       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04058.                                          
       AUTHOR.       COVANSYS.                                          
       DATE-WRITTEN. OCT 2007.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES COLLECTION AGENCY AND CREDIT BUREAU    *        
      *  EXEMPTION HISTORY FOR AN ACCOUNT.                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     Program Modification Log                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  10/26/2007 CVNS      INITIAL VERSION                          *        
      *             CHENNAI                                            *        
      ******************************************************************        
      *                                                                *        
      *                ---- Basic Sequence Structure ----              *        
      *                                                                *        
      *         0000 - 0999     Main Control Path and Initialization   *        
      *         1000 - 1999     Input Processing Control Path          *        
      *         2000 - 2999     Output Processing Control Path         *        
      *         5000 - 5999     Common Modules                         *        
      *         7000 - 7999     Database Access / Input Modules        *        
      *         8000 - 8999     Output Modules                         *        
      *         9000 - 9799     Termination Modules                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04058'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                        PIC X(40)  VALUE              
           'WORKING STORAGE FOR CSR04058 STARTS HERE'.                  
      *                                                                         
      *****************************************************************         
      *   RETURN FIELD AREA                                           *         
      *****************************************************************         
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE            PIC S9(9)  COMP VALUE ZERO.      
           05 S-INDICATOR              PIC X(02)  VALUE  SPACES.        
           05 S-TRANS-DATE             PIC X(10)  VALUE  SPACES.        
           05 S-EXEMPT-CD              PIC X(75)  VALUE  SPACES.        
           05 S-USER-ID                PIC X(07)  VALUE  SPACES.        
           05 S-COMMENTS               PIC X(210) VALUE  SPACES.        
           05 S-TRANS-HIST-SEQ-NO      PIC X(26)  VALUE  SPACES.        
      *                                                                         
       01 TDS-RETURN-FIELDS.                                            
           05 RS-RETURN-CODE           PIC S9(9)  COMP VALUE ZERO.      
           05 RS-INDICATOR             PIC X(02)  VALUE  SPACES.        
           05 RS-TRANS-DATE            PIC X(10)  VALUE  SPACES.        
           05 RS-EXEMPT-CD             PIC X(75)  VALUE  SPACES.        
           05 RS-USER-ID               PIC X(07)  VALUE  SPACES.        
           05 RS-COMMENTS              PIC X(210) VALUE  SPACES.        
           05 RS-TRANS-HIST-SEQ-NO     PIC X(26)  VALUE  SPACES.        
      *                                                                         
       01 WS-MISC.                                                      
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR04058'.      
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.            
                                                                        
           05 WS-ATTR-VAL-TS           PIC X(26).                       
           05 WS-EXEMPT-EXISTS         PIC X(01).                       
           05 WS-TIMESTAMP             PIC X(16) VALUE                  
                                                 '-23.59.59.999999'.    
           05 WS-TRANS-HIST-SEQ-NO     PIC X(26).                       
           05 WS-USER-ID               PIC X(07).                       
           05 WS-COMMENTS              PIC X(210).                      
           05 WS-COLUMN-DESC           PIC X(15).                       
           05 WS-CHG-COLUMN-VALUE      PIC X(75).                       
           05 WS-INDICATOR             PIC X(02).                       
           05 WS-SQLSTATE              PIC X(05) VALUE '     '.         
           05 WS-EXEMPT-TYPE           PIC X(08) VALUE SPACES.          
           05 WS-XMPT-TYPE-HIST-COUNT  PIC S9(04) COMP  VALUE ZEROES.   
                                                                        
       01 SWITCHES.                                                     
           05 SEND-DONE-SW             PIC X(01)  VALUE 'Y'.            
              88 SEND-DONE-ERROR                  VALUE 'N'.            
              88 SEND-DONE-OK                     VALUE 'Y'.            
           05 WS-NO-MORE-DATA-HSTCUR   PIC X(01)  VALUE 'N'.            
              88 NO-MORE-DATA-HSTCUR              VALUE 'Y'.            
           05 WS-NO-MORE-DATA-DETCUR   PIC X(01)  VALUE 'N'.            
              88 NO-MORE-DATA-DETCUR              VALUE 'Y'.            
           05 WS-NO-MORE-DATA-ACTCUR   PIC X(01)  VALUE 'N'.            
              88 NO-MORE-DATA-ACTCUR              VALUE 'Y'.            
           05 WS-FIRST-TIME            PIC X(01)  VALUE 'Y'.            
              88 THIS-IS-FIRST-TIME               VALUE 'Y'.            
              88 THIS-IS-NOT-FST-TIME             VALUE 'N'.            
      *                                                                         
      ******************************************************************        
      * SQL Error Checking Copy Books.                                 *        
      ******************************************************************        
                                                                        
      *01  WS-WARNING-DATA-ELEMENTS.                                            
           COPY CWS00303.                                                       
                                                                        
      *01  CSRERLOG-P.                                                          
           COPY CWSSP001.                                                       
                                                                        
      ******************************************************************        
      * DB2 Includes                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    YP - CSS_ACCT_ATTRIBUTE                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    KC - CSS_FW_ATTRIBUTE                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFWATTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    KV - CSS_FW_ATTRIB_DESC                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBATTDES                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    MH - CSS_MNT_TRANS_HIST                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    MI - CSS_MT_TRN_HST_DET                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Error Handling Copy Book.                                      *        
      ******************************************************************        
      *                                                                         
      *01  ABEND-FILE.                                                          
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * TRN_HST CURSOR.                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE TRN_HST CURSOR FOR                              
                SELECT                                                  
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                             
                      ,MH.USER_ID                                       
                      ,MH.TRAN_COMMENT                                  
                FROM                                                    
                       CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)              
                WHERE                                                   
                       MH.ACCOUNT_NO         = :WS-ACCOUNT-NO-COMP3     
                  AND  MH.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                        :WS-ATTR-VAL-TS
              )          
                  AND  MH.APPL_PROGRAM_ID    = 'PANEL490'               
                ORDER  BY TRANS_HIST_SEQ_NO DESC                     
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE TRN_HST CURSOR FOR                                      
MFA-TR*         SELECT                                                          
MFA-TR*                MH.TRANS_HIST_SEQ_NO                                     
MFA-TR*               ,MH.USER_ID                                               
MFA-TR*               ,MH.TRAN_COMMENT                                          
MFA-TR*         FROM                                                            
MFA-TR*                CSS_MNT_TRANS_HIST MH                                    
MFA-TR*         WHERE                                                           
MFA-TR*                MH.ACCOUNT_NO         = :WS-ACCOUNT-NO-COMP3             
MFA-TR*           AND  MH.TRANS_HIST_SEQ_NO <= :WS-ATTR-VAL-TS                  
MFA-TR*           AND  MH.APPL_PROGRAM_ID    = 'PANEL490'                       
MFA-TR*         ORDER  BY MH.TRANS_HIST_SEQ_NO DESC                             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * TRN_HST_DET CURSOR.                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE TRN_HST_DET CURSOR FOR                          
                SELECT                                                  
                       MI.COLUMN_DESC                                   
                      ,MI.CHG_COLUMN_VALUE                              
                FROM                                                    
                       CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)              
                WHERE                                                   
                       MI.TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )     
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE TRN_HST_DET CURSOR FOR                                  
MFA-TR*         SELECT                                                          
MFA-TR*                MI.COLUMN_DESC                                           
MFA-TR*               ,MI.CHG_COLUMN_VALUE                                      
MFA-TR*         FROM                                                            
MFA-TR*                CSS_MT_TRN_HST_DET MI                                    
MFA-TR*         WHERE                                                           
MFA-TR*                MI.TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  I-ACCOUNT-NO             PIC X(13).                          
      *                                                                         
       PROCEDURE DIVISION USING  I-ACCOUNT-NO.                          
      *                                                                         
      ******************************************************************        
      * Controls the Main Processing of the Program.                   *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           MOVE 'CAEXEMPT'             TO WS-EXEMPT-TYPE.               
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           INITIALIZE WS-XMPT-TYPE-HIST-COUNT.                          
           MOVE 'CBEXEMPT'             TO WS-EXEMPT-TYPE.               
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           IF CTR-ROWS = 0                                              
              PERFORM 5200-EXEMPT-NOTEXISTS THRU 5200-EXIT              
           END-IF                                                       
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Initialize Return Fields, Declare GTT and Result Set Cursor.   *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
      *                                                                         
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 RETURN_CODE                  AS RETURN_CODE            
                ,[INDICATOR]                    AS [INDICATOR]              
                ,TRANS_DATE                   AS TRANS_DATE             
                ,EXEMPT_CD                    AS EXEMPT_CD              
                ,USER_ID                      AS USER_ID                
                ,COMMENTS                     AS COMMENTS               
                ,TRANS_HIST_SEQ_NO            AS TRANS_HIST_SEQ_NO      
              FROM #CSR04058_R1                                  
              ORDER BY TRANS_HIST_SEQ_NO DESC                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE                  AS RETURN_CODE                    
MFA-TR*         ,INDICATOR                    AS INDICATOR                      
MFA-TR*         ,TRANS_DATE                   AS TRANS_DATE                     
MFA-TR*         ,EXEMPT_CD                    AS EXEMPT_CD                      
MFA-TR*         ,USER_ID                      AS USER_ID                        
MFA-TR*         ,COMMENTS                     AS COMMENTS                       
MFA-TR*         ,TRANS_HIST_SEQ_NO            AS TRANS_HIST_SEQ_NO              
MFA-TR*       FROM SESSION.CSR04058_R1                                          
MFA-TR*       ORDER BY TRANS_HIST_SEQ_NO DESC                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *0100A-DECLARE-GTT************************************************        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04058_R1'            
                                                TO S-SQL-STATEMENT-V.   
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04058_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04058_R1
              (                                                       
                   RETURN_CODE           INT                        
                  ,[INDICATOR] CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,TRANS_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,EXEMPT_CD CHAR(75)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,USER_ID CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2             
                  ,COMMENTS CHAR(210)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,TRANS_HIST_SEQ_NO CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '0100A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DECLARE GTT'         TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04058_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU  9900-EXIT                
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE I-ACCOUNT-NO             TO WS-ACCOUNT-NO.              
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE    WS-ACCOUNT-NO-NUM     TO WS-ACCOUNT-NO-COMP3.        
           MOVE    'N'                   TO WS-EXEMPT-EXISTS.           
           MOVE    'N'                   TO WS-NO-MORE-DATA-HSTCUR.     
           PERFORM 7000-CHK-EXEMPT-EXISTS    THRU 7000-EXIT.            
           IF WS-EXEMPT-EXISTS = 'Y'                                    
              STRING  YP-ATTRIBUTE-VALUE-DT, WS-TIMESTAMP DELIMITED BY  
                      SIZE INTO WS-ATTR-VAL-TS                          
                                                                        
              PERFORM 7200-OPEN-TRN-HST      THRU 7200-EXIT             
              PERFORM 7300-FETCH-TRN-HST     THRU 7300-EXIT             
              IF WS-NO-MORE-DATA-HSTCUR = 'Y'                           
                 PERFORM 7400-CLOSE-TRN-HST           THRU 7400-EXIT    
                 PERFORM 5050-PROCESS-ATTR-ATTRIBUTE  THRU 5050-EXIT    
              ELSE                                                      
                 PERFORM 5000-PROCESS-TRN-HST         THRU 5000-EXIT    
                   UNTIL NO-MORE-DATA-HSTCUR                            
                 PERFORM 7400-CLOSE-TRN-HST           THRU 7400-EXIT    
              END-IF                                                    
           END-IF.                                                      
           IF WS-XMPT-TYPE-HIST-COUNT = 0                               
              IF WS-EXEMPT-EXISTS = 'Y'                                 
                 PERFORM 5050-PROCESS-ATTR-ATTRIBUTE  THRU 5050-EXIT    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Prepares Result Set Row.                                       *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
           MOVE RS-INDICATOR              TO S-INDICATOR.               
           MOVE RS-TRANS-DATE             TO S-TRANS-DATE.              
           MOVE RS-EXEMPT-CD              TO S-EXEMPT-CD.               
           MOVE RS-USER-ID                TO S-USER-ID.                 
           MOVE RS-COMMENTS               TO S-COMMENTS.                
           MOVE RS-TRANS-HIST-SEQ-NO      TO S-TRANS-HIST-SEQ-NO.       
           ADD  +1                        TO WS-XMPT-TYPE-HIST-COUNT.   
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5000-PROCESS-TRN-HST.                                          *        
      ******************************************************************        
       5000-PROCESS-TRN-HST.                                            
           PERFORM 7500-OPEN-TRN-HST-DET  THRU 7500-EXIT.               
           PERFORM 7600-FETCH-TRN-HST-DET THRU 7600-EXIT.               
           PERFORM 5100-PROCESS-TRN-HST-DET                             
                                          THRU 5100-EXIT                
                                          UNTIL NO-MORE-DATA-DETCUR.    
           PERFORM 7700-CLOSE-TRN-HST-DET THRU 7700-EXIT.               
           PERFORM 7300-FETCH-TRN-HST     THRU 7300-EXIT.               
           MOVE    'N'                    TO WS-NO-MORE-DATA-DETCUR.    
      *                                                                         
       5000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5050-PROCESS-ATTR-ATTRIBUTE                                    *        
      ******************************************************************        
       5050-PROCESS-ATTR-ATTRIBUTE.                                     
           IF YP-ATTRIBUTE-VALUE-CD > SPACES                            
              MOVE SPACES                 TO KV-FW-ATTRIB-TYPE-CD       
              MOVE SPACES                 TO KV-FW-ATTR-VALUE-CD        
              MOVE SPACES                 TO KV-FW-ATTR-VALUE-DESC      
      *                                                                         
              IF YP-ATTRIBUTE-DESC  = 'CAEXEMPT'                        
                 MOVE 'CA'                TO RS-INDICATOR               
                                             KV-FW-ATTRIB-TYPE-CD       
              ELSE                                                      
                 MOVE 'CB'                TO RS-INDICATOR               
                                             KV-FW-ATTRIB-TYPE-CD       
              END-IF                                                    
              MOVE YP-ATTRIBUTE-VALUE-DT  TO RS-TRANS-DATE              
      *                                                                         
              MOVE YP-ATTRIBUTE-VALUE-CD       TO KV-FW-ATTR-VALUE-CD   
              PERFORM 7150-GET-ATTR-VAL-DESC   THRU 7150-EXIT           
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE KV-FW-ATTR-VALUE-DESC    TO RS-EXEMPT-CD          
              ELSE                                                      
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE KV-FW-ATTR-VALUE-CD   TO RS-EXEMPT-CD          
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              MOVE SPACES                 TO RS-USER-ID                 
              MOVE SPACES                 TO RS-COMMENTS                
              MOVE 0                      TO RS-RETURN-CODE             
              MOVE SPACES                 TO RS-TRANS-HIST-SEQ-NO       
              PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                
           END-IF.                                                      
      *                                                                         
       5050-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5100-PROCESS-TRN-HST-DET.                                      *        
      ******************************************************************        
       5100-PROCESS-TRN-HST-DET.                                        
      *                                                                         
           INITIALIZE WS-COMMENTS.                                      
           INITIALIZE WS-CHG-COLUMN-VALUE.                              
           MOVE MH-TRANS-HIST-SEQ-NO      TO WS-TRANS-HIST-SEQ-NO.      
           MOVE MH-USER-ID                TO WS-USER-ID.                
           MOVE MH-TRAN-COMMENT-TEXT (1:MH-TRAN-COMMENT-LEN)            
                                          TO WS-COMMENTS.               
           MOVE MI-COLUMN-DESC            TO WS-COLUMN-DESC.            
           MOVE MI-CHG-COLUMN-VALUE-TEXT (1:MI-CHG-COLUMN-VALUE-LEN)    
                                          TO WS-CHG-COLUMN-VALUE.       
      *                                                                         
           IF WS-COLUMN-DESC = WS-EXEMPT-TYPE                           
              IF WS-COLUMN-DESC = 'CAEXEMPT'                            
                 MOVE 'CA'                TO RS-INDICATOR               
                                             WS-INDICATOR               
              ELSE                                                      
                 MOVE 'CB'                TO RS-INDICATOR               
                                             WS-INDICATOR               
              END-IF                                                    
              MOVE WS-TRANS-HIST-SEQ-NO(1:10)                           
                                          TO RS-TRANS-DATE              
      *                                                                         
              IF WS-CHG-COLUMN-VALUE = '**DELETED**'                    
                 MOVE SPACES              TO WS-CHG-COLUMN-VALUE        
              END-IF                                                    
      *                                                                         
              MOVE WS-CHG-COLUMN-VALUE    TO RS-EXEMPT-CD               
              MOVE WS-USER-ID             TO RS-USER-ID                 
              MOVE WS-COMMENTS            TO RS-COMMENTS                
              MOVE 0                      TO RS-RETURN-CODE             
              MOVE WS-TRANS-HIST-SEQ-NO   TO RS-TRANS-HIST-SEQ-NO       
              PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                
           END-IF.                                                      
           PERFORM 7600-FETCH-TRN-HST-DET THRU 7600-EXIT.               
                                                                        
      *                                                                         
       5100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5200-EXEMPT-NOTEXISTS.                                         *        
      ******************************************************************        
       5200-EXEMPT-NOTEXISTS.                                           
            MOVE 100                      TO RS-RETURN-CODE             
            MOVE SPACES                   TO RS-INDICATOR               
                                             RS-TRANS-DATE              
                                             RS-EXEMPT-CD               
                                             RS-USER-ID                 
                                             RS-COMMENTS                
                                             RS-TRANS-HIST-SEQ-NO.      
            PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.              
            PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.               
      *                                                                         
       5200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7000-CHK-EXEMPT-EXISTS.                                        *        
      ******************************************************************        
      *                                                                         
       7000-CHK-EXEMPT-EXISTS.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                      'Y'                                               
                     ,ATTRIBUTE_DESC                                    
                     ,ATTRIBUTE_VALUE_CD                                
                     ,ATTRIBUTE_VALUE_DT                                
              INTO                                                      
                      :WS-EXEMPT-EXISTS                                 
                     ,:YP-ATTRIBUTE-DESC                                
                     ,:YP-ATTRIBUTE-VALUE-CD                            
                     ,:YP-ATTRIBUTE-VALUE-DT                            
              FROM                                                      
                     CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
              WHERE                                                     
                     ACCOUNT_NO      = :WS-ACCOUNT-NO-COMP3             
                AND  ATTRIBUTE_DESC  = :WS-EXEMPT-TYPE                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*               'Y'                                                       
MFA-TR*              ,ATTRIBUTE_DESC                                            
MFA-TR*              ,ATTRIBUTE_VALUE_CD                                        
MFA-TR*              ,ATTRIBUTE_VALUE_DT                                        
MFA-TR*       INTO                                                              
MFA-TR*               :WS-EXEMPT-EXISTS                                         
MFA-TR*              ,:YP-ATTRIBUTE-DESC                                        
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-DT                                    
MFA-TR*       FROM                                                              
MFA-TR*              CSS_ACCT_ATTRIBUTE                                         
MFA-TR*       WHERE                                                             
MFA-TR*              ACCOUNT_NO      = :WS-ACCOUNT-NO-COMP3                     
MFA-TR*         AND  ATTRIBUTE_DESC  = :WS-EXEMPT-TYPE                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE      = SUCCESSFUL-CALL OR           
                                           NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO-COMP3   TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7150-GET-ATTR-VAL-DESC                                         *        
      ******************************************************************        
       7150-GET-ATTR-VAL-DESC.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT FW_ATTR_VALUE_DESC                                
               INTO   :KV-FW-ATTR-VALUE-DESC                            
               FROM   CSS_FW_ATTRIB_DESC                                
               WHERE  FW_ATTRIB_TYPE_CD = :KV-FW-ATTRIB-TYPE-CD         
               AND    FW_ATTR_VALUE_CD  = :KV-FW-ATTR-VALUE-CD          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '7150'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_FW_ATTRIB_DESC' TO TABLE-1                      
              MOVE 'FW_ATTR_VALUE_DESC' TO TABLE-ELEMENT-1              
              MOVE KV-FW-ATTRIB-TYPE-CD TO HOSTVAR-ELEMENT-1            
              MOVE KV-FW-ATTR-VALUE-CD  TO HOSTVAR-ELEMENT-2            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7200-OPEN-TRN-HST.                                             *        
      ******************************************************************        
      *                                                                         
       7200-OPEN-TRN-HST.                                               
      *                                                                         
           EXEC SQL                                                     
                OPEN TRN_HST                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
                                              RS-RETURN-CODE            
              MOVE SQLSTATE                TO ABEND-SQLSTATE            
              MOVE '7200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE 'CSS_MNT_TRANS_HIST'    TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'TRANS_HIST_SEQ_NO'     TO TABLE-ELEMENT-2           
              MOVE 'APPL_PROGRAM_ID'       TO TABLE-ELEMENT-3           
              MOVE WS-ACCOUNT-NO-COMP3     TO HOSTVAR-ELEMENT-1         
              MOVE WS-ATTR-VAL-TS          TO HOSTVAR-ELEMENT-2         
              MOVE 'PANEL490'              TO HOSTVAR-ELEMENT-3         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7300-FETCH-TRN-HST.                                            *        
      ******************************************************************        
      *                                                                         
       7300-FETCH-TRN-HST.                                              
      *                                                                         
           EXEC SQL                                                     
                FETCH TRN_HST                                           
                INTO  :MH-TRANS-HIST-SEQ-NO                             
                     ,:MH-USER-ID                                       
                     ,:MH-TRAN-COMMENT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN NOT-FOUND                                             
               MOVE 'Y'                    TO WS-NO-MORE-DATA-HSTCUR    
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE SQLCODE                TO ABEND-SQLCODE             
                                              RS-RETURN-CODE            
               MOVE SQLSTATE               TO ABEND-SQLSTATE            
               MOVE '7300'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_MNT_TRANS_HIST'   TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE 'TRANS_HIST_SEQ_NO'    TO TABLE-ELEMENT-2           
               MOVE 'APPL_PROGRAM_ID'      TO TABLE-ELEMENT-3           
               MOVE WS-ACCOUNT-NO-COMP3    TO HOSTVAR-ELEMENT-1         
               MOVE WS-ATTR-VAL-TS         TO HOSTVAR-ELEMENT-2         
               MOVE 'PANEL490'             TO HOSTVAR-ELEMENT-3         
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
           END-EVALUATE.                                                
      *                                                                         
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7400-CLOSE-TRN-HST.                                            *        
      ******************************************************************        
      *                                                                         
       7400-CLOSE-TRN-HST.                                              
      *                                                                         
           EXEC SQL                                                     
                CLOSE TRN_HST                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE SQLCODE                TO ABEND-SQLCODE              
                                             RS-RETURN-CODE             
              MOVE SQLSTATE               TO ABEND-SQLSTATE             
              MOVE '7400'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'CSS_MNT_TRANS_HIST'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'TRANS_HIST_SEQ_NO'    TO TABLE-ELEMENT-2            
              MOVE 'APPL_PROGRAM_ID'      TO TABLE-ELEMENT-3            
              MOVE WS-ACCOUNT-NO-COMP3    TO HOSTVAR-ELEMENT-1          
              MOVE WS-ATTR-VAL-TS         TO HOSTVAR-ELEMENT-2          
              MOVE 'PANEL490'             TO HOSTVAR-ELEMENT-3          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7500-OPEN-TRN-HST-DET.                                         *        
      ******************************************************************        
      *                                                                         
       7500-OPEN-TRN-HST-DET.                                           
      *                                                                         
           EXEC SQL                                                     
                OPEN TRN_HST_DET                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
                                              RS-RETURN-CODE            
              MOVE SQLSTATE                TO ABEND-SQLSTATE            
              MOVE '7200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE 'CSS_MT_TRN_HST_DET'    TO TABLE-1                   
              MOVE 'TRANS_HIST_SEQ_NO'     TO TABLE-ELEMENT-1           
              MOVE MH-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7600-FETCH-TRN-HST-DET.                                        *        
      ******************************************************************        
      *                                                                         
       7600-FETCH-TRN-HST-DET.                                          
      *                                                                         
           EXEC SQL                                                     
                FETCH TRN_HST_DET                                       
                INTO  :MI-COLUMN-DESC                                   
                     ,:MI-CHG-COLUMN-VALUE                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               CONTINUE                                                 
             WHEN NOT-FOUND                                             
               MOVE 'Y'                    TO WS-NO-MORE-DATA-DETCUR    
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE SQLCODE                TO ABEND-SQLCODE             
                                              RS-RETURN-CODE            
               MOVE SQLSTATE               TO ABEND-SQLSTATE            
               MOVE '7300'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_MT_TRN_HST_DET'   TO TABLE-1                   
               MOVE 'TRANS_HIST_SEQ_NO'    TO TABLE-ELEMENT-1           
               MOVE MH-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
           END-EVALUATE.                                                
      *                                                                         
       7600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7700-CLOSE-TRN-HST-DET.                                        *        
      ******************************************************************        
      *                                                                         
       7700-CLOSE-TRN-HST-DET.                                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE TRN_HST_DET                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE SQLCODE                TO ABEND-SQLCODE              
                                             RS-RETURN-CODE             
              MOVE SQLSTATE               TO ABEND-SQLSTATE             
              MOVE '7700'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'CSS_MT_TRN_HST_DET'   TO TABLE-1                    
              MOVE 'TRANS_HIST_SEQ_NO'    TO TABLE-ELEMENT-1            
              MOVE MH-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * INSERT RESULTSET.                                              *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
           EXEC SQL                                                     
                INSERT INTO #CSR04058_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,[INDICATOR]                                          
                    ,TRANS_DATE                                         
                    ,EXEMPT_CD                                          
                    ,USER_ID                                            
                    ,COMMENTS                                           
                    ,TRANS_HIST_SEQ_NO                                  
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE                                     
                    ,:S-INDICATOR                                       
                    ,:S-TRANS-DATE                                      
                    ,:S-EXEMPT-CD                                       
                    ,:S-USER-ID                                         
                    ,:S-COMMENTS                                        
                    ,:S-TRANS-HIST-SEQ-NO                               
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04058_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,INDICATOR                                                  
MFA-TR*             ,TRANS_DATE                                                 
MFA-TR*             ,EXEMPT_CD                                                  
MFA-TR*             ,USER_ID                                                    
MFA-TR*             ,COMMENTS                                                   
MFA-TR*             ,TRANS_HIST_SEQ_NO                                          
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-INDICATOR                                               
MFA-TR*             ,:S-TRANS-DATE                                              
MFA-TR*             ,:S-EXEMPT-CD                                               
MFA-TR*             ,:S-USER-ID                                                 
MFA-TR*             ,:S-COMMENTS                                                
MFA-TR*             ,:S-TRANS-HIST-SEQ-NO                                       
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                      TO  CTR-ROWS                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO  ABEND-PROGRAM             
              MOVE '8100'                 TO  ACTIVE-PARAGRAPH          
              MOVE 'INSERT'               TO  ABEND-FUNCTION            
              MOVE SQLCODE                TO  ABEND-SQLCODE             
              MOVE SPACES                 TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSR04058_R1'          TO  TABLE-1                   
              MOVE SPACES                 TO  TABLE-ELEMENT-1           
              MOVE SPACES                 TO  HOSTVAR-ELEMENT-1         
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                       Program Copy Books                       *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9700-PROCESS-ABEND                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023C                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                  SQL Error Processing Copy Book                *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
