       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04055.                                          
COB303 DATE-WRITTEN.      JANUARY 15, 2008.                             
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ACCOUNT INFORMATION FOR THE WEB        *        
      *  STOP/START/TRANSFER PROCESS.                                  *        
      *  STATUS CODE VALUES ARE:                                       *        
      *       100     PREMISE DOES NOT EXIST                           *        
      *       150     MULTIPLE PREMISES EXIST                          *        
      *       200     RATE 5 / MULTIPLE REGISTER METERS EXIST          *        
      *       300     APPLIANCES CAUTION TAG / IMPROPER CONDITION      *        
      *       400     INVALID METER STATUS                             *        
      *       500     INVALID METER STATUS REASON                      *        
      *       600     DNPFB ORDER EXISTS                               *        
      *       700     METERED ORDER EXISTS                             *        
      *       800     ACCOUNT NOT RESIDENTIAL                          *        
      *       900     MULTIPLE METERS WITHIN UTILITY TYPE              *        
      *       950     INACTIVE CC/REVERT OR OFF ORDER                  *        
      *       960     SCHEDULED DATE PRIOR TO TODAY                    *        
      *       970     BOLT-IN OR 3-PHASE METER AT PREMISE              *        
      *       975     RED FLAG COMMUNICATION                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/15/08    FMB      NEW PROGRAM.                                      
P00253*  12/21/09    FMB      ADDED DETECTENT ORDER TYPE FW016.                 
A03264*  05/26/11    FMB      ADDED BOLT-IN AND 3-PHASE METERS.                 
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04055'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04055 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSTRSFX                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRGREAD                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
A03264     EXEC SQL                                                             
A03264        INCLUDE TBELMTR                                                   
A03264     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04055_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-PREMISE-NO           PIC X(10) VALUE SPACES.          
           05  RS-ACCOUNT-NO           PIC X(13) VALUE SPACES.          
           05  RS-NAME-CHECK-FL        PIC X(01) VALUE SPACES.          
           05  RS-ELEC-METER-NO        PIC X(09) VALUE SPACES.          
           05  RS-GAS-METER-NO         PIC X(09) VALUE SPACES.          
           05  RS-LAST-NAME            PIC X(40) VALUE SPACES.          
           05  RS-ELEC-FL              PIC X(01) VALUE SPACES.          
           05  RS-GAS-FL               PIC X(01) VALUE SPACES.          
           05  RS-SUBD-LITE-FL         PIC X(01) VALUE SPACES.          
           05  RS-LITE-FL              PIC X(01) VALUE SPACES.          
           05  RS-COMPANY-NO           PIC X(02) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-PREMISE-NO           PIC X(10) VALUE SPACES.           
           05  S-ACCOUNT-NO           PIC X(13) VALUE SPACES.           
           05  S-NAME-CHECK-FL        PIC X(01) VALUE SPACES.           
           05  S-ELEC-METER-NO        PIC X(09) VALUE SPACES.           
           05  S-GAS-METER-NO         PIC X(09) VALUE SPACES.           
           05  S-LAST-NAME            PIC X(40) VALUE SPACES.           
           05  S-ELEC-FL              PIC X(01) VALUE SPACES.           
           05  S-GAS-FL               PIC X(01) VALUE SPACES.           
           05  S-SUBD-LITE-FL         PIC X(01) VALUE SPACES.           
           05  S-LITE-FL              PIC X(01) VALUE SPACES.           
           05  S-COMPANY-NO           PIC X(02) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-NUM        PIC 9(10).                      
           05  WS-PREMISE-NO-RED        REDEFINES WS-PREMISE-NO-NUM     
                                        PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       PIC 9(10).                      
           05  WS-CUSTOMER-NO-CHAR      REDEFINES WS-CUSTOMER-NO-NUM    
                                        PIC X(10).                      
           05  WS-ACCOUNT-NO-NUM        PIC 9(13).                      
           05  WS-ACCOUNT-NO-RED        REDEFINES WS-ACCOUNT-NO-NUM     
                                        PIC X(13).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04055'.     
           05  WS-COUNT-PREMISES-1      PIC S9(4) COMP VALUE 0.         
           05  WS-COUNT-PREMISES-2      PIC S9(4) COMP VALUE 0.         
           05  WS-TOTAL-PREMISES        PIC S9(4) COMP VALUE 0.         
           05  WS-COUNT-GAS-METERS      PIC S9(4) COMP VALUE 0.         
           05  WS-COUNT-ELEC-METERS     PIC S9(4) COMP VALUE 0.         
           05  WS-ACTIVE-ACCOUNT        PIC X(01) VALUE 'N'.            
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
               DECLARE PREMISE_CURSOR CURSOR FOR                        
                   SELECT DISTINCT(PR.PREMISE_NO)                       
                     FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                 
                          CSS_ACCOUNT AT WITH(READUNCOMMITTED),                 
                          CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),          
                          CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)           
                    WHERE DY.ZIP_CODE = :DY-ZIP-CODE                    
                      AND DY.ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1          
                      AND DY.ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2          
                      AND DY.STREET_NAME = :DY-STREET-NAME              
                      AND DY.STREET_SUFFIX = :S9-STREET-SUFFIX          
                      AND DY.ADDR_SUFFIX = :DY-ADDR-SUFFIX              
                      AND DY.HOUSE_NO = :DY-HOUSE-NO                    
                      AND DY.STREET_LOCATION_1 = :DY-STREET-LOCATION-1  
                      AND DY.STREET_LOCATION_2 = :DY-STREET-LOCATION-2  
                      AND DY.ADDRESS_ID = PR.ADDRESS_ID                 
                      AND PR.PREMISE_NO = AT.PREMISE_NO                 
                      AND AT.CODE_ACCT_STAT IN ('A', 'S', 'B')          
                      AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                 
                      AND UT.CODE_REVENUE_CLASS <> '021'                
                      AND EXISTS                                        
                          (SELECT 'Y' FROM CSS_MTRD_ENVRNMT MT2
                           WITH(READUNCOMMITTED)         
                            WHERE UT.ACCOUNT_NO = MT2.ACCOUNT_NO        
                              AND MT2.CODE_UTIL_TYPE IN ('E', 'G'))     
                   UNION ALL                                            
                   SELECT DISTINCT(PR.PREMISE_NO)                       
                     FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                 
                          CSS_ACCOUNT AT WITH(READUNCOMMITTED),                 
                          CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),          
                          CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                
                    WHERE DY.ZIP_CODE = :DY-ZIP-CODE                    
                      AND DY.ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1          
                      AND DY.ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2          
                      AND DY.STREET_NAME = :DY-STREET-NAME              
                      AND DY.STREET_SUFFIX = :S9-STREET-SUFFIX          
                      AND DY.ADDR_SUFFIX = :DY-ADDR-SUFFIX              
                      AND DY.HOUSE_NO = :DY-HOUSE-NO                    
                      AND DY.STREET_LOCATION_1 = :DY-STREET-LOCATION-1  
                      AND DY.STREET_LOCATION_2 = :DY-STREET-LOCATION-2  
                      AND DY.ADDRESS_ID = PR.ADDRESS_ID                 
                      AND PR.PREMISE_NO = AT.PREMISE_NO                 
                      AND AT.CODE_ACCT_STAT IN ('A', 'S', 'B')          
                      AND AT.ACCOUNT_NO = CP.ACCOUNT_NO                 
                      AND CP.CODE_PLAN_STATUS IN                        
                          ('A', 'I', 'B', 'D', 'M')                     
                      AND NOT EXISTS                                    
                          (SELECT 'Y' FROM CSS_MTRD_ENVRNMT MT2
                           WITH(READUNCOMMITTED)         
                            WHERE AT.ACCOUNT_NO = MT2.ACCOUNT_NO        
                              AND MT2.CODE_UTIL_TYPE IN ('E', 'G'))     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PREMISE_CURSOR CURSOR FOR                                
MFA-TR*            SELECT DISTINCT(PR.PREMISE_NO)                               
MFA-TR*              FROM CSS_PREMISE PR,                                       
MFA-TR*                   CSS_ACCOUNT AT,                                       
MFA-TR*                   CSS_ADDR_FORMATTED DY,                                
MFA-TR*                   CSS_UTIL_ENVRNMT   UT                                 
MFA-TR*             WHERE DY.ZIP_CODE = :DY-ZIP-CODE                            
MFA-TR*               AND DY.ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1                  
MFA-TR*               AND DY.ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2                  
MFA-TR*               AND DY.STREET_NAME = :DY-STREET-NAME                      
MFA-TR*               AND DY.STREET_SUFFIX = :S9-STREET-SUFFIX                  
MFA-TR*               AND DY.ADDR_SUFFIX = :DY-ADDR-SUFFIX                      
MFA-TR*               AND DY.HOUSE_NO = :DY-HOUSE-NO                            
MFA-TR*               AND DY.STREET_LOCATION_1 = :DY-STREET-LOCATION-1          
MFA-TR*               AND DY.STREET_LOCATION_2 = :DY-STREET-LOCATION-2          
MFA-TR*               AND DY.ADDRESS_ID = PR.ADDRESS_ID                         
MFA-TR*               AND PR.PREMISE_NO = AT.PREMISE_NO                         
MFA-TR*               AND AT.CODE_ACCT_STAT IN ('A', 'S', 'B')                  
MFA-TR*               AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                         
MFA-TR*               AND UT.CODE_REVENUE_CLASS <> '021'                        
MFA-TR*               AND EXISTS                                                
MFA-TR*                   (SELECT 'Y' FROM CSS_MTRD_ENVRNMT MT2                 
MFA-TR*                     WHERE UT.ACCOUNT_NO = MT2.ACCOUNT_NO                
MFA-TR*                       AND MT2.CODE_UTIL_TYPE IN ('E', 'G'))             
MFA-TR*            UNION ALL                                                    
MFA-TR*            SELECT DISTINCT(PR.PREMISE_NO)                               
MFA-TR*              FROM CSS_PREMISE PR,                                       
MFA-TR*                   CSS_ACCOUNT AT,                                       
MFA-TR*                   CSS_ADDR_FORMATTED DY,                                
MFA-TR*                   CSS_CUST_PLAN CP                                      
MFA-TR*             WHERE DY.ZIP_CODE = :DY-ZIP-CODE                            
MFA-TR*               AND DY.ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1                  
MFA-TR*               AND DY.ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2                  
MFA-TR*               AND DY.STREET_NAME = :DY-STREET-NAME                      
MFA-TR*               AND DY.STREET_SUFFIX = :S9-STREET-SUFFIX                  
MFA-TR*               AND DY.ADDR_SUFFIX = :DY-ADDR-SUFFIX                      
MFA-TR*               AND DY.HOUSE_NO = :DY-HOUSE-NO                            
MFA-TR*               AND DY.STREET_LOCATION_1 = :DY-STREET-LOCATION-1          
MFA-TR*               AND DY.STREET_LOCATION_2 = :DY-STREET-LOCATION-2          
MFA-TR*               AND DY.ADDRESS_ID = PR.ADDRESS_ID                         
MFA-TR*               AND PR.PREMISE_NO = AT.PREMISE_NO                         
MFA-TR*               AND AT.CODE_ACCT_STAT IN ('A', 'S', 'B')                  
MFA-TR*               AND AT.ACCOUNT_NO = CP.ACCOUNT_NO                         
MFA-TR*               AND CP.CODE_PLAN_STATUS IN                                
MFA-TR*                   ('A', 'I', 'B', 'D', 'M')                             
MFA-TR*               AND NOT EXISTS                                            
MFA-TR*                   (SELECT 'Y' FROM CSS_MTRD_ENVRNMT MT2                 
MFA-TR*                     WHERE AT.ACCOUNT_NO = MT2.ACCOUNT_NO                
MFA-TR*                       AND MT2.CODE_UTIL_TYPE IN ('E', 'G'))             
MFA-TR*               WITH UR                                                   
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ZIP-CODE           PIC X(05).                           
       01  LINK-HOUSE-NO           PIC X(15).                           
       01  LINK-ADDR-PREFIX-1      PIC X(03).                           
       01  LINK-ADDR-PREFIX-2      PIC X(02).                           
       01  LINK-STREET-NAME        PIC X(30).                           
       01  LINK-STREET-SUFFIX-DESC PIC X(15).                           
       01  LINK-ADDR-SUFFIX        PIC X(02).                           
       01  LINK-STREET-LOC-1       PIC X(04).                           
       01  LINK-STREET-LOC-2       PIC X(11).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ZIP-CODE                                 
                          LINK-HOUSE-NO                                 
                          LINK-ADDR-PREFIX-1                            
                          LINK-ADDR-PREFIX-2                            
                          LINK-STREET-NAME                              
                          LINK-STREET-SUFFIX-DESC                       
                          LINK-ADDR-SUFFIX                              
                          LINK-STREET-LOC-1                             
                          LINK-STREET-LOC-2.                            
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE       AS RETURN_CODE,              
                      :S-STATUS-CODE       AS STATUS_CODE,              
                      :S-PREMISE-NO        AS PREMISE_NO,               
                      :S-ACCOUNT-NO        AS ACCOUNT_NO,               
                      :S-NAME-CHECK-FL     AS NAME_CHECK_FL,            
                      :S-ELEC-METER-NO     AS ELEC_METER_NO,            
                      :S-GAS-METER-NO      AS GAS_METER_NO,             
                      :S-LAST-NAME         AS LAST_NAME,                
                      :S-ELEC-FL           AS ELEC_FL,                  
                      :S-GAS-FL            AS GAS_FL,                   
                      :S-SUBD-LITE-FL      AS SUB_LITE_FL,              
                      :S-LITE-FL           AS LITE_FL,                  
                      :S-COMPANY-NO        AS COMPANY_NO                
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE       AS RETURN_CODE,                      
MFA-TR*               :S-STATUS-CODE       AS STATUS_CODE,                      
MFA-TR*               :S-PREMISE-NO        AS PREMISE_NO,                       
MFA-TR*               :S-ACCOUNT-NO        AS ACCOUNT_NO,                       
MFA-TR*               :S-NAME-CHECK-FL     AS NAME_CHECK_FL,                    
MFA-TR*               :S-ELEC-METER-NO     AS ELEC_METER_NO,                    
MFA-TR*               :S-GAS-METER-NO      AS GAS_METER_NO,                     
MFA-TR*               :S-LAST-NAME         AS LAST_NAME,                        
MFA-TR*               :S-ELEC-FL           AS ELEC_FL,                          
MFA-TR*               :S-GAS-FL            AS GAS_FL,                           
MFA-TR*               :S-SUBD-LITE-FL      AS SUB_LITE_FL,                      
MFA-TR*               :S-LITE-FL           AS LITE_FL,                          
MFA-TR*               :S-COMPANY-NO        AS COMPANY_NO                        
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-ZIP-CODE              TO DY-ZIP-CODE.              
           MOVE LINK-ADDR-PREFIX-1         TO DY-ADDR-PREFIX-1.         
           MOVE LINK-ADDR-PREFIX-2         TO DY-ADDR-PREFIX-2.         
           MOVE LINK-STREET-NAME           TO DY-STREET-NAME.           
           MOVE LINK-STREET-SUFFIX-DESC    TO S9-STREET-SUFFIX-DESC.    
           MOVE LINK-ADDR-SUFFIX           TO DY-ADDR-SUFFIX.           
           MOVE LINK-HOUSE-NO              TO DY-HOUSE-NO.              
           MOVE LINK-STREET-LOC-1          TO DY-STREET-LOCATION-1.     
           MOVE LINK-STREET-LOC-2          TO DY-STREET-LOCATION-2.     
                                                                        
           PERFORM 7000-SELECT-SUFFIX THRU 7000-EXIT.                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-COUNT-PREMISES THRU 2100-EXIT.                  
                                                                        
           MOVE 0 TO RS-STATUS-CODE.                                    
           COMPUTE WS-TOTAL-PREMISES =                                  
                   WS-COUNT-PREMISES-1 +                                
                   WS-COUNT-PREMISES-2.                                 
           EVALUATE WS-TOTAL-PREMISES                                   
               WHEN 0                                                   
                   MOVE +100 TO RS-STATUS-CODE                          
               WHEN 1                                                   
                   PERFORM 7010-OPEN-CURSOR THRU 7010-EXIT              
                   PERFORM 7020-FETCH-CURSOR THRU 7020-EXIT             
                   IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                       PERFORM 3000-PREMISE-FILTER THRU 3000-EXIT       
                   ELSE                                                 
                       MOVE +100 TO RS-STATUS-CODE                      
                   END-IF                                               
                   PERFORM 7030-CLOSE-CURSOR THRU 7030-EXIT             
               WHEN OTHER                                               
                   MOVE +150 TO RS-STATUS-CODE                          
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
             MOVE RS-RETURN-CODE      TO S-RETURN-CODE.                 
             MOVE RS-STATUS-CODE      TO S-STATUS-CODE.                 
             MOVE RS-PREMISE-NO       TO S-PREMISE-NO .                 
             MOVE RS-ACCOUNT-NO       TO S-ACCOUNT-NO .                 
             MOVE RS-NAME-CHECK-FL    TO S-NAME-CHECK-FL.               
             MOVE RS-ELEC-METER-NO    TO S-ELEC-METER-NO.               
             MOVE RS-GAS-METER-NO     TO S-GAS-METER-NO.                
             MOVE RS-LAST-NAME        TO S-LAST-NAME.                   
             MOVE RS-ELEC-FL          TO S-ELEC-FL.                     
             MOVE RS-GAS-FL           TO S-GAS-FL                       
             MOVE RS-SUBD-LITE-FL     TO S-SUBD-LITE-FL.                
             MOVE RS-LITE-FL          TO S-LITE-FL.                     
             MOVE RS-COMPANY-NO       TO S-COMPANY-NO.                  
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
       2100-COUNT-PREMISES.                                             
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(DISTINCT PR.PREMISE_NO)                     
                 INTO :WS-COUNT-PREMISES-1                              
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_UTIL_ENVRNMT       UT WITH(READUNCOMMITTED)           
                WHERE DY.ZIP_CODE = :DY-ZIP-CODE                        
                  AND DY.ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1              
                  AND DY.ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2              
                  AND DY.STREET_NAME = :DY-STREET-NAME                  
                  AND DY.STREET_SUFFIX = :S9-STREET-SUFFIX              
                  AND DY.ADDR_SUFFIX = :DY-ADDR-SUFFIX                  
                  AND DY.HOUSE_NO = :DY-HOUSE-NO                        
                  AND DY.STREET_LOCATION_1 = :DY-STREET-LOCATION-1      
                  AND DY.STREET_LOCATION_2 = :DY-STREET-LOCATION-2      
                  AND DY.ADDRESS_ID = PR.ADDRESS_ID                     
                  AND PR.PREMISE_NO = AT.PREMISE_NO                     
                  AND AT.CODE_ACCT_STAT IN ('A', 'S', 'B')              
                  AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND UT.CODE_REVENUE_CLASS <> '021'                    
                  AND EXISTS                                            
                      (SELECT 'Y' FROM CSS_MTRD_ENVRNMT MT2
                           WITH(READUNCOMMITTED)             
                        WHERE UT.ACCOUNT_NO = MT2.ACCOUNT_NO            
                          AND MT2.CODE_UTIL_TYPE IN ('E', 'G'))         
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(DISTINCT PR.PREMISE_NO)                             
MFA-TR*          INTO :WS-COUNT-PREMISES-1                                      
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_UTIL_ENVRNMT       UT                                 
MFA-TR*         WHERE DY.ZIP_CODE = :DY-ZIP-CODE                                
MFA-TR*           AND DY.ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1                      
MFA-TR*           AND DY.ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2                      
MFA-TR*           AND DY.STREET_NAME = :DY-STREET-NAME                          
MFA-TR*           AND DY.STREET_SUFFIX = :S9-STREET-SUFFIX                      
MFA-TR*           AND DY.ADDR_SUFFIX = :DY-ADDR-SUFFIX                          
MFA-TR*           AND DY.HOUSE_NO = :DY-HOUSE-NO                                
MFA-TR*           AND DY.STREET_LOCATION_1 = :DY-STREET-LOCATION-1              
MFA-TR*           AND DY.STREET_LOCATION_2 = :DY-STREET-LOCATION-2              
MFA-TR*           AND DY.ADDRESS_ID = PR.ADDRESS_ID                             
MFA-TR*           AND PR.PREMISE_NO = AT.PREMISE_NO                             
MFA-TR*           AND AT.CODE_ACCT_STAT IN ('A', 'S', 'B')                      
MFA-TR*           AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND UT.CODE_REVENUE_CLASS <> '021'                            
MFA-TR*           AND EXISTS                                                    
MFA-TR*               (SELECT 'Y' FROM CSS_MTRD_ENVRNMT MT2                     
MFA-TR*                 WHERE UT.ACCOUNT_NO = MT2.ACCOUNT_NO                    
MFA-TR*                   AND MT2.CODE_UTIL_TYPE IN ('E', 'G'))                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 21001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT1'             TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'ZIP_CODE'            TO TABLE-ELEMENT-1             
              MOVE 'STREET_NAME'         TO TABLE-ELEMENT-2             
              MOVE 'HOUSE_NO'            TO TABLE-ELEMENT-3             
              MOVE DY-ZIP-CODE           TO HOSTVAR-ELEMENT-1           
              MOVE DY-STREET-NAME        TO HOSTVAR-ELEMENT-2           
              MOVE DY-HOUSE-NO           TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(DISTINCT PR.PREMISE_NO)                     
                 INTO :WS-COUNT-PREMISES-2                              
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                    
                WHERE DY.ZIP_CODE = :DY-ZIP-CODE                        
                  AND DY.ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1              
                  AND DY.ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2              
                  AND DY.STREET_NAME = :DY-STREET-NAME                  
                  AND DY.STREET_SUFFIX = :S9-STREET-SUFFIX              
                  AND DY.ADDR_SUFFIX = :DY-ADDR-SUFFIX                  
                  AND DY.HOUSE_NO = :DY-HOUSE-NO                        
                  AND DY.STREET_LOCATION_1 = :DY-STREET-LOCATION-1      
                  AND DY.STREET_LOCATION_2 = :DY-STREET-LOCATION-2      
                  AND DY.ADDRESS_ID = PR.ADDRESS_ID                     
                  AND PR.PREMISE_NO = AT.PREMISE_NO                     
                  AND AT.CODE_ACCT_STAT IN ('A', 'S', 'B')              
                  AND AT.ACCOUNT_NO = CP.ACCOUNT_NO                     
                  AND CP.CODE_PLAN_STATUS IN                            
                      ('A', 'I', 'B', 'D', 'M')                         
                  AND NOT EXISTS                                        
                      (SELECT 'Y' FROM CSS_MTRD_ENVRNMT MT2
                           WITH(READUNCOMMITTED)             
                        WHERE AT.ACCOUNT_NO = MT2.ACCOUNT_NO            
                          AND MT2.CODE_UTIL_TYPE IN ('E', 'G'))         
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(DISTINCT PR.PREMISE_NO)                             
MFA-TR*          INTO :WS-COUNT-PREMISES-2                                      
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_CUST_PLAN CP                                          
MFA-TR*         WHERE DY.ZIP_CODE = :DY-ZIP-CODE                                
MFA-TR*           AND DY.ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1                      
MFA-TR*           AND DY.ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2                      
MFA-TR*           AND DY.STREET_NAME = :DY-STREET-NAME                          
MFA-TR*           AND DY.STREET_SUFFIX = :S9-STREET-SUFFIX                      
MFA-TR*           AND DY.ADDR_SUFFIX = :DY-ADDR-SUFFIX                          
MFA-TR*           AND DY.HOUSE_NO = :DY-HOUSE-NO                                
MFA-TR*           AND DY.STREET_LOCATION_1 = :DY-STREET-LOCATION-1              
MFA-TR*           AND DY.STREET_LOCATION_2 = :DY-STREET-LOCATION-2              
MFA-TR*           AND DY.ADDRESS_ID = PR.ADDRESS_ID                             
MFA-TR*           AND PR.PREMISE_NO = AT.PREMISE_NO                             
MFA-TR*           AND AT.CODE_ACCT_STAT IN ('A', 'S', 'B')                      
MFA-TR*           AND AT.ACCOUNT_NO = CP.ACCOUNT_NO                             
MFA-TR*           AND CP.CODE_PLAN_STATUS IN                                    
MFA-TR*               ('A', 'I', 'B', 'D', 'M')                                 
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT 'Y' FROM CSS_MTRD_ENVRNMT MT2                     
MFA-TR*                 WHERE AT.ACCOUNT_NO = MT2.ACCOUNT_NO                    
MFA-TR*                   AND MT2.CODE_UTIL_TYPE IN ('E', 'G'))                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 21002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT2'             TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'ZIP_CODE'            TO TABLE-ELEMENT-1             
              MOVE 'STREET_NAME'         TO TABLE-ELEMENT-2             
              MOVE 'HOUSE_NO'            TO TABLE-ELEMENT-3             
              MOVE DY-ZIP-CODE           TO HOSTVAR-ELEMENT-1           
              MOVE DY-STREET-NAME        TO HOSTVAR-ELEMENT-2           
              MOVE DY-HOUSE-NO           TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3000-PREMISE-FILTER.                                             
                                                                        
           MOVE PR-PREMISE-NO TO WS-CPD99-PREMISE-NO.                   
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
           MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO.                   
A03264     PERFORM 7260-GET-AT-COMPANY THRU 7260-EXIT.                  
                                                                        
           PERFORM 7100-RATE-5-CHECK THRU 7100-EXIT.                    
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7110-APPLIANCE-CHECK THRU 7110-EXIT
           END-IF.             
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7120-METER-STATUS-CHECK THRU 7120-EXIT
           END-IF.          
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7130-METER-REASON-CHECK THRU 7130-EXIT
           END-IF.          
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7140-DNPFB-CHECK THRU 7140-EXIT
           END-IF.                 
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7150-METERED-ORDER-CHECK THRU 7150-EXIT
           END-IF.         
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7160-NON-RESIDENTIAL-CHECK THRU 7160-EXIT
           END-IF.       
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7170-MULTIPLE-METER-CHECK THRU 7170-EXIT
           END-IF.        
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7180-ORDER-STATUS-CHECK THRU 7180-EXIT
           END-IF.          
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7190-RED-FLAG-CHECK THRU 7190-EXIT
           END-IF.              
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7250-DATE-CHECK THRU 7250-EXIT
           END-IF.                  
A03264     IF RS-STATUS-CODE = 0 AND                                    
A03264        AT-COMPANY-NO = '01' AND                                  
A03264        RS-GAS-FL = 'Y'                                           
A03264           PERFORM 7270-BOLT-PHASE-METER THRU 7270-EXIT
           END-IF.          
                                                                        
           IF RS-STATUS-CODE = 0                                        
               PERFORM 3100-ONE-GOOD-ROW-FOUND THRU 3100-EXIT
           END-IF.          
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-ONE-GOOD-ROW-FOUND.                                         
                                                                        
           MOVE PR-PREMISE-NO TO WS-PREMISE-NO-NUM.                     
           MOVE WS-PREMISE-NO-RED TO RS-PREMISE-NO.                     
           MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO-NUM.                     
           MOVE WS-ACCOUNT-NO-RED TO RS-ACCOUNT-NO.                     
           PERFORM 7400-GET-LIGHTING THRU 7400-EXIT.                    
           PERFORM 7500-GET-COMPANY-NO THRU 7500-EXIT.                  
           PERFORM 7200-ACTIVE-ACCOUNT-CHECK THRU 7200-EXIT.            
           IF WS-ACTIVE-ACCOUNT = 'Y'                                   
               MOVE 'Y' TO RS-NAME-CHECK-FL                             
               PERFORM 7210-ACTIVE-OFF-CHECK THRU 7210-EXIT             
               IF RS-NAME-CHECK-FL = 'Y'                                
                   PERFORM 7220-ACTIVE-CC-REVERT-CHECK THRU 7220-EXIT   
               END-IF                                                   
               IF RS-NAME-CHECK-FL = 'Y'                                
                   PERFORM 7230-BUSINESS-NAME-CHECK THRU 7230-EXIT      
               END-IF                                                   
               IF RS-NAME-CHECK-FL = 'Y'                                
                  PERFORM 7240-ACCOUNT-LL-NAME-CHECK THRU 7240-EXIT     
               END-IF                                                   
               IF RS-NAME-CHECK-FL = 'Y'                                
                  PERFORM 7300-GET-NAME-METER THRU 7300-EXIT
               END-IF
           END-IF.           
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-SUFFIX.                                              
                                                                        
           EXEC SQL                                                     
               SELECT STREET_SUFFIX                                     
                 INTO :S9-STREET-SUFFIX                                 
                 FROM CSS_STREET_SUFFIX                                 
                WHERE STREET_SUFFIX_DESC = :S9-STREET-SUFFIX-DESC       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT STREET_SUFFIX                                             
MFA-TR*          INTO :S9-STREET-SUFFIX                                         
MFA-TR*          FROM CSS_STREET_SUFFIX                                         
MFA-TR*         WHERE STREET_SUFFIX_DESC = :S9-STREET-SUFFIX-DESC               
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_STREET_SUFFIX'   TO TABLE-1                     
              MOVE 'STREET_SUFFIX_DESC'  TO TABLE-ELEMENT-1             
              MOVE S9-STREET-SUFFIX-DESC TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-CURSOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN PREMISE_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_PREMISE'           TO TABLE-1                  
               MOVE 'ZIP_CODE'              TO TABLE-ELEMENT-1          
               MOVE 'STREET_NAME'           TO TABLE-ELEMENT-2          
               MOVE 'HOUSE_NO'              TO TABLE-ELEMENT-3          
               MOVE DY-ZIP-CODE             TO HOSTVAR-ELEMENT-1        
               MOVE DY-STREET-NAME          TO HOSTVAR-ELEMENT-2        
               MOVE DY-HOUSE-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-FETCH-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               FETCH PREMISE_CURSOR                                     
               INTO :PR-PREMISE-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7020'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_PREMISE'           TO TABLE-1                  
               MOVE 'ZIP_CODE'              TO TABLE-ELEMENT-1          
               MOVE 'STREET_NAME'           TO TABLE-ELEMENT-2          
               MOVE 'HOUSE_NO'              TO TABLE-ELEMENT-3          
               MOVE DY-ZIP-CODE             TO HOSTVAR-ELEMENT-1        
               MOVE DY-STREET-NAME          TO HOSTVAR-ELEMENT-2        
               MOVE DY-HOUSE-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE PREMISE_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_PREMISE'           TO TABLE-1                  
               MOVE 'ZIP_CODE'              TO TABLE-ELEMENT-1          
               MOVE 'STREET_NAME'           TO TABLE-ELEMENT-2          
               MOVE 'HOUSE_NO'              TO TABLE-ELEMENT-3          
               MOVE DY-ZIP-CODE             TO HOSTVAR-ELEMENT-1        
               MOVE DY-STREET-NAME          TO HOSTVAR-ELEMENT-2        
               MOVE DY-HOUSE-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-RATE-5-CHECK.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RATE_PLAN_NO                                      
                 INTO :UT-RATE-PLAN-NO                                  
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND RATE_PLAN_NO = '005'                              
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RATE_PLAN_NO                                              
MFA-TR*          INTO :UT-RATE-PLAN-NO                                          
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND RATE_PLAN_NO = '005'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +200 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :RG-ACCOUNT-NO                                    
                 FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :RG-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_REGISTER_READ                                         
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +200 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_REGISTER_READ' TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE RG-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-APPLIANCE-CHECK.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PREMISE_NO                                        
                 INTO :LA-PREMISE-NO                                    
                 FROM CSS_APPLIANCE WITH(READUNCOMMITTED)                       
                WHERE PREMISE_NO   = :PR-PREMISE-NO                     
                  AND (CONDITION_CD > ' '                               
                   OR  CAUTION_TAG_IND = 'Y')                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*          INTO :LA-PREMISE-NO                                            
MFA-TR*          FROM CSS_APPLIANCE                                             
MFA-TR*         WHERE PREMISE_NO   = :PR-PREMISE-NO                             
MFA-TR*           AND (CONDITION_CD > ' '                                       
MFA-TR*            OR  CAUTION_TAG_IND = 'Y')                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +300 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_APPLIANCE'    TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-METER-STATUS-CHECK.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :MN-ACCOUNT-NO                                    
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_METER_STATUS NOT IN ('A','J')                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :MN-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_METER_STATUS NOT IN ('A','J')                        
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7120                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +400 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7120'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-METER-REASON-CHECK.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :MN-ACCOUNT-NO                                    
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_STATUS_REAS IN ('N', 'B', 'R', '8', 'F',     
                      'G', 'H', 'K', 'L', 'M', 'O', 'P', 'S', 'U',      
                      'V', 'Z', '1', '2', '5', '6', '7', '9')           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :MN-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_STATUS_REAS IN ('N', 'B', 'R', '8', 'F',             
MFA-TR*               'G', 'H', 'K', 'L', 'M', 'O', 'P', 'S', 'U',              
MFA-TR*               'V', 'Z', '1', '2', '5', '6', '7', '9')                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7130                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +500 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7130'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-DNPFB-CHECK.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND ORDER_TYPE_CD = 'DNPFB'                           
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND ORDER_TYPE_CD = 'DNPFB'                                   
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71401                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +600 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7140'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CODE_STATUS_REASON                                
                 INTO :AT-CODE-STATUS-REASON                            
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_ACCT_STAT = 'B'                              
                  AND CODE_STATUS_REASON = 'C'                          
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_STATUS_REASON                                        
MFA-TR*          INTO :AT-CODE-STATUS-REASON                                    
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_ACCT_STAT = 'B'                                      
MFA-TR*           AND CODE_STATUS_REASON = 'C'                                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71402                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +600 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7140'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-METERED-ORDER-CHECK.                                        
                                                                        
      * CHECK FOR SET, DNP, MARKETING, METER CHANGE ORDERS                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_ORDER_TYPE FO WITH(READUNCOMMITTED)                   
                WHERE PREMISE_NO   = :PR-PREMISE-NO                     
                  AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD               
                  AND VO.COMPANY_NO = FO.COMPANY_NO                     
                  AND FO.ORDER_GROUP_CD IN ('B', 'C', 'E', 'G')         
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_ORDER_TYPE FO                                         
MFA-TR*         WHERE PREMISE_NO   = :PR-PREMISE-NO                             
MFA-TR*           AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD                       
MFA-TR*           AND VO.COMPANY_NO = FO.COMPANY_NO                             
MFA-TR*           AND FO.ORDER_GROUP_CD IN ('B', 'C', 'E', 'G')                 
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71501                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +700 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7150'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
      * CHECK FOR METER-RELATED ORDERS NOT CC001 OR OFF01                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_ORDER_TYPE FO WITH(READUNCOMMITTED)                   
                WHERE PREMISE_NO   = :PR-PREMISE-NO                     
                  AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD               
                  AND VO.COMPANY_NO = FO.COMPANY_NO                     
                  AND FO.ORDER_GROUP_CD = 'D'                           
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND VO.ORDER_TYPE_CD NOT IN ('OFF01', 'CC001')        
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_ORDER_TYPE FO                                         
MFA-TR*         WHERE PREMISE_NO   = :PR-PREMISE-NO                             
MFA-TR*           AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD                       
MFA-TR*           AND VO.COMPANY_NO = FO.COMPANY_NO                             
MFA-TR*           AND FO.ORDER_GROUP_CD = 'D'                                   
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND VO.ORDER_TYPE_CD NOT IN ('OFF01', 'CC001')                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71502                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +700 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7150'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
      * CHECK FOR CC001 ORDERS NOT REVERTS                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE PREMISE_NO   = :PR-PREMISE-NO                     
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND ORDER_TYPE_CD = 'CC001'                           
                  AND ORDER_REASON <> 'R'                               
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*         WHERE PREMISE_NO   = :PR-PREMISE-NO                             
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND ORDER_TYPE_CD = 'CC001'                                   
MFA-TR*           AND ORDER_REASON = 'R'                                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71503                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +700 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7150'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT3'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
      * CHECK FOR CC001 AND OFF01 ORDERS                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) VO1.SERV_ORDER_NO                                 
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA VO1 WITH(READUNCOMMITTED),                    
                      CSS_SO_DATA VO2 WITH(READUNCOMMITTED)                     
                WHERE VO1.PREMISE_NO   = :PR-PREMISE-NO                 
                  AND VO1.ORDER_STATE_CD NOT IN ('C', 'Z')              
                  AND VO1.ORDER_TYPE_CD = 'CC001'                       
                  AND VO1.PREMISE_NO   = VO2.PREMISE_NO                 
                  AND VO2.ORDER_STATE_CD NOT IN ('C', 'Z')              
                  AND VO2.ORDER_TYPE_CD = 'OFF01'                       
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VO1.SERV_ORDER_NO                                         
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA VO1,                                          
MFA-TR*               CSS_SO_DATA VO2                                           
MFA-TR*         WHERE VO1.PREMISE_NO   = :PR-PREMISE-NO                         
MFA-TR*           AND VO1.ORDER_STATE_CD NOT IN ('C', 'Z')                      
MFA-TR*           AND VO1.ORDER_TYPE_CD = 'CC001'                               
MFA-TR*           AND VO1.PREMISE_NO   = VO2.PREMISE_NO                         
MFA-TR*           AND VO2.ORDER_STATE_CD NOT IN ('C', 'Z')                      
MFA-TR*           AND VO2.ORDER_TYPE_CD = 'OFF01'                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71504                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +700 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7150'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT4'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
      * CHECK FOR NEW SERVICE, ENDV, RETIRE SERVICE                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE PREMISE_NO   = :PR-PREMISE-NO                     
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND ORDER_TYPE_CD IN ('FW009', 'FW021', 'FW010',      
P00253                                  'FW019', 'FW023', 'FW016')      
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*         WHERE PREMISE_NO   = :PR-PREMISE-NO                             
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND ORDER_TYPE_CD IN ('FW009', 'FW021', 'FW010',              
MFA-TR*                                 'FW019', 'FW023', 'FW016')              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71505                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +700 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7150'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT5'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7160-NON-RESIDENTIAL-CHECK.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_TYPE_CODE                                 
                 INTO :AT-ACCOUNT-TYPE-CODE                             
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_TYPE_CODE                                         
MFA-TR*          INTO :AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7160                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF AT-ACCOUNT-TYPE-CODE NOT = 'R'                    
                       MOVE +800 TO RS-STATUS-CODE                      
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7160'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7170-MULTIPLE-METER-CHECK.                                       
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-COUNT-ELEC-METERS                             
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_UTIL_TYPE = 'E'                              
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-COUNT-ELEC-METERS                                     
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71701                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-COUNT-ELEC-METERS > 1                          
                       MOVE +900 TO RS-STATUS-CODE                      
                   END-IF                                               
                   IF WS-COUNT-ELEC-METERS > 0                          
                       MOVE 'Y' TO RS-ELEC-FL                           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7170'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-COUNT-GAS-METERS                              
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_UTIL_TYPE = 'G'                              
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-COUNT-GAS-METERS                                      
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71702                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-COUNT-GAS-METERS > 1                           
                       MOVE +900 TO RS-STATUS-CODE                      
                   END-IF                                               
                   IF WS-COUNT-GAS-METERS > 0                           
                       MOVE 'Y' TO RS-GAS-FL                            
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7170'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7180-ORDER-STATUS-CHECK.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO   = :PR-PREMISE-NO                     
                  AND ORDER_STATE_CD NOT IN ('A', 'C', 'Z')             
                  AND ORDER_TYPE_CD = 'CC001'                           
                  AND ORDER_REASON = 'R'                                
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO   = :PR-PREMISE-NO                             
MFA-TR*           AND ORDER_STATE_CD NOT IN ('A', 'C', 'Z')                     
MFA-TR*           AND ORDER_TYPE_CD = 'CC001'                                   
MFA-TR*           AND ORDER_REASON = 'R'                                        
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71801                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +950 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7180'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO   = :PR-PREMISE-NO                     
                  AND ORDER_STATE_CD NOT IN ('A', 'C', 'Z')             
                  AND ORDER_TYPE_CD = 'OFF01'                           
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO   = :PR-PREMISE-NO                             
MFA-TR*           AND ORDER_STATE_CD NOT IN ('A', 'C', 'Z')                     
MFA-TR*           AND ORDER_TYPE_CD = 'OFF01'                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71802                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +950 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7180'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7190-RED-FLAG-CHECK.                                             
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET   :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           COMMUNICATION_ID, 121), ' ', '-'), ':', '.') 
           COMMUNICATION_ID                                  
                 INTO :KO-COMMUNICATION-ID                              
                 FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                  AND ((RED_FLAG_IND = 'Y'                              
                  AND  RED_FLAG_EXPIRE_DT IS NULL)                      
                   OR (RED_FLAG_IND = 'Y'                               
                  AND  RED_FLAG_EXPIRE_DT > CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )))     
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMMUNICATION_ID                                          
MFA-TR*          INTO :KO-COMMUNICATION-ID                                      
MFA-TR*          FROM CSS_COMM_DATA                                             
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*           AND ((RED_FLAG_IND = 'Y'                                      
MFA-TR*           AND  RED_FLAG_EXPIRE_DT IS NULL)                              
MFA-TR*            OR (RED_FLAG_IND = 'Y'                                       
MFA-TR*           AND  RED_FLAG_EXPIRE_DT > :WS-CURRENT-TIMESTAMP))             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71901                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +975 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7190'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'    TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           COMMUNICATION_ID, 121), ' ', '-'), ':', '.') 
           COMMUNICATION_ID                                  
                 INTO :KO-COMMUNICATION-ID                              
                 FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                       
                WHERE PREMISE_NO  = :PR-PREMISE-NO                      
                  AND ((RED_FLAG_IND = 'Y'                              
                  AND  RED_FLAG_EXPIRE_DT IS NULL)                      
                   OR (RED_FLAG_IND = 'Y'                               
                  AND  RED_FLAG_EXPIRE_DT > CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )))     
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMMUNICATION_ID                                          
MFA-TR*          INTO :KO-COMMUNICATION-ID                                      
MFA-TR*          FROM CSS_COMM_DATA                                             
MFA-TR*         WHERE PREMISE_NO  = :PR-PREMISE-NO                              
MFA-TR*           AND ((RED_FLAG_IND = 'Y'                                      
MFA-TR*           AND  RED_FLAG_EXPIRE_DT IS NULL)                              
MFA-TR*            OR (RED_FLAG_IND = 'Y'                                       
MFA-TR*           AND  RED_FLAG_EXPIRE_DT > :WS-CURRENT-TIMESTAMP))             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 71902                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +975 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7190'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'    TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-ACTIVE-ACCOUNT-CHECK.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ACTIVE-ACCOUNT                                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_ACCT_STAT = 'A'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ACTIVE-ACCOUNT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_ACCT_STAT = 'A'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ACTIVE-ACCOUNT                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ACTIVE-ACCOUNT                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-ACTIVE-OFF-CHECK.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO     = :PR-PREMISE-NO                   
                  AND ORDER_TYPE_CD  = 'OFF01'                          
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO     = :PR-PREMISE-NO                           
MFA-TR*           AND ORDER_TYPE_CD  = 'OFF01'                                  
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO RS-NAME-CHECK-FL                         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7210'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-ACTIVE-CC-REVERT-CHECK.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_LANDLORD SI WITH(READUNCOMMITTED)                     
                WHERE VO.PREMISE_NO  = :PR-PREMISE-NO                   
                  AND ORDER_TYPE_CD  = 'CC001'                          
                  AND ORDER_REASON = 'R'                                
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND VO.ACCOUNT_NO = AT.ACCOUNT_NO                     
                  AND AT.CUSTOMER_NO = SI.CUSTOMER_NO                   
                  AND VO.PREMISE_NO = SI.PREMISE_NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_LANDLORD SI                                           
MFA-TR*         WHERE VO.PREMISE_NO  = :PR-PREMISE-NO                           
MFA-TR*           AND ORDER_TYPE_CD  = 'CC001'                                  
MFA-TR*           AND ORDER_REASON = 'R'                                        
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND VO.ACCOUNT_NO = AT.ACCOUNT_NO                             
MFA-TR*           AND AT.CUSTOMER_NO = SI.CUSTOMER_NO                           
MFA-TR*           AND VO.PREMISE_NO = SI.PREMISE_NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7220                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO RS-NAME-CHECK-FL                         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7220'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'CSS_ACCOUNT'      TO TABLE-2                   
                   MOVE 'CSS_LANDLORD'     TO TABLE-3                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7230-BUSINESS-NAME-CHECK.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DQ.NAME_ID                                        
                 INTO :DQ-NAME-ID                                       
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_CUSTOMER CU WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                  AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                   
                  AND CU.NAME_ID = DQ.NAME_ID                           
                  AND NAME_FORMAT = 'B'                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DQ.NAME_ID                                                
MFA-TR*          INTO :DQ-NAME-ID                                               
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_CUSTOMER CU,                                          
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*           AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND NAME_FORMAT = 'B'                                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7230                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO RS-NAME-CHECK-FL                         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7230'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'CSS_CUSTOMER'     TO TABLE-2                   
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-ACCOUNT-LL-NAME-CHECK.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SI.CUSTOMER_NO                                    
                 INTO :SI-CUSTOMER-NO                                   
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_LANDLORD SI WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                  AND AT.CUSTOMER_NO = SI.CUSTOMER_NO                   
                  AND AT.PREMISE_NO = SI.PREMISE_NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SI.CUSTOMER_NO                                            
MFA-TR*          INTO :SI-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_LANDLORD SI                                           
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*           AND AT.CUSTOMER_NO = SI.CUSTOMER_NO                           
MFA-TR*           AND AT.PREMISE_NO = SI.PREMISE_NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7240                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO RS-NAME-CHECK-FL                         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7240'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'CSS_LANDLORD'     TO TABLE-2                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-DATE-CHECK.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET   :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO  = :PR-PREMISE-NO                      
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND (ORDER_TYPE_CD = 'OFF01'                          
                   OR (ORDER_TYPE_CD = 'CC001'                          
                  AND ORDER_REASON = 'R'))                              
                  AND ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO  = :PR-PREMISE-NO                              
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND (ORDER_TYPE_CD = 'OFF01'                                  
MFA-TR*            OR (ORDER_TYPE_CD = 'CC001'                                  
MFA-TR*           AND ORDER_REASON = 'R'))                                      
MFA-TR*           AND ASSIGNED_DATETIME < :WS-CURRENT-TIMESTAMP                 
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +960 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7250'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO-DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03264 7260-GET-AT-COMPANY.                                             
A03264                                                                  
A03264     EXEC SQL                                                     
A03264         SELECT TOP(1) COMPANY_NO                                        
A03264           INTO :AT-COMPANY-NO                                    
A03264           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
A03264          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
A03264                                           
A03264                                                           
A03264                                                      
A03264     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO                                                
MFA-TR*          INTO :AT-COMPANY-NO                                            
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7260                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03264                                                                  
A03264     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03264                                                                  
A03264     EVALUATE WS-ACTIVE-RETURN-CODE                               
A03264         WHEN SUCCESSFUL-CALL                                     
A03264             CONTINUE                                             
A03264         WHEN OTHER                                               
A03264             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A03264             MOVE '7260'           TO ACTIVE-PARAGRAPH            
A03264             MOVE 'SELECT'         TO ABEND-FUNCTION              
A03264             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A03264                                      ABEND-TABLES                
A03264             MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
A03264             MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
A03264             MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
A03264             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A03264             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A03264     END-EVALUATE.                                                
A03264                                                                  
A03264 7260-EXIT.                                                       
A03264     EXIT.                                                        
                                                                        
A03264 7270-BOLT-PHASE-METER.                                           
A03264                                                                  
A03264     EXEC SQL                                                     
A03264         SELECT TOP(1) MN.ACCOUNT_NO                                     
A03264           INTO :MN-ACCOUNT-NO                                    
A03264           FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                
A03264                CSS_ELEC_METER EM WITH(READUNCOMMITTED)                   
A03264          WHERE MN.ACCOUNT_NO = :AT-ACCOUNT-NO                    
A03264            AND MN.CODE_UTIL_TYPE = 'E'                           
A03264            AND MN.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE             
A03264            AND MN.CODE_METER_STATUS = 'J'                        
A03264            AND MN.METER_NO = EM.METER_NO                         
A03264            AND EM.COMPANY_NO = :AT-COMPANY-NO                    
A03264            AND (EM.MTR_CONNECT_TYP_ID = 'BOLT-IN'                
A03264             OR  EM.NO_PHASES = '3')                              
A03264            AND EXISTS (                                          
A03264                SELECT '1'                                        
A03264                  FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)             
A03264                 WHERE ACCOUNT_NO = MN.ACCOUNT_NO                 
A03264                   AND CODE_UTIL_TYPE = 'G'                       
A03264                   AND CODE_METER_STATUS = 'J')                   
A03264                                           
A03264                                                           
A03264                                                      
A03264     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MN.ACCOUNT_NO                                             
MFA-TR*          INTO :MN-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN,                                      
MFA-TR*               CSS_ELEC_METER EM                                         
MFA-TR*         WHERE MN.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND MN.CODE_UTIL_TYPE = 'E'                                   
MFA-TR*           AND MN.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE                     
MFA-TR*           AND MN.CODE_METER_STATUS = 'J'                                
MFA-TR*           AND MN.METER_NO = EM.METER_NO                                 
MFA-TR*           AND EM.COMPANY_NO = :AT-COMPANY-NO                            
MFA-TR*           AND (EM.MTR_CONNECT_TYP_ID = 'BOLT-IN'                        
MFA-TR*            OR  EM.NO_PHASES = '3')                                      
MFA-TR*           AND EXISTS (                                                  
MFA-TR*               SELECT '1'                                                
MFA-TR*                 FROM CSS_MTRD_ENVRNMT                                   
MFA-TR*                WHERE ACCOUNT_NO = MN.ACCOUNT_NO                         
MFA-TR*                  AND CODE_UTIL_TYPE = 'G'                               
MFA-TR*                  AND CODE_METER_STATUS = 'J')                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7270                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03264                                                                  
A03264     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03264                                                                  
A03264     EVALUATE WS-ACTIVE-RETURN-CODE                               
A03264         WHEN SUCCESSFUL-CALL                                     
A03264             MOVE +970 TO RS-STATUS-CODE                          
A03264         WHEN NOT-FOUND                                           
A03264             MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
A03264         WHEN OTHER                                               
A03264             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A03264             MOVE '7270'           TO ACTIVE-PARAGRAPH            
A03264             MOVE 'SELECT'         TO ABEND-FUNCTION              
A03264             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A03264                                      ABEND-TABLES                
A03264             MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
A03264             MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
A03264             MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
A03264             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A03264             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A03264     END-EVALUATE.                                                
A03264                                                                  
A03264 7270-EXIT.                                                       
A03264     EXIT.                                                        
                                                                        
       7300-GET-NAME-METER.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MN.METER_NO                                       
                 INTO :MN-METER-NO                                      
                 FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
                WHERE MN.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MN.METER_NO                                               
MFA-TR*          INTO :MN-METER-NO                                              
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN                                       
MFA-TR*         WHERE MN.ACCOUNT_NO  = :AT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 73001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE MN-METER-NO  TO RS-ELEC-METER-NO                
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MN.METER_NO                                       
                 INTO :MN-METER-NO                                      
                 FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
                WHERE MN.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MN.METER_NO                                               
MFA-TR*          INTO :MN-METER-NO                                              
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN                                       
MFA-TR*         WHERE MN.ACCOUNT_NO  = :AT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 73002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE MN-METER-NO  TO RS-GAS-METER-NO                 
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DQ.LAST_NAME                                      
                 INTO :DQ-LAST-NAME                                     
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_CUSTOMER CU WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
                  AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                   
                  AND CU.NAME_ID     = DQ.NAME_ID                       
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DQ.LAST_NAME                                              
MFA-TR*          INTO :DQ-LAST-NAME                                             
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_CUSTOMER CU,                                          
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                           
MFA-TR*           AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND CU.NAME_ID     = DQ.NAME_ID                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 73003                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE DQ-LAST-NAME TO RS-LAST-NAME                    
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT3'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'CSS_CUSTOMER'     TO TABLE-1                   
                   MOVE 'CSS_NAME'         TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-GET-LIGHTING.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) UT.ACCOUNT_NO                                     
                 INTO :UT-ACCOUNT-NO                                    
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'U'                              
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT UT.ACCOUNT_NO                                             
MFA-TR*          INTO :UT-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE UT.ACCOUNT_NO  = :AT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'U'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 74001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-LITE-FL                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-LITE-FL                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF RS-LITE-FL = 'Y'                                          
               EXEC SQL                                                 
                   SELECT TOP(1) UT.ACCOUNT_NO                                 
                     INTO :UT-ACCOUNT-NO                                
                     FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)             
                    WHERE UT.ACCOUNT_NO = :AT-ACCOUNT-NO                
                      AND CODE_UTIL_TYPE = 'U'                          
                      AND RATE_PLAN_NO = '064'                          
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*            SELECT UT.ACCOUNT_NO                                         
MFA-TR*              INTO :UT-ACCOUNT-NO                                        
MFA-TR*              FROM CSS_UTIL_ENVRNMT UT                                   
MFA-TR*             WHERE UT.ACCOUNT_NO = :AT-ACCOUNT-NO                        
MFA-TR*               AND CODE_UTIL_TYPE = 'U'                                  
MFA-TR*               AND RATE_PLAN_NO = '064'                                  
MFA-TR*             FETCH FIRST 1 ROWS ONLY                                     
MFA-TR*             WITH UR                                                     
MFA-TR*             QUERYNO 74002                                               
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                                                                        
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       MOVE 'Y' TO RS-SUBD-LITE-FL                      
                   WHEN NOT-FOUND                                       
                       MOVE 'N' TO RS-SUBD-LITE-FL                      
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME TO ABEND-PROGRAM               
                       MOVE '7400'       TO ACTIVE-PARAGRAPH            
                       MOVE 'SELECT2'    TO ABEND-FUNCTION              
                       MOVE SPACES       TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                       MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1               
                       MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1            
                       MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1          
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
               END-EVALUATE
           END-IF.                                            
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-GET-COMPANY-NO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) COMPANY_NO                                        
                 INTO :PR-COMPANY-NO                                    
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO  = :PR-PREMISE-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO                                                
MFA-TR*          INTO :PR-COMPANY-NO                                            
MFA-TR*          FROM CSS_PREMISE                                               
MFA-TR*         WHERE PREMISE_NO  = :PR-PREMISE-NO                              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE PR-COMPANY-NO TO RS-COMPANY-NO                  
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO RS-COMPANY-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREMISE'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
