                                                                        
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04043.                                            
       DATE-WRITTEN. 09/21/07.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE CALLED FROM CRYSTAL  *        
      *  REPORTS                                                       *        
      *                                                                *        
      *  THIS PROGRAM SELECTS RECORDS FOR REPORTS SERVICE COUNT        *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  09/21/07  GV97034    INITIAL VERSION                          *        
C37253*  06/16/08  FMB        CREATED BINDO CARD FOR REOPT(VARS)       *        
CSR501*  12/16/15  PK44514    ADD ST1 TO UG WORK TYPES LIST            *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04043'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(45) VALUE   
           'WORKING STORAGE FOR SP CSR04043 STARTS HERE'.               
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHSTODR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBWKMATL                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GTT-SVC-OUT.                                                 
            05  GTT-NAME                PIC X(26)                       
                    VALUE 'SESSION.CSR04043_R1'.                        
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  GTT-SVC-CNT.                                                 
            05  GTT-NAME                PIC X(26)                       
                    VALUE 'SESSION.CSR04043_R2'.                        
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  GTT-OU-CNT.                                                  
            05  GTT-NAME                PIC X(26)                       
                    VALUE 'SESSION.CSR04043_R3'.                        
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  MESSAGE-FIELDS.                                              
            05  MSG-TYPE                     PIC S9(9) COMP.            
            05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.   
            05  MSG-NR                       PIC S9(9) COMP VALUE  2.   
            05  MSG-RPC                      PIC X(4)  VALUE 'S200'.    
            05  MSG-RPC                      PIC X(8)  VALUE 'CSR04043'.
            05  MSG-RPC-L                    PIC S9(9) COMP.            
            05  MSG-TEXT                     PIC X(100).                
            05  MSG-TEXT-L                   PIC S9(9) COMP.            
            05  MSG-SQL-ERROR.                                          
                10  FILLER                   PIC X(10)                  
                                             VALUE 'SQLCODE = '.        
                10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.         
                10  FILLER                   PIC X(16)                  
                                             VALUE ', ERROR TOKENS: '.  
                10  MSG-SQL-ERROR-K          PIC X(70).                 
                10  MSG-SQL-ERROR-K-CHARS                               
                                             REDEFINES MSG-SQL-ERROR-K  
                                             OCCURS 70 TIMES            
                                             PIC X.                     
            05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.            
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
            05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
            05  S-WQ-FLAG               PIC X(01) VALUE 'N'.            
                                                                        
       01  SWITCHES.                                                    
            05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.            
                88 SEND-DONE-ERROR                VALUE 'N'.            
                88 SEND-DONE-OK                   VALUE 'Y'.            
       01  WS-BEGIN-DT                  PIC X(10).                      
       01  WS-END-DT                    PIC X(10).                      
       01  WS-BEGIN-TS                  PIC X(26).                      
       01  WS-END-TS                    PIC X(26).                      
       01  WS-TIMESTAMP                 PIC X(16)                       
                                        VALUE '-00.00.00.000000'.       
       01  WS-SQLSTATE                  PIC X(05) VALUE SPACES.         
       01  CTR-ROWS                     PIC S9(9) COMP VALUE 0.         
       01  S-CURR-VALUE                 PIC X(20) VALUE SPACE.          
       01  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04043'.     
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-BEGIN-DT      PIC X(10).                                
       01  PARM-END-DT        PIC X(10).                                
                                                                        
       PROCEDURE DIVISION USING PARM-BEGIN-DT                           
                                PARM-END-DT.                            
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                 
            PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                 
            PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                 
            PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                 
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
            EXEC SQL                                                    
                WHENEVER SQLWARNING CONTINUE                            
            END-EXEC.                                                   
            EXEC SQL                                                    
                WHENEVER SQLERROR   CONTINUE                            
            END-EXEC.                                                   
            EXEC SQL                                                    
                WHENEVER NOT FOUND  CONTINUE                            
            END-EXEC.                                                   
                                                                        
            PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                  
                                                                        
            EXEC SQL                                                    
               DECLARE C1 CURSOR  FOR                        
                  SELECT ACTION_CD                                      
                        ,(CASE WHEN OVERHEAD_UNDERGROUND ='OH'          
                               THEN 'OVERHEAD'                          
                               ELSE 'UNDERGROUND' END) OH_UG            
                        ,COMPLETE_DATE                                  
                        ,SUM(CNT) CNT                                   
                        ,BEGIN_DATE                                     
                        ,END_DATE                                       
                    FROM #CSR04043_R1                            
                    GROUP BY COMPLETE_DATE,                             
                             ACTION_CD,                                 
                             OVERHEAD_UNDERGROUND,                      
                             BEGIN_DATE,                                
                             END_DATE                                   
                    ORDER BY ACTION_CD,                                 
                             OVERHEAD_UNDERGROUND,                      
                             COMPLETE_DATE                              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*           SELECT ACTION_CD                                              
MFA-TR*                 ,(CASE WHEN OVERHEAD_UNDERGROUND ='OH'                  
MFA-TR*                        THEN 'OVERHEAD'                                  
MFA-TR*                        ELSE 'UNDERGROUND' END) OH_UG                    
MFA-TR*                 ,COMPLETE_DATE                                          
MFA-TR*                 ,SUM(CNT) CNT                                           
MFA-TR*                 ,BEGIN_DATE                                             
MFA-TR*                 ,END_DATE                                               
MFA-TR*             FROM SESSION.CSR04043_R1                                    
MFA-TR*             GROUP BY COMPLETE_DATE,                                     
MFA-TR*                      ACTION_CD,                                         
MFA-TR*                      OVERHEAD_UNDERGROUND,                              
MFA-TR*                      BEGIN_DATE,                                        
MFA-TR*                      END_DATE                                           
MFA-TR*             ORDER BY ACTION_CD,                                         
MFA-TR*                      OVERHEAD_UNDERGROUND,                              
MFA-TR*                      COMPLETE_DATE                                      
MFA-TR*     END-EXEC.                                                           
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT************************************************        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04043_R1'            
                                                TO S-SQL-STATEMENT-V.   
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04043_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04043_R1
              (                                                       
                   BEGIN_DATE            DATETIME2(6)                      
                  ,END_DATE              DATETIME2(6)                      
                  ,SERV_ORDER_NO         DECIMAL(13,0)                  
                  ,WORK_TYPE CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,REGION_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,WORK_AREA CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,ORDER_STATUS CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,ACTION_CD CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,OVERHEAD_UNDERGROUND CHAR(2)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,COMPLETE_DATE         DATETIME2(6)                      
                  ,CNT                   DECIMAL(5,0)                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE SQLCODE            TO ABEND-SQLCODE                  
              MOVE SQLSTATE           TO ABEND-SQLSTATE                 
              MOVE '0100A'            TO ACTIVE-PARAGRAPH               
              MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR04043_R1'      TO TABLE-1                        
              MOVE SPACES             TO TABLE-ELEMENT-1                
              MOVE SPACES             TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                      THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04043_R2'            
                                      TO S-SQL-STATEMENT-V.             
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04043_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04043_R2
              (                                                         
                 REGION_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2             
                ,COMPLETE_DATE           DATETIME2(6)                      
                ,UNDER_TOT               DECIMAL(7,0)                   
                ,OU_TOT                  DECIMAL(7,0)                   
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE SQLCODE            TO ABEND-SQLCODE                  
              MOVE SQLSTATE           TO ABEND-SQLSTATE                 
              MOVE '0100A'            TO ACTIVE-PARAGRAPH               
              MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR04043_R2'      TO TABLE-1                        
              MOVE SPACES             TO TABLE-ELEMENT-1                
              MOVE SPACES             TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                      THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04043_R3'            
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04043_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04043_R3
              (                                                         
                 REGION_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2             
                ,COMPLETE_DATE           DATETIME2(6)                      
                ,UNDER_TOT               DECIMAL(7,0)                   
                ,OU_TOT                  DECIMAL(7,0)                   
                ,DIVISOR                 DECIMAL(7,2)                   
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE SQLCODE            TO ABEND-SQLCODE                  
              MOVE SQLSTATE           TO ABEND-SQLSTATE                 
              MOVE '0100A'            TO ACTIVE-PARAGRAPH               
              MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR04043_R3'      TO TABLE-1                        
              MOVE SPACES             TO TABLE-ELEMENT-1                
              MOVE SPACES             TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                      THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
            MOVE PARM-BEGIN-DT           TO WS-BEGIN-DT.                
            MOVE PARM-END-DT             TO WS-END-DT.                  
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
            STRING                                                      
            WS-BEGIN-DT, WS-TIMESTAMP DELIMITED BY SIZE                 
                   INTO WS-BEGIN-TS.                                    
            STRING                                                      
            WS-END-DT, WS-TIMESTAMP DELIMITED BY SIZE                   
                   INTO WS-END-TS.                                      
            PERFORM 5000-INSERT-CSR04043-R1        THRU 5000-EXIT.      
      *     PERFORM 5010-DELETE-CSR04043-R1        THRU 5010-EXIT.              
      *     PERFORM 5020-UPDATE-CSR04043-R1        THRU 5020-EXIT.              
            PERFORM 5030-INSERT-CSR04043-R1-HST    THRU 5030-EXIT.      
      *     PERFORM 5040-DELETE-CSR04043-R1-HST    THRU 5040-EXIT.              
      *     PERFORM 5050-UPDATE-CSR04043-R1-HST    THRU 5050-EXIT.              
            PERFORM 5060-UPDATE-CSR04043-R1-REG    THRU 5060-EXIT.      
            PERFORM 5070-UPDATE-CSR04043-R1-OH     THRU 5070-EXIT.      
            PERFORM 5080-UPDATE-CSR04043-R1-UG     THRU 5080-EXIT.      
            PERFORM 5090-UPDATE-CSR04043-R1-INS    THRU 5090-EXIT.      
            PERFORM 5100-UPDATE-CSR04043-R1-REM    THRU 5100-EXIT.      
            PERFORM 5110-DELETE-CSR04043-R1-WOR    THRU 5110-EXIT.      
      *     PERFORM 5120-INSERT-CSR04043-R2        THRU 5120-EXIT.              
      *     PERFORM 5130-INSERT-CSR04043-R2-UG     THRU 5130-EXIT.              
      *     PERFORM 5140-INSERT-CSR04043-R3        THRU 5140-EXIT.              
      *     PERFORM 5150-UPDATE-CSR04043-R3        THRU 5150-EXIT.              
            PERFORM 5160-UPDATE-CSR04043-R1-002    THRU 5160-EXIT.      
            PERFORM 5170-UPDATE-CSR04043-R1-035    THRU 5170-EXIT.      
            PERFORM 5180-UPDATE-CSR04043-R1-050    THRU 5180-EXIT.      
            PERFORM 5190-UPDATE-CSR04043-R1-060    THRU 5190-EXIT.      
            PERFORM 5200-UPDATE-CSR04043-R1-070    THRU 5200-EXIT.      
            PERFORM 5210-UPDATE-CSR04043-R1-090    THRU 5210-EXIT.      
            PERFORM 5220-UPDATE-CSR04043-R1-LAST   THRU 5220-EXIT.      
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5000-INSERT-CSR04043-R1.                                       *        
      ******************************************************************        
       5000-INSERT-CSR04043-R1.                                         
      *     EXEC SQL                                                            
      *        INSERT INTO SESSION.CSR04043_R1                                  
      *            SELECT TIMESTAMP(:WS-BEGIN-TS)                               
      *                  ,TIMESTAMP(:WS-END-TS)                                 
      *                  ,OI.SERV_ORDER_NO                                      
      *                  ,OI.WORK_TYPE_CD                                       
      *                  ,'000'                                                 
      *                  ,' '                                                   
      *                  ,' '                                                   
      *                  ,'       '                                             
      *                  ,' '                                                   
      *                  ,TIMESTAMP('1900-01-01-00.00.00.000000')               
      *                  ,1                                                     
      *              FROM CSS_SO_ORDER_INST      OI                             
      *             WHERE OI.WORK_TYPE_CD IN ('ST1','S11','S12','S54',          
      *                    'S56','S57','S58','RS2','S20','S21')                 
      *               AND OI.CODE_UTIL_TYPE = 'E'                               
      *     END-EXEC.                                                           
            EXEC SQL                                                    
               INSERT INTO #CSR04043_R1                          
                   SELECT CIS.CHAR2TIMESTAMP(:WS-BEGIN-TS)                      
                         ,CIS.CHAR2TIMESTAMP(:WS-END-TS)                        
                         ,OI.SERV_ORDER_NO                              
                         ,OI.WORK_TYPE_CD                               
                         ,'000'                                         
                         ,SO.WORK_AREA_ID                               
                         ,SO.SERV_ORDER_STATUS                          
                         ,'       '                                     
                         ,' '                                           
                         ,CIS.CHAR2TIMESTAMP(SUBSTRING(REPLACE(REPLACE(
           CONVERT(CHAR(26), SO.COMPLETED_DATETIME, 121), ' ', '-'), 
           ':', '.'), 1, 7) + '-01-00.00.00.000000')          
                         ,1                                             
                     FROM CSS_SO_ORDER_INST OI, CSS_SO_DATA SO          
                    WHERE OI.SERV_ORDER_NO = SO.SERV_ORDER_NO           
                      AND OI.WORK_TYPE_CD IN ('ST1','S11','S12','S54',  
                           'S56','S57','S58','RS2','S20','S21')         
                      AND OI.CODE_UTIL_TYPE = 'E'                       
                      AND SO.SERV_ORDER_STATUS >='40'                   
                      AND SO.COMPLETED_DATETIME >=                      
                                                 CIS.CHAR2TIMESTAMP(
                                                          :WS-BEGIN-TS)
                      AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                            :WS-END-TS)
                      AND SO.COMPLETED_DATETIME IS NOT NULL             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04043_R1                                  
MFA-TR*            SELECT TIMESTAMP(:WS-BEGIN-TS)                               
MFA-TR*                  ,TIMESTAMP(:WS-END-TS)                                 
MFA-TR*                  ,OI.SERV_ORDER_NO                                      
MFA-TR*                  ,OI.WORK_TYPE_CD                                       
MFA-TR*                  ,'000'                                                 
MFA-TR*                  ,SO.WORK_AREA_ID                                       
MFA-TR*                  ,SO.SERV_ORDER_STATUS                                  
MFA-TR*                  ,'       '                                             
MFA-TR*                  ,' '                                                   
MFA-TR*                  ,TIMESTAMP(SUBSTR(CHAR(                                
MFA-TR*                                 SO.COMPLETED_DATETIME),1,7) ||          
MFA-TR*                                 '-01-00.00.00.000000')                  
MFA-TR*                  ,1                                                     
MFA-TR*              FROM CSS_SO_ORDER_INST OI, CSS_SO_DATA SO                  
MFA-TR*             WHERE OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                   
MFA-TR*               AND OI.WORK_TYPE_CD IN ('ST1','S11','S12','S54',          
MFA-TR*                    'S56','S57','S58','RS2','S20','S21')                 
MFA-TR*               AND OI.CODE_UTIL_TYPE = 'E'                               
MFA-TR*               AND SO.SERV_ORDER_STATUS >='40'                           
MFA-TR*               AND SO.COMPLETED_DATETIME >=                              
MFA-TR*                                          TIMESTAMP(:WS-BEGIN-TS)        
MFA-TR*               AND SO.COMPLETED_DATETIME <= TIMESTAMP(:WS-END-TS)        
MFA-TR*               AND SO.COMPLETED_DATETIME IS NOT NULL                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  ADD  +1                TO CTR-ROWS                    
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '5000'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04043_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5010-DELETE-CSR04043-R1.                                      *         
      ******************************************************************        
       5010-DELETE-CSR04043-R1.                                         
                                                                        
            EXEC SQL                                                    
                 DELETE FROM SC                      
                 FROM #CSR04043_R1 SC
                  WHERE EXISTS (SELECT 1 FROM CSS_SO_DATA SO            
                  WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO             
                    AND ((SO.SERV_ORDER_STATUS <> '40')                 
                     OR (SO.COMPLETED_DATETIME <                        
                                      CIS.CHAR2TIMESTAMP(:WS-BEGIN-TS)          
                     OR SO.COMPLETED_DATETIME >                         
                                      CIS.CHAR2TIMESTAMP(:WS-END-TS))))         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          DELETE FROM SESSION.CSR04043_R1 SC                             
MFA-TR*           WHERE EXISTS (SELECT 1 FROM CSS_SO_DATA SO                    
MFA-TR*           WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO                     
MFA-TR*             AND ((SO.SERV_ORDER_STATUS <> '40')                         
MFA-TR*              OR (SO.COMPLETED_DATETIME <                                
MFA-TR*                               TIMESTAMP(:WS-BEGIN-TS)                   
MFA-TR*              OR SO.COMPLETED_DATETIME >                                 
MFA-TR*                               TIMESTAMP(:WS-END-TS))))                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5010'                TO ACTIVE-PARAGRAPH           
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSR04043_R1'         TO TABLE-1                    
               MOVE 'SERV_ORDER_STATUS'   TO TABLE-ELEMENT-1            
               MOVE '40'                  TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5020-UPDATE-CSR04043-R1.                                       *        
      ******************************************************************        
       5020-UPDATE-CSR04043-R1.                                         
                                                                        
            EXEC SQL                                                    
                 UPDATE SC                           
                    SET WORK_AREA = (SELECT SO.WORK_AREA_ID
            FROM CSS_SO_DATA SO
            WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO             
                    AND SO.COMPLETED_DATETIME IS NOT NULL),
               ORDER_STATUS = (SELECT SO.SERV_ORDER_STATUS
            FROM CSS_SO_DATA SO
            WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO             
                    AND SO.COMPLETED_DATETIME IS NOT NULL),
               COMPLETE_DATE = (SELECT CIS.CHAR2TIMESTAMP( SUBSTRING(
           REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.'), 1, 7) + 
           '-01-00.00.00.000000' )
            FROM CSS_SO_DATA SO
            WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO             
                    AND SO.COMPLETED_DATETIME IS NOT NULL)              
                 FROM #CSR04043_R1 SC
                  WHERE EXISTS (SELECT 1 FROM CSS_SO_DATA SO            
                        WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO       
                          AND SO.COMPLETED_DATETIME IS NOT NULL)        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1 SC                                  
MFA-TR*             SET (WORK_AREA, ORDER_STATUS, COMPLETE_DATE) =              
MFA-TR*                 (SELECT SO.WORK_AREA_ID, SO.SERV_ORDER_STATUS,          
MFA-TR*                 TIMESTAMP(SUBSTR(CHAR(                                  
MFA-TR*                                 SO.COMPLETED_DATETIME),1,7) ||          
MFA-TR*                                 '-01-00.00.00.000000')                  
MFA-TR*            FROM CSS_SO_DATA SO                                          
MFA-TR*           WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO                     
MFA-TR*             AND SO.COMPLETED_DATETIME IS NOT NULL)                      
MFA-TR*           WHERE EXISTS (SELECT 1 FROM CSS_SO_DATA SO                    
MFA-TR*                 WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO               
MFA-TR*                   AND SO.COMPLETED_DATETIME IS NOT NULL)                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5020'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04043_R1'         TO TABLE-1                    
               MOVE 'WORK_AREA    '       TO TABLE-ELEMENT-1            
               MOVE 'SO.WORK_AREA_ID'     TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5020-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5030-INSERT-CSR04043-R1-HST.                                   *        
      ******************************************************************        
       5030-INSERT-CSR04043-R1-HST.                                     
      *     EXEC SQL                                                            
      *        INSERT INTO SESSION.CSR04043_R1                                  
      *            SELECT TIMESTAMP(:WS-BEGIN-TS)                               
      *                  ,TIMESTAMP(:WS-END-TS)                                 
      *                  ,OI.SERV_ORDER_NO                                      
      *                  ,OI.WORK_TYPE_CD                                       
      *                  ,'000'                                                 
      *                  ,' '                                                   
      *                  ,' '                                                   
      *                  ,'       '                                             
      *                  ,' '                                                   
      *                  ,TIMESTAMP('1900-01-01-00.00.00.000000')               
      *                  ,1                                                     
      *              FROM HST_SO_ORDER_INST      OI                             
      *             WHERE OI.WORK_TYPE_CD IN ('ST1','S11','S12','S54',          
      *                    'S56','S57','S58','RS2','S20','S21')                 
      *               AND OI.CODE_UTIL_TYPE = 'E'                               
      *     END-EXEC.                                                           
            EXEC SQL                                                    
               INSERT INTO #CSR04043_R1                          
                   SELECT CIS.CHAR2TIMESTAMP(:WS-BEGIN-TS)                      
                         ,CIS.CHAR2TIMESTAMP(:WS-END-TS)                        
                         ,OI.SERV_ORDER_NO                              
                         ,OI.WORK_TYPE_CD                               
                         ,'000'                                         
                         ,SO.WORK_AREA_ID                               
                         ,SO.SERV_ORDER_STATUS                          
                         ,'       '                                     
                         ,' '                                           
                         ,CIS.CHAR2TIMESTAMP(SUBSTRING(REPLACE(REPLACE(
           CONVERT(CHAR(26), SO.COMPLETED_DATETIME, 121), ' ', '-'), 
           ':', '.'), 1, 7) + '-01-00.00.00.000000')          
                         ,1                                             
                     FROM HST_SO_ORDER_INST OI, HST_SO_DATA SO          
                    WHERE OI.SERV_ORDER_NO = SO.SERV_ORDER_NO           
                      AND OI.WORK_TYPE_CD IN ('ST1','S11','S12','S54',  
                           'S56','S57','S58','RS2','S20','S21')         
                      AND OI.CODE_UTIL_TYPE = 'E'                       
                      AND SO.SERV_ORDER_STATUS >='40'                   
                      AND SO.COMPLETED_DATETIME >=                      
                                                 CIS.CHAR2TIMESTAMP(
                                                          :WS-BEGIN-TS)
                      AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                            :WS-END-TS)
                      AND SO.COMPLETED_DATETIME IS NOT NULL             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04043_R1                                  
MFA-TR*            SELECT TIMESTAMP(:WS-BEGIN-TS)                               
MFA-TR*                  ,TIMESTAMP(:WS-END-TS)                                 
MFA-TR*                  ,OI.SERV_ORDER_NO                                      
MFA-TR*                  ,OI.WORK_TYPE_CD                                       
MFA-TR*                  ,'000'                                                 
MFA-TR*                  ,SO.WORK_AREA_ID                                       
MFA-TR*                  ,SO.SERV_ORDER_STATUS                                  
MFA-TR*                  ,'       '                                             
MFA-TR*                  ,' '                                                   
MFA-TR*                  ,TIMESTAMP(SUBSTR(CHAR(                                
MFA-TR*                                 SO.COMPLETED_DATETIME),1,7) ||          
MFA-TR*                                 '-01-00.00.00.000000')                  
MFA-TR*                  ,1                                                     
MFA-TR*              FROM HST_SO_ORDER_INST OI, HST_SO_DATA SO                  
MFA-TR*             WHERE OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                   
MFA-TR*               AND OI.WORK_TYPE_CD IN ('ST1','S11','S12','S54',          
MFA-TR*                    'S56','S57','S58','RS2','S20','S21')                 
MFA-TR*               AND OI.CODE_UTIL_TYPE = 'E'                               
MFA-TR*               AND SO.SERV_ORDER_STATUS >='40'                           
MFA-TR*               AND SO.COMPLETED_DATETIME >=                              
MFA-TR*                                          TIMESTAMP(:WS-BEGIN-TS)        
MFA-TR*               AND SO.COMPLETED_DATETIME <= TIMESTAMP(:WS-END-TS)        
MFA-TR*               AND SO.COMPLETED_DATETIME IS NOT NULL                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  ADD  +1                TO CTR-ROWS                    
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '5030'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04043_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5040-DELETE-CSR04043-R1-HST.                                  *         
      ******************************************************************        
       5040-DELETE-CSR04043-R1-HST.                                     
                                                                        
            EXEC SQL                                                    
                 DELETE FROM SC                      
                 FROM #CSR04043_R1 SC
                  WHERE EXISTS (SELECT 1 FROM HST_SO_DATA SO            
                  WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO             
                    AND ((SO.SERV_ORDER_STATUS <> '40')                 
                     OR (SO.COMPLETED_DATETIME <                        
                                      CIS.CHAR2TIMESTAMP(:WS-BEGIN-TS)          
                     OR SO.COMPLETED_DATETIME >                         
                                      CIS.CHAR2TIMESTAMP(:WS-END-TS))))         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          DELETE FROM SESSION.CSR04043_R1 SC                             
MFA-TR*           WHERE EXISTS (SELECT 1 FROM HST_SO_DATA SO                    
MFA-TR*           WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO                     
MFA-TR*             AND ((SO.SERV_ORDER_STATUS <> '40')                         
MFA-TR*              OR (SO.COMPLETED_DATETIME <                                
MFA-TR*                               TIMESTAMP(:WS-BEGIN-TS)                   
MFA-TR*              OR SO.COMPLETED_DATETIME >                                 
MFA-TR*                               TIMESTAMP(:WS-END-TS))))                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5040'                TO ACTIVE-PARAGRAPH           
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSR04043_R1'         TO TABLE-1                    
               MOVE 'SERV_ORDER_STATUS'   TO TABLE-ELEMENT-1            
               MOVE '40'                  TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5040-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5050-UPDATE-CSR04043-R1-HST.                                   *        
      ******************************************************************        
       5050-UPDATE-CSR04043-R1-HST.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE SC                           
                    SET WORK_AREA = (SELECT SO.WORK_AREA_ID
            FROM HST_SO_DATA SO
            WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO             
                    AND SO.COMPLETED_DATETIME IS NOT NULL),
               ORDER_STATUS = (SELECT SO.SERV_ORDER_STATUS
            FROM HST_SO_DATA SO
            WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO             
                    AND SO.COMPLETED_DATETIME IS NOT NULL),
               COMPLETE_DATE = (SELECT CIS.CHAR2TIMESTAMP( SUBSTRING(
           REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.'), 1, 7) + 
           '-01-00.00.00.000000' )
            FROM HST_SO_DATA SO
            WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO             
                    AND SO.COMPLETED_DATETIME IS NOT NULL)              
                 FROM #CSR04043_R1 SC
                  WHERE EXISTS (SELECT 1 FROM HST_SO_DATA SO            
                        WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO       
                          AND SO.COMPLETED_DATETIME IS NOT NULL)        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1 SC                                  
MFA-TR*             SET (WORK_AREA, ORDER_STATUS, COMPLETE_DATE) =              
MFA-TR*                 (SELECT SO.WORK_AREA_ID, SO.SERV_ORDER_STATUS,          
MFA-TR*                 TIMESTAMP(SUBSTR(CHAR(                                  
MFA-TR*                                 SO.COMPLETED_DATETIME),1,7) ||          
MFA-TR*                                 '-01-00.00.00.000000')                  
MFA-TR*            FROM HST_SO_DATA SO                                          
MFA-TR*           WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO                     
MFA-TR*             AND SO.COMPLETED_DATETIME IS NOT NULL)                      
MFA-TR*           WHERE EXISTS (SELECT 1 FROM HST_SO_DATA SO                    
MFA-TR*                 WHERE SC.SERV_ORDER_NO = SO.SERV_ORDER_NO               
MFA-TR*                   AND SO.COMPLETED_DATETIME IS NOT NULL)                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5050'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04043_R1'         TO TABLE-1                    
               MOVE 'WORK_AREA    '       TO TABLE-ELEMENT-1            
               MOVE 'SO.WORK_AREA_ID'     TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5050-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5060-UPDATE-CSR04043-R1-REG.                                   *        
      ******************************************************************        
       5060-UPDATE-CSR04043-R1-REG.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE SC                           
                    SET REGION_ID = (SELECT WA.REGION_ID                
                   FROM CSS_WORK_AREA_MATL WA                           
                  WHERE SC.WORK_AREA = WA.WORK_AREA_ID)                 
                 FROM #CSR04043_R1 SC
                  WHERE EXISTS (SELECT 1 FROM CSS_WORK_AREA_MATL WA     
                        WHERE SC.WORK_AREA = WA.WORK_AREA_ID)           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1 SC                                  
MFA-TR*             SET REGION_ID = (SELECT WA.REGION_ID                        
MFA-TR*            FROM CSS_WORK_AREA_MATL WA                                   
MFA-TR*           WHERE SC.WORK_AREA = WA.WORK_AREA_ID)                         
MFA-TR*           WHERE EXISTS (SELECT 1 FROM CSS_WORK_AREA_MATL WA             
MFA-TR*                 WHERE SC.WORK_AREA = WA.WORK_AREA_ID)                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5060'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04043_R1'         TO TABLE-1                    
               MOVE 'REGION_ID'           TO TABLE-ELEMENT-1            
               MOVE 'WA.REGION_ID'        TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5060-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5070-UPDATE-CSR04043-R1-OH.                                    *        
      ******************************************************************        
       5070-UPDATE-CSR04043-R1-OH.                                      
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04043_R1                             
                    SET OVERHEAD_UNDERGROUND = 'OH'                     
                  WHERE WORK_TYPE IN ('S11','S20','RS2')                
                    AND OVERHEAD_UNDERGROUND = ' '                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1                                     
MFA-TR*             SET OVERHEAD_UNDERGROUND = 'OH'                             
MFA-TR*           WHERE WORK_TYPE IN ('S11','S20','RS2')                        
MFA-TR*             AND OVERHEAD_UNDERGROUND = ' '                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5070'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'OVERHEAD_UNDERGROUND' TO TABLE-ELEMENT-1           
               MOVE 'OH'                   TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5070-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5080-UPDATE-CSR04043-R1-UG.                                    *        
      ******************************************************************        
       5080-UPDATE-CSR04043-R1-UG.                                      
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04043_R1                             
                    SET OVERHEAD_UNDERGROUND = 'UG'                     
                  WHERE WORK_TYPE IN ('S12','S21','S54','S56',          
CSR501                                   'S57','S58', 'ST1')            
                    AND OVERHEAD_UNDERGROUND = ' '                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1                                     
MFA-TR*             SET OVERHEAD_UNDERGROUND = 'UG'                             
MFA-TR*           WHERE WORK_TYPE IN ('S12','S21','S54','S56',                  
MFA-TR*                                  'S57','S58', 'ST1')                    
MFA-TR*             AND OVERHEAD_UNDERGROUND = ' '                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5080'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'OVERHEAD_UNDERGROUND' TO TABLE-ELEMENT-1           
               MOVE 'UG'                   TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5080-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5090-UPDATE-CSR04043-R1-INS.                                   *        
      ******************************************************************        
       5090-UPDATE-CSR04043-R1-INS.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04043_R1                             
                    SET ACTION_CD = 'INSTALL'                           
                  WHERE WORK_TYPE IN ('S11','S12','S54','ST1',          
                                         'S56','S57','S58')             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1                                     
MFA-TR*             SET ACTION_CD = 'INSTALL'                                   
MFA-TR*           WHERE WORK_TYPE IN ('S11','S12','S54','ST1',                  
MFA-TR*                                  'S56','S57','S58')                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5090'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'ACTION_CD'            TO TABLE-ELEMENT-1           
               MOVE 'INSTALL'              TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5090-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5100-UPDATE-CSR04043-R1-REM.                                   *        
      ******************************************************************        
       5100-UPDATE-CSR04043-R1-REM.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04043_R1                             
                    SET ACTION_CD = 'REMOVE'                            
                  WHERE WORK_TYPE IN ('RS2','S20','S21')                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1                                     
MFA-TR*             SET ACTION_CD = 'REMOVE'                                    
MFA-TR*           WHERE WORK_TYPE IN ('RS2','S20','S21')                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5100'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'ACTION_CD'            TO TABLE-ELEMENT-1           
               MOVE 'REMOVE'               TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5110-DELETE-CSR04043-R1-WOR.                                   *        
      ******************************************************************        
       5110-DELETE-CSR04043-R1-WOR.                                     
                                                                        
            EXEC SQL                                                    
                 DELETE FROM #CSR04043_R1                        
                  WHERE WORK_AREA = ' '                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          DELETE FROM SESSION.CSR04043_R1                                
MFA-TR*           WHERE WORK_AREA = ' '                                         
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5110'                 TO ACTIVE-PARAGRAPH          
               MOVE 'DELETE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'WORK_AREA'            TO TABLE-ELEMENT-1           
               MOVE SPACES                 TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5110-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5120-INSERT-CSR04043-R2.                                       *        
      ******************************************************************        
       5120-INSERT-CSR04043-R2.                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04043_R2                          
                   SELECT REGION_ID                                     
                         ,COMPLETE_DATE                                 
                         ,0                                             
                         ,COUNT(OVERHEAD_UNDERGROUND)                   
                     FROM #CSR04043_R1                           
                    WHERE OVERHEAD_UNDERGROUND IN ('UG','OH')           
                    GROUP BY REGION_ID, COMPLETE_DATE                   
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04043_R2                                  
MFA-TR*            SELECT REGION_ID                                             
MFA-TR*                  ,COMPLETE_DATE                                         
MFA-TR*                  ,0                                                     
MFA-TR*                  ,COUNT(OVERHEAD_UNDERGROUND)                           
MFA-TR*              FROM SESSION.CSR04043_R1                                   
MFA-TR*             WHERE OVERHEAD_UNDERGROUND IN ('UG','OH')                   
MFA-TR*             GROUP BY REGION_ID, COMPLETE_DATE                           
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES                 TO S-CURR-VALUE           
                  PERFORM 8100-SEND-RESULT    THRU 8100-EXIT            
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '5120'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04043_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5120-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5130-INSERT-CSR04043-R2-UG.                                    *        
      ******************************************************************        
       5130-INSERT-CSR04043-R2-UG.                                      
            EXEC SQL                                                    
               INSERT INTO #CSR04043_R2                          
                   SELECT REGION_ID                                     
                         ,COMPLETE_DATE                                 
                         ,COUNT(OVERHEAD_UNDERGROUND)                   
                         ,0                                             
                     FROM #CSR04043_R1                           
                    WHERE OVERHEAD_UNDERGROUND = 'UG'                   
                    GROUP BY REGION_ID, COMPLETE_DATE                   
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04043_R2                                  
MFA-TR*            SELECT REGION_ID                                             
MFA-TR*                  ,COMPLETE_DATE                                         
MFA-TR*                  ,COUNT(OVERHEAD_UNDERGROUND)                           
MFA-TR*                  ,0                                                     
MFA-TR*              FROM SESSION.CSR04043_R1                                   
MFA-TR*             WHERE OVERHEAD_UNDERGROUND = 'UG'                           
MFA-TR*             GROUP BY REGION_ID, COMPLETE_DATE                           
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES                 TO S-CURR-VALUE           
                  PERFORM 8100-SEND-RESULT    THRU 8100-EXIT            
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '5130'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04043_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5130-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5140-INSERT-CSR04043-R3.                                       *        
      ******************************************************************        
       5140-INSERT-CSR04043-R3.                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04043_R3                          
                   SELECT REGION_ID                                     
                         ,COMPLETE_DATE                                 
                         ,SUM(UNDER_TOT)                                
                         ,SUM(OU_TOT)                                   
                         ,0                                             
                     FROM #CSR04043_R2                           
                    GROUP BY REGION_ID, COMPLETE_DATE                   
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04043_R3                                  
MFA-TR*            SELECT REGION_ID                                             
MFA-TR*                  ,COMPLETE_DATE                                         
MFA-TR*                  ,SUM(UNDER_TOT)                                        
MFA-TR*                  ,SUM(OU_TOT)                                           
MFA-TR*                  ,0                                                     
MFA-TR*              FROM SESSION.CSR04043_R2                                   
MFA-TR*             GROUP BY REGION_ID, COMPLETE_DATE                           
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES                 TO S-CURR-VALUE           
                  PERFORM 8100-SEND-RESULT    THRU 8100-EXIT            
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '5140'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04043_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5140-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5150-UPDATE-CSR04043-R3.                                       *        
      ******************************************************************        
       5150-UPDATE-CSR04043-R3.                                         
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04043_R3                             
                    SET DIVISOR = ROUND(((UNDER_TOT / OU_TOT) * 10),0)  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R3                                     
MFA-TR*             SET DIVISOR = ROUND(((UNDER_TOT / OU_TOT) * 10),0)          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5150'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R3'          TO TABLE-1                   
               MOVE 'DIVISOR'              TO TABLE-ELEMENT-1           
               MOVE SPACES                 TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5150-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5160-UPDATE-CSR04043-R1-002.                                   *        
      ******************************************************************        
       5160-UPDATE-CSR04043-R1-002.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE SC                           
                    SET SC.OVERHEAD_UNDERGROUND = 'UG'                  
                 FROM #CSR04043_R1 SC
                  WHERE SC.OVERHEAD_UNDERGROUND = ' '                   
                    AND SC.REGION_ID = '002'                            
                    AND EXISTS (SELECT 1 FROM #CSR04043_R3 CNT   
                WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <
                        CNT.DIVISOR                                     
                  AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE              
                  AND SC.REGION_ID = CNT.REGION_ID)                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1 SC                                  
MFA-TR*             SET SC.OVERHEAD_UNDERGROUND = 'UG'                          
MFA-TR*           WHERE SC.OVERHEAD_UNDERGROUND = ' '                           
MFA-TR*             AND SC.REGION_ID = '002'                                    
MFA-TR*             AND EXISTS (SELECT 1 FROM SESSION.CSR04043_R3 CNT           
MFA-TR*         WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <        
MFA-TR*                 CNT.DIVISOR                                             
MFA-TR*           AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE                      
MFA-TR*           AND SC.REGION_ID = CNT.REGION_ID)                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5160'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'REGION'               TO TABLE-ELEMENT-1           
               MOVE '002'                  TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5160-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5170-UPDATE-CSR04043-R1-035.                                   *        
      ******************************************************************        
       5170-UPDATE-CSR04043-R1-035.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE SC                           
                    SET SC.OVERHEAD_UNDERGROUND = 'UG'                  
                 FROM #CSR04043_R1 SC
                  WHERE SC.OVERHEAD_UNDERGROUND = ' '                   
                    AND SC.REGION_ID = '035'                            
                    AND EXISTS (SELECT 1 FROM #CSR04043_R3 CNT   
                WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <
                        CNT.DIVISOR                                     
                  AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE              
                  AND SC.REGION_ID = CNT.REGION_ID)                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1 SC                                  
MFA-TR*             SET SC.OVERHEAD_UNDERGROUND = 'UG'                          
MFA-TR*           WHERE SC.OVERHEAD_UNDERGROUND = ' '                           
MFA-TR*             AND SC.REGION_ID = '035'                                    
MFA-TR*             AND EXISTS (SELECT 1 FROM SESSION.CSR04043_R3 CNT           
MFA-TR*         WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <        
MFA-TR*                 CNT.DIVISOR                                             
MFA-TR*           AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE                      
MFA-TR*           AND SC.REGION_ID = CNT.REGION_ID)                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5170'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'REGION'               TO TABLE-ELEMENT-1           
               MOVE '035'                  TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5170-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5180-UPDATE-CSR04043-R1-050.                                   *        
      ******************************************************************        
       5180-UPDATE-CSR04043-R1-050.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE SC                           
                    SET SC.OVERHEAD_UNDERGROUND = 'UG'                  
                 FROM #CSR04043_R1 SC
                  WHERE SC.OVERHEAD_UNDERGROUND = ' '                   
                    AND SC.REGION_ID = '050'                            
                    AND EXISTS (SELECT 1 FROM #CSR04043_R3 CNT   
                WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <
                        CNT.DIVISOR                                     
                  AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE              
                  AND SC.REGION_ID = CNT.REGION_ID)                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1 SC                                  
MFA-TR*             SET SC.OVERHEAD_UNDERGROUND = 'UG'                          
MFA-TR*           WHERE SC.OVERHEAD_UNDERGROUND = ' '                           
MFA-TR*             AND SC.REGION_ID = '050'                                    
MFA-TR*             AND EXISTS (SELECT 1 FROM SESSION.CSR04043_R3 CNT           
MFA-TR*         WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <        
MFA-TR*                 CNT.DIVISOR                                             
MFA-TR*           AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE                      
MFA-TR*           AND SC.REGION_ID = CNT.REGION_ID)                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5180'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'REGION'               TO TABLE-ELEMENT-1           
               MOVE '050'                  TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5180-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5190-UPDATE-CSR04043-R1-060.                                   *        
      ******************************************************************        
       5190-UPDATE-CSR04043-R1-060.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE SC                           
                    SET SC.OVERHEAD_UNDERGROUND = 'UG'                  
                 FROM #CSR04043_R1 SC
                  WHERE SC.OVERHEAD_UNDERGROUND = ' '                   
                    AND SC.REGION_ID = '060'                            
                    AND EXISTS (SELECT 1 FROM #CSR04043_R3 CNT   
                WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <
                        CNT.DIVISOR                                     
                  AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE              
                  AND SC.REGION_ID = CNT.REGION_ID)                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1 SC                                  
MFA-TR*             SET SC.OVERHEAD_UNDERGROUND = 'UG'                          
MFA-TR*           WHERE SC.OVERHEAD_UNDERGROUND = ' '                           
MFA-TR*             AND SC.REGION_ID = '060'                                    
MFA-TR*             AND EXISTS (SELECT 1 FROM SESSION.CSR04043_R3 CNT           
MFA-TR*         WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <        
MFA-TR*                 CNT.DIVISOR                                             
MFA-TR*           AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE                      
MFA-TR*           AND SC.REGION_ID = CNT.REGION_ID)                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5190'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'REGION'               TO TABLE-ELEMENT-1           
               MOVE '060'                  TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5190-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5200-UPDATE-CSR04043-R1-070.                                   *        
      ******************************************************************        
       5200-UPDATE-CSR04043-R1-070.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE SC                           
                    SET SC.OVERHEAD_UNDERGROUND = 'UG'                  
                 FROM #CSR04043_R1 SC
                  WHERE SC.OVERHEAD_UNDERGROUND = ' '                   
                    AND SC.REGION_ID = '070'                            
                    AND EXISTS (SELECT 1 FROM #CSR04043_R3 CNT   
                WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <
                        CNT.DIVISOR                                     
                  AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE              
                  AND SC.REGION_ID = CNT.REGION_ID)                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1 SC                                  
MFA-TR*             SET SC.OVERHEAD_UNDERGROUND = 'UG'                          
MFA-TR*           WHERE SC.OVERHEAD_UNDERGROUND = ' '                           
MFA-TR*             AND SC.REGION_ID = '070'                                    
MFA-TR*             AND EXISTS (SELECT 1 FROM SESSION.CSR04043_R3 CNT           
MFA-TR*         WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <        
MFA-TR*                 CNT.DIVISOR                                             
MFA-TR*           AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE                      
MFA-TR*           AND SC.REGION_ID = CNT.REGION_ID)                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5200'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'REGION'               TO TABLE-ELEMENT-1           
               MOVE '070'                  TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5200-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5210-UPDATE-CSR04043-R1-090.                                   *        
      ******************************************************************        
       5210-UPDATE-CSR04043-R1-090.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE SC                           
                    SET SC.OVERHEAD_UNDERGROUND = 'UG'                  
                 FROM #CSR04043_R1 SC
                  WHERE SC.OVERHEAD_UNDERGROUND = ' '                   
                    AND SC.REGION_ID = '090'                            
                    AND EXISTS (SELECT 1 FROM #CSR04043_R3 CNT   
                WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <
                        CNT.DIVISOR                                     
                  AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE              
                  AND SC.REGION_ID = CNT.REGION_ID)                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1 SC                                  
MFA-TR*             SET SC.OVERHEAD_UNDERGROUND = 'UG'                          
MFA-TR*           WHERE SC.OVERHEAD_UNDERGROUND = ' '                           
MFA-TR*             AND SC.REGION_ID = '090'                                    
MFA-TR*             AND EXISTS (SELECT 1 FROM SESSION.CSR04043_R3 CNT           
MFA-TR*         WHERE (SC.SERV_ORDER_NO - ((SC.SERV_ORDER_NO/10) *10)) <        
MFA-TR*                 CNT.DIVISOR                                             
MFA-TR*           AND SC.COMPLETE_DATE = CNT.COMPLETE_DATE                      
MFA-TR*           AND SC.REGION_ID = CNT.REGION_ID)                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5210'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'REGION'               TO TABLE-ELEMENT-1           
               MOVE '090'                  TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5210-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5220-UPDATE-CSR04043-R1-LAST.                                  *        
      ******************************************************************        
       5220-UPDATE-CSR04043-R1-LAST.                                    
                                                                        
            EXEC SQL                                                    
                 UPDATE SC                           
                    SET SC.OVERHEAD_UNDERGROUND = 'OH'                  
                 FROM #CSR04043_R1 SC
                  WHERE SC.OVERHEAD_UNDERGROUND = ' '                   
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04043_R1 SC                                  
MFA-TR*             SET SC.OVERHEAD_UNDERGROUND = 'OH'                          
MFA-TR*           WHERE SC.OVERHEAD_UNDERGROUND = ' '                           
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5220'                 TO ACTIVE-PARAGRAPH          
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSR04043_R1'          TO TABLE-1                   
               MOVE 'OVERHEAD_UNDERGROUND' TO TABLE-ELEMENT-1           
               MOVE 'OH'                   TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5220-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
                                                                        
      ******************************************************************        
      *    EXEC SQL                                                             
      *       INCLUDE CPD00300                                                  
      *    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
                                                                        
