                                                                        
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04037.                                            
       DATE-WRITTEN. 04/18/07.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE CALLED FROM CRYSTAL  *        
      *  REPORTS                                                       *        
      *                                                                *        
      *  THIS PROGRAM SELECTS RECORDS FOR REPORTS NEW SERVICE WORKAREA *        
      *  WISE                                                          *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/05/07  GV97034    INITIAL VERSION                          *        
C37253*  06/16/08  FMB        CREATED BINDO CARD FOR REOPT(VARS)       *        
C37261*  06/16/08  FMB        CORRECTED DCLGEN NAMES                   *        
A02983*  01/18/11  SC         CHANGES TO SCHEDULE THE REPORTS MONTHLY  *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04037'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(45) VALUE   
           'WORKING STORAGE FOR SP CSR04037 STARTS HERE'.               
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHSTODR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPREGN                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBWKAREA                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
C37261        INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
C37261        INCLUDE TBWKAR                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPAREA                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GTT-SVC-OUT.                                                 
            05  GTT-NAME                PIC X(26)                       
                    VALUE 'SESSION.CSR04037_R1'.                        
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  GTT-SVC-CNT.                                                 
            05  GTT-NAME                PIC X(26)                       
                    VALUE 'SESSION.CSR04037_R2'.                        
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  GTT-OU-CNT.                                                  
            05  GTT-NAME                PIC X(26)                       
                    VALUE 'SESSION.CSR04037_R3'.                        
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  GTT-OU-CNT1.                                                 
            05  GTT-NAME                PIC X(26)                       
                    VALUE 'SESSION.CSR04037_R4'.                        
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  GTT-WA-MATL.                                                 
            05  GTT-NAME                PIC X(26)                       
                    VALUE 'SESSION.CSR04037_R5'.                        
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  MESSAGE-FIELDS.                                              
            05  MSG-TYPE                     PIC S9(9) COMP.            
            05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.   
            05  MSG-NR                       PIC S9(9) COMP VALUE  2.   
            05  MSG-RPC                      PIC X(4)  VALUE 'S200'.    
            05  MSG-RPC                      PIC X(8)  VALUE 'CSR04037'.
            05  MSG-RPC-L                    PIC S9(9) COMP.            
            05  MSG-TEXT                     PIC X(100).                
            05  MSG-TEXT-L                   PIC S9(9) COMP.            
            05  MSG-SQL-ERROR.                                          
                10  FILLER                   PIC X(10)                  
                                             VALUE 'SQLCODE = '.        
                10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.         
                10  FILLER                   PIC X(16)                  
                                             VALUE ', ERROR TOKENS: '.  
                10  MSG-SQL-ERROR-K          PIC X(70).                 
                10  MSG-SQL-ERROR-K-CHARS                               
                                             REDEFINES MSG-SQL-ERROR-K  
                                             OCCURS 70 TIMES            
                                             PIC X.                     
            05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.            
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
            05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
            05  S-WQ-FLAG               PIC X(01) VALUE 'N'.            
                                                                        
       01  SWITCHES.                                                    
            05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.            
                88 SEND-DONE-ERROR                VALUE 'N'.            
                88 SEND-DONE-OK                   VALUE 'Y'.            
       01  WS-COMPANY-NO                PIC X(2).                       
       01  WS-BEGIN-DT                  PIC X(26).                      
       01  WS-END-DT                    PIC X(26).                      
       01  WS-AREA-ID                   PIC X(3).                       
       01  WS-REGION-ID                 PIC X(3).                       
       01  WS-WORK-AREA-ID              PIC X(12).                      
       01  WS-MIN-DATE                  PIC X(10).                      
       01  WS-MAX-DATE                  PIC X(10).                      
       01  WS-CF-MIN-COMP-DT            PIC X(26).                      
       01  WS-CF-MIN-DT                 PIC X(26).                      
       01  WS-CF-MIN-DT-NULL-IND        PIC S9(4) USAGE COMP VALUE +0.  
       01  WS-CF-MAX-DT                 PIC X(26).                      
       01  WS-HOLIDAY-DT                PIC X(10).                      
       01  WS-HOLIDAY-TS                PIC X(26).                      
       01  WS-TIMESTAMP                 PIC X(16)                       
                                        VALUE '-00.00.00.000000'.       
A02983 01  WS-CURRENT-DATETIME          PIC X(26) VALUE SPACES.         
       01  WS-LAST                      PIC X(6).                       
       01  WS-BEGIN                     PIC X(6).                       
       01  WS-LAST-NUM                  PIC 9(6).                       
       01  WS-BEGIN-NUM                 PIC 9(6).                       
       01  WS-MONTH                     PIC 9(2).                       
       01  WS-YEAR                      PIC 9(4).                       
       01  WS-YEAR-DIG                  PIC X(2).                       
       01  WS-MON                       PIC X(4).                       
       01  WS-YRMON                     PIC X(6).                       
       01  WS-WID                       PIC X(12).                      
       01  WS-RID                       PIC X(3).                       
       01  WS-YRMONTX                   PIC X(6).                       
       01  WS-WTX                       PIC X(40).                      
       01  WS-RTX                       PIC X(32).                      
       01  WS-OLD-YRMON                 PIC X(6).                       
       01  WS-OLD-WID                   PIC X(12).                      
       01  WS-OLD-RID                   PIC X(3).                       
       01  WS-OLD-YRMONTX               PIC X(6).                       
       01  WS-OLD-WTX                   PIC X(40).                      
       01  WS-OLD-RTX                   PIC X(32).                      
       01  WS-CF-MET-FL                 PIC S9(3) usage comp.           
       01  WS-ORDERS                    PIC S9(4) usage comp.           
       01  WS-ORDERS-MET                PIC S9(4) usage comp.           
COB305 01 WS-ROUND-VAL        PIC 9(3)V999 COMP-3 VALUE 0.            
COB305 01 WS-DEC-PERCENT        PIC S9(3)V99 COMP-3 VALUE 0.            
       01  WS-DEC-NUM                   PIC 9(3).99.                    
       01  WS-ACTION-CD                 PIC X(7).                       
A02983 01  WS-TEMP-MONTH                PIC X(2).                       
A02983 01  WS-TEMP-MNTH        REDEFINES WS-TEMP-MONTH                  
A02983                                  PIC S9(2).                      
A02983 01  WS-TEMP-YEAR                 PIC X(4).                       
A02983 01  WS-TEMP-YR          REDEFINES WS-TEMP-YEAR                   
A02983                                  PIC S9(4).                      
A02983 01  WS-QUOTIENT                  PIC 9(04).                      
A02983 01  WS-REMAINDER                 PIC 9(04).                      
       01  WS-CNT                       PIC S9(5) USAGE COMP.           
       01  WS-OVERHEAD                  PIC X(2).                       
       01  WS-SQLSTATE                  PIC X(05) VALUE SPACES.         
       01  CTR-ROWS                     PIC S9(9) COMP VALUE 0.         
       01  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.            
          88 NO-MORE-ROWS               VALUE 'Y'.                      
       01  S-CURR-VALUE                 PIC X(20) VALUE SPACE.          
       01  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04037'.     
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE HOLIDAY_CUR CURSOR FOR                            
                 SELECT HOLIDAY_DT                                      
                   FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                       
                  WHERE COMPANY_NO LIKE :WS-COMPANY-NO                  
                    AND HOLIDAY_DT BETWEEN IIF(TRY_CONVERT(DATE, 
                                                           :WS-MIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-DATE
              ) <> 0) OR (LEN(:WS-MIN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-MIN-DATE
              ), CONVERT(DATE, :WS-MIN-DATE) ) AND 
              IIF(TRY_CONVERT(DATE, :WS-MAX-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-DATE
              ) <> 0) OR (LEN(:WS-MAX-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-MAX-DATE
              ), CONVERT(DATE, :WS-MAX-DATE) )
                    FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE HOLIDAY_CUR CURSOR FOR                                    
MFA-TR*          SELECT HOLIDAY_DT                                              
MFA-TR*            FROM CSS_HOLIDAY                                             
MFA-TR*           WHERE COMPANY_NO LIKE :WS-COMPANY-NO                          
MFA-TR*             AND HOLIDAY_DT BETWEEN :WS-MIN-DATE AND :WS-MAX-DATE        
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE WKAREA_CUR CURSOR FOR                             
                 SELECT YRMON_CD, WORK_AREA_ID, REGION_ID, REGION_TX,   
                        YRMON_TX, WORK_AREA_TX, CF_MET_FL               
                   FROM #CSR04037_R2 WITH(READUNCOMMITTED)                      
                  ORDER BY YRMON_CD, WORK_AREA_ID                       
                    FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WKAREA_CUR CURSOR FOR                                     
MFA-TR*          SELECT YRMON_CD, WORK_AREA_ID, REGION_ID, REGION_TX,           
MFA-TR*                 YRMON_TX, WORK_AREA_TX, CF_MET_FL                       
MFA-TR*            FROM SESSION.CSR04037_R2                                     
MFA-TR*           ORDER BY YRMON_CD, WORK_AREA_ID                               
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-FREQUENCY     PIC X(1).                                 
       01  PARM-COMPANY-NO    PIC X(2).                                 
       01  PARM-BEGIN-DT      PIC X(26).                                
       01  PARM-END-DT        PIC X(26).                                
       01  PARM-REGION-ID     PIC X(3).                                 
       01  PARM-AREA-ID       PIC X(3).                                 
       01  PARM-WORK-AREA-ID  PIC X(12).                                
                                                                        
       PROCEDURE DIVISION USING PARM-FREQUENCY                          
                                PARM-COMPANY-NO                         
                                PARM-BEGIN-DT                           
                                PARM-END-DT                             
                                PARM-REGION-ID                          
                                PARM-AREA-ID                            
                                PARM-WORK-AREA-ID.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                 
            PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                 
            PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                 
            PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                 
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
            EXEC SQL                                                    
                WHENEVER SQLWARNING CONTINUE                            
            END-EXEC.                                                   
            EXEC SQL                                                    
                WHENEVER SQLERROR   CONTINUE                            
            END-EXEC.                                                   
            EXEC SQL                                                    
                WHENEVER NOT FOUND  CONTINUE                            
            END-EXEC.                                                   
                                                                        
            PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                  
                                                                        
            EXEC SQL                                                    
               DECLARE C1 CURSOR  FOR                        
                  SELECT YRMON_TX                                       
                        ,REGION_TX                                      
                        ,WORK_AREA_TX                                   
                        ,TOTAL_ORDERS                                   
                        ,ORDERS_MET                                     
                        ,PERCENT_XY                                     
                        ,YRMON_CD                                       
                    FROM #CSR04037_R4                            
                    ORDER BY YRMON_CD, REGION_TX, WORK_AREA_TX          
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*           SELECT YRMON_TX                                               
MFA-TR*                 ,REGION_TX                                              
MFA-TR*                 ,WORK_AREA_TX                                           
MFA-TR*                 ,TOTAL_ORDERS                                           
MFA-TR*                 ,ORDERS_MET                                             
MFA-TR*                 ,PERCENT_XY                                             
MFA-TR*                 ,YRMON_CD                                               
MFA-TR*             FROM SESSION.CSR04037_R4                                    
MFA-TR*             ORDER BY YRMON_CD, REGION_TX, WORK_AREA_TX                  
MFA-TR*     END-EXEC.                                                           
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT************************************************        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04037_R1'            
                                                TO S-SQL-STATEMENT-V.   
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04037_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04037_R1
              (                                                       
                   YRMON_TX CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,REGION_TX CHAR(32)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,TOTAL_ORDERS          INT                        
                  ,ORDERS_MET            INT                        
                  ,PERCENT_XY            DECIMAL(5,2)                   
                  ,YRMON_CD CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2            
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE SQLCODE            TO ABEND-SQLCODE                  
              MOVE SQLSTATE           TO ABEND-SQLSTATE                 
              MOVE '0100A'            TO ACTIVE-PARAGRAPH               
              MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR04037_R1'      TO TABLE-1                        
              MOVE SPACES             TO TABLE-ELEMENT-1                
              MOVE SPACES             TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                      THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04037_R2'            
                                      TO S-SQL-STATEMENT-V.             
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04037_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04037_R2
              (                                                         
                 SERV_ORDER_NO           DECIMAL(13,0)                  
                ,REGION_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2             
                ,REGION_TX CHAR(32)  COLLATE LATIN1_GENERAL_100_BIN2            
                ,AREA_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2               
                ,AREA_TX CHAR(32)  COLLATE LATIN1_GENERAL_100_BIN2              
                ,WORK_AREA_ID CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,WORK_AREA_TX CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,ORDER_TYPE_CD CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,ORDER_TYPE_DESC CHAR(15)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                       
                ,WORK_TYPE_CD CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,WORK_TYPE_DESC CHAR(25)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                       
                ,RELEASE_DATE            DATETIME2(6)                      
                ,WANTED_DATE             DATETIME2(6)                      
                ,COMPLETED_DATE          DATETIME2(6)                      
                ,YRMON_CD CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2              
                ,YRMON_TX CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2              
                ,GOAL                    INT                        
                ,HOLADJ                  INT                        
                ,CF_WANTED_FL            INT                        
                ,CF_DATEDIFF             INT                        
                ,CF_DOWADJ               INT                        
                ,CF_WKENDADJ             INT                        
                ,CF_NBD                  INT                        
                ,CF_RECEIVED_FL          INT                        
                ,CF_MET_FL               INT                        
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE SQLCODE            TO ABEND-SQLCODE                  
              MOVE SQLSTATE           TO ABEND-SQLSTATE                 
              MOVE '0100A'            TO ACTIVE-PARAGRAPH               
              MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR04037_R2'      TO TABLE-1                        
              MOVE SPACES             TO TABLE-ELEMENT-1                
              MOVE SPACES             TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                      THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04037_R3'            
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04037_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04037_R3
              (                                                        
                  YRMON_TX CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2             
                 ,YRMON_CD CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2             
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE SQLCODE            TO ABEND-SQLCODE                  
              MOVE SQLSTATE           TO ABEND-SQLSTATE                 
              MOVE '0100A'            TO ACTIVE-PARAGRAPH               
              MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR04037_R3'      TO TABLE-1                        
              MOVE SPACES             TO TABLE-ELEMENT-1                
              MOVE SPACES             TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                      THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04037_R4'            
                                      TO S-SQL-STATEMENT-V.             
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04037_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04037_R4
              (                                                         
                 YRMON_CD CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2              
                ,YRMON_TX CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2              
                ,REGION_TX CHAR(32)  COLLATE LATIN1_GENERAL_100_BIN2            
                ,WORK_AREA_TX CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,TOTAL_ORDERS            INT                        
                ,ORDERS_MET              INT                        
                ,PERCENT_XY              DECIMAL(5,2)                   
                ,WORK_AREA_ID CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,REGION_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2             
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE SQLCODE            TO ABEND-SQLCODE                  
              MOVE SQLSTATE           TO ABEND-SQLSTATE                 
              MOVE '0100A'            TO ACTIVE-PARAGRAPH               
              MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR04037_R4'      TO TABLE-1                        
              MOVE SPACES             TO TABLE-ELEMENT-1                
              MOVE SPACES             TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                      THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04037_R5'            
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04037_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04037_R5
              (                                                         
                 REGION_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2             
                ,REGION_TX CHAR(32)  COLLATE LATIN1_GENERAL_100_BIN2            
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE SQLCODE            TO ABEND-SQLCODE                  
              MOVE SQLSTATE           TO ABEND-SQLSTATE                 
              MOVE '0100A'            TO ACTIVE-PARAGRAPH               
              MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR04037_R5'      TO TABLE-1                        
              MOVE SPACES             TO TABLE-ELEMENT-1                
              MOVE SPACES             TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                      THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
            MOVE PARM-COMPANY-NO         TO WS-COMPANY-NO.              
A02983      IF PARM-FREQUENCY = 'O' THEN                                
            MOVE PARM-BEGIN-DT           TO WS-BEGIN-DT                 
            MOVE PARM-END-DT             TO WS-END-DT                   
A02983      ELSE                                                        
A02983       EXEC SQL                                                   
A02983          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATETIME           
A02983       END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SET :WS-CURRENT-DATETIME  = CURRENT TIMESTAMP                   
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02983        MOVE '0000-00-00-00.00.00.000000' TO PARM-BEGIN-DT        
A02983                                             PARM-END-DT          
A02983        MOVE WS-CURRENT-DATETIME(1:10)    TO PARM-BEGIN-DT(1:10)  
A02983                                             PARM-END-DT(1:10)    
A02983        MOVE WS-CURRENT-DATETIME(6:2)    TO WS-TEMP-MONTH         
A02983        MOVE WS-CURRENT-DATETIME(1:4)    TO WS-TEMP-YEAR          
A02983        IF WS-TEMP-MONTH = '01' THEN                              
A02983           MOVE  '12'                   TO PARM-BEGIN-DT(6:2)     
A02983                                           PARM-END-DT(6:2)       
A02983                                           WS-TEMP-MONTH          
A02983           SUBTRACT      1     FROM WS-TEMP-YR                    
A02983           MOVE  WS-TEMP-YR       TO PARM-BEGIN-DT(1:4)           
A02983                                     PARM-END-DT(1:4)             
A02983         ELSE                                                     
A02983            SUBTRACT     1 FROM WS-TEMP-MNTH                      
A02983            MOVE WS-TEMP-MNTH            TO PARM-BEGIN-DT(6:2)    
A02983                                            PARM-END-DT(6:2)      
A02983          END-IF                                                  
A02983        IF WS-TEMP-MNTH = 2 THEN                                  
A02983            PERFORM 5130-CHECK-LEAP-YEAR      THRU 5130-EXIT      
A02983         ELSE                                                     
A02983           IF WS-TEMP-MNTH = 4 OR WS-TEMP-MNTH = 6 OR             
A02983             WS-TEMP-MNTH = 9 OR WS-TEMP-MNTH = 11 THEN           
A02983         MOVE '30'                 TO PARM-END-DT(9:2)            
A02983        ELSE                                                      
A02983         MOVE '31'                 TO PARM-END-DT(9:2)            
A02983         END-IF                                                   
A02983       END-IF                                                     
A02983         MOVE '01'                 TO PARM-BEGIN-DT(9:2)          
A02983         MOVE PARM-BEGIN-DT        TO WS-BEGIN-DT                 
A02983         MOVE PARM-END-DT          TO WS-END-DT                   
A02983       END-IF                                                     
                                                                        
            MOVE PARM-REGION-ID          TO WS-REGION-ID.               
            MOVE PARM-AREA-ID            TO WS-AREA-ID.                 
            MOVE PARM-WORK-AREA-ID       TO WS-WORK-AREA-ID.            
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
            IF WS-REGION-ID = SPACES                                    
               MOVE '%%%'                 TO WS-REGION-ID               
            END-IF.                                                     
            IF WS-AREA-ID = SPACES                                      
               MOVE '%%%'                 TO WS-AREA-ID                 
            END-IF.                                                     
            IF WS-WORK-AREA-ID = SPACES                                 
               MOVE '%%%%%%%%%%%%'        TO WS-WORK-AREA-ID            
            END-IF.                                                     
            PERFORM 5000-INSERT-CSR04037-R2        THRU 5000-EXIT.      
            PERFORM 5010-UPDATE-CSR04037-R2        THRU 5010-EXIT.      
            PERFORM 5015-UPDATE-CSR04037-R2-WKEND  THRU 5015-EXIT.      
            PERFORM 5020-SELECT-CSR04037-R2        THRU 5020-EXIT.      
            IF WS-CF-MIN-DT-NULL-IND = -1                               
               MOVE WS-CF-MIN-COMP-DT(1:10)        TO WS-MIN-DATE       
            ELSE                                                        
               MOVE WS-CF-MIN-DT(1:10)             TO WS-MIN-DATE       
            END-IF.                                                     
            MOVE WS-CF-MAX-DT(1:10)                TO WS-MAX-DATE.      
            PERFORM 7000-OPEN-HOLIDAY-CUR          THRU 7000-EXIT.      
            PERFORM 7010-FETCH-HOLIDAY-CUR         THRU 7010-EXIT.      
            PERFORM 5030-PROCESS-HOLIDAY-CUR       THRU 5030-EXIT       
                                                   UNTIL NO-MORE-ROWS.  
            PERFORM 7020-CLOSE-HOLIDAY-CUR         THRU 7020-EXIT.      
            PERFORM 5040-UPDATE-CSR04037-R2-NBD    THRU 5040-EXIT.      
            PERFORM 5050-UPDATE-CSR04037-R2-REC-FL THRU 5050-EXIT.      
            PERFORM 5060-UPDATE-CSR04037-R2-MET-FL THRU 5060-EXIT.      
            PERFORM 5070-BUILD-SERIES              THRU 5070-EXIT.      
            PERFORM 7030-OPEN-WKAREA-CUR           THRU 7030-EXIT.      
            PERFORM 7040-FETCH-WKAREA-CUR          THRU 7040-EXIT.      
            PERFORM 5090-MOVE-WKAREA-DATA          THRU 5090-EXIT.      
            PERFORM 5100-PROCESS-WKAREA-CUR        THRU 5100-EXIT       
                                                   UNTIL NO-MORE-ROWS.  
            PERFORM 7050-CLOSE-WKAREA-CUR          THRU 7050-EXIT.      
            PERFORM 5110-POST-PROCESS-WKAREA-CUR   THRU 5110-EXIT.      
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5000-INSERT-CSR04037-R2.                                       *        
      ******************************************************************        
       5000-INSERT-CSR04037-R2.                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04037_R2                          
                   SELECT CSO.SERV_ORDER_NO                             
                         ,OOR.REGION_ID                                 
                         ,OOR.REGION_TX                                 
                         ,OOA.AREA_ID                                   
                         ,OOA.AREA_TX                                   
                         ,CWA.WORK_AREA_ID                              
                         ,CWA.WORK_AREA_TX                              
                         ,CSO.ORDER_TYPE_CD                             
                         ,COT.ORDER_TYPE_DESC                           
                         ,SOI.WORK_TYPE_CD                              
                         ,CWT.WORK_TYPE_DESC                            
                         ,COALESCE(SOI.RLSE_DATE,                       
                          
           CIS.CHAR2TIMESTAMP('1900-01-01-00.00.00.000000'))      
                         ,WANTED_BY_DATETIME                            
                         ,COMPLETED_DATETIME                            
                         ,LTRIM(RTRIM(CIS.INT2CHAR(YEAR(
           CSO.COMPLETED_DATETIME)))) + SUBSTRING(REPLACE(REPLACE(
           CONVERT(CHAR(26), CSO.COMPLETED_DATETIME, 121), ' ', '-'), 
           ':', '.'), 6, 2)      
            ,((CASE                                                     
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 1 THEN 'JAN'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 2 THEN 'FEB'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 3 THEN 'MAR'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 4 THEN 'APR'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 5 THEN 'MAY'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 6 THEN 'JUN'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 7 THEN 'JUL'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 8 THEN 'AUG'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 9 THEN 'SEP'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 10 THEN 'OCT'     
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 11 THEN 'NOV'     
                 WHEN MONTH(CSO.COMPLETED_DATETIME
           ) = 12 THEN 'DEC' END) + '-' + CIS.SUBSTR3$(CIS.INT2CHAR(           
                          YEAR(CSO.COMPLETED_DATETIME)), 3, 2))           
                         ,1                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                     FROM CSS_WORK_AREA_MATL     WAM                    
                         ,CSS_SO_DATA            CSO                    
                         ,CSS_SO_ORDER_INST      SOI                    
                         ,CSS_WORK_AREA          CWA                    
                         ,CSS_ORDER_TYPE         COT                    
                         ,CSS_WORK_TYPE          CWT                    
                         ,CSS_OP_REGION          OOR                    
                         ,CSS_OP_AREA            OOA                    
                    WHERE (CSO.COMPANY_NO   =    :WS-COMPANY-NO)        
                      AND (WAM.REGION_ID    LIKE :WS-REGION-ID)         
                      AND (WAM.AREA_ID      LIKE :WS-AREA-ID)           
                      AND (WAM.WORK_AREA_ID LIKE :WS-WORK-AREA-ID)      
                      AND (CSO.WORK_AREA_ID = WAM.WORK_AREA_ID)         
                      AND (CSO.COMPLETED_DATETIME IS NOT NULL)          
                      AND ((CSO.COMPLETED_DATETIME                      
                  BETWEEN CIS.CHAR2TIMESTAMP(:WS-BEGIN-DT) AND 
              CIS.CHAR2TIMESTAMP(:WS-END-DT))                  
                      AND (CSO.ORDER_STATE_CD IN ('A','Z')))            
                      AND (SOI.SERV_ORDER_NO = CSO.SERV_ORDER_NO)       
                      AND (SOI.CODE_UTIL_TYPE = 'E')                    
                      AND (SOI.WORK_TYPE_CD IN                          
                          ('SET', 'SOS', 'ST1', 'ST3'))                 
                      AND NOT (SOI.RLSE_DATE IS NULL                    
                      AND CSO.WANTED_BY_DATETIME IS NULL)               
                      AND (CWA.WORK_AREA_ID = WAM.WORK_AREA_ID)         
                      AND (CWA.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (COT.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (COT.ORDER_TYPE_CD = CSO.ORDER_TYPE_CD)       
                      AND (CWT.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (CWT.WORK_TYPE_CD = SOI.WORK_TYPE_CD)         
                      AND (OOA.REGION_ID = WAM.REGION_ID)               
                      AND (OOA.AREA_ID   = WAM.AREA_ID)                 
                      AND (OOR.REGION_ID = WAM.REGION_ID)               
                   UNION                                                
                   SELECT CSO.SERV_ORDER_NO                             
                         ,OOR.REGION_ID                                 
                         ,OOR.REGION_TX                                 
                         ,OOA.AREA_ID                                   
                         ,OOA.AREA_TX                                   
                         ,CWA.WORK_AREA_ID                              
                         ,CWA.WORK_AREA_TX                              
                         ,CSO.ORDER_TYPE_CD                             
                         ,COT.ORDER_TYPE_DESC                           
                         ,SOI.WORK_TYPE_CD                              
                         ,CWT.WORK_TYPE_DESC                            
                         ,COALESCE(SOI.RLSE_DATE,                       
                          
           CIS.CHAR2TIMESTAMP('1900-01-01-00.00.00.000000'))      
                         ,WANTED_BY_DATETIME                            
                         ,COMPLETED_DATETIME                            
                         ,LTRIM(RTRIM(CIS.INT2CHAR(YEAR(
           CSO.COMPLETED_DATETIME)))) + SUBSTRING(REPLACE(REPLACE(
           CONVERT(CHAR(26), CSO.COMPLETED_DATETIME, 121), ' ', '-'), 
           ':', '.'), 6, 2)      
            ,((CASE                                                     
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 1 THEN 'JAN'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 2 THEN 'FEB'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 3 THEN 'MAR'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 4 THEN 'APR'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 5 THEN 'MAY'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 6 THEN 'JUN'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 7 THEN 'JUL'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 8 THEN 'AUG'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 9 THEN 'SEP'      
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 10 THEN 'OCT'     
                 WHEN MONTH(CSO.COMPLETED_DATETIME) = 11 THEN 'NOV'     
                 WHEN MONTH(CSO.COMPLETED_DATETIME
           ) = 12 THEN 'DEC' END) + '-' + CIS.SUBSTR3$(CIS.INT2CHAR(           
                          YEAR(CSO.COMPLETED_DATETIME)), 3, 2))           
                         ,1                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                     FROM CSS_WORK_AREA_MATL         WAM                
                         ,HST_SO_DATA                CSO                
                         ,HST_SO_ORDER_INST          SOI                
                         ,CSS_WORK_AREA              CWA                
                         ,CSS_ORDER_TYPE             COT                
                         ,CSS_WORK_TYPE              CWT                
                         ,CSS_OP_REGION              OOR                
                         ,CSS_OP_AREA                OOA                
                    WHERE (CSO.COMPANY_NO   =    :WS-COMPANY-NO)        
                      AND (WAM.REGION_ID    LIKE :WS-REGION-ID)         
                      AND (WAM.AREA_ID      LIKE :WS-AREA-ID)           
                      AND (WAM.WORK_AREA_ID LIKE :WS-WORK-AREA-ID)      
                      AND (CSO.WORK_AREA_ID = WAM.WORK_AREA_ID)         
                      AND (CSO.COMPLETED_DATETIME IS NOT NULL)          
                      AND ((CSO.COMPLETED_DATETIME                      
                  BETWEEN CIS.CHAR2TIMESTAMP(:WS-BEGIN-DT) AND 
              CIS.CHAR2TIMESTAMP(:WS-END-DT))                  
                      AND (CSO.ORDER_STATE_CD IN ('A','Z')))            
                      AND (SOI.SERV_ORDER_NO = CSO.SERV_ORDER_NO)       
                      AND (SOI.CODE_UTIL_TYPE = 'E')                    
                      AND (SOI.WORK_TYPE_CD IN                          
                          ('SET', 'SOS', 'ST1', 'ST3'))                 
                      AND NOT (SOI.RLSE_DATE IS NULL                    
                      AND CSO.WANTED_BY_DATETIME IS NULL)               
                      AND (CWA.WORK_AREA_ID = WAM.WORK_AREA_ID)         
                      AND (CWA.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (COT.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (COT.ORDER_TYPE_CD = CSO.ORDER_TYPE_CD)       
                      AND (CWT.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (CWT.WORK_TYPE_CD = SOI.WORK_TYPE_CD)         
                      AND (OOA.REGION_ID = WAM.REGION_ID)               
                      AND (OOA.AREA_ID   = WAM.AREA_ID)                 
                      AND (OOR.REGION_ID = WAM.REGION_ID)               
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04037_R2                                  
MFA-TR*            SELECT CSO.SERV_ORDER_NO                                     
MFA-TR*                  ,OOR.REGION_ID                                         
MFA-TR*                  ,OOR.REGION_TX                                         
MFA-TR*                  ,OOA.AREA_ID                                           
MFA-TR*                  ,OOA.AREA_TX                                           
MFA-TR*                  ,CWA.WORK_AREA_ID                                      
MFA-TR*                  ,CWA.WORK_AREA_TX                                      
MFA-TR*                  ,CSO.ORDER_TYPE_CD                                     
MFA-TR*                  ,COT.ORDER_TYPE_DESC                                   
MFA-TR*                  ,SOI.WORK_TYPE_CD                                      
MFA-TR*                  ,CWT.WORK_TYPE_DESC                                    
MFA-TR*                  ,COALESCE(SOI.RLSE_DATE,                               
MFA-TR*                   TIMESTAMP('1900-01-01-00.00.00.000000'))              
MFA-TR*                  ,WANTED_BY_DATETIME                                    
MFA-TR*                  ,COMPLETED_DATETIME                                    
MFA-TR*                  ,STRIP(CHAR(YEAR(CSO.COMPLETED_DATETIME))) ||          
MFA-TR*                   SUBSTR(CHAR(CSO.COMPLETED_DATETIME),6,2)              
MFA-TR*     ,((CASE                                                             
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 1 THEN 'JAN'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 2 THEN 'FEB'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 3 THEN 'MAR'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 4 THEN 'APR'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 5 THEN 'MAY'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 6 THEN 'JUN'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 7 THEN 'JUL'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 8 THEN 'AUG'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 9 THEN 'SEP'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 10 THEN 'OCT'             
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 11 THEN 'NOV'             
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 12 THEN 'DEC' END)        
MFA-TR*                   || '-' ||                                             
MFA-TR*                   SUBSTR(CHAR(                                          
MFA-TR*                   YEAR(CSO.COMPLETED_DATETIME)),3,2))                   
MFA-TR*                  ,1                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*              FROM CSS_WORK_AREA_MATL     WAM                            
MFA-TR*                  ,CSS_SO_DATA            CSO                            
MFA-TR*                  ,CSS_SO_ORDER_INST      SOI                            
MFA-TR*                  ,CSS_WORK_AREA          CWA                            
MFA-TR*                  ,CSS_ORDER_TYPE         COT                            
MFA-TR*                  ,CSS_WORK_TYPE          CWT                            
MFA-TR*                  ,CSS_OP_REGION          OOR                            
MFA-TR*                  ,CSS_OP_AREA            OOA                            
MFA-TR*             WHERE (CSO.COMPANY_NO   =    :WS-COMPANY-NO)                
MFA-TR*               AND (WAM.REGION_ID    LIKE :WS-REGION-ID)                 
MFA-TR*               AND (WAM.AREA_ID      LIKE :WS-AREA-ID)                   
MFA-TR*               AND (WAM.WORK_AREA_ID LIKE :WS-WORK-AREA-ID)              
MFA-TR*               AND (CSO.WORK_AREA_ID = WAM.WORK_AREA_ID)                 
MFA-TR*               AND (CSO.COMPLETED_DATETIME IS NOT NULL)                  
MFA-TR*               AND ((CSO.COMPLETED_DATETIME                              
MFA-TR*           BETWEEN :WS-BEGIN-DT AND :WS-END-DT)                          
MFA-TR*               AND (CSO.ORDER_STATE_CD IN ('A','Z')))                    
MFA-TR*               AND (SOI.SERV_ORDER_NO = CSO.SERV_ORDER_NO)               
MFA-TR*               AND (SOI.CODE_UTIL_TYPE = 'E')                            
MFA-TR*               AND (SOI.WORK_TYPE_CD IN                                  
MFA-TR*                   ('SET', 'SOS', 'ST1', 'ST3'))                         
MFA-TR*               AND NOT (SOI.RLSE_DATE IS NULL                            
MFA-TR*               AND CSO.WANTED_BY_DATETIME IS NULL)                       
MFA-TR*               AND (CWA.WORK_AREA_ID = WAM.WORK_AREA_ID)                 
MFA-TR*               AND (CWA.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (COT.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (COT.ORDER_TYPE_CD = CSO.ORDER_TYPE_CD)               
MFA-TR*               AND (CWT.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (CWT.WORK_TYPE_CD = SOI.WORK_TYPE_CD)                 
MFA-TR*               AND (OOA.REGION_ID = WAM.REGION_ID)                       
MFA-TR*               AND (OOA.AREA_ID   = WAM.AREA_ID)                         
MFA-TR*               AND (OOR.REGION_ID = WAM.REGION_ID)                       
MFA-TR*            UNION                                                        
MFA-TR*            SELECT CSO.SERV_ORDER_NO                                     
MFA-TR*                  ,OOR.REGION_ID                                         
MFA-TR*                  ,OOR.REGION_TX                                         
MFA-TR*                  ,OOA.AREA_ID                                           
MFA-TR*                  ,OOA.AREA_TX                                           
MFA-TR*                  ,CWA.WORK_AREA_ID                                      
MFA-TR*                  ,CWA.WORK_AREA_TX                                      
MFA-TR*                  ,CSO.ORDER_TYPE_CD                                     
MFA-TR*                  ,COT.ORDER_TYPE_DESC                                   
MFA-TR*                  ,SOI.WORK_TYPE_CD                                      
MFA-TR*                  ,CWT.WORK_TYPE_DESC                                    
MFA-TR*                  ,COALESCE(SOI.RLSE_DATE,                               
MFA-TR*                   TIMESTAMP('1900-01-01-00.00.00.000000'))              
MFA-TR*                  ,WANTED_BY_DATETIME                                    
MFA-TR*                  ,COMPLETED_DATETIME                                    
MFA-TR*                  ,STRIP(CHAR(YEAR(CSO.COMPLETED_DATETIME))) ||          
MFA-TR*                   SUBSTR(CHAR(CSO.COMPLETED_DATETIME),6,2)              
MFA-TR*     ,((CASE                                                             
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 1 THEN 'JAN'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 2 THEN 'FEB'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 3 THEN 'MAR'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 4 THEN 'APR'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 5 THEN 'MAY'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 6 THEN 'JUN'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 7 THEN 'JUL'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 8 THEN 'AUG'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 9 THEN 'SEP'              
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 10 THEN 'OCT'             
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 11 THEN 'NOV'             
MFA-TR*          WHEN MONTH(CSO.COMPLETED_DATETIME) = 12 THEN 'DEC' END)        
MFA-TR*                   || '-' ||                                             
MFA-TR*                   SUBSTR(CHAR(                                          
MFA-TR*                   YEAR(CSO.COMPLETED_DATETIME)),3,2))                   
MFA-TR*                  ,1                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*              FROM CSS_WORK_AREA_MATL         WAM                        
MFA-TR*                  ,HST_SO_DATA                CSO                        
MFA-TR*                  ,HST_SO_ORDER_INST          SOI                        
MFA-TR*                  ,CSS_WORK_AREA              CWA                        
MFA-TR*                  ,CSS_ORDER_TYPE             COT                        
MFA-TR*                  ,CSS_WORK_TYPE              CWT                        
MFA-TR*                  ,CSS_OP_REGION              OOR                        
MFA-TR*                  ,CSS_OP_AREA                OOA                        
MFA-TR*             WHERE (CSO.COMPANY_NO   =    :WS-COMPANY-NO)                
MFA-TR*               AND (WAM.REGION_ID    LIKE :WS-REGION-ID)                 
MFA-TR*               AND (WAM.AREA_ID      LIKE :WS-AREA-ID)                   
MFA-TR*               AND (WAM.WORK_AREA_ID LIKE :WS-WORK-AREA-ID)              
MFA-TR*               AND (CSO.WORK_AREA_ID = WAM.WORK_AREA_ID)                 
MFA-TR*               AND (CSO.COMPLETED_DATETIME IS NOT NULL)                  
MFA-TR*               AND ((CSO.COMPLETED_DATETIME                              
MFA-TR*           BETWEEN :WS-BEGIN-DT AND :WS-END-DT)                          
MFA-TR*               AND (CSO.ORDER_STATE_CD IN ('A','Z')))                    
MFA-TR*               AND (SOI.SERV_ORDER_NO = CSO.SERV_ORDER_NO)               
MFA-TR*               AND (SOI.CODE_UTIL_TYPE = 'E')                            
MFA-TR*               AND (SOI.WORK_TYPE_CD IN                                  
MFA-TR*                   ('SET', 'SOS', 'ST1', 'ST3'))                         
MFA-TR*               AND NOT (SOI.RLSE_DATE IS NULL                            
MFA-TR*               AND CSO.WANTED_BY_DATETIME IS NULL)                       
MFA-TR*               AND (CWA.WORK_AREA_ID = WAM.WORK_AREA_ID)                 
MFA-TR*               AND (CWA.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (COT.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (COT.ORDER_TYPE_CD = CSO.ORDER_TYPE_CD)               
MFA-TR*               AND (CWT.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (CWT.WORK_TYPE_CD = SOI.WORK_TYPE_CD)                 
MFA-TR*               AND (OOA.REGION_ID = WAM.REGION_ID)                       
MFA-TR*               AND (OOA.AREA_ID   = WAM.AREA_ID)                         
MFA-TR*               AND (OOR.REGION_ID = WAM.REGION_ID)                       
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES                 TO S-CURR-VALUE           
                  PERFORM 8100-SEND-RESULT    THRU 8100-EXIT            
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '5000'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04037_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5010-UPDATE-CSR04037-R2.                                       *        
      ******************************************************************        
       5010-UPDATE-CSR04037-R2.                                         
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04037_R2                             
                    SET CF_WANTED_FL = (CASE WHEN (CIS.DAYS(WANTED_DATE)    
                        - CIS.DAYS(
           COMPLETED_DATE)) >= 0 THEN 1 ELSE 0 END),
                        CF_DATEDIFF  = (CIS.DAYS(COMPLETED_DATE) -          
                        CIS.DAYS(RELEASE_DATE)),                            
                        CF_DOWADJ    = (CASE                            
                        WHEN CIS.DAYOFWEEK(RELEASE_DATE) = 7 THEN 1         
                        ELSE 0 END)                                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04037_R2                                     
MFA-TR*             SET CF_WANTED_FL = (CASE WHEN (DAYS(WANTED_DATE)            
MFA-TR*                 - DAYS(COMPLETED_DATE)) >= 0 THEN 1 ELSE 0 END),        
MFA-TR*                 CF_DATEDIFF  = (DAYS(COMPLETED_DATE) -                  
MFA-TR*                 DAYS(RELEASE_DATE)),                                    
MFA-TR*                 CF_DOWADJ    = (CASE                                    
MFA-TR*                 WHEN DAYOFWEEK(RELEASE_DATE) = 7 THEN 1                 
MFA-TR*                 ELSE 0 END)                                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5010'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04037_R2'         TO TABLE-1                    
               MOVE 'CF_WANTED_FL'        TO TABLE-ELEMENT-1            
               MOVE 'DATEDIFF'            TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5015-UPDATE-CSR04037-R2-WKEND.                                 *        
      ******************************************************************        
       5015-UPDATE-CSR04037-R2-WKEND.                                   
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04037_R2                             
                    SET CF_WKENDADJ  = ((CIS.DAYOFWEEK(RELEASE_DATE) + 
           CF_DATEDIFF) / 7 ) 
                        * 2                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR* MSQ051
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04037_R2                                     
MFA-TR*             SET CF_WKENDADJ  = CAST(                                    
MFA-TR*                 (((DAYOFWEEK(RELEASE_DATE) + CF_DATEDIFF) / 7 )         
MFA-TR*                 * 2) AS INTEGER)                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5015'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04037_R2'         TO TABLE-1                    
               MOVE 'CF_WKENDADJ'         TO TABLE-ELEMENT-1            
               MOVE 'CF_WKENDADJ'         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5015-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5020-SELECT-CSR04037-R2.                                       *        
      ******************************************************************        
       5020-SELECT-CSR04037-R2.                                         
                                                                        
            EXEC SQL                                                    
                 SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MIN(
           COMPLETED_DATE), 121), ' ', '-'), ':', '.'), REPLACE(
           REPLACE(CONVERT(CHAR(26), MIN(RELEASE_DATE), 121), ' ', 
           '-'), ':', '.'),         
                        REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           COMPLETED_DATE), 121), ' ', '-'), ':', '.')                         
                   INTO :WS-CF-MIN-COMP-DT,                             
                        :WS-CF-MIN-DT :WS-CF-MIN-DT-NULL-IND,           
                        :WS-CF-MAX-DT                                   
                   FROM #CSR04037_R2                             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT MIN(COMPLETED_DATE), MIN(RELEASE_DATE),                 
MFA-TR*                 MAX(COMPLETED_DATE)                                     
MFA-TR*            INTO :WS-CF-MIN-COMP-DT,                                     
MFA-TR*                 :WS-CF-MIN-DT :WS-CF-MIN-DT-NULL-IND,                   
MFA-TR*                 :WS-CF-MAX-DT                                           
MFA-TR*            FROM SESSION.CSR04037_R2                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5020'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSR04037_R2'         TO TABLE-1                    
               MOVE 'CF_MIN_MAX_DT'       TO TABLE-ELEMENT-1            
               MOVE 'CF-MIN-MAX-DT'       TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5020-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      * 7000-OPEN-HOLIDAY-CUR.                                        *         
      *****************************************************************         
       7000-OPEN-HOLIDAY-CUR.                                           
                                                                        
            EXEC SQL                                                    
                 OPEN HOLIDAY_CUR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7000'                      TO ACTIVE-PARAGRAPH     
               MOVE 'OPEN'                      TO ABEND-FUNCTION       
               MOVE 'CSS_HOLIDAY'               TO TABLE-1              
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7010-FETCH-HOLIDAY-CUR.                                       *         
      *****************************************************************         
       7010-FETCH-HOLIDAY-CUR.                                          
                                                                        
            EXEC SQL                                                    
                 FETCH HOLIDAY_CUR                                      
                  INTO :WS-HOLIDAY-DT                                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE. 
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE 'Y'                       TO WS-NO-MORE-ROWS     
               END-IF                                                   
            ELSE                                                        
                MOVE PROGRAM-NAME                TO ABEND-PROGRAM       
                MOVE '7010'                      TO ACTIVE-PARAGRAPH    
                MOVE 'FETCH'                     TO ABEND-FUNCTION      
                MOVE 'CSS_HOLIDAY'               TO TABLE-1             
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7020-CLOSE-HOLIDAY-CUR.                                       *         
      *****************************************************************         
       7020-CLOSE-HOLIDAY-CUR.                                          
                                                                        
            EXEC SQL                                                    
                 CLOSE HOLIDAY_CUR                                      
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7020'                      TO ACTIVE-PARAGRAPH     
               MOVE 'CLOSE'                     TO ABEND-FUNCTION       
               MOVE 'CSS_HOLIDAY'               TO TABLE-1              
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7020-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5030-PROCESS-HOLIDAY-CUR.                                      *        
      ******************************************************************        
       5030-PROCESS-HOLIDAY-CUR.                                        
                                                                        
           STRING WS-HOLIDAY-DT, WS-TIMESTAMP DELIMITED BY SIZE         
                  INTO WS-HOLIDAY-TS.                                   
            EXEC SQL                                                    
                 UPDATE #CSR04037_R2                             
                    SET HOLADJ = HOLADJ + 1                             
                  WHERE CF_WANTED_FL    = 0                             
                    AND RELEASE_DATE   <=                               
                        CIS.CHAR2TIMESTAMP(:WS-HOLIDAY-TS)                      
                    AND COMPLETED_DATE >=                               
                        CIS.CHAR2TIMESTAMP(:WS-HOLIDAY-TS)                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04037_R2                                     
MFA-TR*             SET HOLADJ = HOLADJ + 1                                     
MFA-TR*           WHERE CF_WANTED_FL    = 0                                     
MFA-TR*             AND RELEASE_DATE   <=                                       
MFA-TR*                 TIMESTAMP(:WS-HOLIDAY-TS)                               
MFA-TR*             AND COMPLETED_DATE >=                                       
MFA-TR*                 TIMESTAMP(:WS-HOLIDAY-TS)                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5030'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04037_R2'         TO TABLE-1                    
               MOVE 'HOLADJ'              TO TABLE-ELEMENT-1            
               MOVE 'HOLADJ'              TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
            PERFORM 7010-FETCH-HOLIDAY-CUR   THRU 7010-EXIT.            
                                                                        
       5030-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5040-UPDATE-CSR04037-R2-NBD.                                   *        
      ******************************************************************        
       5040-UPDATE-CSR04037-R2-NBD.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04037_R2                             
                    SET CF_NBD = CF_DATEDIFF + CF_DOWADJ -              
                        CF_WKENDADJ - HOLADJ                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04037_R2                                     
MFA-TR*             SET CF_NBD = CF_DATEDIFF + CF_DOWADJ -                      
MFA-TR*                 CF_WKENDADJ - HOLADJ                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5040'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04037_R2-NBD'     TO TABLE-1                    
               MOVE 'CF_NBD'              TO TABLE-ELEMENT-1            
               MOVE 'CF_NBD'              TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5040-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5050-UPDATE-CSR04037-R2-REC-FL.                                *        
      ******************************************************************        
       5050-UPDATE-CSR04037-R2-REC-FL.                                  
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04037_R2                             
                    SET CF_RECEIVED_FL = (CASE WHEN CF_NBD <= GOAL      
                                               THEN 1 ELSE 0 END)       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04037_R2                                     
MFA-TR*             SET CF_RECEIVED_FL = (CASE WHEN CF_NBD <= GOAL              
MFA-TR*                                        THEN 1 ELSE 0 END)               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5050'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04037-R2-REC-FL'  TO TABLE-1                    
               MOVE 'CF_RECEIVED_FL'      TO TABLE-ELEMENT-1            
               MOVE 'CF_RECEIVED_FL'      TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5050-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5060-UPDATE-CSR04037-R2-MET-FL.                                *        
      ******************************************************************        
       5060-UPDATE-CSR04037-R2-MET-FL.                                  
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04037_R2                             
                    SET CF_MET_FL = (CASE WHEN CF_RECEIVED_FL = 1 OR    
                                               CF_WANTED_FL   = 1       
                                          THEN 1 ELSE 0 END)            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04037_R2                                     
MFA-TR*             SET CF_MET_FL = (CASE WHEN CF_RECEIVED_FL = 1 OR            
MFA-TR*                                        CF_WANTED_FL   = 1               
MFA-TR*                                   THEN 1 ELSE 0 END)                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5060'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04037-R2-MET-FL'  TO TABLE-1                    
               MOVE 'CF_MET_FL'           TO TABLE-ELEMENT-1            
               MOVE 'CF_MET_FL'           TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5060-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5070-BUILD-SERIES.                                             *        
      ******************************************************************        
       5070-BUILD-SERIES.                                               
                                                                        
            MOVE WS-END-DT(1:4)           TO WS-YEAR.                   
            MOVE WS-END-DT(6:2)           TO WS-MONTH.                  
            STRING WS-YEAR, WS-MONTH DELIMITED BY SIZE                  
                   INTO WS-LAST.                                        
            MOVE WS-LAST                  TO WS-LAST-NUM.               
            MOVE WS-BEGIN-DT(6:2)         TO WS-MONTH.                  
            MOVE WS-BEGIN-DT(1:4)         TO WS-YEAR.                   
            STRING WS-YEAR, WS-MONTH DELIMITED BY SIZE                  
                   INTO WS-BEGIN.                                       
            MOVE WS-BEGIN                 TO WS-BEGIN-NUM.              
            MOVE WS-BEGIN-DT(3:2)         TO WS-YEAR-DIG.               
            PERFORM 5071-PROCESS-SERIES   THRU 5071-EXIT                
                             UNTIL WS-BEGIN-NUM > WS-LAST-NUM.          
       5070-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5071-PROCESS-SERIES.                                           *        
      ******************************************************************        
       5071-PROCESS-SERIES.                                             
            EVALUATE WS-MONTH                                           
                WHEN '01'                                               
                     MOVE 'JAN-'       TO WS-MON                        
                WHEN '02'                                               
                     MOVE 'FEB-'       TO WS-MON                        
                WHEN '03'                                               
                     MOVE 'MAR-'       TO WS-MON                        
                WHEN '04'                                               
                     MOVE 'APR-'       TO WS-MON                        
                WHEN '05'                                               
                     MOVE 'MAY-'       TO WS-MON                        
                WHEN '06'                                               
                     MOVE 'JUN-'       TO WS-MON                        
                WHEN '07'                                               
                     MOVE 'JUL-'       TO WS-MON                        
                WHEN '08'                                               
                     MOVE 'AUG-'       TO WS-MON                        
                WHEN '09'                                               
                     MOVE 'SEP-'       TO WS-MON                        
                WHEN '10'                                               
                     MOVE 'OCT-'       TO WS-MON                        
                WHEN '11'                                               
                     MOVE 'NOV-'       TO WS-MON                        
                WHEN '12'                                               
                     MOVE 'DEC-'       TO WS-MON                        
            END-EVALUATE.                                               
            STRING WS-MON, WS-YEAR-DIG DELIMITED BY SIZE                
                       INTO WS-YRMON.                                   
            PERFORM 5080-INSERT-CSR04037-R3 THRU 5080-EXIT.             
                                                                        
            IF WS-MONTH IS NUMERIC                                      
               ADD 1               TO WS-MONTH                          
            END-IF.                                                     
            IF WS-MONTH = '13'                                          
               ADD 1               TO WS-YEAR                           
               MOVE 1              TO WS-MONTH                          
            END-IF.                                                     
                                                                        
            STRING WS-YEAR,WS-MONTH DELIMITED BY SIZE                   
                       INTO WS-BEGIN.                                   
            MOVE WS-BEGIN                 TO WS-BEGIN-NUM.              
            MOVE WS-YEAR(3:2)             TO WS-YEAR-DIG.               
       5071-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5080-INSERT-CSR04037-R3.                                       *        
      ******************************************************************        
       5080-INSERT-CSR04037-R3.                                         
            EXEC SQL                                                    
                 INSERT INTO #CSR04037_R3                        
                 (                                                      
                   YRMON_TX                                             
                  ,YRMON_CD                                             
                 )                                                      
                 VALUES                                                 
                 (                                                      
                   :WS-YRMON                                            
                  ,:WS-BEGIN                                            
                 )                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04037_R3                                
MFA-TR*          (                                                              
MFA-TR*            YRMON_TX                                                     
MFA-TR*           ,YRMON_CD                                                     
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*            :WS-YRMON                                                    
MFA-TR*           ,:WS-BEGIN                                                    
MFA-TR*          )                                                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES                 TO S-CURR-VALUE           
                  PERFORM 8100-SEND-RESULT    THRU 8100-EXIT            
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '5080'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04037_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5080-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7030-OPEN-WKAREA-CUR.                                         *         
      *****************************************************************         
       7030-OPEN-WKAREA-CUR.                                            
                                                                        
            EXEC SQL                                                    
                 OPEN WKAREA_CUR                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7030'                      TO ACTIVE-PARAGRAPH     
               MOVE 'OPEN'                      TO ABEND-FUNCTION       
               MOVE 'CSR04037_R4'               TO TABLE-1              
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7040-FETCH-WKAREA-CUR.                                        *         
      *****************************************************************         
       7040-FETCH-WKAREA-CUR.                                           
                                                                        
            EXEC SQL                                                    
                 FETCH WKAREA_CUR                                       
                  INTO :WS-YRMON, :WS-WID, :WS-RID, :WS-RTX,            
                       :WS-YRMONTX, :WS-WTX, :WS-CF-MET-FL              
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE. 
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE 'Y'                       TO WS-NO-MORE-ROWS     
               END-IF                                                   
            ELSE                                                        
                MOVE PROGRAM-NAME                TO ABEND-PROGRAM       
                MOVE '7040'                      TO ACTIVE-PARAGRAPH    
                MOVE 'FETCH'                     TO ABEND-FUNCTION      
                MOVE 'CSR04037_R4'               TO TABLE-1             
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7050-CLOSE-WKAREA-CUR.                                        *         
      *****************************************************************         
       7050-CLOSE-WKAREA-CUR.                                           
                                                                        
            EXEC SQL                                                    
                 CLOSE WKAREA_CUR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7050'                      TO ACTIVE-PARAGRAPH     
               MOVE 'CLOSE'                     TO ABEND-FUNCTION       
               MOVE 'CSR04037_R4'               TO TABLE-1              
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5090-MOVE-WKAREA-DATA.                                         *        
      ******************************************************************        
       5090-MOVE-WKAREA-DATA.                                           
                                                                        
            MOVE WS-YRMON                     TO WS-OLD-YRMON.          
            MOVE WS-WID                       TO WS-OLD-WID.            
            MOVE WS-RID                       TO WS-OLD-RID.            
            MOVE WS-RTX                       TO WS-OLD-RTX.            
            MOVE WS-YRMONTX                   TO WS-OLD-YRMONTX.        
            MOVE WS-WTX                       TO WS-OLD-WTX.            
            MOVE 0                            TO WS-ORDERS-MET.         
            MOVE 0                            TO WS-ORDERS.             
            MOVE 'N'                          TO WS-NO-MORE-ROWS.       
                                                                        
       5090-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5100-PROCESS-WKAREA-CUR.                                       *        
      ******************************************************************        
       5100-PROCESS-WKAREA-CUR.                                         
                                                                        
           IF (WS-OLD-YRMON NOT = WS-YRMON) OR (WS-OLD-WID NOT = WS-WID)
               IF WS-ORDERS > 0                                         
                  DIVIDE WS-ORDERS-MET BY WS-ORDERS                     
                         GIVING WS-ROUND-VAL                            
               ELSE                                                     
                  MOVE 0                         TO WS-ROUND-VAL        
               END-IF                                                   
               MULTIPLY 100 BY WS-ROUND-VAL GIVING WS-DEC-NUM           
               MOVE WS-DEC-NUM                  TO WS-DEC-PERCENT       
               PERFORM 5120-INSERT-CSR04037-R4   THRU 5120-EXIT         
               MOVE WS-YRMON                     TO WS-OLD-YRMON        
               MOVE WS-WID                       TO WS-OLD-WID          
               MOVE 0                            TO WS-ORDERS-MET       
               MOVE 0                            TO WS-ORDERS           
               MOVE WS-RID                       TO WS-OLD-RID          
               MOVE WS-RTX                       TO WS-OLD-RTX          
               MOVE WS-YRMONTX                   TO WS-OLD-YRMONTX      
               MOVE WS-WTX                       TO WS-OLD-WTX          
            END-IF.                                                     
            ADD      1                           TO WS-ORDERS.          
                                                                        
            IF WS-CF-MET-FL = 1                                         
               ADD 1                             TO WS-ORDERS-MET       
            END-IF.                                                     
            PERFORM 7040-FETCH-WKAREA-CUR       THRU 7040-EXIT.         
       5100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5110-POST-PROCESS-WKAREA-CUR.                                  *        
      ******************************************************************        
       5110-POST-PROCESS-WKAREA-CUR.                                    
                                                                        
               IF WS-ORDERS > 0                                         
                  DIVIDE WS-ORDERS-MET BY WS-ORDERS                     
                         GIVING WS-ROUND-VAL                            
               ELSE                                                     
                  MOVE 0                        TO WS-ROUND-VAL         
               END-IF.                                                  
               MULTIPLY 100 BY WS-ROUND-VAL GIVING WS-DEC-NUM.          
               MOVE    WS-DEC-NUM              TO WS-DEC-PERCENT.       
               PERFORM 5120-INSERT-CSR04037-R4 THRU 5120-EXIT.          
                                                                        
       5110-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5120-INSERT-CSR04037-R4.                                       *        
      ******************************************************************        
       5120-INSERT-CSR04037-R4.                                         
            EXEC SQL                                                    
                 INSERT INTO #CSR04037_R4                        
                 (                                                      
                   YRMON_CD                                             
                  ,YRMON_TX                                             
                  ,REGION_TX                                            
                  ,WORK_AREA_TX                                         
                  ,TOTAL_ORDERS                                         
                  ,ORDERS_MET                                           
                  ,PERCENT_XY                                           
                  ,WORK_AREA_ID                                         
                  ,REGION_ID                                            
                 )                                                      
                 VALUES                                                 
                 (                                                      
                   :WS-OLD-YRMON                                        
                  ,:WS-OLD-YRMONTX                                      
                  ,:WS-OLD-RTX                                          
                  ,:WS-OLD-WTX                                          
                  ,:WS-ORDERS                                           
                  ,:WS-ORDERS-MET                                       
                  ,:WS-DEC-PERCENT                                      
                  ,:WS-OLD-WID                                          
                  ,:WS-OLD-RID                                          
                 )                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04037_R4                                
MFA-TR*          (                                                              
MFA-TR*            YRMON_CD                                                     
MFA-TR*           ,YRMON_TX                                                     
MFA-TR*           ,REGION_TX                                                    
MFA-TR*           ,WORK_AREA_TX                                                 
MFA-TR*           ,TOTAL_ORDERS                                                 
MFA-TR*           ,ORDERS_MET                                                   
MFA-TR*           ,PERCENT_XY                                                   
MFA-TR*           ,WORK_AREA_ID                                                 
MFA-TR*           ,REGION_ID                                                    
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*            :WS-OLD-YRMON                                                
MFA-TR*           ,:WS-OLD-YRMONTX                                              
MFA-TR*           ,:WS-OLD-RTX                                                  
MFA-TR*           ,:WS-OLD-WTX                                                  
MFA-TR*           ,:WS-ORDERS                                                   
MFA-TR*           ,:WS-ORDERS-MET                                               
MFA-TR*           ,:WS-DEC-PERCENT                                              
MFA-TR*           ,:WS-OLD-WID                                                  
MFA-TR*           ,:WS-OLD-RID                                                  
MFA-TR*          )                                                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1                     TO CTR-ROWS                   
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5120'                TO ACTIVE-PARAGRAPH           
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSR04037_R4'         TO TABLE-1                    
               MOVE 'YRMON_CD'            TO TABLE-ELEMENT-1            
               MOVE  WS-OLD-YRMON         TO HOSTVAR-ELEMENT-1          
               MOVE 'WORK_AREA_ID'        TO TABLE-ELEMENT-2            
               MOVE  WS-OLD-WID           TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5120-EXIT.                                                       
            EXIT.                                                       
                                                                        
A02983******************************************************************        
A02983* 5130-CHECK-LEAP-YEAR                                                    
A02983******************************************************************        
A02983 5130-CHECK-LEAP-YEAR.                                            
                                                                        
                                                                        
A02983           DIVIDE WS-TEMP-YR BY 4                                 
A02983             GIVING WS-QUOTIENT                                   
A02983             REMAINDER WS-REMAINDER                               
A02983           IF  WS-REMAINDER = 0                                   
A02983               MOVE '29'                     TO PARM-END-DT(9:2)  
A02983               DIVIDE WS-TEMP-YR   BY 100                         
A02983               GIVING WS-QUOTIENT                                 
A02983               REMAINDER WS-REMAINDER                             
A02983               IF  WS-REMAINDER = 0                               
A02983                    MOVE '28'                 TO PARM-END-DT(9:2) 
A02983                    DIVIDE WS-TEMP-YR BY 400                      
A02983                    GIVING WS-QUOTIENT                            
A02983                    REMAINDER WS-REMAINDER                        
A02983                    IF  WS-REMAINDER = 0                          
A02983                        MOVE '29'             TO PARM-END-DT(9:2) 
A02983                    END-IF                                        
A02983                END-IF                                            
A02983            ELSE                                                  
A02983                MOVE '28'                     TO PARM-END-DT(9:2) 
A02983            END-IF.                                               
                                                                        
A02983 5130-EXIT.                                                       
A02983     EXIT.                                                        
                                                                        
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
                                                                        
