       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04031.                                            
       DATE-WRITTEN.  APR 22, 2008.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS MODULE                                                   *        
      *    - Coded For Start, Stop & Transfer (WEB)  Project.          *        
      *    - Executes via CIS Web-Service( ).                          *        
      *    - Evaluates The Utility Credit Details Of A Customer/Spouse.*        
      *    - Returns The Deposit To be Charged or Call to Equifax.     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/22/08  VP94820    INITIAL VERSION                          *        
A01869*  11/18/09  VP94820    CHARGE MAX DEP WHEN ELEC-ONLY SERVICE    *        
P00399*  08/16/10  VV94890   1)ADDED NEW COPYBOOK CPD00334 TO DETERMINE*        
      *                        GOOD/BAD CREDIT HISTORY.                *        
      *                      2)NO LONGER REVIEW THE DISCONNECT HISTORY *        
      *                        ONLY CONSIDER THE ARREARS HISTORY.      *        
      *                      3)THE NUMBER OF MONTHS WILL BE DETERMINED *        
      *                        BY DELINQUENCY VALUE BASED ON ACCT TYPE.*        
      *   "GOOD CREDIT RULE" - SCEG                                    *        
      *        THERE ARE NO CONSECUTIVE 30-DAY ARREARS OR LESS THAN    *        
      *        TWO NON-CONSECUTIVE 30-DAY ARREARS WITH IN THE LAST     *        
      *        DELINQ MONTHS.                                          *        
      *   "BAD CREDIT RULE" - SCEG                                     *        
      *        ARREARS HISTORY HAS ANY CONSECUTIVE OR MORE THAN TWO    *        
      *        NON-CONSECUTIVE 30-DAY ARREARS WITHIN THE LAST DELINQ   *        
      *        MONTHS.                                                 *        
      *   "GOOD CREDIT RULE" - PSNC                                    *        
      *        THERE ARE 2 OR LESS                                     *        
      *        NON-CONSECUTIVE 30-DAY ARREARS WITH IN THE LAST         *        
      *        DELINQ MONTHS.                                          *        
      *   "BAD CREDIT RULE"                                            *        
      *        ARREARS HISTORY HAS MORE THAN TWO                       *        
      *        NON-CONSECUTIVE 30-DAY ARREARS WITHIN THE LAST DELINQ   *        
      *        MONTHS.                                                 *        
P00399*  11/08/10  MJ13662   FOR PSNC, USE TOTAL ARREARS COUNT TO      *        
P00399*                     DETERMINE GOOD CREDIT.             .       *        
P00518*  09/07/11  SP95538   FOR SECOND SERVICE AND NEW CREDIT GROUP   *        
P00518*                      CHECK FOR ARREAR RULES.                   *        
P00471*  09/13/11  SP95538  ADD '4' FOR PSNC GOOD CREDIT RULE.         *        
ACT030*  02/04/15  VIJAY    INCREASE S-RETURN-CODE FIELD LENGTH.       *        
ACT030*  A05136                                                        *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04031'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04031 STARTS HERE'.                  
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
ACT030    05 S-RETURN-CODE                 PIC S9(9)  COMP VALUE ZERO.  
          05 S-PROGRAM-ID                  PIC X(08)  VALUE 'CSR04031'. 
          05 S-PROCESS-CODE                PIC X(01)  VALUE SPACES.     
          05 S-DEPOSIT-AMT                 PIC S9(09)V99                
                                                      COMP-3 VALUE +0.  
          05 S-CALL-EQUIFAX                PIC X(01)  VALUE SPACES.     
          05 S-EQUIFAX-REASON              PIC X(01)  VALUE SPACES.     
          05 S-WAIVER-REASON               PIC X(01)  VALUE SPACES.     
          05 S-WAIVER-ACCT                 PIC X(13)  VALUE SPACES.     
          05 S-CUST-SSN                    PIC X(09)  VALUE SPACES.     
      *                                                                         
       01 WS-RESULT.                                                    
ACT030    05 RS-RETURN-CODE                PIC S9(9)  COMP VALUE ZERO.  
          05 WS-PROCESS-CODE               PIC X(01)  VALUE SPACES.     
          05 WS-CALL-EQUIFAX               PIC X(01)  VALUE SPACES.     
          05 WS-EQUIFAX-REASON             PIC X(01)  VALUE SPACES.     
          05 WS-WAIVER-REASON              PIC X(01)  VALUE SPACES.     
          05 WS-WAIVER-ACCT                PIC X(13)  VALUE SPACES.     
          05 WS-CUST-SSN                   PIC X(09)  VALUE SPACES.     
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-IN-SSN                     PIC X(09)  VALUE SPACES.     
          05 WS-IN-CUST-NO                 PIC X(10)  VALUE SPACES.     
          05 WS-IN-CUST-FLAG               PIC X(06)  VALUE SPACES.     
          05 WS-IN-SPOUSE-FLAG             PIC X(01)  VALUE SPACES.     
          05 WS-CREDIT-GROUP               PIC X(01)  VALUE SPACES.     
          05 WS-SPOUSE-SSN                 PIC X(09)  VALUE SPACES.     
          05 WS-COMPANY-NO                 PIC X(02)  VALUE SPACES.     
P00399    05 WS-RETAIN-COMMER-DEP          PIC S9(04) COMP VALUE ZERO.  
P00399    05 WS-RETAIN-INDUST-DEP          PIC S9(04) COMP VALUE ZERO.  
P00399    05 WS-RETAIN-RESIDENT-DEP        PIC S9(04) COMP VALUE ZERO.  
P00399    05 WS-RETAIN-DEL-MTHS            PIC S9(04) COMP VALUE ZERO.  
P00399    05 WS-ACCOUNT-TYPE-CODE          PIC X(01)  VALUE SPACES.     
          05 WS-START-REV-DATE             PIC X(10)  VALUE SPACES.     
          05 WS-START-REV-MONTH            PIC X(06)  VALUE SPACES.     
          05 WS-DATE-BILLED-START          PIC X(10)  VALUE SPACES.     
          05 WS-DATE-BILLED-END            PIC X(10)  VALUE SPACES.     
          05 WS-PREV-CHAR                  PIC X(01)  VALUE SPACES.     
          05 WS-DEP-PAY-AMT                PIC S9(09)V99  USAGE COMP-3  
                                                      VALUE 0.          
          05 WS-DEPOSIT-AMT                PIC S9(09)V99                
                                                     COMP-3 VALUE +0.   
          05 WS-I                          PIC S9(04) USAGE COMP        
                                                      VALUE 0.          
          05 WS-NO-OF-BILLS                PIC S9(04) USAGE COMP        
                                                      VALUE 0.          
          05 WS-CUST-ARR-HST               PIC X(12)  VALUE SPACES.     
          05 WS-DISCONNECT-HIST            PIC X(12)  VALUE SPACES.     
          05 WS-DISC-EXCEPTN-HIST          PIC X(12)  VALUE SPACES.     
          05 WS-CUST-ARR-CNT               PIC S9(04) USAGE COMP        
                                                      VALUE 0.          
      *                                                                         
          05 WS-COMM-TIMESTAMP             PIC X(26) VALUE SPACES.      
      *                                                                         
          05  WS-ACCOUNT-NO                 PIC X(13)  VALUE SPACES.    
          05  WS-ACCOUNT-NO-NUM             REDEFINES WS-ACCOUNT-NO     
                                            PIC 9(13).                  
COB305    05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.         
COB305    05 WS-GOOD-CR-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.         
      *                                                                         
          05  WS-PREMISE-NO                 PIC X(10)  VALUE SPACES.    
          05  WS-PREMISE-NO-NUM             REDEFINES WS-PREMISE-NO     
                                            PIC 9(10).                  
          05  WS-PREMISE-NO-COMP3           PIC S9(10) COMP-3 VALUE +0. 
      *                                                                         
          05  WS-CUSTOMER-NO                PIC X(10)  VALUE SPACES.    
          05  WS-CUST-NO-NUM                REDEFINES WS-CUSTOMER-NO    
                                            PIC 9(10).                  
          05  WS-CUST-NO-COMP3              PIC S9(10) COMP-3 VALUE +0. 
      *                                                                         
          05  WS-DEPOSIT-AMT-EDT            PIC $ZZZ.ZZ.                
      *                                                                         
           05 WS-ACTIV-ACCT-CNT             PIC S9(04) COMP.            
           05 WS-BAL-CR-GRP-CNT             PIC S9(04) COMP.            
      *                                                                         
          05  WS-REVENUE-DATE.                                          
              10  WS-REV-YEAR               PIC X(04)  VALUE SPACES.    
              10  FILLER                    PIC X(01)  VALUE '-'.       
              10  WS-REV-MONTH              PIC X(02)  VALUE SPACES.    
              10  FILLER                    PIC X(01)  VALUE '-'.       
              10  WS-REV-DATE               PIC X(02)  VALUE SPACES.    
      *                                                                         
          05  WS-REVENUE-DT REDEFINES WS-REVENUE-DATE                   
                                            PIC X(10).                  
      *                                                                         
          05 WS-CODE-ARRAY                  OCCURS 100 TIMES            
                                            INDEXED BY WS-IDX-C.        
             10 WS-CODE-VALUE               PIC X(10).                  
             10 WS-CODE-LONG-DESC           PIC X(80).                  
      *                                                                         
          05  WS-COMM-CODE                  PIC X(10)                   
                                            OCCURS 20 TIMES.            
          05  WS-CNT                        PIC S9(4) COMP VALUE +1.    
      *                                                                         
          05 WS-CODE-DESC-TEXT.                                         
             10 WS-CODE-DESC                PIC X(01)                   
                            OCCURS 80  TIMES INDEXED BY WS-IDX-D.       
          05 WS-FINAL-COMM-TEXT.                                        
             10 WS-FINAL-COMM               PIC X(01)                   
                            OCCURS 225 TIMES INDEXED BY WS-IDX-F.       
      *                                                                         
          05 WS-CONTACT-NAME                PIC X(25)  VALUE SPACES.    
          05 WS-TEMP-CONTACT-NAME           PIC X(25)  VALUE SPACES.    
      *                                                                         
P00471    05 WS-DISCONNECT-HIST-CZ          PIC X(24)  VALUE SPACES.    
P00471    05 WS-DISC-EXCEPTN-HIST-CZ        PIC X(24)  VALUE SPACES.    
      *                                                                         
       01 WS-NULL-IND.                                                  
           05 WS-NULL-IND-1                 PIC S9(04) COMP.            
           05 WS-RED-FL-NULL-IND            PIC S9(04) COMP.            
           05 WS-END-NULL-IND               PIC S9(04) COMP.            
      *                                                                         
       01 WS-LITERALES.                                                 
          05 WS-MULTIPLE-ROWS               PIC S9(9) VALUE -811 COMP.  
          05 PROGRAM-NAME                   PIC X(08) VALUE 'CSR04031'. 
          05 WS-COMM-SEP                    PIC X(02) VALUE '//'.       
          05 WS-HYPEN                       PIC X(03) VALUE ' - '.      
      *                                                                         
       01 CSR02022-RTN-VALUES.                                          
           05 WS-NUMBER-OF-BILLS            PIC S9(04)V USAGE COMP-3    
                                                       VALUE 0.         
           05 WS-MIN-DEPOSIT-AMT            PIC S9(09)V99 USAGE COMP-3  
                                                       VALUE 0.         
           05 WS-MAX-DEPOSIT-AMT            PIC S9(09)V99 USAGE COMP-3  
                                                       VALUE 0.         
           05 WS-USAGE-HISTORY-FLAG         PIC X(01)  VALUE SPACES.    
           05 WS-SUMMARY-COL-NAME           PIC X(30)  VALUE SPACES.    
           05 WS-COLUMN-SUBTOTAL            PIC S9(09)V99  COMP-3       
                                                       VALUE +0.        
           05 WS-RETURN-CODE                PIC S9(9)  USAGE COMP       
                                                       VALUE +0.        
           05 WS-MAX-DEP-REF-XMT-CD         PIC X(01)  VALUE SPACES.    
           05 WS-LAST-MAX-AT-REV-DT         PIC X(10)  VALUE SPACES.    
           05 WS-MAX-DEP-AT-REV-AM          PIC S9(9)V9(2) USAGE COMP-3 
                                                       VALUE 0.         
           05 WS-PD-DEP-AT-REV-AM           PIC S9(9)V9(2) USAGE COMP-3 
                                                       VALUE 0.         
           05 WS-MAX-DEP-REFUND-CD          PIC X(01)  VALUE SPACES.    
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                  PIC X(01)  VALUE 'Y'.        
             88 SEND-DONE-ERROR                       VALUE 'N'.        
             88 SEND-DONE-OK                          VALUE 'Y'.        
          05 WS-CUST-IS-ACCT-HOLDER        PIC X(01)  VALUE ' '.        
             88  WS-NOT-ACCT-HOLDER                   VALUE 'Y'.        
             88  WS-ACCT-HOLDER                       VALUE 'N'.        
          05 WS-NO-OF-ACTIVE-ACCTS         PIC X(01)  VALUE ' '.        
             88  WS-NO-ACTIVE-ACCT                    VALUE '0'.        
             88  WS-ONE-ACTIVE-ACCT                   VALUE '1'.        
             88  WS-MULTI-ACTIVE-ACCT                 VALUE '2'.        
          05 WS-EOF-CURSOR                 PIC X(01)  VALUE 'N'.        
             88 NO-MORE-DATA                          VALUE 'Y'.        
          05 WS-CONS-SERVICE               PIC X(01)  VALUE ' '.        
             88  WS-HAS-CONS-SERV                     VALUE 'Y'.        
             88  WS-NO-CONS-SERV                      VALUE 'N'.        
          05 WS-GOOD-CREDIT                PIC X(01)  VALUE ' '.        
             88  WS-HAS-GOOD-CRED                     VALUE 'Y'.        
             88  WS-HAS-BAD-CRED                      VALUE 'N'.        
          05 WS-DNP-HIST                   PIC X(01)  VALUE ' '.        
             88  WS-HAS-DNP                           VALUE 'Y'.        
             88  WS-HAS-NO-DNP                        VALUE 'N'.        
          05 WS-SECURITY                   PIC X(01)  VALUE ' '.        
             88  WS-HAS-SECURITY                      VALUE 'Y'.        
             88  WS-NO-SECURITY                       VALUE 'N'.        
          05 WS-SERVICE-ELEC               PIC X(01)  VALUE ' '.        
             88  WS-ELEC-ONLY                         VALUE 'E'.        
          05 WS-SERVICE-GAS                PIC X(01)  VALUE ' '.        
             88  WS-GAS-ONLY                          VALUE 'G'.        
          05 WS-SERVICE-COMBO              PIC X(01)  VALUE ' '.        
             88  WS-COMBO                             VALUE 'C'.        
          05 WS-FB-ACCT                    PIC X(01)  VALUE ' '.        
             88  WS-HAS-FB-ACCT                       VALUE 'Y'.        
             88  WS-NO-FB-ACCT                        VALUE 'N'.        
          05 WS-CRED-EXEMPT                PIC X(01)  VALUE ' '.        
             88  WS-EXEMPT                            VALUE 'Y'.        
          05 WS-FORMAT                     PIC X(01)  VALUE 'N'.        
             88 FORMAT-DONE                           VALUE 'Y'.        
          05 WS-APPEND-DEP                 PIC X(01)  VALUE 'N'.        
             88 WS-DEP-AMT                            VALUE 'Y'.        
          05 WS-CQ-IND                     PIC X(01)  VALUE 'N'.        
             88 WS-C-AND-Q                            VALUE 'Y'.        
      *                                                                         
      *01 LOC-RESLTSET                     USAGE SQL TYPE IS            
      *                                    RESULT-SET-LOCATOR VARYING.  
                                                                        
      *                                                                         
      ******************************************************************        
      *     DB2 INCLUDES                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    AR - CSS_AR_TRANS_HIST                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBARHIST                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CE - CSS_CUST_STATS                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCSTSTS                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DQ - CSS_NAME                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CZ - CSS_CREDIT_PROFILE                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCRPROF                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    UV - CSS_CODE_VALUE                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCDVALU                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    G6 - CSS_JOB_PARM                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
      *                                                                         
P00399******************************************************************06330000
P00399*    C8 - CSS_DELINQUENCY                                        *06340000
P00399******************************************************************06350000
                                                                        
P00399     EXEC SQL                                                     06370000
P00399         INCLUDE TBDELQ                                           06380000
P00399     END-EXEC.                                                    06390000
      *                                                                         
      ******************************************************************        
      *    GU - CSS_GUARANTOR                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBGTNTR                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DO - CSS_DEP_ON_HAND                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDEPHND                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DP - CSS_DEP_PAY_HST                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDEPHST                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    KO - CSS_COMM_DATA                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCOMDAT                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    BI - CSS_BILLING_HDR                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBBLLHDR                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    UT - CSS_UTIL_ENVRNMT                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      *    CSRERLOG                                                             
           COPY CWSSP001.                                                       
      *                                                                         
      *    USED IN REDUCING EMBDDED BLANKS.                                     
           COPY CWS00011.                                                       
P00399*                                                                         
P00399*    USED IN CPD00324 FOR TO DETERMINE GOOD/BAD CREDIT HISTORY.           
P00399     COPY CWS00334.                                                       
      *                                                                         
      *****************************************************************         
      *   CURSOR DELCARATION                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
                DECLARE CONS_SERVICE_CUR CURSOR FOR                     
                 SELECT                                                 
                        AT.ACCOUNT_NO                                   
                   FROM                                                 
                        CSS_ACCOUNT AT                                  
                  WHERE                                                 
                        AT.CUSTOMER_NO      =   :AT-CUSTOMER-NO         
                    AND AT.CODE_ACCT_STAT   IN  ('B','S')               
                    AND AT.REV_MTH_LST_NRML >=  :AT-REV-MTH-LST-NRML    
           END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
                DECLARE SERVICE_TYPE_CUR CURSOR FOR                     
                 SELECT                                                 
                        UT.CODE_UTIL_TYPE                               
                   FROM                                                 
                        CSS_UTIL_ENVRNMT UT                             
                  WHERE                                                 
                        UT.PREMISE_NO = :UT-PREMISE-NO                  
                    AND UT.CODE_UTIL_TYPE IN ('E','G')                  
           END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
                DECLARE ACTIVE_ACCTS CURSOR FOR                         
                 SELECT                                                 
                         AT.ACCOUNT_NO                                  
                        ,AT.CREDIT_GROUP                                
                   FROM                                                 
                        CSS_ACCOUNT AT                                  
                  WHERE                                                 
                        AT.CUSTOMER_NO     = :AT-CUSTOMER-NO            
                    AND AT.CODE_ACCT_STAT  = 'A'                        
           END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
                DECLARE CODE_VALUES CURSOR FOR                          
                SELECT                                                  
                       UV.CODE_VALUE                                    
                      ,UV.CODE_LONG_DESC                                
                FROM                                                    
                       CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                  
                WHERE                                                   
                       UV.PROGRAM_ID        = 'WEBSST'                  
                  FOR READ ONLY                                        
                                                                 
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CODE_VALUES CURSOR FOR                                  
MFA-TR*         SELECT                                                          
MFA-TR*                UV.CODE_VALUE                                            
MFA-TR*               ,UV.CODE_LONG_DESC                                        
MFA-TR*         FROM                                                            
MFA-TR*                CSS_CODE_VALUE UV                                        
MFA-TR*         WHERE                                                           
MFA-TR*                UV.PROGRAM_ID        = 'WEBSST'                          
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR02022( :WS-ACCOUNT-NO
                  )
MSQ001        END-EXEC.
                                                    
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-CUSTOMER-NO                  PIC X(10).                  
       01 PARM-MOVE-TO-PR-NO                PIC X(10).                  
       01 PARM-IS-CUST-FLAG                 PIC X(06).                  
       01 PARM-COMPANY-NO                   PIC X(02).                  
       01 PARM-AS-SPOUSE-FLAG               PIC X(01).                  
       01 PARM-SSN                          PIC X(09).                  
      *                                                                         
       PROCEDURE DIVISION USING   PARM-CUSTOMER-NO                      
                                , PARM-MOVE-TO-PR-NO                    
                                , PARM-IS-CUST-FLAG                     
                                , PARM-COMPANY-NO                       
                                , PARM-AS-SPOUSE-FLAG                   
                                  PARM-SSN.                             
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      *     Controls The Main Path Of The Program                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE.                                               *        
      *     1. Reset DB2 Error Handlers                                *        
      *     2. Declare Cursor For Result Set                           *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
              SELECT                                                    
                      :S-RETURN-CODE         AS RETURN_CODE             
                     ,:S-PROGRAM-ID          AS PROGRAM_ID              
                     ,:S-PROCESS-CODE        AS PROCESS_CODE            
                     ,:S-DEPOSIT-AMT         AS DEPOSIT_AMT             
                     ,:S-CALL-EQUIFAX        AS CALL_EQUIFAX            
                     ,:S-EQUIFAX-REASON      AS EQUIFAX_REASON          
                     ,:S-WAIVER-REASON       AS WAIVER_REASON           
                     ,:S-WAIVER-ACCT         AS WAIVER_ACCT             
                     ,:S-CUST-SSN            AS CUST_SSN                
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT                                                            
MFA-TR*               :S-RETURN-CODE         AS RETURN_CODE                     
MFA-TR*              ,:S-PROGRAM-ID          AS PROGRAM_ID                      
MFA-TR*              ,:S-PROCESS-CODE        AS PROCESS_CODE                    
MFA-TR*              ,:S-DEPOSIT-AMT         AS DEPOSIT_AMT                     
MFA-TR*              ,:S-CALL-EQUIFAX        AS CALL_EQUIFAX                    
MFA-TR*              ,:S-EQUIFAX-REASON      AS EQUIFAX_REASON                  
MFA-TR*              ,:S-WAIVER-REASON       AS WAIVER_REASON                   
MFA-TR*              ,:S-WAIVER-ACCT         AS WAIVER_ACCT                     
MFA-TR*              ,:S-CUST-SSN            AS CUST_SSN                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           INITIALIZE DCLCSS-ACCOUNT                                    
                      DCLCSS-AR-TRANS-HIST                              
                      DCLCSS-CUST-STATS                                 
                      DCLCSS-NAME-ACCT-XREF                             
                      DCLCSS-NAME                                       
                      DCLCSS-CREDIT-PROFILE                             
                      DCLCSS-CODE-VALUE                                 
                      DCLCSS-JOB-PARM                                   
                      DCLCSS-GUARANTOR                                  
                      DCLCSS-DEP-ON-HAND                                
                      DCLCSS-DEP-PAY-HST                                
                      DCLCSS-COMM-DATA                                  
                      DCLCSS-BILLING-HDR                                
                      DCLCSS-UTIL-ENVRNMT.                              
      *                                                                         
           MOVE SPACES                           TO WS-CODE-DESC-TEXT   
                                                    WS-FINAL-COMM-TEXT. 
      *                                                                         
           MOVE 'I'                              TO WS-EQUIFAX-REASON.  
           MOVE 'N'                              TO WS-CALL-EQUIFAX.    
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *     -Assingns Input parms to WS Variables.                     *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-CUSTOMER-NO                 TO WS-IN-CUST-NO.      
           MOVE PARM-MOVE-TO-PR-NO               TO WS-PREMISE-NO.      
           MOVE WS-PREMISE-NO-NUM                TO WS-PREMISE-NO-COMP3.
           MOVE PARM-COMPANY-NO                  TO WS-COMPANY-NO.      
           MOVE PARM-IS-CUST-FLAG                TO WS-IN-CUST-FLAG.    
           MOVE PARM-AS-SPOUSE-FLAG              TO WS-IN-SPOUSE-FLAG.  
           MOVE PARM-SSN                         TO WS-IN-SSN.          
      *                                                                         
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     -Main Business Logic Process                               *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           IF WS-IN-CUST-FLAG = 'NEW'                                   
              MOVE WS-IN-SSN                     TO CE-SSN              
                                                    WS-SPOUSE-SSN       
              IF WS-IN-SPOUSE-FLAG = 'Y'                                
                 MOVE 'C'                        TO CE-CUSTOMER-TYPE    
              ELSE                                                      
                 MOVE 'S'                        TO CE-CUSTOMER-TYPE    
              END-IF                                                    
              PERFORM 7005-SEL-CUST-NO           THRU 7005-EXIT         
              IF CE-CUSTOMER-NO > ZEROS                                 
                 MOVE 'A'                        TO WS-EQUIFAX-REASON   
      *          Code-Value:'D'- Chk Spouse Acct for Credit Rules               
                 MOVE 'D '                       TO WS-COMM-CODE(WS-CNT)
                 ADD +1                          TO WS-CNT              
                 MOVE CE-CUSTOMER-NO             TO WS-CUSTOMER-NO      
                                                    WS-CUST-NO-COMP3    
                                                    AT-CUSTOMER-NO      
                 PERFORM 5000-CHECK-ACCT-STATUS  THRU 5000-EXIT         
              ELSE                                                      
                 SET WS-NOT-ACCT-HOLDER          TO TRUE                
                 SET WS-NO-ACTIVE-ACCT           TO TRUE                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-IN-CUST-FLAG = 'EXISTS'                                
              MOVE WS-IN-CUST-NO                 TO WS-CUSTOMER-NO      
              MOVE WS-CUST-NO-NUM                TO WS-CUST-NO-COMP3    
                                                    AT-CUSTOMER-NO      
              PERFORM 5000-CHECK-ACCT-STATUS     THRU 5000-EXIT         
              IF WS-NOT-ACCT-HOLDER                                     
                 MOVE WS-IN-SSN                  TO CE-SSN              
                                                    WS-SPOUSE-SSN       
                 IF WS-IN-SPOUSE-FLAG = 'Y'                             
                    MOVE 'C'                     TO CE-CUSTOMER-TYPE    
                 ELSE                                                   
                    MOVE 'S'                     TO CE-CUSTOMER-TYPE    
                 END-IF                                                 
                 PERFORM 7005-SEL-CUST-NO        THRU 7005-EXIT         
                 IF CE-CUSTOMER-NO > ZEROS                              
                    MOVE 'A'                     TO WS-EQUIFAX-REASON   
      *             Code-Value:'D'- Chk Spouse Acct for Credit Rules            
                    MOVE 'D '                    TO WS-COMM-CODE(WS-CNT)
                    ADD +1                       TO WS-CNT              
                    MOVE CE-CUSTOMER-NO          TO WS-CUSTOMER-NO      
                                                    WS-CUST-NO-COMP3    
                                                    AT-CUSTOMER-NO      
                    PERFORM 5000-CHECK-ACCT-STATUS THRU 5000-EXIT       
                 ELSE                                                   
                    SET WS-NOT-ACCT-HOLDER       TO TRUE                
                    SET WS-NO-ACTIVE-ACCT        TO TRUE                
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-PREMISE-NO-NUM                TO AT-PREMISE-NO.      
           PERFORM 7012-SEL-PREV-ACCT-PR         THRU 7012-EXIT.        
           MOVE AT-ACCOUNT-NO                    TO WS-ACCOUNT-NO-NUM.  
           PERFORM 7074-CALL-CSR02022            THRU 7074-EXIT.        
      *                                                                         
           EVALUATE TRUE                                                
               WHEN WS-NO-ACTIVE-ACCT                                   
                    PERFORM 2100-PROCESS-NEW-SERVICE  THRU 2100-EXIT    
               WHEN WS-ONE-ACTIVE-ACCT                                  
                    PERFORM 2200-PROCESS-2ND-SERVICE  THRU 2200-EXIT    
               WHEN WS-MULTI-ACTIVE-ACCT                                
                    PERFORM 2300-PROCESS-MULTIPLE-SER THRU 2300-EXIT    
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 2400-SET-PROCESS-CODE              THRU 2400-EXIT.   
      *                                                                         
           PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT.  
      *                                                                         
           PERFORM 2500-PROCESS-COMM-DETAILS          THRU 2500-EXIT.   
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *2000A-MOVE-RESULT.                                              *        
      *     -Populated Result Set Variables.                           *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE +1                             TO CTR-ROWS.             
      *                                                                         
           MOVE RS-RETURN-CODE                 TO S-RETURN-CODE.        
           MOVE PROGRAM-NAME                   TO S-PROGRAM-ID.         
           MOVE WS-PROCESS-CODE                TO S-PROCESS-CODE.       
      *                                                                         
      *Applying $150 Min Dep rule for SCE&G Combo/Elec Service.                 
      *                                                                         
           IF WS-COMPANY-NO = '01'                                      
              IF WS-DEPOSIT-AMT > 0 AND WS-DEPOSIT-AMT < +150           
                 PERFORM 5200-CHECK-SERV-AT-NEW-PR                      
                                               THRU 5200-EXIT           
                 IF WS-GAS-ONLY                                         
                    MOVE WS-DEPOSIT-AMT        TO S-DEPOSIT-AMT         
                 ELSE                                                   
                    MOVE 150                   TO S-DEPOSIT-AMT         
                 END-IF                                                 
              ELSE                                                      
                    MOVE WS-DEPOSIT-AMT        TO S-DEPOSIT-AMT         
              END-IF                                                    
           ELSE                                                         
                 MOVE WS-DEPOSIT-AMT           TO S-DEPOSIT-AMT         
           END-IF.                                                      
           MOVE S-DEPOSIT-AMT                  TO wS-DEPOSIT-AMT.       
      *                                                                         
           MOVE WS-CALL-EQUIFAX                TO S-CALL-EQUIFAX.       
           MOVE WS-EQUIFAX-REASON              TO S-EQUIFAX-REASON.     
           MOVE WS-WAIVER-REASON               TO S-WAIVER-REASON.      
           MOVE WS-WAIVER-ACCT                 TO S-WAIVER-ACCT.        
           MOVE WS-CUST-SSN                    TO S-CUST-SSN.           
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-NEW-SERVICE.                                      *        
      *     -Processes The cutomers Applying for NEW Service.          *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-NEW-SERVICE.                                        
      *                                                                         
           IF WS-ACCT-HOLDER                                            
              MOVE WS-CUST-NO-COMP3            TO AT-CUSTOMER-NO        
              PERFORM 2110-CHECK-CONS-SERVICE  THRU 2110-EXIT           
           ELSE                                                         
              MOVE 'Y'                         TO WS-CALL-EQUIFAX       
      *       Code-Value:'T'- Called Equifax                                    
              MOVE 'T '                        TO WS-COMM-CODE(WS-CNT)  
              ADD +1                           TO WS-CNT                
              MOVE WS-IN-CUST-NO               TO WS-CUSTOMER-NO        
              MOVE WS-CUST-NO-NUM              TO CE-CUSTOMER-NO        
              MOVE 'C'                         TO CE-CUSTOMER-TYPE      
              PERFORM 7011-SELECT-SSN          THRU 7011-EXIT           
              MOVE CE-SSN                      TO WS-CUST-SSN           
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2110-CHECK-CONS-SERVICE.                                       *        
      *     -Checks the Consecutive Service in last 24 calender months *        
      *      for the Cutomers applying to a new service.               *        
      ******************************************************************        
      *                                                                         
       2110-CHECK-CONS-SERVICE.                                         
      *                                                                         
           PERFORM 7060-SEL-REVENUE-MONTH      THRU 7060-EXIT           
      *                                                                         
           EXEC SQL                                                     
                SELECT
              DATEADD( YEAR, -2, IIF(TRY_CONVERT(DATE, :WS-REVENUE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REVENUE-DT
              ) <> 0) OR (LEN(:WS-REVENUE-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REVENUE-DT
              ), CONVERT(DATE, :WS-REVENUE-DT) ) )
            INTO
              :WS-START-REV-DATE
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-START-REV-DATE =  DATE(:WS-REVENUE-DT) - 2 YEARS        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE WS-START-REV-DATE              TO WS-DATE-BILLED-START  
           MOVE WS-REVENUE-DT                  TO WS-DATE-BILLED-END    
      *                                                                         
           MOVE WS-START-REV-DATE(1:4)       TO WS-START-REV-MONTH(1:4) 
           MOVE WS-START-REV-DATE(6:2)       TO WS-START-REV-MONTH(5:2) 
           MOVE WS-START-REV-MONTH           TO AT-REV-MTH-LST-NRML     
      *                                                                         
           MOVE 'N'                            TO   WS-EOF-CURSOR.      
           PERFORM 7061-OPEN-CONS-SERVICE-CUR  THRU 7061-EXIT.          
           PERFORM 7062-FETCH-CONS-SERVICE-CUR THRU 7062-EXIT.          
           SET WS-NO-CONS-SERV                 TO TRUE                  
      *                                                                         
           PERFORM UNTIL NO-MORE-DATA                                   
              MOVE AT-ACCOUNT-NO               TO BI-ACCOUNT-NO         
                                                  WS-ACCOUNT-NO-NUM     
              PERFORM 7065-GET-BILLS-COUNT     THRU 7065-EXIT           
              IF WS-NO-OF-BILLS >= 12                                   
                 SET WS-HAS-CONS-SERV          TO TRUE                  
                 MOVE WS-ACCOUNT-NO-NUM        TO AT-ACCOUNT-NO         
                                                  CZ-ACCOUNT-NO         
                 PERFORM 5400-CHECK-FOR-GOOD-CRED                       
                                               THRU 5400-EXIT           
                 IF WS-HAS-BAD-CRED                                     
P00518              MOVE 'Y'                   TO WS-CALL-EQUIFAX       
P00518*       Code-Value:'T'- Called Equifax                                    
P00518              MOVE 'T '                  TO WS-COMM-CODE(WS-CNT)  
P00518              ADD +1                     TO WS-CNT                
                 ELSE                                                   
                    MOVE WS-ACCOUNT-NO-NUM     TO WS-GOOD-CR-ACCT-NO    
                 END-IF                                                 
              END-IF                                                    
              PERFORM 7062-FETCH-CONS-SERVICE-CUR                       
                                               THRU 7062-EXIT           
           END-PERFORM.                                                 
      *                                                                         
           IF WS-HAS-CONS-SERV                                          
      *       Code-Value:'O'- Consecutive Service                               
              MOVE 'O '                        TO WS-COMM-CODE(WS-CNT)  
              ADD +1                           TO WS-CNT                
              IF WS-HAS-GOOD-CRED                                       
                 MOVE ZERO                     TO WS-DEPOSIT-AMT        
                 MOVE 'P'                      TO WS-WAIVER-REASON      
                 MOVE WS-GOOD-CR-ACCT-NO       TO WS-WAIVER-ACCT        
      *          Code-Value:'P'- Good Credit Present                            
                 MOVE 'P '                     TO WS-COMM-CODE(WS-CNT)  
                 ADD +1                        TO WS-CNT                
      *          Code-Value:'I'- Deposit Waived                                 
                 MOVE 'I '                     TO WS-COMM-CODE(WS-CNT)  
                 ADD +1                        TO WS-CNT                
              ELSE                                                      
      *          Code-Value:'Q'-Good Credit Absent                              
                 MOVE 'Q '                     TO WS-COMM-CODE(WS-CNT)  
                 ADD +1                        TO WS-CNT                
                 MOVE WS-ACCOUNT-NO-NUM        TO DO-ACCOUNT-NO         
                                                  DP-ACCOUNT-NO         
                                                  GU-ACCOUNT-NO         
                                                  AR-ACCOUNT-NO         
                 PERFORM 5600-CHECK-SEC-PRESENT                         
                                               THRU 5600-EXIT           
                 IF WS-HAS-SECURITY                                     
      *             Code-Value:'Y'- Security Present                            
                    MOVE 'Y '                  TO WS-COMM-CODE(WS-CNT)  
                    ADD +1                     TO WS-CNT                
                    PERFORM 2111-GET-DEP-AMT   THRU 2111-EXIT           
                 ELSE                                                   
      *             Code-Value:'Z'- Security Absent                             
                    MOVE 'Z '                  TO WS-COMM-CODE(WS-CNT)  
                    ADD +1                     TO WS-CNT                
                    IF WS-EQUIFAX-REASON = 'I'                          
                       IF WS-COMPANY-NO = '26'                          
                          MOVE WS-MAX-DEPOSIT-AMT TO WS-DEPOSIT-AMT     
      *                   Code-Value:'G'- Maximum Deposit Charged               
                          MOVE 'G '            TO WS-COMM-CODE(WS-CNT)  
                          ADD +1               TO WS-CNT                
                       ELSE                                             
                          MOVE WS-MIN-DEPOSIT-AMT TO WS-DEPOSIT-AMT     
      *                   Code-Value:'H'- Minimum Deposit Charged               
                          MOVE 'H '            TO WS-COMM-CODE(WS-CNT)  
                          ADD +1               TO WS-CNT                
                       END-IF                                           
                    ELSE                                                
                       MOVE 'Y'                TO WS-CALL-EQUIFAX       
                       MOVE WS-IN-CUST-NO      TO WS-CUSTOMER-NO        
                       MOVE WS-CUST-NO-NUM     TO CE-CUSTOMER-NO        
                       MOVE 'C'                TO CE-CUSTOMER-TYPE      
                       PERFORM 7011-SELECT-SSN    THRU 7011-EXIT        
                       MOVE CE-SSN             TO WS-CUST-SSN           
      *                Code-Value:'T'- Called Equifax                           
                       MOVE 'T '               TO WS-COMM-CODE(WS-CNT)  
                       ADD +1                  TO WS-CNT                
                       ADD +1                  TO WS-CNT                
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE 'Y'                         TO WS-CALL-EQUIFAX       
      *       Code-Value:'S'- No Consecutive Service                            
              MOVE 'S '                        TO WS-COMM-CODE(WS-CNT)  
              ADD +1                           TO WS-CNT                
      *       Code-Value:'T'- Called Equifax                                    
              MOVE 'T '                        TO WS-COMM-CODE(WS-CNT)  
              ADD +1                           TO WS-CNT                
              MOVE WS-IN-CUST-NO               TO WS-CUSTOMER-NO        
              MOVE WS-CUST-NO-NUM              TO CE-CUSTOMER-NO        
              MOVE 'C'                         TO CE-CUSTOMER-TYPE      
              PERFORM 7011-SELECT-SSN          THRU 7011-EXIT           
              MOVE CE-SSN                      TO WS-CUST-SSN           
           END-IF                                                       
      *                                                                         
           PERFORM 7063-CLOSE-CONS-SERVICE-CUR THRU 7063-EXIT.          
      *                                                                         
       2110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2111-GET-DEP-AMT.                                              *        
      *     -Evaluated the Deposit To Be Charged For The Customers with*        
      *      Bad Credit And Security Deposit.                          *        
      ******************************************************************        
      *                                                                         
       2111-GET-DEP-AMT.                                                
      *                                                                         
           IF WS-EQUIFAX-REASON = 'I'                                   
              IF WS-COMPANY-NO = '26'                                   
                 MOVE WS-MAX-DEPOSIT-AMT       TO WS-DEPOSIT-AMT        
      *          Code-Value:'G'- Maximum Deposit Charged                        
                 MOVE 'G '                     TO WS-COMM-CODE(WS-CNT)  
                 ADD +1                        TO WS-CNT                
              ELSE                                                      
                 PERFORM 5200-CHECK-SERV-AT-NEW-PR                      
                                               THRU 5200-EXIT           
A01869           IF WS-GAS-ONLY                                         
                    MOVE WS-MIN-DEPOSIT-AMT    TO WS-DEPOSIT-AMT        
      *             Code-Value:'H'- Minimum Deposit Charged                     
                    MOVE 'H '                  TO WS-COMM-CODE(WS-CNT)  
                    ADD +1                     TO WS-CNT                
                 ELSE                                                   
                    IF WS-DEP-PAY-AMT > WS-MAX-DEPOSIT-AMT              
                       MOVE WS-MAX-DEPOSIT-AMT TO WS-DEPOSIT-AMT        
      *                Code-Value:'G'- Maximum Deposit Charged                  
                       MOVE 'G '               TO WS-COMM-CODE(WS-CNT)  
                    ELSE                                                
                       MOVE WS-DEP-PAY-AMT     TO WS-DEPOSIT-AMT        
      *                Code-Value:'JJ'- Prev FB Acct Security Dep               
                       MOVE 'JJ'               TO WS-COMM-CODE(WS-CNT)  
                    END-IF                                              
                    ADD +1                     TO WS-CNT                
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE 'Y'                         TO WS-CALL-EQUIFAX       
      *       Code-Value:'T '- Called Equifax                                   
              MOVE 'T '                        TO WS-COMM-CODE(WS-CNT)  
              ADD +1                           TO WS-CNT                
              MOVE WS-IN-CUST-NO               TO WS-CUSTOMER-NO        
              MOVE WS-CUST-NO-NUM              TO CE-CUSTOMER-NO        
              MOVE 'C'                         TO CE-CUSTOMER-TYPE      
              PERFORM 7011-SELECT-SSN          THRU 7011-EXIT           
              MOVE CE-SSN                      TO WS-CUST-SSN           
           END-IF.                                                      
      *                                                                         
       2111-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-2ND-SERVICE.                                      *        
      *     -Processes The Cutomers Applied For Second Service.        *        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-2ND-SERVICE.                                        
      *                                                                         
      *    Code-Value:'DD'- One Active Account                                  
           MOVE 'DD'                           TO WS-COMM-CODE(WS-CNT)  
           ADD +1                              TO WS-CNT                
           PERFORM 7007-SEL-CREDIT-GROUP       THRU 7007-EXIT.          
           MOVE AT-CREDIT-GROUP                TO WS-CREDIT-GROUP.      
           MOVE AT-ACCOUNT-NO                  TO WS-ACCOUNT-NO.        
      *                                                                         
           EVALUATE WS-CREDIT-GROUP                                     
               WHEN 'A'                                                 
      *             Code-Value:'W '- Arrears Credit Group                       
                    MOVE 'W '                  TO WS-COMM-CODE(WS-CNT)  
                    ADD +1                     TO WS-CNT                
                    MOVE WS-ACCOUNT-NO-NUM     TO DO-ACCOUNT-NO         
                                                  DP-ACCOUNT-NO         
                                                  GU-ACCOUNT-NO         
                                                  AR-ACCOUNT-NO         
                    PERFORM 5600-CHECK-SEC-PRESENT     THRU 5600-EXIT   
                    IF WS-HAS-SECURITY                                  
      *                Code-Value:'Y '- Security Present                        
                       MOVE 'Y '               TO WS-COMM-CODE(WS-CNT)  
                       ADD +1                  TO WS-CNT                
                       IF WS-EQUIFAX-REASON = 'I'                       
                          IF WS-COMPANY-NO = '26'                       
                             MOVE WS-MAX-DEPOSIT-AMT   TO WS-DEPOSIT-AMT
      *                      Code-Value:'G'- Maximum Deposit Charged            
                             MOVE 'G '         TO WS-COMM-CODE(WS-CNT)  
                             ADD +1            TO WS-CNT                
                          ELSE                                          
                             MOVE WS-MIN-DEPOSIT-AMT   TO WS-DEPOSIT-AMT
      *                      Code-Value:'H'- Minimum Deposit Charged            
                             MOVE 'H '         TO WS-COMM-CODE(WS-CNT)  
                             ADD +1            TO WS-CNT                
                          END-IF                                        
                       ELSE                                             
                          MOVE 'Y'             TO WS-CALL-EQUIFAX       
                          MOVE WS-IN-CUST-NO   TO WS-CUSTOMER-NO        
                          MOVE WS-CUST-NO-NUM  TO CE-CUSTOMER-NO        
                          MOVE 'C'             TO CE-CUSTOMER-TYPE      
                          PERFORM 7011-SELECT-SSN      THRU 7011-EXIT   
                          MOVE CE-SSN          TO WS-CUST-SSN           
      *                   Code-Value:'T'- Called Equifax                        
                          MOVE 'T '            TO WS-COMM-CODE(WS-CNT)  
                          ADD +1               TO WS-CNT                
                       END-IF                                           
                    ELSE                                                
      *                Code-Value:'Z '- Security Absent                         
                       MOVE 'Z '               TO WS-COMM-CODE(WS-CNT)  
                       ADD +1                  TO WS-CNT                
                       PERFORM 2210-GET-ARR-DEP   THRU 2210-EXIT        
                    END-IF                                              
               WHEN 'B'                                                 
      *             Code-Value:'V '- Balance Credit Group                       
                    MOVE 'V '                  TO WS-COMM-CODE(WS-CNT)  
                    ADD +1                     TO WS-CNT                
                    IF WS-EQUIFAX-REASON = 'I'                          
                       IF WS-COMPANY-NO = '26'                          
                          MOVE WS-MAX-DEPOSIT-AMT TO WS-DEPOSIT-AMT     
      *                   Code-Value:'G'- Maximum Deposit Charged               
                          MOVE 'G '            TO WS-COMM-CODE(WS-CNT)  
                          ADD +1               TO WS-CNT                
                       ELSE                                             
                          MOVE WS-MIN-DEPOSIT-AMT TO WS-DEPOSIT-AMT     
      *                   Code-Value:'H'- Minumum Deposit Charged               
                          MOVE 'H '            TO WS-COMM-CODE(WS-CNT)  
                          ADD +1               TO WS-CNT                
                       END-IF                                           
                    ELSE                                                
                       MOVE 'Y'                TO WS-CALL-EQUIFAX       
                       MOVE WS-IN-CUST-NO      TO WS-CUSTOMER-NO        
                       MOVE WS-CUST-NO-NUM     TO CE-CUSTOMER-NO        
                       MOVE 'C'                TO CE-CUSTOMER-TYPE      
                       PERFORM 7011-SELECT-SSN    THRU 7011-EXIT        
                       MOVE CE-SSN             TO WS-CUST-SSN           
      *                Code-Value:'T'- Called Equifax                           
                       MOVE 'T '               TO WS-COMM-CODE(WS-CNT)  
                       ADD +1                  TO WS-CNT                
                    END-IF                                              
               WHEN 'C'                                                 
                    MOVE ZERO                  TO WS-DEPOSIT-AMT        
                    MOVE 'P'                   TO WS-WAIVER-REASON      
                    MOVE WS-ACCOUNT-NO-NUM     TO WS-WAIVER-ACCT        
      *             Code-Value:'U'- Exempt Credit Group                         
                    MOVE 'U '                  TO WS-COMM-CODE(WS-CNT)  
                    ADD +1                     TO WS-CNT                
      *             Code-Value:'I'- Deposit Waived                              
                    MOVE 'I '                  TO WS-COMM-CODE(WS-CNT)  
                    ADD +1                     TO WS-CNT                
               WHEN 'N'                                                 
      *             Code-Value:'X '- New Credit Group                           
                    MOVE 'X '                  TO WS-COMM-CODE(WS-CNT)  
                    ADD +1                     TO WS-CNT                
                    MOVE WS-ACCOUNT-NO-NUM     TO DO-ACCOUNT-NO         
                                                  DP-ACCOUNT-NO         
                                                  GU-ACCOUNT-NO         
                                                  AR-ACCOUNT-NO         
                    PERFORM 5600-CHECK-SEC-PRESENT     THRU 5600-EXIT   
                    IF WS-HAS-SECURITY                                  
      *                Code-Value:'Y '- Security Present                        
                       MOVE 'Y '               TO WS-COMM-CODE(WS-CNT)  
                       ADD +1                  TO WS-CNT                
                       IF WS-EQUIFAX-REASON = 'I'                       
                          IF WS-COMPANY-NO = '26'                       
                             MOVE WS-MAX-DEPOSIT-AMT   TO WS-DEPOSIT-AMT
      *                      Code-Value:'G'- Maximum Deposit Charged            
                             MOVE 'G '         TO WS-COMM-CODE(WS-CNT)  
                             ADD +1            TO WS-CNT                
                          ELSE                                          
                             MOVE WS-MIN-DEPOSIT-AMT   TO WS-DEPOSIT-AMT
      *                      Code-Value:'H'- Minimum Deposit Charged            
                             MOVE 'H '         TO WS-COMM-CODE(WS-CNT)  
                             ADD +1            TO WS-CNT                
                          END-IF                                        
                       ELSE                                             
                          MOVE 'Y'             TO WS-CALL-EQUIFAX       
                          MOVE WS-IN-CUST-NO   TO WS-CUSTOMER-NO        
                          MOVE WS-CUST-NO-NUM  TO CE-CUSTOMER-NO        
                          MOVE 'C'             TO CE-CUSTOMER-TYPE      
                          PERFORM 7011-SELECT-SSN      THRU 7011-EXIT   
                          MOVE CE-SSN          TO WS-CUST-SSN           
      *                   Code-Value:'T'- Called Equifax                        
                          MOVE 'T '            TO WS-COMM-CODE(WS-CNT)  
                          ADD +1               TO WS-CNT                
                       END-IF                                           
                    ELSE                                                
      *                Code-Value:'Z '- Security Absent                         
                       MOVE 'Z '               TO WS-COMM-CODE(WS-CNT)  
                       ADD +1                  TO WS-CNT                
P00518                 PERFORM 2210-GET-ARR-DEP        THRU 2210-EXIT   
                    END-IF                                              
           END-EVALUATE.                                                
      *                                                                         
       2200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2210-GET-ARR-DEP.                                              *        
      *     -Evaluates Deposit For Cusomers With Arrears Credit Group  *        
      ******************************************************************        
      *                                                                         
       2210-GET-ARR-DEP.                                                
      *                                                                         
           PERFORM 7060-SEL-REVENUE-MONTH      THRU 7060-EXIT.          
      *                                                                         
           EXEC SQL                                                     
                SELECT
              DATEADD( YEAR, -2, IIF(TRY_CONVERT(DATE, :WS-REVENUE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REVENUE-DT
              ) <> 0) OR (LEN(:WS-REVENUE-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REVENUE-DT
              ), CONVERT(DATE, :WS-REVENUE-DT) ) )
            INTO
              :WS-START-REV-DATE
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-START-REV-DATE =  DATE(:WS-REVENUE-DT) - 2 YEARS        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE WS-START-REV-DATE              TO WS-DATE-BILLED-START  
           MOVE WS-REVENUE-DT                  TO WS-DATE-BILLED-END    
      *                                                                         
           MOVE WS-START-REV-DATE(1:4)       TO WS-START-REV-MONTH(1:4) 
           MOVE WS-START-REV-DATE(6:2)       TO WS-START-REV-MONTH(5:2) 
      *                                                                         
           MOVE WS-ACCOUNT-NO-NUM              TO BI-ACCOUNT-NO.        
      *                                                                         
           PERFORM 7065-GET-BILLS-COUNT        THRU 7065-EXIT.          
           IF WS-NO-OF-BILLS >= 12                                      
              SET WS-HAS-CONS-SERV             TO TRUE                  
           ELSE                                                         
              SET WS-NO-CONS-SERV              TO TRUE                  
           END-IF.                                                      
      *                                                                         
           IF WS-HAS-CONS-SERV                                          
      *       Code-Value:'O'- Consecutive Service                               
              MOVE 'O '                        TO WS-COMM-CODE(WS-CNT)  
              ADD +1                           TO WS-CNT                
              MOVE WS-ACCOUNT-NO-NUM           TO AT-ACCOUNT-NO         
                                                  CZ-ACCOUNT-NO         
              PERFORM 5400-CHECK-FOR-GOOD-CRED THRU 5400-EXIT           
              IF WS-HAS-GOOD-CRED                                       
                 MOVE ZERO                     TO WS-DEPOSIT-AMT        
                 MOVE 'P'                      TO WS-WAIVER-REASON      
                 MOVE WS-ACCOUNT-NO-NUM        TO WS-WAIVER-ACCT        
      *          Code-Value:'P'- Good Credit Present                            
                 MOVE 'P '                     TO WS-COMM-CODE(WS-CNT)  
                 ADD +1                        TO WS-CNT                
      *          Code-Value:'I'- Deposit Waived                                 
                 MOVE 'I '                     TO WS-COMM-CODE(WS-CNT)  
                 ADD +1                        TO WS-CNT                
              ELSE                                                      
      *          Code-Value:'Q'-Good Credit Absent                              
                 MOVE 'Q '                     TO WS-COMM-CODE(WS-CNT)  
                 ADD +1                        TO WS-CNT                
                 IF WS-EQUIFAX-REASON = 'I'                             
                    IF WS-COMPANY-NO = '26'                             
                       MOVE WS-MAX-DEPOSIT-AMT TO WS-DEPOSIT-AMT        
      *                Code-Value:'G'- Maximum Deposit Charged                  
                       MOVE 'G '               TO WS-COMM-CODE(WS-CNT)  
                       ADD +1                  TO WS-CNT                
                    ELSE                                                
                       MOVE WS-MIN-DEPOSIT-AMT TO WS-DEPOSIT-AMT        
      *                Code-Value:'H'- Minumum Deposit Charged                  
                       MOVE 'H '               TO WS-COMM-CODE(WS-CNT)  
                       ADD +1                  TO WS-CNT                
                    END-IF                                              
                 ELSE                                                   
                    MOVE 'Y'                   TO WS-CALL-EQUIFAX       
                    MOVE WS-IN-CUST-NO         TO WS-CUSTOMER-NO        
                    MOVE WS-CUST-NO-NUM        TO CE-CUSTOMER-NO        
                    MOVE 'C'                   TO CE-CUSTOMER-TYPE      
                    PERFORM 7011-SELECT-SSN    THRU 7011-EXIT           
                    MOVE CE-SSN                TO WS-CUST-SSN           
      *             Code-Value:'T'- Called Equifax                              
                    MOVE 'T '                  TO WS-COMM-CODE(WS-CNT)  
                    ADD +1                     TO WS-CNT                
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
      *       Code-Value:'S'- No Consecutive Service                            
              MOVE 'S '                        TO WS-COMM-CODE(WS-CNT)  
              ADD +1                           TO WS-CNT                
              MOVE WS-ACCOUNT-NO-NUM           TO AT-ACCOUNT-NO         
                                                  CZ-ACCOUNT-NO         
              PERFORM 5500-CHECK-DNP-ARR-HIST  THRU 5500-EXIT           
      *                                                                         
              IF WS-HAS-NO-DNP                                          
                 MOVE ZERO                     TO WS-DEPOSIT-AMT        
                 MOVE 'P'                      TO WS-WAIVER-REASON      
                 MOVE WS-ACCOUNT-NO-NUM        TO WS-WAIVER-ACCT        
      *          Code-Value:'LL'- Has No DNP or Arrears Hist                    
                 MOVE 'LL'                     TO WS-COMM-CODE(WS-CNT)  
                 ADD +1                        TO WS-CNT                
      *          Code-Value:'I'- Deposit Waived                                 
                 MOVE 'I '                     TO WS-COMM-CODE(WS-CNT)  
                 ADD +1                        TO WS-CNT                
              ELSE                                                      
      *          Code-Value:'KK'- Has DNP or Arrears Hist                       
                 MOVE 'KK'                     TO WS-COMM-CODE(WS-CNT)  
                 ADD +1                        TO WS-CNT                
                 IF WS-EQUIFAX-REASON = 'I'                             
                    IF WS-COMPANY-NO = '26'                             
                       MOVE WS-MAX-DEPOSIT-AMT TO WS-DEPOSIT-AMT        
      *                Code-Value:'G'- Maximum Deposit Charged                  
                       MOVE 'G '               TO WS-COMM-CODE(WS-CNT)  
                       ADD +1                  TO WS-CNT                
                    ELSE                                                
                       MOVE WS-MIN-DEPOSIT-AMT TO WS-DEPOSIT-AMT        
      *                Code-Value:'H'- Minumum Deposit Charged                  
                       MOVE 'H '               TO WS-COMM-CODE(WS-CNT)  
                       ADD +1                  TO WS-CNT                
                    END-IF                                              
                 ELSE                                                   
                    MOVE 'Y'                   TO WS-CALL-EQUIFAX       
                    MOVE WS-IN-CUST-NO         TO WS-CUSTOMER-NO        
                    MOVE WS-CUST-NO-NUM        TO CE-CUSTOMER-NO        
                    MOVE 'C'                   TO CE-CUSTOMER-TYPE      
                    PERFORM 7011-SELECT-SSN    THRU 7011-EXIT           
                    MOVE CE-SSN                TO WS-CUST-SSN           
      *             Code-Value:'T'- Called Equifax                              
                    MOVE 'T '                  TO WS-COMM-CODE(WS-CNT)  
                    ADD +1                     TO WS-CNT                
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2210-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2300-PROCESS-MULTIPLE-SER.                                     *        
      *     -Processes The Cutomers Applied for Additional Service (>2)*        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-MULTIPLE-SER.                                       
      *                                                                         
      *    Code-Value:'EE'- Multiple Active Accounts                            
           MOVE 'EE'                          TO WS-COMM-CODE(WS-CNT).  
           ADD +1                             TO WS-CNT.                
           MOVE +0                            TO WS-ACTIV-ACCT-CNT      
                                                 WS-BAL-CR-GRP-CNT.     
      *                                                                         
           MOVE WS-CUST-NO-NUM                TO AT-CUSTOMER-NO.        
           MOVE 'N'                           TO WS-EOF-CURSOR.         
           PERFORM 7002-OPEN-ACTIVE-ACCTS     THRU 7002-EXIT.           
           PERFORM 7003-FETCH-ACTIVE-ACCTS    THRU 7003-EXIT.           
      *                                                                         
           PERFORM UNTIL NO-MORE-DATA OR WS-HAS-SECURITY                
              ADD  +1                         TO WS-ACTIV-ACCT-CNT      
              MOVE AT-ACCOUNT-NO              TO DO-ACCOUNT-NO          
                                                 DP-ACCOUNT-NO          
                                                 GU-ACCOUNT-NO          
                                                 WS-ACCOUNT-NO          
                                                 AR-ACCOUNT-NO          
              PERFORM 5600-CHECK-SEC-PRESENT  THRU 5600-EXIT            
              PERFORM 7003-FETCH-ACTIVE-ACCTS THRU 7003-EXIT            
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7004-CLOSE-ACTIVE-ACCTS    THRU 7004-EXIT.           
      *                                                                         
           IF WS-HAS-SECURITY                                           
      *       Code-Value:'Y '- Security present                                 
              MOVE 'Y '                       TO WS-COMM-CODE(WS-CNT)   
              ADD +1                          TO WS-CNT                 
              IF WS-EQUIFAX-REASON = 'I'                                
                 IF WS-COMPANY-NO = '26'                                
                    MOVE WS-MAX-DEPOSIT-AMT   TO WS-DEPOSIT-AMT         
      *             Code-Value:'G'- Maximum Deposit Charged                     
                    MOVE 'G '                 TO WS-COMM-CODE(WS-CNT)   
                    ADD +1                    TO WS-CNT                 
                 ELSE                                                   
                    MOVE WS-MIN-DEPOSIT-AMT   TO WS-DEPOSIT-AMT         
      *             Code-Value:'H'- Minimum Deposit Charged                     
                    MOVE 'H '                 TO WS-COMM-CODE(WS-CNT)   
                    ADD +1                    TO WS-CNT                 
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'Y'                     TO WS-CALL-EQUIFAX        
                 MOVE WS-IN-CUST-NO           TO WS-CUSTOMER-NO         
                 MOVE WS-CUST-NO-NUM          TO CE-CUSTOMER-NO         
                 MOVE 'C'                     TO CE-CUSTOMER-TYPE       
                 PERFORM 7011-SELECT-SSN      THRU 7011-EXIT            
                 MOVE CE-SSN                  TO WS-CUST-SSN            
      *          Code-Value:'T'- Called Equifax                                 
                 MOVE 'T '                    TO WS-COMM-CODE(WS-CNT)   
                 ADD +1                       TO WS-CNT                 
              END-IF                                                    
           ELSE                                                         
      *       Code-Value:'Z '- Security Absent                                  
              MOVE 'Z '                       TO WS-COMM-CODE(WS-CNT)   
              ADD +1                          TO WS-CNT                 
              MOVE 'N'                        TO WS-EOF-CURSOR          
              PERFORM 7002-OPEN-ACTIVE-ACCTS  THRU 7002-EXIT            
              PERFORM 7003-FETCH-ACTIVE-ACCTS THRU 7003-EXIT            
      *                                                                         
              PERFORM UNTIL NO-MORE-DATA OR WS-EXEMPT                   
                 MOVE AT-ACCOUNT-NO           TO WS-ACCOUNT-NO-NUM      
                 EVALUATE AT-CREDIT-GROUP                               
                     WHEN 'C'                                           
                          SET WS-EXEMPT       TO TRUE                   
                     WHEN 'B'                                           
                          ADD  +1             TO WS-BAL-CR-GRP-CNT      
                     WHEN OTHER                                         
                          CONTINUE                                      
                 END-EVALUATE                                           
                 PERFORM 7003-FETCH-ACTIVE-ACCTS   THRU 7003-EXIT       
              END-PERFORM                                               
      *                                                                         
              PERFORM 7004-CLOSE-ACTIVE-ACCTS THRU 7004-EXIT            
      *                                                                         
              EVALUATE TRUE                                             
                  WHEN WS-EXEMPT                                        
                       MOVE ZERO              TO WS-DEPOSIT-AMT         
                       MOVE 'P'               TO WS-WAIVER-REASON       
                       MOVE WS-ACCOUNT-NO-NUM TO WS-WAIVER-ACCT         
      *                Code-Value:'U'- Exempt Credit Group                      
                       MOVE 'U '              TO WS-COMM-CODE(WS-CNT)   
                       ADD +1                 TO WS-CNT                 
      *                Code-Value:'I'- Deposit Waived                           
                       MOVE 'I '              TO WS-COMM-CODE(WS-CNT)   
                       ADD +1                 TO WS-CNT                 
                  WHEN WS-ACTIV-ACCT-CNT = WS-BAL-CR-GRP-CNT            
      *                Code-Value:'R '- All in Balance Credit Group             
                       MOVE 'R '              TO WS-COMM-CODE(WS-CNT)   
                       ADD +1                 TO WS-CNT                 
                       IF WS-EQUIFAX-REASON = 'I'                       
                          IF WS-COMPANY-NO = '26'                       
                             MOVE WS-MAX-DEPOSIT-AMT TO WS-DEPOSIT-AMT  
      *                      Code-Value:'G'- Maximum Deposit Charged            
                             MOVE 'G '        TO WS-COMM-CODE(WS-CNT)   
                             ADD +1           TO WS-CNT                 
                          ELSE                                          
                             MOVE WS-MIN-DEPOSIT-AMT TO WS-DEPOSIT-AMT  
      *                      Code-Value:'H'- Minimum Deposit Charged            
                             MOVE 'H '        TO WS-COMM-CODE(WS-CNT)   
                             ADD +1           TO WS-CNT                 
                          END-IF                                        
                       ELSE                                             
                          MOVE 'Y'            TO WS-CALL-EQUIFAX        
                          MOVE WS-IN-CUST-NO  TO WS-CUSTOMER-NO         
                          MOVE WS-CUST-NO-NUM TO CE-CUSTOMER-NO         
                          MOVE 'C'            TO CE-CUSTOMER-TYPE       
                          PERFORM 7011-SELECT-SSN    THRU 7011-EXIT     
                          MOVE CE-SSN         TO WS-CUST-SSN            
      *                   Code-Value:'T'- Called Equifax                        
                          MOVE 'T '           TO WS-COMM-CODE(WS-CNT)   
                          ADD +1              TO WS-CNT                 
                       END-IF                                           
                  WHEN OTHER                                            
                       IF WS-EQUIFAX-REASON = 'I'                       
                          SET WS-C-AND-Q      TO TRUE                   
      *                   Code-Value:'A'- Capture En-Queue                      
                          MOVE 'A '           TO WS-COMM-CODE(WS-CNT)   
                          ADD +1              TO WS-CNT                 
      *                   Code-Value:'FF'- Cred Grp Not Exempt/Bal              
                          MOVE 'FF'           TO WS-COMM-CODE(WS-CNT)   
                          ADD +1              TO WS-CNT                 
                       ELSE                                             
                          MOVE 'Y'            TO WS-CALL-EQUIFAX        
                          MOVE WS-IN-CUST-NO  TO WS-CUSTOMER-NO         
                          MOVE WS-CUST-NO-NUM TO CE-CUSTOMER-NO         
                          MOVE 'C'            TO CE-CUSTOMER-TYPE       
                          PERFORM 7011-SELECT-SSN    THRU 7011-EXIT     
                          MOVE CE-SSN         TO WS-CUST-SSN            
      *                   Code-Value:'T'- Called Equifax                        
                          MOVE 'T '           TO WS-COMM-CODE(WS-CNT)   
                          ADD +1                     TO WS-CNT          
                       END-IF                                           
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2006-SET-PROCESS-CODE.                                         *        
      *     -Set The Process Code For Output                           *        
      ******************************************************************        
      *                                                                         
       2400-SET-PROCESS-CODE.                                           
      *                                                                         
           EVALUATE TRUE                                                
               WHEN NOT WS-C-AND-Q AND WS-CALL-EQUIFAX = 'N'            
                    MOVE 'R'               TO WS-PROCESS-CODE           
               WHEN WS-C-AND-Q                                          
                    MOVE 'C'               TO WS-PROCESS-CODE           
               WHEN WS-CALL-EQUIFAX = 'Y'                               
                    MOVE 'T'               TO WS-PROCESS-CODE           
           END-EVALUATE.                                                
      *                                                                         
       2400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2500-PROCESS-COMM-DETAILS.                                     *        
      *     -Process and Insert Communication Record.                  *        
      ******************************************************************        
      *                                                                         
       2500-PROCESS-COMM-DETAILS.                                       
      *                                                                         
           MOVE 'N'                        TO WS-EOF-CURSOR.            
           SET WS-IDX-C                    TO 1.                        
           PERFORM 7100-OPEN-CODE-VALUES   THRU 7100-EXIT.              
           PERFORM 7101-FETCH-CODE-VALUES  THRU 7101-EXIT.              
      *                                                                         
           PERFORM UNTIL NO-MORE-DATA                                   
              MOVE UV-CODE-VALUE-TEXT      TO WS-CODE-VALUE(WS-IDX-C)   
              MOVE UV-CODE-LONG-DESC-TEXT  TO                           
                                          WS-CODE-LONG-DESC(WS-IDX-C)   
              SET WS-IDX-C UP BY 1                                      
              PERFORM 7101-FETCH-CODE-VALUES                            
                                           THRU 7101-EXIT               
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7102-CLOSE-CODE-VALUES  THRU 7102-EXIT.              
      *                                                                         
      * For capture En-Queued customers append the text in the begining         
      *                                                                         
           SET WS-IDX-C                    TO 1.                        
           SET WS-IDX-F                    TO 1.                        
           IF WS-C-AND-Q                                                
              SEARCH WS-CODE-ARRAY                                      
                WHEN WS-CODE-VALUE(WS-IDX-C) = 'A'                      
                     MOVE SPACES           TO WS-CODE-DESC-TEXT         
                     MOVE WS-CODE-LONG-DESC(WS-IDX-C)                   
                                           TO WS-CODE-DESC-TEXT         
                     PERFORM 5700-REFORMAT-COMM-TEXT                    
                                           THRU 5700-EXIT               
                     IF WS-IDX-F > 225                                  
                        NEXT SENTENCE                                   
                     END-IF                                             
              END-SEARCH                                                
           END-IF.                                                      
      *                                                                         
           SET WS-IDX-C                    TO 1.                        
           SET WS-IDX-D                    TO 1.                        
           MOVE +1                         TO WS-I.                     
           PERFORM WS-CNT TIMES                                         
              SEARCH WS-CODE-ARRAY                                      
                WHEN WS-COMM-CODE(WS-I) = 'A'                           
                     CONTINUE                                           
                WHEN WS-COMM-CODE(WS-I) = WS-CODE-VALUE(WS-IDX-C)       
                     MOVE SPACES           TO WS-CODE-DESC-TEXT         
                     MOVE WS-CODE-LONG-DESC(WS-IDX-C)                   
                                           TO WS-CODE-DESC-TEXT         
                     PERFORM 5700-REFORMAT-COMM-TEXT                    
                                           THRU 5700-EXIT               
                     IF WS-COMM-CODE(WS-I) = 'G' OR 'H' OR 'JJ'         
                        SET WS-IDX-F DOWN BY 2                          
                        MOVE WS-DEPOSIT-AMT      TO  WS-DEPOSIT-AMT-EDT 
                        MOVE WS-DEPOSIT-AMT-EDT  TO  WS-CODE-DESC-TEXT  
                        PERFORM 5700-REFORMAT-COMM-TEXT                 
                                                 THRU 5700-EXIT         
                     END-IF                                             
                     IF WS-IDX-F > 225                                  
                        NEXT SENTENCE                                   
                     END-IF                                             
              END-SEARCH                                                
              ADD +1                       TO WS-I                      
              SET WS-IDX-C                 TO 1                         
           END-PERFORM.                                                 
      *                                                                         
           SET WS-IDX-F DOWN BY 2.                                      
           MOVE SPACE                      TO WS-FINAL-COMM(WS-IDX-F).  
           SET WS-IDX-F UP BY   1.                                      
           MOVE SPACE                      TO WS-FINAL-COMM(WS-IDX-F).  
      *                                                                         
           MOVE WS-IN-CUST-NO              TO KO-CUSTOMER-NO            
           MOVE 0                          TO KO-ACCOUNT-NO             
           MOVE WS-PREMISE-NO              TO KO-PREMISE-NO.            
           MOVE WS-COMPANY-NO              TO KO-COMPANY-NO.            
           MOVE 'Z'                        TO KO-COMM-METHOD.           
           MOVE 'I'                        TO KO-COMM-DIRECTION.        
           MOVE '41'                       TO KO-COMM-TYPE-CD.          
           MOVE '10'                       TO KO-COMM-SUBTYPE-CODE.     
           MOVE 'WEBTRN1'                  TO KO-USER-ID-ORIG.          
           MOVE LENGTH OF WS-FINAL-COMM-TEXT                            
                                           TO KO-INITIAL-COMMENT-TX-LEN 
           MOVE WS-FINAL-COMM-TEXT         TO KO-INITIAL-COMMENT-TX-TEXT
           MOVE 'N'                        TO KO-RED-FLAG-IND.          
           MOVE SPACES                     TO KO-RED-FLAG-EXPIRE-DT.    
           MOVE -1                         TO WS-RED-FL-NULL-IND.       
      *    MOVE SPACES                     TO KO-CONTACT-NAME.                  
           MOVE SPACES                     TO KO-PROMOTION-ID.          
           MOVE 'N'                        TO KO-PSC-COMPLIANCE-IND.    
           MOVE 0                          TO KO-CALL-ORIGIN-ID.        
           MOVE SPACES                     TO KO-CALL-END-TIME.         
           MOVE -1                         TO WS-END-NULL-IND.          
           MOVE 0                          TO KO-NUMBER-TRANSFERS.      
           MOVE 0                          TO KO-HOLD-TIME.             
           MOVE 0                          TO KO-QUEUE-TIME.            
           MOVE 'N'                        TO KO-SCREEN-POP-IND.        
           MOVE 0                          TO KO-TOTAL-CALL-TIME.       
           MOVE SPACES                     TO KO-RESPONSE-REASON-CD.    
           MOVE SPACES                     TO KO-RESPONSE-TYPE-CD.      
           MOVE SPACES                     TO KO-SOLICITATION-CD.       
           MOVE 'C'                        TO KO-COMM-ASSOC-CD.         
           MOVE 'N'                        TO KO-COMPLAINT-FL.          
           MOVE SPACES                     TO KO-DISCOVERY-MTHD-CD.     
           MOVE SPACES                     TO KO-PREV-MARKETER-CD.      
      *                                                                         
      *** POPULATE CONTACT NAME ON COMM RECORD.                                 
           MOVE WS-IN-CUST-NO              TO WS-CUSTOMER-NO.           
           MOVE WS-CUST-NO-NUM             TO CE-CUSTOMER-NO.           
           PERFORM 7006-GET-CUST-DETAILS THRU 7006-EXIT.                
                                                                        
           MOVE 70                          TO WS-EMB-LENG              
           STRING DQ-LAST-NAME,                                         
                  ', ',                                                 
                  DQ-FIRST-NAME,                                        
                  ' ',                                                  
                  DQ-MIDDLE-NAME                                        
           DELIMITED BY SIZE INTO WS-EMB-INPUT.                         
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
           MOVE WS-CMP-TABLE               TO WS-TEMP-CONTACT-NAME.     
           MOVE WS-TEMP-CONTACT-NAME       TO WS-CONTACT-NAME.          
      *                                                                         
           MOVE WS-CONTACT-NAME            TO KO-CONTACT-NAME.          
      *                                                                         
           PERFORM 7103-INSERT-COMM-DATA   THRU 7103-EXIT.              
      *                                                                         
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5000-CHECK-ACCT-STATUS                                         *        
      *     -Retuns Whether the Cutomer Is Account Holder or Not.      *        
      *     -If Account Holder Has How Many Active Accounts.           *        
      ******************************************************************        
      *                                                                         
       5000-CHECK-ACCT-STATUS.                                          
      *                                                                         
           PERFORM 7001-ACCT-LOOK-UP       THRU 7001-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              SET WS-NOT-ACCT-HOLDER       TO TRUE                      
              SET WS-NO-ACTIVE-ACCT        TO TRUE                      
           ELSE                                                         
              SET WS-ACCT-HOLDER           TO TRUE                      
           END-IF.                                                      
           IF WS-ACCT-HOLDER                                            
              PERFORM 7009-ACTIV-ACCT-LOOK-UP  THRU 7009-EXIT           
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                  WHEN SUCCESSFUL-CALL                                  
                       SET WS-ONE-ACTIVE-ACCT   TO TRUE                 
                  WHEN NOT-FOUND                                        
                       SET WS-NO-ACTIVE-ACCT    TO TRUE                 
                  WHEN WS-MULTIPLE-ROWS                                 
                       SET WS-MULTI-ACTIVE-ACCT    TO TRUE              
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5200-CHECK-SERV-AT-NEW-PR.                                     *        
      *     -Retuns The Service Type At A Premise. (Elec/Gas/Combo)    *        
      ******************************************************************        
      *                                                                         
       5200-CHECK-SERV-AT-NEW-PR.                                       
      *                                                                         
           MOVE WS-PREMISE-NO-NUM                  TO UT-PREMISE-NO.    
           MOVE 'N'                                TO WS-EOF-CURSOR.    
           PERFORM 7070-OPEN-SERVICE-TYPE-CUR      THRU 7070-EXIT.      
           PERFORM 7071-FETCH-SERVICE-TYPE-CUR     THRU 7071-EXIT.      
           PERFORM UNTIL NO-MORE-DATA                                   
               IF UT-CODE-UTIL-TYPE = 'E'                               
                  SET WS-ELEC-ONLY                 TO TRUE              
               END-IF                                                   
               IF UT-CODE-UTIL-TYPE = 'G'                               
                  SET WS-GAS-ONLY                  TO TRUE              
               END-IF                                                   
               PERFORM 7071-FETCH-SERVICE-TYPE-CUR THRU 7071-EXIT       
           END-PERFORM.                                                 
           IF WS-ELEC-ONLY AND  WS-GAS-ONLY                             
              SET WS-COMBO                         TO TRUE              
              MOVE SPACE                           TO WS-SERVICE-ELEC   
                                                      WS-SERVICE-GAS    
           END-IF.                                                      
           PERFORM 7072-CLOSE-SERVICE-TYPE-CUR     THRU 7072-EXIT.      
      *                                                                         
       5200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5400-CHECK-FOR-GOOD-CRED.                                      *        
      *     -Evaluated the Arrears, Dis-Connection, Dis-Connection     *        
      *      Exemption Histories And Retuns Cusomert Has Good/Bad Cred *        
P00399*      FOR PSNC, DO NOT CONSIDER CONSECUTIVE ARREARS.            *        
      ******************************************************************        
      *                                                                         
       5400-CHECK-FOR-GOOD-CRED.                                        
      *                                                                         
P00399     MOVE ZERO                  TO WS-RETAIN-COMMER-DEP           
P00399                                   WS-RETAIN-INDUST-DEP           
P00399                                   WS-RETAIN-RESIDENT-DEP         
P00399                                   WS-RETAIN-DEL-MTHS             
P00399     MOVE WS-COMPANY-NO         TO C8-COMPANY-NO                  
P00399     MOVE 'RETAIN-RESIDENT-DEP' TO C8-DELINQ-CD                   
P00399     PERFORM 7104-GET-DLINQ-VAL THRU 7104-EXIT                    
P00399     MOVE C8-DELINQ-VALUE       TO WS-RETAIN-RESIDENT-DEP         
P00399     MOVE 'RETAIN-COMMER-DEP'   TO C8-DELINQ-CD                   
P00399     PERFORM 7104-GET-DLINQ-VAL THRU 7104-EXIT                    
P00399     MOVE C8-DELINQ-VALUE       TO WS-RETAIN-COMMER-DEP           
P00399     MOVE 'RETAIN-INDUST-DEP'   TO C8-DELINQ-CD                   
P00399     PERFORM 7104-GET-DLINQ-VAL THRU 7104-EXIT                    
P00399     MOVE C8-DELINQ-VALUE       TO WS-RETAIN-INDUST-DEP           
      *                                                                         
P00399     MOVE SPACES                 TO WS-ACCOUNT-TYPE-CODE          
P00399     PERFORM 7105-GET-ACCOUNT-TYPE         THRU 7105-EXIT         
P00399     MOVE AT-ACCOUNT-TYPE-CODE   TO WS-ACCOUNT-TYPE-CODE          
      *                                                                         
P00399     EVALUATE WS-ACCOUNT-TYPE-CODE                                
P00399       WHEN 'C'                                                   
P00399           MOVE WS-RETAIN-COMMER-DEP   TO WS-RETAIN-DEL-MTHS      
P00399       WHEN 'I'                                                   
P00399           MOVE WS-RETAIN-INDUST-DEP   TO WS-RETAIN-DEL-MTHS      
P00399       WHEN 'R'                                                   
P00399           MOVE WS-RETAIN-RESIDENT-DEP TO WS-RETAIN-DEL-MTHS      
P00399       WHEN OTHER                                                 
P00399           MOVE 12                     TO WS-RETAIN-DEL-MTHS      
P00399     END-EVALUATE                                                 
      *                                                                 02175000
           PERFORM 7010-SEL-CRED-PROFILE        THRU 7010-EXIT          
P00471     MOVE CZ-DISCONNECT-HIST    TO WS-DISCONNECT-HIST-CZ          
P00471     MOVE CZ-DISC-EXCEPTN-HIST  TO WS-DISC-EXCEPTN-HIST-CZ        
P00471     MOVE WS-DISCONNECT-HIST-CZ    TO WS-ACCT-DISCONNECT-HST      
P00471     MOVE WS-DISC-EXCEPTN-HIST-CZ  TO WS-ACCT-DISC-EXCEPTN-HST    
      *                                                                         
P00399     MOVE 0                     TO WS-ELIG-NO-MTHS                
P00399                                   WS-DELINQ-MTH                  
P00399                                   WS-ARRS-CNT                    
P00399     MOVE 'N'                   TO WS-NOT-USE-CR-HIST-FL          
P00399                                   WS-FORECAST-CRED-GR-FL         
P00399     MOVE SPACES                TO WS-ACCT-HST                    
P00399     MOVE PROGRAM-NAME          TO WS-PROGRAM-CPD334              
P00399     MOVE WS-RETAIN-DEL-MTHS    TO WS-ELIG-NO-MTHS                
P00399                                   WS-DELINQ-MTH                  
P00399     MOVE CZ-ARREARS-HIST(1:WS-RETAIN-DEL-MTHS)                   
P00399                                TO WS-ACCT-HST                    
P00399     MOVE WS-COMPANY-NO         TO WS-COMPANY-CPD334              
P00399     PERFORM 6565-PROCESS-CREDIT-RULE    THRU 6565-EXIT           
P00399     IF WS-COMPANY-NO = '01'                                      
P00399        IF ( WS-ENOUGH-CREDIT-HIST = 'Y' AND                      
P00399           ( WS-CONSEC-CNT = 0 AND WS-NON-CONSEC-CNT <= 2 ) )     
P00399           SET WS-HAS-GOOD-CRED   TO TRUE                         
P00399        ELSE                                                      
P00399           SET WS-HAS-BAD-CRED    TO TRUE                         
P00399        END-IF                                                    
P00399     ELSE                                                         
P00399        IF ( WS-ENOUGH-CREDIT-HIST = 'Y' AND                      
P00399             WS-ARRS-CNT <= 2 )                                   
P00399           SET WS-HAS-GOOD-CRED   TO TRUE                         
P00399        ELSE                                                      
P00399           SET WS-HAS-BAD-CRED    TO TRUE                         
P00399        END-IF                                                    
P00399     END-IF.                                                      
      *                                                                         
       5400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5500-CHECK-DNP-ARR-HIST.                                       *        
      *     -Evaluated the Arrears, Dis-Connection, Dis-Connection     *        
      *      Exemption Histories And Retuns Cusomert Has any DNP/Arr   *        
      *     -Looks For At Least One Arrear                             *        
      ******************************************************************        
      *                                                                         
       5500-CHECK-DNP-ARR-HIST.                                         
      *                                                                         
            PERFORM 7010-SEL-CRED-PROFILE        THRU 7010-EXIT.        
      *                                                                         
            MOVE CZ-ARREARS-HIST(1:12)           TO WS-CUST-ARR-HST     
            MOVE 1                               TO WS-I                
            PERFORM 12 TIMES                                            
               IF WS-CUST-ARR-HST(WS-I:1) >= 1                          
                  ADD +1                         TO WS-CUST-ARR-CNT     
               END-IF                                                   
               ADD +1                            TO WS-I                
            END-PERFORM.                                                
            IF WS-CUST-ARR-CNT > 0                                      
               SET WS-HAS-DNP           TO TRUE                         
            ELSE                                                        
               SET WS-HAS-NO-DNP        TO TRUE                         
            END-IF.                                                     
      *                                                                         
P00471      IF WS-COMPANY-NO = '26'                                     
               IF WS-HAS-NO-DNP                                         
                  MOVE 1                         TO WS-I                
                  MOVE CZ-DISCONNECT-HIST(1:12)  TO WS-DISCONNECT-HIST  
                  PERFORM UNTIL WS-I > 12 OR WS-HAS-GOOD-CRED           
                     IF WS-DISCONNECT-HIST(WS-I:1) = '3' OR             
                        WS-DISCONNECT-HIST(WS-I:1) = '4' OR             
                        WS-DISCONNECT-HIST(WS-I:1) = 'I' OR             
                        WS-DISCONNECT-HIST(WS-I:1) = 'R'                
                        SET WS-HAS-DNP           TO TRUE                
                     END-IF                                             
                     ADD +1                      TO WS-I                
                  END-PERFORM                                           
               END-IF                                                   
      *                                                                         
               IF WS-HAS-NO-DNP                                         
                  MOVE 1                         TO WS-I                
                  MOVE CZ-DISC-EXCEPTN-HIST(1:12) TO                    
                                                  WS-DISC-EXCEPTN-HIST  
                  PERFORM UNTIL WS-I > 12 OR WS-HAS-GOOD-CRED           
                     IF WS-DISC-EXCEPTN-HIST(WS-I:1) = '3' OR           
                        WS-DISC-EXCEPTN-HIST(WS-I:1) = '4' OR           
                        WS-DISC-EXCEPTN-HIST(WS-I:1) = 'I' OR           
                        WS-DISC-EXCEPTN-HIST(WS-I:1) = 'R'              
                        SET WS-HAS-DNP           TO TRUE                
                     END-IF                                             
                     ADD +1                      TO WS-I                
                  END-PERFORM                                           
               END-IF                                                   
P00471      END-IF.                                                     
      *                                                                         
       5500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5600-CHECK-SEC-PRESENT.                                        *        
      *     -Retuns Whether The Cutomers Has Security or Not.          *        
      *     -If Security Presents then Security Amount.                *        
      ******************************************************************        
      *                                                                         
       5600-CHECK-SEC-PRESENT.                                          
      *                                                                         
           IF WS-NO-ACTIVE-ACCT                                         
              PERFORM 7076-SEL-DEP-AT-FB         THRU 7076-EXIT         
           ELSE                                                         
              PERFORM 7067-SEL-DEPOSIT-AMT       THRU 7067-EXIT         
           END-IF.                                                      
           IF WS-NULL-IND-1 < 0                                         
              MOVE +0                            TO WS-DEP-PAY-AMT      
              PERFORM 7068-SEL-GUARANTOR         THRU 7068-EXIT         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET WS-NO-SECURITY              TO TRUE                
              ELSE                                                      
                 SET WS-HAS-SECURITY             TO TRUE                
              END-IF                                                    
           ELSE                                                         
              SET WS-HAS-SECURITY                TO TRUE                
           END-IF.                                                      
      *                                                                         
       5600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5700-REFORMAT-COMM-TEXT.                                       *        
      *     -Formats the Communication Text.                           *        
      ******************************************************************        
      *                                                                         
       5700-REFORMAT-COMM-TEXT.                                         
      *                                                                         
           MOVE SPACES                           TO WS-PREV-CHAR        
                                                    WS-FORMAT.          
           SET WS-IDX-D                          TO 1.                  
      *                                                                         
           PERFORM UNTIL (WS-IDX-D > 80 OR FORMAT-DONE)                 
              IF (WS-CODE-DESC(WS-IDX-D) = SPACE OR LOW-VALUES          
                                           OR HIGH-VALUES)              
                AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES) 
                IF WS-IDX-D > 1                                         
                   SET WS-IDX-F DOWN BY 1                               
                   MOVE '/'                   TO WS-FINAL-COMM(WS-IDX-F)
                   SET WS-IDX-F UP BY 1                                 
                   MOVE '/'                   TO WS-FINAL-COMM(WS-IDX-F)
                   SET WS-IDX-F UP BY 1                                 
                END-IF                                                  
                MOVE 'Y'                      TO WS-FORMAT              
              ELSE                                                      
                MOVE WS-CODE-DESC(WS-IDX-D)   TO WS-FINAL-COMM(WS-IDX-F)
                                                 WS-PREV-CHAR           
                SET WS-IDX-D, WS-IDX-F UP BY 1                          
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       5700-EXIT.                                                       
            EXIT.                                                       
P00399******************************************************************        
P00399*6565-PROCESS-CREDIT-RULE                                        *        
P00399******************************************************************        
P00399*                                                                         
P00399     EXEC SQL                                                             
P00399          INCLUDE CPD00334                                                
P00399     END-EXEC.                                                            
P00399*                                                                         
      ******************************************************************        
      * 7001-ACCT-LOOK-UP                                              *        
      ******************************************************************        
      *                                                                         
       7001-ACCT-LOOK-UP.                                               
      *                                                                         
            EXEC SQL                                                    
                                                                        
                 SELECT                                                 
                        AT.ACCOUNT_NO                                   
                   INTO                                                 
                        :AT-ACCOUNT-NO                                  
                   FROM                                                 
                        CSS_ACCOUNT AT                                  
                  WHERE                                                 
                        AT.CUSTOMER_NO    = :AT-CUSTOMER-NO             
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
             WHEN NOT-FOUND                                             
             WHEN WS-MULTIPLE-ROWS                                      
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7001'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'WS-CUSTOMER-NO'        TO TABLE-ELEMENT-1          
               MOVE WS-CUST-NO-NUM          TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7001-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7002-OPEN-ACTIVE-ACCTS.                                        *        
      ******************************************************************        
      *                                                                         
       7002-OPEN-ACTIVE-ACCTS.                                          
      *                                                                         
           EXEC SQL                                                     
                OPEN ACTIVE_ACCTS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7002'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE WS-CUST-NO-NUM           TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_ACCT_STAT'         TO TABLE-ELEMENT-2          
              MOVE 'A'                      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7002-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7003-FETCH-ACTIVE-ACCTS.                                       *        
      ******************************************************************        
      *                                                                         
       7003-FETCH-ACTIVE-ACCTS.                                         
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                      ACTIVE_ACCTS                                      
                 INTO                                                   
                      :AT-ACCOUNT-NO                                    
                     ,:AT-CREDIT-GROUP                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA        TO TRUE                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '7003'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE 'CSS_ACCOUNT'      TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE 'Y'                TO HOSTVAR-ELEMENT-1        
                    MOVE 'CODE_ACCT_STAT'   TO TABLE-ELEMENT-2          
                    MOVE 'A'                TO HOSTVAR-ELEMENT-2        
                    PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       7003-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7004-CLOSE-ACTIVE-ACCTS.                                       *        
      ******************************************************************        
      *                                                                         
       7004-CLOSE-ACTIVE-ACCTS.                                         
      *                                                                         
           EXEC SQL                                                     
                CLOSE ACTIVE_ACCTS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7004'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE WS-CUST-NO-NUM           TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_ACCT_STAT'         TO TABLE-ELEMENT-2          
              MOVE 'A'                      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7004-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7005-SEL-CUST-NO                                               *        
      ******************************************************************        
      *                                                                         
       7005-SEL-CUST-NO.                                                
      *                                                                         
           EXEC SQL                                                     
                 SELECT                                                 
                        CE.CUSTOMER_NO                                  
                   INTO                                                 
                        :CE-CUSTOMER-NO                                 
                   FROM                                                 
                        CSS_CUST_STATS CE                               
                  WHERE                                                 
                        CE.SSN           = :CE-SSN                      
                    AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
             WHEN NOT-FOUND                                             
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7005'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_CUST_STATS'        TO TABLE-1                  
               MOVE 'WS-CUSTOMER-NO'        TO TABLE-ELEMENT-1          
               MOVE 'WS-CUSTOMER-TYPE'      TO TABLE-ELEMENT-2          
               MOVE WS-SPOUSE-SSN           TO HOSTVAR-ELEMENT-1        
               MOVE CE-CUSTOMER-TYPE        TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * SELECTS CUTOMER NAME.                                          *        
      ******************************************************************        
       7006-GET-CUST-DETAILS.                                           
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME                                     
                  INTO :DQ-FIRST-NAME,                                  
                       :DQ-MIDDLE-NAME,                                 
                       :DQ-LAST-NAME                                    
                  FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                 
                       CSS_NAME DQ WITH(READUNCOMMITTED),                       
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                 WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO               
                   AND CE.CUSTOMER_TYPE = 'C'                           
                   AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                
                   AND CE.NAME_ID       = HT.NAME_ID                    
                   AND HT.NAME_ID       = DQ.NAME_ID                    
                                                 
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DQ.FIRST_NAME,                                           
MFA-TR*                DQ.MIDDLE_NAME,                                          
MFA-TR*                DQ.LAST_NAME                                             
MFA-TR*           INTO :DQ-FIRST-NAME,                                          
MFA-TR*                :DQ-MIDDLE-NAME,                                         
MFA-TR*                :DQ-LAST-NAME                                            
MFA-TR*           FROM CSS_CUST_STATS CE,                                       
MFA-TR*                CSS_NAME DQ,                                             
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*          WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                       
MFA-TR*            AND CE.CUSTOMER_TYPE = 'C'                                   
MFA-TR*            AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                        
MFA-TR*            AND CE.NAME_ID       = HT.NAME_ID                            
MFA-TR*            AND HT.NAME_ID       = DQ.NAME_ID                            
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7006'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
              MOVE 'CSS_NAME'                TO TABLE-2                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-3                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7006-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7007-SEL-CREDIT-GROUP                                          *        
      ******************************************************************        
      *                                                                         
       7007-SEL-CREDIT-GROUP.                                           
      *                                                                         
            EXEC SQL                                                    
                 SELECT                                                 
                         AT.ACCOUNT_NO                                  
                        ,AT.CREDIT_GROUP                                
                   INTO                                                 
                         :AT-ACCOUNT-NO                                 
                        ,:AT-CREDIT-GROUP                               
                   FROM                                                 
                        CSS_ACCOUNT AT                                  
                  WHERE                                                 
                        AT.CUSTOMER_NO    = :AT-CUSTOMER-NO             
                    AND AT.CODE_ACCT_STAT = 'A'                         
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7007'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE WS-CUST-NO-NUM          TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7007-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7009-ACTIV-ACCT-LOOK-UP                                        *        
      ******************************************************************        
      *                                                                         
       7009-ACTIV-ACCT-LOOK-UP.                                         
      *                                                                         
            EXEC SQL                                                    
                                                                        
                 SELECT                                                 
                        ACCOUNT_NO                                      
                   INTO                                                 
                        :AT-ACCOUNT-NO                                  
                   FROM                                                 
                        CSS_ACCOUNT AT                                  
                  WHERE                                                 
                        AT.CUSTOMER_NO    = :AT-CUSTOMER-NO             
                    AND AT.CODE_ACCT_STAT = 'A'                         
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
             WHEN NOT-FOUND                                             
             WHEN WS-MULTIPLE-ROWS                                      
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7001'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'WS-CUSTOMER-NO'        TO TABLE-ELEMENT-1          
               MOVE WS-CUST-NO-NUM          TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7009-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7010-SEL-CRED-PROFILE.                                         *        
      ******************************************************************        
      *                                                                         
       7010-SEL-CRED-PROFILE.                                           
      *                                                                         
            EXEC SQL                                                    
                 SELECT                                                 
                         CZ.ARREARS_HIST                                
                        ,CZ.DISCONNECT_HIST                             
                        ,CZ.DISC_EXCEPTN_HIST                           
                   INTO                                                 
                         :CZ-ARREARS-HIST                               
                        ,:CZ-DISCONNECT-HIST                            
                        ,:CZ-DISC-EXCEPTN-HIST                          
                   FROM                                                 
                        CSS_CREDIT_PROFILE CZ                           
                  WHERE                                                 
                        CZ.ACCOUNT_NO    = :CZ-ACCOUNT-NO               
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
             WHEN NOT-FOUND                                             
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7020'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_CREDIT_PROFILE'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7010-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7011-SELECT-SSN.                                               *        
      ******************************************************************        
      *                                                                         
       7011-SELECT-SSN.                                                 
      *                                                                         
           EXEC SQL                                                     
                 SELECT                                                 
                        CE.SSN                                          
                   INTO                                                 
                        :CE-SSN                                         
                   FROM                                                 
                        CSS_CUST_STATS CE                               
                  WHERE                                                 
                        CE.CUSTOMER_NO   = :CE-CUSTOMER-NO              
                    AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
             WHEN NOT-FOUND                                             
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7011'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_CUST_STATS'        TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE 'CUSTOMER_TYPE'         TO TABLE-ELEMENT-2          
               MOVE WS-CUST-NO-NUM          TO HOSTVAR-ELEMENT-1        
               MOVE CE-CUSTOMER-TYPE        TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7011-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7012-SEL-PREV-ACCT-PR.                                         *        
      ******************************************************************        
      *                                                                         
       7012-SEL-PREV-ACCT-PR.                                           
      *                                                                         
           EXEC SQL                                                     
                 SELECT                                                 
                        AT.ACCOUNT_NO                                   
                   INTO                                                 
                        :AT-ACCOUNT-NO                                  
                   FROM                                                 
                        CSS_ACCOUNT AT                                  
                  WHERE                                                 
                        AT.PREMISE_NO     = :AT-PREMISE-NO              
                    AND AT.ACCT_CREATE_DT =                             
                        (                                               
                          SELECT                                        
                                 MAX(ACCT_CREATE_DT)                    
                            FROM                                        
                                 CSS_ACCOUNT A                          
                           WHERE                                        
                                 A.PREMISE_NO     = :AT-PREMISE-NO      
                        )                                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
             WHEN NOT-FOUND                                             
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7012'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7012-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7060-SEL-REVENUE-MONTH.                                        *        
      ******************************************************************        
      *                                                                         
       7060-SEL-REVENUE-MONTH.                                          
      *                                                                         
             EXEC SQL                                                   
                                                                        
                  SELECT                                                
                         G6.PARM_DATA                                   
                    INTO                                                
                         :G6-PARM-DATA                                  
                    FROM                                                
                         CSS_JOB_PARM G6                                
                   WHERE                                                
                         G6.PROGRAM_NAME = 'COMMON'                     
                     AND G6.CMND_CODE    = 'DATE'                       
                     AND G6.SEQ_NO       = 20                           
                                                                        
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  MOVE G6-PARM-DATA(15:4)   TO WS-REV-YEAR              
                  MOVE G6-PARM-DATA(19:2)   TO WS-REV-MONTH             
                  MOVE '01'                 TO WS-REV-DATE              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7060'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_JOB_PARM'          TO TABLE-1                  
               MOVE 'PROGRAM_NAME'          TO TABLE-ELEMENT-1          
               MOVE 'CMND_CODE'             TO TABLE-ELEMENT-2          
               MOVE 'SEQ_NO'                TO TABLE-ELEMENT-3          
               MOVE 'COMMON'                TO HOSTVAR-ELEMENT-1        
               MOVE 'DATE'                  TO HOSTVAR-ELEMENT-2        
               MOVE '20'                    TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7060-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7061-OPEN-CONS-SERVICE-CUR.                                    *        
      ******************************************************************        
      *                                                                         
       7061-OPEN-CONS-SERVICE-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
                OPEN CONS_SERVICE_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7061'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CONS_SERVICE_CUR'       TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'REV_MTH_LST_NRML'       TO TABLE-ELEMENT-2          
              MOVE WS-CUST-NO-NUM           TO HOSTVAR-ELEMENT-1        
              MOVE AT-REV-MTH-LST-NRML      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7061-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7062-FETCH-CONS-SERVICE-CUR.                                   *        
      ******************************************************************        
      *                                                                         
       7062-FETCH-CONS-SERVICE-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                      CONS_SERVICE_CUR                                  
                 INTO                                                   
                      :AT-ACCOUNT-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               CONTINUE                                                 
             WHEN NOT-FOUND                                             
               SET NO-MORE-DATA             TO TRUE                     
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7062'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CONS_SERVICE_CUR'      TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE 'REV_MTH_LST_NRML'      TO TABLE-ELEMENT-2          
               MOVE WS-CUST-NO-NUM          TO HOSTVAR-ELEMENT-1        
               MOVE AT-REV-MTH-LST-NRML     TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7062-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7063-CLOSE-CONS-SERVICE-CUR.                                   *        
      ******************************************************************        
      *                                                                         
       7063-CLOSE-CONS-SERVICE-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
                CLOSE CONS_SERVICE_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7064'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CONS_SERVICE_CUR'       TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'REV_MTH_LST_NRML'       TO TABLE-ELEMENT-2          
              MOVE WS-CUST-NO-NUM           TO HOSTVAR-ELEMENT-1        
              MOVE AT-REV-MTH-LST-NRML      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7063-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *7065-GET-BILLS-COUNT.                                           *        
      ******************************************************************        
      *                                                                         
       7065-GET-BILLS-COUNT.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       COUNT(BI.DATE_BILLED)                            
                  INTO                                                  
                       :WS-NO-OF-BILLS                                  
                  FROM                                                  
                       CSS_BILLING_HDR BI                               
               WHERE                                                    
                       BI.ACCOUNT_NO = :BI-ACCOUNT-NO                   
                   AND BI.DATE_BILLED  BETWEEN IIF(TRY_CONVERT(DATE, 
                                                  :WS-DATE-BILLED-START
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED-START
              ) <> 0) OR (LEN(:WS-DATE-BILLED-START
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILLED-START
              ), CONVERT(DATE, :WS-DATE-BILLED-START) )    
                                           AND IIF(TRY_CONVERT(DATE, 
                                                    :WS-DATE-BILLED-END
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED-END
              ) <> 0) OR (LEN(:WS-DATE-BILLED-END
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILLED-END
              ), CONVERT(DATE, :WS-DATE-BILLED-END) )      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                COUNT(BI.DATE_BILLED)                                    
MFA-TR*           INTO                                                          
MFA-TR*                :WS-NO-OF-BILLS                                          
MFA-TR*           FROM                                                          
MFA-TR*                CSS_BILLING_HDR BI                                       
MFA-TR*        WHERE                                                            
MFA-TR*                BI.ACCOUNT_NO = :BI-ACCOUNT-NO                           
MFA-TR*            AND BI.DATE_BILLED  BETWEEN :WS-DATE-BILLED-START            
MFA-TR*                                    AND :WS-DATE-BILLED-END              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
             WHEN NOT-FOUND                                             
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7067'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BILLING_HDR'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'DATE_BILLED_START'     TO TABLE-ELEMENT-2          
               MOVE 'DATE_BILLED_END'       TO TABLE-ELEMENT-3          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               MOVE WS-DATE-BILLED-START    TO HOSTVAR-ELEMENT-2        
               MOVE WS-DATE-BILLED-END      TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7065-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7067-SEL-DEPOSIT-AMT                                           *        
      ******************************************************************        
      *                                                                         
       7067-SEL-DEPOSIT-AMT.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       SUM(DP.DEP_PAY_AMT)                              
                  INTO                                                  
                       :WS-DEP-PAY-AMT :WS-NULL-IND-1                    
                  FROM                                                  
                       CSS_DEP_ON_HAND D1                               
                      ,CSS_DEP_PAY_HST DP                               
                 WHERE                                                  
                       D1.ACCOUNT_NO        = :DO-ACCOUNT-NO            
                   AND D1.DEPOSIT_STATUS_CD IN ('A','P')                
                   AND DP.ACCOUNT_NO        = :DP-ACCOUNT-NO            
                   AND D1.ACCOUNT_NO        = DP.ACCOUNT_NO             
                   AND D1.DEPOSIT_CERT_NO   = DP.DEPOSIT_CERT_NO        
                   AND D1.DEPOSIT_CERT_NO   =                           
                                ( SELECT                                
                                         MAX( D.DEPOSIT_CERT_NO)        
                                    FROM                                
                                         CSS_DEP_ON_HAND D              
                                   WHERE                                
                                         D.ACCOUNT_NO = :DO-ACCOUNT-NO  
                                )                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE SQLCODE                 TO ABEND-SQLCODE       
                                                    RS-RETURN-CODE      
                    MOVE SQLSTATE                TO ABEND-SQLSTATE      
                    MOVE '7067'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'SELECT'                TO ABEND-FUNCTION      
                    MOVE 'CSS_DEP_ON_HAND'       TO TABLE-1             
                    MOVE 'WS-ACCOUNT-NO'         TO TABLE-ELEMENT-1     
                    MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1   
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       7067-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7068-SEL-GUARANTOR.                                            *        
      ******************************************************************        
      *                                                                         
       7068-SEL-GUARANTOR.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       AMOUNT_GUARANTEED                                
                  INTO                                                  
                       :WS-DEP-PAY-AMT                                  
                  FROM                                                  
                       CSS_GUARANTOR   GU                               
                 WHERE                                                  
                       GU.ACCOUNT_NO      = :GU-ACCOUNT-NO              
                   AND GU.GUAR_STATUS_CD  = 'A'                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN WS-MULTIPLE-ROWS                                    
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE SQLCODE                 TO ABEND-SQLCODE       
                                                    RS-RETURN-CODE      
                    MOVE SQLSTATE                TO ABEND-SQLSTATE      
                    MOVE '7068'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'SELECT'                TO ABEND-FUNCTION      
                    MOVE 'CSS_GUARANTOR'         TO TABLE-1             
                    MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1     
                    MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1   
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       7068-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7070-OPEN-SERVICE-TYPE-CUR.                                    *        
      ******************************************************************        
      *                                                                         
       7070-OPEN-SERVICE-TYPE-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
                OPEN SERVICE_TYPE_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-PREMISE-NO-NUM        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7071-FETCH-SERVICE-TYPE-CUR.                                  *         
      ******************************************************************        
      *                                                                         
       7071-FETCH-SERVICE-TYPE-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                      SERVICE_TYPE_CUR                                  
                 INTO                                                   
                      :UT-CODE-UTIL-TYPE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               CONTINUE                                                 
             WHEN NOT-FOUND                                             
                  SET NO-MORE-DATA          TO TRUE                     
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7071'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSR04031_R1'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'Y'                     TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7071-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7072-CLOSE-SERVICE-TYPE-CUR.                                   *        
      ******************************************************************        
      *                                                                         
       7072-CLOSE-SERVICE-TYPE-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
                CLOSE SERVICE_TYPE_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7072'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-PREMISE-NO-NUM        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7072-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7073-SEL-FB-ACCTS                                              *        
      ******************************************************************        
      *                                                                         
       7073-SEL-FB-ACCTS.                                               
      *                                                                         
            EXEC SQL                                                    
                   SELECT TOP(1) AT.ACCOUNT_NO,
              AT.DATE_LAST_ACTION                          
                     INTO                                               
                           :AT-ACCOUNT-NO                               
                          ,:AT-DATE-LAST-ACTION                         
                     FROM                                               
                          CSS_ACCOUNT AT                                
                    WHERE                                               
                          AT.CUSTOMER_NO    = :AT-CUSTOMER-NO           
                      AND AT.CODE_ACCT_STAT = 'B'                       
                    ORDER BY AT.DATE_LAST_ACTION DESC                   
                                                  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*     EXEC SQL                                                            
MFA-TR*            SELECT                                                       
MFA-TR*                    AT.ACCOUNT_NO                                        
MFA-TR*                   ,AT.DATE_LAST_ACTION                                  
MFA-TR*              INTO                                                       
MFA-TR*                    :AT-ACCOUNT-NO                                       
MFA-TR*                   ,:AT-DATE-LAST-ACTION                                 
MFA-TR*              FROM                                                       
MFA-TR*                   CSS_ACCOUNT AT                                        
MFA-TR*             WHERE                                                       
MFA-TR*                   AT.CUSTOMER_NO    = :AT-CUSTOMER-NO                   
MFA-TR*               AND AT.CODE_ACCT_STAT = 'B'                               
MFA-TR*             ORDER BY AT.DATE_LAST_ACTION DESC                           
MFA-TR*             FETCH FIRST 1 ROW ONLY                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
             WHEN NOT-FOUND                                             
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7073'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE WS-CUST-NO-NUM          TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7073-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CAL CSR02022.                                                  *        
      *     - Using input Account # retuns Max/Min Deposits.           *        
      ******************************************************************        
      *                                                                         
       7074-CALL-CSR02022.                                              
      *                                                                         
      *    EXEC SQL                                                     
      *         CALL CSR02022(:WS-ACCOUNT-NO)                           
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
      *    EXEC SQL                                                     
      *         ASSOCIATE LOCATORS                                      
      *         (:LOC-RESLTSET)                                         
      *         WITH PROCEDURE CSR02022                                 
      *    END-EXEC.                                                    
      *                                                                         
      *    EXEC SQL                                                     
      *         ALLOCATE C2 CURSOR FOR RESULT SET                       
      *         :LOC-RESLTSET                                           
      *    END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
                FETCH C2 INTO                                           
                      :WS-NUMBER-OF-BILLS,                              
                      :WS-MIN-DEPOSIT-AMT,                              
                      :WS-MAX-DEPOSIT-AMT,                              
                      :WS-USAGE-HISTORY-FLAG,                           
                      :WS-SUMMARY-COL-NAME,                             
                      :WS-COLUMN-SUBTOTAL,                              
                      :WS-RETURN-CODE,                                  
                      :WS-MAX-DEP-REF-XMT-CD,                           
                      :WS-LAST-MAX-AT-REV-DT,                           
                      :WS-MAX-DEP-AT-REV-AM,                            
                      :WS-PD-DEP-AT-REV-AM,                             
                      :WS-MAX-DEP-REFUND-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7074'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'C2_CURSOR'              TO TABLE-1                  
              MOVE 'WS-ACTIVE-RETURN-CODE'  TO TABLE-ELEMENT-1          
              MOVE WS-ACTIVE-RETURN-CODE    TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7074-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Gets the total Deposit refunded at the time of Final Bill      *        
      ******************************************************************        
      *                                                                         
       7076-SEL-DEP-AT-FB.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       SUM(D1.AMT_REFUNDED)                             
                  INTO                                                  
                       :WS-DEP-PAY-AMT :WS-NULL-IND-1                    
                  FROM                                                  
                       CSS_DEP_ON_HAND   D1                             
                 WHERE                                                  
                       D1.ACCOUNT_NO        = :DO-ACCOUNT-NO            
                   AND D1.DEPOSIT_STATUS_CD = 'R'                       
                   AND D1.DATE_REFUNDED IN                              
                       (                                                
                        SELECT                                          
                               CAST(AR.TRANS_HIST_SEQ_NO AS DATE)               
                          FROM                                          
                               CSS_AR_TRANS_HIST AR                     
                         WHERE                                          
                               AR.ACCOUNT_NO      = :AR-ACCOUNT-NO      
                           AND AR.APPL_PROGRAM_ID IN                    
                                               ('PCSSO62J','PCSSO62A')  
                       )                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                SUM(D1.AMT_REFUNDED)                                     
MFA-TR*           INTO                                                          
MFA-TR*                :WS-DEP-PAY-AMT:WS-NULL-IND-1                            
MFA-TR*           FROM                                                          
MFA-TR*                CSS_DEP_ON_HAND   D1                                     
MFA-TR*          WHERE                                                          
MFA-TR*                D1.ACCOUNT_NO        = :DO-ACCOUNT-NO                    
MFA-TR*            AND D1.DEPOSIT_STATUS_CD = 'R'                               
MFA-TR*            AND D1.DATE_REFUNDED IN                                      
MFA-TR*                (                                                        
MFA-TR*                 SELECT                                                  
MFA-TR*                        DATE(AR.TRANS_HIST_SEQ_NO)                       
MFA-TR*                   FROM                                                  
MFA-TR*                        CSS_AR_TRANS_HIST AR                             
MFA-TR*                  WHERE                                                  
MFA-TR*                        AR.ACCOUNT_NO      = :AR-ACCOUNT-NO              
MFA-TR*                    AND AR.APPL_PROGRAM_ID IN                            
MFA-TR*                                        ('PCSSO62J','PCSSO62A')          
MFA-TR*                )                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE SQLCODE                 TO ABEND-SQLCODE       
                                                    RS-RETURN-CODE      
                    MOVE SQLSTATE                TO ABEND-SQLSTATE      
                    MOVE '7076'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'SELECT'                TO ABEND-FUNCTION      
                    MOVE 'CSS_DEP_ON_HAND'       TO TABLE-1             
                    MOVE 'WS-ACCOUNT-NO'         TO TABLE-ELEMENT-1     
                    MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1   
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       7076-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-CODE-VALUES.                                   *              
      ******************************************************************        
      *                                                                         
       7100-OPEN-CODE-VALUES.                                           
      *                                                                         
           EXEC SQL                                                     
                OPEN CODE_VALUES                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'PROGRAM_ID'             TO TABLE-ELEMENT-1          
              MOVE 'WEBSST'                 TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7101-FETCH-CODE-VALUES.                                  *              
      ******************************************************************        
      *                                                                         
       7101-FETCH-CODE-VALUES.                                          
      *                                                                         
           MOVE SPACES                      TO UV-CODE-VALUE-TEXT.      
           MOVE SPACES                      TO UV-CODE-LONG-DESC-TEXT.  
           EXEC SQL                                                     
                FETCH                                                   
                      CODE_VALUES                                       
                INTO                                                    
                      :UV-CODE-VALUE                                    
                     ,:UV-CODE-LONG-DESC                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN NOT-FOUND                                             
                  SET NO-MORE-DATA           TO TRUE                    
             WHEN OTHER                                                 
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                                                RS-RETURN-CODE          
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '7101'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH'               TO ABEND-FUNCTION          
                  MOVE 'CSS_CODE_VALUE'      TO TABLE-1                 
                  MOVE 'PROGRAM_ID'          TO TABLE-ELEMENT-1         
                  MOVE 'WEBSST'              TO HOSTVAR-ELEMENT-1       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
           END-EVALUATE.                                                
      *                                                                         
       7101-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7102-CLOSE-CODE-VALUES.                                        *        
      ******************************************************************        
      *                                                                         
       7102-CLOSE-CODE-VALUES.                                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE CODE_VALUES                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7102'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'PROGRAM_ID'             TO TABLE-ELEMENT-1          
              MOVE 'WEBSST'                 TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7102-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7103-INSERT-COMM-DATA.                                         *        
      ******************************************************************        
      *                                                                         
       7103-INSERT-COMM-DATA.                                           
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (                                               
                         COMMUNICATION_ID                               
                        ,ACCOUNT_NO                                     
                        ,CUSTOMER_NO                                    
                        ,PREMISE_NO                                     
                        ,COMPANY_NO                                     
                        ,RED_FLAG_IND                                   
                        ,RED_FLAG_EXPIRE_DT                             
                        ,COMM_METHOD                                    
                        ,COMM_DIRECTION                                 
                        ,COMM_TYPE_CD                                   
                        ,COMM_SUBTYPE_CODE                              
                        ,USER_ID_ORIG                                   
                        ,CONTACT_NAME                                   
                        ,PROMOTION_ID                                   
                        ,PSC_COMPLIANCE_IND                             
                        ,CALL_ORIGIN_ID                                 
                        ,CALL_END_TIME                                  
                        ,NUMBER_TRANSFERS                               
                        ,HOLD_TIME                                      
                        ,QUEUE_TIME                                     
                        ,SCREEN_POP_IND                                 
                        ,TOTAL_CALL_TIME                                
                        ,INITIAL_COMMENT_TX                             
                        ,RESPONSE_REASON_CD                             
                        ,RESPONSE_TYPE_CD                               
                        ,SOLICITATION_CD                                
                        ,COMM_ASSOC_CD                                  
                        ,COMPLAINT_FL                                   
                        ,DISCOVERY_MTHD_CD                              
                        ,PREV_MARKETER_CD                               
                       )                                                
                VALUES                                                  
                       (                                                
                          CIS.CURRENT$TIMESTAMP()                             
                        ,:KO-ACCOUNT-NO                                 
                        ,:KO-CUSTOMER-NO                                
                        ,:KO-PREMISE-NO                                 
                        ,:KO-COMPANY-NO                                 
                        ,:KO-RED-FLAG-IND                               
                        ,CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND)      
                        ,:KO-COMM-METHOD                                
                        ,:KO-COMM-DIRECTION                             
                        ,:KO-COMM-TYPE-CD                               
                        ,:KO-COMM-SUBTYPE-CODE                          
                        ,:KO-USER-ID-ORIG                               
                        ,:KO-CONTACT-NAME                               
                        ,:KO-PROMOTION-ID                               
                        ,:KO-PSC-COMPLIANCE-IND                         
                        ,:KO-CALL-ORIGIN-ID                             
                        ,CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND)              
                        ,:KO-NUMBER-TRANSFERS                           
                        ,:KO-HOLD-TIME                                  
                        ,:KO-QUEUE-TIME                                 
                        ,:KO-SCREEN-POP-IND                             
                        ,:KO-TOTAL-CALL-TIME                            
                        ,:KO-INITIAL-COMMENT-TX                         
                        ,:KO-RESPONSE-REASON-CD                         
                        ,:KO-RESPONSE-TYPE-CD                           
                        ,:KO-SOLICITATION-CD                            
                        ,:KO-COMM-ASSOC-CD                              
                        ,:KO-COMPLAINT-FL                               
                        ,:KO-DISCOVERY-MTHD-CD                          
                        ,:KO-PREV-MARKETER-CD                           
                       )                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (                                                       
MFA-TR*                  COMMUNICATION_ID                                       
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*                 ,CUSTOMER_NO                                            
MFA-TR*                 ,PREMISE_NO                                             
MFA-TR*                 ,COMPANY_NO                                             
MFA-TR*                 ,RED_FLAG_IND                                           
MFA-TR*                 ,RED_FLAG_EXPIRE_DT                                     
MFA-TR*                 ,COMM_METHOD                                            
MFA-TR*                 ,COMM_DIRECTION                                         
MFA-TR*                 ,COMM_TYPE_CD                                           
MFA-TR*                 ,COMM_SUBTYPE_CODE                                      
MFA-TR*                 ,USER_ID_ORIG                                           
MFA-TR*                 ,CONTACT_NAME                                           
MFA-TR*                 ,PROMOTION_ID                                           
MFA-TR*                 ,PSC_COMPLIANCE_IND                                     
MFA-TR*                 ,CALL_ORIGIN_ID                                         
MFA-TR*                 ,CALL_END_TIME                                          
MFA-TR*                 ,NUMBER_TRANSFERS                                       
MFA-TR*                 ,HOLD_TIME                                              
MFA-TR*                 ,QUEUE_TIME                                             
MFA-TR*                 ,SCREEN_POP_IND                                         
MFA-TR*                 ,TOTAL_CALL_TIME                                        
MFA-TR*                 ,INITIAL_COMMENT_TX                                     
MFA-TR*                 ,RESPONSE_REASON_CD                                     
MFA-TR*                 ,RESPONSE_TYPE_CD                                       
MFA-TR*                 ,SOLICITATION_CD                                        
MFA-TR*                 ,COMM_ASSOC_CD                                          
MFA-TR*                 ,COMPLAINT_FL                                           
MFA-TR*                 ,DISCOVERY_MTHD_CD                                      
MFA-TR*                 ,PREV_MARKETER_CD                                       
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                   CURRENT TIMESTAMP                                     
MFA-TR*                 ,:KO-ACCOUNT-NO                                         
MFA-TR*                 ,:KO-CUSTOMER-NO                                        
MFA-TR*                 ,:KO-PREMISE-NO                                         
MFA-TR*                 ,:KO-COMPANY-NO                                         
MFA-TR*                 ,:KO-RED-FLAG-IND                                       
MFA-TR*                 ,:KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND              
MFA-TR*                 ,:KO-COMM-METHOD                                        
MFA-TR*                 ,:KO-COMM-DIRECTION                                     
MFA-TR*                 ,:KO-COMM-TYPE-CD                                       
MFA-TR*                 ,:KO-COMM-SUBTYPE-CODE                                  
MFA-TR*                 ,:KO-USER-ID-ORIG                                       
MFA-TR*                 ,:KO-CONTACT-NAME                                       
MFA-TR*                 ,:KO-PROMOTION-ID                                       
MFA-TR*                 ,:KO-PSC-COMPLIANCE-IND                                 
MFA-TR*                 ,:KO-CALL-ORIGIN-ID                                     
MFA-TR*                 ,:KO-CALL-END-TIME:WS-END-NULL-IND                      
MFA-TR*                 ,:KO-NUMBER-TRANSFERS                                   
MFA-TR*                 ,:KO-HOLD-TIME                                          
MFA-TR*                 ,:KO-QUEUE-TIME                                         
MFA-TR*                 ,:KO-SCREEN-POP-IND                                     
MFA-TR*                 ,:KO-TOTAL-CALL-TIME                                    
MFA-TR*                 ,:KO-INITIAL-COMMENT-TX                                 
MFA-TR*                 ,:KO-RESPONSE-REASON-CD                                 
MFA-TR*                 ,:KO-RESPONSE-TYPE-CD                                   
MFA-TR*                 ,:KO-SOLICITATION-CD                                    
MFA-TR*                 ,:KO-COMM-ASSOC-CD                                      
MFA-TR*                 ,:KO-COMPLAINT-FL                                       
MFA-TR*                 ,:KO-DISCOVERY-MTHD-CD                                  
MFA-TR*                 ,:KO-PREV-MARKETER-CD                                   
MFA-TR*                )                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '7103'                   TO  ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
                                                RS-RETURN-CODE          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_COMM_DATA'          TO  TABLE-1                 
              MOVE 'CUSTOMER_NO'            TO  TABLE-ELEMENT-1         
              MOVE 'PREMISE_NO'             TO  TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'             TO  TABLE-ELEMENT-3         
              MOVE WS-CUST-NO-NUM           TO  HOSTVAR-ELEMENT-1       
              MOVE WS-PREMISE-NO-NUM        TO  HOSTVAR-ELEMENT-2       
              MOVE WS-COMPANY-NO            TO  HOSTVAR-ELEMENT-3       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7103-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00399*****************************************************************         
P00399* 7104-GET-DLINQ-VAL.                                           *         
P00399*     SELECTS VALUES FROM CSS_DELINQUENCY                       *         
P00399*****************************************************************         
      *                                                                         
P00399 7104-GET-DLINQ-VAL.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
                 AND C8.COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7104                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7104'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_DELINQUENCY'       TO TABLE-1                  
               MOVE 'DELINQ_CD'             TO TABLE-ELEMENT-1          
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2          
               MOVE C8-DELINQ-CD            TO HOSTVAR-ELEMENT-1        
               MOVE C8-COMPANY-NO           TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
P00399*                                                                         
P00399 7104-EXIT.                                                       
P00399     EXIT.                                                        
P00399*                                                                         
P00399******************************************************************        
P00399* 7105-GET-ACCOUNT-TYPE                                          *        
P00399******************************************************************        
      *                                                                         
P00399 7105-GET-ACCOUNT-TYPE.                                           
      *                                                                         
            EXEC SQL                                                    
                 SELECT                                                 
                         AT.ACCOUNT_TYPE_CODE                           
                   INTO                                                 
                         :AT-ACCOUNT-TYPE-CODE                          
                   FROM                                                 
                        CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                  WHERE                                                 
                        AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT                                                         
MFA-TR*                  AT.ACCOUNT_TYPE_CODE                                   
MFA-TR*            INTO                                                         
MFA-TR*                  :AT-ACCOUNT-TYPE-CODE                                  
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_ACCOUNT AT                                          
MFA-TR*           WHERE                                                         
MFA-TR*                 AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                        
MFA-TR*           WITH UR                                                       
MFA-TR*          QUERYNO 7105                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7105'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
P00399*                                                                         
P00399 7105-EXIT.                                                       
P00399      EXIT.                                                       
P00399*                                                                         
      ******************************************************************        
      *9700-PROCESS-ABEND                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023C                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REDUCE-EMBEDDED SPACES                                        *        
      ******************************************************************        
                                                                        
       COPY CPD00004.                                                           
      *********************** END OF THE PROGRAM ***********************        
