                                                                        
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04030.                                          
       DATE-WRITTEN. OCT 2008.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE WHICH IS USED TO     *        
      *  START/STOP/TRANSFER SERVICE VIA WEB CUSTOMER FILTERING.       *        
      *                                                                *        
      ******************************************************************        
      *  PROCESS-CD           DESCRIPTION                              *        
      ******************************************************************        
      *   C           Capture & Queue                                  *        
      *   P           Customer Past Due Balance info.                  *        
      *   R           Deposit info.                                    *        
      *   T           Call EQuifax for deposit calculation             *        
      *   X           Transfer process acct Past due balance           *        
      *   Z           Call CSR04031 for internal credit hist           *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     Program Modification Log                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  10/16/2008 VD41351   INITIAL VERSION                          *        
PECS12*  06/12/2009 VD41351   Issue#627 - when SSN# has space for given*        
PECS12*                       customer, return 'Z' row to process inter*        
PECS12*                       nal credit check instead of Equifax check*        
PECS12*  06/16/2009 VD41351   Whenever the program quote a past due bal*        
PECS12*                       via xfer, the record subtype will be 11. *        
P00253*  12/21/2009 FMB       ADDED DETECTENT ORDER TYPE FW016         *        
DEF054*  10/26/2016 SM93554   Defect 54 - .NET error in CSR04030 due   *        
      *                       INDEX ISSUE.                             *        
DEF054*  03/20/2017 MJ13662   ONLY SET WS-IDX-F DOWN BY W IF WS-IDX-F IS        
      *                       > 2.                                     *        
      ******************************************************************        
      *                                                                *        
      *                ---- Basic Sequence Structure ----              *        
      *                                                                *        
      *         0000 - 0999     Main Control Path and Initialization   *        
      *         1000 - 1999     Input Processing Control Path          *        
      *         2000 - 2999     Output Processing Control Path         *        
      *         5000 - 5999     Common Modules                         *        
      *         7000 - 7999     Database Access / Input Modules        *        
      *         8000 - 8999     Output Modules                         *        
      *         9000 - 9799     Termination Modules                    *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04030'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                        PIC X(40)  VALUE              
           'WORKING STORAGE FOR CSR04030 STARTS HERE'.                  
      *                                                                         
      *****************************************************************         
      *   RETURN FIELD AREA                                           *         
      *****************************************************************         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                PIC S9(9) COMP VALUE ZERO.    
          05 S-PROGRAM-ID                 PIC X(08) VALUE  SPACES.      
          05 S-PROCESS-CD                 PIC X(01) VALUE  SPACES.      
          05 S-CRDT-CHCK-REQ              PIC X(01) VALUE  SPACES.      
          05 S-CPTR-QUE-FLAG              PIC X(01) VALUE  SPACES.      
          05 S-PAST-DUE-FLAG              PIC X(01) VALUE  SPACES.      
          05 S-DEPOSIT-AMT                PIC S9(09)V99 COMP-3 VALUE +0.
          05 S-ACCOUNT-NO                 PIC S9(13)V COMP-3 VALUE +0.  
          05 S-CODE-ACCT-STAT             PIC X(01) VALUE  SPACES.      
          05 S-PAST-DUE-UTL               PIC S9(09)V99 COMP-3 VALUE +0.
          05 S-PAST-DUE-NONUTL            PIC S9(09)V99 COMP-3 VALUE +0.
          05 S-CUST-TYPE                  PIC X(01) VALUE  SPACES.      
          05 S-TOTAL-UTL                  PIC S9(09)V99 COMP-3 VALUE +0.
          05 S-TOTAL-NONUTL               PIC S9(09)V99 COMP-3 VALUE +0.
          05 S-CASH-ONLY-FLAG             PIC X(01) VALUE SPACES.       
          05 S-SSN                        PIC X(09) VALUE SPACES.       
          05 S-ACCT-SRVC-ADDRESS          PIC X(75) VALUE SPACES.       
          05 S-PREMISE-NO                 PIC S9(10)V COMP-3 VALUE +0.  
      *                                                                         
       01 TDS-RETURN-FIELDS.                                            
          05 RS-RETURN-CODE               PIC S9(9) COMP VALUE ZERO.    
          05 RS-PROGRAM-ID                PIC X(08) VALUE  SPACES.      
          05 RS-PROCESS-CD                PIC X(01) VALUE  SPACES.      
          05 RS-CRDT-CHCK-REQ             PIC X(01) VALUE  SPACES.      
          05 RS-CPTR-QUE-FLAG             PIC X(01) VALUE  SPACES.      
          05 RS-PAST-DUE-FLAG             PIC X(01) VALUE  SPACES.      
          05 RS-DEPOSIT-AMT               PIC S9(09)V99 COMP-3 VALUE +0.
          05 RS-ACCOUNT-NO                PIC S9(13)V COMP-3 VALUE +0.  
          05 RS-CODE-ACCT-STAT            PIC X(01) VALUE  SPACES.      
          05 RS-PAST-DUE-UTL              PIC S9(09)V99 COMP-3 VALUE +0.
          05 RS-PAST-DUE-NONUTL           PIC S9(09)V99 COMP-3 VALUE +0.
          05 RS-CUST-TYPE                 PIC X(01) VALUE  SPACES.      
          05 RS-TOTAL-UTL                 PIC S9(09)V99 COMP-3 VALUE +0.
          05 RS-TOTAL-NONUTL              PIC S9(09)V99 COMP-3 VALUE +0.
          05 RS-CASH-ONLY-FLAG            PIC X(01) VALUE SPACES.       
          05 RS-SSN                       PIC X(09) VALUE SPACES.       
          05 RS-ACCT-SRVC-ADDRESS         PIC X(75) VALUE SPACES.       
          05 RS-PREMISE-NO                PIC S9(10)V COMP-3 VALUE +0.  
      *                                                                         
       01 WS-ACCT-ARRAY.                                                
          05 WS-ACCT-ARRAY-CNT            PIC S9(7) COMP-3 VALUE +0.    
          05 WS-ACCT-ARRAY-ELEMENTS       OCCURS 100 TIMES              
                                          INDEXED BY WS-INDEX.          
             10 WS-ACCT-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE +0.  
             10 WS-ACCT-PREMISE-NO        PIC S9(10)V COMP-3 VALUE +0.  
             10 WS-ACCT-CODE-ACCT-STAT    PIC X(1).                     
             10 WS-ACCT-TOTAL-AR-BAL    PIC S9(11)V9(2) COMP-3 VALUE +0.
             10 WS-ACCT-CODES-DATA-PRESENT                              
                                          PIC X(32).                    
             10 WS-ACCT-CODE-STAT-REASON  PIC X(1).                     
             10 WS-ACCT-BANKRUPTCY-IND    PIC X(1).                     
             10 WS-ACCT-CREDIT-GROUP      PIC X(1).                     
             10 WS-ACCT-MST-SUB-ACCT-IND  PIC X(1).                     
             10 WS-ACCT-CODE-MAJOR-ACCT   pIC X(1).                     
             10 WS-ACCT-CT-METER-RATED-IND                              
                                          PIC X(1).                     
             10 WS-ACCT-COMPANY-NO        PIC X(2).                     
             10 WS-ACCT-LOCAL-OFFICE      PIC X(3).                     
             10 WS-ACCT-DATE-BILL-DAY-00  PIC X(10).                    
             10 WS-ACCT-DATE-BILL-DAY-30  PIC X(10).                    
             10 WS-ACCT-DATE-BILL-DAY-60  PIC X(10).                    
             10 WS-ACCT-DATE-BILL-DAY-90  pIC X(10).                    
             10 WS-ACCT-CODE-DISC-OK      PIC X(1).                     
             10 WS-ACCT-NOTICE-EXEMPT-CD  PIC X(1).                     
             10 WS-ACCT-BILL-CYCLE        PIC X(2).                     
             10 WS-ACCT-IVR-EXEMPT-CD     PIC X(1).                     
             10 WS-ACCT-PAST-DUE-UTIL     PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-ACCT-PAST-DUE-NONUTIL  PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-ACCT-UTIL-BAL          PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-ACCT-NONUTIL-BAL       PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-ACCT-AMT-UTIL-BAL      PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-ACCT-AMT-NONUTIL-BAL   PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-ACCT-WRITE-OFF-DATE    PIC X(10) VALUE '1900-01-01'. 
             10 WS-ACCT-CASHONLY-FLAG     PIC X(01) VALUE SPACES.       
                                                                        
       01 WS-SP-ARRAY.                                                  
          05 WS-SP-ARRAY-CNT              PIC S9(7) COMP-3 VALUE +0.    
          05 WS-SP-ARRAY-ELEMENTS         OCCURS 100 TIMES              
                                          INDEXED BY WS-INDEX-SP.       
             10 WS-SP-ACCOUNT-NO          PIC S9(13)V COMP-3 VALUE +0.  
             10 WS-SP-PREMISE-NO          PIC S9(10)V COMP-3 VALUE +0.  
             10 WS-SP-CODE-ACCT-STAT      PIC X(1).                     
             10 WS-SP-TOTAL-AR-BAL        PIC S9(11)V99 COMP-3 VALUE +0.
             10 WS-SP-CODES-DATA-PRESENT  PIC X(32).                    
             10 WS-SP-CODE-STAT-REASON    PIC X(1).                     
             10 WS-SP-BANKRUPTCY-IND      PIC X(1).                     
             10 WS-SP-CREDIT-GROUP        PIC X(1).                     
             10 WS-SP-MST-SUB-ACCT-IND    PIC X(1).                     
             10 WS-SP-CODE-MAJOR-ACCT     PIC X(1).                     
             10 WS-SP-CT-METER-RATED-IND  PIC X(1).                     
             10 WS-SP-COMPANY-NO          PIC X(2).                     
             10 WS-SP-LOCAL-OFFICE        PIC X(3).                     
             10 WS-SP-DATE-BILL-DAY-00    PIC X(10).                    
             10 WS-SP-DATE-BILL-DAY-30    PIC X(10).                    
             10 WS-SP-DATE-BILL-DAY-60    PIC X(10).                    
             10 WS-SP-DATE-BILL-DAY-90    PIC X(10).                    
             10 WS-SP-CODE-DISC-OK        PIC X(1).                     
             10 WS-SP-NOTICE-EXEMPT-CD    PIC X(1).                     
             10 WS-SP-BILL-CYCLE          PIC X(2).                     
             10 WS-SP-IVR-EXEMPT-CD       PIC X(1).                     
             10 WS-SP-PAST-DUE-UTIL       PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-SP-PAST-DUE-NONUTIL    PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-SP-AMT-UTIL-BAL        PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-SP-AMT-NONUTIL-BAL     PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-SP-UTIL-BAL            PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-SP-NONUTIL-BAL         PIC S9(09)V99 COMP-3 VALUE +0.
             10 WS-SP-WRITE-OFF-DATE      PIC X(10).                    
             10 WS-SP-CASHONLY-FLAG       PIC X(01) VALUE SPACES.       
                                                                        
       01 WS-MISC.                                                      
           05 PROGRAM-NAME                PIC X(08) VALUE 'CSR04030'.   
           05 WS-MCSCB068                 PIC X(08) VALUE 'MCSCB068'.   
           05 WS-ACCOUNT-NO               PIC X(13) VALUE SPACES.       
           05 WS-ACCOUNT-NO-NUM           REDEFINES WS-ACCOUNT-NO       
                                          PIC 9(13).                    
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.           
           05 WS-XFER-FLAG                PIC X(01) VALUE SPACES.       
           05 WS-XFER-ACCT-NO             PIC X(13) VALUE SPACES.       
           05 WS-XFER-ACCT-NO-NUM         REDEFINES WS-XFER-ACCT-NO     
                                          PIC 9(13).                    
           05 WS-XFER-ACCT-NO-COMP3       PIC S9(13)V COMP-3 VALUE +0.  
           05 WS-CUSTOMER-NO              PIC X(10) VALUE SPACES.       
           05 WS-CUSTOMER-NO-JST          PIC X(10) JUSTIFIED RIGHT.    
           05 WS-CUSTOMER-NO-NUM          REDEFINES WS-CUSTOMER-NO-JST  
                                          PIC 9(10).                    
           05 WS-CUSTOMER-NO-COMP3        PIC S9(10) COMP-3 VALUE +0.   
           05 WS-PREV-CUST-NO-COMP3       PIC S9(10) COMP-3 VALUE +0.   
           05 WS-PREMISE-NO               PIC X(10) VALUE SPACES.       
           05 WS-PREMISE-NO-NUM           REDEFINES WS-PREMISE-NO       
                                          PIC 9(10).                    
           05 WS-PREMISE-NO-COMP3         PIC S9(10) COMP-3 VALUE +0.   
           05 WS-DEPOSIT-AMT              PIC S9(09)V99 COMP-3 VALUE +0.
           05 WS-DEPOSIT-AMT-EDT          PIC $ZZ9.99.                  
           05 WS-DEPOSIT-AMT-EDT1         PIC $ZZZ9.99.                 
           05 WS-CUST-FLAG                PIC X(06) VALUE SPACES.       
           05 WS-COMPANY-NO               pIC X(02) VALUE SPACES.       
           05 WS-ACTIVE-ACCT              PIC X(01) VALUE SPACES.       
           05 WS-MULT-ACTIVE-ACCT         PIC X(01) VALUE SPACES.       
           05 WS-NEW-PREMISE-ACCT-NO      PIC S9(13)V COMP-3 VALUE +0.  
           05 WS-SP-CUST-NO               PIC 9(10) VALUE ZERO.         
           05 WS-SP-SSN                   PIC X(9)  VALUE SPACES.       
           05 WS-CUST-SSN                 PIC X(9)  VALUE SPACES.       
           05 WS-SP-ACTV-CNT              PIC S9(4) COMP-3 VALUE +0.    
           05 WS-ACTIVE-ACCT-CNT          PIC S9(4) COMP-3 VALUE +0.    
           05 WS-ACTIVE-SP-CNT            PIC S9(4) COMP-3 VALUE +0.    
           05 WS-FB-ACCT-CNT              PIC S9(4) COMP-3 VALUE +0.    
           05 WS-TEMP-CONTACT-NAME        PIC X(25) VALUE SPACES.       
           05 WS-CUST-CONTACT-NAME        PIC X(25) VALUE SPACES.       
           05 WS-CONTACT-NAME             PIC X(25) VALUE SPACES.       
           05 WS-FULL-SRVC-ADDR           PIC X(57) VALUE SPACES.       
           05 WS-FULL-LOCATION            PIC X(15) VALUE SPACES.       
           05 WS-ACCT-SRVC-ADDRESS        PIC X(75) VALUE SPACES.       
           05 WS-TEMP-ACCT-SRVC-ADDR      PIC X(75) VALUE SPACES.       
           05 WS-COMM-COMMENT             PIC X(500) VALUE SPACES.      
           05 WS-PAST-DUE-DELINQ-LIMIT   PIC S9(4)V9(5) COMP-3 VALUE +0.
           05 WS-PAST-DUE-CHARGE         PIc X(01) VALUE SPACES.        
           05 WS-ACCT-BAL-FB             PIC X(01) VALUE SPACES.        
           05 WS-SO-TYPE-CD              PIC X(05) VALUE SPACES.        
           05 WS-UTIL-BAL-DELINQ-LIMIT   PIC S9(4)V9(5) COMP-3 VALUE +0.
           05 WS-CUTOFF-DELINQ-VALUE     PIC S9(4)V9(5) COMP-3 VALUE +0.
           05 WS-CUT-OFF-DATE            PIC X(10) VALUE SPACES.        
           05 WS-SPCL-PSNC-PASTDUE       PIC X(01) VALUE 'N'.           
           05 WS-ENDV-FLAG               PIC X(01) VALUE SPACES.        
           05 WS-RECONNECT-FLAG          PIC X(01) VALUE SPACES.        
           05 WS-DNP-FB-FLAG             PIC X(01) VALUE SPACES.        
           05 WS-SP-PAST-DUE             PIC X(01) VALUE SPACES.        
           05 WS-WRITE-OFF-DT            PIC X(10) VALUE SPACES.        
           05 WS-CUTOFF-ACCT             PIC S9(13)V COMP-3 VALUE +0.   
           05 WS-ACCT-NO                 PIC S9(13)V COMP-3 VALUE +0.   
           05 WS-AMT-UTIL                PIC S9(09)V99 COMP-3 VALUE +0. 
           05 WS-TOT-NONUTIL             PIC S9(09)V99 COMP-3 VALUE +0. 
           05 WS-TOT-UTIL                PIC S9(09)V99 COMP-3 VALUE +0. 
           05 WS-AMT-NONUTIL             PIC S9(09)V99 COMP-3 VALUE +0. 
           05 WS-AMT-PASTDUE             PIC S9(09)V99 COMP-3 VALUE +0. 
           05 WS-WRITE-OFF-CNT           PIC S9(9) COMP VALUE 0.        
           05 WS-WO-DT-GRT-CUTOFF-DATE   PIC S9(9) COMP VALUE 0.        
           05 WS-WO-DT-LESS-CUTOFF-DATE  PIC S9(9) COMP VALUE 0.        
           05 WS-WO-DT-EQL-CUTOFF-DATE   PIC S9(9) COMP VALUE 0.        
           05 WS-WRITEOFF-YRS-CNT        PIC X VALUE SPACES.            
           05 WS-CNT-FLAG                PIC X VALUE 'N'.               
           05 WS-CNTT-FLAG               PIC X VALUE 'N'.               
           05 WS-WRITE-OFF-CNTT          PIC S9(9) COMP VALUE 0.        
           05 WS-WO-DT-GRT-CUTOFF-DT     PIC S9(9) COMP VALUE 0.        
           05 WS-WO-DT-LESS-CUTOFF-DT    PIC S9(9) COMP VALUE 0.        
           05 WS-WO-DT-EQL-CUTOFF-DT     PIC S9(9) COMP VALUE 0.        
           05 WS-WRITEOFF-YRS-CNTT       PIC X     VALUE SPACES.        
           05 WS-COMM-INITIAL-COMMENT    PIC X(255) VALUE SPACES.       
           05 WS-TOTAL-AR-BAL            PIC S9(9)V9(2) COMP-3 VALUE +0.
           05 WS-COMMA                   PIC X(02) VALUE ';'.           
           05 WS-HYPEN                   PIC X(03) VALUE ' - '.         
           05 WS-SEPERATOR               PIC X(02) VALUE '//'.          
           05 WS-COMM-LENGTH             PIC S9(9) COMP VALUE 0.        
           05 WS-ACCT-SRVC-LENGTH        PIC S9(9) COMP VALUE 0.        
           05 WS-TEMP-LENGTH             PIC S9(9) COMP VALUE 0.        
           05 WS-TOT-LENGTH              PIC S9(9) COMP VALUE 76.       
           05 WS-VALID-WRITE-OFF         PIC X(01) VALUE SPACES.        
           05 WS-TOT-PASTDUE-EDT3        PIC $ZZZ9.99.                  
           05 WS-TOT-PASTDUE-EDT2        PIC $ZZ9.99.                   
           05 WS-TOT-PASTDUE-EDT1        PIC $Z9.99.                    
           05 WS-SQLSTATE                PIC X(05) VALUE '     '.       
           05 WS-SPACE                   PIC X(02) VALUE '  '.          
           05 WS-EXIT-FLAG               PIC X(01) VALUE 'N'.           
           05 WS-TEMP-NAME-AMTT.                                        
              10  WS-TEMP-NAME-COMMENT      PIC X(80)  VALUE SPACES.    
              10  WS-TEMP-NAME-COMMENT-LEN  PIC S9(4)  VALUE 0 COMP.    
      *                                                                         
       01 WS-CODE-ARRAY-TABLE.                                          
          05 WS-CODE-ARRAY                  OCCURS 100 TIMES            
                                            INDEXED BY WS-IDX-C.        
             10 WS-CODE-VALUE               PIC X(10).                  
             10 WS-CODE-LONG-DESC           PIC X(80).                  
      *                                                                         
          05  WS-COMM-CODE                  PIC X(10) OCCURS 20 TIMES.  
          05  WS-CNT                        PIC S9(4) COMP VALUE +1.    
      *                                                                         
          05 WS-CODE-DESC-TEXT.                                         
             10 WS-CODE-DESC                PIC X(01)                   
                            OCCURS 80  TIMES INDEXED BY WS-IDX-D.       
          05 WS-FINAL-COMM-TEXT.                                        
             10 WS-FINAL-COMM               PIC X(01)                   
                            OCCURS 250 TIMES INDEXED BY WS-IDX-F.       
      *                                                                         
       01 CSR02022-RETURN-VALUES.                                       
           05 WS-NO-OF-BILLS           PIC S9(04)V    COMP-3 VALUE +0.  
           05 WS-MIN-DEPOSIT-AMT       PIC S9(09)V99  COMP-3 VALUE +0.  
           05 WS-MAX-DEPOSIT-AMT       PIC S9(09)V99  COMP-3 VALUE +0.  
           05 WS-USAGE-HISTORY-FLAG    PIC X(01)      VALUE  SPACES.    
           05 WS-SUMMARY-COL-NAME      PIC X(30)      VALUE  SPACES.    
           05 WS-COLUMN-SUBTOTAL       PIC S9(09)V99  COMP-3 VALUE +0.  
           05 WS-RETURN-CODE           PIC S9(9)      COMP   VALUE 0.   
           05 WS-MAX-DEP-REF-XMT-CD    PIC X(01)      VALUE  SPACES.    
           05 WS-LAST-MAX-AT-REV-DT    PIC X(10)      VALUE  SPACES.    
           05 WS-MAX-DEP-AT-REV-AM     PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05 WS-PD-DEP-AT-REV-AM      PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05 WS-MAX-DEP-REFUND-CD     PIC X(01)      VALUE  SPACES.    
           05 WS-PREV-CHAR             PIC X(01)      VALUE  SPACES.    
      *                                                                         
       01 SWITCHES.                                                     
           05 SEND-DONE-SW             PIC X(01)  VALUE 'Y'.            
              88 SEND-DONE-ERROR                  VALUE 'N'.            
              88 SEND-DONE-OK                     VALUE 'Y'.            
           05 WS-CUST-PROC             PIC X(01)  VALUE 'N'.            
              88 WS-CUST-NOT-PROCESSED            VALUE 'N'.            
              88 WS-CUST-PROCESSED                VALUE 'Y'.            
           05 WS-NO-MORE-DATA-ACCTCUR  PIC X(01)  VALUE 'N'.            
              88 NO-MORE-DATA-ACCTCUR             VALUE 'Y'.            
           05 WS-NO-MORE-DATA-SPCUR    PIC X(01)  VALUE 'N'.            
              88 NO-MORE-DATA-SPCUR               VALUE 'Y'.            
           05 WS-NO-MORE-DATA-CODECUR  PIC X(01)  VALUE 'N'.            
              88 NO-MORE-DATA-CODECUR             VALUE 'Y'.            
           05 WS-NO-MORE-DATA-RESCUR   PIC X(01)  VALUE 'N'.            
              88 NO-MORE-DATA-RESCUR              VALUE 'Y'.            
           05 WS-EOF-CURSOR            PIC X(01)  VALUE 'N'.            
              88 NO-MORE-DATA                     VALUE 'Y'.            
           05 WS-FORMAT                PIC X(01)  VALUE 'N'.            
              88 FORMAT-DONE                      VALUE 'Y'.            
           05 WS-CUST-CUR              PIC X(01)  VALUE 'N'.            
              88 WS-CUST-EOC                      VALUE 'Y'.            
           05 WS-SERVICE-ELEC          PIC X(01)  VALUE ' '.            
              88  WS-ELEC-ONLY                    VALUE 'E'.            
           05 WS-SERVICE-GAS           PIC X(01)  VALUE ' '.            
              88  WS-GAS-ONLY                     VALUE 'G'.            
           05 WS-SERVICE-COMBO         PIC X(01)  VALUE ' '.            
              88  WS-COMBO                        VALUE 'C'.            
       01 COUNTER-FIELDS.                                               
           05 CTR-SUB                       PIC S9(9)  COMP VALUE 1.    
           05 CTR-SUB-WO                    PIC S9(9)  COMP VALUE 1.    
           05 CTR-SUB-CNT                   PIC S9(9)  COMP VALUE 1.    
           05 WS-I                          PIC S9(04) COMP VALUE +0.   
      *01 LOC-RESLTSET                 USAGE SQL TYPE IS                
      *                                    RESULT-SET-LOCATOR VARYING.  
      ******************************************************************        
      * INDICATOR VARIABLES.                                           *        
      ******************************************************************        
      *                                                                         
       01 IND-VARIABLES.                                                
           05 WS-NULL-INDICATOR-1      PIC S9(4) COMP.                  
           05 WS-NULL-INDICATOR-2      PIC S9(4) COMP.                  
           05 WS-NULL-INDICATOR-3      PIC S9(4) COMP.                  
           05 WS-NULL-INDICATOR-4      PIC S9(4) COMP.                  
           05 WS-NULL-INDICATOR-5      PIC S9(4) COMP.                  
           05 WS-NULL-INDICATOR-6      PIC S9(4) COMP.                  
           05 WS-RED-FL-NULL-IND       PIC S9(04) COMP.                 
           05 WS-END-NULL-IND          PIC S9(04) COMP.                 
      *                                                                         
      ******************************************************************        
      * SQL Error Checking Copy Books.                                 *        
      ******************************************************************        
                                                                        
      *01  WS-WARNING-DATA-ELEMENTS.                                            
           COPY CWS00303.                                                       
                                                                        
      *01  CSRERLOG-P.                                                          
           COPY CWSSP001.                                                       
                                                                        
      *****************************************************************         
      *    WS FOR 6010-REDUCE-EMBEDDED SPACES                         *         
      *****************************************************************         
           COPY CWS00011.                                                       
                                                                        
      ******************************************************************        
      * Working Storage for Procedure Division Copy Books              *        
      ******************************************************************        
                                                                        
      *01  WS-CPD68-LINK-RECORD.                                                
      *USED WILE CALLING MCSCB068 MODULE.                                       
           COPY CWS0068L.                                                       
                                                                        
      ******************************************************************        
      * DB2 Includes                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CE - CSS_CUST_STATS                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DQ - CSS_NAME                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    UV - CSS_CODE_VALUE                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    VO - CSS_SO_DATA                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DL - CSS_RECONNECT                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    KO - CSS_COMM_DATA                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CO - CSS_CHRG_OFF                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CZ - CSS_CREDIT_PROFILE                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    S9 - CSS_STREET_SUFFIX                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSTRSFX                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    PR - CSS_PREMISE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DY - CSS_ADDR_FORMATTED                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *    UT - CSS_UTIL_ENVRNMT                                                
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * Error Handling Copy Book.                                      *        
      ******************************************************************        
      *                                                                         
      *01  ABEND-FILE.                                                          
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Working Storage to Support CPD00068.                           *        
      ******************************************************************        
      *                                                                         
      *01  CWS00068-FIELDS.                                                     
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
      *                                                                         
      *01  WS-CODES-DATA-PRESENT.                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO GET THE EXISTING CUSTOMER NUMBERS ASSOSIATED WITH I/P*        
      * CUSTOMERS SSN.                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE CUST_CURSOR CURSOR FOR                          
                SELECT CE.CUSTOMER_NO                                   
                      ,CE.CUSTOMER_TYPE                                 
                      ,CE.SSN                                           
                  FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                  
                 WHERE CE.CUSTOMER_NO IN (                              
                         SELECT DISTINCT C1.CUSTOMER_NO                 
                           FROM CSS_CUST_STATS C1 WITH(READUNCOMMITTED)         
                          WHERE C1.SSN IN (                             
                                  SELECT A.SSN                          
                                    FROM CSS_CUST_STATS A
                           WITH(READUNCOMMITTED)               
                                   WHERE A.CUSTOMER_NO = :CE-CUSTOMER-NO
                                   AND A.SSN > ' '                      
                                  ))                                    
                   AND CE.CUSTOMER_TYPE = 'C'                           
                ORDER BY CE.CUSTOMER_NO, CE.CUSTOMER_TYPE               
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CUST_CURSOR CURSOR FOR                                  
MFA-TR*         SELECT CE.CUSTOMER_NO                                           
MFA-TR*               ,CE.CUSTOMER_TYPE                                         
MFA-TR*               ,CE.SSN                                                   
MFA-TR*           FROM CSS_CUST_STATS CE                                        
MFA-TR*          WHERE CE.CUSTOMER_NO IN (                                      
MFA-TR*                  SELECT DISTINCT C1.CUSTOMER_NO                         
MFA-TR*                    FROM CSS_CUST_STATS C1                               
MFA-TR*                   WHERE C1.SSN IN (                                     
MFA-TR*                           SELECT A.SSN                                  
MFA-TR*                             FROM CSS_CUST_STATS A                       
MFA-TR*                            WHERE A.CUSTOMER_NO = :CE-CUSTOMER-NO        
MFA-TR*                            AND A.SSN > ' '                              
MFA-TR*                           ))                                            
MFA-TR*            AND CE.CUSTOMER_TYPE = 'C'                                   
MFA-TR*         ORDER BY CE.CUSTOMER_NO, CE.CUSTOMER_TYPE                       
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO IDENTIFY SERV AT NEW PREMISE.                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE SERVICE_TYPE_CUR CURSOR FOR                     
                 SELECT                                                 
                        UT.CODE_UTIL_TYPE                               
                   FROM                                                 
                        CSS_UTIL_ENVRNMT UT                             
                  WHERE                                                 
                        UT.PREMISE_NO = :UT-PREMISE-NO                  
                    AND UT.CODE_UTIL_TYPE IN ('E','G')                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE SERVICE_TYPE_CUR CURSOR FOR                             
MFA-TR*          SELECT                                                         
MFA-TR*                 UT.CODE_UTIL_TYPE                                       
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_UTIL_ENVRNMT UT                                     
MFA-TR*           WHERE                                                         
MFA-TR*                 UT.PREMISE_NO = :UT-PREMISE-NO                          
MFA-TR*             AND UT.CODE_UTIL_TYPE IN ('E','G')                          
MFA-TR*        QUERYNO 7080                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO POPULATE ACCOUNT TABLE ARRAY.                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE ACCT_CURSOR CURSOR FOR                          
                SELECT                                                  
                       AT.ACCOUNT_NO                                    
                      ,AT.PREMISE_NO                                    
                      ,AT.CODE_ACCT_STAT                                
                      ,AT.TOTAL_AR_BALANCE                              
                      ,AT.CODES_DATA_PRESENT                            
                      ,AT.CODE_STATUS_REASON                            
                      ,AT.BANKRUPTCY_IND                                
                      ,AT.CREDIT_GROUP                                  
                      ,AT.MST_SUB_ACCT_IND                              
                      ,AT.CODE_MAJOR_ACCT                               
                      ,AT.CT_METER_RATED_IND                            
                      ,AT.COMPANY_NO                                    
                      ,AT.LOCAL_OFFICE                                  
                      ,AT.DATE_BILL_DAY_00                              
                      ,AT.DATE_BILL_DAY_30                              
                      ,AT.DATE_BILL_DAY_60                              
                      ,AT.DATE_BILL_DAY_90                              
                      ,AT.CODE_DISC_OK                                  
                      ,AT.NOTICE_EXEMPT_CD                              
                      ,AT.BILL_CYCLE                                    
                      ,AT.IVR_EXEMPT_CD                                 
                      ,CZ.CASH_ONLY_FL                                  
                FROM                                                    
                       CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                    
                      ,CSS_CREDIT_PROFILE  CZ WITH(READUNCOMMITTED)             
                WHERE                                                   
                       AT.CUSTOMER_NO       = :AT-CUSTOMER-NO           
                  AND  AT.COMPANY_NO        = :WS-COMPANY-NO            
                  AND  CZ.ACCOUNT_NO        = AT.ACCOUNT_NO             
                  AND  AT.ACCOUNT_TYPE_CODE <> 'N'                      
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE ACCT_CURSOR CURSOR FOR                                  
MFA-TR*         SELECT                                                          
MFA-TR*                AT.ACCOUNT_NO                                            
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*               ,AT.CODE_ACCT_STAT                                        
MFA-TR*               ,AT.TOTAL_AR_BALANCE                                      
MFA-TR*               ,AT.CODES_DATA_PRESENT                                    
MFA-TR*               ,AT.CODE_STATUS_REASON                                    
MFA-TR*               ,AT.BANKRUPTCY_IND                                        
MFA-TR*               ,AT.CREDIT_GROUP                                          
MFA-TR*               ,AT.MST_SUB_ACCT_IND                                      
MFA-TR*               ,AT.CODE_MAJOR_ACCT                                       
MFA-TR*               ,AT.CT_METER_RATED_IND                                    
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*               ,AT.DATE_BILL_DAY_00                                      
MFA-TR*               ,AT.DATE_BILL_DAY_30                                      
MFA-TR*               ,AT.DATE_BILL_DAY_60                                      
MFA-TR*               ,AT.DATE_BILL_DAY_90                                      
MFA-TR*               ,AT.CODE_DISC_OK                                          
MFA-TR*               ,AT.NOTICE_EXEMPT_CD                                      
MFA-TR*               ,AT.BILL_CYCLE                                            
MFA-TR*               ,AT.IVR_EXEMPT_CD                                         
MFA-TR*               ,CZ.CASH_ONLY_FL                                          
MFA-TR*         FROM                                                            
MFA-TR*                CSS_ACCOUNT  AT                                          
MFA-TR*               ,CSS_CREDIT_PROFILE  CZ                                   
MFA-TR*         WHERE                                                           
MFA-TR*                AT.CUSTOMER_NO       = :AT-CUSTOMER-NO                   
MFA-TR*           AND  AT.COMPANY_NO        = :WS-COMPANY-NO                    
MFA-TR*           AND  CZ.ACCOUNT_NO        = AT.ACCOUNT_NO                     
MFA-TR*           AND  AT.ACCOUNT_TYPE_CODE <> 'N'                              
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO POPULATE SPOUSE ACCOUNT TABLE ARRAY FOR FINAL\WO BAL *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE SPOUSE_CURSOR CURSOR FOR                        
                SELECT                                                  
                       AT.ACCOUNT_NO                                    
                      ,AT.PREMISE_NO                                    
                      ,AT.CODE_ACCT_STAT                                
                      ,AT.TOTAL_AR_BALANCE                              
                      ,AT.CODES_DATA_PRESENT                            
                      ,AT.CODE_STATUS_REASON                            
                      ,AT.BANKRUPTCY_IND                                
                      ,AT.CREDIT_GROUP                                  
                      ,AT.MST_SUB_ACCT_IND                              
                      ,AT.CODE_MAJOR_ACCT                               
                      ,AT.CT_METER_RATED_IND                            
                      ,AT.COMPANY_NO                                    
                      ,AT.LOCAL_OFFICE                                  
                      ,AT.DATE_BILL_DAY_00                              
                      ,AT.DATE_BILL_DAY_30                              
                      ,AT.DATE_BILL_DAY_60                              
                      ,AT.DATE_BILL_DAY_90                              
                      ,AT.CODE_DISC_OK                                  
                      ,AT.NOTICE_EXEMPT_CD                              
                      ,AT.BILL_CYCLE                                    
                      ,AT.IVR_EXEMPT_CD                                 
                      ,CZ.CASH_ONLY_FL                                  
                FROM                                                    
                       CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                    
                      ,CSS_CREDIT_PROFILE  CZ WITH(READUNCOMMITTED)             
                WHERE                                                   
                       AT.CUSTOMER_NO       = :AT-CUSTOMER-NO           
                  AND  AT.COMPANY_NO        = :WS-COMPANY-NO            
                  AND  ((AT.CODE_ACCT_STAT  = 'B'                       
                  AND  AT.TOTAL_AR_BALANCE  >= 0 )                      
                   OR  AT.CODE_ACCT_STAT    = 'S')                      
                  AND  CZ.ACCOUNT_NO        = AT.ACCOUNT_NO             
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE SPOUSE_CURSOR CURSOR FOR                                
MFA-TR*         SELECT                                                          
MFA-TR*                AT.ACCOUNT_NO                                            
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*               ,AT.CODE_ACCT_STAT                                        
MFA-TR*               ,AT.TOTAL_AR_BALANCE                                      
MFA-TR*               ,AT.CODES_DATA_PRESENT                                    
MFA-TR*               ,AT.CODE_STATUS_REASON                                    
MFA-TR*               ,AT.BANKRUPTCY_IND                                        
MFA-TR*               ,AT.CREDIT_GROUP                                          
MFA-TR*               ,AT.MST_SUB_ACCT_IND                                      
MFA-TR*               ,AT.CODE_MAJOR_ACCT                                       
MFA-TR*               ,AT.CT_METER_RATED_IND                                    
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*               ,AT.DATE_BILL_DAY_00                                      
MFA-TR*               ,AT.DATE_BILL_DAY_30                                      
MFA-TR*               ,AT.DATE_BILL_DAY_60                                      
MFA-TR*               ,AT.DATE_BILL_DAY_90                                      
MFA-TR*               ,AT.CODE_DISC_OK                                          
MFA-TR*               ,AT.NOTICE_EXEMPT_CD                                      
MFA-TR*               ,AT.BILL_CYCLE                                            
MFA-TR*               ,AT.IVR_EXEMPT_CD                                         
MFA-TR*               ,CZ.CASH_ONLY_FL                                          
MFA-TR*         FROM                                                            
MFA-TR*                CSS_ACCOUNT  AT                                          
MFA-TR*               ,CSS_CREDIT_PROFILE  CZ                                   
MFA-TR*         WHERE                                                           
MFA-TR*                AT.CUSTOMER_NO       = :AT-CUSTOMER-NO                   
MFA-TR*           AND  AT.COMPANY_NO        = :WS-COMPANY-NO                    
MFA-TR*           AND  ((AT.CODE_ACCT_STAT  = 'B'                               
MFA-TR*           AND  AT.TOTAL_AR_BALANCE  >= 0 )                              
MFA-TR*            OR  AT.CODE_ACCT_STAT    = 'S')                              
MFA-TR*           AND  CZ.ACCOUNT_NO        = AT.ACCOUNT_NO                     
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO POPULATE CODE VALUE TABLE ARRAY.                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE CODE_CURSOR CURSOR FOR                          
                SELECT                                                  
                       UV.CODE_VALUE                                    
                      ,UV.CODE_LONG_DESC                                
                FROM                                                    
                       CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                  
                WHERE                                                   
                       UV.PROGRAM_ID = 'WEBSST'                         
                  AND  UV.COMPANY_NO = :WS-COMPANY-NO                   
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CODE_CURSOR CURSOR FOR                                  
MFA-TR*         SELECT                                                          
MFA-TR*                UV.CODE_VALUE                                            
MFA-TR*               ,UV.CODE_LONG_DESC                                        
MFA-TR*         FROM                                                            
MFA-TR*                CSS_CODE_VALUE UV                                        
MFA-TR*         WHERE                                                           
MFA-TR*                UV.PROGRAM_ID = 'WEBSST'                                 
MFA-TR*           AND  UV.COMPANY_NO = :WS-COMPANY-NO                           
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO GET THE ACCOUNT NO & PAST DUE CHARGES FROM RESULTSET *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE RES_CURSOR CURSOR FOR                           
                SELECT                                                  
                       ACCOUNT_NO                                       
                      ,PAST_DUE_UTL                                     
                      ,PAST_DUE_NONUTL                                  
                      ,TOTAL_UTL                                        
                      ,TOTAL_NONUTL                                     
                      ,ACCT_SRVC_ADDRESS                                
                FROM                                                    
                       #CSR04030_R1                              
                WHERE                                                   
                      PAST_DUE_FLAG = 'Y'                               
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE RES_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT                                                          
MFA-TR*                ACCOUNT_NO                                               
MFA-TR*               ,PAST_DUE_UTL                                             
MFA-TR*               ,PAST_DUE_NONUTL                                          
MFA-TR*               ,TOTAL_UTL                                                
MFA-TR*               ,TOTAL_NONUTL                                             
MFA-TR*               ,ACCT_SRVC_ADDRESS                                        
MFA-TR*         FROM                                                            
MFA-TR*                SESSION.CSR04030_R1                                      
MFA-TR*         WHERE                                                           
MFA-TR*               PAST_DUE_FLAG = 'Y'                                       
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR02022( :WS-ACCOUNT-NO
                  )
MSQ001        END-EXEC.
                                                    
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  I-CUSTOMER-NO            PIC 9(10).                          
       01  I-NEW-PRMSE-NO           PIC X(10).                          
       01  I-CUST-FLAG              PIC X(06).                          
       01  I-COMPANY-NO             PIC X(02).                          
       01  I-XFER-FLAG              PIC X(01).                          
       01  I-XFER-ACCT-NO           PIC X(13).                          
      *                                                                         
       PROCEDURE DIVISION USING  I-CUSTOMER-NO                          
                               , I-NEW-PRMSE-NO                         
                               , I-CUST-FLAG                            
                               , I-COMPANY-NO                           
                               , I-XFER-FLAG                            
                               , I-XFER-ACCT-NO.                        
      *                                                                         
      ******************************************************************        
      * Controls the Main Processing of the Program.                   *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Initialize Return Fields, Declare GTT and Result Set Cursor.   *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
      *                                                                         
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 RETURN_CODE                  AS RETURN_CODE            
                ,PROGRAM_ID                   AS PROGRAM_ID             
                ,PROCESS_CD                   AS PROCESS_CD             
                ,CRDT_CHCK_REQ                AS CRDT_CHCK_REQ          
                ,CPTR_QUE_FLAG                AS CPTR_QUE_FLAG          
                ,PAST_DUE_FLAG                AS PAST_DUE_FLAG          
                ,DEPOSIT_AMT                  AS DEPOSIT_AMT            
                ,ACCOUNT_NO                   AS ACCOUNT_NO             
                ,CODE_ACCT_STAT               AS CODE_ACCT_STAT         
                ,PAST_DUE_UTL                 AS PAST_DUE_UTL           
                ,PAST_DUE_NONUTL              AS PAST_DUE_NONUTL        
                ,CUST_TYPE                    AS CUST_TYPE              
                ,TOTAL_UTL                    AS TOTAL_UTL              
                ,TOTAL_NONUTL                 AS TOTAL_NONUTL           
                ,CASHONLY_FLAG                AS CASHONLY_FLAG          
                ,SSN                          AS SSN                    
                ,ACCT_SRVC_ADDRESS            AS ACCT_SRVC_ADDRESS      
                ,PREMISE_NO                   AS PREMISE_NO             
              FROM #CSR04030_R1                                  
              ORDER BY PROCESS_CD                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE                  AS RETURN_CODE                    
MFA-TR*         ,PROGRAM_ID                   AS PROGRAM_ID                     
MFA-TR*         ,PROCESS_CD                   AS PROCESS_CD                     
MFA-TR*         ,CRDT_CHCK_REQ                AS CRDT_CHCK_REQ                  
MFA-TR*         ,CPTR_QUE_FLAG                AS CPTR_QUE_FLAG                  
MFA-TR*         ,PAST_DUE_FLAG                AS PAST_DUE_FLAG                  
MFA-TR*         ,DEPOSIT_AMT                  AS DEPOSIT_AMT                    
MFA-TR*         ,ACCOUNT_NO                   AS ACCOUNT_NO                     
MFA-TR*         ,CODE_ACCT_STAT               AS CODE_ACCT_STAT                 
MFA-TR*         ,PAST_DUE_UTL                 AS PAST_DUE_UTL                   
MFA-TR*         ,PAST_DUE_NONUTL              AS PAST_DUE_NONUTL                
MFA-TR*         ,CUST_TYPE                    AS CUST_TYPE                      
MFA-TR*         ,TOTAL_UTL                    AS TOTAL_UTL                      
MFA-TR*         ,TOTAL_NONUTL                 AS TOTAL_NONUTL                   
MFA-TR*         ,CASHONLY_FLAG                AS CASHONLY_FLAG                  
MFA-TR*         ,SSN                          AS SSN                            
MFA-TR*         ,ACCT_SRVC_ADDRESS            AS ACCT_SRVC_ADDRESS              
MFA-TR*         ,PREMISE_NO                   AS PREMISE_NO                     
MFA-TR*       FROM SESSION.CSR04030_R1                                          
MFA-TR*       ORDER BY PROCESS_CD                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           INITIALIZE WS-COMM-COMMENT.                                  
           INITIALIZE WS-CODE-ARRAY-TABLE.                              
      *                                                                         
           SET WS-INDEX    TO 1.                                        
           SET WS-INDEX-SP TO 1.                                        
DEF054     MOVE 1          TO WS-CNT.                                   
           MOVE 'N'        TO WS-SPCL-PSNC-PASTDUE.                     
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *0100A-DECLARE-GTT************************************************        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04030_R1'            
                                                TO S-SQL-STATEMENT-V.   
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04030_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04030_R1
              (                                                       
                   RETURN_CODE           INT                        
                  ,PROGRAM_ID CHAR(8)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,PROCESS_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,CRDT_CHCK_REQ CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,CPTR_QUE_FLAG CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,PAST_DUE_FLAG CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,DEPOSIT_AMT           DECIMAL(11,2)                  
                  ,ACCOUNT_NO            DECIMAL(13,0)                  
                  ,CODE_ACCT_STAT CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,PAST_DUE_UTL          DECIMAL(11,2)                  
                  ,PAST_DUE_NONUTL       DECIMAL(11,2)                  
                  ,CUST_TYPE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,TOTAL_UTL             DECIMAL(11,2)                  
                  ,TOTAL_NONUTL          DECIMAL(11,2)                  
                  ,CASHONLY_FLAG CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,SSN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2                
                  ,ACCT_SRVC_ADDRESS CHAR(75)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,PREMISE_NO            DECIMAL(10,0)                  
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
             PERFORM 8000A-DELETE-GTT-ROWS     THRU 8000A-EXIT          
             MOVE ZEROES                     TO WS-ACTIVE-RETURN-CODE   
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '0100A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DECLARE GTT'         TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04030_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU  9900-EXIT                
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE I-CUSTOMER-NO            TO WS-CUSTOMER-NO.             
           MOVE I-NEW-PRMSE-NO           TO WS-PREMISE-NO.              
           MOVE I-CUST-FLAG              TO WS-CUST-FLAG.               
           MOVE I-COMPANY-NO             TO WS-COMPANY-NO.              
           MOVE I-XFER-FLAG              TO WS-XFER-FLAG.               
           MOVE I-XFER-ACCT-NO           TO WS-XFER-ACCT-NO.            
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE PROGRAM-NAME                TO RS-PROGRAM-ID.           
                                                                        
           MOVE 0                           TO WS-ACCT-ARRAY-CNT        
                                               WS-SP-ARRAY-CNT.         
      *                                                                         
           IF WS-XFER-FLAG = 'Y'                                        
              IF WS-XFER-ACCT-NO-NUM > 0                                
                 MOVE WS-XFER-ACCT-NO-NUM   TO WS-XFER-ACCT-NO-COMP3    
              ELSE                                                      
                 MOVE 0                     TO WS-XFER-ACCT-NO-COMP3    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           UNSTRING WS-CUSTOMER-NO DELIMITED BY SPACES INTO             
                                            WS-CUSTOMER-NO-JST.         
           MOVE WS-CUSTOMER-NO-NUM          TO WS-CUSTOMER-NO-COMP3.    
           MOVE WS-CUSTOMER-NO-COMP3        TO CE-CUSTOMER-NO.          
                                                                        
           MOVE 'N'                         TO WS-CUST-CUR.             
           PERFORM 7000-OPEN-CUST-CUR       THRU 7000-EXIT.             
           PERFORM 7001-FETCH-CUST-CUR      THRU 7001-EXIT.             
           PERFORM UNTIL WS-CUST-EOC                                    
      * Select all accounts for given customer and load into WS table.          
               IF CE-CUSTOMER-NO = WS-CUSTOMER-NO-COMP3                 
                  IF WS-CUST-NOT-PROCESSED                              
                     MOVE CE-CUSTOMER-NO    TO AT-CUSTOMER-NO           
                     MOVE CE-SSN            TO WS-CUST-SSN              
                     PERFORM 7020-OPEN-ACCT-CURSOR    THRU 7020-EXIT    
                     PERFORM 7030-FETCH-ACCT-CURSOR   THRU 7030-EXIT    
                     IF WS-XFER-FLAG NOT = 'Y'                          
                        PERFORM 2001-PROCESS-ACCT-CURSOR THRU 2001-EXIT 
                          UNTIL NO-MORE-DATA-ACCTCUR                    
                     ELSE                                               
                        PERFORM 2031-PROCESS-XFER-ACCT THRU 2031-EXIT   
                          UNTIL NO-MORE-DATA-ACCTCUR                    
                     END-IF                                             
                     PERFORM 7040-CLOSE-ACCT-CURSOR   THRU 7040-EXIT    
                     MOVE 'N'        TO WS-NO-MORE-DATA-ACCTCUR         
                     SET WS-CUST-PROCESSED            TO TRUE           
                  ELSE                                                  
                     CONTINUE                                           
                  END-IF                                                
               ELSE                                                     
                  IF CE-CUSTOMER-TYPE = 'S'                             
                     MOVE CE-CUSTOMER-NO              TO AT-CUSTOMER-NO 
                     PERFORM 7020-OPEN-ACCT-CURSOR       THRU 7020-EXIT 
                     PERFORM 7030-FETCH-ACCT-CURSOR      THRU 7030-EXIT 
                     IF WS-XFER-FLAG NOT = 'Y'                          
                        PERFORM 2001-PROCESS-ACCT-CURSOR THRU 2001-EXIT 
                          UNTIL NO-MORE-DATA-ACCTCUR                    
                     ELSE                                               
                        PERFORM 2031-PROCESS-XFER-ACCT THRU 2031-EXIT   
                          UNTIL NO-MORE-DATA-ACCTCUR                    
                     END-IF                                             
                     PERFORM 7040-CLOSE-ACCT-CURSOR   THRU 7040-EXIT    
                     MOVE 'N'        TO WS-NO-MORE-DATA-ACCTCUR         
                  END-IF                                                
      * Select all accounts for given spouse cust and load in WS table. e.      
                  IF CE-CUSTOMER-TYPE = 'C' AND WS-XFER-FLAG NOT = 'Y'  
                     MOVE CE-CUSTOMER-NO    TO AT-CUSTOMER-NO           
                     MOVE CE-SSN            TO WS-SP-SSN                
                     PERFORM 7015-SELECT-SP-ACTIVE-ACCTS THRU 7015-EXIT 
                     PERFORM 7050-OPEN-SPOUSE-CURSOR  THRU 7050-EXIT    
                     PERFORM 7060-FETCH-SPOUSE-CURSOR THRU 7060-EXIT    
                     PERFORM 2002-PROCESS-SPOUSE-CURSOR THRU 2002-EXIT  
                       UNTIL NO-MORE-DATA-SPCUR                         
                     PERFORM 7070-CLOSE-SPOUSE-CURSOR THRU 7070-EXIT    
                     MOVE 'N'        TO WS-NO-MORE-DATA-SPCUR           
                  END-IF                                                
               END-IF                                                   
               PERFORM 7001-FETCH-CUST-CUR  THRU 7001-EXIT              
           END-PERFORM.                                                 
      *                                                                         
PECS12*Assuming given Cust# doesn't have valid SSN#, load accts to table        
PECS12     IF WS-ACCT-ARRAY-CNT = 0 AND                                 
PECS12        WS-SP-ARRAY-CNT = 0 AND WS-ACTIVE-SP-CNT = 0 THEN         
PECS12        MOVE WS-CUSTOMER-NO-COMP3        TO AT-CUSTOMER-NO        
PECS12        PERFORM 7020-OPEN-ACCT-CURSOR    THRU 7020-EXIT           
PECS12        PERFORM 7030-FETCH-ACCT-CURSOR   THRU 7030-EXIT           
PECS12        IF WS-XFER-FLAG NOT = 'Y'                                 
PECS12           PERFORM 2001-PROCESS-ACCT-CURSOR THRU 2001-EXIT        
PECS12                   UNTIL NO-MORE-DATA-ACCTCUR                     
PECS12        ELSE                                                      
PECS12           PERFORM 2031-PROCESS-XFER-ACCT THRU 2031-EXIT          
PECS12                   UNTIL NO-MORE-DATA-ACCTCUR                     
PECS12        END-IF                                                    
PECS12        PERFORM 7040-CLOSE-ACCT-CURSOR   THRU 7040-EXIT           
PECS12        MOVE 'N'        TO WS-NO-MORE-DATA-ACCTCUR                
PECS12     END-IF.                                                      
                                                                        
      * Find IN-PREMISE-NO has any Active accts found                           
           MOVE WS-PREMISE-NO-NUM           TO WS-PREMISE-NO-COMP3.     
           PERFORM 7110-SELECT-ACCT-NO      THRU 7110-EXIT.             
      * Process Active accounts for given Acct-Customers                        
           MOVE    'N'                      TO WS-ACTIVE-ACCT           
                                               WS-MULT-ACTIVE-ACCT.     
                                                                        
           PERFORM 2004-ACTIVE-ACCT-CNT     THRU 2004-EXIT              
                                            VARYING WS-INDEX FROM 1 BY 1
                                     UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT.
                                                                        
           MOVE 'N'                         TO RS-CPTR-QUE-FLAG.        
           IF WS-ACTIVE-ACCT-CNT = 1                                    
              MOVE 'Y'                      TO WS-ACTIVE-ACCT           
              MOVE 'N'                      TO WS-MULT-ACTIVE-ACCT      
           ELSE                                                         
              IF WS-ACTIVE-ACCT-CNT > 1                                 
                 MOVE 'Y'                   TO WS-ACTIVE-ACCT           
                                               WS-MULT-ACTIVE-ACCT      
              END-IF                                                    
           END-IF.                                                      
      * Process Active Accounts Logic Here                                      
           IF WS-ACTIVE-ACCT = 'Y' THEN                                 
              PERFORM 2005-ACTIVE-PREMISE   THRU 2005-EXIT              
                                            VARYING WS-INDEX FROM 1 BY 1
                                      UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT
              IF WS-EXIT-FLAG = 'N' THEN                                
                 PERFORM 2024-MEDICAL-CERT  THRU 2024-EXIT              
                                            VARYING WS-INDEX FROM 1 BY 1
                                     UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT 
              IF WS-EXIT-FLAG = 'N' THEN                                
                 PERFORM 2025-DPP-FILTER    THRU 2025-EXIT              
                                           VARYING WS-INDEX FROM 1 BY 1 
                                     UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT 
              IF WS-EXIT-FLAG = 'N' THEN                                
                 PERFORM 2026-ENDV-FILTER   THRU 2026-EXIT              
                                            VARYING WS-INDEX FROM 1 BY 1
                                      UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT
              IF WS-EXIT-FLAG = 'N' THEN                                
                 PERFORM 2028-DNP-FB-FILTER THRU 2028-EXIT              
                                            VARYING WS-INDEX FROM 1 BY 1
                                      UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT
              IF WS-EXIT-FLAG = 'N' THEN                                
                 PERFORM 2027-RECONNECT-FILTER                          
                                            THRU 2027-EXIT              
                                            VARYING WS-INDEX FROM 1 BY 1
                                      UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT
              IF WS-EXIT-FLAG = 'N' THEN                                
                 PERFORM 7130-SEL-PASTDUE-LMT THRU 7130-EXIT            
                 PERFORM 2007-ACTIVE-PASTDUE  THRU 2007-EXIT            
                                      VARYING WS-INDEX FROM 1 BY 1      
                                      UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT
                                                                        
              END-IF                                                    
              END-IF                                                    
              END-IF                                                    
              END-IF                                                    
              END-IF                                                    
           END-IF
           END-IF.                                                      
      * Process Non-Active - Final\WO Past dues accounts here                   
           IF WS-ACTIVE-ACCT = 'N' THEN                                 
              PERFORM 2023-BANKRUPT-ACCT    THRU 2023-EXIT              
                                     VARYING WS-INDEX FROM 1 BY 1       
                                     UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT 
              MOVE    'N'                   TO WS-SPCL-PSNC-PASTDUE     
              PERFORM 2010-FINAL-BILLED-ACCT THRU 2010-EXIT             
                                     VARYING WS-INDEX FROM 1 BY 1       
                                     UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT 
              IF WS-SP-ARRAY-CNT > 0 THEN                               
                 PERFORM 2037-FB-SPOUSE-ACCT     THRU 2037-EXIT         
                                    VARYING WS-INDEX-SP FROM 1 BY 1     
                                  UNTIL WS-INDEX-SP > WS-SP-ARRAY-CNT   
                                                                        
                 PERFORM 2008-SPOUSE-PAST-DUE    THRU 2008-EXIT         
                                                                        
              END-IF                                                    
                                                                        
              IF WS-EXIT-FLAG = 'N'                                     
                 PERFORM 2011-CHK-WRITEOFF  THRU 2011-EXIT              
                 IF WS-CNT-FLAG = 'Y' OR WS-CNTT-FLAG = 'Y' THEN        
                    MOVE 'N'                   TO WS-VALID-WRITE-OFF    
                    PERFORM 2015-WRITEOFF-ACCT THRU 2015-EXIT           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-PAST-DUE-CHARGE = 'Y' AND WS-SPCL-PSNC-PASTDUE = 'N'   
      * Code Value:'C'- Quoted Past due balance                                 
              MOVE 'C'          TO WS-COMM-CODE(WS-CNT)                 
              ADD  +1            TO WS-CNT                              
           ELSE                                                         
              IF WS-PAST-DUE-CHARGE = 'Y' AND WS-SPCL-PSNC-PASTDUE = 'Y'
      * Code Value:'A'- Request Incomplete                                      
                 MOVE 'A'          TO WS-COMM-CODE(WS-CNT)              
                 ADD  +1            TO WS-CNT                           
      * Code Value:'N'- PSNC customer has write-off balance                     
                 MOVE 'N'          TO WS-COMM-CODE(WS-CNT)              
                 ADD  +1            TO WS-CNT                           
              END-IF                                                    
           END-IF.                                                      
           IF CTR-ROWS = 0                                              
             IF WS-XFER-FLAG NOT = 'Y' THEN                             
               IF WS-ACCT-ARRAY-CNT = 0 AND                             
                  WS-SP-ARRAY-CNT = 0 AND WS-ACTIVE-SP-CNT = 0 THEN     
      * Code-Value:'T'- Called Equifax                                          
                  MOVE 'T '                    TO WS-COMM-CODE(WS-CNT)  
                  ADD +1                       TO WS-CNT                
                  MOVE 'T'                     TO RS-PROCESS-CD         
                  MOVE 'N'                     TO RS-CRDT-CHCK-REQ      
                  MOVE 'N'                     TO RS-CPTR-QUE-FLAG      
                  MOVE 'N'                     TO RS-PAST-DUE-FLAG      
                  MOVE 0                       TO RS-DEPOSIT-AMT        
                  MOVE 0                       TO RS-ACCOUNT-NO         
                  MOVE 0                       TO RS-PREMISE-NO         
                  MOVE SPACES                  TO RS-CODE-ACCT-STAT     
                  MOVE 0                       TO RS-PAST-DUE-UTL       
                  MOVE 0                       TO RS-PAST-DUE-NONUTL    
                  MOVE 'C'                     TO RS-CUST-TYPE          
                  MOVE WS-CUST-SSN             TO RS-SSN                
                  MOVE 0                       TO RS-TOTAL-UTL          
                  MOVE 0                       TO RS-TOTAL-NONUTL       
                  MOVE 'N'                     TO RS-CASH-ONLY-FLAG     
                  MOVE SPACES                  TO RS-ACCT-SRVC-ADDRESS  
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 8100-SEND-RESULT     THRU 8100-EXIT           
               ELSE                                                     
                  MOVE 0                       TO RS-RETURN-CODE        
                  MOVE 'Z'                     TO RS-PROCESS-CD         
                  MOVE 'Y'                     TO RS-CRDT-CHCK-REQ      
                  MOVE 'N'                     TO RS-CPTR-QUE-FLAG      
                  MOVE 'N'                     TO RS-PAST-DUE-FLAG      
                  MOVE 0                       TO RS-DEPOSIT-AMT        
                  MOVE 0                       TO RS-ACCOUNT-NO         
                  MOVE 0                       TO RS-PREMISE-NO         
                  MOVE SPACES                  TO RS-CODE-ACCT-STAT     
                  MOVE 0                       TO RS-PAST-DUE-UTL       
                  MOVE 0                       TO RS-PAST-DUE-NONUTL    
                  IF WS-ACCT-ARRAY-CNT = 0 AND                          
                     (WS-SP-ARRAY-CNT > 0 OR WS-ACTIVE-SP-CNT > 0) THEN 
                     MOVE 'S'                  TO RS-CUST-TYPE          
                     MOVE WS-SP-SSN            TO RS-SSN                
                  ELSE                                                  
                     MOVE 'C'                  TO RS-CUST-TYPE          
                     MOVE WS-CUST-SSN          TO RS-SSN                
                  END-IF                                                
                  MOVE 0                       TO RS-TOTAL-UTL          
                  MOVE 0                       TO RS-TOTAL-NONUTL       
                  MOVE 'N'                     TO RS-CASH-ONLY-FLAG     
                  MOVE SPACES                  TO RS-ACCT-SRVC-ADDRESS  
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 8100-SEND-RESULT     THRU 8100-EXIT           
               END-IF                                                   
             ELSE                                                       
      * Xfer process-Default X row,if xfer acct doesn't have past due           
               MOVE 0                       TO RS-RETURN-CODE           
               MOVE 'X'                     TO RS-PROCESS-CD            
               MOVE 'N'                     TO RS-CRDT-CHCK-REQ         
               MOVE 'N'                     TO RS-CPTR-QUE-FLAG         
               MOVE 'N'                     TO RS-PAST-DUE-FLAG         
               MOVE 0                       TO RS-DEPOSIT-AMT           
               MOVE 0                       TO RS-ACCOUNT-NO            
               MOVE 0                       TO RS-PREMISE-NO            
               MOVE SPACES                  TO RS-CODE-ACCT-STAT        
               MOVE 0                       TO RS-PAST-DUE-UTL          
               MOVE 0                       TO RS-PAST-DUE-NONUTL       
               MOVE 'C'                     TO RS-CUST-TYPE             
               MOVE 0                       TO RS-TOTAL-UTL             
               MOVE 0                       TO RS-TOTAL-NONUTL          
               MOVE 'N'                     TO RS-CASH-ONLY-FLAG        
               MOVE SPACES                  TO RS-ACCT-SRVC-ADDRESS     
               PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT             
               PERFORM 8100-SEND-RESULT     THRU 8100-EXIT              
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF CTR-ROWS > 0                                              
              PERFORM 2500-PROCESS-COMM-DETAILS          THRU 2500-EXIT 
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Prepares Result Set Row.                                       *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
           MOVE RS-PROGRAM-ID             TO S-PROGRAM-ID.              
           MOVE RS-PROCESS-CD             TO S-PROCESS-CD.              
           MOVE RS-CRDT-CHCK-REQ          TO S-CRDT-CHCK-REQ.           
           MOVE RS-CPTR-QUE-FLAG          TO S-CPTR-QUE-FLAG.           
           MOVE RS-PAST-DUE-FLAG          TO S-PAST-DUE-FLAG.           
      *                                                                         
      *Applying $150 Min Dep rule for SCE&G Combo/Elec Service.                 
      *                                                                         
           IF WS-COMPANY-NO = '01'                                      
              IF RS-DEPOSIT-AMT > 0 AND RS-DEPOSIT-AMT < +150           
                 PERFORM 5200-CHECK-SERV-AT-NEW-PR                      
                                          THRU 5200-EXIT                
                 IF WS-GAS-ONLY                                         
                    MOVE RS-DEPOSIT-AMT   TO S-DEPOSIT-AMT              
                 ELSE                                                   
                    MOVE 150              TO S-DEPOSIT-AMT              
                 END-IF                                                 
              ELSE                                                      
                 MOVE RS-DEPOSIT-AMT      TO S-DEPOSIT-AMT              
              END-IF                                                    
           ELSE                                                         
              MOVE RS-DEPOSIT-AMT         TO S-DEPOSIT-AMT              
           END-IF.                                                      
           MOVE S-DEPOSIT-AMT             TO WS-DEPOSIT-AMT.            
           MOVE RS-ACCOUNT-NO             TO S-ACCOUNT-NO.              
           MOVE RS-CODE-ACCT-STAT         TO S-CODE-ACCT-STAT.          
           MOVE RS-PAST-DUE-UTL           TO S-PAST-DUE-UTL.            
           MOVE RS-PAST-DUE-NONUTL        TO S-PAST-DUE-NONUTL.         
           MOVE RS-CUST-TYPE              TO S-CUST-TYPE.               
           MOVE RS-TOTAL-UTL              TO S-TOTAL-UTL.               
           MOVE RS-TOTAL-NONUTL           TO S-TOTAL-NONUTL.            
           MOVE RS-CASH-ONLY-FLAG         TO S-CASH-ONLY-FLAG.          
           MOVE RS-SSN                    TO S-SSN.                     
           MOVE RS-ACCT-SRVC-ADDRESS      TO S-ACCT-SRVC-ADDRESS.       
           MOVE RS-PREMISE-NO             TO S-PREMISE-NO.              
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2001-PROCESS-ACCT-CURSOR.                                      *        
      ******************************************************************        
      *                                                                         
       2001-PROCESS-ACCT-CURSOR.                                        
                                                                        
           ADD +1                           TO WS-ACCT-ARRAY-CNT.       
           MOVE AT-ACCOUNT-NO               TO WS-ACCT-ACCOUNT-NO       
                                               (WS-INDEX).              
           MOVE AT-PREMISE-NO               TO WS-ACCT-PREMISE-NO       
                                               (WS-INDEX).              
           MOVE AT-CODE-ACCT-STAT           TO WS-ACCT-CODE-ACCT-STAT   
                                               (WS-INDEX).              
           MOVE AT-TOTAL-AR-BALANCE         TO WS-ACCT-TOTAL-AR-BAL     
                                               (WS-INDEX).              
           MOVE AT-CODES-DATA-PRESENT       TO                          
                                   WS-ACCT-CODES-DATA-PRESENT(WS-INDEX).
           MOVE AT-CODE-STATUS-REASON       TO WS-ACCT-CODE-STAT-REASON 
                                               (WS-INDEX).              
           MOVE AT-BANKRUPTCY-IND           TO WS-ACCT-BANKRUPTCY-IND   
                                               (WS-INDEX).              
           MOVE AT-CREDIT-GROUP             TO WS-ACCT-CREDIT-GROUP     
                                               (WS-INDEX).              
           MOVE AT-MST-SUB-ACCT-IND         TO WS-ACCT-MST-SUB-ACCT-IND 
                                               (WS-INDEX).              
           MOVE AT-CODE-MAJOR-ACCT          TO WS-ACCT-CODE-MAJOR-ACCT  
                                               (WS-INDEX).              
           MOVE AT-CT-METER-RATED-IND       TO                          
                                   WS-ACCT-CT-METER-RATED-IND(WS-INDEX).
           MOVE AT-COMPANY-NO               TO WS-ACCT-COMPANY-NO       
                                               (WS-INDEX).              
           MOVE AT-LOCAL-OFFICE             TO WS-ACCT-LOCAL-OFFICE     
                                               (WS-INDEX).              
           MOVE AT-CANREB-CODE-00-DAY       TO WS-ACCT-DATE-BILL-DAY-00 
                                               (WS-INDEX).              
           MOVE AT-CANREB-CODE-30-DAY       TO WS-ACCT-DATE-BILL-DAY-30 
                                               (WS-INDEX).              
           MOVE AT-CANREB-CODE-60-DAY       TO WS-ACCT-DATE-BILL-DAY-60 
                                               (WS-INDEX).              
           MOVE AT-CANREB-CODE-90-DAY       TO WS-ACCT-DATE-BILL-DAY-90 
                                               (WS-INDEX).              
           MOVE AT-CODE-DISC-OK             TO WS-ACCT-CODE-DISC-OK     
                                               (WS-INDEX).              
           MOVE AT-NOTICE-EXEMPT-CD         TO WS-ACCT-NOTICE-EXEMPT-CD 
                                               (WS-INDEX).              
           MOVE AT-BILL-CYCLE               TO WS-ACCT-BILL-CYCLE       
                                               (WS-INDEX).              
           MOVE AT-IVR-EXEMPT-CD            TO WS-ACCT-IVR-EXEMPT-CD    
                                               (WS-INDEX).              
           IF CZ-CASH-ONLY-FL = ' ' THEN                                
              MOVE 'N'                      TO                          
                                        WS-ACCT-CASHONLY-FLAG(WS-INDEX) 
           ELSE                                                         
              MOVE CZ-CASH-ONLY-FL          TO                          
                                        WS-ACCT-CASHONLY-FLAG(WS-INDEX) 
           END-IF.                                                      
           SET WS-INDEX                     UP BY 1.                    
           PERFORM 7030-FETCH-ACCT-CURSOR   THRU 7030-EXIT.             
      *                                                                         
       2001-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2002-PROCESS-SPOUSE-CURSOR.                                    *        
      ******************************************************************        
      *                                                                         
       2002-PROCESS-SPOUSE-CURSOR.                                      
                                                                        
           ADD +1                       TO WS-SP-ARRAY-CNT.             
                                                                        
           MOVE AT-ACCOUNT-NO           TO WS-SP-ACCOUNT-NO             
                                           (WS-INDEX-SP).               
           MOVE AT-PREMISE-NO           TO WS-SP-PREMISE-NO             
                                           (WS-INDEX-SP).               
           MOVE AT-CODE-ACCT-STAT       TO WS-SP-CODE-ACCT-STAT         
                                           (WS-INDEX-SP).               
           MOVE AT-TOTAL-AR-BALANCE     TO WS-SP-TOTAL-AR-BAL           
                                           (WS-INDEX-SP).               
           MOVE AT-CODES-DATA-PRESENT   TO WS-SP-CODES-DATA-PRESENT     
                                           (WS-INDEX-SP).               
           MOVE AT-CODE-STATUS-REASON   TO WS-SP-CODE-STAT-REASON       
                                           (WS-INDEX-SP).               
           MOVE AT-BANKRUPTCY-IND       TO WS-SP-BANKRUPTCY-IND         
                                           (WS-INDEX-SP).               
           MOVE AT-CREDIT-GROUP         TO WS-SP-CREDIT-GROUP           
                                           (WS-INDEX-SP).               
           MOVE AT-MST-SUB-ACCT-IND     TO WS-SP-MST-SUB-ACCT-IND       
                                           (WS-INDEX-SP).               
           MOVE AT-CODE-MAJOR-ACCT      TO WS-SP-CODE-MAJOR-ACCT        
                                           (WS-INDEX-SP).               
           MOVE AT-CT-METER-RATED-IND   TO WS-SP-CT-METER-RATED-IND     
                                           (WS-INDEX-SP).               
           MOVE AT-COMPANY-NO           TO WS-SP-COMPANY-NO             
                                           (WS-INDEX-SP).               
           MOVE AT-LOCAL-OFFICE         TO WS-SP-LOCAL-OFFICE           
                                           (WS-INDEX-SP).               
           MOVE AT-CANREB-CODE-00-DAY   TO WS-SP-DATE-BILL-DAY-00       
                                           (WS-INDEX-SP).               
           MOVE AT-CANREB-CODE-30-DAY   TO WS-SP-DATE-BILL-DAY-30       
                                           (WS-INDEX-SP).               
           MOVE AT-CANREB-CODE-60-DAY   TO WS-SP-DATE-BILL-DAY-60       
                                           (WS-INDEX-SP).               
           MOVE AT-CANREB-CODE-90-DAY   TO WS-SP-DATE-BILL-DAY-90       
                                           (WS-INDEX-SP).               
           MOVE AT-CODE-DISC-OK         TO WS-SP-CODE-DISC-OK           
                                           (WS-INDEX-SP).               
           MOVE AT-NOTICE-EXEMPT-CD     TO WS-SP-NOTICE-EXEMPT-CD       
                                           (WS-INDEX-SP).               
           MOVE AT-BILL-CYCLE           TO WS-SP-BILL-CYCLE             
                                           (WS-INDEX-SP).               
           MOVE AT-IVR-EXEMPT-CD        TO WS-SP-IVR-EXEMPT-CD          
                                           (WS-INDEX-SP).               
           IF CZ-CASH-ONLY-FL = ' ' THEN                                
              MOVE 'N'                      TO                          
                                   WS-SP-CASHONLY-FLAG(WS-INDEX-SP)     
           ELSE                                                         
              MOVE CZ-CASH-ONLY-FL          TO                          
                                   WS-SP-CASHONLY-FLAG(WS-INDEX-SP)     
           END-IF.                                                      
           SET WS-INDEX-SP              UP BY 1.                        
           PERFORM 7060-FETCH-SPOUSE-CURSOR                             
                                        THRU 7060-EXIT.                 
      *                                                                         
       2002-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2004-ACTIVE-ACCT-CNT.                                          *        
      ******************************************************************        
      *                                                                         
       2004-ACTIVE-ACCT-CNT.                                            
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'A'                    
              ADD +1                      TO WS-ACTIVE-ACCT-CNT         
           END-IF.                                                      
      *                                                                         
       2004-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2005-ACTIVE-PREMISE.                                           *        
      ******************************************************************        
      *                                                                         
       2005-ACTIVE-PREMISE.                                             
                                                                        
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'A'                    
              IF WS-ACCT-PREMISE-NO(WS-INDEX) = WS-PREMISE-NO-COMP3     
      *      Code Value:'A'-Request Incomplete                                  
                 MOVE 'A'                   TO WS-COMM-CODE(WS-CNT)     
                 ADD  +1                    TO WS-CNT                   
      *      Code Value:'B'-Cust already has SVC at Premise                     
                 MOVE 'B'                   TO WS-COMM-CODE(WS-CNT)     
                 ADD  +1                    TO WS-CNT                   
                 MOVE 0                     TO RS-RETURN-CODE           
                 MOVE 'C'                   TO RS-PROCESS-CD            
                 MOVE 'N'                   TO RS-CRDT-CHCK-REQ         
                 MOVE 'Y'                   TO RS-CPTR-QUE-FLAG         
                 MOVE 'N'                   TO RS-PAST-DUE-FLAG         
                 MOVE 0                     TO RS-DEPOSIT-AMT           
                 MOVE 0                     TO RS-ACCOUNT-NO            
                 MOVE 0                     TO RS-PREMISE-NO            
                 MOVE SPACES                TO RS-CODE-ACCT-STAT        
                 MOVE 0                     TO RS-PAST-DUE-UTL          
                 MOVE 0                     TO RS-PAST-DUE-NONUTL       
                 MOVE 'C'                   TO RS-CUST-TYPE             
                 MOVE 0                     TO RS-TOTAL-UTL             
                 MOVE 0                     TO RS-TOTAL-NONUTL          
                 MOVE 'N'                   TO RS-CASH-ONLY-FLAG        
                 MOVE SPACES                TO RS-ACCT-SRVC-ADDRESS     
                 PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
                 MOVE 'Y'                   TO WS-EXIT-FLAG             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2005-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2007-ACTIVE-PASTDUE.                                           *        
      ******************************************************************        
      *                                                                         
       2007-ACTIVE-PASTDUE.                                             
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'A'                    
              MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX) TO AT-ACCOUNT-NO        
                                                                        
              PERFORM 9500-CALL-CPD00068  THRU 9500-EXIT                
                                                                        
              MOVE WS-AMT-PAST-DUE-UTL    TO                            
                                         WS-ACCT-PAST-DUE-UTIL(WS-INDEX)
              MOVE WS-AMT-PAST-DUE-NONUTL TO                            
                                      WS-ACCT-PAST-DUE-NONUTIL(WS-INDEX)
              IF WS-ACCT-PAST-DUE-UTIL(WS-INDEX) >                      
                                             WS-PAST-DUE-DELINQ-LIMIT   
                 MOVE 'Y'                 TO WS-PAST-DUE-CHARGE         
                 PERFORM 2201-GETS-ACCT-SRV-ADDRESS   THRU 2201-EXIT    
                 MOVE 0                   TO RS-RETURN-CODE             
                 MOVE 'P'                 TO RS-PROCESS-CD              
                 MOVE 'N'                 TO RS-CRDT-CHCK-REQ           
                 MOVE 'N'                 TO RS-CPTR-QUE-FLAG           
                 MOVE 'Y'                 TO RS-PAST-DUE-FLAG           
                 MOVE 0                   TO RS-DEPOSIT-AMT             
                 MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX)                      
                                          TO RS-ACCOUNT-NO              
                 MOVE WS-ACCT-PREMISE-NO(WS-INDEX)                      
                                          TO RS-PREMISE-NO              
                 MOVE WS-ACCT-CODE-ACCT-STAT(WS-INDEX)                  
                                          TO RS-CODE-ACCT-STAT          
                 MOVE WS-ACCT-PAST-DUE-UTIL(WS-INDEX)                   
                                          TO RS-PAST-DUE-UTL            
                                             RS-TOTAL-UTL               
                 MOVE WS-ACCT-PAST-DUE-NONUTIL(WS-INDEX)                
                                          TO RS-PAST-DUE-NONUTL         
                                             RS-TOTAL-NONUTL            
                 MOVE WS-ACCT-CASHONLY-FLAG(WS-INDEX)                   
                                          TO RS-CASH-ONLY-FLAG          
                 MOVE 'C'                 TO RS-CUST-TYPE               
                 MOVE WS-ACCT-SRVC-ADDRESS     TO RS-ACCT-SRVC-ADDRESS  
                 PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT          
                 PERFORM 8100-SEND-RESULT      THRU 8100-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2007-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2008-SPOUSE-PAST-DUE.                                          *        
      ******************************************************************        
      *                                                                         
       2008-SPOUSE-PAST-DUE.                                            
                                                                        
            PERFORM 7150-SEL-WO-CUTOFF-DT   THRU 7150-EXIT.             
            PERFORM 7130-SEL-PASTDUE-LMT    THRU 7130-EXIT.             
            PERFORM 7160-CALC-CUTOFF-DATE   THRU 7160-EXIT.             
                                                                        
            PERFORM 2009-WRITEOFF-SPOUSE    THRU 2009-EXIT              
                                  VARYING WS-INDEX-SP FROM 1 BY 1       
                                UNTIL WS-INDEX-SP > WS-SP-ARRAY-CNT.    
                                                                        
       2008-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2009-WRITEOFF-SPOUSE.                                          *        
      ******************************************************************        
      *                                                                         
       2009-WRITEOFF-SPOUSE.                                            
      *                                                                         
           IF WS-SP-CODE-ACCT-STAT(WS-INDEX-SP) = 'S' THEN              
                                                                        
              MOVE WS-SP-ACCOUNT-NO(WS-INDEX-SP)                        
                                            TO WS-CUTOFF-ACCT           
              PERFORM 7170-SEL-WRITE-OFF-DT THRU 7170-EXIT              
              MOVE WS-WRITE-OFF-DT          TO                          
                                 WS-SP-WRITE-OFF-DATE(WS-INDEX-SP)      
      *       PERFORM 7250-SEL-TOTAL-AR-BAL THRU 7250-EXIT                      
              PERFORM 2034-WRITEOFF-SPOUSE-VALIDATE THRU 2034-EXIT      
                                                                        
           END-IF.                                                      
      *                                                                         
       2009-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2010-FINAL-BILLED-ACCT.                                        *        
      ******************************************************************        
      *                                                                         
       2010-FINAL-BILLED-ACCT.                                          
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'B' AND                
              WS-ACCT-TOTAL-AR-BAL(WS-INDEX) > 0  AND                   
              WS-ACCT-BANKRUPTCY-IND(WS-INDEX) NOT = 'B' THEN           
                                                                        
              MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX)                         
                                            TO AT-ACCOUNT-NO            
              PERFORM 7130-SEL-PASTDUE-LMT  THRU 7130-EXIT              
              MOVE WS-PAST-DUE-DELINQ-LIMIT TO WS-UTIL-BAL-DELINQ-LIMIT 
                                                                        
      * Final billed with Non-Payment ("C") - DNPFB Scenario                    
      * Move FULL BAL UTL to PAST DUE UTIL, customer needs to pay full          
              IF WS-ACCT-CODE-STAT-REASON(WS-INDEX) = 'C' THEN          
                 MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX) TO AT-ACCOUNT-NO     
                                                                        
                 PERFORM 9500-CALL-CPD00068 THRU 9500-EXIT              
                                                                        
                 MOVE WS-AMT-FULL-BAL-UTL    TO                         
                                         WS-ACCT-UTIL-BAL(WS-INDEX)     
                                         WS-ACCT-PAST-DUE-UTIL(WS-INDEX)
                 MOVE WS-AMT-FULL-BAL-NONUTL TO                         
                                      WS-ACCT-NONUTIL-BAL(WS-INDEX)     
                                      WS-ACCT-PAST-DUE-NONUTIL(WS-INDEX)
                                                                        
                 IF WS-ACCT-UTIL-BAL(WS-INDEX) > 0 AND                  
                    WS-ACCT-UTIL-BAL(WS-INDEX)> WS-UTIL-BAL-DELINQ-LIMIT
                                                                        
                    MOVE 'Y'                TO WS-ACCT-BAL-FB           
                                               WS-PAST-DUE-CHARGE       
                    MOVE 0                  TO RS-RETURN-CODE           
                    MOVE 'P'                TO RS-PROCESS-CD            
                    MOVE 'N'                TO RS-CRDT-CHCK-REQ         
                    MOVE 'N'                TO RS-CPTR-QUE-FLAG         
                    MOVE 'Y'                TO RS-PAST-DUE-FLAG         
                    PERFORM 2201-GETS-ACCT-SRV-ADDRESS   THRU 2201-EXIT 
                    MOVE 0                  TO RS-DEPOSIT-AMT           
                    MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX)                   
                                            TO RS-ACCOUNT-NO            
                    MOVE WS-ACCT-PREMISE-NO(WS-INDEX)                   
                                            TO RS-PREMISE-NO            
                    MOVE WS-ACCT-CODE-ACCT-STAT(WS-INDEX)               
                                            TO RS-CODE-ACCT-STAT        
                    MOVE WS-ACCT-PAST-DUE-UTIL(WS-INDEX)                
                                            TO RS-PAST-DUE-UTL          
                    MOVE WS-ACCT-PAST-DUE-NONUTIL(WS-INDEX)             
                                            TO RS-PAST-DUE-NONUTL       
                    MOVE WS-ACCT-UTIL-BAL(WS-INDEX)                     
                                            TO RS-TOTAL-UTL             
                    MOVE WS-ACCT-NONUTIL-BAL(WS-INDEX)                  
                                            TO RS-TOTAL-NONUTL          
                    MOVE WS-ACCT-CASHONLY-FLAG(WS-INDEX)                
                                            TO RS-CASH-ONLY-FLAG        
                    MOVE 'C'                TO RS-CUST-TYPE             
                    MOVE WS-ACCT-SRVC-ADDRESS TO RS-ACCT-SRVC-ADDRESS   
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100-SEND-RESULT  THRU 8100-EXIT            
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX) TO AT-ACCOUNT-NO     
                                                                        
                 PERFORM 9500-CALL-CPD00068 THRU 9500-EXIT              
                                                                        
                 MOVE WS-AMT-FULL-BAL-UTL    TO                         
                                        WS-ACCT-AMT-UTIL-BAL(WS-INDEX)  
                 MOVE WS-AMT-FULL-BAL-NONUTL  TO                        
                                      WS-ACCT-AMT-NONUTIL-BAL(WS-INDEX) 
                 MOVE WS-AMT-PAST-DUE-UTL                               
                                    TO WS-ACCT-PAST-DUE-UTIL(WS-INDEX)  
                 MOVE WS-AMT-PAST-DUE-NONUTL                            
                                   TO WS-ACCT-PAST-DUE-NONUTIL(WS-INDEX)
      * For Normal Final Bill and past due bal > 0                              
                 IF WS-ACCT-PAST-DUE-UTIL(WS-INDEX) > 0 THEN            
                    MOVE 'Y'           TO WS-ACCT-BAL-FB                
                                          WS-PAST-DUE-CHARGE            
                    MOVE 0             TO RS-RETURN-CODE                
                    MOVE 'P'           TO RS-PROCESS-CD                 
                    MOVE 'N'           TO RS-CRDT-CHCK-REQ              
                    MOVE 'N'           TO RS-CPTR-QUE-FLAG              
                    MOVE 'Y'           TO RS-PAST-DUE-FLAG              
                    PERFORM 2201-GETS-ACCT-SRV-ADDRESS                  
                                          THRU 2201-EXIT                
                    MOVE 0             TO RS-DEPOSIT-AMT                
                    MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX)                   
                                       TO RS-ACCOUNT-NO                 
                    MOVE WS-ACCT-PREMISE-NO(WS-INDEX)                   
                                       TO RS-PREMISE-NO                 
                    MOVE WS-ACCT-CODE-ACCT-STAT(WS-INDEX)               
                                       TO RS-CODE-ACCT-STAT             
                    IF WS-ACCT-AMT-UTIL-BAL(WS-INDEX) > 0 THEN          
                       MOVE WS-ACCT-PAST-DUE-UTIL(WS-INDEX)             
                                       TO RS-PAST-DUE-UTL               
                       MOVE WS-ACCT-PAST-DUE-NONUTIL(WS-INDEX)          
                                       TO RS-PAST-DUE-NONUTL            
                       MOVE WS-ACCT-AMT-UTIL-BAL(WS-INDEX)              
                                       TO RS-TOTAL-UTL                  
                       MOVE WS-ACCT-AMT-NONUTIL-BAL(WS-INDEX)           
                                       TO RS-TOTAL-NONUTL               
                    ELSE                                                
                       MOVE WS-ACCT-PAST-DUE-UTIL(WS-INDEX)             
                                       TO RS-PAST-DUE-UTL               
                                          RS-TOTAL-UTL                  
                       MOVE WS-ACCT-PAST-DUE-NONUTIL(WS-INDEX)          
                                       TO RS-PAST-DUE-NONUTL            
                                          RS-TOTAL-NONUTL               
                    END-IF                                              
                    MOVE WS-ACCT-CASHONLY-FLAG(WS-INDEX)                
                                       TO RS-CASH-ONLY-FLAG             
                    MOVE 'C'           TO RS-CUST-TYPE                  
                    MOVE WS-ACCT-SRVC-ADDRESS TO RS-ACCT-SRVC-ADDRESS   
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100-SEND-RESULT  THRU 8100-EXIT            
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2010-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2011-CHK-WRITEOFF.                                            *         
      ******************************************************************        
      *                                                                         
       2011-CHK-WRITEOFF.                                               
      *                                                                         
              PERFORM 7150-SEL-WO-CUTOFF-DT  THRU 7150-EXIT.            
              PERFORM 7130-SEL-PASTDUE-LMT   THRU 7130-EXIT.            
              PERFORM 7160-CALC-CUTOFF-DATE  THRU 7160-EXIT.            
              PERFORM 2012-WRITEOFF-DATE     THRU 2012-EXIT             
                                     VARYING WS-INDEX FROM 1 BY 1       
                                     UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT.
              PERFORM 2013-CHK-VALID-WRITE-OFF THRU 2013-EXIT           
                                     VARYING WS-INDEX FROM 1 BY 1       
                                     UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT.
              PERFORM 2014-WRITE-OFF-YRS-CNT     THRU 2014-EXIT.        
      *                                                                         
       2011-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * 2012-WRITEOFF-DATE.                                            *        
      ******************************************************************        
      *                                                                         
       2012-WRITEOFF-DATE.                                              
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'S'                    
              MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX) TO WS-CUTOFF-ACCT       
              PERFORM 7170-SEL-WRITE-OFF-DT     THRU 7170-EXIT          
              MOVE WS-WRITE-OFF-DT              TO                      
                                      WS-ACCT-WRITE-OFF-DATE(WS-INDEX)  
           END-IF.                                                      
      *                                                                         
       2012-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2013-CHK-VALID-WRITE-OFF                                       *        
      ******************************************************************        
      *                                                                         
       2013-CHK-VALID-WRITE-OFF.                                        
      *                                                                         
           IF WS-COMPANY-NO = '26' THEN                                 
              IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'S' AND             
                 WS-ACCT-BANKRUPTCY-IND(WS-INDEX) NOT = 'B' THEN        
                 MOVE 'Y'                   TO WS-CNT-FLAG              
                 ADD 1                      TO WS-WRITE-OFF-CNT         
                 IF WS-ACCT-WRITE-OFF-DATE(WS-INDEX) > WS-CUT-OFF-DATE  
                    ADD 1                   TO WS-WO-DT-GRT-CUTOFF-DATE 
                 ELSE                                                   
                   IF WS-ACCT-WRITE-OFF-DATE(WS-INDEX) < WS-CUT-OFF-DATE
                      ADD 1                 TO WS-WO-DT-LESS-CUTOFF-DATE
                   ELSE                                                 
                      ADD 1                 TO WS-WO-DT-EQL-CUTOFF-DATE 
                   END-IF                                               
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-COMPANY-NO = '01' THEN                                 
              IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'S' THEN            
                 MOVE 'Y'                    TO WS-CNTT-FLAG            
                 ADD 1                       TO WS-WRITE-OFF-CNTT       
                 IF WS-ACCT-WRITE-OFF-DATE(WS-INDEX) > WS-CUT-OFF-DATE  
                    ADD 1                    TO WS-WO-DT-GRT-CUTOFF-DT  
                 ELSE                                                   
                   IF WS-ACCT-WRITE-OFF-DATE(WS-INDEX) < WS-CUT-OFF-DATE
                      ADD 1                 TO WS-WO-DT-LESS-CUTOFF-DT  
                   ELSE                                                 
                      ADD 1                 TO WS-WO-DT-EQL-CUTOFF-DT   
                   END-IF                                               
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2013-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2014-WRITE-OFF-YRS-CNT                                         *        
      ******************************************************************        
      *                                                                         
       2014-WRITE-OFF-YRS-CNT.                                          
      *                                                                         
            IF WS-CNT-FLAG = 'Y' THEN                                   
              IF WS-WRITE-OFF-CNT = WS-WO-DT-GRT-CUTOFF-DATE THEN       
                 MOVE 'G'                     TO WS-WRITEOFF-YRS-CNT    
              ELSE                                                      
               IF WS-WRITE-OFF-CNT = WS-WO-DT-LESS-CUTOFF-DATE THEN     
                   MOVE 'L'                 TO WS-WRITEOFF-YRS-CNT      
               ELSE                                                     
                  IF WS-WO-DT-GRT-CUTOFF-DATE > ZERO AND                
                     WS-WO-DT-LESS-CUTOFF-DATE > ZERO THEN              
                     MOVE 'J'                 TO WS-WRITEOFF-YRS-CNT    
                  END-IF                                                
                  IF WS-WO-DT-EQL-CUTOFF-DATE > 0 THEN                  
                       MOVE 'J'             TO WS-WRITEOFF-YRS-CNT      
                  END-IF                                                
               END-IF                                                   
              END-IF                                                    
            END-IF.                                                     
                                                                        
            IF WS-CNTT-FLAG = 'Y' THEN                                  
             IF WS-WRITE-OFF-CNTT = WS-WO-DT-GRT-CUTOFF-DT THEN         
               MOVE 'F'                     TO WS-WRITEOFF-YRS-CNTT     
             ELSE                                                       
               IF WS-WRITE-OFF-CNTT = WS-WO-DT-LESS-CUTOFF-DT THEN      
                   MOVE 'M'                 TO WS-WRITEOFF-YRS-CNTT     
               ELSE                                                     
                   IF WS-WO-DT-GRT-CUTOFF-DT  > ZERO AND                
                      WS-WO-DT-LESS-CUTOFF-DT > ZERO THEN               
                       MOVE 'J'             TO WS-WRITEOFF-YRS-CNTT     
                   ELSE                                                 
                      IF WS-WO-DT-GRT-CUTOFF-DT  > 0 THEN               
                         MOVE 'F'           TO WS-WRITEOFF-YRS-CNTT     
                      ELSE                                              
                         IF WS-WO-DT-LESS-CUTOFF-DT > 0 THEN            
                            MOVE 'M'        TO WS-WRITEOFF-YRS-CNTT     
                         END-IF                                         
                      END-IF                                            
                   END-IF                                               
                   IF WS-WO-DT-EQL-CUTOFF-DT > 0 THEN                   
                       MOVE 'J'             TO WS-WRITEOFF-YRS-CNTT     
                   END-IF                                               
               END-IF                                                   
             END-IF                                                     
            END-IF.                                                     
      *                                                                         
       2014-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2015-WRITEOFF-ACCT.                                            *        
      ******************************************************************        
      *                                                                         
       2015-WRITEOFF-ACCT.                                              
      *                                                                         
            IF WS-CNTT-FLAG = 'Y' THEN                                  
            IF WS-COMPANY-NO = '01' AND WS-WRITEOFF-YRS-CNTT = 'F' THEN 
               MOVE 'Y'                     TO WS-VALID-WRITE-OFF       
               PERFORM 2016-WRITEOFF-ACCT-VALIDATE THRU 2016-EXIT       
                                    VARYING CTR-SUB-WO FROM 1 BY 1      
                                    UNTIL CTR-SUB-WO > WS-ACCT-ARRAY-CNT
            ELSE                                                        
               IF WS-COMPANY-NO = '01' AND                              
                                        WS-WRITEOFF-YRS-CNTT = 'M' THEN 
                  IF WS-VALID-WRITE-OFF = 'Y' AND                       
                     WS-PAST-DUE-CHARGE NOT = 'Y' THEN                  
                     PERFORM 2017-WRITEOFF-COMP    THRU 2017-EXIT       
                  END-IF                                                
                  PERFORM 2018-WRITEOFF-COMPUTE THRU 2018-EXIT          
               ELSE                                                     
                  IF WS-COMPANY-NO = '01' AND                           
                                       WS-WRITEOFF-YRS-CNTT = 'J' THEN  
                     PERFORM 2118-WRITEOFF-GRT-LESS-YRS   THRU 2118-EXIT
                                  VARYING CTR-SUB-WO FROM 1 BY 1        
                                  UNTIL CTR-SUB-WO > WS-ACCT-ARRAY-CNT  
                  END-IF                                                
               END-IF                                                   
            END-IF                                                      
            END-IF.                                                     
            IF WS-CNT-FLAG = 'Y' THEN                                   
              IF WS-COMPANY-NO = '26' AND WS-WRITEOFF-YRS-CNT = 'G' THEN
                    MOVE 'Y'                TO WS-VALID-WRITE-OFF       
                    PERFORM 2019-WO-ACCT-LT-THREEYRS THRU 2019-EXIT     
                                 VARYING CTR-SUB-WO FROM 1 BY 1         
                                 UNTIL CTR-SUB-WO > WS-ACCT-ARRAY-CNT   
                                                                        
              ELSE                                                      
                 IF WS-COMPANY-NO = '26' AND                            
                                   WS-WRITEOFF-YRS-CNT = 'L' THEN       
                    MOVE 'O'                TO WS-VALID-WRITE-OFF       
                    PERFORM 2020-WO-ACCT-GT-THREEYRS THRU 2020-EXIT     
                                    VARYING CTR-SUB-WO FROM 1 BY 1      
                                    UNTIL CTR-SUB-WO > WS-ACCT-ARRAY-CNT
                 ELSE                                                   
                    IF WS-COMPANY-NO = '26' AND                         
                                    WS-WRITEOFF-YRS-CNT = 'J' THEN      
                       MOVE 'Y'             TO WS-VALID-WRITE-OFF       
                       PERFORM 2021-WO-ACCT-NE-THREEYRS THRU 2021-EXIT  
                                    VARYING CTR-SUB-WO FROM 1 BY 1      
                                    UNTIL CTR-SUB-WO > WS-ACCT-ARRAY-CNT
                      PERFORM 2022-WO-ACCT-NE-THREEYRS-WO THRU 2022-EXIT
                                    VARYING CTR-SUB-WO FROM 1 BY 1      
                                    UNTIL CTR-SUB-WO > WS-ACCT-ARRAY-CNT
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
            END-IF.                                                     
                                                                        
       2015-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2016-WRITEOFF-ACCT-VALIDATE                                    *        
      ******************************************************************        
      *                                                                         
       2016-WRITEOFF-ACCT-VALIDATE.                                     
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO) =  'S' AND             
              WS-ACCT-BANKRUPTCY-IND(CTR-SUB-WO) NOT = 'B' THEN         
                                                                        
              IF WS-ACCT-WRITE-OFF-DATE(CTR-SUB-WO) > WS-CUT-OFF-DATE   
                 MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO) TO AT-ACCOUNT-NO   
                                                                        
                 PERFORM 9500-CALL-CPD00068 THRU 9500-EXIT              
                                                                        
                 MOVE WS-AMT-FULL-BAL-UTL    TO                         
                                    WS-ACCT-AMT-UTIL-BAL(CTR-SUB-WO)    
                 MOVE WS-AMT-FULL-BAL-NONUTL  TO                        
                                    WS-ACCT-AMT-NONUTIL-BAL(CTR-SUB-WO) 
                 MOVE WS-AMT-PAST-DUE-UTL   TO                          
                                    WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)   
                 MOVE WS-AMT-PAST-DUE-NONUTL TO                         
                                    WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)
                                                                        
                 IF WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO) >                 
                            WS-PAST-DUE-DELINQ-LIMIT     OR             
                    WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO) >              
                            WS-PAST-DUE-DELINQ-LIMIT                    
                                                                        
                    MOVE 'Y'                TO WS-PAST-DUE-CHARGE       
                    PERFORM 2201-GETS-ACCT-SRV-ADDRESS   THRU 2201-EXIT 
                    MOVE 0                  TO RS-RETURN-CODE           
                    MOVE 'P'                TO RS-PROCESS-CD            
                    MOVE 'N'                TO RS-CRDT-CHCK-REQ         
                    MOVE 'N'                TO RS-CPTR-QUE-FLAG         
                    MOVE 'Y'                TO RS-PAST-DUE-FLAG         
                    MOVE 0                  TO RS-DEPOSIT-AMT           
                    MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                 
                                            TO RS-ACCOUNT-NO            
                    MOVE WS-ACCT-PREMISE-NO(CTR-SUB-WO)                 
                                            TO RS-PREMISE-NO            
                    MOVE WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO)             
                                            TO RS-CODE-ACCT-STAT        
                    MOVE WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)              
                                            TO RS-PAST-DUE-UTL          
                                               RS-TOTAL-UTL             
                    MOVE WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)           
                                            TO RS-PAST-DUE-NONUTL       
                                               RS-TOTAL-NONUTL          
                    MOVE WS-ACCT-CASHONLY-FLAG(CTR-SUB-WO)              
                                            TO RS-CASH-ONLY-FLAG        
                    MOVE 'C'                TO RS-CUST-TYPE             
                    MOVE WS-ACCT-SRVC-ADDRESS  TO RS-ACCT-SRVC-ADDRESS  
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100-SEND-RESULT  THRU 8100-EXIT            
                 ELSE                                                   
                    IF WS-VALID-WRITE-OFF = 'Y' AND                     
                       WS-PAST-DUE-CHARGE NOT = 'Y' THEN                
                       PERFORM 2017-WRITEOFF-COMP    THRU 2017-EXIT     
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2016-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      **************************************************************            
      * 2017-WRITEOFF-COMP.                                                     
      **************************************************************            
      *                                                                         
       2017-WRITEOFF-COMP.                                              
      *                                                                         
           MOVE WS-NEW-PREMISE-ACCT-NO  TO WS-ACCOUNT-NO.               
           PERFORM 7180-CALL-CSR02022   THRU 7180-EXIT.                 
                                                                        
      *Code-Value:'N'-Cust has Write Off                                        
           MOVE 'N'                     TO WS-COMM-CODE(WS-CNT)         
           ADD  +1                      TO WS-CNT                       
      *Code-Value:'G'-Maximum Deposit Charged                                   
           MOVE 'G'                     TO WS-COMM-CODE(WS-CNT)         
           ADD  +1                      TO WS-CNT                       
           MOVE 0                       TO RS-RETURN-CODE.              
           MOVE 'R'                     TO RS-PROCESS-CD.               
           MOVE 'N'                     TO RS-CRDT-CHCK-REQ.            
           MOVE 'N'                     TO RS-CPTR-QUE-FLAG.            
           MOVE 'N'                     TO RS-PAST-DUE-FLAG.            
           MOVE WS-MAX-DEPOSIT-AMT      TO RS-DEPOSIT-AMT               
                                           WS-DEPOSIT-AMT.              
           MOVE 0                       TO RS-ACCOUNT-NO.               
           MOVE 0                       TO RS-PREMISE-NO.               
           MOVE SPACES                  TO RS-CODE-ACCT-STAT.           
           MOVE 0                       TO RS-PAST-DUE-UTL.             
           MOVE 0                       TO RS-PAST-DUE-NONUTL.          
           MOVE 'C'                     TO RS-CUST-TYPE.                
           MOVE 0                       TO RS-TOTAL-UTL.                
           MOVE 0                       TO RS-TOTAL-NONUTL.             
           MOVE 'N'                     TO RS-CASH-ONLY-FLAG.           
           MOVE SPACES                  TO RS-ACCT-SRVC-ADDRESS.        
           PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT.                
           PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                 
      *                                                                         
       2017-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2018-WRITEOFF-COMPUTE.                                         *        
      ******************************************************************        
      *                                                                         
       2018-WRITEOFF-COMPUTE.                                           
      *                                                                         
           IF WS-VALID-WRITE-OFF = 'O' OR 'N' THEN                      
               MOVE 0                       TO RS-RETURN-CODE           
               MOVE 'Z'                     TO RS-PROCESS-CD            
               MOVE 'Y'                     TO RS-CRDT-CHCK-REQ         
               MOVE 'N'                     TO RS-CPTR-QUE-FLAG         
               MOVE 'N'                     TO RS-PAST-DUE-FLAG         
               MOVE 0                       TO RS-DEPOSIT-AMT           
               MOVE 0                       TO RS-ACCOUNT-NO            
               MOVE 0                       TO RS-PREMISE-NO            
               MOVE SPACES                  TO RS-CODE-ACCT-STAT        
               MOVE 0                       TO RS-PAST-DUE-UTL          
               MOVE 0                       TO RS-PAST-DUE-NONUTL       
               MOVE 'C'                     TO RS-CUST-TYPE             
               MOVE WS-CUST-SSN             TO RS-SSN                   
               MOVE 0                       TO RS-TOTAL-UTL             
               MOVE 0                       TO RS-TOTAL-NONUTL          
               MOVE 'N'                     TO RS-CASH-ONLY-FLAG        
               MOVE SPACES                  TO RS-ACCT-SRVC-ADDRESS     
               PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT             
               PERFORM 8100-SEND-RESULT     THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
       2018-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2019-WO-ACCT-LT-THREEYRS.                                      *        
      ******************************************************************        
      *                                                                         
       2019-WO-ACCT-LT-THREEYRS.                                        
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO) = 'S'                  
              MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO) TO AT-ACCOUNT-NO      
                                                                        
              PERFORM 9500-CALL-CPD00068    THRU 9500-EXIT              
                                                                        
              MOVE WS-AMT-FULL-BAL-UTL      TO                          
                                     WS-ACCT-AMT-UTIL-BAL(CTR-SUB-WO)   
              MOVE WS-AMT-FULL-BAL-NONUTL   TO                          
                                     WS-ACCT-AMT-NONUTIL-BAL(CTR-SUB-WO)
              MOVE WS-AMT-PAST-DUE-UTL      TO                          
                                     WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)  
              MOVE WS-AMT-PAST-DUE-NONUTL                               
                                 TO WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)
                                                                        
              IF WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO) >                    
                    WS-PAST-DUE-DELINQ-LIMIT     OR                     
                 WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO) >                 
                    WS-PAST-DUE-DELINQ-LIMIT                            
                 MOVE 'Y'                   TO WS-PAST-DUE-CHARGE       
                 PERFORM 2201-GETS-ACCT-SRV-ADDRESS   THRU 2201-EXIT    
                 MOVE 0                     TO RS-RETURN-CODE           
                 MOVE 'P'                   TO RS-PROCESS-CD            
                 MOVE 'N'                   TO RS-CRDT-CHCK-REQ         
                 MOVE 'N'                   TO RS-CPTR-QUE-FLAG         
                 MOVE 'Y'                   TO RS-PAST-DUE-FLAG         
                 MOVE 0                     TO RS-DEPOSIT-AMT           
                 MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                    
                                            TO RS-ACCOUNT-NO            
                 MOVE WS-ACCT-PREMISE-NO(CTR-SUB-WO)                    
                                            TO RS-PREMISE-NO            
                 MOVE WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO)                
                                            TO RS-CODE-ACCT-STAT        
                 MOVE WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)                 
                                            TO RS-PAST-DUE-UTL          
                                               RS-TOTAL-UTL             
                 MOVE WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)              
                                            TO RS-PAST-DUE-NONUTL       
                                               RS-TOTAL-NONUTL          
                 MOVE WS-ACCT-CASHONLY-FLAG(CTR-SUB-WO)                 
                                            TO RS-CASH-ONLY-FLAG        
                 MOVE 'C'                   TO RS-CUST-TYPE             
                 MOVE WS-ACCT-SRVC-ADDRESS  TO RS-ACCT-SRVC-ADDRESS     
                 PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
              ELSE                                                      
                 IF WS-VALID-WRITE-OFF = 'Y' AND                        
                    WS-PAST-DUE-CHARGE NOT = 'Y' THEN                   
                    PERFORM 2017-WRITEOFF-COMP    THRU 2017-EXIT        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2019-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2020-WO-ACCT-GT-THREEYRS.                                      *        
      ******************************************************************        
      *                                                                         
       2020-WO-ACCT-GT-THREEYRS.                                        
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO) = 'S'                  
              MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO) TO AT-ACCOUNT-NO      
                                                                        
              PERFORM 9500-CALL-CPD00068    THRU 9500-EXIT              
                                                                        
              MOVE WS-AMT-FULL-BAL-UTL      TO                          
                                     WS-ACCT-AMT-UTIL-BAL(CTR-SUB-WO)   
              MOVE WS-AMT-FULL-BAL-NONUTL   TO                          
                                     WS-ACCT-AMT-NONUTIL-BAL(CTR-SUB-WO)
              MOVE WS-AMT-PAST-DUE-UTL      TO                          
                                    WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)   
              MOVE WS-AMT-PAST-DUE-NONUTL   TO                          
                                    WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)
                                                                        
              IF WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO) >                    
                    WS-PAST-DUE-DELINQ-LIMIT     OR                     
                 WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO) >                 
                    WS-PAST-DUE-DELINQ-LIMIT                            
                 MOVE 'Y'                   TO WS-PAST-DUE-CHARGE       
                                               WS-SPCL-PSNC-PASTDUE     
                 PERFORM 2201-GETS-ACCT-SRV-ADDRESS   THRU 2201-EXIT    
                 MOVE 0                     TO RS-RETURN-CODE           
                 MOVE 'C'                   TO RS-PROCESS-CD            
                 MOVE 'N'                   TO RS-CRDT-CHCK-REQ         
                 MOVE 'Y'                   TO RS-CPTR-QUE-FLAG         
                 MOVE 'N'                   TO RS-PAST-DUE-FLAG         
                 MOVE 0                     TO RS-DEPOSIT-AMT           
                 MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                    
                                            TO RS-ACCOUNT-NO            
                 MOVE WS-ACCT-PREMISE-NO(CTR-SUB-WO)                    
                                            TO RS-PREMISE-NO            
                 MOVE WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO)                
                                            TO RS-CODE-ACCT-STAT        
                 MOVE WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)                 
                                            TO RS-PAST-DUE-UTL          
                                               RS-TOTAL-UTL             
                 MOVE WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)              
                                            TO RS-PAST-DUE-NONUTL       
                                               RS-TOTAL-NONUTL          
                 MOVE WS-ACCT-CASHONLY-FLAG(CTR-SUB-WO)                 
                                            TO RS-CASH-ONLY-FLAG        
                 MOVE 'C'                   TO RS-CUST-TYPE             
                 MOVE WS-ACCT-SRVC-ADDRESS  TO RS-ACCT-SRVC-ADDRESS     
                 PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
              ELSE                                                      
                 IF WS-VALID-WRITE-OFF = 'Y' AND                        
                    WS-PAST-DUE-CHARGE NOT = 'Y' THEN                   
                    PERFORM 2017-WRITEOFF-COMP    THRU 2017-EXIT        
                 END-IF                                                 
                 PERFORM 2018-WRITEOFF-COMPUTE THRU 2018-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2020-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2021-WO-ACCT-NE-THREEYRS.                                      *        
      ******************************************************************        
      *                                                                         
       2021-WO-ACCT-NE-THREEYRS.                                        
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO) = 'S' AND              
              WS-ACCT-WRITE-OFF-DATE(CTR-SUB-WO) < WS-CUT-OFF-DATE AND  
              WS-ACCT-BANKRUPTCY-IND(CTR-SUB-WO) NOT = 'B' THEN         
                                                                        
              MOVE 'O'                      TO WS-VALID-WRITE-OFF       
              MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                       
                                            TO AT-ACCOUNT-NO            
              PERFORM 9500-CALL-CPD00068    THRU 9500-EXIT              
                                                                        
                                                                        
              MOVE WS-AMT-FULL-BAL-UTL      TO                          
                                   WS-ACCT-AMT-UTIL-BAL(CTR-SUB-WO)     
              MOVE WS-AMT-FULL-BAL-NONUTL   TO                          
                                   WS-ACCT-AMT-NONUTIL-BAL(CTR-SUB-WO)  
              MOVE WS-AMT-PAST-DUE-UTL      TO                          
                                    WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)   
              MOVE WS-AMT-PAST-DUE-NONUTL   TO                          
                                    WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)
                                                                        
              IF WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO) >                    
                    WS-PAST-DUE-DELINQ-LIMIT                            
                                                                        
                 MOVE 'Y'                   TO WS-PAST-DUE-CHARGE       
                                               WS-SPCL-PSNC-PASTDUE     
                 PERFORM 2201-GETS-ACCT-SRV-ADDRESS   THRU 2201-EXIT    
                 MOVE 0                     TO RS-RETURN-CODE           
                 MOVE 'P'                   TO RS-PROCESS-CD            
                 MOVE 'N'                   TO RS-CRDT-CHCK-REQ         
                 MOVE 'N'                   TO RS-CPTR-QUE-FLAG         
                 MOVE 'Y'                   TO RS-PAST-DUE-FLAG         
                 MOVE 0                     TO RS-DEPOSIT-AMT           
                 MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                    
                                            TO RS-ACCOUNT-NO            
                 MOVE WS-ACCT-PREMISE-NO(CTR-SUB-WO)                    
                                            TO RS-PREMISE-NO            
                 MOVE WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO)                
                                            TO RS-CODE-ACCT-STAT        
                 MOVE WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)                 
                                            TO RS-PAST-DUE-UTL          
                                               RS-TOTAL-UTL             
                 MOVE WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)              
                                            TO RS-PAST-DUE-NONUTL       
                                               RS-TOTAL-NONUTL          
                 MOVE WS-ACCT-CASHONLY-FLAG(CTR-SUB-WO)                 
                                          TO RS-CASH-ONLY-FLAG          
                 MOVE 'C'                   TO RS-CUST-TYPE             
                 MOVE WS-ACCT-SRVC-ADDRESS  TO RS-ACCT-SRVC-ADDRESS     
                 PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
              END-IF                                                    
                                                                        
           END-IF.                                                      
      *                                                                         
       2021-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2022-WO-ACCT-NE-THREEYRS-WO.                                   *        
      ******************************************************************        
      *                                                                         
       2022-WO-ACCT-NE-THREEYRS-WO.                                     
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO) = 'S' AND              
              WS-ACCT-WRITE-OFF-DATE(CTR-SUB-WO)                        
                                       >= WS-CUT-OFF-DATE AND           
              WS-ACCT-BANKRUPTCY-IND(CTR-SUB-WO) NOT = 'B' THEN         
                                                                        
              MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                       
                                            TO AT-ACCOUNT-NO            
              PERFORM 9500-CALL-CPD00068    THRU 9500-EXIT              
                                                                        
                                                                        
              MOVE WS-AMT-FULL-BAL-UTL      TO                          
                                    WS-ACCT-AMT-UTIL-BAL(CTR-SUB-WO)    
              MOVE WS-AMT-FULL-BAL-NONUTL   TO                          
                                   WS-ACCT-AMT-NONUTIL-BAL(CTR-SUB-WO)  
              MOVE WS-AMT-PAST-DUE-UTL      TO                          
                                    WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)   
              MOVE WS-AMT-PAST-DUE-NONUTL   TO                          
                                    WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)
                                                                        
              IF WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO) >                    
                    WS-PAST-DUE-DELINQ-LIMIT                            
                                                                        
                 MOVE 'Y'                   TO WS-PAST-DUE-CHARGE       
                 PERFORM 2201-GETS-ACCT-SRV-ADDRESS   THRU 2201-EXIT    
                 MOVE 0                     TO RS-RETURN-CODE           
                 MOVE 'N'                   TO RS-CRDT-CHCK-REQ         
      * check the Logic Here for SPCL PSNC pastdue? ****                        
                 IF WS-SPCL-PSNC-PASTDUE = 'Y'                          
                    MOVE 'Y'                TO RS-CPTR-QUE-FLAG         
                    MOVE 'C'                TO RS-PROCESS-CD            
                 ELSE                                                   
                    MOVE 'N'                TO RS-CPTR-QUE-FLAG         
                    MOVE 'P'                TO RS-PROCESS-CD            
                 END-IF                                                 
                 MOVE 'Y'                   TO RS-PAST-DUE-FLAG         
                 MOVE 0                     TO RS-DEPOSIT-AMT           
                 MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                    
                                            TO RS-ACCOUNT-NO            
                 MOVE WS-ACCT-PREMISE-NO(CTR-SUB-WO)                    
                                            TO RS-PREMISE-NO            
                 MOVE WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO)                
                                            TO RS-CODE-ACCT-STAT        
                 MOVE WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)                 
                                            TO RS-PAST-DUE-UTL          
                                               RS-TOTAL-UTL             
                 MOVE WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)              
                                            TO RS-PAST-DUE-NONUTL       
                                               RS-TOTAL-NONUTL          
                 MOVE WS-ACCT-CASHONLY-FLAG(CTR-SUB-WO)                 
                                            TO RS-CASH-ONLY-FLAG        
                 MOVE 'C'                   TO RS-CUST-TYPE             
                 MOVE WS-ACCT-SRVC-ADDRESS  TO RS-ACCT-SRVC-ADDRESS     
                 PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
              END-IF                                                    
                                                                        
           END-IF.                                                      
      *                                                                         
       2022-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2023-BANKRUPT-ACCT.                                            *        
      ******************************************************************        
      *                                                                         
       2023-BANKRUPT-ACCT.                                              
      *                                                                         
           IF (WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'B'   OR              
               WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'S') AND              
               WS-ACCT-BANKRUPTCY-IND(WS-INDEX) = 'B' THEN              
                                                                        
               MOVE WS-NEW-PREMISE-ACCT-NO  TO WS-ACCOUNT-NO            
               PERFORM 7180-CALL-CSR02022   THRU 7180-EXIT              
                                                                        
      *    Code-Value:'E'- Bankrupt                                             
               MOVE 'E'                     TO WS-COMM-CODE(WS-CNT)     
               ADD  +1                      TO WS-CNT                   
      *    Code-Value:'G'- Maximum Deposit Charged                              
               MOVE 'G'                     TO WS-COMM-CODE(WS-CNT)     
               ADD  +1                      TO WS-CNT                   
               MOVE 0                       TO RS-RETURN-CODE           
               MOVE 'R'                     TO RS-PROCESS-CD            
               MOVE 'N'                     TO RS-CRDT-CHCK-REQ         
               MOVE 'N'                     TO RS-CPTR-QUE-FLAG         
               MOVE 'N'                     TO RS-PAST-DUE-FLAG         
               MOVE WS-MAX-DEPOSIT-AMT      TO RS-DEPOSIT-AMT           
                                               WS-DEPOSIT-AMT           
               MOVE 0                       TO RS-ACCOUNT-NO            
               MOVE 0                       TO RS-PREMISE-NO            
               MOVE SPACES                  TO RS-CODE-ACCT-STAT        
               MOVE 0                       TO RS-PAST-DUE-UTL          
               MOVE 0                       TO RS-PAST-DUE-NONUTL       
               MOVE 'C'                     TO RS-CUST-TYPE             
               MOVE 0                       TO RS-TOTAL-UTL             
               MOVE 0                       TO RS-TOTAL-NONUTL          
               MOVE 'N'                     TO RS-CASH-ONLY-FLAG        
               MOVE SPACES                  TO RS-ACCT-SRVC-ADDRESS     
               PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT             
               PERFORM 8100-SEND-RESULT     THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
       2023-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2024-MEDICAL-CERT.                                             *        
      ******************************************************************        
      *                                                                         
       2024-MEDICAL-CERT.                                               
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'A' AND                
              WS-ACCT-CODES-DATA-PRESENT(WS-INDEX) (24:1) = 'A'         
                                                                        
      *    Code-Value:'A'- Request Incomplete                                   
               MOVE 'A'                     TO WS-COMM-CODE(WS-CNT)     
               ADD  +1                      TO WS-CNT                   
      *    Code-Value:'J'- Cust has Medical Certificate                         
               MOVE 'J'                     TO WS-COMM-CODE(WS-CNT)     
               ADD  +1                      TO WS-CNT                   
               MOVE 0                       TO RS-RETURN-CODE           
               MOVE 'C'                     TO RS-PROCESS-CD            
               MOVE 'N'                     TO RS-CRDT-CHCK-REQ         
               MOVE 'Y'                     TO RS-CPTR-QUE-FLAG         
               MOVE 'N'                     TO RS-PAST-DUE-FLAG         
               MOVE 0                       TO RS-DEPOSIT-AMT           
               MOVE 0                       TO RS-ACCOUNT-NO            
               MOVE 0                       TO RS-PREMISE-NO            
               MOVE SPACES                  TO RS-CODE-ACCT-STAT        
               MOVE 0                       TO RS-PAST-DUE-UTL          
               MOVE 0                       TO RS-PAST-DUE-NONUTL       
               MOVE 'C'                     TO RS-CUST-TYPE             
               MOVE 0                       TO RS-TOTAL-UTL             
               MOVE 0                       TO RS-TOTAL-NONUTL          
               MOVE 'N'                     TO RS-CASH-ONLY-FLAG        
               MOVE SPACES                  TO RS-ACCT-SRVC-ADDRESS     
               PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT             
               PERFORM 8100-SEND-RESULT     THRU 8100-EXIT              
               MOVE 'Y'                     TO WS-EXIT-FLAG             
           END-IF.                                                      
      *                                                                         
       2024-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2025-DPP-FILTER.                                               *        
      ******************************************************************        
      *                                                                         
       2025-DPP-FILTER.                                                 
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'A' AND                
              WS-ACCT-CODES-DATA-PRESENT(WS-INDEX) (26:1) = 'A'         
                                                                        
      *    Code Value:'A'- Request Incomplete                                   
               MOVE 'A'                     TO WS-COMM-CODE(WS-CNT)     
               ADD  +1                      TO WS-CNT                   
      *    Code Value:'K'-Cust has DPP                                          
               MOVE 'K'                     TO WS-COMM-CODE(WS-CNT)     
               ADD  +1                      TO WS-CNT                   
               MOVE 0                       TO RS-RETURN-CODE           
               MOVE 'C'                     TO RS-PROCESS-CD            
               MOVE 'N'                     TO RS-CRDT-CHCK-REQ         
               MOVE 'Y'                     TO RS-CPTR-QUE-FLAG         
               MOVE 'N'                     TO RS-PAST-DUE-FLAG         
               MOVE 0                       TO RS-DEPOSIT-AMT           
               MOVE 0                       TO RS-ACCOUNT-NO            
               MOVE 0                       TO RS-PREMISE-NO            
               MOVE SPACES                  TO RS-CODE-ACCT-STAT        
               MOVE 0                       TO RS-PAST-DUE-UTL          
               MOVE 0                       TO RS-PAST-DUE-NONUTL       
               MOVE 'C'                     TO RS-CUST-TYPE             
               MOVE 0                       TO RS-TOTAL-UTL             
               MOVE 0                       TO RS-TOTAL-NONUTL          
               MOVE 'N'                     TO RS-CASH-ONLY-FLAG        
               MOVE SPACES                  TO RS-ACCT-SRVC-ADDRESS     
               PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT             
               PERFORM 8100-SEND-RESULT     THRU 8100-EXIT              
               MOVE 'Y'                     TO WS-EXIT-FLAG             
           END-IF.                                                      
      *                                                                         
       2025-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2026-ENDV-FILTER.                                              *        
      ******************************************************************        
      *                                                                         
       2026-ENDV-FILTER.                                                
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'A'                    
               MOVE 'N'                     TO WS-ENDV-FLAG             
               MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX)                        
                                            TO WS-ACCT-NO               
               PERFORM 7190-SEL-ENDV-FLAG   THRU 7190-EXIT              
                                                                        
               IF WS-ENDV-FLAG = 'Y'                                    
      *        Code-Value:'A'-Request Incomplete                                
                  MOVE 'A'                  TO WS-COMM-CODE(WS-CNT)     
                  ADD  +1                   TO WS-CNT                   
      *        Code-Value:'L'- Cust has RP Invest Order                         
                  MOVE 'L'                  TO WS-COMM-CODE(WS-CNT)     
                  ADD  +1                   TO WS-CNT                   
                  MOVE 0                    TO RS-RETURN-CODE           
                  MOVE 'C'                  TO RS-PROCESS-CD            
                  MOVE 'N'                  TO RS-CRDT-CHCK-REQ         
                  MOVE 'Y'                  TO RS-CPTR-QUE-FLAG         
                  MOVE 'N'                  TO RS-PAST-DUE-FLAG         
                  MOVE 0                    TO RS-DEPOSIT-AMT           
                  MOVE 0                    TO RS-ACCOUNT-NO            
                  MOVE 0                    TO RS-PREMISE-NO            
                  MOVE SPACES               TO RS-CODE-ACCT-STAT        
                  MOVE 0                    TO RS-PAST-DUE-UTL          
                  MOVE 0                    TO RS-PAST-DUE-NONUTL       
                  MOVE 'C'                  TO RS-CUST-TYPE             
                  MOVE 0                    TO RS-TOTAL-UTL             
                  MOVE 0                    TO RS-TOTAL-NONUTL          
                  MOVE 'N'                  TO RS-CASH-ONLY-FLAG        
                  MOVE SPACES               TO RS-ACCT-SRVC-ADDRESS     
                  PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT             
                  PERFORM 8100-SEND-RESULT  THRU 8100-EXIT              
                  MOVE 'Y'                  TO WS-EXIT-FLAG             
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2026-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2027-RECONNECT-FILTER.                                         *        
      ******************************************************************        
      *                                                                         
       2027-RECONNECT-FILTER.                                           
      *                                                                         
           MOVE 'N'                         TO WS-RECONNECT-FLAG.       
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'A'                    
                                                                        
               MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX)                        
                                            TO WS-ACCT-NO               
               PERFORM 7200-SEL-RECONNECT-FLAG                          
                                            THRU 7200-EXIT              
               IF WS-RECONNECT-FLAG = 'Y'                               
      *        Code-Value:'A'-Request Incomplete                                
                  MOVE 'A'                  TO WS-COMM-CODE(WS-CNT)     
                  ADD  +1                   TO WS-CNT                   
      *        Code-Value:'M'-Cust OFF for DNP                                  
                  MOVE 'M'                  TO WS-COMM-CODE(WS-CNT)     
                  ADD  +1                   TO WS-CNT                   
                  MOVE 0                    TO RS-RETURN-CODE           
                  MOVE 'C'                  TO RS-PROCESS-CD            
                  MOVE 'N'                  TO RS-CRDT-CHCK-REQ         
                  MOVE 'Y'                  TO RS-CPTR-QUE-FLAG         
                  MOVE 'N'                  TO RS-PAST-DUE-FLAG         
                  MOVE 0                    TO RS-DEPOSIT-AMT           
                  MOVE 0                    TO RS-ACCOUNT-NO            
                  MOVE 0                    TO RS-PREMISE-NO            
                  MOVE SPACES               TO RS-CODE-ACCT-STAT        
                  MOVE 0                    TO RS-PAST-DUE-UTL          
                  MOVE 0                    TO RS-PAST-DUE-NONUTL       
                  MOVE 'C'                  TO RS-CUST-TYPE             
                  MOVE 0                    TO RS-TOTAL-UTL             
                  MOVE 0                    TO RS-TOTAL-NONUTL          
                  MOVE 'N'                  TO RS-CASH-ONLY-FLAG        
                  MOVE SPACES               TO RS-ACCT-SRVC-ADDRESS     
                  PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT             
                  PERFORM 8100-SEND-RESULT  THRU 8100-EXIT              
                  MOVE 'Y'                  TO WS-EXIT-FLAG             
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2027-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2028-DNP-FB-FILTER                                                      
      ******************************************************************        
      *                                                                         
       2028-DNP-FB-FILTER.                                              
      *                                                                         
           MOVE 'N'                         TO WS-DNP-FB-FLAG.          
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'A'                    
              MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX) TO WS-ACCT-NO           
              PERFORM 7270-SEL-DNP-FB-FLAG     THRU 7270-EXIT           
                                                                        
              IF WS-DNP-FB-FLAG = 'Y' THEN                              
      *       Code Value:'A'-Request Incomplete                                 
                 MOVE 'A'                  TO WS-COMM-CODE(WS-CNT)      
                 ADD  +1                   TO WS-CNT                    
      *       Code Value:'M'-Cust OFF for DNP                                   
                 MOVE 'M'                  TO WS-COMM-CODE(WS-CNT)      
                 ADD  +1                   TO WS-CNT                    
                 MOVE 0                    TO RS-RETURN-CODE            
                 MOVE 'C'                  TO RS-PROCESS-CD             
                 MOVE 'N'                  TO RS-CRDT-CHCK-REQ          
                 MOVE 'Y'                  TO RS-CPTR-QUE-FLAG          
                 MOVE 'N'                  TO RS-PAST-DUE-FLAG          
                 MOVE 0                    TO RS-DEPOSIT-AMT            
                 MOVE 0                    TO RS-ACCOUNT-NO             
                 MOVE 0                    TO RS-PREMISE-NO             
                 MOVE SPACES               TO RS-CODE-ACCT-STAT         
                 MOVE 0                    TO RS-PAST-DUE-UTL           
                 MOVE 0                    TO RS-PAST-DUE-NONUTL        
                 MOVE 'C'                  TO RS-CUST-TYPE              
                 MOVE 0                    TO RS-TOTAL-UTL              
                 MOVE 0                    TO RS-TOTAL-NONUTL           
                 MOVE 'N'                  TO RS-CASH-ONLY-FLAG         
                 MOVE SPACES               TO RS-ACCT-SRVC-ADDRESS      
                 PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
                 PERFORM 8100-SEND-RESULT  THRU 8100-EXIT               
                 MOVE 'Y'                  TO WS-EXIT-FLAG              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2028-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2029-WO-ACCT-GT-THREEYRS.                                      *        
      ******************************************************************        
      *                                                                         
       2029-WO-ACCT-GT-THREEYRS.                                        
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO) = 'S'                  
              MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                       
                                            TO AT-ACCOUNT-NO            
              PERFORM 9500-CALL-CPD00068    THRU 9500-EXIT              
                                                                        
              MOVE WS-AMT-FULL-BAL-UTL      TO                          
                                        WS-ACCT-AMT-UTIL-BAL(WS-INDEX)  
              MOVE WS-AMT-FULL-BAL-NONUTL   TO                          
                                       WS-ACCT-AMT-NONUTIL-BAL(WS-INDEX)
              MOVE WS-AMT-PAST-DUE-UTL      TO                          
                                       WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)
              MOVE WS-AMT-PAST-DUE-NONUTL   TO                          
                                    WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)
                                                                        
              IF WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO) >                    
                    WS-PAST-DUE-DELINQ-LIMIT     OR                     
                 WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO) >                 
                    WS-PAST-DUE-DELINQ-LIMIT                            
                                                                        
                 MOVE 'Y'                   TO WS-PAST-DUE-CHARGE       
                                               WS-SPCL-PSNC-PASTDUE     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2029-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2030-CHK-VALID-OFF-TYPE .                                      *        
      ******************************************************************        
      *                                                                         
       2030-CHK-VALID-OFF-TYPE.                                         
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'S' AND                
              WS-ACCT-WRITE-OFF-DATE(WS-INDEX) < WS-CUT-OFF-DATE AND    
              WS-ACCT-BANKRUPTCY-IND(WS-INDEX) NOT = 'B' THEN           
                                                                        
              MOVE 'O'                      TO WS-VALID-WRITE-OFF       
              MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                       
                                            TO AT-ACCOUNT-NO            
              PERFORM 9500-CALL-CPD00068    THRU 9500-EXIT              
                                                                        
                                                                        
              MOVE WS-AMT-FULL-BAL-UTL      TO                          
                                        WS-ACCT-AMT-UTIL-BAL(WS-INDEX)  
              MOVE WS-AMT-FULL-BAL-NONUTL   TO                          
                                       WS-ACCT-AMT-NONUTIL-BAL(WS-INDEX)
              MOVE WS-AMT-PAST-DUE-UTL      TO                          
                                    WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)   
              MOVE WS-AMT-PAST-DUE-NONUTL   TO                          
                                    WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)
                                                                        
              IF WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO) >                    
                    WS-PAST-DUE-DELINQ-LIMIT                            
                                                                        
                 MOVE 'Y'                   TO WS-PAST-DUE-CHARGE       
                                               WS-SPCL-PSNC-PASTDUE     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2030-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2031-PROCESS-XFER-ACCT.                                        *        
      ******************************************************************        
      *                                                                         
       2031-PROCESS-XFER-ACCT.                                          
      *                                                                         
           IF WS-XFER-ACCT-NO-COMP3 = AT-ACCOUNT-NO THEN                
              PERFORM 2001-PROCESS-ACCT-CURSOR THRU 2001-EXIT           
              MOVE 'Y'              TO WS-NO-MORE-DATA-ACCTCUR          
           ELSE                                                         
              PERFORM 7030-FETCH-ACCT-CURSOR   THRU 7030-EXIT           
           END-IF.                                                      
      *                                                                         
       2031-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2033-PROCESS-RES-DATA.                                         *        
      ******************************************************************        
      *                                                                         
       2033-PROCESS-RES-DATA.                                           
      *                                                                         
           INITIALIZE WS-AMT-PASTDUE.                                   
           MOVE WS-ACCT-NO                 TO WS-ACCOUNT-NO.            
           IF WS-AMT-UTIL > 0 THEN                                      
              ADD  WS-AMT-UTIL    TO  WS-AMT-PASTDUE                    
           END-IF.                                                      
           IF WS-AMT-NONUTIL > 0 THEN                                   
              ADD  WS-AMT-NONUTIL TO WS-AMT-PASTDUE                     
           END-IF.                                                      
           IF WS-AMT-PASTDUE >= 100 THEN                                
              MOVE WS-AMT-PASTDUE    TO WS-TOT-PASTDUE-EDT3             
              IF WS-COMM-COMMENT > SPACES THEN                          
                 STRING  WS-COMM-COMMENT, WS-SEPERATOR,                 
                         WS-ACCOUNT-NO, WS-HYPEN,                       
                         WS-TOT-PASTDUE-EDT3, WS-HYPEN,                 
                         WS-ACCT-SRVC-ADDRESS                           
                 DELIMITED BY WS-SPACE  INTO WS-COMM-COMMENT            
              ELSE                                                      
                 STRING  WS-ACCOUNT-NO, WS-HYPEN,                       
                         WS-TOT-PASTDUE-EDT3, WS-HYPEN,                 
                         WS-ACCT-SRVC-ADDRESS                           
                 DELIMITED BY WS-SPACE INTO WS-COMM-COMMENT             
              END-IF                                                    
           ELSE                                                         
              IF WS-AMT-PASTDUE >= 10 THEN                              
                 MOVE WS-AMT-PASTDUE    TO WS-TOT-PASTDUE-EDT2          
                 IF WS-COMM-COMMENT > SPACES THEN                       
                    STRING  WS-COMM-COMMENT, WS-SEPERATOR,              
                            WS-ACCOUNT-NO, WS-HYPEN,                    
                            WS-TOT-PASTDUE-EDT2, WS-HYPEN,              
                            WS-ACCT-SRVC-ADDRESS                        
                    DELIMITED BY WS-SPACE  INTO WS-COMM-COMMENT         
                 ELSE                                                   
                    STRING  WS-ACCOUNT-NO, WS-HYPEN,                    
                            WS-TOT-PASTDUE-EDT2, WS-HYPEN,              
                            WS-ACCT-SRVC-ADDRESS                        
                    DELIMITED BY WS-SPACE INTO WS-COMM-COMMENT          
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-AMT-PASTDUE    TO WS-TOT-PASTDUE-EDT1          
                 IF WS-COMM-COMMENT > SPACES THEN                       
                    STRING  WS-COMM-COMMENT, WS-SEPERATOR,              
                            WS-ACCOUNT-NO, WS-HYPEN,                    
                            WS-TOT-PASTDUE-EDT1, WS-HYPEN,              
                            WS-ACCT-SRVC-ADDRESS                        
                    DELIMITED BY WS-SPACE  INTO WS-COMM-COMMENT         
                 ELSE                                                   
                    STRING  WS-ACCOUNT-NO, WS-HYPEN,                    
                            WS-TOT-PASTDUE-EDT1, WS-HYPEN,              
                            WS-ACCT-SRVC-ADDRESS                        
                    DELIMITED BY WS-SPACE INTO WS-COMM-COMMENT          
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           INITIALIZE WS-COMM-LENGTH.                                   
                                                                        
           INSPECT WS-COMM-COMMENT TALLYING WS-COMM-LENGTH              
                    FOR CHARACTERS BEFORE INITIAL '  '.                 
                                                                        
           PERFORM 7220-FETCH-RES-CURSOR THRU 7220-EXIT.                
      *                                                                         
       2033-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2034-WRITEOFF-SPOUSE-VALIDATE                                  *        
      ******************************************************************        
      *                                                                         
       2034-WRITEOFF-SPOUSE-VALIDATE.                                   
      *                                                                         
           IF WS-SP-CODE-ACCT-STAT(WS-INDEX-SP) =      'S' AND          
              WS-SP-BANKRUPTCY-IND(WS-INDEX-SP) NOT = 'B' THEN          
                                                                        
              IF WS-SP-WRITE-OFF-DATE(WS-INDEX-SP) >= WS-CUT-OFF-DATE   
      *          AND  WS-TOTAL-AR-BAL > 0 THEN                                  
                     THEN                                               
                 MOVE WS-SP-ACCOUNT-NO(WS-INDEX-SP)                     
                                            TO AT-ACCOUNT-NO            
                 PERFORM 9500-CALL-CPD00068 THRU 9500-EXIT              
                                                                        
                 MOVE WS-AMT-FULL-BAL-UTL    TO                         
                             WS-SP-AMT-UTIL-BAL(WS-INDEX-SP)            
                 MOVE WS-AMT-FULL-BAL-NONUTL  TO                        
                             WS-SP-AMT-NONUTIL-BAL(WS-INDEX-SP)         
                 MOVE WS-AMT-PAST-DUE-UTL   TO                          
                             WS-SP-PAST-DUE-UTIL(WS-INDEX-SP)           
                 MOVE WS-AMT-PAST-DUE-NONUTL TO                         
                             WS-SP-PAST-DUE-NONUTIL(WS-INDEX-SP)        
                                                                        
                 IF WS-SP-PAST-DUE-UTIL(WS-INDEX-SP) >                  
                            WS-PAST-DUE-DELINQ-LIMIT     OR             
                    WS-SP-PAST-DUE-NONUTIL(WS-INDEX-SP) >               
                            WS-PAST-DUE-DELINQ-LIMIT                    
                                                                        
                    MOVE 'Y'                   TO WS-PAST-DUE-CHARGE    
                    PERFORM 2201-GETS-ACCT-SRV-ADDRESS   THRU 2201-EXIT 
                    MOVE 0                     TO RS-RETURN-CODE        
                    MOVE 'P'                   TO RS-PROCESS-CD         
                    MOVE 'N'                   TO RS-CRDT-CHCK-REQ      
                    MOVE 'N'                   TO RS-CPTR-QUE-FLAG      
                    MOVE 'Y'                   TO RS-PAST-DUE-FLAG      
                    MOVE 0                     TO RS-DEPOSIT-AMT        
                    MOVE WS-SP-ACCOUNT-NO(WS-INDEX-SP)                  
                                               TO RS-ACCOUNT-NO         
                    MOVE WS-SP-PREMISE-NO(WS-INDEX-SP)                  
                                               TO RS-PREMISE-NO         
                    MOVE WS-SP-CODE-ACCT-STAT(WS-INDEX-SP)              
                                               TO RS-CODE-ACCT-STAT     
                    MOVE WS-SP-PAST-DUE-UTIL(WS-INDEX-SP)               
                                               TO RS-PAST-DUE-UTL       
                                                  RS-TOTAL-UTL          
                    MOVE WS-SP-PAST-DUE-NONUTIL(WS-INDEX-SP)            
                                               TO RS-PAST-DUE-NONUTL    
                                                  RS-TOTAL-NONUTL       
                    MOVE WS-SP-CASHONLY-FLAG(WS-INDEX-SP)               
                                               TO RS-CASH-ONLY-FLAG     
                    MOVE 'S'                   TO RS-CUST-TYPE          
                    MOVE WS-ACCT-SRVC-ADDRESS  TO RS-ACCT-SRVC-ADDRESS  
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100-SEND-RESULT  THRU 8100-EXIT            
                 ELSE                                                   
                    IF WS-VALID-WRITE-OFF = 'Y' AND                     
                       WS-PAST-DUE-CHARGE NOT = 'Y' THEN                
                       PERFORM 2017-WRITEOFF-COMP    THRU 2017-EXIT     
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2034-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2037-FB-SPOUSE-ACCT                                           *         
      ******************************************************************        
      *                                                                         
       2037-FB-SPOUSE-ACCT.                                             
      *                                                                         
           IF WS-SP-CODE-ACCT-STAT(WS-INDEX-SP) = 'B' THEN              
                                                                        
              MOVE WS-SP-ACCOUNT-NO(WS-INDEX-SP)                        
                                            TO AT-ACCOUNT-NO            
              PERFORM 9500-CALL-CPD00068    THRU 9500-EXIT              
                                                                        
              MOVE WS-AMT-FULL-BAL-UTL      TO                          
                                   WS-SP-AMT-UTIL-BAL(WS-INDEX-SP)      
              MOVE WS-AMT-FULL-BAL-NONUTL   TO                          
                                   WS-SP-AMT-NONUTIL-BAL(WS-INDEX-SP)   
              MOVE WS-AMT-PAST-DUE-UTL      TO                          
                                   WS-SP-PAST-DUE-UTIL(WS-INDEX-SP)     
              MOVE WS-AMT-PAST-DUE-NONUTL   TO                          
                                   WS-SP-PAST-DUE-NONUTIL(WS-INDEX-SP)  
              IF WS-SP-PAST-DUE-UTIL(WS-INDEX-SP) >                     
                                      WS-PAST-DUE-DELINQ-LIMIT          
                 MOVE 'Y'                   TO WS-PAST-DUE-CHARGE       
                 PERFORM 2201-GETS-ACCT-SRV-ADDRESS   THRU 2201-EXIT    
                 MOVE 0                     TO RS-RETURN-CODE           
                 MOVE 'P'                   TO RS-PROCESS-CD            
                 MOVE 'N'                   TO RS-CRDT-CHCK-REQ         
                 MOVE 'N'                   TO RS-CPTR-QUE-FLAG         
                 MOVE 'Y'                   TO RS-PAST-DUE-FLAG         
                 MOVE 0                     TO RS-DEPOSIT-AMT           
                 MOVE WS-SP-ACCOUNT-NO(WS-INDEX-SP)                     
                                            TO RS-ACCOUNT-NO            
                 MOVE WS-SP-PREMISE-NO(WS-INDEX-SP)                     
                                            TO RS-PREMISE-NO            
                 MOVE WS-SP-CODE-ACCT-STAT(WS-INDEX-SP)                 
                                            TO RS-CODE-ACCT-STAT        
                 MOVE WS-SP-PAST-DUE-UTIL(WS-INDEX-SP)                  
                                            TO RS-PAST-DUE-UTL          
                                               RS-TOTAL-UTL             
                 MOVE WS-SP-PAST-DUE-NONUTIL(WS-INDEX-SP)               
                                            TO RS-PAST-DUE-NONUTL       
                                               RS-TOTAL-NONUTL          
                 MOVE WS-SP-CASHONLY-FLAG(WS-INDEX-SP)                  
                                            TO RS-CASH-ONLY-FLAG        
                 MOVE 'S'                   TO RS-CUST-TYPE             
                 MOVE WS-ACCT-SRVC-ADDRESS  TO RS-ACCT-SRVC-ADDRESS     
                 PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2037-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2118-WRITEOFF-GRT-LESS-YRS                                    *         
      ******************************************************************        
      *                                                                         
       2118-WRITEOFF-GRT-LESS-YRS.                                      
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO) =  'S' AND             
              WS-ACCT-BANKRUPTCY-IND(CTR-SUB-WO) NOT = 'B' THEN         
              MOVE 'Y'                     TO WS-VALID-WRITE-OFF        
              IF WS-ACCT-WRITE-OFF-DATE(CTR-SUB-WO)                     
                                     >= WS-CUT-OFF-DATE THEN            
                 MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                    
                                            TO AT-ACCOUNT-NO            
                 PERFORM 9500-CALL-CPD00068                             
                                            THRU 9500-EXIT              
                                                                        
                 MOVE WS-AMT-FULL-BAL-UTL    TO                         
                                    WS-ACCT-AMT-UTIL-BAL(CTR-SUB-WO)    
                 MOVE WS-AMT-FULL-BAL-NONUTL  TO                        
                                 WS-ACCT-AMT-NONUTIL-BAL(CTR-SUB-WO)    
                 MOVE WS-AMT-PAST-DUE-UTL   TO                          
                                 WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)      
                 MOVE WS-AMT-PAST-DUE-NONUTL TO                         
                                 WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)   
                                                                        
                 IF WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO) >                 
                            WS-PAST-DUE-DELINQ-LIMIT     OR             
                    WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO) >              
                            WS-PAST-DUE-DELINQ-LIMIT                    
                                                                        
                    MOVE 'Y'                TO WS-PAST-DUE-CHARGE       
                    PERFORM 2201-GETS-ACCT-SRV-ADDRESS   THRU 2201-EXIT 
                    MOVE 0                  TO RS-RETURN-CODE           
                    MOVE 'P'                TO RS-PROCESS-CD            
                    MOVE 'N'                TO RS-CRDT-CHCK-REQ         
                    MOVE 'N'                TO RS-CPTR-QUE-FLAG         
                    MOVE 'Y'                TO RS-PAST-DUE-FLAG         
                    MOVE 0                  TO RS-DEPOSIT-AMT           
                    MOVE WS-ACCT-ACCOUNT-NO(CTR-SUB-WO)                 
                                            TO RS-ACCOUNT-NO            
                    MOVE WS-ACCT-PREMISE-NO(CTR-SUB-WO)                 
                                            TO RS-PREMISE-NO            
                    MOVE WS-ACCT-CODE-ACCT-STAT(CTR-SUB-WO)             
                                            TO RS-CODE-ACCT-STAT        
                    MOVE WS-ACCT-PAST-DUE-UTIL(CTR-SUB-WO)              
                                            TO RS-PAST-DUE-UTL          
                                               RS-TOTAL-UTL             
                    MOVE WS-ACCT-PAST-DUE-NONUTIL(CTR-SUB-WO)           
                                            TO RS-PAST-DUE-NONUTL       
                                               RS-TOTAL-NONUTL          
                    MOVE WS-ACCT-CASHONLY-FLAG(CTR-SUB-WO)              
                                            TO RS-CASH-ONLY-FLAG        
                    MOVE 'C'                TO RS-CUST-TYPE             
                    MOVE WS-ACCT-SRVC-ADDRESS  TO RS-ACCT-SRVC-ADDRESS  
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100-SEND-RESULT  THRU 8100-EXIT            
                 ELSE                                                   
                    IF WS-VALID-WRITE-OFF = 'Y' AND                     
                       WS-PAST-DUE-CHARGE NOT = 'Y' THEN                
                       PERFORM 2017-WRITEOFF-COMP    THRU 2017-EXIT     
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                  IF WS-VALID-WRITE-OFF = 'Y' AND                       
                     WS-PAST-DUE-CHARGE NOT = 'Y' THEN                  
                     PERFORM 2017-WRITEOFF-COMP    THRU 2017-EXIT       
                  END-IF                                                
                  PERFORM 2018-WRITEOFF-COMPUTE THRU 2018-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2118-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2201-GETS-ACCT-SRV-ADDRESS                                    *         
      ******************************************************************        
      *                                                                         
       2201-GETS-ACCT-SRV-ADDRESS.                                      
      *                                                                         
           MOVE SPACES                     TO WS-FULL-SRVC-ADDR.        
           MOVE SPACES                     TO WS-FULL-LOCATION.         
           MOVE SPACES                     TO WS-TEMP-ACCT-SRVC-ADDR.   
           MOVE SPACES                     TO WS-ACCT-SRVC-ADDRESS.     
                                                                        
           INITIALIZE WS-ACCT-SRVC-ADDRESS                              
                      WS-FULL-SRVC-ADDR                                 
                      WS-FULL-LOCATION                                  
                      WS-EMB-LENG                                       
                      WS-EMB-INPUT                                      
                      WS-TEMP-ACCT-SRVC-ADDR.                           
           PERFORM 7280-SEL-ACCT-SRVC-ADDR THRU 7280-EXIT.              
           IF WS-FULL-LOCATION > SPACES THEN                            
              MOVE 80                             TO WS-EMB-LENG        
              STRING WS-FULL-SRVC-ADDR, ', ', WS-FULL-LOCATION, '#'     
                     DELIMITED BY SIZE INTO WS-EMB-INPUT                
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT        
              MOVE WS-CMP-TABLE              TO WS-ACCT-SRVC-ADDRESS    
           ELSE                                                         
              MOVE 72                             TO WS-EMB-LENG        
              STRING WS-FULL-SRVC-ADDR, '#' DELIMITED BY SIZE INTO      
                                                     WS-EMB-INPUT       
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT        
              MOVE WS-CMP-TABLE              TO WS-ACCT-SRVC-ADDRESS    
           END-IF.                                                      
                                                                        
           INITIALIZE WS-ACCT-SRVC-LENGTH.                              
           INSPECT WS-ACCT-SRVC-ADDRESS TALLYING WS-ACCT-SRVC-LENGTH    
                      FOR CHARACTERS BEFORE INITIAL '#'.                
           INITIALIZE WS-TEMP-LENGTH.                                   
           COMPUTE WS-TEMP-LENGTH = WS-TOT-LENGTH - WS-ACCT-SRVC-LENGTH.
           MOVE SPACES TO                                               
               WS-ACCT-SRVC-ADDRESS(WS-ACCT-SRVC-LENGTH:WS-TEMP-LENGTH).
      *                                                                         
       2201-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2500-PROCESS-COMM-DETAILS.                                     *        
      *     -Process and Insert Communication Record.                  *        
      ******************************************************************        
      *                                                                         
       2500-PROCESS-COMM-DETAILS.                                       
      *                                                                         
           MOVE 'N'                        TO WS-EOF-CURSOR.            
           SET WS-IDX-C                    TO 1.                        
           PERFORM 7100-OPEN-CODE-VALUES   THRU 7100-EXIT.              
           PERFORM 7101-FETCH-CODE-VALUES  THRU 7101-EXIT.              
      *                                                                         
           PERFORM UNTIL NO-MORE-DATA                                   
              MOVE UV-CODE-VALUE-TEXT      TO WS-CODE-VALUE(WS-IDX-C)   
              MOVE UV-CODE-LONG-DESC-TEXT  TO                           
                                          WS-CODE-LONG-DESC(WS-IDX-C)   
              SET WS-IDX-C UP BY 1                                      
              PERFORM 7101-FETCH-CODE-VALUES                            
                                           THRU 7101-EXIT               
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7102-CLOSE-CODE-VALUES  THRU 7102-EXIT.              
      *                                                                         
           SET WS-IDX-C                    TO 1.                        
           SET WS-IDX-D                    TO 1.                        
DEF054     MOVE 1                          TO WS-I.                     
DEF054     SET WS-IDX-F                    TO 1.                        
           PERFORM WS-CNT TIMES                                         
              SEARCH WS-CODE-ARRAY                                      
                WHEN WS-COMM-CODE(WS-I) = WS-CODE-VALUE(WS-IDX-C)       
                     MOVE SPACES           TO WS-CODE-DESC-TEXT         
                     MOVE WS-CODE-LONG-DESC(WS-IDX-C)                   
                                           TO WS-CODE-DESC-TEXT         
                     PERFORM 5700-REFORMAT-COMM-TEXT                    
                                           THRU 5700-EXIT               
                     IF WS-COMM-CODE(WS-I) = 'G' OR 'H'                 
DEF054                  IF WS-IDX-F > 2                                 
                           SET WS-IDX-F DOWN BY 2                       
DEF054                  END-IF                                          
                        IF WS-DEPOSIT-AMT >= 100 THEN                   
                         MOVE WS-DEPOSIT-AMT      TO WS-DEPOSIT-AMT-EDT1
                         MOVE WS-DEPOSIT-AMT-EDT1 TO WS-CODE-DESC-TEXT  
                        ELSE                                            
                         MOVE WS-DEPOSIT-AMT      TO WS-DEPOSIT-AMT-EDT 
                         MOVE WS-DEPOSIT-AMT-EDT  TO WS-CODE-DESC-TEXT  
                        END-IF                                          
                        PERFORM 5700-REFORMAT-COMM-TEXT                 
                                                 THRU 5700-EXIT         
                     END-IF                                             
                     IF WS-IDX-F > 250                                  
                        NEXT SENTENCE                                   
                     END-IF                                             
              END-SEARCH                                                
              ADD +1                       TO WS-I                      
              SET WS-IDX-C                 TO 1                         
           END-PERFORM.                                                 
      *                                                                         
           IF WS-PAST-DUE-CHARGE = 'Y'                                  
              PERFORM 7210-OPEN-RES-CURSOR  THRU 7210-EXIT              
              PERFORM 7220-FETCH-RES-CURSOR THRU 7220-EXIT              
              PERFORM 2033-PROCESS-RES-DATA THRU 2033-EXIT              
                                            UNTIL NO-MORE-DATA-RESCUR   
              PERFORM 7230-CLOSE-RES-CURSOR THRU 7230-EXIT              
              IF WS-COMM-COMMENT > SPACES THEN                          
                 STRING WS-FINAL-COMM-TEXT, WS-SEPERATOR,               
                        WS-COMM-COMMENT                                 
                 DELIMITED BY WS-SPACE INTO WS-FINAL-COMM-TEXT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
DEF054     IF WS-IDX-F > 2                                              
              SET WS-IDX-F DOWN BY 2                                    
              MOVE SPACE                      TO WS-FINAL-COMM(WS-IDX-F)
              SET WS-IDX-F UP BY   1                                    
              MOVE SPACE                      TO WS-FINAL-COMM(WS-IDX-F)
DEF054     END-IF                                                       
      *                                                                         
           MOVE WS-CUSTOMER-NO             TO KO-CUSTOMER-NO            
                                              CE-CUSTOMER-NO.           
                                                                        
           INITIALIZE WS-TEMP-CONTACT-NAME                              
                      WS-CONTACT-NAME                                   
                      WS-CMP-TABLE                                      
                      WS-EMB-INPUT.                                     
                                                                        
      * Populate Contact Name On Communication Record.                          
           PERFORM 7003-GET-CUST-DETAILS THRU 7003-EXIT.                
           MOVE 70                          TO WS-EMB-LENG              
           STRING DQ-LAST-NAME,                                         
                  ', ',                                                 
                  DQ-FIRST-NAME,                                        
                  ' ',                                                  
                  DQ-MIDDLE-NAME                                        
           DELIMITED BY SIZE INTO WS-EMB-INPUT.                         
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
           MOVE WS-CMP-TABLE               TO WS-TEMP-CONTACT-NAME.     
           MOVE WS-TEMP-CONTACT-NAME       TO WS-CONTACT-NAME.          
                                                                        
           MOVE 0                          TO KO-ACCOUNT-NO.            
           MOVE WS-PREMISE-NO              TO KO-PREMISE-NO.            
           MOVE WS-COMPANY-NO              TO KO-COMPANY-NO.            
           MOVE 'Z'                        TO KO-COMM-METHOD.           
           MOVE 'I'                        TO KO-COMM-DIRECTION.        
           MOVE '41'                       TO KO-COMM-TYPE-CD.          
PECS12     IF WS-XFER-FLAG = 'Y'                                        
PECS12        MOVE '11'                    TO KO-COMM-SUBTYPE-CODE      
PECS12     ELSE                                                         
              MOVE '10'                    TO KO-COMM-SUBTYPE-CODE
           END-IF.     
           MOVE 'WEBTRN1'                  TO KO-USER-ID-ORIG.          
           MOVE LENGTH OF WS-FINAL-COMM-TEXT                            
                                           TO KO-INITIAL-COMMENT-TX-LEN 
           MOVE WS-FINAL-COMM-TEXT         TO KO-INITIAL-COMMENT-TX-TEXT
           MOVE 'N'                        TO KO-RED-FLAG-IND.          
           MOVE SPACES                     TO KO-RED-FLAG-EXPIRE-DT.    
           MOVE -1                         TO WS-RED-FL-NULL-IND.       
           MOVE WS-CONTACT-NAME            TO KO-CONTACT-NAME.          
           MOVE SPACES                     TO KO-PROMOTION-ID.          
           MOVE 'N'                        TO KO-PSC-COMPLIANCE-IND.    
           MOVE 0                          TO KO-CALL-ORIGIN-ID.        
           MOVE SPACES                     TO KO-CALL-END-TIME.         
           MOVE -1                         TO WS-END-NULL-IND.          
           MOVE 0                          TO KO-NUMBER-TRANSFERS.      
           MOVE 0                          TO KO-HOLD-TIME.             
           MOVE 0                          TO KO-QUEUE-TIME.            
           MOVE 'N'                        TO KO-SCREEN-POP-IND.        
           MOVE 0                          TO KO-TOTAL-CALL-TIME.       
           MOVE SPACES                     TO KO-RESPONSE-REASON-CD.    
           MOVE SPACES                     TO KO-RESPONSE-TYPE-CD.      
           MOVE SPACES                     TO KO-SOLICITATION-CD.       
           MOVE 'C'                        TO KO-COMM-ASSOC-CD.         
           MOVE 'N'                        TO KO-COMPLAINT-FL.          
           MOVE SPACES                     TO KO-DISCOVERY-MTHD-CD.     
           MOVE SPACES                     TO KO-PREV-MARKETER-CD.      
      *                                                                         
           IF WS-FINAL-COMM-TEXT > SPACES THEN                          
              PERFORM 8200-INSERT-COMM-DATA   THRU 8200-EXIT            
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      **************************************************************            
      * 5200-CHECK-SERV-AT-NEW-PR.                                              
      *     -Retuns The Service Type At A Premise. (Elec/Gas/Combo)             
      **************************************************************            
      *                                                                         
       5200-CHECK-SERV-AT-NEW-PR.                                       
      *                                                                         
           MOVE WS-PREMISE-NO-NUM                  TO UT-PREMISE-NO.    
           MOVE 'N'                                TO WS-EOF-CURSOR.    
           PERFORM 7080-OPEN-SERVICE-TYPE-CUR      THRU 7080-EXIT.      
           PERFORM 7085-FETCH-SERVICE-TYPE-CUR     THRU 7085-EXIT.      
           PERFORM UNTIL NO-MORE-DATA                                   
               IF UT-CODE-UTIL-TYPE = 'E'                               
                  SET WS-ELEC-ONLY                 TO TRUE              
               END-IF                                                   
               IF UT-CODE-UTIL-TYPE = 'G'                               
                  SET WS-GAS-ONLY                  TO TRUE              
               END-IF                                                   
               PERFORM 7085-FETCH-SERVICE-TYPE-CUR THRU 7085-EXIT       
           END-PERFORM.                                                 
           IF WS-ELEC-ONLY AND  WS-GAS-ONLY                             
              SET WS-COMBO                         TO TRUE              
              MOVE SPACE                           TO WS-SERVICE-ELEC   
                                                      WS-SERVICE-GAS    
           END-IF.                                                      
           PERFORM 7090-CLOSE-SERVICE-TYPE-CUR     THRU 7090-EXIT.      
      *                                                                         
       5200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5700-REFORMAT-COMM-TEXT.                                       *        
      *     -Formats the Communication Text.                           *        
DEF054* REMOVED SETTING WS-IDX-F TO 1.                                 *        
      ******************************************************************        
      *                                                                         
       5700-REFORMAT-COMM-TEXT.                                         
      *                                                                         
           MOVE SPACES                           TO WS-PREV-CHAR        
                                                    WS-FORMAT.          
           SET WS-IDX-D                          TO 1.                  
      *                                                                         
           PERFORM UNTIL (WS-IDX-D > 80 OR FORMAT-DONE)                 
              IF (WS-CODE-DESC(WS-IDX-D) = SPACE OR LOW-VALUES          
                                           OR HIGH-VALUES)              
                AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES) 
                IF WS-IDX-D > 1                                         
                   SET WS-IDX-F DOWN BY 1                               
                   MOVE '/'                   TO WS-FINAL-COMM(WS-IDX-F)
                   SET WS-IDX-F UP BY 1                                 
                   MOVE '/'                   TO WS-FINAL-COMM(WS-IDX-F)
                   SET WS-IDX-F UP BY 1                                 
                END-IF                                                  
                MOVE 'Y'                      TO WS-FORMAT              
              ELSE                                                      
                MOVE WS-CODE-DESC(WS-IDX-D)   TO WS-FINAL-COMM(WS-IDX-F)
                                                 WS-PREV-CHAR           
                SET WS-IDX-D, WS-IDX-F UP BY 1                          
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       5700-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * OPEN CUST_CURSOR.                                              *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-CUST-CUR.                                              
      *                                                                         
           EXEC SQL                                                     
                OPEN CUST_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CUST_CURSOR'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE WS-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * FETCH CUST_CURSOR.                                             *        
      ******************************************************************        
      *                                                                         
       7001-FETCH-CUST-CUR.                                             
      *                                                                         
           EXEC SQL                                                     
                FETCH CUST_CURSOR                                       
                 INTO :CE-CUSTOMER-NO                                   
                     ,:CE-CUSTOMER-TYPE                                 
                     ,:CE-SSN                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET WS-CUST-EOC         TO TRUE                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '7001'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE 'CUST_CURSOR'      TO TABLE-1                  
                    MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1          
                    MOVE WS-CUSTOMER-NO-NUM TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       7001-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CLOSE CUST_CURSOR.                                             *        
      ******************************************************************        
      *                                                                         
       7002-CLOSE-CUST-CUR.                                             
      *                                                                         
           EXEC SQL                                                     
                CLOSE CUST_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7002'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CUST_CUSRSOR'           TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE WS-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7002-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * SELECTS CUTOMER DN NO.                                         *        
      ******************************************************************        
      *                                                                         
       7003-GET-CUST-DETAILS.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME                                     
                  INTO :DQ-FIRST-NAME,                                  
                       :DQ-MIDDLE-NAME,                                 
                       :DQ-LAST-NAME                                    
                  FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                 
                       CSS_NAME DQ WITH(READUNCOMMITTED),                       
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                 WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO               
                   AND CE.CUSTOMER_TYPE = 'C'                           
                   AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                
                   AND CE.NAME_ID       = HT.NAME_ID                    
                   AND HT.NAME_ID       = DQ.NAME_ID                    
                                                 
                                                                 
                                                            
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DQ.FIRST_NAME,                                           
MFA-TR*                DQ.MIDDLE_NAME,                                          
MFA-TR*                DQ.LAST_NAME                                             
MFA-TR*           INTO :DQ-FIRST-NAME,                                          
MFA-TR*                :DQ-MIDDLE-NAME,                                         
MFA-TR*                :DQ-LAST-NAME                                            
MFA-TR*           FROM CSS_CUST_STATS CE,                                       
MFA-TR*                CSS_NAME DQ,                                             
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*          WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                       
MFA-TR*            AND CE.CUSTOMER_TYPE = 'C'                                   
MFA-TR*            AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                        
MFA-TR*            AND CE.NAME_ID       = HT.NAME_ID                            
MFA-TR*            AND HT.NAME_ID       = DQ.NAME_ID                            
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7003                                                 
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7002'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
              MOVE 'CSS_NAME'                TO TABLE-2                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-3                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7003-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * SELECTS SPOUSE ACTIVE ACCOUNTS                                 *        
      ******************************************************************        
      *                                                                         
       7015-SELECT-SP-ACTIVE-ACCTS.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     COUNT(*)                                           
                INTO                                                    
                     :WS-SP-ACTV-CNT                                    
                FROM                                                    
                     CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE                                                    
                     CUSTOMER_NO     = :AT-CUSTOMER-NO                  
                 AND COMPANY_NO      = :WS-COMPANY-NO                   
                 AND ACCOUNT_TYPE_CODE <> 'N'                           
                 AND CODE_ACCT_STAT = 'A'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              COUNT(*)                                                   
MFA-TR*         INTO                                                            
MFA-TR*              :WS-SP-ACTV-CNT                                            
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ACCOUNT                                                
MFA-TR*        WHERE                                                            
MFA-TR*              CUSTOMER_NO     = :AT-CUSTOMER-NO                          
MFA-TR*          AND COMPANY_NO      = :WS-COMPANY-NO                           
MFA-TR*          AND ACCOUNT_TYPE_CODE <> 'N'                                   
MFA-TR*          AND CODE_ACCT_STAT = 'A'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              COMPUTE WS-ACTIVE-SP-CNT =                                
                                WS-ACTIVE-SP-CNT + WS-SP-ACTV-CNT       
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7015'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7015-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * OPENS ACCT_CURSOR CURSOR.                                      *        
      ******************************************************************        
      *                                                                         
       7020-OPEN-ACCT-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
                OPEN ACCT_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * FETCHES ACCT_CURSOR CURSOR.                                    *        
      ******************************************************************        
      *                                                                         
       7030-FETCH-ACCT-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
                FETCH ACCT_CURSOR                                       
                INTO  :AT-ACCOUNT-NO                                    
                     ,:AT-PREMISE-NO                                    
                     ,:AT-CODE-ACCT-STAT                                
                     ,:AT-TOTAL-AR-BALANCE                              
                     ,:AT-CODES-DATA-PRESENT                            
                     ,:AT-CODE-STATUS-REASON                            
                     ,:AT-BANKRUPTCY-IND                                
                     ,:AT-CREDIT-GROUP                                  
                     ,:AT-MST-SUB-ACCT-IND                              
                     ,:AT-CODE-MAJOR-ACCT                               
                     ,:AT-CT-METER-RATED-IND                            
                     ,:AT-COMPANY-NO                                    
                     ,:AT-LOCAL-OFFICE                                  
                     ,:AT-DATE-BILL-DAY-00                              
                     ,:AT-DATE-BILL-DAY-30                              
                     ,:AT-DATE-BILL-DAY-60                              
                     ,:AT-DATE-BILL-DAY-90                              
                     ,:AT-CODE-DISC-OK                                  
                     ,:AT-NOTICE-EXEMPT-CD                              
                     ,:AT-BILL-CYCLE                                    
                     ,:AT-IVR-EXEMPT-CD                                 
                     ,:CZ-CASH-ONLY-FL :WS-NULL-INDICATOR-5              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               IF WS-NULL-INDICATOR-5 < 0                               
                 MOVE SPACES                 TO CZ-CASH-ONLY-FL         
               END-IF                                                   
             WHEN NOT-FOUND                                             
               MOVE 'Y'                     TO WS-NO-MORE-DATA-ACCTCUR  
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7030'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2          
               MOVE AT-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               MOVE WS-COMPANY-NO           TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7030-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CLOSES ACCT_CURSOR CURSOR.                                     *        
      ******************************************************************        
      *                                                                         
       7040-CLOSE-ACCT-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE ACCT_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * OPENS SPOUSE_CURSOR CURSOR.                                    *        
      ******************************************************************        
      *                                                                         
       7050-OPEN-SPOUSE-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
                OPEN SPOUSE_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * FETCHES SPOUSE_CURSOR CURSOR.                                  *        
      ******************************************************************        
      *                                                                         
       7060-FETCH-SPOUSE-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                      SPOUSE_CURSOR                                     
                INTO  :AT-ACCOUNT-NO                                    
                     ,:AT-PREMISE-NO                                    
                     ,:AT-CODE-ACCT-STAT                                
                     ,:AT-TOTAL-AR-BALANCE                              
                     ,:AT-CODES-DATA-PRESENT                            
                     ,:AT-CODE-STATUS-REASON                            
                     ,:AT-BANKRUPTCY-IND                                
                     ,:AT-CREDIT-GROUP                                  
                     ,:AT-MST-SUB-ACCT-IND                              
                     ,:AT-CODE-MAJOR-ACCT                               
                     ,:AT-CT-METER-RATED-IND                            
                     ,:AT-COMPANY-NO                                    
                     ,:AT-LOCAL-OFFICE                                  
                     ,:AT-DATE-BILL-DAY-00                              
                     ,:AT-DATE-BILL-DAY-30                              
                     ,:AT-DATE-BILL-DAY-60                              
                     ,:AT-DATE-BILL-DAY-90                              
                     ,:AT-CODE-DISC-OK                                  
                     ,:AT-NOTICE-EXEMPT-CD                              
                     ,:AT-BILL-CYCLE                                    
                     ,:AT-IVR-EXEMPT-CD                                 
                     ,:CZ-CASH-ONLY-FL :WS-NULL-INDICATOR-5              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               IF WS-NULL-INDICATOR-5 < 0                               
                 MOVE SPACES                 TO CZ-CASH-ONLY-FL         
               END-IF                                                   
             WHEN NOT-FOUND                                             
               MOVE 'Y'                     TO WS-NO-MORE-DATA-SPCUR    
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7060'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2          
               MOVE AT-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               MOVE WS-COMPANY-NO           TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7060-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CLOSES SPOUSE_CURSOR CURSOR.                                   *        
      ******************************************************************        
      *                                                                         
       7070-CLOSE-SPOUSE-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
                CLOSE SPOUSE_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      **************************************************************            
      * 7080-OPEN-SERVICE-TYPE-CUR.                                             
      **************************************************************            
      *                                                                         
       7080-OPEN-SERVICE-TYPE-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
                OPEN SERVICE_TYPE_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7080'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-PREMISE-NO-NUM        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7080-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      **************************************************************            
      * 7085-FETCH-SERVICE-TYPE-CUR.                                            
      **************************************************************            
      *                                                                         
       7085-FETCH-SERVICE-TYPE-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                      SERVICE_TYPE_CUR                                  
                 INTO                                                   
                      :UT-CODE-UTIL-TYPE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               CONTINUE                                                 
             WHEN NOT-FOUND                                             
                  SET NO-MORE-DATA          TO TRUE                     
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7085'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSS_PREMISE'           TO TABLE-1                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-PREMISE-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7085-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      **************************************************************            
      * 7090-CLOSE-SERVICE-TYPE-CUR.                                            
      **************************************************************            
      *                                                                         
       7090-CLOSE-SERVICE-TYPE-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
                CLOSE SERVICE_TYPE_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7090'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-PREMISE-NO-NUM        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7090-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * OPENS CODE_CURSOR CURSOR.                                      *        
      ******************************************************************        
      *                                                                         
       7100-OPEN-CODE-VALUES.                                           
      *                                                                         
           EXEC SQL                                                     
                OPEN CODE_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'PROGRAM_ID'             TO TABLE-ELEMENT-1          
              MOVE 'CSR04030'               TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * FETCHES CODE_CURSOR CURSOR.                                    *        
      ******************************************************************        
      *                                                                         
       7101-FETCH-CODE-VALUES.                                          
      *                                                                         
           MOVE SPACES                      TO UV-CODE-VALUE-TEXT.      
           MOVE SPACES                      TO UV-CODE-LONG-DESC-TEXT.  
           EXEC SQL                                                     
                FETCH                                                   
                      CODE_CURSOR                                       
                INTO                                                    
                      :UV-CODE-VALUE                                    
                     ,:UV-CODE-LONG-DESC                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               CONTINUE                                                 
             WHEN NOT-FOUND                                             
               SET NO-MORE-DATA             TO TRUE                     
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7101'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSS_CODE_VALUE'        TO TABLE-1                  
               MOVE 'PROGRAM_ID'            TO TABLE-ELEMENT-1          
               MOVE 'CSR04030'              TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7101-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CLOSES CODE_CURSOR CURSOR.                                     *        
      ******************************************************************        
      *                                                                         
       7102-CLOSE-CODE-VALUES.                                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE CODE_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7102'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'PROGRAM_ID'             TO TABLE-ELEMENT-1          
              MOVE 'CSR04030'               TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7102-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * SELECTS ACCOUNT NO FOR NEW PREMISE NO.                         *        
      ******************************************************************        
      *                                                                         
       7110-SELECT-ACCT-NO.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) AT.ACCOUNT_NO                                   
                  INTO                                                  
                        :WS-NEW-PREMISE-ACCT-NO                         
                  FROM                                                  
                        CSS_ACCOUNT    AT WITH(READUNCOMMITTED)                 
                 WHERE                                                  
                        AT.PREMISE_NO  = :WS-PREMISE-NO-COMP3           
                 ORDER BY ACCT_CREATE_DT DESC                           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 AT.ACCOUNT_NO                                           
MFA-TR*           INTO                                                          
MFA-TR*                 :WS-NEW-PREMISE-ACCT-NO                                 
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_ACCOUNT    AT                                       
MFA-TR*          WHERE                                                          
MFA-TR*                 AT.PREMISE_NO  = :WS-PREMISE-NO-COMP3                   
MFA-TR*          ORDER BY ACCT_CREATE_DT DESC                                   
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7110'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_ACCOUNT'         TO TABLE-1                  
                 MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1          
                 MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * SELECTS ACCOUNT DETAILS.                                       *        
      ******************************************************************        
      *                                                                         
       7120-SEL-ACCT-DET.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT COMPANY_NO,                                      
                       TOTAL_AR_BALANCE,                                
                       CODE_COMPANY_ACCT,                               
                       CODE_ACCT_STAT,                                  
                       CODE_STATUS_REASON,                              
                       PREMISE_NO,                                      
                       CUSTOMER_NO,                                     
                       DATE_LAST_ACTION,                                
                       LOCAL_OFFICE,                                    
                       ACCOUNT_NO,                                      
                       CODES_DATA_PRESENT,                              
                       CREDIT_GROUP,                                    
                       TOTAL_AR_BALANCE,                                
                       NOTICE_EXEMPT_CD,                                
                       CODE_DISC_OK,                                    
                       DATE_BILL_DAY_00,                                
                       DATE_BILL_DAY_30,                                
                       DATE_BILL_DAY_60,                                
                       DATE_BILL_DAY_90,                                
                       BANKRUPTCY_IND,                                  
                       IVR_EXEMPT_CD                                    
                  INTO :AT-COMPANY-NO,                                  
                       :AT-TOTAL-AR-BALANCE,                            
                       :AT-CODE-COMPANY-ACCT,                           
                       :AT-CODE-ACCT-STAT,                              
                       :AT-CODE-STATUS-REASON,                          
                       :AT-PREMISE-NO,                                  
                       :AT-CUSTOMER-NO,                                 
                       :AT-DATE-LAST-ACTION,                            
                       :AT-LOCAL-OFFICE,                                
                       :AT-ACCOUNT-NO,                                  
                       :AT-CODES-DATA-PRESENT,                          
                       :AT-CREDIT-GROUP,                                
                       :AT-TOTAL-AR-BALANCE,                            
                       :AT-NOTICE-EXEMPT-CD,                            
                       :AT-CODE-DISC-OK,                                
                       :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,        
                       :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,        
                       :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,        
                       :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,        
                       :AT-BANKRUPTCY-IND,                              
                       :AT-IVR-EXEMPT-CD                                
                  FROM                                                  
                        CSS_ACCOUNT    AT                               
                 WHERE                                                  
                        ACCOUNT_NO  = :AT-ACCOUNT-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COMPANY_NO,                                              
MFA-TR*                TOTAL_AR_BALANCE,                                        
MFA-TR*                CODE_COMPANY_ACCT,                                       
MFA-TR*                CODE_ACCT_STAT,                                          
MFA-TR*                CODE_STATUS_REASON,                                      
MFA-TR*                PREMISE_NO,                                              
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                DATE_LAST_ACTION,                                        
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                CODES_DATA_PRESENT,                                      
MFA-TR*                CREDIT_GROUP,                                            
MFA-TR*                TOTAL_AR_BALANCE,                                        
MFA-TR*                NOTICE_EXEMPT_CD,                                        
MFA-TR*                CODE_DISC_OK,                                            
MFA-TR*                DATE_BILL_DAY_00,                                        
MFA-TR*                DATE_BILL_DAY_30,                                        
MFA-TR*                DATE_BILL_DAY_60,                                        
MFA-TR*                DATE_BILL_DAY_90,                                        
MFA-TR*                BANKRUPTCY_IND,                                          
MFA-TR*                IVR_EXEMPT_CD                                            
MFA-TR*           INTO :AT-COMPANY-NO,                                          
MFA-TR*                :AT-TOTAL-AR-BALANCE,                                    
MFA-TR*                :AT-CODE-COMPANY-ACCT,                                   
MFA-TR*                :AT-CODE-ACCT-STAT,                                      
MFA-TR*                :AT-CODE-STATUS-REASON,                                  
MFA-TR*                :AT-PREMISE-NO,                                          
MFA-TR*                :AT-CUSTOMER-NO,                                         
MFA-TR*                :AT-DATE-LAST-ACTION,                                    
MFA-TR*                :AT-LOCAL-OFFICE,                                        
MFA-TR*                :AT-ACCOUNT-NO,                                          
MFA-TR*                :AT-CODES-DATA-PRESENT,                                  
MFA-TR*                :AT-CREDIT-GROUP,                                        
MFA-TR*                :AT-TOTAL-AR-BALANCE,                                    
MFA-TR*                :AT-NOTICE-EXEMPT-CD,                                    
MFA-TR*                :AT-CODE-DISC-OK,                                        
MFA-TR*                :AT-DATE-BILL-DAY-00:WS-NULL-INDICATOR-1,                
MFA-TR*                :AT-DATE-BILL-DAY-30:WS-NULL-INDICATOR-2,                
MFA-TR*                :AT-DATE-BILL-DAY-60:WS-NULL-INDICATOR-3,                
MFA-TR*                :AT-DATE-BILL-DAY-90:WS-NULL-INDICATOR-4,                
MFA-TR*                :AT-BANKRUPTCY-IND,                                      
MFA-TR*                :AT-IVR-EXEMPT-CD                                        
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_ACCOUNT    AT                                       
MFA-TR*          WHERE                                                          
MFA-TR*                 ACCOUNT_NO  = :AT-ACCOUNT-NO                            
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL TO SUCCESSFUL-CALL        
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7120'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT    
              IF WS-NULL-INDICATOR-1 < 0                                
                MOVE SPACES                 TO AT-DATE-BILL-DAY-00      
              END-IF                                                    
              IF WS-NULL-INDICATOR-2 < 0                                
                MOVE SPACES                 TO AT-DATE-BILL-DAY-30      
              END-IF                                                    
              IF WS-NULL-INDICATOR-3 < 0                                
                MOVE SPACES                 TO AT-DATE-BILL-DAY-60      
              END-IF                                                    
              IF WS-NULL-INDICATOR-4 < 0                                
                MOVE SPACES                 TO AT-DATE-BILL-DAY-90      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * SELECT PAST-DUE-DELINQ-LIMIT FROM DELINQUENCY TABLE.           *        
      ******************************************************************        
      *                                                                         
       7130-SEL-PASTDUE-LMT.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                        C8.DELINQ_VALUE                                 
                  INTO                                                  
                        :WS-PAST-DUE-DELINQ-LIMIT                       
                  FROM                                                  
                        CSS_DELINQUENCY C8                              
                 WHERE                                                  
                        C8.DELINQ_CD   = 'AMT-WEB-PASTDUE-LMT'          
                   AND  C8.COMPANY_NO  = :WS-COMPANY-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 C8.DELINQ_VALUE                                         
MFA-TR*           INTO                                                          
MFA-TR*                 :WS-PAST-DUE-DELINQ-LIMIT                               
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_DELINQUENCY C8                                      
MFA-TR*          WHERE                                                          
MFA-TR*                 C8.DELINQ_CD   = 'AMT-WEB-PASTDUE-LMT'                  
MFA-TR*            AND  C8.COMPANY_NO  = :WS-COMPANY-NO                         
MFA-TR*        QUERYNO 7130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7130'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_DELINQUENCY'     TO TABLE-1                  
                 MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1          
                 MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2          
                 MOVE 'AMT-WEB-PASTDUE-LMT' TO HOSTVAR-ELEMENT-1        
                 MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7130-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * SELECT WO-CUTOFF-DT FROM DELINQUENCY TABLE.                    *        
      ******************************************************************        
      *                                                                         
       7150-SEL-WO-CUTOFF-DT.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                        C8.DELINQ_VALUE                                 
                  INTO                                                  
                        :WS-CUTOFF-DELINQ-VALUE                         
                  FROM                                                  
                        CSS_DELINQUENCY C8                              
                 WHERE                                                  
                        C8.DELINQ_CD   = 'WO-CUTOFF-DT'                 
                   AND  C8.COMPANY_NO  = :WS-COMPANY-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 C8.DELINQ_VALUE                                         
MFA-TR*           INTO                                                          
MFA-TR*                 :WS-CUTOFF-DELINQ-VALUE                                 
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_DELINQUENCY C8                                      
MFA-TR*          WHERE                                                          
MFA-TR*                 C8.DELINQ_CD   = 'WO-CUTOFF-DT'                         
MFA-TR*            AND  C8.COMPANY_NO  = :WS-COMPANY-NO                         
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7150'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_DELINQUENCY'     TO TABLE-1                  
                 MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1          
                 MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2          
                 MOVE 'WO-CUTOFF-DT'        TO HOSTVAR-ELEMENT-1        
                 MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CALCULATE CUTOFF DATE.                                         *        
      ******************************************************************        
      *                                                                         
       7160-CALC-CUTOFF-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT
              DATEADD( YEAR, -:WS-CUTOFF-DELINQ-VALUE, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CUT-OFF-DATE    
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CUT-OFF-DATE =                                          
MFA-TR*                 CURRENT DATE - :WS-CUTOFF-DELINQ-VALUE YEARS            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       7160-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * SELECT WRITE_OFF_DT FROM CSS_CHRG_OFF TABLE.                   *        
      ******************************************************************        
      *                                                                         
       7170-SEL-WRITE-OFF-DT.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                        CAST(AT.ACCT_FINALED_DT AS DATE)                        
                  INTO                                                  
                        :WS-WRITE-OFF-DT :WS-NULL-INDICATOR-6            
                  FROM                                                  
                        CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                 WHERE                                                  
                        AT.ACCOUNT_NO     = :WS-CUTOFF-ACCT             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 DATE(AT.ACCT_FINALED_DT)                                
MFA-TR*           INTO                                                          
MFA-TR*                 :WS-WRITE-OFF-DT:WS-NULL-INDICATOR-6                    
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_ACCOUNT AT                                          
MFA-TR*          WHERE                                                          
MFA-TR*                 AT.ACCOUNT_NO     = :WS-CUTOFF-ACCT                     
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7170                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-INDICATOR-6 < 0                          
                       MOVE SPACES          TO WS-WRITE-OFF-DT          
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE SPACES             TO WS-WRITE-OFF-DT          
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7170'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_CHRG_OFF'        TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE WS-CUTOFF-ACCT        TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7170-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CAL CSR02022.                                                  *        
      ******************************************************************        
      *                                                                         
       7180-CALL-CSR02022.                                              
      *                                                                         
      *    EXEC SQL                                                     
      *         CALL CSR02022(:WS-ACCOUNT-NO)                           
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
      *    EXEC SQL                                                     
      *         ASSOCIATE LOCATORS                                      
      *         (:LOC-RESLTSET)                                         
      *         WITH PROCEDURE CSR02022                                 
      *    END-EXEC.                                                    
      *                                                                         
      *    EXEC SQL                                                     
      *         ALLOCATE C2 CURSOR FOR RESULT SET                       
      *         :LOC-RESLTSET                                           
      *    END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
                FETCH C2 INTO                                           
                      :WS-NO-OF-BILLS,                                  
                      :WS-MIN-DEPOSIT-AMT,                              
                      :WS-MAX-DEPOSIT-AMT,                              
                      :WS-USAGE-HISTORY-FLAG,                           
                      :WS-SUMMARY-COL-NAME,                             
                      :WS-COLUMN-SUBTOTAL,                              
                      :WS-RETURN-CODE,                                  
                      :WS-MAX-DEP-REF-XMT-CD,                           
                      :WS-LAST-MAX-AT-REV-DT,                           
                      :WS-MAX-DEP-AT-REV-AM,                            
                      :WS-PD-DEP-AT-REV-AM,                             
                      :WS-MAX-DEP-REFUND-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL OR        
                                              NOT-FOUND                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7180'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'C2_CURSOR'              TO TABLE-1                  
              MOVE 'WS-ACTIVE-RETURN-CODE'  TO TABLE-ELEMENT-1          
              MOVE WS-ACTIVE-RETURN-CODE    TO HOSTVAR-ELEMENT-1        
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7180-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * SELECT ENDV FLAG FROM CSS_SO_DATA TABLE.                       *        
      ******************************************************************        
      *                                                                         
       7190-SEL-ENDV-FLAG.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       'Y'                                              
                  INTO                                                  
                       :WS-ENDV-FLAG                                    
                  FROM                                                  
                       CSS_SO_DATA                                      
                 WHERE                                                  
                       ACCOUNT_NO     = :WS-ACCT-NO                     
P00253             AND ORDER_TYPE_CD  IN ('FW019', 'FW016')             
                   AND ORDER_STATE_CD = 'A'                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-ENDV-FLAG                                            
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA                                              
MFA-TR*          WHERE                                                          
MFA-TR*                ACCOUNT_NO     = :WS-ACCT-NO                             
MFA-TR*            AND ORDER_TYPE_CD  IN ('FW019', 'FW016')                     
MFA-TR*            AND ORDER_STATE_CD = 'A'                                     
MFA-TR*        QUERYNO 7190                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7190'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_SO_DATA'         TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE 'ORDER_TYPE_CD'       TO TABLE-ELEMENT-2          
                 MOVE 'ORDER_STATE_CD'      TO TABLE-ELEMENT-3          
                 MOVE WS-ACCT-NO            TO HOSTVAR-ELEMENT-1        
P00253           MOVE 'FW019/FW016'         TO HOSTVAR-ELEMENT-2        
                 MOVE 'A'                   TO HOSTVAR-ELEMENT-3        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7190-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * SELECT RECONNECT FLAG FROM CSS_RECONNECT.                      *        
      ******************************************************************        
      *                                                                         
       7200-SEL-RECONNECT-FLAG.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                        'Y'                                             
                  INTO                                                  
                        :WS-RECONNECT-FLAG                              
                  FROM                                                  
                        CSS_RECONNECT                                   
                 WHERE                                                  
                        ACCOUNT_NO     = :WS-ACCT-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 'Y'                                                     
MFA-TR*           INTO                                                          
MFA-TR*                 :WS-RECONNECT-FLAG                                      
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_RECONNECT                                           
MFA-TR*          WHERE                                                          
MFA-TR*                 ACCOUNT_NO     = :WS-ACCT-NO                            
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7200'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_RECONNECT'       TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE WS-ACCT-NO            TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * OPENS RES_CURSOR CURSOR.                                       *        
      ******************************************************************        
      *                                                                         
       7210-OPEN-RES-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
                OPEN RES_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                              RS-RETURN-CODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSR04030_R1'            TO TABLE-1                  
              MOVE 'PAST_DUE_FLAG'          TO TABLE-ELEMENT-1          
              MOVE 'Y'                      TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * FETCHES RES_CURSOR CURSOR.                                     *        
      ******************************************************************        
      *                                                                         
       7220-FETCH-RES-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                      RES_CURSOR                                        
                 INTO                                                   
                      :WS-ACCT-NO                                       
                     ,:WS-AMT-UTIL                                      
                     ,:WS-AMT-NONUTIL                                   
                     ,:WS-TOT-UTIL                                      
                     ,:WS-TOT-NONUTIL                                   
                     ,:WS-ACCT-SRVC-ADDRESS                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               CONTINUE                                                 
             WHEN NOT-FOUND                                             
               MOVE 'Y'                     TO WS-NO-MORE-DATA-RESCUR   
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7220'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSR04030_R1'           TO TABLE-1                  
               MOVE 'PAST_DUE_FLAG'         TO TABLE-ELEMENT-1          
               MOVE 'Y'                     TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7220-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CLOSES RES_CURSOR CURSOR.                                      *        
      ******************************************************************        
      *                                                                         
       7230-CLOSE-RES-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
                CLOSE RES_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                              RS-RETURN-CODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7230'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSR04030_R1'            TO TABLE-1                  
              MOVE 'PAST_DUE_FLAG'          TO TABLE-ELEMENT-1          
              MOVE 'Y'                      TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * SELECT SUM(AMT_TRANS) FROM CSS_CHRG_OFF.                       *        
      ******************************************************************        
      *                                                                         
       7250-SEL-TOTAL-AR-BAL.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                        COALESCE (SUM(AMT_TRANS),0)                     
                  INTO                                                  
                        :WS-TOTAL-AR-BAL                                
                  FROM                                                  
                        CSS_CHRG_OFF                                    
                 WHERE                                                  
                        ACCOUNT_NO     = :WS-CUTOFF-ACCT                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 COALESCE (SUM(AMT_TRANS),0)                             
MFA-TR*           INTO                                                          
MFA-TR*                 :WS-TOTAL-AR-BAL                                        
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_CHRG_OFF                                            
MFA-TR*          WHERE                                                          
MFA-TR*                 ACCOUNT_NO     = :WS-CUTOFF-ACCT                        
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7250'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_CHRG_OFF'        TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE WS-SP-ACCOUNT-NO(CTR-SUB)                         
                                            TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7250-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *7270-SEL-DNP-FB-FLAG                                            *        
      ******************************************************************        
       7270-SEL-DNP-FB-FLAG.                                            
      *                                                                         
           EXEC SQL                                                     
                  SELECT 'Y'                                            
                    INTO                                                
                         :WS-DNP-FB-FLAG                                
                    FROM CSS_SO_DATA                                    
                   WHERE                                                
                         ACCOUNT_NO     = :WS-ACCT-NO                   
                     AND ORDER_TYPE_CD  = 'DNPFB'                       
                     AND ORDER_STATE_CD NOT IN ('Z','C')                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*           SELECT 'Y'                                                    
MFA-TR*             INTO                                                        
MFA-TR*                  :WS-DNP-FB-FLAG                                        
MFA-TR*             FROM CSS_SO_DATA                                            
MFA-TR*            WHERE                                                        
MFA-TR*                  ACCOUNT_NO     = :WS-ACCT-NO                           
MFA-TR*              AND ORDER_TYPE_CD  = 'DNPFB'                               
MFA-TR*              AND ORDER_STATE_CD NOT IN ('Z','C')                        
MFA-TR*        QUERYNO 7270                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7270'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_SO_DATA'         TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE 'ORDER_TYPE_CD'       TO TABLE-ELEMENT-2          
                 MOVE 'ORDER_STATE_CD'      TO TABLE-ELEMENT-3          
                 MOVE WS-ACCT-NO            TO HOSTVAR-ELEMENT-1        
                 MOVE 'DNPFB'               TO HOSTVAR-ELEMENT-2        
                 MOVE 'A'                   TO HOSTVAR-ELEMENT-3        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7270-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *7280-SEL-ACCT-SRVC-ADDR                                         *        
      ******************************************************************        
      *                                                                         
       7280-SEL-ACCT-SRVC-ADDR.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) RTRIM(DY.HOUSE_NO) + ' ' + RTRIM(
           DY.ADDR_PREFIX_1) + ' ' + RTRIM(DY.ADDR_PREFIX_2) + ' ' + 
           RTRIM(DY.STREET_NAME) + ' ' + RTRIM(S9.STREET_SUFFIX_DESC
           ) + ' ' + RTRIM(DY.ADDR_SUFFIX),
              RTRIM(DY.STREET_LOCATION_1) + ' ' + RTRIM(
           DY.STREET_LOCATION_2)                     
                  INTO :WS-FULL-SRVC-ADDR                               
                       ,:WS-FULL-LOCATION                               
                  FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),             
                       CSS_PREMISE PR WITH(READUNCOMMITTED),                    
                       CSS_STREET_SUFFIX S9 WITH(READUNCOMMITTED),              
                       CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                 WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                   
                   AND AT.PREMISE_NO = PR.PREMISE_NO                    
                   AND DY.ADDRESS_ID = PR.ADDRESS_ID                    
                   AND DY.STREET_SUFFIX = S9.STREET_SUFFIX              
                   AND DY.ADDR_USAGE_CD = 'F'                           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT RTRIM(DY.HOUSE_NO) ||' '||                               
MFA-TR*                RTRIM(DY.ADDR_PREFIX_1) ||' '||                          
MFA-TR*                RTRIM(DY.ADDR_PREFIX_2) ||' '||                          
MFA-TR*                RTRIM(DY.STREET_NAME) ||' '||                            
MFA-TR*                RTRIM(S9.STREET_SUFFIX_DESC) ||' '||                     
MFA-TR*                RTRIM(DY.ADDR_SUFFIX)                                    
MFA-TR*                ,RTRIM(DY.STREET_LOCATION_1) ||' '||                     
MFA-TR*                 RTRIM(DY.STREET_LOCATION_2)                             
MFA-TR*           INTO :WS-FULL-SRVC-ADDR                                       
MFA-TR*                ,:WS-FULL-LOCATION                                       
MFA-TR*           FROM CSS_ADDR_FORMATTED DY,                                   
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_STREET_SUFFIX S9,                                    
MFA-TR*                CSS_ACCOUNT AT                                           
MFA-TR*          WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*            AND AT.PREMISE_NO = PR.PREMISE_NO                            
MFA-TR*            AND DY.ADDRESS_ID = PR.ADDRESS_ID                            
MFA-TR*            AND DY.STREET_SUFFIX = S9.STREET_SUFFIX                      
MFA-TR*            AND DY.ADDR_USAGE_CD = 'F'                                   
MFA-TR*            FETCH FIRST ROW ONLY WITH UR                                 
MFA-TR*        QUERYNO 7280                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7280'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                  
                 MOVE 'CSS_PREMISE'         TO TABLE-1                  
                 MOVE 'CSS_STREET_SUFFIX'   TO TABLE-1                  
                 MOVE 'CSS_ACCOUNT'         TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE WS-ACCT-NO            TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7280-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
      *                                                                         
            EXEC SQL                                                    
               DELETE FROM #CSR04030_R1                          
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        DELETE FROM SESSION.CSR04030_R1                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             NEXT SENTENCE                                              
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000A'                  TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSR04030_R1'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * INSERT RESULTSET.                                              *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR04030_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,PROGRAM_ID                                         
                    ,PROCESS_CD                                         
                    ,CRDT_CHCK_REQ                                      
                    ,CPTR_QUE_FLAG                                      
                    ,PAST_DUE_FLAG                                      
                    ,DEPOSIT_AMT                                        
                    ,ACCOUNT_NO                                         
                    ,CODE_ACCT_STAT                                     
                    ,PAST_DUE_UTL                                       
                    ,PAST_DUE_NONUTL                                    
                    ,CUST_TYPE                                          
                    ,TOTAL_UTL                                          
                    ,TOTAL_NONUTL                                       
                    ,CASHONLY_FLAG                                      
                    ,SSN                                                
                    ,ACCT_SRVC_ADDRESS                                  
                    ,PREMISE_NO                                         
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE                                     
                    ,:S-PROGRAM-ID                                      
                    ,:S-PROCESS-CD                                      
                    ,:S-CRDT-CHCK-REQ                                   
                    ,:S-CPTR-QUE-FLAG                                   
                    ,:S-PAST-DUE-FLAG                                   
                    ,:S-DEPOSIT-AMT                                     
                    ,:S-ACCOUNT-NO                                      
                    ,:S-CODE-ACCT-STAT                                  
                    ,:S-PAST-DUE-UTL                                    
                    ,:S-PAST-DUE-NONUTL                                 
                    ,:S-CUST-TYPE                                       
                    ,:S-TOTAL-UTL                                       
                    ,:S-TOTAL-NONUTL                                    
                    ,:S-CASH-ONLY-FLAG                                  
                    ,:S-SSN                                             
                    ,:S-ACCT-SRVC-ADDRESS                               
                    ,:S-PREMISE-NO                                      
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04030_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,PROGRAM_ID                                                 
MFA-TR*             ,PROCESS_CD                                                 
MFA-TR*             ,CRDT_CHCK_REQ                                              
MFA-TR*             ,CPTR_QUE_FLAG                                              
MFA-TR*             ,PAST_DUE_FLAG                                              
MFA-TR*             ,DEPOSIT_AMT                                                
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,PAST_DUE_UTL                                               
MFA-TR*             ,PAST_DUE_NONUTL                                            
MFA-TR*             ,CUST_TYPE                                                  
MFA-TR*             ,TOTAL_UTL                                                  
MFA-TR*             ,TOTAL_NONUTL                                               
MFA-TR*             ,CASHONLY_FLAG                                              
MFA-TR*             ,SSN                                                        
MFA-TR*             ,ACCT_SRVC_ADDRESS                                          
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-PROGRAM-ID                                              
MFA-TR*             ,:S-PROCESS-CD                                              
MFA-TR*             ,:S-CRDT-CHCK-REQ                                           
MFA-TR*             ,:S-CPTR-QUE-FLAG                                           
MFA-TR*             ,:S-PAST-DUE-FLAG                                           
MFA-TR*             ,:S-DEPOSIT-AMT                                             
MFA-TR*             ,:S-ACCOUNT-NO                                              
MFA-TR*             ,:S-CODE-ACCT-STAT                                          
MFA-TR*             ,:S-PAST-DUE-UTL                                            
MFA-TR*             ,:S-PAST-DUE-NONUTL                                         
MFA-TR*             ,:S-CUST-TYPE                                               
MFA-TR*             ,:S-TOTAL-UTL                                               
MFA-TR*             ,:S-TOTAL-NONUTL                                            
MFA-TR*             ,:S-CASH-ONLY-FLAG                                          
MFA-TR*             ,:S-SSN                                                     
MFA-TR*             ,:S-ACCT-SRVC-ADDRESS                                       
MFA-TR*             ,:S-PREMISE-NO                                              
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS                
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04030_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8200-INSERT-COMM-DATA.                                         *        
      ******************************************************************        
      *                                                                         
       8200-INSERT-COMM-DATA.                                           
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (                                               
                         COMMUNICATION_ID                               
                        ,ACCOUNT_NO                                     
                        ,CUSTOMER_NO                                    
                        ,PREMISE_NO                                     
                        ,COMPANY_NO                                     
                        ,RED_FLAG_IND                                   
                        ,RED_FLAG_EXPIRE_DT                             
                        ,COMM_METHOD                                    
                        ,COMM_DIRECTION                                 
                        ,COMM_TYPE_CD                                   
                        ,COMM_SUBTYPE_CODE                              
                        ,USER_ID_ORIG                                   
                        ,CONTACT_NAME                                   
                        ,PROMOTION_ID                                   
                        ,PSC_COMPLIANCE_IND                             
                        ,CALL_ORIGIN_ID                                 
                        ,CALL_END_TIME                                  
                        ,NUMBER_TRANSFERS                               
                        ,HOLD_TIME                                      
                        ,QUEUE_TIME                                     
                        ,SCREEN_POP_IND                                 
                        ,TOTAL_CALL_TIME                                
                        ,INITIAL_COMMENT_TX                             
                        ,RESPONSE_REASON_CD                             
                        ,RESPONSE_TYPE_CD                               
                        ,SOLICITATION_CD                                
                        ,COMM_ASSOC_CD                                  
                        ,COMPLAINT_FL                                   
                        ,DISCOVERY_MTHD_CD                              
                        ,PREV_MARKETER_CD                               
                       )                                                
                VALUES                                                  
                       (                                                
                          CIS.CURRENT$TIMESTAMP()                             
                        ,:KO-ACCOUNT-NO                                 
                        ,:KO-CUSTOMER-NO                                
                        ,:KO-PREMISE-NO                                 
                        ,:KO-COMPANY-NO                                 
                        ,:KO-RED-FLAG-IND                               
                        ,CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND)      
                        ,:KO-COMM-METHOD                                
                        ,:KO-COMM-DIRECTION                             
                        ,:KO-COMM-TYPE-CD                               
                        ,:KO-COMM-SUBTYPE-CODE                          
                        ,:KO-USER-ID-ORIG                               
                        ,:KO-CONTACT-NAME                               
                        ,:KO-PROMOTION-ID                               
                        ,:KO-PSC-COMPLIANCE-IND                         
                        ,:KO-CALL-ORIGIN-ID                             
                        ,CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND)              
                        ,:KO-NUMBER-TRANSFERS                           
                        ,:KO-HOLD-TIME                                  
                        ,:KO-QUEUE-TIME                                 
                        ,:KO-SCREEN-POP-IND                             
                        ,:KO-TOTAL-CALL-TIME                            
                        ,:KO-INITIAL-COMMENT-TX                         
                        ,:KO-RESPONSE-REASON-CD                         
                        ,:KO-RESPONSE-TYPE-CD                           
                        ,:KO-SOLICITATION-CD                            
                        ,:KO-COMM-ASSOC-CD                              
                        ,:KO-COMPLAINT-FL                               
                        ,:KO-DISCOVERY-MTHD-CD                          
                        ,:KO-PREV-MARKETER-CD                           
                       )                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (                                                       
MFA-TR*                  COMMUNICATION_ID                                       
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*                 ,CUSTOMER_NO                                            
MFA-TR*                 ,PREMISE_NO                                             
MFA-TR*                 ,COMPANY_NO                                             
MFA-TR*                 ,RED_FLAG_IND                                           
MFA-TR*                 ,RED_FLAG_EXPIRE_DT                                     
MFA-TR*                 ,COMM_METHOD                                            
MFA-TR*                 ,COMM_DIRECTION                                         
MFA-TR*                 ,COMM_TYPE_CD                                           
MFA-TR*                 ,COMM_SUBTYPE_CODE                                      
MFA-TR*                 ,USER_ID_ORIG                                           
MFA-TR*                 ,CONTACT_NAME                                           
MFA-TR*                 ,PROMOTION_ID                                           
MFA-TR*                 ,PSC_COMPLIANCE_IND                                     
MFA-TR*                 ,CALL_ORIGIN_ID                                         
MFA-TR*                 ,CALL_END_TIME                                          
MFA-TR*                 ,NUMBER_TRANSFERS                                       
MFA-TR*                 ,HOLD_TIME                                              
MFA-TR*                 ,QUEUE_TIME                                             
MFA-TR*                 ,SCREEN_POP_IND                                         
MFA-TR*                 ,TOTAL_CALL_TIME                                        
MFA-TR*                 ,INITIAL_COMMENT_TX                                     
MFA-TR*                 ,RESPONSE_REASON_CD                                     
MFA-TR*                 ,RESPONSE_TYPE_CD                                       
MFA-TR*                 ,SOLICITATION_CD                                        
MFA-TR*                 ,COMM_ASSOC_CD                                          
MFA-TR*                 ,COMPLAINT_FL                                           
MFA-TR*                 ,DISCOVERY_MTHD_CD                                      
MFA-TR*                 ,PREV_MARKETER_CD                                       
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                   CURRENT TIMESTAMP                                     
MFA-TR*                 ,:KO-ACCOUNT-NO                                         
MFA-TR*                 ,:KO-CUSTOMER-NO                                        
MFA-TR*                 ,:KO-PREMISE-NO                                         
MFA-TR*                 ,:KO-COMPANY-NO                                         
MFA-TR*                 ,:KO-RED-FLAG-IND                                       
MFA-TR*                 ,:KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND              
MFA-TR*                 ,:KO-COMM-METHOD                                        
MFA-TR*                 ,:KO-COMM-DIRECTION                                     
MFA-TR*                 ,:KO-COMM-TYPE-CD                                       
MFA-TR*                 ,:KO-COMM-SUBTYPE-CODE                                  
MFA-TR*                 ,:KO-USER-ID-ORIG                                       
MFA-TR*                 ,:KO-CONTACT-NAME                                       
MFA-TR*                 ,:KO-PROMOTION-ID                                       
MFA-TR*                 ,:KO-PSC-COMPLIANCE-IND                                 
MFA-TR*                 ,:KO-CALL-ORIGIN-ID                                     
MFA-TR*                 ,:KO-CALL-END-TIME:WS-END-NULL-IND                      
MFA-TR*                 ,:KO-NUMBER-TRANSFERS                                   
MFA-TR*                 ,:KO-HOLD-TIME                                          
MFA-TR*                 ,:KO-QUEUE-TIME                                         
MFA-TR*                 ,:KO-SCREEN-POP-IND                                     
MFA-TR*                 ,:KO-TOTAL-CALL-TIME                                    
MFA-TR*                 ,:KO-INITIAL-COMMENT-TX                                 
MFA-TR*                 ,:KO-RESPONSE-REASON-CD                                 
MFA-TR*                 ,:KO-RESPONSE-TYPE-CD                                   
MFA-TR*                 ,:KO-SOLICITATION-CD                                    
MFA-TR*                 ,:KO-COMM-ASSOC-CD                                      
MFA-TR*                 ,:KO-COMPLAINT-FL                                       
MFA-TR*                 ,:KO-DISCOVERY-MTHD-CD                                  
MFA-TR*                 ,:KO-PREV-MARKETER-CD                                   
MFA-TR*                )                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8200'                   TO  ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
                                                RS-RETURN-CODE          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_COMM_DATA'          TO  TABLE-1                 
              MOVE 'CUSTOMER_NO'            TO  TABLE-ELEMENT-1         
              MOVE 'PREMISE_NO'             TO  TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'             TO  TABLE-ELEMENT-3         
              MOVE WS-CUSTOMER-NO           TO  HOSTVAR-ELEMENT-1       
              MOVE WS-PREMISE-NO-NUM        TO  HOSTVAR-ELEMENT-2       
              MOVE WS-COMPANY-NO            TO  HOSTVAR-ELEMENT-3       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Calls WS-MCSCB068 as part of CPD00068 process.                 *        
      ******************************************************************        
      *                                                                         
       9500-CALL-CPD00068.                                              
      *                                                                         
           PERFORM 7120-SEL-ACCT-DET     THRU 7120-EXIT.                
                                                                        
           MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT.      
                                                                        
           MOVE 'Y'                      TO CALC-BALANCE-SW             
                                            CALC-ARREARS-SW             
                                            CALC-PAST-DUE-SW.           
      *                                                                         
           CALL WS-MCSCB068  USING CWS00068-FIELDS                      
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
      *                                                                         
           MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                               SQLCODE.                 
      *                                                                         
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                    TO RS-RETURN-CODE           
                                               WS-ACTIVE-RETURN-CODE    
              END-IF                                                    
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       9500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                       Program Copy Books                       *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9700-PROCESS-ABEND                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023C                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                  SQL Error Processing Copy Book                *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REDUCE-EMBEDDED SPACES                                        *        
      ******************************************************************        
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      **********************End-of the Program**************************        
