       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04029.                                            
       DATE-WRITTEN.  OCT 06, 2007.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE WHICH ENABLES TO     *        
      *  FIND OR CREATE CUSTOMER NUMBER, WHICH IS USED TO IDENTIFY     *        
      *  WHETHER THE CUSTOMER IS E-CUSTOMER AND HAS VALID E-LOGIN      *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  10/06/07  CVNS       INITIAL VERSION                          *        
      *  10/06/08  VD41351    ADDED ENDV CHECK HERE                    *        
      *  10/20/08  VD41351    ADDED ACTIVE, PENDING, FINAL AND WO ACCTS*        
      *                       ASSOCIATED WITH THE CUSTOMER             *        
      *  12/16/08  VD41351    ALLOW NON-UTIL CUSTOMERS TO SIGNUP RES   *        
      *                       SERVICE                                  *        
      *  01/26/09  VD41351    MODFIED CSR02203 CALL STMT TO ADD ADTL   *        
      *                       INPUT PARM AS PART OF SEBR PROJECT       *        
      *  02/17/09  VD41351    FOR PENDING ACCTS CHECK CC/OC ORDER STATS*        
P00172*  07/06/09  VD41351    MODFIED CSR02203 CALL STMT TO ADD ADTL   *        
P00172*                       INPUT PARM DHR_FL FOR REGULATED PROVIDER.*        
P00253*  12/21/09  FMB        ADDED DETECTENT ORDER TYPE FW016         *        
P00422*  09/08/10  FMB        ADDED LANDLORD_REVERT_FL TO CSR02203 CALL*        
P00465*  06/16/11  FMB        ADDED WELCOME_KIT_FL TO CSR02203 CALL    *        
A05317*  01/19/17  FMB        REPLACE CSR02203 WITH CSR04496           *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 3999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  4000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04029'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04029 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *   RETURN FIELD AREA                                           *         
      *****************************************************************         
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                 PIC S9(9)  COMP VALUE ZERO.  
          05 S-E-CUST-FLAG                 PIC X(01)  VALUE SPACES.     
          05 S-E-LOGIN-FLAG                PIC X(01)  VALUE SPACES.     
          05 S-CUSTOMER-NO                 PIC X(10)  VALUE SPACES.     
          05 S-CUST-FLAG                   PIC X(06)  VALUE SPACES.     
          05 S-CUST-SSN-FLAG               PIC X(01)  VALUE SPACES.     
          05 S-ACCOUNT-NOS                 PIC X(200) VALUE SPACES.     
                                                                        
       01 TDS-RETURN-FIELDS.                                            
          05 RS-RETURN-CODE                PIC S9(9)  COMP VALUE ZERO.  
          05 RS-E-CUST-FLAG                PIC X(01)  VALUE SPACES.     
          05 RS-E-LOGIN-FLAG               PIC X(01)  VALUE SPACES.     
          05 RS-CUSTOMER-NO                PIC X(10)  VALUE SPACES.     
          05 RS-CUST-FLAG                  PIC X(06)  VALUE SPACES.     
          05 RS-CUST-SSN-FLAG              PIC X(01)  VALUE SPACES.     
          05 RS-ACCOUNT-NOS                PIC X(200) VALUE SPACES.     
                                                                        
       01 SWITCHES.                                                     
          05 SEND-DONE-SW                  PIC X(01)  VALUE 'Y'.        
              88 SEND-DONE-ERROR                      VALUE 'N'.        
              88 SEND-DONE-OK                         VALUE 'Y'.        
          05 WS-CODE-ACCT-ROWS             PIC X(01)  VALUE 'N'.        
              88 NO-CODE-ACCT-ROWS                    VALUE 'Y'.        
          05 WS-ACCT-ACTIVE-PEND-ROWS      PIC X(01)  VALUE 'N'.        
              88 NO-ACCT-ACTIVE-PEND-ROWS             VALUE 'Y'.        
                                                                        
       01 WS-RETURN-FIELDS.                                             
          05 WS-RETURN-CODE                PIC S9(9)  COMP VALUE ZERO.  
          05 WS-E-CUST-FLAG                PIC X(01)  VALUE SPACES.     
          05 WS-E-LOGIN-FLAG               PIC X(01)  VALUE SPACES.     
          05 WS-CUSTOMER-NO-JST            PIC X(10) JUSTIFIED RIGHT.   
          05 WS-CUSTOMER-NO                PIC X(10)  VALUE SPACES.     
          05 WS-CUSTOMER-NO-NUM            REDEFINES  WS-CUSTOMER-NO    
                                           PIC 9(10).                   
          05 WS-AT-CUSTOMER-NO             PIC S9(10) COMP-3 VALUE ZERO.
          05 WS-NEW-CUSTOMER-NO            PIC X(10)  VALUE SPACES.     
          05 WS-CUSTOMER-EST-DATE          PIC X(10)  VALUE SPACES.     
          05 WS-CUST-FLAG                  PIC X(06)  VALUE SPACES.     
          05 WS-CUST-SSN-FLAG              PIC X(01)  VALUE 'N'.        
                                                                        
      *****************************************************************         
      *   GENERAL-WORKING-STORAGE VARIABLE DECLARATION                *         
      *****************************************************************         
                                                                        
       01 WORKING-VARIABLES.                                            
          05 WS-SSN                        PIC X(09)  VALUE SPACES.     
          05 WS-FIRST-NAME                 PIC X(15)  VALUE SPACES.     
          05 WS-MIDDLE-NAME                PIC X(15)  VALUE SPACES.     
          05 WS-LAST-NAME                  PIC X(40)  VALUE SPACES.     
          05 WS-SUFFIX                     PIC X(03)  VALUE SPACES.     
          05 WS-EXISTS-FULL-NAME           PIC X(70)  VALUE SPACES.     
          05 WS-EXIST-FULL-NAME.                                        
             10  WS-FULL-NAME-COMMENT      PIC X(70)  VALUE SPACES.     
             10  WS-FULL-NAME-COMMENT-LEN  PIC S9(4)  VALUE 0 COMP.     
          05 WS-COMPANY-NO                 PIC X(02)  VALUE SPACES.     
          05 WS-PREMISE-NO                 PIC X(10)  VALUE SPACES.     
          05 WS-PREMISE-ADDR.                                           
             10 WS-PREMISE-ADDR-LEN        PIC S9(04) USAGE COMP.       
             10 WS-PREMISE-ADDR-TEXT       PIC X(100) VALUE SPACES.     
          05 WS-FIRST-NAME-EXISTS.                                      
             10  WS-FIRST-NAME-COMMENT     PIC X(15)  VALUE SPACES.     
             10  WS-FIRST-NAME-COMMENT-LEN PIC S9(4)  VALUE 0 COMP.     
          05 WS-LAST-NAME-EXISTS.                                       
             10  WS-LAST-NAME-COMMENT      PIC X(40)  VALUE SPACES.     
             10  WS-LAST-NAME-COMMENT-LEN  PIC S9(4)  VALUE 0 COMP.     
          05 WS-MIDDLE-NAME-EXISTS.                                     
             10 WS-MIDDLE-NAME-COMMENT     PIC X(15)  VALUE SPACES.     
             10 WS-MIDDLE-NAME-COMMENT-LEN PIC S9(4)  VALUE 0 COMP.     
          05 WS-CONTACT-NAME               PIC X(25)  VALUE SPACES.     
          05 WS-TEMP-NAME1.                                             
             10  WS-TEMP-NAME-COMMENT      PIC X(25)  VALUE SPACES.     
             10  WS-TEMP-NAME-COMMENT-LEN  PIC S9(4)  VALUE 0 COMP.     
          05 WS-TEMP-NAME2                 PIC X(25)  VALUE SPACES.     
          05 WS-TEMP-NAME3                 PIC X(25)  VALUE SPACES.     
          05 WS-CUST-CONTACT-NAME          PIC X(25)  VALUE SPACES.     
          05 WS-TEMP-CONTACT-NAME          PIC X(25)  VALUE SPACES.     
          05 WS-USER-ID-ORIG               PIC X(07)  VALUE SPACES.     
          05 WS-EXISTS-FIRST-NAME          PIC X(15)  VALUE SPACES.     
          05 WS-EXISTS-MIDDLE-NAME         PIC X(15)  VALUE SPACES.     
          05 WS-SPOUSE-FIRST-NAME          PIC X(15)  VALUE SPACES.     
          05 WS-EXISTS-LAST-NAME           PIC X(40)  VALUE SPACES.     
          05 WS-SPOUSE-LAST-NAME           PIC X(40)  VALUE SPACES.     
          05 WS-EBILL-REGISTER-IND         PIC X(01)  VALUE SPACES.     
          05 WS-CUSTOMER-TYPE              PIC X(01)  VALUE SPACES.     
          05 WS-SPOUSE-CUSTOMER-TYPE       PIC X(01)  VALUE SPACES.     
          05 WS-CUST-IND-BIS-FLAG          PIC X(01)  VALUE 'N'.        
          05 WS-ACCOUNT-EXISTS             PIC X(01)  VALUE 'N'.        
          05 WS-CUST-RES-FLAG              PIC X(01)  VALUE 'N'.        
          05 WS-CUST-NOT-RES-FLAG          PIC X(01)  VALUE SPACES.     
          05 WS-DELINQ-CD                  PIC X(20)  VALUE SPACES.     
          05 WS-DELINQ-VALUE               PIC S9(4)V COMP-3 VALUE 0.   
          05 WS-CODE-ACCT-STAT             PIC X(01)  VALUE SPACES.     
          05 WS-ACCT-FINALED-DT            PIC X(26)  VALUE SPACES.     
          05 WS-DIFF-VALUE                 PIC S9(9)  COMP VALUE 0.     
          05 WS-DIF-CDATE-VALUE            PIC S9(9)  COMP VALUE 0.     
          05 WS-F-B-ACCT-VAL               PIC S9(9)  COMP VALUE 0.     
          05 WS-RET-STATUS                 PIC S9(4)  COMP VALUE ZERO.  
          05 PROGRAM-NAME                  PIC X(08)  VALUE 'CSR04029'. 
          05 WS-CUST-NOT-VALID             PIC X(3)   VALUE '400'.      
          05 WS-SPOUSE-NOT-VALID           PIC X(3)   VALUE '401'.      
          05 WS-CUST-TYPE-IB               PIC X(3)   VALUE '500'.      
          05 WS-CUST-TYPE-RO               PIC X(3)   VALUE '600'.      
          05 WS-ITPA-RSLT-CURR-RETURN-CD   PIC X(3)   VALUE '700'.      
          05 WS-RED-FLAG-RETURN-CODE       PIC X(3)   VALUE '800'.      
          05 WS-ENDV-FLAG-RETURN-CODE      PIC X(3)   VALUE '900'.      
          05 WS-CUSTOMER-EXISTS            PIC X(6)   VALUE 'EXISTS'.   
          05 WS-UPDATE-TYPE                PIC X(01)  VALUE 'I'.        
          05 WS-NAME-FORMAT                PIC X(01)  VALUE 'I'.        
          05 WS-USER-ID                    PIC X(07)  VALUE 'WEBTRN1'.  
          05 WS-OTHER-ACCT-VAL             PIC S9(9)  VALUE ZERO.       
          05 WS-WRITEOF-ACCT-VAL           PIC S9(9)  VALUE ZERO.       
          05 WS-FINAL-BILL-ACCT-VAL        PIC S9(9)  VALUE ZERO.       
          05 WS-TEMP-VAL                   PIC S9(9)  VALUE ZERO.       
          05 WS-IND-FINALED-DT             PIC X(1)   VALUE SPACES.     
          05 WS-COMM-TIMESTAMP             PIC X(26) VALUE SPACES.      
          05 WS-COMM-CUST-NO               PIC S9(10)V COMP-3 VALUE +0. 
          05 WS-COMM-ACCT-NO               PIC S9(13)V COMP-3 VALUE +0. 
          05 WS-COMM-PREM-NO               PIC S9(10)V COMP-3 VALUE +0. 
          05 WS-COMM-COMPANY-NO            PIC X(02) VALUE SPACES.      
          05 WS-COMM-METHOD                PIC X(01) VALUE SPACES.      
          05 WS-COMM-DIRECTION             PIC X(01) VALUE SPACES.      
          05 WS-COMM-TYPE-CD               PIC X(02) VALUE SPACES.      
          05 WS-COMM-SUBTYPE-CODE          PIC X(02) VALUE SPACES.      
          05 WS-COMM-ASSOC-CD              PIC X(01) VALUE SPACES.      
          05 WS-COMM-INITIAL-COMMENT       PIC X(255) VALUE SPACES.     
          05 WS-COMM-COMM-TEXT             PIC X(255) VALUE SPACES.     
          05 WS-COMM-COMM-TEXT1            PIC X(26) VALUE              
                                         'REQUEST INCOMPLETE//ITPA//'.  
          05 WS-COMM-COMM-TEXT2            PIC X(13) VALUE              
                                          'CONTACT_NAME='.              
          05 WS-COMM-COMM-TEXT3            PIC X(46) VALUE              
                     'REQUEST INCOMPLETE//CUST HAS RP INVEST ORDER//'.  
          05 WS-COMM-COMM-TEXT4            PIC X(30) VALUE              
                                     'REQUEST INCOMPLETE//RED FLAG//'.  
          05 WS-COMMA-MARK                 PIC X(01) VALUE ','.         
          05 WS-SPACE                      PIC X(01) VALUE ' '.         
          05 WS-ITPA-RSLT-CURR-CD          PIC X(01)  VALUE SPACES.     
          05 WS-ITPA-RSLT-CURR-CD-FLAG     PIC X(01)  VALUE 'N'.        
          05 WS-RED-FLAG-IND               PIC X(01)  VALUE 'N'.        
          05 WS-ENDV-FLAG-IND              PIC X(01)  VALUE 'N'.        
          05 WS-RED-FLAG-INDD              PIC X(01)  VALUE 'Y'.        
          05 WS-ACCOUNTT-NO                PIC X(200) VALUE SPACES.     
          05 WS-TEMP-ACCOUNT-NO            PIC X(200) VALUE SPACES.     
          05 WS-SEMI-COLON                 PIC X(1) VALUE ';'.          
COB305    05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.          
          05 WS-ACCOUNT-NO-NUM             REDEFINES WS-ACCOUNT-NO-COMP3
                                           PIC 9(13).                   
          05 WS-ACCOUNT-NO                 PIC X(13).                   
                                                                        
       01 COUNTER-FIELDS.                                               
          05 CTR-ROWS                      PIC S9(9)  COMP VALUE 1.     
                                                                        
      *01 LOC-RESLTSET                     USAGE SQL TYPE IS            
      *                                    RESULT-SET-LOCATOR VARYING.  
                                                                        
      ******************************************************************        
      *     DB2 INCLUDES                                               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CE - CSS_CUST_STATS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCSTSTS                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNMACTX                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ - CSS_NAME                                               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNAME                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    VO - CSS_SO_DATA                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    UT - CSS_UTIL_ENVRNMT                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    KO - CSS_COMM_DATA                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCOMDAT                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    LF - CSS_CRED_ITPA_HIST                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCRITPA                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   COBOL WORKING STORAGE COPY BOOKS                            *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      *    WS FOR 6010-REDUCE-EMBEDDED SPACES                         *         
      *****************************************************************         
       COPY CWS00011.                                                           
                                                                        
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   CURSOR DELCARATION                                          *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
                DECLARE CODE-ACCT-CUR CURSOR FOR                        
                 SELECT AT.CODE_ACCT_STAT                               
                       ,AT.ACCOUNT_NO                                   
                       ,COALESCE(REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.'),' ')            
                   FROM CSS_ACCOUNT AT                                  
                  WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                
                    AND AT.COMPANY_NO  = :AT-COMPANY-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CODE-ACCT-CUR CURSOR FOR                                
MFA-TR*          SELECT AT.CODE_ACCT_STAT                                       
MFA-TR*                ,AT.ACCOUNT_NO                                           
MFA-TR*                ,IFNULL(CHAR(AT.ACCT_FINALED_DT),' ')                    
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*           WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                        
MFA-TR*             AND AT.COMPANY_NO  = :AT-COMPANY-NO                         
MFA-TR*          QUERYNO 7040                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                DECLARE ACCT-ACTIVE-PEND-CUR CURSOR FOR                 
                 SELECT AT.ACCOUNT_NO                                   
                       ,AT.CODE_ACCT_STAT                               
                   FROM CSS_ACCOUNT AT                                  
                  WHERE AT.CUSTOMER_NO    = :AT-CUSTOMER-NO             
                    AND AT.COMPANY_NO     = :AT-COMPANY-NO              
                    AND ((AT.CODE_ACCT_STAT = 'A')                      
                     OR (AT.CODE_ACCT_STAT = 'P'                        
                    AND  EXISTS (SELECT 1                               
                                   FROM CSS_SO_DATA VO                  
                                  WHERE VO.ACCOUNT_NO = AT.ACCOUNT_NO   
               AND VO.ORDER_TYPE_CD IN ('CC001','CC002','CC003','NC001')
               AND VO.ORDER_STATE_CD <> 'C')))                          
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE ACCT-ACTIVE-PEND-CUR CURSOR FOR                         
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.CODE_ACCT_STAT                                       
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*           WHERE AT.CUSTOMER_NO    = :AT-CUSTOMER-NO                     
MFA-TR*             AND AT.COMPANY_NO     = :AT-COMPANY-NO                      
MFA-TR*             AND ((AT.CODE_ACCT_STAT = 'A')                              
MFA-TR*              OR (AT.CODE_ACCT_STAT = 'P'                                
MFA-TR*             AND  EXISTS (SELECT 1                                       
MFA-TR*                            FROM CSS_SO_DATA VO                          
MFA-TR*                           WHERE VO.ACCOUNT_NO = AT.ACCOUNT_NO           
MFA-TR*        AND VO.ORDER_TYPE_CD IN ('CC001','CC002','CC003','NC001')        
MFA-TR*        AND VO.ORDER_STATE_CD <> 'C')))                                  
MFA-TR*          QUERYNO 7270                                                   
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR04496( :WS-UPDATE-TYPE
                  , ' '
                  , :WS-COMPANY-NO
                  , ' '
                  , ' '
                  , :WS-FIRST-NAME
                  , :WS-MIDDLE-NAME
                  , :WS-LAST-NAME
                  , :WS-SUFFIX
                  , ' '
                  , :WS-SSN
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , 'N'
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , 'N'
                  , ' '
                  , ' '
                  , :WS-USER-ID
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01 PARM-CUSTOMER-NO   PIC X(10).                                 
       01 PARM-SSN           PIC X(09).                                 
       01 PARM-FIRST-NAME    PIC X(15).                                 
       01 PARM-MIDDLE-NAME   PIC X(15).                                 
       01 PARM-LAST-NAME     PIC X(40).                                 
       01 PARM-SUFFIX        PIC X(03).                                 
       01 PARM-COMPANY-NO    PIC X(10).                                 
       01 PARM-PREMISE-NO    PIC X(10).                                 
       01 PARM-PREMISE-ADDR  PIC X(100).                                
                                                                        
       PROCEDURE DIVISION USING PARM-CUSTOMER-NO,                       
                                PARM-SSN,                               
                                PARM-FIRST-NAME,                        
                                PARM-MIDDLE-NAME,                       
                                PARM-LAST-NAME,                         
                                PARM-SUFFIX,                            
                                PARM-COMPANY-NO,                        
                                PARM-PREMISE-NO,                        
                                PARM-PREMISE-ADDR.                      
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
              SELECT                                                    
                      :S-RETURN-CODE           AS RETURN_CODE           
                     ,:S-E-CUST-FLAG           AS E_CUST_FLAG           
                     ,:S-E-LOGIN-FLAG          AS E_LOGIN_FLAG          
                     ,:S-CUSTOMER-NO           AS CUSTOMER_NO           
                     ,:S-CUST-FLAG             AS CUST_FLAG             
                     ,:S-CUST-SSN-FLAG         AS CUST_SSN_FLAG         
                     ,:S-ACCOUNT-NOS           AS ACCOUNT_NOS           
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT                                                            
MFA-TR*               :S-RETURN-CODE           AS RETURN_CODE                   
MFA-TR*              ,:S-E-CUST-FLAG           AS E_CUST_FLAG                   
MFA-TR*              ,:S-E-LOGIN-FLAG          AS E_LOGIN_FLAG                  
MFA-TR*              ,:S-CUSTOMER-NO           AS CUSTOMER_NO                   
MFA-TR*              ,:S-CUST-FLAG             AS CUST_FLAG                     
MFA-TR*              ,:S-CUST-SSN-FLAG         AS CUST_SSN_FLAG                 
MFA-TR*              ,:S-ACCOUNT-NOS           AS ACCOUNT_NOS                   
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           INITIALIZE RS-RETURN-CODE,                                   
                      RS-E-CUST-FLAG,                                   
                      RS-E-LOGIN-FLAG,                                  
                      RS-CUSTOMER-NO,                                   
                      RS-CUST-FLAG,                                     
                      RS-CUST-SSN-FLAG,                                 
                      RS-ACCOUNT-NOS.                                   
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
            MOVE PARM-CUSTOMER-NO           TO WS-CUSTOMER-NO.          
            MOVE PARM-SSN                   TO WS-SSN.                  
            MOVE PARM-FIRST-NAME            TO WS-FIRST-NAME.           
            MOVE PARM-MIDDLE-NAME           TO WS-MIDDLE-NAME.          
            MOVE PARM-LAST-NAME             TO WS-LAST-NAME.            
            MOVE PARM-SUFFIX                TO WS-SUFFIX.               
            MOVE PARM-COMPANY-NO            TO WS-COMPANY-NO            
                                               AT-COMPANY-NO            
                                               KO-COMPANY-NO.           
            MOVE PARM-PREMISE-NO            TO WS-PREMISE-NO.           
            MOVE PARM-PREMISE-ADDR          TO WS-PREMISE-ADDR.         
            MOVE 'DAY-WEB-NEW-E-CUST'       TO WS-DELINQ-CD.            
            MOVE WS-NAME-FORMAT             TO DQ-NAME-FORMAT.          
            MOVE WS-RED-FLAG-INDD           TO KO-RED-FLAG-IND.         
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
            IF WS-CUSTOMER-NO > 0 THEN                                  
               UNSTRING WS-CUSTOMER-NO DELIMITED BY SPACES INTO         
                                       WS-CUSTOMER-NO-JST               
               MOVE WS-CUSTOMER-NO-JST      TO WS-CUSTOMER-NO           
               MOVE WS-CUSTOMER-NO          TO WS-CUSTOMER-NO-NUM       
               MOVE WS-CUSTOMER-NO-NUM      TO WS-AT-CUSTOMER-NO        
               MOVE WS-AT-CUSTOMER-NO       TO CE-CUSTOMER-NO           
                                               LF-CUSTOMER-NO           
                                               KO-CUSTOMER-NO           
                                               AT-CUSTOMER-NO           
                                                                        
               PERFORM 2005-CUST-NO-EXISTS  THRU 2005-EXIT              
            ELSE                                                        
               IF WS-CUSTOMER-NO = 0 THEN                               
                  MOVE 'Y'                    TO   WS-CUST-SSN-FLAG     
                                                   RS-CUST-SSN-FLAG     
                  PERFORM 2010-CHK-NEW-EXISTS THRU 2010-EXIT            
                  PERFORM 2060-CHK-CUST-VALID THRU 2060-EXIT            
               END-IF                                                   
            END-IF.                                                     
            PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.            
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT.                                              *        
      ******************************************************************        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE              TO S-RETURN-CODE.           
           MOVE RS-E-CUST-FLAG              TO S-E-CUST-FLAG.           
           MOVE RS-E-LOGIN-FLAG             TO S-E-LOGIN-FLAG.          
           MOVE RS-CUSTOMER-NO              TO S-CUSTOMER-NO.           
           MOVE RS-CUST-FLAG                TO S-CUST-FLAG.             
           MOVE RS-CUST-SSN-FLAG            TO S-CUST-SSN-FLAG.         
           MOVE RS-ACCOUNT-NOS              TO S-ACCOUNT-NOS.           
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *2005-CUST-NO-EXISTS                                             *        
      ******************************************************************        
                                                                        
       2005-CUST-NO-EXISTS.                                             
                                                                        
           PERFORM 7005-GET-CUST-DETAILS    THRU 7005-EXIT.             
           MOVE CE-SSN                      TO   WS-SSN.                
           IF WS-SSN NOT = SPACES THEN                                  
              MOVE 'Y'                      TO WS-CUST-SSN-FLAG         
           END-IF.                                                      
                                                                        
           MOVE 70                          TO WS-EMB-LENG              
           STRING DQ-LAST-NAME,                                         
                  ', ',                                                 
                  DQ-FIRST-NAME,                                        
                  ' ',                                                  
                  DQ-MIDDLE-NAME                                        
           DELIMITED BY SIZE INTO WS-EMB-INPUT.                         
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
           MOVE WS-CMP-TABLE TO WS-TEMP-CONTACT-NAME.                   
                                                                        
           UNSTRING WS-TEMP-CONTACT-NAME DELIMITED BY WS-COMMA-MARK     
                  INTO  WS-TEMP-NAME-COMMENT, WS-TEMP-NAME2.            
                                                                        
           INSPECT WS-TEMP-NAME-COMMENT TALLYING                        
                         WS-TEMP-NAME-COMMENT-LEN                       
                   FOR CHARACTERS BEFORE INITIAL '  '.                  
           ADD +1                   TO WS-TEMP-NAME-COMMENT-LEN.        
           MOVE '#' TO                                                  
               WS-TEMP-NAME-COMMENT(WS-TEMP-NAME-COMMENT-LEN:1)         
           MOVE WS-TEMP-NAME-COMMENT       TO WS-TEMP-NAME3.            
                                                                        
           STRING WS-TEMP-NAME3, WS-COMMA-MARK,                         
           WS-TEMP-NAME2  DELIMITED BY '#' INTO WS-CUST-CONTACT-NAME.   
                                                                        
                                                                        
           MOVE WS-CUST-SSN-FLAG            TO RS-CUST-SSN-FLAG.        
                                                                        
           PERFORM 7010-GET-CUST-TYPE-I-B   THRU 7010-EXIT.             
           PERFORM 2040-CHK-CUST-TYPE-I-B   THRU 2040-EXIT.             
           PERFORM 3000-CHECK-ENDV-EXISTS   THRU 3000-EXIT.             
           MOVE WS-CUSTOMER-NO              TO RS-CUSTOMER-NO.          
           MOVE 'Y'                         TO RS-E-CUST-FLAG.          
           MOVE 'Y'                         TO RS-E-LOGIN-FLAG.         
                                                                        
       2005-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *2010-CHK-NEW-EXISTS                                             *        
      *THIS PARA IS USED TO CHECK WHETHER THE CUSTOMER IS EXISTS OR NEW*        
      ******************************************************************        
                                                                        
       2010-CHK-NEW-EXISTS.                                             
                                                                        
           MOVE WS-SSN                           TO CE-SSN.             
           PERFORM 7000-GET-CUST-NEW-EXIST       THRU 7000-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN              
              MOVE CE-CUSTOMER-NO                TO RS-CUSTOMER-NO      
              PERFORM 2020-CHK-CUST-DET          THRU 2020-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 7080-GET-SPOUSE-EXISTS  THRU 7080-EXIT         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN        
                    PERFORM 2020-CHK-CUST-DET    THRU 2020-EXIT         
                 ELSE                                                   
                    PERFORM 8000-CREATE-NEW-CUST THRU 8000-EXIT         
                 END-IF                                                 
              ELSE                                                      
                  NEXT SENTENCE                                         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2015-CHK-ACCT-STAT                                             *        
      * THIS PARA IS USED TO CHECK THE CONDITIONS WHETHER THE CUSTOMER *        
      * IS FINAL BILLED , WRITEOFF OR OTHER                            *        
      ******************************************************************        
                                                                        
       2015-CHK-ACCT-STAT.                                              
                                                                        
           IF WS-ACCT-FINALED-DT = WS-IND-FINALED-DT THEN               
              IF WS-CODE-ACCT-STAT = 'S'                                
                  ADD 1                     TO WS-WRITEOF-ACCT-VAL      
              ELSE                                                      
                  IF WS-CODE-ACCT-STAT = 'B'                            
                     ADD 1                  TO WS-FINAL-BILL-ACCT-VAL   
                  ELSE                                                  
                     ADD 1                  TO WS-OTHER-ACCT-VAL        
                  END-IF                                                
              END-IF                                                    
           ELSE                                                         
              IF WS-CODE-ACCT-STAT = 'S'                                
                 ADD 1                      TO WS-WRITEOF-ACCT-VAL      
              ELSE                                                      
                 IF WS-CODE-ACCT-STAT = 'B'                             
                    INITIALIZE WS-DIFF-VALUE                            
                    PERFORM 7070-CAL-DIFF-DAYS THRU 7070-EXIT           
                    IF WS-DIFF-VALUE > WS-DELINQ-VALUE THEN             
                       ADD 1                TO WS-DIF-CDATE-VALUE       
                    ELSE                                                
                      PERFORM 2065-PROCESS-FINAL-WO-ACCTS THRU 2065-EXIT
                    END-IF                                              
                    ADD 1                   TO WS-F-B-ACCT-VAL          
                 ELSE                                                   
                    ADD 1                   TO WS-OTHER-ACCT-VAL        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7050-FETCH-CODE-ACCT-CUR THRU 7050-EXIT.             
                                                                        
       2015-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2020-CHK-CUST-DET                                              *        
      * THIS PARA IS USED TO CHECK WHETHER THE CUSTOMER IS VALID       *        
      * CUSTOMER OR NOT                                                *        
      ******************************************************************        
                                                                        
       2020-CHK-CUST-DET.                                               
                                                                        
           MOVE DQ-FIRST-NAME               TO WS-EXISTS-FIRST-NAME.    
           MOVE DQ-LAST-NAME                TO WS-EXISTS-LAST-NAME.     
           MOVE DQ-MIDDLE-NAME              TO WS-EXISTS-MIDDLE-NAME.   
           MOVE 70                          TO WS-EMB-LENG              
           STRING WS-EXISTS-LAST-NAME,                                  
                  ', ',                                                 
                  WS-EXISTS-FIRST-NAME,                                 
                  ' ',                                                  
                  WS-EXISTS-MIDDLE-NAME                                 
           DELIMITED BY SIZE INTO WS-EMB-INPUT.                         
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
           MOVE WS-CMP-TABLE TO WS-TEMP-CONTACT-NAME.                   
                                                                        
           UNSTRING WS-TEMP-CONTACT-NAME DELIMITED BY WS-COMMA-MARK     
                  INTO  WS-TEMP-NAME-COMMENT, WS-TEMP-NAME2.            
                                                                        
           INSPECT WS-TEMP-NAME-COMMENT TALLYING                        
                         WS-TEMP-NAME-COMMENT-LEN                       
                   FOR CHARACTERS BEFORE INITIAL '  '.                  
           ADD +1                          TO WS-TEMP-NAME-COMMENT-LEN. 
           MOVE '#'                        TO                           
               WS-TEMP-NAME-COMMENT(WS-TEMP-NAME-COMMENT-LEN:1)         
                                                                        
           MOVE WS-TEMP-NAME-COMMENT       TO WS-TEMP-NAME3.            
           STRING WS-TEMP-NAME3, WS-COMMA-MARK,                         
           WS-TEMP-NAME2  DELIMITED BY '#' INTO WS-CUST-CONTACT-NAME.   
                                                                        
           MOVE CE-EBILL-REGISTER-IND       TO WS-EBILL-REGISTER-IND.   
           MOVE CE-CUSTOMER-TYPE            TO WS-CUSTOMER-TYPE.        
           MOVE CE-CUSTOMER-NO              TO WS-CUSTOMER-NO.          
                                                                        
           IF WS-FIRST-NAME = WS-EXISTS-FIRST-NAME AND                  
              WS-LAST-NAME  = WS-EXISTS-LAST-NAME  THEN                 
              IF WS-CUSTOMER-TYPE = 'S' THEN                            
                 PERFORM 8000-CREATE-NEW-CUST      THRU 8000-EXIT       
              ELSE                                                      
                 IF WS-CUSTOMER-TYPE = 'C' THEN                         
                    MOVE WS-CUSTOMER-NO            TO WS-CUSTOMER-NO-NUM
                    MOVE WS-CUSTOMER-NO-NUM        TO WS-AT-CUSTOMER-NO 
                    MOVE WS-AT-CUSTOMER-NO         TO LF-CUSTOMER-NO    
                                                      KO-CUSTOMER-NO    
                                                      AT-CUSTOMER-NO    
                    PERFORM 7010-GET-CUST-TYPE-I-B THRU 7010-EXIT       
                    PERFORM 2040-CHK-CUST-TYPE-I-B THRU 2040-EXIT       
                    PERFORM 3000-CHECK-ENDV-EXISTS THRU 3000-EXIT       
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF WS-CUSTOMER-TYPE = 'S' THEN                            
                 MOVE WS-SPOUSE-NOT-VALID   TO RS-RETURN-CODE           
              ELSE                                                      
                 IF WS-CUSTOMER-TYPE = 'C' THEN                         
                    MOVE WS-CUST-NOT-VALID  TO RS-RETURN-CODE           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2025-CHK-ELOGIN                                                *        
      * THIS PARA IS USED CHECK THE CONDITION TO FINALIZE WHETHER THE  *        
      * THE CUSTOMER IS HAVING E-LOGIN FACILITY OR NOT                 *        
      ******************************************************************        
                                                                        
       2025-CHK-ELOGIN.                                                 
                                                                        
           IF WS-WRITEOF-ACCT-VAL > WS-TEMP-VAL THEN                    
              MOVE 'P'                      TO RS-E-LOGIN-FLAG          
           ELSE                                                         
              IF WS-FINAL-BILL-ACCT-VAL > WS-TEMP-VAL THEN              
                 MOVE 'Y'                   TO RS-E-LOGIN-FLAG          
              ELSE                                                      
                 IF WS-F-B-ACCT-VAL   = WS-TEMP-VAL AND                 
                    WS-OTHER-ACCT-VAL > WS-TEMP-VAL                     
                    MOVE 'Y'                TO RS-E-LOGIN-FLAG          
                 ELSE                                                   
                    IF WS-DIF-CDATE-VALUE = WS-F-B-ACCT-VAL THEN        
                       MOVE 'P'             TO RS-E-LOGIN-FLAG          
                    ELSE                                                
                       MOVE 'Y'             TO RS-E-LOGIN-FLAG          
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2025-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * 2035-INS-COMM-DATA.                                           *         
      ******************************************************************        
       2035-INS-COMM-DATA.                                              
                                                                        
            PERFORM 7260-GET-TIME-STAMP     THRU 7260-EXIT.             
            MOVE WS-AT-CUSTOMER-NO          TO WS-COMM-CUST-NO.         
            MOVE 0                          TO WS-COMM-ACCT-NO.         
            MOVE WS-PREMISE-NO              TO WS-COMM-PREM-NO.         
            MOVE WS-COMPANY-NO              TO WS-COMM-COMPANY-NO.      
            MOVE 'Z'                        TO WS-COMM-METHOD.          
            MOVE 'I'                        TO WS-COMM-DIRECTION.       
            MOVE '41'                       TO WS-COMM-TYPE-CD.         
            MOVE '10'                       TO WS-COMM-SUBTYPE-CODE.    
            MOVE 'C'                        TO WS-COMM-ASSOC-CD.        
            IF WS-ITPA-RSLT-CURR-CD-FLAG = 'Y' THEN                     
               STRING WS-COMM-COMM-TEXT1,                               
                  WS-PREMISE-ADDR-TEXT(1:WS-PREMISE-ADDR-LEN)           
                  DELIMITED BY SIZE  INTO WS-COMM-COMM-TEXT             
            ELSE                                                        
               IF WS-RED-FLAG-IND = 'Y' THEN                            
                  STRING WS-COMM-COMM-TEXT4,                            
                         WS-PREMISE-ADDR-TEXT(1:WS-PREMISE-ADDR-LEN)    
                         DELIMITED BY SIZE  INTO WS-COMM-COMM-TEXT      
               ELSE                                                     
                  STRING WS-COMM-COMM-TEXT3,                            
                         WS-PREMISE-ADDR-TEXT(1:WS-PREMISE-ADDR-LEN)    
                         DELIMITED BY SIZE  INTO WS-COMM-COMM-TEXT      
               END-IF                                                   
            END-IF.                                                     
            MOVE WS-COMM-COMM-TEXT          TO WS-COMM-INITIAL-COMMENT. 
            MOVE 'WEBTRN1'                  TO WS-USER-ID-ORIG.         
            MOVE WS-CUST-CONTACT-NAME       TO WS-CONTACT-NAME.         
            PERFORM 8100-INSERT-COMM-DATA   THRU 8100-EXIT.             
      *                                                                         
       2035-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2040-CHK-CUST-TYPE-I-B                                         *        
      * THIS PARA IS USED TO CHECK WHETHER THE CUSTOMER IS INDIVIDUAL  *        
      * OR BUSINESS                                                    *        
      ******************************************************************        
                                                                        
       2040-CHK-CUST-TYPE-I-B.                                          
                                                                        
                                                                        
           IF WS-CUST-IND-BIS-FLAG NOT = 'N' THEN                       
              PERFORM 7041-GET-ITPA-EXISTS        THRU 7041-EXIT        
              PERFORM 2041-CHECK-ITPA-EXISTS      THRU 2041-EXIT        
              IF WS-ITPA-RSLT-CURR-CD-FLAG NOT = 'Y' THEN               
                 PERFORM 7042-GET-RED-FLAG        THRU 7042-EXIT        
                 PERFORM 2042-CHECK-RED-FLAG      THRU 2042-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CUST-IND-BIS-FLAG = 'N' THEN                           
              MOVE WS-CUST-TYPE-IB             TO RS-RETURN-CODE        
           ELSE                                                         
              PERFORM 2050-CHECK-RES-EXISTS    THRU 2050-EXIT           
              IF WS-CUST-RES-FLAG = 'N' THEN                            
                 MOVE WS-CUST-TYPE-RO          TO RS-RETURN-CODE        
              ELSE                                                      
                 IF WS-ITPA-RSLT-CURR-CD-FLAG = 'Y' THEN                
                    MOVE WS-ITPA-RSLT-CURR-RETURN-CD TO RS-RETURN-CODE  
                    PERFORM 2035-INS-COMM-DATA       THRU 2035-EXIT     
                 ELSE                                                   
                    IF WS-RED-FLAG-IND = 'Y' THEN                       
                       MOVE WS-RED-FLAG-RETURN-CODE  TO RS-RETURN-CODE  
                       PERFORM 2035-INS-COMM-DATA    THRU 2035-EXIT     
                    ELSE                                                
                       MOVE WS-CUSTOMER-EXISTS       TO RS-CUST-FLAG    
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2040-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2041-CHECK-ITPA-EXISTS                                         *        
      * THIS PARA IS USED TO CHECK CUSTOMER IS RESIDENTIAL OR OTHER    *        
      ******************************************************************        
       2041-CHECK-ITPA-EXISTS.                                          
                                                                        
            IF WS-ACTIVE-RETURN-CODE = 0 THEN                           
               MOVE LF-ITPA-RSLT-CURR-CD TO WS-ITPA-RSLT-CURR-CD        
               IF WS-ITPA-RSLT-CURR-CD NOT = 'R' THEN                   
                  MOVE 'Y'               TO WS-ITPA-RSLT-CURR-CD-FLAG   
               END-IF                                                   
            END-IF.                                                     
                                                                        
       2041-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2042-CHECK-RED-FLAG                                            *        
      * THIS PARA IS USED TO CHECK CUSTOMER HAS RED FLAG OR NOT        *        
      ******************************************************************        
       2042-CHECK-RED-FLAG.                                             
                                                                        
            IF WS-ACTIVE-RETURN-CODE = 0 THEN                           
                  MOVE 'Y'               TO WS-RED-FLAG-IND             
            END-IF.                                                     
                                                                        
       2042-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2050-CHECK-RES-EXISTS                                          *        
      * THIS PARA IS USED TO CHECK CUSTOMER IS RESIDENTIAL OR OTHER    *        
      ******************************************************************        
       2050-CHECK-RES-EXISTS.                                           
                                                                        
           PERFORM 7020-CHK-CUST-RES-BUS    THRU 7020-EXIT              
           IF WS-ACCOUNT-EXISTS = 'Y' THEN                              
              PERFORM 7090-GET-CUST-TYPE-RES   THRU 7090-EXIT           
              IF WS-ACTIVE-RETURN-CODE NOT = 0 THEN                     
                 MOVE 'N'                      TO WS-CUST-RES-FLAG      
              END-IF                                                    
           ELSE                                                         
      ***FOR PEND\NO ACCOUNTS, WE DON'T HAVE ACCOUNT DETAILS AS OF NOW          
              MOVE 'Y'                      TO WS-CUST-RES-FLAG         
           END-IF.                                                      
                                                                        
       2050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2060-CHK-CUST-VALID                                            *        
      * THIS PARA IS USED TO CHECK WHETHER THE CUSTOMER EXISTS IS VALID*        
      * CUSTOMER OR NOT                                                *        
      ******************************************************************        
                                                                        
       2060-CHK-CUST-VALID.                                             
                                                                        
           INITIALIZE WS-CODE-ACCT-STAT.                                
           IF RS-CUST-FLAG = WS-CUSTOMER-EXISTS THEN                    
              PERFORM 7270-OPEN-ACCT-ACTIVE-PEND-CUR  THRU 7270-EXIT    
              PERFORM 7280-FETCH-ACTIVE-PEND-CUR      THRU 7280-EXIT    
              PERFORM 2069-PROCESS-ACTIVE-PEND-CUR    THRU 2069-EXIT    
                                      UNTIL NO-ACCT-ACTIVE-PEND-ROWS    
              PERFORM 7290-CLOSE-ACTIVE-PEND-CUR      THRU 7290-EXIT    
              PERFORM 2070-CHK-EBIL-TYPE              THRU 2070-EXIT    
              MOVE WS-ACCOUNTT-NO                     TO RS-ACCOUNT-NOS 
           ELSE                                                         
              MOVE 'N'                          TO RS-E-CUST-FLAG       
              MOVE 'N'                          TO RS-E-LOGIN-FLAG      
           END-IF.                                                      
                                                                        
       2060-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * 2065-PROCESS-FINAL-WO-ACCTS                                    *        
      * THIS PARA IS USED TO PROCESS ACCOUNTS WHETHER FINAL OR WRITEOFF*        
      * FOR THE CUSTOMER                                               *        
      ******************************************************************        
                                                                        
       2065-PROCESS-FINAL-WO-ACCTS.                                     
                                                                        
            MOVE WS-ACCOUNT-NO-COMP3            TO WS-ACCOUNT-NO-NUM.   
            MOVE WS-ACCOUNT-NO-NUM              TO WS-ACCOUNT-NO.       
                                                                        
            STRING WS-CODE-ACCT-STAT, WS-ACCOUNT-NO, WS-SEMI-COLON      
                        DELIMITED BY SPACE INTO WS-TEMP-ACCOUNT-NO.     
            STRING WS-ACCOUNTT-NO, WS-TEMP-ACCOUNT-NO                   
                        DELIMITED BY SPACE INTO  WS-ACCOUNTT-NO.        
                                                                        
       2065-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2069-PROCESS-ACTIVE-PEND-CUR                                   *        
      * THIS PARA IS USED TO PROCESS ACCOUNTS WHETHER ACTIVE OR PENDING*        
      * FOR THE CUSTOMER                                               *        
      ******************************************************************        
                                                                        
       2069-PROCESS-ACTIVE-PEND-CUR.                                    
                                                                        
            MOVE WS-ACCOUNT-NO-COMP3            TO WS-ACCOUNT-NO-NUM.   
            MOVE WS-ACCOUNT-NO-NUM              TO WS-ACCOUNT-NO.       
                                                                        
            STRING WS-CODE-ACCT-STAT, WS-ACCOUNT-NO, WS-SEMI-COLON      
                        DELIMITED BY SPACE INTO WS-TEMP-ACCOUNT-NO.     
            STRING WS-ACCOUNTT-NO, WS-TEMP-ACCOUNT-NO                   
                        DELIMITED BY SPACE INTO  WS-ACCOUNTT-NO.        
                                                                        
            PERFORM 7280-FETCH-ACTIVE-PEND-CUR THRU 7280-EXIT.          
                                                                        
       2069-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2070-CHK-EBIL-TYPE                                             *        
      * THIS PARA IS USED TO CHECK WHETHER THE CUSTOMER EXISTS IS      *        
      * HAVING EBILL FACILITY OR NOT                                   *        
      ******************************************************************        
                                                                        
       2070-CHK-EBIL-TYPE.                                              
                                                                        
           IF WS-EBILL-REGISTER-IND = 'Y' THEN                          
              MOVE 'Y'                      TO RS-E-CUST-FLAG           
           ELSE                                                         
              MOVE WS-CUSTOMER-NO           TO RS-CUSTOMER-NO           
              MOVE 'N'                      TO RS-E-CUST-FLAG           
              MOVE 'N'                      TO RS-E-LOGIN-FLAG          
           END-IF.                                                      
           MOVE WS-COMPANY-NO            TO C8-COMPANY-NO.              
           MOVE WS-DELINQ-CD             TO C8-DELINQ-CD.               
           PERFORM 2080-CAL-DELINQ-VAL   THRU 2080-EXIT.                
                                                                        
       2070-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2080-CAL-DELINQ-VAL                                            *        
      * THIS PARA IS USED TO CHECK THE DELINQ-VALUE                    *        
      ******************************************************************        
                                                                        
       2080-CAL-DELINQ-VAL.                                             
                                                                        
           PERFORM 7030-GET-DEL-VAL         THRU 7030-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DELINQ-VALUE.         
           PERFORM 2090-CURSOR-PROCESS      THRU 2090-EXIT.             
                                                                        
       2080-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2090-CURSOR-PROCESS                                            *        
      * THIS PARA IS USED TO DO THE PROCESS TO CHECK THE CUSTOMER IS   *        
      * VALID CUSTOMER OR NOT                                          *        
      ******************************************************************        
                                                                        
       2090-CURSOR-PROCESS.                                             
                                                                        
           PERFORM 7040-OPEN-CODE-ACCT-CUR     THRU 7040-EXIT.          
           PERFORM 7050-FETCH-CODE-ACCT-CUR    THRU 7050-EXIT.          
           PERFORM 2015-CHK-ACCT-STAT          THRU 2015-EXIT           
                                               UNTIL NO-CODE-ACCT-ROWS. 
           IF WS-EBILL-REGISTER-IND = 'Y' THEN                          
              PERFORM 2025-CHK-ELOGIN          THRU 2025-EXIT           
           END-IF.                                                      
           PERFORM 7060-CLOSE-CODE-ACCT-CUR    THRU 7060-EXIT.          
           MOVE WS-CUSTOMER-NO                 TO RS-CUSTOMER-NO.       
                                                                        
       2090-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 3000-CHECK-ENDV-EXISTS                                         *        
      * THIS PARA IS USED TO CHECK CUSTOMER ACCOUNT IS ENDV COMPLIANT  *        
      ******************************************************************        
       3000-CHECK-ENDV-EXISTS.                                          
                                                                        
           PERFORM 7040-OPEN-CODE-ACCT-CUR     THRU 7040-EXIT.          
           PERFORM 7050-FETCH-CODE-ACCT-CUR    THRU 7050-EXIT.          
           PERFORM 3010-CHK-ACCT-ENDV          THRU 3010-EXIT           
                                               UNTIL NO-CODE-ACCT-ROWS. 
           PERFORM 7060-CLOSE-CODE-ACCT-CUR    THRU 7060-EXIT.          
           MOVE 'N'                         TO WS-CODE-ACCT-ROWS.       
                                                                        
           IF WS-ENDV-FLAG-IND = 'Y' THEN                               
              MOVE WS-ENDV-FLAG-RETURN-CODE TO RS-RETURN-CODE           
              PERFORM 2035-INS-COMM-DATA    THRU 2035-EXIT              
           END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 3010-CHK-ACCT-ENDV                                                      
      * THIS PARA IS USED TO CHECK CUSTOMER ACCOUNT IS ENDV COMPLIANT  *        
      ******************************************************************        
       3010-CHK-ACCT-ENDV.                                              
                                                                        
           PERFORM 7043-GET-ENDV-FLAG          THRU 7043-EXIT.          
           IF WS-ENDV-FLAG-IND = 'Y' THEN                               
              MOVE 'Y'                         TO WS-CODE-ACCT-ROWS     
           ELSE                                                         
              PERFORM 7050-FETCH-CODE-ACCT-CUR THRU 7050-EXIT           
           END-IF.                                                      
                                                                        
       3010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7000-GET-CUST-NEW-EXIST                                        *        
      * THIS PARA IS USED TO SELECT THE VALUES FOR THE CORRESPONDING   *        
      * VALUES GIVE BY THE CUSTOMER                                    *        
      ******************************************************************        
                                                                        
       7000-GET-CUST-NEW-EXIST.                                         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) DQ.FIRST_NAME,
              DQ.LAST_NAME,
              DQ.MIDDLE_NAME,
              DQ.FULL_NAME,
              CE.EBILL_REGISTER_IND,
              CE.CUSTOMER_TYPE,
              CE.CUSTOMER_NO                                   
                  INTO :DQ-FIRST-NAME,                                  
                       :DQ-LAST-NAME,                                   
                       :DQ-MIDDLE-NAME,                                 
                       :DQ-FULL-NAME,                                   
                       :CE-EBILL-REGISTER-IND,                          
                       :CE-CUSTOMER-TYPE,                               
                       :CE-CUSTOMER-NO                                  
                  FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                 
                       CSS_NAME DQ WITH(READUNCOMMITTED),                       
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                 WHERE CE.SSN           = :CE-SSN                       
                   AND CE.CUSTOMER_TYPE = 'C'                           
                   AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                
                   AND CE.NAME_ID       = HT.NAME_ID                    
                   AND HT.NAME_ID       = DQ.NAME_ID                    
                                                 
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DQ.FIRST_NAME,                                           
MFA-TR*                DQ.LAST_NAME,                                            
MFA-TR*                DQ.MIDDLE_NAME,                                          
MFA-TR*                DQ.FULL_NAME,                                            
MFA-TR*                CE.EBILL_REGISTER_IND,                                   
MFA-TR*                CE.CUSTOMER_TYPE,                                        
MFA-TR*                CE.CUSTOMER_NO                                           
MFA-TR*           INTO :DQ-FIRST-NAME,                                          
MFA-TR*                :DQ-LAST-NAME,                                           
MFA-TR*                :DQ-MIDDLE-NAME,                                         
MFA-TR*                :DQ-FULL-NAME,                                           
MFA-TR*                :CE-EBILL-REGISTER-IND,                                  
MFA-TR*                :CE-CUSTOMER-TYPE,                                       
MFA-TR*                :CE-CUSTOMER-NO                                          
MFA-TR*           FROM CSS_CUST_STATS CE,                                       
MFA-TR*                CSS_NAME DQ,                                             
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*          WHERE CE.SSN           = :CE-SSN                               
MFA-TR*            AND CE.CUSTOMER_TYPE = 'C'                                   
MFA-TR*            AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                        
MFA-TR*            AND CE.NAME_ID       = HT.NAME_ID                            
MFA-TR*            AND HT.NAME_ID       = DQ.NAME_ID                            
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7000                                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
              MOVE 'CSS_NAME'                TO TABLE-2                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-3                 
              MOVE 'SSN'                     TO TABLE-ELEMENT-1         
              MOVE WS-SSN                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7005-GET-CUST-DETAILS                                          *        
      * THIS PARA IS USED TO SELECT THE VALUES FOR THE CORRESPONDING   *        
      * VALUES GIVE BY THE CUSTOMER                                    *        
      ******************************************************************        
       7005-GET-CUST-DETAILS.                                           
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) DQ.FULL_NAME,
              DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              CE.CUSTOMER_TYPE,
              CE.SSN                                           
                  INTO :DQ-FULL-NAME,                                   
                       :DQ-FIRST-NAME,                                  
                       :DQ-MIDDLE-NAME,                                 
                       :DQ-LAST-NAME,                                   
                       :CE-CUSTOMER-TYPE,                               
                       :CE-SSN                                          
                  FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                 
                       CSS_NAME DQ WITH(READUNCOMMITTED),                       
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                 WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO               
                   AND CE.CUSTOMER_TYPE = 'C'                           
                   AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                
                   AND CE.NAME_ID       = HT.NAME_ID                    
                   AND HT.NAME_ID       = DQ.NAME_ID                    
                                                 
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DQ.FULL_NAME,                                            
MFA-TR*                DQ.FIRST_NAME,                                           
MFA-TR*                DQ.MIDDLE_NAME,                                          
MFA-TR*                DQ.LAST_NAME,                                            
MFA-TR*                CE.CUSTOMER_TYPE,                                        
MFA-TR*                CE.SSN                                                   
MFA-TR*           INTO :DQ-FULL-NAME,                                           
MFA-TR*                :DQ-FIRST-NAME,                                          
MFA-TR*                :DQ-MIDDLE-NAME,                                         
MFA-TR*                :DQ-LAST-NAME,                                           
MFA-TR*                :CE-CUSTOMER-TYPE,                                       
MFA-TR*                :CE-SSN                                                  
MFA-TR*           FROM CSS_CUST_STATS CE,                                       
MFA-TR*                CSS_NAME DQ,                                             
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*          WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                       
MFA-TR*            AND CE.CUSTOMER_TYPE = 'C'                                   
MFA-TR*            AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                        
MFA-TR*            AND CE.NAME_ID       = HT.NAME_ID                            
MFA-TR*            AND HT.NAME_ID       = DQ.NAME_ID                            
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7005                                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7005'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
              MOVE 'CSS_NAME'                TO TABLE-2                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-3                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7010-GET-CUST-TYPE-I-B                                         *        
      * THIS PARA USED TO SELECT WHETHER THE EXISTS CUSTOMER IS        *        
      * INDIVIDUAL OR BUSINESS                                         *        
      ******************************************************************        
                                                                        
       7010-GET-CUST-TYPE-I-B.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CUST-IND-BIS-FLAG                              
                FROM CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
               WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                 
                 AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE               
                 AND CE.NAME_ID       = DQ.NAME_ID                      
                 AND DQ.NAME_FORMAT   = :DQ-NAME-FORMAT                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CUST-IND-BIS-FLAG                                      
MFA-TR*         FROM CSS_NAME DQ,                                               
MFA-TR*              CSS_CUST_STATS CE                                          
MFA-TR*        WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                         
MFA-TR*          AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                       
MFA-TR*          AND CE.NAME_ID       = DQ.NAME_ID                              
MFA-TR*          AND DQ.NAME_FORMAT   = :DQ-NAME-FORMAT                         
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7010                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_NAME'                TO TABLE-1                 
              MOVE 'CSS_CUST_STATS'          TO TABLE-2                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE 'CUSTOMER-TYPE'           TO TABLE-ELEMENT-2         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              MOVE WS-CUSTOMER-TYPE          TO HOSTVAR-ELEMENT-2       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-CHK-CUST-RES-BUS                                          *        
      * THIS PARA USED TO SELECT WHETHER ACCOUNT EXISTS FOR CUSTOMER   *        
      ******************************************************************        
                                                                        
       7020-CHK-CUST-RES-BUS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-ACCOUNT-EXISTS                                 
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                   
                 AND AT.COMPANY_NO  = :AT-COMPANY-NO                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ACCOUNT-EXISTS                                         
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                           
MFA-TR*          AND AT.COMPANY_NO  = :AT-COMPANY-NO                            
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7020                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE 'COMPANY-NO'              TO TABLE-ELEMENT-2         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-GET-DEL-VAL                                               *        
      * THIS PARA IS USED TO SELECT THE DELINQ-VALUE FOR THE DELINQ-CD *        
      ******************************************************************        
                                                                        
       7030-GET-DEL-VAL.                                                
                                                                        
            EXEC SQL                                                    
                 SELECT DELINQ_VALUE                                    
                   INTO :C8-DELINQ-VALUE                                
                   FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                
                  WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                   
                    AND C8.COMPANY_NO = :C8-COMPANY-NO                  
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT DELINQ_VALUE                                            
MFA-TR*            INTO :C8-DELINQ-VALUE                                        
MFA-TR*            FROM CSS_DELINQUENCY C8                                      
MFA-TR*           WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                           
MFA-TR*             AND C8.COMPANY_NO = :C8-COMPANY-NO                          
MFA-TR*             WITH UR                                                     
MFA-TR*          QUERYNO 7030                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SQLCODE       TO RS-RETURN-CODE                   
                 MOVE 0             TO C8-DELINQ-VALUE                  
              ELSE                                                      
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '7030'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'SELECT'                  TO ABEND-FUNCTION       
                 MOVE 'CSS_DELINQUENCY'         TO TABLE-1              
                 MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1      
                 MOVE WS-DELINQ-CD              TO HOSTVAR-ELEMENT-1    
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
       7030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7040-OPEN-CODE-ACCT-CUR                                        *        
      * THIS PARA IS USED TO OPEN THE CODE-ACCT-CUR                    *        
      ******************************************************************        
                                                                        
       7040-OPEN-CODE-ACCT-CUR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN CODE-ACCT-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7041-GET-ITPA-EXISTS                                           *        
      * THIS PARA IS USED TO SELECT THE ITPA-VALUE FOR THE CUSTOMER    *        
      ******************************************************************        
                                                                        
       7041-GET-ITPA-EXISTS.                                            
                                                                        
            EXEC SQL                                                    
                 SELECT TOP(1) ITPA_RSLT_CURR_CD                               
                   INTO :LF-ITPA-RSLT-CURR-CD                           
                   FROM CSS_CRED_ITPA_HIST LF WITH(READUNCOMMITTED)             
                  WHERE LF.CUSTOMER_NO = :LF-CUSTOMER-NO                
                  ORDER BY LF.CR_HIST_TRAN_DT DESC                      
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT ITPA_RSLT_CURR_CD                                       
MFA-TR*            INTO :LF-ITPA-RSLT-CURR-CD                                   
MFA-TR*            FROM CSS_CRED_ITPA_HIST LF                                   
MFA-TR*           WHERE LF.CUSTOMER_NO = :LF-CUSTOMER-NO                        
MFA-TR*           ORDER BY LF.CR_HIST_TRAN_DT DESC                              
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*            WITH UR                                                      
MFA-TR*          QUERYNO 7041                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7041'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CRED_ITPA_HIST'      TO TABLE-1                 
              MOVE 'LF-CUSTOMER-NO'          TO TABLE-ELEMENT-1         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
                                                                        
       7041-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7042-GET-RED-FLAG                                              *        
      * THIS PARA IS USED TO SELECT THE RED-FLAG FOR THE CUSTOMER      *        
      ******************************************************************        
                                                                        
       7042-GET-RED-FLAG.                                               
                                                                        
            EXEC SQL                                                    
                 SELECT TOP(1) RED_FLAG_IND                                    
                   INTO :KO-RED-FLAG-IND                                
                   FROM CSS_COMM_DATA  KO WITH(READUNCOMMITTED)                 
                  WHERE KO.CUSTOMER_NO = :KO-CUSTOMER-NO                
                    AND KO.COMPANY_NO  = :KO-COMPANY-NO                 
                    AND RED_FLAG_IND   = :KO-RED-FLAG-IND               
                    AND (KO.RED_FLAG_EXPIRE_DT > CIS.CURRENT$TIMESTAMP()      
                    OR KO.RED_FLAG_EXPIRE_DT IS NULL)                   
                    ORDER BY KO.RED_FLAG_EXPIRE_DT                      
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT RED_FLAG_IND                                            
MFA-TR*            INTO :KO-RED-FLAG-IND                                        
MFA-TR*            FROM CSS_COMM_DATA  KO                                       
MFA-TR*           WHERE KO.CUSTOMER_NO = :KO-CUSTOMER-NO                        
MFA-TR*             AND KO.COMPANY_NO  = :KO-COMPANY-NO                         
MFA-TR*             AND RED_FLAG_IND   = :KO-RED-FLAG-IND                       
MFA-TR*             AND (KO.RED_FLAG_EXPIRE_DT > CURRENT TIMESTAMP              
MFA-TR*             OR KO.RED_FLAG_EXPIRE_DT IS NULL)                           
MFA-TR*             ORDER BY KO.RED_FLAG_EXPIRE_DT                              
MFA-TR*             FETCH FIRST ROW ONLY                                        
MFA-TR*             WITH UR                                                     
MFA-TR*          QUERYNO 7042                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7042'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_COMM_DATA'           TO TABLE-1                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE 'COMPANY-NO'              TO TABLE-ELEMENT-2         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
                                                                        
       7042-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7043-GET-ENDV-FLAG                                             *        
      * THIS PARA IS USED TO SELECT THE ENDV-FLAG FOR THE CUSTOMER     *        
      ******************************************************************        
                                                                        
       7043-GET-ENDV-FLAG.                                              
                                                                        
            EXEC SQL                                                    
                 SELECT TOP(1) 'Y'                                             
                   INTO :WS-ENDV-FLAG-IND                               
                   FROM CSS_SO_DATA WITH(READUNCOMMITTED)                       
                  WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                 
P00253              AND ORDER_TYPE_CD  IN ('FW019', 'FW016')            
                    AND ORDER_STATE_CD = 'A'                            
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT 'Y'                                                     
MFA-TR*            INTO :WS-ENDV-FLAG-IND                                       
MFA-TR*            FROM CSS_SO_DATA                                             
MFA-TR*           WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                         
MFA-TR*             AND ORDER_TYPE_CD  IN ('FW019', 'FW016')                    
MFA-TR*             AND ORDER_STATE_CD = 'A'                                    
MFA-TR*             FETCH FIRST ROW ONLY                                        
MFA-TR*             WITH UR                                                     
MFA-TR*          QUERYNO 7043                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7043'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ORDER_TYPE_CD'           TO TABLE-ELEMENT-1         
              MOVE 'ORDER_STATE_CD'          TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00253        MOVE 'FW019/FW016'             TO HOSTVAR-ELEMENT-2       
              MOVE 'A'                       TO HOSTVAR-ELEMENT-3       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
                                                                        
       7043-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7050-FETCH-CODE-ACCT-CUR                                       *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM CODE-ACCT-CUR       *        
      ******************************************************************        
                                                                        
       7050-FETCH-CODE-ACCT-CUR.                                        
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      CODE-ACCT-CUR                                     
                 INTO                                                   
                      :WS-CODE-ACCT-STAT                                
                     ,:AT-ACCOUNT-NO                                    
                     ,:WS-ACCT-FINALED-DT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE AT-ACCOUNT-NO            TO WS-ACCOUNT-NO-COMP3
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-CODE-ACCT-ROWS 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7050'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'CSS_ACCOUNT'             TO TABLE-1           
                    MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1   
                    MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1 
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7060-CLOSE-CODE-ACCT-CUR                                       *        
      * THIS PARA IS USED TO CLOSE CODE-ACCT-CUR CURSOR                *        
      ******************************************************************        
                                                                        
       7060-CLOSE-CODE-ACCT-CUR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE CODE-ACCT-CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE          =  SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7070-CAL-DIFF-DAYS                                             *        
      * THIS PARA IS USED TO FIND VALUE BETWEEN FINAL_BILL_DT AND      *        
      * AND CURRENT DATE                                               *        
      ******************************************************************        
                                                                        
       7070-CAL-DIFF-DAYS.                                              
                                                                        
           EXEC SQL                                                     
                SELECT
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) - CIS.DAYS(
              IIF(TRY_CONVERT(DATE, :WS-ACCT-FINALED-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACCT-FINALED-DT
              ) <> 0) OR (LEN(:WS-ACCT-FINALED-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACCT-FINALED-DT
              ), CONVERT(DATE, :WS-ACCT-FINALED-DT) ))
            INTO
              :WS-DIFF-VALUE 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DIFF-VALUE =                                            
MFA-TR*          (DAYS(CURRENT DATE) - DAYS(DATE(:WS-ACCT-FINALED-DT)))         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE          =  SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SYSIBM.SYSDUMMY1'        TO TABLE-1                 
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7080-GET-SPOUSE-EXISTS                                         *        
      * THIS PARA IS USED TO SELECT THE VALUES FOR THE CORRESPONDING   *        
      * VALUES GIVE BY THE CUSTOMER                                    *        
      ******************************************************************        
                                                                        
       7080-GET-SPOUSE-EXISTS.                                          
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) DQ.FIRST_NAME,
              DQ.LAST_NAME,
              CE.EBILL_REGISTER_IND,
              CE.CUSTOMER_TYPE,
              CE.CUSTOMER_NO                                   
                  INTO :DQ-FIRST-NAME,                                  
                       :DQ-LAST-NAME,                                   
                       :CE-EBILL-REGISTER-IND,                          
                       :CE-CUSTOMER-TYPE,                               
                       :CE-CUSTOMER-NO                                  
                  FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                 
                       CSS_NAME DQ WITH(READUNCOMMITTED),                       
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                 WHERE CE.SSN           = :CE-SSN                       
                   AND CE.CUSTOMER_TYPE = 'S'                           
                   AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                
                   AND CE.NAME_ID       = HT.NAME_ID                    
                   AND HT.NAME_ID       = DQ.NAME_ID                    
                                                 
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DQ.FIRST_NAME,                                           
MFA-TR*                DQ.LAST_NAME,                                            
MFA-TR*                CE.EBILL_REGISTER_IND,                                   
MFA-TR*                CE.CUSTOMER_TYPE,                                        
MFA-TR*                CE.CUSTOMER_NO                                           
MFA-TR*           INTO :DQ-FIRST-NAME,                                          
MFA-TR*                :DQ-LAST-NAME,                                           
MFA-TR*                :CE-EBILL-REGISTER-IND,                                  
MFA-TR*                :CE-CUSTOMER-TYPE,                                       
MFA-TR*                :CE-CUSTOMER-NO                                          
MFA-TR*           FROM CSS_CUST_STATS CE,                                       
MFA-TR*                CSS_NAME DQ,                                             
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*          WHERE CE.SSN           = :CE-SSN                               
MFA-TR*            AND CE.CUSTOMER_TYPE = 'S'                                   
MFA-TR*            AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                        
MFA-TR*            AND CE.NAME_ID       = HT.NAME_ID                            
MFA-TR*            AND HT.NAME_ID       = DQ.NAME_ID                            
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*          QUERYNO 7080                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7080'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
              MOVE 'CSS_NAME'                TO TABLE-2                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-3                 
              MOVE 'SSN'                     TO TABLE-ELEMENT-1         
              MOVE WS-SSN                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7090-GET-CUST-TYPE-R-O                                         *        
      * THIS PARA IS USED TO SELECT THE CORRESPONDING VALUES FOR THE   *        
      * RESIDENTIAL('R'), NON-UTILITY('N') OR OTHER CUSTOMER           *        
      ******************************************************************        
                                                                        
       7090-GET-CUST-TYPE-RES.                                          
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-CUST-RES-FLAG                                
                  FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                 
                       CSS_ACCOUNT AT WITH(READUNCOMMITTED),                    
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                 WHERE CE.CUSTOMER_NO    = :CE-CUSTOMER-NO              
                   AND CE.CUSTOMER_TYPE  = :CE-CUSTOMER-TYPE            
                   AND CE.CUSTOMER_NO    = HT.CUSTOMER_NO               
                   AND AT.ACCOUNT_TYPE_CODE IN ('R','N')                
                   AND CE.NAME_ID        = HT.NAME_ID                   
                   AND HT.ACCOUNT_NO     = AT.ACCOUNT_NO                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-CUST-RES-FLAG                                        
MFA-TR*           FROM CSS_CUST_STATS CE,                                       
MFA-TR*                CSS_ACCOUNT AT,                                          
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*          WHERE CE.CUSTOMER_NO    = :CE-CUSTOMER-NO                      
MFA-TR*            AND CE.CUSTOMER_TYPE  = :CE-CUSTOMER-TYPE                    
MFA-TR*            AND CE.CUSTOMER_NO    = HT.CUSTOMER_NO                       
MFA-TR*            AND AT.ACCOUNT_TYPE_CODE IN ('R','N')                        
MFA-TR*            AND CE.NAME_ID        = HT.NAME_ID                           
MFA-TR*            AND HT.ACCOUNT_NO     = AT.ACCOUNT_NO                        
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*          QUERYNO 7090                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7090'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
              MOVE 'CSS_ACCOUNT'             TO TABLE-2                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-3                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE 'CUSTOMER-TYPE'           TO TABLE-ELEMENT-2         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              MOVE WS-CUSTOMER-TYPE          TO HOSTVAR-ELEMENT-2       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * GET CURRENT TIMESTAMP.                                         *        
      ******************************************************************        
      *                                                                         
       7260-GET-TIME-STAMP.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-COMM-TIMESTAMP              
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-COMM-TIMESTAMP = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       7260-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7270-OPEN-ACCT-ACTIVE-PEND-CUR                                 *        
      * THIS PARA IS USED TO OPEN THE ACCT-ACTIVE-PEND-CUR             *        
      ******************************************************************        
                                                                        
       7270-OPEN-ACCT-ACTIVE-PEND-CUR.                                  
                                                                        
           EXEC SQL                                                     
               OPEN ACCT-ACTIVE-PEND-CUR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7270'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE 'CODE-ACCT-STAT'          TO TABLE-ELEMENT-2         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7280-FETCH-ACTIVE-PEND-CUR                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM ACCT-ACTIVE-PEND-CUR*        
      ******************************************************************        
                                                                        
       7280-FETCH-ACTIVE-PEND-CUR.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      ACCT-ACTIVE-PEND-CUR                              
                 INTO                                                   
                      :AT-ACCOUNT-NO                                    
                     ,:AT-CODE-ACCT-STAT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE AT-ACCOUNT-NO            TO WS-ACCOUNT-NO-COMP3
                    MOVE AT-CODE-ACCT-STAT        TO WS-CODE-ACCT-STAT  
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO                   
                                                WS-ACCT-ACTIVE-PEND-ROWS
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7280'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'CSS_ACCOUNT'             TO TABLE-1           
                    MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1   
                    MOVE 'CODE_ACCT_STAT'          TO TABLE-ELEMENT-2   
                    MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1 
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7280-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7290-CLOSE-ACTIVE-PEND-CUR                                     *        
      * THIS PARA IS USED TO CLOSE  ACTIVE-PEND-CUR                    *        
      ******************************************************************        
                                                                        
       7290-CLOSE-ACTIVE-PEND-CUR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE ACCT-ACTIVE-PEND-CUR                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE          =  SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7290'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE 'CODE_ACCT_STAT'          TO TABLE-ELEMENT-2         
              MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7290-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8000-CREATE-NEW-CUST                                           *        
      * THIS PARA IS USED TO CREATE A NEW CUSTOMER                     *        
      ******************************************************************        
                                                                        
       8000-CREATE-NEW-CUST.                                            
                                                                        
            INITIALIZE WS-RET-STATUS                                    
      *     EXEC SQL                                                    
A05317*         CALL CSR04496(:WS-UPDATE-TYPE,                          
A05317*                       ' ',                                      
A05317*                       :WS-COMPANY-NO,                           
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       :WS-FIRST-NAME,                           
A05317*                       :WS-MIDDLE-NAME,                          
A05317*                       :WS-LAST-NAME,                            
A05317*                       :WS-SUFFIX,                               
A05317*                       ' ',                                      
A05317*                       :WS-SSN,                                  
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       'N',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       'N',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       :WS-USER-ID,                              
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ',                                      
A05317*                       ' ')                                      
      *     END-EXEC.                                                   

MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
P00172      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
P00172      IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                     
P00172          MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
P00172          MOVE '8000'                TO ACTIVE-PARAGRAPH          
P00172          MOVE 'CALL'                TO ABEND-FUNCTION            
A05317          MOVE 'CSR04496'            TO TABLE-1                   
P00172          MOVE 'FIRST_NAME'          TO TABLE-ELEMENT-1           
P00172          MOVE WS-FIRST-NAME         TO HOSTVAR-ELEMENT-1         
P00172          MOVE 'LAST_NAME'           TO TABLE-ELEMENT-2           
P00172          MOVE WS-LAST-NAME          TO HOSTVAR-ELEMENT-2         
P00172          MOVE 'WS-ACTIVE-RETURN-CODE' TO TABLE-ELEMENT-3         
P00172          MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-3       
P00172          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
P00172          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
P00172      END-IF.                                                     
                                                                        
      *     EXEC SQL                                                    
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC-RESLTSET)                                          
A05317*        WITH PROCEDURE CSR04496                                  
      *     END-EXEC.                                                   
                                                                        
      *     EXEC SQL                                                    
      *        ALLOCATE C2 CURSOR FOR RESULT SET                        
      *        :LOC-RESLTSET                                            
      *     END-EXEC.                                                   
                                                                        
            EXEC SQL                                                    
               FETCH C2 INTO                                            
                     :WS-RET-STATUS,                                    
                     :WS-NEW-CUSTOMER-NO,                               
                     :WS-CUSTOMER-EST-DATE                              
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE          =    SUCCESSFUL-CALL       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'C2_CURSOR'               TO TABLE-1                 
              MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
              MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
           IF WS-RET-STATUS = ZEROES                                    
              EXEC SQL                                                  
                 COMMIT                                                 
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE 'NEW'                     TO RS-CUST-FLAG            
              MOVE WS-NEW-CUSTOMER-NO        TO RS-CUSTOMER-NO          
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DB2 SP CALL'             TO ABEND-FUNCTION          
A05317        MOVE 'CSR04496'                TO TABLE-1                 
              MOVE 'WS-RET-STATUS'           TO TABLE-ELEMENT-1         
              MOVE WS-RET-STATUS             TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 8100-INSERT-COMM-DATA.                                         *        
      ******************************************************************        
      *                                                                         
       8100-INSERT-COMM-DATA.                                           
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                (                                                       
                     COMMUNICATION_ID                                   
                    ,CUSTOMER_NO                                        
                    ,ACCOUNT_NO                                         
                    ,PREMISE_NO                                         
                    ,COMPANY_NO                                         
                    ,COMM_METHOD                                        
                    ,COMM_DIRECTION                                     
                    ,COMM_TYPE_CD                                       
                    ,COMM_SUBTYPE_CODE                                  
                    ,COMM_ASSOC_CD                                      
                    ,INITIAL_COMMENT_TX                                 
                    ,USER_ID_ORIG                                       
                    ,CONTACT_NAME                                       
                )                                                       
                VALUES                                                  
                (                                                       
                     CIS.CHAR2TIMESTAMP(:WS-COMM-TIMESTAMP)                     
                    ,:WS-COMM-CUST-NO                                   
                    ,:WS-COMM-ACCT-NO                                   
                    ,:WS-COMM-PREM-NO                                   
                    ,:WS-COMM-COMPANY-NO                                
                    ,:WS-COMM-METHOD                                    
                    ,:WS-COMM-DIRECTION                                 
                    ,:WS-COMM-TYPE-CD                                   
                    ,:WS-COMM-SUBTYPE-CODE                              
                    ,:WS-COMM-ASSOC-CD                                  
                    ,:WS-COMM-INITIAL-COMMENT                           
                    ,:WS-USER-ID-ORIG                                   
                    ,:WS-CONTACT-NAME                                   
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*         (                                                               
MFA-TR*              COMMUNICATION_ID                                           
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,COMM_METHOD                                                
MFA-TR*             ,COMM_DIRECTION                                             
MFA-TR*             ,COMM_TYPE_CD                                               
MFA-TR*             ,COMM_SUBTYPE_CODE                                          
MFA-TR*             ,COMM_ASSOC_CD                                              
MFA-TR*             ,INITIAL_COMMENT_TX                                         
MFA-TR*             ,USER_ID_ORIG                                               
MFA-TR*             ,CONTACT_NAME                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :WS-COMM-TIMESTAMP                                         
MFA-TR*             ,:WS-COMM-CUST-NO                                           
MFA-TR*             ,:WS-COMM-ACCT-NO                                           
MFA-TR*             ,:WS-COMM-PREM-NO                                           
MFA-TR*             ,:WS-COMM-COMPANY-NO                                        
MFA-TR*             ,:WS-COMM-METHOD                                            
MFA-TR*             ,:WS-COMM-DIRECTION                                         
MFA-TR*             ,:WS-COMM-TYPE-CD                                           
MFA-TR*             ,:WS-COMM-SUBTYPE-CODE                                      
MFA-TR*             ,:WS-COMM-ASSOC-CD                                          
MFA-TR*             ,:WS-COMM-INITIAL-COMMENT                                   
MFA-TR*             ,:WS-USER-ID-ORIG                                           
MFA-TR*             ,:WS-CONTACT-NAME                                           
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_COMM_DATA'          TO  TABLE-1                 
              MOVE 'CUSTOMER_NO'            TO  TABLE-ELEMENT-1         
              MOVE 'PREMISE_NO'             TO  TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'             TO  TABLE-ELEMENT-3         
              MOVE WS-COMM-CUST-NO          TO  HOSTVAR-ELEMENT-1       
              MOVE WS-COMM-PREM-NO          TO  HOSTVAR-ELEMENT-2       
              MOVE WS-COMM-COMPANY-NO       TO  HOSTVAR-ELEMENT-3       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      * COPYBOOK                                                                
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  REDUCE-EMBEDDED SPACES                                        *        
      ******************************************************************        
                                                                        
       COPY CPD00004.                                                           
      *                                                                         
