       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04026.                                     
COB303 DATE-WRITTEN.                                                    
COB303            SEPTEMBER 10, 2007.                                   
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                 P R O G R A M  S U M M A R Y                            
      *                                                                         
C32257*  THIS PROGRAM UPDATES LATITUDE AND LONGITUDE ON                         
      *  CSS_MTRD_ENVRNMT FOR AN ACCOUNT.                                       
      *                                                                         
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  09/10/07    FMB      CREATED.                                 *        
C36689*  01/04/08    FMB      USE ACCOUNT_NO_PRIOR.                    *        
C37538*  08/06/08    FMB      CORRECTED S0C7 ABEND.                    *        
P00575*  08/18/10    FMB      UPDATE LAT/LONG ON CSS_PREMISE IF NO ROW *        
P00575*                       ON CSS_MTRD_ENVRNMT                      *        
A03345*  07/11/11    FMB      UPDATE LAT/LONG ON CSS_PREMISE EVEN IF   *        
A03345*                       ROW ON CSS_MTRD_ENVRNMT                  *        
A04527*  06/07/13    MR7E794  REMOVED UNUSED COPYBOOK CWS00056.        *        
A05317*  11/15/16    FMB      REMOVE REFERENCES TO MN LAT/LONG.        *        
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04026'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04026 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
       COPY CCA00001.                                                           
            EXEC SQL                                                            
               INCLUDE CWSX0010                                                 
            END-EXEC.                                                           
       COPY CWS00027.                                                           
       COPY CWS00303.                                                           
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04026'.     
           05  WS-TRAN-APPL-NO          PIC 9(02) VALUE 0.              
           05  WS-SERV-ORDER-NO         PIC 9(13) VALUE 0.              
           05  WS-PARSE-LAT-LONG.                                       
               10  WS-SIGN              PIC X(01).                      
               10  WS-DDD               PIC X(03).                      
               10  WS-PERIOD            PIC X(01).                      
               10  WS-HHMMSS            PIC X(06).                      
           05  WS-DDD-NUM               PIC 9(03).                      
           05  WS-HHMMSS-NUM            PIC 9(06).                      
           05  WS-HHMMSS-NUM-DEC        PIC V9(06).                     
COB305     05 WS-PREM-REF-LATITUDE        PIC S9(3)V9(6) USAGE COMP-3 
COB305       VALUE 0.    
COB305     05 WS-PREM-REF-LONGITUDE        PIC S9(3)V9(6) USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-DISPLAY-LAT-LONG      PIC -999.999999.                
                                                                        
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  EXISTS-SW                PIC X(01) VALUE 'N'.            
               88 EXISTS-YES                      VALUE 'Y'.            
               88 EXISTS-NO                       VALUE 'N'.            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04026_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ID1                PIC S9(9) COMP VALUE 1.          
           05  PARM-SERV-ORDER-NO      PIC X(13) VALUE SPACES.          
           05  PARM-LATITUDE           PIC X(11) VALUE SPACES.          
           05  PARM-LONGITUDE          PIC X(11) VALUE SPACES.          
           05  PARM-USERID             PIC X(07) VALUE SPACES.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-SERV-ORDER-NO      PIC X(13).                           
       01  LINK-LATITUDE           PIC X(11).                           
       01  LINK-LONGITUDE          PIC X(11).                           
       01  LINK-USERID             PIC X(07).                           
                                                                        
       PROCEDURE DIVISION USING LINK-SERV-ORDER-NO                      
                                LINK-LATITUDE                           
                                LINK-LONGITUDE                          
                                LINK-USERID.                            
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE AS  RETURN_CODE                    
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE AS  RETURN_CODE                            
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO PARM-SERV-ORDER-NO.               
           MOVE LINK-LATITUDE      TO PARM-LATITUDE.                    
           MOVE LINK-LONGITUDE     TO PARM-LONGITUDE.                   
           MOVE LINK-USERID        TO PARM-USERID.                      
                                                                        
           MOVE PARM-SERV-ORDER-NO TO WS-SERV-ORDER-NO.                 
           MOVE WS-SERV-ORDER-NO   TO VO-SERV-ORDER-NO.                 
                                                                        
           MOVE PARM-LATITUDE      TO WS-PARSE-LAT-LONG.                
           IF WS-SIGN = '+' OR '-'                                      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '+'   TO WS-SIGN
           END-IF.                                   
           MOVE WS-DDD    TO WS-DDD-NUM.                                
           MOVE WS-HHMMSS TO WS-HHMMSS-NUM.                             
           COMPUTE WS-HHMMSS-NUM-DEC =                                  
                   WS-HHMMSS-NUM * .000001.                             
A          COMPUTE PR-PREM-REF-LATITUDE =                               
                   WS-DDD-NUM +                                         
                   WS-HHMMSS-NUM-DEC.                                   
           IF WS-SIGN = '-'                                             
A              COMPUTE PR-PREM-REF-LATITUDE =                           
A                      PR-PREM-REF-LATITUDE * -1
           END-IF.                       
                                                                        
           MOVE PARM-LONGITUDE     TO WS-PARSE-LAT-LONG.                
           IF WS-SIGN = '+' OR '-'                                      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '+'   TO WS-SIGN
           END-IF.                                   
           MOVE WS-DDD    TO WS-DDD-NUM.                                
           MOVE WS-HHMMSS TO WS-HHMMSS-NUM.                             
           COMPUTE WS-HHMMSS-NUM-DEC =                                  
                   WS-HHMMSS-NUM * .000001.                             
A          COMPUTE PR-PREM-REF-LONGITUDE =                              
                   WS-DDD-NUM +                                         
                   WS-HHMMSS-NUM-DEC.                                   
           IF WS-SIGN = '-'                                             
A              COMPUTE PR-PREM-REF-LONGITUDE =                          
A                      PR-PREM-REF-LONGITUDE * -1
           END-IF.                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 7000-GET-ACCOUNT      THRU 7000-EXIT.                
I00575     PERFORM 8200-UPDATE-PREMISE THRU 8200-EXIT.                  
I00575     PERFORM 8100-INSERT-TRANSHIST THRU 8100-EXIT.                
                                                                        
           PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT.                  
           ADD +1                     TO   CTR-ROWS.                    
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
       7000-GET-ACCOUNT.                                                
                                                                        
           EXEC SQL                                                     
C36689        SELECT TOP(1) ACCOUNT_NO_PRIOR,
              VO.PREMISE_NO,
              PREM_REF_LATITUDE,
              PREM_REF_LONGITUDE                                 
C36689        INTO :VO-ACCOUNT-NO-PRIOR,                                
I00575             :VO-PREMISE-NO,                                      
A05317             :WS-PREM-REF-LATITUDE,                               
A05317             :WS-PREM-REF-LONGITUDE                               
              FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                        
A05317             CSS_PREMISE PR WITH(READUNCOMMITTED)                         
             WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                    
A05317         AND VO.PREMISE_NO = PR.PREMISE_NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO_PRIOR,                                          
MFA-TR*              VO.PREMISE_NO,                                             
MFA-TR*              PREM_REF_LATITUDE,                                         
MFA-TR*              PREM_REF_LONGITUDE                                         
MFA-TR*       INTO :VO-ACCOUNT-NO-PRIOR,                                        
MFA-TR*            :VO-PREMISE-NO,                                              
MFA-TR*            :WS-PREM-REF-LATITUDE,                                       
MFA-TR*            :WS-PREM-REF-LONGITUDE                                       
MFA-TR*       FROM CSS_SO_DATA VO,                                              
MFA-TR*            CSS_PREMISE PR                                               
MFA-TR*      WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                            
MFA-TR*        AND VO.PREMISE_NO = PR.PREMISE_NO                                
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7000'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
A05317             MOVE 'CSS_PREMISE'      TO TABLE-2                   
                   MOVE 'SERV_ORDER_NO'    TO TABLE-ELEMENT-1           
                   MOVE PARM-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       8100-INSERT-TRANSHIST.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT DATE                                              
MFA-TR*          INTO :MH-DATE-TRANS                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT TIMESTAMP                                         
MFA-TR*          INTO :MH-TRANS-HIST-SEQ-NO                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT  RESP_AREA_ID                                      
              INTO    :MH-RESP-AREA-ID                                  
              FROM    CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
              WHERE   USER_ID = :PARM-USERID                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21410000
MFA-TR*       SELECT  RESP_AREA_ID                                      21420000
MFA-TR*       INTO    :MH-RESP-AREA-ID                                  21430000
MFA-TR*       FROM    CSS_USER_PROFILE                                  21440000
MFA-TR*       WHERE   USER_ID = :PARM-USERID                            21450000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 8100                                                      
MFA-TR*    END-EXEC.                                                    21460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO MH-RESP-AREA-ID                       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME            TO ABEND-PROGRAM        
                   MOVE 'SELECT'                TO ABEND-FUNCTION       
                   MOVE SPACES                  TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                   MOVE 'CSS_USER_PROFILE'      TO TABLE-1              
                   MOVE 'USER_ID'               TO TABLE-ELEMENT-1      
                   MOVE PARM-USERID             TO HOSTVAR-ELEMENT-1    
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE 1                               TO WS-TRAN-APPL-NO      
                                                   MI-TRAN-APPL-NO.     
                                                                        
           MOVE 'F'                             TO MH-CODE-TRAN-TYPE.   
I00575     MOVE VO-PREMISE-NO                   TO MH-PREMISE-NO        
I00575     MOVE ZEROS                           TO MH-ACCOUNT-NO.       
           MOVE ZEROS                           TO MH-CUSTOMER-NO.      
           MOVE PARM-USERID                     TO MH-USER-ID.          
           MOVE 'PANELCADS'                     TO MH-APPL-PROGRAM-ID.  
                                                                        
A          IF WS-PREM-REF-LATITUDE NOT = PR-PREM-REF-LATITUDE           
               MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO          
               MOVE 'LATITUDE'              TO MI-COLUMN-DESC           
               MOVE SPACES                  TO MI-TABLE-ID              
A              MOVE WS-PREM-REF-LATITUDE    TO WS-DISPLAY-LAT-LONG      
               MOVE WS-DISPLAY-LAT-LONG     TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE +11                     TO MI-PRV-COLUMN-VALUE-LEN  
A              MOVE PR-PREM-REF-LATITUDE    TO WS-DISPLAY-LAT-LONG      
               MOVE WS-DISPLAY-LAT-LONG     TO MI-CHG-COLUMN-VALUE-TEXT 
               MOVE +11                     TO MI-CHG-COLUMN-VALUE-LEN  
               MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
A          IF WS-PREM-REF-LONGITUDE NOT = PR-PREM-REF-LONGITUDE         
               MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO          
               MOVE 'LONGITUDE'             TO MI-COLUMN-DESC           
               MOVE SPACES                  TO MI-TABLE-ID              
A              MOVE WS-PREM-REF-LONGITUDE   TO WS-DISPLAY-LAT-LONG      
               MOVE WS-DISPLAY-LAT-LONG     TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE +11                     TO MI-PRV-COLUMN-VALUE-LEN  
A              MOVE PR-PREM-REF-LONGITUDE   TO WS-DISPLAY-LAT-LONG      
               MOVE WS-DISPLAY-LAT-LONG     TO MI-CHG-COLUMN-VALUE-TEXT 
               MOVE +11                     TO MI-CHG-COLUMN-VALUE-LEN  
               MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00575 8200-UPDATE-PREMISE.                                             
I00575                                                                  
I00575     MOVE '8200' TO ACTIVE-PARAGRAPH.                             
I00575                                                                  
I00575     EXEC SQL                                                     
I00575         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :PR-LAT-LONG-DT                                   
I00575     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT DATE                                              
MFA-TR*          INTO :PR-LAT-LONG-DT                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00575                                                                  
I00575     EXEC SQL                                                     
I00575         UPDATE CSS_PREMISE                                       
I00575            SET LAT_LONG_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :PR-LAT-LONG-DT
              ) IS NULL OR (PATINDEX('%.%', :PR-LAT-LONG-DT
              ) <> 0) OR (LEN(:PR-LAT-LONG-DT) <> 10), CIS.CHAR2DATE(
                                                        :PR-LAT-LONG-DT
              ), CONVERT(DATE, :PR-LAT-LONG-DT) ),             
I00575                LAT_LONG_SOURCE_CD = 'D',                         
I00575                PREM_REF_LATITUDE  = :PR-PREM-REF-LATITUDE,       
I00575                PREM_REF_LONGITUDE = :PR-PREM-REF-LONGITUDE       
I00575          WHERE PREMISE_NO         = :VO-PREMISE-NO               
I00575                                                      
I00575     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PREMISE                                               
MFA-TR*           SET LAT_LONG_DT        = :PR-LAT-LONG-DT,                     
MFA-TR*               LAT_LONG_SOURCE_CD = 'D',                                 
MFA-TR*               PREM_REF_LATITUDE  = :PR-PREM-REF-LATITUDE,               
MFA-TR*               PREM_REF_LONGITUDE = :PR-PREM-REF-LONGITUDE               
MFA-TR*         WHERE PREMISE_NO         = :VO-PREMISE-NO                       
MFA-TR*         QUERYNO 8200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00575                                                                  
I00575     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
I00575     EVALUATE WS-ACTIVE-RETURN-CODE                               
I00575         WHEN SUCCESSFUL-CALL                                     
I00575             CONTINUE                                             
I00575         WHEN OTHER                                               
I00575             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
I00575             MOVE SPACES              TO ABEND-TABLES             
I00575             MOVE SPACES              TO ABEND-SQL-PREDICATES     
I00575             MOVE 'CSR04026'          TO ABEND-PROGRAM            
I00575             MOVE 'UPDATE'            TO ABEND-FUNCTION           
I00575             MOVE 'CSS_PREMISE'       TO TABLE-1                  
I00575             MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
I00575             MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
I00575             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
I00575             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
I00575     END-EVALUATE.                                                
I00575                                                                  
I00575 8200-EXIT.                                                       
I00575     EXIT.                                                        
I00575                                                                  
              EXEC SQL                                                          
                 INCLUDE CPDSP300                                               
              END-EXEC.                                                         
                                                                        
              EXEC SQL                                                          
                 INCLUDE CPD00321                                               
              END-EXEC.                                                         
