       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04012.                                            
       DATE-WRITTEN. NOV 12, 2007.                                      
       AUTHOR. VIDHU VALSARAJAN.                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM DESKTOP 2000.*        
      * THIS STORED PROCEDURE IS CALLED FROM PANEL 015.                *        
      *                                                                *        
      * THIS PROGRAM DETERMINES THE RELEASE REQUIREMENT AND RETURNS    *        
      * THE APPROPRIATE MESSAGE(S) AND CONTACT #(S).                   *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
C34541*  11/12/07  VV90387    INITIAL CODE.                            *        
C34591*  04/25/08  VV90387    GIVE 'INACTIVE DATE MISSING' MESSAGE IF  *        
ACT-6 *                       REMOVED DATE TP DOES NOT SATISFY INACTIVE*        
      *                       TP. AS THE METER COULD BE HAVE BEEN      *        
      *                       INACTIVE MUCH BEFORE IT WAS ACTUALLY     *        
      *                       REMOVED.                                 *        
C34590*  07/16/08  VV90387    INCLUDE RELEASE BRIDGE CHECK FUNCTIONALY *        
C34590*                       FOR SPLIT ORDER PROJECT.                 *        
A01628*  10/26/09  VV90387    DO NOT CHECK RLSE CHKBOX FOR SUPPLIES OF *        
A01628*                       MOBILE HOME.                             *        
A01628*  12/14/09  VV90387    REMOVE HARD CODING OF RLSE EXCEPTION MSG *        
A01628*                       FROM CSS_RLSE_SUPPLIES                   *        
A04670*  09/27/13  FMB        FETCH FIRST 1 ROWS ONLY ON FETCH OF      *        
A04670*                       CSS_PREM_RLSE TO AVOID -811.             *        
DT9497*  03/28/16  PK44514    CHECK THE MTR INACTIVE/REMOVED DATE WITH *        
DT9497*                       TP ONLY IF MTR STATUS IS INACTIVE/REMOVED*        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04012'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04012 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    SQL COMMUNICATION AREA                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RLSE_REV_DIST     (PREFIX = BA)                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRLSERD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RLSE_SUPPLIES    (PREFIX = BB)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRLSESP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RLSE_STAT_REAS   (PREFIX = BM)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRLSEST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT     (PREFIX = MN)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REV_DISTRICT     (PREFIX = A9)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRVDST                                                   
           END-EXEC.                                                            
                                                                        
C34590******************************************************************        
C34590*    CSS_PREM_RLSE        (PREFIX = RE)                          *        
C34590******************************************************************        
C34590     EXEC SQL                                                             
C34590        INCLUDE TBPRMRL                                                   
C34590     END-EXEC.                                                            
C34590                                                                  
C34590******************************************************************        
C34590*    CSS_PREM_RLSE_DATA   (PREFIX = RP)                          *        
C34590******************************************************************        
C34590     EXEC SQL                                                             
C34590        INCLUDE TBRLSED                                                   
C34590     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04012'.      
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9)  COMP.                 
           05  PARM-COMPANY-NO         PIC X(02)  VALUE SPACES.         
           05  PARM-REV-DISTRICT-CD    PIC X(03)  VALUE SPACES.         
           05  PARM-CODE-UTIL-TYPE     PIC X(01)  VALUE SPACES.         
           05  PARM-ORDER-TYPE-CD      PIC X(05)  VALUE SPACES.         
           05  PARM-WORK-TYPE-CD       PIC X(03)  VALUE SPACES.         
           05  PARM-RLSE-CHECK-CD      PIC X(01)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO-RED     REDEFINES  PARM-ACCOUNT-NO       
                                       PIC 9(13).                       
           05  PARM-ACCOUNT-NUM        PIC S9(13)V COMP-3 VALUE 0.      
           05  PARM-IC-NO              PIC X(04)   VALUE SPACES.        
           05  PARM-IC-NO-RED          REDEFINES   PARM-IC-NO           
                                       PIC 9(04).                       
           05  PARM-IC-NUM             PIC S9(04)  USAGE COMP           
                                                   VALUE 0.             
           05  PARM-MTR-REF-NO         PIC X(04)   VALUE SPACES.        
           05  PARM-MTR-REF-NO-RED     REDEFINES   PARM-MTR-REF-NO      
                                       PIC 9(04).                       
           05  PARM-MTR-REF-NUM        PIC S9(04)  USAGE COMP           
                                                   VALUE 0.             
           05  PARM-METER-SUPPLYING-CD PIC X(02)   VALUE SPACES.        
           05  PARM-CODE-STATUS-REAS   PIC X(01)   VALUE SPACES.        
           05  PARM-CALLING-SYSTEM     PIC X(03)   VALUE SPACES.        
           05  PARM-WANTED-BY-DATE     PIC X(10)   VALUE SPACES.        
C34590     05  PARM-PREMISE-NO         PIC X(10)   VALUE SPACES.        
C34590     05  PARM-PREMISE-NO-RED     REDEFINES   PARM-PREMISE-NO      
C34590                                 PIC 9(10).                       
           05  PARM-PREMISE-NUM        PIC S9(10)  USAGE COMP           
                                                   VALUE 0.             
C34590     05  PARM-RLSE-TYPE          PIC X(02)   VALUE SPACES.        
C34590     05  PARM-RLSE-SUPPLIES      PIC X(15)   VALUE SPACES.        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-RCVPRM               PIC X(20)      VALUE SPACES.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MESSAGES.                                                 
           05  WS-DEFAULT-MSG1         PIC X(05) VALUE 'RBAD1'.         
           05  WS-DEFAULT-MSG2         PIC X(05) VALUE 'RBAD2'.         
           05  WS-DEFAULT-MSG3         PIC X(05) VALUE 'RBAS1'.         
           05  WS-DEFAULT-MSG4         PIC X(05) VALUE 'RBAS2'.         
           05  WS-DEFAULT-MSGI         PIC X(05) VALUE 'RBAMI'.         
           05  WS-DEFAULT-MSGR         PIC X(05) VALUE 'RBAMR'.         
           05  WS-EXCPTN-MSG1          PIC X(05) VALUE 'RBAX1'.         
           05  WS-EXCPTN-MSG2          PIC X(05) VALUE 'RBAX2'.         
           05  WS-ERROR-MSG1           PIC X(05) VALUE 'RE001'.         
           05  WS-ERROR-MSG2           PIC X(05) VALUE 'RE002'.         
           05  WS-ERROR-MSG3           PIC X(05) VALUE 'RE003'.         
           05  WS-ERROR-MSG4           PIC X(05) VALUE 'RE004'.         
           05  WS-ERROR-MSG5           PIC X(05) VALUE 'RE005'.         
           05  WS-ERROR-MSG6           PIC X(05) VALUE 'RE006'.         
           05  WS-ERROR-MSG7           PIC X(05) VALUE 'RE007'.         
           05  WS-ERROR-MSG8           PIC X(05) VALUE 'RE008'.         
           05  WS-ERROR-MSG9           PIC X(05) VALUE 'RE009'.         
           05  WS-ERROR-MSG10          PIC X(05) VALUE 'RE010'.         
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-B                    PIC X(01) VALUE 'B'.             
           05  WS-E                    PIC X(01) VALUE 'E'.             
           05  WS-I                    PIC X(02) VALUE 'I '.            
           05  WS-M                    PIC X(01) VALUE 'M'.             
           05  WS-R                    PIC X(01) VALUE 'R'.             
           05  WS-U                    PIC X(01) VALUE 'U'.             
           05  WS-NS                   PIC X(02) VALUE 'NS'.            
           05  WS-AA                   PIC X(02) VALUE 'AA'.            
           05  WS-FS                   PIC X(02) VALUE 'FS'.            
           05  WS-NN                   PIC X(03) VALUE 'N  '.           
           05  WS-NNN                  PIC X(03) VALUE 'NNN'.           
           05  WS-ORD-SET              PIC X(05) VALUE 'FM002'.         
           05  WS-ORD-E-MNT-WK         PIC X(05) VALUE 'FW001'.         
           05  WS-ORD-G-MNT-WK         PIC X(05) VALUE 'FW007'.         
           05  WS-WK-SET               PIC X(03) VALUE 'SET'.           
           05  WS-WK-ST3               PIC X(03) VALUE 'ST3'.           
           05  WS-WK-ST2               PIC X(03) VALUE 'ST2'.           
           05  WS-WK-TMP               PIC X(03) VALUE 'TMP'.           
           05  WS-WK-G97               PIC X(03) VALUE 'G97'.           
           05  WS-WK-S55               PIC X(03) VALUE 'S55'.           
           05  WS-WK-SOL               PIC X(03) VALUE 'SOL'.           
           05  WS-WK-SOR               PIC X(03) VALUE 'SOR'.           
           05  WS-WK-SOS               PIC X(03) VALUE 'SOS'.           
           05  WS-SETS                 PIC X(01) VALUE 'N'.             
DT9497     05  WS-MTR-INACTIVE-CD      PIC X(01) VALUE 'J'.             
DT9497     05  WS-MTR-REMOVED-CD       PIC X(01) VALUE 'K'.             
           05  WS-INACTIVE             PIC X(01) VALUE 'N'.             
           05  WS-INACTIVE-STATUS      PIC X(01) VALUE 'N'.             
           05  WS-REMOVED              PIC X(01) VALUE 'N'.             
           05  WS-REMOVED-STATUS       PIC X(01) VALUE 'N'.             
           05  WS-DATE-MISMATCH        PIC X(01) VALUE 'N'.             
           05  WS-MISMATCH             PIC X(01) VALUE 'N'.             
           05  WS-REV-DIST-EXISTS      PIC X(01) VALUE 'N'.             
A01628     05  WS-CHK-SUPPLIES         PIC X(01) VALUE SPACES.          
           05  WS-MESSAGE              PIC X(05) VALUE SPACES.          
           05  WS-PHONE                PIC X(12) VALUE SPACES.          
           05  WS-PHONE-FORMATD.                                        
               10  WS-PH-AREA-CD       PIC X(03) VALUE SPACES.          
               10  WS-FILLER           PIC X(01) VALUE '.'.             
               10  WS-PH-NUM           PIC X(03) VALUE SPACES.          
               10  WS-FILLER           PIC X(01) VALUE '.'.             
               10  WS-PH-NUM-L4        PIC X(04) VALUE SPACES.          
           05  WS-DATE                 PIC X(10).                       
           05  WS-NEW-DATE             PIC X(10).                       
           05  WS-WANTED-BY-DATE       PIC X(10).                       
           05  WS-DAYS                 PIC S9(4) COMP.                  
           05  WS-MTR-INACTIVE-NULL    PIC S9(4) COMP  VALUE 0.         
           05  WS-MTR-REMOVED-NULL     PIC S9(4) COMP  VALUE 0.         
           05  WS-MTR-STATUS-CHNG-NULL PIC S9(4) COMP  VALUE 0.         
           05  WS-METER-TIME-PERIOD    PIC S9(3) COMP  VALUE 0.         
           05  WS-METER-TP             PIC X(3)  VALUE SPACES.          
           05  WS-METER-TP1            PIC 9(3)  COMP  VALUE 0.         
           05  WS-METER-TP2            PIC 9(3)  COMP  VALUE 0.         
           05  WS-METER-TP3            PIC 9(3)  COMP  VALUE 0.         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  RS-RLSE-REQUIRED-FL    PIC X(01)      VALUE SPACES.      
           05  RS-MESSAGE             PIC X(05)      VALUE SPACES.      
           05  RS-ADTL-MESSAGE        PIC X(05)      VALUE SPACES.      
           05  RS-PHONE               PIC X(12)      VALUE SPACES.      
           05  RS-ALT-PHONE           PIC X(12)      VALUE SPACES.      
           05  RS-UTIL-TYPE           PIC X(04)      VALUE SPACES.      
           05  RS-REV-DIST-DESC       PIC X(35)      VALUE SPACES.      
C34590     05  RS-RLSE-EXISTS         PIC X(01)      VALUE SPACES.      
C34590     05  RS-RLSE-NO             PIC X(10)      VALUE SPACES.      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW            PIC X(01)      VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW           PIC X(01)      VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18)       VALUE SPACES.  
           10  S-SQLCODE                 PIC S9(9) COMP  VALUE 0.       
           10  S-SQLSTATE                PIC X(5)        VALUE ' '.     
           10  S-TABLE-NAME              PIC X(18)       VALUE SPACES.  
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-RETURN-CODE            PIC S9(9) COMP  VALUE 0.       
           10  WS-SQLSTATE               PIC X(05)       VALUE SPACES.  
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-COMPANY-NO               PIC X(02).                     
       01  LINK-REV-DISTRICT-CD          PIC X(03).                     
       01  LINK-CODE-UTIL-TYPE           PIC X(01).                     
       01  LINK-ORDER-TYPE-CD            PIC X(05).                     
       01  LINK-WORK-TYPE-CD             PIC X(03).                     
       01  LINK-RLSE-CHECK-CD            PIC X(01).                     
       01  LINK-ACCOUNT-NO               PIC X(13).                     
       01  LINK-IC-NO                    PIC X(04).                     
       01  LINK-MTR-REF-NO               PIC X(04).                     
       01  LINK-METER-SUPPLYING-CD       PIC X(02).                     
       01  LINK-CODE-STATUS-REAS         PIC X(01).                     
       01  LINK-CALLING-SYSTEM           PIC X(03).                     
       01  LINK-WANTED-BY-DATE           PIC X(10).                     
C34590 01  LINK-PREMISE-NO               PIC X(10).                     
C34590 01  LINK-RLSE-TYPE                PIC X(02).                     
C34590 01  LINK-RLSE-SUPPLIES            PIC X(15).                     
                                                                        
       PROCEDURE DIVISION USING          LINK-COMPANY-NO                
                                        ,LINK-REV-DISTRICT-CD           
                                        ,LINK-CODE-UTIL-TYPE            
                                        ,LINK-ORDER-TYPE-CD             
                                        ,LINK-WORK-TYPE-CD              
                                        ,LINK-RLSE-CHECK-CD             
                                        ,LINK-ACCOUNT-NO                
                                        ,LINK-IC-NO                     
                                        ,LINK-MTR-REF-NO                
                                        ,LINK-METER-SUPPLYING-CD        
                                        ,LINK-CODE-STATUS-REAS          
                                        ,LINK-CALLING-SYSTEM            
                                        ,LINK-WANTED-BY-DATE            
C34590                                  ,LINK-PREMISE-NO                
C34590                                  ,LINK-RLSE-TYPE                 
C34590                                  ,LINK-RLSE-SUPPLIES.            
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. DECLARE CURSOR                                          *        
      *     2. RECEIVE INPUT PARAMETRS                                 *        
      *     3. INITIALIZE OUTPUT PARAMETERS                            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
              SELECT :S-RETURN-CODE          AS RETURN_CODE             
                    ,:RS-RLSE-REQUIRED-FL    AS RLSE_REQUIRED_FL        
                    ,:RS-MESSAGE             AS MESSAGE                 
                    ,:RS-ADTL-MESSAGE        AS ADTL_MESSAGE            
                    ,:RS-PHONE               AS PHONE                   
                    ,:RS-ALT-PHONE           AS ALT_PHONE               
                    ,:RS-UTIL-TYPE           AS UTIL_TYPE               
                    ,:RS-REV-DIST-DESC       AS REV_DIST_DESC           
C34590              ,:RS-RLSE-EXISTS         AS RLSE_EXISTS             
C34590              ,:RS-RLSE-NO             AS RLSE_NO                 
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT :S-RETURN-CODE          AS RETURN_CODE                     
MFA-TR*             ,:RS-RLSE-REQUIRED-FL    AS RLSE_REQUIRED_FL                
MFA-TR*             ,:RS-MESSAGE             AS MESSAGE                         
MFA-TR*             ,:RS-ADTL-MESSAGE        AS ADTL_MESSAGE                    
MFA-TR*             ,:RS-PHONE               AS PHONE                           
MFA-TR*             ,:RS-ALT-PHONE           AS ALT_PHONE                       
MFA-TR*             ,:RS-UTIL-TYPE           AS UTIL_TYPE                       
MFA-TR*             ,:RS-REV-DIST-DESC       AS REV_DIST_DESC                   
MFA-TR*             ,:RS-RLSE-EXISTS         AS RLSE_EXISTS                     
MFA-TR*             ,:RS-RLSE-NO             AS RLSE_NO                         
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE LINK-COMPANY-NO              TO PARM-COMPANY-NO.        
           MOVE LINK-REV-DISTRICT-CD         TO PARM-REV-DISTRICT-CD.   
           MOVE LINK-CODE-UTIL-TYPE          TO PARM-CODE-UTIL-TYPE.    
           MOVE LINK-ORDER-TYPE-CD           TO PARM-ORDER-TYPE-CD.     
           MOVE LINK-WORK-TYPE-CD            TO PARM-WORK-TYPE-CD.      
           MOVE LINK-RLSE-CHECK-CD           TO PARM-RLSE-CHECK-CD.     
           MOVE LINK-ACCOUNT-NO              TO PARM-ACCOUNT-NO.        
           MOVE LINK-IC-NO                   TO PARM-IC-NO.             
           MOVE LINK-MTR-REF-NO              TO PARM-MTR-REF-NO.        
           MOVE LINK-METER-SUPPLYING-CD      TO PARM-METER-SUPPLYING-CD.
           MOVE LINK-CODE-STATUS-REAS        TO PARM-CODE-STATUS-REAS.  
           MOVE LINK-CALLING-SYSTEM          TO PARM-CALLING-SYSTEM.    
           MOVE LINK-WANTED-BY-DATE          TO PARM-WANTED-BY-DATE.    
C34590     MOVE LINK-PREMISE-NO              TO PARM-PREMISE-NO.        
C34590     MOVE LINK-RLSE-TYPE               TO PARM-RLSE-TYPE.         
C34590     MOVE LINK-RLSE-SUPPLIES           TO PARM-RLSE-SUPPLIES.     
                                                                        
           INITIALIZE                           S-RETURN-CODE           
                                                RS-RLSE-REQUIRED-FL     
                                                RS-MESSAGE              
                                                RS-ADTL-MESSAGE         
                                                RS-PHONE                
                                                RS-ALT-PHONE            
                                                RS-UTIL-TYPE            
                                                RS-REV-DIST-DESC        
C34590                                          RS-RLSE-EXISTS          
C34590                                          RS-RLSE-NO.             
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     RECEIVE PARARMETERS AND MOVE TO NUMERIC FIELDS.            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE PARM-ACCOUNT-NO-RED           TO PARM-ACCOUNT-NUM.      
           MOVE PARM-IC-NO-RED                TO PARM-IC-NUM.           
           MOVE PARM-MTR-REF-NO-RED           TO PARM-MTR-REF-NUM.      
                                                                        
           MOVE PARM-COMPANY-NO               TO BA-COMPANY-NO          
                                                 BB-COMPANY-NO          
                                                 BM-COMPANY-NO.         
           MOVE PARM-REV-DISTRICT-CD          TO BA-REV-DISTRICT-CD     
                                                 BB-REV-DISTRICT-CD     
                                                 BM-REV-DISTRICT-CD     
                                                 RP-REV-DISTRICT-CD     
                                                 A9-REV-DISTRICT-CD.    
           MOVE PARM-CODE-UTIL-TYPE           TO BA-CODE-UTIL-TYPE      
                                                 BB-CODE-UTIL-TYPE      
                                                 BM-CODE-UTIL-TYPE      
                                                 MN-CODE-UTIL-TYPE.     
                                                                        
           MOVE PARM-ACCOUNT-NUM              TO MN-ACCOUNT-NO.         
           MOVE PARM-IC-NUM                   TO MN-IC-NO.              
           MOVE PARM-MTR-REF-NUM              TO MN-MTR-REF-NO.         
                                                                        
           MOVE PARM-METER-SUPPLYING-CD       TO BB-METER-SUPPLYING-CD. 
           MOVE PARM-CODE-STATUS-REAS         TO BM-CODE-STATUS-REAS.   
           MOVE PARM-WANTED-BY-DATE           TO WS-WANTED-BY-DATE.     
                                                                        
C34590     MOVE PARM-PREMISE-NO-RED           TO PARM-PREMISE-NUM.      
C34590     MOVE PARM-PREMISE-NUM              TO RP-PREMISE-NO.         
C34590     MOVE PARM-RLSE-TYPE                TO RE-RLSE-TYPE.          
C34590     MOVE PARM-RLSE-SUPPLIES            TO RE-RLSE-SUPPLIES.      
                                                                        
           IF PARM-ORDER-TYPE-CD    = WS-ORD-SET AND                    
             (PARM-WORK-TYPE-CD     = WS-WK-SET  OR                     
              PARM-WORK-TYPE-CD     = WS-WK-ST3  OR                     
              PARM-WORK-TYPE-CD     = WS-WK-ST2)                        
              MOVE WS-YES                     TO WS-SETS                
           END-IF.                                                      
                                                                        
           IF PARM-COMPANY-NO       = SPACES  OR                        
              PARM-REV-DISTRICT-CD  = SPACES  OR                        
              PARM-CODE-UTIL-TYPE   = SPACES                            
              MOVE WS-E                       TO RS-RLSE-REQUIRED-FL    
              IF WS-SETS            = WS-YES                            
                 MOVE WS-ERROR-MSG8           TO RS-MESSAGE             
              ELSE                                                      
                 MOVE WS-ERROR-MSG6           TO RS-MESSAGE             
              END-IF                                                    
C34590        MOVE WS-NO                      TO RS-RLSE-EXISTS         
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
           IF PARM-CODE-UTIL-TYPE    = WS-E                             
              MOVE 'ELEC'                     TO RS-UTIL-TYPE           
           ELSE                                                         
              MOVE 'GAS'                      TO RS-UTIL-TYPE           
           END-IF.                                                      
                                                                        
           PERFORM 7050-GET-REV-DIST-DESC     THRU 7050-EXIT.           
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE A9-REV-DISTRICT-DESC      TO RS-REV-DIST-DESC       
           ELSE                                                         
               MOVE SPACES                    TO RS-REV-DIST-DESC       
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
           PERFORM 7600-RLSE-BRIDGE-INFO      THRU 7600-EXIT            
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-GET-RLSE-REV-DIST        THRU 7000-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE      = SUCCESSFUL-CALL              
              PERFORM 2250-CALC-PRE-DEFAULTS     THRU 2250-EXIT         
              IF PARM-ORDER-TYPE-CD      = WS-ORD-SET AND               
                 (PARM-WORK-TYPE-CD      = WS-WK-SET  OR                
                  PARM-WORK-TYPE-CD      = WS-WK-ST3  OR                
                  PARM-WORK-TYPE-CD      = WS-WK-ST2)                   
                 PERFORM 2300-DETERMINE-SETS     THRU 2300-EXIT         
              END-IF                                                    
                                                                        
              IF PARM-ORDER-TYPE-CD      = WS-ORD-SET AND               
                 PARM-WORK-TYPE-CD       = WS-WK-TMP                    
                 PERFORM 2400-DETERMINE-TSAWS    THRU 2400-EXIT         
              END-IF                                                    
                                                                        
              IF ((PARM-ORDER-TYPE-CD    = WS-ORD-E-MNT-WK OR           
                 WS-ORD-G-MNT-WK) AND (PARM-WORK-TYPE-CD = WS-WK-G97))  
                 OR ((PARM-ORDER-TYPE-CD = WS-ORD-E-MNT-WK) AND         
                 (PARM-WORK-TYPE-CD      = WS-WK-S55))                  
                 PERFORM 2500-DETERMINE-GROUPA   THRU 2500-EXIT         
              END-IF                                                    
                                                                        
              IF MN-ACCOUNT-NO                  > 0                     
                 PERFORM 7100-METER-TP-DTLS             THRU 7100-EXIT  
                 MOVE WS-NO                     TO WS-DATE-MISMATCH     
                                                   WS-MISMATCH          
                 IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL AND   
DT9497              (MN-CODE-METER-STATUS = WS-MTR-REMOVED-CD OR        
DT9497               MN-CODE-METER-STATUS = WS-MTR-INACTIVE-CD)         
                    IF BA-METER-INACTIVE-TP NOT EQUAL (WS-NN AND WS-NNN)
                       PERFORM 2600-MTR-INACTIVE-TP     THRU 2600-EXIT  
                    END-IF                                              
                    IF (PARM-WORK-TYPE-CD = WS-WK-SOL   OR              
                        PARM-WORK-TYPE-CD = WS-WK-SOR   OR              
                        PARM-WORK-TYPE-CD = WS-WK-SOS)  AND             
                        BA-METER-REMOVED-TP NOT EQUAL (WS-NN AND WS-NNN)
                        PERFORM 2700-MTR-REMOVED-TP     THRU 2700-EXIT  
                    END-IF                                              
                                                                        
A01628              MOVE WS-YES                TO WS-CHK-SUPPLIES       
A01628*             IF PARM-METER-SUPPLYING-CD  > SPACES                        
A01628*                PERFORM 2800-GET-RLSE-SUPPLIES   THRU 2800-EXIT          
A01628*             END-IF                                                      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF PARM-CODE-STATUS-REAS   > SPACES                       
                 PERFORM 2900-GET-RLSE-STAT-REAS THRU 2900-EXIT         
              END-IF                                                    
                                                                        
A01628        IF PARM-METER-SUPPLYING-CD  > SPACES AND                  
A01628           WS-CHK-SUPPLIES          = WS-YES                      
A01628           PERFORM 2800-GET-RLSE-SUPPLIES  THRU 2800-EXIT         
A01628        END-IF                                                    
                                                                        
              PERFORM 3000-CHECK-DATE-ERROR      THRU 3000-EXIT         
                                                                        
              MOVE ZERO                          TO S-RETURN-CODE       
              MOVE WS-NO                         TO RS-RLSE-REQUIRED-FL 
              MOVE SPACES                        TO RS-MESSAGE          
                                                    RS-PHONE            
           ELSE                                                         
C34590        PERFORM 7600-RLSE-BRIDGE-INFO      THRU 7600-EXIT         
              PERFORM 7025-REV-DIST-EXIST        THRU 7025-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE ZERO                       TO S-RETURN-CODE       
                 MOVE WS-NO                      TO RS-RLSE-REQUIRED-FL 
              ELSE                                                      
                 MOVE WS-E                       TO RS-RLSE-REQUIRED-FL 
                 IF WS-SETS            = WS-YES                         
                    MOVE WS-ERROR-MSG7           TO RS-MESSAGE          
                 ELSE                                                   
                    MOVE WS-ERROR-MSG1           TO RS-MESSAGE          
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2250-CALC-PRE-DEFAULTS.                                        *        
      *     CHECK AND POPULATE THE INITIAL MESSAGE AND PHONE#          *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2250-CALC-PRE-DEFAULTS.                                          
                                                                        
           IF BA-RLSE-EXEMPT-MSG-FL  =  WS-YES                          
              IF BA-RLSE-PHONE-NO    >  SPACES                          
                 MOVE WS-EXCPTN-MSG1          TO WS-MESSAGE             
              ELSE                                                      
                 MOVE WS-EXCPTN-MSG2          TO WS-MESSAGE             
              END-IF                                                    
           ELSE                                                         
              IF BA-RLSE-PHONE-NO    >  SPACES                          
                 MOVE WS-DEFAULT-MSG1         TO WS-MESSAGE             
              ELSE                                                      
                 MOVE WS-DEFAULT-MSG2         TO WS-MESSAGE             
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF BA-RLSE-PHONE-NO       >  SPACES                          
              MOVE BA-RLSE-PHONE-NO(1:3)      TO WS-PH-AREA-CD          
              MOVE BA-RLSE-PHONE-NO(4:3)      TO WS-PH-NUM              
              MOVE BA-RLSE-PHONE-NO(7:4)      TO WS-PH-NUM-L4           
              MOVE WS-PHONE-FORMATD           TO WS-PHONE               
           ELSE                                                         
              MOVE BA-RLSE-PHONE-NO           TO WS-PHONE               
           END-IF.                                                      
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-DETERMINE-SETS.                                           *        
      *     CHECK IF A SET NEW SET(ORDER/WORK TYPE) REQUIRES A RELEASE *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2300-DETERMINE-SETS.                                             
                                                                        
           IF BA-SET-NEW-SET-FL            =  WS-YES                    
              MOVE WS-YES                     TO RS-RLSE-REQUIRED-FL    
              IF PARM-WORK-TYPE-CD         =  WS-WK-ST2                 
                 IF BA-RLSE-PHONE-NO       >  SPACES                    
                    MOVE WS-DEFAULT-MSG3      TO RS-MESSAGE             
                 ELSE                                                   
                    MOVE WS-DEFAULT-MSG4      TO RS-MESSAGE             
                 END-IF                                                 
                 MOVE WS-PHONE                TO RS-PHONE               
              ELSE                                                      
                 IF (BA-ALT-MSG-CD         =  WS-NS OR WS-AA) OR        
                    (BA-ALT-MSG-CD         =  WS-FS AND                 
                     BB-METER-SUPPLYING-CD =  WS-I)                     
                     MOVE BA-ALT-MSG-NO       TO RS-MESSAGE             
                 ELSE                                                   
                     MOVE WS-MESSAGE          TO RS-MESSAGE             
                     MOVE WS-PHONE            TO RS-PHONE               
                 END-IF                                                 
              END-IF                                                    
C34590        PERFORM 7600-RLSE-BRIDGE-INFO   THRU 7600-EXIT            
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-DETERMINE-TSAWS.                                          *        
      *     CHECK IF A SET INSTALL TSAW(ORDER/WORK TYPE) REQUIRES A    *        
      *     RELEASE.                                                   *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2400-DETERMINE-TSAWS.                                            
                                                                        
           IF BA-SET-INSTAL-TSAW-FL           =  WS-YES                 
              MOVE WS-YES                        TO RS-RLSE-REQUIRED-FL 
              IF BA-ALT-TSAW-MSG-NO           >  SPACES                 
                 MOVE BA-ALT-TSAW-MSG-NO         TO RS-MESSAGE          
              ELSE                                                      
                 IF BA-ALT-MSG-CD             =  WS-AA                  
                    MOVE BA-ALT-MSG-NO           TO RS-MESSAGE          
                 ELSE                                                   
                    MOVE WS-MESSAGE              TO RS-MESSAGE          
                    MOVE WS-PHONE                TO RS-PHONE            
                 END-IF                                                 
              END-IF                                                    
C34590        PERFORM 7600-RLSE-BRIDGE-INFO      THRU 7600-EXIT         
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
              PERFORM 9999-END-PROGRAM           THRU 9999-EXIT         
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-DETERMINE-GROUPA.                                         *        
      *     CHECK IF A GROUP A ORDER/WORK TYPE REQUIRES A RELEASE      *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2500-DETERMINE-GROUPA.                                           
                                                                        
           IF (BA-GROUP-A-CD =  WS-B)  OR (BA-GROUP-A-CD =  WS-U        
               AND PARM-WORK-TYPE-CD = WS-WK-S55) OR                    
              (BA-GROUP-A-CD =  WS-R AND PARM-WORK-TYPE-CD = WS-WK-G97) 
              MOVE WS-YES                     TO RS-RLSE-REQUIRED-FL    
              IF BA-ALT-MSG-CD             =  WS-AA                     
                 MOVE BA-ALT-MSG-NO           TO RS-MESSAGE             
              ELSE                                                      
                 MOVE WS-MESSAGE              TO RS-MESSAGE             
                 MOVE WS-PHONE                TO RS-PHONE               
              END-IF                                                    
C34590        PERFORM 7600-RLSE-BRIDGE-INFO   THRU 7600-EXIT            
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
           IF PARM-RLSE-CHECK-CD = WS-M                                 
              MOVE ZERO                       TO S-RETURN-CODE          
              MOVE WS-NO                      TO RS-RLSE-REQUIRED-FL    
C34590                                           RS-RLSE-EXISTS         
              MOVE SPACES                     TO RS-MESSAGE             
                                                 RS-PHONE               
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-MTR-INACTIVE-TP                                           *        
      *     CHECK IF THE METER HAS BEEN LONG ENOUGH INACTIVE TO REQUIRE*        
      *     A RELEASE.                                                 *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2600-MTR-INACTIVE-TP.                                            
                                                                        
           INITIALIZE                                 WS-METER-TP.      
           MOVE WS-NO                              TO WS-INACTIVE.      
           MOVE BA-METER-INACTIVE-TP               TO WS-METER-TP.      
           PERFORM 2625-GET-TIME-PERIOD            THRU 2625-EXIT.      
                                                                        
           IF WS-METER-TIME-PERIOD = 0                                  
              MOVE WS-YES                          TO WS-INACTIVE       
              PERFORM 2650-SET-RLSE-REQMNT         THRU 2650-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-MTR-INACTIVE-NULL   = -1                               
              IF WS-MTR-REMOVED-NULL = 0                                
                 MOVE MN-METER-REMOVED-DT       TO WS-DATE              
              ELSE                                                      
                 MOVE WS-YES                    TO WS-DATE-MISMATCH     
                                                   WS-INACTIVE-STATUS   
                 GO TO 2600-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              MOVE MN-METER-INACTIVE-DT         TO WS-DATE              
           END-IF.                                                      
           PERFORM 7200-CALC-NEW-DATE           THRU 7200-EXIT          
           PERFORM 7300-CALC-METER-TP           THRU 7300-EXIT          
                                                                        
           IF (MN-MTR-STATUS-CHNG-DT = MN-METER-INACTIVE-DT) OR         
              (MN-MTR-STATUS-CHNG-DT = MN-METER-REMOVED-DT)             
              IF WS-DAYS > ZERO                                         
                 MOVE WS-YES                    TO WS-INACTIVE          
                 PERFORM 2650-SET-RLSE-REQMNT   THRU 2650-EXIT          
C34591        ELSE                                                      
C34591           IF WS-MTR-INACTIVE-NULL = -1                           
C34591              MOVE WS-YES                 TO WS-DATE-MISMATCH     
C34591                                             WS-INACTIVE-STATUS   
C34591           END-IF                                                 
C34591        END-IF                                                    
           ELSE                                                         
              MOVE WS-YES                       TO WS-DATE-MISMATCH     
                                                   WS-INACTIVE-STATUS   
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2625-GET-TIME-PERIOD.                                          *        
      *     GET THE TIME PERIOD THE METER WAS INACTIVE/REMOVED         *        
      *                                                                *        
      *     CALLED BY:  2600-MTR-INACTIVE-TP                           *        
      *                 2700-MTR-REMOVED-TP                            *        
      ******************************************************************        
       2625-GET-TIME-PERIOD.                                            
                                                                        
           INITIALIZE                         WS-METER-TP1              
                                              WS-METER-TP2              
                                              WS-METER-TP3              
                                              WS-METER-TIME-PERIOD.     
                                                                        
           MOVE WS-METER-TP(1:1)           TO WS-METER-TP1.             
                                                                        
           IF WS-METER-TP(2:1)  = SPACES                                
              MOVE WS-METER-TP1            TO WS-METER-TIME-PERIOD      
           ELSE                                                         
              MOVE WS-METER-TP(1:2)        TO WS-METER-TP2              
              MOVE WS-METER-TP2            TO WS-METER-TIME-PERIOD      
           END-IF.                                                      
                                                                        
           IF WS-METER-TP(3:1)  = SPACES                                
              IF WS-METER-TP(2:1) > SPACES                              
                 MOVE WS-METER-TP2         TO WS-METER-TIME-PERIOD      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-METER-TP(1:3)        TO WS-METER-TP3              
              MOVE WS-METER-TP3            TO WS-METER-TIME-PERIOD      
           END-IF.                                                      
                                                                        
       2625-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2650-SET-RLSE-REQMNT.                                          *        
      *     SET THE RELEASE PARAMETERS IF THE RELEASE IS REQUIRED.     *        
      *                                                                *        
      *     CALLED BY:  2600-MTR-INACTIVE-TP                           *        
      *                 2700-MTR-REMOVED-TP                            *        
      ******************************************************************        
       2650-SET-RLSE-REQMNT.                                            
                                                                        
           MOVE ZERO                      TO S-RETURN-CODE.             
           MOVE WS-YES                    TO RS-RLSE-REQUIRED-FL.       
                                                                        
           IF BA-ALT-MSG-CD = WS-AA                                     
              MOVE BA-ALT-MSG-NO          TO RS-MESSAGE                 
           ELSE                                                         
              MOVE WS-MESSAGE             TO RS-MESSAGE                 
              MOVE WS-PHONE               TO RS-PHONE                   
           END-IF.                                                      
                                                                        
           IF WS-INACTIVE   = WS-YES                                    
              MOVE WS-DEFAULT-MSGI        TO RS-ADTL-MESSAGE            
           END-IF.                                                      
           IF WS-REMOVED    = WS-YES                                    
              MOVE WS-DEFAULT-MSGR        TO RS-ADTL-MESSAGE            
           END-IF.                                                      
                                                                        
C34590     PERFORM 7600-RLSE-BRIDGE-INFO  THRU 7600-EXIT.               
           PERFORM 8100-SEND-RESULT       THRU 8100-EXIT.               
           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT.               
                                                                        
       2650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2675-METER-DATE-ERROR                                          *        
      *     SEND ERROR MESSAGE IF METER INACTIVE/REMOVED DATE IN ERROR *        
      *                                                                *        
      *     CALLED BY:  2600-MTR-INACTIVE-TP                           *        
      *                 2700-MTR-REMOVED-TP                            *        
      *                 2825-GET-SUPPLIES-TP                           *        
      ******************************************************************        
       2675-METER-DATE-ERROR.                                           
                                                                        
           MOVE ZERO                    TO S-RETURN-CODE.               
           MOVE WS-E                    TO RS-RLSE-REQUIRED-FL.         
                                                                        
           IF WS-INACTIVE-STATUS     =  WS-YES                          
              IF PARM-CODE-UTIL-TYPE =  WS-E                            
                 MOVE WS-ERROR-MSG2     TO RS-MESSAGE                   
              ELSE                                                      
                 MOVE WS-ERROR-MSG3     TO RS-MESSAGE                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-REMOVED-STATUS      =  WS-YES                          
              IF PARM-CODE-UTIL-TYPE =  WS-E                            
                 MOVE WS-ERROR-MSG4     TO RS-MESSAGE                   
              ELSE                                                      
                 MOVE WS-ERROR-MSG5     TO RS-MESSAGE                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
C34590     PERFORM 7600-RLSE-BRIDGE-INFO   THRU 7600-EXIT.              
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT.              
                                                                        
       2675-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2700-MTR-REMOVED-TP.                                           *        
      *     CHECK IF THE METER HAS BEEN LONG ENOUGH REMOVED TO REQUIRE *        
      *     A RELEASE.                                                 *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2700-MTR-REMOVED-TP.                                             
                                                                        
           MOVE WS-NO                               TO WS-REMOVED.      
                                                                        
           INITIALIZE                                  WS-METER-TP.     
           MOVE BA-METER-REMOVED-TP                 TO WS-METER-TP.     
           PERFORM 2625-GET-TIME-PERIOD             THRU 2625-EXIT.     
                                                                        
           IF WS-METER-TIME-PERIOD = 0                                  
              MOVE WS-YES                           TO WS-REMOVED       
              PERFORM 2650-SET-RLSE-REQMNT          THRU 2650-EXIT      
           END-IF.                                                      
                                                                        
           IF WS-MTR-REMOVED-NULL = -1                                  
              MOVE WS-YES                           TO WS-DATE-MISMATCH 
                                                       WS-REMOVED-STATUS
           ELSE                                                         
              MOVE MN-METER-REMOVED-DT              TO WS-DATE          
              PERFORM 7200-CALC-NEW-DATE            THRU 7200-EXIT      
              PERFORM 7300-CALC-METER-TP            THRU 7300-EXIT      
                                                                        
              IF MN-MTR-STATUS-CHNG-DT = MN-METER-REMOVED-DT            
                 IF WS-DAYS > ZERO                                      
                    MOVE WS-YES                     TO WS-REMOVED       
                    PERFORM 2650-SET-RLSE-REQMNT    THRU 2650-EXIT      
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-YES                        TO WS-DATE-MISMATCH 
                                                       WS-REMOVED-STATUS
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2800-GET-RLSE-SUPPLIES.                                        *        
      *     CHECK IF THE METER SUPPLIES RELEASE REQUIRES A RELEASE.  *          
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2800-GET-RLSE-SUPPLIES.                                          
                                                                        
           PERFORM 7400-GET-MTR-SUPPLIES           THRU 7400-EXIT       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF BB-METER-INACTIVE-TP NOT EQUAL (WS-NN AND WS-NNN)      
                 PERFORM 2825-GET-SUPPLIES-TP      THRU 2825-EXIT       
A01628        ELSE                                                      
A01628           PERFORM 2826-CHECK-EXEMPTION      THRU 2826-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2825-GET-SUPPLIES-TP                                           *        
      *     CHECK IF THE SUPPLIES HAS BEEN LONG ENOUGH INACTIVE TO     *        
      *     REQUIRE A RELEASE.                                         *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2825-GET-SUPPLIES-TP.                                            
                                                                        
           INITIALIZE                              WS-METER-TP.         
           MOVE BB-METER-INACTIVE-TP               TO WS-METER-TP.      
           PERFORM 2625-GET-TIME-PERIOD            THRU 2625-EXIT.      
                                                                        
           IF WS-METER-TIME-PERIOD = 0                                  
              PERFORM 2850-SET-RLSE-REQMNT         THRU 2850-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-MTR-INACTIVE-NULL = -1                                 
A01628        MOVE WS-YES                          TO WS-MISMATCH       
A01628        PERFORM 2826-CHECK-EXEMPTION         THRU 2826-EXIT       
           ELSE                                                         
              MOVE MN-METER-INACTIVE-DT            TO WS-DATE           
              PERFORM 7200-CALC-NEW-DATE           THRU 7200-EXIT       
              PERFORM 7300-CALC-METER-TP           THRU 7300-EXIT       
                                                                        
              IF MN-MTR-STATUS-CHNG-DT = MN-METER-INACTIVE-DT           
                 IF WS-DAYS > ZERO                                      
                    PERFORM 2850-SET-RLSE-REQMNT   THRU 2850-EXIT       
                 ELSE                                                   
A01628              PERFORM 2826-CHECK-EXEMPTION   THRU 2826-EXIT       
                 END-IF                                                 
              ELSE                                                      
A01628           MOVE WS-YES                       TO WS-MISMATCH       
A01628           PERFORM 2826-CHECK-EXEMPTION      THRU 2826-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2825-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2826-CHECK-EXEMPTION                                           *        
      *     CHECK IF THE SUPPLIES HAS AN EXPEMPTION                    *        
      *                                                                *        
      *     CALLED BY:  2825-GET-SUPPLIES-TP                           *        
      ******************************************************************        
       2826-CHECK-EXEMPTION.                                            
                                                                        
A01628     IF BB-RLSE-CHECK-CD   = WS-E                                 
A01628        MOVE ZERO                       TO S-RETURN-CODE          
A01628        MOVE WS-E                       TO RS-RLSE-REQUIRED-FL    
A01628        MOVE BB-EXCEPTION-MSG-NO        TO RS-MESSAGE             
A01628        PERFORM 7600-RLSE-BRIDGE-INFO   THRU 7600-EXIT            
A01628        IF RS-RLSE-EXISTS = WS-YES                                
A01628           MOVE WS-YES                  TO RS-RLSE-REQUIRED-FL    
A01628        END-IF                                                    
A01628        PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
A01628        PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
A01628     END-IF.                                                      
                                                                        
       2826-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2850-SET-RLSE-REQMNT.                                          *        
      *     SET THE RELEASE PARAMETERS IF THE RELEASE IS REQUIRED.     *        
      *                                                                *        
      *     CALLED BY:  2800-GET-RLSE-SUPPLIES                         *        
      ******************************************************************        
       2850-SET-RLSE-REQMNT.                                            
                                                                        
           MOVE ZERO                          TO S-RETURN-CODE.         
           MOVE WS-YES                        TO RS-RLSE-REQUIRED-FL    
                                                                        
           IF BA-ALT-MSG-CD = WS-AA                                     
              MOVE BA-ALT-MSG-NO              TO RS-MESSAGE             
           ELSE                                                         
              MOVE WS-MESSAGE                 TO RS-MESSAGE             
              MOVE WS-PHONE                   TO RS-PHONE               
           END-IF.                                                      
                                                                        
           MOVE BB-ERROR-MSG-NO               TO RS-ADTL-MESSAGE.       
           IF BB-ALT-PHONE-FL = WS-YES                                  
              MOVE BA-RLSE-ALT-PHONE-NO(1:3)  TO WS-PH-AREA-CD          
              MOVE BA-RLSE-ALT-PHONE-NO(4:3)  TO WS-PH-NUM              
              MOVE BA-RLSE-ALT-PHONE-NO(7:4)  TO WS-PH-NUM-L4           
              MOVE WS-PHONE-FORMATD           TO RS-ALT-PHONE           
           END-IF.                                                      
                                                                        
C34590     PERFORM 7600-RLSE-BRIDGE-INFO      THRU 7600-EXIT.           
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       2850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2875-METER-DATE-ERROR                                          *        
      *     SEND ERROR MESSAGE IF METER INACTIVE/REMOVED DATE IN ERROR *        
      *                                                                *        
      *     CALLED BY:  2825A-GET-SUPPLIES-TP                          *        
      *                 2825B-GET-SUPPLIES-TP                          *        
      ******************************************************************        
       2875-METER-DATE-ERROR.                                           
                                                                        
           MOVE ZERO                    TO S-RETURN-CODE.               
           MOVE WS-E                    TO RS-RLSE-REQUIRED-FL.         
                                                                        
           IF PARM-CODE-UTIL-TYPE = WS-E                                
              MOVE WS-ERROR-MSG9        TO RS-MESSAGE                   
           ELSE                                                         
              MOVE WS-ERROR-MSG10       TO RS-MESSAGE                   
           END-IF.                                                      
                                                                        
C34590     PERFORM 7600-RLSE-BRIDGE-INFO   THRU 7600-EXIT.              
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT.              
                                                                        
       2875-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2900-GET-RLSE-STAT-REAS.                                       *        
      *     CHECK IF THE METER STATUS REASON REQUIRES A RELEASE.       *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2900-GET-RLSE-STAT-REAS.                                         
                                                                        
           PERFORM 7500-GET-MTR-STAT-REAS  THRU 7500-EXIT               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE ZERO                    TO S-RETURN-CODE             
              MOVE WS-YES                  TO RS-RLSE-REQUIRED-FL       
              IF BA-ALT-MSG-CD      = WS-AA                             
                 MOVE BA-ALT-MSG-NO        TO RS-MESSAGE                
              ELSE                                                      
                 MOVE WS-MESSAGE           TO RS-MESSAGE                
                 MOVE WS-PHONE             TO RS-PHONE                  
              END-IF                                                    
              MOVE BM-ERROR-MSG-NO         TO RS-ADTL-MESSAGE           
C34590        PERFORM 7600-RLSE-BRIDGE-INFO   THRU 7600-EXIT            
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3000-CHECK-DATE-ERROR.                                         *        
      *     CHECK IF THE METER INAVTIVE/REMOVED DATE WAS NULL OR WAS   *        
      *     NOT THE SAME AS THE METER STATUS CHANGE DATE               *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       3000-CHECK-DATE-ERROR.                                           
                                                                        
           IF WS-DATE-MISMATCH = WS-YES                                 
              PERFORM 2675-METER-DATE-ERROR      THRU 2675-EXIT         
           ELSE                                                         
              IF WS-MISMATCH   = WS-YES                                 
                 PERFORM 2875-METER-DATE-ERROR   THRU 2875-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-GET-RLSE-REV-DIST.                                        *        
      *     GET ALL RELEASE INFORMATION.                               *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7000-GET-RLSE-REV-DIST.                                          
                                                                        
           EXEC SQL                                                     
              SELECT SET_NEW_SET_FL,                                    
                     ALT_MSG_CD,                                        
                     ALT_MSG_NO,                                        
                     SET_INSTAL_TSAW_FL,                                
                     ALT_TSAW_MSG_NO,                                   
                     GROUP_A_CD,                                        
                     LTRIM(RTRIM(METER_INACTIVE_TP)),                          
                     LTRIM(RTRIM(METER_REMOVED_TP)),                           
                     RLSE_EXEMPT_MSG_FL,                                
                     RLSE_PHONE_NO,                                     
                     RLSE_ALT_PHONE_NO                                  
                INTO :BA-SET-NEW-SET-FL,                                
                     :BA-ALT-MSG-CD,                                    
                     :BA-ALT-MSG-NO,                                    
                     :BA-SET-INSTAL-TSAW-FL,                            
                     :BA-ALT-TSAW-MSG-NO,                               
                     :BA-GROUP-A-CD,                                    
                     :BA-METER-INACTIVE-TP,                             
                     :BA-METER-REMOVED-TP,                              
                     :BA-RLSE-EXEMPT-MSG-FL,                            
                     :BA-RLSE-PHONE-NO,                                 
                     :BA-RLSE-ALT-PHONE-NO                              
                FROM CSS_RLSE_REV_DIST WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO         = :BA-COMPANY-NO                
                 AND REV_DISTRICT_CD    = :BA-REV-DISTRICT-CD           
                 AND CODE_UTIL_TYPE     = :BA-CODE-UTIL-TYPE            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SET_NEW_SET_FL,                                            
MFA-TR*              ALT_MSG_CD,                                                
MFA-TR*              ALT_MSG_NO,                                                
MFA-TR*              SET_INSTAL_TSAW_FL,                                        
MFA-TR*              ALT_TSAW_MSG_NO,                                           
MFA-TR*              GROUP_A_CD,                                                
MFA-TR*              STRIP(METER_INACTIVE_TP),                                  
MFA-TR*              STRIP(METER_REMOVED_TP),                                   
MFA-TR*              RLSE_EXEMPT_MSG_FL,                                        
MFA-TR*              RLSE_PHONE_NO,                                             
MFA-TR*              RLSE_ALT_PHONE_NO                                          
MFA-TR*         INTO :BA-SET-NEW-SET-FL,                                        
MFA-TR*              :BA-ALT-MSG-CD,                                            
MFA-TR*              :BA-ALT-MSG-NO,                                            
MFA-TR*              :BA-SET-INSTAL-TSAW-FL,                                    
MFA-TR*              :BA-ALT-TSAW-MSG-NO,                                       
MFA-TR*              :BA-GROUP-A-CD,                                            
MFA-TR*              :BA-METER-INACTIVE-TP,                                     
MFA-TR*              :BA-METER-REMOVED-TP,                                      
MFA-TR*              :BA-RLSE-EXEMPT-MSG-FL,                                    
MFA-TR*              :BA-RLSE-PHONE-NO,                                         
MFA-TR*              :BA-RLSE-ALT-PHONE-NO                                      
MFA-TR*         FROM CSS_RLSE_REV_DIST                                          
MFA-TR*        WHERE COMPANY_NO         = :BA-COMPANY-NO                        
MFA-TR*          AND REV_DISTRICT_CD    = :BA-REV-DISTRICT-CD                   
MFA-TR*          AND CODE_UTIL_TYPE     = :BA-CODE-UTIL-TYPE                    
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RLSE_REV_DIST'        TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE BA-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'REV_DISTRICT_CD'          TO TABLE-ELEMENT-2        
              MOVE BA-REV-DISTRICT-CD         TO HOSTVAR-ELEMENT-2      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE BA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7025-REV-DIST-EXIST.                                           *        
      *     VERIFY IF AN ENTRY EXIST IN TABLE FOR THAT REV DISTRICT    *        
      *     IF NOT THEN THE REV DIST DETAILS ARE MISSING AND IN ERROR  *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7025-REV-DIST-EXIST.                                             
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-REV-DIST-EXISTS                                
                FROM CSS_RLSE_REV_DIST WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO         = :BA-COMPANY-NO                
                 AND REV_DISTRICT_CD    = :BA-REV-DISTRICT-CD           
                 AND CODE_UTIL_TYPE     IN ('E','G')                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-REV-DIST-EXISTS                                        
MFA-TR*         FROM CSS_RLSE_REV_DIST                                          
MFA-TR*        WHERE COMPANY_NO         = :BA-COMPANY-NO                        
MFA-TR*          AND REV_DISTRICT_CD    = :BA-REV-DISTRICT-CD                   
MFA-TR*          AND CODE_UTIL_TYPE     IN ('E','G')                            
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7025'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RLSE_REV_DIST'        TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE BA-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'REV_DISTRICT_CD'          TO TABLE-ELEMENT-2        
              MOVE BA-REV-DISTRICT-CD         TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-GET-REV-DIST-DESC                                         *        
      *     GET THE REVENUE DISTRICT DESCRIPTION                       *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7050-GET-REV-DIST-DESC.                                          
                                                                        
           EXEC SQL                                                     
              SELECT REV_DISTRICT_DESC                                  
                INTO :A9-REV-DISTRICT-DESC                              
                FROM CSS_REV_DISTRICT WITH(READUNCOMMITTED)                     
               WHERE REV_DISTRICT_CD    = :A9-REV-DISTRICT-CD           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REV_DISTRICT_DESC                                          
MFA-TR*         INTO :A9-REV-DISTRICT-DESC                                      
MFA-TR*         FROM CSS_REV_DISTRICT                                           
MFA-TR*        WHERE REV_DISTRICT_CD    = :A9-REV-DISTRICT-CD                   
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_REV_DISTRICT'         TO TABLE-1                
              MOVE 'REV_DISTRICT_CD'          TO TABLE-ELEMENT-1        
              MOVE A9-REV-DISTRICT-CD         TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-METER-TP-DTLS.                                            *        
      *     GET THE METER INACTIVE AND REMOVED TIME PERIODS.           *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7100-METER-TP-DTLS.                                              
                                                                        
DT9497     MOVE SPACE TO MN-CODE-METER-STATUS.                          
           EXEC SQL                                                     
              SELECT METER_INACTIVE_DT,                                 
                     METER_REMOVED_DT,                                  
                     CODE_METER_STATUS,                                 
                     MTR_STATUS_CHNG_DT                                 
                INTO :MN-METER-INACTIVE-DT :WS-MTR-INACTIVE-NULL,        
                     :MN-METER-REMOVED-DT :WS-MTR-REMOVED-NULL,          
                     :MN-CODE-METER-STATUS,                             
                     :MN-MTR-STATUS-CHNG-DT :WS-MTR-STATUS-CHNG-NULL     
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO         = :MN-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = :MN-CODE-UTIL-TYPE            
                 AND IC_NO              = :MN-IC-NO                     
                 AND MTR_REF_NO         = :MN-MTR-REF-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_INACTIVE_DT,                                         
MFA-TR*              METER_REMOVED_DT,                                          
MFA-TR*              CODE_METER_STATUS,                                         
MFA-TR*              MTR_STATUS_CHNG_DT                                         
MFA-TR*         INTO :MN-METER-INACTIVE-DT:WS-MTR-INACTIVE-NULL,                
MFA-TR*              :MN-METER-REMOVED-DT:WS-MTR-REMOVED-NULL,                  
MFA-TR*              :MN-CODE-METER-STATUS,                                     
MFA-TR*              :MN-MTR-STATUS-CHNG-DT:WS-MTR-STATUS-CHNG-NULL             
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO         = :MN-ACCOUNT-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :MN-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :MN-IC-NO                             
MFA-TR*          AND MTR_REF_NO         = :MN-MTR-REF-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE MN-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE MN-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE 'MTR_REF_NO'               TO TABLE-ELEMENT-4        
              MOVE MN-MTR-REF-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-CALC-NEW-DATE                                             *        
      *     DETERMINE THE INACTIVE/REMOVED TIME PERIOD FOR THE METER.  *        
      *                                                                *        
      *     CALLED BY:  2600-MTR-INACTIVE-TP                           *        
      ******************************************************************        
       7200-CALC-NEW-DATE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, :WS-METER-TIME-PERIOD, 
              IIF(TRY_CONVERT(DATE, :WS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE) <> 0) OR (LEN(
                                                               :WS-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-DATE), CONVERT(DATE, :WS-DATE
              ) ) )
            INTO
              :WS-NEW-DATE        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-NEW-DATE =                                                
MFA-TR*            DATE(:WS-DATE) + :WS-METER-TIME-PERIOD MONTHS                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
              MOVE 'DATE '                    TO TABLE-ELEMENT-1        
              MOVE WS-DATE                    TO HOSTVAR-ELEMENT-1      
              MOVE 'TP   '                    TO TABLE-ELEMENT-2        
              MOVE WS-METER-TIME-PERIOD       TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-CALC-METER-TP                                             *        
      *     DETERMINE THE INACTIVE/REMOVED TIME PERIOD FOR THE METER.  *        
      *                                                                *        
      *     CALLED BY:  2600-MTR-INACTIVE-TP                           *        
      *                 2700-MTR-REMOVED-TP                            *        
      ******************************************************************        
       7300-CALC-METER-TP.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-WANTED-BY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WANTED-BY-DATE
              ) <> 0) OR (LEN(:WS-WANTED-BY-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-WANTED-BY-DATE
              ), CONVERT(DATE, :WS-WANTED-BY-DATE) ) ) - CIS.DAYS( 
              IIF(TRY_CONVERT(DATE, :WS-NEW-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-DATE
              ) <> 0) OR (LEN(:WS-NEW-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-NEW-DATE
              ), CONVERT(DATE, :WS-NEW-DATE) ) )
            INTO
              :WS-DAYS        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DAYS =                                                    
MFA-TR*            DAYS(:WS-WANTED-BY-DATE) - DAYS(:WS-NEW-DATE)                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
              MOVE 'NEW DATE '                TO TABLE-ELEMENT-1        
              MOVE WS-NEW-DATE                TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-GET-MTR-SUPPLIES.                                         *        
      *     GETS THE MESSAGE AND PHONE# FOR THE SUPPLIES THAT NEEDS A  *        
      *     RELEASE.                                                   *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7400-GET-MTR-SUPPLIES.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ERROR_MSG_NO,                                      
                     ALT_PHONE_FL,                                      
                     METER_INACTIVE_TP,                                 
A01628               RLSE_CHECK_CD,                                     
A01628               EXCEPTION_MSG_NO                                   
                INTO :BB-ERROR-MSG-NO,                                  
                     :BB-ALT-PHONE-FL,                                  
                     :BB-METER-INACTIVE-TP,                             
A01628               :BB-RLSE-CHECK-CD,                                 
A01628               :BB-EXCEPTION-MSG-NO                               
                FROM CSS_RLSE_SUPPLIES WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO         = :BB-COMPANY-NO                
                 AND REV_DISTRICT_CD    = :BB-REV-DISTRICT-CD           
                 AND CODE_UTIL_TYPE     = :BB-CODE-UTIL-TYPE            
                 AND METER_SUPPLYING_CD = :BB-METER-SUPPLYING-CD        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ERROR_MSG_NO,                                              
MFA-TR*              ALT_PHONE_FL,                                              
MFA-TR*              METER_INACTIVE_TP,                                         
MFA-TR*              RLSE_CHECK_CD,                                             
MFA-TR*              EXCEPTION_MSG_NO                                           
MFA-TR*         INTO :BB-ERROR-MSG-NO,                                          
MFA-TR*              :BB-ALT-PHONE-FL,                                          
MFA-TR*              :BB-METER-INACTIVE-TP,                                     
MFA-TR*              :BB-RLSE-CHECK-CD,                                         
MFA-TR*              :BB-EXCEPTION-MSG-NO                                       
MFA-TR*         FROM CSS_RLSE_SUPPLIES                                          
MFA-TR*        WHERE COMPANY_NO         = :BB-COMPANY-NO                        
MFA-TR*          AND REV_DISTRICT_CD    = :BB-REV-DISTRICT-CD                   
MFA-TR*          AND CODE_UTIL_TYPE     = :BB-CODE-UTIL-TYPE                    
MFA-TR*          AND METER_SUPPLYING_CD = :BB-METER-SUPPLYING-CD                
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RLSE_SUPPLIES'        TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE BB-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'REV_DISTRICT_CD'          TO TABLE-ELEMENT-2        
              MOVE BB-REV-DISTRICT-CD         TO HOSTVAR-ELEMENT-2      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE BB-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE 'METER_SUPPLYING_CD'       TO TABLE-ELEMENT-4        
              MOVE BB-METER-SUPPLYING-CD      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-GET-MTR-STAT-REAS.                                        *        
      *     GET THE ADDITIONAL RELEASE REQUIRING MESSAGE.              *        
      *                                                                *        
      *     CALLED BY:  2900-GET-RLSE-STAT-REAS                        *        
      ******************************************************************        
       7500-GET-MTR-STAT-REAS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT ERROR_MSG_NO                                       
                INTO :BM-ERROR-MSG-NO                                   
                FROM CSS_RLSE_STAT_REAS WITH(READUNCOMMITTED)                   
               WHERE COMPANY_NO         = :BM-COMPANY-NO                
                 AND REV_DISTRICT_CD    = :BM-REV-DISTRICT-CD           
                 AND CODE_UTIL_TYPE     = :BM-CODE-UTIL-TYPE            
                 AND CODE_STATUS_REAS   = :BM-CODE-STATUS-REAS          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ERROR_MSG_NO                                               
MFA-TR*         INTO :BM-ERROR-MSG-NO                                           
MFA-TR*         FROM CSS_RLSE_STAT_REAS                                         
MFA-TR*        WHERE COMPANY_NO         = :BM-COMPANY-NO                        
MFA-TR*          AND REV_DISTRICT_CD    = :BM-REV-DISTRICT-CD                   
MFA-TR*          AND CODE_UTIL_TYPE     = :BM-CODE-UTIL-TYPE                    
MFA-TR*          AND CODE_STATUS_REAS   = :BM-CODE-STATUS-REAS                  
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RLSE_STAT_REAS'       TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE BM-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'REV_DISTRICT_CD'          TO TABLE-ELEMENT-2        
              MOVE BM-REV-DISTRICT-CD         TO HOSTVAR-ELEMENT-2      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE BM-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE 'CODE_STATUS_REAS'         TO TABLE-ELEMENT-4        
              MOVE BM-CODE-STATUS-REAS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
C34590                                                                  
C34590******************************************************************        
C34590* 7600-RLSE-BRIDGE-INFO.                                         *        
C34590*     CHECK IF RELEASE BRIDGES OR NOT AND SEND RLSE NO DETAILS   *        
C34590*                                                                *        
C34590*     CALLED BY:                                                 *        
C34590******************************************************************        
C34590 7600-RLSE-BRIDGE-INFO.                                           
C34590                                                                  
C34590     EXEC SQL                                                     
C34590          SELECT TOP(1) 'Y',
              RE.RLSE_NO                                       
C34590            INTO :RS-RLSE-EXISTS,                                 
C34590                 :RS-RLSE-NO                                      
C34590            FROM CSS_PREM_RLSE_DATA RP WITH(READUNCOMMITTED),             
C34590                 CSS_PREM_RLSE      RE WITH(READUNCOMMITTED)              
C34590           WHERE RP.PREMISE_NO       = :RP-PREMISE-NO             
C34590             AND RP.RLSE_NO          = RE.RLSE_NO                 
C34590             AND RP.REV_DISTRICT_CD  = RE.REV_DISTRICT_CD         
C34590             AND RP.REV_DISTRICT_CD  = :RP-REV-DISTRICT-CD        
C34590             AND RE.RLSE_TYPE        = :RE-RLSE-TYPE              
C34590             AND RE.RLSE_SUPPLIES    = :RE-RLSE-SUPPLIES          
C34590             AND RE.RLSE_EXP_DATE   >= CIS.CURRENT$TIMESTAMP()          
A04670                                           
C34590                                                           
                                                            
C34590     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y',                                                     
MFA-TR*                RE.RLSE_NO                                               
MFA-TR*           INTO :RS-RLSE-EXISTS,                                         
MFA-TR*                :RS-RLSE-NO                                              
MFA-TR*           FROM CSS_PREM_RLSE_DATA RP,                                   
MFA-TR*                CSS_PREM_RLSE      RE                                    
MFA-TR*          WHERE RP.PREMISE_NO       = :RP-PREMISE-NO                     
MFA-TR*            AND RP.RLSE_NO          = RE.RLSE_NO                         
MFA-TR*            AND RP.REV_DISTRICT_CD  = RE.REV_DISTRICT_CD                 
MFA-TR*            AND RP.REV_DISTRICT_CD  = :RP-REV-DISTRICT-CD                
MFA-TR*            AND RE.RLSE_TYPE        = :RE-RLSE-TYPE                      
MFA-TR*            AND RE.RLSE_SUPPLIES    = :RE-RLSE-SUPPLIES                  
MFA-TR*            AND RE.RLSE_EXP_DATE   >= CURRENT TIMESTAMP                  
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*           WITH UR                                                       
MFA-TR*          QUERYNO 7600                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34590                                                                  
C34590     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
C34590                                           S-RETURN-CODE.         
C34590                                                                  
C34590     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C34590        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C34590           MOVE WS-NO                   TO RS-RLSE-EXISTS         
C34590           MOVE SPACES                  TO RS-RLSE-NO             
C34590        END-IF                                                    
C34590     ELSE                                                         
C34590        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C34590        MOVE '7600'                     TO ACTIVE-PARAGRAPH       
C34590        MOVE 'SELECT'                   TO ABEND-FUNCTION         
C34590        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C34590                                           ABEND-TABLES           
C34590        MOVE 'CSS_PREM_RLSE'            TO TABLE-1                
C34590        MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
C34590        MOVE RP-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
C34590        MOVE 'REV_DISTRICT_CD'          TO TABLE-ELEMENT-2        
C34590        MOVE RP-REV-DISTRICT-CD         TO HOSTVAR-ELEMENT-2      
C34590        MOVE 'RLSE_TYPE'                TO TABLE-ELEMENT-3        
C34590        MOVE RE-RLSE-TYPE               TO HOSTVAR-ELEMENT-3      
C34590        MOVE 'RLSE_SUPPLIES'            TO TABLE-ELEMENT-4        
C34590        MOVE RE-RLSE-SUPPLIES           TO HOSTVAR-ELEMENT-4      
C34590        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C34590        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C34590     END-IF.                                                      
C34590                                                                  
C34590 7600-EXIT.                                                       
C34590     EXIT.                                                        
C34590                                                                  
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
