       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04007.                                         
       DATE-WRITTEN. JUL 26, 2007.                                      
       DATE-COMPILED.                                                   
                                                                        
      *---------------------------------------------------------------- 00060000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00070000
      *---------------------------------------------------------------- 00080000
      *--                   STORED PROCEDURE:  CSR04007              -- 00090000
      *---------------------------------------------------------------- 00100000
      *--                         S U M M A R Y                      -- 00110000
      *--                                                            -- 00120000
      *--  CSR04007:                                                 -- 00130000
      *--                                                            -- 00140000
      *--  # RETURNS RENEWAL OPTION CODES FOR A SPECIFIC OPTION CODE -- 00150000
      *--                                                            -- 00160000
      *---------------------------------------------------------------- 00170000
      *--                                                            -- 00180000
      *--  PARAMETERS                                                -- 00190000
      *--                                                            -- 00200000
      *--      IN                                                    -- 00210000
      *--            OPTION_CD             CHAR(12)                  -- 00220000
      *--            ACCOUNT_NO            CHAR(13)                  -- 00230000
      *--            CODE_UTIL_TYPE        CHAR(01)                  -- 00240000
      *--            IC_NO                 CHAR(04)                  -- 00250000
P00836*--            PROCESS_TYPE_CD       CHAR(01)                  -- 00250000
      *--                                                            -- 00260000
      *--      OUT                                                   -- 00270000
      *--            OPTION_CD             CHAR(12)                  -- 00280000
      *--            OFFER_CD              CHAR(12)                  -- 00281007
      *--            THERM_PRICE           DECIMAL(11,6)             -- 00300000
      *--            EXIT_FEE              DECIMAL(11,6)             -- 00301006
      *--            TIER_SORUCE_CD        CHAR(02)                  -- 00302006
      *--            OPTN_VALID_MNTHS      SMALLINT                  -- 00310000
      *--            RATE_CALC_TYPE_CD     CHAR(02)                  -- 00320000
      *--            CSC_AMT               DECIMAL(11,6)             -- 00330000
      *--            CSC_REFND_FL          CHAR(01)                  -- 00340000
      *--            CSC_MNTHS             SMALLINT                  -- 00341006
      *--            RATE_DEFINITION_CD    CHAR(01)                  -- 00342012
      *--            CURR_EXT_DESC_LONG    CHAR(255)                 -- 00350008
      *--            RENEWAL_DESC_LONG     CHAR(255)                 -- 00352009
      *--            OPT_DESC_INT_LONG     CHAR(255)                 -- 00353006
P00581*--            ACCOUNT_TYPE_CODE     CHAR(01)                  --         
P00805*--            PRINT_RETN_MSG_FL     CHAR(01)                  --         
P00805*--            AMT_RETN_DISCOUNT     DECIMAL(5,2)              --         
P00805*--            RENEW_BY_DATE         CHAR(10)                  --         
P00805*--            NEW_RATE_BEGINS_DATE  CHAR(10)                  --         
P00805*--            PRINT_BBP_MSG_FL      CHAR(01)                  --         
PRJ805*--            IS_RENEWAL_OPTN_FLEX  CHAR(01)                  --         
A05037*--            CORE_RATE_PLAN_NO     CHAR(03)                  --         
A05037*--            CORE_RATE_PLAN_DDDC   DECIMAL(5,2)              --         
P00836*--            OPTION_PROMO_DESC     CHAR(255)                 -- 00352009
P00836*--            WEB_MKT_DESC_LONG     VARCHAR(1024)             -- 00352009
P00892*--            AUTO_RENEWAL_FL       CHAR(01)                  -- 00352009
P00836*--            SENIOR_RATE_FL        CHAR(01)                  --         
      *--                                                            -- 00353006
P00836*--            BUSINESS RULES                                  --         
      *--      INOUT                                                 -- 00360000
      *--                                                            -- 00370000
      *--            NONE                                            -- 00380000
      *--                                                            -- 00390000
      *--  RESULT SET                                                -- 00400000
      *--                                                            -- 00410000
      *--     1                                                      -- 00420000
      *--                                                            -- 00430000
      *---------------------------------------------------------------- 00440000
      *--                        MODIFICATION LOG                    -- 00450000
      *--                                                            -- 00460000
      *--  DATE          INITIALS    COMMENTS                        -- 00470000
      *--  -----------   --------    ---------------------------------- 00480000
      *--  07/26/2007    VY95550     PROGRAM INITIALLY WRITTEN.      -- 00490000
P00396*--  06/01/2010    VY95550     ADDED SORT_SEQ_NO               -- 00460000
P00581*--  11/21/2011    SS97726     SCANA ENERGY FEE INCREASES. ADD --         
P00581*--                            ACCOUNT_TYPE_CODE TO RESULT SET.--         
P00473*--  11/22/2011    SB93596     CHGS INCLUDED TO PULL APPROVED  --         
P00473*--                            OPTION RECORD.                  --         
A04019*--  05/24/2012    VIJAY       SEB CSC CHANGES.                --         
JC4019*--  08/08/2012    JC91900     Temp fix. Commercial CSC.       --         
JC4019*--  09/12/2012    JC91900     Remove temp fix.                --         
P00805*--  02/24/2014    SS97726     Extended Renewal - Web Messaging--         
P00805*--                            Changes.                        --         
PRJ805*--  04/22/2014    SS97726     Pass Flex attribute flag for the--         
PRJ805*--                            Renewal Options.                --         
A05037*--  09/25/2014    SS97726     Pass DDDC Value.                --         
A05043*--  11/19/2014    SS97726     Lower Sr. Discount.             --         
P00836*--  03/24/2015    SS97726     Web Channel Modernization.      --         
P00892*--  04/13/2015    VIJAY       FIXED RATE AUTO RENEWAL CHANGES.--         
OTPOOL*--  08/17/2016    SS45239     OUTER POOL GROUP CHANGES.       --         
      *---------------------------------------------------------------- 00500000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04007'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                       PIC X(40)                     
           VALUE 'WORKING STORAGE FOR CSR04007 STARTS HERE'.            
                                                                        
      ******************************************************************00590000
      *    WORK AREAS                                                  *00600000
      ******************************************************************00610000
       01  PARM-FIELDS.                                                 
           05  PARM-L                     PIC  S9(9) COMP.              
           05  PARM-OPTION-CD             PIC  X(12).                   
           05  PARM-ACCOUNT-NO            PIC  X(13) VALUE SPACES.      
           05  PARM-ACCOUNT-NO-NUM        PIC  9(13).                   
COB305     05 PARM-ACCOUNT-NO-DEC        PIC  S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05  PARM-CODE-UTIL-TYPE        PIC  X(01).                   
           05  PARM-IC-NO                 PIC  X(04) VALUE SPACES.      
           05  PARM-IC-NO-NUM             PIC  9(04).                   
           05  PARM-IC-NO-DEC             PIC  S9(04) USAGE COMP.       
P00836     05  PARM-PROCESS-TYPE-CD       PIC  X(01) VALUE SPACES.      
      *                                                                 00740000
       01  GTT-RETURN-FIELDS.                                           
P00836     05  GTT-RETURN-FIELDS-1.                                     
               10  S-RETURN-CODE-1        PIC S9(09) COMP VALUE 0.      
               10  S-OPTION-CD            PIC  X(12) VALUE SPACES.      
               10  S-OFFER-CD             PIC  X(12) VALUE SPACES.      
COB305         10 S-THERM-PRICE        PIC S9(5)V9(6) USAGE COMP-3 
COB305           VALUE 0.  
COB305         10 S-EXIT-FEE        PIC S9(5)V9(6) USAGE COMP-3 VALUE 0.  
               10  S-TIER-SOURCE-CD       PIC  X(02) VALUE SPACES.      
               10  S-OPTN-VALID-MNTHS     PIC S9(4) USAGE COMP.         
               10  S-RATE-CALC-TYPE-CD    PIC  X(2)  VALUE SPACES.      
COB305         10 S-CSC-AMT        PIC S9(5)V9(6) USAGE COMP-3 VALUE 0.  
               10  S-CSC-REFND-FL         PIC  X(1)  VALUE SPACES.      
               10  S-CSC-MNTHS            PIC S9(4) USAGE COMP.         
               10  S-RATE-DEFINITION-CD   PIC  X(1)  VALUE SPACES.      
               10  S-CURR-EXT-DESC-LONG   PIC X(255) VALUE SPACES.      
               10  S-RENEWAL-DESC-LONG    PIC X(255) VALUE SPACES.      
P00836         10  S-OPTION-PROMO-DESC    PIC X(255) VALUE SPACES.      
P00836         10  S-WEB-MKT-DESC-LONG.                                 
P00836             49 S-WEB-MKT-DESC-LONG-LEN                           
P00836                                    PIC S9(4) COMP SYNC VALUE +0. 
P00836             49 S-WEB-MKT-DESC-LONG-TEXT                          
P00836                                    PIC X(1024) VALUE SPACES.     
               10  S-OPT-DESC-INT-LONG    PIC X(255) VALUE SPACES.      
P00396         10  S-SORT-SEQ-NO          PIC S9(4) USAGE COMP.         
P00581         10  S-ACCOUNT-TYPE-CODE    PIC X(01)  VALUE SPACES.      
P00805         10  S-PRINT-RETN-MSG-FL    PIC X(01)  VALUE SPACES.      
COB305         10 S-AMT-RETN-DISCOUNT        PIC S9(3)V9(2) 
COB305           USAGE COMP-3 VALUE 0.  
P00805         10  S-RENEW-BY-DATE        PIC X(10)  VALUE SPACES.      
P00805         10  S-NEW-RATE-BEGINS-DATE PIC X(10)  VALUE SPACES.      
P00805         10  S-PRINT-BBP-MSG-FL     PIC X(01)  VALUE SPACES.      
PRJ805         10  S-IS-RENEWAL-OPTN-FLEX PIC X(01)  VALUE SPACES.      
A05037         10  S-CORE-RATE-PLAN-NO    PIC X(03)  VALUE SPACES.      
COB305         10 S-CORE-RATE-PLAN-DDDC        PIC S9(3)V9(2) 
COB305           USAGE COMP-3 VALUE 0.  
P00892         10  S-AUTO-RENEWAL-FL      PIC X(01)  VALUE SPACES.      
P00836         10  S-SENIOR-RATE-FL       PIC X(01)  VALUE SPACES.      
P00836     05  GTT-RETURN-FIELDS-2.                                     
P00836         10  S-RETURN-CODE-2        PIC S9(9) COMP VALUE 0.       
P00836         10  S-BUS-RULE-MSG-ID      PIC X(10)  VALUE SPACES.      
P00836         10  S-BUS-RULE-RESULT-CD   PIC X(10)  VALUE SPACES.      
P00836         10  S-BUS-RULE-XREF-ID     PIC X(26)  VALUE SPACES.      
P00836         10  S-MESSAGE-PARMS.                                     
P00836             49 S-MESSAGE-PARMS-LEN PIC S9(4) COMP SYNC VALUE +0. 
P00836             49 S-MESSAGE-PARMS-TEXT                              
P00836                                    PIC X(300) VALUE SPACES.      
P00836         10  S-LINK-PARMS           PIC X(200) VALUE SPACES.      
                                                                        
       01  WS-GENERAL-WORKING-STORAGE.                                  
           05  MCSCB328                  PIC X(08) VALUE 'MCSCB328'.    
P00836     05  RS-RETURN-CODE-1          PIC S9(04) COMP VALUE 0.       
P00836     05  RS-RETURN-CODE-2          PIC S9(04) COMP VALUE 0.       
P00836     05  WS-GTT01-DECLARED         PIC X(01) VALUE 'N'.           
P00836     05  WS-GTT02-DECLARED         PIC X(01) VALUE 'N'.           
           05  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
           05  WS-CTR                    PIC S9(3) VALUE 0.             
           05  WS-ACCOUNT-NO-JST         PIC X(13) JUSTIFIED RIGHT.     
           05  WS-IC-NO-JST              PIC X(04) JUSTIFIED RIGHT.     
           05  WS-RATE-DEFINITION-CD     PIC X(01) VALUE SPACES.        
P00581     05  WS-ACCOUNT-TYPE-CODE      PIC X(01) VALUE SPACES.        
A04019     05  WS-CSC-AMT-DESC           PIC $Z9.99.                    
A04019     05  WS-CSC-LIT-DESC           PIC X(04) VALUE ' CSC'.        
P00805     05  WS-REV-MONTH-NUM          PIC 9(06) VALUE ZEROES.        
P00805     05  WS-REV-MONTH-CHAR         REDEFINES WS-REV-MONTH-NUM     
P00805                                   PIC X(06).                     
P00805     05  WS-REV-MONTH-DT           PIC X(10) VALUE SPACES.        
P00805     05  WS-REV-MONTH-PLUS-DT      PIC X(10) VALUE SPACES.        
P00805     05  WS-REV-MONTH-PLUS-NUM     PIC 9(06) VALUE ZEROES.        
P00805     05  WS-DURATION-REM-NUM       PIC S9(9) COMP VALUE 0.        
P00805     05  WS-NULL-01                PIC S9(4) COMP VALUE +0.       
P00805     05  WS-NULL-02                PIC S9(4) COMP VALUE +0.       
P00805     05  WS-PARM-DT                PIC X(10) VALUE SPACES.        
P00805     05  WS-BBP-ANNV-REV-MTH-NUM   PIC 9(06) VALUE ZEROES.        
P00805     05  WS-CODE-BUDGET-PLAN       PIC X(01) VALUE SPACES.        
P00836     05  WS-RULE-XREF-ID           PIC X(26) VALUE SPACES.        
P00836     05  WS-RULE-RESULT-CD         PIC X(10) VALUE SPACES.        
P00836     05  WS-RULE-ID                PIC X(10) VALUE SPACES.        
P00836     05  WS-RULE-MESSAGE-ID        PIC X(10) VALUE SPACES.        
P00836     05  WS-COMP-NO                PIC X(02) VALUE SPACES.        
P00836     05  WS-MM                     PIC X(02) VALUE SPACES.        
P00836     05  WS-MONTH                  PIC X(11) VALUE SPACES.        
P00836     05  WS-FMT-THERM-PRICE        PIC $9.9(4) VALUE ZEROS.       
P00836     05  WS-FMT-CSC-AMOUNT         PIC $$9.99  VALUE ZEROS.       
P00836     05  WS-FMT-EXIT-FEE           PIC $$$9.99 VALUE ZEROS.       
P00836     05  WS-FMT-DDDC               PIC $9.9(2)  VALUE ZEROS.      
P00836     05  WS-VARIABLE-RATE          PIC X(01) VALUE SPACES.        
OTPOOL     05  WS-POOL-GO-DATE           PIC X(10) VALUE SPACES.        
OTPOOL     05  WS-OUTER-POOL-MSG-FL      PIC X(01) VALUE SPACES.        
                                                                        
P00836 01  COUNTER-FIELDS.                                              
P00836     05  CTR-ROWS-RS1              PIC S9(9) COMP VALUE 0.        
P00836     05  CTR-ROWS-RS2              PIC S9(9) COMP VALUE 0.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
P00836     05  BUS-RULE-SW               PIC X(01) VALUE 'Y'.           
P00836         88 BUS-RULE-NOT-FOUND               VALUE 'N'.           
P00836         88 BUS-RULE-FOUND                   VALUE 'Y'.           
P00836     05  END-SEARCH-SW             PIC X(01) VALUE 'Y'.           
P00836         88 NOT-END-OF-SEARCH                VALUE 'N'.           
P00836         88 END-OF-SEARCH                    VALUE 'Y'.           
P00836     05  WS-FLEX-RATE-SW           PIC X(01) VALUE 'Y'.           
P00836         88 FLEX-RATE-NOT-FOUND              VALUE 'N'.           
P00836         88 FLEX-RATE-FOUND                  VALUE 'Y'.           
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04007'.    
P00836     05  PROGRAM-NAME-RTCHG        PIC X(08) VALUE 'CSR4007C'.    
                                                                        
P00836 01  WS-RULES-TABLE.                                              
P00836     05  BUS-RULES                 OCCURS 300                     
P00836                                   INDEXED BY BUS-RULE-INDX.      
P00836         10  BUS-RULE-ID           PIC X(10).                     
P00836         10  BUS-RULE-XREF-ID      PIC X(26).                     
P00836         10  BUS-RULE-COMPANY-NO   PIC X(02).                     
P00836         10  BUS-RULE-MESSAGE-ID   PIC X(10).                     
P00836         10  BUS-RULE-RESULT-CD    PIC X(10).                     
                                                                        
      ******************************************************************00881102
      *    DB2 INCLUDES                                                *00881202
      ******************************************************************00881302
           EXEC SQL                                                     00881402
              INCLUDE SQLCA                                             00881502
           END-EXEC.                                                    00881602
                                                                        
OTPOOL******************************************************************02620000
OTPOOL*    CSS_LOCAL_OFFICE - B1                                       *02630000
OTPOOL******************************************************************02640000
OTPOOL     EXEC SQL                                                     02660000
OTPOOL        INCLUDE TBLOCOFC                                          02670000
OTPOOL     END-EXEC.                                                    02680000
                                                                        
OTPOOL******************************************************************01330000
OTPOOL* CSS_JOB_PARM, G6                                               *01340000
OTPOOL******************************************************************01350000
OTPOOL     EXEC SQL                                                     01360000
OTPOOL        INCLUDE TBJBPARM                                          01370000
OTPOOL     END-EXEC.                                                    01380000
                                                                        
OTPOOL******************************************************************01470000
OTPOOL* CSS_ACCT_MKT_TIER, DD                                          *01480000
OTPOOL******************************************************************01490000
OTPOOL     EXEC SQL                                                     01500000
OTPOOL        INCLUDE TBMKTIER                                          01510000
OTPOOL     END-EXEC.                                                    01520000
                                                                        
      ******************************************************************00881812
      * CSS_RATE_PLAN_DESC, RD                                         *00881912
      ******************************************************************00882012
           EXEC SQL                                                     00882112
              INCLUDE TBRTDESC                                          00882212
           END-EXEC.                                                    00882312
                                                                        
      ******************************************************************00882512
      * CRM_RT_PKG_OPTION, FI                                          *00882612
      ******************************************************************00882712
           EXEC SQL                                                     00882812
              INCLUDE TBRTPKGO                                          00882912
           END-EXEC.                                                    00883012
                                                                        
P00581******************************************************************00882512
P00581* CSS_ACCOUNT, AT                                                *00882612
P00581******************************************************************00882712
P00581     EXEC SQL                                                     00882812
P00581        INCLUDE TBACCT                                            00882912
P00581     END-EXEC.                                                    00883012
P00581                                                                  
P00805******************************************************************        
P00805*    CSS_FIXED_FCTR,    FF                                       *        
P00805******************************************************************        
P00805     EXEC SQL                                                             
P00805         INCLUDE TBFXDFCT                                                 
P00805     END-EXEC.                                                            
P00805                                                                  
P00805******************************************************************        
P00805*    CSS_UTIL_ENVRNMT   UT                                       *        
P00805******************************************************************        
P00805     EXEC SQL                                                             
P00805        INCLUDE TBUTLENV                                                  
P00805     END-EXEC.                                                            
P00805                                                                  
P00805******************************************************************        
P00805*    CSS_BILL_WINDOW    BN                                       *        
P00805******************************************************************        
P00805     EXEC SQL                                                             
P00805        INCLUDE TBBILWDW                                                  
P00805     END-EXEC.                                                            
P00805                                                                  
P00805******************************************************************        
P00805*    CSS_BUDGET_PLAN    BU                                       *        
P00805******************************************************************        
P00805     EXEC SQL                                                             
P00805        INCLUDE TBBGTPLN                                                  
P00805     END-EXEC.                                                            
P00805                                                                  
P00836******************************************************************01610000
P00836* CSS_BUS_RULE_XREF, 1T                                          *01620000
P00836******************************************************************01630000
P00836     EXEC SQL                                                             
P00836        INCLUDE TBRULXRF                                                  
P00836     END-EXEC.                                                            
                                                                        
P00836******************************************************************01610000
P00836* CSS_BUS_RULE_ACTN, 1S                                          *01620000
P00836******************************************************************01630000
P00836     EXEC SQL                                                             
P00836        INCLUDE TBRULACT                                                  
P00836     END-EXEC.                                                            
                                                                        
P00836******************************************************************01540000
P00836* CSS_ACCT_RTPK_AGR, DF                                          *01550000
P00836******************************************************************01560000
P00836     EXEC SQL                                                     01570000
P00836        INCLUDE TBACCTRG                                          01580000
P00836     END-EXEC.                                                    01590000
                                                                        
      ******************************************************************00883212
      *    ERROR HANDLING COPY BOOK                                    *00883312
      ******************************************************************00883412
           EXEC SQL                                                     00883512
               INCLUDE CWSX0010                                         00883612
           END-EXEC.                                                    00883712
                                                                        
      ******************************************************************00883912
      *    SQL ERROR CHECKING COPYBOOK                                 *00884012
      ******************************************************************00884112
           COPY CWS00303.                                               00884212
                                                                        
      ******************************************************************00884412
      *    DB2 ERRROR PROCESSING COPYBOOK                              *00884512
      ******************************************************************00884612
           COPY CWSSP001.                                               00884712
                                                                        
      ******************************************************************00884912
      *    COPY BOOK TO GET RENEWAL OFFER CODE                         *00885012
      ******************************************************************00885112
            EXEC SQL                                                    00885212
              INCLUDE CWS00328                                          00885312
            END-EXEC.                                                   00885412
                                                                        
P00836******************************************************************01260000
P00836*    CURSOR DECLARATIONS                                         *01270000
P00836******************************************************************01280000
P00836     EXEC SQL                                                     
P00836          DECLARE RULE-CURSOR CURSOR FOR                          
P00836           SELECT [1T].BUS_RULE_ID                                  
P00836                 ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1T].BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                             
P00836                 ,[1T].COMPANY_NO                                   
P00836                 ,[1S].RULE_MESSAGE_ID                              
P00836                 ,[1S].RULE_RESULT_CD                               
P00836             FROM CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)            
P00836             JOIN CSS_BUS_RULE_ACTN [1S] WITH(READUNCOMMITTED)            
P00836               ON [1S].BUS_RULE_XREF_ID = [1T].BUS_RULE_XREF_ID       
P00836            WHERE BUS_PROCESS_ID = 'RATERENEW'                    
P00836              AND APPLICATION_ID = 'WEB'                          
P00836                                                           
P00836              FOR READ ONLY                                      
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE RULE-CURSOR CURSOR FOR                                  
MFA-TR*          SELECT 1T.BUS_RULE_ID                                          
MFA-TR*                ,1T.BUS_RULE_XREF_ID                                     
MFA-TR*                ,1T.COMPANY_NO                                           
MFA-TR*                ,1S.RULE_MESSAGE_ID                                      
MFA-TR*                ,1S.RULE_RESULT_CD                                       
MFA-TR*            FROM CSS_BUS_RULE_XREF 1T                                    
MFA-TR*            JOIN CSS_BUS_RULE_ACTN 1S                                    
MFA-TR*              ON 1S.BUS_RULE_XREF_ID = 1T.BUS_RULE_XREF_ID               
MFA-TR*           WHERE BUS_PROCESS_ID = 'RATERENEW'                            
MFA-TR*             AND APPLICATION_ID = 'WEB'                                  
MFA-TR*            WITH UR                                                      
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*           QUERYNO 7000                                                  
MFA-TR*    END-EXEC.                                                            
P00836                                                                  
       LINKAGE SECTION.                                                 
       01  LINK-OPTION-CD                PIC X(12).                     
       01  LINK-ACCOUNT-NO               PIC X(13).                     
       01  LINK-CODE-UTIL-TYPE           PIC X(01).                     
       01  LINK-IC-NO                    PIC X(04).                     
P00836 01  LINK-PROCESS-TYPE-CD          PIC X(01).                     
                                                                        
       PROCEDURE DIVISION USING LINK-OPTION-CD                          
                                LINK-ACCOUNT-NO                         
                                LINK-CODE-UTIL-TYPE                     
                                LINK-IC-NO                              
P00836                          LINK-PROCESS-TYPE-CD.                   
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************01140000
      **                                                              **01150000
      **    0000-MAINLINE                                             **01160000
      **                                                              **01170000
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **01180000
      **                                                              **01190000
      ******************************************************************01200000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INIT-SERVER    THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INIT-SERVER.                                                
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
               SELECT                                                   
                  RETURN_CODE                 AS RETURN_CODE            
                 ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD              
                 ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD               
                 ,THERM_PRICE                 AS THERM_PRICE            
                 ,EXIT_FEE                    AS EXIT_FEE               
                 ,TIER_SORUCE_CD              AS TIER_SORUCE_CD         
                 ,OPTN_VALID_MNTHS            AS OPTN_VALID_MNTHS       
                 ,LTRIM(RTRIM(RATE_CALC_TYPE_CD))    AS 
           RATE_CALC_TYPE_CD      
                 ,CSC_AMT                     AS CSC_AMT                
                 ,CSC_REFND_FL                AS CSC_REFND_FL           
                 ,CSC_MNTHS                   AS CSC_MNTHS              
                 ,RATE_DEFINITION_CD          AS RATE_DEFINITION_CD     
                 ,LTRIM(RTRIM(CURR_EXT_DESC_LONG))   AS 
           CURR_EXT_DESC_LONG     
                 ,LTRIM(RTRIM(RENEWAL_DESC_LONG))    AS 
           RENEWAL_DESC_LONG      
                 ,LTRIM(RTRIM(OPT_DESC_INT_LONG))    AS 
           OPT_DESC_INT_LONG      
P00581           ,ACCOUNT_TYPE_CODE           AS ACCOUNT_TYPE_CODE      
P00805           ,LTRIM(RTRIM(PRINT_RETN_MSG_FL))    AS 
           PRINT_RETN_MSG_FL      
P00805           ,AMT_RETN_DISCOUNT           AS AMT_RETN_DISCOUNT      
P00805           ,LTRIM(RTRIM(RENEW_BY_DATE))        AS RENEW_BY_DATE          
P00805           ,LTRIM(RTRIM(NEW_RATE_BEGINS_DATE)) AS 
           NEW_RATE_BEGINS_DATE   
P00805           ,LTRIM(RTRIM(PRINT_BBP_MSG_FL))     AS PRINT_BBP_MSG_FL       
PRJ805           ,LTRIM(RTRIM(IS_RENEWAL_OPTN_FLEX)) AS 
           IS_RENEWAL_OPTN_FLEX   
A05037           ,LTRIM(RTRIM(CORE_RATE_PLAN_NO))    AS 
           CORE_RATE_PLAN_NO      
A05037           ,CORE_RATE_PLAN_DDDC         AS CORE_RATE_PLAN_DDDC    
P00836           ,LTRIM(RTRIM(OPTION_PROMO_DESC))    AS 
           OPTION_PROMO_DESC      
P00836           ,LTRIM(RTRIM(WEB_MKT_DESC_LONG))    AS 
           WEB_MKT_DESC_LONG      
P00892           ,AUTO_RENEWAL_FL             AS AUTO_RENEWAL_FL        
P00836           ,LTRIM(RTRIM(SENIOR_RATE_FL))       AS SENIOR_RATE_FL         
                FROM #CSR04007_R1                                
P00396         ORDER BY SORT_SEQ_NO                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     01330000
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                          01340000
MFA-TR*        SELECT                                                   01350000
MFA-TR*           RETURN_CODE                 AS RETURN_CODE            01360000
MFA-TR*          ,STRIP(OPTION_CD)            AS OPTION_CD              01370000
MFA-TR*          ,STRIP(OFFER_CD)             AS OFFER_CD               01371007
MFA-TR*          ,THERM_PRICE                 AS THERM_PRICE            01390000
MFA-TR*          ,EXIT_FEE                    AS EXIT_FEE               01391005
MFA-TR*          ,TIER_SORUCE_CD              AS TIER_SORUCE_CD         01392005
MFA-TR*          ,OPTN_VALID_MNTHS            AS OPTN_VALID_MNTHS       01400000
MFA-TR*          ,STRIP(RATE_CALC_TYPE_CD)    AS RATE_CALC_TYPE_CD      01410000
MFA-TR*          ,CSC_AMT                     AS CSC_AMT                01420000
MFA-TR*          ,CSC_REFND_FL                AS CSC_REFND_FL           01430000
MFA-TR*          ,CSC_MNTHS                   AS CSC_MNTHS              01440000
MFA-TR*          ,RATE_DEFINITION_CD          AS RATE_DEFINITION_CD     01440112
MFA-TR*          ,STRIP(CURR_EXT_DESC_LONG)   AS CURR_EXT_DESC_LONG     01441008
MFA-TR*          ,STRIP(RENEWAL_DESC_LONG)    AS RENEWAL_DESC_LONG      01443008
MFA-TR*          ,STRIP(OPT_DESC_INT_LONG)    AS OPT_DESC_INT_LONG              
MFA-TR*          ,ACCOUNT_TYPE_CODE           AS ACCOUNT_TYPE_CODE              
MFA-TR*          ,STRIP(PRINT_RETN_MSG_FL)    AS PRINT_RETN_MSG_FL              
MFA-TR*          ,AMT_RETN_DISCOUNT           AS AMT_RETN_DISCOUNT              
MFA-TR*          ,STRIP(RENEW_BY_DATE)        AS RENEW_BY_DATE                  
MFA-TR*          ,STRIP(NEW_RATE_BEGINS_DATE) AS NEW_RATE_BEGINS_DATE           
MFA-TR*          ,STRIP(PRINT_BBP_MSG_FL)     AS PRINT_BBP_MSG_FL               
MFA-TR*          ,STRIP(IS_RENEWAL_OPTN_FLEX) AS IS_RENEWAL_OPTN_FLEX           
MFA-TR*          ,STRIP(CORE_RATE_PLAN_NO)    AS CORE_RATE_PLAN_NO              
MFA-TR*          ,CORE_RATE_PLAN_DDDC         AS CORE_RATE_PLAN_DDDC            
MFA-TR*          ,STRIP(OPTION_PROMO_DESC)    AS OPTION_PROMO_DESC      01443008
MFA-TR*          ,STRIP(WEB_MKT_DESC_LONG)    AS WEB_MKT_DESC_LONG      01443008
MFA-TR*          ,AUTO_RENEWAL_FL             AS AUTO_RENEWAL_FL        01443008
MFA-TR*          ,STRIP(SENIOR_RATE_FL)       AS SENIOR_RATE_FL         01443008
MFA-TR*         FROM SESSION.CSR04007_R1                                01450000
MFA-TR*        ORDER BY SORT_SEQ_NO                                             
MFA-TR*    END-EXEC.                                                    01460000
                                                                        
P00836     EXEC SQL                                                     
P00836        DECLARE C2 CURSOR  FOR                         
P00836         SELECT RETURN_CODE             AS RETURN_CODE            
P00836               ,LTRIM(RTRIM(BUS_RULE_MSG_ID))  AS BUS_RULE_MSG_ID        
P00836               ,LTRIM(RTRIM(RULE_RESULT_CD))   AS RULE_RESULT_CD         
P00836               ,LTRIM(RTRIM(BUS_RULE_XREF_ID)) AS BUS_RULE_XREF_ID       
P00836               ,LTRIM(RTRIM(MESSAGE_PARMS))    AS MESSAGE_PARMS          
P00836               ,LTRIM(RTRIM(LINK_PARMS))       AS LINK_PARMS             
P00836          FROM #CSR04007_R2                                
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT RETURN_CODE             AS RETURN_CODE                    
MFA-TR*              ,STRIP(BUS_RULE_MSG_ID)  AS BUS_RULE_MSG_ID                
MFA-TR*              ,STRIP(RULE_RESULT_CD)   AS RULE_RESULT_CD                 
MFA-TR*              ,STRIP(BUS_RULE_XREF_ID) AS BUS_RULE_XREF_ID               
MFA-TR*              ,STRIP(MESSAGE_PARMS)    AS MESSAGE_PARMS                  
MFA-TR*              ,STRIP(LINK_PARMS)       AS LINK_PARMS                     
MFA-TR*         FROM SESSION.CSR04007_R2                                02560000
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE LINK-OPTION-CD           TO PARM-OPTION-CD              
           MOVE LINK-ACCOUNT-NO          TO PARM-ACCOUNT-NO             
           MOVE LINK-CODE-UTIL-TYPE      TO PARM-CODE-UTIL-TYPE         
           MOVE LINK-IC-NO               TO PARM-IC-NO                  
P00836     MOVE LINK-PROCESS-TYPE-CD     TO PARM-PROCESS-TYPE-CD        
                                                                        
           PERFORM 0100A-DECLARE-GTT                                    
              THRU 0100A-EXIT                                           
P00836     PERFORM 0100B-DECLARE-GTT                                    
P00836        THRU 0100B-EXIT                                           
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04007_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04007_R1
              (                                                          
               RETURN_CODE           INT                            
              ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,THERM_PRICE           DECIMAL(11,6)                      
              ,EXIT_FEE              DECIMAL(11,6)                      
              ,TIER_SORUCE_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,OPTN_VALID_MNTHS      SMALLINT                           
              ,RATE_CALC_TYPE_CD CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                           
              ,CSC_AMT               DECIMAL(11,6)                      
              ,CSC_REFND_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,CSC_MNTHS             SMALLINT                           
              ,RATE_DEFINITION_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                           
              ,CURR_EXT_DESC_LONG CHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                          
              ,RENEWAL_DESC_LONG CHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                          
              ,OPT_DESC_INT_LONG CHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                          
P00396        ,SORT_SEQ_NO           SMALLINT                           
P00581        ,ACCOUNT_TYPE_CODE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                           
P00805        ,PRINT_RETN_MSG_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                           
P00805        ,AMT_RETN_DISCOUNT     DECIMAL(5,2)                       
P00805        ,RENEW_BY_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
P00805        ,NEW_RATE_BEGINS_DATE CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                           
P00805        ,PRINT_BBP_MSG_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                           
PRJ805        ,IS_RENEWAL_OPTN_FLEX CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                           
A05037        ,CORE_RATE_PLAN_NO CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                           
A05037        ,CORE_RATE_PLAN_DDDC   DECIMAL(5,2)                       
P00836        ,OPTION_PROMO_DESC CHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                          
P00836        ,WEB_MKT_DESC_LONG VARCHAR(1024)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                      
P00892        ,AUTO_RENEWAL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
P00836        ,SENIOR_RATE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
P00396       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
P00836            MOVE 'Y'                  TO WS-GTT01-DECLARED        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04007_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
P00836            PERFORM 9700-PROCESS-ABEND   THRU  9700-EXIT          
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
               EXIT.                                                    
                                                                        
P00836 0100B-DECLARE-GTT.                                               
P00836                                                                  
P00836     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04007_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04007_R2
              (                                                          
P00836         RETURN_CODE         INT                              
P00836        ,BUS_RULE_MSG_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
P00836        ,RULE_RESULT_CD CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
P00836        ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00836        ,MESSAGE_PARMS VARCHAR(300)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
P00836        ,LINK_PARMS CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2            
P00836       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLSTATE TO WS-SQLSTATE.                                
P00836     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
P00836                                                                  
P00836     IF WS-SQLSTATE = '42710'                                     
P00836        PERFORM 8000B-DELETE-GTT-ROWS      THRU 8000B-EXIT        
P00836     ELSE                                                         
P00836        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00836           MOVE 'Y'                  TO WS-GTT02-DECLARED         
P00836        ELSE                                                      
P00836           MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
P00836           MOVE SQLCODE              TO ABEND-SQLCODE             
P00836           MOVE SQLSTATE             TO ABEND-SQLSTATE            
P00836           MOVE '0100B'              TO ACTIVE-PARAGRAPH          
P00836           MOVE 'DECLARE GTT'        TO ABEND-FUNCTION            
P00836           MOVE SPACES               TO ABEND-SQL-PREDICATES      
P00836                                        ABEND-TABLES              
P00836           MOVE 'CSR04007_R2'        TO TABLE-1                   
P00836           MOVE SPACES               TO TABLE-ELEMENT-1           
P00836           MOVE SPACES               TO HOSTVAR-ELEMENT-1         
P00836           PERFORM 9700-PROCESS-ABEND   THRU  9700-EXIT           
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836                                                                  
P00836 0100B-EXIT.                                                      
P00836         EXIT.                                                    
P00836                                                                  
       1000-PROCESS-INPUT.                                              
                                                                        
           UNSTRING PARM-ACCOUNT-NO DELIMITED BY ' '                    
                                    INTO WS-ACCOUNT-NO-JST              
                                                                        
           MOVE WS-ACCOUNT-NO-JST      TO PARM-ACCOUNT-NO-NUM           
           MOVE PARM-ACCOUNT-NO-NUM    TO PARM-ACCOUNT-NO-DEC           
                                                                        
           UNSTRING PARM-IC-NO DELIMITED BY ' '                         
                                    INTO WS-IC-NO-JST                   
           MOVE WS-IC-NO-JST           TO PARM-IC-NO-NUM                
           MOVE PARM-IC-NO-NUM         TO PARM-IC-NO-DEC                
                                                                        
P00836     SET BUS-RULE-INDX TO 1.                                      
P00836     PERFORM 7000-OPEN-RULE-CURSOR  THRU 7000-EXIT.               
P00836     PERFORM 7001-FETCH-RULE-CURSOR THRU 7001-EXIT.               
P00836     PERFORM 1010-LOAD-BUS-RULES    THRU 1010-EXIT                
P00836       UNTIL WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND.              
P00836     PERFORM 7002-CLOSE-RULE-CURSOR THRU 7002-EXIT.               
                                                                        
OTPOOL     MOVE 2                      TO G6-SEQ-NO.                    
OTPOOL     PERFORM 7003-GET-POOL-GO-DATE  THRU 7003-EXIT.               
OTPOOL     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
OTPOOL        MOVE G6-PARM-DATA(14:10) TO WS-POOL-GO-DATE               
OTPOOL     END-IF.                                                      
                                                                        
P00836     INITIALIZE GTT-RETURN-FIELDS-1                               
P00836                GTT-RETURN-FIELDS-2                               
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836 1010-LOAD-BUS-RULES.                                             
P00836                                                                  
P00836     MOVE 1T-BUS-RULE-ID      TO BUS-RULE-ID      (BUS-RULE-INDX).
P00836     MOVE 1T-BUS-RULE-XREF-ID TO BUS-RULE-XREF-ID (BUS-RULE-INDX).
P00836     MOVE 1T-COMPANY-NO       TO BUS-RULE-COMPANY-NO              
P00836                                                  (BUS-RULE-INDX).
P00836     MOVE 1S-RULE-MESSAGE-ID  TO BUS-RULE-MESSAGE-ID              
P00836                                                  (BUS-RULE-INDX).
P00836     MOVE 1S-RULE-RESULT-CD   TO BUS-RULE-RESULT-CD               
P00836                                                  (BUS-RULE-INDX).
P00836     SET BUS-RULE-INDX UP BY 1.                                   
P00836     PERFORM 7001-FETCH-RULE-CURSOR THRU 7001-EXIT.               
P00836                                                                  
P00836 1010-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-BUILD-RESULT       THRU 2100-EXIT               
                                                                        
           IF WS-SUB-CTR > 0                                            
P00836        PERFORM 2500-BUILD-BUS-RULES THRU 2500-EXIT               
P00836     ELSE                                                         
P00836        PERFORM 8200-SEND-BUS-RULES  THRU 8200-EXIT               
P00836     END-IF                                                       
                                                                        
P00836     INITIALIZE GTT-RETURN-FIELDS-1                               
P00836                GTT-RETURN-FIELDS-2                               
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
P00836     MOVE RS-RETURN-CODE-1                  TO S-RETURN-CODE-1    
           MOVE WS-RET-OPTION-CD (WS-CTR)         TO S-OPTION-CD        
           MOVE WS-RET-RENEWAL-OFFER-CD (WS-CTR)  TO S-OFFER-CD         
           MOVE WS-RET-THERM-PRICE (WS-CTR)       TO S-THERM-PRICE      
           MOVE WS-RET-EXIT-FEE (WS-CTR)          TO S-EXIT-FEE         
           MOVE WS-RET-TIER-SOURCE-CD (WS-CTR)    TO S-TIER-SOURCE-CD   
           MOVE WS-RET-OPTN-VALID-MNTHS (WS-CTR)  TO S-OPTN-VALID-MNTHS 
           MOVE WS-RET-RATE-CALC-TYPE-CD (WS-CTR) TO S-RATE-CALC-TYPE-CD
                                                                        
           MOVE WS-RET-CSC-AMT (WS-CTR)           TO S-CSC-AMT          
A04019                                               WS-CSC-AMT-DESC    
           MOVE WS-RET-CSC-REFND-FL (WS-CTR)      TO S-CSC-REFND-FL     
           MOVE WS-RET-CSC-MNTHS (WS-CTR)         TO S-CSC-MNTHS        
           MOVE WS-RATE-DEFINITION-CD  TO S-RATE-DEFINITION-CD          
           MOVE WS-RET-CURR-EXT-DESC-LONG (WS-CTR)                      
                                       TO S-CURR-EXT-DESC-LONG          
           MOVE WS-RET-RENEWAL-DESC-LONG (WS-CTR)                       
                                       TO S-RENEWAL-DESC-LONG           
P00836     MOVE WS-RET-OPTION-PROMO-DESC (WS-CTR)                       
P00836                                 TO S-OPTION-PROMO-DESC           
P00836     MOVE WS-RET-WEB-MKT-DESC-LONG-LEN (WS-CTR)                   
P00836                                 TO S-WEB-MKT-DESC-LONG-LEN       
P00836     MOVE WS-RET-WEB-MKT-DESC-LONG-TEXT (WS-CTR)                  
P00836                                 TO S-WEB-MKT-DESC-LONG-TEXT      
P00892     MOVE WS-RET-AUTO-RENEWAL-FL (WS-CTR)                         
P00892                                 TO S-AUTO-RENEWAL-FL             
           MOVE WS-RET-OPT-DESC-INT-LONG (WS-CTR)                       
                                       TO S-OPT-DESC-INT-LONG           
PRJ805     MOVE WS-RET-ADJRATE-ATTR (WS-CTR)                            
PRJ805                                 TO S-IS-RENEWAL-OPTN-FLEX        
PRJ805     IF S-IS-RENEWAL-OPTN-FLEX NOT EQUAL 'Y'                      
PRJ805        MOVE 'N'                 TO S-IS-RENEWAL-OPTN-FLEX        
PRJ805     END-IF                                                       
                                                                        
A05037     MOVE WS-RET-RATE-PLAN-NO (WS-CTR)                            
A05037                                 TO S-CORE-RATE-PLAN-NO           
A05037     MOVE WS-RET-RATE-PLAN-DDDC (WS-CTR)                          
A05037                                 TO S-CORE-RATE-PLAN-DDDC         
                                                                        
A04019     STRING S-OPT-DESC-INT-LONG DELIMITED BY '   '                
A04019            ' with '                                              
A04019            WS-CSC-AMT-DESC DELIMITED BY SIZE                     
A04019            WS-CSC-LIT-DESC DELIMITED BY SIZE                     
A04019     INTO S-OPT-DESC-INT-LONG                                     
                                                                        
P00396     MOVE WS-CTR                 TO S-SORT-SEQ-NO                 
P00581     MOVE WS-ACCOUNT-TYPE-CODE   TO S-ACCOUNT-TYPE-CODE           
                                                                        
P00805     MOVE WS-PRINT-RETN-MSG-FL   TO S-PRINT-RETN-MSG-FL           
A05043     IF WS-PRINT-RETN-MSG-FL EQUAL 'R' OR 'S'                     
P00805        MOVE WS-AMT-RETN-DISCOUNT                                 
P00805                                 TO S-AMT-RETN-DISCOUNT           
P00805     ELSE                                                         
P00805        MOVE ZEROS               TO S-AMT-RETN-DISCOUNT           
P00805     END-IF                                                       
P00836     MOVE RD-SENIOR-RATE-FL      TO S-SENIOR-RATE-FL              
           .                                                            
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       2100-BUILD-RESULT.                                               
                                                                        
P00581     MOVE PARM-ACCOUNT-NO-DEC    TO AT-ACCOUNT-NO                 
OTPOOL                                    DD-ACCOUNT-NO.                
P00805     MOVE SPACES                 TO WS-CODE-BUDGET-PLAN.          
P00581     PERFORM 7200-GET-ACCT-DETAILS  THRU 7200-EXIT.               
                                                                        
OTPOOL     PERFORM 7250-GET-ACCT-MKT-TIER THRU 7250-EXIT.               
                                                                        
P00805     PERFORM 2200-GET-MORE-DETAILS  THRU 2200-EXIT.               
                                                                        
P00836     IF PARM-PROCESS-TYPE-CD EQUAL 'C'                            
P00836        MOVE PROGRAM-NAME-RTCHG  TO WS-CPD00328-CALLING-PGM       
P00836     ELSE                                                         
              MOVE PROGRAM-NAME        TO WS-CPD00328-CALLING-PGM       
P00836     END-IF.                                                      
      *                                                                 02160400
           MOVE PARM-OPTION-CD         TO WS-IN-OPTION-CD               
           MOVE PARM-ACCOUNT-NO-DEC    TO WS-IN-ACCOUNT-NO              
           MOVE PARM-CODE-UTIL-TYPE    TO WS-IN-CODE-UTIL-TYPE          
           MOVE PARM-IC-NO-DEC         TO WS-IN-IC-NO                   
      *                                                                 02160900
           MOVE SPACES                 TO ABEND-FUNCTION.               
           INITIALIZE  WS-RESULT-TABLE.                                 
      *                                                                 02161200
           CALL MCSCB328  USING   CWS00328-FIELDS,                      
                                  WS-RESULT-TABLE,                      
                                  ABEND-FILE,                           
P00836                            RS-RETURN-CODE-1.                     
                                                                        
P00836     MOVE RS-RETURN-CODE-1       TO  WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-SUB-CTR = 0 OR ABEND-FUNCTION > SPACES                 
P00836        MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1             
                                            S-RETURN-CODE-2             
              INITIALIZE WS-RESULT-TABLE                                
              ADD  1  TO WS-CTR                                         
P00581        MOVE SPACES                TO WS-ACCOUNT-TYPE-CODE        
P00836        PERFORM 9700-PROCESS-ABEND    THRU  9700-EXIT             
           END-IF                                                       
                                                                        
           IF WS-SUB-CTR > 0                                            
              PERFORM VARYING WS-CTR FROM 1 BY 1                        
                                     UNTIL WS-CTR > WS-SUB-CTR          
                 MOVE WS-RET-OPTION-CD (WS-CTR)  TO FI-OPTION-CD        
                 PERFORM 7100-SELECT-RATE-DEF-CD    THRU 7100-EXIT      
                 PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT     
                 PERFORM 8100-SEND-RESULT           THRU 8100-EXIT      
              END-PERFORM                                               
           END-IF                                                       
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02165212
P00805 2200-GET-MORE-DETAILS.                                           
P00805                                                                  
P00805     MOVE PARM-ACCOUNT-NO-DEC        TO UT-ACCOUNT-NO             
P00805                                        BU-ACCOUNT-NO.            
P00805     MOVE PARM-CODE-UTIL-TYPE        TO UT-CODE-UTIL-TYPE.        
P00805     MOVE PARM-IC-NO-DEC             TO UT-IC-NO.                 
P00836     MOVE 'N'                        TO WS-VARIABLE-RATE.         
P00805     PERFORM 7300-GET-OPTION-DETAILS    THRU 7300-EXIT.           
P00805                                                                  
P00805     MOVE SPACES                     TO S-RENEW-BY-DATE           
P00805                                        S-NEW-RATE-BEGINS-DATE.   
P00805     MOVE 'N'                        TO S-PRINT-BBP-MSG-FL        
OTPOOL                                        WS-OUTER-POOL-MSG-FL.     
P00805     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00805        IF AT-REV-MTH-LST-NRML = ZEROES                           
P00805           PERFORM 2300-NO-REV-MONTH    THRU 2300-EXIT            
P00805           MOVE BN-REVENUE-MONTH     TO WS-REV-MONTH-NUM          
P00805        ELSE                                                      
P00805           MOVE AT-REV-MTH-LST-NRML  TO WS-REV-MONTH-NUM          
P00805        END-IF                                                    
P00805        IF WS-REV-MONTH-NUM > 0                                   
P00805           PERFORM 2400-DETERMINE-DATES THRU 2400-EXIT            
P00805        END-IF                                                    
OTPOOL        IF B1-DIVISION-NO        = 'OUT'             AND          
OTPOOL           WS-POOL-GO-DATE       > ' '               AND          
OTPOOL           DF-STATUS-CHANGE-DT   > '1900-01-01'      AND          
OTPOOL           DF-STATUS-CHANGE-DT  >=  WS-POOL-GO-DATE  AND          
OTPOOL          (DD-TIER-ACCT-TYPE-CD  = 'D' OR 'A' OR 'B')             
OTPOOL           MOVE 'Y'                  TO WS-OUTER-POOL-MSG-FL      
OTPOOL        END-IF                                                    
P00805     ELSE                                                         
P00805        MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE     
P00805     END-IF.                                                      
P00805                                                                  
P00805 2200-EXIT.                                                       
P00805     EXIT.                                                        
P00805*                                                                 02165212
P00805 2300-NO-REV-MONTH.                                               
P00805                                                                  
P00805     PERFORM 7400-GET-CURRENT-DATE      THRU 7400-EXIT.           
P00805     MOVE WS-PARM-DT                 TO BN-DATE-EXTRACT.          
P00805                                                                  
P00805     MOVE AT-BILL-CYCLE              TO BN-BILL-CYCLE.            
P00805     PERFORM 7500-BILL-WINDOW           THRU 7500-EXIT.           
P00805                                                                  
P00805     IF BN-REVENUE-MONTH = ZEROES AND                             
P00805        AT-CODE-ACCT-STAT = 'P'                                   
P00805        MOVE UT-READ-CYCLE           TO BN-BILL-CYCLE             
P00805        PERFORM 7500-BILL-WINDOW        THRU 7500-EXIT            
P00805     END-IF.                                                      
P00805                                                                  
P00805 2300-EXIT.                                                       
P00805     EXIT.                                                        
P00805                                                                  
P00805 2400-DETERMINE-DATES.                                            
P00805                                                                  
P00805****CALCULATE THE RENEW BY DATE FOR THE FIXED RATE                        
P00805     MOVE WS-REV-MONTH-CHAR(1:4)     TO WS-REV-MONTH-DT(1:4).     
P00805     MOVE WS-REV-MONTH-CHAR(5:2)     TO WS-REV-MONTH-DT(6:2).     
P00805     MOVE '01'                       TO WS-REV-MONTH-DT(9:2).     
P00805     MOVE '-'                        TO WS-REV-MONTH-DT(5:1)      
P00805                                        WS-REV-MONTH-DT(8:1).     
P00805     MOVE FF-DURATION-REMAIN-NO      TO WS-DURATION-REM-NUM.      
P00836                                                                  
P00836     IF AT-REV-MTH-LST-NRML = ZEROES AND WS-DURATION-REM-NUM > 0  
P00836        COMPUTE WS-DURATION-REM-NUM  EQUAL WS-DURATION-REM-NUM - 1
P00836     END-IF.                                                      
P00805                                                                  
P00805     EXEC SQL                                                     
P00805        SELECT
              DATEADD(MONTH, :WS-DURATION-REM-NUM, 
              IIF(TRY_CONVERT(DATE, :WS-REV-MONTH-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REV-MONTH-DT
              ) <> 0) OR (LEN(:WS-REV-MONTH-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-REV-MONTH-DT
              ), CONVERT(DATE, :WS-REV-MONTH-DT) ))
            INTO
              :WS-REV-MONTH-PLUS-DT                              
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES ADD_MONTHS(:WS-REV-MONTH-DT,:WS-DURATION-REM-NUM)          
MFA-TR*         INTO :WS-REV-MONTH-PLUS-DT                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     IF WS-REV-MONTH-PLUS-DT(1:4) NUMERIC                         
P00805           AND WS-REV-MONTH-PLUS-DT(6:2) NUMERIC                  
P00805        MOVE WS-REV-MONTH-PLUS-DT(1:4)                            
P00805             TO WS-REV-MONTH-PLUS-NUM(1:4)                        
P00805        MOVE WS-REV-MONTH-PLUS-DT(6:2)                            
P00805             TO WS-REV-MONTH-PLUS-NUM(5:2)                        
P00805        MOVE WS-REV-MONTH-PLUS-NUM                                
P00805             TO BN-REVENUE-MONTH                                  
P00805        PERFORM 7600-BILL-WINDOW        THRU 7600-EXIT            
P00805        MOVE BN-DATE-EXTRACT         TO S-RENEW-BY-DATE           
P00836        IF S-RENEW-BY-DATE EQUAL SPACES                           
P00836           MOVE WS-REV-MONTH-PLUS-DT TO S-RENEW-BY-DATE           
P00836        END-IF                                                    
P00805     END-IF.                                                      
P00805                                                                  
P00805****CHECK IF BBP ANNV IS IN SYNC WITH FIXED RATE ANNV.                    
P00805     IF WS-CODE-BUDGET-PLAN = 'A'                                 
P00805           AND WS-REV-MONTH-PLUS-NUM NUMERIC                      
P00805        PERFORM 7700-GET-BUDGET-PLAN    THRU 7700-EXIT            
P00805        IF BU-ANNIVERSARY-DATE > SPACES                           
P00805           AND BU-ANNIVERSARY-DATE(1:4) NUMERIC                   
P00805              AND BU-ANNIVERSARY-DATE(6:2) NUMERIC                
P00805           MOVE BU-ANNIVERSARY-DATE(1:4)                          
P00805              TO WS-BBP-ANNV-REV-MTH-NUM(1:4)                     
P00805           MOVE BU-ANNIVERSARY-DATE(6:2)                          
P00805              TO WS-BBP-ANNV-REV-MTH-NUM(5:2)                     
P00805           IF WS-BBP-ANNV-REV-MTH-NUM                             
P00805                 EQUAL WS-REV-MONTH-PLUS-NUM                      
P00805              MOVE 'Y'               TO S-PRINT-BBP-MSG-FL        
P00805           END-IF                                                 
P00805        END-IF                                                    
P00805     END-IF.                                                      
P00805                                                                  
P00805****CALCULATE THE NEW RATE BEGINS DATE                                    
P00805     IF WS-REV-MONTH-PLUS-DT(1:4) NUMERIC AND                     
P00805        WS-REV-MONTH-PLUS-DT(6:2) NUMERIC                         
P00805        MOVE WS-REV-MONTH-PLUS-DT    TO WS-REV-MONTH-DT           
P00805                                                                  
P00805        EXEC SQL                                                  
P00805           SELECT
              DATEADD(MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-REV-MONTH-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REV-MONTH-DT
              ) <> 0) OR (LEN(:WS-REV-MONTH-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-REV-MONTH-DT
              ), CONVERT(DATE, :WS-REV-MONTH-DT) ))
            INTO
              :WS-REV-MONTH-PLUS-DT                           
P00805        END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*       EXEC SQL                                                          
MFA-TR*          VALUES ADD_MONTHS(:WS-REV-MONTH-DT, 1)                         
MFA-TR*            INTO :WS-REV-MONTH-PLUS-DT                                   
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805        IF WS-REV-MONTH-PLUS-DT(1:4) NUMERIC AND                  
P00805           WS-REV-MONTH-PLUS-DT(6:2) NUMERIC                      
P00805           MOVE WS-REV-MONTH-PLUS-DT(1:4)                         
P00805                TO WS-REV-MONTH-PLUS-NUM(1:4)                     
P00805           MOVE WS-REV-MONTH-PLUS-DT(6:2)                         
P00805                TO WS-REV-MONTH-PLUS-NUM(5:2)                     
P00805           MOVE WS-REV-MONTH-PLUS-NUM                             
P00805                TO BN-REVENUE-MONTH                               
P00805           PERFORM 7600-BILL-WINDOW     THRU 7600-EXIT            
P00805           MOVE BN-DATE-EXTRACT      TO S-NEW-RATE-BEGINS-DATE    
P00805        END-IF                                                    
P00805     END-IF.                                                      
P00805                                                                  
P00805 2400-EXIT.                                                       
P00805     EXIT.                                                        
                                                                        
P00836 2500-BUILD-BUS-RULES.                                            
P00836                                                                  
P00836     INITIALIZE GTT-RETURN-FIELDS-2.                              
P00836     MOVE 0      TO S-RETURN-CODE-2.                              
P00836     MOVE SPACES TO S-BUS-RULE-MSG-ID                             
P00836                    S-BUS-RULE-RESULT-CD                          
P00836                    S-BUS-RULE-XREF-ID                            
P00836                    S-LINK-PARMS.                                 
P00836     MOVE '00'   TO WS-COMP-NO.                                   
P00836                                                                  
P00836     IF WS-VARIABLE-RATE NOT EQUAL 'Y'                            
OTPOOL        IF WS-OUTER-POOL-MSG-FL EQUAL 'Y'                         
OTPOOL           MOVE 'WCM0000032'             TO WS-RULE-ID            
OTPOOL        ELSE                                                      
P00836           MOVE 'WCM0000005'             TO WS-RULE-ID            
OTPOOL        END-IF                                                    
P00836        SET BUS-RULE-NOT-FOUND                                    
P00836            NOT-END-OF-SEARCH  TO TRUE                            
P00836        PERFORM 2600-RULE-XREF              THRU 2600-EXIT        
P00836                UNTIL BUS-RULE-FOUND OR END-OF-SEARCH             
P00836        MOVE S-RENEW-BY-DATE(6:2)        TO WS-MM                 
P00836        PERFORM 2700-GET-MONTH              THRU 2700-EXIT        
P00836        STRING WS-MONTH                                           
P00836               ', '                                               
P00836               S-RENEW-BY-DATE(1:4)                               
P00836               DELIMITED BY '  '                                  
P00836               INTO S-MESSAGE-PARMS-TEXT                          
P00836        END-STRING                                                
P00836        MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                       
P00836                                         TO S-MESSAGE-PARMS-LEN   
P00836        PERFORM 8200-SEND-BUS-RULES         THRU 8200-EXIT        
P00836     END-IF.                                                      
P00836                                                                  
P00836     IF S-ACCOUNT-TYPE-CODE NOT EQUAL 'C'                         
P00836        MOVE PARM-OPTION-CD              TO FI-OPTION-CD          
P00836        PERFORM 7100-SELECT-RATE-DEF-CD     THRU 7100-EXIT        
P00836        IF RD-SENIOR-RATE-FL NOT EQUAL 'Y' AND 'S'                
P00836           INITIALIZE S-MESSAGE-PARMS                             
P00836           MOVE 'WCM0000006'             TO WS-RULE-ID            
P00836           SET BUS-RULE-NOT-FOUND                                 
P00836               NOT-END-OF-SEARCH  TO TRUE                         
P00836           PERFORM 2600-RULE-XREF           THRU 2600-EXIT        
P00836             UNTIL BUS-RULE-FOUND OR END-OF-SEARCH                
P00836           MOVE +0                       TO S-MESSAGE-PARMS-LEN   
P00836           PERFORM 8200-SEND-BUS-RULES      THRU 8200-EXIT        
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836                                                                  
OTPOOL     IF ( DF-STAT-ADJUSTABLE-CD EQUAL 'A' OR 'E' ) AND            
OTPOOL          WS-OUTER-POOL-MSG-FL  NOT EQUAL 'Y'                     
P00836        SET FLEX-RATE-NOT-FOUND          TO TRUE                  
P00836        PERFORM VARYING WS-CTR FROM 1 BY 1                        
P00836                                      UNTIL WS-CTR > WS-SUB-CTR   
P00836                                         OR FLEX-RATE-FOUND       
P00836           IF WS-RET-ADJRATE-ATTR (WS-CTR) = 'Y'                  
P00836              SET FLEX-RATE-FOUND        TO TRUE                  
P00836           END-IF                                                 
P00836        END-PERFORM                                               
P00836        IF FLEX-RATE-NOT-FOUND                                    
P00836           INITIALIZE S-MESSAGE-PARMS                             
P00836           MOVE 'WCM0000007'             TO WS-RULE-ID            
P00836           SET BUS-RULE-NOT-FOUND                                 
P00836               NOT-END-OF-SEARCH         TO TRUE                  
P00836           PERFORM 2600-RULE-XREF           THRU 2600-EXIT        
P00836             UNTIL BUS-RULE-FOUND OR END-OF-SEARCH                
P00836           IF S-ACCOUNT-TYPE-CODE EQUAL 'C'                       
P00836              MOVE 'business services team'                       
P00836                                         TO S-MESSAGE-PARMS-TEXT  
P00836           ELSE                                                   
P00836              MOVE 'contact center'      TO S-MESSAGE-PARMS-TEXT  
P00836           END-IF                                                 
P00836           MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                    
P00836                                         TO S-MESSAGE-PARMS-LEN   
P00836           PERFORM 8200-SEND-BUS-RULES      THRU 8200-EXIT        
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836                                                                  
P00836     IF S-PRINT-BBP-MSG-FL EQUAL 'Y'                              
P00836        INITIALIZE S-MESSAGE-PARMS                                
P00836        MOVE 'WCM0000008'                TO WS-RULE-ID            
P00836        SET BUS-RULE-NOT-FOUND                                    
P00836            NOT-END-OF-SEARCH  TO TRUE                            
P00836        PERFORM 2600-RULE-XREF              THRU 2600-EXIT        
P00836          UNTIL BUS-RULE-FOUND OR END-OF-SEARCH                   
P00836        MOVE +0                          TO S-MESSAGE-PARMS-LEN   
P00836        PERFORM 8200-SEND-BUS-RULES         THRU 8200-EXIT        
P00836     END-IF.                                                      
P00836                                                                  
P00836     INITIALIZE S-MESSAGE-PARMS.                                  
P00836     MOVE S-THERM-PRICE                  TO WS-FMT-THERM-PRICE.   
P00836     MOVE S-CSC-AMT                      TO WS-FMT-CSC-AMOUNT.    
P00836     MOVE S-CORE-RATE-PLAN-DDDC          TO WS-FMT-DDDC           
P00836     IF S-RATE-DEFINITION-CD EQUAL '2'                            
P00836        MOVE 'WCM0000019'                TO WS-RULE-ID            
P00836        STRING S-RENEWAL-DESC-LONG                                
P00836               ';'                                                
P00836               WS-FMT-THERM-PRICE                                 
P00836               ';'                                                
P00836               WS-FMT-CSC-AMOUNT                                  
P00836               ';'                                                
P00836               '('                                                
P00836               WS-FMT-DDDC                                        
P00836               ' X DDDC)'                                         
P00836               DELIMITED BY '  '                                  
P00836               INTO S-MESSAGE-PARMS-TEXT                          
P00836        END-STRING                                                
P00836     ELSE                                                         
P00836        MOVE 'WCM0000009'                TO WS-RULE-ID            
P00836        STRING S-RENEWAL-DESC-LONG                                
P00836               ';'                                                
P00836               WS-FMT-THERM-PRICE                                 
P00836               ';'                                                
P00836               WS-FMT-CSC-AMOUNT                                  
P00836               DELIMITED BY '  '                                  
P00836               INTO S-MESSAGE-PARMS-TEXT                          
P00836        END-STRING                                                
P00836     END-IF                                                       
P00836     MOVE LENGTH OF S-MESSAGE-PARMS-TEXT TO S-MESSAGE-PARMS-LEN.  
P00836     SET BUS-RULE-NOT-FOUND                                       
P00836         NOT-END-OF-SEARCH  TO TRUE.                              
P00836     PERFORM 2600-RULE-XREF                 THRU 2600-EXIT        
P00836       UNTIL BUS-RULE-FOUND OR END-OF-SEARCH.                     
P00836     PERFORM 8200-SEND-BUS-RULES            THRU 8200-EXIT.       
P00836                                                                  
OTPOOL     IF WS-OUTER-POOL-MSG-FL EQUAL 'Y'                            
OTPOOL        INITIALIZE S-MESSAGE-PARMS                                
OTPOOL        MOVE 'WCM0000033'                TO WS-RULE-ID            
OTPOOL        SET BUS-RULE-NOT-FOUND                                    
OTPOOL            NOT-END-OF-SEARCH  TO TRUE                            
OTPOOL        PERFORM 2600-RULE-XREF              THRU 2600-EXIT        
OTPOOL          UNTIL BUS-RULE-FOUND OR END-OF-SEARCH                   
OTPOOL        MOVE +0                          TO S-MESSAGE-PARMS-LEN   
OTPOOL        PERFORM 8200-SEND-BUS-RULES         THRU 8200-EXIT        
OTPOOL     END-IF.                                                      
OTPOOL                                                                  
P00836     INITIALIZE S-MESSAGE-PARMS.                                  
P00836     MOVE 'WCM0000010'                   TO WS-RULE-ID.           
P00836     SET BUS-RULE-NOT-FOUND                                       
P00836         NOT-END-OF-SEARCH  TO TRUE.                              
P00836     PERFORM 2600-RULE-XREF                 THRU 2600-EXIT        
P00836       UNTIL BUS-RULE-FOUND OR END-OF-SEARCH.                     
P00836     MOVE WS-RET-EXIT-FEE (1)            TO WS-FMT-EXIT-FEE.      
P00836     STRING WS-FMT-EXIT-FEE                                       
P00836            DELIMITED BY '  '                                     
P00836            INTO S-MESSAGE-PARMS-TEXT                             
P00836     END-STRING.                                                  
P00836     MOVE LENGTH OF S-MESSAGE-PARMS-TEXT TO S-MESSAGE-PARMS-LEN.  
P00836     PERFORM 8200-SEND-BUS-RULES            THRU 8200-EXIT.       
P00836                                                                  
P00836     INITIALIZE S-MESSAGE-PARMS.                                  
P00836     IF S-ACCOUNT-TYPE-CODE EQUAL 'C'                             
P00836        MOVE 'WCM0000018'                   TO WS-RULE-ID         
P00836     ELSE                                                         
P00836        MOVE 'WCM0000011'                   TO WS-RULE-ID         
P00836     END-IF.                                                      
P00836     SET BUS-RULE-NOT-FOUND                                       
P00836         NOT-END-OF-SEARCH  TO TRUE.                              
P00836     PERFORM 2600-RULE-XREF                 THRU 2600-EXIT        
P00836       UNTIL BUS-RULE-FOUND OR END-OF-SEARCH.                     
P00836     MOVE +0                             TO S-MESSAGE-PARMS-LEN.  
P00836     PERFORM 8200-SEND-BUS-RULES            THRU 8200-EXIT.       
P00836                                                                  
P00836 2500-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 2600-RULE-XREF.                                                  
P00836                                                                  
P00836     MOVE SPACES                         TO WS-RULE-XREF-ID       
P00836                                            WS-RULE-RESULT-CD.    
P00836     SET BUS-RULE-INDX TO +1.                                     
P00836     SEARCH BUS-RULES                                             
P00836        AT END                                                    
P00836           MOVE SPACES                   TO WS-RULE-XREF-ID       
P00836         WHEN BUS-RULE-ID (BUS-RULE-INDX) = LOW-VALUES OR SPACES  
P00836              SET END-OF-SEARCH          TO TRUE                  
P00836         WHEN BUS-RULE-ID             (BUS-RULE-INDX) = WS-RULE-ID
P00836          AND BUS-RULE-COMPANY-NO     (BUS-RULE-INDX) = WS-COMP-NO
P00836              MOVE BUS-RULE-XREF-ID   (BUS-RULE-INDX)             
P00836                                         TO WS-RULE-XREF-ID       
P00836              MOVE BUS-RULE-MESSAGE-ID(BUS-RULE-INDX)             
P00836                                         TO WS-RULE-MESSAGE-ID    
P00836              MOVE BUS-RULE-RESULT-CD (BUS-RULE-INDX)             
P00836                                         TO WS-RULE-RESULT-CD     
P00836              SET  BUS-RULE-FOUND        TO TRUE                  
P00836     END-SEARCH.                                                  
P00836                                                                  
P00836     MOVE WS-RULE-MESSAGE-ID             TO S-BUS-RULE-MSG-ID.    
P00836     MOVE WS-RULE-XREF-ID                TO S-BUS-RULE-XREF-ID.   
P00836     MOVE WS-RULE-RESULT-CD              TO S-BUS-RULE-RESULT-CD. 
P00836                                                                  
P00836 2600-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 2700-GET-MONTH.                                                  
P00836                                                                  
P00836     MOVE SPACES TO WS-MONTH.                                     
P00836                                                                  
P00836     EVALUATE WS-MM                                               
P00836         WHEN '01'                                                
P00836            MOVE 'January'   TO WS-MONTH                          
P00836         WHEN '02'                                                
P00836            MOVE 'February'  TO WS-MONTH                          
P00836         WHEN '03'                                                
P00836            MOVE 'March'     TO WS-MONTH                          
P00836         WHEN '04'                                                
P00836            MOVE 'April'     TO WS-MONTH                          
P00836         WHEN '05'                                                
P00836            MOVE 'May'       TO WS-MONTH                          
P00836         WHEN '06'                                                
P00836            MOVE 'June'      TO WS-MONTH                          
P00836         WHEN '07'                                                
P00836            MOVE 'July'      TO WS-MONTH                          
P00836         WHEN '08'                                                
P00836            MOVE 'August'    TO WS-MONTH                          
P00836         WHEN '09'                                                
P00836            MOVE 'September' TO WS-MONTH                          
P00836         WHEN '10'                                                
P00836            MOVE 'October'   TO WS-MONTH                          
P00836         WHEN '11'                                                
P00836            MOVE 'November'  TO WS-MONTH                          
P00836         WHEN '12'                                                
P00836            MOVE 'December'  TO WS-MONTH                          
P00836         WHEN OTHER                                               
P00836            MOVE 'Unknown'   TO WS-MONTH                          
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 2700-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7000-OPEN-RULE-CURSOR.                                           
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         OPEN RULE-CURSOR                                         
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7000'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'OPEN'                 TO ABEND-FUNCTION        
P00836             MOVE 'CSS_BUS_RULE_XREF'    TO TABLE-1               
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7000-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7001-FETCH-RULE-CURSOR.                                          
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         FETCH RULE-CURSOR                                        
P00836          INTO :1T-BUS-RULE-ID                                    
P00836              ,:1T-BUS-RULE-XREF-ID                               
P00836              ,:1T-COMPANY-NO                                     
P00836              ,:1S-RULE-MESSAGE-ID                                
P00836              ,:1S-RULE-RESULT-CD                                 
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836         WHEN NOT-FOUND                                           
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7001'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'FETCH'                TO ABEND-FUNCTION        
P00836             MOVE 'CSS_BUS_RULE_XREF'    TO TABLE-1               
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7001-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7002-CLOSE-RULE-CURSOR.                                          
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         CLOSE RULE-CURSOR                                        
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7002'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'CLOSE'                TO ABEND-FUNCTION        
P00836             MOVE 'CSS_BUS_RULE_XREF'    TO TABLE-1               
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7002-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
OTPOOL 7003-GET-POOL-GO-DATE.                                           
OTPOOL                                                                  
OTPOOL     EXEC SQL                                                     
OTPOOL        SELECT  G6.PARM_DATA                                      
OTPOOL          INTO :G6-PARM-DATA                                      
OTPOOL          FROM  CSS_JOB_PARM  G6 WITH(READUNCOMMITTED)                    
OTPOOL         WHERE  G6.PROGRAM_NAME        = 'CPD00328'               
OTPOOL           AND  G6.COMPANY_NO          = '01'                     
OTPOOL           AND  G6.CMND_CODE           = 'DATE'                   
OTPOOL           AND  G6.SEQ_NO              = :G6-SEQ-NO               
OTPOOL           AND  G6.STATUS              = 'A'                      
OTPOOL           AND  CIS.SUBSTR3(PARM_DATA,1,13) = 'POOL_GO_DATE='          
OTPOOL                                                           
OTPOOL                                                      
OTPOOL     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  G6.PARM_DATA                                              
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM  CSS_JOB_PARM  G6                                          
MFA-TR*        WHERE  G6.PROGRAM_NAME        = 'CPD00328'                       
MFA-TR*          AND  G6.COMPANY_NO          = '01'                             
MFA-TR*          AND  G6.CMND_CODE           = 'DATE'                           
MFA-TR*          AND  G6.SEQ_NO              = :G6-SEQ-NO                       
MFA-TR*          AND  G6.STATUS              = 'A'                              
MFA-TR*          AND  SUBSTR(PARM_DATA,1,13) = 'POOL_GO_DATE='                  
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7003                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

OTPOOL                                                                  
OTPOOL     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
OTPOOL                                                                  
OTPOOL     EVALUATE WS-ACTIVE-RETURN-CODE                               
OTPOOL         WHEN SUCCESSFUL-CALL                                     
OTPOOL         WHEN NOT-FOUND                                           
OTPOOL             CONTINUE                                             
OTPOOL         WHEN OTHER                                               
OTPOOL             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1      
OTPOOL             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
OTPOOL             MOVE SQLCODE                TO ABEND-SQLCODE         
OTPOOL             MOVE '7003'                 TO ACTIVE-PARAGRAPH      
OTPOOL             MOVE 'SELECT'               TO ABEND-FUNCTION        
OTPOOL             MOVE 'CSS_JOB_PARM'         TO TABLE-1               
OTPOOL             MOVE 'PROGRAM_NAME'         TO TABLE-ELEMENT-1       
OTPOOL             MOVE 'CPD00328'             TO HOSTVAR-ELEMENT-1     
OTPOOL             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
OTPOOL     END-EVALUATE.                                                
OTPOOL                                                                  
OTPOOL 7003-EXIT.                                                       
OTPOOL     EXIT.                                                        
                                                                        
       7100-SELECT-RATE-DEF-CD.                                         
      *                                                                 02165412
           EXEC SQL                                                     
              SELECT RD.RATE_DEFINITION_CD                              
P00836              ,RD.SENIOR_RATE_FL                                  
                INTO :RD-RATE-DEFINITION-CD                             
P00836              ,:RD-SENIOR-RATE-FL                                 
                FROM CSS_RATE_PLAN_DESC  RD WITH(READUNCOMMITTED)               
                    ,CRM_RT_PKG_OPTION   FI WITH(READUNCOMMITTED)               
               WHERE FI.OPTION_CD      = :FI-OPTION-CD                  
                 AND FI.COMPANY_NO     = RD.COMPANY_NO                  
                 AND FI.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE              
                 AND FI.RATE_PLAN_NO   = RD.RATE_PLAN_NO                
P00473           AND FI.OPT_VSTART_TS <= CIS.CURRENT$TIMESTAMP()              
P00473           AND FI.OPT_VEND_TS   >= CIS.CURRENT$TIMESTAMP()              
P00473           AND FI.PROC_STATUS_CD = 'AC'                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     02165512
MFA-TR*       SELECT RD.RATE_DEFINITION_CD                              02165612
MFA-TR*             ,RD.SENIOR_RATE_FL                                  04961004
MFA-TR*         INTO :RD-RATE-DEFINITION-CD                             02165712
MFA-TR*             ,:RD-SENIOR-RATE-FL                                 04971004
MFA-TR*         FROM CSS_RATE_PLAN_DESC  RD                             02165812
MFA-TR*             ,CRM_RT_PKG_OPTION   FI                             02165912
MFA-TR*        WHERE FI.OPTION_CD      = :FI-OPTION-CD                  02166012
MFA-TR*          AND FI.COMPANY_NO     = RD.COMPANY_NO                  02166112
MFA-TR*          AND FI.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE              02166212
MFA-TR*          AND FI.RATE_PLAN_NO   = RD.RATE_PLAN_NO                02166312
MFA-TR*          AND FI.OPT_VSTART_TS <= CURRENT TIMESTAMP                      
MFA-TR*          AND FI.OPT_VEND_TS   >= CURRENT TIMESTAMP                      
MFA-TR*          AND FI.PROC_STATUS_CD = 'AC'                                   
MFA-TR*         WITH UR                                                 02166412
MFA-TR*    END-EXEC.                                                    02166912

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   MOVE RD-RATE-DEFINITION-CD  TO WS-RATE-DEFINITION-CD 
              WHEN NOT-FOUND                                            
                   MOVE SPACES                 TO WS-RATE-DEFINITION-CD 
              WHEN OTHER                                                
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1      
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE SQLCODE                TO ABEND-SQLCODE         
                   MOVE '7100'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CRM_RT_PKG_OPTION'    TO TABLE-1               
                   MOVE 'OPTION_CD'            TO TABLE-ELEMENT-1       
                   MOVE FI-OPTION-CD           TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02169202
P00581 7200-GET-ACCT-DETAILS.                                           
P00581*                                                                 02165412
P00581     EXEC SQL                                                     
P00581        SELECT TOP(1) AT.ACCOUNT_TYPE_CODE,
              AT.REV_MTH_LST_NRML,
              AT.CODE_ACCT_STAT,
              AT.BILL_CYCLE,
              CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1),
              COALESCE(B1.DIVISION_NO,'   ')                       
P00581          INTO :AT-ACCOUNT-TYPE-CODE                              
A04019              ,:AT-REV-MTH-LST-NRML                               
P00805              ,:AT-CODE-ACCT-STAT                                 
P00805              ,:AT-BILL-CYCLE                                     
P00805              ,:WS-CODE-BUDGET-PLAN                               
OTPOOL              ,:B1-DIVISION-NO                                    
P00581          FROM CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                
OTPOOL              ,CSS_LOCAL_OFFICE   B1 WITH(READUNCOMMITTED)                
P00581         WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                   
OTPOOL           AND B1.LOCAL_OFFICE =  AT.LOCAL_OFFICE                 
OTPOOL           AND B1.COMPANY_NO   =  AT.COMPANY_NO                   
OTPOOL                                              
P00581                                                           
P00581                                                      
P00581     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     02165512
MFA-TR*       SELECT AT.ACCOUNT_TYPE_CODE                               02165612
MFA-TR*             ,AT.REV_MTH_LST_NRML                                02165612
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,SUBSTR(AT.CODES_DATA_PRESENT,3,1)                          
MFA-TR*             ,IFNULL(B1.DIVISION_NO,'   ')                               
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-REV-MTH-LST-NRML                               02165612
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:WS-CODE-BUDGET-PLAN                                       
MFA-TR*             ,:B1-DIVISION-NO                                            
MFA-TR*         FROM CSS_ACCOUNT        AT                                      
MFA-TR*             ,CSS_LOCAL_OFFICE   B1                                      
MFA-TR*        WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                           
MFA-TR*          AND B1.LOCAL_OFFICE =  AT.LOCAL_OFFICE                         
MFA-TR*          AND B1.COMPANY_NO   =  AT.COMPANY_NO                           
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                 02166412
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                    02166912

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581                                                                  
P00581     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00581                                                                  
P00581     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00581        WHEN SUCCESSFUL-CALL                                      
P00581             MOVE AT-ACCOUNT-TYPE-CODE   TO WS-ACCOUNT-TYPE-CODE  
P00581        WHEN NOT-FOUND                                            
P00581             MOVE SPACES                 TO WS-ACCOUNT-TYPE-CODE  
P00581        WHEN OTHER                                                
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1      
P00581             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00581             MOVE SQLCODE                TO ABEND-SQLCODE         
P00581             MOVE '7200'                 TO ACTIVE-PARAGRAPH      
P00581             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00581             MOVE 'CSS_ACCOUNT'          TO TABLE-1               
P00581             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00581             MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00581     END-EVALUATE.                                                
P00581                                                                  
P00581 7200-EXIT.                                                       
P00581     EXIT.                                                        
      *                                                                 02169112
OTPOOL 7250-GET-ACCT-MKT-TIER.                                          
OTPOOL*                                                                 02165412
OTPOOL     EXEC SQL                                                     
OTPOOL        SELECT TOP(1) DD.TIER_ACCT_TYPE_CD                              
OTPOOL          INTO :DD-TIER-ACCT-TYPE-CD                              
OTPOOL          FROM  CSS_ACCT_MKT_TIER  DD WITH(READUNCOMMITTED)               
OTPOOL         WHERE  DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                  
OTPOOL           AND  DD.EFF_START_DT =                                 
OTPOOL                       ( SELECT MAX(ZZ.EFF_START_DT)              
OTPOOL                           FROM CSS_ACCT_MKT_TIER ZZ
                           WITH(READUNCOMMITTED)              
OTPOOL                          WHERE ZZ.ACCOUNT_NO = DD.ACCOUNT_NO )   
OTPOOL                                              
OTPOOL                                                           
OTPOOL                                                      
OTPOOL     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02165512
MFA-TR*       SELECT  DD.TIER_ACCT_TYPE_CD                              02165612
MFA-TR*         INTO :DD-TIER-ACCT-TYPE-CD                                      
MFA-TR*         FROM  CSS_ACCT_MKT_TIER  DD                                     
MFA-TR*        WHERE  DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                          
MFA-TR*          AND  DD.EFF_START_DT =                                 04610000
MFA-TR*                      ( SELECT MAX(ZZ.EFF_START_DT)              04620000
MFA-TR*                          FROM CSS_ACCT_MKT_TIER ZZ              04630000
MFA-TR*                         WHERE ZZ.ACCOUNT_NO = DD.ACCOUNT_NO )   04640000
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                 02166412
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                    02166912

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

OTPOOL                                                                  
OTPOOL     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
OTPOOL                                                                  
OTPOOL     EVALUATE WS-ACTIVE-RETURN-CODE                               
OTPOOL        WHEN SUCCESSFUL-CALL                                      
OTPOOL             CONTINUE                                             
OTPOOL        WHEN NOT-FOUND                                            
OTPOOL             MOVE SPACES                 TO DD-TIER-ACCT-TYPE-CD  
OTPOOL        WHEN OTHER                                                
OTPOOL             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1      
OTPOOL             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
OTPOOL             MOVE SQLCODE                TO ABEND-SQLCODE         
OTPOOL             MOVE '7250'                 TO ACTIVE-PARAGRAPH      
OTPOOL             MOVE 'SELECT'               TO ABEND-FUNCTION        
OTPOOL             MOVE 'CSS_ACCT_MKT_TIER'    TO TABLE-1               
OTPOOL             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
OTPOOL             MOVE DD-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
OTPOOL             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
OTPOOL     END-EVALUATE.                                                
OTPOOL                                                                  
OTPOOL 7250-EXIT.                                                       
OTPOOL     EXIT.                                                        
      *                                                                 02169112
P00805 7300-GET-OPTION-DETAILS.                                         
P00805                                                                  
P00805     EXEC SQL                                                     
P00805        SELECT TOP(1) COALESCE(FF.DURATION_REMAIN_NO,0),
              UT.READ_CYCLE,
              DF.STAT_ADJUSTABLE_CD,
              COALESCE(DF.STATUS_CHANGE_DT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))           
P00805          INTO :FF-DURATION-REMAIN-NO                             
P00805              ,:UT-READ-CYCLE                                     
P00836              ,:DF-STAT-ADJUSTABLE-CD                             
OTPOOL              ,:DF-STATUS-CHANGE-DT                               
P00805          FROM CSS_UTIL_ENVRNMT    UT WITH(READUNCOMMITTED)               
P00805              ,CSS_ACCT_RTPK_AGR   DF WITH(READUNCOMMITTED)               
P00805              ,CSS_FIXED_FCTR      FF WITH(READUNCOMMITTED)               
P00805              ,CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)               
P00805         WHERE UT.ACCOUNT_NO         =  :UT-ACCOUNT-NO            
P00805           AND UT.CODE_UTIL_TYPE     =  :UT-CODE-UTIL-TYPE        
P00805           AND UT.IC_NO              =  :UT-IC-NO                 
P00805           AND DF.ACCOUNT_NO         =  UT.ACCOUNT_NO             
P00805           AND DF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE         
P00805           AND DF.IC_NO              =  UT.IC_NO                  
P00805           AND DF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO      
P00805           AND FF.ACCOUNT_NO         =  DF.ACCOUNT_NO             
P00805           AND FF.CODE_UTIL_TYPE     =  DF.CODE_UTIL_TYPE         
P00805           AND FF.IC_NO              =  DF.IC_NO                  
P00805           AND FF.RT_PKG_OPT_SEQ_NO  =  DF.RT_PKG_OPT_SEQ_NO      
P00805           AND HQ.FACTOR_ID          =  FF.FACTOR_ID              
P00805           AND HQ.OPTION_CD          =  DF.OPTION_CD              
P00805           AND HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT       
P00805           AND HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT       
P00805           AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'             
P00805           AND HQ.PRIMRY_OPT_ATTR_FL =  'Y'                       
P00805           AND HQ.PROC_STATUS_CD     =  'AC'                      
P00805           AND HQ.OPT_ATTR_VSTART_TS = (                          
P00805               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                  
P00805                 FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)         
P00805                WHERE H1.OPTION_CD         = HQ.OPTION_CD         
P00805                  AND H1.RT_ATTR_INCTV_TYPE                       
P00805                                           = HQ.RT_ATTR_INCTV_TYPE
P00805                  AND H1.ATTR_INCTV_STRT_DT                       
P00805                                           <= DF.OPT_AGRMT_EFF_DT 
P00805                  AND H1.ATTR_INCTV_END_DT                        
P00805                                           >= DF.OPT_AGRMT_EFF_DT 
P00805                  AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                 
P00805                                           <= DF.OPT_AGRMT_EFF_DT 
P00805                  AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                   
P00805                                            >= DF.OPT_AGRMT_EFF_DT
P00805                  AND H1.PROC_STATUS_CD  = 'AC')                  
P00805         ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                      
P00805                 ,FF.EFF_DATE_FROM      DESC                      
P00805                                       
P00805                                                      
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(FF.DURATION_REMAIN_NO,0)                            
MFA-TR*             ,UT.READ_CYCLE                                              
MFA-TR*             ,DF.STAT_ADJUSTABLE_CD                                      
MFA-TR*             ,IFNULL(DF.STATUS_CHANGE_DT,'1900-01-01')                   
MFA-TR*         INTO :FF-DURATION-REMAIN-NO                                     
MFA-TR*             ,:UT-READ-CYCLE                                             
MFA-TR*             ,:DF-STAT-ADJUSTABLE-CD                                     
MFA-TR*             ,:DF-STATUS-CHANGE-DT                                       
MFA-TR*         FROM CSS_UTIL_ENVRNMT    UT                                     
MFA-TR*             ,CSS_ACCT_RTPK_AGR   DF                                     
MFA-TR*             ,CSS_FIXED_FCTR      FF                                     
MFA-TR*             ,CRM_OPT_ATTR_INCTV  HQ                                     
MFA-TR*        WHERE UT.ACCOUNT_NO         =  :UT-ACCOUNT-NO                    
MFA-TR*          AND UT.CODE_UTIL_TYPE     =  :UT-CODE-UTIL-TYPE                
MFA-TR*          AND UT.IC_NO              =  :UT-IC-NO                         
MFA-TR*          AND DF.ACCOUNT_NO         =  UT.ACCOUNT_NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE                 
MFA-TR*          AND DF.IC_NO              =  UT.IC_NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO              
MFA-TR*          AND FF.ACCOUNT_NO         =  DF.ACCOUNT_NO                     
MFA-TR*          AND FF.CODE_UTIL_TYPE     =  DF.CODE_UTIL_TYPE                 
MFA-TR*          AND FF.IC_NO              =  DF.IC_NO                          
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO  =  DF.RT_PKG_OPT_SEQ_NO              
MFA-TR*          AND HQ.FACTOR_ID          =  FF.FACTOR_ID                      
MFA-TR*          AND HQ.OPTION_CD          =  DF.OPTION_CD                      
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT               
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT               
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'                     
MFA-TR*          AND HQ.PRIMRY_OPT_ATTR_FL =  'Y'                               
MFA-TR*          AND HQ.PROC_STATUS_CD     =  'AC'                              
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS = (                                  
MFA-TR*              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                FROM CRM_OPT_ATTR_INCTV H1                               
MFA-TR*               WHERE H1.OPTION_CD         = HQ.OPTION_CD                 
MFA-TR*                 AND H1.RT_ATTR_INCTV_TYPE                               
MFA-TR*                                          = HQ.RT_ATTR_INCTV_TYPE        
MFA-TR*                 AND H1.ATTR_INCTV_STRT_DT                               
MFA-TR*                                          <= DF.OPT_AGRMT_EFF_DT         
MFA-TR*                 AND H1.ATTR_INCTV_END_DT                                
MFA-TR*                                          >= DF.OPT_AGRMT_EFF_DT         
MFA-TR*                 AND DATE(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                                          <= DF.OPT_AGRMT_EFF_DT         
MFA-TR*                 AND DATE(H1.OPT_ATTR_VEND_TS)                           
MFA-TR*                                           >= DF.OPT_AGRMT_EFF_DT        
MFA-TR*                 AND H1.PROC_STATUS_CD  = 'AC')                          
MFA-TR*        ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                              
MFA-TR*                ,FF.EFF_DATE_FROM      DESC                              
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00805                                                                  
P00805     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00805         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00805         WHEN NOT-FOUND                                           
P00805             MOVE 'Y'                    TO WS-VARIABLE-RATE      
OTPOOL             MOVE '1900-01-01'           TO DF-STATUS-CHANGE-DT   
P00805         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1      
P00805             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00805             MOVE SQLCODE                TO ABEND-SQLCODE         
P00805             MOVE '7300'                 TO ACTIVE-PARAGRAPH      
P00805             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00805             MOVE 'CSS_FIXED_FCTR'       TO TABLE-1               
P00805             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00805             MOVE UT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00805     END-EVALUATE.                                                
P00805                                                                  
P00805 7300-EXIT.                                                       
P00805     EXIT.                                                        
P00805*                                                                         
P00805 7400-GET-CURRENT-DATE.                                           
P00805                                                                  
P00805     EXEC SQL                                                     
P00805        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-PARM-DT                            
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-PARM-DT = CURRENT DATE                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00805                                                                  
P00805     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00805         WHEN SUCCESSFUL-CALL                                     
P00805             CONTINUE                                             
P00805         WHEN OTHER                                               
P00805             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00805             MOVE SQLCODE                TO ABEND-SQLCODE         
P00805             MOVE '7400'                 TO ACTIVE-PARAGRAPH      
P00805             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00805             MOVE 'CSS_MODEL_SQL'        TO TABLE-1               
P00805             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00805             MOVE UT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00805     END-EVALUATE.                                                
P00805                                                                  
P00805 7400-EXIT.                                                       
P00805     EXIT.                                                        
P00805                                                                  
P00805 7500-BILL-WINDOW.                                                
P00805                                                                  
P00805     EXEC SQL                                                     
P00805         SELECT  MIN(BN.REVENUE_MONTH)                            
P00805           INTO :BN-REVENUE-MONTH :WS-NULL-01                      
P00805           FROM  CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                 
P00805          WHERE  BN.DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )              
P00805            AND  BN.BILL_CYCLE    = :BN-BILL-CYCLE                
P00805                                                           
P00805                                                      
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MIN(BN.REVENUE_MONTH)                                    
MFA-TR*          INTO :BN-REVENUE-MONTH:WS-NULL-01                              
MFA-TR*          FROM  CSS_BILL_WINDOW BN                                       
MFA-TR*         WHERE  BN.DATE_EXTRACT >= :BN-DATE-EXTRACT                      
MFA-TR*           AND  BN.BILL_CYCLE    = :BN-BILL-CYCLE                        
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00805                                                                  
P00805     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00805         WHEN SUCCESSFUL-CALL                                     
P00805             IF WS-NULL-01 < 0                                    
P00805                MOVE ZEROES              TO BN-REVENUE-MONTH      
P00805             END-IF                                               
P00805         WHEN OTHER                                               
P00805             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00805             MOVE SQLCODE                TO ABEND-SQLCODE         
P00805             MOVE '7500'                 TO ACTIVE-PARAGRAPH      
P00805             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00805             MOVE 'CSS_BILL_WINDOW'      TO TABLE-1               
P00805             MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-1       
P00805             MOVE AT-BILL-CYCLE          TO HOSTVAR-ELEMENT-1     
P00805             MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-2       
P00805             MOVE BN-REVENUE-MONTH       TO HOSTVAR-ELEMENT-2     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00805     END-EVALUATE.                                                
P00805                                                                  
P00805 7500-EXIT.                                                       
P00805     EXIT.                                                        
P00805                                                                  
P00805 7600-BILL-WINDOW.                                                
P00805                                                                  
P00805     EXEC SQL                                                     
P00805        SELECT MIN(DATE_EXTRACT)                                  
P00805          INTO :BN-DATE-EXTRACT :WS-NULL-02                        
P00805          FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
P00805         WHERE BILL_CYCLE    = :AT-BILL-CYCLE                     
P00805           AND REVENUE_MONTH = :BN-REVENUE-MONTH                  
P00805                                                           
P00805                                                      
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(DATE_EXTRACT)                                          
MFA-TR*         INTO :BN-DATE-EXTRACT:WS-NULL-02                                
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE BILL_CYCLE    = :AT-BILL-CYCLE                             
MFA-TR*          AND REVENUE_MONTH = :BN-REVENUE-MONTH                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00805                                                                  
P00805     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00805         WHEN SUCCESSFUL-CALL                                     
P00805             IF WS-NULL-02 < 0                                    
P00805                MOVE SPACES              TO BN-DATE-EXTRACT       
P00805             END-IF                                               
P00805         WHEN NOT-FOUND                                           
P00805             MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE 
P00805             MOVE SPACES                 TO BN-DATE-EXTRACT       
P00805         WHEN OTHER                                               
P00805             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00805             MOVE SQLCODE                TO ABEND-SQLCODE         
P00805             MOVE '7600'                 TO ACTIVE-PARAGRAPH      
P00805             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00805             MOVE 'CSS_BILL_WINDOW'      TO TABLE-1               
P00805             MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-1       
P00805             MOVE AT-BILL-CYCLE          TO HOSTVAR-ELEMENT-1     
P00805             MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-2       
P00805             MOVE BN-REVENUE-MONTH       TO HOSTVAR-ELEMENT-2     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00805     END-EVALUATE.                                                
P00805                                                                  
P00805 7600-EXIT.                                                       
P00805     EXIT.                                                        
                                                                        
P00805 7700-GET-BUDGET-PLAN.                                            
P00805                                                                  
P00805     EXEC SQL                                                     
P00805        SELECT  COALESCE(ANNIVERSARY_DATE,IIF(TRY_CONVERT(DATE, 
              '          ') IS NULL OR (PATINDEX('%.%', '          '
              ) <> 0) OR (LEN('          ') <> 10), CIS.CHAR2DATE(
              '          '), CONVERT(DATE, '          ') ))             
P00805          INTO :BU-ANNIVERSARY-DATE                               
P00805          FROM  CSS_BUDGET_PLAN WITH(READUNCOMMITTED)                     
P00805         WHERE  ACCOUNT_NO    = :BU-ACCOUNT-NO                    
P00805                                                           
P00805                                                      
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  IFNULL(ANNIVERSARY_DATE,'          ')                     
MFA-TR*         INTO :BU-ANNIVERSARY-DATE                                       
MFA-TR*         FROM  CSS_BUDGET_PLAN                                           
MFA-TR*        WHERE  ACCOUNT_NO    = :BU-ACCOUNT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00805                                                                  
P00805     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00805         WHEN SUCCESSFUL-CALL                                     
P00805             CONTINUE                                             
P00805         WHEN NOT-FOUND                                           
P00805             MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE 
P00805             MOVE SPACES                 TO BU-ANNIVERSARY-DATE   
P00805         WHEN OTHER                                               
P00805             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00805             MOVE SQLCODE                TO ABEND-SQLCODE         
P00805             MOVE '7700'                 TO ACTIVE-PARAGRAPH      
P00805             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00805             MOVE 'CSS_BUDGET_PLAN'      TO TABLE-1               
P00805             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00805             MOVE BU-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00805     END-EVALUATE.                                                
P00805                                                                  
P00805 7700-EXIT.                                                       
P00805     EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 02169402
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                 02169802
            EXEC SQL                                                    
                DELETE FROM #CSR04007_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    02169902
MFA-TR*         DELETE FROM SESSION.CSR04007_R1                         02170002
MFA-TR*     END-EXEC.                                                   02170102

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02170202
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 02170402
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04007_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
P00836         PERFORM 9700-PROCESS-ABEND   THRU  9700-EXIT             
           END-IF.                                                      
      *                                                                 02172002
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
P00836 8000B-DELETE-GTT-ROWS.                                           
P00836*                                                                 05660000
P00836     MOVE                                                         
P00836     'DELETE ROWS'                                                
P00836         TO S-SQL-STATEMENT-V.                                    
P00836*                                                                 05700000
P00836      EXEC SQL                                                    
P00836          DELETE FROM #CSR04007_R2                         
P00836      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    05710000
MFA-TR*         DELETE FROM SESSION.CSR04007_R2                         05720000
MFA-TR*     END-EXEC.                                                   05730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                 05740000
P00836      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
P00836*                                                                 05760000
P00836      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00836         NEXT SENTENCE                                            
P00836      ELSE                                                        
P00836         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00836         MOVE SQLCODE              TO ABEND-SQLCODE               
P00836         MOVE SQLSTATE             TO ABEND-SQLSTATE              
P00836         MOVE '8000B'              TO ACTIVE-PARAGRAPH            
P00836         MOVE 'DELETE'             TO ABEND-FUNCTION              
P00836         MOVE SPACES               TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836         MOVE 'CSR04007_R2'        TO TABLE-1                     
P00836         MOVE SPACES               TO TABLE-ELEMENT-1             
P00836         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
P00836         PERFORM 9700-PROCESS-ABEND   THRU  9700-EXIT             
P00836     END-IF.                                                      
P00836*                                                                 05920000
P00836 8000B-EXIT.                                                      
P00836     EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04007_R1                            
             (                                                          
              RETURN_CODE                                               
             ,OPTION_CD                                                 
             ,OFFER_CD                                                  
             ,THERM_PRICE                                               
             ,EXIT_FEE                                                  
             ,TIER_SORUCE_CD                                            
             ,OPTN_VALID_MNTHS                                          
             ,RATE_CALC_TYPE_CD                                         
             ,CSC_AMT                                                   
             ,CSC_REFND_FL                                              
             ,CSC_MNTHS                                                 
             ,RATE_DEFINITION_CD                                        
             ,CURR_EXT_DESC_LONG                                        
             ,RENEWAL_DESC_LONG                                         
             ,OPT_DESC_INT_LONG                                         
P00396       ,SORT_SEQ_NO                                               
P00581       ,ACCOUNT_TYPE_CODE                                         
P00805       ,PRINT_RETN_MSG_FL                                         
P00805       ,AMT_RETN_DISCOUNT                                         
P00805       ,RENEW_BY_DATE                                             
P00805       ,NEW_RATE_BEGINS_DATE                                      
P00805       ,PRINT_BBP_MSG_FL                                          
PRJ805       ,IS_RENEWAL_OPTN_FLEX                                      
A05037       ,CORE_RATE_PLAN_NO                                         
A05037       ,CORE_RATE_PLAN_DDDC                                       
P00836       ,OPTION_PROMO_DESC                                         
P00836       ,WEB_MKT_DESC_LONG                                         
P00892       ,AUTO_RENEWAL_FL                                           
P00892       ,SENIOR_RATE_FL                                            
             )                                                          
             VALUES                                                     
             (                                                          
P00836        :S-RETURN-CODE-1                                          
             ,:S-OPTION-CD                                              
             ,:S-OFFER-CD                                               
             ,:S-THERM-PRICE                                            
             ,:S-EXIT-FEE                                               
             ,:S-TIER-SOURCE-CD                                         
             ,:S-OPTN-VALID-MNTHS                                       
             ,:S-RATE-CALC-TYPE-CD                                      
             ,:S-CSC-AMT                                                
             ,:S-CSC-REFND-FL                                           
             ,:S-CSC-MNTHS                                              
             ,:S-RATE-DEFINITION-CD                                     
             ,:S-CURR-EXT-DESC-LONG                                     
             ,:S-RENEWAL-DESC-LONG                                      
             ,:S-OPT-DESC-INT-LONG                                      
P00396       ,:S-SORT-SEQ-NO                                            
P00581       ,:S-ACCOUNT-TYPE-CODE                                      
P00805       ,:S-PRINT-RETN-MSG-FL                                      
P00805       ,:S-AMT-RETN-DISCOUNT                                      
P00805       ,:S-RENEW-BY-DATE                                          
P00805       ,:S-NEW-RATE-BEGINS-DATE                                   
P00805       ,:S-PRINT-BBP-MSG-FL                                       
PRJ805       ,:S-IS-RENEWAL-OPTN-FLEX                                   
A05037       ,:S-CORE-RATE-PLAN-NO                                      
A05037       ,:S-CORE-RATE-PLAN-DDDC                                    
P00836       ,:S-OPTION-PROMO-DESC                                      
P00836       ,:S-WEB-MKT-DESC-LONG                                      
P00892       ,:S-AUTO-RENEWAL-FL                                        
P00836       ,:S-SENIOR-RATE-FL                                         
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     02190000
MFA-TR*      INSERT INTO SESSION.CSR04007_R1                            02200000
MFA-TR*      (                                                          02210000
MFA-TR*       RETURN_CODE                                               02220000
MFA-TR*      ,OPTION_CD                                                 02230000
MFA-TR*      ,OFFER_CD                                                  02231007
MFA-TR*      ,THERM_PRICE                                               02250000
MFA-TR*      ,EXIT_FEE                                                  02251005
MFA-TR*      ,TIER_SORUCE_CD                                            02252005
MFA-TR*      ,OPTN_VALID_MNTHS                                          02260000
MFA-TR*      ,RATE_CALC_TYPE_CD                                         02270000
MFA-TR*      ,CSC_AMT                                                   02280000
MFA-TR*      ,CSC_REFND_FL                                              02290000
MFA-TR*      ,CSC_MNTHS                                                 02300000
MFA-TR*      ,RATE_DEFINITION_CD                                        02300112
MFA-TR*      ,CURR_EXT_DESC_LONG                                        02301008
MFA-TR*      ,RENEWAL_DESC_LONG                                         02303008
MFA-TR*      ,OPT_DESC_INT_LONG                                                 
MFA-TR*      ,SORT_SEQ_NO                                                       
MFA-TR*      ,ACCOUNT_TYPE_CODE                                                 
MFA-TR*      ,PRINT_RETN_MSG_FL                                                 
MFA-TR*      ,AMT_RETN_DISCOUNT                                                 
MFA-TR*      ,RENEW_BY_DATE                                                     
MFA-TR*      ,NEW_RATE_BEGINS_DATE                                              
MFA-TR*      ,PRINT_BBP_MSG_FL                                                  
MFA-TR*      ,IS_RENEWAL_OPTN_FLEX                                              
MFA-TR*      ,CORE_RATE_PLAN_NO                                                 
MFA-TR*      ,CORE_RATE_PLAN_DDDC                                               
MFA-TR*      ,OPTION_PROMO_DESC                                                 
MFA-TR*      ,WEB_MKT_DESC_LONG                                                 
MFA-TR*      ,AUTO_RENEWAL_FL                                                   
MFA-TR*      ,SENIOR_RATE_FL                                                    
MFA-TR*      )                                                          02310000
MFA-TR*      VALUES                                                     02320000
MFA-TR*      (                                                          02330000
MFA-TR*       :S-RETURN-CODE-1                                          02340000
MFA-TR*      ,:S-OPTION-CD                                              02350000
MFA-TR*      ,:S-OFFER-CD                                               02351007
MFA-TR*      ,:S-THERM-PRICE                                            02370000
MFA-TR*      ,:S-EXIT-FEE                                               02371005
MFA-TR*      ,:S-TIER-SOURCE-CD                                         02372005
MFA-TR*      ,:S-OPTN-VALID-MNTHS                                       02380000
MFA-TR*      ,:S-RATE-CALC-TYPE-CD                                      02390000
MFA-TR*      ,:S-CSC-AMT                                                02400000
MFA-TR*      ,:S-CSC-REFND-FL                                           02410000
MFA-TR*      ,:S-CSC-MNTHS                                              02420000
MFA-TR*      ,:S-RATE-DEFINITION-CD                                     02420112
MFA-TR*      ,:S-CURR-EXT-DESC-LONG                                     02421008
MFA-TR*      ,:S-RENEWAL-DESC-LONG                                      02423008
MFA-TR*      ,:S-OPT-DESC-INT-LONG                                              
MFA-TR*      ,:S-SORT-SEQ-NO                                                    
MFA-TR*      ,:S-ACCOUNT-TYPE-CODE                                              
MFA-TR*      ,:S-PRINT-RETN-MSG-FL                                              
MFA-TR*      ,:S-AMT-RETN-DISCOUNT                                              
MFA-TR*      ,:S-RENEW-BY-DATE                                                  
MFA-TR*      ,:S-NEW-RATE-BEGINS-DATE                                           
MFA-TR*      ,:S-PRINT-BBP-MSG-FL                                               
MFA-TR*      ,:S-IS-RENEWAL-OPTN-FLEX                                           
MFA-TR*      ,:S-CORE-RATE-PLAN-NO                                              
MFA-TR*      ,:S-CORE-RATE-PLAN-DDDC                                            
MFA-TR*      ,:S-OPTION-PROMO-DESC                                              
MFA-TR*      ,:S-WEB-MKT-DESC-LONG                                              
MFA-TR*      ,:S-AUTO-RENEWAL-FL                                                
MFA-TR*      ,:S-SENIOR-RATE-FL                                                 
MFA-TR*      )                                                          02430000
MFA-TR*    END-EXEC.                                                    02440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE SQLCODE             TO ABEND-SQLCODE                 
              MOVE SQLSTATE            TO ABEND-SQLSTATE                
              MOVE '8100'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE 'CSR04007_R1'       TO TABLE-1                       
P00836        PERFORM 9700-PROCESS-ABEND  THRU  9700-EXIT               
           END-IF.                                                      
                                                                        
P00836     ADD 1 TO CTR-ROWS-RS1.                                       
      *                                                                 02610000
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 02640000
P00836******************************************************************05960000
P00836* 8200-SEND-BUS-RULES.                                           *05970000
P00836******************************************************************05980000
P00836 8200-SEND-BUS-RULES.                                             
P00836                                                                  
P00836     EXEC SQL                                                     
P00836       INSERT INTO #CSR04007_R2                            
P00836       (                                                          
P00836        RETURN_CODE                                               
P00836       ,BUS_RULE_MSG_ID                                           
P00836       ,RULE_RESULT_CD                                            
P00836       ,BUS_RULE_XREF_ID                                          
P00836       ,MESSAGE_PARMS                                             
P00836       ,LINK_PARMS                                                
P00836       )                                                          
P00836       VALUES                                                     
P00836       (                                                          
P00836        :S-RETURN-CODE-2                                          
P00836       ,:S-BUS-RULE-MSG-ID                                        
P00836       ,:S-BUS-RULE-RESULT-CD                                     
P00836       ,:S-BUS-RULE-XREF-ID                                       
P00836       ,:S-MESSAGE-PARMS                                          
P00836       ,:S-LINK-PARMS                                             
P00836       )                                                          
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     06050000
MFA-TR*      INSERT INTO SESSION.CSR04007_R2                            06060000
MFA-TR*      (                                                          06070000
MFA-TR*       RETURN_CODE                                               06080000
MFA-TR*      ,BUS_RULE_MSG_ID                                           06090000
MFA-TR*      ,RULE_RESULT_CD                                            06100000
MFA-TR*      ,BUS_RULE_XREF_ID                                          06110000
MFA-TR*      ,MESSAGE_PARMS                                             06120000
MFA-TR*      ,LINK_PARMS                                                06130000
MFA-TR*      )                                                          06230000
MFA-TR*      VALUES                                                     06240000
MFA-TR*      (                                                          06250000
MFA-TR*       :S-RETURN-CODE-2                                          06260000
MFA-TR*      ,:S-BUS-RULE-MSG-ID                                        06270000
MFA-TR*      ,:S-BUS-RULE-RESULT-CD                                     06280000
MFA-TR*      ,:S-BUS-RULE-XREF-ID                                       06290000
MFA-TR*      ,:S-MESSAGE-PARMS                                          06300000
MFA-TR*      ,:S-LINK-PARMS                                             06310000
MFA-TR*      )                                                          06410000
MFA-TR*    END-EXEC.                                                    06420000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00836                                                                  
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00836        NEXT SENTENCE                                             
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
P00836        MOVE SQLCODE             TO ABEND-SQLCODE                 
P00836        MOVE SQLSTATE            TO ABEND-SQLSTATE                
P00836        MOVE '8200'              TO ACTIVE-PARAGRAPH              
P00836        MOVE 'INSERT'            TO ABEND-FUNCTION                
P00836        MOVE 'CSR04007_R2'       TO TABLE-1                       
P00836        PERFORM 9700-PROCESS-ABEND  THRU  9700-EXIT               
P00836     END-IF.                                                      
P00836                                                                  
P00836     ADD 1 TO CTR-ROWS-RS2.                                       
P00836*                                                                 06600000
P00836 8200-EXIT.                                                       
P00836      EXIT.                                                       
      *                                                                 06630000
P00836*****************************************************************         
P00836* 8800-CHECK-RESULTS.                                           *         
P00836*****************************************************************         
P00836 8800-CHECK-RESULTS.                                              
P00836                                                                  
P00836     IF CTR-ROWS-RS1 <= 0                                         
P00836        INITIALIZE                       GTT-RETURN-FIELDS-1      
P00836        MOVE   100                    TO S-RETURN-CODE-1          
P00836        PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
P00836     END-IF.                                                      
P00836                                                                  
P00836     IF CTR-ROWS-RS2 <= 0                                         
P00836        INITIALIZE                       GTT-RETURN-FIELDS-2      
P00836        MOVE   100                    TO S-RETURN-CODE-2          
P00836        PERFORM 8200-SEND-BUS-RULES      THRU 8200-EXIT           
P00836     END-IF.                                                      
P00836                                                                  
P00836 8800-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* 8900-SEND-DONE.                                               *         
P00836*****************************************************************         
P00836 8900-SEND-DONE.                                                  
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         OPEN C1                                                  
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         OPEN C2                                                  
P00836     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
P00836                                                                  
P00836 8900-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* 9000-SEND-ERROR-RESULT.                                       *         
P00836*****************************************************************         
P00836 9000-SEND-ERROR-RESULT.                                          
P00836                                                                  
P00836     MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
P00836                                         S-RETURN-CODE-1          
P00836                                         S-RETURN-CODE-2.         
P00836                                                                  
P00836     MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
P00836                                                                  
P00836     IF WS-GTT01-DECLARED = 'N'                                   
P00836        PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT          
P00836     END-IF.                                                      
P00836                                                                  
P00836     IF WS-GTT02-DECLARED = 'N'                                   
P00836        PERFORM 0100B-DECLARE-GTT        THRU 0100B-EXIT          
P00836     END-IF.                                                      
P00836                                                                  
P00836     PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
P00836     PERFORM 8200-SEND-BUS-RULES         THRU 8200-EXIT.          
P00836                                                                  
P00836 9000-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* 9700-PROCESS-ABEND.                                           *         
P00836*****************************************************************         
P00836 9700-PROCESS-ABEND.                                              
P00836                                                                  
P00836     PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
P00836     PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
P00836                                                                  
P00836 9700-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* 9900-SQL-ERROR-ROUTINE.                                       *         
P00836*****************************************************************         
P00836 9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
P00836                  WHEN :TABLE-ELEMENT-1 > ' ' THEN                
P00836                     LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
P00836                  ELSE                                            
P00836                     ''                                           
P00836               END + CASE                                               
P00836                  WHEN :TABLE-ELEMENT-2 > ' ' THEN                
P00836                     LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
P00836                  ELSE                                            
P00836                     ''                                           
P00836               END + CASE                                               
P00836                  WHEN :TABLE-ELEMENT-3 > ' ' THEN                
P00836                     LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
P00836                  ELSE                                            
P00836                     ''                                           
P00836               END + CASE                                               
P00836                  WHEN :TABLE-ELEMENT-4 > ' ' THEN                
P00836                     LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
P00836                  ELSE                                            
P00836                     ''                                           
P00836               END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
P00836     
MSQ016        GOBACK.                                                    
P00836                                                                  
P00836 9900-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* 9999-END-PROGRAM.                                             *         
P00836*****************************************************************         
P00836 9999-END-PROGRAM.                                                
P00836                                                                  
P00836     PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
P00836     PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
P00836                                                                  
P00836     
MSQ016        GOBACK.                                                    
P00836                                                                  
P00836 9999-EXIT.                                                       
P00836     EXIT.                                                        
