       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04005.                                     
COB303 DATE-WRITTEN.     MAY 18,  2007.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04005              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04005 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVES MARKETING TIER DETAILS OF PROSPECT/EXISTING  --         
      *--     OF PROSPECT/EXISTING CUSTOMERS (THE DETAILS INCLUDES   --         
      *--     TIER, OFFER AND OPTION INFORMATION).                   --         
      *--                                                            --         
A00775*-- SPECIAL NOTE : ANY TIME WE MAKE CHANGES TO MCSCB063, WE    --         
A00775*-- NEED TO ANALYZE THIS PROGRAM FOR THE RESPECTIVE CHANGES.   --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             CALL_TYPE           CHAR(03)                   --         
      *--             INT_EXT_DATA_FL     CHAR(01)                   --         
      *--             TIER_CUST_STAT_CODE CHAR(01)                   --         
      *--             TIER_ACCT_TYPE_CD   CHAR(01)                   --         
      *--             MKT_TIER_RANKING    S9(4) COMP SYNC            --         
      *--             PROMO_CD            CHAR(12)                   --         
      *--             COMPANY_NO          CHAR(02)                   --         
P00269*--             USER_ID             CHAR(07)                   --         
P00269*--             VIEW_APPLY_CD       CHAR(01)                   --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  27 JUNE 2007  AD94658     NEW CODE                        --         
      *--  01 NOV  2007  GD97441     CHANGES BASED ON DETAILED       --         
      *--                            REQUIREMENTS                    --         
      *--  19 MAY  2008  GD97441     TIER_CUST_STAT_CD &             --         
      *--                            TIER_CUST_STAT_CD CHECKS HAVE   --         
      *--                            BEEN ADDED BACK TO "CRM"        --         
      *--                            PROMOTION CODE FLOW.            --         
A00775*--  26 JAN  2009  GD97441     1.MCSCB063 CALL IS BEEN REPLACED--         
A00775*--                            WITH CALCULATIONS IN PROGRAM.   --         
A00775*--                            2.ONLY ONE GLOBAL TEMP TABLE FOR--         
A00775*--                            GIVEN CALL BASED ON CALL TYPE.  --         
A00775*--                            3.ADDED "ROWSET POSITIONING" FOR--         
A00775*--                            ALL GLOBAL TEMP TABLES.         --         
A00775*--                            4.CODE_UTIL_TYPE IS HARDCODED   --         
A00775*--                              TO "G" IN ALL SQLS.           --         
A00910*--  09 MAR  2009  GD97441     IF MARKET TIER EXPIRES, USE THE --         
A00910*--                            DEFAULT MARKET TIER FOR CRM.    --         
P00141*--  04 APR  2009  SS97726     ADD START/END DATE TO CRM USER  --         
P00141*--                            TABLE CRM_OPT_ATTR_INCTV        --         
P00165*--  07 JUL  2009  SS97726     SET THERM PRICE TO ZERO FOR ALL --         
P00165*--                            STEP RATES.                     --         
A02087*--  05 FEB  2010  GD97441     GET URL FOR CRM CALL_TYPE=I     --         
A02087*--                            WITHOUT ADDITIONAL CHECKS.      --         
P00269*--  11 FEB  2010  MN90523     INCLUDED OFFER_OPT_START_DT AND --         
P00269*--                            OFFER_OPT_END_DT                --         
P00269*--  26 MAR  2010  MN90523     INCLUDED CRM SECURITY CHANGED   --         
P00269*--                                                            --         
PRDFIX*--  09 AUG  2010  VY95550     INCREASED THE SIZE OF THE ARRAY --         
PRDFIX*--                            WHICH HOLD THE SPECIAL FACTOR   --         
PRDFIX*--                            APPL FROM 300 TO 600.           --         
A02804*--                                                            --         
A02804*--  08 OCT  2010  JC91900     Fix issue w/VARPRICE factors.   --         
A-2804*--                                                            --         
A-2804*--  01 NOV  2010  MN90523     Included INT_DISP_END_TS for    --         
A-2804*--                            COMBOFIXED factors              --         
I01095*--  09 DEC  2010  VY95550     Included new columns            --         
P00485*--  03 MAR  2011  JC91900     Fix issue w\expiration date.    --         
P00485*--  21 MAR  2011  SB93596     ADD TWO PART RATE CODE TO FOR   --         
P00485*--                            WEB CALLS.                      --         
P00453*--  18 JAN  2011  MN90523     PULL ONLY PREPAID PLAN OFFER IF --         
P00453*--                            I/P RANK IS SAME AS DEF-PRP-RANK--         
P00473*--  12 MAY  2011  SB93596     CHGS INCLUDED TO PULL APPROVED  --         
P00473*--                            OPTION/OFFER/PROMOTION          --         
P00473*--                            APT ATTR INCTV RECORDS.         --         
P00544*--  03 NOV  2011  GD97441     ADDED NEW COLUMNS TO WEB RES SET--         
P00544*--                            OPT_TYPE_WEB HAS CUSTOMIZED OPT --         
P00544*--                            DERIVATION AND IS APPROVED BY   --         
P00544*--                            LAUREN / LISA.                  --         
A04019*--  24 MAY  2012  VIJAY       SEB CSC CHANGES.                --         
P00680*--  17 AUG  2012  SS97726     CUSTOMER RETENTION & ACQUISITION--         
A04362*--  19 SEP  2012  DB41297     SET S-INCTV-ENABLE-FLAG = 'Y'   --         
NEW680*--  26 SEP  2012  SS97726     ADD FACTOR_DESC TO CRM RESULT SET-         
NEW680*--                P00680                                      --         
A04221*--  20 OCT  2012  SV95326     CHANGE THE RATE_SPCL_FCTR CURSOR--         
A04221*--                            WITH NEW SET OF CONDITION.      --         
P680P2*--  19 FEB  2013  SS97726     SEND PRICE NEGOTIATION PARAMETERS-         
P680P2*--                P00680      TO CRM/RATE SELECTION.          --         
P00614*--  07 MAY  2013  GD43988     1.CHANGED PROGRAM TO SUPPORT OLD--         
P00614*--                            LEGACY SOA & WEB MODERNIZATION. --         
P00614*--                            2.ADDED "ECS" CACHE CALL TYPE.  --         
P00614*--                            3.UPDATED EXTERNAL CURSOR LOGIC.--         
P614FX*--  29 AUG  2013  GD43988     EXIT FEE FIX - OLD WEB SOA CALL.--         
P614P2*--  17 SEP  2013  GD43988     WEB/ECS:ADDED HIDE OPTION LOGIC --         
P614P2*--                            WEB/ECS-PERF IMPRV:COMMENT 5700---         
P614P2*--                            PLEASE REVISIT ABOVE CHANGES IN --         
P614P2*--                            FLEXIBLE BILLING PROJECT.       --         
P00838*--  14 MAY  2014  SS97726     Pull Web Discounted Offers for  --         
P00838*--                            ECS cache call.                 --         
P00892*--  06 APR  2015  VIJAY       ADD FI.AUTO_RENEWAL_FL          --         
P00892*--                                                            --         
P00836*--  23 APR  2015  SS97726     Add Option Duration for Web.    --         
A05470*--  16 FEB  2016  GD43988     INCREASED RATE SPCL FCTR ARRAY  --         
A05470*--                ACT010      SIZE FROM 600 TO 1500.          --         
P00836*--  22 APR  2016  GD43988     Remove default checks for ECS.  --         
P00805*--  01 MAR  2016  GD43988     MODIFIED ATTR_DET CURSOR TO SEND--         
P00805*--                            ALL ATTRIBUTE DATA FOR CRM CALL.--         
OTPOOL*--  22 AUG  2016  SS45239     PASS CORE RATE DDDC             --         
I02262*--  17 OCT  2016  SS45239     PASS CORE RATE DDDC FOR WEB     --         
P01137*--  17 JAN  2017  GD43988     REPLACED CSS_NAVIGATION WITH    --         
P01137*--                            CATEGORY_ID = 346 CHECK         --         
P1137C*--  19 MAR  2017  GD43988     ADDED PROGRAM VARIABLES FOR     --         
P1137C*--                            CURRENT DATE/TIMESTAMP          --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-RATE-SPCL-FCTR  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04005'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OPTION  (FI)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_ATTR_INCV   (G7)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTINCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OFFER   (FG)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFF_MKT_TIER   (DU)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFMKT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFFER_OPTION   (E9)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFOPT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_MKT_TIER       (IG)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTTER                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GROUP     (F7)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRATGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GRP_OFFER (G5)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTEGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OPT_ATTR_INCTV (HQ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SPCL_FCTR_APPL (SA)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SPCL_FCTR (SF)                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PRICE_SCHED (PS)                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_VRSN_DEF (J4)                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTVRSN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC (RD)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_MKT_PROMOTION  (KM)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_CREATOR  (RT)                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
      *                                                                         
P00165******************************************************************        
P00165*    CSS_RATE_COMP_DEF (J1)                                      *        
P00165******************************************************************        
P00165*                                                                         
P00165     EXEC SQL                                                             
P00165         INCLUDE TBRTCDEF                                                 
P00165     END-EXEC.                                                            
P00165*                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM (G6)                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
P00269******************************************************************        
P00269*    CRM_ACCESS_OFF_OPT  (CI)                                    *        
P00269******************************************************************        
P00269*                                                                         
P00269     EXEC SQL                                                             
P00269        INCLUDE TBCRMACC                                                  
P00269     END-EXEC.                                                            
P00269*                                                                         
P00269******************************************************************        
P00269*    CSS_CATEGORY        (F5)                                    *        
P00269******************************************************************        
P00269*                                                                         
P00269     EXEC SQL                                                             
P00269        INCLUDE TBCAT                                                     
P00269     END-EXEC.                                                            
I01095*                                                                         
I01095******************************************************************        
I01095*    CSS_DELINQUENCY     (C8)                                    *        
I01095******************************************************************        
I01095      EXEC SQL                                                            
I01095           INCLUDE TBDELQ                                                 
I01095      END-EXEC.                                                           
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04005'.      
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-NAME                PIC X(26) VALUE                  
                                           'SESSION.CSR04005_R1'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  WS-LITERALS.                                                 
           05 MCSCB063                PIC X(08) VALUE 'MCSCB063'.       
P680P2     05 WS-PRICE-NEGOTIATION-CD PIC X(20) VALUE                   
P680P2                                 'PRC-NEGOTIATION-PARM'.          
I01095     05 WS-RATE-EFF-DLINQ-CD    PIC X(15) VALUE                   
I01095                                 'RATE-EFF-MONTHS'.               
I01095     05 WS-CRM-RT-CHG-DLINQ-CD  PIC X(19) VALUE                   
I01095                                 'CRM-RATE-CHANGE-DAY'.           
P00453     05 WS-PRP-DEFAULT-TIER     PIC X(20) VALUE                   
P00453                                 'PRP-DEFAULT-TIER'.              
P00453     05 WS-PRP-TIER-RANK-FL     PIC X(01) VALUE 'N'.              
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
      *                                                                         
       01  LS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
      *                                                                         
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE            PIC S9(9) VALUE 0 COMP.          
           10 S-TIER-CUST-STAT-CD      PIC X(1)  VALUE SPACES.          
           10 S-TIER-ACCT-TYPE-CD      PIC X(1)  VALUE SPACES.          
           10 S-MKT-TIER-RANKING       PIC S9(4) USAGE COMP             
                                                 VALUE ZEROES.          
           10 S-MKT-TIER-START-DT      PIC X(10) VALUE SPACES.          
           10 S-MKT-TIER-DESC          PIC X(50) VALUE SPACES.          
           10 S-MKT-TIER-END-DT        PIC X(10) VALUE SPACES.          
           10 S-TIER-OFFER-VIEW        PIC S9(4) USAGE COMP             
                                                 VALUE ZEROES.          
           10 S-OFFER-CD               PIC X(12) VALUE SPACES.          
           10 S-OFFER-TIER-STRT-DT     PIC X(10) VALUE SPACES.          
           10 S-OFFER-TIER-END-DT      PIC X(10) VALUE SPACES.          
           10 S-TIER-DEFLT-OFFR-CD     PIC X(1)  VALUE SPACES.          
           10 S-OFFER-DESC-INT         PIC X(50) VALUE SPACES.          
           10 S-OFFER-DESC-EXT         PIC X(50) VALUE SPACES.          
           10 S-OFFER-START-DT         PIC X(10) VALUE SPACES.          
           10 S-OFFER-END-DT           PIC X(10) VALUE SPACES.          
           10 S-PROMO-CD-INT-FL        PIC X(1)  VALUE SPACES.          
           10 S-PROMO-CD-EXT-FL        PIC X(1)  VALUE SPACES.          
           10 S-SPCL-OFFER-TYPE-CD     PIC X(2)  VALUE SPACES.          
           10 S-OPTION-CD              PIC X(12) VALUE SPACES.          
           10 S-OPT-DESC-INT           PIC X(50) VALUE SPACES.          
           10 S-OPT-DESC-INT-LONG.                                      
               49 S-OPT-DESC-INT-LONG-LEN                               
                                       PIC S9(4) COMP SYNC VALUE +0.    
               49 S-OPT-DESC-INT-LONG-TEXT                              
                                       PIC X(255) VALUE SPACES.         
           10 S-CURR-EXT-DESC-LONG.                                     
               49 S-CURR-EXT-DESC-LONG-LEN                              
                                       PIC S9(4) COMP SYNC VALUE +0.    
               49 S-CURR-EXT-DESC-LONG-TEXT                             
                                       PIC X(255) VALUE SPACES.         
           10 S-WEB-DESC-LONG.                                          
               49 S-WEB-DESC-LONG-LEN  PIC S9(4) COMP SYNC VALUE +0.    
               49 S-WEB-DESC-LONG-TEXT PIC X(255) VALUE SPACES.         
           10 S-CODE-UTIL-TYPE         PIC X(1)  VALUE SPACES.          
           10 S-RATE-PLAN-NO           PIC X(3)  VALUE SPACES.          
           10 S-OPTION-START-DT        PIC X(10) VALUE SPACES.          
           10 S-OPTION-END-DT          PIC X(10) VALUE SPACES.          
           10 S-OPTION-SORT-SEQ-NO     PIC S9(4) USAGE COMP             
                                                 VALUE ZEROES.          
           10 S-THERM-PRICE            PIC S9(05)V9(6) USAGE COMP-3     
                                                 VALUE ZEROES.          
           10 S-CSC-AMT                PIC S9(05)V9(6) USAGE COMP-3     
                                                 VALUE ZEROES.          
           10 S-RT-ATTR-INCTV-TYPE     PIC X(15) VALUE SPACES.          
           10 S-RT-ATTR-INCTV-DESC     PIC X(50) VALUE SPACES.          
           10 S-ATTR-INCTV-SEQ-NO      PIC S9(4) USAGE COMP             
                                                 VALUE ZEROES.          
           10 S-DURATION-NO            PIC S9(4) USAGE COMP             
                                                 VALUE ZEROES.          
P00836     10 S-FXD-PRC-OPTN-DUR-NO    PIC S9(4) USAGE COMP             
P00836                                           VALUE ZEROES.          
           10 S-ATTR-INCTV-VALUE       PIC S9(05)V9(6) USAGE COMP-3     
                                                 VALUE ZEROES.          
           10 S-ATTR-INCTV-VAL-TX      PIC X(20) VALUE SPACES.          
           10 S-RATE-GRP-DESC          PIC X(50) VALUE SPACES.          
           10 S-RATE-GRP-DESC-LONG     PIC X(255) VALUE SPACES.         
           10 S-RT-GRP-SORT-SEQ-NO     PIC S9(4) USAGE COMP             
                                                 VALUE ZEROES.          
           10 S-SORT-SEQ-NO            PIC S9(4) USAGE COMP             
                                                 VALUE ZEROES.          
           10 S-PROMO-CD               PIC X(12) VALUE SPACES.          
           10 S-EXT-LANDING-PG-URL.                                     
               49 S-EXT-LANDING-PG-URL-LEN                              
                                       PIC S9(4) COMP SYNC VALUE +0.    
               49 S-EXT-LANDING-PG-URL-TEXT                             
                                       PIC X(255) VALUE SPACES.         
           10 S-INCTV-ENABLE-FLAG      PIC X(01) VALUE SPACES.          
I01095     10 S-INT-LANDING-PG-URL.                                     
I01095         49 S-INT-LANDING-PG-URL-LEN                              
I01095                                 PIC S9(4) COMP SYNC VALUE +0.    
I01095         49 S-INT-LANDING-PG-URL-TEXT                             
I01095                                 PIC X(255) VALUE SPACES.         
I01095     10 S-WEB-MKT-DESC-LONG.                                      
I01095         49 S-WEB-MKT-DESC-LONG-LEN                               
I01095                                 PIC S9(4) COMP SYNC VALUE +0.    
I01095         49 S-WEB-MKT-DESC-LONG-TEXT                              
I01095                                 PIC X(1024) VALUE SPACES.        
I01095     10 S-RATE-EFFECTIVE-DT      PIC X(10) VALUE SPACES.          
I01095     10 S-RATE-EXPIRATION-DATE   PIC X(10) VALUE SPACES.          
I01095     10 S-EXIT-FEE               PIC S9(05)V9(6) USAGE COMP-3     
I01095                                           VALUE ZEROES.          
P00485                                                                  
P00485     10 S-RATE-DEFINITION-CD     PIC X(1)  VALUE SPACES.          
P00544     10 S-OPT-CALC-TYPE-CD       PIC X(02) VALUE SPACES.          
P00544     10 S-OPT-TYPE-WEB           PIC X(01) VALUE SPACES.          
P00680     10 S-THERM-PRC-DSCNT-FL     PIC X(01) VALUE SPACES.          
P00680     10 S-CSC-DSCNT-FL           PIC X(01) VALUE SPACES.          
P00680     10 S-TOT-THERM-PRC-DSCNT    PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-TOT-CSC-DSCNT          PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-DSCNTD-THERM-PRC-CRM   PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-DSCNTD-CSC-CRM         PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-THERM-PRC-DSCNT-A-DESC PIC X(60) VALUE SPACES.          
P00680     10 S-THERM-PRC-DSCNT-A-VAL  PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-THERM-PRC-DSCNT-A-DUR  PIC S9(4) USAGE COMP             
P00680                                           VALUE ZEROES.          
P00680     10 S-THERM-PRC-DSCNT-B-DESC PIC X(60) VALUE SPACES.          
P00680     10 S-THERM-PRC-DSCNT-B-VAL  PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-THERM-PRC-DSCNT-B-DUR  PIC S9(4) USAGE COMP             
P00680                                           VALUE ZEROES.          
P00680     10 S-THERM-PRC-DSCNT-C-DESC PIC X(60) VALUE SPACES.          
P00680     10 S-THERM-PRC-DSCNT-C-VAL  PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-THERM-PRC-DSCNT-C-DUR  PIC S9(4) USAGE COMP             
P00680                                           VALUE ZEROES.          
P00680     10 S-THERM-PRC-DSCNT-D-DESC PIC X(60) VALUE SPACES.          
P00680     10 S-THERM-PRC-DSCNT-D-VAL  PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-THERM-PRC-DSCNT-D-DUR  PIC S9(4) USAGE COMP             
P00680                                           VALUE ZEROES.          
P00680     10 S-THERM-PRC-DSCNT-E-DESC PIC X(60) VALUE SPACES.          
P00680     10 S-THERM-PRC-DSCNT-E-VAL  PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-THERM-PRC-DSCNT-E-DUR  PIC S9(4) USAGE COMP             
P00680                                           VALUE ZEROES.          
P00680     10 S-CSC-DSCNT-A-DESC       PIC X(60) VALUE SPACES.          
P00680     10 S-CSC-DSCNT-A-VAL        PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-CSC-DSCNT-A-DUR        PIC S9(4) USAGE COMP             
P00680                                           VALUE ZEROES.          
P00680     10 S-CSC-DSCNT-B-DESC       PIC X(60) VALUE SPACES.          
P00680     10 S-CSC-DSCNT-B-VAL        PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-CSC-DSCNT-B-DUR        PIC S9(4) USAGE COMP             
P00680                                           VALUE ZEROES.          
P00680     10 S-CSC-DSCNT-C-DESC       PIC X(60) VALUE SPACES.          
P00680     10 S-CSC-DSCNT-C-VAL        PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-CSC-DSCNT-C-DUR        PIC S9(4) USAGE COMP             
P00680                                           VALUE ZEROES.          
P00680     10 S-CSC-DSCNT-D-DESC       PIC X(60) VALUE SPACES.          
P00680     10 S-CSC-DSCNT-D-VAL        PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-CSC-DSCNT-D-DUR        PIC S9(4) USAGE COMP             
P00680                                           VALUE ZEROES.          
P00680     10 S-CSC-DSCNT-E-DESC       PIC X(60) VALUE SPACES.          
P00680     10 S-CSC-DSCNT-E-VAL        PIC S9(05)V9(6) USAGE COMP-3     
P00680                                           VALUE ZEROES.          
P00680     10 S-CSC-DSCNT-E-DUR        PIC S9(4) USAGE COMP             
P00680                                           VALUE ZEROES.          
NEW680     10 S-FCTR-LONG-DESC-CRM     PIC X(60) VALUE SPACES.          
P680P2     10 S-MAX-OFFER-OPT-PRICE    PIC S9(05)V9(6) USAGE COMP-3     
P680P2                                           VALUE ZEROES.          
P680P2     10 S-PRICE-NEGOTIATION-PARM PIC S9(05)V9(6) USAGE COMP-3     
P680P2                                           VALUE ZEROES.          
P00614     10 S-WEB-NEW-EXISTS-CD      PIC X(01) VALUE SPACES.          
P00614     10 S-WEB-SIGN-UP-FL         PIC X(01) VALUE SPACES.          
P00614     10 S-CUST-ACCT-DEFLT-FL     PIC X(01) VALUE SPACES.          
P00614     10 S-SENIOR-RATE-FL         PIC X(01) VALUE SPACES.          
P00614     10 S-FLEX-OPT-FL            PIC X(01) VALUE SPACES.          
P00892     10 S-AUTO-RENEWAL-FL        PIC X(01) VALUE SPACES.          
OTPOOL     10 S-CORE-RATE-PLAN-DDDC    PIC S9(3)V9(2) USAGE COMP-3      
OTPOOL                                           VALUE ZEROES.          
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
P680P2     05  WS-MAX-OFFER-OPTS-CTR   PIC S9(4) COMP VALUE 0.          
OTPOOL     05  DDC-CNT                 PIC S9(5) COMP-3 VALUE +0.       
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                         
       01  WS-ADJUSTMENTS.                                              
           10  WS-BC-CODE-ADJUST-TYPE        PIC X(1).                  
P00680         88  ADD-TO-COMPONENT-AMT      VALUE 'A'.                 
               88  ADD-TO-NET-RATE           VALUE 'C'.                 
               88  REPL-NET-RATE             VALUE 'F'.                 
               88  SUB-FROM-NET-RATE         VALUE 'J'.                 
               88  ADD-TO-BFC-CHARGE         VALUE 'L'.                 
               88  SUBTRACT-FROM-BFC-CHARGE  VALUE 'O'.                 
               88  REPLACE-BFC-CHARGE        VALUE 'N'.                 
                                                                        
       01  WS-MISC.                                                     
P1137C     05  WS-CURR-DATE            PIC X(10) VALUE SPACES.          
P1137C     05  WS-CURR-TIMESTAMP       PIC X(26) VALUE SPACES.          
           05  WS-CALL-TYPE            PIC X(03) VALUE SPACES.          
P00269     05  WS-VIEW-APPLY-CD        PIC X(01) VALUE SPACES.          
           05  WS-MKT-TIER-RANKING     PIC S9(4) USAGE COMP VALUE 0.    
           05  WS-MIN-TIER-RANKING     PIC S9(4) USAGE COMP.            
           05  WS-MAX-TIER-RANKING     PIC S9(4) USAGE COMP.            
           05  MULTIPLE-ROWS           PIC S9(9) VALUE -811 COMP.       
           05  WS-SPCL-OFFER-TYPE-CD   PIC X(02) VALUE SPACES.          
           05  WS-YES-NULL             PIC S9(04) VALUE -1.             
           05  WS-CRMACTV-PROMO-YES    PIC X(01) VALUE SPACES.          
           05  WS-CRMEXPI-OFFER-CD     PIC X(12) VALUE SPACES.          
           05  WS-CRMEXPI-AD-CHAN-CD   PIC X(10) VALUE SPACES.          
           05  WS-CRMCURR-PROMO-CD     PIC X(12) VALUE SPACES.          
           05  WS-WEBACTV-PROMO-YES    PIC X(01) VALUE SPACES.          
           05  WS-WEBEXPI-OFFER-CD     PIC X(12) VALUE SPACES.          
           05  WS-WEBEXPI-AD-CHAN-CD   PIC X(10) VALUE SPACES.          
           05  WS-WEBCURR-PROMO-CD     PIC X(12) VALUE SPACES.          
A00775     05  WS-CUST-DFLT-RANK       PIC S9(4) USAGE COMP.            
A00775     05  WS-CUST-DFLT-OFF-VIEW   PIC S9(4) USAGE COMP.            
A00775     05  WS-RATE-SPCL-FCTR-TABLE.                                 
A00775        10 ARR-RATE-PLAN-NO      PIC X(03)                        
A05470                OCCURS 1500 TIMES INDEXED BY WS-RATE-INDX.        
A00775        10 ARR-FACTOR-ID         PIC X(09)                        
A05470                OCCURS 1500 TIMES INDEXED BY WS-FCTRID-INDX.      
A00775        10 ARR-FACTOR-TYPE       PIC X(01)                        
A05470                OCCURS 1500 TIMES INDEXED BY WS-FCTTYP-INDX.      
A00775        10 ARR-ADJUST-ELEMENT    PIC X(01)                        
A05470                OCCURS 1500 TIMES INDEXED BY WS-ADJ-ELEM-INDX.    
COB305        10 ARR-FACTOR        PIC S9(3)V9(6) USAGE COMP-3 
COB305           OCCURS 1500 TIMES  INDEXED BY WS-FACTOR-INDX VALUE 0.     
I01095        10 ARR-INT-DISP-START-TS PIC X(26)                        
A05470                OCCURS 1500 TIMES  INDEXED BY WS-INT-DISP-INDX.   
P00269     05  WS-ACCESS-FLAG          PIC X(01) VALUE SPACES.          
A04362     05  WS-CHECK-KEY.                                            
P00269         10  WS-CHECK-OFFER      PIC X(12) VALUE SPACES.          
P00269         10  WS-CHECK-OPTION     PIC X(12) VALUE SPACES.          
P00269     05  WS-SUPER-USER-FLAG      PIC X(01) VALUE 'N'.             
A00775     05  WS-RATE-SPCL-FCTR-COUNT PIC 9(04) VALUE 0.               
A00775     05  WS-THERM-PRICE          PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775     05  WS-CSC-AMT              PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
P00680     05  WS-PRC-DSCNT-FL         PIC X(01) VALUE 'N'.             
P00680     05  WS-CSC-DSCNT-FL         PIC X(01) VALUE 'N'.             
P00680     05  WS-TOT-PRC-DSCNT        PIC S9(5)V9(6) USAGE COMP-3      
P00680                                                VALUE 0.          
P00680     05  WS-TOT-CSC-DSCNT        PIC S9(5)V9(6) USAGE COMP-3      
P00680                                                VALUE 0.          
P00680     05  WS-PRC-DSCNT-CTR        PIC S9(4) USAGE COMP.            
P00680     05  WS-CSC-DSCNT-CTR        PIC S9(4) USAGE COMP.            
I01095     05  WS-RATE-EFFECTIVE-DT    PIC X(10) VALUE SPACES.          
I01095     05  WS-RATE-EXPIRATION-DATE.                                 
I01095         10  WS-RATE-EXPIRATION-YYYY PIC X(04) VALUE SPACES.      
I01095         10  WS-FILLER-01            PIC X(01) VALUE SPACES.      
I01095         10  WS-RATE-EXPIRATION-MM   PIC X(02) VALUE SPACES.      
I01095         10  WS-FILLER-02            PIC X(01) VALUE SPACES.      
I01095         10  WS-RATE-EXPIRATION-DD   PIC X(02) VALUE SPACES.      
I01095     05  WS-EXIT-FEE             PIC S9(05)V9(6) USAGE COMP-3     
I01095                                           VALUE ZEROES.          
A00775     05  WS-ADJ-AMT-VAR-1.                                        
A00775         10 WS-ADD-AMT1          PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775         10 WS-SUB-AMT1          PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775         10 WS-REPL-AMT1         PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775         10 WS-ADD-CSC-AMT1      PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775         10 WS-SUB-CSC-AMT1      PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775         10 WS-REPL-CSC-AMT1     PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775     05  WS-ADJ-AMT-VAR-2.                                        
A00775         10 WS-ADD-AMT2          PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775         10 WS-SUB-AMT2          PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775         10 WS-REPL-AMT2         PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775         10 WS-ADD-CSC-AMT2      PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775         10 WS-SUB-CSC-AMT2      PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
A00775         10 WS-REPL-CSC-AMT2     PIC S9(5)V9(6) USAGE COMP-3      
A00775                                                VALUE 0.          
I01095     05  WS-DUMMY-DATE           PIC X(10) VALUE SPACES.          
I01095     05  WS-TIME-STAMP           PIC X(26) VALUE SPACES.          
I01095     05  WS-RATE-EFF-DLINQ       PIC S9(4) USAGE COMP             
I01095                                           VALUE +0.              
I01095     05  WS-CRM-RT-CHG-DAY       PIC S9(4) USAGE COMP             
I01095                                           VALUE +0.              
I01095     05  WS-CRM-RT-CHG-DAY-NUM   PIC 9(04) VALUE ZEROS.           
I01095     05  WS-CRM-RT-CHG-DAY-CHAR REDEFINES WS-CRM-RT-CHG-DAY-NUM   
I01095                                 PIC X(04).                       
P00453     05  WS-PRP-MKT-TIER-RANK    PIC S9(4) USAGE COMP VALUE +0.   
A04019     05  WS-CSC-AMT-DESC         PIC $Z9.99.                      
A04019     05  WS-CSC-LIT-DESC         PIC X(04) VALUE ' CSC'.          
COB305     05 WS-PRC-NEGOTIATION-PARM        PIC S9(4)V9(5) 
COB305       USAGE COMP-3 VALUE 0.     
P680P2                                                                  
P680P2* TABLE TO STORE PRICES FOR OPTIONS ON THE MAX_PRICE_OFFER_CD             
P680P2     05  WS-MAX-OFFER-OPTIONS.                                    
P680P2         10  WS-MAX-OFFER-OPTION OCCURS 10 TIMES                  
P680P2                                 INDEXED BY WS-OPTION-INDX.       
P680P2             15 WS-MAX-OFFER-OPT-CD      PIC X(12) VALUE SPACES.  
P680P2             15 WS-MAX-OFFER-OPT-FCTR-ID PIC X(09) VALUE SPACES.  
P680P2             15 WS-MAX-OFFER-OPT-DUR-NO  PIC S9(4) USAGE COMP     
P680P2                                                   VALUE 0.       
P680P2             15 WS-MAX-OFFER-OPT-PRICE   PIC S9(9)V9(6)  COMP-3   
P680P2                                                   VALUE 0.       
A04362 01  WS-SECURE-OFF-OPT-TBL.                                       
A04362     05  WS-SEC-CNT              PIC S9(3) COMP-3 VALUE +0.       
A04362     05  WS-SECURE-OFF-OPT-TABLE OCCURS 0 TO 100 TIMES            
A04362                                 DEPENDING ON WS-SEC-CNT          
A04362                                 ASCENDING KEY WS-SEC-KEY         
A04362                                 INDEXED BY WS-SEC-TAB-INDX.      
A04362         10 WS-SEC-KEY.                                           
A04362            15 WS-SEC-OFFER      PIC X(12).                       
A04362            15 WS-SEC-OPTION     PIC X(12).                       
A04362         10 WS-SEC-VIEW-APPLY-CD PIC X(01).                       
A04362         10 WS-SEC-ACCESS-FL     PIC X(01).                       
      *                                                                         
OTPOOL 01  WS-DDDC-TABLE.                                               
OTPOOL     05  WS-DDDC-TBL OCCURS 0 TO 999                              
OTPOOL                     DEPENDING ON DDC-CNT                         
OTPOOL                     ASCENDING KEY DDC-RATE-PLAN-NO               
OTPOOL                     INDEXED BY DDC-IND.                          
OTPOOL         10 DDC-RATE-PLAN-NO          PIC X(3).                   
OTPOOL         10 DDC-FACTOR                PIC S9(3)V99.               
OTPOOL                                                                  
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  IND-ATTR-INCTV-VALUE    PIC S9(04) COMP.                 
           05  IND-SORT-SEQ-NO         PIC S9(04) COMP.                 
           05  IND-RATE-GROUP-CD       PIC S9(04) COMP.                 
           05  IND-RATE-GRP-DESC       PIC S9(04) COMP.                 
           05  IND-RATE-GRP-DESC-LONG  PIC S9(04) COMP.                 
           05  IND-RT-GRP-SORT-SEQ-NO  PIC S9(04) COMP.                 
           05  IND-EXT-LANDING-PG-URL  PIC S9(04) COMP.                 
           05  IND-PROMO-CD            PIC S9(04) COMP.                 
A00775     05  IND-FACTOR-ID           PIC S9(04) COMP.                 
P00269     05  IND-ACCESS-FLAG         PIC S9(04) COMP.                 
I01095     05  IND-INT-LANDING-PG-URL  PIC S9(04) COMP.                 
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-TR-ROWS1     PIC X(01) VALUE 'N'.              
              88 NO-MORE-TR-ROWS1               VALUE 'Y'.              
           05 WS-NO-MORE-TR-ROWS2     PIC X(01) VALUE 'N'.              
              88 NO-MORE-TR-ROWS2               VALUE 'Y'.              
           05 WS-NO-MORE-TR-ROWS3     PIC X(01) VALUE 'N'.              
              88 NO-MORE-TR-ROWS3               VALUE 'Y'.              
           05 WS-NO-MORE-TR-ROWS4     PIC X(01) VALUE 'N'.              
              88 NO-MORE-TR-ROWS4               VALUE 'Y'.              
           05 WS-NO-MORE-TR-ROWS5     PIC X(01) VALUE 'N'.              
              88 NO-MORE-TR-ROWS5               VALUE 'Y'.              
           05 WS-NO-MORE-TR-ROWS6     PIC X(01) VALUE 'N'.              
              88 NO-MORE-TR-ROWS6               VALUE 'Y'.              
           05 WS-NO-MORE-TR-ROWS7     PIC X(01) VALUE 'N'.              
              88 NO-MORE-TR-ROWS7               VALUE 'Y'.              
P00680     05 WS-NO-MORE-TR-ROWS8     PIC X(01) VALUE 'N'.              
P00680        88 NO-MORE-TR-ROWS8               VALUE 'Y'.              
P00680     05 WS-NO-MORE-TR-ROWS9     PIC X(01) VALUE 'N'.              
P00680        88 NO-MORE-TR-ROWS9               VALUE 'Y'.              
P00269     05 WS-SECURE-OFFER-SW      PIC X(01) VALUE 'N'.              
P00269        88 SECURE-OFFER                   VALUE 'Y'.              
P00269        88 OFFER-NOT-SECURE               VALUE 'N'.              
P00269     05 WS-SECURE-OPTION-SW     PIC X(01) VALUE 'N'.              
P00269        88 SECURE-OPTION                  VALUE 'Y'.              
P00269        88 OPTION-NOT-SECURE              VALUE 'N'.              
P00269     05 WS-USER-OFFR-ACCESS-SW  PIC X(01) VALUE 'N'.              
P00269        88 USER-HAS-OFFR-ACCESS           VALUE 'Y'.              
P00269     05 WS-USER-OPTN-ACCESS-SW  PIC X(01) VALUE 'N'.              
P00269        88 USER-HAS-OPTN-ACCESS           VALUE 'Y'.              
P00269     05 WS-SUPER-USER-SW        PIC X(01) VALUE 'N'.              
P00269        88 SUPER-USER                     VALUE 'Y'.              
P680P2     05 WS-MAX-OFFER-OPT-SW     PIC X(01) VALUE 'N'.              
P680P2        88 MAX-OFFER-OPT-LOC              VALUE 'Y'.              
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW            PIC X(01) VALUE 'N'.              
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW           PIC X(01) VALUE 'Y'.              
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
      ******************************************************************        
      **  CURSOR DECLARATION TO FETCH OFFER DETAILS BASED ON          **        
      **  MIN & MAX MKT TIER RANKING. INTERNAL DESC WILL BE FETCHED.  **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE TIERANK_RTPKOFF_INT CURSOR FOR                   
                 SELECT DU.MKT_TIER_RANKING                             
                       ,DU.OFFER_TIER_END_DT                            
                       ,DU.OFFER_TIER_STRT_DT                           
                       ,DU.TIER_ACCT_TYPE_CD                            
                       ,DU.TIER_CUST_STAT_CD                            
                       ,DU.TIER_DEFLT_OFFR_CD                           
                       ,FG.OFFER_CD                                     
                       ,FG.OFFER_DESC_INT                               
                       ,FG.OFFER_DESC_INT_LNG                           
                       ,FG.OFFER_END_DT                                 
                       ,FG.OFFER_START_DT                               
                       ,FG.PROMO_CD_INT_FL                              
                       ,FG.SPCL_OFFER_TYPE_CD                           
P680P2                 ,FG.MAX_PRICE_OFFER_CD                           
                       ,KM.PROMO_CD                                     
                       ,KM.EXT_LANDING_PG_URL                           
I01905                 ,KM.INT_LANDING_PG_URL                           
                 FROM   CRM_OFF_MKT_TIER     DU
                           WITH(READUNCOMMITTED)  JOIN                   
                        CRM_RT_PKG_OFFER     FG WITH(READUNCOMMITTED)           
                   ON  (FG.OFFER_CD   =   DU.OFFER_CD                   
                  AND   FG.COMPANY_NO =   DU.COMPANY_NO)  LEFT JOIN     
                        CRM_MKT_PROMOTION    KM WITH(READUNCOMMITTED)           
                   ON  (:WS-CALL-TYPE        = 'CRM'                    
A02087**********  AND   :WS-MKT-TIER-RANKING = 999                              
                  AND   KM.OFFER_CD          = FG.OFFER_CD              
                  AND   KM.COMPANY_NO        = FG.COMPANY_NO            
A02087**********  AND   FG.PROMO_CD_INT_FL   = 'Y'                              
P1137C            AND   KM.PROMO_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )           
P1137C            AND   KM.PROMO_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )           
P1137C            AND   KM.PROMO_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P1137C            AND   KM.PROMO_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473            AND   KM.PROC_STATUS_CD     = 'AC' )                  
                WHERE DU.TIER_CUST_STAT_CD    =  :DU-TIER-CUST-STAT-CD  
                  AND DU.TIER_ACCT_TYPE_CD    =  :DU-TIER-ACCT-TYPE-CD  
      * MKT_TIER_APPLY_CD = 'A' (ALL ACCOUNTS CAN VIEW OFFER)                   
                  AND ( (:WS-CALL-TYPE           = 'WEB' AND            
                          (DU.MKT_TIER_RANKING           BETWEEN        
                           :WS-MIN-TIER-RANKING          AND            
                           :WS-MAX-TIER-RANKING)         AND            
                         DU.TIER_DEFLT_OFFR_CD   = 'Y')                 
                                      OR                                
                        (:WS-CALL-TYPE           = 'CRM' AND            
                          (DU.MKT_TIER_RANKING           BETWEEN        
                           :WS-MIN-TIER-RANKING          AND            
                           :WS-MAX-TIER-RANKING) )                      
                                      OR                                
                        (:WS-CALL-TYPE           = 'CRM' AND            
                         DU.MKT_TIER_APPLY_CD    = 'A'   AND            
P00453                   :WS-PRP-TIER-RANK-FL    = 'N' )                
                                      OR                                
P00269* PULL THE SECURED OFFER IRRESPECTIVE                                     
P00269* OF REQUESTED MKT TIER RANKING                                           
P00269                  ( EXISTS                                        
P00269                       ( SELECT OFFER_CD                          
P00269                           FROM CRM_ACCESS_OFF_OPT CI
                           WITH(READUNCOMMITTED)             
P00269                          WHERE CI.VIEW_APPLY_CD IN ('S','B')     
P00269                          AND CI.OFFER_CD   = DU.OFFER_CD         
P00473                          AND CI.ACCESS_VSTART_TS <=              
P1137C                                          CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473                          AND CI.ACCESS_VEND_TS   >=              
P1137C                                          CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473                          AND CI.PROC_STATUS_CD    = 'AC'         
P1137C                          AND CI.ACCESS_START_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) ) 
P1137C                          AND CI.ACCESS_END_DT  >= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )) 
P00269                    AND :WS-VIEW-APPLY-CD = 'S'                   
P00453                    AND :WS-PRP-TIER-RANK-FL = 'N' )              
P00269                )                                                 
P1137C            AND DU.MKT_TIER_START_DT    <=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
P1137C            AND DU.OFFER_TIER_STRT_DT   <=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
P1137C            AND DU.OFFER_TIER_END_DT    >=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
                  AND DU.COMPANY_NO           =  :DU-COMPANY-NO         
P1137C            AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P1137C            AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P00473            AND DU.PROC_STATUS_CD      = 'AC'                     
                  AND (  (  :WS-CALL-TYPE         = 'CRM'               
                             AND :WS-VIEW-APPLY-CD = 'S')               
                                     OR                                 
                            FG.PROMO_CD_INT_FL   <> 'Y'   )             
P1137C            AND FG.OFFER_START_DT       <=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
P1137C            AND FG.OFFER_END_DT         >=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
P1137C            AND CAST(FG.DISP_START_INT_TS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )       
P1137C            AND CAST(FG.DISP_END_INT_TS AS DATE)   >= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )       
P1137C             AND FG.OFF_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P1137C             AND FG.OFF_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473             AND FG.PROC_STATUS_CD      = 'AC'                    
               ORDER BY DU.MKT_TIER_RANKING,FG.OFFER_CD                 
                                                                 
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE TIERANK_RTPKOFF_INT CURSOR FOR                           
MFA-TR*          SELECT DU.MKT_TIER_RANKING                                     
MFA-TR*                ,DU.OFFER_TIER_END_DT                                    
MFA-TR*                ,DU.OFFER_TIER_STRT_DT                                   
MFA-TR*                ,DU.TIER_ACCT_TYPE_CD                                    
MFA-TR*                ,DU.TIER_CUST_STAT_CD                                    
MFA-TR*                ,DU.TIER_DEFLT_OFFR_CD                                   
MFA-TR*                ,FG.OFFER_CD                                             
MFA-TR*                ,FG.OFFER_DESC_INT                                       
MFA-TR*                ,FG.OFFER_DESC_INT_LNG                                   
MFA-TR*                ,FG.OFFER_END_DT                                         
MFA-TR*                ,FG.OFFER_START_DT                                       
MFA-TR*                ,FG.PROMO_CD_INT_FL                                      
MFA-TR*                ,FG.SPCL_OFFER_TYPE_CD                                   
MFA-TR*                ,FG.MAX_PRICE_OFFER_CD                                   
MFA-TR*                ,KM.PROMO_CD                                             
MFA-TR*                ,KM.EXT_LANDING_PG_URL                                   
MFA-TR*                ,KM.INT_LANDING_PG_URL                                   
MFA-TR*          FROM   CRM_OFF_MKT_TIER     DU  JOIN                           
MFA-TR*                 CRM_RT_PKG_OFFER     FG                                 
MFA-TR*            ON  (FG.OFFER_CD   =   DU.OFFER_CD                           
MFA-TR*           AND   FG.COMPANY_NO =   DU.COMPANY_NO)  LEFT JOIN             
MFA-TR*                 CRM_MKT_PROMOTION    KM                                 
MFA-TR*            ON  (:WS-CALL-TYPE        = 'CRM'                            
MFA-TR**********  AND   :WS-MKT-TIER-RANKING = 999                              
MFA-TR*           AND   KM.OFFER_CD          = FG.OFFER_CD                      
MFA-TR*           AND   KM.COMPANY_NO        = FG.COMPANY_NO                    
MFA-TR**********  AND   FG.PROMO_CD_INT_FL   = 'Y'                              
MFA-TR*           AND   KM.PROMO_START_DT    <= :WS-CURR-DATE                   
MFA-TR*           AND   KM.PROMO_END_DT      >= :WS-CURR-DATE                   
MFA-TR*           AND   KM.PROMO_VSTART_TS   <= :WS-CURR-TIMESTAMP              
MFA-TR*           AND   KM.PROMO_VEND_TS     >= :WS-CURR-TIMESTAMP              
MFA-TR*           AND   KM.PROC_STATUS_CD     = 'AC' )                          
MFA-TR*         WHERE DU.TIER_CUST_STAT_CD    =  :DU-TIER-CUST-STAT-CD          
MFA-TR*           AND DU.TIER_ACCT_TYPE_CD    =  :DU-TIER-ACCT-TYPE-CD          
MFA-TR* MKT_TIER_APPLY_CD = 'A' (ALL ACCOUNTS CAN VIEW OFFER)                   
MFA-TR*           AND ( (:WS-CALL-TYPE           = 'WEB' AND                    
MFA-TR*                   (DU.MKT_TIER_RANKING           BETWEEN                
MFA-TR*                    :WS-MIN-TIER-RANKING          AND                    
MFA-TR*                    :WS-MAX-TIER-RANKING)         AND                    
MFA-TR*                  DU.TIER_DEFLT_OFFR_CD   = 'Y')                         
MFA-TR*                               OR                                        
MFA-TR*                 (:WS-CALL-TYPE           = 'CRM' AND                    
MFA-TR*                   (DU.MKT_TIER_RANKING           BETWEEN                
MFA-TR*                    :WS-MIN-TIER-RANKING          AND                    
MFA-TR*                    :WS-MAX-TIER-RANKING) )                              
MFA-TR*                               OR                                        
MFA-TR*                 (:WS-CALL-TYPE           = 'CRM' AND                    
MFA-TR*                  DU.MKT_TIER_APPLY_CD    = 'A'   AND                    
MFA-TR*                  :WS-PRP-TIER-RANK-FL    = 'N' )                        
MFA-TR*                               OR                                        
MFA-TR* PULL THE SECURED OFFER IRRESPECTIVE                                     
MFA-TR* OF REQUESTED MKT TIER RANKING                                           
MFA-TR*                 ( EXISTS                                                
MFA-TR*                      ( SELECT OFFER_CD                                  
MFA-TR*                          FROM CRM_ACCESS_OFF_OPT CI                     
MFA-TR*                         WHERE CI.VIEW_APPLY_CD IN ('S','B')             
MFA-TR*                         AND CI.OFFER_CD   = DU.OFFER_CD                 
MFA-TR*                         AND CI.ACCESS_VSTART_TS <=                      
MFA-TR*                                         :WS-CURR-TIMESTAMP              
MFA-TR*                         AND CI.ACCESS_VEND_TS   >=                      
MFA-TR*                                         :WS-CURR-TIMESTAMP              
MFA-TR*                         AND CI.PROC_STATUS_CD    = 'AC'                 
MFA-TR*                         AND CI.ACCESS_START_DT <= :WS-CURR-DATE         
MFA-TR*                         AND CI.ACCESS_END_DT  >= :WS-CURR-DATE)         
MFA-TR*                   AND :WS-VIEW-APPLY-CD = 'S'                           
MFA-TR*                   AND :WS-PRP-TIER-RANK-FL = 'N' )                      
MFA-TR*               )                                                         
MFA-TR*           AND DU.MKT_TIER_START_DT    <=  :WS-CURR-DATE                 
MFA-TR*           AND DU.OFFER_TIER_STRT_DT   <=  :WS-CURR-DATE                 
MFA-TR*           AND DU.OFFER_TIER_END_DT    >=  :WS-CURR-DATE                 
MFA-TR*           AND DU.COMPANY_NO           =  :DU-COMPANY-NO                 
MFA-TR*           AND DU.OFF_TIER_VSTART_TS <= :WS-CURR-TIMESTAMP               
MFA-TR*           AND DU.OFF_TIER_VEND_TS   >= :WS-CURR-TIMESTAMP               
MFA-TR*           AND DU.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND (  (  :WS-CALL-TYPE         = 'CRM'                       
MFA-TR*                      AND :WS-VIEW-APPLY-CD = 'S')                       
MFA-TR*                              OR                                         
MFA-TR*                     FG.PROMO_CD_INT_FL   <> 'Y'   )                     
MFA-TR*           AND FG.OFFER_START_DT       <=  :WS-CURR-DATE                 
MFA-TR*           AND FG.OFFER_END_DT         >=  :WS-CURR-DATE                 
MFA-TR*           AND DATE(FG.DISP_START_INT_TS) <= :WS-CURR-DATE               
MFA-TR*           AND DATE(FG.DISP_END_INT_TS)   >= :WS-CURR-DATE               
MFA-TR*            AND FG.OFF_VSTART_TS      <= :WS-CURR-TIMESTAMP              
MFA-TR*            AND FG.OFF_VEND_TS        >= :WS-CURR-TIMESTAMP              
MFA-TR*            AND FG.PROC_STATUS_CD      = 'AC'                            
MFA-TR*        ORDER BY DU.MKT_TIER_RANKING,FG.OFFER_CD                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CURSOR DECLARATION TO FETCH OFFER DETAILS BASED ON          **        
      **  MIN & MAX MKT TIER RANKING. EXTERNAL DESC WILL BE FETCHED.  **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE TIERANK_RTPKOFF_EXT CURSOR FOR                   
                 SELECT DU.MKT_TIER_RANKING                             
                       ,DU.OFFER_TIER_END_DT                            
                       ,DU.OFFER_TIER_STRT_DT                           
                       ,DU.TIER_ACCT_TYPE_CD                            
                       ,DU.TIER_CUST_STAT_CD                            
                       ,DU.TIER_DEFLT_OFFR_CD                           
P00614                 ,IG.CUST_ACCT_DEFLT_FL                           
                       ,FG.OFFER_CD                                     
                       ,FG.OFFER_DESC_EXT                               
                       ,FG.OFFER_DESC_EXT_LNG                           
                       ,FG.OFFER_END_DT                                 
                       ,FG.OFFER_START_DT                               
                       ,FG.PROMO_CD_EXT_FL                              
                       ,FG.SPCL_OFFER_TYPE_CD                           
P680P2                 ,FG.MAX_PRICE_OFFER_CD                           
                       ,KM.PROMO_CD                                     
                       ,KM.EXT_LANDING_PG_URL                           
I01095                 ,KM.INT_LANDING_PG_URL                           
                 FROM   CRM_OFF_MKT_TIER     DU
                           WITH(READUNCOMMITTED)  JOIN                   
P00614                  CRM_MKT_TIER         IG WITH(READUNCOMMITTED)           
P00614             ON  (IG.COMPANY_NO        = DU.COMPANY_NO            
P00614            AND   IG.TIER_CUST_STAT_CD = DU.TIER_CUST_STAT_CD     
P00614            AND   IG.TIER_ACCT_TYPE_CD = DU.TIER_ACCT_TYPE_CD     
P00614            AND   IG.MKT_TIER_START_DT = DU.MKT_TIER_START_DT     
P00614            AND   IG.MKT_TIER_RANKING  = DU.MKT_TIER_RANKING) JOIN
                        CRM_RT_PKG_OFFER     FG WITH(READUNCOMMITTED)           
                   ON  (FG.OFFER_CD   =   DU.OFFER_CD                   
                  AND   FG.COMPANY_NO =   DU.COMPANY_NO)  LEFT JOIN     
                        CRM_MKT_PROMOTION    KM WITH(READUNCOMMITTED)           
P00614             ON  (:WS-CALL-TYPE        = 'ECS'                    
                  AND   KM.OFFER_CD          = FG.OFFER_CD              
                  AND   KM.COMPANY_NO        = FG.COMPANY_NO            
P1137C            AND   KM.PROMO_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P1137C            AND   KM.PROMO_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P00473            AND   KM.PROC_STATUS_CD    = 'AC'                     
P1137C            AND   KM.PROMO_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )           
P1137C            AND   KM.PROMO_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) ) )         
P00614          WHERE ( (:WS-CALL-TYPE        = 'WEB'                   
P00614            AND    DU.TIER_CUST_STAT_CD = :DU-TIER-CUST-STAT-CD   
P00614            AND    DU.TIER_ACCT_TYPE_CD = :DU-TIER-ACCT-TYPE-CD   
P00614            AND    DU.MKT_TIER_RANKING  BETWEEN                   
P00614                   :WS-MIN-TIER-RANKING AND :WS-MAX-TIER-RANKING  
P00614            AND    DU.TIER_DEFLT_OFFR_CD   = 'Y')                 
P00614                             OR                                   
P00614                  (:WS-CALL-TYPE         =  'ECS'                 
P00838            AND    DU.TIER_CUST_STAT_CD IN ('P','L','W')          
P00836            AND    DU.TIER_ACCT_TYPE_CD IN ('D','1','2','S'))     
P00836***         AND    (DU.TIER_DEFLT_OFFR_CD = 'Y' OR                        
P00836***                 IG.CUST_ACCT_DEFLT_FL = 'Y' OR                        
P00836***                 FG.PROMO_CD_EXT_FL    = 'Y' ))                        
P00614                )                                                 
P1137C            AND DU.MKT_TIER_START_DT    <=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
P1137C            AND DU.OFFER_TIER_STRT_DT   <=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
P1137C            AND DU.OFFER_TIER_END_DT    >=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
                  AND DU.COMPANY_NO           =  :DU-COMPANY-NO         
P1137C            AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P1137C            AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P00473            AND DU.PROC_STATUS_CD      = 'AC'                     
P1137C            AND FG.OFFER_START_DT       <=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
P1137C            AND FG.OFFER_END_DT         >=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
P1137C            AND CAST(FG.DISP_START_EXT_TS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )       
P1137C            AND CAST(FG.DISP_END_EXT_TS AS DATE)   >= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )       
P1137C            AND FG.OFF_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P1137C            AND FG.OFF_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P00473            AND FG.PROC_STATUS_CD      = 'AC'                     
P00614         ORDER BY DU.TIER_ACCT_TYPE_CD,DU.TIER_CUST_STAT_CD       
P00614                 ,DU.MKT_TIER_RANKING,FG.OFFER_CD                 
                                                                 
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE TIERANK_RTPKOFF_EXT CURSOR FOR                           
MFA-TR*          SELECT DU.MKT_TIER_RANKING                                     
MFA-TR*                ,DU.OFFER_TIER_END_DT                                    
MFA-TR*                ,DU.OFFER_TIER_STRT_DT                                   
MFA-TR*                ,DU.TIER_ACCT_TYPE_CD                                    
MFA-TR*                ,DU.TIER_CUST_STAT_CD                                    
MFA-TR*                ,DU.TIER_DEFLT_OFFR_CD                                   
MFA-TR*                ,IG.CUST_ACCT_DEFLT_FL                                   
MFA-TR*                ,FG.OFFER_CD                                             
MFA-TR*                ,FG.OFFER_DESC_EXT                                       
MFA-TR*                ,FG.OFFER_DESC_EXT_LNG                                   
MFA-TR*                ,FG.OFFER_END_DT                                         
MFA-TR*                ,FG.OFFER_START_DT                                       
MFA-TR*                ,FG.PROMO_CD_EXT_FL                                      
MFA-TR*                ,FG.SPCL_OFFER_TYPE_CD                                   
MFA-TR*                ,FG.MAX_PRICE_OFFER_CD                                   
MFA-TR*                ,KM.PROMO_CD                                             
MFA-TR*                ,KM.EXT_LANDING_PG_URL                                   
MFA-TR*                ,KM.INT_LANDING_PG_URL                                   
MFA-TR*          FROM   CRM_OFF_MKT_TIER     DU  JOIN                           
MFA-TR*                 CRM_MKT_TIER         IG                                 
MFA-TR*            ON  (IG.COMPANY_NO        = DU.COMPANY_NO                    
MFA-TR*           AND   IG.TIER_CUST_STAT_CD = DU.TIER_CUST_STAT_CD             
MFA-TR*           AND   IG.TIER_ACCT_TYPE_CD = DU.TIER_ACCT_TYPE_CD             
MFA-TR*           AND   IG.MKT_TIER_START_DT = DU.MKT_TIER_START_DT             
MFA-TR*           AND   IG.MKT_TIER_RANKING  = DU.MKT_TIER_RANKING) JOIN        
MFA-TR*                 CRM_RT_PKG_OFFER     FG                                 
MFA-TR*            ON  (FG.OFFER_CD   =   DU.OFFER_CD                           
MFA-TR*           AND   FG.COMPANY_NO =   DU.COMPANY_NO)  LEFT JOIN             
MFA-TR*                 CRM_MKT_PROMOTION    KM                                 
MFA-TR*            ON  (:WS-CALL-TYPE        = 'ECS'                            
MFA-TR*           AND   KM.OFFER_CD          = FG.OFFER_CD                      
MFA-TR*           AND   KM.COMPANY_NO        = FG.COMPANY_NO                    
MFA-TR*           AND   KM.PROMO_VSTART_TS  <= :WS-CURR-TIMESTAMP               
MFA-TR*           AND   KM.PROMO_VEND_TS    >= :WS-CURR-TIMESTAMP               
MFA-TR*           AND   KM.PROC_STATUS_CD    = 'AC'                             
MFA-TR*           AND   KM.PROMO_START_DT    <= :WS-CURR-DATE                   
MFA-TR*           AND   KM.PROMO_END_DT      >= :WS-CURR-DATE )                 
MFA-TR*         WHERE ( (:WS-CALL-TYPE        = 'WEB'                           
MFA-TR*           AND    DU.TIER_CUST_STAT_CD = :DU-TIER-CUST-STAT-CD           
MFA-TR*           AND    DU.TIER_ACCT_TYPE_CD = :DU-TIER-ACCT-TYPE-CD           
MFA-TR*           AND    DU.MKT_TIER_RANKING  BETWEEN                           
MFA-TR*                  :WS-MIN-TIER-RANKING AND :WS-MAX-TIER-RANKING          
MFA-TR*           AND    DU.TIER_DEFLT_OFFR_CD   = 'Y')                         
MFA-TR*                            OR                                           
MFA-TR*                 (:WS-CALL-TYPE         =  'ECS'                         
MFA-TR*           AND    DU.TIER_CUST_STAT_CD IN ('P','L','W')                  
MFA-TR*           AND    DU.TIER_ACCT_TYPE_CD IN ('D','1','2','S'))             
MFA-TR***         AND    (DU.TIER_DEFLT_OFFR_CD = 'Y' OR                        
MFA-TR***                 IG.CUST_ACCT_DEFLT_FL = 'Y' OR                        
MFA-TR***                 FG.PROMO_CD_EXT_FL    = 'Y' ))                        
MFA-TR*               )                                                         
MFA-TR*           AND DU.MKT_TIER_START_DT    <=  :WS-CURR-DATE                 
MFA-TR*           AND DU.OFFER_TIER_STRT_DT   <=  :WS-CURR-DATE                 
MFA-TR*           AND DU.OFFER_TIER_END_DT    >=  :WS-CURR-DATE                 
MFA-TR*           AND DU.COMPANY_NO           =  :DU-COMPANY-NO                 
MFA-TR*           AND DU.OFF_TIER_VSTART_TS <= :WS-CURR-TIMESTAMP               
MFA-TR*           AND DU.OFF_TIER_VEND_TS   >= :WS-CURR-TIMESTAMP               
MFA-TR*           AND DU.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND FG.OFFER_START_DT       <=  :WS-CURR-DATE                 
MFA-TR*           AND FG.OFFER_END_DT         >=  :WS-CURR-DATE                 
MFA-TR*           AND DATE(FG.DISP_START_EXT_TS) <= :WS-CURR-DATE               
MFA-TR*           AND DATE(FG.DISP_END_EXT_TS)   >= :WS-CURR-DATE               
MFA-TR*           AND FG.OFF_VSTART_TS      <= :WS-CURR-TIMESTAMP               
MFA-TR*           AND FG.OFF_VEND_TS        >= :WS-CURR-TIMESTAMP               
MFA-TR*           AND FG.PROC_STATUS_CD      = 'AC'                             
MFA-TR*        ORDER BY DU.TIER_ACCT_TYPE_CD,DU.TIER_CUST_STAT_CD               
MFA-TR*                ,DU.MKT_TIER_RANKING,FG.OFFER_CD                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CURSOR DECLARATION TO FETCH OFFER DETAILS BASED ON          **        
      **  PROMOTION CODE. INTERNAL DESC WILL BE FETCHED.              **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE PROMO_RTPKOFF_INT CURSOR FOR                     
                 SELECT FG.OFFER_CD                                     
                       ,FG.OFFER_DESC_INT                               
                       ,FG.OFFER_DESC_INT_LNG                           
                       ,FG.OFFER_END_DT                                 
                       ,FG.OFFER_START_DT                               
                       ,FG.PROMO_CD_INT_FL                              
                       ,FG.SPCL_OFFER_TYPE_CD                           
P680P2                 ,FG.MAX_PRICE_OFFER_CD                           
                       ,KM.EXT_LANDING_PG_URL                           
I01095                 ,KM.INT_LANDING_PG_URL                           
                FROM  CRM_MKT_PROMOTION    KM WITH(READUNCOMMITTED)             
                     ,CRM_RT_PKG_OFFER     FG WITH(READUNCOMMITTED)             
               WHERE  KM.PROMO_CD          =  :KM-PROMO-CD              
                 AND  KM.COMPANY_NO        =  :KM-COMPANY-NO            
P1137C           AND  KM.PROMO_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )             
P1137C           AND  KM.PROMO_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )             
                 AND  KM.OFFER_CD          =  FG.OFFER_CD               
                 AND  KM.COMPANY_NO        =  FG.COMPANY_NO             
P1137C           AND  KM.PROMO_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )         
P1137C           AND  KM.PROMO_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )         
P00473           AND  KM.PROC_STATUS_CD    = 'AC'                       
P1137C           AND  FG.OFFER_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )             
P1137C           AND  FG.OFFER_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )             
P1137C           AND  CAST(FG.DISP_START_INT_TS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )       
P1137C           AND  CAST(FG.DISP_END_INT_TS AS DATE)   >= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )       
P1137C           AND  FG.OFF_VSTART_TS           <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )  
P1137C           AND  FG.OFF_VEND_TS             >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )  
P00473           AND  FG.PROC_STATUS_CD           = 'AC'                
      * WE DON'T CHECK FG.PROMO_CD_INT_FL = 'Y'                                 
             ORDER BY FG.OFFER_CD                                       
                                                                 
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PROMO_RTPKOFF_INT CURSOR FOR                             
MFA-TR*          SELECT FG.OFFER_CD                                             
MFA-TR*                ,FG.OFFER_DESC_INT                                       
MFA-TR*                ,FG.OFFER_DESC_INT_LNG                                   
MFA-TR*                ,FG.OFFER_END_DT                                         
MFA-TR*                ,FG.OFFER_START_DT                                       
MFA-TR*                ,FG.PROMO_CD_INT_FL                                      
MFA-TR*                ,FG.SPCL_OFFER_TYPE_CD                                   
MFA-TR*                ,FG.MAX_PRICE_OFFER_CD                                   
MFA-TR*                ,KM.EXT_LANDING_PG_URL                                   
MFA-TR*                ,KM.INT_LANDING_PG_URL                                   
MFA-TR*         FROM  CRM_MKT_PROMOTION    KM                                   
MFA-TR*              ,CRM_RT_PKG_OFFER     FG                                   
MFA-TR*        WHERE  KM.PROMO_CD          =  :KM-PROMO-CD                      
MFA-TR*          AND  KM.COMPANY_NO        =  :KM-COMPANY-NO                    
MFA-TR*          AND  KM.PROMO_START_DT    <= :WS-CURR-DATE                     
MFA-TR*          AND  KM.PROMO_END_DT      >= :WS-CURR-DATE                     
MFA-TR*          AND  KM.OFFER_CD          =  FG.OFFER_CD                       
MFA-TR*          AND  KM.COMPANY_NO        =  FG.COMPANY_NO                     
MFA-TR*          AND  KM.PROMO_VSTART_TS  <= :WS-CURR-TIMESTAMP                 
MFA-TR*          AND  KM.PROMO_VEND_TS    >= :WS-CURR-TIMESTAMP                 
MFA-TR*          AND  KM.PROC_STATUS_CD    = 'AC'                               
MFA-TR*          AND  FG.OFFER_START_DT    <= :WS-CURR-DATE                     
MFA-TR*          AND  FG.OFFER_END_DT      >= :WS-CURR-DATE                     
MFA-TR*          AND  DATE(FG.DISP_START_INT_TS) <= :WS-CURR-DATE               
MFA-TR*          AND  DATE(FG.DISP_END_INT_TS)   >= :WS-CURR-DATE               
MFA-TR*          AND  FG.OFF_VSTART_TS           <= :WS-CURR-TIMESTAMP          
MFA-TR*          AND  FG.OFF_VEND_TS             >= :WS-CURR-TIMESTAMP          
MFA-TR*          AND  FG.PROC_STATUS_CD           = 'AC'                        
MFA-TR* WE DON'T CHECK FG.PROMO_CD_INT_FL = 'Y'                                 
MFA-TR*      ORDER BY FG.OFFER_CD                                               
MFA-TR*      WITH UR                                                            
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CURSOR DECLARATION TO FETCH OFFER DETAILS BASED ON          **        
      **  PROMOTION CODE. EXTERNAL DESC WILL BE FETCHED.              **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE PROMO_RTPKOFF_EXT CURSOR FOR                     
                 SELECT FG.OFFER_CD                                     
                       ,FG.OFFER_DESC_EXT                               
                       ,FG.OFFER_DESC_EXT_LNG                           
                       ,FG.OFFER_END_DT                                 
                       ,FG.OFFER_START_DT                               
                       ,FG.PROMO_CD_EXT_FL                              
                       ,FG.SPCL_OFFER_TYPE_CD                           
P680P2                 ,FG.MAX_PRICE_OFFER_CD                           
                       ,KM.EXT_LANDING_PG_URL                           
I01095                 ,KM.INT_LANDING_PG_URL                           
                FROM  CRM_MKT_PROMOTION    KM WITH(READUNCOMMITTED)             
                     ,CRM_RT_PKG_OFFER     FG WITH(READUNCOMMITTED)             
               WHERE  KM.PROMO_CD          =  :KM-PROMO-CD              
                 AND  KM.COMPANY_NO        =  :KM-COMPANY-NO            
P1137C           AND  KM.PROMO_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )             
P1137C           AND  KM.PROMO_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )             
                 AND  KM.OFFER_CD          =  FG.OFFER_CD               
                 AND  KM.COMPANY_NO        =  FG.COMPANY_NO             
P1137C           AND  KM.PROMO_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )         
P1137C           AND  KM.PROMO_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )         
P00473           AND  KM.PROC_STATUS_CD    = 'AC'                       
P1137C           AND  FG.OFFER_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )             
P1137C           AND  FG.OFFER_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )             
P1137C           AND  CAST(FG.DISP_START_EXT_TS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )       
P1137C           AND  CAST(FG.DISP_END_EXT_TS AS DATE)   >= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )       
P1137C           AND  FG.OFF_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P1137C           AND  FG.OFF_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P00473           AND  FG.PROC_STATUS_CD      = 'AC'                     
      * WE DON'T CHECK FG.PROMO_CD_EXT_FL = 'Y'                                 
             ORDER BY FG.OFFER_CD                                       
                                                                 
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PROMO_RTPKOFF_EXT CURSOR FOR                             
MFA-TR*          SELECT FG.OFFER_CD                                             
MFA-TR*                ,FG.OFFER_DESC_EXT                                       
MFA-TR*                ,FG.OFFER_DESC_EXT_LNG                                   
MFA-TR*                ,FG.OFFER_END_DT                                         
MFA-TR*                ,FG.OFFER_START_DT                                       
MFA-TR*                ,FG.PROMO_CD_EXT_FL                                      
MFA-TR*                ,FG.SPCL_OFFER_TYPE_CD                                   
MFA-TR*                ,FG.MAX_PRICE_OFFER_CD                                   
MFA-TR*                ,KM.EXT_LANDING_PG_URL                                   
MFA-TR*                ,KM.INT_LANDING_PG_URL                                   
MFA-TR*         FROM  CRM_MKT_PROMOTION    KM                                   
MFA-TR*              ,CRM_RT_PKG_OFFER     FG                                   
MFA-TR*        WHERE  KM.PROMO_CD          =  :KM-PROMO-CD                      
MFA-TR*          AND  KM.COMPANY_NO        =  :KM-COMPANY-NO                    
MFA-TR*          AND  KM.PROMO_START_DT    <= :WS-CURR-DATE                     
MFA-TR*          AND  KM.PROMO_END_DT      >= :WS-CURR-DATE                     
MFA-TR*          AND  KM.OFFER_CD          =  FG.OFFER_CD                       
MFA-TR*          AND  KM.COMPANY_NO        =  FG.COMPANY_NO                     
MFA-TR*          AND  KM.PROMO_VSTART_TS  <= :WS-CURR-TIMESTAMP                 
MFA-TR*          AND  KM.PROMO_VEND_TS    >= :WS-CURR-TIMESTAMP                 
MFA-TR*          AND  KM.PROC_STATUS_CD    = 'AC'                               
MFA-TR*          AND  FG.OFFER_START_DT    <= :WS-CURR-DATE                     
MFA-TR*          AND  FG.OFFER_END_DT      >= :WS-CURR-DATE                     
MFA-TR*          AND  DATE(FG.DISP_START_EXT_TS) <= :WS-CURR-DATE               
MFA-TR*          AND  DATE(FG.DISP_END_EXT_TS)   >= :WS-CURR-DATE               
MFA-TR*          AND  FG.OFF_VSTART_TS      <= :WS-CURR-TIMESTAMP               
MFA-TR*          AND  FG.OFF_VEND_TS        >= :WS-CURR-TIMESTAMP               
MFA-TR*          AND  FG.PROC_STATUS_CD      = 'AC'                             
MFA-TR* WE DON'T CHECK FG.PROMO_CD_EXT_FL = 'Y'                                 
MFA-TR*      ORDER BY FG.OFFER_CD                                               
MFA-TR*      WITH UR                                                            
MFA-TR*       QUERYNO 7450                                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  OPTIONS ASSCOCITED WITH THE GIVEN OFFER.                    **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE OPTION_DET CURSOR FOR                            
                  SELECT  FI.OPTION_CD                                  
                         ,FI.OPT_DESC_INT                               
                         ,FI.CODE_UTIL_TYPE                             
                         ,FI.RATE_PLAN_NO                               
                         ,FI.OPTION_START_DT                            
                         ,FI.OPTION_END_DT                              
                         ,FI.OPT_DESC_INT_LONG                          
                         ,FI.CURR_EXT_DESC_LONG                         
                         ,FI.WEB_DESC_LONG                              
I01095                   ,FI.OPT_CALC_TYPE_CD                           
I01095                   ,LTRIM(RTRIM(FI.WEB_MKT_DESC_LONG))                   
                         ,E9.OFFER_CD                                   
                         ,E9.OPTION_SORT_SEQ_NO                         
P00614                   ,E9.WEB_NEW_EXISTS_CD                          
P00614                   ,E9.WEB_SIGN_UP_FL                             
P614P2                   ,E9.OFF_OPT_EXCLUDE_CD                         
                         ,G5.SORT_SEQ_NO                                
                         ,G5.RATE_GROUP_CD                              
                         ,F7.RATE_GRP_DESC                              
                         ,F7.RATE_GRP_DESC_LONG                         
                         ,F7.RT_GRP_SORT_SEQ_NO                         
P00892                   ,FI.AUTO_RENEWAL_FL                            
                   FROM   CRM_RT_PKG_OPTION   FI
                           WITH(READUNCOMMITTED)     JOIN               
                          CRM_OFFER_OPTION    E9 WITH(READUNCOMMITTED)          
                     ON  ( FI.OPTION_CD  = E9.OPTION_CD                 
                    AND    FI.COMPANY_NO = E9.COMPANY_NO )  LEFT JOIN   
                          CRM_RATE_GRP_OFFER  G5 WITH(READUNCOMMITTED)          
                     ON  (:WS-CALL-TYPE = 'CRM'                         
                    AND   G5.OFFER_CD   = E9.OFFER_CD                   
                    AND   G5.COMPANY_NO = E9.COMPANY_NO                 
      * G5-RATE-GROUP-TYPE-CD = 'C' FOR 'CRM'                                   
                    AND   G5.RATE_GROUP_TYPE_CD = 'C'                   
P1137C              AND   G5.EFF_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )              
P1137C              AND   G5.GRP_OFF_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P1137C              AND   G5.GRP_OFF_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P00473              AND   G5.PROC_STATUS_CD      = 'AC'                 
P1137C              AND   G5.EFF_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )) LEFT JOIN   
                          CRM_RATE_GROUP      F7 WITH(READUNCOMMITTED)          
                     ON  (:WS-CALL-TYPE = 'CRM'                         
                    AND   F7.RATE_GROUP_TYPE_CD = G5.RATE_GROUP_TYPE_CD 
                    AND   F7.RATE_GROUP_CD      = G5.RATE_GROUP_CD      
                    AND   F7.COMPANY_NO         = G5.COMPANY_NO)        
                  WHERE E9.OFFER_CD         =  :E9-OFFER-CD             
                    AND FI.COMPANY_NO       =  :FI-COMPANY-NO           
P1137C              AND FI.OPTION_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )            
P1137C              AND FI.OPTION_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )            
P1137C              AND FI.OPT_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )     
P1137C              AND FI.OPT_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )     
P00473              AND FI.PROC_STATUS_CD      = 'AC'                   
P1137C              AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )          
P1137C              AND E9.OFFER_OPT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )          
P1137C              AND E9.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )     
P1137C              AND E9.OFF_OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )     
P00473              AND E9.PROC_STATUS_CD      = 'AC'                   
                ORDER BY E9.OPTION_SORT_SEQ_NO                          
               FOR READ ONLY                                    
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OPTION_DET CURSOR FOR                                    
MFA-TR*           SELECT  FI.OPTION_CD                                          
MFA-TR*                  ,FI.OPT_DESC_INT                                       
MFA-TR*                  ,FI.CODE_UTIL_TYPE                                     
MFA-TR*                  ,FI.RATE_PLAN_NO                                       
MFA-TR*                  ,FI.OPTION_START_DT                                    
MFA-TR*                  ,FI.OPTION_END_DT                                      
MFA-TR*                  ,FI.OPT_DESC_INT_LONG                                  
MFA-TR*                  ,FI.CURR_EXT_DESC_LONG                                 
MFA-TR*                  ,FI.WEB_DESC_LONG                                      
MFA-TR*                  ,FI.OPT_CALC_TYPE_CD                                   
MFA-TR*                  ,STRIP(FI.WEB_MKT_DESC_LONG)                           
MFA-TR*                  ,E9.OFFER_CD                                           
MFA-TR*                  ,E9.OPTION_SORT_SEQ_NO                                 
MFA-TR*                  ,E9.WEB_NEW_EXISTS_CD                                  
MFA-TR*                  ,E9.WEB_SIGN_UP_FL                                     
MFA-TR*                  ,E9.OFF_OPT_EXCLUDE_CD                                 
MFA-TR*                  ,G5.SORT_SEQ_NO                                        
MFA-TR*                  ,G5.RATE_GROUP_CD                                      
MFA-TR*                  ,F7.RATE_GRP_DESC                                      
MFA-TR*                  ,F7.RATE_GRP_DESC_LONG                                 
MFA-TR*                  ,F7.RT_GRP_SORT_SEQ_NO                                 
MFA-TR*                  ,FI.AUTO_RENEWAL_FL                                    
MFA-TR*            FROM   CRM_RT_PKG_OPTION   FI     JOIN                       
MFA-TR*                   CRM_OFFER_OPTION    E9                                
MFA-TR*              ON  ( FI.OPTION_CD  = E9.OPTION_CD                         
MFA-TR*             AND    FI.COMPANY_NO = E9.COMPANY_NO )  LEFT JOIN           
MFA-TR*                   CRM_RATE_GRP_OFFER  G5                                
MFA-TR*              ON  (:WS-CALL-TYPE = 'CRM'                                 
MFA-TR*             AND   G5.OFFER_CD   = E9.OFFER_CD                           
MFA-TR*             AND   G5.COMPANY_NO = E9.COMPANY_NO                         
MFA-TR* G5-RATE-GROUP-TYPE-CD = 'C' FOR 'CRM'                                   
MFA-TR*             AND   G5.RATE_GROUP_TYPE_CD = 'C'                           
MFA-TR*             AND   G5.EFF_START_DT <= :WS-CURR-DATE                      
MFA-TR*             AND   G5.GRP_OFF_VSTART_TS  <= :WS-CURR-TIMESTAMP           
MFA-TR*             AND   G5.GRP_OFF_VEND_TS    >= :WS-CURR-TIMESTAMP           
MFA-TR*             AND   G5.PROC_STATUS_CD      = 'AC'                         
MFA-TR*             AND   G5.EFF_END_DT   >= :WS-CURR-DATE) LEFT JOIN           
MFA-TR*                   CRM_RATE_GROUP      F7                                
MFA-TR*              ON  (:WS-CALL-TYPE = 'CRM'                                 
MFA-TR*             AND   F7.RATE_GROUP_TYPE_CD = G5.RATE_GROUP_TYPE_CD         
MFA-TR*             AND   F7.RATE_GROUP_CD      = G5.RATE_GROUP_CD              
MFA-TR*             AND   F7.COMPANY_NO         = G5.COMPANY_NO)                
MFA-TR*           WHERE E9.OFFER_CD         =  :E9-OFFER-CD                     
MFA-TR*             AND FI.COMPANY_NO       =  :FI-COMPANY-NO                   
MFA-TR*             AND FI.OPTION_START_DT  <= :WS-CURR-DATE                    
MFA-TR*             AND FI.OPTION_END_DT    >= :WS-CURR-DATE                    
MFA-TR*             AND FI.OPT_VSTART_TS      <= :WS-CURR-TIMESTAMP             
MFA-TR*             AND FI.OPT_VEND_TS        >= :WS-CURR-TIMESTAMP             
MFA-TR*             AND FI.PROC_STATUS_CD      = 'AC'                           
MFA-TR*             AND E9.OFFER_OPT_START_DT <= :WS-CURR-DATE                  
MFA-TR*             AND E9.OFFER_OPT_END_DT   >= :WS-CURR-DATE                  
MFA-TR*             AND E9.OFF_OPT_VSTART_TS  <= :WS-CURR-TIMESTAMP             
MFA-TR*             AND E9.OFF_OPT_VEND_TS    >= :WS-CURR-TIMESTAMP             
MFA-TR*             AND E9.PROC_STATUS_CD      = 'AC'                           
MFA-TR*         ORDER BY E9.OPTION_SORT_SEQ_NO                                  
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ATTRIBUTES ASSOCIATED WITH THE GIVEN OPTION.                **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE ATTR_DET CURSOR FOR                              
P00805          SELECT  G7.RT_ATTR_INCTV_TYPE                           
P00805                 ,G7.RT_ATTR_INCTV_DESC                           
P00805                 ,HQ.ATTR_INCTV_SEQ_NO                            
P00805                 ,HQ.DURATION_NO                                  
P00805                 ,HQ.ATTR_INCTV_VALUE                             
P00805                 ,HQ.ATTR_INCTV_VAL_TX                            
P00805                 ,COALESCE(SF.FACTOR_TEXT,'')                       
P00805                 ,COALESCE(SF.FACTOR_DESC,'')                       
P00805            FROM  CRM_OPT_ATTR_INCTV    HQ WITH(READUNCOMMITTED)          
P00805            JOIN  CRM_RT_ATTR_INCTV     G7 WITH(READUNCOMMITTED)          
P00805              ON (G7.RT_ATTR_INCTV_TYPE  = HQ.RT_ATTR_INCTV_TYPE  
P00805             AND  G7.COMPANY_NO          = HQ.COMPANY_NO          
P00805             AND  G7.SOURCE_CD          <> 'CV')                  
P00805       LEFT JOIN  CSS_SPCL_FCTR         SF WITH(READUNCOMMITTED)          
P00805              ON (SF.FACTOR_ID           = HQ.FACTOR_ID)          
P00805           WHERE  HQ.OPTION_CD           = :HQ-OPTION-CD          
P00805             AND  HQ.COMPANY_NO          = :HQ-COMPANY-NO         
P1137C             AND  HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )          
P1137C             AND  HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )          
P1137C             AND  HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )     
P1137C             AND  HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )     
P00805             AND  HQ.PROC_STATUS_CD      = 'AC'                   
P00805          FOR READ ONLY                                   
P00805                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ATTR_DET CURSOR FOR                                      
MFA-TR*         SELECT  G7.RT_ATTR_INCTV_TYPE                                   
MFA-TR*                ,G7.RT_ATTR_INCTV_DESC                                   
MFA-TR*                ,HQ.ATTR_INCTV_SEQ_NO                                    
MFA-TR*                ,HQ.DURATION_NO                                          
MFA-TR*                ,HQ.ATTR_INCTV_VALUE                                     
MFA-TR*                ,HQ.ATTR_INCTV_VAL_TX                                    
MFA-TR*                ,IFNULL(SF.FACTOR_TEXT,'')                               
MFA-TR*                ,IFNULL(SF.FACTOR_DESC,'')                               
MFA-TR*           FROM  CRM_OPT_ATTR_INCTV    HQ                                
MFA-TR*           JOIN  CRM_RT_ATTR_INCTV     G7                                
MFA-TR*             ON (G7.RT_ATTR_INCTV_TYPE  = HQ.RT_ATTR_INCTV_TYPE          
MFA-TR*            AND  G7.COMPANY_NO          = HQ.COMPANY_NO                  
MFA-TR*            AND  G7.SOURCE_CD          <> 'CV')                          
MFA-TR*      LEFT JOIN  CSS_SPCL_FCTR         SF                                
MFA-TR*             ON (SF.FACTOR_ID           = HQ.FACTOR_ID)                  
MFA-TR*          WHERE  HQ.OPTION_CD           = :HQ-OPTION-CD                  
MFA-TR*            AND  HQ.COMPANY_NO          = :HQ-COMPANY-NO                 
MFA-TR*            AND  HQ.ATTR_INCTV_STRT_DT <= :WS-CURR-DATE                  
MFA-TR*            AND  HQ.ATTR_INCTV_END_DT  >= :WS-CURR-DATE                  
MFA-TR*            AND  HQ.OPT_ATTR_VSTART_TS <= :WS-CURR-TIMESTAMP             
MFA-TR*            AND  HQ.OPT_ATTR_VEND_TS   >= :WS-CURR-TIMESTAMP             
MFA-TR*            AND  HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7830                                                    
MFA-TR*    END-EXEC.                                                            
A00775******************************************************************        
A00775**  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
A00775**  RATE FACTORS & SPECIAL FACTORS ACCOCIATED WITH ANY GIVEN    **        
A00775**  RATE PLAN & UTIL TYPE.                                      **        
A00775******************************************************************        
A00775*                                                                         
A00775     EXEC SQL                                                     
A00775       DECLARE RATE_SPCL_FCTR                                     
A00775               CURSOR WITH ROWSET POSITIONING FOR                 
A00775        SELECT SA.RATE_PLAN_NO                                    
A00775              ,SA.FACTOR_ID                                       
A00775              ,SF.FACTOR_TYPE                                     
A00775              ,SF.ADJUST_ELEMENT                                  
A00775              ,SA.FACTOR                                          
I01095              ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA.INT_DISP_START_TS, 121), ' ', '-'), ':', '.') 
           INT_DISP_START_TS                               
A00775         FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                 
A00775             ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)                 
A00775         WHERE SA.FACTOR_ID      = SF.FACTOR_ID                   
A00775           AND SA.CODE_UTIL_TYPE = 'G'                            
A04221           AND SA.CODE_STATUS    IN ('A', 'E')                    
A04221           AND SF.RT_ATTR_INCTV_TYPE > ' '                        
P1137C           AND SA.INT_DISP_START_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )         
P1137C           AND SA.INT_DISP_END_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )         
A04221           ORDER BY SA.RATE_PLAN_NO, SA.FACTOR_ID                 
A00775         FOR READ ONLY                                    
A04362                                                      
A00775     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE RATE_SPCL_FCTR                                             
MFA-TR*              CURSOR WITH ROWSET POSITIONING FOR                         
MFA-TR*       SELECT SA.RATE_PLAN_NO                                            
MFA-TR*             ,SA.FACTOR_ID                                               
MFA-TR*             ,SF.FACTOR_TYPE                                             
MFA-TR*             ,SF.ADJUST_ELEMENT                                          
MFA-TR*             ,SA.FACTOR                                                  
MFA-TR*             ,SA.INT_DISP_START_TS                                       
MFA-TR*        FROM CSS_SPCL_FCTR_APPL SA                                       
MFA-TR*            ,CSS_SPCL_FCTR      SF                                       
MFA-TR*        WHERE SA.FACTOR_ID      = SF.FACTOR_ID                           
MFA-TR*          AND SA.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*          AND SA.CODE_STATUS    IN ('A', 'E')                            
MFA-TR*          AND SF.RT_ATTR_INCTV_TYPE > ' '                                
MFA-TR*          AND SA.INT_DISP_START_TS <= :WS-CURR-TIMESTAMP                 
MFA-TR*          AND SA.INT_DISP_END_TS   >= :WS-CURR-TIMESTAMP                 
MFA-TR*          ORDER BY SA.RATE_PLAN_NO, SA.FACTOR_ID                         
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            
A00775******************************************************************        
A00775**  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
A00775**  INCENTIVE FACTOR IDS ASSOCIATED WITH THE GIVEN OPTION CD.   **        
A00775******************************************************************        
A00775*                                                                         
A00775     EXEC SQL                                                     
A00775         DECLARE ATTR_INCTV CURSOR FOR                            
A00775           SELECT  HQ.FACTOR_ID                                   
A00775                  ,HQ.ATTR_INCTV_VALUE                            
A00775                  ,HQ.PRIMRY_OPT_ATTR_FL                          
A00775                  ,HQ.DURATION_NO                                 
A00775                  ,HQ.RT_ATTR_INCTV_TYPE                          
A00775             FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)           
A00775            WHERE  HQ.OPTION_CD          = :HQ-OPTION-CD          
A00775              AND  HQ.COMPANY_NO         = :HQ-COMPANY-NO         
P1137C              AND  HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
P1137C              AND  HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )         
P1137C              AND  HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )    
P1137C              AND  HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )    
P00473              AND  HQ.PROC_STATUS_CD      = 'AC'                  
A00775           FOR READ ONLY                                  
A04362                                                      
A00775     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ATTR_INCTV CURSOR FOR                                    
MFA-TR*          SELECT  HQ.FACTOR_ID                                           
MFA-TR*                 ,HQ.ATTR_INCTV_VALUE                                    
MFA-TR*                 ,HQ.PRIMRY_OPT_ATTR_FL                                  
MFA-TR*                 ,HQ.DURATION_NO                                         
MFA-TR*                 ,HQ.RT_ATTR_INCTV_TYPE                                  
MFA-TR*            FROM  CRM_OPT_ATTR_INCTV  HQ                                 
MFA-TR*           WHERE  HQ.OPTION_CD          = :HQ-OPTION-CD                  
MFA-TR*             AND  HQ.COMPANY_NO         = :HQ-COMPANY-NO                 
MFA-TR*             AND  HQ.ATTR_INCTV_STRT_DT <= :WS-CURR-DATE                 
MFA-TR*             AND  HQ.ATTR_INCTV_END_DT  >= :WS-CURR-DATE                 
MFA-TR*             AND  HQ.OPT_ATTR_VSTART_TS <= :WS-CURR-TIMESTAMP            
MFA-TR*             AND  HQ.OPT_ATTR_VEND_TS   >= :WS-CURR-TIMESTAMP            
MFA-TR*             AND  HQ.PROC_STATUS_CD      = 'AC'                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*       QUERYNO 7750                                                      
MFA-TR*    END-EXEC.                                                            
P00269******************************************************************        
P00269**  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A OFFER    **        
P00269**  AND OPTION THAT ARE SECURED                                 **        
P00269******************************************************************        
P00269*                                                                         
P00269     EXEC SQL                                                     
P00269         DECLARE SEC_OFF_OPT_CUR CURSOR FOR                       
P00269         SELECT CI.OFFER_CD                                       
P00269               ,CI.OPTION_CD                                      
P00269               ,CI.VIEW_APPLY_CD                                  
P00269               ,(SELECT DISTINCT 'Y'                              
P00269                   FROM CSS_CATEGORY WITH(READUNCOMMITTED)                
P00269                  WHERE CATEGORY_ID = CI.CATEGORY_ID              
P00269                    AND USER_ID     = :F5-USER-ID ) ACCESS_FLAG   
P00269           FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)               
P1137C          WHERE CI.ACCESS_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )              
P1137C            AND CI.ACCESS_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )              
P00269            AND CI.COMPANY_NO        = :CI-COMPANY-NO             
P1137C            AND CI.ACCESS_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )         
P1137C            AND CI.ACCESS_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )         
P00473            AND CI.PROC_STATUS_CD    = 'AC'                       
P00269          ORDER BY                                                
P00269                CI.OFFER_CD                                       
P00269               ,CI.OPTION_CD                                      
P00269               ,CI.VIEW_APPLY_CD                                  
P00269               ,ACCESS_FLAG                                       
P00269         FOR READ ONLY                                    
A04362                                                      
P00269     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SEC_OFF_OPT_CUR CURSOR FOR                               
MFA-TR*        SELECT CI.OFFER_CD                                               
MFA-TR*              ,CI.OPTION_CD                                              
MFA-TR*              ,CI.VIEW_APPLY_CD                                          
MFA-TR*              ,(SELECT DISTINCT 'Y'                                      
MFA-TR*                  FROM CSS_CATEGORY                                      
MFA-TR*                 WHERE CATEGORY_ID = CI.CATEGORY_ID                      
MFA-TR*                   AND USER_ID     = :F5-USER-ID ) ACCESS_FLAG           
MFA-TR*          FROM CRM_ACCESS_OFF_OPT CI                                     
MFA-TR*         WHERE CI.ACCESS_START_DT  <= :WS-CURR-DATE                      
MFA-TR*           AND CI.ACCESS_END_DT    >= :WS-CURR-DATE                      
MFA-TR*           AND CI.COMPANY_NO        = :CI-COMPANY-NO                     
MFA-TR*           AND CI.ACCESS_VSTART_TS <= :WS-CURR-TIMESTAMP                 
MFA-TR*           AND CI.ACCESS_VEND_TS   >= :WS-CURR-TIMESTAMP                 
MFA-TR*           AND CI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*         ORDER BY                                                        
MFA-TR*               CI.OFFER_CD                                               
MFA-TR*              ,CI.OPTION_CD                                              
MFA-TR*              ,CI.VIEW_APPLY_CD                                          
MFA-TR*              ,ACCESS_FLAG                                               
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*       QUERYNO 7860                                                      
MFA-TR*    END-EXEC.                                                            
P00680******************************************************************        
P00680**  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING DISCOUNT   **        
P00680**  INCENTIVE FACTOR IDS ASSOCIATED WITH THE GIVEN OPTION CD.   **        
P00680******************************************************************        
P00680*                                                                         
P00680     EXEC SQL                                                     
P00680         DECLARE DISCOUNT_INCTV CURSOR FOR                        
P00680           SELECT  HQ.FACTOR_ID                                   
P00680                  ,HQ.RT_ATTR_INCTV_TYPE                          
P00680                  ,HQ.ATTR_INCTV_VALUE                            
P00680                  ,HQ.DURATION_NO                                 
P00680                  ,SF.FACTOR_TEXT                                 
P00680                  ,SF.FACTOR_DESC                                 
P00680             FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)           
P00680                  ,CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)           
P00680            WHERE  HQ.OPTION_CD            = :HQ-OPTION-CD        
P1137C              AND  HQ.ATTR_INCTV_STRT_DT  <= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
P1137C              AND  HQ.ATTR_INCTV_END_DT   >= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
P00680              AND  HQ.PROC_STATUS_CD       = 'AC'                 
P00680              AND  HQ.RT_ATTR_INCTV_TYPE  IN ('PRICE DISCOUNT',   
P00680                                                'CSC DISCOUNT')   
P00680              AND  SF.FACTOR_ID            =  HQ.FACTOR_ID        
P00680              AND  HQ.OPT_ATTR_VSTART_TS   =                      
P00680                                                                  
P00680                  (SELECT  MAX(H1.OPT_ATTR_VSTART_TS)             
P00680                     FROM  CRM_OPT_ATTR_INCTV H1
                           WITH(READUNCOMMITTED)                  
P00680                    WHERE  H1.OPTION_CD    = HQ.OPTION_CD         
P00680                      AND  H1.RT_ATTR_INCTV_TYPE                  
P00680                                           = HQ.RT_ATTR_INCTV_TYPE
P00680                      AND  H1.ATTR_INCTV_STRT_DT                  
P1137C                                          <= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
P00680                      AND  H1.ATTR_INCTV_END_DT                   
P1137C                                          >= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
P00680                      AND  H1.OPT_ATTR_VSTART_TS                  
P1137C                                          <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P00680                      AND  H1.OPT_ATTR_VEND_TS                    
P1137C                                          >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P00680                      AND  H1.PROC_STATUS_CD                      
P00680                                           = 'AC')                
P00680           FOR READ ONLY                                  
A04362                                                      
P00680     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE DISCOUNT_INCTV CURSOR FOR                                
MFA-TR*          SELECT  HQ.FACTOR_ID                                           
MFA-TR*                 ,HQ.RT_ATTR_INCTV_TYPE                                  
MFA-TR*                 ,HQ.ATTR_INCTV_VALUE                                    
MFA-TR*                 ,HQ.DURATION_NO                                         
MFA-TR*                 ,SF.FACTOR_TEXT                                         
MFA-TR*                 ,SF.FACTOR_DESC                                         
MFA-TR*            FROM  CRM_OPT_ATTR_INCTV  HQ                                 
MFA-TR*                 ,CSS_SPCL_FCTR       SF                                 
MFA-TR*           WHERE  HQ.OPTION_CD            = :HQ-OPTION-CD                
MFA-TR*             AND  HQ.ATTR_INCTV_STRT_DT  <= :WS-CURR-DATE                
MFA-TR*             AND  HQ.ATTR_INCTV_END_DT   >= :WS-CURR-DATE                
MFA-TR*             AND  HQ.PROC_STATUS_CD       = 'AC'                         
MFA-TR*             AND  HQ.RT_ATTR_INCTV_TYPE  IN ('PRICE DISCOUNT',           
MFA-TR*                                               'CSC DISCOUNT')           
MFA-TR*             AND  SF.FACTOR_ID            =  HQ.FACTOR_ID                
MFA-TR*             AND  HQ.OPT_ATTR_VSTART_TS   =                              
MFA-TR*                                                                         
MFA-TR*                 (SELECT  MAX(H1.OPT_ATTR_VSTART_TS)                     
MFA-TR*                    FROM  CRM_OPT_ATTR_INCTV H1                          
MFA-TR*                   WHERE  H1.OPTION_CD    = HQ.OPTION_CD                 
MFA-TR*                     AND  H1.RT_ATTR_INCTV_TYPE                          
MFA-TR*                                          = HQ.RT_ATTR_INCTV_TYPE        
MFA-TR*                     AND  H1.ATTR_INCTV_STRT_DT                          
MFA-TR*                                         <= :WS-CURR-DATE                
MFA-TR*                     AND  H1.ATTR_INCTV_END_DT                           
MFA-TR*                                         >= :WS-CURR-DATE                
MFA-TR*                     AND  H1.OPT_ATTR_VSTART_TS                          
MFA-TR*                                         <= :WS-CURR-TIMESTAMP           
MFA-TR*                     AND  H1.OPT_ATTR_VEND_TS                            
MFA-TR*                                         >= :WS-CURR-TIMESTAMP           
MFA-TR*                     AND  H1.PROC_STATUS_CD                              
MFA-TR*                                          = 'AC')                        
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*       QUERYNO 7940                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
P680P2******************************************************************        
P680P2**  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING FIXED PRICE**        
P680P2**  FOR OPTIONS ON THE MAX_PRICE_OFFER_CD.                      **        
P680P2******************************************************************        
P680P2*                                                                         
P680P2     EXEC SQL                                                     
P680P2         DECLARE MAX_OFFER_OPTIONS CURSOR FOR                     
P680P2           SELECT  E9.OPTION_CD                                   
P680P2                  ,HQ.FACTOR_ID                                   
P680P2                  ,HQ.DURATION_NO                                 
P680P2                  ,SA.FACTOR                                      
P680P2             FROM  CRM_OFFER_OPTION   E9 WITH(READUNCOMMITTED)            
P680P2                                                                  
P680P2             JOIN  CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)            
P680P2               ON  FI.OPTION_CD           =  E9.OPTION_CD         
P1137C              AND  FI.OPTION_START_DT    <=  
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
P1137C              AND  FI.OPTION_END_DT      >=  
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
P1137C              AND  FI.OPT_VSTART_TS      <=  CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P1137C              AND  FI.OPT_VEND_TS        >=  CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P680P2              AND  FI.PROC_STATUS_CD      = 'AC'                  
P680P2              AND  FI.OPT_CALC_TYPE_CD    = 'FP'                  
P680P2                                                                  
P680P2             JOIN  CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)            
P680P2               ON  HQ.OPTION_CD           =  FI.OPTION_CD         
P680P2              AND  HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'         
P1137C              AND  HQ.ATTR_INCTV_STRT_DT <=  
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
P1137C              AND  HQ.ATTR_INCTV_END_DT  >=  
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
P1137C              AND  HQ.OPT_ATTR_VSTART_TS <=  CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P1137C              AND  HQ.OPT_ATTR_VEND_TS   >=  CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P680P2              AND  HQ.PROC_STATUS_CD      = 'AC'                  
P680P2                                                                  
P680P2             JOIN  CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)            
P680P2               ON  SA.RATE_PLAN_NO        =  FI.RATE_PLAN_NO      
P680P2              AND  SA.FACTOR_ID           =  HQ.FACTOR_ID         
P1137C              AND  SA.INT_DISP_START_TS  <=  CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P1137C              AND  SA.INT_DISP_END_TS    >   CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P680P2              AND  SA.CODE_STATUS         = 'A'                   
P680P2                                                                  
P680P2            WHERE  E9.OFFER_CD            = :FG-MAX-PRICE-OFFER-CD
P680P2              AND  E9.OFFER_OPT_START_DT <=  
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
P1137C              AND  E9.OFFER_OPT_END_DT   >=  
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
P1137C              AND  E9.OFF_OPT_VSTART_TS  <=  CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P1137C              AND  E9.OFF_OPT_VEND_TS    >=  CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
P680P2              AND  E9.PROC_STATUS_CD      = 'AC'                  
P680P2           FOR READ ONLY                                  
P680P2                                                      
P680P2     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MAX_OFFER_OPTIONS CURSOR FOR                             
MFA-TR*          SELECT  E9.OPTION_CD                                           
MFA-TR*                 ,HQ.FACTOR_ID                                           
MFA-TR*                 ,HQ.DURATION_NO                                         
MFA-TR*                 ,SA.FACTOR                                              
MFA-TR*            FROM  CRM_OFFER_OPTION   E9                                  
MFA-TR*                                                                         
MFA-TR*            JOIN  CRM_RT_PKG_OPTION  FI                                  
MFA-TR*              ON  FI.OPTION_CD           =  E9.OPTION_CD                 
MFA-TR*             AND  FI.OPTION_START_DT    <=  :WS-CURR-DATE                
MFA-TR*             AND  FI.OPTION_END_DT      >=  :WS-CURR-DATE                
MFA-TR*             AND  FI.OPT_VSTART_TS      <=  :WS-CURR-TIMESTAMP           
MFA-TR*             AND  FI.OPT_VEND_TS        >=  :WS-CURR-TIMESTAMP           
MFA-TR*             AND  FI.PROC_STATUS_CD      = 'AC'                          
MFA-TR*             AND  FI.OPT_CALC_TYPE_CD    = 'FP'                          
MFA-TR*                                                                         
MFA-TR*            JOIN  CRM_OPT_ATTR_INCTV HQ                                  
MFA-TR*              ON  HQ.OPTION_CD           =  FI.OPTION_CD                 
MFA-TR*             AND  HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'                 
MFA-TR*             AND  HQ.ATTR_INCTV_STRT_DT <=  :WS-CURR-DATE                
MFA-TR*             AND  HQ.ATTR_INCTV_END_DT  >=  :WS-CURR-DATE                
MFA-TR*             AND  HQ.OPT_ATTR_VSTART_TS <=  :WS-CURR-TIMESTAMP           
MFA-TR*             AND  HQ.OPT_ATTR_VEND_TS   >=  :WS-CURR-TIMESTAMP           
MFA-TR*             AND  HQ.PROC_STATUS_CD      = 'AC'                          
MFA-TR*                                                                         
MFA-TR*            JOIN  CSS_SPCL_FCTR_APPL SA                                  
MFA-TR*              ON  SA.RATE_PLAN_NO        =  FI.RATE_PLAN_NO              
MFA-TR*             AND  SA.FACTOR_ID           =  HQ.FACTOR_ID                 
MFA-TR*             AND  SA.INT_DISP_START_TS  <=  :WS-CURR-TIMESTAMP           
MFA-TR*             AND  SA.INT_DISP_END_TS    >   :WS-CURR-TIMESTAMP           
MFA-TR*             AND  SA.CODE_STATUS         = 'A'                           
MFA-TR*                                                                         
MFA-TR*           WHERE  E9.OFFER_CD            = :FG-MAX-PRICE-OFFER-CD        
MFA-TR*             AND  E9.OFFER_OPT_START_DT <=  :WS-CURR-DATE                
MFA-TR*             AND  E9.OFFER_OPT_END_DT   >=  :WS-CURR-DATE                
MFA-TR*             AND  E9.OFF_OPT_VSTART_TS  <=  :WS-CURR-TIMESTAMP           
MFA-TR*             AND  E9.OFF_OPT_VEND_TS    >=  :WS-CURR-TIMESTAMP           
MFA-TR*             AND  E9.PROC_STATUS_CD      = 'AC'                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*       QUERYNO 7970                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
OTPOOL**Cursor to load transportation charge for all Rate Plans.                
OTPOOL     EXEC SQL                                                     
OTPOOL      DECLARE SPCL_FCTR_DDDC CURSOR WITH ROWSET POSITIONING FOR   
OTPOOL          SELECT DISTINCT(SA.RATE_PLAN_NO)                        
OTPOOL                ,SA.FACTOR                                        
OTPOOL            FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)              
OTPOOL                ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)              
OTPOOL           WHERE SA.CODE_UTIL_TYPE = 'G'                          
OTPOOL             AND SA.CODE_STATUS    = 'A'                          
OTPOOL             AND SA.FACTOR_ID      = SF.FACTOR_ID                 
OTPOOL             AND SF.SPCL_GROUP_CD  = 'DD'                         
P1137C             AND SA.DATE_TO       >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )                
OTPOOL             AND SA.DATE_FROM      =                              
OTPOOL                   (SELECT MAX(ZZ.DATE_FROM)                      
OTPOOL                      FROM CSS_SPCL_FCTR_APPL ZZ
                           WITH(READUNCOMMITTED)                  
OTPOOL                     WHERE ZZ.RATE_PLAN_NO   = SA.RATE_PLAN_NO    
OTPOOL                       AND ZZ.CODE_UTIL_TYPE = SA.CODE_UTIL_TYPE  
OTPOOL                       AND ZZ.FACTOR_ID      = SA.FACTOR_ID       
P1137C                       AND ZZ.DATE_TO       >= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) ))     
OTPOOL           ORDER BY SA.RATE_PLAN_NO                               
OTPOOL             FOR READ ONLY                                
OTPOOL                                                      
OTPOOL     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE SPCL_FCTR_DDDC CURSOR WITH ROWSET POSITIONING FOR           
MFA-TR*         SELECT DISTINCT(SA.RATE_PLAN_NO)                                
MFA-TR*               ,SA.FACTOR                                                
MFA-TR*           FROM CSS_SPCL_FCTR_APPL SA                                    
MFA-TR*               ,CSS_SPCL_FCTR      SF                                    
MFA-TR*          WHERE SA.CODE_UTIL_TYPE = 'G'                                  
MFA-TR*            AND SA.CODE_STATUS    = 'A'                                  
MFA-TR*            AND SA.FACTOR_ID      = SF.FACTOR_ID                         
MFA-TR*            AND SF.SPCL_GROUP_CD  = 'DD'                                 
MFA-TR*            AND SA.DATE_TO       >= :WS-CURR-DATE                        
MFA-TR*            AND SA.DATE_FROM      =                                      
MFA-TR*                  (SELECT MAX(ZZ.DATE_FROM)                              
MFA-TR*                     FROM CSS_SPCL_FCTR_APPL ZZ                          
MFA-TR*                    WHERE ZZ.RATE_PLAN_NO   = SA.RATE_PLAN_NO            
MFA-TR*                      AND ZZ.CODE_UTIL_TYPE = SA.CODE_UTIL_TYPE          
MFA-TR*                      AND ZZ.FACTOR_ID      = SA.FACTOR_ID               
MFA-TR*                      AND ZZ.DATE_TO       >= :WS-CURR-DATE)             
MFA-TR*          ORDER BY SA.RATE_PLAN_NO                                       
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7991                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01 I-CALL-TYPE           PIC  X(03).                             
       01 I-INT-EXT-DATA-FL     PIC  X(01).                             
       01 I-TIER-CUST-STAT-CODE PIC  X(01).                             
       01 I-TIER-ACCT-TYPE-CD   PIC  X(01).                             
       01 I-MKT-TIER-RANKING    PIC  S9(4) COMP SYNC.                   
       01 I-PROMO-CD            PIC  X(12).                             
       01 I-COMPANY-NO          PIC  X(02).                             
P00269 01 I-USER-ID             PIC  X(07).                             
P00269 01 I-VIEW-APPLY-CD       PIC  X(01).                             
      *                                                                         
       PROCEDURE DIVISION USING I-CALL-TYPE                             
                               ,I-INT-EXT-DATA-FL                       
                               ,I-TIER-CUST-STAT-CODE                   
                               ,I-TIER-ACCT-TYPE-CD                     
                               ,I-MKT-TIER-RANKING                      
                               ,I-PROMO-CD                              
                               ,I-COMPANY-NO                            
P00269                         ,I-USER-ID                               
P00269                         ,I-VIEW-APPLY-CD.                        

SCA006        SET DDC-IND TO 1.
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                 **        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                     **        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
                                                                        
A00775     PERFORM 1100-LOAD-RATE-SPCL-FCTR-DATA                        
A00775                                       THRU 1100-EXIT.            
OTPOOL     PERFORM 1125-LOAD-ALL-DDDC        THRU 1125-EXIT.            
                                                                        
P00269     PERFORM 1200-PROCESS-SECURE-OFF-OPT                          
P00269                                       THRU 1200-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT                                             **        
      *      DECLARE TEMPORARY TABLE                                  **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04005_R1'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04005_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04005_R1
              (                                                    
                       RETURN_CODE            INT                   
P00614                ,TIER_CUST_STAT_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
P00614                ,TIER_ACCT_TYPE_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
P00614                ,MKT_TIER_RANKING       SMALLINT                  
P00614                ,CUST_ACCT_DEFLT_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,OFFER_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,TIER_DEFLT_OFFR_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
P00614                ,PROMO_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,OPTION_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,OPTION_SORT_SEQ_NO     SMALLINT                  
P00614                ,WEB_NEW_EXISTS_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,WEB_SIGN_UP_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,OPT_TYPE_WEB CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,FLEX_OPT_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,RATE_DEFINITION_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,SENIOR_RATE_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,RATE_EFFECTIVE_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,RATE_EXPIRATION_DATE CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00614                ,THERM_PRICE            DECIMAL(11,6)             
P00614                ,CSC_AMT                DECIMAL(11,6)             
P00614                ,EXIT_FEE               DECIMAL(11,6)             
P00680                ,THERM_PRC_DSCNT_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,CSC_DSCNT_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,TOT_THERM_PRC_DSCNT    DECIMAL(11,6)             
P00680                ,TOT_CSC_DSCNT          DECIMAL(11,6)             
P00892                ,AUTO_RENEWAL_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00836                ,DURATION_NO            SMALLINT                  
I02262                ,CORE_RATE_PLAN_DDDC    DECIMAL(5,2)              
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04005_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                                                                        
A00775         DECLARE C1 CURSOR                             
A00775                 WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
P00614                ,TIER_CUST_STAT_CD                                
P00614                ,TIER_ACCT_TYPE_CD                                
P00614                ,MKT_TIER_RANKING                                 
P00614                ,CUST_ACCT_DEFLT_FL                               
P00614                ,OFFER_CD                                         
P00614                ,TIER_DEFLT_OFFR_CD                               
P00614                ,PROMO_CD                                         
P00614                ,OPTION_CD                                        
P00614                ,OPTION_SORT_SEQ_NO                               
P00614                ,WEB_NEW_EXISTS_CD                                
P00614                ,WEB_SIGN_UP_FL                                   
P00614                ,OPT_TYPE_WEB                                     
P00614                ,FLEX_OPT_FL                                      
P00614                ,RATE_DEFINITION_CD                               
P00614                ,SENIOR_RATE_FL                                   
P00614                ,RATE_EFFECTIVE_DT                                
P00614                ,RATE_EXPIRATION_DATE                             
P00614                ,THERM_PRICE                                      
P00614                ,CSC_AMT                                          
P00614                ,EXIT_FEE                                         
P00680                ,THERM_PRC_DSCNT_FL                               
P00680                ,CSC_DSCNT_FL                                     
P00680                ,TOT_THERM_PRC_DSCNT                              
P00680                ,TOT_CSC_DSCNT                                    
P00892                ,AUTO_RENEWAL_FL                                  
P00836                ,DURATION_NO                                      
I02262                ,CORE_RATE_PLAN_DDDC                              
               FROM #CSR04005_R1                                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,TIER_CUST_STAT_CD                                        
MFA-TR*               ,TIER_ACCT_TYPE_CD                                        
MFA-TR*               ,MKT_TIER_RANKING                                         
MFA-TR*               ,CUST_ACCT_DEFLT_FL                                       
MFA-TR*               ,OFFER_CD                                                 
MFA-TR*               ,TIER_DEFLT_OFFR_CD                                       
MFA-TR*               ,PROMO_CD                                                 
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,OPTION_SORT_SEQ_NO                                       
MFA-TR*               ,WEB_NEW_EXISTS_CD                                        
MFA-TR*               ,WEB_SIGN_UP_FL                                           
MFA-TR*               ,OPT_TYPE_WEB                                             
MFA-TR*               ,FLEX_OPT_FL                                              
MFA-TR*               ,RATE_DEFINITION_CD                                       
MFA-TR*               ,SENIOR_RATE_FL                                           
MFA-TR*               ,RATE_EFFECTIVE_DT                                        
MFA-TR*               ,RATE_EXPIRATION_DATE                                     
MFA-TR*               ,THERM_PRICE                                              
MFA-TR*               ,CSC_AMT                                                  
MFA-TR*               ,EXIT_FEE                                                 
MFA-TR*               ,THERM_PRC_DSCNT_FL                                       
MFA-TR*               ,CSC_DSCNT_FL                                             
MFA-TR*               ,TOT_THERM_PRC_DSCNT                                      
MFA-TR*               ,TOT_CSC_DSCNT                                            
MFA-TR*               ,AUTO_RENEWAL_FL                                          
MFA-TR*               ,DURATION_NO                                              
MFA-TR*               ,CORE_RATE_PLAN_DDDC                                      
MFA-TR*        FROM SESSION.CSR04005_R1                                         
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100B-DECLARE-GTT                                             **        
      *      DECLARE TEMPORARY TABLE                                  **        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT.                                               
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04005_R2'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04005_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04005_R2
              (                                                    
                       RETURN_CODE            INT                   
                      ,TIER_CUST_STAT_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,TIER_ACCT_TYPE_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,MKT_TIER_RANKING       SMALLINT                  
                      ,MKT_TIER_START_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,MKT_TIER_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,MKT_TIER_DESC CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TIER_OFFER_VIEW        SMALLINT                  
                      ,OFFER_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_TIER_STRT_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_TIER_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TIER_DEFLT_OFFR_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,OFFER_START_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_DESC_EXT CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,PROMO_CD_EXT_FL CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,SPCL_OFFER_TYPE_CD CHAR(2)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,OPTION_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CURR_EXT_DESC_LONG CHAR(255)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                      ,WEB_DESC_LONG CHAR(255)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                      ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,OPTION_START_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OPTION_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OPTION_SORT_SEQ_NO     SMALLINT                  
                      ,THERM_PRICE            DECIMAL(11,6)             
                      ,CSC_AMT                DECIMAL(11,6)             
                      ,PROMO_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
I01095                ,WEB_MKT_DESC_LONG VARCHAR(1024)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2             
I01095                ,RATE_EFFECTIVE_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
I01095                ,RATE_EXPIRATION_DATE CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
I01095                ,EXIT_FEE               DECIMAL(11,6)             
P00485                ,RATE_DEFINITION_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
P00544                ,OPT_CALC_TYPE_CD CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00544                ,OPT_TYPE_WEB CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,THERM_PRC_DSCNT_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,CSC_DSCNT_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,TOT_THERM_PRC_DSCNT    DECIMAL(11,6)             
P00680                ,TOT_CSC_DSCNT          DECIMAL(11,6)             
P00680                ,THERM_PRC_DSCNT_A_DESC CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,THERM_PRC_DSCNT_A_VAL  DECIMAL(11,6)             
P00680                ,THERM_PRC_DSCNT_A_DUR  SMALLINT                  
P00680                ,THERM_PRC_DSCNT_B_DESC CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,THERM_PRC_DSCNT_B_VAL  DECIMAL(11,6)             
P00680                ,THERM_PRC_DSCNT_B_DUR  SMALLINT                  
P00680                ,THERM_PRC_DSCNT_C_DESC CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,THERM_PRC_DSCNT_C_VAL  DECIMAL(11,6)             
P00680                ,THERM_PRC_DSCNT_C_DUR  SMALLINT                  
P00680                ,THERM_PRC_DSCNT_D_DESC CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,THERM_PRC_DSCNT_D_VAL  DECIMAL(11,6)             
P00680                ,THERM_PRC_DSCNT_D_DUR  SMALLINT                  
P00680                ,THERM_PRC_DSCNT_E_DESC CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,THERM_PRC_DSCNT_E_VAL  DECIMAL(11,6)             
P00680                ,THERM_PRC_DSCNT_E_DUR  SMALLINT                  
P00680                ,CSC_DSCNT_A_DESC CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,CSC_DSCNT_A_VAL        DECIMAL(11,6)             
P00680                ,CSC_DSCNT_A_DUR        SMALLINT                  
P00680                ,CSC_DSCNT_B_DESC CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,CSC_DSCNT_B_VAL        DECIMAL(11,6)             
P00680                ,CSC_DSCNT_B_DUR        SMALLINT                  
P00680                ,CSC_DSCNT_C_DESC CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,CSC_DSCNT_C_VAL        DECIMAL(11,6)             
P00680                ,CSC_DSCNT_C_DUR        SMALLINT                  
P00680                ,CSC_DSCNT_D_DESC CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,CSC_DSCNT_D_VAL        DECIMAL(11,6)             
P00680                ,CSC_DSCNT_D_DUR        SMALLINT                  
P00680                ,CSC_DSCNT_E_DESC CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,CSC_DSCNT_E_VAL        DECIMAL(11,6)             
P00680                ,CSC_DSCNT_E_DUR        SMALLINT                  
P00892                ,AUTO_RENEWAL_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00836                ,DURATION_NO            SMALLINT                  
I02262                ,CORE_RATE_PLAN_DDDC    DECIMAL(5,2)              
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04005_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                                                                        
A00775         DECLARE C2 CURSOR                             
A00775                 WITH ROWSET POSITIONING FOR                      
               SELECT   RETURN_CODE                                     
                      ,TIER_CUST_STAT_CD                                
                      ,TIER_ACCT_TYPE_CD                                
                      ,MKT_TIER_RANKING                                 
                      ,MKT_TIER_START_DT                                
                      ,MKT_TIER_END_DT                                  
                      ,MKT_TIER_DESC                                    
                      ,TIER_OFFER_VIEW                                  
                      ,OFFER_CD                                         
                      ,OFFER_TIER_STRT_DT                               
                      ,OFFER_TIER_END_DT                                
                      ,TIER_DEFLT_OFFR_CD                               
                      ,OFFER_START_DT                                   
                      ,OFFER_END_DT                                     
                      ,OFFER_DESC_EXT                                   
                      ,PROMO_CD_EXT_FL                                  
                      ,SPCL_OFFER_TYPE_CD                               
                      ,OPTION_CD                                        
                      ,CURR_EXT_DESC_LONG                               
                      ,WEB_DESC_LONG                                    
                      ,CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,OPTION_START_DT                                  
                      ,OPTION_END_DT                                    
                      ,OPTION_SORT_SEQ_NO                               
                      ,THERM_PRICE                                      
                      ,CSC_AMT                                          
                      ,PROMO_CD                                         
I01095                ,WEB_MKT_DESC_LONG                                
I01095                ,RATE_EFFECTIVE_DT                                
I01095                ,RATE_EXPIRATION_DATE                             
I01095                ,EXIT_FEE                                         
P00485                ,RATE_DEFINITION_CD                               
P00544                ,OPT_CALC_TYPE_CD                                 
P00544                ,OPT_TYPE_WEB                                     
P00680                ,THERM_PRC_DSCNT_FL                               
P00680                ,CSC_DSCNT_FL                                     
P00680                ,TOT_THERM_PRC_DSCNT                              
P00680                ,TOT_CSC_DSCNT                                    
P00680                ,THERM_PRC_DSCNT_A_DESC                           
P00680                ,THERM_PRC_DSCNT_A_VAL                            
P00680                ,THERM_PRC_DSCNT_A_DUR                            
P00680                ,THERM_PRC_DSCNT_B_DESC                           
P00680                ,THERM_PRC_DSCNT_B_VAL                            
P00680                ,THERM_PRC_DSCNT_B_DUR                            
P00680                ,THERM_PRC_DSCNT_C_DESC                           
P00680                ,THERM_PRC_DSCNT_C_VAL                            
P00680                ,THERM_PRC_DSCNT_C_DUR                            
P00680                ,THERM_PRC_DSCNT_D_DESC                           
P00680                ,THERM_PRC_DSCNT_D_VAL                            
P00680                ,THERM_PRC_DSCNT_D_DUR                            
P00680                ,THERM_PRC_DSCNT_E_DESC                           
P00680                ,THERM_PRC_DSCNT_E_VAL                            
P00680                ,THERM_PRC_DSCNT_E_DUR                            
P00680                ,CSC_DSCNT_A_DESC                                 
P00680                ,CSC_DSCNT_A_VAL                                  
P00680                ,CSC_DSCNT_A_DUR                                  
P00680                ,CSC_DSCNT_B_DESC                                 
P00680                ,CSC_DSCNT_B_VAL                                  
P00680                ,CSC_DSCNT_B_DUR                                  
P00680                ,CSC_DSCNT_C_DESC                                 
P00680                ,CSC_DSCNT_C_VAL                                  
P00680                ,CSC_DSCNT_C_DUR                                  
P00680                ,CSC_DSCNT_D_DESC                                 
P00680                ,CSC_DSCNT_D_VAL                                  
P00680                ,CSC_DSCNT_D_DUR                                  
P00680                ,CSC_DSCNT_E_DESC                                 
P00680                ,CSC_DSCNT_E_VAL                                  
P00680                ,CSC_DSCNT_E_DUR                                  
P00892                ,AUTO_RENEWAL_FL                                  
P00836                ,DURATION_NO                                      
I02262                ,CORE_RATE_PLAN_DDDC                              
               FROM #CSR04005_R2                                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT   RETURN_CODE                                             
MFA-TR*               ,TIER_CUST_STAT_CD                                        
MFA-TR*               ,TIER_ACCT_TYPE_CD                                        
MFA-TR*               ,MKT_TIER_RANKING                                         
MFA-TR*               ,MKT_TIER_START_DT                                        
MFA-TR*               ,MKT_TIER_END_DT                                          
MFA-TR*               ,MKT_TIER_DESC                                            
MFA-TR*               ,TIER_OFFER_VIEW                                          
MFA-TR*               ,OFFER_CD                                                 
MFA-TR*               ,OFFER_TIER_STRT_DT                                       
MFA-TR*               ,OFFER_TIER_END_DT                                        
MFA-TR*               ,TIER_DEFLT_OFFR_CD                                       
MFA-TR*               ,OFFER_START_DT                                           
MFA-TR*               ,OFFER_END_DT                                             
MFA-TR*               ,OFFER_DESC_EXT                                           
MFA-TR*               ,PROMO_CD_EXT_FL                                          
MFA-TR*               ,SPCL_OFFER_TYPE_CD                                       
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,CURR_EXT_DESC_LONG                                       
MFA-TR*               ,WEB_DESC_LONG                                            
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,OPTION_START_DT                                          
MFA-TR*               ,OPTION_END_DT                                            
MFA-TR*               ,OPTION_SORT_SEQ_NO                                       
MFA-TR*               ,THERM_PRICE                                              
MFA-TR*               ,CSC_AMT                                                  
MFA-TR*               ,PROMO_CD                                                 
MFA-TR*               ,WEB_MKT_DESC_LONG                                        
MFA-TR*               ,RATE_EFFECTIVE_DT                                        
MFA-TR*               ,RATE_EXPIRATION_DATE                                     
MFA-TR*               ,EXIT_FEE                                                 
MFA-TR*               ,RATE_DEFINITION_CD                                       
MFA-TR*               ,OPT_CALC_TYPE_CD                                         
MFA-TR*               ,OPT_TYPE_WEB                                             
MFA-TR*               ,THERM_PRC_DSCNT_FL                                       
MFA-TR*               ,CSC_DSCNT_FL                                             
MFA-TR*               ,TOT_THERM_PRC_DSCNT                                      
MFA-TR*               ,TOT_CSC_DSCNT                                            
MFA-TR*               ,THERM_PRC_DSCNT_A_DESC                                   
MFA-TR*               ,THERM_PRC_DSCNT_A_VAL                                    
MFA-TR*               ,THERM_PRC_DSCNT_A_DUR                                    
MFA-TR*               ,THERM_PRC_DSCNT_B_DESC                                   
MFA-TR*               ,THERM_PRC_DSCNT_B_VAL                                    
MFA-TR*               ,THERM_PRC_DSCNT_B_DUR                                    
MFA-TR*               ,THERM_PRC_DSCNT_C_DESC                                   
MFA-TR*               ,THERM_PRC_DSCNT_C_VAL                                    
MFA-TR*               ,THERM_PRC_DSCNT_C_DUR                                    
MFA-TR*               ,THERM_PRC_DSCNT_D_DESC                                   
MFA-TR*               ,THERM_PRC_DSCNT_D_VAL                                    
MFA-TR*               ,THERM_PRC_DSCNT_D_DUR                                    
MFA-TR*               ,THERM_PRC_DSCNT_E_DESC                                   
MFA-TR*               ,THERM_PRC_DSCNT_E_VAL                                    
MFA-TR*               ,THERM_PRC_DSCNT_E_DUR                                    
MFA-TR*               ,CSC_DSCNT_A_DESC                                         
MFA-TR*               ,CSC_DSCNT_A_VAL                                          
MFA-TR*               ,CSC_DSCNT_A_DUR                                          
MFA-TR*               ,CSC_DSCNT_B_DESC                                         
MFA-TR*               ,CSC_DSCNT_B_VAL                                          
MFA-TR*               ,CSC_DSCNT_B_DUR                                          
MFA-TR*               ,CSC_DSCNT_C_DESC                                         
MFA-TR*               ,CSC_DSCNT_C_VAL                                          
MFA-TR*               ,CSC_DSCNT_C_DUR                                          
MFA-TR*               ,CSC_DSCNT_D_DESC                                         
MFA-TR*               ,CSC_DSCNT_D_VAL                                          
MFA-TR*               ,CSC_DSCNT_D_DUR                                          
MFA-TR*               ,CSC_DSCNT_E_DESC                                         
MFA-TR*               ,CSC_DSCNT_E_VAL                                          
MFA-TR*               ,CSC_DSCNT_E_DUR                                          
MFA-TR*               ,AUTO_RENEWAL_FL                                          
MFA-TR*               ,DURATION_NO                                              
MFA-TR*               ,CORE_RATE_PLAN_DDDC                                      
MFA-TR*        FROM SESSION.CSR04005_R2                                         
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100C-DECLARE-GTT                                             **        
      *      DECLARE TEMPORARY TABLE                                  **        
      ******************************************************************        
      *                                                                         
       0100C-DECLARE-GTT.                                               
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04005_R3'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04005_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04005_R3
              (                                                    
                       RETURN_CODE            INT                   
                      ,TIER_CUST_STAT_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,TIER_ACCT_TYPE_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,MKT_TIER_RANKING       SMALLINT                  
                      ,MKT_TIER_START_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,MKT_TIER_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,MKT_TIER_DESC CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TIER_OFFER_VIEW        SMALLINT                  
                      ,OFFER_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_TIER_STRT_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_TIER_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TIER_DEFLT_OFFR_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,OFFER_START_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_DESC_INT CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,PROMO_CD_INT_FL CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,SPCL_OFFER_TYPE_CD CHAR(2)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,OPTION_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OPT_DESC_INT CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OPT_DESC_INT_LONG CHAR(255)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                      ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,OPTION_START_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OPTION_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OPTION_SORT_SEQ_NO     SMALLINT                  
                      ,THERM_PRICE            DECIMAL(11,6)             
                      ,CSC_AMT                DECIMAL(11,6)             
                      ,RT_ATTR_INCTV_TYPE CHAR(15)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,RT_ATTR_INCTV_DESC CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,ATTR_INCTV_SEQ_NO      SMALLINT                  
                      ,DURATION_NO            SMALLINT                  
                      ,ATTR_INCTV_VALUE       DECIMAL(11,6)             
                      ,ATTR_INCTV_VAL_TX CHAR(20)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,RATE_GRP_DESC CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,RATE_GRP_DESC_LONG CHAR(255)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                      ,RT_GRP_SORT_SEQ_NO     SMALLINT                  
                      ,SORT_SEQ_NO            SMALLINT                  
                      ,PROMO_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,EXT_LANDING_PG_URL CHAR(255)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                      ,INCTV_ENABLE_FLAG CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
I01095                ,INT_LANDING_PG_URL CHAR(255)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
P00680                ,OPT_CALC_TYPE_CD CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,THERM_PRC_DSCNT_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,CSC_DSCNT_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,TOT_THERM_PRC_DSCNT    DECIMAL(11,6)             
P00680                ,TOT_CSC_DSCNT          DECIMAL(11,6)             
P00680                ,DSCNTD_THERM_PRC_CRM   DECIMAL(11,6)             
P00680                ,DSCNTD_CSC_CRM         DECIMAL(11,6)             
NEW680                ,FCTR_LONG_DESC_CRM CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P680P2                ,MAX_OFFER_OPT_PRICE    DECIMAL(11,6)             
P680P2                ,PRICE_NEGOTIATION_PARM DECIMAL(11,6)             
P00892                ,AUTO_RENEWAL_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
OTPOOL                ,RATE_DEFINITION_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
OTPOOL                ,CORE_RATE_PLAN_DDDC    DECIMAL(5,2)              
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04005_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                                                                        
A00775         DECLARE C3 CURSOR                             
A00775                 WITH ROWSET POSITIONING FOR                      
               SELECT   RETURN_CODE                                     
                      ,TIER_CUST_STAT_CD                                
                      ,TIER_ACCT_TYPE_CD                                
                      ,MKT_TIER_RANKING                                 
                      ,MKT_TIER_START_DT                                
                      ,MKT_TIER_END_DT                                  
                      ,MKT_TIER_DESC                                    
                      ,TIER_OFFER_VIEW                                  
                      ,OFFER_CD                                         
                      ,OFFER_TIER_STRT_DT                               
                      ,OFFER_TIER_END_DT                                
                      ,TIER_DEFLT_OFFR_CD                               
                      ,OFFER_START_DT                                   
                      ,OFFER_END_DT                                     
                      ,OFFER_DESC_INT                                   
                      ,PROMO_CD_INT_FL                                  
                      ,SPCL_OFFER_TYPE_CD                               
                      ,OPTION_CD                                        
                      ,OPT_DESC_INT                                     
                      ,OPT_DESC_INT_LONG                                
                      ,CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,OPTION_START_DT                                  
                      ,OPTION_END_DT                                    
                      ,OPTION_SORT_SEQ_NO                               
                      ,THERM_PRICE                                      
                      ,CSC_AMT                                          
                      ,RT_ATTR_INCTV_TYPE                               
                      ,RT_ATTR_INCTV_DESC                               
                      ,ATTR_INCTV_SEQ_NO                                
                      ,DURATION_NO                                      
                      ,ATTR_INCTV_VALUE                                 
                      ,ATTR_INCTV_VAL_TX                                
                      ,RATE_GRP_DESC                                    
                      ,RATE_GRP_DESC_LONG                               
                      ,RT_GRP_SORT_SEQ_NO                               
                      ,SORT_SEQ_NO                                      
                      ,PROMO_CD                                         
                      ,EXT_LANDING_PG_URL                               
                      ,INCTV_ENABLE_FLAG                                
I01095                ,INT_LANDING_PG_URL                               
P00680                ,OPT_CALC_TYPE_CD                                 
P00680                ,THERM_PRC_DSCNT_FL                               
P00680                ,CSC_DSCNT_FL                                     
P00680                ,TOT_THERM_PRC_DSCNT                              
P00680                ,TOT_CSC_DSCNT                                    
P00680                ,DSCNTD_THERM_PRC_CRM                             
P00680                ,DSCNTD_CSC_CRM                                   
NEW680                ,FCTR_LONG_DESC_CRM                               
P680P2                ,MAX_OFFER_OPT_PRICE                              
P680P2                ,PRICE_NEGOTIATION_PARM                           
P00892                ,AUTO_RENEWAL_FL                                  
OTPOOL                ,RATE_DEFINITION_CD                               
OTPOOL                ,CORE_RATE_PLAN_DDDC                              
               FROM #CSR04005_R3                                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT   RETURN_CODE                                             
MFA-TR*               ,TIER_CUST_STAT_CD                                        
MFA-TR*               ,TIER_ACCT_TYPE_CD                                        
MFA-TR*               ,MKT_TIER_RANKING                                         
MFA-TR*               ,MKT_TIER_START_DT                                        
MFA-TR*               ,MKT_TIER_END_DT                                          
MFA-TR*               ,MKT_TIER_DESC                                            
MFA-TR*               ,TIER_OFFER_VIEW                                          
MFA-TR*               ,OFFER_CD                                                 
MFA-TR*               ,OFFER_TIER_STRT_DT                                       
MFA-TR*               ,OFFER_TIER_END_DT                                        
MFA-TR*               ,TIER_DEFLT_OFFR_CD                                       
MFA-TR*               ,OFFER_START_DT                                           
MFA-TR*               ,OFFER_END_DT                                             
MFA-TR*               ,OFFER_DESC_INT                                           
MFA-TR*               ,PROMO_CD_INT_FL                                          
MFA-TR*               ,SPCL_OFFER_TYPE_CD                                       
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,OPT_DESC_INT                                             
MFA-TR*               ,OPT_DESC_INT_LONG                                        
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,OPTION_START_DT                                          
MFA-TR*               ,OPTION_END_DT                                            
MFA-TR*               ,OPTION_SORT_SEQ_NO                                       
MFA-TR*               ,THERM_PRICE                                              
MFA-TR*               ,CSC_AMT                                                  
MFA-TR*               ,RT_ATTR_INCTV_TYPE                                       
MFA-TR*               ,RT_ATTR_INCTV_DESC                                       
MFA-TR*               ,ATTR_INCTV_SEQ_NO                                        
MFA-TR*               ,DURATION_NO                                              
MFA-TR*               ,ATTR_INCTV_VALUE                                         
MFA-TR*               ,ATTR_INCTV_VAL_TX                                        
MFA-TR*               ,RATE_GRP_DESC                                            
MFA-TR*               ,RATE_GRP_DESC_LONG                                       
MFA-TR*               ,RT_GRP_SORT_SEQ_NO                                       
MFA-TR*               ,SORT_SEQ_NO                                              
MFA-TR*               ,PROMO_CD                                                 
MFA-TR*               ,EXT_LANDING_PG_URL                                       
MFA-TR*               ,INCTV_ENABLE_FLAG                                        
MFA-TR*               ,INT_LANDING_PG_URL                                       
MFA-TR*               ,OPT_CALC_TYPE_CD                                         
MFA-TR*               ,THERM_PRC_DSCNT_FL                                       
MFA-TR*               ,CSC_DSCNT_FL                                             
MFA-TR*               ,TOT_THERM_PRC_DSCNT                                      
MFA-TR*               ,TOT_CSC_DSCNT                                            
MFA-TR*               ,DSCNTD_THERM_PRC_CRM                                     
MFA-TR*               ,DSCNTD_CSC_CRM                                           
MFA-TR*               ,FCTR_LONG_DESC_CRM                                       
MFA-TR*               ,MAX_OFFER_OPT_PRICE                                      
MFA-TR*               ,PRICE_NEGOTIATION_PARM                                   
MFA-TR*               ,AUTO_RENEWAL_FL                                          
MFA-TR*               ,RATE_DEFINITION_CD                                       
MFA-TR*               ,CORE_RATE_PLAN_DDDC                                      
MFA-TR*        FROM SESSION.CSR04005_R3                                         
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100D-DECLARE-GTT                                             **        
      *      DECLARE TEMPORARY TABLE                                  **        
      ******************************************************************        
      *                                                                         
       0100D-DECLARE-GTT.                                               
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04005_R4'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04005_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04005_R4
              (                                                    
                       RETURN_CODE            INT                   
                      ,TIER_CUST_STAT_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,TIER_ACCT_TYPE_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,MKT_TIER_RANKING       SMALLINT                  
                      ,MKT_TIER_START_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,MKT_TIER_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,MKT_TIER_DESC CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TIER_OFFER_VIEW        SMALLINT                  
                      ,OFFER_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_TIER_STRT_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_TIER_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TIER_DEFLT_OFFR_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,OFFER_START_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OFFER_DESC_EXT CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,PROMO_CD_EXT_FL CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,SPCL_OFFER_TYPE_CD CHAR(2)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,OPTION_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CURR_EXT_DESC_LONG CHAR(255)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                      ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                      ,OPTION_START_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OPTION_END_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,OPTION_SORT_SEQ_NO     SMALLINT                  
                      ,THERM_PRICE            DECIMAL(11,6)             
                      ,CSC_AMT                DECIMAL(11,6)             
                      ,RT_ATTR_INCTV_TYPE CHAR(15)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,RT_ATTR_INCTV_DESC CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,ATTR_INCTV_SEQ_NO      SMALLINT                  
                      ,DURATION_NO            SMALLINT                  
                      ,ATTR_INCTV_VALUE       DECIMAL(11,6)             
                      ,ATTR_INCTV_VAL_TX CHAR(20)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,RATE_GRP_DESC CHAR(50)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,RATE_GRP_DESC_LONG CHAR(255)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                      ,RT_GRP_SORT_SEQ_NO     SMALLINT                  
                      ,SORT_SEQ_NO            SMALLINT                  
                      ,PROMO_CD CHAR(12)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,EXT_LANDING_PG_URL CHAR(255)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                      ,INCTV_ENABLE_FLAG CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
I01095                ,INT_LANDING_PG_URL CHAR(255)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
P00680                ,OPT_CALC_TYPE_CD CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,THERM_PRC_DSCNT_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,CSC_DSCNT_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P00680                ,TOT_THERM_PRC_DSCNT    DECIMAL(11,6)             
P00680                ,TOT_CSC_DSCNT          DECIMAL(11,6)             
P00680                ,DSCNTD_THERM_PRC_CRM   DECIMAL(11,6)             
P00680                ,DSCNTD_CSC_CRM         DECIMAL(11,6)             
NEW680                ,FCTR_LONG_DESC_CRM CHAR(60)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
P680P2                ,MAX_OFFER_OPT_PRICE    DECIMAL(11,6)             
P680P2                ,PRICE_NEGOTIATION_PARM DECIMAL(11,6)             
P00892                ,AUTO_RENEWAL_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
OTPOOL                ,RATE_DEFINITION_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
OTPOOL                ,CORE_RATE_PLAN_DDDC    DECIMAL(5,2)              
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04005_R4'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                                                                        
A00775         DECLARE C4 CURSOR                             
A00775                 WITH ROWSET POSITIONING FOR                      
               SELECT   RETURN_CODE                                     
                      ,TIER_CUST_STAT_CD                                
                      ,TIER_ACCT_TYPE_CD                                
                      ,MKT_TIER_RANKING                                 
                      ,MKT_TIER_START_DT                                
                      ,MKT_TIER_END_DT                                  
                      ,MKT_TIER_DESC                                    
                      ,TIER_OFFER_VIEW                                  
                      ,OFFER_CD                                         
                      ,OFFER_TIER_STRT_DT                               
                      ,OFFER_TIER_END_DT                                
                      ,TIER_DEFLT_OFFR_CD                               
                      ,OFFER_START_DT                                   
                      ,OFFER_END_DT                                     
                      ,OFFER_DESC_EXT                                   
                      ,PROMO_CD_EXT_FL                                  
                      ,SPCL_OFFER_TYPE_CD                               
                      ,OPTION_CD                                        
                      ,CURR_EXT_DESC_LONG                               
                      ,CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,OPTION_START_DT                                  
                      ,OPTION_END_DT                                    
                      ,OPTION_SORT_SEQ_NO                               
                      ,THERM_PRICE                                      
                      ,CSC_AMT                                          
                      ,RT_ATTR_INCTV_TYPE                               
                      ,RT_ATTR_INCTV_DESC                               
                      ,ATTR_INCTV_SEQ_NO                                
                      ,DURATION_NO                                      
                      ,ATTR_INCTV_VALUE                                 
                      ,ATTR_INCTV_VAL_TX                                
                      ,RATE_GRP_DESC                                    
                      ,RATE_GRP_DESC_LONG                               
                      ,RT_GRP_SORT_SEQ_NO                               
                      ,SORT_SEQ_NO                                      
                      ,PROMO_CD                                         
                      ,EXT_LANDING_PG_URL                               
                      ,INCTV_ENABLE_FLAG                                
I01095                ,INT_LANDING_PG_URL                               
P00544                ,OPT_CALC_TYPE_CD                                 
P00680                ,THERM_PRC_DSCNT_FL                               
P00680                ,CSC_DSCNT_FL                                     
P00680                ,TOT_THERM_PRC_DSCNT                              
P00680                ,TOT_CSC_DSCNT                                    
P00680                ,DSCNTD_THERM_PRC_CRM                             
P00680                ,DSCNTD_CSC_CRM                                   
NEW680                ,FCTR_LONG_DESC_CRM                               
P680P2                ,MAX_OFFER_OPT_PRICE                              
P680P2                ,PRICE_NEGOTIATION_PARM                           
P00892                ,AUTO_RENEWAL_FL                                  
OTPOOL                ,RATE_DEFINITION_CD                               
OTPOOL                ,CORE_RATE_PLAN_DDDC                              
               FROM #CSR04005_R4                                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT   RETURN_CODE                                             
MFA-TR*               ,TIER_CUST_STAT_CD                                        
MFA-TR*               ,TIER_ACCT_TYPE_CD                                        
MFA-TR*               ,MKT_TIER_RANKING                                         
MFA-TR*               ,MKT_TIER_START_DT                                        
MFA-TR*               ,MKT_TIER_END_DT                                          
MFA-TR*               ,MKT_TIER_DESC                                            
MFA-TR*               ,TIER_OFFER_VIEW                                          
MFA-TR*               ,OFFER_CD                                                 
MFA-TR*               ,OFFER_TIER_STRT_DT                                       
MFA-TR*               ,OFFER_TIER_END_DT                                        
MFA-TR*               ,TIER_DEFLT_OFFR_CD                                       
MFA-TR*               ,OFFER_START_DT                                           
MFA-TR*               ,OFFER_END_DT                                             
MFA-TR*               ,OFFER_DESC_EXT                                           
MFA-TR*               ,PROMO_CD_EXT_FL                                          
MFA-TR*               ,SPCL_OFFER_TYPE_CD                                       
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,CURR_EXT_DESC_LONG                                       
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,OPTION_START_DT                                          
MFA-TR*               ,OPTION_END_DT                                            
MFA-TR*               ,OPTION_SORT_SEQ_NO                                       
MFA-TR*               ,THERM_PRICE                                              
MFA-TR*               ,CSC_AMT                                                  
MFA-TR*               ,RT_ATTR_INCTV_TYPE                                       
MFA-TR*               ,RT_ATTR_INCTV_DESC                                       
MFA-TR*               ,ATTR_INCTV_SEQ_NO                                        
MFA-TR*               ,DURATION_NO                                              
MFA-TR*               ,ATTR_INCTV_VALUE                                         
MFA-TR*               ,ATTR_INCTV_VAL_TX                                        
MFA-TR*               ,RATE_GRP_DESC                                            
MFA-TR*               ,RATE_GRP_DESC_LONG                                       
MFA-TR*               ,RT_GRP_SORT_SEQ_NO                                       
MFA-TR*               ,SORT_SEQ_NO                                              
MFA-TR*               ,PROMO_CD                                                 
MFA-TR*               ,EXT_LANDING_PG_URL                                       
MFA-TR*               ,INCTV_ENABLE_FLAG                                        
MFA-TR*               ,INT_LANDING_PG_URL                                       
MFA-TR*               ,OPT_CALC_TYPE_CD                                         
MFA-TR*               ,THERM_PRC_DSCNT_FL                                       
MFA-TR*               ,CSC_DSCNT_FL                                             
MFA-TR*               ,TOT_THERM_PRC_DSCNT                                      
MFA-TR*               ,TOT_CSC_DSCNT                                            
MFA-TR*               ,DSCNTD_THERM_PRC_CRM                                     
MFA-TR*               ,DSCNTD_CSC_CRM                                           
MFA-TR*               ,FCTR_LONG_DESC_CRM                                       
MFA-TR*               ,MAX_OFFER_OPT_PRICE                                      
MFA-TR*               ,PRICE_NEGOTIATION_PARM                                   
MFA-TR*               ,AUTO_RENEWAL_FL                                          
MFA-TR*               ,RATE_DEFINITION_CD                                       
MFA-TR*               ,CORE_RATE_PLAN_DDDC                                      
MFA-TR*        FROM SESSION.CSR04005_R4                                         
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1000-INITIALIZE-PROCEDURE.                                   **         
      *     SET UP SQL ERROR PROCESSING AND DECLARE ASSOCIATED CURSOR**         
      *****************************************************************         
      *                                                                         
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
P1137C*                                                                         
P1137C*** USE CURRENT DATE/TIMESTAMP FOR OPTIMIZATION                           
P1137C     PERFORM 7100-GET-CURR-DATE-AND-TS THRU 7100-EXIT.            
      *                                                                         
           INITIALIZE WS-MIN-TIER-RANKING                               
                     ,WS-MAX-TIER-RANKING.                              
P00453                                                                  
P00453     MOVE 'N'                     TO WS-PRP-TIER-RANK-FL          
P00453* GET PREPAID PLAN TIER RANK                                              
P00453     MOVE I-COMPANY-NO            TO C8-COMPANY-NO                
P00453     MOVE WS-PRP-DEFAULT-TIER     TO C8-DELINQ-CD                 
P00453     PERFORM 7920-SELECT-DELINQ-VALUE  THRU 7920-EXIT             
P00453     MOVE C8-DELINQ-VALUE         TO WS-PRP-MKT-TIER-RANK         
P00453     IF I-MKT-TIER-RANKING = WS-PRP-MKT-TIER-RANK                 
P00453        MOVE 'Y'                  TO WS-PRP-TIER-RANK-FL          
P00453     END-IF                                                       
      *                                                                         
I01095                                                                  
I01095* GET NUMBER OF MONTHS RATE EFFECTIVE DELIQUENCY VALUE                    
P00614     IF I-CALL-TYPE = 'WEB' OR 'ECS'                              
I01095        MOVE I-COMPANY-NO            TO C8-COMPANY-NO             
I01095        MOVE WS-RATE-EFF-DLINQ-CD    TO C8-DELINQ-CD              
I01095        PERFORM 7920-SELECT-DELINQ-VALUE  THRU 7920-EXIT          
I01095        MOVE C8-DELINQ-VALUE         TO WS-RATE-EFF-DLINQ         
I01095                                                                  
I01095        MOVE WS-CRM-RT-CHG-DLINQ-CD  TO C8-DELINQ-CD              
I01095        PERFORM 7920-SELECT-DELINQ-VALUE  THRU 7920-EXIT          
I01095        MOVE C8-DELINQ-VALUE         TO WS-CRM-RT-CHG-DAY         
I01095        MOVE WS-CRM-RT-CHG-DAY       TO WS-CRM-RT-CHG-DAY-NUM     
I01095     END-IF.                                                      
                                                                        
P680P2     IF I-CALL-TYPE = 'CRM'                                       
P680P2        MOVE I-COMPANY-NO            TO C8-COMPANY-NO             
P680P2        MOVE WS-PRICE-NEGOTIATION-CD TO C8-DELINQ-CD              
P680P2        PERFORM 7920-SELECT-DELINQ-VALUE  THRU 7920-EXIT          
P680P2        MOVE C8-DELINQ-VALUE         TO WS-PRC-NEGOTIATION-PARM   
P680P2     END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A00775******************************************************************        
A00775**  1100-LOAD-RATE-SPCL-FCTR-DATA.                              **        
A00775**      LOAD RATE FACTORS & SPECIAL FACTORS INTO AN ARRAY.      **        
A00775******************************************************************        
A00775*                                                                         
A00775 1100-LOAD-RATE-SPCL-FCTR-DATA.                                   
A00775*                                                                         
A00775     PERFORM 7700-OPEN-RATE-SPCL-FCTRS  THRU 7700-EXIT.           
A00775                                                                  
A00775     PERFORM 7710-FETCH-RATE-SPCL-FCTRS THRU 7710-EXIT.           
A00775                                                                  
A00775     PERFORM 7720-CLOSE-RATE-SPCL-FCTRS THRU 7720-EXIT.           
A00775*                                                                         
A00775 1100-EXIT.                                                       
A00775     EXIT.                                                        
      *                                                                         
OTPOOL*****************************************************************         
OTPOOL* 1125-LOAD-ALL-DDDC.                                           *         
OTPOOL*   LOAD DDDC VALUE FOR ALL RATE PLANS                          *         
OTPOOL*****************************************************************         
OTPOOL 1125-LOAD-ALL-DDDC.                                              
OTPOOL                                                                  
OTPOOL     MOVE +0                         TO DDC-CNT.                  
OTPOOL     PERFORM 7991-OPEN-DDDC-CURSOR      THRU 7991-EXIT.           
OTPOOL     PERFORM 7992-FETCH-DDDC-CURSOR     THRU 7992-EXIT.           
OTPOOL     PERFORM 1150-LOAD-ALL-DDDC         THRU 1150-EXIT            
OTPOOL            UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.          
OTPOOL     PERFORM 7993-CLOSE-DDDC-CURSOR     THRU 7993-EXIT.           
OTPOOL                                                                  
OTPOOL 1125-EXIT.                                                       
OTPOOL     EXIT.                                                        
      *                                                                         
OTPOOL*****************************************************************         
OTPOOL* 1150-PROCESS-DDDC.                                            *         
OTPOOL*   LOAD DDDC VALUE INTO WORKING STORAGE ARRAY                  *         
OTPOOL*****************************************************************         
OTPOOL 1150-LOAD-ALL-DDDC.                                              
OTPOOL                                                                  
OTPOOL     ADD 1                           TO DDC-CNT.                  
OTPOOL     MOVE SA-RATE-PLAN-NO            TO DDC-RATE-PLAN-NO(DDC-CNT).
OTPOOL     COMPUTE DDC-FACTOR(DDC-CNT) ROUNDED = SA-FACTOR.             
OTPOOL     PERFORM 7992-FETCH-DDDC-CURSOR     THRU 7992-EXIT.           
OTPOOL                                                                  
OTPOOL 1150-EXIT.                                                       
OTPOOL     EXIT.                                                        
      *                                                                         
P00269******************************************************************        
P00269**  1200-PROCESS-SECURE-OFF-OPT.                                **        
P00269**  CHECK IF SUPER USER OR ELSE LOAD SECURE OFFER AND OPTION    **        
P00269**  TABLE                                                       **        
P00269******************************************************************        
P00269*                                                                         
P00269 1200-PROCESS-SECURE-OFF-OPT.                                     
P00269*                                                                         
P00269     MOVE I-USER-ID                    TO F5-USER-ID.             
P00269                                                                  
P00269     PERFORM 7890-GET-SUPER-USER-FLAG  THRU 7890-EXIT.            
P00269                                                                  
P00269     MOVE WS-SUPER-USER-FLAG           TO WS-SUPER-USER-SW.       
P00269                                                                  
P00269     IF SUPER-USER                                                
P00269        CONTINUE                                                  
P00269     ELSE                                                         
P00269        PERFORM 1250-LOAD-SECURE-OFF-OPT-DATA                     
P00269                                       THRU 1250-EXIT             
P00269     END-IF.                                                      
P00269*                                                                         
P00269 1200-EXIT.                                                       
P00269     EXIT.                                                        
P00269*                                                                         
P00269******************************************************************        
P00269**  1250-LOAD-SECURE-OFF-OPT-DATA.                              **        
P00269**      LOAD SECURE OFFER AND OPTION ACCESS DATA TO AN ARRAY.   **        
P00269******************************************************************        
P00269*                                                                         
P00269 1250-LOAD-SECURE-OFF-OPT-DATA.                                   
P00269*                                                                         
P00269     SET  WS-SEC-TAB-INDX               TO 1.                     
P00269                                                                  
P00269     MOVE I-COMPANY-NO                  TO CI-COMPANY-NO.         
P00269                                                                  
P00269     PERFORM 7860-OPEN-SEC-OFF-OPT-CUR  THRU 7860-EXIT.           
P00269                                                                  
P00269     PERFORM 7870-FETCH-SEC-OFF-OPT-CUR THRU 7870-EXIT.           
P00269                                                                  
P00269     PERFORM 5450-PROCESS-SEC-OFF-OPT   THRU 5450-EXIT            
P00269             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
P00269                                                                  
P00269     PERFORM 7880-CLOSE-SEC-OFF-OPT-CUR THRU 7880-EXIT.           
P00269*                                                                         
P00269 1250-EXIT.                                                       
P00269     EXIT.                                                        
P00269*                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                          **        
      *     CALCULATE THE FIRST AND THE LAST DAY OF THE GIVEN REVENUE **        
      *     MONTH AND PROCESS ALL THE FACTORS.                        **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT        THRU 2200-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
      *                                                                         
           MOVE I-CALL-TYPE                 TO WS-CALL-TYPE             
P00269     MOVE I-VIEW-APPLY-CD             TO WS-VIEW-APPLY-CD         
           MOVE I-TIER-CUST-STAT-CODE       TO IG-TIER-CUST-STAT-CD     
                                              ,DU-TIER-CUST-STAT-CD     
           MOVE I-TIER-ACCT-TYPE-CD         TO IG-TIER-ACCT-TYPE-CD     
                                              ,DU-TIER-ACCT-TYPE-CD     
           MOVE I-COMPANY-NO                TO IG-COMPANY-NO            
                                               FI-COMPANY-NO            
                                              ,DU-COMPANY-NO            
                                              ,G7-COMPANY-NO            
                                              ,KM-COMPANY-NO            
                                                                        
P00614     EVALUATE TRUE                                                
P00614         WHEN I-CALL-TYPE  = 'ECS'                                
P00614              PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT           
P00614         WHEN I-CALL-TYPE  = 'WEB'                                
P00614              PERFORM 0100B-DECLARE-GTT THRU 0100B-EXIT           
P00614         WHEN (I-CALL-TYPE = 'CRM' AND I-INT-EXT-DATA-FL = 'I')   
P00614              PERFORM 0100C-DECLARE-GTT THRU 0100C-EXIT           
P00614         WHEN (I-CALL-TYPE = 'CRM' AND I-INT-EXT-DATA-FL = 'E')   
P00614              PERFORM 0100D-DECLARE-GTT THRU 0100D-EXIT           
P00614     END-EVALUATE                                                 
                                                                        
           IF I-PROMO-CD EQUAL SPACES                                   
              IF I-MKT-TIER-RANKING > 0                                 
                 MOVE I-MKT-TIER-RANKING        TO IG-MKT-TIER-RANKING  
                 PERFORM 7000-SELECT-MKT-TIER-DET  THRU 7000-EXIT       
A00910*** IF WE GET A NOT FOUND IN THE ABOVE SELECT, ASSUMPTION IS              
A00910*** MKT TIER WOULD HAVE BEEN EXPIRED. SO WE WILL GET DEFAULT              
A00910*** MKT TIER USING TIER_CUST_STAT_CD & TIER_ACCT_TYPE_CD                  
A00910           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
A00910              PERFORM 7005-SELECT-DFLT-MKT-TIER THRU 7005-EXIT    
A00910           END-IF                                                 
              ELSE                                                      
                 PERFORM 7005-SELECT-DFLT-MKT-TIER THRU 7005-EXIT       
              END-IF                                                    
              MOVE IG-MKT-TIER-RANKING          TO WS-MKT-TIER-RANKING  
              PERFORM 5000-PROCESS-TIERRANK-DET THRU 5000-EXIT          
           ELSE                                                         
              PERFORM 5200-PROCESS-PROMO-DET    THRU 5200-EXIT          
           END-IF                                                       
                                                                        
           IF CTR-ROWS = 0                                              
              PERFORM 7099-SEND-NOTFOUND-RES    THRU 7099-EXIT          
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2400-MOVE-VALUES                                               *        
      *     MOVE VALUES INTO RESULT SET.                               *        
      ******************************************************************        
       2400-MOVE-VALUES.                                                
      *                                                                         
P00269     MOVE FI-OPTION-CD              TO WS-CHECK-OPTION            
P00269     PERFORM 5470-CHECK-SECURE-OPTN-ACCESS                        
P00269                                    THRU 5470-EXIT                
P00269     IF SUPER-USER OR OPTION-NOT-SECURE                           
P00269       OR ( SECURE-OPTION AND USER-HAS-OPTN-ACCESS )              
P00269                                                                  
              MOVE 0                        TO S-RETURN-CODE            
              MOVE DU-TIER-CUST-STAT-CD     TO S-TIER-CUST-STAT-CD      
              MOVE DU-TIER-ACCT-TYPE-CD     TO S-TIER-ACCT-TYPE-CD      
              MOVE DU-MKT-TIER-RANKING      TO S-MKT-TIER-RANKING       
              MOVE IG-MKT-TIER-START-DT     TO S-MKT-TIER-START-DT      
              MOVE IG-MKT-TIER-END-DT       TO S-MKT-TIER-END-DT        
              MOVE IG-MKT-TIER-DESC         TO S-MKT-TIER-DESC          
              MOVE IG-TIER-OFFER-VIEW       TO S-TIER-OFFER-VIEW        
P00614        MOVE IG-CUST-ACCT-DEFLT-FL    TO S-CUST-ACCT-DEFLT-FL     
              MOVE FG-OFFER-CD              TO S-OFFER-CD               
              MOVE DU-OFFER-TIER-STRT-DT    TO S-OFFER-TIER-STRT-DT     
              MOVE DU-OFFER-TIER-END-DT     TO S-OFFER-TIER-END-DT      
              MOVE DU-TIER-DEFLT-OFFR-CD    TO S-TIER-DEFLT-OFFR-CD     
              MOVE FG-OFFER-START-DT        TO S-OFFER-START-DT         
              MOVE FG-OFFER-END-DT          TO S-OFFER-END-DT           
              MOVE FG-PROMO-CD-INT-FL       TO S-PROMO-CD-INT-FL        
              MOVE FG-PROMO-CD-EXT-FL       TO S-PROMO-CD-EXT-FL        
              MOVE WS-SPCL-OFFER-TYPE-CD    TO S-SPCL-OFFER-TYPE-CD     
              MOVE FI-OPTION-CD             TO S-OPTION-CD              
                                              ,HQ-OPTION-CD             
              MOVE FI-AUTO-RENEWAL-FL       TO S-AUTO-RENEWAL-FL        
I01095                                                                  
P00544*****   IF I-CALL-TYPE = 'WEB' AND I-PROMO-CD > SPACES                    
P00544        IF I-CALL-TYPE = 'WEB'                                    
I01095           MOVE FI-WEB-MKT-DESC-LONG-LEN                          
I01095                                      TO S-WEB-MKT-DESC-LONG-LEN  
I01095           MOVE FI-WEB-MKT-DESC-LONG-TEXT                         
I01095                                      TO S-WEB-MKT-DESC-LONG-TEXT 
I01095        END-IF                                                    
I01095                                                                  
P00485                                                                  
              MOVE FI-CODE-UTIL-TYPE        TO S-CODE-UTIL-TYPE         
P00485                                         RD-CODE-UTIL-TYPE        
              MOVE FI-RATE-PLAN-NO          TO S-RATE-PLAN-NO           
P00485                                         RD-RATE-PLAN-NO          
P00485                                                                  
P00485        PERFORM 7930-SELECT-RATE-CALC-CD   THRU 7930-EXIT         
P00485                                                                  
OTPOOL        MOVE ZEROS                    TO S-CORE-RATE-PLAN-DDDC    
P00485        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00485           MOVE RD-RATE-DEFINITION-CD TO S-RATE-DEFINITION-CD     
P00614           MOVE RD-SENIOR-RATE-FL     TO S-SENIOR-RATE-FL         
I02262           IF RD-RATE-DEFINITION-CD EQUAL '2'                     
OTPOOL              SEARCH ALL WS-DDDC-TBL                              
OTPOOL                  AT END                                          
OTPOOL                     CONTINUE                                     
OTPOOL                WHEN DDC-RATE-PLAN-NO(DDC-IND) = FI-RATE-PLAN-NO  
OTPOOL                     MOVE DDC-FACTOR(DDC-IND)                     
OTPOOL                          TO S-CORE-RATE-PLAN-DDDC                
OTPOOL              END-SEARCH                                          
OTPOOL           END-IF                                                 
P00485        ELSE                                                      
P00485           MOVE SPACES                TO S-RATE-DEFINITION-CD     
P00614                                         S-SENIOR-RATE-FL         
P00485        END-IF                                                    
P00485                                                                  
              MOVE FI-OPTION-START-DT       TO S-OPTION-START-DT        
              MOVE FI-OPTION-END-DT         TO S-OPTION-END-DT          
P00544        MOVE FI-OPT-CALC-TYPE-CD      TO S-OPT-CALC-TYPE-CD       
P00544        EVALUATE S-OPT-CALC-TYPE-CD                               
P00544            WHEN 'FP'                                             
P00544                 MOVE 'F'             TO S-OPT-TYPE-WEB           
P00544            WHEN 'IV'                                             
P00544            WHEN 'TV'                                             
P00544            WHEN 'VP'                                             
P00544                 MOVE 'V'             TO S-OPT-TYPE-WEB           
P00544            WHEN OTHER                                            
P00544                 MOVE 'O'             TO S-OPT-TYPE-WEB           
P00544        END-EVALUATE                                              
              MOVE E9-OPTION-SORT-SEQ-NO    TO S-OPTION-SORT-SEQ-NO     
P00614        MOVE E9-WEB-NEW-EXISTS-CD     TO S-WEB-NEW-EXISTS-CD      
P00614        MOVE E9-WEB-SIGN-UP-FL        TO S-WEB-SIGN-UP-FL         
              MOVE F7-RATE-GRP-DESC         TO S-RATE-GRP-DESC          
              MOVE F7-RATE-GRP-DESC-LONG    TO S-RATE-GRP-DESC-LONG     
              MOVE F7-RT-GRP-SORT-SEQ-NO    TO S-RT-GRP-SORT-SEQ-NO     
              MOVE G5-SORT-SEQ-NO           TO S-SORT-SEQ-NO            
A04362        MOVE 'Y'                      TO S-INCTV-ENABLE-FLAG      
              MOVE KM-PROMO-CD              TO S-PROMO-CD               
              MOVE KM-EXT-LANDING-PG-URL-LEN                            
                                            TO S-EXT-LANDING-PG-URL-LEN 
              MOVE KM-EXT-LANDING-PG-URL-TEXT                           
                                            TO S-EXT-LANDING-PG-URL-TEXT
I01095        MOVE KM-INT-LANDING-PG-URL-LEN                            
I01095                                      TO S-INT-LANDING-PG-URL-LEN 
I01095        MOVE KM-INT-LANDING-PG-URL-TEXT                           
I01095                                      TO S-INT-LANDING-PG-URL-TEXT
                                                                        
      * WS-SPCL-OFFER-TYPE-CD = 'IN' --> INCENTIVE                              
              IF WS-SPCL-OFFER-TYPE-CD  =  'IN'                         
                 INITIALIZE                     WS-THERM-PRICE          
                                                WS-CSC-AMT              
P00680                                          WS-TOT-PRC-DSCNT        
P00680                                          WS-TOT-CSC-DSCNT        
                                                S-THERM-PRICE           
                                                S-CSC-AMT               
P00680                                          S-TOT-THERM-PRC-DSCNT   
P00680                                          S-TOT-CSC-DSCNT         
P00680                                          S-DSCNTD-THERM-PRC-CRM  
P00680                                          S-DSCNTD-CSC-CRM        
P00680           MOVE 'N'                    TO WS-PRC-DSCNT-FL         
P00680                                          WS-CSC-DSCNT-FL         
              ELSE                                                      
                 PERFORM 5400-SELECT-THERM-CSC  THRU 5400-EXIT          
              END-IF                                                    
      *                                                                         
A00775        MOVE WS-THERM-PRICE            TO S-THERM-PRICE           
A00775        MOVE WS-CSC-AMT                TO S-CSC-AMT               
A04019                                          WS-CSC-AMT-DESC         
              MOVE FG-OFFER-DESC-INT         TO S-OFFER-DESC-INT        
                                                                        
A04019        IF WS-CSC-AMT > 0                                         
A04019           STRING FI-OPT-DESC-INT DELIMITED BY '   '              
A04019                  ' with '                                        
A04019                  WS-CSC-AMT-DESC DELIMITED BY SIZE               
A04019                  WS-CSC-LIT-DESC DELIMITED BY SIZE               
A04019           INTO S-OPT-DESC-INT                                    
A04019        ELSE                                                      
A04019           MOVE FI-OPT-DESC-INT        TO S-OPT-DESC-INT          
A04019        END-IF                                                    
                                                                        
A04019        IF WS-CSC-AMT > 0                                         
A04019           STRING FI-OPT-DESC-INT-LONG-TEXT DELIMITED BY '    '   
A04019                  ' with '                                        
A04019                  WS-CSC-AMT-DESC DELIMITED BY SIZE               
A04019                  WS-CSC-LIT-DESC DELIMITED BY SIZE               
A04019           INTO FI-OPT-DESC-INT-LONG-TEXT                         
A04019           MOVE LENGTH OF FI-OPT-DESC-INT-LONG-TEXT               
A04019                                       TO S-OPT-DESC-INT-LONG-LEN 
A04019           MOVE FI-OPT-DESC-INT-LONG-TEXT                         
A04019                                       TO S-OPT-DESC-INT-LONG-TEXT
A04019        ELSE                                                      
A04019           MOVE LENGTH OF FI-OPT-DESC-INT-LONG-TEXT               
A04019                                       TO S-OPT-DESC-INT-LONG-LEN 
A04019           MOVE FI-OPT-DESC-INT-LONG-TEXT                         
A04019                                       TO S-OPT-DESC-INT-LONG-TEXT
A04019        END-IF                                                    
              MOVE FI-CURR-EXT-DESC-LONG-LEN TO S-CURR-EXT-DESC-LONG-LEN
              MOVE FI-CURR-EXT-DESC-LONG-TEXT                           
                TO S-CURR-EXT-DESC-LONG-TEXT                            
              MOVE FI-WEB-DESC-LONG-LEN      TO S-WEB-DESC-LONG-LEN     
              MOVE FI-WEB-DESC-LONG-TEXT     TO S-WEB-DESC-LONG-TEXT    
                                                                        
I01095        MOVE WS-RATE-EFFECTIVE-DT      TO S-RATE-EFFECTIVE-DT     
I01095        MOVE WS-RATE-EXPIRATION-DATE   TO S-RATE-EXPIRATION-DATE  
I01095        MOVE WS-EXIT-FEE               TO S-EXIT-FEE              
P00680        MOVE WS-PRC-DSCNT-FL           TO S-THERM-PRC-DSCNT-FL    
P00680        MOVE WS-CSC-DSCNT-FL           TO S-CSC-DSCNT-FL          
P00680        MOVE WS-TOT-PRC-DSCNT          TO S-TOT-THERM-PRC-DSCNT   
P00680        MOVE WS-TOT-CSC-DSCNT          TO S-TOT-CSC-DSCNT         
A00775                                                                  
A00775        IF I-CALL-TYPE = 'CRM'                                    
P00680           IF WS-TOT-PRC-DSCNT NOT EQUAL 0                        
P00680              COMPUTE S-DSCNTD-THERM-PRC-CRM                      
P00680                  EQUAL WS-THERM-PRICE +  WS-TOT-PRC-DSCNT        
P00680           END-IF                                                 
P00680           IF WS-TOT-CSC-DSCNT NOT EQUAL 0                        
P00680              COMPUTE S-DSCNTD-CSC-CRM                            
P00680                  EQUAL WS-CSC-AMT     +  WS-TOT-CSC-DSCNT        
P00680           END-IF                                                 
A00775           MOVE 'N'                    TO WS-NO-MORE-TR-ROWS7     
A00775           PERFORM 7830-OPEN-ATTR-DET     THRU 7830-EXIT          
A00775           PERFORM 7840-FETCH-ATTR-DET    THRU 7840-EXIT          
A00775                                                                  
A00775           IF NO-MORE-TR-ROWS7                                    
A00775              MOVE SPACES              TO S-RT-ATTR-INCTV-TYPE    
A00775              MOVE SPACES              TO S-RT-ATTR-INCTV-DESC    
A00775              MOVE ZEROES              TO S-ATTR-INCTV-SEQ-NO     
A00775              MOVE ZEROES              TO S-DURATION-NO           
A00775              MOVE ZEROES              TO S-ATTR-INCTV-VALUE      
P680P2                                          S-MAX-OFFER-OPT-PRICE   
P680P2                                          S-PRICE-NEGOTIATION-PARM
A00775              MOVE SPACES              TO S-ATTR-INCTV-VAL-TX     
A00775                                                                  
A00775              IF I-INT-EXT-DATA-FL  = 'I'                         
A00775                 PERFORM 8300-SEND-RESULT THRU  8300-EXIT         
A00775              ELSE                                                
A00775                 PERFORM 8400-SEND-RESULT THRU  8400-EXIT         
A00775              END-IF                                              
A00775           ELSE                                                   
A00775              PERFORM 5500-PROCESS-ATTR-DET                       
A00775                                          THRU 5500-EXIT          
A00775                                          UNTIL NO-MORE-TR-ROWS7  
A00775           END-IF                                                 
A00775                                                                  
A00775           PERFORM 7850-CLOSE-ATTR-DET    THRU 7850-EXIT          
A00775        ELSE                                                      
P00680           MOVE 'N'                    TO WS-NO-MORE-TR-ROWS8     
P00680           MOVE +1                     TO WS-PRC-DSCNT-CTR        
P00680                                          WS-CSC-DSCNT-CTR        
P00680           PERFORM 7940-OPEN-DISCOUNT-CURSOR                      
P00680                                          THRU 7940-EXIT          
P00680           PERFORM 7950-FETCH-DISCOUNT-CURSOR                     
P00680                                          THRU 7950-EXIT          
P00680           PERFORM 5600-PROCESS-DISCOUNTS THRU 5600-EXIT          
P00680                   UNTIL NO-MORE-TR-ROWS8                         
P00680           PERFORM 7960-CLOSE-DISCOUNT-CURSOR                     
P00680                                          THRU 7960-EXIT          
P614P2*** OFF_OPT_EXCLUDE_CD = W --> EXCLUDE/HIDE OPTION                        
P614P2           IF E9-OFF-OPT-EXCLUDE-CD NOT = 'W'                     
P614P2              IF I-CALL-TYPE = 'ECS'                              
P614P2                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT          
P614P2              ELSE                                                
P614P2                 PERFORM 8200-SEND-RESULT THRU 8200-EXIT          
P614P2              END-IF                                              
P614P2           END-IF                                                 
A00775        END-IF                                                    
P00269     END-IF                                                       
                                                                        
           PERFORM 7810-FETCH-OPTION-DET        THRU 7810-EXIT.         
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5000-PROCESS-TIERRANK-DET.                                   **         
      *                                                              **         
      *****************************************************************         
       5000-PROCESS-TIERRANK-DET.                                       
                                                                        
           EVALUATE IG-TIER-OFFER-VIEW                                  
               WHEN 0                                                   
                    MOVE IG-MKT-TIER-RANKING  TO WS-MIN-TIER-RANKING    
                                                ,WS-MAX-TIER-RANKING    
               WHEN 999                                                 
                    MOVE  0                   TO WS-MIN-TIER-RANKING    
                    MOVE 999                  TO WS-MAX-TIER-RANKING    
               WHEN OTHER                                               
                    MOVE IG-MKT-TIER-RANKING  TO WS-MIN-TIER-RANKING    
                    MOVE IG-TIER-OFFER-VIEW   TO WS-MAX-TIER-RANKING    
           END-EVALUATE                                                 
                                                                        
           IF I-INT-EXT-DATA-FL  = 'I'                                  
              MOVE 'N'                TO WS-NO-MORE-TR-ROWS2            
              PERFORM 7300-OPEN-TIERANK-RTPKOFF-INT                     
                                                 THRU 7300-EXIT         
              PERFORM 7310-FETCH-TIERANK-RTPKOFF-INT                    
                                                 THRU 7310-EXIT         
              PERFORM 5100-PROCESS-TIERRANK-INT                         
                                                 THRU 5100-EXIT         
                                                 UNTIL NO-MORE-TR-ROWS2 
              PERFORM 7320-CLOSE-TIERANK-RTPKOFF-INT                    
                                                 THRU 7320-EXIT         
           ELSE                                                         
              MOVE 'N'                TO WS-NO-MORE-TR-ROWS3            
              PERFORM 7350-OPEN-TIERANK-RTPKOFF-EXT                     
                                                 THRU 7350-EXIT         
              PERFORM 7360-FETCH-TIERANK-RTPKOFF-EXT                    
                                                 THRU 7360-EXIT         
              PERFORM 5150-PROCESS-TIERRANK-EXT THRU  5150-EXIT         
                                                 UNTIL NO-MORE-TR-ROWS3 
              PERFORM 7370-CLOSE-TIERANK-RTPKOFF-EXT                    
                                                 THRU 7370-EXIT         
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5100-PROCESS-TIERRANK-INT                                    **         
      *                                                              **         
      *****************************************************************         
       5100-PROCESS-TIERRANK-INT.                                       
                                                                        
            MOVE FG-OFFER-CD               TO E9-OFFER-CD               
P00269                                        WS-CHECK-OFFER            
                                                                        
P00453      IF DU-MKT-TIER-RANKING  = WS-PRP-MKT-TIER-RANK              
P00453       AND WS-PRP-TIER-RANK-FL = 'N'                              
P00453         CONTINUE                                                 
P00453      ELSE                                                        
P00269         PERFORM 5460-CHECK-SECURE-OFFR-ACCESS                    
P00269                                     THRU 5460-EXIT               
P00269         IF OFFER-NOT-SECURE OR SUPER-USER                        
P00269            OR ( SECURE-OFFER AND USER-HAS-OFFR-ACCESS ) THEN     
P680P2            PERFORM 5700-GET-MAX-OFFER-OPTIONS                    
P680P2                                           THRU 5700-EXIT         
                  MOVE 'N'                       TO WS-NO-MORE-TR-ROWS6 
                  PERFORM 7800-OPEN-OPTION-DET   THRU 7800-EXIT         
                                                                        
                  PERFORM 7810-FETCH-OPTION-DET  THRU 7810-EXIT         
                                                                        
                  PERFORM 2400-MOVE-VALUES       THRU 2400-EXIT         
                                                 UNTIL NO-MORE-TR-ROWS6 
                  PERFORM 7820-CLOSE-OPTION-DET  THRU 7820-EXIT         
P00269         END-IF                                                   
P00453      END-IF.                                                     
                                                                        
            PERFORM 7310-FETCH-TIERANK-RTPKOFF-INT THRU 7310-EXIT.      
      *                                                                         
       5100-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      *****************************************************************         
      * 5150-PROCESS-TIERRANK-EXT                                    **         
      *                                                              **         
      *****************************************************************         
       5150-PROCESS-TIERRANK-EXT.                                       
                                                                        
            MOVE FG-OFFER-CD               TO E9-OFFER-CD               
P00269                                        WS-CHECK-OFFER            
P00453      IF DU-MKT-TIER-RANKING  = WS-PRP-MKT-TIER-RANK              
P00453       AND WS-PRP-TIER-RANK-FL = 'N'                              
P00453         CONTINUE                                                 
P00453      ELSE                                                        
P00269         PERFORM 5460-CHECK-SECURE-OFFR-ACCESS                    
P00269                                     THRU 5460-EXIT               
P00269         IF OFFER-NOT-SECURE OR SUPER-USER                        
P00269            OR ( SECURE-OFFER AND USER-HAS-OFFR-ACCESS ) THEN     
P614P2*****       PERFORM 5700-GET-MAX-OFFER-OPTIONS                            
P614P2*****                                      THRU 5700-EXIT                 
                  MOVE 'N'                       TO WS-NO-MORE-TR-ROWS6 
                  PERFORM 7800-OPEN-OPTION-DET   THRU 7800-EXIT         
                                                                        
                  PERFORM 7810-FETCH-OPTION-DET  THRU 7810-EXIT         
                                                                        
                  PERFORM 2400-MOVE-VALUES       THRU 2400-EXIT         
                                                 UNTIL NO-MORE-TR-ROWS6 
                  PERFORM 7820-CLOSE-OPTION-DET  THRU 7820-EXIT         
P00269         END-IF                                                   
P00453      END-IF.                                                     
                                                                        
            PERFORM 7360-FETCH-TIERANK-RTPKOFF-EXT THRU 7360-EXIT.      
      *                                                                         
       5150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5200-PROCESS-PROMO-DET.                                      **         
      *                                                              **         
      *****************************************************************         
       5200-PROCESS-PROMO-DET.                                          
      *                                                                         
           IF I-CALL-TYPE = 'CRM'                                       
              PERFORM 7010-CRMCHK-ACTV-PROMO       THRU  7010-EXIT      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE I-PROMO-CD                   TO KM-PROMO-CD       
              ELSE                                                      
                 PERFORM 7020-CRMCHK-EXPI-PROMO    THRU  7020-EXIT      
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    IF KM-REPLACMNT-PROMO-CD EQUAL SPACES               
                       INITIALIZE                  GTT-RETURN-FIELDS    
                       MOVE 111                    TO S-RETURN-CODE     
                       PERFORM 7099-SEND-NOTFOUND-RES                   
                                                   THRU 7099-EXIT       
                    ELSE                                                
                       MOVE KM-REPLACMNT-PROMO-CD  TO KM-PROMO-CD       
                    END-IF                                              
                 ELSE                                                   
                    PERFORM 7099-SEND-NOTFOUND-RES THRU 7099-EXIT       
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              PERFORM 7060-WEBCHK-ACTV-PROMO       THRU  7060-EXIT      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE I-PROMO-CD                   TO KM-PROMO-CD       
              ELSE                                                      
                 PERFORM 7070-WEBCHK-EXPI-PROMO    THRU  7070-EXIT      
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    IF KM-REPLACMNT-PROMO-CD EQUAL SPACES               
                       INITIALIZE                  GTT-RETURN-FIELDS    
                       MOVE 111                    TO S-RETURN-CODE     
                       PERFORM 7099-SEND-NOTFOUND-RES                   
                                                   THRU 7099-EXIT       
                    ELSE                                                
                       MOVE KM-REPLACMNT-PROMO-CD  TO KM-PROMO-CD       
                    END-IF                                              
                 ELSE                                                   
                    PERFORM 7099-SEND-NOTFOUND-RES THRU 7099-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF I-INT-EXT-DATA-FL  = 'I'                                  
              MOVE 'N'                TO WS-NO-MORE-TR-ROWS4            
              PERFORM 7400-OPEN-PROMO-RTPKOFF-INT  THRU  7400-EXIT      
              PERFORM 7410-FETCH-PROMO-RTPKOFF-INT THRU  7410-EXIT      
              PERFORM 5300-PROCESS-PROMO-INT       THRU  5300-EXIT      
                                         UNTIL NO-MORE-TR-ROWS4         
              PERFORM 7420-CLOSE-PROMO-RTPKOFF-INT THRU  7420-EXIT      
           ELSE                                                         
              MOVE 'N'                TO WS-NO-MORE-TR-ROWS5            
              PERFORM 7450-OPEN-PROMO-RTPKOFF-EXT  THRU  7450-EXIT      
              PERFORM 7460-FETCH-PROMO-RTPKOFF-EXT THRU  7460-EXIT      
              PERFORM 5350-PROCESS-PROMO-EXT       THRU  5350-EXIT      
                                         UNTIL  NO-MORE-TR-ROWS5        
              PERFORM 7470-CLOSE-PROMO-RTPKOFF-EXT THRU  7470-EXIT      
           END-IF.                                                      
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5300-PROCESS-PROMO-INT                                       **         
      *                                                              **         
      *****************************************************************         
       5300-PROCESS-PROMO-INT.                                          
                                                                        
            MOVE FG-OFFER-CD               TO E9-OFFER-CD               
P00269                                        WS-CHECK-OFFER            
P00269      PERFORM 5460-CHECK-SECURE-OFFR-ACCESS                       
P00269                                     THRU 5460-EXIT               
P00269      IF OFFER-NOT-SECURE OR SUPER-USER                           
P00269         OR ( SECURE-OFFER AND USER-HAS-OFFR-ACCESS ) THEN        
P680P2         PERFORM 5700-GET-MAX-OFFER-OPTIONS                       
P680P2                                        THRU 5700-EXIT            
               MOVE 'N'                       TO WS-NO-MORE-TR-ROWS6    
               PERFORM 7800-OPEN-OPTION-DET   THRU 7800-EXIT            
                                                                        
               PERFORM 7810-FETCH-OPTION-DET  THRU 7810-EXIT            
                                                                        
               PERFORM 2400-MOVE-VALUES       THRU 2400-EXIT            
                                              UNTIL NO-MORE-TR-ROWS6    
               PERFORM 7820-CLOSE-OPTION-DET  THRU 7820-EXIT            
P00269      END-IF                                                      
                                                                        
            PERFORM 7410-FETCH-PROMO-RTPKOFF-INT THRU 7410-EXIT.        
      *                                                                         
       5300-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      *****************************************************************         
      * 5350-PROCESS-PROMO-EXT                                       **         
      *                                                              **         
      *****************************************************************         
       5350-PROCESS-PROMO-EXT.                                          
                                                                        
            MOVE FG-OFFER-CD               TO E9-OFFER-CD               
P00269                                        WS-CHECK-OFFER            
P00269      PERFORM 5460-CHECK-SECURE-OFFR-ACCESS                       
P00269                                     THRU 5460-EXIT               
P00269      IF OFFER-NOT-SECURE OR SUPER-USER                           
P00269         OR ( SECURE-OFFER AND USER-HAS-OFFR-ACCESS ) THEN        
P614P2*****    PERFORM 5700-GET-MAX-OFFER-OPTIONS                               
P614P2*****                                   THRU 5700-EXIT                    
               MOVE 'N'                       TO WS-NO-MORE-TR-ROWS6    
               PERFORM 7800-OPEN-OPTION-DET   THRU 7800-EXIT            
                                                                        
               PERFORM 7810-FETCH-OPTION-DET  THRU 7810-EXIT            
                                                                        
               PERFORM 2400-MOVE-VALUES       THRU 2400-EXIT            
                                              UNTIL NO-MORE-TR-ROWS6    
               PERFORM 7820-CLOSE-OPTION-DET  THRU 7820-EXIT            
P00269      END-IF                                                      
                                                                        
            PERFORM 7460-FETCH-PROMO-RTPKOFF-EXT THRU 7460-EXIT.        
      *                                                                         
       5350-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      *****************************************************************         
      **  5400-SELECT-THERM-CSC                                      **         
      *****************************************************************         
       5400-SELECT-THERM-CSC.                                           
      *                                                                         
A00775     INITIALIZE                       WS-THERM-PRICE              
A00775                                      WS-CSC-AMT                  
P00680                                      WS-TOT-PRC-DSCNT            
P00680                                      WS-TOT-CSC-DSCNT            
A00775                                      S-THERM-PRICE               
A00775                                      S-CSC-AMT                   
P00680                                      S-TOT-THERM-PRC-DSCNT       
P00680                                      S-TOT-CSC-DSCNT             
P00680                                      S-DSCNTD-THERM-PRC-CRM      
P00680                                      S-DSCNTD-CSC-CRM            
I01095                                      WS-RATE-EFFECTIVE-DT        
I01095                                      WS-RATE-EXPIRATION-DATE     
I01095                                      WS-EXIT-FEE                 
P00614                                      S-FLEX-OPT-FL               
P00836                                      S-FXD-PRC-OPTN-DUR-NO       
P00680     MOVE 'N'                      TO WS-PRC-DSCNT-FL             
P00680                                      WS-CSC-DSCNT-FL             
A00775                                                                  
A00775     MOVE FI-OPTION-CD             TO HQ-OPTION-CD                
A00775     MOVE FI-COMPANY-NO            TO HQ-COMPANY-NO               
A00775     MOVE FI-RATE-PLAN-NO          TO RT-RATE-PLAN-NO             
A00775                                      PS-RATE-PLAN-NO             
A00775                                      J4-RATE-PLAN-NO             
A00775                                                                  
A00775     PERFORM 7520-SELECT-RATE-CREATOR THRU 7520-EXIT              
A00775                                                                  
A00775     MOVE RT-VERSION-NO-CNTRL      TO PS-VERSION-NO-CNTRL         
A00775                                      J4-VERSION-NO-CNTRL         
A00775                                                                  
A00775     PERFORM 7530-SELECT-CUST-CHRG THRU 7530-EXIT                 
A00775                                                                  
A00775     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00775        MOVE J4-AMT-CUST-CHRG      TO WS-CSC-AMT                  
A00775     ELSE                                                         
A00775        MOVE ZEROES                TO WS-CSC-AMT                  
A00775     END-IF                                                       
A00775                                                                  
P00165     PERFORM 7535-CHECK-STEP-RATE    THRU 7535-EXIT.              
P00165                                                                  
P00165     IF J1-LAST-ENERGY-BLOCK > 1                                  
P00165        MOVE ZEROES                TO WS-THERM-PRICE              
P00165     ELSE                                                         
A00775        PERFORM 7540-SELECT-PRICE-SCHED THRU 7540-EXIT            
A00775                                                                  
A00775        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A00775           MOVE PS-SCHED-PRICE-AM  TO WS-THERM-PRICE              
A00775        ELSE                                                      
A00775           MOVE ZEROES             TO WS-THERM-PRICE              
A00775        END-IF                                                    
P00165     END-IF.                                                      
A00775                                                                  
A00775     PERFORM 5800-PROCESS-RATE-FCTRS   THRU 5800-EXIT             
A00775     PERFORM 7750-OPEN-ATTR-INCTV-DET  THRU 7750-EXIT             
A00775     PERFORM 7760-FETCH-ATTR-INCTV-DET THRU 7760-EXIT             
A00775                                                                  
A00775     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A00775        MOVE HQ-FACTOR-ID          TO SA-FACTOR-ID                
A00775        IF HQ-FACTOR-ID NOT EQUAL SPACES                          
A00775           PERFORM 5900-PROCESS-SPCL-FCTRS THRU 5900-EXIT         
A00775        END-IF                                                    
P00836        EVALUATE HQ-RT-ATTR-INCTV-TYPE                            
P00836            WHEN 'ADJUSTABLE RATE'                                
P00836               MOVE 'Y'            TO S-FLEX-OPT-FL               
P00836            WHEN 'FIXED PRICE'                                    
P00836               MOVE HQ-DURATION-NO TO S-FXD-PRC-OPTN-DUR-NO       
P00836        END-EVALUATE                                              
A00775        PERFORM 7760-FETCH-ATTR-INCTV-DET THRU 7760-EXIT          
A00775     END-PERFORM                                                  
A00775                                                                  
A00775     PERFORM 7770-CLOSE-ATTR-INCTV-DET THRU 7770-EXIT.            
P00165                                                                  
P00165     IF J1-LAST-ENERGY-BLOCK > 1                                  
P00165        MOVE ZEROES                TO WS-THERM-PRICE              
P00165     END-IF.                                                      
      *                                                                         
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00269*****************************************************************         
P00269* 5450-PROCESS-SEC-OFF-OPT.                                    **         
P00269*                                                              **         
P00269*****************************************************************         
P00269 5450-PROCESS-SEC-OFF-OPT.                                        
P00269                                                                  
A04362      ADD 1 TO WS-SEC-CNT.                                        
P00269      MOVE CI-OFFER-CD                TO                          
A04362                             WS-SEC-OFFER(WS-SEC-CNT).            
P00269      MOVE CI-OPTION-CD               TO                          
A04362                             WS-SEC-OPTION(WS-SEC-CNT).           
P00269      MOVE CI-VIEW-APPLY-CD           TO                          
A04362                            WS-SEC-VIEW-APPLY-CD(WS-SEC-CNT).     
P00269      MOVE WS-ACCESS-FLAG             TO                          
A04362                             WS-SEC-ACCESS-FL(WS-SEC-CNT).        
P00269                                                                  
P00269      PERFORM 7870-FETCH-SEC-OFF-OPT-CUR                          
P00269                                      THRU 7870-EXIT.             
P00269                                                                  
P00269      SET  WS-SEC-TAB-INDX            UP BY 1.                    
P00269*                                                                         
P00269 5450-EXIT.                                                       
P00269     EXIT.                                                        
P00269*                                                                         
P00269*****************************************************************         
P00269* 5460-CHECK-SECURE-OFFR-ACCESS.                               **         
P00269*                                                              **         
P00269*****************************************************************         
P00269*                                                                         
P00269 5460-CHECK-SECURE-OFFR-ACCESS.                                   
P00269                                                                  
P00269      MOVE 'N'                       TO WS-SECURE-OFFER-SW        
P00269      MOVE 'N'                       TO WS-USER-OFFR-ACCESS-SW    
P00269                                                                  
P00269      SET WS-SEC-TAB-INDX            TO 1                         
P00269                                                                  
P00269      SEARCH WS-SECURE-OFF-OPT-TABLE                              
P00269         AT END                                                   
P00269            CONTINUE                                              
P00269         WHEN WS-SEC-OFFER(WS-SEC-TAB-INDX)  = WS-CHECK-OFFER     
P00269          AND WS-SEC-OPTION(WS-SEC-TAB-INDX) = SPACES             
P00269          AND ( WS-SEC-VIEW-APPLY-CD(WS-SEC-TAB-INDX)             
P00269                                             = I-VIEW-APPLY-CD    
P00269              OR ( WS-SEC-VIEW-APPLY-CD(WS-SEC-TAB-INDX) = 'B'    
P00269                   AND ( I-VIEW-APPLY-CD = 'S'                    
P00269                      OR I-VIEW-APPLY-CD = 'P' ) ) )              
P00269              SET SECURE-OFFER            TO TRUE                 
P00269              IF WS-SEC-ACCESS-FL(WS-SEC-TAB-INDX) = 'Y'          
P00269                 SET USER-HAS-OFFR-ACCESS TO TRUE                 
P00269              END-IF                                              
P00269      END-SEARCH.                                                 
P00269*                                                                         
P00269 5460-EXIT.                                                       
P00269     EXIT.                                                        
P00269*                                                                         
P00269*                                                                         
P00269*****************************************************************         
P00269* 5470-CHECK-SECURE-OPTN-ACCESS.                               **         
P00269*                                                              **         
P00269*****************************************************************         
P00269 5470-CHECK-SECURE-OPTN-ACCESS.                                   
P00269                                                                  
P00269      MOVE 'N'                       TO WS-SECURE-OPTION-SW       
P00269      MOVE 'N'                       TO WS-USER-OPTN-ACCESS-SW    
P00269                                                                  
P00269      SET WS-SEC-TAB-INDX            TO 1                         
P00269                                                                  
P00269      SEARCH WS-SECURE-OFF-OPT-TABLE                              
P00269         AT END                                                   
P00269            CONTINUE                                              
P00269         WHEN ( ( WS-SEC-OFFER(WS-SEC-TAB-INDX)  = WS-CHECK-OFFER 
P00269            AND WS-SEC-OPTION(WS-SEC-TAB-INDX) = WS-CHECK-OPTION )
P00269           OR ( WS-SEC-OFFER(WS-SEC-TAB-INDX)  = SPACES           
P00269           AND WS-SEC-OPTION(WS-SEC-TAB-INDX) = WS-CHECK-OPTION ))
P00269           AND ( WS-SEC-VIEW-APPLY-CD(WS-SEC-TAB-INDX)            
P00269                                               = I-VIEW-APPLY-CD  
P00269              OR ( WS-SEC-VIEW-APPLY-CD(WS-SEC-TAB-INDX) = 'B'    
P00269                   AND ( I-VIEW-APPLY-CD = 'S'                    
P00269                      OR I-VIEW-APPLY-CD = 'P' ) ) )              
P00269              SET SECURE-OPTION           TO TRUE                 
P00269              IF WS-SEC-ACCESS-FL(WS-SEC-TAB-INDX) = 'Y'          
P00269                 SET USER-HAS-OPTN-ACCESS TO TRUE                 
P00269              END-IF                                              
P00269      END-SEARCH.                                                 
P00269*                                                                         
P00269 5470-EXIT.                                                       
P00269     EXIT.                                                        
P00269*                                                                         
      *****************************************************************         
      * 5500-PROCESS-ATTR-DET.                                       **         
      *                                                              **         
      *****************************************************************         
       5500-PROCESS-ATTR-DET.                                           
                                                                        
            MOVE G7-RT-ATTR-INCTV-TYPE       TO S-RT-ATTR-INCTV-TYPE    
            MOVE G7-RT-ATTR-INCTV-DESC       TO S-RT-ATTR-INCTV-DESC    
            MOVE HQ-ATTR-INCTV-SEQ-NO        TO S-ATTR-INCTV-SEQ-NO     
            MOVE HQ-DURATION-NO              TO S-DURATION-NO           
            MOVE HQ-ATTR-INCTV-VALUE         TO S-ATTR-INCTV-VALUE      
NEW680      MOVE SPACES                      TO S-FCTR-LONG-DESC-CRM    
                                                S-ATTR-INCTV-VAL-TX     
P00680      IF G7-RT-ATTR-INCTV-TYPE EQUAL 'PRICE DISCOUNT'             
P00680                                  OR 'CSC DISCOUNT'               
P00680         MOVE SF-FACTOR-TEXT           TO S-ATTR-INCTV-VAL-TX     
NEW680         MOVE SF-FACTOR-DESC           TO S-FCTR-LONG-DESC-CRM    
P00680      ELSE                                                        
               MOVE HQ-ATTR-INCTV-VAL-TX     TO S-ATTR-INCTV-VAL-TX     
P00680      END-IF                                                      
                                                                        
P680P2      IF G7-RT-ATTR-INCTV-TYPE EQUAL 'FIXED PRICE'                
P680P2         MOVE 'N'                      TO WS-MAX-OFFER-OPT-SW     
P680P2         IF WS-MAX-OFFER-OPTS-CTR > 0                             
P680P2            PERFORM VARYING WS-OPTION-INDX FROM 1 BY 1            
SCA006              UNTIL WS-OPTION-INDX > 10 OR 
SCA006                    MAX-OFFER-OPT-LOC OR 
                          WS-MAX-OFFER-OPT-CD (WS-OPTION-INDX)          
P680P2                                           EQUAL SPACES                   
P680P2               IF WS-MAX-OFFER-OPT-DUR-NO (WS-OPTION-INDX)        
P680P2                                           EQUAL S-DURATION-NO    
P680P2                  SET  MAX-OFFER-OPT-LOC                          
P680P2                                       TO TRUE                    
P680P2                  MOVE WS-MAX-OFFER-OPT-PRICE  (WS-OPTION-INDX)   
P680P2                                       TO S-MAX-OFFER-OPT-PRICE   
P680P2                  MOVE WS-PRC-NEGOTIATION-PARM                    
P680P2                                       TO S-PRICE-NEGOTIATION-PARM
P680P2               END-IF                                             
P680P2            END-PERFORM                                           
P680P2            IF WS-MAX-OFFER-OPT-SW = 'N'                          
P680P2               MOVE ZEROS              TO S-MAX-OFFER-OPT-PRICE   
P680P2                                          S-PRICE-NEGOTIATION-PARM
P680P2            END-IF                                                
P680P2         END-IF                                                   
P680P2      END-IF.                                                     
                                                                        
            IF I-INT-EXT-DATA-FL  = 'I'                                 
               PERFORM 8300-SEND-RESULT      THRU 8300-EXIT             
            ELSE                                                        
               PERFORM 8400-SEND-RESULT      THRU 8400-EXIT             
            END-IF                                                      
                                                                        
P680P2      MOVE ZEROS                    TO S-MAX-OFFER-OPT-PRICE      
P680P2                                       S-PRICE-NEGOTIATION-PARM.  
                                                                        
            PERFORM 7840-FETCH-ATTR-DET      THRU 7840-EXIT.            
      *                                                                         
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00680*****************************************************************         
P00680* 5600-PROCESS-DISCOUNTS.                                      **         
P00680*                                                              **         
P00680*****************************************************************         
P00680 5600-PROCESS-DISCOUNTS.                                          
P00680                                                                  
P00680     EVALUATE HQ-RT-ATTR-INCTV-TYPE                               
P00680                                                                  
P00680         WHEN 'PRICE DISCOUNT'                                    
P00680           EVALUATE WS-PRC-DSCNT-CTR                              
P00680               WHEN 1                                             
P00680                 MOVE SF-FACTOR-DESC TO S-THERM-PRC-DSCNT-A-DESC  
P00680                 MOVE HQ-ATTR-INCTV-VALUE                         
P00680                                     TO S-THERM-PRC-DSCNT-A-VAL   
P00680                 MOVE HQ-DURATION-NO TO S-THERM-PRC-DSCNT-A-DUR   
P00680               WHEN 2                                             
P00680                 MOVE SF-FACTOR-DESC TO S-THERM-PRC-DSCNT-B-DESC  
P00680                 MOVE HQ-ATTR-INCTV-VALUE                         
P00680                                     TO S-THERM-PRC-DSCNT-B-VAL   
P00680                 MOVE HQ-DURATION-NO TO S-THERM-PRC-DSCNT-B-DUR   
P00680               WHEN 3                                             
P00680                 MOVE SF-FACTOR-DESC TO S-THERM-PRC-DSCNT-C-DESC  
P00680                 MOVE HQ-ATTR-INCTV-VALUE                         
P00680                                     TO S-THERM-PRC-DSCNT-C-VAL   
P00680                 MOVE HQ-DURATION-NO TO S-THERM-PRC-DSCNT-C-DUR   
P00680               WHEN 4                                             
P00680                 MOVE SF-FACTOR-DESC TO S-THERM-PRC-DSCNT-D-DESC  
P00680                 MOVE HQ-ATTR-INCTV-VALUE                         
P00680                                     TO S-THERM-PRC-DSCNT-D-VAL   
P00680                 MOVE HQ-DURATION-NO TO S-THERM-PRC-DSCNT-D-DUR   
P00680               WHEN 5                                             
P00680                 MOVE SF-FACTOR-DESC TO S-THERM-PRC-DSCNT-E-DESC  
P00680                 MOVE HQ-ATTR-INCTV-VALUE                         
P00680                                     TO S-THERM-PRC-DSCNT-E-VAL   
P00680                 MOVE HQ-DURATION-NO TO S-THERM-PRC-DSCNT-E-DUR   
P00680               WHEN OTHER                                         
P00680                 CONTINUE                                         
P00680           END-EVALUATE                                           
P00680           ADD +1                    TO WS-PRC-DSCNT-CTR          
P00680                                                                  
P00680         WHEN 'CSC DISCOUNT'                                      
P00680           EVALUATE WS-CSC-DSCNT-CTR                              
P00680               WHEN 1                                             
P00680                 MOVE SF-FACTOR-DESC TO S-CSC-DSCNT-A-DESC        
P00680                 MOVE HQ-ATTR-INCTV-VALUE                         
P00680                                     TO S-CSC-DSCNT-A-VAL         
P00680                 MOVE HQ-DURATION-NO TO S-CSC-DSCNT-A-DUR         
P00680               WHEN 2                                             
P00680                 MOVE SF-FACTOR-DESC TO S-CSC-DSCNT-B-DESC        
P00680                 MOVE HQ-ATTR-INCTV-VALUE                         
P00680                                     TO S-CSC-DSCNT-B-VAL         
P00680                 MOVE HQ-DURATION-NO TO S-CSC-DSCNT-B-DUR         
P00680               WHEN 3                                             
P00680                 MOVE SF-FACTOR-DESC TO S-CSC-DSCNT-C-DESC        
P00680                 MOVE HQ-ATTR-INCTV-VALUE                         
P00680                                     TO S-CSC-DSCNT-C-VAL         
P00680                 MOVE HQ-DURATION-NO TO S-CSC-DSCNT-C-DUR         
P00680               WHEN 4                                             
P00680                 MOVE SF-FACTOR-DESC TO S-CSC-DSCNT-D-DESC        
P00680                 MOVE HQ-ATTR-INCTV-VALUE                         
P00680                                     TO S-CSC-DSCNT-D-VAL         
P00680                 MOVE HQ-DURATION-NO TO S-CSC-DSCNT-D-DUR         
P00680               WHEN 5                                             
P00680                 MOVE SF-FACTOR-DESC TO S-CSC-DSCNT-E-DESC        
P00680                 MOVE HQ-ATTR-INCTV-VALUE                         
P00680                                     TO S-CSC-DSCNT-E-VAL         
P00680                 MOVE HQ-DURATION-NO TO S-CSC-DSCNT-E-DUR         
P00680               WHEN OTHER                                         
P00680                 CONTINUE                                         
P00680           END-EVALUATE                                           
P00680           ADD +1                    TO WS-CSC-DSCNT-CTR          
P00680         WHEN OTHER                                               
P00680           CONTINUE                                               
P00680     END-EVALUATE.                                                
P00680                                                                  
P00680     PERFORM 7950-FETCH-DISCOUNT-CURSOR THRU 7950-EXIT.           
P00680*                                                                         
P00680 5600-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
P680P2*****************************************************************         
P680P2* 5700-GET-MAX-OFFER-OPTIONS.                                  **         
P680P2*****************************************************************         
P680P2 5700-GET-MAX-OFFER-OPTIONS.                                      
P680P2*                                                                         
P680P2     MOVE ZEROS                       TO WS-MAX-OFFER-OPTS-CTR.   
P680P2     MOVE 'N'                         TO WS-NO-MORE-TR-ROWS9.     
P680P2                                                                  
P680P2     INITIALIZE WS-MAX-OFFER-OPTIONS.                             
P680P2     SET WS-OPTION-INDX               TO 1.                       
P680P2                                                                  
P680P2     PERFORM 7970-OPEN-MAX-OFFER-CURSOR  THRU 7970-EXIT.          
P680P2                                                                  
P680P2     PERFORM 7980-FETCH-MAX-OFFER-CURSOR THRU 7980-EXIT.          
P680P2                                                                  
P680P2     PERFORM UNTIL NO-MORE-TR-ROWS9                               
P680P2                OR WS-MAX-OFFER-OPTS-CTR > 10                     
P680P2             MOVE E9-OPTION-CD         TO WS-MAX-OFFER-OPT-CD     
P680P2                                                  (WS-OPTION-INDX)
P680P2             MOVE HQ-FACTOR-ID         TO WS-MAX-OFFER-OPT-FCTR-ID
P680P2                                                  (WS-OPTION-INDX)
P680P2             MOVE HQ-DURATION-NO       TO WS-MAX-OFFER-OPT-DUR-NO 
P680P2                                                  (WS-OPTION-INDX)
P680P2             MOVE SA-FACTOR            TO WS-MAX-OFFER-OPT-PRICE  
P680P2                                                  (WS-OPTION-INDX)
P680P2             SET  WS-OPTION-INDX UP BY 1                          
P680P2             PERFORM 7980-FETCH-MAX-OFFER-CURSOR                  
P680P2                                         THRU 7980-EXIT           
P680P2     END-PERFORM.                                                 
P680P2                                                                  
P680P2     PERFORM 7990-CLOSE-MAX-OFFER-CURSOR THRU 7990-EXIT.          
P680P2*                                                                         
P680P2 5700-EXIT.                                                       
P680P2     EXIT.                                                        
P680P2*                                                                         
A00775*****************************************************************         
A00775* 5800-PROCESS-RATE-FCTRS.                                     **         
A00775*****************************************************************         
A00775 5800-PROCESS-RATE-FCTRS.                                         
A00775                                                                  
A00775     SET  WS-RATE-INDX                  TO 1.                     
A00775     SEARCH ARR-RATE-PLAN-NO VARYING WS-RATE-INDX                 
A00775         AT END                                                   
A00775            CONTINUE                                              
A00775       WHEN WS-RATE-INDX > WS-RATE-SPCL-FCTR-COUNT                
A00775            CONTINUE                                              
A00775       WHEN ARR-RATE-PLAN-NO (WS-RATE-INDX) = FI-RATE-PLAN-NO     
A00775            PERFORM VARYING WS-RATE-INDX FROM WS-RATE-INDX BY 1   
A00775              UNTIL WS-RATE-INDX > WS-RATE-SPCL-FCTR-COUNT        
A00775                 OR ARR-RATE-PLAN-NO (WS-RATE-INDX) NOT =         
A00775                    FI-RATE-PLAN-NO                               
A00775                    PERFORM 5850-ADJ-RATE-FCTRS THRU 5850-EXIT    
P614FX                    IF (I-CALL-TYPE = 'WEB' OR 'ECS')             
I01095                      AND FI-OPT-CALC-TYPE-CD = 'VP'              
I01095                      AND ARR-FACTOR-ID (WS-FCTRID-INDX)          
I01095                                                 = 'VARPRICE'     
I01095                       PERFORM 5910-GET-RATE-DATES THRU 5910-EXIT 
I01095                    END-IF                                        
A00775            END-PERFORM                                           
A00775     END-SEARCH.                                                  
A00775*                                                                         
A00775 5800-EXIT.                                                       
A00775       EXIT.                                                      
A00775*                                                                         
A00775*****************************************************************         
A00775* 5850-ADJ-RATE-FCTRS.                                         **         
A00775*****************************************************************         
A00775 5850-ADJ-RATE-FCTRS.                                             
A00775                                                                  
A00775     INITIALIZE  WS-ADJ-AMT-VAR-1.                                
A00775                                                                  
A00775     SET WS-FCTRID-INDX,WS-FCTTYP-INDX,                           
A00775         WS-ADJ-ELEM-INDX,WS-FACTOR-INDX  TO WS-RATE-INDX.        
A00775                                                                  
A00775     IF ARR-FACTOR-TYPE (WS-FCTTYP-INDX) = 'A'                    
A00775        MOVE ARR-ADJUST-ELEMENT (WS-ADJ-ELEM-INDX) TO             
A00775                                     WS-BC-CODE-ADJUST-TYPE       
A00775                                                                  
A00775        EVALUATE TRUE                                             
A00775            WHEN ADD-TO-NET-RATE                                  
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-ADD-AMT1     
A00775            WHEN SUB-FROM-NET-RATE                                
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-SUB-AMT1     
A00775            WHEN REPL-NET-RATE                                    
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-REPL-AMT1    
A00775            WHEN ADD-TO-BFC-CHARGE                                
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-ADD-CSC-AMT1 
A00775            WHEN SUBTRACT-FROM-BFC-CHARGE                         
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-SUB-CSC-AMT1 
A00775            WHEN REPLACE-BFC-CHARGE                               
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-REPL-CSC-AMT1
A00775        END-EVALUATE                                              
A00775                                                                  
A00775        IF WS-REPL-AMT1 NOT EQUAL ZERO                            
A00775           MOVE WS-REPL-AMT1                 TO WS-THERM-PRICE    
A00775        END-IF                                                    
A00775        IF WS-ADD-AMT1 NOT EQUAL  ZERO                            
A00775           COMPUTE WS-THERM-PRICE = WS-THERM-PRICE + WS-ADD-AMT1  
A00775        END-IF                                                    
A00775        IF WS-SUB-AMT1 NOT EQUAL  ZERO                            
A00775           COMPUTE WS-THERM-PRICE = WS-THERM-PRICE - WS-SUB-AMT1  
A00775        END-IF                                                    
A00775        IF WS-REPL-CSC-AMT1 NOT EQUAL ZERO                        
A00775           MOVE WS-REPL-CSC-AMT1             TO WS-CSC-AMT        
A00775        END-IF                                                    
A00775        IF WS-ADD-CSC-AMT1 NOT EQUAL  ZERO                        
A00775           COMPUTE WS-CSC-AMT     = WS-CSC-AMT + WS-ADD-CSC-AMT1  
A00775        END-IF                                                    
A00775        IF WS-SUB-CSC-AMT1 NOT EQUAL  ZERO                        
A00775           COMPUTE WS-CSC-AMT     = WS-CSC-AMT - WS-SUB-CSC-AMT1  
A00775        END-IF                                                    
A00775     END-IF.                                                      
A00775*                                                                         
A00775 5850-EXIT.                                                       
A00775       EXIT.                                                      
A00775*                                                                         
A00775*****************************************************************         
A00775* 5900-PROCESS-SPCL-FCTRS.                                     **         
A00775*****************************************************************         
A00775 5900-PROCESS-SPCL-FCTRS.                                         
A00775                                                                  
A00775     SET  WS-RATE-INDX       TO 1.                                
A00775     SEARCH ARR-RATE-PLAN-NO VARYING WS-RATE-INDX                 
A00775         AT END                                                   
A00775            CONTINUE                                              
A00775       WHEN WS-RATE-INDX > WS-RATE-SPCL-FCTR-COUNT                
A00775            CONTINUE                                              
A00775       WHEN ARR-RATE-PLAN-NO (WS-RATE-INDX) = FI-RATE-PLAN-NO     
A00775            PERFORM VARYING WS-RATE-INDX FROM WS-RATE-INDX BY 1   
A00775              UNTIL WS-RATE-INDX > WS-RATE-SPCL-FCTR-COUNT        
A00775                 OR ARR-RATE-PLAN-NO (WS-RATE-INDX) NOT =         
A00775                    FI-RATE-PLAN-NO                               
A00775                    PERFORM 5950-ADJ-SPCL-FCTRS THRU 5950-EXIT    
P614FX                    IF (I-CALL-TYPE = 'WEB' OR 'ECS')             
I01095                      AND HQ-PRIMRY-OPT-ATTR-FL = 'Y'             
I01095                      AND ARR-FACTOR-ID (WS-FCTRID-INDX)          
I01095                                                 = HQ-FACTOR-ID   
I01095                       PERFORM 5910-GET-RATE-DATES THRU 5910-EXIT 
I01095                    END-IF                                        
A00775            END-PERFORM                                           
A00775     END-SEARCH.                                                  
A00775*                                                                         
A00775 5900-EXIT.                                                       
A00775       EXIT.                                                      
I01095*                                                                         
I01095*****************************************************************         
I01095* 5910-GET-RATE-DATES.                                         **         
I01095*****************************************************************         
I01095 5910-GET-RATE-DATES.                                             
I01095                                                                  
I01095     SET WS-INT-DISP-INDX        TO WS-RATE-INDX                  
I01095                                                                  
I01095     MOVE ARR-INT-DISP-START-TS (WS-INT-DISP-INDX)                
I01095                                 TO WS-TIME-STAMP                 
I01095     MOVE WS-TIME-STAMP (1:10)   TO WS-RATE-EFFECTIVE-DT          
I01095                                    WS-DUMMY-DATE.                
I01095     PERFORM 7900-CALC-EXP-DATE           THRU 7900-EXIT.         
I01095     MOVE WS-DUMMY-DATE          TO WS-RATE-EXPIRATION-DATE.      
I01095     MOVE WS-CRM-RT-CHG-DAY-CHAR(3:2)                             
I01095                                 TO WS-RATE-EXPIRATION-DD.        
I01095                                                                  
I01095     IF FI-OPT-CALC-TYPE-CD = 'VP'                                
I01095       AND ARR-FACTOR-ID (WS-FCTRID-INDX) = 'VARPRICE'            
I01095        MOVE 0                   TO WS-EXIT-FEE                   
I01095     ELSE                                                         
I01095        PERFORM 7910-SELECT-EXIT-FEE      THRU 7910-EXIT          
I01095     END-IF.                                                      
I01095                                                                  
I01095 5910-EXIT.                                                       
I01095     EXIT.                                                        
A00775*                                                                         
A00775*****************************************************************         
A00775* 5950-ADJ-SPCL-FCTRS.                                         **         
A00775*****************************************************************         
A00775 5950-ADJ-SPCL-FCTRS.                                             
A00775                                                                  
A00775     INITIALIZE  WS-ADJ-AMT-VAR-2.                                
A00775                                                                  
A00775     SET WS-FCTRID-INDX,WS-FCTTYP-INDX,                           
A00775         WS-ADJ-ELEM-INDX,WS-FACTOR-INDX  TO WS-RATE-INDX.        
A00775                                                                  
A00775     IF (ARR-FACTOR-ID (WS-FCTRID-INDX)    = HQ-FACTOR-ID) AND    
A00775        (ARR-FACTOR-TYPE (WS-FCTTYP-INDX)  = 'B' OR 'V' OR 'F')   
A00775        MOVE ARR-ADJUST-ELEMENT (WS-ADJ-ELEM-INDX) TO             
A00775                                     WS-BC-CODE-ADJUST-TYPE       
A00775                                                                  
A00775        EVALUATE TRUE                                             
A00775          WHEN ADD-TO-NET-RATE                                    
A00775            IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-ADD-AMT2     
A00775            ELSE                                                  
A00775               ADD HQ-ATTR-INCTV-VALUE         TO WS-ADD-AMT2     
A00775            END-IF                                                
A00775          WHEN SUB-FROM-NET-RATE                                  
A00775            IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-SUB-AMT2     
A00775            ELSE                                                  
A00775               ADD HQ-ATTR-INCTV-VALUE         TO WS-SUB-AMT2     
A00775            END-IF                                                
A00775          WHEN REPL-NET-RATE                                      
A00775            IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-REPL-AMT2    
A00775            ELSE                                                  
A00775               ADD HQ-ATTR-INCTV-VALUE         TO WS-REPL-AMT2    
A00775            END-IF                                                
A00775          WHEN ADD-TO-BFC-CHARGE                                  
A00775            IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-ADD-CSC-AMT2 
A00775            ELSE                                                  
A00775               ADD HQ-ATTR-INCTV-VALUE         TO WS-ADD-CSC-AMT2 
A00775            END-IF                                                
A00775          WHEN SUBTRACT-FROM-BFC-CHARGE                           
A00775            IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-SUB-CSC-AMT2 
A00775            ELSE                                                  
A00775               ADD HQ-ATTR-INCTV-VALUE         TO WS-SUB-CSC-AMT2 
A00775            END-IF                                                
A00775          WHEN REPLACE-BFC-CHARGE                                 
A00775            IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
A00775               ADD ARR-FACTOR (WS-FACTOR-INDX) TO WS-REPL-CSC-AMT2
A00775            ELSE                                                  
A00775               ADD HQ-ATTR-INCTV-VALUE         TO WS-REPL-CSC-AMT2
A00775            END-IF                                                
P00680          WHEN ADD-TO-COMPONENT-AMT                               
P00680            IF HQ-RT-ATTR-INCTV-TYPE  EQUAL 'PRICE DISCOUNT'      
P00680               MOVE 'Y'                        TO WS-PRC-DSCNT-FL 
P00614               IF I-CALL-TYPE = 'WEB' OR 'ECS'                    
P00680                  IF HQ-ATTR-INCTV-VALUE EQUAL ZERO               
P00680                     ADD ARR-FACTOR (WS-FACTOR-INDX)              
P00680                                               TO WS-ADD-AMT2     
P00680                                                  WS-TOT-PRC-DSCNT
P00680                  ELSE                                            
P00680                     ADD HQ-ATTR-INCTV-VALUE   TO WS-ADD-AMT2     
P00680                                                  WS-TOT-PRC-DSCNT
P00680                  END-IF                                          
P00680               ELSE                                               
P00680                  IF HQ-ATTR-INCTV-VALUE EQUAL ZERO               
P00680                     ADD ARR-FACTOR (WS-FACTOR-INDX)              
P00680                                               TO WS-TOT-PRC-DSCNT
P00680                  ELSE                                            
P00680                     ADD HQ-ATTR-INCTV-VALUE   TO WS-TOT-PRC-DSCNT
P00680                  END-IF                                          
P00680               END-IF                                             
P00680            END-IF                                                
P00680            IF HQ-RT-ATTR-INCTV-TYPE  EQUAL 'CSC DISCOUNT'        
P00680               MOVE 'Y'                        TO WS-CSC-DSCNT-FL 
P00614               IF I-CALL-TYPE = 'WEB' OR 'ECS'                    
P00680                  IF HQ-ATTR-INCTV-VALUE EQUAL ZERO               
P00680                     ADD ARR-FACTOR (WS-FACTOR-INDX)              
P00680                                               TO WS-ADD-CSC-AMT2 
P00680                                                  WS-TOT-CSC-DSCNT
P00680                  ELSE                                            
P00680                     ADD HQ-ATTR-INCTV-VALUE   TO WS-ADD-CSC-AMT2 
P00680                                                  WS-TOT-CSC-DSCNT
P00680                  END-IF                                          
P00680               ELSE                                               
P00680                  IF HQ-ATTR-INCTV-VALUE EQUAL ZERO               
P00680                     ADD ARR-FACTOR (WS-FACTOR-INDX)              
P00680                                               TO WS-TOT-CSC-DSCNT
P00680                  ELSE                                            
P00680                     ADD HQ-ATTR-INCTV-VALUE   TO WS-TOT-CSC-DSCNT
P00680                  END-IF                                          
P00680               END-IF                                             
P00680            END-IF                                                
A00775        END-EVALUATE                                              
A00775                                                                  
A00775        IF WS-REPL-AMT2 NOT EQUAL ZERO                            
A00775           MOVE WS-REPL-AMT2          TO WS-THERM-PRICE           
A00775        END-IF                                                    
A00775        IF WS-ADD-AMT2 NOT EQUAL  ZERO                            
A00775           COMPUTE WS-THERM-PRICE = WS-THERM-PRICE + WS-ADD-AMT2  
A00775        END-IF                                                    
A00775        IF WS-SUB-AMT2 NOT EQUAL  ZERO                            
A00775           COMPUTE WS-THERM-PRICE = WS-THERM-PRICE - WS-SUB-AMT2  
A00775        END-IF                                                    
A00775        IF WS-REPL-CSC-AMT2 NOT EQUAL ZERO                        
A00775           MOVE WS-REPL-CSC-AMT2      TO WS-CSC-AMT               
A00775        END-IF                                                    
A00775        IF WS-ADD-CSC-AMT2 NOT EQUAL  ZERO                        
A00775           COMPUTE WS-CSC-AMT     = WS-CSC-AMT + WS-ADD-CSC-AMT2  
A00775        END-IF                                                    
A00775        IF WS-SUB-CSC-AMT2 NOT EQUAL  ZERO                        
A00775           COMPUTE WS-CSC-AMT     = WS-CSC-AMT - WS-SUB-CSC-AMT2  
A00775        END-IF                                                    
A00775     END-IF.                                                      
A00775*                                                                         
A00775 5950-EXIT.                                                       
A00775       EXIT.                                                      
      *                                                                         
      *****************************************************************         
      **  7000-SELECT-MKT-TIER-DET                                   **         
      *****************************************************************         
       7000-SELECT-MKT-TIER-DET.                                        
                                                                        
           EXEC SQL                                                     
                SELECT  IG.MKT_TIER_RANKING                             
                       ,IG.MKT_TIER_START_DT                            
                       ,IG.MKT_TIER_END_DT                              
                       ,IG.MKT_TIER_DESC                                
                       ,IG.TIER_OFFER_VIEW                              
                                                                        
                  INTO  :IG-MKT-TIER-RANKING                            
                       ,:IG-MKT-TIER-START-DT                           
                       ,:IG-MKT-TIER-END-DT                             
                       ,:IG-MKT-TIER-DESC                               
                       ,:IG-TIER-OFFER-VIEW                             
                                                                        
                  FROM CRM_MKT_TIER        IG WITH(READUNCOMMITTED)             
                                                                        
                 WHERE IG.TIER_CUST_STAT_CD  =  :IG-TIER-CUST-STAT-CD   
                   AND IG.TIER_ACCT_TYPE_CD  =  :IG-TIER-ACCT-TYPE-CD   
                   AND IG.MKT_TIER_RANKING   =  :IG-MKT-TIER-RANKING    
P1137C             AND IG.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )           
P1137C             AND IG.MKT_TIER_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )           
                   AND IG.COMPANY_NO         =  :IG-COMPANY-NO          
                                                                 
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  IG.MKT_TIER_RANKING                                     
MFA-TR*                ,IG.MKT_TIER_START_DT                                    
MFA-TR*                ,IG.MKT_TIER_END_DT                                      
MFA-TR*                ,IG.MKT_TIER_DESC                                        
MFA-TR*                ,IG.TIER_OFFER_VIEW                                      
MFA-TR*                                                                         
MFA-TR*           INTO  :IG-MKT-TIER-RANKING                                    
MFA-TR*                ,:IG-MKT-TIER-START-DT                                   
MFA-TR*                ,:IG-MKT-TIER-END-DT                                     
MFA-TR*                ,:IG-MKT-TIER-DESC                                       
MFA-TR*                ,:IG-TIER-OFFER-VIEW                                     
MFA-TR*                                                                         
MFA-TR*           FROM CRM_MKT_TIER        IG                                   
MFA-TR*                                                                         
MFA-TR*          WHERE IG.TIER_CUST_STAT_CD  =  :IG-TIER-CUST-STAT-CD           
MFA-TR*            AND IG.TIER_ACCT_TYPE_CD  =  :IG-TIER-ACCT-TYPE-CD           
MFA-TR*            AND IG.MKT_TIER_RANKING   =  :IG-MKT-TIER-RANKING            
MFA-TR*            AND IG.MKT_TIER_START_DT  <= :WS-CURR-DATE                   
MFA-TR*            AND IG.MKT_TIER_END_DT    >= :WS-CURR-DATE                   
MFA-TR*            AND IG.COMPANY_NO         =  :IG-COMPANY-NO                  
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
GOPI       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CRM_MKT_TIER'        TO TABLE-1                     
              MOVE 'TIER_CUST_STAT_CD'   TO TABLE-ELEMENT-1             
              MOVE 'TIER_ACCT_TYPE_CD'   TO TABLE-ELEMENT-2             
              MOVE 'MKT_TIER_RANKING'    TO TABLE-ELEMENT-3             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-4             
              MOVE IG-TIER-CUST-STAT-CD  TO HOSTVAR-ELEMENT-1           
              MOVE IG-TIER-ACCT-TYPE-CD  TO HOSTVAR-ELEMENT-2           
              MOVE IG-MKT-TIER-RANKING   TO HOSTVAR-ELEMENT-3           
              MOVE IG-COMPANY-NO         TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7005-SELECT-DFLT-MKT-TIER                                  **         
      *****************************************************************         
       7005-SELECT-DFLT-MKT-TIER.                                       
                                                                        
           EXEC SQL                                                     
                SELECT  IG.MKT_TIER_RANKING                             
                       ,IG.MKT_TIER_START_DT                            
                       ,IG.MKT_TIER_END_DT                              
                       ,IG.MKT_TIER_DESC                                
                       ,IG.TIER_OFFER_VIEW                              
                                                                        
                  INTO  :IG-MKT-TIER-RANKING                            
                       ,:IG-MKT-TIER-START-DT                           
                       ,:IG-MKT-TIER-END-DT                             
                       ,:IG-MKT-TIER-DESC                               
                       ,:IG-TIER-OFFER-VIEW                             
                                                                        
                  FROM CRM_MKT_TIER        IG WITH(READUNCOMMITTED)             
                                                                        
                 WHERE IG.TIER_CUST_STAT_CD  =  :IG-TIER-CUST-STAT-CD   
                   AND IG.TIER_ACCT_TYPE_CD  =  :IG-TIER-ACCT-TYPE-CD   
                   AND IG.CUST_ACCT_DEFLT_FL =   'Y'                    
P1137C             AND IG.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )           
P1137C             AND IG.MKT_TIER_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )           
                   AND IG.COMPANY_NO         =  :IG-COMPANY-NO          
                                                                 
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  IG.MKT_TIER_RANKING                                     
MFA-TR*                ,IG.MKT_TIER_START_DT                                    
MFA-TR*                ,IG.MKT_TIER_END_DT                                      
MFA-TR*                ,IG.MKT_TIER_DESC                                        
MFA-TR*                ,IG.TIER_OFFER_VIEW                                      
MFA-TR*                                                                         
MFA-TR*           INTO  :IG-MKT-TIER-RANKING                                    
MFA-TR*                ,:IG-MKT-TIER-START-DT                                   
MFA-TR*                ,:IG-MKT-TIER-END-DT                                     
MFA-TR*                ,:IG-MKT-TIER-DESC                                       
MFA-TR*                ,:IG-TIER-OFFER-VIEW                                     
MFA-TR*                                                                         
MFA-TR*           FROM CRM_MKT_TIER        IG                                   
MFA-TR*                                                                         
MFA-TR*          WHERE IG.TIER_CUST_STAT_CD  =  :IG-TIER-CUST-STAT-CD           
MFA-TR*            AND IG.TIER_ACCT_TYPE_CD  =  :IG-TIER-ACCT-TYPE-CD           
MFA-TR*            AND IG.CUST_ACCT_DEFLT_FL =   'Y'                            
MFA-TR*            AND IG.MKT_TIER_START_DT  <= :WS-CURR-DATE                   
MFA-TR*            AND IG.MKT_TIER_END_DT    >= :WS-CURR-DATE                   
MFA-TR*            AND IG.COMPANY_NO         =  :IG-COMPANY-NO                  
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7005                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
P00614     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7005'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CRM_MKT_TIER'        TO TABLE-1                     
              MOVE 'TIER_CUST_STAT_CD'   TO TABLE-ELEMENT-1             
              MOVE 'TIER_ACCT_TYPE_CD'   TO TABLE-ELEMENT-2             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE IG-TIER-CUST-STAT-CD  TO HOSTVAR-ELEMENT-1           
              MOVE IG-TIER-ACCT-TYPE-CD  TO HOSTVAR-ELEMENT-2           
              MOVE IG-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7010-CRMCHK-ACTV-PROMO                                     **         
      *****************************************************************         
       7010-CRMCHK-ACTV-PROMO.                                          
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                                                                        
                  INTO :WS-CRMACTV-PROMO-YES                            
                                                                        
                  FROM CRM_MKT_PROMOTION   KM WITH(READUNCOMMITTED)             
DT0519                ,CRM_OFF_MKT_TIER    DU WITH(READUNCOMMITTED)             
                                                                        
                 WHERE KM.PROMO_CD       =  :I-PROMO-CD                 
                   AND KM.COMPANY_NO     =  :KM-COMPANY-NO              
P1137C             AND KM.PROMO_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )               
P1137C             AND KM.PROMO_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )               
P1137C             AND KM.PROMO_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P1137C             AND KM.PROMO_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )       
P00473             AND KM.PROC_STATUS_CD     = 'AC'                     
DT0519             AND DU.OFFER_CD           =  KM.OFFER_CD             
DT0519             AND DU.COMPANY_NO         =  KM.COMPANY_NO           
DT0519             AND DU.TIER_CUST_STAT_CD  =  :DU-TIER-CUST-STAT-CD   
DT0519             AND DU.TIER_ACCT_TYPE_CD  =  :DU-TIER-ACCT-TYPE-CD   
P1137C             AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P1137C             AND DU.OFF_TIER_VEND_TS  >=  CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473             AND DU.PROC_STATUS_CD     = 'AC'                     
DT0519                                       
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*                                                                         
MFA-TR*           INTO :WS-CRMACTV-PROMO-YES                                    
MFA-TR*                                                                         
MFA-TR*           FROM CRM_MKT_PROMOTION   KM                                   
MFA-TR*               ,CRM_OFF_MKT_TIER    DU                                   
MFA-TR*                                                                         
MFA-TR*          WHERE KM.PROMO_CD       =  :I-PROMO-CD                         
MFA-TR*            AND KM.COMPANY_NO     =  :KM-COMPANY-NO                      
MFA-TR*            AND KM.PROMO_START_DT <= :WS-CURR-DATE                       
MFA-TR*            AND KM.PROMO_END_DT   >= :WS-CURR-DATE                       
MFA-TR*            AND KM.PROMO_VSTART_TS   <= :WS-CURR-TIMESTAMP               
MFA-TR*            AND KM.PROMO_VEND_TS     >= :WS-CURR-TIMESTAMP               
MFA-TR*            AND KM.PROC_STATUS_CD     = 'AC'                             
MFA-TR*            AND DU.OFFER_CD           =  KM.OFFER_CD                     
MFA-TR*            AND DU.COMPANY_NO         =  KM.COMPANY_NO                   
MFA-TR*            AND DU.TIER_CUST_STAT_CD  =  :DU-TIER-CUST-STAT-CD           
MFA-TR*            AND DU.TIER_ACCT_TYPE_CD  =  :DU-TIER-ACCT-TYPE-CD           
MFA-TR*            AND DU.OFF_TIER_VSTART_TS <= :WS-CURR-TIMESTAMP              
MFA-TR*            AND DU.OFF_TIER_VEND_TS  >=  :WS-CURR-TIMESTAMP              
MFA-TR*            AND DU.PROC_STATUS_CD     = 'AC'                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CRM_MKT_PROMOTION'   TO TABLE-1                     
DT0519        MOVE 'CRM_OFF_MKT_TIER'    TO TABLE-2                     
              MOVE 'PROMO_CD'            TO TABLE-ELEMENT-1             
DT0519        MOVE 'TIER_CUST_STAT_CD'   TO TABLE-ELEMENT-2             
DT0519        MOVE 'TIER_ACCT_TYPE_CD'   TO TABLE-ELEMENT-3             
              MOVE I-PROMO-CD            TO HOSTVAR-ELEMENT-1           
DT0519        MOVE DU-TIER-CUST-STAT-CD  TO HOSTVAR-ELEMENT-2           
DT0519        MOVE DU-TIER-ACCT-TYPE-CD  TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7020-CRMCHK-EXPI-PROMO                                     **         
      *****************************************************************         
       7020-CRMCHK-EXPI-PROMO.                                          
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) KM.REPLACMNT_PROMO_CD                           
                                                                        
                  INTO  :KM-REPLACMNT-PROMO-CD                          
                                                                        
                  FROM CRM_MKT_PROMOTION   KM WITH(READUNCOMMITTED)             
DT0519                ,CRM_OFF_MKT_TIER    DU WITH(READUNCOMMITTED)             
                                                                        
                 WHERE KM.PROMO_CD            = :I-PROMO-CD             
                   AND KM.COMPANY_NO          = :KM-COMPANY-NO          
P1137C             AND KM.PROMO_VSTART_TS    <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P1137C             AND KM.PROMO_VEND_TS      >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473             AND KM.PROC_STATUS_CD      = 'AC'                    
DT0519             AND DU.OFFER_CD            = KM.OFFER_CD             
DT0519             AND DU.COMPANY_NO          = KM.COMPANY_NO           
DT0519             AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD   
DT0519             AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD   
P1137C             AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P1137C             AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473             AND DU.PROC_STATUS_CD      = 'AC'                    
                                             
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  KM.REPLACMNT_PROMO_CD                                   
MFA-TR*                                                                         
MFA-TR*           INTO  :KM-REPLACMNT-PROMO-CD                                  
MFA-TR*                                                                         
MFA-TR*           FROM CRM_MKT_PROMOTION   KM                                   
MFA-TR*               ,CRM_OFF_MKT_TIER    DU                                   
MFA-TR*                                                                         
MFA-TR*          WHERE KM.PROMO_CD            = :I-PROMO-CD                     
MFA-TR*            AND KM.COMPANY_NO          = :KM-COMPANY-NO                  
MFA-TR*            AND KM.PROMO_VSTART_TS    <= :WS-CURR-TIMESTAMP              
MFA-TR*            AND KM.PROMO_VEND_TS      >= :WS-CURR-TIMESTAMP              
MFA-TR*            AND KM.PROC_STATUS_CD      = 'AC'                            
MFA-TR*            AND DU.OFFER_CD            = KM.OFFER_CD                     
MFA-TR*            AND DU.COMPANY_NO          = KM.COMPANY_NO                   
MFA-TR*            AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD           
MFA-TR*            AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD           
MFA-TR*            AND DU.OFF_TIER_VSTART_TS <= :WS-CURR-TIMESTAMP              
MFA-TR*            AND DU.OFF_TIER_VEND_TS   >= :WS-CURR-TIMESTAMP              
MFA-TR*            AND DU.PROC_STATUS_CD      = 'AC'                            
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CRM_MKT_PROMOTION'   TO TABLE-1                     
              MOVE 'CRM_OFF_MKT_TIER'    TO TABLE-2                     
              MOVE 'PROMO_CD'            TO TABLE-ELEMENT-1             
DT0519        MOVE 'TIER_CUST_STAT_CD'   TO TABLE-ELEMENT-2             
DT0519        MOVE 'TIER_ACCT_TYPE_CD'   TO TABLE-ELEMENT-3             
              MOVE I-PROMO-CD            TO HOSTVAR-ELEMENT-1           
DT0519        MOVE DU-TIER-CUST-STAT-CD  TO HOSTVAR-ELEMENT-2           
DT0519        MOVE DU-TIER-ACCT-TYPE-CD  TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7060-WEBCHK-ACTV-PROMO                                     **         
      *****************************************************************         
       7060-WEBCHK-ACTV-PROMO.                                          
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                                                                        
                  INTO :WS-WEBACTV-PROMO-YES                            
                                                                        
                  FROM CRM_MKT_PROMOTION   KM WITH(READUNCOMMITTED)             
                      ,CRM_OFF_MKT_TIER    DU WITH(READUNCOMMITTED)             
                                                                        
                 WHERE KM.PROMO_CD            = :I-PROMO-CD             
                   AND KM.COMPANY_NO          = :KM-COMPANY-NO          
P1137C             AND KM.PROMO_START_DT     <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )           
P1137C             AND KM.PROMO_END_DT       >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )           
P1137C             AND KM.PROMO_VSTART_TS    <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P1137C             AND KM.PROMO_VEND_TS      >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473             AND KM.PROC_STATUS_CD      = 'AC'                    
                   AND DU.OFFER_CD            = KM.OFFER_CD             
                   AND DU.COMPANY_NO          = KM.COMPANY_NO           
                   AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD   
                   AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD   
P1137C             AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P1137C             AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473             AND DU.PROC_STATUS_CD      = 'AC'                    
                                             
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*                                                                         
MFA-TR*           INTO :WS-WEBACTV-PROMO-YES                                    
MFA-TR*                                                                         
MFA-TR*           FROM CRM_MKT_PROMOTION   KM                                   
MFA-TR*               ,CRM_OFF_MKT_TIER    DU                                   
MFA-TR*                                                                         
MFA-TR*          WHERE KM.PROMO_CD            = :I-PROMO-CD                     
MFA-TR*            AND KM.COMPANY_NO          = :KM-COMPANY-NO                  
MFA-TR*            AND KM.PROMO_START_DT     <= :WS-CURR-DATE                   
MFA-TR*            AND KM.PROMO_END_DT       >= :WS-CURR-DATE                   
MFA-TR*            AND KM.PROMO_VSTART_TS    <= :WS-CURR-TIMESTAMP              
MFA-TR*            AND KM.PROMO_VEND_TS      >= :WS-CURR-TIMESTAMP              
MFA-TR*            AND KM.PROC_STATUS_CD      = 'AC'                            
MFA-TR*            AND DU.OFFER_CD            = KM.OFFER_CD                     
MFA-TR*            AND DU.COMPANY_NO          = KM.COMPANY_NO                   
MFA-TR*            AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD           
MFA-TR*            AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD           
MFA-TR*            AND DU.OFF_TIER_VSTART_TS <= :WS-CURR-TIMESTAMP              
MFA-TR*            AND DU.OFF_TIER_VEND_TS   >= :WS-CURR-TIMESTAMP              
MFA-TR*            AND DU.PROC_STATUS_CD      = 'AC'                            
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7060                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CRM_MKT_PROMOTION'   TO TABLE-1                     
              MOVE 'CRM_OFF_MKT_TIER'    TO TABLE-2                     
              MOVE 'PROMO_CD'            TO TABLE-ELEMENT-1             
              MOVE 'TIER_CUST_STAT_CD'   TO TABLE-ELEMENT-2             
              MOVE 'TIER_ACCT_TYPE_CD'   TO TABLE-ELEMENT-3             
              MOVE I-PROMO-CD            TO HOSTVAR-ELEMENT-1           
              MOVE DU-TIER-CUST-STAT-CD  TO HOSTVAR-ELEMENT-2           
              MOVE DU-TIER-ACCT-TYPE-CD  TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7070-WEBCHK-EXPI-PROMO                                     **         
      *****************************************************************         
       7070-WEBCHK-EXPI-PROMO.                                          
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) KM.REPLACMNT_PROMO_CD                           
                                                                        
                  INTO  :KM-REPLACMNT-PROMO-CD                          
                                                                        
                  FROM CRM_MKT_PROMOTION   KM WITH(READUNCOMMITTED)             
                      ,CRM_OFF_MKT_TIER    DU WITH(READUNCOMMITTED)             
                                                                        
                 WHERE KM.PROMO_CD           =  :I-PROMO-CD             
                   AND KM.COMPANY_NO         =  :KM-COMPANY-NO          
P1137C             AND KM.PROMO_VSTART_TS    <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P1137C             AND KM.PROMO_VEND_TS      >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473             AND KM.PROC_STATUS_CD      = 'AC'                    
                   AND DU.OFFER_CD           =  KM.OFFER_CD             
                   AND DU.COMPANY_NO         =  KM.COMPANY_NO           
                   AND DU.TIER_CUST_STAT_CD  =  :DU-TIER-CUST-STAT-CD   
                   AND DU.TIER_ACCT_TYPE_CD  =  :DU-TIER-ACCT-TYPE-CD   
P1137C             AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P1137C             AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )      
P00473             AND DU.PROC_STATUS_CD      = 'AC'                    
                                             
A04362                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  KM.REPLACMNT_PROMO_CD                                   
MFA-TR*                                                                         
MFA-TR*           INTO  :KM-REPLACMNT-PROMO-CD                                  
MFA-TR*                                                                         
MFA-TR*           FROM CRM_MKT_PROMOTION   KM                                   
MFA-TR*               ,CRM_OFF_MKT_TIER    DU                                   
MFA-TR*                                                                         
MFA-TR*          WHERE KM.PROMO_CD           =  :I-PROMO-CD                     
MFA-TR*            AND KM.COMPANY_NO         =  :KM-COMPANY-NO                  
MFA-TR*            AND KM.PROMO_VSTART_TS    <= :WS-CURR-TIMESTAMP              
MFA-TR*            AND KM.PROMO_VEND_TS      >= :WS-CURR-TIMESTAMP              
MFA-TR*            AND KM.PROC_STATUS_CD      = 'AC'                            
MFA-TR*            AND DU.OFFER_CD           =  KM.OFFER_CD                     
MFA-TR*            AND DU.COMPANY_NO         =  KM.COMPANY_NO                   
MFA-TR*            AND DU.TIER_CUST_STAT_CD  =  :DU-TIER-CUST-STAT-CD           
MFA-TR*            AND DU.TIER_ACCT_TYPE_CD  =  :DU-TIER-ACCT-TYPE-CD           
MFA-TR*            AND DU.OFF_TIER_VSTART_TS <= :WS-CURR-TIMESTAMP              
MFA-TR*            AND DU.OFF_TIER_VEND_TS   >= :WS-CURR-TIMESTAMP              
MFA-TR*            AND DU.PROC_STATUS_CD      = 'AC'                            
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CRM_MKT_PROMOTION'   TO TABLE-1                     
              MOVE 'CRM_OFF_MKT_TIER'    TO TABLE-2                     
              MOVE 'PROMO_CD'            TO TABLE-ELEMENT-1             
              MOVE 'TIER_CUST_STAT_CD'   TO TABLE-ELEMENT-2             
              MOVE 'TIER_ACCT_TYPE_CD'   TO TABLE-ELEMENT-3             
              MOVE I-PROMO-CD            TO HOSTVAR-ELEMENT-1           
              MOVE DU-TIER-CUST-STAT-CD  TO HOSTVAR-ELEMENT-2           
              MOVE DU-TIER-ACCT-TYPE-CD  TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7099-SEND-NOTFOUND-RES                                     **         
      *****************************************************************         
       7099-SEND-NOTFOUND-RES.                                          
      *                                                                         
      * IF KM-REPLACMNT-PROMO-CD = SPACES, S-RETURN-CODE = 111                  
      *                                                                         
           IF S-RETURN-CODE NOT = 111                                   
              INITIALIZE                       GTT-RETURN-FIELDS        
              MOVE NOT-FOUND                   TO S-RETURN-CODE         
           END-IF.                                                      
      *                                                                         
P00614     EVALUATE TRUE                                                
P00614         WHEN I-CALL-TYPE  = 'ECS'                                
P00614              PERFORM 8100-SEND-RESULT  THRU  8100-EXIT           
P00614         WHEN I-CALL-TYPE  = 'WEB'                                
P00614              PERFORM 8200-SEND-RESULT  THRU  8200-EXIT           
P00614         WHEN (I-CALL-TYPE = 'CRM' AND I-INT-EXT-DATA-FL = 'I')   
P00614              PERFORM 8300-SEND-RESULT  THRU 8300-EXIT            
P00614         WHEN (I-CALL-TYPE = 'CRM' AND I-INT-EXT-DATA-FL = 'E')   
P00614              PERFORM 8400-SEND-RESULT  THRU 8400-EXIT            
P00614     END-EVALUATE.                                                
      *                                                                         
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
      *                                                                         
       7099-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P1137C*****************************************************************         
P1137C**  GET CURRENT DATE & TIMESTAMP                               **         
P1137C*****************************************************************         
P1137C*                                                                         
P1137C 7100-GET-CURR-DATE-AND-TS.                                       
P1137C*                                                                         
P1137C     EXEC SQL                                                     
P1137C        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-TIMESTAMP,
              :WS-CURR-DATE                     
P1137C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-TIMESTAMP = CURRENT TIMESTAMP                        
MFA-TR*          ,:WS-CURR-DATE      = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P1137C*                                                                         
P1137C     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P1137C*                                                                         
P1137C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P1137C        CONTINUE                                                  
P1137C     ELSE                                                         
P1137C        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P1137C        MOVE '7100'                TO ACTIVE-PARAGRAPH            
P1137C        MOVE 'SET'                 TO ABEND-FUNCTION              
P1137C        MOVE SPACES                TO TABLE-1                     
P1137C        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P1137C        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P1137C     END-IF.                                                      
P1137C*                                                                         
P1137C 7100-EXIT.                                                       
P1137C     EXIT.                                                        
P1137C*                                                                         
      *****************************************************************         
      * 7300-OPEN-TIERANK-RTPKOFF-INT                                **         
      *                                                              **         
      *****************************************************************         
       7300-OPEN-TIERANK-RTPKOFF-INT.                                   
                                                                        
           EXEC SQL                                                     
                OPEN TIERANK_RTPKOFF_INT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7310-FETCH-TIERANK-RTPKOFF-INT                               **         
      *                                                              **         
      *****************************************************************         
       7310-FETCH-TIERANK-RTPKOFF-INT.                                  
                                                                        
           EXEC SQL                                                     
               FETCH TIERANK_RTPKOFF_INT                                
                INTO :DU-MKT-TIER-RANKING                               
                    ,:DU-OFFER-TIER-END-DT                              
                    ,:DU-OFFER-TIER-STRT-DT                             
                    ,:DU-TIER-ACCT-TYPE-CD                              
                    ,:DU-TIER-CUST-STAT-CD                              
                    ,:DU-TIER-DEFLT-OFFR-CD                             
                    ,:FG-OFFER-CD                                       
                    ,:FG-OFFER-DESC-INT                                 
                    ,:FG-OFFER-DESC-INT-LNG                             
                    ,:FG-OFFER-END-DT                                   
                    ,:FG-OFFER-START-DT                                 
                    ,:FG-PROMO-CD-INT-FL                                
                    ,:WS-SPCL-OFFER-TYPE-CD                             
P680P2              ,:FG-MAX-PRICE-OFFER-CD                             
                    ,:KM-PROMO-CD :IND-PROMO-CD                          
                    ,:KM-EXT-LANDING-PG-URL :IND-EXT-LANDING-PG-URL      
I01095              ,:KM-INT-LANDING-PG-URL :IND-INT-LANDING-PG-URL      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  IND-PROMO-CD = WS-YES-NULL                               
               MOVE SPACES TO KM-PROMO-CD                               
           END-IF.                                                      
                                                                        
           IF  IND-EXT-LANDING-PG-URL = WS-YES-NULL                     
               MOVE ZEROS  TO KM-EXT-LANDING-PG-URL-LEN                 
               MOVE SPACES TO KM-EXT-LANDING-PG-URL-TEXT                
           END-IF.                                                      
I01095                                                                  
I01095     IF  IND-INT-LANDING-PG-URL = WS-YES-NULL                     
I01095         MOVE ZEROS  TO KM-INT-LANDING-PG-URL-LEN                 
I01095         MOVE SPACES TO KM-INT-LANDING-PG-URL-TEXT                
I01095     END-IF.                                                      
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'Y' TO WS-NO-MORE-TR-ROWS2                          
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7320-CLOSE-TIERANK-RTPKOFF-INT                               **         
      *                                                              **         
      *****************************************************************         
       7320-CLOSE-TIERANK-RTPKOFF-INT.                                  
                                                                        
           EXEC SQL                                                     
               CLOSE TIERANK_RTPKOFF_INT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7320'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7350-OPEN-TIERANK-RTPKOFF-EXT                                **         
      *                                                              **         
      *****************************************************************         
       7350-OPEN-TIERANK-RTPKOFF-EXT.                                   
                                                                        
           EXEC SQL                                                     
                OPEN TIERANK_RTPKOFF_EXT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7350'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7360-FETCH-TIERANK-RTPKOFF-EXT                               **         
      *****************************************************************         
       7360-FETCH-TIERANK-RTPKOFF-EXT.                                  
                                                                        
           EXEC SQL                                                     
               FETCH TIERANK_RTPKOFF_EXT                                
                INTO :DU-MKT-TIER-RANKING                               
                    ,:DU-OFFER-TIER-END-DT                              
                    ,:DU-OFFER-TIER-STRT-DT                             
                    ,:DU-TIER-ACCT-TYPE-CD                              
                    ,:DU-TIER-CUST-STAT-CD                              
                    ,:DU-TIER-DEFLT-OFFR-CD                             
P00614              ,:IG-CUST-ACCT-DEFLT-FL                             
                    ,:FG-OFFER-CD                                       
                    ,:FG-OFFER-DESC-EXT                                 
                    ,:FG-OFFER-DESC-EXT-LNG                             
                    ,:FG-OFFER-END-DT                                   
                    ,:FG-OFFER-START-DT                                 
                    ,:FG-PROMO-CD-EXT-FL                                
                    ,:WS-SPCL-OFFER-TYPE-CD                             
P680P2              ,:FG-MAX-PRICE-OFFER-CD                             
                    ,:KM-PROMO-CD :IND-PROMO-CD                          
                    ,:KM-EXT-LANDING-PG-URL :IND-EXT-LANDING-PG-URL      
I01095              ,:KM-INT-LANDING-PG-URL :IND-INT-LANDING-PG-URL      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  IND-PROMO-CD = WS-YES-NULL                               
               MOVE SPACES TO KM-PROMO-CD                               
           END-IF.                                                      
                                                                        
           IF  IND-EXT-LANDING-PG-URL = WS-YES-NULL                     
               MOVE ZEROS  TO KM-EXT-LANDING-PG-URL-LEN                 
               MOVE SPACES TO KM-EXT-LANDING-PG-URL-TEXT                
           END-IF.                                                      
                                                                        
I01095     IF  IND-INT-LANDING-PG-URL = WS-YES-NULL                     
I01095         MOVE ZEROS  TO KM-INT-LANDING-PG-URL-LEN                 
I01095         MOVE SPACES TO KM-INT-LANDING-PG-URL-TEXT                
I01095     END-IF.                                                      
I01095                                                                  
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'Y' TO WS-NO-MORE-TR-ROWS3                          
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7360'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7370-CLOSE-TIERANK-RTPKOFF-EXT                               **         
      *                                                              **         
      *****************************************************************         
       7370-CLOSE-TIERANK-RTPKOFF-EXT.                                  
                                                                        
           EXEC SQL                                                     
               CLOSE TIERANK_RTPKOFF_EXT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7370'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7400-OPEN-PROMO-RTPKOFF-INT                                  **         
      *                                                              **         
      *****************************************************************         
       7400-OPEN-PROMO-RTPKOFF-INT.                                     
                                                                        
           EXEC SQL                                                     
                OPEN PROMO_RTPKOFF_INT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7410-FETCH-PROMO-RTPKOFF-INT                                 **         
      *                                                              **         
      *****************************************************************         
       7410-FETCH-PROMO-RTPKOFF-INT.                                    
                                                                        
           EXEC SQL                                                     
               FETCH PROMO_RTPKOFF_INT                                  
                INTO :FG-OFFER-CD                                       
                    ,:FG-OFFER-DESC-INT                                 
                    ,:FG-OFFER-DESC-INT-LNG                             
                    ,:FG-OFFER-END-DT                                   
                    ,:FG-OFFER-START-DT                                 
                    ,:FG-PROMO-CD-INT-FL                                
                    ,:WS-SPCL-OFFER-TYPE-CD                             
P680P2              ,:FG-MAX-PRICE-OFFER-CD                             
                    ,:KM-EXT-LANDING-PG-URL :IND-EXT-LANDING-PG-URL      
I01095              ,:KM-INT-LANDING-PG-URL :IND-INT-LANDING-PG-URL      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF  IND-EXT-LANDING-PG-URL = WS-YES-NULL                     
               MOVE ZEROS  TO KM-EXT-LANDING-PG-URL-LEN                 
               MOVE SPACES TO KM-EXT-LANDING-PG-URL-TEXT                
           END-IF.                                                      
                                                                        
I01095     IF  IND-INT-LANDING-PG-URL = WS-YES-NULL                     
I01095         MOVE ZEROS  TO KM-INT-LANDING-PG-URL-LEN                 
I01095         MOVE SPACES TO KM-INT-LANDING-PG-URL-TEXT                
I01095     END-IF.                                                      
I01095                                                                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'Y' TO WS-NO-MORE-TR-ROWS4                          
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7410'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7420-CLOSE-PROMO-RTPKOFF-INT                                 **         
      *                                                              **         
      *****************************************************************         
       7420-CLOSE-PROMO-RTPKOFF-INT.                                    
                                                                        
           EXEC SQL                                                     
               CLOSE PROMO_RTPKOFF_INT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7320'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7450-OPEN-PROMO-RTPKOFF-EXT                                  **         
      *                                                              **         
      *****************************************************************         
       7450-OPEN-PROMO-RTPKOFF-EXT.                                     
                                                                        
           EXEC SQL                                                     
                OPEN PROMO_RTPKOFF_EXT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7450'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7460-FETCH-PROMO-RTPKOFF-EXT                                 **         
      *****************************************************************         
       7460-FETCH-PROMO-RTPKOFF-EXT.                                    
                                                                        
           EXEC SQL                                                     
               FETCH PROMO_RTPKOFF_EXT                                  
                INTO :FG-OFFER-CD                                       
                    ,:FG-OFFER-DESC-EXT                                 
                    ,:FG-OFFER-DESC-EXT-LNG                             
                    ,:FG-OFFER-END-DT                                   
                    ,:FG-OFFER-START-DT                                 
                    ,:FG-PROMO-CD-EXT-FL                                
                    ,:WS-SPCL-OFFER-TYPE-CD                             
P680P2              ,:FG-MAX-PRICE-OFFER-CD                             
                    ,:KM-EXT-LANDING-PG-URL :IND-EXT-LANDING-PG-URL      
I01095              ,:KM-INT-LANDING-PG-URL :IND-INT-LANDING-PG-URL      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF  IND-EXT-LANDING-PG-URL = WS-YES-NULL                     
               MOVE ZEROS  TO KM-EXT-LANDING-PG-URL-LEN                 
               MOVE SPACES TO KM-EXT-LANDING-PG-URL-TEXT                
           END-IF.                                                      
                                                                        
I01095     IF  IND-INT-LANDING-PG-URL = WS-YES-NULL                     
I01095         MOVE ZEROS  TO KM-INT-LANDING-PG-URL-LEN                 
I01095         MOVE SPACES TO KM-INT-LANDING-PG-URL-TEXT                
I01095     END-IF.                                                      
I01095                                                                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'Y' TO WS-NO-MORE-TR-ROWS5                          
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7460'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7470-CLOSE-PROMO-RTPKOFF-EXT                                 **         
      *                                                              **         
      *****************************************************************         
       7470-CLOSE-PROMO-RTPKOFF-EXT.                                    
                                                                        
           EXEC SQL                                                     
               CLOSE PROMO_RTPKOFF_EXT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7470'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A00775******************************************************************        
A00775* 7520-SELECT-RATE-CREATOR.                                     **        
A00775*                                                               **        
A00775******************************************************************        
A00775 7520-SELECT-RATE-CREATOR.                                        
A00775                                                                  
A00775     EXEC SQL                                                     
A00775        SELECT TOP(1) RT.VERSION_NO_CNTRL                                
A00775          INTO :RT-VERSION-NO-CNTRL                               
A00775          FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                  
A00775         WHERE RT.RATE_PLAN_NO      = :RT-RATE-PLAN-NO            
A00775           AND RT.CODE_UTIL_TYPE    = 'G'                         
A00775           AND RT.CODE_STATUS       = 'A'                         
P1137C           AND RT.FROM_EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )              
A00775         ORDER BY RT.VERSION_NO_CNTRL DESC                        
A00775                                       
A04019                                                      
A00775     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RT.VERSION_NO_CNTRL                                        
MFA-TR*         INTO :RT-VERSION-NO-CNTRL                                       
MFA-TR*         FROM CSS_RATE_CREATOR RT                                        
MFA-TR*        WHERE RT.RATE_PLAN_NO      = :RT-RATE-PLAN-NO                    
MFA-TR*          AND RT.CODE_UTIL_TYPE    = 'G'                                 
MFA-TR*          AND RT.CODE_STATUS       = 'A'                                 
MFA-TR*          AND RT.FROM_EFFECTIVE_DT <= :WS-CURR-DATE                      
MFA-TR*        ORDER BY RT.VERSION_NO_CNTRL DESC                                
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7520                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00775                                                                  
A00775     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A00775                                                                  
A00775     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00775        CONTINUE                                                  
A00775     ELSE                                                         
A00775        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
A00775        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A00775        MOVE '7520'                   TO ACTIVE-PARAGRAPH         
A00775        MOVE 'SELECT'                 TO ABEND-FUNCTION           
A00775        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
A00775                                           ABEND-TABLES           
A00775        MOVE 'CSS_RATE_CREATOR'       TO TABLE-1                  
A00775        MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
A00775        MOVE RT-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
A00775        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00775        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00775     END-IF.                                                      
A00775*                                                                         
A00775 7520-EXIT.                                                       
A00775     EXIT.                                                        
A00775*                                                                         
A00775******************************************************************        
A00775* 7530-SELECT-CUST-CHRG.                                        **        
A00775*                                                               **        
A00775******************************************************************        
A00775 7530-SELECT-CUST-CHRG.                                           
A00775                                                                  
A00775     EXEC SQL                                                     
A00775         SELECT J4.AMT_CUST_CHRG                                  
A00775           INTO :J4-AMT-CUST-CHRG                                 
A00775           FROM CSS_RATE_VRSN_DEF J4 WITH(READUNCOMMITTED)                
A00775          WHERE CODE_UTIL_TYPE   = 'G'                            
A00775            AND RATE_PLAN_NO     = :J4-RATE-PLAN-NO               
A00775            AND VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL           
A04019                                                           
A04019                                                      
A00775     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT J4.AMT_CUST_CHRG                                          
MFA-TR*          INTO :J4-AMT-CUST-CHRG                                         
MFA-TR*          FROM CSS_RATE_VRSN_DEF J4                                      
MFA-TR*         WHERE CODE_UTIL_TYPE   = 'G'                                    
MFA-TR*           AND RATE_PLAN_NO     = :J4-RATE-PLAN-NO                       
MFA-TR*           AND VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7530                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00775                                                                  
A00775     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A00775                                                                  
A00775     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A00775        NEXT SENTENCE                                             
A00775     ELSE                                                         
A00775        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
A00775        MOVE SPACES                   TO ABEND-TABLES             
A00775        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
A00775        MOVE '7530'                   TO ACTIVE-PARAGRAPH         
A00775        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A00775        MOVE 'SELECT'                 TO ABEND-FUNCTION           
A00775        MOVE 'CSS_RATE_VRSN_DEF'      TO TABLE-1                  
A00775        MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
A00775        MOVE 'VERSION_NO_CNTRL'       TO TABLE-ELEMENT-2          
A00775        MOVE J4-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
A00775        MOVE J4-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-2        
A00775        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00775        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00775     END-IF.                                                      
A00775*                                                                         
A00775 7530-EXIT.                                                       
A00775     EXIT.                                                        
P00165*                                                                         
P00165******************************************************************        
P00165* 7535-CHECK-STEP-RATE.                                         **        
P00165*                                                               **        
P00165******************************************************************        
P00165 7535-CHECK-STEP-RATE.                                            
P00165                                                                  
P00165     EXEC SQL                                                     
P00165         SELECT LAST_ENERGY_BLOCK                                 
P00165           INTO :J1-LAST-ENERGY-BLOCK                             
P00165           FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                
P00165          WHERE J1.CODE_UTIL_TYPE   = 'G'                         
P00165            AND J1.RATE_PLAN_NO     = :PS-RATE-PLAN-NO            
P00165            AND J1.CMPNT_ID_CD      = '10'                        
P00165            AND J1.VERSION_NO_CNTRL = :PS-VERSION-NO-CNTRL        
P00165                                                           
A04019                                                      
P00165     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LAST_ENERGY_BLOCK                                         
MFA-TR*          INTO :J1-LAST-ENERGY-BLOCK                                     
MFA-TR*          FROM CSS_RATE_COMP_DEF J1                                      
MFA-TR*         WHERE J1.CODE_UTIL_TYPE   = 'G'                                 
MFA-TR*           AND J1.RATE_PLAN_NO     = :PS-RATE-PLAN-NO                    
MFA-TR*           AND J1.CMPNT_ID_CD      = '10'                                
MFA-TR*           AND J1.VERSION_NO_CNTRL = :PS-VERSION-NO-CNTRL                
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7535                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00165                                                                  
P00165     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00165                                                                  
P00165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00165        CONTINUE                                                  
P00165     ELSE                                                         
P00165        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
P00165        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00165        MOVE '7535'                   TO ACTIVE-PARAGRAPH         
P00165        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P00165        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
P00165                                         ABEND-TABLES             
P00165        MOVE 'CSS_RATE_COMP_DEF'      TO TABLE-1                  
P00165        MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
P00165        MOVE PS-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
P00165        MOVE 'VERSION_NO_CONTROL'     TO TABLE-ELEMENT-2          
P00165        MOVE PS-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-2        
P00165        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00165        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00165     END-IF.                                                      
P00165*                                                                         
P00165 7535-EXIT.                                                       
P00165     EXIT.                                                        
P00165*                                                                         
A00775*                                                                         
A00775******************************************************************        
A00775* 7540-SELECT-PRICE-SCHED.                                      **        
A00775*                                                               **        
A00775******************************************************************        
A00775 7540-SELECT-PRICE-SCHED.                                         
A00775                                                                  
A00775     EXEC SQL                                                     
A00775         SELECT PS.SCHED_PRICE_AM                                 
A00775            INTO :PS-SCHED-PRICE-AM                               
A00775            FROM CSS_PRICE_SCHED  PS                              
A00775           WHERE PS.CODE_UTIL_TYPE      = 'G'                     
A00775             AND PS.RATE_PLAN_NO        = :PS-RATE-PLAN-NO        
A00775             AND PS.VERSION_NO_CNTRL    = :PS-VERSION-NO-CNTRL    
A00775             AND PS.CMPNT_ID_CD         = '10'                    
A00775             AND PS.CODE_SEASON         = 'B'                     
A00775             AND PS.CODE_TIME_PERIOD    = 0                       
A00775             AND PS.CODE_USE_INST_TYPE  = 'R'                     
A04362                                                      
A00775     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PS.SCHED_PRICE_AM                                         
MFA-TR*           INTO :PS-SCHED-PRICE-AM                                       
MFA-TR*           FROM CSS_PRICE_SCHED  PS                                      
MFA-TR*          WHERE PS.CODE_UTIL_TYPE      = 'G'                             
MFA-TR*            AND PS.RATE_PLAN_NO        = :PS-RATE-PLAN-NO                
MFA-TR*            AND PS.VERSION_NO_CNTRL    = :PS-VERSION-NO-CNTRL            
MFA-TR*            AND PS.CMPNT_ID_CD         = '10'                            
MFA-TR*            AND PS.CODE_SEASON         = 'B'                             
MFA-TR*            AND PS.CODE_TIME_PERIOD    = 0                               
MFA-TR*            AND PS.CODE_USE_INST_TYPE  = 'R'                             
MFA-TR*       QUERYNO 7540                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00775                                                                  
A00775     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A00775                                                                  
A00775     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00775        CONTINUE                                                  
A00775     ELSE                                                         
A00775        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
A00775        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A00775        MOVE '7540'                   TO ACTIVE-PARAGRAPH         
A00775        MOVE 'SELECT'                 TO ABEND-FUNCTION           
A00775        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
A00775                                         ABEND-TABLES             
A00775        MOVE 'CSS_PRICE_SCHED'        TO TABLE-1                  
A00775        MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
A00775        MOVE PS-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
A00775        MOVE 'VERSION_NO_CONTROL'     TO TABLE-ELEMENT-2          
A00775        MOVE PS-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-2        
A00775        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00775        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00775     END-IF.                                                      
A00775*                                                                         
A00775 7540-EXIT.                                                       
A00775     EXIT.                                                        
A00775*                                                                         
A00775*****************************************************************         
A00775* 7700-OPEN-RATE-SPCL-FCTRS.                                   **         
A00775*                                                              **         
A00775*****************************************************************         
A00775 7700-OPEN-RATE-SPCL-FCTRS.                                       
A00775                                                                  
A00775     EXEC SQL                                                     
A00775          OPEN RATE_SPCL_FCTR                                     
A00775     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00775                                                                  
A00775     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A00775                                                                  
A00775     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00775        NEXT SENTENCE                                             
A00775     ELSE                                                         
A00775        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
A00775        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A00775        MOVE '7700'                   TO ACTIVE-PARAGRAPH         
A00775        MOVE 'OPEN'                   TO ABEND-FUNCTION           
A00775        MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
A00775        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00775        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00775     END-IF.                                                      
A00775*                                                                         
A00775 7700-EXIT.                                                       
A00775     EXIT.                                                        
A00775*                                                                         
A00775*****************************************************************         
A00775* 7710-FETCH-RATE-SPCL-FCTRS.                                  **         
A00775*                                                              **         
A00775*****************************************************************         
A00775 7710-FETCH-RATE-SPCL-FCTRS.                                      

MSQ008     MOVE 1500 TO MSQ008-RATE-SPCL-FCTR
A00775                                                                  
A00775     EXEC SQL                                                     
                                                                        
A05470         FOR :MSQ008-RATE-SPCL-FCTR
              FETCH 
              FROM RATE_SPCL_FCTR       
A00775          INTO :ARR-RATE-PLAN-NO                                  
A00775              ,:ARR-FACTOR-ID                                     
A00775              ,:ARR-FACTOR-TYPE                                   
A00775              ,:ARR-ADJUST-ELEMENT                                
A00775              ,:ARR-FACTOR                                        
I01095              ,:ARR-INT-DISP-START-TS                             
A00775     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        FETCH NEXT ROWSET FROM RATE_SPCL_FCTR FOR 1500 ROWS              
MFA-TR*         INTO :ARR-RATE-PLAN-NO                                          
MFA-TR*             ,:ARR-FACTOR-ID                                             
MFA-TR*             ,:ARR-FACTOR-TYPE                                           
MFA-TR*             ,:ARR-ADJUST-ELEMENT                                        
MFA-TR*             ,:ARR-FACTOR                                                
MFA-TR*             ,:ARR-INT-DISP-START-TS                                     
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-RATE-SPCL-FCTR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00775                                                                  
A00775     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
A00775     MOVE SQLERRD(3)          TO WS-RATE-SPCL-FCTR-COUNT.         
A00775                                                                  
A00775* FOR THIS SCENARIO SQL CODE = 0 MEANS ARRAY OVERFLOW IS LIKELY.          
A00775* THAT IS WHY IT IS HANDLED AS AN EXCEPTION.                              
A00775     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND  AND                
A00775        WS-RATE-SPCL-FCTR-COUNT  >  0                             
A00775        CONTINUE                                                  
A00775     ELSE                                                         
A00775        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
A00775        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A00775        MOVE '7710'                    TO ACTIVE-PARAGRAPH        
A00775        MOVE 'FETCH'                   TO ABEND-FUNCTION          
A00775        MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
A00775        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00775        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00775     END-IF.                                                      
A00775*                                                                         
                                                                        
A00775 7710-EXIT.                                                       
A00775     EXIT.                                                        
A00775*                                                                         
A00775*****************************************************************         
A00775* 7720-CLOSE-RATE-SPCL-FCTRS.                                  **         
A00775*                                                              **         
A00775*****************************************************************         
A00775 7720-CLOSE-RATE-SPCL-FCTRS.                                      
A00775                                                                  
A00775     EXEC SQL                                                     
A00775         CLOSE RATE_SPCL_FCTR                                     
A00775     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00775                                                                  
A00775     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A00775                                                                  
A00775     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00775        NEXT SENTENCE                                             
A00775     ELSE                                                         
A00775        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
A00775        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A00775        MOVE '7720'                   TO ACTIVE-PARAGRAPH         
A00775        MOVE 'CLOSE'                  TO ABEND-FUNCTION           
A00775        MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
A00775        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00775        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00775     END-IF.                                                      
A00775*                                                                         
A00775 7720-EXIT.                                                       
A00775     EXIT.                                                        
A00775*                                                                         
A00775*****************************************************************         
A00775* 7750-OPEN-ATTR-INCTV-DET.                                    **         
A00775*                                                              **         
A00775*****************************************************************         
A00775 7750-OPEN-ATTR-INCTV-DET.                                        
A00775                                                                  
A00775     EXEC SQL                                                     
A00775          OPEN ATTR_INCTV                                         
A00775     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00775                                                                  
A00775     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A00775                                                                  
A00775     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00775        NEXT SENTENCE                                             
A00775     ELSE                                                         
A00775        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
A00775        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A00775        MOVE '7750'                    TO ACTIVE-PARAGRAPH        
A00775        MOVE 'OPEN'                    TO ABEND-FUNCTION          
A00775        MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
A00775        MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
A00775        MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
A00775        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00775        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00775     END-IF.                                                      
A00775*                                                                         
A00775 7750-EXIT.                                                       
A00775     EXIT.                                                        
A00775*                                                                         
A00775*****************************************************************         
A00775* 7760-FETCH-ATTR-INCTV-DET.                                   **         
A00775*                                                              **         
A00775*****************************************************************         
A00775 7760-FETCH-ATTR-INCTV-DET.                                       
A00775                                                                  
A00775     EXEC SQL                                                     
A00775         FETCH ATTR_INCTV                                         
A00775          INTO :HQ-FACTOR-ID :IND-FACTOR-ID                        
A00775              ,:HQ-ATTR-INCTV-VALUE :IND-ATTR-INCTV-VALUE          
A00775              ,:HQ-PRIMRY-OPT-ATTR-FL                             
A00775              ,:HQ-DURATION-NO                                    
A00775              ,:HQ-RT-ATTR-INCTV-TYPE                             
A00775     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00775                                                                  
A00775     IF IND-FACTOR-ID = WS-YES-NULL                               
A00775        MOVE SPACES          TO HQ-FACTOR-ID                      
A00775     END-IF                                                       
A00775                                                                  
A00775     IF IND-ATTR-INCTV-VALUE = WS-YES-NULL                        
A00775        MOVE ZEROES          TO HQ-ATTR-INCTV-VALUE               
A00775     END-IF                                                       
A00775                                                                  
A00775     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A00775                                                                  
A00775     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A00775        CONTINUE                                                  
A00775     ELSE                                                         
A00775        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A00775        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00775        MOVE '7760'                TO ACTIVE-PARAGRAPH            
A00775        MOVE 'FETCH'               TO ABEND-FUNCTION              
A00775        MOVE 'CRM_OPT_ATTR_INCTV'  TO TABLE-1                     
A00775        MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
A00775        MOVE HQ-OPTION-CD          TO HOSTVAR-ELEMENT-1           
A00775        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00775        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00775     END-IF.                                                      
A00775*                                                                         
A00775 7760-EXIT.                                                       
A00775     EXIT.                                                        
A00775*                                                                         
A00775*****************************************************************         
A00775* 7770-CLOSE-ATTR-INCTV-DET.                                   **         
A00775*                                                              **         
A00775*****************************************************************         
A00775 7770-CLOSE-ATTR-INCTV-DET.                                       
A00775                                                                  
A00775     EXEC SQL                                                     
A00775         CLOSE ATTR_INCTV                                         
A00775     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00775                                                                  
A00775     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A00775                                                                  
A00775     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00775        NEXT SENTENCE                                             
A00775     ELSE                                                         
A00775        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
A00775        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A00775        MOVE '7770'                   TO ACTIVE-PARAGRAPH         
A00775        MOVE 'CLOSE'                  TO ABEND-FUNCTION           
A00775        MOVE 'CRM_OPT_ATTR_INCTV'     TO TABLE-1                  
A00775        MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
A00775        MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-1        
A00775        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00775        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00775     END-IF.                                                      
A00775*                                                                         
A00775 7770-EXIT.                                                       
A00775     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7800-OPEN-OPTION-DET.                                        **         
      *                                                              **         
      *****************************************************************         
       7800-OPEN-OPTION-DET.                                            
                                                                        
           EXEC SQL                                                     
                OPEN OPTION_DET                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7800'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7810-FETCH-OPTION-DET.                                       **         
      *                                                              **         
      *****************************************************************         
       7810-FETCH-OPTION-DET.                                           
                                                                        
A04019     INITIALIZE FI-OPT-DESC-INT                                   
A04019                FI-OPT-DESC-INT-LONG                              
A04019                S-OPT-DESC-INT-LONG-TEXT                          
A04019                S-OPT-DESC-INT.                                   
           EXEC SQL                                                     
               FETCH OPTION_DET                                         
                INTO :FI-OPTION-CD                                      
                    ,:FI-OPT-DESC-INT                                   
                    ,:FI-CODE-UTIL-TYPE                                 
                    ,:FI-RATE-PLAN-NO                                   
                    ,:FI-OPTION-START-DT                                
                    ,:FI-OPTION-END-DT                                  
                    ,:FI-OPT-DESC-INT-LONG                              
                    ,:FI-CURR-EXT-DESC-LONG                             
                    ,:FI-WEB-DESC-LONG                                  
                    ,:FI-OPT-CALC-TYPE-CD                               
I01095              ,:FI-WEB-MKT-DESC-LONG                              
                    ,:E9-OFFER-CD                                       
                    ,:E9-OPTION-SORT-SEQ-NO                             
P00614              ,:E9-WEB-NEW-EXISTS-CD                              
P00614              ,:E9-WEB-SIGN-UP-FL                                 
P614P2              ,:E9-OFF-OPT-EXCLUDE-CD                             
                    ,:G5-SORT-SEQ-NO :IND-SORT-SEQ-NO                    
                    ,:G5-RATE-GROUP-CD :IND-RATE-GROUP-CD                
                    ,:F7-RATE-GRP-DESC :IND-RATE-GRP-DESC                
                    ,:F7-RATE-GRP-DESC-LONG :IND-RATE-GRP-DESC-LONG      
                    ,:F7-RT-GRP-SORT-SEQ-NO :IND-RT-GRP-SORT-SEQ-NO      
P00892              ,:FI-AUTO-RENEWAL-FL                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF  IND-SORT-SEQ-NO = WS-YES-NULL                            
               MOVE ZEROS  TO G5-SORT-SEQ-NO                            
           END-IF.                                                      
           IF  IND-RATE-GROUP-CD =  WS-YES-NULL                         
               MOVE ZEROS  TO G5-RATE-GROUP-CD                          
           END-IF.                                                      
           IF  IND-RATE-GRP-DESC = WS-YES-NULL                          
               MOVE SPACES TO F7-RATE-GRP-DESC                          
           END-IF.                                                      
           IF  IND-RATE-GRP-DESC-LONG = WS-YES-NULL                     
               MOVE SPACES TO F7-RATE-GRP-DESC-LONG                     
           END-IF.                                                      
           IF  IND-RT-GRP-SORT-SEQ-NO = WS-YES-NULL                     
               MOVE ZEROS  TO F7-RT-GRP-SORT-SEQ-NO                     
           END-IF.                                                      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN NOT-FOUND                                             
                  MOVE 'Y'                   TO WS-NO-MORE-TR-ROWS6     
             WHEN OTHER                                                 
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '7810'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH'               TO ABEND-FUNCTION          
                  MOVE 'CRM_RT_PKG_OPTION'   TO TABLE-1                 
                  MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1         
                  MOVE E9-OFFER-CD           TO HOSTVAR-ELEMENT-1       
                  PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT       
                  PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7820-CLOSE-OPTION-DET.                                       **         
      *                                                              **         
      *****************************************************************         
       7820-CLOSE-OPTION-DET.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE OPTION_DET                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7820'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CRM_RT_PKG_OPTION'      TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE E9-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7830-OPEN-ATTR-DET.                                          **         
      *                                                              **         
      *****************************************************************         
       7830-OPEN-ATTR-DET.                                              
                                                                        
           EXEC SQL                                                     
                OPEN ATTR_DET                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7830'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CRM_RT_ATTR_INCV'        TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7840-FETCH-ATTR-DET.                                         **         
      *****************************************************************         
       7840-FETCH-ATTR-DET.                                             
                                                                        
           EXEC SQL                                                     
               FETCH ATTR_DET                                           
                INTO :G7-RT-ATTR-INCTV-TYPE                             
                    ,:G7-RT-ATTR-INCTV-DESC                             
                    ,:HQ-ATTR-INCTV-SEQ-NO                              
                    ,:HQ-DURATION-NO                                    
                    ,:HQ-ATTR-INCTV-VALUE :IND-ATTR-INCTV-VALUE          
                    ,:HQ-ATTR-INCTV-VAL-TX                              
P00680              ,:SF-FACTOR-TEXT                                    
NEW680              ,:SF-FACTOR-DESC                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  IF IND-ATTR-INCTV-VALUE = WS-YES-NULL                 
                     MOVE ZEROES             TO HQ-ATTR-INCTV-VALUE     
                  END-IF                                                
             WHEN NOT-FOUND                                             
                  MOVE 'Y'                   TO WS-NO-MORE-TR-ROWS7     
             WHEN OTHER                                                 
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '7840'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH'               TO ABEND-FUNCTION          
                  MOVE 'CRM_RT_ATTR_INCV'    TO TABLE-1                 
                  MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1         
                  MOVE HQ-OPTION-CD          TO HOSTVAR-ELEMENT-1       
                  PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT       
                  PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       7840-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7850-CLOSE-ATTR-DET.                                         **         
      *                                                              **         
      *****************************************************************         
       7850-CLOSE-ATTR-DET.                                             
                                                                        
           EXEC SQL                                                     
               CLOSE ATTR_DET                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7850'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CRM_RT_ATTR_INCV'       TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00269*                                                                         
P00269*****************************************************************         
P00269* 7860-OPEN-SEC-OFF-OPT-CUR.                                   **         
P00269*                                                              **         
P00269*****************************************************************         
P00269 7860-OPEN-SEC-OFF-OPT-CUR.                                       
P00269                                                                  
P00269     EXEC SQL                                                     
P00269          OPEN SEC_OFF_OPT_CUR                                    
P00269     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00269                                                                  
P00269     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00269                                                                  
P00269     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00269        NEXT SENTENCE                                             
P00269     ELSE                                                         
P00269        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00269        MOVE '7860'                    TO ACTIVE-PARAGRAPH        
P00269        MOVE 'OPEN'                    TO ABEND-FUNCTION          
P00269        MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
P00269        MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
P00269        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
P00269        MOVE F5-USER-ID                TO HOSTVAR-ELEMENT-1       
P00269        MOVE CI-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
P00269        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00269        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00269     END-IF.                                                      
P00269*                                                                         
P00269 7860-EXIT.                                                       
P00269     EXIT.                                                        
P00269*                                                                         
P00269*****************************************************************         
P00269* 7870-FETCH-SEC-OFF-OPT-CUR.                                  **         
P00269*****************************************************************         
P00269 7870-FETCH-SEC-OFF-OPT-CUR.                                      
P00269                                                                  
P00269     EXEC SQL                                                     
P00269         FETCH SEC_OFF_OPT_CUR                                    
P00269          INTO :CI-OFFER-CD                                       
P00269              ,:CI-OPTION-CD                                      
P00269              ,:CI-VIEW-APPLY-CD                                  
P00269              ,:WS-ACCESS-FLAG :IND-ACCESS-FLAG                    
P00269     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00269                                                                  
P00269     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00269                                                                  
P00269     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00269       WHEN SUCCESSFUL-CALL                                       
P00269            IF IND-ACCESS-FLAG = WS-YES-NULL                      
P00269               MOVE 'N'                TO WS-ACCESS-FLAG          
P00269            END-IF                                                
P00269       WHEN NOT-FOUND                                             
P00269            CONTINUE                                              
P00269       WHEN OTHER                                                 
P00269            MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
P00269            MOVE '7870'                TO ACTIVE-PARAGRAPH        
P00269            MOVE 'FETCH'               TO ABEND-FUNCTION          
P00269            MOVE 'CRM_ACCESS_OFF_OPT'  TO TABLE-1                 
P00269            MOVE 'USER_ID'             TO TABLE-ELEMENT-1         
P00269            MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2         
P00269            MOVE F5-USER-ID            TO HOSTVAR-ELEMENT-1       
P00269            MOVE CI-COMPANY-NO         TO HOSTVAR-ELEMENT-2       
P00269            PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT       
P00269            PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT       
P00269     END-EVALUATE.                                                
P00269*                                                                         
P00269 7870-EXIT.                                                       
P00269     EXIT.                                                        
P00269*                                                                         
P00269*****************************************************************         
P00269* 7880-CLOSE-SEC-OFF-OPT-CUR.                                  **         
P00269*                                                              **         
P00269*****************************************************************         
P00269*                                                                         
P00269 7880-CLOSE-SEC-OFF-OPT-CUR.                                      
P00269                                                                  
P00269     EXEC SQL                                                     
P00269         CLOSE SEC_OFF_OPT_CUR                                    
P00269     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00269                                                                  
P00269     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00269                                                                  
P00269     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00269        NEXT SENTENCE                                             
P00269     ELSE                                                         
P00269        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00269        MOVE '7880'                   TO ACTIVE-PARAGRAPH         
P00269        MOVE 'CLOSE'                  TO ABEND-FUNCTION           
P00269        MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
P00269        MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
P00269        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
P00269        MOVE F5-USER-ID                TO HOSTVAR-ELEMENT-1       
P00269        MOVE CI-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
P00269        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00269        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00269     END-IF.                                                      
P00269*                                                                         
P00269 7880-EXIT.                                                       
P00269     EXIT.                                                        
P00269*                                                                         
P00269*****************************************************************         
P00269*                                                               *         
P00269* 7890-GET-SUPER-USER-FLAG.                                     *         
P00269*****************************************************************         
P00269*                                                                         
P00269 7890-GET-SUPER-USER-FLAG.                                        
P00269                                                                  
P00269     EXEC SQL                                                     
P00269        SELECT TOP(1) 'Y'                                                
P00269          INTO :WS-SUPER-USER-FLAG                                
P00269          FROM CSS_CATEGORY   F5 WITH(READUNCOMMITTED)                    
P00269         WHERE F5.USER_ID     = :F5-USER-ID                       
P01137           AND F5.CATEGORY_ID =  346                              
P00269                                              
P00269                                                           
A04019                                                      
P00269     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SUPER-USER-FLAG                                        
MFA-TR*         FROM CSS_CATEGORY   F5                                          
MFA-TR*        WHERE F5.USER_ID     = :F5-USER-ID                               
MFA-TR*          AND F5.CATEGORY_ID =  346                                      
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7890                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00269                                                                  
P00269     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00269                                                                  
P00269     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00269        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00269           MOVE 'N'                    TO WS-SUPER-USER-FLAG      
P00269        END-IF                                                    
P00269     ELSE                                                         
P00269        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00269        MOVE '7890'                    TO ACTIVE-PARAGRAPH        
P00269        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00269        MOVE 'CSS_CATEGORY'            TO TABLE-1                 
P00269        MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
P00269        MOVE F5-USER-ID                TO HOSTVAR-ELEMENT-1       
P00269        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00269        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00269     END-IF.                                                      
P00269                                                                  
P00269 7890-EXIT.                                                       
P00269     EXIT.                                                        
P00269                                                                  
I01095*****************************************************************         
I01095* 7900-CALC-EXP-DATE.                                           *         
I01095*****************************************************************         
I01095 7900-CALC-EXP-DATE.                                              
I01095                                                                  
I01095     EXEC SQL                                                     
I01095        SELECT
              DATEADD( MONTH, :WS-RATE-EFF-DLINQ, IIF(TRY_CONVERT(DATE, 
                                                         :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE) ) )
            INTO
              :WS-DUMMY-DATE          
I01095     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DUMMY-DATE = DATE(:WS-DUMMY-DATE) +                       
MFA-TR*                             :WS-RATE-EFF-DLINQ  MONTHS                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01095                                                                  
I01095     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I01095                                                                  
I01095     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I01095        CONTINUE                                                  
I01095     ELSE                                                         
I01095        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I01095        MOVE '7900'                    TO ACTIVE-PARAGRAPH        
I01095        MOVE 'SET'                     TO ABEND-FUNCTION          
I01095        MOVE 'WS-DUMMY-DATE'           TO TABLE-ELEMENT-1         
I01095        MOVE WS-DUMMY-DATE             TO HOSTVAR-ELEMENT-1       
I01095        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I01095        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I01095     END-IF.                                                      
I01095                                                                  
I01095 7900-EXIT.                                                       
I01095     EXIT.                                                        
I01095                                                                  
I01095*****************************************************************         
I01095* 7910-SELECT-EXIT-FEE.                                         *         
I01095*****************************************************************         
I01095 7910-SELECT-EXIT-FEE.                                            
I01095                                                                  
I01095     EXEC SQL                                                     
I01095        SELECT TOP(1) HQ.ATTR_INCTV_VALUE                                
I01095          INTO :WS-EXIT-FEE                                       
I01095          FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
I01095              ,CRM_RT_ATTR_INCTV  G7 WITH(READUNCOMMITTED)                
I01095         WHERE HQ.OPTION_CD          = :HQ-OPTION-CD              
I01095           AND HQ.RT_ATTR_INCTV_TYPE = G7.RT_ATTR_INCTV_TYPE      
I01095           AND HQ.COMPANY_NO         = G7.COMPANY_NO              
I01095           AND G7.RT_ATTR_INCTV_TYPE = 'EXIT FEE'                 
P1137C           AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )             
P1137C           AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )             
P1137C           AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )        
P1137C           AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )        
P00473           AND HQ.PROC_STATUS_CD      = 'AC'                      
I01095         ORDER BY HQ.ATTR_INCTV_STRT_DT                           
I01095                                              
I01095                                                           
I01095                                                      
I01095     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HQ.ATTR_INCTV_VALUE                                        
MFA-TR*         INTO :WS-EXIT-FEE                                               
MFA-TR*         FROM CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*             ,CRM_RT_ATTR_INCTV  G7                                      
MFA-TR*        WHERE HQ.OPTION_CD          = :HQ-OPTION-CD                      
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE = G7.RT_ATTR_INCTV_TYPE              
MFA-TR*          AND HQ.COMPANY_NO         = G7.COMPANY_NO                      
MFA-TR*          AND G7.RT_ATTR_INCTV_TYPE = 'EXIT FEE'                         
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= :WS-CURR-DATE                     
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= :WS-CURR-DATE                     
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= :WS-CURR-TIMESTAMP                
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= :WS-CURR-TIMESTAMP                
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*        ORDER BY HQ.ATTR_INCTV_STRT_DT                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7910                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01095                                                                  
I01095     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I01095                                                                  
I01095     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I01095        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
I01095           MOVE 0                      TO WS-EXIT-FEE             
I01095        END-IF                                                    
I01095     ELSE                                                         
I01095        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I01095        MOVE '7910'                    TO ACTIVE-PARAGRAPH        
I01095        MOVE 'SELECT'                  TO ABEND-FUNCTION          
I01095        MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
I01095        MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
I01095        MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
I01095        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I01095        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I01095     END-IF.                                                      
I01095                                                                  
I01095 7910-EXIT.                                                       
I01095     EXIT.                                                        
I01095                                                                  
I01095*****************************************************************         
I01095* 7920-SELECT-DELINQ-VALUE.                                     *         
I01095*****************************************************************         
I01095 7920-SELECT-DELINQ-VALUE.                                        
I01095                                                                  
I01095     EXEC SQL                                                     
I01095        SELECT C8.DELINQ_VALUE                                    
I01095          INTO :C8-DELINQ-VALUE                                   
I01095          FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
I01095         WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                     
I01095           AND C8.COMPANY_NO  = :C8-COMPANY-NO                    
I01095                                                           
I01095                                                      
I01095     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                             
MFA-TR*          AND C8.COMPANY_NO  = :C8-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7920                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01095                                                                  
I01095     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
I01095                                                                  
I01095     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
I01095        CONTINUE                                                  
I01095     ELSE                                                         
I01095        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I01095        MOVE '7920'                    TO ACTIVE-PARAGRAPH        
I01095        MOVE 'SELECT'                  TO ABEND-FUNCTION          
I01095        MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
I01095        MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
I01095        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
I01095        MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
I01095        MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
I01095        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I01095        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I01095     END-IF.                                                      
I01095                                                                  
I01095 7920-EXIT.                                                       
I01095     EXIT.                                                        
I01095*                                                                         
P00485******************************************************************        
P00485* 7930-SELECT-RATE-CALC-CD.                                     **        
P00485* SELECTING TWO PART RATE CODE FROM RATE DESCRIPTOR TABLE.      **        
P00485******************************************************************        
P00485 7930-SELECT-RATE-CALC-CD.                                        
P00485                                                                  
P00485     EXEC SQL                                                     
P00485         SELECT RATE_DEFINITION_CD                                
P00614               ,SENIOR_RATE_FL                                    
P00485           INTO :RD-RATE-DEFINITION-CD                            
P00614               ,:RD-SENIOR-RATE-FL                                
P00485           FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
P00485          WHERE RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE            
P00485            AND RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO              
A04362                                                           
P00485                                                      
P00485     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RATE_DEFINITION_CD                                        
MFA-TR*              ,SENIOR_RATE_FL                                            
MFA-TR*          INTO :RD-RATE-DEFINITION-CD                                    
MFA-TR*              ,:RD-SENIOR-RATE-FL                                        
MFA-TR*          FROM CSS_RATE_PLAN_DESC RD                                     
MFA-TR*         WHERE RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                    
MFA-TR*           AND RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO                      
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7930                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00485                                                                  
P00485     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00485                                                                  
P00485     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00485        CONTINUE                                                  
P00485     ELSE                                                         
P00485        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
P00485        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00485        MOVE '7930'                   TO ACTIVE-PARAGRAPH         
P00485        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P00485        MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
P00485        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
P00485        MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
P00485        MOVE RD-RATE-DEFINITION-CD    TO HOSTVAR-ELEMENT-2        
P00485        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
P00485        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
P00485     END-IF.                                                      
P00485*                                                                         
P00485 7930-EXIT.                                                       
P00485     EXIT.                                                        
P00485                                                                  
P00680*****************************************************************         
P00680* 7940-OPEN-DISCOUNT-CURSOR.                                   **         
P00680*                                                              **         
P00680*****************************************************************         
P00680 7940-OPEN-DISCOUNT-CURSOR.                                       
P00680                                                                  
P00680     EXEC SQL                                                     
P00680          OPEN DISCOUNT_INCTV                                     
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00680        NEXT SENTENCE                                             
P00680     ELSE                                                         
P00680        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00680        MOVE '7940'                    TO ACTIVE-PARAGRAPH        
P00680        MOVE 'OPEN'                    TO ABEND-FUNCTION          
P00680        MOVE 'CRM_RT_ATTR_INCV'        TO TABLE-1                 
P00680        MOVE 'CSS_SPCL_FCTR'           TO TABLE-2                 
P00680        MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
P00680        MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
P00680        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00680        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00680     END-IF.                                                      
P00680*                                                                         
P00680 7940-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
P00680*****************************************************************         
P00680* 7950-FETCH-DISCOUNT-CURSOR.                                  **         
P00680*****************************************************************         
P00680 7950-FETCH-DISCOUNT-CURSOR.                                      
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         FETCH DISCOUNT_INCTV                                     
P00680          INTO :HQ-FACTOR-ID                                      
P00680              ,:HQ-RT-ATTR-INCTV-TYPE                             
P00680              ,:HQ-ATTR-INCTV-VALUE :IND-ATTR-INCTV-VALUE          
P00680              ,:HQ-DURATION-NO                                    
P00680              ,:SF-FACTOR-TEXT                                    
P00680              ,:SF-FACTOR-DESC                                    
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00680                                                                  
P00680     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00680       WHEN SUCCESSFUL-CALL                                       
P00680            IF IND-ATTR-INCTV-VALUE = WS-YES-NULL                 
P00680               MOVE ZEROES             TO HQ-ATTR-INCTV-VALUE     
P00680            END-IF                                                
P00680       WHEN NOT-FOUND                                             
P00680            MOVE 'Y'                   TO WS-NO-MORE-TR-ROWS8     
P00680       WHEN OTHER                                                 
P00680            MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
P00680            MOVE '7950'                TO ACTIVE-PARAGRAPH        
P00680            MOVE 'FETCH'               TO ABEND-FUNCTION          
P00680            MOVE 'CRM_RT_ATTR_INCV'    TO TABLE-1                 
P00680            MOVE 'CSS_SPCL_FCTR'       TO TABLE-2                 
P00680            MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1         
P00680            MOVE HQ-OPTION-CD          TO HOSTVAR-ELEMENT-1       
P00680            PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT       
P00680            PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT       
P00680     END-EVALUATE.                                                
P00680*                                                                         
P00680 7950-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
P00680*****************************************************************         
P00680* 7960-CLOSE-DISCOUNT-CURSOR.                                  **         
P00680*                                                              **         
P00680*****************************************************************         
P00680 7960-CLOSE-DISCOUNT-CURSOR.                                      
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         CLOSE DISCOUNT_INCTV                                     
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00680        NEXT SENTENCE                                             
P00680     ELSE                                                         
P00680        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00680        MOVE '7960'                   TO ACTIVE-PARAGRAPH         
P00680        MOVE 'CLOSE'                  TO ABEND-FUNCTION           
P00680        MOVE 'CRM_RT_ATTR_INCV'       TO TABLE-1                  
P00680        MOVE 'CSS_SPCL_FCTR'          TO TABLE-2                  
P00680        MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
P00680        MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-1        
P00680        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00680        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00680     END-IF.                                                      
P00680*                                                                         
P00680 7960-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
P680P2*****************************************************************         
P680P2* 7970-OPEN-MAX-OFFER-CURSOR.                                  **         
P680P2*                                                              **         
P680P2*****************************************************************         
P680P2 7970-OPEN-MAX-OFFER-CURSOR.                                      
P680P2                                                                  
P680P2     EXEC SQL                                                     
P680P2          OPEN MAX_OFFER_OPTIONS                                  
P680P2     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P680P2                                                                  
P680P2     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P680P2                                                                  
P680P2     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P680P2        NEXT SENTENCE                                             
P680P2     ELSE                                                         
P680P2        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P680P2        MOVE '7970'                    TO ACTIVE-PARAGRAPH        
P680P2        MOVE 'OPEN'                    TO ABEND-FUNCTION          
P680P2        MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
P680P2        MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-2                 
P680P2        MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
P680P2        MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-1       
P680P2        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P680P2        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P680P2     END-IF.                                                      
P680P2*                                                                         
P680P2 7970-EXIT.                                                       
P680P2     EXIT.                                                        
P680P2*                                                                         
P680P2*****************************************************************         
P680P2* 7980-FETCH-MAX-OFFER-CURSOR.                                 **         
P680P2*****************************************************************         
P680P2 7980-FETCH-MAX-OFFER-CURSOR.                                     
P680P2                                                                  
P680P2     EXEC SQL                                                     
P680P2         FETCH MAX_OFFER_OPTIONS                                  
P680P2          INTO :E9-OPTION-CD                                      
P680P2              ,:HQ-FACTOR-ID                                      
P680P2              ,:HQ-DURATION-NO                                    
P680P2              ,:SA-FACTOR                                         
P680P2     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P680P2                                                                  
P680P2     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P680P2                                                                  
P680P2     EVALUATE WS-ACTIVE-RETURN-CODE                               
P680P2       WHEN SUCCESSFUL-CALL                                       
P680P2            ADD +1                     TO WS-MAX-OFFER-OPTS-CTR   
P680P2       WHEN NOT-FOUND                                             
P680P2            MOVE 'Y'                   TO WS-NO-MORE-TR-ROWS9     
P680P2       WHEN OTHER                                                 
P680P2            MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
P680P2            MOVE '7980'                TO ACTIVE-PARAGRAPH        
P680P2            MOVE 'FETCH'               TO ABEND-FUNCTION          
P680P2            MOVE 'CRM_RT_PKG_OFFER'    TO TABLE-1                 
P680P2            MOVE 'CRM_RT_PKG_OPTION'   TO TABLE-2                 
P680P2            MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1         
P680P2            MOVE E9-OFFER-CD           TO HOSTVAR-ELEMENT-1       
P680P2            PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT       
P680P2            PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT       
P680P2     END-EVALUATE.                                                
P680P2*                                                                         
P680P2 7980-EXIT.                                                       
P680P2     EXIT.                                                        
P680P2*                                                                         
P680P2*****************************************************************         
P680P2* 7990-CLOSE-MAX-OFFER-CURSOR.                                 **         
P680P2*                                                              **         
P680P2*****************************************************************         
P680P2 7990-CLOSE-MAX-OFFER-CURSOR.                                     
P680P2                                                                  
P680P2     EXEC SQL                                                     
P680P2         CLOSE MAX_OFFER_OPTIONS                                  
P680P2     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P680P2                                                                  
P680P2     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P680P2                                                                  
P680P2     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P680P2        NEXT SENTENCE                                             
P680P2     ELSE                                                         
P680P2        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P680P2        MOVE '7990'                   TO ACTIVE-PARAGRAPH         
P680P2        MOVE 'CLOSE'                  TO ABEND-FUNCTION           
P680P2        MOVE 'CRM_RT_PKG_OFFER'       TO TABLE-1                  
P680P2        MOVE 'CRM_RT_PKG_OPTION'      TO TABLE-2                  
P680P2        MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
P680P2        MOVE E9-OFFER-CD              TO HOSTVAR-ELEMENT-1        
P680P2        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P680P2        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P680P2     END-IF.                                                      
P680P2*                                                                         
P680P2 7990-EXIT.                                                       
P680P2     EXIT.                                                        
P680P2*                                                                         
OTPOOL****************************************************************          
OTPOOL*   7991-OPEN-DDDC-CURSOR.                                                
OTPOOL****************************************************************          
OTPOOL 7991-OPEN-DDDC-CURSOR.                                           
OTPOOL*                                                                         
OTPOOL     EXEC SQL                                                     
OTPOOL         OPEN SPCL_FCTR_DDDC                                      
OTPOOL     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

OTPOOL                                                                  
OTPOOL     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
OTPOOL                                                                  
OTPOOL     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
OTPOOL        NEXT SENTENCE                                             
OTPOOL     ELSE                                                         
OTPOOL        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
OTPOOL        MOVE SQLCODE                  TO ABEND-SQLCODE            
OTPOOL        MOVE '7991'                   TO ACTIVE-PARAGRAPH         
OTPOOL        MOVE 'OPEN'                   TO ABEND-FUNCTION           
OTPOOL        MOVE 'CSS_SPCL_FCTR'          TO TABLE-1                  
OTPOOL        MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-2                  
OTPOOL        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
OTPOOL        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
OTPOOL     END-IF.                                                      
OTPOOL*                                                                         
OTPOOL 7991-EXIT.                                                       
OTPOOL     EXIT.                                                        
OTPOOL*                                                                         
OTPOOL****************************************************************          
OTPOOL**  7992-FETCH-DDDC-CURSOR.                                               
OTPOOL****************************************************************          
OTPOOL 7992-FETCH-DDDC-CURSOR.                                          
OTPOOL*                                                                         
OTPOOL     EXEC SQL                                                     
OTPOOL         FETCH SPCL_FCTR_DDDC                                     
OTPOOL          INTO :SA-RATE-PLAN-NO                                   
OTPOOL              ,:SA-FACTOR                                         
OTPOOL     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

OTPOOL                                                                  
OTPOOL     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
OTPOOL                                                                  
OTPOOL     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
OTPOOL        NEXT SENTENCE                                             
OTPOOL     ELSE                                                         
OTPOOL        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
OTPOOL        MOVE SQLCODE                  TO ABEND-SQLCODE            
OTPOOL        MOVE '7992'                   TO ACTIVE-PARAGRAPH         
OTPOOL        MOVE 'FETCH'                  TO ABEND-FUNCTION           
OTPOOL        MOVE 'CSS_SPCL_FCTR'          TO TABLE-1                  
OTPOOL        MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-2                  
OTPOOL        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
OTPOOL        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
OTPOOL     END-IF.                                                      
OTPOOL*                                                                         
OTPOOL 7992-EXIT.                                                       
OTPOOL     EXIT.                                                        
OTPOOL*                                                                         
OTPOOL****************************************************************          
OTPOOL**  7993-CLOSE-DDDC-CURSOR.                                               
OTPOOL****************************************************************          
OTPOOL 7993-CLOSE-DDDC-CURSOR.                                          
OTPOOL*                                                                         
OTPOOL     EXEC SQL                                                     
OTPOOL         CLOSE SPCL_FCTR_DDDC                                     
OTPOOL     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

OTPOOL                                                                  
OTPOOL     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
OTPOOL                                                                  
OTPOOL     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
OTPOOL        NEXT SENTENCE                                             
OTPOOL     ELSE                                                         
OTPOOL        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
OTPOOL        MOVE SQLCODE                  TO ABEND-SQLCODE            
OTPOOL        MOVE '7993'                   TO ACTIVE-PARAGRAPH         
OTPOOL        MOVE 'CLOSE'                  TO ABEND-FUNCTION           
OTPOOL        MOVE 'CSS_SPCL_FCTR'          TO TABLE-1                  
OTPOOL        MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-2                  
OTPOOL        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
OTPOOL        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
OTPOOL     END-IF.                                                      
OTPOOL*                                                                         
OTPOOL 7993-EXIT.                                                       
OTPOOL     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                        **        
      *                                                               **        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04005_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04005_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04005_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04005_R2                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04005_R2                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04005_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04005_R3                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04005_R3                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04005_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04005_R4                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04005_R4                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04005_R4'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR04005_R1'                               
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL                                                     
                                                                        
               INSERT INTO #CSR04005_R1                          
                   (                                                    
                       RETURN_CODE                                      
P00614                ,TIER_CUST_STAT_CD                                
P00614                ,TIER_ACCT_TYPE_CD                                
P00614                ,MKT_TIER_RANKING                                 
P00614                ,CUST_ACCT_DEFLT_FL                               
P00614                ,OFFER_CD                                         
P00614                ,TIER_DEFLT_OFFR_CD                               
P00614                ,PROMO_CD                                         
P00614                ,OPTION_CD                                        
P00614                ,OPTION_SORT_SEQ_NO                               
P00614                ,WEB_NEW_EXISTS_CD                                
P00614                ,WEB_SIGN_UP_FL                                   
P00614                ,OPT_TYPE_WEB                                     
P00614                ,FLEX_OPT_FL                                      
P00614                ,RATE_DEFINITION_CD                               
P00614                ,SENIOR_RATE_FL                                   
P00614                ,RATE_EFFECTIVE_DT                                
P00614                ,RATE_EXPIRATION_DATE                             
P00614                ,THERM_PRICE                                      
P00614                ,CSC_AMT                                          
P00614                ,EXIT_FEE                                         
P00680                ,THERM_PRC_DSCNT_FL                               
P00680                ,CSC_DSCNT_FL                                     
P00680                ,TOT_THERM_PRC_DSCNT                              
P00680                ,TOT_CSC_DSCNT                                    
P00892                ,AUTO_RENEWAL_FL                                  
P00892                ,DURATION_NO                                      
I02262                ,CORE_RATE_PLAN_DDDC                              
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE                                     
P00614              ,:S-TIER-CUST-STAT-CD                               
P00614              ,:S-TIER-ACCT-TYPE-CD                               
P00614              ,:S-MKT-TIER-RANKING                                
P00614              ,:S-CUST-ACCT-DEFLT-FL                              
P00614              ,:S-OFFER-CD                                        
P00614              ,:S-TIER-DEFLT-OFFR-CD                              
P00614              ,:S-PROMO-CD                                        
P00614              ,:S-OPTION-CD                                       
P00614              ,:S-OPTION-SORT-SEQ-NO                              
P00614              ,:S-WEB-NEW-EXISTS-CD                               
P00614              ,:S-WEB-SIGN-UP-FL                                  
P00614              ,:S-OPT-TYPE-WEB                                    
P00614              ,:S-FLEX-OPT-FL                                     
P00614              ,:S-RATE-DEFINITION-CD                              
P00614              ,:S-SENIOR-RATE-FL                                  
P00614              ,:S-RATE-EFFECTIVE-DT                               
P00614              ,:S-RATE-EXPIRATION-DATE                            
P00614              ,:S-THERM-PRICE                                     
P00614              ,:S-CSC-AMT                                         
P00614              ,:S-EXIT-FEE                                        
P00680              ,:S-THERM-PRC-DSCNT-FL                              
P00680              ,:S-CSC-DSCNT-FL                                    
P00680              ,:S-TOT-THERM-PRC-DSCNT                             
P00680              ,:S-TOT-CSC-DSCNT                                   
P00892              ,:S-AUTO-RENEWAL-FL                                 
P00836              ,:S-FXD-PRC-OPTN-DUR-NO                             
I02262              ,:S-CORE-RATE-PLAN-DDDC                             
                   )                                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR04005_R1                                  
MFA-TR*            (                                                            
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,TIER_CUST_STAT_CD                                        
MFA-TR*               ,TIER_ACCT_TYPE_CD                                        
MFA-TR*               ,MKT_TIER_RANKING                                         
MFA-TR*               ,CUST_ACCT_DEFLT_FL                                       
MFA-TR*               ,OFFER_CD                                                 
MFA-TR*               ,TIER_DEFLT_OFFR_CD                                       
MFA-TR*               ,PROMO_CD                                                 
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,OPTION_SORT_SEQ_NO                                       
MFA-TR*               ,WEB_NEW_EXISTS_CD                                        
MFA-TR*               ,WEB_SIGN_UP_FL                                           
MFA-TR*               ,OPT_TYPE_WEB                                             
MFA-TR*               ,FLEX_OPT_FL                                              
MFA-TR*               ,RATE_DEFINITION_CD                                       
MFA-TR*               ,SENIOR_RATE_FL                                           
MFA-TR*               ,RATE_EFFECTIVE_DT                                        
MFA-TR*               ,RATE_EXPIRATION_DATE                                     
MFA-TR*               ,THERM_PRICE                                              
MFA-TR*               ,CSC_AMT                                                  
MFA-TR*               ,EXIT_FEE                                                 
MFA-TR*               ,THERM_PRC_DSCNT_FL                                       
MFA-TR*               ,CSC_DSCNT_FL                                             
MFA-TR*               ,TOT_THERM_PRC_DSCNT                                      
MFA-TR*               ,TOT_CSC_DSCNT                                            
MFA-TR*               ,AUTO_RENEWAL_FL                                          
MFA-TR*               ,DURATION_NO                                              
MFA-TR*               ,CORE_RATE_PLAN_DDDC                                      
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-TIER-CUST-STAT-CD                                       
MFA-TR*             ,:S-TIER-ACCT-TYPE-CD                                       
MFA-TR*             ,:S-MKT-TIER-RANKING                                        
MFA-TR*             ,:S-CUST-ACCT-DEFLT-FL                                      
MFA-TR*             ,:S-OFFER-CD                                                
MFA-TR*             ,:S-TIER-DEFLT-OFFR-CD                                      
MFA-TR*             ,:S-PROMO-CD                                                
MFA-TR*             ,:S-OPTION-CD                                               
MFA-TR*             ,:S-OPTION-SORT-SEQ-NO                                      
MFA-TR*             ,:S-WEB-NEW-EXISTS-CD                                       
MFA-TR*             ,:S-WEB-SIGN-UP-FL                                          
MFA-TR*             ,:S-OPT-TYPE-WEB                                            
MFA-TR*             ,:S-FLEX-OPT-FL                                             
MFA-TR*             ,:S-RATE-DEFINITION-CD                                      
MFA-TR*             ,:S-SENIOR-RATE-FL                                          
MFA-TR*             ,:S-RATE-EFFECTIVE-DT                                       
MFA-TR*             ,:S-RATE-EXPIRATION-DATE                                    
MFA-TR*             ,:S-THERM-PRICE                                             
MFA-TR*             ,:S-CSC-AMT                                                 
MFA-TR*             ,:S-EXIT-FEE                                                
MFA-TR*             ,:S-THERM-PRC-DSCNT-FL                                      
MFA-TR*             ,:S-CSC-DSCNT-FL                                            
MFA-TR*             ,:S-TOT-THERM-PRC-DSCNT                                     
MFA-TR*             ,:S-TOT-CSC-DSCNT                                           
MFA-TR*             ,:S-AUTO-RENEWAL-FL                                         
MFA-TR*             ,:S-FXD-PRC-OPTN-DUR-NO                                     
MFA-TR*             ,:S-CORE-RATE-PLAN-DDDC                                     
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04005_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8200-SEND-RESULT.                                              *        
      ******************************************************************        
       8200-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR04005_R2'                               
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL                                                     
                                                                        
               INSERT INTO #CSR04005_R2                          
                   (                                                    
                       RETURN_CODE                                      
                      ,TIER_CUST_STAT_CD                                
                      ,TIER_ACCT_TYPE_CD                                
                      ,MKT_TIER_RANKING                                 
                      ,MKT_TIER_START_DT                                
                      ,MKT_TIER_END_DT                                  
                      ,MKT_TIER_DESC                                    
                      ,TIER_OFFER_VIEW                                  
                      ,OFFER_CD                                         
                      ,OFFER_TIER_STRT_DT                               
                      ,OFFER_TIER_END_DT                                
                      ,TIER_DEFLT_OFFR_CD                               
                      ,OFFER_START_DT                                   
                      ,OFFER_END_DT                                     
                      ,OFFER_DESC_EXT                                   
                      ,PROMO_CD_EXT_FL                                  
                      ,SPCL_OFFER_TYPE_CD                               
                      ,OPTION_CD                                        
                      ,CURR_EXT_DESC_LONG                               
                      ,WEB_DESC_LONG                                    
                      ,CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,OPTION_START_DT                                  
                      ,OPTION_END_DT                                    
                      ,OPTION_SORT_SEQ_NO                               
                      ,THERM_PRICE                                      
                      ,CSC_AMT                                          
                      ,PROMO_CD                                         
I01095                ,WEB_MKT_DESC_LONG                                
I01095                ,RATE_EFFECTIVE_DT                                
I01095                ,RATE_EXPIRATION_DATE                             
I01095                ,EXIT_FEE                                         
P00485                ,RATE_DEFINITION_CD                               
P00544                ,OPT_CALC_TYPE_CD                                 
P00544                ,OPT_TYPE_WEB                                     
P00680                ,THERM_PRC_DSCNT_FL                               
P00680                ,CSC_DSCNT_FL                                     
P00680                ,TOT_THERM_PRC_DSCNT                              
P00680                ,TOT_CSC_DSCNT                                    
P00680                ,THERM_PRC_DSCNT_A_DESC                           
P00680                ,THERM_PRC_DSCNT_A_VAL                            
P00680                ,THERM_PRC_DSCNT_A_DUR                            
P00680                ,THERM_PRC_DSCNT_B_DESC                           
P00680                ,THERM_PRC_DSCNT_B_VAL                            
P00680                ,THERM_PRC_DSCNT_B_DUR                            
P00680                ,THERM_PRC_DSCNT_C_DESC                           
P00680                ,THERM_PRC_DSCNT_C_VAL                            
P00680                ,THERM_PRC_DSCNT_C_DUR                            
P00680                ,THERM_PRC_DSCNT_D_DESC                           
P00680                ,THERM_PRC_DSCNT_D_VAL                            
P00680                ,THERM_PRC_DSCNT_D_DUR                            
P00680                ,THERM_PRC_DSCNT_E_DESC                           
P00680                ,THERM_PRC_DSCNT_E_VAL                            
P00680                ,THERM_PRC_DSCNT_E_DUR                            
P00680                ,CSC_DSCNT_A_DESC                                 
P00680                ,CSC_DSCNT_A_VAL                                  
P00680                ,CSC_DSCNT_A_DUR                                  
P00680                ,CSC_DSCNT_B_DESC                                 
P00680                ,CSC_DSCNT_B_VAL                                  
P00680                ,CSC_DSCNT_B_DUR                                  
P00680                ,CSC_DSCNT_C_DESC                                 
P00680                ,CSC_DSCNT_C_VAL                                  
P00680                ,CSC_DSCNT_C_DUR                                  
P00680                ,CSC_DSCNT_D_DESC                                 
P00680                ,CSC_DSCNT_D_VAL                                  
P00680                ,CSC_DSCNT_D_DUR                                  
P00680                ,CSC_DSCNT_E_DESC                                 
P00680                ,CSC_DSCNT_E_VAL                                  
P00680                ,CSC_DSCNT_E_DUR                                  
P00892                ,AUTO_RENEWAL_FL                                  
P00836                ,DURATION_NO                                      
I02262                ,CORE_RATE_PLAN_DDDC                              
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE                                     
                    ,:S-TIER-CUST-STAT-CD                               
                    ,:S-TIER-ACCT-TYPE-CD                               
                    ,:S-MKT-TIER-RANKING                                
                    ,:S-MKT-TIER-START-DT                               
                    ,:S-MKT-TIER-END-DT                                 
                    ,:S-MKT-TIER-DESC                                   
                    ,:S-TIER-OFFER-VIEW                                 
                    ,:S-OFFER-CD                                        
                    ,:S-OFFER-TIER-STRT-DT                              
                    ,:S-OFFER-TIER-END-DT                               
                    ,:S-TIER-DEFLT-OFFR-CD                              
                    ,:S-OFFER-START-DT                                  
                    ,:S-OFFER-END-DT                                    
                    ,:S-OFFER-DESC-EXT                                  
                    ,:S-PROMO-CD-EXT-FL                                 
                    ,:S-SPCL-OFFER-TYPE-CD                              
                    ,:S-OPTION-CD                                       
                    ,:S-CURR-EXT-DESC-LONG                              
                    ,:S-WEB-DESC-LONG                                   
                    ,:S-CODE-UTIL-TYPE                                  
                    ,:S-RATE-PLAN-NO                                    
                    ,:S-OPTION-START-DT                                 
                    ,:S-OPTION-END-DT                                   
                    ,:S-OPTION-SORT-SEQ-NO                              
                    ,:S-THERM-PRICE                                     
                    ,:S-CSC-AMT                                         
                    ,:S-PROMO-CD                                        
I01095              ,:S-WEB-MKT-DESC-LONG                               
I01095              ,:S-RATE-EFFECTIVE-DT                               
I01095              ,:S-RATE-EXPIRATION-DATE                            
I01095              ,:S-EXIT-FEE                                        
P00485              ,:S-RATE-DEFINITION-CD                              
P00544              ,:S-OPT-CALC-TYPE-CD                                
P00544              ,:S-OPT-TYPE-WEB                                    
P00680              ,:S-THERM-PRC-DSCNT-FL                              
P00680              ,:S-CSC-DSCNT-FL                                    
P00680              ,:S-TOT-THERM-PRC-DSCNT                             
P00680              ,:S-TOT-CSC-DSCNT                                   
P00680              ,:S-THERM-PRC-DSCNT-A-DESC                          
P00680              ,:S-THERM-PRC-DSCNT-A-VAL                           
P00680              ,:S-THERM-PRC-DSCNT-A-DUR                           
P00680              ,:S-THERM-PRC-DSCNT-B-DESC                          
P00680              ,:S-THERM-PRC-DSCNT-B-VAL                           
P00680              ,:S-THERM-PRC-DSCNT-B-DUR                           
P00680              ,:S-THERM-PRC-DSCNT-C-DESC                          
P00680              ,:S-THERM-PRC-DSCNT-C-VAL                           
P00680              ,:S-THERM-PRC-DSCNT-C-DUR                           
P00680              ,:S-THERM-PRC-DSCNT-D-DESC                          
P00680              ,:S-THERM-PRC-DSCNT-D-VAL                           
P00680              ,:S-THERM-PRC-DSCNT-D-DUR                           
P00680              ,:S-THERM-PRC-DSCNT-E-DESC                          
P00680              ,:S-THERM-PRC-DSCNT-E-VAL                           
P00680              ,:S-THERM-PRC-DSCNT-E-DUR                           
P00680              ,:S-CSC-DSCNT-A-DESC                                
P00680              ,:S-CSC-DSCNT-A-VAL                                 
P00680              ,:S-CSC-DSCNT-A-DUR                                 
P00680              ,:S-CSC-DSCNT-B-DESC                                
P00680              ,:S-CSC-DSCNT-B-VAL                                 
P00680              ,:S-CSC-DSCNT-B-DUR                                 
P00680              ,:S-CSC-DSCNT-C-DESC                                
P00680              ,:S-CSC-DSCNT-C-VAL                                 
P00680              ,:S-CSC-DSCNT-C-DUR                                 
P00680              ,:S-CSC-DSCNT-D-DESC                                
P00680              ,:S-CSC-DSCNT-D-VAL                                 
P00680              ,:S-CSC-DSCNT-D-DUR                                 
P00680              ,:S-CSC-DSCNT-E-DESC                                
P00680              ,:S-CSC-DSCNT-E-VAL                                 
P00680              ,:S-CSC-DSCNT-E-DUR                                 
P00892              ,:S-AUTO-RENEWAL-FL                                 
P00836              ,:S-FXD-PRC-OPTN-DUR-NO                             
I02262              ,:S-CORE-RATE-PLAN-DDDC                             
                   )                                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR04005_R2                                  
MFA-TR*            (                                                            
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,TIER_CUST_STAT_CD                                        
MFA-TR*               ,TIER_ACCT_TYPE_CD                                        
MFA-TR*               ,MKT_TIER_RANKING                                         
MFA-TR*               ,MKT_TIER_START_DT                                        
MFA-TR*               ,MKT_TIER_END_DT                                          
MFA-TR*               ,MKT_TIER_DESC                                            
MFA-TR*               ,TIER_OFFER_VIEW                                          
MFA-TR*               ,OFFER_CD                                                 
MFA-TR*               ,OFFER_TIER_STRT_DT                                       
MFA-TR*               ,OFFER_TIER_END_DT                                        
MFA-TR*               ,TIER_DEFLT_OFFR_CD                                       
MFA-TR*               ,OFFER_START_DT                                           
MFA-TR*               ,OFFER_END_DT                                             
MFA-TR*               ,OFFER_DESC_EXT                                           
MFA-TR*               ,PROMO_CD_EXT_FL                                          
MFA-TR*               ,SPCL_OFFER_TYPE_CD                                       
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,CURR_EXT_DESC_LONG                                       
MFA-TR*               ,WEB_DESC_LONG                                            
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,OPTION_START_DT                                          
MFA-TR*               ,OPTION_END_DT                                            
MFA-TR*               ,OPTION_SORT_SEQ_NO                                       
MFA-TR*               ,THERM_PRICE                                              
MFA-TR*               ,CSC_AMT                                                  
MFA-TR*               ,PROMO_CD                                                 
MFA-TR*               ,WEB_MKT_DESC_LONG                                        
MFA-TR*               ,RATE_EFFECTIVE_DT                                        
MFA-TR*               ,RATE_EXPIRATION_DATE                                     
MFA-TR*               ,EXIT_FEE                                                 
MFA-TR*               ,RATE_DEFINITION_CD                                       
MFA-TR*               ,OPT_CALC_TYPE_CD                                         
MFA-TR*               ,OPT_TYPE_WEB                                             
MFA-TR*               ,THERM_PRC_DSCNT_FL                                       
MFA-TR*               ,CSC_DSCNT_FL                                             
MFA-TR*               ,TOT_THERM_PRC_DSCNT                                      
MFA-TR*               ,TOT_CSC_DSCNT                                            
MFA-TR*               ,THERM_PRC_DSCNT_A_DESC                                   
MFA-TR*               ,THERM_PRC_DSCNT_A_VAL                                    
MFA-TR*               ,THERM_PRC_DSCNT_A_DUR                                    
MFA-TR*               ,THERM_PRC_DSCNT_B_DESC                                   
MFA-TR*               ,THERM_PRC_DSCNT_B_VAL                                    
MFA-TR*               ,THERM_PRC_DSCNT_B_DUR                                    
MFA-TR*               ,THERM_PRC_DSCNT_C_DESC                                   
MFA-TR*               ,THERM_PRC_DSCNT_C_VAL                                    
MFA-TR*               ,THERM_PRC_DSCNT_C_DUR                                    
MFA-TR*               ,THERM_PRC_DSCNT_D_DESC                                   
MFA-TR*               ,THERM_PRC_DSCNT_D_VAL                                    
MFA-TR*               ,THERM_PRC_DSCNT_D_DUR                                    
MFA-TR*               ,THERM_PRC_DSCNT_E_DESC                                   
MFA-TR*               ,THERM_PRC_DSCNT_E_VAL                                    
MFA-TR*               ,THERM_PRC_DSCNT_E_DUR                                    
MFA-TR*               ,CSC_DSCNT_A_DESC                                         
MFA-TR*               ,CSC_DSCNT_A_VAL                                          
MFA-TR*               ,CSC_DSCNT_A_DUR                                          
MFA-TR*               ,CSC_DSCNT_B_DESC                                         
MFA-TR*               ,CSC_DSCNT_B_VAL                                          
MFA-TR*               ,CSC_DSCNT_B_DUR                                          
MFA-TR*               ,CSC_DSCNT_C_DESC                                         
MFA-TR*               ,CSC_DSCNT_C_VAL                                          
MFA-TR*               ,CSC_DSCNT_C_DUR                                          
MFA-TR*               ,CSC_DSCNT_D_DESC                                         
MFA-TR*               ,CSC_DSCNT_D_VAL                                          
MFA-TR*               ,CSC_DSCNT_D_DUR                                          
MFA-TR*               ,CSC_DSCNT_E_DESC                                         
MFA-TR*               ,CSC_DSCNT_E_VAL                                          
MFA-TR*               ,CSC_DSCNT_E_DUR                                          
MFA-TR*               ,AUTO_RENEWAL_FL                                          
MFA-TR*               ,DURATION_NO                                              
MFA-TR*               ,CORE_RATE_PLAN_DDDC                                      
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-TIER-CUST-STAT-CD                                       
MFA-TR*             ,:S-TIER-ACCT-TYPE-CD                                       
MFA-TR*             ,:S-MKT-TIER-RANKING                                        
MFA-TR*             ,:S-MKT-TIER-START-DT                                       
MFA-TR*             ,:S-MKT-TIER-END-DT                                         
MFA-TR*             ,:S-MKT-TIER-DESC                                           
MFA-TR*             ,:S-TIER-OFFER-VIEW                                         
MFA-TR*             ,:S-OFFER-CD                                                
MFA-TR*             ,:S-OFFER-TIER-STRT-DT                                      
MFA-TR*             ,:S-OFFER-TIER-END-DT                                       
MFA-TR*             ,:S-TIER-DEFLT-OFFR-CD                                      
MFA-TR*             ,:S-OFFER-START-DT                                          
MFA-TR*             ,:S-OFFER-END-DT                                            
MFA-TR*             ,:S-OFFER-DESC-EXT                                          
MFA-TR*             ,:S-PROMO-CD-EXT-FL                                         
MFA-TR*             ,:S-SPCL-OFFER-TYPE-CD                                      
MFA-TR*             ,:S-OPTION-CD                                               
MFA-TR*             ,:S-CURR-EXT-DESC-LONG                                      
MFA-TR*             ,:S-WEB-DESC-LONG                                           
MFA-TR*             ,:S-CODE-UTIL-TYPE                                          
MFA-TR*             ,:S-RATE-PLAN-NO                                            
MFA-TR*             ,:S-OPTION-START-DT                                         
MFA-TR*             ,:S-OPTION-END-DT                                           
MFA-TR*             ,:S-OPTION-SORT-SEQ-NO                                      
MFA-TR*             ,:S-THERM-PRICE                                             
MFA-TR*             ,:S-CSC-AMT                                                 
MFA-TR*             ,:S-PROMO-CD                                                
MFA-TR*             ,:S-WEB-MKT-DESC-LONG                                       
MFA-TR*             ,:S-RATE-EFFECTIVE-DT                                       
MFA-TR*             ,:S-RATE-EXPIRATION-DATE                                    
MFA-TR*             ,:S-EXIT-FEE                                                
MFA-TR*             ,:S-RATE-DEFINITION-CD                                      
MFA-TR*             ,:S-OPT-CALC-TYPE-CD                                        
MFA-TR*             ,:S-OPT-TYPE-WEB                                            
MFA-TR*             ,:S-THERM-PRC-DSCNT-FL                                      
MFA-TR*             ,:S-CSC-DSCNT-FL                                            
MFA-TR*             ,:S-TOT-THERM-PRC-DSCNT                                     
MFA-TR*             ,:S-TOT-CSC-DSCNT                                           
MFA-TR*             ,:S-THERM-PRC-DSCNT-A-DESC                                  
MFA-TR*             ,:S-THERM-PRC-DSCNT-A-VAL                                   
MFA-TR*             ,:S-THERM-PRC-DSCNT-A-DUR                                   
MFA-TR*             ,:S-THERM-PRC-DSCNT-B-DESC                                  
MFA-TR*             ,:S-THERM-PRC-DSCNT-B-VAL                                   
MFA-TR*             ,:S-THERM-PRC-DSCNT-B-DUR                                   
MFA-TR*             ,:S-THERM-PRC-DSCNT-C-DESC                                  
MFA-TR*             ,:S-THERM-PRC-DSCNT-C-VAL                                   
MFA-TR*             ,:S-THERM-PRC-DSCNT-C-DUR                                   
MFA-TR*             ,:S-THERM-PRC-DSCNT-D-DESC                                  
MFA-TR*             ,:S-THERM-PRC-DSCNT-D-VAL                                   
MFA-TR*             ,:S-THERM-PRC-DSCNT-D-DUR                                   
MFA-TR*             ,:S-THERM-PRC-DSCNT-E-DESC                                  
MFA-TR*             ,:S-THERM-PRC-DSCNT-E-VAL                                   
MFA-TR*             ,:S-THERM-PRC-DSCNT-E-DUR                                   
MFA-TR*             ,:S-CSC-DSCNT-A-DESC                                        
MFA-TR*             ,:S-CSC-DSCNT-A-VAL                                         
MFA-TR*             ,:S-CSC-DSCNT-A-DUR                                         
MFA-TR*             ,:S-CSC-DSCNT-B-DESC                                        
MFA-TR*             ,:S-CSC-DSCNT-B-VAL                                         
MFA-TR*             ,:S-CSC-DSCNT-B-DUR                                         
MFA-TR*             ,:S-CSC-DSCNT-C-DESC                                        
MFA-TR*             ,:S-CSC-DSCNT-C-VAL                                         
MFA-TR*             ,:S-CSC-DSCNT-C-DUR                                         
MFA-TR*             ,:S-CSC-DSCNT-D-DESC                                        
MFA-TR*             ,:S-CSC-DSCNT-D-VAL                                         
MFA-TR*             ,:S-CSC-DSCNT-D-DUR                                         
MFA-TR*             ,:S-CSC-DSCNT-E-DESC                                        
MFA-TR*             ,:S-CSC-DSCNT-E-VAL                                         
MFA-TR*             ,:S-CSC-DSCNT-E-DUR                                         
MFA-TR*             ,:S-AUTO-RENEWAL-FL                                         
MFA-TR*             ,:S-FXD-PRC-OPTN-DUR-NO                                     
MFA-TR*             ,:S-CORE-RATE-PLAN-DDDC                                     
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04005_R2'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8300-SEND-RESULT.                                              *        
      ******************************************************************        
       8300-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR04005_R3'                               
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL                                                     
                                                                        
               INSERT INTO #CSR04005_R3                          
                   (                                                    
                       RETURN_CODE                                      
                      ,TIER_CUST_STAT_CD                                
                      ,TIER_ACCT_TYPE_CD                                
                      ,MKT_TIER_RANKING                                 
                      ,MKT_TIER_START_DT                                
                      ,MKT_TIER_END_DT                                  
                      ,MKT_TIER_DESC                                    
                      ,TIER_OFFER_VIEW                                  
                      ,OFFER_CD                                         
                      ,OFFER_TIER_STRT_DT                               
                      ,OFFER_TIER_END_DT                                
                      ,TIER_DEFLT_OFFR_CD                               
                      ,OFFER_START_DT                                   
                      ,OFFER_END_DT                                     
                      ,OFFER_DESC_INT                                   
                      ,PROMO_CD_INT_FL                                  
                      ,SPCL_OFFER_TYPE_CD                               
                      ,OPTION_CD                                        
                      ,OPT_DESC_INT                                     
                      ,OPT_DESC_INT_LONG                                
                      ,CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,OPTION_START_DT                                  
                      ,OPTION_END_DT                                    
                      ,OPTION_SORT_SEQ_NO                               
                      ,THERM_PRICE                                      
                      ,CSC_AMT                                          
                      ,RT_ATTR_INCTV_TYPE                               
                      ,RT_ATTR_INCTV_DESC                               
                      ,ATTR_INCTV_SEQ_NO                                
                      ,DURATION_NO                                      
                      ,ATTR_INCTV_VALUE                                 
                      ,ATTR_INCTV_VAL_TX                                
                      ,RATE_GRP_DESC                                    
                      ,RATE_GRP_DESC_LONG                               
                      ,RT_GRP_SORT_SEQ_NO                               
                      ,SORT_SEQ_NO                                      
                      ,PROMO_CD                                         
                      ,EXT_LANDING_PG_URL                               
                      ,INCTV_ENABLE_FLAG                                
I01095                ,INT_LANDING_PG_URL                               
P00680                ,OPT_CALC_TYPE_CD                                 
P00680                ,THERM_PRC_DSCNT_FL                               
P00680                ,CSC_DSCNT_FL                                     
P00680                ,TOT_THERM_PRC_DSCNT                              
P00680                ,TOT_CSC_DSCNT                                    
P00680                ,DSCNTD_THERM_PRC_CRM                             
P00680                ,DSCNTD_CSC_CRM                                   
NEW680                ,FCTR_LONG_DESC_CRM                               
P680P2                ,MAX_OFFER_OPT_PRICE                              
P680P2                ,PRICE_NEGOTIATION_PARM                           
P00892                ,AUTO_RENEWAL_FL                                  
OTPOOL                ,RATE_DEFINITION_CD                               
OTPOOL                ,CORE_RATE_PLAN_DDDC                              
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE                                     
                    ,:S-TIER-CUST-STAT-CD                               
                    ,:S-TIER-ACCT-TYPE-CD                               
                    ,:S-MKT-TIER-RANKING                                
                    ,:S-MKT-TIER-START-DT                               
                    ,:S-MKT-TIER-END-DT                                 
                    ,:S-MKT-TIER-DESC                                   
                    ,:S-TIER-OFFER-VIEW                                 
                    ,:S-OFFER-CD                                        
                    ,:S-OFFER-TIER-STRT-DT                              
                    ,:S-OFFER-TIER-END-DT                               
                    ,:S-TIER-DEFLT-OFFR-CD                              
                    ,:S-OFFER-START-DT                                  
                    ,:S-OFFER-END-DT                                    
                    ,:S-OFFER-DESC-INT                                  
                    ,:S-PROMO-CD-INT-FL                                 
                    ,:S-SPCL-OFFER-TYPE-CD                              
                    ,:S-OPTION-CD                                       
                    ,:S-OPT-DESC-INT                                    
                    ,:S-OPT-DESC-INT-LONG                               
                    ,:S-CODE-UTIL-TYPE                                  
                    ,:S-RATE-PLAN-NO                                    
                    ,:S-OPTION-START-DT                                 
                    ,:S-OPTION-END-DT                                   
                    ,:S-OPTION-SORT-SEQ-NO                              
                    ,:S-THERM-PRICE                                     
                    ,:S-CSC-AMT                                         
                    ,:S-RT-ATTR-INCTV-TYPE                              
                    ,:S-RT-ATTR-INCTV-DESC                              
                    ,:S-ATTR-INCTV-SEQ-NO                               
                    ,:S-DURATION-NO                                     
                    ,:S-ATTR-INCTV-VALUE                                
                    ,:S-ATTR-INCTV-VAL-TX                               
                    ,:S-RATE-GRP-DESC                                   
                    ,:S-RATE-GRP-DESC-LONG                              
                    ,:S-RT-GRP-SORT-SEQ-NO                              
                    ,:S-SORT-SEQ-NO                                     
                    ,:S-PROMO-CD                                        
                    ,:S-EXT-LANDING-PG-URL                              
                    ,:S-INCTV-ENABLE-FLAG                               
I01095              ,:S-INT-LANDING-PG-URL                              
P00680              ,:S-OPT-CALC-TYPE-CD                                
P00680              ,:S-THERM-PRC-DSCNT-FL                              
P00680              ,:S-CSC-DSCNT-FL                                    
P00680              ,:S-TOT-THERM-PRC-DSCNT                             
P00680              ,:S-TOT-CSC-DSCNT                                   
P00680              ,:S-DSCNTD-THERM-PRC-CRM                            
P00680              ,:S-DSCNTD-CSC-CRM                                  
NEW680              ,:S-FCTR-LONG-DESC-CRM                              
P680P2              ,:S-MAX-OFFER-OPT-PRICE                             
P680P2              ,:S-PRICE-NEGOTIATION-PARM                          
P00892              ,:S-AUTO-RENEWAL-FL                                 
OTPOOL              ,:S-RATE-DEFINITION-CD                              
OTPOOL              ,:S-CORE-RATE-PLAN-DDDC                             
                   )                                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR04005_R3                                  
MFA-TR*            (                                                            
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,TIER_CUST_STAT_CD                                        
MFA-TR*               ,TIER_ACCT_TYPE_CD                                        
MFA-TR*               ,MKT_TIER_RANKING                                         
MFA-TR*               ,MKT_TIER_START_DT                                        
MFA-TR*               ,MKT_TIER_END_DT                                          
MFA-TR*               ,MKT_TIER_DESC                                            
MFA-TR*               ,TIER_OFFER_VIEW                                          
MFA-TR*               ,OFFER_CD                                                 
MFA-TR*               ,OFFER_TIER_STRT_DT                                       
MFA-TR*               ,OFFER_TIER_END_DT                                        
MFA-TR*               ,TIER_DEFLT_OFFR_CD                                       
MFA-TR*               ,OFFER_START_DT                                           
MFA-TR*               ,OFFER_END_DT                                             
MFA-TR*               ,OFFER_DESC_INT                                           
MFA-TR*               ,PROMO_CD_INT_FL                                          
MFA-TR*               ,SPCL_OFFER_TYPE_CD                                       
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,OPT_DESC_INT                                             
MFA-TR*               ,OPT_DESC_INT_LONG                                        
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,OPTION_START_DT                                          
MFA-TR*               ,OPTION_END_DT                                            
MFA-TR*               ,OPTION_SORT_SEQ_NO                                       
MFA-TR*               ,THERM_PRICE                                              
MFA-TR*               ,CSC_AMT                                                  
MFA-TR*               ,RT_ATTR_INCTV_TYPE                                       
MFA-TR*               ,RT_ATTR_INCTV_DESC                                       
MFA-TR*               ,ATTR_INCTV_SEQ_NO                                        
MFA-TR*               ,DURATION_NO                                              
MFA-TR*               ,ATTR_INCTV_VALUE                                         
MFA-TR*               ,ATTR_INCTV_VAL_TX                                        
MFA-TR*               ,RATE_GRP_DESC                                            
MFA-TR*               ,RATE_GRP_DESC_LONG                                       
MFA-TR*               ,RT_GRP_SORT_SEQ_NO                                       
MFA-TR*               ,SORT_SEQ_NO                                              
MFA-TR*               ,PROMO_CD                                                 
MFA-TR*               ,EXT_LANDING_PG_URL                                       
MFA-TR*               ,INCTV_ENABLE_FLAG                                        
MFA-TR*               ,INT_LANDING_PG_URL                                       
MFA-TR*               ,OPT_CALC_TYPE_CD                                         
MFA-TR*               ,THERM_PRC_DSCNT_FL                                       
MFA-TR*               ,CSC_DSCNT_FL                                             
MFA-TR*               ,TOT_THERM_PRC_DSCNT                                      
MFA-TR*               ,TOT_CSC_DSCNT                                            
MFA-TR*               ,DSCNTD_THERM_PRC_CRM                                     
MFA-TR*               ,DSCNTD_CSC_CRM                                           
MFA-TR*               ,FCTR_LONG_DESC_CRM                                       
MFA-TR*               ,MAX_OFFER_OPT_PRICE                                      
MFA-TR*               ,PRICE_NEGOTIATION_PARM                                   
MFA-TR*               ,AUTO_RENEWAL_FL                                          
MFA-TR*               ,RATE_DEFINITION_CD                                       
MFA-TR*               ,CORE_RATE_PLAN_DDDC                                      
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-TIER-CUST-STAT-CD                                       
MFA-TR*             ,:S-TIER-ACCT-TYPE-CD                                       
MFA-TR*             ,:S-MKT-TIER-RANKING                                        
MFA-TR*             ,:S-MKT-TIER-START-DT                                       
MFA-TR*             ,:S-MKT-TIER-END-DT                                         
MFA-TR*             ,:S-MKT-TIER-DESC                                           
MFA-TR*             ,:S-TIER-OFFER-VIEW                                         
MFA-TR*             ,:S-OFFER-CD                                                
MFA-TR*             ,:S-OFFER-TIER-STRT-DT                                      
MFA-TR*             ,:S-OFFER-TIER-END-DT                                       
MFA-TR*             ,:S-TIER-DEFLT-OFFR-CD                                      
MFA-TR*             ,:S-OFFER-START-DT                                          
MFA-TR*             ,:S-OFFER-END-DT                                            
MFA-TR*             ,:S-OFFER-DESC-INT                                          
MFA-TR*             ,:S-PROMO-CD-INT-FL                                         
MFA-TR*             ,:S-SPCL-OFFER-TYPE-CD                                      
MFA-TR*             ,:S-OPTION-CD                                               
MFA-TR*             ,:S-OPT-DESC-INT                                            
MFA-TR*             ,:S-OPT-DESC-INT-LONG                                       
MFA-TR*             ,:S-CODE-UTIL-TYPE                                          
MFA-TR*             ,:S-RATE-PLAN-NO                                            
MFA-TR*             ,:S-OPTION-START-DT                                         
MFA-TR*             ,:S-OPTION-END-DT                                           
MFA-TR*             ,:S-OPTION-SORT-SEQ-NO                                      
MFA-TR*             ,:S-THERM-PRICE                                             
MFA-TR*             ,:S-CSC-AMT                                                 
MFA-TR*             ,:S-RT-ATTR-INCTV-TYPE                                      
MFA-TR*             ,:S-RT-ATTR-INCTV-DESC                                      
MFA-TR*             ,:S-ATTR-INCTV-SEQ-NO                                       
MFA-TR*             ,:S-DURATION-NO                                             
MFA-TR*             ,:S-ATTR-INCTV-VALUE                                        
MFA-TR*             ,:S-ATTR-INCTV-VAL-TX                                       
MFA-TR*             ,:S-RATE-GRP-DESC                                           
MFA-TR*             ,:S-RATE-GRP-DESC-LONG                                      
MFA-TR*             ,:S-RT-GRP-SORT-SEQ-NO                                      
MFA-TR*             ,:S-SORT-SEQ-NO                                             
MFA-TR*             ,:S-PROMO-CD                                                
MFA-TR*             ,:S-EXT-LANDING-PG-URL                                      
MFA-TR*             ,:S-INCTV-ENABLE-FLAG                                       
MFA-TR*             ,:S-INT-LANDING-PG-URL                                      
MFA-TR*             ,:S-OPT-CALC-TYPE-CD                                        
MFA-TR*             ,:S-THERM-PRC-DSCNT-FL                                      
MFA-TR*             ,:S-CSC-DSCNT-FL                                            
MFA-TR*             ,:S-TOT-THERM-PRC-DSCNT                                     
MFA-TR*             ,:S-TOT-CSC-DSCNT                                           
MFA-TR*             ,:S-DSCNTD-THERM-PRC-CRM                                    
MFA-TR*             ,:S-DSCNTD-CSC-CRM                                          
MFA-TR*             ,:S-FCTR-LONG-DESC-CRM                                      
MFA-TR*             ,:S-MAX-OFFER-OPT-PRICE                                     
MFA-TR*             ,:S-PRICE-NEGOTIATION-PARM                                  
MFA-TR*             ,:S-AUTO-RENEWAL-FL                                         
MFA-TR*             ,:S-RATE-DEFINITION-CD                                      
MFA-TR*             ,:S-CORE-RATE-PLAN-DDDC                                     
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04005_R3'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8400-SEND-RESULT.                                              *        
      ******************************************************************        
       8400-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR04005_R4'                               
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL                                                     
                                                                        
               INSERT INTO #CSR04005_R4                          
                   (                                                    
                       RETURN_CODE                                      
                      ,TIER_CUST_STAT_CD                                
                      ,TIER_ACCT_TYPE_CD                                
                      ,MKT_TIER_RANKING                                 
                      ,MKT_TIER_START_DT                                
                      ,MKT_TIER_END_DT                                  
                      ,MKT_TIER_DESC                                    
                      ,TIER_OFFER_VIEW                                  
                      ,OFFER_CD                                         
                      ,OFFER_TIER_STRT_DT                               
                      ,OFFER_TIER_END_DT                                
                      ,TIER_DEFLT_OFFR_CD                               
                      ,OFFER_START_DT                                   
                      ,OFFER_END_DT                                     
                      ,OFFER_DESC_EXT                                   
                      ,PROMO_CD_EXT_FL                                  
                      ,SPCL_OFFER_TYPE_CD                               
                      ,OPTION_CD                                        
                      ,CURR_EXT_DESC_LONG                               
                      ,CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,OPTION_START_DT                                  
                      ,OPTION_END_DT                                    
                      ,OPTION_SORT_SEQ_NO                               
                      ,THERM_PRICE                                      
                      ,CSC_AMT                                          
                      ,RT_ATTR_INCTV_TYPE                               
                      ,RT_ATTR_INCTV_DESC                               
                      ,ATTR_INCTV_SEQ_NO                                
                      ,DURATION_NO                                      
                      ,ATTR_INCTV_VALUE                                 
                      ,ATTR_INCTV_VAL_TX                                
                      ,RATE_GRP_DESC                                    
                      ,RATE_GRP_DESC_LONG                               
                      ,RT_GRP_SORT_SEQ_NO                               
                      ,SORT_SEQ_NO                                      
                      ,PROMO_CD                                         
                      ,EXT_LANDING_PG_URL                               
                      ,INCTV_ENABLE_FLAG                                
I01095                ,INT_LANDING_PG_URL                               
P00680                ,OPT_CALC_TYPE_CD                                 
P00680                ,THERM_PRC_DSCNT_FL                               
P00680                ,CSC_DSCNT_FL                                     
P00680                ,TOT_THERM_PRC_DSCNT                              
P00680                ,TOT_CSC_DSCNT                                    
P00680                ,DSCNTD_THERM_PRC_CRM                             
P00680                ,DSCNTD_CSC_CRM                                   
NEW680                ,FCTR_LONG_DESC_CRM                               
P680P2                ,MAX_OFFER_OPT_PRICE                              
P680P2                ,PRICE_NEGOTIATION_PARM                           
P00892                ,AUTO_RENEWAL_FL                                  
OTPOOL                ,RATE_DEFINITION_CD                               
OTPOOL                ,CORE_RATE_PLAN_DDDC                              
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE                                     
                    ,:S-TIER-CUST-STAT-CD                               
                    ,:S-TIER-ACCT-TYPE-CD                               
                    ,:S-MKT-TIER-RANKING                                
                    ,:S-MKT-TIER-START-DT                               
                    ,:S-MKT-TIER-END-DT                                 
                    ,:S-MKT-TIER-DESC                                   
                    ,:S-TIER-OFFER-VIEW                                 
                    ,:S-OFFER-CD                                        
                    ,:S-OFFER-TIER-STRT-DT                              
                    ,:S-OFFER-TIER-END-DT                               
                    ,:S-TIER-DEFLT-OFFR-CD                              
                    ,:S-OFFER-START-DT                                  
                    ,:S-OFFER-END-DT                                    
                    ,:S-OFFER-DESC-EXT                                  
                    ,:S-PROMO-CD-EXT-FL                                 
                    ,:S-SPCL-OFFER-TYPE-CD                              
                    ,:S-OPTION-CD                                       
                    ,:S-CURR-EXT-DESC-LONG                              
                    ,:S-CODE-UTIL-TYPE                                  
                    ,:S-RATE-PLAN-NO                                    
                    ,:S-OPTION-START-DT                                 
                    ,:S-OPTION-END-DT                                   
                    ,:S-OPTION-SORT-SEQ-NO                              
                    ,:S-THERM-PRICE                                     
                    ,:S-CSC-AMT                                         
                    ,:S-RT-ATTR-INCTV-TYPE                              
                    ,:S-RT-ATTR-INCTV-DESC                              
                    ,:S-ATTR-INCTV-SEQ-NO                               
                    ,:S-DURATION-NO                                     
                    ,:S-ATTR-INCTV-VALUE                                
                    ,:S-ATTR-INCTV-VAL-TX                               
                    ,:S-RATE-GRP-DESC                                   
                    ,:S-RATE-GRP-DESC-LONG                              
                    ,:S-RT-GRP-SORT-SEQ-NO                              
                    ,:S-SORT-SEQ-NO                                     
                    ,:S-PROMO-CD                                        
                    ,:S-EXT-LANDING-PG-URL                              
                    ,:S-INCTV-ENABLE-FLAG                               
I01095              ,:S-INT-LANDING-PG-URL                              
P00680              ,:S-OPT-CALC-TYPE-CD                                
P00680              ,:S-THERM-PRC-DSCNT-FL                              
P00680              ,:S-CSC-DSCNT-FL                                    
P00680              ,:S-TOT-THERM-PRC-DSCNT                             
P00680              ,:S-TOT-CSC-DSCNT                                   
P00680              ,:S-DSCNTD-THERM-PRC-CRM                            
P00680              ,:S-DSCNTD-CSC-CRM                                  
NEW680              ,:S-FCTR-LONG-DESC-CRM                              
P680P2              ,:S-MAX-OFFER-OPT-PRICE                             
P680P2              ,:S-PRICE-NEGOTIATION-PARM                          
P00892              ,:S-AUTO-RENEWAL-FL                                 
OTPOOL              ,:S-RATE-DEFINITION-CD                              
OTPOOL              ,:S-CORE-RATE-PLAN-DDDC                             
                   )                                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR04005_R4                                  
MFA-TR*            (                                                            
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,TIER_CUST_STAT_CD                                        
MFA-TR*               ,TIER_ACCT_TYPE_CD                                        
MFA-TR*               ,MKT_TIER_RANKING                                         
MFA-TR*               ,MKT_TIER_START_DT                                        
MFA-TR*               ,MKT_TIER_END_DT                                          
MFA-TR*               ,MKT_TIER_DESC                                            
MFA-TR*               ,TIER_OFFER_VIEW                                          
MFA-TR*               ,OFFER_CD                                                 
MFA-TR*               ,OFFER_TIER_STRT_DT                                       
MFA-TR*               ,OFFER_TIER_END_DT                                        
MFA-TR*               ,TIER_DEFLT_OFFR_CD                                       
MFA-TR*               ,OFFER_START_DT                                           
MFA-TR*               ,OFFER_END_DT                                             
MFA-TR*               ,OFFER_DESC_EXT                                           
MFA-TR*               ,PROMO_CD_EXT_FL                                          
MFA-TR*               ,SPCL_OFFER_TYPE_CD                                       
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,CURR_EXT_DESC_LONG                                       
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,OPTION_START_DT                                          
MFA-TR*               ,OPTION_END_DT                                            
MFA-TR*               ,OPTION_SORT_SEQ_NO                                       
MFA-TR*               ,THERM_PRICE                                              
MFA-TR*               ,CSC_AMT                                                  
MFA-TR*               ,RT_ATTR_INCTV_TYPE                                       
MFA-TR*               ,RT_ATTR_INCTV_DESC                                       
MFA-TR*               ,ATTR_INCTV_SEQ_NO                                        
MFA-TR*               ,DURATION_NO                                              
MFA-TR*               ,ATTR_INCTV_VALUE                                         
MFA-TR*               ,ATTR_INCTV_VAL_TX                                        
MFA-TR*               ,RATE_GRP_DESC                                            
MFA-TR*               ,RATE_GRP_DESC_LONG                                       
MFA-TR*               ,RT_GRP_SORT_SEQ_NO                                       
MFA-TR*               ,SORT_SEQ_NO                                              
MFA-TR*               ,PROMO_CD                                                 
MFA-TR*               ,EXT_LANDING_PG_URL                                       
MFA-TR*               ,INCTV_ENABLE_FLAG                                        
MFA-TR*               ,INT_LANDING_PG_URL                                       
MFA-TR*               ,OPT_CALC_TYPE_CD                                         
MFA-TR*               ,THERM_PRC_DSCNT_FL                                       
MFA-TR*               ,CSC_DSCNT_FL                                             
MFA-TR*               ,TOT_THERM_PRC_DSCNT                                      
MFA-TR*               ,TOT_CSC_DSCNT                                            
MFA-TR*               ,DSCNTD_THERM_PRC_CRM                                     
MFA-TR*               ,DSCNTD_CSC_CRM                                           
MFA-TR*               ,FCTR_LONG_DESC_CRM                                       
MFA-TR*               ,MAX_OFFER_OPT_PRICE                                      
MFA-TR*               ,PRICE_NEGOTIATION_PARM                                   
MFA-TR*               ,AUTO_RENEWAL_FL                                          
MFA-TR*               ,RATE_DEFINITION_CD                                       
MFA-TR*               ,CORE_RATE_PLAN_DDDC                                      
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-TIER-CUST-STAT-CD                                       
MFA-TR*             ,:S-TIER-ACCT-TYPE-CD                                       
MFA-TR*             ,:S-MKT-TIER-RANKING                                        
MFA-TR*             ,:S-MKT-TIER-START-DT                                       
MFA-TR*             ,:S-MKT-TIER-END-DT                                         
MFA-TR*             ,:S-MKT-TIER-DESC                                           
MFA-TR*             ,:S-TIER-OFFER-VIEW                                         
MFA-TR*             ,:S-OFFER-CD                                                
MFA-TR*             ,:S-OFFER-TIER-STRT-DT                                      
MFA-TR*             ,:S-OFFER-TIER-END-DT                                       
MFA-TR*             ,:S-TIER-DEFLT-OFFR-CD                                      
MFA-TR*             ,:S-OFFER-START-DT                                          
MFA-TR*             ,:S-OFFER-END-DT                                            
MFA-TR*             ,:S-OFFER-DESC-EXT                                          
MFA-TR*             ,:S-PROMO-CD-EXT-FL                                         
MFA-TR*             ,:S-SPCL-OFFER-TYPE-CD                                      
MFA-TR*             ,:S-OPTION-CD                                               
MFA-TR*             ,:S-CURR-EXT-DESC-LONG                                      
MFA-TR*             ,:S-CODE-UTIL-TYPE                                          
MFA-TR*             ,:S-RATE-PLAN-NO                                            
MFA-TR*             ,:S-OPTION-START-DT                                         
MFA-TR*             ,:S-OPTION-END-DT                                           
MFA-TR*             ,:S-OPTION-SORT-SEQ-NO                                      
MFA-TR*             ,:S-THERM-PRICE                                             
MFA-TR*             ,:S-CSC-AMT                                                 
MFA-TR*             ,:S-RT-ATTR-INCTV-TYPE                                      
MFA-TR*             ,:S-RT-ATTR-INCTV-DESC                                      
MFA-TR*             ,:S-ATTR-INCTV-SEQ-NO                                       
MFA-TR*             ,:S-DURATION-NO                                             
MFA-TR*             ,:S-ATTR-INCTV-VALUE                                        
MFA-TR*             ,:S-ATTR-INCTV-VAL-TX                                       
MFA-TR*             ,:S-RATE-GRP-DESC                                           
MFA-TR*             ,:S-RATE-GRP-DESC-LONG                                      
MFA-TR*             ,:S-RT-GRP-SORT-SEQ-NO                                      
MFA-TR*             ,:S-SORT-SEQ-NO                                             
MFA-TR*             ,:S-PROMO-CD                                                
MFA-TR*             ,:S-EXT-LANDING-PG-URL                                      
MFA-TR*             ,:S-INCTV-ENABLE-FLAG                                       
MFA-TR*             ,:S-INT-LANDING-PG-URL                                      
MFA-TR*             ,:S-OPT-CALC-TYPE-CD                                        
MFA-TR*             ,:S-THERM-PRC-DSCNT-FL                                      
MFA-TR*             ,:S-CSC-DSCNT-FL                                            
MFA-TR*             ,:S-TOT-THERM-PRC-DSCNT                                     
MFA-TR*             ,:S-TOT-CSC-DSCNT                                           
MFA-TR*             ,:S-DSCNTD-THERM-PRC-CRM                                    
MFA-TR*             ,:S-DSCNTD-CSC-CRM                                          
MFA-TR*             ,:S-FCTR-LONG-DESC-CRM                                      
MFA-TR*             ,:S-MAX-OFFER-OPT-PRICE                                     
MFA-TR*             ,:S-PRICE-NEGOTIATION-PARM                                  
MFA-TR*             ,:S-AUTO-RENEWAL-FL                                         
MFA-TR*             ,:S-RATE-DEFINITION-CD                                      
MFA-TR*             ,:S-CORE-RATE-PLAN-DDDC                                     
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04005_R4'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *                                                                         
           IF I-CALL-TYPE = 'CRM'                                       
              IF I-INT-EXT-DATA-FL  = 'I'                               
                 EXEC SQL                                               
                  OPEN C3                                               
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
              ELSE                                                      
                 EXEC SQL                                               
                  OPEN C4                                               
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
              END-IF                                                    
           ELSE                                                         
P00614        IF I-CALL-TYPE = 'ECS'                                    
                 EXEC SQL                                               
                  OPEN C1                                               
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
              ELSE                                                      
                 EXEC SQL                                               
                  OPEN C2                                               
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
                                                                        
               ROLLBACK                                                 
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
P00614     EVALUATE TRUE                                                
P00614         WHEN I-CALL-TYPE  = 'ECS'                                
P00614              PERFORM 8100-SEND-RESULT  THRU  8100-EXIT           
P00614         WHEN I-CALL-TYPE  = 'WEB'                                
P00614              PERFORM 8200-SEND-RESULT  THRU  8200-EXIT           
P00614         WHEN (I-CALL-TYPE = 'CRM' AND I-INT-EXT-DATA-FL = 'I')   
P00614              PERFORM 8300-SEND-RESULT  THRU 8300-EXIT            
P00614         WHEN (I-CALL-TYPE = 'CRM' AND I-INT-EXT-DATA-FL = 'E')   
P00614              PERFORM 8400-SEND-RESULT  THRU 8400-EXIT            
P00614     END-EVALUATE.                                                
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9100-CHECK-ERROR                                               *        
      ******************************************************************        
       9100-CHECK-ERROR.                                                
           EXIT.                                                        
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
