       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR03984.                                       
       AUTHOR.       JIJU CHOVVA.                                       
COB303 DATE-WRITTEN. MAY 15, 2006.                                       
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03984              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03984 :                                                --         
      *--                                                            --         
      *--  #  INVOKED FROM CRM APPL, INSERTS FACTORS TO CIS TABLES.  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            CODE_UTIL_TYPE        CHAR(01)                  --         
      *--            BILL_NO               CHAR(09)                  --         
      *--            IC_NO                 CHAR(04)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            RETURN_CODE           CHAR(9)                   --         
      *--            REV_MONTH_BILD        CHAR(06)                  --         
      *--            ORIG_REV_MONTH_BILD   CHAR(06)                  --         
      *--            CHRG_DESC             CHAR(54)                  --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--     MULTIPLE                                               --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
C34569*--  05/15/2007    JC91900     PROGRAM INTIALLY WRITTEN.       --         
P00892*--  04/14/2015    VIJAY       FIXED RATE AUTO RENEWAL CHANGES --         
ACT086*--  02/19/2016    MUTHU       REMOVE THE DCLGEN COPYBOOK      --         
ACT086*--  A04860                    TBMFWQ FOR TABLE CSS_WQ_ITEMS_MF--         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03984'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCOUNT, AT                                               *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBACCT                                                 
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_ACCT_ATTRIBUTE, YP                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBACTATT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_AR_CNTL, AC                                               *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBARCNTL                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_ACCT_RTPK_AGR, DF                                         *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBACCTRG                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BILLING_DET, BG                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBLLDET                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BILLING_HDR, BI                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBLLHDR                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_CNSMPTN_HIST, CX                                          *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCNSMP                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_CREDIT_HIST, CK                                                     
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCRHIST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY, C8                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBDELQ                                                 
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_FIXED_FCTR, FF                                            *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFXDFCT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_FIXED_FCT_HIST, FH                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFXHST                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CRM_RT_PKG_OPTION, FI                                                   
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRTPKGO                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_JOB_PARM, G6                                              *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBJBPARM                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_MNT_TRANS_HIST, MH                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMNHIST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_MT_TRN_HST_DET, MI                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMNHDT                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CRM_OPT_ATTR_INCTV, HQ                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBOPTATT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_READ_WINDOW, RW                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRDWNDW                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CRM_RT_ATTR_INCTV, G7                                         *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRTINCT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_SPCL_FCTR, SF                                             *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBSPLFTR                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_SPCL_FCT_CMPNT, SK                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFCTCMP                                               
            END-EXEC.                                                           
      *****************************************************************         
      * CSS_SPCL_FCTR_APPL, SA                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBSPLAPL                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_SPCL_FCTR_ATTR, SY                                                  
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBSPFCAT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_USER_PROFILE, PF                                                    
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBUSRPRF                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_UTL_ENVRMNT , UT                                                    
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR 326.                            *        
      ******************************************************************        
           COPY CWS00326.                                                       
                                                                        
      ******************************************************************        
      *    WQ CREATION COPYBOOK.                                       *        
      ******************************************************************        
           COPY CWS0070B.                                                       
                                                                        
      ***************************************************************** 00165600
      * COPYBOOK FOR THE WORKING STORAGE THAT IS TUNED FOR BATCH      * 00165700
      ***************************************************************** 00165800
            EXEC SQL                                                            
                 INCLUDE CWS00327                                               
            END-EXEC.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
      *    COPY CWS00010.                                                       
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE             PIC X(05) VALUE SPACES.           
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE             VALUE 'N'.                    
              88 ALL-DONE                 VALUE 'Y'.                    
           05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR          VALUE 'N'.                    
              88 SEND-DONE-OK             VALUE 'Y'.                    
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME            PIC X(08) VALUE 'CSR03984'.       
           05 MCSCB326                PIC X(08) VALUE 'MCSCB326'.       
           05 WS-N                    PIC X(01) VALUE 'N'.              
           05 GTT-NAME                PIC X(26)                         
                                            VALUE 'SESSION.CSR03984_R1'.
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05 RS-IC-NO                  PIC X(04)  VALUE SPACES.        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05  S-IC-NO                  PIC X(04)  VALUE SPACES.        
                                                                        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PGMID                PIC X(08).                    
       01  PARM-ACCOUNT-NO                PIC X(13).                    
       01  PARM-CODE-UTIL-TYPE            PIC X(01).                    
       01  PARM-IC-NO                     PIC X(04).                    
       01  PARM-OPTION-CD                 PIC X(12).                    
       01  PARM-OFFER-CD                  PIC X(12).                    
       01  PARM-TRANS-SEQ-ID              PIC X(04).                    
       01  PARM-PROMO-CD                  PIC X(12).                    
       01  PARM-COMM-CHANNEL              PIC X(01).                    
       01  PARM-CREATED-USER-ID           PIC X(07).                    
       01  PARM-PROCESS-CD                PIC X(01).                    
       01  PARM-OPT-AGRMT-EFF-DT          PIC X(10).                    
       01  PARM-OPT-AGRMT-EFF-TM          PIC X(08).                    
       01  PARM-EXIT-FEE-FLAG             PIC X(01).                    
       01  PARM-EXIT-FEE-AMT              PIC X(11).                    
       01  PARM-PREV-OPT-CODE             PIC X(12).                    
       01  PARM-RATE-PLAN-NO              PIC X(03).                    
       01  PARM-CUST-AGRD-THERM           PIC X(11).                    
       01  PARM-CODE-REV-CLASS            PIC X(03).                    
       01  PARM-TIER-ACCT-TYPE-CD         PIC X(01).                    
       01  PARM-TIER-CUST-STAT-CD         PIC X(01).                    
       01  PARM-MKT-TIER-RANKING          PIC X(04).                    
       01  PARM-MKT-TIER-START-DT         PIC X(10).                    
P00892 01  PARM-AUTO-REN-OPT-IN-FL        PIC X(01).                    
                                                                        
       PROCEDURE DIVISION  USING PARM-APPL-PGMID                        
                                 PARM-ACCOUNT-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-IC-NO                             
                                 PARM-OPTION-CD                         
                                 PARM-OFFER-CD                          
                                 PARM-TRANS-SEQ-ID                      
                                 PARM-PROMO-CD                          
                                 PARM-COMM-CHANNEL                      
                                 PARM-CREATED-USER-ID                   
                                 PARM-PROCESS-CD                        
                                 PARM-OPT-AGRMT-EFF-DT                  
                                 PARM-OPT-AGRMT-EFF-TM                  
                                 PARM-EXIT-FEE-FLAG                     
                                 PARM-EXIT-FEE-AMT                      
                                 PARM-PREV-OPT-CODE                     
                                 PARM-RATE-PLAN-NO                      
                                 PARM-CUST-AGRD-THERM                   
                                 PARM-CODE-REV-CLASS                    
                                 PARM-TIER-ACCT-TYPE-CD                 
                                 PARM-TIER-CUST-STAT-CD                 
                                 PARM-MKT-TIER-RANKING                  
                                 PARM-MKT-TIER-START-DT                 
P00892                           PARM-AUTO-REN-OPT-IN-FL.               
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
                 SELECT :S-RETURN-CODE AS RETURN_CODE                   
                       ,:S-IC-NO       AS IC_NO                         
                   FROM CIS.SYSDUMMY1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*          SELECT :S-RETURN-CODE AS RETURN_CODE                           
MFA-TR*                ,:S-IC-NO       AS IC_NO                                 
MFA-TR*            FROM SYSIBM.SYSDUMMY1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO-O            
           MOVE PARM-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE-O        
           MOVE PARM-IC-NO                TO WS-IC-NO-O                 
           MOVE PARM-OPTION-CD            TO WS-OPTION-CD-O             
           MOVE PARM-OFFER-CD             TO WS-OFFER-CD-O              
           MOVE PARM-TRANS-SEQ-ID         TO WS-TRANS-SEQ-ID-O          
           MOVE PARM-PROMO-CD             TO WS-PROMO-CD-O              
           MOVE PARM-COMM-CHANNEL         TO WS-COMM-CHANNEL-O          
           MOVE PARM-CREATED-USER-ID      TO WS-CREATED-USER-ID-O       
           MOVE PARM-PROCESS-CD           TO WS-PROCESS-CD-O            
           MOVE PARM-OPT-AGRMT-EFF-DT     TO WS-OPT-AGRMT-EFF-DT-O      
           MOVE PARM-OPT-AGRMT-EFF-TM     TO WS-OPT-AGRMT-EFF-TM-O      
           MOVE PARM-EXIT-FEE-FLAG        TO WS-EXIT-FEE-FLAG-O         
           MOVE PARM-EXIT-FEE-AMT         TO WS-EXIT-FEE-AMT-O          
           MOVE PARM-PREV-OPT-CODE        TO WS-PREV-OPT-CODE-O         
           MOVE PARM-RATE-PLAN-NO         TO WS-RATE-PLAN-NO-O          
           MOVE PARM-CUST-AGRD-THERM      TO WS-CUST-AGRD-THERM-O.      
           MOVE PARM-CODE-REV-CLASS       TO WS-CODE-REV-CLASS-O.       
           MOVE PARM-TIER-ACCT-TYPE-CD    TO WS-TIER-ACCT-TYPE-CD-O     
           MOVE PARM-TIER-CUST-STAT-CD    TO WS-TIER-CUST-STAT-CD-O     
           MOVE PARM-MKT-TIER-RANKING     TO WS-MKT-TIER-RANKING-O      
           MOVE PARM-MKT-TIER-START-DT    TO WS-MKT-TIER-START-DT-O     
           MOVE PARM-APPL-PGMID           TO WS-APPL-PGMID.             
P00892     MOVE PARM-AUTO-REN-OPT-IN-FL   TO WS-AUTO-REN-OPT-IN-FL-O.   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 6000-START-APPLYING-FCTRS   THRU 6000-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
            MOVE RS-IC-NO                   TO S-IC-NO.                 
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-START-APPLYING-FCTRS.                                    *         
      *****************************************************************         
       6000-START-APPLYING-FCTRS.                                       
                                                                        
           CALL MCSCB326 USING ABEND-FILE                               
                              ,WS-WARNING-DATA-ELEMENTS                 
                              ,LS-MCSCB326-CALL-TYPE                    
                              ,LS-MCSCB326-ONLINE-CALL                  
                              ,LS-MCSCB326-RET-FIELDS.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL ZEROES                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              MOVE WS-NEW-IC-NO              TO S-IC-NO                 
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
              ADD +1                    TO CTR-ROWS.                    
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
                                                                        
