       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR03977.                                          
       DATE-WRITTEN.  NOV 17, 2008.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE SERVICE ORDER NUMBERS FOR THE      *        
      *  THE SPECIFIC COMPANY NO, WORK AREA ID, ORDERTYPE CODE, CREW ID*        
      *  GIVEN AS INPUT                                                *        
      *                                                                *        
      *  PROGRAM:       CSR03977                                       *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  11/17/08  SJ94244    CONVERTED SPDB CSR03977 TO CSR03977(SPCN)*        
P0795 *  09/26/15  LH12766    ADDED CODE FOR MOD.  RETURN REMARKS,     *        
P0795 *                       PREMISE NO AND ACCOUNT NO                         
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  5100 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03977'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03977 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      * DB2 INCLUDES                                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT - AT                                              *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ZIP_CODE - A4                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SO_ORDER_INST - VI                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_WORK_TYPE - L4                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SO_REQUIREMENT - EG                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOREQ                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SO_CREW - TE                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOCREW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SO_DATA - VO                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ORDER_TYPE - C2                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_REQ_PROCESS - TB                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBREQPRO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_FORMATTED - DY                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SO_ERROR_MSG - S6                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSERMSG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_PREMISE - PR                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_WK_CLASS_STAT - R6                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWKCST                                                   
           END-EXEC.                                                            
                                                                        
P0795 ******************************************************************        
P0795 * CSS_SO_REMARKS    - EF                                         *        
P0795 ******************************************************************        
P0795      EXEC SQL                                                             
P0795         INCLUDE TBSOREM                                                   
P0795      END-EXEC.                                                            
                                                                        
P0795 ******************************************************************        
P0795 * CSS_NAME_ACCT_XREF- HT                                         *        
P0795 ******************************************************************        
P0795      EXEC SQL                                                             
P0795         INCLUDE TBNMACTX                                                  
P0795      END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *  SQL ERRORS                                                             
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
COB305     05 RS-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  RS-ORDER-PRIORITY-CD    PIC S9(04)   USAGE COMP.         
           05  RS-WORK-AREA-ID         PIC X(12)    VALUE SPACES.       
           05  RS-ASSIGNED-DATETIME    PIC X(26)    VALUE SPACES.       
           05  RS-WANTED-BY-DATETIME   PIC X(26)    VALUE SPACES.       
           05  RS-ORDER-STATE-CD       PIC X(01)    VALUE SPACES.       
           05  RS-STATUS-TX            PIC X(25)    VALUE SPACES.       
COB305     05 RS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  RS-PROJECT-TITLE        PIC X(40)    VALUE SPACES.       
           05  RS-CREW-ID              PIC X(06)    VALUE SPACES.       
           05  RS-APPOINTMENT-FL       PIC X(01)    VALUE SPACES.       
P0795      05  RS-PREMISE-NO           PIC S9(10)V COMP-3 VALUE 0.      
P0795      05  RS-ACCOUNT-NO           PIC S9(13)V COMP-3 VALUE 0.      
P0795      05  RS-ACCOUNT-NO-PRIOR     PIC S9(13)V COMP-3 VALUE 0.      
P0795      05  RS-REMARK-FL            PIC X(1)   VALUE 'N'.            
P0795      05  RS-REMARK-TX            PIC X(210) VALUE SPACES.         
P0795      05  RS-CUSTOMER-NO          PIC S9(10)V COMP-3 VALUE 0.      
                                                                        
       01  FLAGS.                                                       
           05 WS-T1A-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T1A-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T1B-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T1B-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T1C-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T1C-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T1D-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T1D-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T2A-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T2A-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T2B-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T2B-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T2C-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T2C-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T2D-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T2D-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T3A-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T3A-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T3B-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T3B-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T3C-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T3C-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
           05 WS-T3D-CURSOR-ROWS        PIC X(01)    VALUE 'N'.         
              88 NO-T3D-CURSOR-ROWS                  VALUE 'Y'.         
                                                                        
                                                                        
       01  WS-GENERAL-WORKING-STORAGE.                                  
           05 PROGRAM-NAME             PIC X(08)    VALUE 'CSR03977'.   
                                                                        
       01  WS-MISC.                                                     
           05 WS-APPT-AM-PM-CD         PIC X(01)    VALUE SPACES.       
COB305     05 WS-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
COB305     05 WS-SERV-ORDER-NO-OLD        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.       
           05 WS-PANEL-NO              PIC X(03)    VALUE SPACES.       
           05 WS-COMPANY-NO            PIC X(02)    VALUE SPACES.       
           05 WS-ORDER-TYPE-CD         PIC X(05)    VALUE SPACES.       
           05 WS-OPEN-CURSOR-C2        PIC X(01)    VALUE SPACES.       
           05 WS-ORDER-PRIORITY-CD     PIC S9(04)   USAGE COMP.         
           05 WS-WORK-AREA-ID          PIC X(12)    VALUE SPACES.       
           05 WS-ASSIGNED-DATETIME     PIC X(26)    VALUE SPACES.       
           05 WS-WANTED-BY-DATETIME    PIC X(26)    VALUE SPACES.       
           05 WS-ORDER-STATE-CD        PIC X(01)    VALUE SPACES.       
           05 WS-STATUS-TX             PIC X(25)    VALUE SPACES.       
COB305     05 WS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05 WS-ORDER-TYPE-DESC       PIC X(40)    VALUE SPACES.       
           05 WS-CREW-ID               PIC X(06)    VALUE SPACES.       
           05 WS-TEMP-ROWS             PIC S9(04)   COMP VALUE 0.       
P0795      05 WS-PREMISE-NO            PIC S9(10)V COMP-3 VALUE 0.      
P0795      05 WS-ACCOUNT-NO            PIC S9(13)V COMP-3 VALUE 0.      
P0795      05 WS-ACCOUNT-NO-PRIOR      PIC S9(13)V COMP-3 VALUE 0.      
P0795      05 WS-REMARK-TX             PIC X(210) VALUE SPACES.         
P0795      05 WS-REMARK-FL             PIC X      VALUE 'N'.            
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01)    VALUE 'N'.          
               88 NOT-ALL-DONE                      VALUE 'N'.          
               88 ALL-DONE                          VALUE 'Y'.          
           05  SEND-DONE-SW            PIC X(01)    VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
                                                                        
       01 IND-VARIABLES.                                                
           05 WS-NULL1                 PIC S9(04)   COMP VALUE 0.       
           05 WS-NULL2                 PIC S9(04)   COMP VALUE 0.       
           05 WS-NULL3                 PIC S9(04)   COMP VALUE 0.       
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)    VALUE SPACES.       
           10  S-SQLCODE               PIC S9(9)    COMP VALUE 0.       
           10  S-SQLSTATE              PIC X(5)     VALUE ' '.          
           10  S-TABLE-NAME            PIC X(18)    VALUE SPACES.       
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4)    USAGE COMP.         
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4)    USAGE COMP.         
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4)    USAGE COMP.         
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4)    USAGE COMP.         
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05)    VALUE SPACES.       
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE RESULTANT CURSOR                 **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
                SELECT  ST.SERV_ORDER_NO         AS SERV_ORDER_NO       
                       ,LTRIM(RTRIM(ST.PROJECT_TITLE))  AS PROJECT_TITLE       
                       ,ST.ORDER_PRIORITY_CD     AS ORDER_PRIORITY_CD   
                       ,ST.WORK_AREA_ID          AS WORK_AREA_ID        
                       ,ST.CREW_ID               AS CREW_ID             
                       ,ST.ASSIGNED_DATETIME     AS ASSIGNED_DATETIME   
                       ,ST.WANTED_BY_DATETIME    AS WANTED_BY_DATETIME  
                       ,ST.STATUS_TX             AS STATUS_TX           
                       ,ST.ORDER_STATE_CD        AS ORDER_STATE_CD      
                       ,ST.APPOINTMENT_FL        AS APPOINTMENT_FL      
                       ,L4.WORK_TYPE_DESC        AS WORK_TYPE_DESC      
                       ,LTRIM(RTRIM(DY.HOUSE_NO))       AS HOUSE_NO            
                       ,LTRIM(RTRIM(DY.STREET_NAME))    AS STREET_NAME         
                       ,LTRIM(RTRIM(DY.STREET_SUFFIX))  AS STREET_SUFFIX       
                       ,LTRIM(RTRIM(A4.TOWN))           AS TOWN                
                       ,VI.RLSE_NO               AS RLSE_NO             
                       ,VI.HOLD_RELEASE          AS HOLD_RELEASE        
                       ,VI.CODE_UTIL_TYPE        AS CODE_UTIL_TYPE      
                       ,' '                                             
                       ,ST.PREMISE_NO            AS PREMISE_NO          
                       ,ST.ACCOUNT_NO            AS ACCOUNT_NO          
                       ,ST.ACCOUNT_NO_PRIOR AS ACCOUNT_NO_PRIOR         
                       ,ST.REMARK_FL        AS REMARK_FL                
                       ,ST.REMARK_TX        AS REMARK_TX                
                       ,ST.CUSTOMER_NO      AS CUSTOMER_NO              
                  FROM #SESSION_T1 ST,                           
                       CSS_ADDR_FORMATTED DY,                           
                       CSS_ZIP_CODE A4,                                 
                       CSS_SO_ORDER_INST VI,                            
                       CSS_WORK_TYPE L4                                 
                 WHERE (VI.SERV_ORDER_NO  = ST.SERV_ORDER_NO)           
                   AND (DY.ADDRESS_ID     = ST.ADDRESS_ID)              
                   AND (A4.ZIP_CODE       = DY.ZIP_CODE)                
                   AND (A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN)          
                   AND (L4.COMPANY_NO     = :WS-COMPANY-NO)             
                   AND (L4.WORK_TYPE_CD   = VI.WORK_TYPE_CD)            
                 ORDER BY ST.ASSIGNED_DATETIME          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR* SQL175
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*         SELECT  ST.SERV_ORDER_NO         AS SERV_ORDER_NO               
MFA-TR*                ,STRIP(ST.PROJECT_TITLE)  AS PROJECT_TITLE               
MFA-TR*                ,ST.ORDER_PRIORITY_CD     AS ORDER_PRIORITY_CD           
MFA-TR*                ,ST.WORK_AREA_ID          AS WORK_AREA_ID                
MFA-TR*                ,ST.CREW_ID               AS CREW_ID                     
MFA-TR*                ,ST.ASSIGNED_DATETIME     AS ASSIGNED_DATETIME           
MFA-TR*                ,ST.WANTED_BY_DATETIME    AS WANTED_BY_DATETIME          
MFA-TR*                ,ST.STATUS_TX             AS STATUS_TX                   
MFA-TR*                ,ST.ORDER_STATE_CD        AS ORDER_STATE_CD              
MFA-TR*                ,ST.APPOINTMENT_FL        AS APPOINTMENT_FL              
MFA-TR*                ,L4.WORK_TYPE_DESC        AS WORK_TYPE_DESC              
MFA-TR*                ,STRIP(DY.HOUSE_NO)       AS HOUSE_NO                    
MFA-TR*                ,STRIP(DY.STREET_NAME)    AS STREET_NAME                 
MFA-TR*                ,STRIP(DY.STREET_SUFFIX)  AS STREET_SUFFIX               
MFA-TR*                ,STRIP(A4.TOWN)           AS TOWN                        
MFA-TR*                ,VI.RLSE_NO               AS RLSE_NO                     
MFA-TR*                ,VI.HOLD_RELEASE          AS HOLD_RELEASE                
MFA-TR*                ,VI.CODE_UTIL_TYPE        AS CODE_UTIL_TYPE              
MFA-TR*                ,' '                                                     
MFA-TR*                ,ST.PREMISE_NO            AS PREMISE_NO                  
MFA-TR*                ,ST.ACCOUNT_NO            AS ACCOUNT_NO                  
MFA-TR*                ,ST.ACCOUNT_NO_PRIOR AS ACCOUNT_NO_PRIOR                 
MFA-TR*                ,ST.REMARK_FL        AS REMARK_FL                        
MFA-TR*                ,ST.REMARK_TX        AS REMARK_TX                        
MFA-TR*                ,ST.CUSTOMER_NO      AS CUSTOMER_NO                      
MFA-TR*           FROM SESSION.SESSION_T1 ST,                                   
MFA-TR*                CSS_ADDR_FORMATTED DY,                                   
MFA-TR*                CSS_ZIP_CODE A4,                                         
MFA-TR*                CSS_SO_ORDER_INST VI,                                    
MFA-TR*                CSS_WORK_TYPE L4                                         
MFA-TR*          WHERE (VI.SERV_ORDER_NO  = ST.SERV_ORDER_NO)                   
MFA-TR*            AND (DY.ADDRESS_ID     = ST.ADDRESS_ID)                      
MFA-TR*            AND (A4.ZIP_CODE       = DY.ZIP_CODE)                        
MFA-TR*            AND (A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN)                  
MFA-TR*            AND (L4.COMPANY_NO     = :WS-COMPANY-NO)                     
MFA-TR*            AND (L4.WORK_TYPE_CD   = VI.WORK_TYPE_CD)                    
MFA-TR*          ORDER BY SESSION.SESSION_T1.ASSIGNED_DATETIME                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR FOR SELECTING THE SERV ORDER WITH CREW ID AS UNASGN  *        
      *    AND VALID CREW_ID AND VALID ORDER TYPE CD                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T1A_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO     = EG.SERV_ORDER_NO)        
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)         
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (TE.CREW_ID           IS NULL)                     
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T1A_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO     = EG.SERV_ORDER_NO)                
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)                 
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (TE.CREW_ID           IS NULL)                             
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR FOR SELECTING THE SERV ORDER WITH CREW ID AS UNASGN  *        
      *    AND VALID WORK AREA ID AND ORDER TYPE AS NULL               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T1B_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO     = EG.SERV_ORDER_NO)        
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (TE.CREW_ID           IS NULL)                     
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T1B_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO     = EG.SERV_ORDER_NO)                
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (TE.CREW_ID           IS NULL)                             
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR FOR SELECTING THE SERV ORDER WITH CREW ID AS UNASGN   *        
      *   AND WORK AREA ID AS NULL AND ORDER TYPE AS NULL              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T1C_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO     = EG.SERV_ORDER_NO)        
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (TE.CREW_ID           IS NULL)                     
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T1C_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO     = EG.SERV_ORDER_NO)                
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (TE.CREW_ID           IS NULL)                             
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR FOR SELECTING THE SERV ORDER WITH CREW ID AS UNASGN  *        
      *    AND WORK AREA ID AS NULL AND VALID ORDER TYPE               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T1D_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO     = EG.SERV_ORDER_NO)        
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)         
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (TE.CREW_ID           IS NULL)                     
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T1D_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO     = EG.SERV_ORDER_NO)                
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)                 
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (TE.CREW_ID           IS NULL)                             
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR FOR SELECTING THE SERV ORDER WITHOUT VALID CREW ID     *        
      *  AND ORDER TYPE AS NULL AND VALID WORK AREA ID PASSED AS INPUT *        
      *                                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T2A_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)          
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T2A_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)                  
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR FOR SELECTING THE SERV ORDER WITHOUT VALID CREW ID   *        
      *    AND ORDER TYPE AS NULL AND WORK AREA ID AS NULL             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T2B_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)          
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T2B_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)                  
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR FOR SELECTING THE SERV ORDER WITHOUT VALID CREW ID   *        
      *    AND VALID WORK AREA ID AND VALID ORDER TYPE PASSED AS INPUT *        
      *                                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T2C_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)          
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)         
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T2C_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)                  
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)                 
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR FOR SELECTING THE SERV ORDER WITHOUT VALID CREW ID    *        
      *   AND WORK AREA ID AS NULL AND VALID ORDER TYPE                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T2D_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)          
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)         
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T2D_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)                  
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)                 
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR FOR SELECTING THE SERV ORDER WITH VALID CREW ID      *        
      *    AND VALID ORDER TYPE CD AND VALID WORK AREA ID              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T3A_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)          
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)         
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (TE.CREW_ID           = :WS-CREW-ID)               
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T3A_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)                  
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)                 
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (TE.CREW_ID           = :WS-CREW-ID)                       
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR FOR SELECTING THE SERV ORDER WITH VALID CREW ID      *        
      *    AND  VALID WORK AREA ID AND ORDER TYPE CD AS NULL           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T3B_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)          
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (TE.CREW_ID           = :WS-CREW-ID)               
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T3B_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)                  
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.WORK_AREA_ID      = :WS-WORK-AREA-ID)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (TE.CREW_ID           = :WS-CREW-ID)                       
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR FOR SELECTING THE SERV ORDER WITH VALID CREW ID      *        
      *    AND WORK AREA ID AS NULL AND ORDER TYPE CD AS NULL          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T3C_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)          
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (TE.CREW_ID           = :WS-CREW-ID)               
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T3C_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)                  
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (TE.CREW_ID           = :WS-CREW-ID)                       
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR FOR SELECTING THE SERV ORDER WITH VALID CREW ID      *        
      *    AND WORK AREA ID AS NULL AND VALID ORDER TYPE CD            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE T3D_CURSOR CURSOR FOR                           
                SELECT ROUND(VO.SERV_ORDER_NO, 0),                      
                       VO.ORDER_PRIORITY_CD,                            
                       VO.WORK_AREA_ID,                                 
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                           
                       VO.ORDER_STATE_CD,                               
                       R6.STATUS_TX,                                    
                       ROUND(PR.ADDRESS_ID, 0),                         
                       C2.ORDER_TYPE_DESC,                              
                       TE.CREW_ID,                                      
                       VO.APPT_AM_PM_CD,                                
                       VO.PREMISE_NO,                                   
                       VO.ACCOUNT_NO,                                   
                       VO.ACCOUNT_NO_PRIOR                              
                  FROM CSS_SO_DATA VO LEFT OUTER JOIN                   
                       CSS_SO_CREW TE ON                                
                       VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,             
                       CSS_ORDER_TYPE C2,                               
                       CSS_WK_CLASS_STAT R6,                            
                       CSS_PREMISE PR,                                  
                       CSS_SO_REQUIREMENT EG,                           
                       CSS_REQ_PROCESS TB                               
                 WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)          
                 AND (EG.REQMNT_STAGE_CD   = 'R')                       
                 AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)         
                 AND (VO.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (C2.COMPANY_NO        = :WS-COMPANY-NO)            
                 AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')         
                 AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)          
                 AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)         
                 AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)          
                 AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)          
                 AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)      
                 AND (VO.ORDER_STATE_CD  IN ('D','B')                   
                    OR (VO.SERV_ORDER_STATUS <> '40'                    
                       AND VO.ORDER_STATE_CD NOT IN ('C','Z')))         
                 AND (TE.CREW_ID           = :WS-CREW-ID)               
                 AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)          
                 AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)      
                 AND (PR.PREMISE_NO        = VO.PREMISE_NO)             
                ORDER BY VO.SERV_ORDER_NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE T3D_CURSOR CURSOR FOR                                   
MFA-TR*         SELECT ROUND(VO.SERV_ORDER_NO, 0),                              
MFA-TR*                VO.ORDER_PRIORITY_CD,                                    
MFA-TR*                VO.WORK_AREA_ID,                                         
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ORDER_STATE_CD,                                       
MFA-TR*                R6.STATUS_TX,                                            
MFA-TR*                ROUND(PR.ADDRESS_ID, 0),                                 
MFA-TR*                C2.ORDER_TYPE_DESC,                                      
MFA-TR*                TE.CREW_ID,                                              
MFA-TR*                VO.APPT_AM_PM_CD,                                        
MFA-TR*                VO.PREMISE_NO,                                           
MFA-TR*                VO.ACCOUNT_NO,                                           
MFA-TR*                VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*           FROM CSS_SO_DATA VO LEFT OUTER JOIN                           
MFA-TR*                CSS_SO_CREW TE ON                                        
MFA-TR*                VO.SERV_ORDER_NO = TE.SERV_ORDER_NO,                     
MFA-TR*                CSS_ORDER_TYPE C2,                                       
MFA-TR*                CSS_WK_CLASS_STAT R6,                                    
MFA-TR*                CSS_PREMISE PR,                                          
MFA-TR*                CSS_SO_REQUIREMENT EG,                                   
MFA-TR*                CSS_REQ_PROCESS TB                                       
MFA-TR*          WHERE (VO.SERV_ORDER_NO   = EG.SERV_ORDER_NO)                  
MFA-TR*          AND (EG.REQMNT_STAGE_CD   = 'R')                               
MFA-TR*          AND (EG.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (EG.REQUIREMENT_CD    = TB.REQUIREMENT_CD)                 
MFA-TR*          AND (VO.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (C2.COMPANY_NO        = :WS-COMPANY-NO)                    
MFA-TR*          AND (TB.PROCESS_NA        = 'WORK_ASSIGNMENT')                 
MFA-TR*          AND (C2.WORK_CLASS_ID     = TB.WORK_CLASS_ID)                  
MFA-TR*          AND (C2.ORDER_TYPE_CD     = :WS-ORDER-TYPE-CD)                 
MFA-TR*          AND (C2.ORDER_TYPE_CD     = VO.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.ORDER_TYPE_CD     = C2.ORDER_TYPE_CD)                  
MFA-TR*          AND (VO.SERV_ORDER_STATUS = TB.SERV_ORDER_STATUS)              
MFA-TR*          AND (VO.ORDER_STATE_CD  IN ('D','B')                           
MFA-TR*             OR (VO.SERV_ORDER_STATUS <> '40'                            
MFA-TR*                AND VO.ORDER_STATE_CD NOT IN ('C','Z')))                 
MFA-TR*          AND (TE.CREW_ID           = :WS-CREW-ID)                       
MFA-TR*          AND (R6.WORK_CLASS_ID     = C2.WORK_CLASS_ID)                  
MFA-TR*          AND (R6.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS)              
MFA-TR*          AND (PR.PREMISE_NO        = VO.PREMISE_NO)                     
MFA-TR*         ORDER BY VO.SERV_ORDER_NO                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARM-PANEL-NO                     PIC X(03).                 
       01  PARM-COMPANY-NO                   PIC X(02).                 
       01  PARM-WORK-AREA-ID                 PIC X(12).                 
       01  PARM-ORDER-TYPE-CD                PIC X(05).                 
       01  PARM-CREW-ID                      PIC X(10).                 
                                                                        
       PROCEDURE DIVISION USING PARM-PANEL-NO                           
                                PARM-COMPANY-NO                         
                                PARM-WORK-AREA-ID                       
                                PARM-ORDER-TYPE-CD                      
                                PARM-CREW-ID.                           
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      **    0000-MAINLINE                                             **        
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INIT-SERVER    THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INIT-SERVER.                                                
                                                                        
           PERFORM 0100A-DECLARE-GTT      THRU 0100A-EXIT.              
           MOVE ZERO                      TO WS-SERV-ORDER-NO-OLD       
                                             WS-SERV-ORDER-NO.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#SESSION_T1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #SESSION_T1
              (                                                       
                   SERV_ORDER_NO         DECIMAL(13,0) NOT NULL         
                  ,ORDER_PRIORITY_CD     SMALLINT NOT NULL              
                  ,WORK_AREA_ID CHAR(12)  COLLATE 
                                LATIN1_GENERAL_100_BIN2 NOT NULL              
                  ,ASSIGNED_DATETIME     DATETIME2(6)                      
                  ,WANTED_BY_DATETIME    DATETIME2(6)                      
                  ,ORDER_STATE_CD CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2 NOT NULL              
                  ,STATUS_TX CHAR(25)  COLLATE 
                                LATIN1_GENERAL_100_BIN2 NOT NULL              
                  ,ADDRESS_ID            DECIMAL(13,0) NOT NULL         
                  ,PROJECT_TITLE CHAR(40)  COLLATE 
                                LATIN1_GENERAL_100_BIN2 NOT NULL              
                  ,CREW_ID CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,APPOINTMENT_FL CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,PREMISE_NO            DECIMAL(13,0) NOT NULL         
                  ,ACCOUNT_NO            DECIMAL(13,0) NOT NULL         
                  ,ACCOUNT_NO_PRIOR      DECIMAL(13,0) NOT NULL         
                  ,REMARK_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,REMARK_TX CHAR(210)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CUSTOMER_NO           DECIMAL(10,0) NOT NULL         
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE              TO WS-SQLSTATE.                   
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'SESSION_T1'          TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT        
                 PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *       RECEIVE PARMS FROM THE CLIENT AND CHECKS FOR NULL,       *        
      *       IF IT IS NULL THEN % IS ASSIGNED                         *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-PANEL-NO             TO WS-PANEL-NO.               
           MOVE PARM-COMPANY-NO           TO WS-COMPANY-NO.             
P0795      IF PARM-WORK-AREA-ID = SPACES                                
P0795          MOVE LOW-VALUES TO PARM-WORK-AREA-ID                     
P0795      END-IF.                                                      
P0795      MOVE PARM-WORK-AREA-ID         TO WS-WORK-AREA-ID.           
P0795      IF PARM-ORDER-TYPE-CD = SPACES                               
P0795          MOVE LOW-VALUES TO PARM-ORDER-TYPE-CD                    
P0795      END-IF.                                                      
           MOVE PARM-ORDER-TYPE-CD        TO WS-ORDER-TYPE-CD.          
           MOVE PARM-CREW-ID              TO WS-CREW-ID.                
                                                                        
           IF PARM-CREW-ID < SPACES                                     
              MOVE SPACES TO WS-CREW-ID                                 
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. BUILD RESULT SET                                        *        
      *     4. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
            IF ((WS-PANEL-NO < SPACES) OR                               
               (WS-COMPANY-NO < SPACES))                                
               GO TO 9999-END-PROGRAM                                   
            END-IF.                                                     
                                                                        
            IF ((WS-CREW-ID = 'UNASGN')                                 
                OR (WS-CREW-ID = SPACES)) THEN                          
               IF WS-CREW-ID = 'UNASGN'                                 
                  PERFORM 2010-PROCESS-T1-CURSOR-SERIES THRU 2010-EXIT  
               ELSE                                                     
                  PERFORM 2020-PROCESS-T2-CURSOR-SERIES THRU 2020-EXIT  
               END-IF                                                   
            ELSE                                                        
               PERFORM 2030-PROCESS-T3-CURSOR-SERIES    THRU 2030-EXIT  
            END-IF.                                                     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2010-PROCESS-T1-CURSOR-SERIES.                                  *        
      *THIS SERIES WILL BE PROCESSED WHEN CREW ID IS GIVEN AS 'UNASGN' *        
      ******************************************************************        
       2010-PROCESS-T1-CURSOR-SERIES.                                   
                                                                        
           IF (WS-WORK-AREA-ID >= SPACES AND WS-ORDER-TYPE-CD >= SPACES)
              PERFORM 7000-OPEN-T1A-CURSOR-PARA      THRU 7000-EXIT     
              PERFORM 7010-FETCH-T1A-CURSOR-PARA     THRU 7010-EXIT     
              PERFORM 2050-PROCESS-T1A-CURSOR-PARA   THRU 2050-EXIT     
                           UNTIL  (NO-T1A-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7020-CLOSE-T1A-CURSOR-PARA     THRU 7020-EXIT     
           END-IF                                                       
                                                                        
           IF (WS-WORK-AREA-ID >= SPACES AND WS-ORDER-TYPE-CD < SPACES) 
              PERFORM 7002-OPEN-T1B-CURSOR-PARA      THRU 7002-EXIT     
              PERFORM 7012-FETCH-T1B-CURSOR-PARA     THRU 7012-EXIT     
              PERFORM 2052-PROCESS-T1B-CURSOR-PARA   THRU 2052-EXIT     
                           UNTIL  (NO-T1B-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7022-CLOSE-T1B-CURSOR-PARA     THRU 7022-EXIT     
           END-IF                                                       
                                                                        
           IF (WS-WORK-AREA-ID < SPACES AND WS-ORDER-TYPE-CD < SPACES)  
              PERFORM 7004-OPEN-T1C-CURSOR-PARA      THRU 7004-EXIT     
              PERFORM 7014-FETCH-T1C-CURSOR-PARA     THRU 7014-EXIT     
              PERFORM 2054-PROCESS-T1C-CURSOR-PARA   THRU 2054-EXIT     
                           UNTIL  (NO-T1C-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7024-CLOSE-T1C-CURSOR-PARA     THRU 7024-EXIT     
           END-IF                                                       
                                                                        
           IF (WS-WORK-AREA-ID < SPACES AND WS-ORDER-TYPE-CD >= SPACES) 
              PERFORM 7006-OPEN-T1D-CURSOR-PARA      THRU 7006-EXIT     
              PERFORM 7016-FETCH-T1D-CURSOR-PARA     THRU 7016-EXIT     
              PERFORM 2056-PROCESS-T1D-CURSOR-PARA   THRU 2056-EXIT     
                           UNTIL  (NO-T1D-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7026-CLOSE-T1D-CURSOR-PARA     THRU 7026-EXIT     
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2020-PROCESS-T2-CURSOR-SERIES.                                  *        
      *THIS SERIES WILL BE PROCESSED WHEN CREW ID IS GIVEN AS NULL     *        
      ******************************************************************        
       2020-PROCESS-T2-CURSOR-SERIES.                                   
                                                                        
           IF (WS-WORK-AREA-ID >= SPACES AND WS-ORDER-TYPE-CD < SPACES) 
              PERFORM 7030-OPEN-T2A-CURSOR-PARA      THRU 7030-EXIT     
              PERFORM 7040-FETCH-T2A-CURSOR-PARA     THRU 7040-EXIT     
              PERFORM 2060-PROCESS-T2A-CURSOR-PARA   THRU 2060-EXIT     
                           UNTIL  (NO-T2A-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7050-CLOSE-T2A-CURSOR-PARA     THRU 7050-EXIT     
           END-IF                                                       
                                                                        
           IF (WS-WORK-AREA-ID < SPACES AND WS-ORDER-TYPE-CD < SPACES)  
              PERFORM 7032-OPEN-T2B-CURSOR-PARA      THRU 7032-EXIT     
              PERFORM 7042-FETCH-T2B-CURSOR-PARA     THRU 7042-EXIT     
              PERFORM 2062-PROCESS-T2B-CURSOR-PARA   THRU 2062-EXIT     
                           UNTIL  (NO-T2B-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7052-CLOSE-T2B-CURSOR-PARA     THRU 7052-EXIT     
           END-IF                                                       
                                                                        
           IF (WS-WORK-AREA-ID >= SPACES AND WS-ORDER-TYPE-CD >= SPACES)
              PERFORM 7034-OPEN-T2C-CURSOR-PARA      THRU 7034-EXIT     
              PERFORM 7044-FETCH-T2C-CURSOR-PARA     THRU 7044-EXIT     
              PERFORM 2064-PROCESS-T2C-CURSOR-PARA   THRU 2064-EXIT     
                           UNTIL  (NO-T2C-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7054-CLOSE-T2C-CURSOR-PARA     THRU 7054-EXIT     
           END-IF                                                       
                                                                        
           IF (WS-WORK-AREA-ID < SPACES AND WS-ORDER-TYPE-CD >= SPACES) 
              PERFORM 7036-OPEN-T2D-CURSOR-PARA      THRU 7036-EXIT     
              PERFORM 7046-FETCH-T2D-CURSOR-PARA     THRU 7046-EXIT     
              PERFORM 2066-PROCESS-T2D-CURSOR-PARA   THRU 2066-EXIT     
                           UNTIL  (NO-T2D-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7056-CLOSE-T2D-CURSOR-PARA     THRU 7056-EXIT     
           END-IF.                                                      
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2030-PROCESS-T3-CURSOR-SERIES.                                  *        
      *THIS SERIES WILL BE PROCESSED WHEN CREW ID IS GIVEN AS VALID    *        
      *VALUE                                                           *        
      ******************************************************************        
       2030-PROCESS-T3-CURSOR-SERIES.                                   
                                                                        
           IF (WS-WORK-AREA-ID >= SPACES AND WS-ORDER-TYPE-CD >= SPACES)
              PERFORM 7060-OPEN-T3A-CURSOR-PARA      THRU 7060-EXIT     
              PERFORM 7070-FETCH-T3A-CURSOR-PARA     THRU 7070-EXIT     
              PERFORM 2070-PROCESS-T3A-CURSOR-PARA   THRU 2070-EXIT     
                           UNTIL  (NO-T3A-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7080-CLOSE-T3A-CURSOR-PARA     THRU 7080-EXIT     
           END-IF                                                       
                                                                        
           IF (WS-WORK-AREA-ID >= SPACES AND WS-ORDER-TYPE-CD < SPACES) 
              PERFORM 7062-OPEN-T3B-CURSOR-PARA      THRU 7062-EXIT     
              PERFORM 7072-FETCH-T3B-CURSOR-PARA     THRU 7072-EXIT     
              PERFORM 2072-PROCESS-T3B-CURSOR-PARA   THRU 2072-EXIT     
                           UNTIL  (NO-T3B-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7082-CLOSE-T3B-CURSOR-PARA     THRU 7082-EXIT     
           END-IF                                                       
                                                                        
           IF (WS-WORK-AREA-ID < SPACES AND WS-ORDER-TYPE-CD < SPACES)  
              PERFORM 7064-OPEN-T3C-CURSOR-PARA      THRU 7064-EXIT     
              PERFORM 7074-FETCH-T3C-CURSOR-PARA     THRU 7074-EXIT     
              PERFORM 2074-PROCESS-T3C-CURSOR-PARA   THRU 2074-EXIT     
                           UNTIL  (NO-T3C-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7084-CLOSE-T3C-CURSOR-PARA     THRU 7084-EXIT     
           END-IF                                                       
                                                                        
           IF (WS-WORK-AREA-ID < SPACES AND WS-ORDER-TYPE-CD >= SPACES) 
              PERFORM 7066-OPEN-T3D-CURSOR-PARA      THRU 7066-EXIT     
              PERFORM 7076-FETCH-T3D-CURSOR-PARA     THRU 7076-EXIT     
              PERFORM 2076-PROCESS-T3D-CURSOR-PARA   THRU 2076-EXIT     
                           UNTIL  (NO-T3D-CURSOR-ROWS                   
                                  OR WS-TEMP-ROWS = 9990)               
              PERFORM 7086-CLOSE-T3D-CURSOR-PARA     THRU 7086-EXIT     
           END-IF.                                                      
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2050-PROCESS-T1A-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2050-PROCESS-T1A-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7010-FETCH-T1A-CURSOR-PARA  THRU 7010-EXIT.          
                                                                        
       2050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2052-PROCESS-T1B-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2052-PROCESS-T1B-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7012-FETCH-T1B-CURSOR-PARA  THRU 7012-EXIT.          
                                                                        
       2052-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2054-PROCESS-T1C-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2054-PROCESS-T1C-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7014-FETCH-T1C-CURSOR-PARA  THRU 7014-EXIT.          
                                                                        
       2054-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2056-PROCESS-T1D-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2056-PROCESS-T1D-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7016-FETCH-T1D-CURSOR-PARA  THRU 7016-EXIT.          
                                                                        
       2056-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2060-PROCESS-T2A-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2060-PROCESS-T2A-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7040-FETCH-T2A-CURSOR-PARA  THRU 7040-EXIT.          
                                                                        
       2060-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2062-PROCESS-T2B-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2062-PROCESS-T2B-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7042-FETCH-T2B-CURSOR-PARA  THRU 7042-EXIT.          
                                                                        
       2062-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2064-PROCESS-T2C-CURSOR-PARA                                  *         
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2064-PROCESS-T2C-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7044-FETCH-T2C-CURSOR-PARA  THRU 7044-EXIT.          
                                                                        
       2064-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2066-PROCESS-T2D-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2066-PROCESS-T2D-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7046-FETCH-T2D-CURSOR-PARA  THRU 7046-EXIT.          
                                                                        
       2066-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2070-PROCESS-T3A-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2070-PROCESS-T3A-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7070-FETCH-T3A-CURSOR-PARA  THRU 7070-EXIT.          
                                                                        
       2070-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2072-PROCESS-T3B-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2072-PROCESS-T3B-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7072-FETCH-T3B-CURSOR-PARA  THRU 7072-EXIT.          
                                                                        
       2072-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2074-PROCESS-T3C-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2074-PROCESS-T3C-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7074-FETCH-T3C-CURSOR-PARA  THRU 7074-EXIT.          
                                                                        
       2074-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2076-PROCESS-T3D-CURSOR-PARA                                   *        
      *     THIS PARA IS USED TO MOVE DATA TO SESSION_T1 TEMP TABLE    *        
      ******************************************************************        
       2076-PROCESS-T3D-CURSOR-PARA.                                    
      *                                                                         
           IF VO-SERV-ORDER-NO NOT = WS-SERV-ORDER-NO-OLD THEN          
              MOVE VO-SERV-ORDER-NO         TO WS-SERV-ORDER-NO         
              MOVE VO-ORDER-PRIORITY-CD     TO WS-ORDER-PRIORITY-CD     
              MOVE VO-WORK-AREA-ID          TO WS-WORK-AREA-ID          
              MOVE VO-ASSIGNED-DATETIME     TO WS-ASSIGNED-DATETIME     
              MOVE VO-WANTED-BY-DATETIME    TO WS-WANTED-BY-DATETIME    
              MOVE VO-ORDER-STATE-CD        TO WS-ORDER-STATE-CD        
              MOVE R6-STATUS-TX             TO WS-STATUS-TX             
              MOVE PR-ADDRESS-ID            TO WS-ADDRESS-ID            
              MOVE C2-ORDER-TYPE-DESC       TO WS-ORDER-TYPE-DESC       
              MOVE TE-CREW-ID               TO WS-CREW-ID               
              IF VO-APPT-AM-PM-CD = SPACES                              
                 MOVE 'N'                   TO WS-APPT-AM-PM-CD         
              ELSE                                                      
                 MOVE 'Y'                   TO WS-APPT-AM-PM-CD         
              END-IF                                                    
P0795         MOVE VO-PREMISE-NO            TO WS-PREMISE-NO            
P0795         MOVE VO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P0795         MOVE VO-ACCOUNT-NO-PRIOR      TO WS-ACCOUNT-NO-PRIOR      
      *                                                                         
              PERFORM 2100-MOVE-RESULTS     THRU 2100-EXIT              
              PERFORM 8100-SEND-RESULT-T1   THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
           MOVE VO-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-OLD.    
           COMPUTE WS-TEMP-ROWS  = WS-TEMP-ROWS + 1                     
      *                                                                         
           PERFORM 2800-INIT-PROCESS-VARIABLES THRU 2800-EXIT.          
           PERFORM 7076-FETCH-T3D-CURSOR-PARA  THRU 7076-EXIT.          
                                                                        
       2076-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2800-INIT-PROCESS-VARIABLES.                                    *        
      *INITIALIZE THE VARIABLES AFTER THE FETCH PROCESS                *        
      ******************************************************************        
       2800-INIT-PROCESS-VARIABLES.                                     
                                                                        
           INITIALIZE WS-SERV-ORDER-NO                                  
                      WS-ORDER-PRIORITY-CD                              
                      WS-WORK-AREA-ID                                   
                      WS-ASSIGNED-DATETIME                              
                      WS-WANTED-BY-DATETIME                             
                      WS-ORDER-STATE-CD                                 
                      WS-STATUS-TX                                      
                      WS-ADDRESS-ID                                     
                      WS-ORDER-TYPE-DESC                                
                      WS-CREW-ID                                        
                      WS-APPT-AM-PM-CD                                  
                      VO-SERV-ORDER-NO                                  
                      VO-ORDER-PRIORITY-CD                              
                      VO-WORK-AREA-ID                                   
                      VO-ASSIGNED-DATETIME                              
                      VO-WANTED-BY-DATETIME                             
                      VO-ORDER-STATE-CD                                 
                      R6-STATUS-TX                                      
                      PR-ADDRESS-ID                                     
                      C2-ORDER-TYPE-DESC                                
                      TE-CREW-ID                                        
P0795                 VO-PREMISE-NO                                     
P0795                 VO-ACCOUNT-NO                                     
P0795                 VO-ACCOUNT-NO-PRIOR.                              
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100 MOVE RESULTS                                              *        
      * THIS PARA MOVES THE DATA TO THE RS-FIELDS                      *        
      ******************************************************************        
       2100-MOVE-RESULTS.                                               
                                                                        
           MOVE WS-SERV-ORDER-NO            TO RS-SERV-ORDER-NO.        
           MOVE WS-ORDER-PRIORITY-CD        TO RS-ORDER-PRIORITY-CD.    
           MOVE WS-WORK-AREA-ID             TO RS-WORK-AREA-ID.         
           MOVE WS-ASSIGNED-DATETIME        TO RS-ASSIGNED-DATETIME.    
           MOVE WS-WANTED-BY-DATETIME       TO RS-WANTED-BY-DATETIME.   
           MOVE WS-ORDER-STATE-CD           TO RS-ORDER-STATE-CD.       
           MOVE WS-STATUS-TX                TO RS-STATUS-TX.            
           MOVE WS-ADDRESS-ID               TO RS-ADDRESS-ID.           
           MOVE WS-ORDER-TYPE-DESC          TO RS-PROJECT-TITLE.        
           MOVE WS-CREW-ID                  TO RS-CREW-ID.              
           MOVE WS-APPT-AM-PM-CD            TO RS-APPOINTMENT-FL.       
                                                                        
P0795      PERFORM 2150-SELECT-SO-REMARKS THRU 2150-EXIT.               
P0795      MOVE WS-PREMISE-NO               TO RS-PREMISE-NO.           
P0795      MOVE WS-ACCOUNT-NO               TO RS-ACCOUNT-NO.           
P0795      MOVE WS-ACCOUNT-NO-PRIOR         TO RS-ACCOUNT-NO-PRIOR.     
P0795      MOVE WS-REMARK-FL                TO RS-REMARK-FL             
P0795      MOVE WS-REMARK-TX                TO RS-REMARK-TX.            
P0795      MOVE ZEROS                       TO WS-CUSTOMER-NO.          
P0795      PERFORM 2155-SELECT-CUSTOMER-NO THRU 2155-EXIT.              
P0795      MOVE WS-CUSTOMER-NO TO RS-CUSTOMER-NO.                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0795 ******************************************************************        
P0795 * 2150-SELECT CSS_SO_REMARKS                                     *        
P0795 * THIS PARA IS USED TO SELECT THE REMARKS                        *        
P0795 ******************************************************************        
P0795                                                                   
P0795  2150-SELECT-SO-REMARKS.                                          
P0795                                                                   
P0795      MOVE '2150-SELECT-SO-REMARKS' TO ACTIVE-PARAGRAPH.           
P0795      MOVE 'N' TO WS-REMARK-FL.                                    
P0795      MOVE SPACES TO EF-REMARK-TX.                                 
P0795                                                                   
P0795      EXEC SQL                                                     
P0795          SELECT TOP(1) REMARK_TX                                         
P0795             INTO  :EF-REMARK-TX                                   
P0795             FROM  CSS_SO_REMARKS RM WITH(READUNCOMMITTED)                 
P0795             WHERE RM.SERV_ORDER_NO = :WS-SERV-ORDER-NO            
P0795               AND RM.REMARK_TYPE_CD = 'G'                         
P0795             ORDER BY REMARK_DATETIME DESC                         
P0795                                            
P0795                                                            
P0795      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REMARK_TX                                                 
MFA-TR*           INTO  :EF-REMARK-TX                                           
MFA-TR*           FROM  CSS_SO_REMARKS RM                                       
MFA-TR*           WHERE RM.SERV_ORDER_NO = :WS-SERV-ORDER-NO                    
MFA-TR*             AND RM.REMARK_TYPE_CD = 'G'                                 
MFA-TR*           ORDER BY REMARK_DATETIME DESC                                 
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795                                                                   
P0795      MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P0795                                                                   
P0795      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0795         MOVE 'Y' TO WS-REMARK-FL                                  
P0795         MOVE EF-REMARK-TX-TEXT TO WS-REMARK-TX                    
P0795      ELSE                                                         
P0795          IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
P0795             MOVE 'N' TO WS-REMARK-FL                              
P0795             MOVE SPACES TO EF-REMARK-TX                           
P0795          ELSE                                                     
P0795              MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
P0795              MOVE SQLCODE            TO ABEND-SQLCODE             
P0795              MOVE SQLSTATE           TO ABEND-SQLSTATE            
P0795              MOVE '2150'             TO ACTIVE-PARAGRAPH          
P0795              MOVE 'SELECT'           TO ABEND-FUNCTION            
P0795              MOVE 'CSS_SO_REMARKS'   TO TABLE-1                   
P0795              MOVE 'SERV_ORDER_NO'    TO TABLE-ELEMENT-1           
P0795              MOVE WS-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1         
P0795              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P0795              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P0795          END-IF                                                   
P0795      END-IF.                                                      
P0795                                                                   
P0795  2150-EXIT.                                                       
P0795      EXIT.                                                        
                                                                        
P0795 ******************************************************************        
P0795 * 2155-SELECT-CUSTOMER-NO                                        *        
P0795 * THIS PARA IS USED TO SELECT THE CUSTOMER NO                    *        
P0795 ******************************************************************        
P0795                                                                   
P0795  2155-SELECT-CUSTOMER-NO.                                         
P0795                                                                   
P0795      MOVE '2155-SELECT-CUSTOMER-NO' TO ACTIVE-PARAGRAPH.          
P0795      MOVE ZEROES TO HT-CUSTOMER-NO.                               
P0795                                                                   
P0795      EXEC SQL                                                     
P0795          SELECT TOP(1) CUSTOMER_NO                                       
P0795             INTO  :HT-CUSTOMER-NO                                 
P0795             FROM  CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)            
P0795             WHERE HT.ACCOUNT_NO = :WS-ACCOUNT-NO                  
P0795                                            
P0795                                                            
P0795      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*           INTO  :HT-CUSTOMER-NO                                         
MFA-TR*           FROM  CSS_NAME_ACCT_XREF  HT                                  
MFA-TR*           WHERE HT.ACCOUNT_NO = :WS-ACCOUNT-NO                          
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795                                                                   
P0795      MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P0795                                                                   
P0795      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0795         MOVE HT-CUSTOMER-NO TO WS-CUSTOMER-NO                     
P0795      ELSE                                                         
P0795          IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
P0795             MOVE ZEROES TO HT-CUSTOMER-NO                         
P0795          ELSE                                                     
P0795              MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
P0795              MOVE SQLCODE            TO ABEND-SQLCODE             
P0795              MOVE SQLSTATE           TO ABEND-SQLSTATE            
P0795              MOVE '2155'             TO ACTIVE-PARAGRAPH          
P0795              MOVE 'SELECT'           TO ABEND-FUNCTION            
P0795              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
P0795              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
P0795              MOVE WS-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
P0795              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P0795              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P0795          END-IF                                                   
P0795      END-IF.                                                      
P0795                                                                   
P0795  2155-EXIT.                                                       
P0795      EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-T1A-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T1_CURSOR                        *        
      ******************************************************************        
                                                                        
       7000-OPEN-T1A-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T1A_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T1A_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7002-OPEN-T1B-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T1_CURSOR                        *        
      ******************************************************************        
                                                                        
       7002-OPEN-T1B-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T1B_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7002'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T1B_CURSOR'               TO TABLE-1                
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7002-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7004-OPEN-T1C-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T1C_CURSOR                       *        
      ******************************************************************        
                                                                        
       7004-OPEN-T1C-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T1C_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7004'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T1C_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7004-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7006-OPEN-T1D-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T1D_CURSOR                       *        
      ******************************************************************        
                                                                        
       7006-OPEN-T1D-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T1D_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7006'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T1D_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7006-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7010-FETCH-T1A-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T1A_CURSOR          *        
      ******************************************************************        
                                                                        
       7010-FETCH-T1A-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T1A_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T1A-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7010'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T1A_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7012-FETCH-T1B-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T1B_CURSOR          *        
      ******************************************************************        
                                                                        
       7012-FETCH-T1B-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T1B_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T1B-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7012'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T1B_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7012-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7014-FETCH-T1C-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T1C_CURSOR          *        
      ******************************************************************        
                                                                        
       7014-FETCH-T1C-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T1C_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T1C-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7014'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T1C_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7014-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7016-FETCH-T1D-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T1D_CURSOR          *        
      ******************************************************************        
                                                                        
       7016-FETCH-T1D-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T1D_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T1D-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7016'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T1D_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7016-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7020-CLOSE-T1A-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T1A_CURSOR                          *        
      ******************************************************************        
                                                                        
       7020-CLOSE-T1A-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T1A_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T1A_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7020-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7022-CLOSE-T1B-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T1B_CURSOR                          *        
      ******************************************************************        
                                                                        
       7022-CLOSE-T1B-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T1B_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7022'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T1B_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7022-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7024-CLOSE-T1C-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T1C_CURSOR                          *        
      ******************************************************************        
                                                                        
       7024-CLOSE-T1C-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T1C_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7024'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T1C_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7024-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7026-CLOSE-T1D-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T1D_CURSOR                          *        
      ******************************************************************        
                                                                        
       7026-CLOSE-T1D-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T1D_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7026'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T1D_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7026-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7030-OPEN-T2A-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T2A_CURSOR                       *        
      ******************************************************************        
                                                                        
       7030-OPEN-T2A-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T2A_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T2A_CURSOR'               TO TABLE-1                
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7032-OPEN-T2B-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T2B_CURSOR                       *        
      ******************************************************************        
                                                                        
       7032-OPEN-T2B-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T2B_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7032'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T2B_CURSOR'               TO TABLE-1                
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7032-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7034-OPEN-T2C-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T2C_CURSOR                       *        
      ******************************************************************        
                                                                        
       7034-OPEN-T2C-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T2C_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7034'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T2C_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7034-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7036-OPEN-T2D-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T2D_CURSOR                       *        
      ******************************************************************        
                                                                        
       7036-OPEN-T2D-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T2D_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7036'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T2D_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7036-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7040-FETCH-T2A-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T2A_CURSOR          *        
      ******************************************************************        
                                                                        
       7040-FETCH-T2A-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T2A_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T2A-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7040'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T2A_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7042-FETCH-T2B-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T2B_CURSOR          *        
      ******************************************************************        
                                                                        
       7042-FETCH-T2B-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T2B_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T2B-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7042'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T2B_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7042-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7044-FETCH-T2C-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T2C_CURSOR          *        
      ******************************************************************        
                                                                        
       7044-FETCH-T2C-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T2C_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T2C-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7044'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T2C_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7044-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7046-FETCH-T2D-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T2D_CURSOR          *        
      ******************************************************************        
                                                                        
       7046-FETCH-T2D-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T2D_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T2D-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7046'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T2D_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7046-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7050-CLOSE-T2A-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T2A_CURSOR                          *        
      ******************************************************************        
                                                                        
       7050-CLOSE-T2A-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T2A_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T2A_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7050-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7052-CLOSE-T2B-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T2B_CURSOR                          *        
      ******************************************************************        
                                                                        
       7052-CLOSE-T2B-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T2B_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7052'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T2B_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7052-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7054-CLOSE-T2C-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T2C_CURSOR                          *        
      ******************************************************************        
                                                                        
       7054-CLOSE-T2C-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T2C_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7054'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T2C_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7054-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7056-CLOSE-T2D-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T2D_CURSOR                          *        
      ******************************************************************        
                                                                        
       7056-CLOSE-T2D-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T2D_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7056'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T2D_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7056-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7060-OPEN-T3A-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T3A_CURSOR                       *        
      ******************************************************************        
                                                                        
       7060-OPEN-T3A-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T3A_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T3A_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7062-OPEN-T3B-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T3B_CURSOR                       *        
      ******************************************************************        
                                                                        
       7062-OPEN-T3B-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T3B_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7062'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T3B_CURSOR'               TO TABLE-1                
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7062-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7064-OPEN-T3C-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T3C_CURSOR                       *        
      ******************************************************************        
                                                                        
       7064-OPEN-T3C-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T3C_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7064'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T3C_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7064-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7066-OPEN-T3D-CURSOR-PARA                                      *        
      * THIS PARA IS USED TO OPEN THE T3D_CURSOR                       *        
      ******************************************************************        
                                                                        
       7066-OPEN-T3D-CURSOR-PARA.                                       
                                                                        
           EXEC SQL                                                     
               OPEN T3D_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7066'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'T3D_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7066-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * 7070-FETCH-T3A-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T3A_CURSOR          *        
      ******************************************************************        
                                                                        
       7070-FETCH-T3A-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T3A_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T3A-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7070'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T3A_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7072-FETCH-T3B-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T2B_CURSOR          *        
      ******************************************************************        
                                                                        
       7072-FETCH-T3B-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T3B_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T3B-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7072'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T3B_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7072-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7074-FETCH-T3C-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T3C_CURSOR          *        
      ******************************************************************        
                                                                        
       7074-FETCH-T3C-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T3C_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T3C-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7074'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T3C_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7074-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7076-FETCH-T3D-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO FETCH THE RECORD FROM T3D_CURSOR          *        
      ******************************************************************        
                                                                        
       7076-FETCH-T3D-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                      T3D_CURSOR                                        
                 INTO                                                   
                       :VO-SERV-ORDER-NO,                               
                       :VO-ORDER-PRIORITY-CD,                           
                       :VO-WORK-AREA-ID,                                
                       :VO-ASSIGNED-DATETIME :WS-NULL1,                  
                       :VO-WANTED-BY-DATETIME :WS-NULL2,                 
                       :VO-ORDER-STATE-CD,                              
                       :R6-STATUS-TX,                                   
                       :PR-ADDRESS-ID,                                  
                       :C2-ORDER-TYPE-DESC,                             
                       :TE-CREW-ID :WS-NULL3,                            
                       :VO-APPT-AM-PM-CD,                               
                       :VO-PREMISE-NO,                                  
                       :VO-ACCOUNT-NO,                                  
                       :VO-ACCOUNT-NO-PRIOR                             
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                       TO WS-T3D-CURSOR-ROWS
                    ADD +1                         TO CTR-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME              TO ABEND-PROGRAM     
                    MOVE SQLCODE                   TO ABEND-SQLCODE     
                    MOVE SQLSTATE                  TO ABEND-SQLSTATE    
                    MOVE '7076'                    TO ACTIVE-PARAGRAPH  
                    MOVE 'FETCH'                   TO ABEND-FUNCTION    
                    MOVE 'T3D_CURSOR'              TO TABLE-1           
                    MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1   
                    MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1 
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7076-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7080-CLOSE-T3A-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T3A_CURSOR                          *        
      ******************************************************************        
                                                                        
       7080-CLOSE-T3A-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T3A_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7080'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T3A_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7080-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7082-CLOSE-T3B-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T3B_CURSOR                          *        
      ******************************************************************        
                                                                        
       7082-CLOSE-T3B-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T3B_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7082'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T3B_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7082-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7084-CLOSE-T3C-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T3C_CURSOR                          *        
      ******************************************************************        
                                                                        
       7084-CLOSE-T3C-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T3C_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7084'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T3C_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7084-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7086-CLOSE-T3D-CURSOR-PARA                                     *        
      * THIS PARA IS USED TO CLOSE T3D_CURSOR                          *        
      ******************************************************************        
                                                                        
       7086-CLOSE-T3D-CURSOR-PARA.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE T3D_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7086'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'T3D_CURSOR'              TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        7086-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT-T1                                            *        
      * INSERTS THE DATA INTO THE GLOBAL TEMPORARY TABLE               *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT-T1.                                             
                                                                        
           EXEC SQL                                                     
                                                                        
             INSERT INTO #SESSION_T1                             
                      (SERV_ORDER_NO                                    
                      ,ORDER_PRIORITY_CD                                
                      ,WORK_AREA_ID                                     
                      ,ASSIGNED_DATETIME                                
                      ,WANTED_BY_DATETIME                               
                      ,ORDER_STATE_CD                                   
                      ,STATUS_TX                                        
                      ,ADDRESS_ID                                       
                      ,PROJECT_TITLE                                    
                      ,CREW_ID                                          
                      ,APPOINTMENT_FL                                   
                      ,PREMISE_NO                                       
                      ,ACCOUNT_NO                                       
                      ,ACCOUNT_NO_PRIOR                                 
                      ,REMARK_FL                                        
                      ,REMARK_TX                                        
                      ,CUSTOMER_NO)                                     
               VALUES                                                   
                      (:RS-SERV-ORDER-NO                                
                      ,:RS-ORDER-PRIORITY-CD                            
                      ,:RS-WORK-AREA-ID                                 
                      ,CIS.CHAR2TIMESTAMP(:RS-ASSIGNED-DATETIME 
                                          :WS-NULL1)                   
                      ,CIS.CHAR2TIMESTAMP(:RS-WANTED-BY-DATETIME 
                                          :WS-NULL2)                  
                      ,:RS-ORDER-STATE-CD                               
                      ,:RS-STATUS-TX                                    
                      ,:RS-ADDRESS-ID                                   
                      ,:RS-PROJECT-TITLE                                
                      ,:RS-CREW-ID :WS-NULL3                             
                      ,:RS-APPOINTMENT-FL                               
                      ,:RS-PREMISE-NO                                   
                      ,:RS-ACCOUNT-NO                                   
                      ,:RS-ACCOUNT-NO-PRIOR                             
                      ,:RS-REMARK-FL                                    
                      ,:RS-REMARK-TX                                    
                      ,:RS-CUSTOMER-NO)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*      INSERT INTO SESSION.SESSION_T1                                     
MFA-TR*               (SERV_ORDER_NO                                            
MFA-TR*               ,ORDER_PRIORITY_CD                                        
MFA-TR*               ,WORK_AREA_ID                                             
MFA-TR*               ,ASSIGNED_DATETIME                                        
MFA-TR*               ,WANTED_BY_DATETIME                                       
MFA-TR*               ,ORDER_STATE_CD                                           
MFA-TR*               ,STATUS_TX                                                
MFA-TR*               ,ADDRESS_ID                                               
MFA-TR*               ,PROJECT_TITLE                                            
MFA-TR*               ,CREW_ID                                                  
MFA-TR*               ,APPOINTMENT_FL                                           
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,ACCOUNT_NO_PRIOR                                         
MFA-TR*               ,REMARK_FL                                                
MFA-TR*               ,REMARK_TX                                                
MFA-TR*               ,CUSTOMER_NO)                                             
MFA-TR*        VALUES                                                           
MFA-TR*               (:RS-SERV-ORDER-NO                                        
MFA-TR*               ,:RS-ORDER-PRIORITY-CD                                    
MFA-TR*               ,:RS-WORK-AREA-ID                                         
MFA-TR*               ,:RS-ASSIGNED-DATETIME:WS-NULL1                           
MFA-TR*               ,:RS-WANTED-BY-DATETIME:WS-NULL2                          
MFA-TR*               ,:RS-ORDER-STATE-CD                                       
MFA-TR*               ,:RS-STATUS-TX                                            
MFA-TR*               ,:RS-ADDRESS-ID                                           
MFA-TR*               ,:RS-PROJECT-TITLE                                        
MFA-TR*               ,:RS-CREW-ID:WS-NULL3                                     
MFA-TR*               ,:RS-APPOINTMENT-FL                                       
MFA-TR*               ,:RS-PREMISE-NO                                           
MFA-TR*               ,:RS-ACCOUNT-NO                                           
MFA-TR*               ,:RS-ACCOUNT-NO-PRIOR                                     
MFA-TR*               ,:RS-REMARK-FL                                            
MFA-TR*               ,:RS-REMARK-TX                                            
MFA-TR*               ,:RS-CUSTOMER-NO)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO CTR-ROWS                
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'SESSION_T1'              TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE 'ORDER_PRIORITY_CD'       TO TABLE-ELEMENT-2         
              MOVE 'WORK_AREA_ID'            TO TABLE-ELEMENT-3         
              MOVE RS-SERV-ORDER-NO          TO HOSTVAR-ELEMENT-1       
              MOVE RS-ORDER-PRIORITY-CD      TO HOSTVAR-ELEMENT-2       
              MOVE RS-WORK-AREA-ID           TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            MOVE 'DELETE ROWS'                TO S-SQL-STATEMENT-V.     
                                                                        
            EXEC SQL                                                    
                DELETE FROM #SESSION_T1                          
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.SESSION_T1                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE. 
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE SQLCODE                   TO ABEND-SQLCODE          
               MOVE SQLSTATE                  TO ABEND-SQLSTATE         
               MOVE '8000A'                   TO ACTIVE-PARAGRAPH       
               MOVE 'DELETE'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'SESSION_T1'              TO TABLE-1                
               MOVE SPACES                    TO TABLE-ELEMENT-1        
               MOVE SPACES                    TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
                OPEN C1                                                 
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                     TO SEND-DONE-SW.                
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE   TO ABEND-SQLCODE.               
           MOVE SQLERRMC                TO ABEND-SQLERRMC.              
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'           TO ABEND-FUNCTION               
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM                                               *        
      *     PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!         *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9999-END-PROGRAM'         TO ABEND-FUNCTION         
              MOVE 'PROGRAMMER LOGIC'         TO TABLE-1                
              MOVE 'FAILED TO SEND'           TO TABLE-ELEMENT-1        
              MOVE 'RESULT SET'               TO HOSTVAR-ELEMENT-1      
              MOVE -1                         TO WS-ACTIVE-RETURN-CODE  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE          THRU 8900-EXIT            
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
