       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03948.                                         
COB303 DATE-WRITTEN.      MARCH 26, 2007.                               
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA STORED PROCEDURE CALL (DB2) BY   *00100000
      *  AMR_FROMHOST.TCL                                              *00110000
      *                                                                *        
      *  PROGRAM: CSR03948                                             *00130000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM RETRIEVES NAME, ADDRESS, AND CUSTOMER PHONE INFO *00200000
      *  BASED ON ACCOUNT_NO.                                          *00220000
      *                                                                *        
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  03/26/07    RR       SP ORIGINALLY ADDED.                     *00290000
      *                                                                *        
      ******************************************************************00560000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03948'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03948 STARTS HERE'.                  
                                                                        
      ******************************************************************00650000
      *    DB2 INCLUDES                                                *00660000
      ******************************************************************00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBNAME                                            00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBADRFMT                                          00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBZIPCD                                           00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBCSTPHN                                          00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBNMACTX                                          00700000
           END-EXEC.                                                    00710000
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
           COPY CWS00027.                                               01560000
                                                                        
           EXEC SQL                                                     01570000
               INCLUDE CWSX0010                                         01570000
           END-EXEC.                                                    01570000
                                                                        
           EXEC SQL                                                     01590000
              INCLUDE CWS00013                                          01600000
           END-EXEC.                                                    01610000
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(09) COMP VALUE +0.   
COB305     05 RS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.   
COB305     05 RS-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.   
COB305     05 RS-CN-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.   
           05  RS-CN-FIRST-NAME             PIC X(15).                  
           05  RS-CN-MIDDLE-NAME            PIC X(15).                  
           05  RS-CN-LAST-NAME              PIC X(20).                  
           05  RS-CN-FULL-NAME              PIC X(50).                  
           05  RS-CN-NAME-FORMAT            PIC X(1).                   
COB305     05 RS-DBA-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.   
           05  RS-DBA-FIRST-NAME            PIC X(15).                  
           05  RS-DBA-LAST-NAME             PIC X(15).                  
           05  RS-DBA-FULL-NAME             PIC X(50).                  
           05  RS-DBA-NAME-FORMAT           PIC X(1).                   
COB305     05 RS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.   
           05  RS-ADDR-PREFIX-1             PIC X(3).                   
           05  RS-ADDR-PREFIX-2             PIC X(2).                   
           05  RS-ADDR-SUFFIX               PIC X(2).                   
           05  RS-ADDRESS-OVERFLOW          PIC X(35).                  
           05  RS-HOUSE-NO                  PIC X(5).                   
           05  RS-STREET-LOCATION-1         PIC X(4).                   
           05  RS-STREET-LOCATION-2         PIC X(6).                   
           05  RS-STREET-NAME               PIC X(16).                  
           05  RS-STREET-SUFFIX             PIC X(4).                   
           05  RS-ZIP-CODE                  PIC X(5).                   
           05  RS-ZIP-CODE-PLUS-FOUR        PIC X(4).                   
           05  RS-ZIP-CODE-TOKEN            PIC X(1).                   
           05  RS-ADDR-USAGE-CD            PIC X(1).                    
           05  RS-TOWN                      PIC X(26).                  
           05  RS-STATE                     PIC X(2).                   
           05  RS-PHONE-TYPE-H1             PIC X(2).                   
           05  RS-PHONE-NO-H1               PIC X(10).                  
           05  RS-PHONE-TYPE-W1             PIC X(2).                   
           05  RS-PHONE-NO-W1               PIC X(10).                  
           05  RS-PHONE-TYPE-B1             PIC X(2).                   
           05  RS-PHONE-NO-B1               PIC X(10).                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(09) COMP VALUE +0.   
COB305     05 S-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.   
COB305     05 S-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.   
COB305     05 S-CN-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.   
           05  S-CN-FIRST-NAME              PIC X(15).                  
           05  S-CN-MIDDLE-NAME             PIC X(15).                  
           05  S-CN-LAST-NAME               PIC X(20).                  
           05  S-CN-FULL-NAME               PIC X(50).                  
           05  S-CN-NAME-FORMAT             PIC X(1).                   
COB305     05 S-DBA-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.   
           05  S-DBA-FIRST-NAME             PIC X(15).                  
           05  S-DBA-LAST-NAME              PIC X(15).                  
           05  S-DBA-FULL-NAME              PIC X(50).                  
           05  S-DBA-NAME-FORMAT            PIC X(1).                   
COB305     05 S-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.   
           05  S-ADDR-PREFIX-1              PIC X(3).                   
           05  S-ADDR-PREFIX-2              PIC X(2).                   
           05  S-ADDR-SUFFIX                PIC X(2).                   
           05  S-ADDRESS-OVERFLOW           PIC X(35).                  
           05  S-HOUSE-NO                   PIC X(5).                   
           05  S-STREET-LOCATION-1          PIC X(4).                   
           05  S-STREET-LOCATION-2          PIC X(6).                   
           05  S-STREET-NAME                PIC X(16).                  
           05  S-STREET-SUFFIX              PIC X(4).                   
           05  S-ZIP-CODE                   PIC X(5).                   
           05  S-ZIP-CODE-PLUS-FOUR         PIC X(4).                   
           05  S-ZIP-CODE-TOKEN             PIC X(1).                   
           05  S-ADDR-USAGE-CD             PIC X(1).                    
           05  S-TOWN                       PIC X(26).                  
           05  S-STATE                      PIC X(2).                   
           05  S-PHONE-TYPE-H1              PIC X(2).                   
           05  S-PHONE-NO-H1                PIC X(10).                  
           05  S-PHONE-TYPE-W1              PIC X(2).                   
           05  S-PHONE-NO-W1                PIC X(10).                  
           05  S-PHONE-TYPE-B1              PIC X(2).                   
           05  S-PHONE-NO-B1                PIC X(10).                  
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-RED        PIC X(13).                      
           05  WS-ACCOUNT-NO            REDEFINES WS-ACCOUNT-NO-RED     
                                        PIC 9(13).                      
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR03948'.     
           05  WS-CURRENT-TS            PIC X(26).                      
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO          PIC X(13) VALUE SPACES.             
                                                                        
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO.                       
                                                                        
                                                                        
      ******************************************************************04640000
      * 0000-MAINLINE                                                  *04650000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04660000
      ******************************************************************04670000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04790000
      * 0100-INITIALIZE                                                *04800000
      *                                                                *04810000
      *     1. RESET DB2 ERROR HANDLERS                                *04820000
      *     2. DECLARE CURSOR FOR RESULT SET                           *04850000
      *                                                                *04860000
      ******************************************************************04870000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE          AS RETURN_CODE,              
                   :S-CUSTOMER-NO          AS CUSTOMER_NO,              
                   :S-PREMISE-NO           AS PREMISE_NO,               
                   :S-CN-NAME-ID           AS CN_NAME_ID,               
                   :S-CN-FIRST-NAME        AS CN_FIRST_NAME,            
                   :S-CN-MIDDLE-NAME       AS CN_MIDDLE_NAME,           
                   :S-CN-LAST-NAME         AS CN_LAST_NAME,             
                   :S-CN-FULL-NAME         AS CN_FULL_NAME,             
                   :S-CN-NAME-FORMAT       AS CN_NAME_FORMAT,           
                   :S-DBA-NAME-ID          AS DBA_NAME_ID,              
                   :S-DBA-FIRST-NAME       AS DBA_FIRST_NAME,           
                   :S-DBA-LAST-NAME        AS DBA_LAST_NAME,            
                   :S-DBA-FULL-NAME        AS DBA_FULL_NAME,            
                   :S-DBA-NAME-FORMAT      AS DBA_NAME_FORMAT,          
                   :S-ADDRESS-ID           AS ADDRESS_ID,               
                   :S-ADDR-PREFIX-1        AS ADDR_PREFIX_1,            
                   :S-ADDR-PREFIX-2        AS ADDR_PREFIX_2,            
                   :S-ADDR-SUFFIX          AS ADDR_SUFFIX,              
                   :S-ADDRESS-OVERFLOW     AS ADDRESS_OVERFLOW,         
                   :S-HOUSE-NO             AS HOUSE_NO,                 
                   :S-STREET-LOCATION-1    AS STREET_LOC_1,             
                   :S-STREET-LOCATION-2    AS STREET_LOC_2,             
                   :S-STREET-NAME          AS STREET_NAME,              
                   :S-STREET-SUFFIX        AS STREET_SUFFIX,            
                   :S-ZIP-CODE             AS ZIP_CODE,                 
                   :S-ZIP-CODE-PLUS-FOUR   AS ZIP_PLUS_FOUR,            
                   :S-ZIP-CODE-TOKEN       AS ZIP_CODE_TOKEN,           
                   :S-ADDR-USAGE-CD        AS ADDR_USAGE_CD,            
                   :S-TOWN                 AS TOWN,                     
                   :S-STATE                AS STATE,                    
                   :S-PHONE-TYPE-H1        AS PHONE_TYPE_H1,            
                   :S-PHONE-NO-H1          AS PHONE_NO_H1,              
                   :S-PHONE-TYPE-W1        AS PHONE_TYPE_W1,            
                   :S-PHONE-NO-W1          AS PHONE_NO_W1,              
                   :S-PHONE-TYPE-B1        AS PHONE_TYPE_B1,            
                   :S-PHONE-NO-B1          AS PHONE_NO_B1               
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE          AS RETURN_CODE,                      
MFA-TR*            :S-CUSTOMER-NO          AS CUSTOMER_NO,                      
MFA-TR*            :S-PREMISE-NO           AS PREMISE_NO,                       
MFA-TR*            :S-CN-NAME-ID           AS CN_NAME_ID,                       
MFA-TR*            :S-CN-FIRST-NAME        AS CN_FIRST_NAME,                    
MFA-TR*            :S-CN-MIDDLE-NAME       AS CN_MIDDLE_NAME,                   
MFA-TR*            :S-CN-LAST-NAME         AS CN_LAST_NAME,                     
MFA-TR*            :S-CN-FULL-NAME         AS CN_FULL_NAME,                     
MFA-TR*            :S-CN-NAME-FORMAT       AS CN_NAME_FORMAT,                   
MFA-TR*            :S-DBA-NAME-ID          AS DBA_NAME_ID,                      
MFA-TR*            :S-DBA-FIRST-NAME       AS DBA_FIRST_NAME,                   
MFA-TR*            :S-DBA-LAST-NAME        AS DBA_LAST_NAME,                    
MFA-TR*            :S-DBA-FULL-NAME        AS DBA_FULL_NAME,                    
MFA-TR*            :S-DBA-NAME-FORMAT      AS DBA_NAME_FORMAT,                  
MFA-TR*            :S-ADDRESS-ID           AS ADDRESS_ID,                       
MFA-TR*            :S-ADDR-PREFIX-1        AS ADDR_PREFIX_1,                    
MFA-TR*            :S-ADDR-PREFIX-2        AS ADDR_PREFIX_2,                    
MFA-TR*            :S-ADDR-SUFFIX          AS ADDR_SUFFIX,                      
MFA-TR*            :S-ADDRESS-OVERFLOW     AS ADDRESS_OVERFLOW,                 
MFA-TR*            :S-HOUSE-NO             AS HOUSE_NO,                         
MFA-TR*            :S-STREET-LOCATION-1    AS STREET_LOC_1,                     
MFA-TR*            :S-STREET-LOCATION-2    AS STREET_LOC_2,                     
MFA-TR*            :S-STREET-NAME          AS STREET_NAME,                      
MFA-TR*            :S-STREET-SUFFIX        AS STREET_SUFFIX,                    
MFA-TR*            :S-ZIP-CODE             AS ZIP_CODE,                         
MFA-TR*            :S-ZIP-CODE-PLUS-FOUR   AS ZIP_PLUS_FOUR,                    
MFA-TR*            :S-ZIP-CODE-TOKEN       AS ZIP_CODE_TOKEN,                   
MFA-TR*            :S-ADDR-USAGE-CD        AS ADDR_USAGE_CD,                    
MFA-TR*            :S-TOWN                 AS TOWN,                             
MFA-TR*            :S-STATE                AS STATE,                            
MFA-TR*            :S-PHONE-TYPE-H1        AS PHONE_TYPE_H1,                    
MFA-TR*            :S-PHONE-NO-H1          AS PHONE_NO_H1,                      
MFA-TR*            :S-PHONE-TYPE-W1        AS PHONE_TYPE_W1,                    
MFA-TR*            :S-PHONE-NO-W1          AS PHONE_NO_W1,                      
MFA-TR*            :S-PHONE-TYPE-B1        AS PHONE_TYPE_B1,                    
MFA-TR*            :S-PHONE-NO-B1          AS PHONE_NO_B1                       
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05140000
      * 1000-PROCESS-INPUT.                                            *05150000
      *                                                                *05160000
      *     1.  RECEIVE PARMS FROM THE CLIENT.                         *05170000
      *     2.  FORMAT PACKED NUMERICS.                                *05180000
      *                                                                *05190000
      ******************************************************************05200000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO TO WS-ACCOUNT-NO-RED.                   
                                                                        
           IF WS-ACCOUNT-NO-RED NOT NUMERIC                             
               MOVE ZEROES TO WS-ACCOUNT-NO-RED
           END-IF.                        
           MOVE WS-ACCOUNT-NO-RED TO WS-ACCOUNT-NO.                     
           MOVE WS-ACCOUNT-NO TO HT-ACCOUNT-NO.                         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09200000
      *   2000-PROCESS-OUTPUT                                          *09210000
      *                                                                *09220000
      *       1. RETRIEVE DB2 DATA                                     *09240000
      *       2. BUILD RESULT SET                                      *09250000
      *       3. SEND RESULT SET                                       *09260000
      *                                                                *09270000
      ******************************************************************09280000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-BUILD-RESULT       THRU 5000-EXIT.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD +1                          TO CTR-ROWS.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE           TO S-RETURN-CODE.             
            MOVE RS-CUSTOMER-NO           TO S-CUSTOMER-NO.             
            MOVE RS-PREMISE-NO            TO S-PREMISE-NO.              
            MOVE RS-CN-NAME-ID            TO S-CN-NAME-ID.              
            MOVE RS-CN-FIRST-NAME         TO S-CN-FIRST-NAME.           
            MOVE RS-CN-MIDDLE-NAME        TO S-CN-MIDDLE-NAME.          
            MOVE RS-CN-LAST-NAME          TO S-CN-LAST-NAME.            
            MOVE RS-CN-FULL-NAME          TO S-CN-FULL-NAME.            
            MOVE RS-CN-NAME-FORMAT        TO S-CN-NAME-FORMAT.          
            MOVE RS-DBA-NAME-ID           TO S-DBA-NAME-ID.             
            MOVE RS-DBA-FIRST-NAME        TO S-DBA-FIRST-NAME.          
            MOVE RS-DBA-LAST-NAME         TO S-DBA-LAST-NAME.           
            MOVE RS-DBA-FULL-NAME         TO S-DBA-FULL-NAME.           
            MOVE RS-DBA-NAME-FORMAT       TO S-DBA-NAME-FORMAT.         
            MOVE RS-ADDRESS-ID            TO S-ADDRESS-ID.              
            MOVE RS-ADDR-PREFIX-1         TO S-ADDR-PREFIX-1.           
            MOVE RS-ADDR-PREFIX-2         TO S-ADDR-PREFIX-2.           
            MOVE RS-ADDR-SUFFIX           TO S-ADDR-SUFFIX.             
            MOVE RS-ADDRESS-OVERFLOW      TO S-ADDRESS-OVERFLOW.        
            MOVE RS-HOUSE-NO              TO S-HOUSE-NO.                
            MOVE RS-STREET-LOCATION-1     TO S-STREET-LOCATION-1.       
            MOVE RS-STREET-LOCATION-2     TO S-STREET-LOCATION-2.       
            MOVE RS-STREET-NAME           TO S-STREET-NAME.             
            MOVE RS-STREET-SUFFIX         TO S-STREET-SUFFIX.           
            MOVE RS-ZIP-CODE              TO S-ZIP-CODE.                
            MOVE RS-ZIP-CODE-PLUS-FOUR    TO S-ZIP-CODE-PLUS-FOUR.      
            MOVE RS-ZIP-CODE-TOKEN        TO S-ZIP-CODE-TOKEN.          
            MOVE RS-ADDR-USAGE-CD         TO S-ADDR-USAGE-CD.           
            MOVE RS-TOWN                  TO S-TOWN.                    
            MOVE RS-STATE                 TO S-STATE.                   
            MOVE RS-PHONE-TYPE-H1         TO S-PHONE-TYPE-H1.           
            MOVE RS-PHONE-NO-H1           TO S-PHONE-NO-H1.             
            MOVE RS-PHONE-TYPE-W1         TO S-PHONE-TYPE-W1.           
            MOVE RS-PHONE-NO-W1           TO S-PHONE-NO-W1.             
            MOVE RS-PHONE-TYPE-B1         TO S-PHONE-TYPE-B1.           
            MOVE RS-PHONE-NO-B1           TO S-PHONE-NO-B1.             
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5000-BUILD-RESULT                                              *        
      ******************************************************************        
       5000-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-GET-CUST-PREM               THRU 7000-EXIT.     
                                                                        
           PERFORM 7100-GET-NAMES                   THRU 7100-EXIT.     
                                                                        
           PERFORM 7200-GET-ADDR-INFO               THRU 7200-EXIT.     
                                                                        
           PERFORM 7300-GET-CUST-PHONE              THRU 7300-EXIT.     
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-GET-CUST-PREM                                                      
      ******************************************************************        
       7000-GET-CUST-PREM.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO,
              PREMISE_NO                                         
                INTO :RS-CUSTOMER-NO,                                   
                     :RS-PREMISE-NO                                     
                FROM CSS_NAME_ACCT_XREF                                 
               WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO                                                 
MFA-TR*         INTO :RS-CUSTOMER-NO,                                           
MFA-TR*              :RS-PREMISE-NO                                             
MFA-TR*         FROM CSS_NAME_ACCT_XREF                                         
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             NEXT SENTENCE                                              
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-NAMES*                                                         
      ******************************************************************        
       7100-GET-NAMES.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT HT.NAME_ID,                                        
                     DQ.FIRST_NAME,                                     
                     DQ.MIDDLE_NAME,                                    
                     DQ.LAST_NAME,                                      
                     DQ.FULL_NAME,                                      
                     DQ.NAME_FORMAT                                     
                INTO :RS-CN-NAME-ID,                                    
                     :RS-CN-FIRST-NAME,                                 
                     :RS-CN-MIDDLE-NAME,                                
                     :RS-CN-LAST-NAME,                                  
                     :RS-CN-FULL-NAME,                                  
                     :RS-CN-NAME-FORMAT                                 
                FROM CSS_NAME_ACCT_XREF HT,                             
                     CSS_NAME DQ                                        
               WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                     
                 AND HT.NAME_ID = DQ.NAME_ID                            
                 AND HT.CUSTOMER_ROLE_CD = ' '                          
                 AND DQ.NAME_TYPE = 'CN'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             NEXT SENTENCE                                              
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
           EXEC SQL                                                     
              SELECT HT.NAME_ID,                                        
                     DQ.FIRST_NAME,                                     
                     DQ.LAST_NAME,                                      
                     DQ.FULL_NAME,                                      
                     DQ.NAME_FORMAT                                     
                INTO :RS-DBA-NAME-ID,                                   
                     :RS-DBA-FIRST-NAME,                                
                     :RS-DBA-LAST-NAME,                                 
                     :RS-DBA-FULL-NAME,                                 
                     :RS-DBA-NAME-FORMAT                                
                FROM CSS_NAME_ACCT_XREF HT,                             
                     CSS_NAME DQ                                        
               WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                     
                 AND HT.NAME_ID = DQ.NAME_ID                            
                 AND HT.CUSTOMER_ROLE_CD = ' '                          
                 AND DQ.NAME_TYPE = 'DB'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                MOVE +000 TO WS-ACTIVE-RETURN-CODE                      
                MOVE ZEROS TO RS-DBA-NAME-ID                            
                MOVE SPACES TO RS-DBA-FIRST-NAME                        
                MOVE SPACES TO RS-DBA-LAST-NAME                         
                MOVE SPACES TO RS-DBA-FULL-NAME                         
                MOVE SPACES TO RS-DBA-NAME-FORMAT                       
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-GET-ADDR-INFO                                             *        
      ******************************************************************        
       7200-GET-ADDR-INFO.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) HT.ADDRESS_ID,
              DY.ADDR_PREFIX_1,
              DY.ADDR_PREFIX_2,
              DY.ADDR_SUFFIX,
              DY.ADDRESS_OVERFLOW,
              DY.HOUSE_NO,
              DY.STREET_LOCATION_1,
              DY.STREET_LOCATION_2,
              DY.STREET_NAME,
              DY.STREET_SUFFIX,
              DY.ZIP_CODE,
              DY.ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN,
              DY.ADDR_USAGE_CD,
              A4.TOWN,
              A4.STATE                                           
                INTO :RS-ADDRESS-ID,                                    
                     :RS-ADDR-PREFIX-1,                                 
                     :RS-ADDR-PREFIX-2,                                 
                     :RS-ADDR-SUFFIX,                                   
                     :RS-ADDRESS-OVERFLOW,                              
                     :RS-HOUSE-NO,                                      
                     :RS-STREET-LOCATION-1,                             
                     :RS-STREET-LOCATION-2,                             
                     :RS-STREET-NAME,                                   
                     :RS-STREET-SUFFIX,                                 
                     :RS-ZIP-CODE,                                      
                     :RS-ZIP-CODE-PLUS-FOUR,                            
                     :RS-ZIP-CODE-TOKEN,                                
                     :RS-ADDR-USAGE-CD,                                 
                     :RS-TOWN,                                          
                     :RS-STATE                                          
                FROM CSS_NAME_ACCT_XREF HT,                             
                     CSS_ADDR_FORMATTED DY,                             
                     CSS_ZIP_CODE A4                                    
               WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                     
                 AND HT.CUSTOMER_ROLE_CD = ' '                          
                 AND HT.ADDRESS_ID = DY.ADDRESS_ID                      
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HT.ADDRESS_ID,                                             
MFA-TR*              DY.ADDR_PREFIX_1,                                          
MFA-TR*              DY.ADDR_PREFIX_2,                                          
MFA-TR*              DY.ADDR_SUFFIX,                                            
MFA-TR*              DY.ADDRESS_OVERFLOW,                                       
MFA-TR*              DY.HOUSE_NO,                                               
MFA-TR*              DY.STREET_LOCATION_1,                                      
MFA-TR*              DY.STREET_LOCATION_2,                                      
MFA-TR*              DY.STREET_NAME,                                            
MFA-TR*              DY.STREET_SUFFIX,                                          
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              DY.ZIP_CODE_PLUS_FOUR,                                     
MFA-TR*              DY.ZIP_CODE_TOKEN,                                         
MFA-TR*              DY.ADDR_USAGE_CD,                                          
MFA-TR*              A4.TOWN,                                                   
MFA-TR*              A4.STATE                                                   
MFA-TR*         INTO :RS-ADDRESS-ID,                                            
MFA-TR*              :RS-ADDR-PREFIX-1,                                         
MFA-TR*              :RS-ADDR-PREFIX-2,                                         
MFA-TR*              :RS-ADDR-SUFFIX,                                           
MFA-TR*              :RS-ADDRESS-OVERFLOW,                                      
MFA-TR*              :RS-HOUSE-NO,                                              
MFA-TR*              :RS-STREET-LOCATION-1,                                     
MFA-TR*              :RS-STREET-LOCATION-2,                                     
MFA-TR*              :RS-STREET-NAME,                                           
MFA-TR*              :RS-STREET-SUFFIX,                                         
MFA-TR*              :RS-ZIP-CODE,                                              
MFA-TR*              :RS-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :RS-ZIP-CODE-TOKEN,                                        
MFA-TR*              :RS-ADDR-USAGE-CD,                                         
MFA-TR*              :RS-TOWN,                                                  
MFA-TR*              :RS-STATE                                                  
MFA-TR*         FROM CSS_NAME_ACCT_XREF HT,                                     
MFA-TR*              CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE A4                                            
MFA-TR*        WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                             
MFA-TR*          AND HT.CUSTOMER_ROLE_CD = ' '                                  
MFA-TR*          AND HT.ADDRESS_ID = DY.ADDRESS_ID                              
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-GET-CUST-PHONE                                                     
      ******************************************************************        
       7300-GET-CUST-PHONE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT PHONE_TYPE,                                        
                     PHONE_NO                                           
                INTO :RS-PHONE-TYPE-H1,                                 
                     :RS-PHONE-NO-H1                                    
                FROM CSS_CUST_PHONE                                     
               WHERE CUSTOMER_NO = :RS-CUSTOMER-NO                      
                 AND PHONE_TYPE = 'H1'                                  
                 AND CUSTOMER_TYPE = 'C'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                MOVE +000 TO WS-ACTIVE-RETURN-CODE                      
                MOVE SPACES TO RS-PHONE-TYPE-H1                         
                MOVE SPACES TO RS-PHONE-NO-H1                           
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_PHONE'      TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE RS-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
           EXEC SQL                                                     
              SELECT PHONE_TYPE,                                        
                     PHONE_NO                                           
                INTO :RS-PHONE-TYPE-W1,                                 
                     :RS-PHONE-NO-W1                                    
                FROM CSS_CUST_PHONE                                     
               WHERE CUSTOMER_NO = :RS-CUSTOMER-NO                      
                 AND PHONE_TYPE = 'W1'                                  
                 AND CUSTOMER_TYPE = 'C'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                MOVE +000 TO WS-ACTIVE-RETURN-CODE                      
                MOVE SPACES TO RS-PHONE-TYPE-W1                         
                MOVE SPACES TO RS-PHONE-NO-W1                           
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_PHONE'      TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE RS-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
           EXEC SQL                                                     
              SELECT PHONE_TYPE,                                        
                     PHONE_NO                                           
                INTO :RS-PHONE-TYPE-B1,                                 
                     :RS-PHONE-NO-B1                                    
                FROM CSS_CUST_PHONE                                     
               WHERE CUSTOMER_NO = :RS-CUSTOMER-NO                      
                 AND PHONE_TYPE = 'B1'                                  
                 AND CUSTOMER_TYPE = 'C'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                MOVE +000 TO WS-ACTIVE-RETURN-CODE                      
                MOVE SPACES TO RS-PHONE-TYPE-B1                         
                MOVE SPACES TO RS-PHONE-NO-B1                           
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_PHONE'      TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE RS-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
