       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR03945.                                            
       DATE-WRITTEN. 03/29/07.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COMBINATION OF CSR02200 AND CSR02201 USED   *        
      *  BY THE IVR.                                                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/29/07    FMB      PROCEDURE ORIGINALLY CODED.              *        
      *  08/13/07    AW41078  ADDING WITH UR TO SELECT FROM SO TABLES  *        
P00253*  12/21/09    FMB      ADD DETECTENT ORDER TYPE FW016           *        
A37666*  06/03/10    FMB      IGNORE ARCHIVED ACCOUNTS.                *        
P00455*  09/20/10    PK98692  TEXTING PROJECT CHANGES.                 *        
A03263*  01/24/12    FMB      BYPASS PROCESSING FOR ACCOUNT_NO = 0.    *        
A04527*  06/12/13    MC95456  REMOVED UNUSED COPY BOOK CWS00056        *        
P00633*  07/08/13    FMB      ADDED SEARCH METHODS FOR ZIP/SSN AND     *        
P00633*                       EXPANDED PHONE                           *        
P00633*  12/25/13    FMB      ADDED SPCL_BILL_STMNT_TX                 *        
PRDFIX*  02/12/14    SK42147  REMOVE LOW-VALUES FROM NAME FIELD        *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03945'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBSCSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBOFFCYL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCHS                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTPHN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTACT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCAT                                                  
           END-EXEC.                                                            
                                                                        
A37666     EXEC SQL                                                             
A37666        INCLUDE TBHACCT                                                   
A37666     END-EXEC.                                                            
                                                                        
P00455     EXEC SQL                                                             
P00455        INCLUDE TBUTLENV                                                  
P00455     END-EXEC.                                                            
                                                                        
P00455     EXEC SQL                                                             
P00455        INCLUDE TBCSTMSC                                                  
P00455     END-EXEC.                                                            
                                                                        
P00633     EXEC SQL                                                             
P00633        INCLUDE TBATMISC                                                  
P00633     END-EXEC.                                                            
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR03945_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                 PIC S9(9) COMP.                 
           05  MSG-SEVERITY             PIC S9(9) COMP VALUE 11.        
           05  MSG-NR                   PIC S9(9) COMP VALUE  2.        
           05  MSG-RPC                  PIC X(8)  VALUE 'CSR03945'.     
           05  MSG-RPC-L                PIC S9(9) COMP.                 
           05  MSG-TEXT                 PIC X(100).                     
           05  MSG-TEXT-L               PIC S9(9) COMP.                 
           05  MSG-SQL-ERROR.                                           
               10  FILLER               PIC X(10)                       
                                        VALUE 'SQLCODE = '.             
               10  MSG-SQL-ERROR-C      PIC -9(3) DISPLAY.              
               10  FILLER               PIC X(16)                       
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K      PIC X(70).                      
               10  MSG-SQL-ERROR-K-CHARS                                
                                        REDEFINES MSG-SQL-ERROR-K       
                                        OCCURS 70 TIMES PIC X.          
           05  MSG-SQL-ERROR-SS         PIC S9(4) COMP.                 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
           05  PARM-ID1                     PIC S9(9) COMP VALUE 1.     
           05  PARM-LIMITS.                                             
               10  PARM-LIMIT-TYPE          PIC X(1).                   
                   88  LIMIT-NONE           VALUE 'A'.                  
                   88  LIMIT-LOCAL-OFFICE   VALUE 'L'.                  
                   88  LIMIT-CITY           VALUE 'C'.                  
                   88  LIMIT-ACTIVE-IVR     VALUE 'I'.                  
                   88  LIMIT-COMPANY        VALUE 'B'.                  
                   88  LIMIT-ACTIVE-CSR     VALUE 'D'.                  
               10  PARM-WRITE-OFF           PIC X(1).                   
                   88  FILTER-WRITE-OFF     VALUE 'Y'.                  
                   88  NO-FILTER-WRITE-OFF  VALUE 'N'.                  
               10  PARM-ACTIVE-CSR          PIC X(1).                   
                   88  FILTER-ACTIVE-CSR    VALUE 'Y'.                  
                   88  NO-FILTER-ACTIVE-CSR VALUE 'N'.                  
               10  PARM-BANKRUPT            PIC X(1).                   
                   88  FILTER-BANKRUPT      VALUE 'Y'.                  
                   88  NO-FILTER-BANKRUPT   VALUE 'N'.                  
           05  PARM-SELECT-METHOD           PIC X(3).                   
               88  SEL-METH-ACC             VALUE 'ACC'.                
               88  SEL-METH-SSN             VALUE 'SSN'.                
               88  SEL-METH-PHO             VALUE 'PHO'.                
P00455         88  SEL-METH-CUS             VALUE 'CUS'.                
P00633         88  SEL-METH-ZIP             VALUE 'ZIP'.                
P00633         88  SEL-METH-PHX             VALUE 'PHX'.                
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP.             
           05  RS-ADDRESS                   PIC X(42).                  
           05  RS-NAME                      PIC X(56).                  
           05  RS-CITY                      PIC X(26).                  
           05  RS-ACCT-TYPE                 PIC X.                      
           05  RS-ACCOUNT-NO                PIC X(13).                  
           05  RS-SERVICE-AVAIL.                                        
               10  RS-SERV-AVAIL-OCC        OCCURS 5 TIMES.             
                   15  RS-SERV-AVAIL        PIC X.                      
           05  RS-CUSTOMER-NO               PIC X(10).                  
           05  RS-LOCAL-OFFICE              PIC X(3).                   
           05  RS-PREMISE-NO                PIC X(10).                  
           05  RS-ZIP-CODE                  PIC X(5).                   
           05  RS-COMPANY-NO                PIC X(02).                  
           05  RS-PASSWORD                  PIC X(16).                  
           05  RS-ENDV                      PIC X(1).                   
           05  RS-DNP                       PIC X(1).                   
           05  RS-BANKRUPTCY-IND            PIC X(1).                   
           05  RS-CONSOLIDATE-BILL          PIC X(1).                   
           05  RS-PENDING-FINAL             PIC X(1).                   
P00455     05  RS-POINT-ID-FL               PIC X(01).                  
P00455     05  RS-UTILITY-SOURCE-CD         PIC X(01).                  
P00455     05  RS-SERVICE-SUPPLIED.                                     
P00455         10  RS-SERV-SUPPLIED-OCC     OCCURS 5 TIMES.             
P00455             15  RS-SERV-SUPPLIED     PIC X.                      
P00455     05  RS-CODE-ACCT-STAT            PIC X(01).                  
P00455     05  RS-CODE-CRIT-OUTAGE          PIC X(02).                  
P00455     05  RS-KEY-CUSTOMER              PIC X(02).                  
P00455     05  RS-RATE-PLAN-NO              PIC X(03).                  
P00455     05  RS-CODE-REVENUE-CLASS        PIC X(03).                  
P00633     05  RS-ACCOUNT-ID                PIC X(35).                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE               PIC S9(9) COMP.              
           05  S-ADDRESS                   PIC X(42).                   
           05  S-NAME                      PIC X(56).                   
           05  S-CITY                      PIC X(26).                   
           05  S-ACCT-TYPE                 PIC X.                       
           05  S-ACCOUNT-NO                PIC X(13).                   
           05  S-SERVICE-AVAIL             PIC X(5).                    
           05  S-CUSTOMER-NO               PIC X(10).                   
           05  S-LOCAL-OFFICE              PIC X(3).                    
           05  S-PREMISE-NO                PIC X(10).                   
           05  S-ZIP-CODE                  PIC X(5).                    
           05  S-COMPANY-NO                PIC X(02).                   
           05  S-PASSWORD                  PIC X(16).                   
           05  S-ENDV                      PIC X(1).                    
           05  S-DNP                       PIC X(1).                    
           05  S-BANKRUPTCY-IND            PIC X(1).                    
           05  S-CONSOLIDATE-BILL          PIC X(1).                    
           05  S-PENDING-FINAL             PIC X(1).                    
P00455     05  S-POINT-ID-FL               PIC X(01).                   
P00455     05  S-UTILITY-SOURCE-CD         PIC X(01).                   
P00455     05  S-SERVICE-SUPPLIED          PIC X(05).                   
P00455     05  S-CODE-ACCT-STAT            PIC X(01).                   
P00455     05  S-CODE-CRIT-OUTAGE          PIC X(02).                   
P00455     05  S-KEY-CUSTOMER              PIC X(02).                   
P00455     05  S-RATE-PLAN-NO              PIC X(03).                   
P00455     05  S-CODE-REVENUE-CLASS        PIC X(03).                   
P00633     05  S-ACCOUNT-ID                PIC X(35).                   
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
       01  WS-PARM-CRITERIA.                                            
                                                                        
           05  WS-ACC-PARM-CRITERIA.                                    
               10  ACC-ACCT-NO              PIC X(13)                   
                                            JUSTIFIED RIGHT.            
               10  ACC-ACCT-NO-NUM          REDEFINES ACC-ACCT-NO       
                                            PIC 9(13).                  
                                                                        
           05  WS-SSN-PARM-CRITERIA.                                    
               10  SSN-NUMBER               PIC X(9).                   
                                                                        
           05  WS-PHO-PARM-CRITERIA.                                    
               10  PHO-NUMBER               PIC X(10).                  
                                                                        
P00455     05  WS-CUS-PARM-CRITERIA.                                    
P00455         10  CUS-CUST-NO              PIC X(10)                   
P00455                                      JUSTIFIED RIGHT.            
P00455         10  CUS-CUST-NO-NUM          REDEFINES CUS-CUST-NO       
P00455                                      PIC 9(10).                  
P00633     05  WS-ZIP-PARM-CRITERIA.                                    
P00633         10  SSN5-NUMBER              PIC X(5).                   
P00633         10  ZIP-CODE                 PIC X(5).                   
P00633     05  WS-PHX-PARM-CRITERIA.                                    
P00633         10  PHONE-NUMBER             PIC X(10).                  
                                                                        
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-PREV-CUST                 PIC X(10) VALUE LOW-VALUE.  
           05  WS-PREV-NAME                 PIC X(56) VALUE LOW-VALUE.  
           05  PROGRAM-NAME                 PIC X(8) VALUE 'CSR03945'.  
           05  WS-CUST-LAST-NAME            PIC X(20) VALUE SPACES.     
           05  WS-CUST-FIRST-NAME           PIC X(15) VALUE SPACES.     
           05  WS-CUST-MIDDLE-NAME          PIC X(15) VALUE SPACES.     
           05  WS-CUST-FULL-NAME            PIC X(56) VALUE SPACES.     
           05  WS-CUST-NAME-FORMAT          PIC X(01) VALUE SPACES.     
           05  WS-CUST-TITLE-SUFFIX-1       PIC X(03) VALUE SPACES.     
           05  WS-ADDRESS.                                              
               10  WS-ADDRESS-X             OCCURS 50 TIMES             
                                            INDEXED BY WS-ADD-SUB.      
                   15  FILLER               PIC X.                      
           05  WS-TODAYS-DATE               PIC X(10).                  
           05  WS-CURRENT-TS                PIC X(26).                  
           05  WS-SERVICES-SET              PIC X(01) VALUE 'N'.        
           05  WS-ROW-FOUND                 PIC X(01) VALUE 'N'.        
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-DNP-FLAG                  PIC X(01) VALUE 'N'.        
           05  WS-FROM.                                                 
               10  WS-FROM-X                OCCURS 51 TIMES PIC X.      
           05  WS-MAX-SZ                    PIC S9(4).                  
           05  WS-LENGTH                    PIC S9(4).                  
           05  WS-ROW-COUNT                 PIC X(02)                   
                                            JUSTIFIED RIGHT.            
           05  WS-ROW-COUNT-R               REDEFINES WS-ROW-COUNT      
                                            PIC 9(02).                  
A37666     05  WS-ARCHIVE-FL                PIC X(01) VALUE SPACES.     
P00455     05  WS-UTILITY-SOURCE-CD         PIC X(01) VALUE SPACES.     
P00455     05  WS-POINT-ID-FL               PIC X(01) VALUE SPACES.     
P00455     05  WS-UTIL-SRC-CD-NULL-IND      PIC S9(04) COMP VALUE 0.    
P00633     05  WS-PREV-ACCOUNT              PIC S9(13)V COMP-3 VALUE 0. 
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-MAX-RETURN-ROWS           PIC S9(4) COMP VALUE 20.    
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  CN-ASTERISK                  PIC X VALUE '*'.            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-LIMIT-TYPE-TEMP    PIC X(04).                           
       01  PARM-OFFICE-CITY        PIC X(26).                           
       01  PARM-SELECT-METHOD-TEMP PIC X(03).                           
       01  PARM-CRITERIA           PIC X(127).                          
       01  PARM-BYPASS-ACCESS-HIST PIC X(01).                           
       01  PARM-USERID             PIC X(07).                           
       01  PARM-ROW-COUNT          PIC X(02).                           
                                                                        
           EXEC SQL DECLARE SSN-CURSOR CURSOR FOR                       
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO                                     
                 FROM CSS_CUST_STATS     CE WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE CE.SSN                = :SSN-NUMBER               
                  AND CE.NAME_ID            = HT.NAME_ID                
             ORDER BY HT.CUSTOMER_NO                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE SSN-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO                                             
MFA-TR*          FROM CSS_CUST_STATS     CE,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE CE.SSN                = :SSN-NUMBER                       
MFA-TR*           AND CE.NAME_ID            = HT.NAME_ID                        
MFA-TR*      ORDER BY HT.CUSTOMER_NO                                            
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE AT-CURSOR CURSOR FOR                        
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO                                     
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE HT.ACCOUNT_NO        = :HT-ACCOUNT-NO             
                  AND HT.NAME_ID           = DQ.NAME_ID                 
                  AND DQ.NAME_TYPE         = 'CN'                       
                  AND HT.CUSTOMER_ROLE_CD  = ' '                        
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE AT-CURSOR CURSOR FOR                                
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO                                             
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.ACCOUNT_NO        = :HT-ACCOUNT-NO                     
MFA-TR*           AND HT.NAME_ID           = DQ.NAME_ID                         
MFA-TR*           AND DQ.NAME_TYPE         = 'CN'                               
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE PHO-CURSOR CURSOR FOR                       
               SELECT DISTINCT(HT.CUSTOMER_NO),                         
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO                                     
                 FROM CSS_CUST_PHONE     CB WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE CB.PHONE_NO         = :PHO-NUMBER                 
                  AND CB.CUSTOMER_NO      = HT.CUSTOMER_NO              
                  AND CB.PHONE_TYPE       IN ('H1','H2','B1','B2','A1') 
                  AND HT.NAME_ID          = DQ.NAME_ID                  
                  AND DQ.NAME_TYPE        = 'CN'                        
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
               UNION                                                    
               SELECT DISTINCT(HT.CUSTOMER_NO),                         
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO                                     
                 FROM CSS_CONTACT_PHONE LP WITH(READUNCOMMITTED),               
                      CSS_CONTACT CV WITH(READUNCOMMITTED),                     
                      CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE PHONE_NO = :PHO-NUMBER                            
                  AND LP.CONTACT_ID = CV.CONTACT_ID                     
                  AND CV.CONTACT_TYPE = 'OC'                            
                  AND CV.CONTACT_ID = DW.CONTACT_ID                     
                  AND DW.ACCOUNT_NO = HT.ACCOUNT_NO                     
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
             ORDER BY 1                                                 
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE PHO-CURSOR CURSOR FOR                               
MFA-TR*        SELECT DISTINCT(HT.CUSTOMER_NO),                                 
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO                                             
MFA-TR*          FROM CSS_CUST_PHONE     CB,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE CB.PHONE_NO         = :PHO-NUMBER                         
MFA-TR*           AND CB.CUSTOMER_NO      = HT.CUSTOMER_NO                      
MFA-TR*           AND CB.PHONE_TYPE       IN ('H1','H2','B1','B2','A1')         
MFA-TR*           AND HT.NAME_ID          = DQ.NAME_ID                          
MFA-TR*           AND DQ.NAME_TYPE        = 'CN'                                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*        UNION                                                            
MFA-TR*        SELECT DISTINCT(HT.CUSTOMER_NO),                                 
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO                                             
MFA-TR*          FROM CSS_CONTACT_PHONE LP,                                     
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_CONTACT_ACCT DW,                                      
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE PHONE_NO = :PHO-NUMBER                                    
MFA-TR*           AND LP.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.CONTACT_TYPE = 'OC'                                    
MFA-TR*           AND CV.CONTACT_ID = DW.CONTACT_ID                             
MFA-TR*           AND DW.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*      ORDER BY 1                                                         
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            
P00455******************************************************************        
P00455*    CU-CURSOR USED TO SEARCH FOR CUSTOMER NUMBER.               *        
P00455******************************************************************        
P00455     EXEC SQL DECLARE CUS-CURSOR CURSOR FOR                       
P00455         SELECT HT.CUSTOMER_NO,                                   
P00455                HT.ACCOUNT_NO,                                    
P00455                HT.PREMISE_NO,                                    
P00455                HT.ADDRESS_ID,                                    
P00455                HT.NAME_ID,                                       
P00455                HT.CUSTOMER_ROLE_CD,                              
P00455                HT.COMPANY_NO                                     
P00455           FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
P00455                CSS_NAME DQ WITH(READUNCOMMITTED)                         
P00455          WHERE HT.CUSTOMER_NO       = :HT-CUSTOMER-NO            
P00455            AND HT.NAME_ID           = DQ.NAME_ID                 
P00455*           AND DQ.NAME_TYPE         NOT IN ('AN', 'AA', 'AI')            
P00455            AND DQ.NAME_TYPE         = 'CN'                       
P00455            AND HT.CUSTOMER_ROLE_CD  = ' '                        
P00455       ORDER BY HT.CUSTOMER_NO                                    
P00455       FOR READ ONLY                                             
P00455                                                           
P00455                                                      
P00455     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CUS-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO                                             
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.CUSTOMER_NO       = :HT-CUSTOMER-NO                    
MFA-TR*           AND HT.NAME_ID           = DQ.NAME_ID                         
MFA-TR*           AND DQ.NAME_TYPE         NOT IN ('AN', 'AA', 'AI')            
MFA-TR*           AND DQ.NAME_TYPE         = 'CN'                               
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*      ORDER BY HT.CUSTOMER_NO                                            
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
P00633     EXEC SQL DECLARE ZIP-CURSOR CURSOR FOR                       
P00633         SELECT HT.CUSTOMER_NO,                                   
P00633                HT.ACCOUNT_NO,                                    
P00633                HT.PREMISE_NO,                                    
P00633                HT.ADDRESS_ID,                                    
P00633                HT.NAME_ID,                                       
P00633                HT.CUSTOMER_ROLE_CD,                              
P00633                HT.COMPANY_NO                                     
P00633           FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                  
P00633                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
P00633                CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
MAN002*         WHERE CIS.SUBSTR3(CE.SSN,5,5) = :SSN5-NUMBER     
MAN002          WHERE CE.SSN_SUBSTR_5_5 = :SSN5-NUMBER                 
P00633            AND CE.NAME_ID = HT.NAME_ID                           
P00633            AND HT.ADDRESS_ID = DY.ADDRESS_ID                     
P00633            AND DY.ZIP_CODE = :ZIP-CODE                           
P00633       FOR READ ONLY                                             
P00633                                                           
P00633                                                      
P00633     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE ZIP-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO                                             
MFA-TR*          FROM CSS_CUST_STATS CE,                                        
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_ADDR_FORMATTED DY                                     
MFA-TR*          WHERE SUBSTR(CE.SSN,5,5) = :SSN5-NUMBER                         
MFA-TR*           AND CE.NAME_ID = HT.NAME_ID                                   
MFA-TR*           AND HT.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*           AND DY.ZIP_CODE = :ZIP-CODE                                   
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7265                                                       
MFA-TR*    END-EXEC.                                                            
P00633                                                                  
P00633     EXEC SQL DECLARE PHX-CURSOR CURSOR FOR                       
P00633         SELECT DISTINCT(HT.CUSTOMER_NO),                         
P00633                HT.ACCOUNT_NO,                                    
P00633                HT.PREMISE_NO,                                    
P00633                HT.ADDRESS_ID,                                    
P00633                HT.NAME_ID,                                       
P00633                HT.CUSTOMER_ROLE_CD,                              
P00633                HT.COMPANY_NO                                     
P00633           FROM CSS_CUST_PHONE CB WITH(READUNCOMMITTED),                  
P00633                CSS_NAME DQ WITH(READUNCOMMITTED),                        
P00633                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
P00633          WHERE CB.PHONE_NO = :PHONE-NUMBER                       
P00633            AND CB.PHONE_TYPE IN ('H1','B1','A1')                 
P00633            AND CB.CUSTOMER_NO = HT.CUSTOMER_NO                   
P00633            AND HT.ACCOUNT_NO > 0                                 
P00633            AND HT.NAME_ID = DQ.NAME_ID                           
P00633            AND ((DQ.NAME_TYPE = 'CN' AND                         
P00633                 CB.CUSTOMER_TYPE = 'C')                          
P00633             OR (DQ.NAME_TYPE = 'SN' AND                          
P00633                 CB.CUSTOMER_TYPE = 'S'))                         
P00633         UNION                                                    
P00633         SELECT DISTINCT(HT2.CUSTOMER_NO),                        
P00633                HT2.ACCOUNT_NO,                                   
P00633                HT2.PREMISE_NO,                                   
P00633                HT2.ADDRESS_ID,                                   
P00633                HT2.NAME_ID,                                      
P00633                HT2.CUSTOMER_ROLE_CD,                             
P00633                HT2.COMPANY_NO                                    
P00633           FROM CSS_CUST_PHONE CB WITH(READUNCOMMITTED),                  
P00633                CSS_NAME DQ WITH(READUNCOMMITTED),                        
P00633                CSS_NAME_ACCT_XREF HT1 WITH(READUNCOMMITTED),             
P00633                CSS_NAME_ACCT_XREF HT2 WITH(READUNCOMMITTED)              
P00633          WHERE CB.PHONE_NO = :PHONE-NUMBER                       
P00633            AND CB.PHONE_TYPE IN ('H1','B1','W1','A1')            
P00633            AND CB.CUSTOMER_NO = HT1.CUSTOMER_NO                  
P00633*           AND HT1.ACCOUNT_NO = 0                                        
P00633            AND HT1.NAME_ID = HT2.NAME_ID                         
P00633            AND HT2.ACCOUNT_NO > 0                                
P00633            AND HT2.CUSTOMER_ROLE_CD IN ('A', 'B')                
P00633            AND HT2.NAME_ID = DQ.NAME_ID                          
P00633         UNION                                                    
P00633         SELECT DISTINCT(HT.CUSTOMER_NO),                         
P00633                HT.ACCOUNT_NO,                                    
P00633                HT.PREMISE_NO,                                    
P00633                HT.ADDRESS_ID,                                    
P00633                HT.NAME_ID,                                       
P00633                HT.CUSTOMER_ROLE_CD,                              
P00633                HT.COMPANY_NO                                     
P00633           FROM CSS_CONTACT_PHONE LP WITH(READUNCOMMITTED),               
P00633                CSS_CONTACT CV WITH(READUNCOMMITTED),                     
P00633                CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                
P00633                CSS_NAME DQ WITH(READUNCOMMITTED),                        
P00633                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
P00633          WHERE PHONE_NO = :PHONE-NUMBER                          
P00633            AND LP.CONTACT_ID = CV.CONTACT_ID                     
P00633            AND CV.CONTACT_TYPE = 'OC'                            
P00633            AND CV.CONTACT_ID = DW.CONTACT_ID                     
P00633            AND DW.ACCOUNT_NO = HT.ACCOUNT_NO                     
P00633            AND HT.NAME_ID = DQ.NAME_ID                           
P00633            AND DQ.NAME_TYPE = 'CN'                               
P00633            AND HT.CUSTOMER_ROLE_CD = ' '                         
P00633       ORDER BY 2, 6                                              
P00633       FOR READ ONLY                                             
P00633                                                           
P00633                                                      
P00633     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE PHX-CURSOR CURSOR FOR                               
MFA-TR*        SELECT DISTINCT(HT.CUSTOMER_NO),                                 
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO                                             
MFA-TR*          FROM CSS_CUST_PHONE CB,                                        
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE CB.PHONE_NO = :PHONE-NUMBER                               
MFA-TR*           AND CB.PHONE_TYPE IN ('H1','B1','A1')                         
MFA-TR*           AND CB.CUSTOMER_NO = HT.CUSTOMER_NO                           
MFA-TR*           AND HT.ACCOUNT_NO > 0                                         
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND ((DQ.NAME_TYPE = 'CN' AND                                 
MFA-TR*                CB.CUSTOMER_TYPE = 'C')                                  
MFA-TR*            OR (DQ.NAME_TYPE = 'SN' AND                                  
MFA-TR*                CB.CUSTOMER_TYPE = 'S'))                                 
MFA-TR*        UNION                                                            
MFA-TR*        SELECT DISTINCT(HT2.CUSTOMER_NO),                                
MFA-TR*               HT2.ACCOUNT_NO,                                           
MFA-TR*               HT2.PREMISE_NO,                                           
MFA-TR*               HT2.ADDRESS_ID,                                           
MFA-TR*               HT2.NAME_ID,                                              
MFA-TR*               HT2.CUSTOMER_ROLE_CD,                                     
MFA-TR*               HT2.COMPANY_NO                                            
MFA-TR*          FROM CSS_CUST_PHONE CB,                                        
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT1,                                   
MFA-TR*               CSS_NAME_ACCT_XREF HT2                                    
MFA-TR*         WHERE CB.PHONE_NO = :PHONE-NUMBER                               
MFA-TR*           AND CB.PHONE_TYPE IN ('H1','B1','W1','A1')                    
MFA-TR*           AND CB.CUSTOMER_NO = HT1.CUSTOMER_NO                          
MFA-TR*           AND HT1.ACCOUNT_NO = 0                                        
MFA-TR*           AND HT1.NAME_ID = HT2.NAME_ID                                 
MFA-TR*           AND HT2.ACCOUNT_NO > 0                                        
MFA-TR*           AND HT2.CUSTOMER_ROLE_CD IN ('A', 'B')                        
MFA-TR*           AND HT2.NAME_ID = DQ.NAME_ID                                  
MFA-TR*        UNION                                                            
MFA-TR*        SELECT DISTINCT(HT.CUSTOMER_NO),                                 
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO                                             
MFA-TR*          FROM CSS_CONTACT_PHONE LP,                                     
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_CONTACT_ACCT DW,                                      
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE PHONE_NO = :PHONE-NUMBER                                  
MFA-TR*           AND LP.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.CONTACT_TYPE = 'OC'                                    
MFA-TR*           AND CV.CONTACT_ID = DW.CONTACT_ID                             
MFA-TR*           AND DW.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*      ORDER BY 2, 6                                                      
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7280                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION USING PARM-LIMIT-TYPE-TEMP                    
                                PARM-OFFICE-CITY                        
                                PARM-SELECT-METHOD-TEMP                 
                                PARM-CRITERIA                           
                                PARM-BYPASS-ACCESS-HIST                 
                                PARM-USERID                             
                                PARM-ROW-COUNT.                         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           IF  SEL-METH-ACC                                             
               
MSQ016        GOBACK                                                 
           ELSE                                                         
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT               
           END-IF.                                                      
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
P00455     IF  PARM-SELECT-METHOD-TEMP NOT = 'ACC'                      
                 PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT              
                 EXEC SQL DECLARE C1 CURSOR  FOR             
                     SELECT                                             
                        RETURN_CODE               AS RETURN_CODE        
                       ,LTRIM(RTRIM(ADDRESS))            AS ADDRESS            
                       ,LTRIM(RTRIM(NAME))               AS NAME               
                       ,LTRIM(RTRIM(CITY))               AS CITY               
                       ,LTRIM(RTRIM(ACCT_TYPE))          AS ACCT_TYPE          
                       ,LTRIM(RTRIM(ACCOUNT_NO))         AS 
           ACCOUNT_NUMBER     
                       ,RTRIM(SERVICE_AVAIL)      AS SERVICE_AVAIL      
                       ,LTRIM(RTRIM(CUSTOMER_NO))        AS 
           CUSTOMER_NUMBER    
                       ,LTRIM(RTRIM(LOCAL_OFFICE))       AS LOCAL_OFFICE       
                       ,LTRIM(RTRIM(PREMISE_NO))         AS PREMISE_NO         
                       ,LTRIM(RTRIM(ZIP_CODE))           AS ZIP_CODE           
                       ,LTRIM(RTRIM(COMPANY_NO))         AS COMPANY_NO         
                       ,LTRIM(RTRIM(PASSWORD))           AS PASSWORD           
                       ,LTRIM(RTRIM(ENDV))               AS ENDV_FLAG          
                       ,LTRIM(RTRIM(DNP))                AS DNP_FLAG           
                       ,LTRIM(RTRIM(BANKRUPTCY_IND))     AS 
           BANKRUPTCY_IND     
                       ,LTRIM(RTRIM(CONSOLIDATE_BILL))   AS 
           CONSOLIDATE_BILL   
                       ,LTRIM(RTRIM(PENDING_FINAL))      AS 
           PENDING_FINAL      
P00455                 ,LTRIM(RTRIM(POINT_ID_FL))      AS POINT_ID_FL          
P00455                 ,LTRIM(RTRIM(UTILITY_SOURCE_CD))                        
P00455                                          AS UTILITY_SOURCE_CD    
P00455                 ,LTRIM(RTRIM(SERVICE_SUPPLIED)) AS 
           SERVICE_SUPPLIED     
P00455                 ,LTRIM(RTRIM(CODE_ACCT_STAT))   AS CODE_ACCT_STAT       
P00455                 ,LTRIM(RTRIM(CODE_CRIT_OUTAGE)) AS 
           CODE_CRIT_OUTAGE     
P00455                 ,LTRIM(RTRIM(KEY_CUSTOMER))     AS KEY_CUSTOMER         
P00455                 ,LTRIM(RTRIM(RATE_PLAN_NO))     AS RATE_PLAN_NO         
P00455                 ,LTRIM(RTRIM(CODE_REVENUE_CLASS)) AS 
           CODE_REVENUE_CLASS 
P00633                 ,LTRIM(RTRIM(ACCOUNT_ID))       AS ACCOUNT_ID           
                     FROM #CSR03945_R1                           
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*          EXEC SQL DECLARE C1 CURSOR WITH RETURN FOR                     
MFA-TR*              SELECT                                                     
MFA-TR*                 RETURN_CODE               AS RETURN_CODE                
MFA-TR*                ,STRIP(ADDRESS)            AS ADDRESS                    
MFA-TR*                ,STRIP(NAME)               AS NAME                       
MFA-TR*                ,STRIP(CITY)               AS CITY                       
MFA-TR*                ,STRIP(ACCT_TYPE)          AS ACCT_TYPE                  
MFA-TR*                ,STRIP(ACCOUNT_NO)         AS ACCOUNT_NUMBER             
MFA-TR*                ,RTRIM(SERVICE_AVAIL)      AS SERVICE_AVAIL              
MFA-TR*                ,STRIP(CUSTOMER_NO)        AS CUSTOMER_NUMBER            
MFA-TR*                ,STRIP(LOCAL_OFFICE)       AS LOCAL_OFFICE               
MFA-TR*                ,STRIP(PREMISE_NO)         AS PREMISE_NO                 
MFA-TR*                ,STRIP(ZIP_CODE)           AS ZIP_CODE                   
MFA-TR*                ,STRIP(COMPANY_NO)         AS COMPANY_NO                 
MFA-TR*                ,STRIP(PASSWORD)           AS PASSWORD                   
MFA-TR*                ,STRIP(ENDV)               AS ENDV_FLAG                  
MFA-TR*                ,STRIP(DNP)                AS DNP_FLAG                   
MFA-TR*                ,STRIP(BANKRUPTCY_IND)     AS BANKRUPTCY_IND             
MFA-TR*                ,STRIP(CONSOLIDATE_BILL)   AS CONSOLIDATE_BILL           
MFA-TR*                ,STRIP(PENDING_FINAL)      AS PENDING_FINAL              
MFA-TR*                ,STRIP(POINT_ID_FL)      AS POINT_ID_FL                  
MFA-TR*                ,STRIP(UTILITY_SOURCE_CD)                                
MFA-TR*                                         AS UTILITY_SOURCE_CD            
MFA-TR*                ,STRIP(SERVICE_SUPPLIED) AS SERVICE_SUPPLIED             
MFA-TR*                ,STRIP(CODE_ACCT_STAT)   AS CODE_ACCT_STAT               
MFA-TR*                ,STRIP(CODE_CRIT_OUTAGE) AS CODE_CRIT_OUTAGE             
MFA-TR*                ,STRIP(KEY_CUSTOMER)     AS KEY_CUSTOMER                 
MFA-TR*                ,STRIP(RATE_PLAN_NO)     AS RATE_PLAN_NO                 
MFA-TR*                ,STRIP(CODE_REVENUE_CLASS) AS CODE_REVENUE_CLASS         
MFA-TR*                ,STRIP(ACCOUNT_ID)       AS ACCOUNT_ID                   
MFA-TR*              FROM SESSION.CSR03945_R1                                   
MFA-TR*          END-EXEC                                                       
             ELSE                                                       
                 EXEC SQL DECLARE C2 CURSOR  FOR             
                     SELECT                                             
                        :S-RETURN-CODE              AS RETURN_CODE      
                        ,LTRIM(RTRIM(:S-ADDRESS))          AS ADDRESS          
                        ,LTRIM(RTRIM(:S-NAME))             AS NAME             
                        ,LTRIM(RTRIM(:S-CITY))             AS CITY             
                        ,LTRIM(RTRIM(:S-ACCT-TYPE))        AS ACCT_TYPE        
                        ,LTRIM(RTRIM(:S-ACCOUNT-NO))       AS 
           ACCOUNT_NUMBER   
                        ,RTRIM(:S-SERVICE-AVAIL)    AS SERVICE_AVAIL    
                        ,LTRIM(RTRIM(:S-CUSTOMER-NO))      AS 
           CUSTOMER_NUMBER  
                        ,LTRIM(RTRIM(:S-LOCAL-OFFICE))     AS 
           LOCAL_OFFICE     
                        ,LTRIM(RTRIM(:S-PREMISE-NO))       AS PREMISE_NO       
                        ,LTRIM(RTRIM(:S-ZIP-CODE))         AS ZIP_CODE         
                        ,LTRIM(RTRIM(:S-COMPANY-NO))       AS COMPANY_NO       
                        ,LTRIM(RTRIM(:S-PASSWORD))         AS PASSWORD         
                        ,LTRIM(RTRIM(:S-ENDV))             AS ENDV_FLAG        
                        ,LTRIM(RTRIM(:S-DNP))              AS DNP_FLAG         
                        ,LTRIM(RTRIM(:S-BANKRUPTCY-IND))   AS 
           BANKRUPTCY_IND   
                        ,LTRIM(RTRIM(:S-CONSOLIDATE-BILL)) AS 
           CONSOLIDATE_BILL 
                        ,LTRIM(RTRIM(:S-PENDING-FINAL))    AS 
           PENDING_FINAL    
P00455                  ,LTRIM(RTRIM(:S-POINT-ID-FL))      AS 
           POINT_ID_FL      
P00455                  ,LTRIM(RTRIM(:S-UTILITY-SOURCE-CD))                    
P00455                                       AS UTILITY_SOURCE_CD       
P00455                  ,LTRIM(RTRIM(:S-SERVICE-SUPPLIED)) AS 
           SERVICE_SUPPLIED 
P00455                  ,LTRIM(RTRIM(:S-CODE-ACCT-STAT))   AS 
           CODE_ACCT_STAT   
P00455                  ,LTRIM(RTRIM(:S-CODE-CRIT-OUTAGE)) AS 
           CODE_CRIT_OUTAGE 
P00455                  ,LTRIM(RTRIM(:S-KEY-CUSTOMER))     AS 
           KEY_CUSTOMER     
P00455                  ,LTRIM(RTRIM(:S-RATE-PLAN-NO))     AS 
           RATE_PLAN_NO     
P00455                  ,LTRIM(RTRIM(:S-CODE-REVENUE-CLASS))                   
P00455                                         AS CODE_REVENUE_CLASS    
P00633                  ,LTRIM(RTRIM(:S-ACCOUNT-ID))       AS ACCOUNT_ID       
                     FROM CIS.SYSDUMMY1                              
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*          EXEC SQL DECLARE C2 CURSOR WITH RETURN FOR                     
MFA-TR*              SELECT                                                     
MFA-TR*                 :S-RETURN-CODE              AS RETURN_CODE              
MFA-TR*                 ,STRIP(:S-ADDRESS)          AS ADDRESS                  
MFA-TR*                 ,STRIP(:S-NAME)             AS NAME                     
MFA-TR*                 ,STRIP(:S-CITY)             AS CITY                     
MFA-TR*                 ,STRIP(:S-ACCT-TYPE)        AS ACCT_TYPE                
MFA-TR*                 ,STRIP(:S-ACCOUNT-NO)       AS ACCOUNT_NUMBER           
MFA-TR*                 ,RTRIM(:S-SERVICE-AVAIL)    AS SERVICE_AVAIL            
MFA-TR*                 ,STRIP(:S-CUSTOMER-NO)      AS CUSTOMER_NUMBER          
MFA-TR*                 ,STRIP(:S-LOCAL-OFFICE)     AS LOCAL_OFFICE             
MFA-TR*                 ,STRIP(:S-PREMISE-NO)       AS PREMISE_NO               
MFA-TR*                 ,STRIP(:S-ZIP-CODE)         AS ZIP_CODE                 
MFA-TR*                 ,STRIP(:S-COMPANY-NO)       AS COMPANY_NO               
MFA-TR*                 ,STRIP(:S-PASSWORD)         AS PASSWORD                 
MFA-TR*                 ,STRIP(:S-ENDV)             AS ENDV_FLAG                
MFA-TR*                 ,STRIP(:S-DNP)              AS DNP_FLAG                 
MFA-TR*                 ,STRIP(:S-BANKRUPTCY-IND)   AS BANKRUPTCY_IND           
MFA-TR*                 ,STRIP(:S-CONSOLIDATE-BILL) AS CONSOLIDATE_BILL         
MFA-TR*                 ,STRIP(:S-PENDING-FINAL)    AS PENDING_FINAL            
MFA-TR*                 ,STRIP(:S-POINT-ID-FL)      AS POINT_ID_FL              
MFA-TR*                 ,STRIP(:S-UTILITY-SOURCE-CD)                            
MFA-TR*                                      AS UTILITY_SOURCE_CD               
MFA-TR*                 ,STRIP(:S-SERVICE-SUPPLIED) AS SERVICE_SUPPLIED         
MFA-TR*                 ,STRIP(:S-CODE-ACCT-STAT)   AS CODE_ACCT_STAT           
MFA-TR*                 ,STRIP(:S-CODE-CRIT-OUTAGE) AS CODE_CRIT_OUTAGE         
MFA-TR*                 ,STRIP(:S-KEY-CUSTOMER)     AS KEY_CUSTOMER             
MFA-TR*                 ,STRIP(:S-RATE-PLAN-NO)     AS RATE_PLAN_NO             
MFA-TR*                 ,STRIP(:S-CODE-REVENUE-CLASS)                           
MFA-TR*                                        AS CODE_REVENUE_CLASS            
MFA-TR*                 ,STRIP(:S-ACCOUNT-ID)       AS ACCOUNT_ID               
MFA-TR*              FROM SYSIBM.SYSDUMMY1                                      
MFA-TR*          END-EXEC                                                       
                 NEXT SENTENCE                                          
             END-IF.                                                    
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR03945_R1' TO        
                 S-SQL-STATEMENT-V.                                     
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR03945_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR03945_R1
               (  RETURN_CODE              INT                     
                  ,ADDRESS CHAR(42)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,NAME CHAR(56)  COLLATE LATIN1_GENERAL_100_BIN2               
                  ,CITY CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2               
                  ,ACCT_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,SERVICE_AVAIL CHAR(05)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,CUSTOMER_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,LOCAL_OFFICE CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,PREMISE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,PASSWORD CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,ENDV CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2               
                  ,DNP CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2                
                  ,BANKRUPTCY_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,CONSOLIDATE_BILL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,PENDING_FINAL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
P00455            ,POINT_ID_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
P00455            ,UTILITY_SOURCE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
P00455            ,SERVICE_SUPPLIED CHAR(05)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
P00455            ,CODE_ACCT_STAT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
P00455            ,CODE_CRIT_OUTAGE CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
P00455            ,KEY_CUSTOMER CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
P00455            ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
P00455            ,CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
P00633            ,ACCOUNT_ID CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2         
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 0120-DELETE-GTT-ROWS THRU 0120-EXIT              
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '0100A'          TO ACTIVE-PARAGRAPH            
                   MOVE 'DECLARE GTT'    TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSR03945_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
               END-IF
            END-IF.       
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       0120-DELETE-GTT-ROWS.                                            
                                                                        
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR03945_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03945_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '0120'                TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR03945_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
            END-IF.           
                                                                        
       0120-EXIT.                                                       
            EXIT.                                                       
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-LIMIT-TYPE-TEMP TO PARM-LIMITS.                    
           MOVE PARM-SELECT-METHOD-TEMP TO PARM-SELECT-METHOD.          
           MOVE SPACE TO WS-PARM-CRITERIA.                              
           MOVE PARM-ROW-COUNT TO WS-ROW-COUNT.                         
           INSPECT WS-ROW-COUNT REPLACING ALL SPACES BY '0'.            
           MOVE WS-ROW-COUNT-R TO CN-MAX-RETURN-ROWS.                   
           IF CN-MAX-RETURN-ROWS = 0                                    
               MOVE 20 TO CN-MAX-RETURN-ROWS
           END-IF.                           
                                                                        
           EVALUATE TRUE                                                
               WHEN SEL-METH-ACC                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO ACC-ACCT-NO                                 
                   IF ACC-ACCT-NO NOT = SPACES                          
                       INSPECT ACC-ACCT-NO REPLACING ALL SPACES BY '0'  
                   END-IF                                               
                   MOVE ACC-ACCT-NO-NUM TO HT-ACCOUNT-NO                
                                                                        
               WHEN SEL-METH-SSN                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO SSN-NUMBER                                  
                                                                        
               WHEN SEL-METH-PHO                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO PHO-NUMBER                                  
                                                                        
P00455         WHEN SEL-METH-CUS                                        
P00455             UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
P00455                 INTO CUS-CUST-NO                                 
P00455             IF CUS-CUST-NO NOT = SPACES                          
P00455                 INSPECT CUS-CUST-NO REPLACING ALL SPACES BY '0'  
P00455             END-IF                                               
P00455             MOVE CUS-CUST-NO-NUM TO HT-CUSTOMER-NO               
                                                                        
P00633         WHEN SEL-METH-ZIP                                        
P00633             UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
P00633                 INTO SSN5-NUMBER                                 
P00633                      ZIP-CODE                                    
P00633                                                                  
P00633         WHEN SEL-METH-PHX                                        
P00633             UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
P00633                 INTO PHONE-NUMBER                                
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TODAYS-DATE                                    
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-TODAYS-DATE                                            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
A03263         WHEN SEL-METH-ACC AND ACC-ACCT-NO-NUM NOT = 0            
                   PERFORM 2100-SEARCH-VIA-ACC-CURSOR THRU 2100-EXIT    
               WHEN SEL-METH-SSN                                        
                   PERFORM 2200-SEARCH-VIA-SSN-CURSOR THRU 2200-EXIT    
               WHEN SEL-METH-PHO                                        
                   PERFORM 2300-SEARCH-VIA-PHO-CURSOR THRU 2300-EXIT    
P00455         WHEN SEL-METH-CUS                                        
                   PERFORM 2400-SEARCH-VIA-CUS-CURSOR THRU 2400-EXIT    
P00633         WHEN SEL-METH-ZIP                                        
P00633             PERFORM 2600-SSN-ZIP-SEARCH THRU 2600-EXIT           
P00633         WHEN SEL-METH-PHX                                        
P00633             PERFORM 2700-PHONE-SEARCH THRU 2700-EXIT             
           END-EVALUATE.                                                
                                                                        
P00455     IF SEL-METH-ACC                                              
               IF CTR-ROWS = ZERO                                       
                   INITIALIZE TDS-RETURN-FIELDS                         
                   MOVE NOT-FOUND TO RS-RETURN-CODE                     
                   PERFORM 2005-MOVE-RESULT THRU 2005-EXIT              
               END-IF                                                   
                  EXEC SQL                                              
                       OPEN C2                                          
                  END-EXEC                                              

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
               GO TO 2000-EXIT                                          
           END-IF.                                                      
                                                                        
           IF CTR-ROWS = ZERO                                           
               INITIALIZE TDS-RETURN-FIELDS                             
               MOVE NOT-FOUND TO RS-RETURN-CODE                         
               PERFORM 2005-MOVE-RESULT THRU 2005-EXIT                  
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
                                                                        
      *    IF CTR-ROWS = CN-MAX-RETURN-ROWS                                     
      *        MOVE 101 TO RS-RETURN-CODE                                       
      *        PERFORM 2005-MOVE-RESULT THRU 2005-EXIT                          
      *        PERFORM 8100-SEND-RESULT THRU 8100-EXIT                          
      *    END-IF.                                                              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2005-MOVE-RESULT.                                                
                                                                        
                                                                        
           MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
           MOVE RS-ADDRESS            TO S-ADDRESS.                     
           MOVE RS-CITY               TO S-CITY.                        
           MOVE RS-NAME               TO S-NAME.                        
           MOVE RS-ACCT-TYPE          TO S-ACCT-TYPE.                   
           MOVE RS-ACCOUNT-NO         TO S-ACCOUNT-NO.                  
           MOVE RS-SERVICE-AVAIL      TO S-SERVICE-AVAIL.               
           MOVE RS-CUSTOMER-NO        TO S-CUSTOMER-NO.                 
           MOVE RS-LOCAL-OFFICE       TO S-LOCAL-OFFICE.                
           MOVE RS-PREMISE-NO         TO S-PREMISE-NO.                  
           MOVE RS-ZIP-CODE           TO S-ZIP-CODE.                    
           MOVE RS-COMPANY-NO         TO S-COMPANY-NO.                  
           MOVE RS-PASSWORD           TO S-PASSWORD.                    
           MOVE RS-ENDV               TO S-ENDV.                        
           MOVE RS-DNP                TO S-DNP.                         
           MOVE RS-BANKRUPTCY-IND     TO S-BANKRUPTCY-IND.              
           MOVE RS-CONSOLIDATE-BILL   TO S-CONSOLIDATE-BILL.            
           MOVE RS-PENDING-FINAL      TO S-PENDING-FINAL.               
P00455     MOVE RS-POINT-ID-FL        TO S-POINT-ID-FL.                 
P00455     MOVE RS-UTILITY-SOURCE-CD  TO S-UTILITY-SOURCE-CD.           
P00455     MOVE RS-SERVICE-SUPPLIED   TO S-SERVICE-SUPPLIED.            
P00455     MOVE RS-CODE-ACCT-STAT     TO S-CODE-ACCT-STAT.              
P00455     MOVE RS-CODE-CRIT-OUTAGE   TO S-CODE-CRIT-OUTAGE.            
P00455     MOVE RS-KEY-CUSTOMER       TO S-KEY-CUSTOMER.                
P00455     MOVE RS-RATE-PLAN-NO       TO S-RATE-PLAN-NO.                
P00455     MOVE RS-CODE-REVENUE-CLASS TO S-CODE-REVENUE-CLASS.          
P00633     MOVE RS-ACCOUNT-ID         TO S-ACCOUNT-ID.                  
                                                                        
       2005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-SEARCH-VIA-ACC-CURSOR.                                      
                                                                        
           PERFORM 7000-OPEN-AT-CURSOR  THRU 7000-EXIT.                 
           PERFORM 7010-FETCH-AT-CURSOR THRU 7010-EXIT.                 
                                                                        
           PERFORM UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR          
                          CTR-ROWS >= CN-MAX-RETURN-ROWS)               
               PERFORM 2500-PROCESS-ROW     THRU 2500-EXIT              
               PERFORM 7010-FETCH-AT-CURSOR THRU 7010-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7020-CLOSE-AT-CURSOR THRU 7020-EXIT.                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-SEARCH-VIA-SSN-CURSOR.                                      
                                                                        
           PERFORM 7100-OPEN-SSN-CURSOR  THRU 7100-EXIT.                
           PERFORM 7110-FETCH-SSN-CURSOR THRU 7110-EXIT.                
                                                                        
           PERFORM UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR          
                          CTR-ROWS >= CN-MAX-RETURN-ROWS)               
               PERFORM 2500-PROCESS-ROW      THRU 2500-EXIT             
               PERFORM 7110-FETCH-SSN-CURSOR THRU 7110-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7120-CLOSE-SSN-CURSOR THRU 7120-EXIT.                
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-SEARCH-VIA-PHO-CURSOR.                                      
                                                                        
           PERFORM 7200-OPEN-PHO-CURSOR  THRU 7200-EXIT.                
           PERFORM 7210-FETCH-PHO-CURSOR THRU 7210-EXIT.                
                                                                        
           PERFORM UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR          
                          CTR-ROWS >= CN-MAX-RETURN-ROWS)               
               PERFORM 2500-PROCESS-ROW      THRU 2500-EXIT             
               PERFORM 7210-FETCH-PHO-CURSOR THRU 7210-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7220-CLOSE-PHO-CURSOR THRU 7220-EXIT.                
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-SEARCH-VIA-CUS-CURSOR.                                      
                                                                        
           PERFORM 7250-OPEN-CUS-CURSOR  THRU 7250-EXIT.                
           PERFORM 7255-FETCH-CUS-CURSOR THRU 7255-EXIT.                
                                                                        
           PERFORM UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR          
                          CTR-ROWS >= CN-MAX-RETURN-ROWS)               
               PERFORM 2500-PROCESS-ROW      THRU 2500-EXIT             
               PERFORM 7255-FETCH-CUS-CURSOR THRU 7255-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7260-CLOSE-CUS-CURSOR THRU 7260-EXIT.                
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-PROCESS-ROW.                                                
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE 'N' TO WS-ARCHIVE-FL.                                   
                                                                        
P00633     IF SEL-METH-PHX AND                                          
P00633        HT-ACCOUNT-NO > 0 AND                                     
P00633        HT-ACCOUNT-NO = WS-PREV-ACCOUNT                           
P00633            GO TO 2500-EXIT
           END-IF.                                      
                                                                        
P00633     MOVE HT-ACCOUNT-NO TO WS-PREV-ACCOUNT.                       
                                                                        
           MOVE HT-COMPANY-NO TO RS-COMPANY-NO.                         
                                                                        
           IF HT-NAME-ID > 0                                            
               PERFORM 7930-GET-NAME THRU 7930-EXIT
           END-IF.                    
                                                                        
           MOVE 'N' TO WS-SERVICES-SET.                                 
           IF HT-ACCOUNT-NO > 0                                         
              PERFORM 7915-GET-ACCOUNT-DETAILS THRU 7915-EXIT           
              PERFORM 7917-SUPPLIED-AVAILABLE  THRU 7917-EXIT           
P00455           IF RS-SERV-SUPPLIED (2) = 'E'                          
P00455              PERFORM 7942-UTILITY-SOURCE   THRU 7942-EXIT        
P00455              PERFORM 7943-POINT-ID         THRU 7943-EXIT        
P00455           END-IF                                                 
P00455           PERFORM  7944-CHECK-IF-INDUSTRIAL THRU 7944-EXIT       
P00455           IF UT-RATE-PLAN-NO EQUAL SPACES                        
P00455              PERFORM 7945-GET-ELEC-RATE THRU 7945-EXIT           
P00455           END-IF                                                 
              PERFORM 7400-OFF-CYCLE THRU 7400-EXIT                     
              PERFORM 7600-RECONNECT THRU 7600-EXIT                     
           ELSE                                                         
              MOVE SPACE TO AT-ACCOUNT-TYPE-CODE                        
                            AT-LOCAL-OFFICE                             
                            AT-MST-SUB-ACCT-IND                         
                            AT-JUDGEMENT-IND                            
                            AT-BANKRUPTCY-IND                           
                            AT-CODE-ACCT-STAT                           
P00455                      AT-CODE-CRIT-OUTAGE                         
                            OC-CODE-BILL-OFF-CYCL                       
P00455                      WS-UTILITY-SOURCE-CD                        
P00455                      WS-POINT-ID-FL                              
P00455                      UT-RATE-PLAN-NO                             
P00455                      UT-CODE-REVENUE-CLASS                       
P00633                      TA-SPCL-BILL-STMNT-TX
           END-IF.                      
                                                                        
           IF HT-PREMISE-NO > 0                                         
               PERFORM 7500-ENDV THRU 7500-EXIT                         
               IF VO-SERV-ORDER-NO > 0                                  
                   MOVE 'Y' TO RS-ENDV                                  
               ELSE                                                     
                   MOVE 'N' TO RS-ENDV                                  
               END-IF                                                   
               IF WS-DNP-FLAG = 'N'                                     
                   PERFORM 7700-DNP THRU 7700-EXIT                      
               END-IF                                                   
               PERFORM 7940-GET-PREMISE-DETAILS THRU 7940-EXIT          
               IF WS-SERVICES-SET = 'N' OR ' '                          
                   PERFORM 2520-PROCESS-SERVICES THRU 2520-EXIT
               END-IF
           END-IF.        
                                                                        
           IF LIMIT-ACTIVE-IVR AND AT-CODE-ACCT-STAT NOT = 'A'          
               GO TO 2500-EXIT
           END-IF.                                         
                                                                        
           IF WS-ARCHIVE-FL = 'Y'                                       
               GO TO 2500-EXIT
           END-IF.                                         
                                                                        
           IF HT-ADDRESS-ID > 0                                         
               PERFORM 7920-GET-ADDRESS THRU 7920-EXIT                  
               PERFORM 7925-GET-CITY    THRU 7925-EXIT                  
           ELSE                                                         
               MOVE SPACE TO DY-HOUSE-NO                                
                             DY-ADDR-PREFIX-1                           
                             DY-ADDR-PREFIX-2                           
                             DY-STREET-NAME                             
                             DY-ADDRESS-OVERFLOW                        
                             DY-ADDR-USAGE-CD                           
                             DY-STREET-SUFFIX                           
                             DY-STREET-LOCATION-1                       
                             DY-STREET-LOCATION-2                       
                             DY-ZIP-CODE                                
                             DY-ZIP-CODE-TOKEN                          
                             A4-TOWN                                    
                             DY-ADDR-SUFFIX
           END-IF.                            
                                                                        
           MOVE HT-ACCOUNT-NO         TO RS-ACCOUNT-NO.                 
           MOVE AT-ACCOUNT-TYPE-CODE  TO RS-ACCT-TYPE.                  
P00455     MOVE AT-CODE-ACCT-STAT     TO RS-CODE-ACCT-STAT              
P00455     MOVE AT-CODE-CRIT-OUTAGE   TO RS-CODE-CRIT-OUTAGE            
P00455     MOVE WS-UTILITY-SOURCE-CD  TO RS-UTILITY-SOURCE-CD           
P00455     MOVE WS-POINT-ID-FL        TO RS-POINT-ID-FL                 
P00455     MOVE UT-RATE-PLAN-NO       TO RS-RATE-PLAN-NO                
P00455     MOVE UT-CODE-REVENUE-CLASS TO RS-CODE-REVENUE-CLASS          
           IF AT-MST-SUB-ACCT-IND > ' '                                 
               MOVE 'Y' TO RS-CONSOLIDATE-BILL                          
           ELSE                                                         
               MOVE 'N' TO RS-CONSOLIDATE-BILL
           END-IF.                         
           IF OC-CODE-BILL-OFF-CYCL = 'B'                               
               MOVE 'Y' TO RS-PENDING-FINAL                             
           ELSE                                                         
               MOVE 'N' TO RS-PENDING-FINAL
           END-IF.                            
                                                                        
           MOVE DY-ZIP-CODE           TO RS-ZIP-CODE.                   
                                                                        
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE DQ-LAST-NAME TO WS-FROM                             
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-LAST-NAME                             
                                                                        
               MOVE DQ-FIRST-NAME TO WS-FROM                            
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-FIRST-NAME                            
                                                                        
               IF DQ-MIDDLE-NAME NOT = SPACE                            
                   MOVE DQ-MIDDLE-NAME TO WS-FROM                       
                   PERFORM 2510-PROCESS-FROM-STRING                     
                   MOVE WS-FROM TO DQ-MIDDLE-NAME                       
               END-IF                                                   
                                                                        
               MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
                                                                        
               IF DQ-MIDDLE-NAME = SPACE                                
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               ELSE                                                     
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME     TO RS-NAME                         
           END-IF.                                                      
                                                                        
           MOVE SPACE TO WS-ADDRESS.                                    
           SET WS-ADD-SUB TO 1.                                         
                                                                        
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE DY-STREET-NAME           TO WS-FROM                 
               MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ               
               PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT           
                                                                        
               MOVE '&' TO WS-FROM                                      
               MOVE 1   TO WS-MAX-SZ                                    
               PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT           
                                                                        
               MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM            
               MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ          
               PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT           
           ELSE                                                         
               MOVE SPACE TO WS-ADDRESS                                 
               SET WS-ADD-SUB TO 1                                      
                                                                        
               IF DY-HOUSE-NO NOT = SPACE                               
                   MOVE DY-HOUSE-NO           TO WS-FROM                
                   MOVE LENGTH OF DY-HOUSE-NO TO WS-MAX-SZ              
                   PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT       
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-1 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-1           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT       
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-2 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-2           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT       
               END-IF                                                   
                                                                        
               IF DY-STREET-NAME NOT = SPACE                            
                   MOVE DY-STREET-NAME           TO WS-FROM             
                   MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ           
                   PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT       
               END-IF                                                   
                                                                        
               IF DY-STREET-SUFFIX NOT = SPACE                          
                   MOVE DY-STREET-SUFFIX           TO WS-FROM           
                   MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT       
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-1 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-1           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT       
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-2 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-2           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT       
               END-IF                                                   
                                                                        
               IF DY-ADDR-SUFFIX NOT = SPACE                            
                   MOVE DY-ADDR-SUFFIX                 TO WS-FROM       
                   MOVE LENGTH OF DY-ADDR-SUFFIX       TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS THRU 2540-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS           TO RS-ADDRESS.                     
                                                                        
           MOVE A4-TOWN              TO RS-CITY.                        
           MOVE HT-CUSTOMER-NO       TO RS-CUSTOMER-NO.                 
           MOVE AT-LOCAL-OFFICE      TO RS-LOCAL-OFFICE.                
           MOVE HT-PREMISE-NO        TO RS-PREMISE-NO.                  
                                                                        
           IF AT-BANKRUPTCY-IND = 'B' AND AT-JUDGEMENT-IND = 'J'        
               MOVE 'A' TO AT-BANKRUPTCY-IND                            
           ELSE                                                         
               IF AT-BANKRUPTCY-IND = 'B' AND AT-JUDGEMENT-IND NOT = 'J'
                   MOVE 'B' TO AT-BANKRUPTCY-IND                        
               ELSE                                                     
                   IF AT-BANKRUPTCY-IND NOT EQUAL 'B' AND               
                      AT-JUDGEMENT-IND = 'J'                            
                          MOVE 'J' TO AT-BANKRUPTCY-IND
                   END-IF
               END-IF
           END-IF.                
           MOVE AT-BANKRUPTCY-IND    TO RS-BANKRUPTCY-IND.              
                                                                        
           IF WS-PREV-NAME = RS-NAME AND                                
              WS-PREV-CUST = RS-CUSTOMER-NO AND                         
             (SEL-METH-SSN OR SEL-METH-PHO)                             
                 MOVE RS-NAME TO WS-PREV-NAME                           
                 MOVE SPACE   TO RS-NAME                                
           ELSE                                                         
               MOVE RS-NAME TO WS-PREV-NAME
           END-IF.                            
                                                                        
           IF HT-CUSTOMER-NO = 0                                        
              MOVE SPACES TO RS-NAME
           END-IF.                                   
           MOVE RS-CUSTOMER-NO TO WS-PREV-CUST.                         
                                                                        
           PERFORM 7300-CUST-STATS THRU 7300-EXIT.                      
           MOVE CE-PASSWORD-TX TO RS-PASSWORD.                          
                                                                        
P00455     PERFORM 7350-CUST-MISC-INFO  THRU 7350-EXIT.                 
P00455     MOVE LQ-KEY-CUSTOMER TO RS-KEY-CUSTOMER.                     
                                                                        
           MOVE WS-DNP-FLAG TO RS-DNP.                                  
                                                                        
P00633     PERFORM 7450-ACCOUNT-ID THRU 7450-EXIT.                      
P00633     MOVE TA-SPCL-BILL-STMNT-TX TO RS-ACCOUNT-ID.                 
                                                                        
           IF PARM-BYPASS-ACCESS-HIST NOT = 'Y' AND                     
              HT-CUSTOMER-NO > 0                                        
                  PERFORM 8200-INSERT-ACCESS-HISTORY THRU 8200-EXIT
           END-IF.    
                                                                        
           PERFORM 2005-MOVE-RESULT THRU 2005-EXIT.                     
                                                                        
           IF  SEL-METH-ACC                                             
               MOVE 1 TO CTR-ROWS                                       
           ELSE                                                         
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2510-PROCESS-FROM-STRING.                                        
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 51 BY -1                             
                 UNTIL WS-SUB < 1                                       
                    OR WS-FROM-X (WS-SUB) NOT = SPACE                   
           END-PERFORM.                                                 
           ADD 1             TO WS-SUB.                                 
           MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2520-PROCESS-SERVICES.                                           
                                                                        
           IF PR-GAS-AVAILABLE-IND = 'A' OR 'I'                         
               MOVE 'G' TO RS-SERV-AVAIL (1)
           END-IF.                           
P00455     IF PR-GAS-AVAILABLE-IND = 'A'                                
P00455         MOVE 'G' TO RS-SERV-SUPPLIED (1)
           END-IF.                        
           IF PR-ELEC-AVAILABLE-IND = 'A' OR 'I'                        
               MOVE 'E' TO RS-SERV-AVAIL (2)
           END-IF.                           
P00455     IF PR-ELEC-AVAILABLE-IND = 'A'                               
P00455         MOVE 'E' TO RS-SERV-SUPPLIED (2)
           END-IF.                        
           IF PR-LITE-AVAILABLE-IND = 'A' OR 'I'                        
               MOVE 'L' TO RS-SERV-AVAIL (3)
           END-IF.                           
P00455     IF PR-LITE-AVAILABLE-IND = 'A'                               
P00455         MOVE 'L' TO RS-SERV-SUPPLIED (3)
           END-IF.                        
           IF PR-WTR-AVAILABLE-IND = 'A' OR 'I'                         
               MOVE 'W' TO RS-SERV-AVAIL (4)
           END-IF.                           
P00455     IF PR-WTR-AVAILABLE-IND = 'A'                                
P00455         MOVE 'W' TO RS-SERV-SUPPLIED (4)
           END-IF.                        
           IF PR-SWR-AVAILABLE-IND = 'A' OR 'I'                         
               MOVE 'S' TO RS-SERV-AVAIL (5)
           END-IF.                           
P00455     IF PR-SWR-AVAILABLE-IND = 'A'                                
P00455         MOVE 'S' TO RS-SERV-SUPPLIED (5)
           END-IF.                        
                                                                        
       2520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2540-ACCUMULATE-ADDRESS.                                         
                                                                        
           PERFORM                                                      
               VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
                 UNTIL WS-LENGTH < 1                                    
                    OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
           END-PERFORM.                                                 
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 1 BY 1                               
                 UNTIL WS-SUB > WS-LENGTH                               
                   MOVE WS-FROM-X (WS-SUB)                              
                        TO WS-ADDRESS-X (WS-ADD-SUB)                    
                   SET WS-ADD-SUB UP BY 1                               
           END-PERFORM.                                                 
                                                                        
           SET WS-ADD-SUB UP BY 1.                                      
                                                                        
       2540-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00633 2600-SSN-ZIP-SEARCH.                                             
P00633                                                                  
P00633     PERFORM 7265-OPEN-ZIP-CURSOR THRU 7265-EXIT.                 
P00633     PERFORM 7270-FETCH-ZIP-CURSOR THRU 7270-EXIT.                
P00633                                                                  
P00633     PERFORM                                                      
P00633         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
P00633                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
P00633         PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
P00633         PERFORM 7270-FETCH-ZIP-CURSOR THRU 7270-EXIT             
P00633     END-PERFORM.                                                 
P00633                                                                  
P00633     PERFORM 7275-CLOSE-ZIP-CURSOR THRU 7275-EXIT.                
P00633                                                                  
P00633 2600-EXIT.                                                       
P00633     EXIT.                                                        
P00633                                                                  
P00633 2700-PHONE-SEARCH.                                               
P00633                                                                  
P00633     PERFORM 7280-OPEN-PHX-CURSOR THRU 7280-EXIT.                 
P00633     PERFORM 7285-FETCH-PHX-CURSOR THRU 7285-EXIT.                
P00633                                                                  
P00633     PERFORM                                                      
P00633         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
P00633                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
P00633         PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
P00633         PERFORM 7285-FETCH-PHX-CURSOR THRU 7285-EXIT             
P00633     END-PERFORM.                                                 
P00633                                                                  
P00633     PERFORM 7290-CLOSE-PHX-CURSOR THRU 7290-EXIT.                
P00633                                                                  
P00633 2700-EXIT.                                                       
P00633     EXIT.                                                        
                                                                        
       7000-OPEN-AT-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN AT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7000'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-FETCH-AT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH AT-CURSOR                                          
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7010'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-CLOSE-AT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE AT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7020'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7100-OPEN-SSN-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN SSN-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7100'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'SSN'                  TO TABLE-ELEMENT-1           
               MOVE SSN-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-FETCH-SSN-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               FETCH SSN-CURSOR                                         
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7110'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'SSN'                  TO TABLE-ELEMENT-1           
               MOVE SSN-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-CLOSE-SSN-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE SSN-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7120'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'SSN'                  TO TABLE-ELEMENT-1           
               MOVE SSN-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-OPEN-PHO-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN PHO-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7200'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'PHONE_NO'             TO TABLE-ELEMENT-1           
               MOVE PHO-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-FETCH-PHO-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              FETCH PHO-CURSOR                                          
              INTO :HT-CUSTOMER-NO,                                     
                   :HT-ACCOUNT-NO,                                      
                   :HT-PREMISE-NO,                                      
                   :HT-ADDRESS-ID,                                      
                   :HT-NAME-ID,                                         
                   :HT-CUSTOMER-ROLE-CD,                                
                   :HT-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7210'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'PHONE_NO'             TO TABLE-ELEMENT-1           
               MOVE PHO-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CLOSE-PHO-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
             CLOSE PHO-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7220'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'PHONE_NO'             TO TABLE-ELEMENT-1           
               MOVE PHO-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-OPEN-CUS-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN CUS-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7250'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE  HT-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7255-FETCH-CUS-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              FETCH CUS-CURSOR                                          
              INTO :HT-CUSTOMER-NO,                                     
                   :HT-ACCOUNT-NO,                                      
                   :HT-PREMISE-NO,                                      
                   :HT-ADDRESS-ID,                                      
                   :HT-NAME-ID,                                         
                   :HT-CUSTOMER-ROLE-CD,                                
                   :HT-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7255'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7255-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7260-CLOSE-CUS-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
             CLOSE CUS-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7260'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00633 7265-OPEN-ZIP-CURSOR.                                            
P00633                                                                  
P00633     EXEC SQL                                                     
P00633         OPEN ZIP-CURSOR                                          
P00633     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00633                                                                  
P00633     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00633                                                                  
P00633     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00633         NEXT SENTENCE                                            
P00633     ELSE                                                         
P00633         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
P00633         MOVE '7265'                 TO ACTIVE-PARAGRAPH          
P00633         MOVE 'OPEN'                 TO ABEND-FUNCTION            
P00633         MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
P00633         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
P00633         MOVE 'SSN'                  TO TABLE-ELEMENT-1           
P00633         MOVE SSN5-NUMBER            TO HOSTVAR-ELEMENT-1         
P00633         MOVE 'ZIP'                  TO TABLE-ELEMENT-2           
P00633         MOVE ZIP-CODE               TO HOSTVAR-ELEMENT-2         
P00633         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00633         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
P00633                                                                  
P00633 7265-EXIT.                                                       
P00633     EXIT.                                                        
P00633                                                                  
P00633 7270-FETCH-ZIP-CURSOR.                                           
P00633                                                                  
P00633     EXEC SQL                                                     
P00633         FETCH ZIP-CURSOR                                         
P00633          INTO :HT-CUSTOMER-NO,                                   
P00633               :HT-ACCOUNT-NO,                                    
P00633               :HT-PREMISE-NO,                                    
P00633               :HT-ADDRESS-ID,                                    
P00633               :HT-NAME-ID,                                       
P00633               :HT-CUSTOMER-ROLE-CD,                              
P00633               :HT-COMPANY-NO                                     
P00633     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00633                                                                  
P00633     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00633                                                                  
P00633     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
P00633         NEXT SENTENCE                                            
P00633     ELSE                                                         
P00633         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
P00633         MOVE '7270'                 TO ACTIVE-PARAGRAPH          
P00633         MOVE 'FETCH'                TO ABEND-FUNCTION            
P00633         MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
P00633         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
P00633         MOVE 'SSN'                  TO TABLE-ELEMENT-1           
P00633         MOVE SSN5-NUMBER            TO HOSTVAR-ELEMENT-1         
P00633         MOVE 'ZIP'                  TO TABLE-ELEMENT-2           
P00633         MOVE ZIP-CODE               TO HOSTVAR-ELEMENT-2         
P00633         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00633         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
P00633                                                                  
P00633 7270-EXIT.                                                       
P00633     EXIT.                                                        
P00633                                                                  
P00633 7275-CLOSE-ZIP-CURSOR.                                           
P00633                                                                  
P00633     EXEC SQL                                                     
P00633         CLOSE ZIP-CURSOR                                         
P00633     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00633                                                                  
P00633     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00633                                                                  
P00633     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00633         NEXT SENTENCE                                            
P00633     ELSE                                                         
P00633         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
P00633         MOVE '7275'                 TO ACTIVE-PARAGRAPH          
P00633         MOVE 'CLOSE'                TO ABEND-FUNCTION            
P00633         MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
P00633         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
P00633         MOVE 'SSN'                  TO TABLE-ELEMENT-1           
P00633         MOVE SSN5-NUMBER            TO HOSTVAR-ELEMENT-1         
P00633         MOVE 'ZIP'                  TO TABLE-ELEMENT-2           
P00633         MOVE ZIP-CODE               TO HOSTVAR-ELEMENT-2         
P00633         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00633         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
P00633                                                                  
P00633 7275-EXIT.                                                       
P00633     EXIT.                                                        
P00633                                                                  
P00633 7280-OPEN-PHX-CURSOR.                                            
P00633                                                                  
P00633     EXEC SQL                                                     
P00633        OPEN PHX-CURSOR                                           
P00633     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00633                                                                  
P00633     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00633                                                                  
P00633     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00633         NEXT SENTENCE                                            
P00633     ELSE                                                         
P00633         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
P00633         MOVE '7280'                 TO ACTIVE-PARAGRAPH          
P00633         MOVE 'OPEN'                 TO ABEND-FUNCTION            
P00633         MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
P00633         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
P00633         MOVE 'CSS_NAME'             TO TABLE-3                   
P00633         MOVE 'PHONE_NO'             TO TABLE-ELEMENT-1           
P00633         MOVE PHONE-NUMBER           TO HOSTVAR-ELEMENT-1         
P00633         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00633         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
P00633                                                                  
P00633 7280-EXIT.                                                       
P00633     EXIT.                                                        
P00633                                                                  
P00633 7285-FETCH-PHX-CURSOR.                                           
P00633                                                                  
P00633     EXEC SQL                                                     
P00633        FETCH PHX-CURSOR                                          
P00633         INTO :HT-CUSTOMER-NO,                                    
P00633              :HT-ACCOUNT-NO,                                     
P00633              :HT-PREMISE-NO,                                     
P00633              :HT-ADDRESS-ID,                                     
P00633              :HT-NAME-ID,                                        
P00633              :HT-CUSTOMER-ROLE-CD,                               
P00633              :HT-COMPANY-NO                                      
P00633     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00633                                                                  
P00633     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00633                                                                  
P00633     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
P00633         NEXT SENTENCE                                            
P00633     ELSE                                                         
P00633         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
P00633         MOVE '7285'                 TO ACTIVE-PARAGRAPH          
P00633         MOVE 'FETCH'                TO ABEND-FUNCTION            
P00633         MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
P00633         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
P00633         MOVE 'CSS_NAME'             TO TABLE-3                   
P00633         MOVE 'PHONE_NO'             TO TABLE-ELEMENT-1           
P00633         MOVE PHONE-NUMBER           TO HOSTVAR-ELEMENT-1         
P00633         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00633         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
P00633                                                                  
P00633 7285-EXIT.                                                       
P00633     EXIT.                                                        
P00633                                                                  
P00633 7290-CLOSE-PHX-CURSOR.                                           
P00633                                                                  
P00633     EXEC SQL                                                     
P00633        CLOSE PHX-CURSOR                                          
P00633     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00633                                                                  
P00633     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00633                                                                  
P00633     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00633         NEXT SENTENCE                                            
P00633     ELSE                                                         
P00633         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
P00633         MOVE '7290'                 TO ACTIVE-PARAGRAPH          
P00633         MOVE 'CLOSE'                TO ABEND-FUNCTION            
P00633         MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
P00633         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
P00633         MOVE 'CSS_NAME'             TO TABLE-3                   
P00633         MOVE 'PHONE_NO'             TO TABLE-ELEMENT-1           
P00633         MOVE PHONE-NUMBER           TO HOSTVAR-ELEMENT-1         
P00633         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00633         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
P00633                                                                  
P00633 7290-EXIT.                                                       
P00633     EXIT.                                                        
                                                                        
       7300-CUST-STATS.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PASSWORD_TX                                       
                INTO :CE-PASSWORD-TX                                    
                FROM CSS_CUST_STATS                                     
               WHERE CUSTOMER_NO = :HT-CUSTOMER-NO                      
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PASSWORD_TX                                               
MFA-TR*         INTO :CE-PASSWORD-TX                                            
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO = :HT-CUSTOMER-NO                              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACE TO CE-PASSWORD-TX                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7300'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_CUST_STATS'       TO TABLE-1               
                   MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1       
                   MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7350-CUST-MISC-INFO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT KEY_CUSTOMER                                      
                INTO :LQ-KEY-CUSTOMER                                   
                FROM CSS_CUST_MISC_INFO                                 
               WHERE CUSTOMER_NO = :HT-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KEY_CUSTOMER                                              
MFA-TR*         INTO :LQ-KEY-CUSTOMER                                           
MFA-TR*         FROM CSS_CUST_MISC_INFO                                         
MFA-TR*        WHERE CUSTOMER_NO = :HT-CUSTOMER-NO                              
MFA-TR*         QUERYNO 7350                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACE TO LQ-KEY-CUSTOMER                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7350'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_CUST_MISC_INFO'   TO TABLE-1               
                   MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1       
                   MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-OFF-CYCLE.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CODE_BILL_OFF_CYCL                                
                INTO :OC-CODE-BILL-OFF-CYCL                             
                FROM CSS_OFF_CYCL_ACCT                                  
               WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                 AND CODE_BILL_OFF_CYCL = 'B'                           
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_BILL_OFF_CYCL                                        
MFA-TR*         INTO :OC-CODE-BILL-OFF-CYCL                                     
MFA-TR*         FROM CSS_OFF_CYCL_ACCT                                          
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*          AND CODE_BILL_OFF_CYCL = 'B'                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ' ' TO OC-CODE-BILL-OFF-CYCL                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7400'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_OFF_CYCL_ACCT'    TO TABLE-1               
                   MOVE 'ACCOUNT_NO '          TO TABLE-ELEMENT-1       
                   MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00633 7450-ACCOUNT-ID.                                                 
P00633                                                                  
P00633     EXEC SQL                                                     
P00633         SELECT TOP(1) SPCL_BILL_STMNT_TX                                
P00633          INTO :TA-SPCL-BILL-STMNT-TX                             
P00633          FROM CSS_ACCT_MISC_INFO                                 
P00633         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
P00633                                           
P00633                                                      
P00633     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SPCL_BILL_STMNT_TX                                        
MFA-TR*         INTO :TA-SPCL-BILL-STMNT-TX                                     
MFA-TR*         FROM CSS_ACCT_MISC_INFO                                         
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7450                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00633                                                                  
P00633     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00633                                                                  
P00633     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00633         WHEN SUCCESSFUL-CALL                                     
P00633             CONTINUE                                             
P00633         WHEN NOT-FOUND                                           
P00633             MOVE ' ' TO TA-SPCL-BILL-STMNT-TX                    
P00633         WHEN OTHER                                               
P00633             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00633             MOVE '7450'                 TO ACTIVE-PARAGRAPH      
P00633             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00633             MOVE 'CSS_ACCT_MISC_INFO'   TO TABLE-1               
P00633             MOVE 'ACCOUNT_NO '          TO TABLE-ELEMENT-1       
P00633             MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00633             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00633             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
P00633                                                                  
P00633 7450-EXIT.                                                       
P00633     EXIT.                                                        
                                                                        
       7500-ENDV.                                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                INTO :VO-SERV-ORDER-NO                                  
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :HT-PREMISE-NO                        
                 AND ORDER_STATE_CD IN ('A', 'H')                       
P00253                 AND ORDER_TYPE_CD IN ('FW019', 'FW016')          
                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*         INTO :VO-SERV-ORDER-NO                                          
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO = :HT-PREMISE-NO                                
MFA-TR*          AND ORDER_STATE_CD IN ('A', 'H')                               
MFA-TR*                AND ORDER_TYPE_CD IN ('FW019', 'FW016')                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY WITH UR                                 
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0 TO VO-SERV-ORDER-NO                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7500'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_SO_DATA'          TO TABLE-1               
                   MOVE 'PREMISE_NO '          TO TABLE-ELEMENT-1       
                   MOVE HT-PREMISE-NO          TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-RECONNECT.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                INTO :VO-SERV-ORDER-NO                                  
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO_PRIOR = :HT-ACCOUNT-NO                  
                 AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D')             
                 AND ORDER_TYPE_CD = 'FM006'                            
                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*         INTO :VO-SERV-ORDER-NO                                          
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE ACCOUNT_NO_PRIOR = :HT-ACCOUNT-NO                          
MFA-TR*          AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D')                     
MFA-TR*          AND ORDER_TYPE_CD = 'FM006'                                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY WITH UR                                 
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'F' TO WS-DNP-FLAG                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-DNP-FLAG                              
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7600'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_SO_DATA'          TO TABLE-1               
                   MOVE 'ACCOUNT_NO_PRIOR'     TO TABLE-ELEMENT-1       
                   MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-DNP.                                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                INTO :VO-SERV-ORDER-NO                                  
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :HT-PREMISE-NO                        
                 AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D')             
                 AND ORDER_TYPE_CD = 'DNP01'                            
                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*         INTO :VO-SERV-ORDER-NO                                          
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO = :HT-PREMISE-NO                                
MFA-TR*          AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D')                     
MFA-TR*          AND ORDER_TYPE_CD = 'DNP01'                                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY WITH UR                                 
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-DNP-FLAG                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-DNP-FLAG                              
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7700'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_SO_DATA'          TO TABLE-1               
                   MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1       
                   MOVE HT-PREMISE-NO          TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7915-GET-ACCOUNT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_TYPE_CODE,
              LOCAL_OFFICE,
              BANKRUPTCY_IND,
              ADDRESS_ID,
              CUSTOMER_NO,
              PREMISE_NO,
              JUDGEMENT_IND,
              CODE_ACCT_STAT,
              MST_SUB_ACCT_IND,
              CODE_CRIT_OUTAGE                                  
                INTO :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-LOCAL-OFFICE,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-ADDRESS-ID,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-JUDGEMENT-IND,                                 
                     :AT-CODE-ACCT-STAT,                                
                     :AT-MST-SUB-ACCT-IND,                              
P00455               :AT-CODE-CRIT-OUTAGE                               
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_TYPE_CODE,                                        
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               BANKRUPTCY_IND,                                           
MFA-TR*               ADDRESS_ID,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               JUDGEMENT_IND,                                            
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               MST_SUB_ACCT_IND,                                         
MFA-TR*               CODE_CRIT_OUTAGE                                          
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-LOCAL-OFFICE,                                          
MFA-TR*              :AT-BANKRUPTCY-IND,                                        
MFA-TR*              :AT-ADDRESS-ID,                                            
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-JUDGEMENT-IND,                                         
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-MST-SUB-ACCT-IND,                                      
MFA-TR*              :AT-CODE-CRIT-OUTAGE                                       
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7915                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF HT-ADDRESS-ID = ZERO                              
                       MOVE AT-ADDRESS-ID TO HT-ADDRESS-ID              
                   END-IF                                               
                   IF HT-PREMISE-NO = ZERO                              
                       MOVE AT-PREMISE-NO TO HT-PREMISE-NO              
                   END-IF                                               
                   IF HT-CUSTOMER-NO = ZERO                             
                       MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO            
                   END-IF                                               
               WHEN NOT-FOUND                                           
A37666             PERFORM 7916-ARCHIVE-ACCT THRU 7916-EXIT             
                   MOVE SPACE TO AT-ACCOUNT-TYPE-CODE                   
                                 AT-LOCAL-OFFICE                        
                                 AT-BANKRUPTCY-IND                      
A37666                           AT-MST-SUB-ACCT-IND                    
A37666                           AT-JUDGEMENT-IND                       
A37666                           AT-CODE-ACCT-STAT                      
P00455                           AT-CODE-CRIT-OUTAGE                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7915'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ACCOUNT'          TO TABLE-1               
                   MOVE 'CSS_ACCOUNT_TYPE'     TO TABLE-2               
                   MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
                   MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7915-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7916-ARCHIVE-ACCT.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                INTO :HA-ACCOUNT-NO                                     
                FROM HST_ACCOUNT                                        
               WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*         INTO :HA-ACCOUNT-NO                                             
MFA-TR*         FROM HST_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7916                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ARCHIVE-FL                            
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ARCHIVE-FL                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7916'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'HST_ACCOUNT'          TO TABLE-1               
                   MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
                   MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7916-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7917-SUPPLIED-AVAILABLE.                                         
                                                                        
           MOVE 'Y' TO WS-SERVICES-SET.                                 
           PERFORM 7917E-SUPPLIED-AVAILABLE THRU 7917E-EXIT.            
           PERFORM 7917G-SUPPLIED-AVAILABLE THRU 7917G-EXIT.            
           PERFORM 7917L-SUPPLIED-AVAILABLE THRU 7917L-EXIT.            
                                                                        
       7917-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7917E-SUPPLIED-AVAILABLE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                  AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')    
                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        QUERYNO 79171                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'E' TO RS-SERV-AVAIL (2)                        
P00455                         RS-SERV-SUPPLIED (2)                     
                   GO TO 7917E-EXIT                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917E'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        QUERYNO 79172                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'E' TO RS-SERV-AVAIL (2)                        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917E'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7917E-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7917G-SUPPLIED-AVAILABLE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                  AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')    
                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        QUERYNO 79173                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'G' TO RS-SERV-AVAIL (1)                        
P00455                         RS-SERV-SUPPLIED (1)                     
                   GO TO 7917G-EXIT                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917G'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        QUERYNO 79174                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'G' TO RS-SERV-AVAIL (1)                        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917G'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7917G-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7917L-SUPPLIED-AVAILABLE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_CUST_PLAN                                     
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'U'                              
                  AND CODE_PLAN_STATUS = 'A'                            
                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_CUST_PLAN                                             
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'U'                                      
MFA-TR*           AND CODE_PLAN_STATUS = 'A'                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        QUERYNO 79175                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'L' TO RS-SERV-AVAIL    (3)                     
P00455                         RS-SERV-SUPPLIED (3)                     
                   GO TO 7917L-EXIT                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917L'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_CUST_PLAN'    TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_CUST_PLAN                                     
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'U'                              
                  AND CODE_PLAN_STATUS = 'I'                            
                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_CUST_PLAN                                             
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'U'                                      
MFA-TR*           AND CODE_PLAN_STATUS = 'I'                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        QUERYNO 79176                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'L' TO RS-SERV-AVAIL (3)                        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917L'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7917L-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7920-GET-ADDRESS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              ADDRESS_OVERFLOW,
              ADDR_USAGE_CD,
              STREET_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              ZIP_CODE,
              ZIP_CODE_TOKEN,
              ADDR_SUFFIX                                       
               INTO   :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ADDR-USAGE-CD,                                
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-SUFFIX                                   
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :HT-ADDRESS-ID                       
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               ADDR_SUFFIX                                               
MFA-TR*        INTO   :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DY-ADDR-USAGE-CD,                                        
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-TOKEN,                                       
MFA-TR*               :DY-ADDR-SUFFIX                                           
MFA-TR*          FROM CSS_ADDR_FORMATTED                                        
MFA-TR*         WHERE ADDRESS_ID = :HT-ADDRESS-ID                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*        QUERYNO 7920                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7920'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'ADDRESS_ID'           TO TABLE-ELEMENT-1           
               MOVE HT-ADDRESS-ID          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7925-GET-CITY.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TOWN                                              
                 INTO :A4-TOWN                                          
                 FROM CSS_ZIP_CODE                                      
                WHERE ZIP_CODE       = :DY-ZIP-CODE                     
                  AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TOWN                                                      
MFA-TR*          INTO :A4-TOWN                                                  
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE ZIP_CODE       = :DY-ZIP-CODE                             
MFA-TR*           AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*        QUERYNO 7925                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACE TO A4-TOWN                                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7925'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ZIP_CODE'         TO TABLE-1               
                   MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1       
                   MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2       
                   MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1     
                   MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7925-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7930-GET-NAME.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) NAME_TYPE,
              NAME_FORMAT,
              LAST_NAME,
              FIRST_NAME,
              MIDDLE_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              TITLE_SUFFIX_2,
              FULL_NAME                                         
                INTO :DQ-NAME-TYPE,                                     
                     :DQ-NAME-FORMAT,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-TITLE-PREFIX  ,                                
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :DQ-FULL-NAME                                      
                 FROM CSS_NAME                                          
                WHERE NAME_ID      = :HT-NAME-ID                        
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NAME_TYPE,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               TITLE_PREFIX,                                             
MFA-TR*               TITLE_SUFFIX_1,                                           
MFA-TR*               TITLE_SUFFIX_2,                                           
MFA-TR*               FULL_NAME                                                 
MFA-TR*         INTO :DQ-NAME-TYPE,                                             
MFA-TR*              :DQ-NAME-FORMAT,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-TITLE-PREFIX  ,                                        
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                        
MFA-TR*              :DQ-TITLE-SUFFIX-2,                                        
MFA-TR*              :DQ-FULL-NAME                                              
MFA-TR*          FROM CSS_NAME                                                  
MFA-TR*         WHERE NAME_ID      = :HT-NAME-ID                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*        QUERYNO 7930                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
PRDFIX              INSPECT DQ-MIDDLE-NAME                              
PRDFIX                  REPLACING ALL LOW-VALUES BY SPACES              
PRDFIX              INSPECT DQ-TITLE-PREFIX                             
PRDFIX                  REPLACING ALL LOW-VALUES BY SPACES              
PRDFIX              INSPECT DQ-TITLE-SUFFIX-1                           
PRDFIX                  REPLACING ALL LOW-VALUES BY SPACES              
PRDFIX              INSPECT DQ-TITLE-SUFFIX-2                           
PRDFIX                  REPLACING ALL LOW-VALUES BY SPACES              
               WHEN NOT-FOUND                                           
                   MOVE SPACE TO DQ-NAME-TYPE                           
                                 DQ-NAME-FORMAT                         
                                 DQ-LAST-NAME                           
                                 DQ-FIRST-NAME                          
                                 DQ-MIDDLE-NAME                         
                                 DQ-TITLE-PREFIX                        
                                 DQ-TITLE-SUFFIX-1                      
                                 DQ-TITLE-SUFFIX-2                      
                                 DQ-FULL-NAME                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7930'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_NAME'             TO TABLE-1               
                   MOVE 'NAME_ID'              TO TABLE-ELEMENT-1       
                   MOVE HT-NAME-ID             TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7930-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7940-GET-PREMISE-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) GAS_AVAILABLE_IND,
              ELEC_AVAILABLE_IND,
              LITE_AVAILABLE_IND,
              WTR_AVAILABLE_IND,
              SWR_AVAILABLE_IND,
              LOCAL_OFFICE                                      
                INTO :PR-GAS-AVAILABLE-IND,                             
                     :PR-ELEC-AVAILABLE-IND,                            
                     :PR-LITE-AVAILABLE-IND,                            
                     :PR-WTR-AVAILABLE-IND,                             
                     :PR-SWR-AVAILABLE-IND,                             
                     :AT-LOCAL-OFFICE                                   
                FROM CSS_PREMISE PR                                     
               WHERE PREMISE_NO = :HT-PREMISE-NO                        
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GAS_AVAILABLE_IND,                                        
MFA-TR*               ELEC_AVAILABLE_IND,                                       
MFA-TR*               LITE_AVAILABLE_IND,                                       
MFA-TR*               WTR_AVAILABLE_IND,                                        
MFA-TR*               SWR_AVAILABLE_IND,                                        
MFA-TR*               LOCAL_OFFICE                                              
MFA-TR*         INTO :PR-GAS-AVAILABLE-IND,                                     
MFA-TR*              :PR-ELEC-AVAILABLE-IND,                                    
MFA-TR*              :PR-LITE-AVAILABLE-IND,                                    
MFA-TR*              :PR-WTR-AVAILABLE-IND,                                     
MFA-TR*              :PR-SWR-AVAILABLE-IND,                                     
MFA-TR*              :AT-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_PREMISE PR                                             
MFA-TR*        WHERE PREMISE_NO = :HT-PREMISE-NO                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*        QUERYNO 7940                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7940'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_PREMISE'          TO TABLE-1                   
               MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-PREMISE-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7942-UTILITY-SOURCE.                                             
                                                                        
           EXEC SQL                                                     
                SELECT MAX(UTILITY_SOURCE_CD)                           
                  INTO :WS-UTILITY-SOURCE-CD :WS-UTIL-SRC-CD-NULL-IND    
                  FROM CSS_MTRD_ENVRNMT                                 
                 WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                      
                   AND CODE_UTIL_TYPE = 'E'                             
                   AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')   
                 GROUP BY ACCOUNT_NO                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MAX(UTILITY_SOURCE_CD)                                   
MFA-TR*           INTO :WS-UTILITY-SOURCE-CD:WS-UTIL-SRC-CD-NULL-IND            
MFA-TR*           FROM CSS_MTRD_ENVRNMT                                         
MFA-TR*          WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                              
MFA-TR*            AND CODE_UTIL_TYPE = 'E'                                     
MFA-TR*            AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')           
MFA-TR*          GROUP BY ACCOUNT_NO                                            
MFA-TR*          QUERYNO 7942                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-UTIL-SRC-CD-NULL-IND < 0                           
                   MOVE SPACES TO WS-UTILITY-SOURCE-CD                  
               END-IF                                                   
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7942'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
                END-IF
           END-IF.           
                                                                        
       7942-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7943-POINT-ID.                                                   
                                                                        
           MOVE 'N' TO WS-POINT-ID-FL.                                  
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-POINT-ID-FL                                  
                  FROM CSS_MTRD_ENVRNMT                                 
                 WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                      
                   AND CODE_UTIL_TYPE = 'E'                             
                   AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')   
                   AND GIS_POINT_ID > 0                                 
                                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-POINT-ID-FL                                          
MFA-TR*           FROM CSS_MTRD_ENVRNMT                                         
MFA-TR*          WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                              
MFA-TR*            AND CODE_UTIL_TYPE = 'E'                                     
MFA-TR*            AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')           
MFA-TR*            AND GIS_POINT_ID > 0                                         
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*          QUERYNO 7943                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7943'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7943-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7944-CHECK-IF-INDUSTRIAL.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) UT.RATE_PLAN_NO,
              UT.CODE_REVENUE_CLASS                              
                INTO :UT-RATE-PLAN-NO                                   
                    ,:UT-CODE-REVENUE-CLASS                             
                FROM CSS_UTIL_ENVRNMT UT                                
                    ,CSS_MTRD_ENVRNMT MN                                
               WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                     
                 AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                      
                 AND MN.IC_NO = UT.IC_NO                                
                 AND UT.CODE_UTIL_TYPE = 'E'                            
                 AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE              
                 AND MN.CODE_METER_STATUS = 'A'                         
                 AND UT.RATE_PLAN_NO IN                                 
                             ('024', '027', '060', '065', '066')        
                                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RATE_PLAN_NO                                            
MFA-TR*             ,UT.CODE_REVENUE_CLASS                                      
MFA-TR*         INTO :UT-RATE-PLAN-NO                                           
MFA-TR*             ,:UT-CODE-REVENUE-CLASS                                     
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                             
MFA-TR*          AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                              
MFA-TR*          AND MN.IC_NO = UT.IC_NO                                        
MFA-TR*          AND UT.CODE_UTIL_TYPE = 'E'                                    
MFA-TR*          AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE                      
MFA-TR*          AND MN.CODE_METER_STATUS = 'A'                                 
MFA-TR*          AND UT.RATE_PLAN_NO IN                                         
MFA-TR*                      ('024', '027', '060', '065', '066')                
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*      QUERYNO 7944                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  CONTINUE                                              
              WHEN NOT-FOUND                                            
                  MOVE SPACES TO UT-RATE-PLAN-NO                        
                  MOVE SPACES TO UT-CODE-REVENUE-CLASS                  
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
                  MOVE '7944'                 TO ACTIVE-PARAGRAPH       
                  MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                
                  MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1        
                  MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1      
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
            END-EVALUATE.                                               
       7944-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7945-GET-ELEC-RATE.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RATE_PLAN_NO,
              CODE_REVENUE_CLASS                                
                 INTO :UT-RATE-PLAN-NO                                  
                     ,:UT-CODE-REVENUE-CLASS                            
                 FROM CSS_UTIL_ENVRNMT UT                               
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND UT.CODE_UTIL_TYPE = 'E'                           
                  AND UT.RATE_PLAN_NO NOT IN ('013','029','069','079',  
                                           '68A','68B','69A','69B',     
                                           '69C','69D','A68','A69',     
                                           'B68','B69','C69','D69')     
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RATE_PLAN_NO                                              
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*          INTO :UT-RATE-PLAN-NO                                          
MFA-TR*              ,:UT-CODE-REVENUE-CLASS                                    
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND UT.CODE_UTIL_TYPE = 'E'                                   
MFA-TR*           AND UT.RATE_PLAN_NO NOT IN ('013','029','069','079',          
MFA-TR*                                    '68A','68B','69A','69B',             
MFA-TR*                                    '69C','69D','A68','A69',             
MFA-TR*                                    'B68','B69','C69','D69')             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7945                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  CONTINUE                                              
              WHEN NOT-FOUND                                            
                  MOVE SPACES TO UT-RATE-PLAN-NO                        
                  MOVE SPACES TO UT-CODE-REVENUE-CLASS                  
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
                  MOVE '7945'                 TO ACTIVE-PARAGRAPH       
                  MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                
                  MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1        
                  MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1      
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
            END-EVALUATE.                                               
       7945-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
            EXEC SQL                                                    
                 INSERT INTO #CSR03945_R1                        
                 (    RETURN_CODE                                       
                     ,ADDRESS                                           
                     ,NAME                                              
                     ,CITY                                              
                     ,ACCT_TYPE                                         
                     ,ACCOUNT_NO                                        
                     ,SERVICE_AVAIL                                     
                     ,CUSTOMER_NO                                       
                     ,LOCAL_OFFICE                                      
                     ,PREMISE_NO                                        
                     ,ZIP_CODE                                          
                     ,COMPANY_NO                                        
                     ,PASSWORD                                          
                     ,ENDV                                              
                     ,DNP                                               
                     ,BANKRUPTCY_IND                                    
                     ,CONSOLIDATE_BILL                                  
                     ,PENDING_FINAL                                     
P00455               ,POINT_ID_FL                                       
P00455               ,UTILITY_SOURCE_CD                                 
P00455               ,SERVICE_SUPPLIED                                  
P00455               ,CODE_ACCT_STAT                                    
P00455               ,CODE_CRIT_OUTAGE                                  
P00455               ,KEY_CUSTOMER                                      
P00455               ,RATE_PLAN_NO                                      
P00455               ,CODE_REVENUE_CLASS                                
P00633               ,ACCOUNT_ID)                                       
                 VALUES                                                 
                 (    :S-RETURN-CODE                                    
                     ,:S-ADDRESS                                        
                     ,:S-NAME                                           
                     ,:S-CITY                                           
                     ,:S-ACCT-TYPE                                      
                     ,:S-ACCOUNT-NO                                     
                     ,:S-SERVICE-AVAIL                                  
                     ,:S-CUSTOMER-NO                                    
                     ,:S-LOCAL-OFFICE                                   
                     ,:S-PREMISE-NO                                     
                     ,:S-ZIP-CODE                                       
                     ,:S-COMPANY-NO                                     
                     ,:S-PASSWORD                                       
                     ,:S-ENDV                                           
                     ,:S-DNP                                            
                     ,:S-BANKRUPTCY-IND                                 
                     ,:S-CONSOLIDATE-BILL                               
                     ,:S-PENDING-FINAL                                  
P00455               ,:S-POINT-ID-FL                                    
P00455               ,:S-UTILITY-SOURCE-CD                              
P00455               ,:S-SERVICE-SUPPLIED                               
P00455               ,:S-CODE-ACCT-STAT                                 
P00455               ,:S-CODE-CRIT-OUTAGE                               
P00455               ,:S-KEY-CUSTOMER                                   
P00455               ,:S-RATE-PLAN-NO                                   
P00455               ,:S-CODE-REVENUE-CLASS                             
P00633               ,:S-ACCOUNT-ID)                                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR03945_R1                                
MFA-TR*          (    RETURN_CODE                                               
MFA-TR*              ,ADDRESS                                                   
MFA-TR*              ,NAME                                                      
MFA-TR*              ,CITY                                                      
MFA-TR*              ,ACCT_TYPE                                                 
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,SERVICE_AVAIL                                             
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,PASSWORD                                                  
MFA-TR*              ,ENDV                                                      
MFA-TR*              ,DNP                                                       
MFA-TR*              ,BANKRUPTCY_IND                                            
MFA-TR*              ,CONSOLIDATE_BILL                                          
MFA-TR*              ,PENDING_FINAL                                             
MFA-TR*              ,POINT_ID_FL                                               
MFA-TR*              ,UTILITY_SOURCE_CD                                         
MFA-TR*              ,SERVICE_SUPPLIED                                          
MFA-TR*              ,CODE_ACCT_STAT                                            
MFA-TR*              ,CODE_CRIT_OUTAGE                                          
MFA-TR*              ,KEY_CUSTOMER                                              
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*              ,ACCOUNT_ID)                                               
MFA-TR*          VALUES                                                         
MFA-TR*          (    :S-RETURN-CODE                                            
MFA-TR*              ,:S-ADDRESS                                                
MFA-TR*              ,:S-NAME                                                   
MFA-TR*              ,:S-CITY                                                   
MFA-TR*              ,:S-ACCT-TYPE                                              
MFA-TR*              ,:S-ACCOUNT-NO                                             
MFA-TR*              ,:S-SERVICE-AVAIL                                          
MFA-TR*              ,:S-CUSTOMER-NO                                            
MFA-TR*              ,:S-LOCAL-OFFICE                                           
MFA-TR*              ,:S-PREMISE-NO                                             
MFA-TR*              ,:S-ZIP-CODE                                               
MFA-TR*              ,:S-COMPANY-NO                                             
MFA-TR*              ,:S-PASSWORD                                               
MFA-TR*              ,:S-ENDV                                                   
MFA-TR*              ,:S-DNP                                                    
MFA-TR*              ,:S-BANKRUPTCY-IND                                         
MFA-TR*              ,:S-CONSOLIDATE-BILL                                       
MFA-TR*              ,:S-PENDING-FINAL                                          
MFA-TR*              ,:S-POINT-ID-FL                                            
MFA-TR*              ,:S-UTILITY-SOURCE-CD                                      
MFA-TR*              ,:S-SERVICE-SUPPLIED                                       
MFA-TR*              ,:S-CODE-ACCT-STAT                                         
MFA-TR*              ,:S-CODE-CRIT-OUTAGE                                       
MFA-TR*              ,:S-KEY-CUSTOMER                                           
MFA-TR*              ,:S-RATE-PLAN-NO                                           
MFA-TR*              ,:S-CODE-REVENUE-CLASS                                     
MFA-TR*              ,:S-ACCOUNT-ID)                                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                ADD +1                    TO  CTR-ROWS                  
            ELSE                                                        
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE '8100'               TO  ACTIVE-PARAGRAPH          
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR03945_R1'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
            END-IF.         
                                                                        
        8100-EXIT.                                                      
            EXIT.                                                       
                                                                        
        8200-INSERT-ACCESS-HISTORY.                                     
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCESS_HISTORY (                          
                     CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     ACCESS_TIMESTAMP,                                  
                     ACCESS_STATUS,                                     
                     USERID                                             
                     )                                                  
              VALUES (                                                  
                     :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS),                        
                     'D',                                               
                     :PARM-USERID                                       
                     )                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCESS_HISTORY (                                  
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              ACCESS_TIMESTAMP,                                          
MFA-TR*              ACCESS_STATUS,                                             
MFA-TR*              USERID                                                     
MFA-TR*              )                                                          
MFA-TR*       VALUES (                                                          
MFA-TR*              :HT-CUSTOMER-NO,                                           
MFA-TR*              :HT-ACCOUNT-NO,                                            
MFA-TR*              :WS-CURRENT-TS,                                            
MFA-TR*              'D',                                                       
MFA-TR*              :PARM-USERID                                               
MFA-TR*              )                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '8200'                 TO ACTIVE-PARAGRAPH          
               MOVE 'INSERT'               TO ABEND-FUNCTION            
               MOVE 'CSS_ACCESS_HISTORY'   TO TABLE-1                   
               MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
               MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
        8200-EXIT.                                                      
            EXIT.                                                       
                                                                        
P00455     EXEC SQL                                                             
P00455        INCLUDE CPDSP300                                                  
P00455     END-EXEC.                                                            
                                                                        
                                                                        
P00455     EXEC SQL                                                             
P00455        INCLUDE CPD00320                                                  
P00455     END-EXEC.                                                            
                                                                        
