       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03934.                                         
COB303 DATE-WRITTEN.      APRIL 18, 2007.                               
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED A STORED PROCEDURE CALL (DB2).       *00100000
      *                                                                *00110000
      *  PROGRAM: CSR03934                                             *00130000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  GETS SERVICE ORDER MATERIAL DATA FROM WMS_SO_MATL_TRAN AND    *00200000
      *  INSERTS INTO WMS_SO_MATL_PROCESS FOR PEOPLESOFT MATERIAL      *00220000
      *  TRANSACTION CREATION.                                         *        
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  04/18/07    RR       SP ORIGINALLY ADDED.                     *00290000
      *  01/25/08    SC       FIX FOR PROPER ERROR-HANDLING(CML-36707) *        
C37340*  06/05/08    FMB      ADD ALTERNATE UOM CALCULATION            *        
T37261*  06/09/08   MR97640   RENAMING DCLGEN'S FROM STB TO TB         *        
T37261*                       AND ADDED WITH UR TO AVOID -911 ABENDS.  *        
      ******************************************************************00560000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03934'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03934 STARTS HERE'.                  
                                                                        
      ******************************************************************00650000
      *    DB2 INCLUDES                                                *00660000
      ******************************************************************00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBSODAT                                           00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBSOPROC                                          00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBWMSTRN                                          00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBWKMATL                                          00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
T37261        INCLUDE TBWKAR                                            00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBPREM                                            00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBRVDST                                           00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBDELQ                                            00700000
           END-EXEC.                                                    00710000
                                                                        
      *DB2 AND CICS ERROR PROCESSING                                            
           COPY CWS00303.                                               01520000
                                                                        
      *ABEND WORK AREA                                                          
           EXEC SQL                                                     01570000
               INCLUDE CWSX0010                                         01570000
           END-EXEC.                                                    01570000
                                                                        
      *ABEND WORK AREA                                                          
           EXEC SQL                                                     01570000
               INCLUDE CWSSP001                                         01570000
           END-EXEC.                                                    01570000
                                                                        
      *01  COUNTER-FIELDS.                                              02490000
      *    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          02500000
      *    05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          02510000
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME               PIC X(26)                        
                                        VALUE 'SESSION.CSR03934_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN         PIC S9(04) COMP.                 
                49 GTT-ROW-CHAR        PIC X(1024).                     
            05  GTT-SQLCODE            PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE +0.        
           05  S-COST-CENTER           PIC X(03) VALUE SPACES.          
           05  S-RESOURCE-CD           PIC X(03) VALUE SPACES.          
           05  S-FUNC-ACT-CD           PIC X(06) VALUE SPACES.          
           05  S-GL-ACCT-NM            PIC S9(03)V9999 COMP-3 VALUE 0.  
           05  S-WORK-ORDER-NM         PIC X(06) VALUE SPACES.          
           05  S-CUSTOMER-CD           PIC X(03) VALUE SPACES.          
           05  S-SERVICE-CD            PIC X(03) VALUE SPACES.          
           05  S-EVENT-CD              PIC X(03) VALUE SPACES.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) COMP VALUE +0.        
           05  RS-COST-CENTER          PIC X(03) VALUE SPACES.          
           05  RS-RESOURCE-CD          PIC X(03) VALUE SPACES.          
           05  RS-FUNC-ACT-CD          PIC X(06) VALUE SPACES.          
           05  RS-GL-ACCT-NM           PIC S9(03)V9999 COMP-3 VALUE 0.  
           05  RS-WORK-ORDER-NM        PIC X(06) VALUE SPACES.          
           05  RS-CUSTOMER-CD          PIC X(03) VALUE SPACES.          
           05  RS-SERVICE-CD           PIC X(03) VALUE SPACES.          
           05  RS-EVENT-CD             PIC X(03) VALUE SPACES.          
                                                                        
      *01  CSRERLOG-P.                                                          
      *    10  S-SP-NAME               PIC X(18)      VALUE SPACES.             
      *    10  S-SQLCODE               PIC S9(9) COMP VALUE 0.                  
      *    10  S-SQLSTATE              PIC X(5)       VALUE ' '.                
      *    10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.             
      *    10  S-HOST-VARIABLES.                                                
      **       49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.                    
      *        49  S-HOST-VARIABLES-V  PIC X(255).                              
      *    10  S-SQL-STATEMENT.                                                 
      *        49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.                    
      *        49  S-SQL-STATEMENT-V   PIC X(255).                              
      *    10  S-SQL-DESCRIPTION.                                               
      *        49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.                    
      *        49  S-SQL-DESCRIPTION-V PIC X(255).                              
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-SRNBR                PIC 9(03) VALUE 0.               
           05  WS-SRNBR-CHAR           REDEFINES WS-SRNBR               
                                       PIC X(03).                       
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03934'.      
           05  WS-SQLSTATE             PIC X(05)   VALUE SPACES.        
           05  WS-NULL-IND             PIC S9(04) COMP VALUE ZEROS.     
           05  WS-NULL-IND1            PIC S9(04) COMP VALUE ZEROS.     
           05  WS-NULL-IND2            PIC S9(04) COMP VALUE ZEROS.     
           05  WS-NULL-IND3            PIC S9(04) COMP VALUE ZEROS.     
      *                                                                         
           EXEC SQL                                                     
               DECLARE UDAK-CURSOR CURSOR FOR                           
                   SELECT DISTINCT TN.COST_CENTER,                      
                                   TN.RESOURCE_CD,                      
                                   TN.FUNC_ACT_CD,                      
                                   TN.GL_ACCT_NM,                       
                                   TN.WORK_ORDER_NM,                    
                                   TN.CUSTOMER_CD,                      
                                   TN.SERVICE_CD,                       
                                   TN.EVENT_CD                          
                              FROM CSS_SOMATL_PROCESS TN
                           WITH(READUNCOMMITTED)                
                             WHERE PROCESSED_DT IS NULL                 
                               AND COMPANY_NO = '01'                    
                               AND GL_PROCESSED_DT IS NULL              
                   FOR READ ONLY                                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UDAK-CURSOR CURSOR FOR                                   
MFA-TR*            SELECT DISTINCT TN.COST_CENTER,                              
MFA-TR*                            TN.RESOURCE_CD,                              
MFA-TR*                            TN.FUNC_ACT_CD,                              
MFA-TR*                            TN.GL_ACCT_NM,                               
MFA-TR*                            TN.WORK_ORDER_NM,                            
MFA-TR*                            TN.CUSTOMER_CD,                              
MFA-TR*                            TN.SERVICE_CD,                               
MFA-TR*                            TN.EVENT_CD                                  
MFA-TR*                       FROM CSS_SOMATL_PROCESS TN                        
MFA-TR*                      WHERE PROCESSED_DT IS NULL                         
MFA-TR*                        AND COMPANY_NO = '01'                            
MFA-TR*                        AND GL_PROCESSED_DT IS NULL                      
MFA-TR*            FOR FETCH ONLY                                               
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************04640000
      * 0000-MAINLINE                                                  *04650000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04660000
      ******************************************************************04670000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
      *    PERFORM 7600-COMMIT         THRU 7600-EXIT.                          
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04790000
      * 0100-INITIALIZE                                                *04800000
      *                                                                *04810000
      *     1. RESET DB2 ERROR HANDLERS                                *04820000
      *     2. DECLARE CURSOR FOR RESULT SET                           *04850000
      *                                                                *04860000
      ******************************************************************04870000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   RETURN_CODE             AS RETURN_CD,                
                   LTRIM(RTRIM(COST_CENTER))      AS COST_CENTER,              
                   LTRIM(RTRIM(RESOURCE_CODE))    AS RESOURCE_CODE,            
                   LTRIM(RTRIM(FUNC_ACT_CD))      AS FUNC_ACT_CD,              
                   GL_ACCT_NM              AS GL_ACCT_NM,               
                   LTRIM(RTRIM(WORK_ORDER_NM))    AS WORK_ORDER_NM,            
                   LTRIM(RTRIM(CUSTOMER_CD))      AS CUSTOMER_CD,              
                   LTRIM(RTRIM(SERVICE_CD))       AS SERVICE_CD,               
                   LTRIM(RTRIM(EVENT_CD))         AS EVENT_CD                  
               FROM                                                     
                   #CSR03934_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE             AS RETURN_CD,                        
MFA-TR*            STRIP(COST_CENTER)      AS COST_CENTER,                      
MFA-TR*            STRIP(RESOURCE_CODE)    AS RESOURCE_CODE,                    
MFA-TR*            STRIP(FUNC_ACT_CD)      AS FUNC_ACT_CD,                      
MFA-TR*            GL_ACCT_NM              AS GL_ACCT_NM,                       
MFA-TR*            STRIP(WORK_ORDER_NM)    AS WORK_ORDER_NM,                    
MFA-TR*            STRIP(CUSTOMER_CD)      AS CUSTOMER_CD,                      
MFA-TR*            STRIP(SERVICE_CD)       AS SERVICE_CD,                       
MFA-TR*            STRIP(EVENT_CD)         AS EVENT_CD                          
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR03934_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR03934_R1' TO        
                 S-SQL-STATEMENT-V.                                     
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR03934_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR03934_R1
               (  RETURN_CODE              INT,                    
                   COST_CENTER CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   RESOURCE_CODE CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   FUNC_ACT_CD CHAR(06)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   GL_ACCT_NM               DECIMAL(7,4),               
                   WORK_ORDER_NM CHAR(06)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   CUSTOMER_CD CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   SERVICE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
                   EVENT_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 0120-DELETE-GTT-ROWS THRU 0120-EXIT              
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '0100A'          TO ACTIVE-PARAGRAPH            
                   MOVE 'DECLARE GTT'    TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSR03934_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
               END-IF
            END-IF.       
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       0120-DELETE-GTT-ROWS.                                            
                                                                        
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR03934_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03934_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '0120'                TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR03934_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
            END-IF.           
                                                                        
       0120-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************09200000
      *   2000-PROCESS-OUTPUT                                          *09210000
      *                                                                *09220000
      *       1. RETRIEVE DB2 DATA                                     *09240000
      *       2. BUILD RESULT SET                                      *09250000
      *       3. SEND RESULT SET                                       *09260000
      *                                                                *09270000
      ******************************************************************09280000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-BUILD-RESULT       THRU 5000-EXIT.              
                                                                        
C36707     MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE.            
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5000-BUILD-RESULT                                              *        
      ******************************************************************        
       5000-BUILD-RESULT.                                               
                                                                        
           PERFORM 7100-CHECK-SRNBR                  THRU 7100-EXIT.    
           PERFORM 7200-INS-SOMATL-PROCESS           THRU 7200-EXIT.    
           IF WS-ACTIVE-RETURN-CODE EQUAL ZEROS                         
              PERFORM 7300-UPD-SOMATL-TRK-STOCKS     THRU 7300-EXIT     
              PERFORM 7310-UPD-SOMATL-CTRL-STOCKS    THRU 7310-EXIT     
              PERFORM 7320-UPD-SOMATL-RESRC-CD       THRU 7320-EXIT     
              PERFORM 7330-UPD-SOMATL-FUNC-CD        THRU 7330-EXIT     
              PERFORM 7340-UPD-SOMATL-GL-ACCT        THRU 7340-EXIT     
              PERFORM 7350-UPD-SOMATL-PREM           THRU 7350-EXIT     
C37340        PERFORM 7360-UPD-SOMATL-ALT-UOM        THRU 7360-EXIT     
           END-IF.                                                      
           PERFORM 7400-OPEN-UDAK-VALIDT             THRU 7400-EXIT.    
           PERFORM 7500-FETCH-UDAK-VALIDT            THRU 7500-EXIT     
C36707             UNTIL S-RETURN-CODE = NOT-FOUND.                     
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-CHECK-SRNBR                                               *        
      ******************************************************************        
       7100-CHECK-SRNBR.                                                
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = 'SRNBR'                                
T37261                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'SRNBR'                                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE       TO WS-SRNBR                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_DELIQUENCY'      TO TABLE-1                     
              MOVE 'DELINQUENCY_CD'      TO TABLE-ELEMENT-1             
              MOVE 'SRNBR'               TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-INS-SOMATL-PROCESS                                        *        
      ******************************************************************        
       7200-INS-SOMATL-PROCESS.                                         
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SOMATL_PROCESS                            
                    (SERV_ORDER_NO,                                     
                    COMP_UNIT_CD,                                       
                    CU_SEQ_NM,                                          
                    MATL_USAGE_CD,                                      
                    MATL_ITEM_CD,                                       
                    WORK_ORDER_NM,                                      
                    GL_ACCT_NM,                                         
                    FUNC_ACT_CD,                                        
                    POINT,                                              
                    SPAN_TO_POINT,                                      
                    MISC_TRK_STOCK_AM,                                  
                    MATL_ITEM_QT,                                       
                    CU_QT,                                              
                    MATL_ITEM_TOT_AM,                                   
                    MATL_ITEM_TYPE_CD,                                  
                    UOM_CD,                                             
                    COST_CENTER,                                        
                    EMPLOYEE_ID,                                        
                    COMPANY_NO,                                         
                    LOCAL_STORERM_ID,                                   
                    WORK_AREA_WO_NM,                                    
                    OK_TO_PROCESS_FL,                                   
                    MAIL_CD,                                            
                    PROCESSED_DT)                                       
      *      VALUES (                                                           
             SELECT WU.SERV_ORDER_NO,                                   
                    WU.COMP_UNIT_CD,                                    
                    WU.CU_SEQ_NM,                                       
                    WU.MATL_USAGE_CD,                                   
                    WU.MATL_ITEM_CD,                                    
                    WU.WORK_ORDER_NM,                                   
                    WU.GL_ACCT_NO,                                      
                    WU.FUNC_ACT_CD,                                     
                    WU.POINT,                                           
                    WU.SPAN_TO_POINT,                                   
                    WU.MISC_TRK_STOCK_AM,                               
                    WU.MATL_ITEM_QT,                                    
                    WU.CU_QT,                                           
                    WU.MATL_ITEM_TOT_AM,                                
                    WU.MATL_ITEM_TYPE_CD,                               
                    WU.UOM_CD,                                          
                    WU.COST_CENTER,                                     
                    WU.EMPLOYEE_ID,                                     
                    WU.COMPANY_NO,                                      
                    WU.LOCAL_STORERM_ID,                                
                    WU.WORK_AREA_WO_NM,                                 
                    WU.OK_TO_PROCESS_FL,                                
                    AG.MAIL_CD,                                         
                    WU.PROCESSED_DT                                     
               FROM CSS_SO_MATL_TRAN WU,                                
                    CSS_WORK_AREA_MATL AG,                              
                    CSS_SO_DATA VO,                                     
                    CSS_WORK_AREA I2                                    
              WHERE WU.PROCESSED_DT IS NULL                             
                AND WU.MATL_USAGE_CD IN ('I', 'R')                      
                AND (WU.MATL_ITEM_TYPE_CD LIKE 'T%'                     
                 OR WU.MATL_ITEM_TYPE_CD LIKE 'C%')                     
                AND WU.MATL_ITEM_QT <> 0                                
                AND WU.OK_TO_PROCESS_FL = 'Y'                           
                AND WU.SERV_ORDER_NO= VO.SERV_ORDER_NO                  
                AND WU.LOCAL_STORERM_ID = AG.LOCAL_STORERM_ID           
                AND AG.WORK_AREA_ID = VO.WORK_AREA_ID                   
                AND VO.WORK_AREA_ID = I2.WORK_AREA_ID                   
                AND WU.LOCAL_STORERM_ID <> :WS-SRNBR-CHAR               
      *             )                                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SOMATL_PROCESS'  TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-UPD-SOMATL-TRK-STOCKS                                     *        
      ******************************************************************        
       7300-UPD-SOMATL-TRK-STOCKS.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SOMATL_PROCESS                                 
                 SET RESOURCE_CD = '206'                                
               WHERE MATL_ITEM_TYPE_CD LIKE 'T%'                        
                 AND (RESOURCE_CD IN ('', ' ', '  ')                    
                  OR RESOURCE_CD IS NULL)                               
                 AND PROCESSED_DT IS NULL                               
                 AND GL_PROCESSED_DT IS NULL                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SOMATL_PROCESS'  TO TABLE-1                     
              MOVE 'RESOURCE_CD'         TO TABLE-ELEMENT-1             
              MOVE '206'                 TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-UPD-SOMATL-CTRL-STOCKS                                    *        
      ******************************************************************        
       7310-UPD-SOMATL-CTRL-STOCKS.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SOMATL_PROCESS                                 
                 SET RESOURCE_CD = '202'                                
               WHERE MATL_ITEM_TYPE_CD IN ('CON', 'C', 'C ', 'C  ')     
                 AND MATL_USAGE_CD = 'I'                                
                 AND (RESOURCE_CD IN ('', ' ', '  ')                    
                  OR RESOURCE_CD IS NULL)                               
                 AND PROCESSED_DT IS NULL                               
                 AND GL_PROCESSED_DT IS NULL                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7310'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SOMATL_PROCESS'  TO TABLE-1                     
              MOVE 'RESOURCE_CD'         TO TABLE-ELEMENT-1             
              MOVE '202'                 TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-UPD-SOMATL-RESRC-CD                                       *        
      ******************************************************************        
       7320-UPD-SOMATL-RESRC-CD.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SOMATL_PROCESS                                 
                 SET RESOURCE_CD = '203'                                
               WHERE MATL_ITEM_TYPE_CD IN ('CON', 'C', 'C ', 'C  ')     
                 AND MATL_USAGE_CD = 'R'                                
                 AND (RESOURCE_CD IN ('', ' ', '  ')                    
                  OR RESOURCE_CD IS NULL)                               
                 AND PROCESSED_DT IS NULL                               
                 AND GL_PROCESSED_DT IS NULL                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7320'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SOMATL_PROCESS'  TO TABLE-1                     
              MOVE 'RESOURCE_CD'         TO TABLE-ELEMENT-1             
              MOVE '203'                 TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7330-UPD-SOMATL-FUNC-CD                                        *        
      ******************************************************************        
       7330-UPD-SOMATL-FUNC-CD.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SOMATL_PROCESS                                 
                 SET FUNC_ACT_CD = '    '                               
               WHERE FUNC_ACT_CD IS NULL                                
                  AND MATL_ITEM_TYPE_CD LIKE 'T%'                       
                  AND PROCESSED_DT IS NULL                              
                  AND GL_PROCESSED_DT IS NULL                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7330'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SOMATL_PROCESS'  TO TABLE-1                     
              MOVE 'MATL_ITEM_TYPE_CD'   TO TABLE-ELEMENT-1             
              MOVE 'T%'                  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7340-UPD-SOMATL-GL-ACCT                                        *        
      ******************************************************************        
       7340-UPD-SOMATL-GL-ACCT.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SOMATL_PROCESS                                
                  SET GL_ACCT_NM = 000.0000                             
                WHERE GL_ACCT_NM = 108.0100                             
                  AND WORK_ORDER_NM > '002999'                          
                  AND WORK_ORDER_NM < '008000'                          
                  AND (MATL_ITEM_TYPE_CD LIKE 'T%'                      
                   OR MATL_ITEM_TYPE_CD LIKE 'C%')                      
                  AND PROCESSED_DT IS NULL                              
                  AND GL_PROCESSED_DT IS NULL                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7340'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SOMATL_PROCESS'  TO TABLE-1                     
              MOVE 'MATL_ITEM_TYPE_CD'   TO TABLE-ELEMENT-1             
              MOVE 'T%'                  TO HOSTVAR-ELEMENT-1           
              MOVE 'MATL_ITEM_TYPE_CD'   TO TABLE-ELEMENT-2             
              MOVE 'C%'                  TO HOSTVAR-ELEMENT-2           
              MOVE 'WORK_ORDER_NM'       TO TABLE-ELEMENT-3             
              MOVE '002999'              TO HOSTVAR-ELEMENT-3           
              MOVE 'WORK_ORDER_NM'       TO TABLE-ELEMENT-4             
              MOVE '008000'              TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7350-UPD-SOMATL-PREM                                           *        
      ******************************************************************        
       7350-UPD-SOMATL-PREM.                                            
                                                                        
           EXEC SQL                                                     
               UPDATE TN                              
                  SET PREMISE_NO = (SELECT PR.PREMISE_NO
            FROM CSS_SO_DATA VO                            
                             ,CSS_REV_DISTRICT A9                       
                             ,CSS_PREMISE PR
            WHERE TN.SERV_ORDER_NO = VO.SERV_ORDER_NO       
                          AND VO.PREMISE_NO = PR.PREMISE_NO             
                          AND A9.REV_DISTRICT_CD = PR.REV_DISTRICT_CD),
               STATE_CD = (SELECT A9.STATE
            FROM CSS_SO_DATA VO                            
                             ,CSS_REV_DISTRICT A9                       
                             ,CSS_PREMISE PR
            WHERE TN.SERV_ORDER_NO = VO.SERV_ORDER_NO       
                          AND VO.PREMISE_NO = PR.PREMISE_NO             
                          AND A9.REV_DISTRICT_CD = PR.REV_DISTRICT_CD),
               COUNTY_CD = (SELECT A9.COUNTY
            FROM CSS_SO_DATA VO                            
                             ,CSS_REV_DISTRICT A9                       
                             ,CSS_PREMISE PR
            WHERE TN.SERV_ORDER_NO = VO.SERV_ORDER_NO       
                          AND VO.PREMISE_NO = PR.PREMISE_NO             
                          AND A9.REV_DISTRICT_CD = PR.REV_DISTRICT_CD)  
               FROM CSS_SOMATL_PROCESS TN
                WHERE PROCESSED_DT IS NULL                              
                  AND GL_PROCESSED_DT IS NULL                           
                  AND TN.COMPANY_NO = '26'                              
                  AND EXISTS                                            
                      (SELECT 1                                         
                         FROM CSS_SO_DATA VO                            
                             ,CSS_REV_DISTRICT A9                       
                             ,CSS_PREMISE PR                            
                        WHERE TN.SERV_ORDER_NO = VO.SERV_ORDER_NO       
                          AND VO.PREMISE_NO = PR.PREMISE_NO             
                          AND A9.REV_DISTRICT_CD = PR.REV_DISTRICT_CD)  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ055
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SOMATL_PROCESS TN                                     
MFA-TR*           SET (PREMISE_NO                                               
MFA-TR*               ,STATE_CD                                                 
MFA-TR*               ,COUNTY_CD)                                               
MFA-TR*             =                                                           
MFA-TR*               (SELECT PR.PREMISE_NO                                     
MFA-TR*                      ,A9.STATE                                          
MFA-TR*                      ,A9.COUNTY                                         
MFA-TR*                  FROM CSS_SO_DATA VO                                    
MFA-TR*                      ,CSS_REV_DISTRICT A9                               
MFA-TR*                      ,CSS_PREMISE PR                                    
MFA-TR*                 WHERE TN.SERV_ORDER_NO = VO.SERV_ORDER_NO               
MFA-TR*                   AND VO.PREMISE_NO = PR.PREMISE_NO                     
MFA-TR*                   AND A9.REV_DISTRICT_CD = PR.REV_DISTRICT_CD)          
MFA-TR*         WHERE PROCESSED_DT IS NULL                                      
MFA-TR*           AND GL_PROCESSED_DT IS NULL                                   
MFA-TR*           AND TN.COMPANY_NO = '26'                                      
MFA-TR*           AND EXISTS                                                    
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CSS_SO_DATA VO                                    
MFA-TR*                      ,CSS_REV_DISTRICT A9                               
MFA-TR*                      ,CSS_PREMISE PR                                    
MFA-TR*                 WHERE TN.SERV_ORDER_NO = VO.SERV_ORDER_NO               
MFA-TR*                   AND VO.PREMISE_NO = PR.PREMISE_NO                     
MFA-TR*                   AND A9.REV_DISTRICT_CD = PR.REV_DISTRICT_CD)          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7350'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SOMATL_PROCESS'  TO TABLE-1                     
              MOVE 'COMPANY NO'          TO TABLE-ELEMENT-1             
              MOVE '26'                  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
C37340******************************************************************        
C37340* 7360-UPD-SOMATL-ALT-UOM.                                       *        
C37340******************************************************************        
C37340 7360-UPD-SOMATL-ALT-UOM.                                         
C37340                                                                  
C37340     EXEC SQL                                                     
C37340         UPDATE SP                              
C37340            SET SP.MATL_ITEM_QT = ROUND (SP.MATL_ITEM_QT *        
C37340             (SELECT MATL_ITEM_CNV_FC FROM CSS_MATL_ALT_UOM       
C37340               WHERE MATL_ITEM_CD = SP.MATL_ITEM_CD), 0)          
               FROM CSS_SOMATL_PROCESS SP
C37340          WHERE PROCESSED_DT IS NULL                              
C37340            AND GL_PROCESSED_DT IS NULL                           
C37340            AND SP.MATL_ITEM_CD IN                                
C37340            (SELECT DISTINCT MATL_ITEM_CD FROM CSS_MATL_ALT_UOM)  
C37340     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SOMATL_PROCESS SP                                     
MFA-TR*           SET SP.MATL_ITEM_QT = ROUND (SP.MATL_ITEM_QT *                
MFA-TR*            (SELECT MATL_ITEM_CNV_FC FROM CSS_MATL_ALT_UOM               
MFA-TR*              WHERE MATL_ITEM_CD = SP.MATL_ITEM_CD), 0)                  
MFA-TR*         WHERE PROCESSED_DT IS NULL                                      
MFA-TR*           AND GL_PROCESSED_DT IS NULL                                   
MFA-TR*           AND SP.MATL_ITEM_CD IN                                        
MFA-TR*           (SELECT DISTINCT MATL_ITEM_CD FROM CSS_MATL_ALT_UOM)          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37340                                                                  
C37340     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37340                                                                  
C37340     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C37340        NEXT SENTENCE                                             
C37340     ELSE                                                         
C37340        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C37340        MOVE '7360'                TO ACTIVE-PARAGRAPH            
C37340        MOVE 'UPDATE'              TO ABEND-FUNCTION              
C37340        MOVE 'CSS_SOMATL_PROCESS'  TO TABLE-1                     
C37340        MOVE 'QUANTITY'            TO TABLE-ELEMENT-1             
C37340        MOVE 'ALT UOM'             TO HOSTVAR-ELEMENT-1           
C37340        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C37340        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
C37340                                                                  
C37340 7360-EXIT.                                                       
C37340     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7400-OPEN-UDAK-VALIDT                                         *         
      *****************************************************************         
       7400-OPEN-UDAK-VALIDT.                                           
                                                                        
           EXEC SQL                                                     
               OPEN UDAK-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSS_SOMATL_PROCESS'  TO TABLE-1                     
              MOVE 'COMPANY NO'          TO TABLE-ELEMENT-1             
              MOVE '01'                  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7500-FETCH-UDAK-VALIDT                                        *         
      *****************************************************************         
       7500-FETCH-UDAK-VALIDT.                                          
                                                                        
           EXEC SQL                                                     
               FETCH UDAK-CURSOR                                        
                INTO  :RS-COST-CENTER                                   
                     ,:RS-RESOURCE-CD :WS-NULL-IND                       
                     ,:RS-FUNC-ACT-CD                                   
                     ,:RS-GL-ACCT-NM                                    
                     ,:RS-WORK-ORDER-NM                                 
                     ,:RS-CUSTOMER-CD :WS-NULL-IND1                      
                     ,:RS-SERVICE-CD :WS-NULL-IND2                       
                     ,:RS-EVENT-CD :WS-NULL-IND3                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C36707                      S-RETURN-CODE.                              
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSS_SOMATL_PROCESS'  TO TABLE-1                     
              MOVE 'COMPANY NO'          TO TABLE-ELEMENT-1             
              MOVE '01'                  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
C36707     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
C36707     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND CTR-ROWS = 0        
C36707        PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
C36707     END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7600-COMMIT.                                                  *         
      *****************************************************************         
       7600-COMMIT.                                                     
                                                                        
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *8100-SEND-RESULT.                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR03934_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,COST_CENTER                                        
                    ,RESOURCE_CODE                                      
                    ,FUNC_ACT_CD                                        
                    ,GL_ACCT_NM                                         
                    ,WORK_ORDER_NM                                      
                    ,CUSTOMER_CD                                        
                    ,SERVICE_CD                                         
                    ,EVENT_CD                                           
                )                                                       
                VALUES                                                  
                (                                                       
C36707               :S-RETURN-CODE                                     
                    ,:RS-COST-CENTER                                    
                    ,:RS-RESOURCE-CD                                    
                    ,:RS-FUNC-ACT-CD                                    
                    ,:RS-GL-ACCT-NM                                     
                    ,:RS-WORK-ORDER-NM                                  
                    ,:RS-CUSTOMER-CD                                    
                    ,:RS-SERVICE-CD                                     
                    ,:RS-EVENT-CD                                       
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR03934_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,COST_CENTER                                                
MFA-TR*             ,RESOURCE_CODE                                              
MFA-TR*             ,FUNC_ACT_CD                                                
MFA-TR*             ,GL_ACCT_NM                                                 
MFA-TR*             ,WORK_ORDER_NM                                              
MFA-TR*             ,CUSTOMER_CD                                                
MFA-TR*             ,SERVICE_CD                                                 
MFA-TR*             ,EVENT_CD                                                   
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:RS-COST-CENTER                                            
MFA-TR*             ,:RS-RESOURCE-CD                                            
MFA-TR*             ,:RS-FUNC-ACT-CD                                            
MFA-TR*             ,:RS-GL-ACCT-NM                                             
MFA-TR*             ,:RS-WORK-ORDER-NM                                          
MFA-TR*             ,:RS-CUSTOMER-CD                                            
MFA-TR*             ,:RS-SERVICE-CD                                             
MFA-TR*             ,:RS-EVENT-CD                                               
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                    TO CTR-ROWS                   
           ELSE                                                         
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE SQLCODE              TO ABEND-SQLCODE              
                MOVE '8100'               TO ACTIVE-PARAGRAPH           
                MOVE 'INSERT'             TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSR03934_R1'        TO TABLE-1                    
                MOVE SPACES               TO TABLE-ELEMENT-1            
                MOVE SPACES               TO HOSTVAR-ELEMENT-1          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
