       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR03930.                                            
       DATE-WRITTEN. 06/03/2008.                                        
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO RETRIEVE ALL THE CURRENT ACCOUNTS   *        
      *  FOR A GIVEN GIS_POINT_ID IN CSS_MTRD_ENVRNMT                           
      *  THIS SP IS USED BY THE WMS TEAM TO VERIFY IF ANY POINT IS     *        
      *  ASSOCIATED TO A CURRENT ACCOUNT.                              *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/03/2008  SC41135  PROCEDURE ORIGINALLY CODED               *        
      *  04/09/2009  SC41135  ALLOW POINTID TO BE MADE POST-SPATIAL FOR*        
      *                       REMOVED METERS- APPL00001075             *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03930'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    MN - CSS_MTRD_ENVRNMT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_CUST_PREM_HIST                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    COMMON COPYLIBS                                             *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR03930_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(8)  VALUE 'CSR03930'. 
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP.             
           05  RS-DEACT-POINT               PIC X(01).                  
                                                                        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE               PIC S9(9) COMP.              
           05  S-DEACT-POINT               PIC X(01).                   
      *                                                                         
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
      ******************************************************************        
      *    BETWEEN FIELD WORK AREAS                                    *        
      ******************************************************************        
       01  WS-MISC-FIELDS.                                              
           05  PROGRAM-NAME                 PIC X(8) VALUE 'CSR03930'.  
           05  WS-TODAYS-DATE               PIC X(10).                  
COB305     05 WS-HOLD-PREMISE-NO        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.   
COB305     05 WS-HOLD-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.   
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-MAX-RETURN-ROWS           PIC S9(4) COMP VALUE 20.    
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  CN-ASTERISK                  PIC X VALUE '*'.            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-GIS-POINT-ID             PIC S9(09) COMP.               
       01  PARM-DEACT-POINT              PIC X(01).                     
      ******************************************************************        
      *    PR-CURSOR USED TO SEARCH FOR POINT ID'S.                    *        
      *    CHANGED TO USE GIS-POINT-ID                                 *        
      ******************************************************************        
           EXEC SQL DECLARE PR-CURSOR CURSOR FOR                        
              SELECT  DISTINCT                                          
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO                                     
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)               
                WHERE MN.GIS_POINT_ID    =:MN-GIS-POINT-ID              
                  AND MN.ACCOUNT_NO      = HT.ACCOUNT_NO                
                  AND CODE_METER_STATUS  <> 'K'                         
             FOR READ ONLY                                             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE PR-CURSOR CURSOR FOR                                
MFA-TR*       SELECT  DISTINCT                                                  
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO                                             
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_MTRD_ENVRNMT   MN                                     
MFA-TR*         WHERE MN.GIS_POINT_ID    =:MN-GIS-POINT-ID                      
MFA-TR*           AND MN.ACCOUNT_NO      = HT.ACCOUNT_NO                        
MFA-TR*           AND CODE_METER_STATUS  <> 'K'                                 
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION USING PARM-GIS-POINT-ID ,                     
                                PARM-DEACT-POINT.                       
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
      *        PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                       
               EXEC SQL                                                 
                   DECLARE C1 CURSOR FOR                                
                   SELECT                                               
                        :S-RETURN-CODE        AS RETURN_CODE,           
                        :S-DEACT-POINT        AS DEACT_POINT            
                   FROM                                                 
                       CIS.SYSDUMMY1                                 
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C1 CURSOR FOR                                        
MFA-TR*            SELECT                                                       
MFA-TR*                 :S-RETURN-CODE        AS RETURN_CODE,                   
MFA-TR*                 :S-DEACT-POINT        AS DEACT_POINT                    
MFA-TR*            FROM                                                         
MFA-TR*                SYSIBM.SYSDUMMY1                                         
MFA-TR*        END-EXEC.                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *        
      *     2. SPLIT OUT PARM STRING INFORMATION                       *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
               MOVE PARM-GIS-POINT-ID          TO MN-GIS-POINT-ID.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *     BUILD THE RESULT SET.                                      *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
                   MOVE 0 TO WS-HOLD-PREMISE-NO                         
                             WS-HOLD-ACCOUNT-NO                         
                                                                        
                   PERFORM 2290-SEARCH-VIA-PR-CURSOR    THRU 2290-EXIT  
                                                                        
           IF CTR-ROWS = ZERO                                           
               MOVE NOT-FOUND TO RS-RETURN-CODE                         
               MOVE 'Y'      TO  RS-DEACT-POINT                         
               MOVE 'Y'      TO  PARM-DEACT-POINT                       
               PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
               PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT                                               *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
           MOVE RS-DEACT-POINT         TO S-DEACT-POINT.                
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2290-SEARCH-VIA-PR-CURSOR                                      *        
      *     SEARCH FOR ACCOUNTS VIA PR CURSOR. CALL COMMON PARAGRAPH   *        
      *     TO RETRIEVE ADDTIONAL DATA AND PERFORM FILTERS.            *        
      ******************************************************************        
                                                                        
       2290-SEARCH-VIA-PR-CURSOR.                                       
                                                                        
                                                                        
           PERFORM 7291-OPEN-PR-CURSOR                  THRU 7291-EXIT. 
           PERFORM 7292-FETCH-PR-CURSOR                 THRU 7292-EXIT. 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND)                
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7292-FETCH-PR-CURSOR             THRU 7292-EXIT  
           END-PERFORM.                                                 
                                                                        
           PERFORM 7293-CLOSE-PR-CURSOR                 THRU 7293-EXIT. 
                                                                        
       2290-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-ROW                                               *        
      *     GET ANY MISSING DATA NOT FOUND IN THE ORIGINAL CURSORS.    *        
      *     FORMAT RESULT SET AND SEND DATA.                           *        
      ******************************************************************        
                                                                        
       2500-PROCESS-ROW.                                                
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
           IF HT-PREMISE-NO NOT = WS-HOLD-PREMISE-NO                    
               MOVE ZEROES TO WS-CPD99-ACCOUNT-NO                       
                              WS-CPD99-PREMISE-NO                       
               MOVE HT-PREMISE-NO TO WS-HOLD-PREMISE-NO                 
                                     WS-CPD99-PREMISE-NO                
               PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT            
               MOVE WS-CPD99-ACCOUNT-NO TO WS-HOLD-ACCOUNT-NO           
           END-IF                                                       
                                                                        
           IF HT-ACCOUNT-NO NOT = WS-HOLD-ACCOUNT-NO                    
               GO TO 2500-EXIT                                          
           END-IF                                                       
                                                                        
           MOVE 'N'                TO RS-DEACT-POINT                    
           MOVE 'N'                TO PARM-DEACT-POINT                  
           MOVE 0                  TO RS-RETURN-CODE                    
           PERFORM 2000A-MOVE-RESULT         THRU    2000A-EXIT.        
      *    PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.                    
           PERFORM 7293-CLOSE-PR-CURSOR                 THRU 7293-EXIT. 
               GO TO 2000-EXIT.                                         
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6995-CPD99-ERROR-ROUTINE.                                      *        
      ******************************************************************        
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME               TO ABEND-PROGRAM.            
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7291-OPEN-PR-CURSOR                                            *        
      *     OPEN PR-CURSOR CHECK FOR SQL ERROR.                        *        
      ******************************************************************        
                                                                        
       7291-OPEN-PR-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN PR-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7291'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'POINT_ID'             TO TABLE-ELEMENT-1           
               MOVE MN-GIS-POINT-ID        TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7291-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7292-FETCH-PR-CURSOR                                           *        
      *     FETCH PR-CURSOR CHECK FOR SQL ERROR.                       *        
      ******************************************************************        
                                                                        
       7292-FETCH-PR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH PR-CURSOR                                          
                INTO                                                    
                     :HT-ACCOUNT-NO                                     
                    ,:HT-PREMISE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
                NEXT SENTENCE                                           
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7292'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'POINT_ID'             TO TABLE-ELEMENT-1           
               MOVE MN-GIS-POINT-ID        TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7292-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7293-CLOSE-PR-CURSOR                                           *        
      *     CLOSE PR-CURSOR CHECK FOR SQL ERROR.                       *        
      ******************************************************************        
                                                                        
       7293-CLOSE-PR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE PR-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7293'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'POINT_ID'             TO TABLE-ELEMENT-1           
               MOVE MN-GIS-POINT-ID        TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7293-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR03930_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03930_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR03930_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
            END-IF.                                                     
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
                ADD +1                    TO  CTR-ROWS .                
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00321.                                                       
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
