       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03901.                                         
COB303 DATE-WRITTEN.      JANUARY 25, 2007.                             
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED A STORED PROCEDURE CALL (DB2).       *00100000
      *                                                                *00110000
      *  PROGRAM: CSR03901                                             *00130000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES CSS_SO_PRINT_QUEUE OR CSS_SO_CAD_QUEUE   *00200000
      *  BASED ON INPUT FL AND ALSO UPDATES CSS_SO_DATA.               *00220000
      *                                                                *        
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  01/25/07    RR       SP ORIGINALLY ADDED.                     *00290000
      *  06/26/07    RR       ADD CREATED_TS AND PRIORITY TO INPUT     *        
      *                       PARMS TO IMPROVE PRINT PERFORMANCE       *        
      *                       THIS WAS NOT ADDED FOR CAD BECAUSE THIS  *        
      *                       IS NOT CURRENTLY USED TO UPD CAD_Q.      *        
      *                                                                *        
      ******************************************************************00560000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03901'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03901 STARTS HERE'.                  
                                                                        
      ******************************************************************00650000
      *    DB2 INCLUDES                                                *00660000
      ******************************************************************00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBSODAT                                           00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBCADPQU                                          00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBSOPRT                                           00700000
           END-EXEC.                                                    00710000
                                                                        
           COPY CWS00303.                                               01520000
                                                                        
           EXEC SQL                                                     01570000
               INCLUDE CWSX0010                                         01570000
           END-EXEC.                                                    01570000
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(09) COMP VALUE +0.   
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(09) COMP VALUE +0.   
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                    PIC X(01) VALUE 'Y'.         
               88 NO-MORE-ROWS                       VALUE 'N'.         
               88 MORE-ROWS                          VALUE 'Y'.         
                                                                        
       01  WS-MISC.                                                     
           05  WS-SERV-ORDER-NO-RED     PIC X(13).                      
           05  WS-SERV-ORDER-NO         REDEFINES WS-SERV-ORDER-NO-RED  
                                        PIC 9(13).                      
           05  WS-DEC-SO-NO             PIC S9(13)V COMP-3 VALUE 0.     
           05  WS-QUEUE-FL              PIC X(01) VALUE SPACES.         
           05  WS-CREATED-TS            PIC X(26) VALUE SPACES.         
           05  WS-PRIORITY              PIC X(01) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR03901'.     
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-NUM-ONE               PIC S9(9) COMP VALUE +1.        
           05  WS-CREATED-BY-USERID     PIC X(07) VALUE SPACES.         
           05  WS-WANTED-BY-DATETIME    PIC X(26) VALUE SPACES.         
           05  WS-ASSIGNED-DATETIME     PIC X(26) VALUE SPACES.         
           05  WS-CHECK-DATE            PIC X(26) VALUE SPACES.         
           05  WS-PRINT-PRIORITY        PIC X(01) VALUE SPACES.         
           05  WS-SERV-ORD-STATUS       PIC X(02) VALUE '10'.           
           05  WS-SERVICE-REQ-CODE      PIC X(01) VALUE '2'.            
           05  WS-92-RET-CD             PIC S9(09) COMP VALUE +0.       
           05  WS-64-RET-CD             PIC S9(09) COMP VALUE +0.       
           05  WS-DATE-DIFF             PIC S9(4) COMP VALUE +0.        
                                                                        
      *01 LOC1416 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0092 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0064 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1416 CURSOR
MSQ001          FOR CALL CSR01416 ( :WS-CURRENT-TS
                  , :WS-NUM-ONE
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0092 CURSOR
MSQ001          FOR CALL CSR00092 ( :WS-SERV-ORDER-NO-RED
                  , :WS-SERV-ORD-STATUS
                  , :WS-SERVICE-REQ-CODE
                  , :WS-CREATED-BY-USERID
                  , :WS-WANTED-BY-DATETIME
                  , 'S105'
                  , 'Y'
                  )
MSQ001        END-EXEC.
         
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-QUEUE-FL            PIC X(01) VALUE SPACES.             
       01  PARM-SERV-ORDER-NO       PIC X(13) VALUE SPACES.             
       01  PARM-CREATED-TS          PIC X(26) VALUE SPACES.             
       01  PARM-PRIORITY            PIC X(01) VALUE SPACES.             
                                                                        
       PROCEDURE DIVISION USING  PARM-QUEUE-FL                          
                                 PARM-SERV-ORDER-NO                     
                                 PARM-CREATED-TS                        
                                 PARM-PRIORITY.                         
                                                                        
      ******************************************************************04640000
      * 0000-MAINLINE                                                  *04650000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04660000
      ******************************************************************04670000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04790000
      * 0100-INITIALIZE                                                *04800000
      *                                                                *04810000
      *     1. RESET DB2 ERROR HANDLERS                                *04820000
      *     2. DECLARE CURSOR FOR RESULT SET                           *04850000
      *                                                                *04860000
      ******************************************************************04870000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE          AS  RETURN_CODE              
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE          AS  RETURN_CODE                      
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05140000
      * 1000-PROCESS-INPUT.                                            *05150000
      *                                                                *05160000
      *     1.  RECEIVE PARMS FROM THE CLIENT.                         *05170000
      *     2.  FORMAT PACKED NUMERICS.                                *05180000
      *                                                                *05190000
      ******************************************************************05200000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-SERV-ORDER-NO TO WS-SERV-ORDER-NO-RED.             
                                                                        
           IF WS-SERV-ORDER-NO-RED NOT NUMERIC                          
               MOVE ZEROES TO WS-SERV-ORDER-NO-RED
           END-IF.                     
           MOVE WS-SERV-ORDER-NO-RED TO WS-SERV-ORDER-NO.               
           MOVE WS-SERV-ORDER-NO TO VO-SERV-ORDER-NO.                   
                                                                        
           MOVE PARM-QUEUE-FL TO WS-QUEUE-FL.                           
           MOVE PARM-CREATED-TS TO WS-CREATED-TS.                       
           MOVE PARM-PRIORITY TO WS-PRIORITY.                           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09200000
      *   2000-PROCESS-OUTPUT                                          *09210000
      *                                                                *09220000
      *       1. RETRIEVE DB2 DATA                                     *09240000
      *       2. BUILD RESULT SET                                      *09250000
      *       3. SEND RESULT SET                                       *09260000
      *                                                                *09270000
      ******************************************************************09280000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-BUILD-RESULT       THRU 5000-EXIT.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD +1                          TO CTR-ROWS.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE           TO S-RETURN-CODE.             
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5000-BUILD-RESULT                                              *        
      ******************************************************************        
       5000-BUILD-RESULT.                                               
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TS = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7800-GET-SO-INFO                  THRU 7800-EXIT.    
                                                                        
           EVALUATE WS-QUEUE-FL                                         
               WHEN 'P'                                                 
                   PERFORM 8100-UPDATE-PRINT-QUEUE   THRU 8100-EXIT     
               WHEN 'C'                                                 
                   PERFORM 8200-UPDATE-CAD-QUEUE     THRU 8200-EXIT     
           END-EVALUATE.                                                
                                                                        
           PERFORM 7805-GET-CHECK-DATE               THRU 7805-EXIT.    
           PERFORM 7810-DET-SAME-DAY                 THRU 7810-EXIT.    
                                                                        
           IF WS-DATE-DIFF > 0 OR WS-PRINT-PRIORITY = '2'               
             PERFORM 8300-UPDATE-SO-DATA             THRU 8300-EXIT     
             PERFORM 7815-CALL-CSR00092              THRU 7815-EXIT     
           ELSE                                                         
             PERFORM 8305-PARTIAL-UPD-SO-DATA        THRU 8305-EXIT     
             PERFORM 7820-CALL-CSR00064              THRU 7820-EXIT     
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-GET-SO-INFO                                               *        
      ******************************************************************        
       7800-GET-SO-INFO.                                                
                                                                        
           IF WS-QUEUE-FL = 'P' THEN                                    
             EXEC SQL                                                   
                SELECT TOP(1) VP.CREATED_BY_USER_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), VO.WANTED_BY_DATETIME
           , 121), ' ', '-'), ':', '.') WANTED_BY_DATETIME,
              REPLACE(REPLACE(CONVERT(CHAR(26), VO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              VP.PRINT_PRIORITY                                
                  INTO :WS-CREATED-BY-USERID,                           
                       :WS-WANTED-BY-DATETIME,                          
                       :WS-ASSIGNED-DATETIME,                           
                       :WS-PRINT-PRIORITY                               
                  FROM CSS_SO_DATA VO,                                  
                       CSS_SO_PRINT_QUEUE VP                            
                 WHERE VO.SERV_ORDER_NO      = :VO-SERV-ORDER-NO        
                   AND VO.SERV_ORDER_NO = VP.SERV_ORDER_NO              
                   AND VP.CREATED_TS = CIS.CHAR2TIMESTAMP(:WS-CREATED-TS
              )                   
                   AND VP.PRINT_PRIORITY = :WS-PRIORITY                 
                                                 
             END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT VP.CREATED_BY_USER_ID,                                   
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                VP.PRINT_PRIORITY                                        
MFA-TR*           INTO :WS-CREATED-BY-USERID,                                   
MFA-TR*                :WS-WANTED-BY-DATETIME,                                  
MFA-TR*                :WS-ASSIGNED-DATETIME,                                   
MFA-TR*                :WS-PRINT-PRIORITY                                       
MFA-TR*           FROM CSS_SO_DATA VO,                                          
MFA-TR*                CSS_SO_PRINT_QUEUE VP                                    
MFA-TR*          WHERE VO.SERV_ORDER_NO      = :VO-SERV-ORDER-NO                
MFA-TR*            AND VO.SERV_ORDER_NO = VP.SERV_ORDER_NO                      
MFA-TR*            AND VP.CREATED_TS = :WS-CREATED-TS                           
MFA-TR*            AND VP.PRINT_PRIORITY = :WS-PRIORITY                         
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*      END-EXEC                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
           END-IF.                                                      
                                                                        
           IF WS-QUEUE-FL = 'C' THEN                                    
             EXEC SQL                                                   
                SELECT TOP(1) QP.CREATED_BY_USER_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), VO.WANTED_BY_DATETIME
           , 121), ' ', '-'), ':', '.') WANTED_BY_DATETIME,
              REPLACE(REPLACE(CONVERT(CHAR(26), VO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              QP.CAD_PRIORITY                                  
                  INTO :WS-CREATED-BY-USERID,                           
                       :WS-WANTED-BY-DATETIME,                          
                       :WS-ASSIGNED-DATETIME,                           
                       :WS-PRINT-PRIORITY                               
                  FROM CSS_SO_DATA VO,                                  
                       CSS_SO_CAD_QUEUE QP                              
                 WHERE VO.SERV_ORDER_NO      = :VO-SERV-ORDER-NO        
                   AND VO.SERV_ORDER_NO = QP.SERV_ORDER_NO              
                   AND QP.CAD_TS IS NULL                                
                   AND QP.CAD_PRIORITY IN ('1', '2')                    
                 ORDER BY QP.CAD_PRIORITY DESC                          
                                                 
             END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT QP.CREATED_BY_USER_ID,                                   
MFA-TR*                VO.WANTED_BY_DATETIME,                                   
MFA-TR*                VO.ASSIGNED_DATETIME,                                    
MFA-TR*                QP.CAD_PRIORITY                                          
MFA-TR*           INTO :WS-CREATED-BY-USERID,                                   
MFA-TR*                :WS-WANTED-BY-DATETIME,                                  
MFA-TR*                :WS-ASSIGNED-DATETIME,                                   
MFA-TR*                :WS-PRINT-PRIORITY                                       
MFA-TR*           FROM CSS_SO_DATA VO,                                          
MFA-TR*                CSS_SO_CAD_QUEUE QP                                      
MFA-TR*          WHERE VO.SERV_ORDER_NO      = :VO-SERV-ORDER-NO                
MFA-TR*            AND VO.SERV_ORDER_NO = QP.SERV_ORDER_NO                      
MFA-TR*            AND QP.CAD_TS IS NULL                                        
MFA-TR*            AND QP.CAD_PRIORITY IN ('1', '2')                            
MFA-TR*          ORDER BY QP.CAD_PRIORITY DESC                                  
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*      END-EXEC                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
           END-IF.                                                      
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7800'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE VO-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7805-GET-CHECK-DATE                                            *        
      ******************************************************************        
       7805-GET-CHECK-DATE.                                             
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01416 (:WS-CURRENT-TS, :WS-NUM-ONE)               
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1416 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7805'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01416'            TO TABLE-1                     
              MOVE 'CURRENT TIMESTAMP'   TO TABLE-ELEMENT-1             
              MOVE WS-CURRENT-TS         TO HOSTVAR-ELEMENT-1           
              MOVE 'BIZ DAYS PARM'       TO TABLE-ELEMENT-2             
              MOVE WS-NUM-ONE            TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1416)                                                
      *       WITH PROCEDURE CSR01416                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1416 CURSOR FOR RESULT SET        
      *       :LOC1416                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_1416 INTO                          
                :WS-CHECK-DATE                                          
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
                IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   SET NO-MORE-ROWS             TO TRUE                 
                   MOVE +000 TO WS-ACTIVE-RETURN-CODE                   
                END-IF                                                  
             ELSE                                                       
                MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
                MOVE '7805'                     TO ACTIVE-PARAGRAPH     
                MOVE 'FETCH'                    TO ABEND-FUNCTION       
                MOVE 'CSR01416'                 TO TABLE-1              
                MOVE 'CURRENT TS'               TO TABLE-ELEMENT-1      
                MOVE WS-CURRENT-TS              TO HOSTVAR-ELEMENT-1    
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       7805-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7810-DET-SAME-DAY                                              *        
      ******************************************************************        
       7810-DET-SAME-DAY.                                               
                                                                        
           EXEC SQL                                                     
              SELECT
              CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) ) ) -                
                                    CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                  :WS-ASSIGNED-DATETIME
              ) IS NULL OR (PATINDEX('%.%', :WS-ASSIGNED-DATETIME
              ) <> 0) OR (LEN(:WS-ASSIGNED-DATETIME
              ) <> 10), CIS.CHAR2DATE(:WS-ASSIGNED-DATETIME
              ), CONVERT(DATE, :WS-ASSIGNED-DATETIME) ) )
            INTO
              :WS-DATE-DIFF         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-DIFF = DAYS(:WS-CHECK-DATE) -                        
MFA-TR*                             DAYS(:WS-ASSIGNED-DATETIME)                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7810'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'CSR01416'            TO TABLE-1                     
              MOVE 'DATEDIFF1'           TO TABLE-ELEMENT-1             
              MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-1           
              MOVE 'DATEDIFF2'           TO TABLE-ELEMENT-2             
              MOVE WS-CHECK-DATE         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7815-CALL-CSR00092                                             *        
      ******************************************************************        
       7815-CALL-CSR00092.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00092 (:WS-SERV-ORDER-NO-RED,                     
      *                      :WS-SERV-ORD-STATUS,                       
      *                      :WS-SERVICE-REQ-CODE,                      
      *                      :WS-CREATED-BY-USERID,                     
      *                      :WS-WANTED-BY-DATETIME,                    
      *                      'S105',                                    
      *                      'Y')                                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0092
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0092
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0092 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7815'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00092'            TO TABLE-1                     
              MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1             
              MOVE WS-SERV-ORDER-NO-RED  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0092)                                                
      *       WITH PROCEDURE CSR00092                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0092 CURSOR FOR RESULT SET        
      *       :LOC0092                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_0092 INTO                          
                :WS-92-RET-CD                                           
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
                IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   SET NO-MORE-ROWS             TO TRUE                 
                   MOVE +000 TO WS-ACTIVE-RETURN-CODE                   
                END-IF                                                  
             ELSE                                                       
                MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
                MOVE '7815'                     TO ACTIVE-PARAGRAPH     
                MOVE 'FETCH'                    TO ABEND-FUNCTION       
                MOVE 'CSR00092'                 TO TABLE-1              
                MOVE 'SERVICE ORDER NO'         TO TABLE-ELEMENT-1      
                MOVE WS-SERV-ORDER-NO-RED       TO HOSTVAR-ELEMENT-1    
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       7815-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7820-CALL-CSR00064                                             *        
      ******************************************************************        
       7820-CALL-CSR00064.                                              
                                                                        
           MOVE WS-SERV-ORDER-NO  TO WS-DEC-SO-NO.                      
                                                                        
           EXEC SQL                                                     
              CALL CSR00064 (:WS-DEC-SO-NO,                             
                             :WS-CREATED-BY-USERID,                     
                             :WS-WANTED-BY-DATETIME,                    
                             'S105',                                    
                             'Y')                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7820'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00064'            TO TABLE-1                     
              MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1             
              MOVE WS-SERV-ORDER-NO-RED  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
      *    EXEC SQL                                                             
      *       ASSOCIATE LOCATORS                                                
      *       (:LOC0064)                                                        
      *       WITH PROCEDURE CSR00064                                           
      *    END-EXEC.                                                            
                                                                        
      *    EXEC SQL                                                             
      *       ALLOCATE RESULT_SET_CSR_0064 CURSOR FOR RESULT SET                
      *       :LOC0064                                                          
      *    END-EXEC.                                                            
                                                                        
      *    PERFORM UNTIL NO-MORE-ROWS                                           
      *      EXEC SQL                                                           
      *         FETCH RESULT_SET_CSR_0064 INTO                                  
      *         :WS-64-RET-CD                                                   
      *      END-EXEC                                                           
                                                                        
      *      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE             
      *      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND            
      *         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                            
      *            SET NO-MORE-ROWS             TO TRUE                         
      *            MOVE +000 TO WS-ACTIVE-RETURN-CODE                           
      *         END-IF                                                          
      *      ELSE                                                               
      *         MOVE PROGRAM-NAME               TO ABEND-PROGRAM                
      *         MOVE '7820'                     TO ACTIVE-PARAGRAPH             
      *         MOVE 'FETCH'                    TO ABEND-FUNCTION               
      *         MOVE 'CSR00064'                 TO TABLE-1                      
      *         MOVE 'SERVICE ORDER NO'         TO TABLE-ELEMENT-1              
      *         MOVE WS-SERV-ORDER-NO-RED       TO HOSTVAR-ELEMENT-1            
      *         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                  
      *         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                  
      *      END-IF                                                             
      *    END-PERFORM.                                                         
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-UPDATE-PRINT-QUEUE                                        *        
      ******************************************************************        
       8100-UPDATE-PRINT-QUEUE.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_PRINT_QUEUE                                 
                 SET PRINTED_TS           = CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )              
               WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO             
                 AND PRINT_PRIORITY = :WS-PRIORITY                      
                 AND CREATED_TS = CIS.CHAR2TIMESTAMP(:WS-CREATED-TS)            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SO_PRINT_QUEUE                                         
MFA-TR*          SET PRINTED_TS           = :WS-CURRENT-TS                      
MFA-TR*        WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO                     
MFA-TR*          AND PRINT_PRIORITY = :WS-PRIORITY                              
MFA-TR*          AND CREATED_TS = :WS-CREATED-TS                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000 TO WS-ACTIVE-RETURN-CODE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_PRINT_QUEUE'  TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE VO-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-UPDATE-SO-CAD-QUEUE                                       *        
      ******************************************************************        
       8200-UPDATE-CAD-QUEUE.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_CAD_QUEUE                                   
                 SET CAD_TS             = CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )                
               WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO             
                 AND CAD_TS IS NULL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SO_CAD_QUEUE                                           
MFA-TR*          SET CAD_TS             = :WS-CURRENT-TS                        
MFA-TR*        WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO                     
MFA-TR*          AND CAD_TS IS NULL                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000 TO WS-ACTIVE-RETURN-CODE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_CAD_QUEUE'    TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE VO-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-UPDATE-SO-DATA                                            *        
      ******************************************************************        
       8300-UPDATE-SO-DATA.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_DATA                                        
                 SET PRINTED_IND        = 'Y',                          
                     DATE_PRINTED       = CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )                
               WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SO_DATA                                                
MFA-TR*          SET PRINTED_IND        = 'Y',                                  
MFA-TR*              DATE_PRINTED       = :WS-CURRENT-TS                        
MFA-TR*        WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8300'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE VO-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8305-PARTIAL-UPD-SO-DATA*                                               
      ******************************************************************        
       8305-PARTIAL-UPD-SO-DATA.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_DATA                                        
                 SET DATE_PRINTED       = CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )                
               WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SO_DATA                                                
MFA-TR*          SET DATE_PRINTED       = :WS-CURRENT-TS                        
MFA-TR*        WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8305'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE VO-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       8305-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
