       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03830.                                     
COB303 DATE-WRITTEN. MARCH 6, 2006.                                     
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03830              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03830 :                                                --         
      *--                                                            --         
      *--  THIS PROGRAM INSERTS, DELETES, OR UPDATES A ROW IN        --         
      *--  CSS_WH_CROSS_EQUIP BASED UPON THE REQUEST THRU PANEL213.  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  03/06/2007    VV94890     INITIALLY CODED FOR CML 32547   --         
      *----------------------------------------------------------------         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
      *                                                                         
HPCCDM*    EJECT                                                                
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03830'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                        PIC X(40)  VALUE              
           'WORKING STORAGE FOR CSR03830 STARTS HERE'.                  
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      * DB2 Includes                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    WO - CSS_WH_CROSS_PLUS                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBWCPLUS                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    WL - CSS_WH_CROSS_EQUIP                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBWCPEQU                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    MO - CSS_MEDICAL_EQUIP                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMEDEQU                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    MH - CSS_MNT_TRANS_HIST                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    MI - CSS_MT_TRN_HST_DET                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * PF - CSS_USER_PROFILE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBUSRPRF                                                 
           END-EXEC.                                                            
      ****************************                                              
      * DQ - CSS_NAME            *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MODEL_SQL, MS                                           *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DB2 AND SQL ERROR CHECKING                                 *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *    DB2SP COMMON VARIABLES                                     *         
      *****************************************************************         
       COPY CWSSP001.                                                           
                                                                        
      *****************************************************************         
      *    ERROR HANDLING COPY BOOK                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    COMMON SYSTEM AREA                                         *         
      *****************************************************************         
       COPY CCA00001.                                                           
                                                                        
      *****************************************************************         
      *    WS FOR 6010-REDUCE-EMBEDDED SPACES                         *         
      *****************************************************************         
       COPY CWS00011.                                                           
                                                                        
      *****************************************************************         
      *    ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS             *         
      *****************************************************************         
       COPY CWS00027.                                                           
                                                                        
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
      *                                                                         
       01  PARM-VARIABLES.                                              
           05  PARM-APP-ID             PIC S9(9) USAGE COMP.            
           05  PARM-USER-ID            PIC X(08).                       
           05  PARM-COMMENT-LEN        PIC S9(04) COMP                  
                                       VALUE ZEROS.                     
           05  PARM-COMMENT            PIC X(210).                      
           05  PARM-NO-ROWS            PIC X(02).                       
           05  WS-NO-ROWS              REDEFINES PARM-NO-ROWS           
                                       PIC 9(2).                        
           05  PARM-EQU-DATA.                                           
               10 PARM-EQU-ROW         PIC X(28).                       
               10 PARM-EQU-FIELDS      OCCURS 10 TIMES                  
                                       INDEXED BY EQ-INDX.              
                  15 WS-PROCESS-CD     PIC X(01).                       
                  15 WS-EQUIP-ID       PIC X(09).                       
                  15 WS-EQUIP-ID-NUM   REDEFINES WS-EQUIP-ID            
                                       PIC 9(9).                        
                  15 WS-MED-EQUIP-CD   PIC X(02).                       
                  15 WS-BACKUP-HRS     PIC X(03).                       
                  15 WS-BACKUP-HRS-NUM REDEFINES WS-BACKUP-HRS          
                                       PIC 9(3).                        
                  15 WS-HRS-USED       PIC X(03).                       
                  15 WS-HRS-USED-NUM   REDEFINES WS-HRS-USED            
                                       PIC 9(3).                        
                  15 WS-INACTIVE-DT    PIC X(10).                       
      *                                                                         
       01  NULL-INDICATORS.                                             
           05  WS-NULL-INDICATOR       PIC S9(04) COMP VALUE +0.        
           05  WS-WL-NULL-IND          PIC S9(04) COMP VALUE +0.        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-DT                   PIC X(10)                        
                                       VALUE '0001-01-01'.              
      *                                                                         
       01  WS-DB-FIELDS.                                                
           10 WS-DB-MEDICAL-EQUIP-CD   PIC X(02).                       
COB305     10 WS-DB-WC-BACKUP-HOURS        PIC S9(03)V COMP-3 VALUE 0.          
COB305     10 WS-DB-EQU-DAILY-HRS-USED        PIC S9(03)V COMP-3 
COB305       VALUE 0.              
           10 WS-DB-EQU-INACTIVE-DT    PIC X(10).                       
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9)   COMP VALUE 0.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE            PIC S9(9)   VALUE 0 COMP.        
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-DATABASE             PIC 9(01)   VALUE ZEROS .        
               88  CSR-DATABASE        VALUE 1                 .        
               88  SEB-DATABASE        VALUE 2                 .        
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.        
           05  WS-APPLICATION-ID       PIC Z(08)9  VALUE SPACES.        
           05  WS-APPEND-COMMENT       PIC X(64)   VALUE SPACES.        
           05  WS-APPEND-COMMENT-LEN   PIC S9(4)   VALUE 0 COMP.        
COB305     05 WS-NAME-ID        PIC S9(13)V COMP-3 VALUE 0.        
           05  WS-MED-CODE             PIC X(02)   VALUE SPACES.        
           05  WS-SWITCH-DATE.                                          
               10  WS-YEAR             PIC X(04)               .        
               10  WS-D1               PIC X(01)   VALUE '-'   .        
               10  WS-MONTH            PIC X(02)               .        
               10  WS-D2               PIC X(01)   VALUE '-'   .        
               10  WS-DAY              PIC X(02)               .        
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03830'.      
      *                                                                         
       01  WS-MNT-TRANS-HIST.                                           
           05  WS-USERID               PIC X(08)   VALUE SPACES.        
           05  WS-CURRENT-DATE         PIC X(10)   VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP    PIC X(26)   VALUE SPACES.        
           05  WS-ACCOUNT-EXISTS       PIC X(01)   VALUE 'N'.           
           05  WS-TRANS-COMMENTS       PIC X(210)  VALUE SPACES.        
           05  WS-TRANS-COMMENTS-LEN   PIC S9(4)   VALUE 0 COMP.        
           05  WS-PANEL-NO             PIC X(09)   VALUE 'PANEL213'.    
           05  WS-RESP-AREA-ID         PIC X(03)   VALUE SPACES.        
COB305     05 WS-CUSTOMER-NO-COMP        PIC S9(10) COMP-3 VALUE 0.             
COB305     05 WS-PREMISE-NO-COMP        PIC S9(10) COMP-3 VALUE 0.              
      *                                                                         
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE       PIC X(01)   VALUE 'F'.           
           05  WS-TRAN-APPL-NO         PIC S9(02)  VALUE 0.             
           05  WS-TABLE-ID             PIC X(02).                       
           05  WS-COLUMN-DESC          PIC X(15).                       
           05  WS-CHG-COLUMN-VALUE-TEXT PIC X(30).                      
           05  WS-CHG-COLUMN-VALUE-LEN PIC S9(02).                      
           05  WS-PRV-COLUMN-VALUE-TEXT PIC X(30).                      
           05  WS-PRV-COLUMN-VALUE-LEN PIC S9(02).                      
      *                                                                         
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME              PIC X(18) VALUE SPACES.          
            10  S-SQLCODE              PIC S9(9) COMP VALUE 0.          
            10  S-SQLSTATE             PIC X(5)  VALUE ' '.             
            10  S-TABLE-NAME           PIC X(18) VALUE SPACES.          
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L PIC S9(4) USAGE COMP.            
                49  S-HOST-VARIABLES-V PIC X(255).                      
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L  PIC S9(4) USAGE COMP.            
                49  S-SQL-STATEMENT-V  PIC X(255).                      
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
      *                                                                         
       01  WS-END                      PIC X(40)                        
               VALUE 'WORKING STORAGE FOR CSR03830 ENDS HERE '.         
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LINK-APPLICATION-ID         PIC S9(9) USAGE COMP.            
       01  LINK-USER-ID                PIC X(08).                       
       01  LINK-COMMENT-LEN            PIC S9(04) USAGE COMP.           
       01  LINK-COMMENT                PIC X(210).                      
       01  LINK-NO-ROWS                PIC X(02).                       
       01  LINK-EQU-ROW1               PIC X(28).                       
       01  LINK-EQU-ROW2               PIC X(28).                       
       01  LINK-EQU-ROW3               PIC X(28).                       
       01  LINK-EQU-ROW4               PIC X(28).                       
       01  LINK-EQU-ROW5               PIC X(28).                       
       01  LINK-EQU-ROW6               PIC X(28).                       
       01  LINK-EQU-ROW7               PIC X(28).                       
       01  LINK-EQU-ROW8               PIC X(28).                       
       01  LINK-EQU-ROW9               PIC X(28).                       
       01  LINK-EQU-ROW10              PIC X(28).                       
      *                                                                         
       PROCEDURE DIVISION USING LINK-APPLICATION-ID,                    
                                LINK-USER-ID,                           
                                LINK-COMMENT-LEN,                       
                                LINK-COMMENT,                           
                                LINK-NO-ROWS,                           
                                LINK-EQU-ROW1,                          
                                LINK-EQU-ROW2,                          
                                LINK-EQU-ROW3,                          
                                LINK-EQU-ROW4,                          
                                LINK-EQU-ROW5,                          
                                LINK-EQU-ROW6,                          
                                LINK-EQU-ROW7,                          
                                LINK-EQU-ROW8,                          
                                LINK-EQU-ROW9,                          
                                LINK-EQU-ROW10.                         
      *                                                                         
      *****************************************************************         
      * 0000-MAINLINE                                                 *         
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                     *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT.                 
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                               *         
      *     1. RESET DB2 ERROR HANDLERS                               *         
      *     2. ESTABLISH RETURN CURSOR AND VARIABLES                  *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE                  DCLCSS-WH-CROSS-EQUIP            
                                       PARM-EQU-DATA.                   
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE              AS    RETURN_CODE             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-PROCESS-INPUT                                            *         
      *     1. RECEIVE PARMS.                                         *         
      *     2. CALCULATE NEEDED VARIABLES.                            *         
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                 TO   ACTIVE-PARAGRAPH.           
           MOVE LINK-APPLICATION-ID    TO   PARM-APP-ID                 
                                            WO-APPLICATION-ID           
                                            WL-APPLICATION-ID.          
           MOVE LINK-USER-ID           TO   PARM-USER-ID                
                                            PF-USER-ID                  
                                            WS-USERID.                  
           MOVE LINK-COMMENT-LEN       TO   PARM-COMMENT-LEN.           
           MOVE LINK-COMMENT           TO   PARM-COMMENT.               
           MOVE LINK-NO-ROWS           TO   PARM-NO-ROWS.               
      *                                                                         
           IF WS-NO-ROWS > ZERO                                         
              MOVE LINK-EQU-ROW1       TO  PARM-EQU-FIELDS(1)           
              MOVE LINK-EQU-ROW2       TO  PARM-EQU-FIELDS(2)           
              MOVE LINK-EQU-ROW3       TO  PARM-EQU-FIELDS(3)           
              MOVE LINK-EQU-ROW4       TO  PARM-EQU-FIELDS(4)           
              MOVE LINK-EQU-ROW5       TO  PARM-EQU-FIELDS(5)           
              MOVE LINK-EQU-ROW6       TO  PARM-EQU-FIELDS(6)           
              MOVE LINK-EQU-ROW7       TO  PARM-EQU-FIELDS(7)           
              MOVE LINK-EQU-ROW8       TO  PARM-EQU-FIELDS(8)           
              MOVE LINK-EQU-ROW9       TO  PARM-EQU-FIELDS(9)           
              MOVE LINK-EQU-ROW10      TO  PARM-EQU-FIELDS(10)          
           ELSE                                                         
              MOVE 9999                TO  S-RETURN-CODE                
              EXEC SQL                                                  
                   OPEN C1                                              
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GETS ALL THE REQUIRED INFO AND FORMATS RESULT SET.             *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                 TO ACTIVE-PARAGRAPH.             
           PERFORM 7100-GET-PF-RESP-AREA-ID THRU 7100-EXIT.             
           PERFORM 7200-GET-WO-ACCOUNT-NO   THRU 7200-EXIT.             
           MOVE    WO-NAME-ID          TO DQ-NAME-ID.                   
           MOVE    SPACES              TO DQ-FIRST-NAME                 
                                          DQ-MIDDLE-NAME                
                                          DQ-LAST-NAME.                 
           PERFORM 7210-GET-DQ-NAME         THRU 7210-EXIT.             
           PERFORM 7300-GET-CURRENT-DATE    THRU 7300-EXIT.             
      *                                                                         
           PERFORM VARYING EQ-INDX FROM 1 BY 1                          
                   UNTIL EQ-INDX > WS-NO-ROWS                           
               EVALUATE WS-PROCESS-CD(EQ-INDX)                          
                   WHEN 'C'                                             
                     PERFORM 2100-PROCESS-UPDATE THRU 2100-EXIT         
                   WHEN 'D'                                             
                     PERFORM 2200-PROCESS-DELETE THRU 2200-EXIT         
                   WHEN OTHER                                           
                        CONTINUE                                        
               END-EVALUATE                                             
           END-PERFORM.                                                 
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * UPDATE PROCESS.                                                *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-UPDATE.                                             
                                                                        
           MOVE '2100'                 TO ACTIVE-PARAGRAPH              
           MOVE WS-EQUIP-ID-NUM(EQ-INDX)                                
                                       TO  WL-EQUIPMENT-ID              
           MOVE WS-MED-EQUIP-CD(EQ-INDX)                                
                                       TO  WL-MEDICAL-EQUIP-CD          
           MOVE WS-BACKUP-HRS-NUM(EQ-INDX)                              
                                       TO  WL-WC-BACKUP-HOURS           
           MOVE WS-HRS-USED-NUM(EQ-INDX)                                
                                       TO  WL-EQU-DAILY-HRS-USED        
           IF WS-INACTIVE-DT(EQ-INDX) = WS-DT OR SPACES                 
              MOVE -1                  TO WS-NULL-INDICATOR             
              MOVE SPACES              TO WL-EQU-INACTIVE-DT            
           ELSE                                                         
              MOVE 0                   TO WS-NULL-INDICATOR             
              MOVE WS-INACTIVE-DT(EQ-INDX)                              
                                       TO  WL-EQU-INACTIVE-DT           
           END-IF                                                       
           IF WL-EQUIPMENT-ID > ZEROES                                  
              PERFORM 7400-ORIG-SELECT-WL   THRU 7400-EXIT              
              PERFORM 8200-UPDATE-WL        THRU 8200-EXIT              
              PERFORM 2400-JOURNAL-UPDATE-TRANS THRU 2400-EXIT          
           ELSE                                                         
              PERFORM 7000-GET-NEW-EQ-ID   THRU 7000-EXIT               
              PERFORM 8100-INSERT-WL       THRU 8100-EXIT               
              PERFORM 2300-JOURNAL-NEW-TRANS THRU 2300-EXIT             
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  DELETE PROCESS.                                               *        
      ******************************************************************        
       2200-PROCESS-DELETE.                                             
      *                                                                         
           MOVE '2200'                 TO ACTIVE-PARAGRAPH.             
           MOVE WS-EQUIP-ID-NUM(EQ-INDX)                                
                                       TO  WL-EQUIPMENT-ID.             
           PERFORM 7400-ORIG-SELECT-WL THRU 7400-EXIT.                  
           PERFORM 8300-DELETE-WL      THRU 8300-EXIT.                  
           PERFORM 2500-JOURNAL-DELETE-TRANS THRU 2500-EXIT.            
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2300-JOURNAL-NEW-TRANS                                      *        
      *    INSERT TRANS HIST FOR NEW EQUIPMENT ROWS                    *        
      ******************************************************************        
       2300-JOURNAL-NEW-TRANS.                                          
                                                                        
           MOVE SPACES                 TO WS-TABLE-ID                   
           ADD +1                      TO WS-TRAN-APPL-NO               
           MOVE 'MED EQUIPMENT  '      TO WS-COLUMN-DESC                
           MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT      
           MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN       
           MOVE SPACES                 TO M0-MEDICAL-EQUIP-DESC-TEXT    
           MOVE WL-MEDICAL-EQUIP-CD    TO WS-MED-CODE                   
           PERFORM 7220-GET-MO-EQUIP-DESC  THRU 7220-EXIT               
           MOVE M0-MEDICAL-EQUIP-DESC-TEXT TO                           
                                           WS-CHG-COLUMN-VALUE-TEXT     
           MOVE 30                         TO WS-CHG-COLUMN-VALUE-LEN   
           PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT          
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
      *                                                                         
           MOVE SPACES                 TO WS-TABLE-ID                   
           ADD +1                      TO WS-TRAN-APPL-NO               
           MOVE 'EQ BACKUP HOURS'      TO WS-COLUMN-DESC                
           MOVE  '*NEW*'               TO WS-PRV-COLUMN-VALUE-TEXT      
           MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN       
           MOVE WL-WC-BACKUP-HOURS     TO WS-CHG-COLUMN-VALUE-TEXT      
           MOVE 3                      TO WS-CHG-COLUMN-VALUE-LEN       
           PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT          
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
      *                                                                         
           ADD +1                      TO WS-TRAN-APPL-NO               
           MOVE 'DAILY HRS USED '      TO WS-COLUMN-DESC                
           MOVE  '*NEW*'               TO WS-PRV-COLUMN-VALUE-TEXT      
           MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN       
           MOVE WL-EQU-DAILY-HRS-USED  TO WS-CHG-COLUMN-VALUE-TEXT      
           MOVE 3                      TO WS-CHG-COLUMN-VALUE-LEN       
           PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT          
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
      *                                                                         
           IF WL-EQU-INACTIVE-DT NOT EQUAL SPACES                       
           ADD +1                      TO WS-TRAN-APPL-NO               
           MOVE 'EQU INACTIVE DT'      TO WS-COLUMN-DESC                
           MOVE  '*NEW*'               TO WS-PRV-COLUMN-VALUE-TEXT      
           MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN       
           MOVE WL-EQU-INACTIVE-DT     TO WS-CHG-COLUMN-VALUE-TEXT      
           MOVE 10                     TO WS-CHG-COLUMN-VALUE-LEN       
           PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT          
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2400-JOURNAL-UPDATE-TRANS                                   *        
      *    WRITE TRANS HIST FOR CHANGED ROWS IN WL                     *        
      ******************************************************************        
       2400-JOURNAL-UPDATE-TRANS.                                       
                                                                        
           MOVE SPACES                 TO WS-TABLE-ID                   
           IF  WL-MEDICAL-EQUIP-CD = WS-DB-MEDICAL-EQUIP-CD             
               ADD +1                  TO WS-TRAN-APPL-NO               
               MOVE SPACES             TO                               
                                          M0-MEDICAL-EQUIP-DESC-TEXT    
               MOVE WS-DB-MEDICAL-EQUIP-CD TO WS-MED-CODE               
               PERFORM 7220-GET-MO-EQUIP-DESC THRU 7220-EXIT            
               MOVE M0-MEDICAL-EQUIP-DESC-TEXT TO WS-COLUMN-DESC        
               MOVE SPACES                TO WS-PRV-COLUMN-VALUE-TEXT   
               MOVE ZEROS                 TO WS-PRV-COLUMN-VALUE-LEN    
               MOVE SPACES                TO WS-CHG-COLUMN-VALUE-TEXT   
               MOVE ZEROS                 TO WS-CHG-COLUMN-VALUE-LEN    
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
           ELSE                                                         
               ADD +1                     TO WS-TRAN-APPL-NO            
               MOVE 'MED EQUIPMENT  '     TO WS-COLUMN-DESC             
               MOVE SPACES                TO                            
                                             M0-MEDICAL-EQUIP-DESC-TEXT 
               MOVE WS-DB-MEDICAL-EQUIP-CD TO WS-MED-CODE               
               PERFORM 7220-GET-MO-EQUIP-DESC THRU 7220-EXIT            
               MOVE M0-MEDICAL-EQUIP-DESC-TEXT TO                       
                                             WS-PRV-COLUMN-VALUE-TEXT   
               MOVE 30                    TO WS-PRV-COLUMN-VALUE-LEN    
               MOVE SPACES                TO M0-MEDICAL-EQUIP-DESC-TEXT 
               MOVE WL-MEDICAL-EQUIP-CD   TO WS-MED-CODE                
               PERFORM 7220-GET-MO-EQUIP-DESC THRU 7220-EXIT            
               MOVE M0-MEDICAL-EQUIP-DESC-TEXT TO                       
                                             WS-CHG-COLUMN-VALUE-TEXT   
               MOVE 30                    TO WS-CHG-COLUMN-VALUE-LEN    
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
           END-IF                                                       
      *                                                                         
           MOVE SPACES                     TO WS-TABLE-ID               
           IF  WL-WC-BACKUP-HOURS = WS-DB-WC-BACKUP-HOURS               
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                      TO WS-TRAN-APPL-NO           
               MOVE 'EQ BACKUP HOURS'      TO WS-COLUMN-DESC            
               MOVE WS-DB-WC-BACKUP-HOURS  TO WS-PRV-COLUMN-VALUE-TEXT  
               MOVE 3                      TO WS-PRV-COLUMN-VALUE-LEN   
               MOVE WL-WC-BACKUP-HOURS     TO WS-CHG-COLUMN-VALUE-TEXT  
               MOVE 3                      TO WS-CHG-COLUMN-VALUE-LEN   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
           END-IF                                                       
      *                                                                         
           IF  WL-EQU-DAILY-HRS-USED = WS-DB-EQU-DAILY-HRS-USED         
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                      TO WS-TRAN-APPL-NO           
               MOVE 'DAILY HRS USED '      TO WS-COLUMN-DESC            
               MOVE WS-DB-EQU-DAILY-HRS-USED                            
                                           TO WS-PRV-COLUMN-VALUE-TEXT  
               MOVE 3                      TO WS-PRV-COLUMN-VALUE-LEN   
               MOVE WL-EQU-DAILY-HRS-USED  TO WS-CHG-COLUMN-VALUE-TEXT  
               MOVE 3                      TO WS-CHG-COLUMN-VALUE-LEN   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
           END-IF                                                       
      *                                                                         
           IF  WL-EQU-INACTIVE-DT = WS-DB-EQU-INACTIVE-DT               
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                      TO WS-TRAN-APPL-NO           
               MOVE 'EQU INACTIVE DT'      TO WS-COLUMN-DESC            
               MOVE WS-DB-EQU-INACTIVE-DT                               
                                           TO WS-PRV-COLUMN-VALUE-TEXT  
               MOVE 10                     TO WS-PRV-COLUMN-VALUE-LEN   
               MOVE WL-EQU-INACTIVE-DT     TO WS-CHG-COLUMN-VALUE-TEXT  
               MOVE 10                     TO WS-CHG-COLUMN-VALUE-LEN   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    2500-JOURNAL-DELETE-TRANS                                   *        
      *    WRITE TRANS HIST FOR DELETED ROWS FROM WL                   *        
      ******************************************************************        
       2500-JOURNAL-DELETE-TRANS.                                       
                                                                        
           MOVE SPACES                 TO WS-TABLE-ID                   
           ADD +1                      TO WS-TRAN-APPL-NO               
           MOVE 'MED EQUIPMENT  '      TO WS-COLUMN-DESC                
           MOVE SPACES                 TO M0-MEDICAL-EQUIP-DESC-TEXT    
           MOVE WS-DB-MEDICAL-EQUIP-CD TO WS-MED-CODE                   
           PERFORM 7220-GET-MO-EQUIP-DESC THRU 7220-EXIT                
           MOVE M0-MEDICAL-EQUIP-DESC-TEXT TO                           
                                          WS-PRV-COLUMN-VALUE-TEXT      
           MOVE 30                     TO WS-PRV-COLUMN-VALUE-LEN       
           MOVE  '*DELETED*'           TO WS-CHG-COLUMN-VALUE-TEXT      
           MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN       
           PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT          
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
      *                                                                         
           MOVE SPACES                 TO WS-TABLE-ID                   
           ADD +1                      TO WS-TRAN-APPL-NO               
           MOVE 'EQ BACKUP HOURS'      TO WS-COLUMN-DESC                
           MOVE WS-DB-WC-BACKUP-HOURS  TO WS-PRV-COLUMN-VALUE-TEXT      
           MOVE 3                      TO WS-PRV-COLUMN-VALUE-LEN       
           MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT      
           MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN       
           PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT          
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
      *                                                                         
           ADD +1                      TO WS-TRAN-APPL-NO               
           MOVE 'DAILY HRS USED '      TO WS-COLUMN-DESC                
           MOVE WS-DB-EQU-DAILY-HRS-USED TO WS-PRV-COLUMN-VALUE-TEXT    
           MOVE 3                      TO WS-PRV-COLUMN-VALUE-LEN       
           MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT      
           MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN       
           PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT          
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
      *                                                                         
           IF WS-DB-EQU-INACTIVE-DT NOT EQUAL SPACES                    
           ADD +1                      TO WS-TRAN-APPL-NO               
           MOVE 'EQU INACTIVE DT'      TO WS-COLUMN-DESC                
           MOVE WS-DB-EQU-INACTIVE-DT  TO WS-PRV-COLUMN-VALUE-TEXT      
           MOVE 10                     TO WS-PRV-COLUMN-VALUE-LEN       
           MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT      
           MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN       
           PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT          
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
            MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5950-SET-MNT-TRANS-VARS                                        *        
      *      -- THIS MODULE SETS UP HOST VARIABLES TO INSERT THE       *        
      *         CSS_MNT_TRANS_HIST & CSS_MT_TRN_HST_DET TABLES TO      *        
      *         WRITE MAINTENANCE TRANSACTION RECORDS.                 *        
      ******************************************************************        
       5950-SET-MNT-TRANS-VARS.                                         
                                                                        
           MOVE '5950'                      TO ACTIVE-PARAGRAPH.        
           IF  WS-TRAN-APPL-NO = 1                                      
      *                                                                         
               PERFORM 7300-GET-CURRENT-DATE   THRU 7300-EXIT           
               MOVE 'PANEL213'                  TO MH-APPL-PROGRAM-ID   
               MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO 
               MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS        
               MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE    
               MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID      
               MOVE WO-ACCOUNT-NO               TO MH-ACCOUNT-NO        
               MOVE 0                           TO MH-CUSTOMER-NO       
               MOVE 0                           TO MH-PREMISE-NO        
               MOVE WS-USERID                   TO MH-USER-ID           
      *                                                                         
               MOVE WO-APPLICATION-ID  TO WS-APPLICATION-ID             
                 STRING 'APPLICATION ID:' DELIMITED BY SIZE             
                        WS-APPLICATION-ID DELIMITED BY SIZE             
                         '-'              DELIMITED BY SIZE             
                         DQ-LAST-NAME     DELIMITED BY SIZE             
                            ','           DELIMITED BY SIZE             
                         ' '              DELIMITED BY SIZE             
                        DQ-FIRST-NAME     DELIMITED BY SIZE             
                        ':!'              DELIMITED BY SIZE             
                   INTO WS-APPEND-COMMENT                               
               MOVE +64                TO WS-APPEND-COMMENT-LEN         
               MOVE SPACES             TO WS-EMB-INPUT,                 
                                          WS-CMP-TABLE                  
               MOVE 64                 TO WS-EMB-LENG                   
               MOVE WS-APPEND-COMMENT  TO WS-EMB-INPUT                  
               PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT       
               MOVE WS-CMP-TABLE       TO WS-APPEND-COMMENT             
               MOVE LENGTH OF WS-APPEND-COMMENT                         
                                       TO WS-APPEND-COMMENT-LEN         
      *                                                                         
              IF PARM-COMMENT-LEN > ZEROES                              
                 STRING WS-APPEND-COMMENT DELIMITED BY '!'              
                        PARM-COMMENT DELIMITED BY SIZE                  
                   INTO MH-TRAN-COMMENT-TEXT                            
                 MOVE PARM-COMMENT-LEN        TO MH-TRAN-COMMENT-LEN    
                 ADD WS-APPEND-COMMENT-LEN    TO MH-TRAN-COMMENT-LEN    
              ELSE                                                      
                 MOVE WS-APPEND-COMMENT       TO MH-TRAN-COMMENT-TEXT   
                 MOVE WS-APPEND-COMMENT-LEN   TO MH-TRAN-COMMENT-LEN    
              END-IF                                                    
           END-IF                                                       
           MOVE WS-TABLE-ID              TO MI-TABLE-ID.                
           MOVE WS-COLUMN-DESC           TO MI-COLUMN-DESC.             
           MOVE WS-CURRENT-TIMESTAMP     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE WS-PRV-COLUMN-VALUE-TEXT TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE WS-PRV-COLUMN-VALUE-LEN  TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE WS-CHG-COLUMN-VALUE-TEXT TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE WS-CHG-COLUMN-VALUE-LEN  TO MI-CHG-COLUMN-VALUE-LEN.    
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REDUCE-EMBEDDED SPACES                                        *        
      ******************************************************************        
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
HPCCDM*EJECT                                                                    
      ****************************************************************          
      * 7000-GET-NEW-EQ-ID                                           *          
      * GENERATES THE ID FOR THE NEW EQUIPMENT.                      *          
      ****************************************************************          
       7000-GET-NEW-EQ-ID.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT
              NEXT VALUE FOR SEQ_WL_EQUIPMENT_ID
            INTO
              :WL-EQUIPMENT-ID                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WL-EQUIPMENT-ID                                            
MFA-TR*            = NEXTVAL FOR SEQ_WL_EQUIPMENT_ID                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE '7000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'CSR03830'                TO ABEND-PROGRAM          
               MOVE 'NEXTVAL'                 TO ABEND-FUNCTION         
               MOVE 'SEQ OBJECT'              TO TABLE-1                
               MOVE 'SEQ_WL_EQUIPMENT_ID'     TO TABLE-ELEMENT-1        
               MOVE  SPACES                   TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-PF-RESP-AREA-ID                                       *        
      *      -- THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION  *        
      *         ACCORDING TO A USERS ID.                               *        
      ******************************************************************        
       7100-GET-PF-RESP-AREA-ID.                                        
                                                                        
           MOVE '7100'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           MOVE WS-USERID              TO PF-USER-ID                    
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE                                  
                WHERE USER_ID = :PF-USER-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_USER_PROFILE  '       TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE WS-USERID                  TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
                                                                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7200-GET-WO-ACCOUNT-NO                                       *          
      * GET THE ACCOUNT NO FROM CSS_WH_CROSS_PLUS                    *          
      ****************************************************************          
       7200-GET-WO-ACCOUNT-NO.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT ACCOUNT_NO                                       
                      ,NAME_ID                                          
                  INTO :WO-ACCOUNT-NO                                   
                      ,:WO-NAME-ID                                      
                  FROM CSS_WH_CROSS_PLUS WITH(READUNCOMMITTED)                  
                 WHERE APPLICATION_ID = :WO-APPLICATION-ID              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ACCOUNT_NO                                               
MFA-TR*               ,NAME_ID                                                  
MFA-TR*           INTO :WO-ACCOUNT-NO                                           
MFA-TR*               ,:WO-NAME-ID                                              
MFA-TR*           FROM CSS_WH_CROSS_PLUS                                        
MFA-TR*          WHERE APPLICATION_ID = :WO-APPLICATION-ID                      
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE '7200'                    TO ACTIVE-PARAGRAPH       
               MOVE 'CSR03830'                TO ABEND-PROGRAM          
               MOVE 'SELECT '                 TO ABEND-FUNCTION         
               MOVE 'CSS_WH_CROSS_PLUS'       TO TABLE-1                
               MOVE 'APPLICATION_ID'          TO TABLE-ELEMENT-1        
               MOVE  WO-APPLICATION-ID        TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7210-GET-DQ-NAME                                             *          
      * GET THE FIRST, LAST NAME FROM CSS_NAME                       *          
      ****************************************************************          
       7210-GET-DQ-NAME.                                                
      *                                                                         
           EXEC SQL                                                     
               SELECT  FIRST_NAME                                       
                      ,MIDDLE_NAME                                      
                      ,LAST_NAME                                        
                      ,TITLE_PREFIX                                     
                      ,TITLE_SUFFIX_1                                   
                 INTO :DQ-FIRST-NAME                                    
                     ,:DQ-MIDDLE-NAME                                   
                     ,:DQ-LAST-NAME                                     
                 FROM CSS_NAME WITH(READUNCOMMITTED)                            
                WHERE NAME_ID = :DQ-NAME-ID                             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  FIRST_NAME                                               
MFA-TR*               ,MIDDLE_NAME                                              
MFA-TR*               ,LAST_NAME                                                
MFA-TR*               ,TITLE_PREFIX                                             
MFA-TR*               ,TITLE_SUFFIX_1                                           
MFA-TR*          INTO :DQ-FIRST-NAME                                            
MFA-TR*              ,:DQ-MIDDLE-NAME                                           
MFA-TR*              ,:DQ-LAST-NAME                                             
MFA-TR*          FROM CSS_NAME                                                  
MFA-TR*         WHERE NAME_ID = :DQ-NAME-ID                                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                                     OR NOT-FOUND                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE '7210'                    TO ACTIVE-PARAGRAPH       
               MOVE 'CSR03830'                TO ABEND-PROGRAM          
               MOVE 'SELECT '                 TO ABEND-FUNCTION         
               MOVE 'CSS_NAME'                TO TABLE-1                
               MOVE 'NAME-ID'                 TO TABLE-ELEMENT-1        
               MOVE  DQ-NAME-ID               TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                              *          
      * 7220-GET-MO-EQUIP-DESC                                       *          
      *                                                              *          
      * GET THE MEDICAL EQUIPMENT DESC FROM CSS_MEDICAL_EQUIP TABLE  *          
      ****************************************************************          
       7220-GET-MO-EQUIP-DESC.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                     MEDICAL_EQUIP_DESC                                 
                INTO                                                    
                     :M0-MEDICAL-EQUIP-DESC                             
                FROM                                                    
                     CSS_MEDICAL_EQUIP WITH(READUNCOMMITTED)                    
                WHERE                                                   
                     MEDICAL_EQUIP_CD = :WS-MED-CODE                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*              MEDICAL_EQUIP_DESC                                         
MFA-TR*         INTO                                                            
MFA-TR*              :M0-MEDICAL-EQUIP-DESC                                     
MFA-TR*         FROM                                                            
MFA-TR*              CSS_MEDICAL_EQUIP                                          
MFA-TR*         WHERE                                                           
MFA-TR*              MEDICAL_EQUIP_CD = :WS-MED-CODE                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                                      OR NOT-FOUND                      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE '7220'                    TO ACTIVE-PARAGRAPH       
               MOVE 'CSR03830'                TO ABEND-PROGRAM          
               MOVE 'SELECT '                 TO ABEND-FUNCTION         
               MOVE 'CSS_MEDICAL_EQUIP'       TO TABLE-1                
               MOVE 'MEDICAL_EQUIP_CD'        TO TABLE-ELEMENT-1        
               MOVE  WS-MED-CODE              TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-CURRENT-DATE                                          *        
      *      --THIS MODULE DETERMINES THE CURRENT DATE  FOR THE        *        
      *        MAINTENANCE TRANSACTION RECORD.                         *        
      ******************************************************************        
      *                                                                         
       7300-GET-CURRENT-DATE.                                           
                                                                        
           MOVE '7300'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE                            
MFA-TR*             ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT
           END-IF.     
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7400-ORIG-SELECT-WL                                          *          
      * SELECT EXISTING VALUES FROM CSS_WH_CROSS_EQUIP               *          
      ****************************************************************          
      *                                                                         
       7400-ORIG-SELECT-WL.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                     MEDICAL_EQUIP_CD                                   
                    ,WC_BACKUP_HOURS                                    
                    ,EQU_DAILY_HRS_USED                                 
                    ,EQU_INACTIVE_DT                                    
                INTO                                                    
                    :WS-DB-MEDICAL-EQUIP-CD                             
                   ,:WS-DB-WC-BACKUP-HOURS                              
                   ,:WS-DB-EQU-DAILY-HRS-USED                           
                   ,:WS-DB-EQU-INACTIVE-DT :WS-WL-NULL-IND               
               FROM CSS_WH_CROSS_EQUIP                                  
               WHERE                                                    
                    APPLICATION_ID      =  :WL-APPLICATION-ID           
                AND EQUIPMENT_ID        =  :WL-EQUIPMENT-ID             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-WL-NULL-IND < 0                                     
                 MOVE SPACES                   TO WS-DB-EQU-INACTIVE-DT 
              END-IF                                                    
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7400'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_WH_CROSS_EQUIP'       TO TABLE-1               
               MOVE 'APPLICATION_ID'           TO TABLE-ELEMENT-1       
               MOVE 'EQUIPMENT_ID'             TO TABLE-ELEMENT-2       
               MOVE WL-APPLICATION-ID          TO HOSTVAR-ELEMENT-1     
               MOVE WL-EQUIPMENT-ID            TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8100-INSERT-WL                                               *          
      *     INSERT ROW INTO CSS_WH_CROSS_EQUIP                       *          
      ****************************************************************          
       8100-INSERT-WL.                                                  
      *                                                                         
           EXEC SQL                                                     
               INSERT                                                   
                 INTO CSS_WH_CROSS_EQUIP                                
                      (APPLICATION_ID                                   
                      ,EQUIPMENT_ID                                     
                      ,MEDICAL_EQUIP_CD                                 
                      ,WC_BACKUP_HOURS                                  
                      ,EQU_DAILY_HRS_USED                               
                      ,EQU_INACTIVE_DT)                                 
               VALUES                                                   
                      (:WL-APPLICATION-ID                               
                      ,:WL-EQUIPMENT-ID                                 
                      ,:WL-MEDICAL-EQUIP-CD                             
                      ,:WL-WC-BACKUP-HOURS                              
                      ,:WL-EQU-DAILY-HRS-USED                           
                      ,IIF(TRY_CONVERT(DATE, :WL-EQU-INACTIVE-DT 
                                             :WS-NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :WL-EQU-INACTIVE-DT 
                                                     :WS-NULL-INDICATOR
              ) <> 0) OR (LEN(:WL-EQU-INACTIVE-DT :WS-NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:WL-EQU-INACTIVE-DT 
                                                     :WS-NULL-INDICATOR
              ), CONVERT(DATE, :WL-EQU-INACTIVE-DT :WS-NULL-INDICATOR
              ) ))           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT                                                           
MFA-TR*          INTO CSS_WH_CROSS_EQUIP                                        
MFA-TR*               (APPLICATION_ID                                           
MFA-TR*               ,EQUIPMENT_ID                                             
MFA-TR*               ,MEDICAL_EQUIP_CD                                         
MFA-TR*               ,WC_BACKUP_HOURS                                          
MFA-TR*               ,EQU_DAILY_HRS_USED                                       
MFA-TR*               ,EQU_INACTIVE_DT)                                         
MFA-TR*        VALUES                                                           
MFA-TR*               (:WL-APPLICATION-ID                                       
MFA-TR*               ,:WL-EQUIPMENT-ID                                         
MFA-TR*               ,:WL-MEDICAL-EQUIP-CD                                     
MFA-TR*               ,:WL-WC-BACKUP-HOURS                                      
MFA-TR*               ,:WL-EQU-DAILY-HRS-USED                                   
MFA-TR*               ,:WL-EQU-INACTIVE-DT:WS-NULL-INDICATOR)                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_WH_CROSS_EQUIP'      TO TABLE-1                 
              MOVE 'APPLICATION_ID'          TO TABLE-ELEMENT-1         
              MOVE 'EQUIPMENT_ID'            TO TABLE-ELEMENT-2         
              MOVE WL-APPLICATION-ID         TO HOSTVAR-ELEMENT-1       
              MOVE WL-EQUIPMENT-ID           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8200-UPDATE-WL                                               *          
      *     UPDATE ROW IN CSS_WH_CROSS_EQUIP                         *          
      ****************************************************************          
       8200-UPDATE-WL.                                                  
      *                                                                         
           EXEC SQL                                                     
                UPDATE                                                  
                       CSS_WH_CROSS_EQUIP                               
                   SET                                                  
                        MEDICAL_EQUIP_CD   =  :WL-MEDICAL-EQUIP-CD      
                       ,WC_BACKUP_HOURS    =  :WL-WC-BACKUP-HOURS       
                       ,EQU_DAILY_HRS_USED =  :WL-EQU-DAILY-HRS-USED    
                       ,EQU_INACTIVE_DT    =  IIF(TRY_CONVERT(DATE, 
                                                   :WL-EQU-INACTIVE-DT 
                                                     :WS-NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :WL-EQU-INACTIVE-DT 
                                                     :WS-NULL-INDICATOR
              ) <> 0) OR (LEN(:WL-EQU-INACTIVE-DT :WS-NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:WL-EQU-INACTIVE-DT 
                                                     :WS-NULL-INDICATOR
              ), CONVERT(DATE, :WL-EQU-INACTIVE-DT :WS-NULL-INDICATOR
              ) )        
                 WHERE                                                  
                       APPLICATION_ID      =  :WL-APPLICATION-ID        
                   AND EQUIPMENT_ID        =  :WL-EQUIPMENT-ID          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE                                                          
MFA-TR*                CSS_WH_CROSS_EQUIP                                       
MFA-TR*            SET                                                          
MFA-TR*                 MEDICAL_EQUIP_CD   =  :WL-MEDICAL-EQUIP-CD              
MFA-TR*                ,WC_BACKUP_HOURS    =  :WL-WC-BACKUP-HOURS               
MFA-TR*                ,EQU_DAILY_HRS_USED =  :WL-EQU-DAILY-HRS-USED            
MFA-TR*                ,EQU_INACTIVE_DT    =  :WL-EQU-INACTIVE-DT               
MFA-TR*                                       :WS-NULL-INDICATOR                
MFA-TR*          WHERE                                                          
MFA-TR*                APPLICATION_ID      =  :WL-APPLICATION-ID                
MFA-TR*            AND EQUIPMENT_ID        =  :WL-EQUIPMENT-ID                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '8200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'UPDATE'                   TO ABEND-FUNCTION        
               MOVE 'CSS_WH_CROSS_EQUIP'       TO TABLE-1               
               MOVE 'APPLICATION_ID'           TO TABLE-ELEMENT-1       
               MOVE 'EQUIPMENT_ID'             TO TABLE-ELEMENT-2       
               MOVE 'MEDICAL_EQUIP_CD'         TO TABLE-ELEMENT-3       
               MOVE WL-APPLICATION-ID          TO HOSTVAR-ELEMENT-1     
               MOVE WL-EQUIPMENT-ID            TO HOSTVAR-ELEMENT-2     
               MOVE WL-MEDICAL-EQUIP-CD        TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8300-DELETE-WL                                               *          
      *     DELETE RECORD FROM CSS_WH_CROSS_EQUIP.                   *          
      ****************************************************************          
       8300-DELETE-WL.                                                  
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM                                             
                       CSS_WH_CROSS_EQUIP                               
                 WHERE                                                  
                       EQUIPMENT_ID   =  :WL-EQUIPMENT-ID               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '8300'                     TO ACTIVE-PARAGRAPH      
               MOVE 'DELETE'                   TO ABEND-FUNCTION        
               MOVE 'CSS_WH_CROSS_EQUIP'       TO TABLE-1               
               MOVE 'EQUIPMENT_ID'             TO TABLE-ELEMENT-1       
               MOVE ' '                        TO TABLE-ELEMENT-2       
               MOVE ' '                        TO TABLE-ELEMENT-3       
               MOVE WL-EQUIPMENT-ID            TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * 8900-SEND-DONE.                                                         
      * 9000-SEND-ERROR-RESULT.                                                 
      * 9999-END-PROGRAM.                                                       
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      * 9900-SQL-ERROR-ROUTINE.                                                 
      * 9975-ABEND-CONTROL-TRANSFER.                                            
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
