       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR03828.                                      
COB303 DATE-WRITTEN.     FEB  19, 2007.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS CALLED FROM PANEL212 WHITE CROSS PLUS       *        
      *  PANEL TO GENERATE WHITE CROSS PLUS INFORMATION FOR NEW ACCOUNT*        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/19/07    CVNS       INITIALLY CODED FOR CML 32547          *        
      *             CHENNAI/                                           *        
      *             SS82048                                                     
A01849*  01/05/10   VV94890   1)FIX TO HANDLE UP TO 30 CHARS FOR HEALTH*        
      *                         CARE PROVIDER STREET NAME, 15 CHARS FOR*        
      *                         HOUSE NO AND 11 CHARS FOR STREET LOCATI*        
      *                         ON 2 ENTERED ON ADDRESS PANEL 205.     *        
      *                       2)FIX TO HANDLE UP TO 40 CHARS FOR HEALTH*        
      *                         CARE PROVIDER & PATIENT LAST NAME ON   *        
      *                         PANEL212.                              *        
A04527*  06/07/13    AS7C117  REMOVE UNUSED COPYBOOK CWS00056.         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03828'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03828 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * WO - CSS_WH_CROSS_PLUS   *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBWCPLUS                                                 
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * WP - CSS_WH_CROSS_PATNT  *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBWCPPAT                                                 
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * WJ - CSS_WH_CROSS_SSN    *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBWCPSSN                                                 
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * PY - CSS_PHYSICIAN       *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBPHYSN                                                  
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * PA - CSS_PHYSICIAN_ATTR  *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBPHYADD                                                 
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * DQ - CSS_NAME            *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * DY - CSS_ADDR_FORMATTED  *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * MH - CSS_MNT_TRANS_HIST  *                                              
      ****************************                                              
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      ****************************                                              
      * MH - CSS_MT_TRN_HST_DET  *                                              
      ****************************                                              
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * CL - CSS_CRED_COLL       *                                              
      ****************************                                              
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * C8 - CSS_DELINQUENCY     *                                              
      ****************************                                              
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * AT - CSS_ACCOUNT         *                                              
      ****************************                                              
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * I8 - CSS_ADDR_ID_CNTL    *                                              
      ****************************                                              
           EXEC SQL                                                             
              INCLUDE TBADDRID                                                  
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * I7 - CSS_NAME_ID_CNTL    *                                              
      ****************************                                              
           EXEC SQL                                                             
              INCLUDE TBNAMEID                                                  
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * I6 - CSS_CNTCT_ID_CNTL   *                                              
      ****************************                                              
           EXEC SQL                                                             
              INCLUDE TBCNTCID                                                  
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * PF - CSS_USER_PROFILE    *                                              
      ****************************                                              
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      ****************************                                              
      * WH - CSS_ACCT_WHT_CROSS  *                                              
      ****************************                                              
           EXEC SQL                                                             
              INCLUDE TBWCACCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
                                                                        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      ******* WS FOR 6010-REDUCE-EMBEDDED SPACES ****************               
       COPY CWS00011.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0090A                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0091A                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0092A                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                     22990809
              INCLUDE CWS00071                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0013A                                                  
           END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
                                                                        
       01  WS-MISC.                                                     
           05 WS-SSN                   PIC X(09)  VALUE SPACES.         
           05 WS-APPLICATION-ID        PIC Z(08)9 VALUE SPACES.         
           05 WS-ADDRESS-ID            PIC S9(13)V COMP-3 VALUE 0.      
           05 WS-NEW-CRIT-OUTAGE       PIC X(02)  VALUE SPACES.         
           05 WS-EXACT-MATCH           PIC X(01) VALUE 'N'.             
              88  EXACT-MATCH          VALUE 'Y'.                       
           05 WS-PHYSICIAN-UPDATE      PIC X(01) VALUE 'N'.             
              88  PHYSICIAN-UPDATE     VALUE 'Y'.                       
           05 WS-PHYS-ATTR-UPDATE      PIC X(01) VALUE 'N'.             
              88  PHYS-ATTR-UPDATE     VALUE 'Y'.                       
           05 WS-PHY-ADDR-UPDT         PIC X(01) VALUE 'N'.             
              88  PHY-ADDR-UPDT        VALUE 'Y'.                       
           05 WS-DEL-DUMMY-ADDR        PIC X(01) VALUE 'N'.             
              88  DEL-DUMMY-ADDR       VALUE 'Y'.                       
           05 WS-PATIENT-NAME-UPDT     PIC X(01) VALUE 'N'.             
              88  PATIENT-NAME-UPDT    VALUE 'Y'.                       
           05 WS-PTNT-UPDT             PIC X(01) VALUE 'N'.             
              88  PTNT-UPDT            VALUE 'Y'.                       
           05 WS-PHY-NAME-UPDT         PIC X(01) VALUE 'N'.             
              88  PHY-NAME-UPDT        VALUE 'Y'.                       
           05 WS-WCP-UPDT              PIC X(01) VALUE 'N'.             
              88  WH-CR-PL-UPDT        VALUE 'Y'.                       
           05 WS-PTNT-SSN-UPDT         PIC X(01) VALUE 'N'.             
              88  PTNT-SSN-UPDT        VALUE 'Y'.                       
           05 WS-STATUS-UPDT           PIC X(01) VALUE 'N'.             
              88  STATUS-UPDT          VALUE 'Y'.                       
           05  WS-WHITE-CROSS-FLAG     PIC X(01) VALUE 'N'.             
              88  WS-WC-EXISTS                   VALUE 'Y'.             
           05  WS-WCP-FLAG             PIC X(01) VALUE 'N'.             
              88  WS-WCP-EXISTS                  VALUE 'Y'.             
           05  WS-NEW-PHYSICIAN-FL     PIC X(01) VALUE SPACES.          
              88  NEW-PHYSICIAN                  VALUE 'Y'.             
           05  WS-DEL-PHYSICIAN-FL     PIC X(01) VALUE SPACES.          
              88  DEL-PHYSICIAN                  VALUE 'Y'.             
           05  WS-JOURNAL-ADDRESS      PIC X(01) VALUE SPACES.          
               88 JOURNAL-ADDRESS                VALUE 'Y'.             
           05  WS-JOURNAL-PHY-CONTACT  PIC X(01) VALUE SPACES.          
               88 JOURNAL-PHY-CONTACT            VALUE 'Y'.             
           05  WS-JOURNAL-LIC-STATE    PIC X(01) VALUE SPACES.          
               88 JOURNAL-LIC-STATE              VALUE 'Y'.             
           05  WS-JOURNAL-LICENSE-NO   PIC X(01) VALUE SPACES.          
               88 JOURNAL-LICENSE-NO             VALUE 'Y'.             
           05  WS-DELETE-DNP-FL        PIC X(01) VALUE 'N'.             
           05  WS-END-OF-ROWS          PIC X(01) VALUE 'N'.             
               88  END-OF-ROWS                   VALUE 'Y'.             
COB305     05 WS-NAME-ID        PIC S9(13)V COMP-3 VALUE 0.              
           05 WS-DEL-PHYSICIAN-ID      PIC S9(9) USAGE COMP.            
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                 
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.            
           05  WS-COMMENTS             PIC X(255).                      
           05  WS-SELECT-RETURN-CODE   PIC S9(9) COMP.                  
           05  WS-NULL-IND-EFF         PIC S9(4) COMP  VALUE 0.         
           05  WS-NULL-IND-EXP         PIC S9(4) COMP  VALUE 0.         
           05  WS-NULL-IND-DOB         PIC S9(4) COMP  VALUE 0.         
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03828'.      
           05  WS-SQLSTATE             PIC X(5).                        
           05  WS-ADDRESS.                                              
               10  WS-ADDRESS-X        OCCURS 50 TIMES                  
                                       INDEXED BY WS-ADD-SUB.           
                   15  FILLER          PIC X.                           
           05  WS-ADD-SUB-CNT          PIC 99 VALUE 1.                  
           05  WS-LENGTH               PIC S9(4).                       
           05  WS-MAX-SZ               PIC S9(4).                       
           05  WS-PHY-SUFFIX           PIC X(03) VALUE SPACES.          
           05  WS-PHY-PREFIX           PIC X(09) VALUE SPACES.          
           05  WS-PHY-FIRST-NAME       PIC X(15) VALUE SPACES.          
           05  WS-PHY-MIDDLE-NAME      PIC X(15) VALUE SPACES.          
A01849     05  WS-PHY-LAST-NAME        PIC X(40) VALUE SPACES.          
           05  WS-PTNT-SUFFIX          PIC X(03) VALUE SPACES.          
           05  WS-PTNT-PREFIX          PIC X(09) VALUE SPACES.          
           05  WS-PTNT-FIRST-NAME      PIC X(15) VALUE SPACES.          
           05  WS-PTNT-MIDDLE-NAME     PIC X(15) VALUE SPACES.          
A01849     05  WS-PTNT-LAST-NAME       PIC X(40) VALUE SPACES.          
           05  WS-NAME-TYPE            PIC X(02) VALUE SPACES.          
           05  WS-FULL-NAME            PIC X(50) VALUE SPACES.          
           05  WS-EXPIRATION-DT        PIC X(10) VALUE SPACES.          
           05  WS-NO-OF-DAYS           PIC S9(4) COMP VALUE ZEROS.      
           05  WS-STATUS-CD            PIC X(01) VALUE SPACES.          
       01  WS-SUB                      PIC S9(8) COMP VALUE ZERO.       
       01  WS-EXPIRATION-DATE.                                          
           05  WS-ED-YY                PIC X(04) VALUE SPACES.          
           05  FILLER                  PIC X(01) VALUE '-'.             
           05  WS-ED-MM                PIC X(02) VALUE SPACES.          
           05  FILLER                  PIC X(01) VALUE '-'.             
           05  WS-ED-DD                PIC X(02) VALUE SPACES.          
                                                                        
       01  WS-MNT-TRANS-HIST.                                           
           05  WS-USERID               PIC X(08)  VALUE SPACES.         
           05  WS-DELINQUENCY-DT       PIC X(10)  VALUE SPACES.         
           05  WS-CURRENT-DATE         PIC X(10)  VALUE SPACES.         
           05  WS-CURRENT-TIMESTAMP    PIC X(26)  VALUE SPACES.         
           05  WS-ACCOUNT-EXISTS       PIC X(01)  VALUE 'N'.            
           05  WS-TRANS-COMMENTS       PIC X(210) VALUE SPACES.         
           05  WS-TRANS-COMMENTS-LEN   PIC S9(4)  VALUE 0 COMP.         
           05  WS-PANEL-NO             PIC X(09)  VALUE 'PANEL212 '.    
           05  WS-RESP-AREA-ID         PIC X(03)   VALUE SPACES.        
COB305     05 WS-CUSTOMER-NO-COMP        PIC S9(10) COMP-3 VALUE 0.             
COB305     05 WS-PREMISE-NO-COMP        PIC S9(10) COMP-3 VALUE 0.              
A01849     05  WS-APPEND-COMMENT       PIC X(84)  VALUE SPACES.         
           05  WS-APPEND-COMMENT-LEN   PIC S9(4)  VALUE 0 COMP.         
           05  WS-INSERT-COMMENT       PIC X(24)  VALUE                 
               'WHITE CROSS PLUS ADDED.!'.                              
      *                                                                         
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE       PIC X(01)   VALUE 'F'.           
           05  WS-TRAN-APPL-NO         PIC S9(02)  VALUE 0.             
           05  WS-TABLE-ID             PIC X(02).                       
           05  WS-COLUMN-DESC             PIC X(15).                    
           05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(75).                    
           05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(04) COMP VALUE 0.      
           05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(75).                    
           05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(04) COMP VALUE 0.      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR03828_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-FROM.                                                 
               10  WS-FROM-X           OCCURS 51 TIMES PIC X.           
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  WS-HOLD-DATE.                                                
           05  WS-HOLD-DATE-YY     PIC X(04).                           
           05  FILLER              PIC X(01).                           
           05  WS-HOLD-DATE-MM     PIC X(02).                           
           05  FILLER              PIC X(01).                           
           05  WS-HOLD-DATE-DD     PIC X(02).                           
                                                                        
       01  WS-WORK-DATE.                                                
           05  WS-WORK-DATE-MM     PIC X(02).                           
           05  FILLER              PIC X(01) VALUE '/'.                 
           05  WS-WORK-DATE-DD     PIC X(02).                           
           05  FILLER              PIC X(01) VALUE '/'.                 
           05  WS-WORK-DATE-YY     PIC X(04).                           
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE      PIC S9(9) COMP VALUE +0.             
                                                                        
      *                                                                         
       01  CN-CONSTANTS.                                                
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  CN-ASTERISK                  PIC X VALUE '*'.            
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
HPCCDM*    EJECT                                                                
      ******* CURSOR DECLARATION FOR CSS_CRED_COLL                              
           EXEC SQL                                                     
              DECLARE DNP_CSR CURSOR FOR                                
              SELECT  CODE_NOTICE_TYPE                                  
                     ,DATE_CREDIT_ACTION                                
                FROM CSS_CRED_COLL                                      
               WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                        
                 AND CODE_NOTICE_TYPE IN ('D','G','H','I')              
                 AND (DATE_CREDIT_ACTION BETWEEN IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )       
                                             AND IIF(TRY_CONVERT(DATE, 
                                                     :WS-DELINQUENCY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-DELINQUENCY-DT
              ) <> 0) OR (LEN(:WS-DELINQUENCY-DT
              ) <> 10), CIS.CHAR2DATE(:WS-DELINQUENCY-DT
              ), CONVERT(DATE, :WS-DELINQUENCY-DT) ))    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00059800
MFA-TR*       DECLARE DNP_CSR CURSOR FOR                                00059900
MFA-TR*       SELECT  CODE_NOTICE_TYPE                                          
MFA-TR*              ,DATE_CREDIT_ACTION                                        
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                                
MFA-TR*          AND CODE_NOTICE_TYPE IN ('D','G','H','I')                      
MFA-TR*          AND (DATE_CREDIT_ACTION BETWEEN :WS-CURRENT-DATE               
MFA-TR*                                      AND :WS-DELINQUENCY-DT)            
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  I-ACCOUNT-NO         PIC X(13).                              
       01  I-UPDATE-FL          PIC X(01).                              
       01  I-APPLICATION-ID     PIC S9(9) USAGE COMP.                   
       01  I-STATUS-CD          PIC X(01).                              
       01  I-PTNT-SSN           PIC X(09).                              
       01  I-PTNT-DOB           PIC X(10).                              
       01  I-PTNT-PHONE         PIC X(10).                              
       01  I-RELATIONSHIP       PIC X(15).                              
COB305 01 I-PTNT-NAME-ID        PIC S9(13)V COMP-3 VALUE 0.                     
       01  I-PTNT-PREFIX        PIC X(09).                              
       01  I-PTNT-FIRST-NAME    PIC X(15).                              
       01  I-PTNT-MIDDLE-NAME   PIC X(15).                              
A01849 01  I-PTNT-LAST-NAME     PIC X(40).                              
       01  I-PTNT-SUFFIX        PIC X(03).                              
       01  I-MED-COND-DESC      PIC X(100).                             
       01  I-MED-COND-DESC-LEN  PIC S9(04) COMP.                        
       01  I-DURATION-MONTH     PIC S9(9) USAGE COMP.                   
       01  I-MED-COND-CODE      PIC X(02).                              
       01  I-AMBULANCE-FL       PIC X(01).                              
       01  I-PTNT-ASSIST-FL     PIC X(01).                              
       01  I-MED-LIC-STATE-CD   PIC X(02).                              
       01  I-MED-LICENCE-NO     PIC X(09).                              
       01  I-EFFECTIVE-DT       PIC X(10).                              
       01  I-PHY-PREFIX         PIC X(09).                              
       01  I-PHY-FIRST-NAME     PIC X(15).                              
       01  I-PHY-MIDDLE-NAME    PIC X(15).                              
A01849 01  I-PHY-LAST-NAME      PIC X(40).                              
       01  I-PHY-SUFFIX         PIC X(03).                              
       01  I-COMMENT            PIC X(255).                             
       01  I-COMMENT-LEN        PIC S9(04) COMP.                        
       01  I-TRANS-COMMENTS     PIC X(210).                             
       01  I-TRANS-COMMENTS-LEN PIC S9(04) COMP.                        
COB305 01 I-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.               
       01  I-PHYSICIAN-ID       PIC S9(9) USAGE COMP.                   
       01  I-ADDR-UPDATE-FLG    PIC X(01).                              
A01849 01  I-HOUSE-NO           PIC X(15).                              
       01  I-ADDR-PREFIX-1      PIC X(03).                              
       01  I-ADDR-PREFIX-2      PIC X(02).                              
A01849 01  I-STREET-NAME        PIC X(30).                              
       01  I-STREET-SUFFIX      PIC X(04).                              
       01  I-STREET-LOCATION-1  PIC X(04).                              
A01849 01  I-STREET-LOCATION-2  PIC X(11).                              
       01  I-ADDRESS-OVERFLOW   PIC X(35).                              
       01  I-ZIP-CODE           PIC X(05).                              
       01  I-ZIP-CODE-PL-FOUR   PIC X(04).                              
       01  I-ZIP-CODE-TOKEN     PIC X(01).                              
       01  I-ADDR-SUFFIX        PIC X(02).                              
       01  I-EXTENSION-NO       PIC X(06).                              
       01  I-PHONE-NO           PIC X(10).                              
       01  I-USER-ID            PIC X(07).                              
                                                                        
       PROCEDURE DIVISION USING                                         
                    I-ACCOUNT-NO                                        
                  , I-UPDATE-FL                                         
                  , I-APPLICATION-ID                                    
                  , I-STATUS-CD                                         
                  , I-PTNT-SSN                                          
                  , I-PTNT-DOB                                          
                  , I-PTNT-PHONE                                        
                  , I-RELATIONSHIP                                      
                  , I-PTNT-NAME-ID                                      
                  , I-PTNT-PREFIX                                       
                  , I-PTNT-FIRST-NAME                                   
                  , I-PTNT-MIDDLE-NAME                                  
                  , I-PTNT-LAST-NAME                                    
                  , I-PTNT-SUFFIX                                       
                  , I-MED-COND-DESC                                     
                  , I-MED-COND-DESC-LEN                                 
                  , I-DURATION-MONTH                                    
                  , I-MED-COND-CODE                                     
                  , I-AMBULANCE-FL                                      
                  , I-PTNT-ASSIST-FL                                    
                  , I-MED-LIC-STATE-CD                                  
                  , I-MED-LICENCE-NO                                    
                  , I-EFFECTIVE-DT                                      
                  , I-PHY-PREFIX                                        
                  , I-PHY-FIRST-NAME                                    
                  , I-PHY-MIDDLE-NAME                                   
                  , I-PHY-LAST-NAME                                     
                  , I-PHY-SUFFIX                                        
                  , I-COMMENT                                           
                  , I-COMMENT-LEN                                       
                  , I-TRANS-COMMENTS                                    
                  , I-TRANS-COMMENTS-LEN                                
                  , I-ADDRESS-ID                                        
                  , I-PHYSICIAN-ID                                      
                  , I-ADDR-UPDATE-FLG                                   
                  , I-HOUSE-NO                                          
                  , I-ADDR-PREFIX-1                                     
                  , I-ADDR-PREFIX-2                                     
                  , I-STREET-NAME                                       
                  , I-STREET-SUFFIX                                     
                  , I-STREET-LOCATION-1                                 
                  , I-STREET-LOCATION-2                                 
                  , I-ADDRESS-OVERFLOW                                  
                  , I-ZIP-CODE                                          
                  , I-ZIP-CODE-PL-FOUR                                  
                  , I-ZIP-CODE-TOKEN                                    
                  , I-ADDR-SUFFIX                                       
                  , I-EXTENSION-NO                                      
                  , I-PHONE-NO                                          
                  , I-USER-ID                                           
                  .                                                     
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE                  THRU 0100-EXIT.     
           PERFORM 1000-PROCESS-INPUT               THRU 1000-EXIT.     
           PERFORM 2000-PROCESS-OUTPUT              THRU 2000-EXIT.     
           IF  STATUS-UPDT                                              
           OR  (I-STATUS-CD = 'A' AND I-UPDATE-FL = 'I')                
               PERFORM 2300-MISCELLANEOUS-UPDATE    THRU 2300-EXIT      
           END-IF                                                       
           PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT.    
           PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT.     
           PERFORM 9999-END-PROGRAM                 THRU 9999-EXIT.     
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   0100-ITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE     DCLCSS-WH-CROSS-PLUS                          
                          DCLCSS-WH-CROSS-PATNT                         
                          DCLCSS-WH-CROSS-SSN                           
                          DCLCSS-PHYSICIAN                              
                          DCLCSS-PHYSICIAN-ATTR                         
                          DCLCSS-NAME                                   
                          DCLCSS-ADDR-FORMATTED.                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE    AS    RETURN_CODE                  
                FROM                                                    
                    CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE    AS    RETURN_CODE                          
MFA-TR*         FROM                                                            
MFA-TR*             SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE  I-ACCOUNT-NO                  TO  WS-ACCOUNT-NO        
           MOVE  WS-ACCOUNT-NO-NUM             TO  WS-ACCOUNT-NO-COMP3  
           MOVE  I-USER-ID                     TO  WS-USERID            
           PERFORM 7000-GET-CURRENT-DATE       THRU 7000-EXIT           
           IF  I-EFFECTIVE-DT > SPACES                                  
           AND I-DURATION-MONTH > 0                                     
               PERFORM  7025-GET-EXPIRATION-DT THRU 7025-EXIT           
               MOVE  WS-EXPIRATION-DT(7:4)     TO WS-ED-YY              
               MOVE  WS-EXPIRATION-DT(1:2)     TO WS-ED-MM              
               MOVE  WS-EXPIRATION-DT(4:2)     TO WS-ED-DD              
               IF I-STATUS-CD = 'A'                                     
                  IF WS-EXPIRATION-DATE <= WS-CURRENT-DATE              
                     MOVE  300                 TO  S-RETURN-CODE        
                     PERFORM 8100-SEND-RESULT  THRU 8100-EXIT           
                     PERFORM 9999-END-PROGRAM  THRU 9999-EXIT           
                  END-IF                                                
               END-IF                                                   
           ELSE                                                         
               MOVE SPACES TO WS-EXPIRATION-DT                          
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE STOREDED, WRITES TO THE          *        
      *      TRANSACTION TABLE.                                        *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                          TO ACTIVE-PARAGRAPH     
      *                                                                         
           PERFORM 7010-GET-RESP-AREA-ID            THRU 7010-EXIT      
           IF I-UPDATE-FL = 'I'                                         
              MOVE WS-INSERT-COMMENT    TO WS-APPEND-COMMENT            
              MOVE +24                  TO WS-APPEND-COMMENT-LEN        
              PERFORM 2005-PROCESS-NEW-FORM         THRU 2005-EXIT      
           ELSE                                                         
              IF I-UPDATE-FL = 'U'                                      
                 MOVE I-APPLICATION-ID  TO WS-APPLICATION-ID            
                 STRING 'APPLICATION ID ' DELIMITED BY SIZE             
                         WS-APPLICATION-ID DELIMITED BY SIZE            
                         '-'              DELIMITED BY SIZE             
                         I-PTNT-LAST-NAME DELIMITED BY SIZE             
                            ','           DELIMITED BY SIZE             
                         ' '              DELIMITED BY SIZE             
                        I-PTNT-FIRST-NAME DELIMITED BY SIZE             
                        ';!'              DELIMITED BY SIZE             
                   INTO WS-APPEND-COMMENT                               
A01849           MOVE +84               TO WS-APPEND-COMMENT-LEN        
                 MOVE SPACES            TO WS-EMB-INPUT,                
                                           WS-CMP-TABLE                 
A01849           MOVE 84                TO WS-EMB-LENG                  
                 MOVE WS-APPEND-COMMENT TO WS-EMB-INPUT                 
                 PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT     
                 MOVE WS-CMP-TABLE      TO WS-APPEND-COMMENT            
                 PERFORM 2250-PROCESS-UPDATE        THRU 2250-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
            IF  WS-DELETE-DNP-FL = 'Y'                                  
                MOVE 200                      TO RS-RETURN-CODE         
            END-IF.                                                     
            MOVE RS-RETURN-CODE               TO S-RETURN-CODE.         
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2005-PROCESS-NEW-FORM.                                         *        
      *                                                                *        
      *      PROCESS THE NEW FORM AND  WRITES TO THE                   *        
      *      TRANSACTION TABLE.                                        *        
      ******************************************************************        
      *                                                                         
       2005-PROCESS-NEW-FORM.                                           
      *                                                                         
           MOVE '2005'                          TO ACTIVE-PARAGRAPH.    
           IF  I-PHYSICIAN-ID = 0                                       
               PERFORM 7080-SEL-PHY-MED-LIC-STATE                       
                  THRU 7080-EXIT                                        
               IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   PERFORM 2050-PROCESS-OLD-PHYSICIAN                   
                      THRU 2050-EXIT                                    
               ELSE                                                     
                   PERFORM 2040-PROCESS-NEW-PHYSICIAN                   
                      THRU 2040-EXIT                                    
                   MOVE PY-PHYSICIAN-ID         TO                      
                                                 PA-PHYSICIAN-ID        
                                                 I-PHYSICIAN-ID         
               END-IF                                                   
           ELSE                                                         
               MOVE I-PHYSICIAN-ID            TO WO-PHYSICIAN-ID        
                                                 PA-PHYSICIAN-ID        
                                                 PY-PHYSICIAN-ID        
      * THOUGH HCP EXISTS CHECK IF NAME HAS CHANGED                             
               PERFORM 7055-SELECT-PHYSICIAN  THRU 7055-EXIT            
               MOVE PY-NAME-ID                      TO DQ-NAME-ID       
               PERFORM 2550-JOURNAL-PHY-NAME        THRU 2550-EXIT      
               PERFORM 7060-SELECT-NAME             THRU 7060-EXIT      
               MOVE 'N'                       TO WS-PHY-NAME-UPDT       
               PERFORM 2060-COMPARE-PHY-NAME  THRU 2060-EXIT            
               IF  PHY-NAME-UPDT                                        
                   PERFORM 2030-POPULATE-PHY-FIELDS THRU 2030-EXIT      
                   MOVE PY-NAME-ID                  TO DQ-NAME-ID       
                   PERFORM 8070-UPDATE-NAME         THRU 8070-EXIT      
               END-IF                                                   
               INITIALIZE DCLCSS-NAME                                   
           END-IF                                                       
                                                                        
           IF  I-ADDRESS-ID = 0                                         
               PERFORM 2110-PROCESS-NEW-ADDRESS                         
                  THRU 2110-EXIT                                        
           ELSE                                                         
      * THOUGH ADDRESS EXISTS ADDRESS FIELDS COULD HAVE BEEN UPDATED            
               MOVE I-ADDRESS-ID                    TO  DY-ADDRESS-ID   
                                                        WO-ADDRESS-ID   
               PERFORM 2565-JOURNAL-ADDRESS       THRU 2565-EXIT        
               PERFORM 7070-SELECT-ADDR-FORMATTED THRU 7070-EXIT        
               MOVE 'N'                           TO WS-PHY-ADDR-UPDT   
               PERFORM 2090-COMPARE-ADDR-FIELDS   THRU 2090-EXIT        
               IF  PHY-ADDR-UPDT                                        
                   MOVE I-ADDRESS-ID              TO  DY-ADDRESS-ID     
                   PERFORM 2025-POPULATE-ADDR-FIELDS THRU 2025-EXIT     
                   PERFORM 8075-UPDATE-PHY-ADDRESS THRU 8075-EXIT       
               END-IF                                                   
           END-IF                                                       
                                                                        
      * BELOW APPLIES TO ALL NEW APPLICATION FORM                               
           MOVE I-PTNT-SSN                    TO WJ-SSN                 
           IF  WJ-SSN = '999999999'                                     
               IF  I-PTNT-NAME-ID > 0                                   
                   MOVE I-PTNT-NAME-ID        TO WO-NAME-ID             
                   MOVE WJ-SSN                TO WS-SSN                 
                   MOVE SPACES                TO WJ-SSN                 
                   PERFORM 2547-JOURNAL-WCP-SSN                         
                      THRU 2547-EXIT                                    
                   MOVE WS-SSN                TO WJ-SSN                 
               ELSE                                                     
                   PERFORM 2080-PROCESS-PTNT-NAME                       
                      THRU 2080-EXIT                                    
               END-IF                                                   
           ELSE                                                         
              IF  I-PTNT-NAME-ID > 0                                    
                  MOVE I-PTNT-NAME-ID         TO WO-NAME-ID             
                                                 DQ-NAME-ID             
                                                 WP-NAME-ID             
                                                 WJ-NAME-ID             
      **** THOUGH THE PATIENT EXISTS CHECK IF NAME HAS CHANGED                  
                  PERFORM 2570-JOURNAL-PTNT-NAME    THRU 2570-EXIT      
                  MOVE WJ-SSN                TO WS-SSN                  
                  MOVE SPACES                TO WJ-SSN                  
                  PERFORM 2547-JOURNAL-WCP-SSN                          
                     THRU 2547-EXIT                                     
                  MOVE WS-SSN                TO WJ-SSN                  
                  PERFORM 2540-JOURNAL-PTNT-CONTACT THRU 2540-EXIT      
                  PERFORM 7110-SELECT-PTNT-SSN      THRU 7110-EXIT      
                  IF  WJ-SSN = I-PTNT-SSN                               
                      CONTINUE                                          
                  ELSE                                                  
                      PERFORM 2280-PTNT-SSN-UPDATE                      
                         THRU 2280-EXIT                                 
                  END-IF                                                
                  PERFORM 7060-SELECT-NAME          THRU 7060-EXIT      
                  PERFORM 7089-SELECT-PTNT-CONTACT  THRU 7089-EXIT      
                  MOVE 'N'  TO WS-PATIENT-NAME-UPDT                     
                  PERFORM 2070-COMPARE-PTNT-NAME-FIELDS                 
                    THRU  2070-EXIT                                     
                  IF  PATIENT-NAME-UPDT                                 
                      PERFORM 2035-POPULATE-PTNT-FIELDS THRU 2035-EXIT  
                      PERFORM 8070-UPDATE-NAME      THRU 8070-EXIT      
                      INITIALIZE DCLCSS-NAME                            
                  END-IF                                                
                  IF I-PTNT-DOB = WP-PATIENT-DOB                        
                     CONTINUE                                           
                  ELSE                                                  
                     MOVE I-PTNT-DOB TO WP-PATIENT-DOB                  
                     PERFORM 8055-UPDATE-WCP-PTNT    THRU 8055-EXIT     
                  END-IF                                                
              ELSE                                                      
                  PERFORM 2080-PROCESS-PTNT-NAME                        
                     THRU 2080-EXIT                                     
              END-IF                                                    
           END-IF                                                       
           PERFORM 7050-GET-NEXT-APPLICATION-ID     THRU  7050-EXIT     
           PERFORM  2575-JOURNAL-WCP                THRU 2575-EXIT      
           MOVE I-PHYSICIAN-ID                      TO WO-PHYSICIAN-ID  
           MOVE 'N'                                 TO WS-STATUS-UPDT   
           PERFORM 2100-PROCESS-WH-CROSS-PLUS       THRU  2100-EXIT     
           PERFORM 8040-INSERT-CROSS-PLUS           THRU  8040-EXIT.    
      *                                                                         
       2005-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    2010-PROCESS-NEW-NAME.                                      *        
      *                                                                *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *                                                                *        
      ******************************************************************        
       2010-PROCESS-NEW-NAME.                                           
      *                                                                         
           MOVE '2010'                        TO ACTIVE-PARAGRAPH.      
           MOVE   WS-91-NEW-NAME-ID           TO  DQ-NAME-ID            
           MOVE   WS-NAME-TYPE                TO  DQ-NAME-TYPE          
           MOVE   'I'                         TO  DQ-NAME-FORMAT        
           MOVE   SPACES                      TO  DQ-NICKNAME           
           MOVE   SPACES                      TO  DQ-TITLE-SUFFIX-2     
           PERFORM 8000-INSERT-NAME           THRU 8000-EXIT            
           INITIALIZE DCLCSS-NAME.                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2015-PROCESS-PHY-DETAILS.                                   *        
      *                                                                *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *                                                                *        
      ******************************************************************        
       2015-PROCESS-PHY-DETAILS.                                        
      *                                                                         
           PERFORM 2555-JOURNAL-LIC-STATE     THRU 2555-EXIT            
           PERFORM 2557-JOURNAL-LICENSE-NO    THRU 2557-EXIT            
           MOVE   I-MED-LIC-STATE-CD          TO  PY-MED-LIC-STATE-CD   
           MOVE   I-MED-LICENCE-NO            TO  PY-MED-LICENSE-NO     
           MOVE   WS-91-NEW-NAME-ID           TO  PY-NAME-ID            
           PERFORM 7030-GET-NEXT-PHYSICIAN-ID       THRU 7030-EXIT      
           PERFORM 8010-INSERT-PHY-DETAIL           THRU 8010-EXIT.     
      *                                                                         
       2015-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2020-PROCESS-PHY-ADDRESS.                                   *        
      *                                                                *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *                                                                *        
      ******************************************************************        
       2020-PROCESS-PHY-ADDRESS.                                        
      *                                                                         
           MOVE '2020'                        TO ACTIVE-PARAGRAPH.      
           IF   I-HOUSE-NO           > SPACES                           
           OR   I-ADDR-PREFIX-1      > SPACES                           
           OR   I-ADDR-PREFIX-2      > SPACES                           
           OR   I-STREET-NAME        > SPACES                           
           OR   I-STREET-LOCATION-1  > SPACES                           
           OR   I-STREET-LOCATION-2  > SPACES                           
           OR   I-STREET-SUFFIX      > SPACES                           
           OR   I-ADDRESS-OVERFLOW   > SPACES                           
           OR   I-ZIP-CODE           > SPACES                           
           OR   I-ZIP-CODE-PL-FOUR   > SPACES                           
           OR   I-ZIP-CODE-TOKEN     > SPACES                           
           OR   I-ADDR-SUFFIX        > SPACES                           
                CONTINUE                                                
           ELSE                                                         
                MOVE 0                        TO WS-90-ADDRESS-ID       
                IF  PY-PHYSICIAN-ID > 0                                 
                    MOVE   PY-PHYSICIAN-ID        TO  PA-PHYSICIAN-ID   
                    MOVE   WS-90-ADDRESS-ID       TO  PA-ADDRESS-ID     
                                                      I-ADDRESS-ID      
                    PERFORM 2545-JOURNAL-PHY-CONTACT                    
                       THRU 2545-EXIT                                   
                    PERFORM 2290-CHECK-DUMMY-ADDR-REQ                   
                       THRU 2290-EXIT                                   
                    GO TO  2020-EXIT                                    
                ELSE                                                    
                    GO TO  2020-EXIT                                    
                END-IF                                                  
           END-IF                                                       
      * USE ADDRESS ID TO STORE PHYSICIAN ADDRESS                               
           PERFORM 6202-GET-NEW-ADDRESS-ID    THRU 6202-EXIT            
           MOVE   WS-90-ADDRESS-ID            TO  DY-ADDRESS-ID         
           PERFORM 2565-JOURNAL-ADDRESS       THRU 2565-EXIT            
           PERFORM 2545-JOURNAL-PHY-CONTACT   THRU 2545-EXIT            
           PERFORM 2025-POPULATE-ADDR-FIELDS  THRU 2025-EXIT            
           PERFORM 8020-INSERT-PHY-ADDRESS    THRU 8020-EXIT            
           MOVE   WS-90-ADDRESS-ID            TO  PA-ADDRESS-ID         
           MOVE   I-EXTENSION-NO              TO  PA-EXTENSION-NO       
           MOVE   I-PHONE-NO                  TO  PA-PHONE-NO           
           PERFORM 8030-INSERT-PHY-ATTR       THRU 8030-EXIT.           
           IF  I-UPDATE-FL = 'U'                                        
               MOVE 'N'                       TO WS-PHYS-ATTR-UPDATE    
               SET DEL-DUMMY-ADDR             TO TRUE                   
           END-IF.                                                      
      *                                                                         
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2025-POPULATE-ADDR-FIELDS.                                       
      *                                                                         
           MOVE   I-HOUSE-NO                  TO  DY-HOUSE-NO           
           MOVE   I-ADDR-PREFIX-1             TO  DY-ADDR-PREFIX-1      
           MOVE   I-ADDR-PREFIX-2             TO  DY-ADDR-PREFIX-2      
           MOVE   I-STREET-NAME               TO  DY-STREET-NAME        
           MOVE   I-STREET-LOCATION-1         TO  DY-STREET-LOCATION-1  
           MOVE   I-STREET-LOCATION-2         TO  DY-STREET-LOCATION-2  
           MOVE   I-STREET-SUFFIX             TO  DY-STREET-SUFFIX      
           MOVE   I-ADDRESS-OVERFLOW          TO  DY-ADDRESS-OVERFLOW   
           MOVE   SPACES                      TO  DY-CARRIER-ROUTE      
           MOVE   I-ZIP-CODE                  TO  DY-ZIP-CODE           
           MOVE   I-ZIP-CODE-PL-FOUR          TO  DY-ZIP-CODE-PLUS-FOUR 
           MOVE   I-ZIP-CODE-TOKEN            TO  DY-ZIP-CODE-TOKEN     
           MOVE   'F'                         TO  DY-ADDR-USAGE-CD      
           MOVE   I-ADDR-SUFFIX               TO  DY-ADDR-SUFFIX        
           MOVE   SPACES                      TO  DY-USPS-DELIV-PT-CD.  
      *                                                                         
       2025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2030-POPULATE-PHY-FIELDS.                                        
      *                                                                         
           MOVE I-PHY-FIRST-NAME              TO DQ-FIRST-NAME          
           MOVE I-PHY-MIDDLE-NAME             TO DQ-MIDDLE-NAME         
           MOVE I-PHY-LAST-NAME               TO DQ-LAST-NAME           
           MOVE I-PHY-PREFIX                  TO DQ-TITLE-PREFIX        
           MOVE I-PHY-SUFFIX                  TO DQ-TITLE-SUFFIX-1      
           STRING I-PHY-FIRST-NAME,                                     
                  I-PHY-MIDDLE-NAME,                                    
                  I-PHY-LAST-NAME   DELIMITED BY SIZE                   
             INTO DQ-FULL-NAME.                                         
      *                                                                         
       2030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2035-POPULATE-PTNT-FIELDS.                                       
      *                                                                         
           MOVE I-PTNT-FIRST-NAME             TO DQ-FIRST-NAME          
           MOVE I-PTNT-MIDDLE-NAME            TO DQ-MIDDLE-NAME         
           MOVE I-PTNT-LAST-NAME              TO DQ-LAST-NAME           
           MOVE I-PTNT-PREFIX                 TO DQ-TITLE-PREFIX        
           MOVE I-PTNT-SUFFIX                 TO DQ-TITLE-SUFFIX-1      
           STRING I-PTNT-FIRST-NAME,                                    
                  I-PTNT-MIDDLE-NAME,                                   
                  I-PTNT-LAST-NAME   DELIMITED BY SIZE                  
             INTO DQ-FULL-NAME.                                         
      *                                                                         
       2035-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2040-PROCESS-NEW-PHYSICIAN.                                      
      *                                                                         
           IF  I-PHY-FIRST-NAME   > SPACES                              
           OR  I-PHY-LAST-NAME    > SPACES                              
           OR  I-MED-LIC-STATE-CD > SPACES                              
           OR  I-MED-LICENCE-NO   > SPACES                              
               CONTINUE                                                 
           ELSE                                                         
               GO TO 2040-EXIT                                          
           END-IF                                                       
           MOVE      'PY'                   TO WS-NAME-TYPE             
           PERFORM 6302-GET-NEW-NAME-ID     THRU 6302-EXIT              
           PERFORM 2550-JOURNAL-PHY-NAME    THRU 2550-EXIT              
           STRING I-PHY-FIRST-NAME,                                     
                  I-PHY-MIDDLE-NAME,                                    
                  I-PHY-LAST-NAME       DELIMITED BY SIZE               
             INTO DQ-FULL-NAME                                          
           MOVE I-PHY-PREFIX                TO  DQ-TITLE-PREFIX         
           MOVE I-PHY-FIRST-NAME            TO  DQ-FIRST-NAME           
           MOVE I-PHY-MIDDLE-NAME           TO  DQ-MIDDLE-NAME          
           MOVE I-PHY-LAST-NAME             TO  DQ-LAST-NAME            
           MOVE I-PHY-SUFFIX                TO  DQ-TITLE-SUFFIX-1       
           PERFORM 2010-PROCESS-NEW-NAME    THRU 2010-EXIT              
           PERFORM 2015-PROCESS-PHY-DETAILS THRU 2015-EXIT.             
      *                                                                         
       2040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2050-PROCESS-OLD-PHYSICIAN.                                      
      *                                                                         
           PERFORM 2550-JOURNAL-PHY-NAME      THRU 2550-EXIT            
           MOVE PY-NAME-ID                    TO DQ-NAME-ID             
           PERFORM 7060-SELECT-NAME           THRU 7060-EXIT            
           MOVE 'N'                           TO WS-PHY-NAME-UPDT       
           PERFORM 2060-COMPARE-PHY-NAME      THRU 2060-EXIT            
           IF  PHY-NAME-UPDT                                            
               PERFORM 2030-POPULATE-PHY-FIELDS THRU 2030-EXIT          
               MOVE PY-NAME-ID             TO DQ-NAME-ID                
               PERFORM 8070-UPDATE-NAME    THRU 8070-EXIT               
           END-IF                                                       
           INITIALIZE DCLCSS-NAME                                       
           MOVE PY-PHYSICIAN-ID          TO PA-PHYSICIAN-ID             
                                            I-PHYSICIAN-ID.             
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2060-COMPARE-PHY-NAME.                                           
      *                                                                         
           IF  I-PHY-FIRST-NAME    EQUAL DQ-FIRST-NAME                  
           AND I-PHY-MIDDLE-NAME   EQUAL DQ-MIDDLE-NAME                 
           AND I-PHY-LAST-NAME     EQUAL DQ-LAST-NAME                   
           AND I-PHY-PREFIX        EQUAL DQ-TITLE-PREFIX                
           AND I-PHY-SUFFIX        EQUAL DQ-TITLE-SUFFIX-1              
               CONTINUE                                                 
           ELSE                                                         
               SET PHY-NAME-UPDT TO TRUE                                
           END-IF.                                                      
      *                                                                         
       2060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2070-COMPARE-PTNT-NAME-FIELDS.                                   
      *                                                                         
           IF  I-PTNT-FIRST-NAME    EQUAL DQ-FIRST-NAME                 
           AND I-PTNT-MIDDLE-NAME   EQUAL DQ-MIDDLE-NAME                
           AND I-PTNT-LAST-NAME     EQUAL DQ-LAST-NAME                  
           AND I-PTNT-PREFIX        EQUAL DQ-TITLE-PREFIX               
           AND I-PTNT-SUFFIX        EQUAL DQ-TITLE-SUFFIX-1             
               CONTINUE                                                 
           ELSE                                                         
               SET PATIENT-NAME-UPDT TO TRUE                            
           END-IF.                                                      
      *                                                                         
       2070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2080-PROCESS-PTNT-NAME.                                          
      *                                                                         
           IF  I-PTNT-FIRST-NAME > SPACES                               
           OR  I-PTNT-LAST-NAME  > SPACES                               
           OR  I-PTNT-SSN        > SPACES                               
           OR  I-PTNT-DOB        > SPACES                               
               CONTINUE                                                 
           ELSE                                                         
               MOVE ZEROES                         TO WO-NAME-ID        
               GO TO 2080-EXIT                                          
           END-IF                                                       
      *                                                                         
           PERFORM 6302-GET-NEW-NAME-ID            THRU 6302-EXIT       
           IF  I-PTNT-FIRST-NAME   > SPACES                             
           OR  I-PTNT-LAST-NAME    > SPACES                             
               IF I-UPDATE-FL = 'I'                                     
                  PERFORM 2570-JOURNAL-PTNT-NAME   THRU 2570-EXIT       
               END-IF                                                   
               MOVE      'PA'                      TO WS-NAME-TYPE      
               PERFORM 2035-POPULATE-PTNT-FIELDS   THRU 2035-EXIT       
               PERFORM 2010-PROCESS-NEW-NAME       THRU 2010-EXIT       
           END-IF                                                       
           IF  I-PTNT-DOB > SPACES                                      
               PERFORM 2540-JOURNAL-PTNT-CONTACT   THRU 2540-EXIT       
           END-IF                                                       
           MOVE SPACES TO WJ-SSN                                        
           IF  I-PTNT-SSN > SPACES                                      
           AND I-UPDATE-FL = 'I'                                        
               PERFORM 2547-JOURNAL-WCP-SSN        THRU 2547-EXIT       
           END-IF                                                       
           MOVE WS-91-NEW-NAME-ID             TO WP-NAME-ID             
                                                 WO-NAME-ID             
                                                 WJ-NAME-ID             
           MOVE I-PTNT-DOB                    TO WP-PATIENT-DOB         
           PERFORM 8050-INSERT-WCP-PTNT             THRU  8050-EXIT     
           IF  I-PTNT-SSN > SPACES                                      
               MOVE I-PTNT-SSN                TO WJ-SSN                 
               PERFORM 8060-INSERT-WCP-SSN    THRU  8060-EXIT           
           END-IF.                                                      
      *                                                                         
       2080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2090-COMPARE-ADDR-FIELDS.                                        
      *                                                                         
           IF  I-HOUSE-NO                  =   DY-HOUSE-NO              
           AND I-ADDR-PREFIX-1             =   DY-ADDR-PREFIX-1         
           AND I-ADDR-PREFIX-2             =   DY-ADDR-PREFIX-2         
           AND I-STREET-NAME               =   DY-STREET-NAME           
           AND I-STREET-LOCATION-1         =   DY-STREET-LOCATION-1     
           AND I-STREET-LOCATION-2         =   DY-STREET-LOCATION-2     
           AND I-STREET-SUFFIX             =   DY-STREET-SUFFIX         
           AND I-ADDRESS-OVERFLOW          =   DY-ADDRESS-OVERFLOW      
           AND I-ZIP-CODE                  =   DY-ZIP-CODE              
           AND I-ZIP-CODE-PL-FOUR          =   DY-ZIP-CODE-PLUS-FOUR    
           AND I-ZIP-CODE-TOKEN            =   DY-ZIP-CODE-TOKEN        
           AND I-ADDR-SUFFIX               =   DY-ADDR-SUFFIX           
               CONTINUE                                                 
           ELSE                                                         
               SET PHY-ADDR-UPDT TO TRUE                                
           END-IF.                                                      
      *                                                                         
       2090-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   2100-PROCESS-WH-CROSS-PLUS.                                           
      *                                                                         
      *   CALLED FROM 2000-PROCESS-OUTPUT                                       
      ******************************************************************        
      *                                                                         
       2100-PROCESS-WH-CROSS-PLUS.                                      
      *                                                                         
           MOVE WS-ACCOUNT-NO-COMP3     TO  WO-ACCOUNT-NO               
           MOVE I-STATUS-CD             TO  WO-STATUS-CD                
           MOVE I-EFFECTIVE-DT          TO  WO-EFFECTIVE-DT             
           MOVE WS-EXPIRATION-DT        TO  WO-EXPIRATION-DT            
           MOVE I-COMMENT-LEN           TO  WO-COMMENT-LEN              
           MOVE I-COMMENT               TO  WO-COMMENT-TEXT             
           MOVE I-MED-COND-CODE         TO  WO-MED-COND-CODE            
           MOVE I-MED-COND-DESC-LEN     TO  WO-MEDICAL-COND-DESC-LEN    
           MOVE I-MED-COND-DESC         TO  WO-MEDICAL-COND-DESC-TEXT   
           MOVE I-AMBULANCE-FL          TO  WO-AMBULANCE-FL             
           MOVE I-PTNT-ASSIST-FL        TO  WO-PATIENT-ASSIST-FL.       
           MOVE I-RELATIONSHIP          TO  WO-PATIENT-RELATION         
           MOVE I-PTNT-PHONE            TO  WO-PATIENT-PH-NO.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2110-PROCESS-NEW-ADDRESS.                                        
      *                                                                         
           PERFORM 2025-POPULATE-ADDR-FIELDS                            
              THRU 2025-EXIT                                            
           PERFORM 7100-SELECT-ADDRESS-ID                               
              THRU 7100-EXIT                                            
  *                                                                     
           IF  EXACT-MATCH                                              
               MOVE DY-ADDRESS-ID                   TO WO-ADDRESS-ID    
                                                       PA-ADDRESS-ID    
               MOVE PY-PHYSICIAN-ID                 TO PA-PHYSICIAN-ID  
               MOVE I-EXTENSION-NO                  TO PA-EXTENSION-NO  
               MOVE I-PHONE-NO                      TO PA-PHONE-NO      
               PERFORM 2565-JOURNAL-ADDRESS         THRU 2565-EXIT      
               PERFORM 8030-INSERT-PHY-ATTR         THRU 8030-EXIT      
               IF  I-UPDATE-FL = 'U'                                    
                   SET DEL-DUMMY-ADDR               TO TRUE             
                   MOVE 'N'                      TO WS-PHYS-ATTR-UPDATE 
               END-IF                                                   
               INITIALIZE DCLCSS-ADDR-FORMATTED                         
           ELSE                                                         
               INITIALIZE      DCLCSS-ADDR-FORMATTED                    
               PERFORM 2020-PROCESS-PHY-ADDRESS THRU 2020-EXIT          
               MOVE WS-90-ADDRESS-ID                TO  WO-ADDRESS-ID   
           END-IF.                                                      
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2250-PROCESS-UPDATE.                                        *        
      *                                                                *        
      *    PROCESS UPDATE AND WRITE INTO TRANSACTION TABLE.            *        
      *                                                                *        
      ******************************************************************        
       2250-PROCESS-UPDATE.                                             
      *                                                                         
           MOVE '2250'                        TO ACTIVE-PARAGRAPH.      
           MOVE WS-ACCOUNT-NO-COMP3           TO WO-ACCOUNT-NO          
           MOVE I-APPLICATION-ID              TO WO-APPLICATION-ID      
           PERFORM 7065-SELECT-WCP            THRU 7065-EXIT            
           MOVE WO-STATUS-CD                  TO  WS-STATUS-CD          
           PERFORM 2270-HCP-UPDATES                                     
              THRU 2270-EXIT                                            
           MOVE WO-NAME-ID                      TO DQ-NAME-ID           
                                                   WP-NAME-ID           
                                                   WJ-NAME-ID           
           PERFORM 7060-SELECT-NAME             THRU 7060-EXIT          
           PERFORM 7089-SELECT-PTNT-CONTACT     THRU 7089-EXIT          
           PERFORM 7110-SELECT-PTNT-SSN         THRU 7110-EXIT          
           PERFORM 2570-JOURNAL-PTNT-NAME       THRU 2570-EXIT          
           PERFORM 2540-JOURNAL-PTNT-CONTACT    THRU 2540-EXIT          
           PERFORM 2547-JOURNAL-WCP-SSN         THRU 2547-EXIT          
           IF  PTNT-SSN-UPDT                                            
               PERFORM 2280-PTNT-SSN-UPDATE                             
                  THRU 2280-EXIT                                        
           END-IF                                                       
           IF  PATIENT-NAME-UPDT                                        
               PERFORM 2035-POPULATE-PTNT-FIELDS THRU 2035-EXIT         
               PERFORM 8070-UPDATE-NAME       THRU 8070-EXIT            
               IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   MOVE 'PA'                  TO  DQ-NAME-TYPE          
                   MOVE 'I'                   TO  DQ-NAME-FORMAT        
                   MOVE SPACES                TO  DQ-NICKNAME           
                   MOVE SPACES                TO  DQ-TITLE-SUFFIX-2     
                   PERFORM 8000-INSERT-NAME   THRU 8000-EXIT            
               END-IF                                                   
               INITIALIZE DCLCSS-NAME                                   
           END-IF                                                       
           IF  PTNT-UPDT                                                
               IF  WO-NAME-ID = 0                                       
                   PERFORM 2260-ADD-NEW-NAME-ID                         
                      THRU 2260-EXIT                                    
                        GO TO 2250-EXIT                                 
               ELSE                                                     
                   MOVE I-PTNT-DOB            TO WP-PATIENT-DOB         
                   PERFORM 8055-UPDATE-WCP-PTNT    THRU 8055-EXIT       
               END-IF                                                   
           END-IF                                                       
           PERFORM 2575-JOURNAL-WCP                THRU 2575-EXIT       
           IF  WH-CR-PL-UPDT                                            
               MOVE I-PHYSICIAN-ID            TO WO-PHYSICIAN-ID        
               IF  DEL-PHYSICIAN                                        
                   MOVE 0                     TO WO-PHYSICIAN-ID        
                                                 WO-ADDRESS-ID          
               END-IF                                                   
               PERFORM 2100-PROCESS-WH-CROSS-PLUS  THRU  2100-EXIT      
               PERFORM 8085-UPDATE-WCP             THRU 8085-EXIT       
           END-IF.                                                      
           IF  DEL-DUMMY-ADDR                                           
               MOVE 0                         TO WS-ADDRESS-ID          
               MOVE WO-PHYSICIAN-ID           TO PA-PHYSICIAN-ID        
               PERFORM 8880-DELETE-PHY-ATTR   THRU 8880-EXIT            
           END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2260-ADD-NEW-NAME-ID.                                            
      *                                                                         
           PERFORM 2080-PROCESS-PTNT-NAME                               
              THRU 2080-EXIT                                            
           MOVE I-PHYSICIAN-ID            TO WO-PHYSICIAN-ID            
           PERFORM 2100-PROCESS-WH-CROSS-PLUS                           
              THRU 2100-EXIT                                            
           PERFORM 8085-UPDATE-WCP        THRU 8085-EXIT.               
      *                                                                         
       2260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2270-HCP-UPDATES.                                                
      *                                                                         
           IF  I-PHYSICIAN-ID = WO-PHYSICIAN-ID                         
               CONTINUE                                                 
           ELSE                                                         
              SET WH-CR-PL-UPDT    TO TRUE                              
              IF  I-PHYSICIAN-ID = ZEROES                               
                  PERFORM 7080-SEL-PHY-MED-LIC-STATE                    
                     THRU 7080-EXIT                                     
                  IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                      PERFORM 2050-PROCESS-OLD-PHYSICIAN                
                         THRU 2050-EXIT                                 
                      PERFORM 2290-CHECK-DUMMY-ADDR-REQ                 
                         THRU 2290-EXIT                                 
                  ELSE                                                  
                      PERFORM 2040-PROCESS-NEW-PHYSICIAN                
                         THRU 2040-EXIT                                 
                         MOVE PY-PHYSICIAN-ID        TO I-PHYSICIAN-ID  
                          SET NEW-PHYSICIAN          TO TRUE            
                  END-IF                                                
              ELSE                                                      
                  PERFORM 2555-JOURNAL-LIC-STATE  THRU 2555-EXIT        
                  PERFORM 2557-JOURNAL-LICENSE-NO THRU 2557-EXIT        
                  PERFORM 2290-CHECK-DUMMY-ADDR-REQ                     
                     THRU 2290-EXIT                                     
              END-IF                                                    
           END-IF                                                       
           MOVE I-PHYSICIAN-ID                TO PY-PHYSICIAN-ID        
           PERFORM 7055-SELECT-PHYSICIAN            THRU 7055-EXIT      
           IF  PY-MED-LIC-STATE-CD = I-MED-LIC-STATE-CD                 
               CONTINUE                                                 
           ELSE                                                         
              PERFORM 2555-JOURNAL-LIC-STATE        THRU 2555-EXIT      
              SET PHYSICIAN-UPDATE            TO TRUE                   
           END-IF                                                       
           IF  PY-MED-LICENSE-NO = I-MED-LICENCE-NO                     
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 2557-JOURNAL-LICENSE-NO      THRU 2557-EXIT      
               SET PHYSICIAN-UPDATE           TO TRUE                   
           END-IF                                                       
           IF PHYSICIAN-UPDATE                                          
              IF  PY-PHYSICIAN-ID > 0                                   
                  IF  I-MED-LICENCE-NO   > SPACES                       
                      MOVE I-MED-LIC-STATE-CD     TO PY-MED-LIC-STATE-CD
                      MOVE I-MED-LICENCE-NO       TO PY-MED-LICENSE-NO  
                      PERFORM 8065-UPDATE-PHYSICIAN THRU 8065-EXIT      
                  ELSE                                                  
                      SET WH-CR-PL-UPDT           TO TRUE               
                      SET DEL-PHYSICIAN           TO TRUE               
                  END-IF                                                
              ELSE                                                      
                  PERFORM 7080-SEL-PHY-MED-LIC-STATE                    
                     THRU 7080-EXIT                                     
                  IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                       PERFORM 2050-PROCESS-OLD-PHYSICIAN               
                          THRU 2050-EXIT                                
                       PERFORM 2290-CHECK-DUMMY-ADDR-REQ                
                          THRU 2290-EXIT                                
                      SET WH-CR-PL-UPDT           TO TRUE               
                  ELSE                                                  
                      PERFORM 2040-PROCESS-NEW-PHYSICIAN                
                         THRU 2040-EXIT                                 
                      MOVE PY-PHYSICIAN-ID    TO I-PHYSICIAN-ID         
                                                 PA-PHYSICIAN-ID        
                      SET NEW-PHYSICIAN      TO TRUE                    
                      SET WH-CR-PL-UPDT           TO TRUE               
                  END-IF                                                
              END-IF                                                    
           END-IF                                                       
           MOVE PY-NAME-ID                          TO DQ-NAME-ID       
           PERFORM 7060-SELECT-NAME                 THRU 7060-EXIT      
           PERFORM 2550-JOURNAL-PHY-NAME            THRU 2550-EXIT      
           IF  PHY-NAME-UPDT                                            
               IF  PY-NAME-ID = ZEROES                                  
                   IF  PY-PHYSICIAN-ID = ZEROES                         
                       PERFORM 2040-PROCESS-NEW-PHYSICIAN               
                          THRU 2040-EXIT                                
                       MOVE PY-PHYSICIAN-ID          TO WO-PHYSICIAN-ID 
                                                        PA-PHYSICIAN-ID 
                                                        I-PHYSICIAN-ID  
                       SET WH-CR-PL-UPDT           TO TRUE              
                   ELSE                                                 
      * CODE IF PHYSICIAN NAME IS ENTERED AFTER INSERT                          
                       MOVE 'PY'            TO WS-NAME-TYPE             
                       PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT      
                       PERFORM 2550-JOURNAL-PHY-NAME THRU 2550-EXIT     
                       STRING I-PHY-FIRST-NAME,                         
                              I-PHY-MIDDLE-NAME,                        
                              I-PHY-LAST-NAME DELIMITED BY SIZE         
                         INTO DQ-FULL-NAME                              
                       MOVE I-PHY-PREFIX       TO  DQ-TITLE-PREFIX      
                       MOVE I-PHY-FIRST-NAME   TO DQ-FIRST-NAME         
                       MOVE I-PHY-MIDDLE-NAME  TO DQ-MIDDLE-NAME        
                       MOVE I-PHY-LAST-NAME TO  DQ-LAST-NAME            
                       MOVE I-PHY-SUFFIX    TO  DQ-TITLE-SUFFIX-1       
                       PERFORM 2010-PROCESS-NEW-NAME THRU 2010-EXIT     
                       MOVE   WS-91-NEW-NAME-ID      TO  PY-NAME-ID     
                       MOVE I-MED-LIC-STATE-CD TO PY-MED-LIC-STATE-CD   
                       MOVE I-MED-LICENCE-NO TO PY-MED-LICENSE-NO       
                       PERFORM 8065-UPDATE-PHYSICIAN THRU 8065-EXIT     
                   END-IF                                               
      *                                                                         
               ELSE                                                     
                   PERFORM 2030-POPULATE-PHY-FIELDS THRU 2030-EXIT      
                   MOVE PY-NAME-ID                  TO DQ-NAME-ID       
                   PERFORM 8070-UPDATE-NAME         THRU 8070-EXIT      
                   INITIALIZE DCLCSS-NAME                               
               END-IF                                                   
           END-IF                                                       
           IF  WO-ADDRESS-ID  = I-ADDRESS-ID                            
               MOVE WO-ADDRESS-ID TO DY-ADDRESS-ID                      
                                     PA-ADDRESS-ID                      
               MOVE I-PHYSICIAN-ID TO PA-PHYSICIAN-ID                   
               PERFORM 7070-SELECT-ADDR-FORMATTED   THRU 7070-EXIT      
               PERFORM 7090-SELECT-PHY-CONTACT      THRU 7090-EXIT      
               PERFORM 2565-JOURNAL-ADDRESS         THRU 2565-EXIT      
               PERFORM 2545-JOURNAL-PHY-CONTACT     THRU 2545-EXIT      
               IF  PHY-ADDR-UPDT OR NEW-PHYSICIAN                       
                   IF  I-ADDRESS-ID = ZEROES                            
                       PERFORM 2110-PROCESS-NEW-ADDRESS                 
                          THRU 2110-EXIT                                
                       SET WH-CR-PL-UPDT          TO TRUE               
                   ELSE                                                 
                       MOVE I-ADDRESS-ID          TO  DY-ADDRESS-ID     
                       PERFORM 2025-POPULATE-ADDR-FIELDS THRU 2025-EXIT 
                       PERFORM 8075-UPDATE-PHY-ADDRESS  THRU 8075-EXIT  
                   END-IF                                               
               END-IF                                                   
               IF  PHYS-ATTR-UPDATE                                     
                   MOVE I-PHONE-NO                TO PA-PHONE-NO        
                   MOVE I-EXTENSION-NO            TO PA-EXTENSION-NO    
                   MOVE WO-ADDRESS-ID             TO PA-ADDRESS-ID      
                   MOVE I-PHYSICIAN-ID            TO PA-PHYSICIAN-ID    
                   IF  I-PHYSICIAN-ID EQUAL WO-PHYSICIAN-ID             
                       PERFORM 8080-UPDATE-PHY-ATTR                     
                          THRU 8080-EXIT                                
                   ELSE                                                 
                       PERFORM 8030-INSERT-PHY-ATTR                     
                          THRU 8030-EXIT                                
                   END-IF                                               
               END-IF                                                   
           ELSE                                                         
               IF I-ADDRESS-ID = ZEROES                                 
                  MOVE I-PHYSICIAN-ID TO PA-PHYSICIAN-ID                
                  PERFORM 2110-PROCESS-NEW-ADDRESS                      
                     THRU 2110-EXIT                                     
                  SET WH-CR-PL-UPDT             TO TRUE                 
               ELSE                                                     
                 MOVE I-ADDRESS-ID              TO  WO-ADDRESS-ID       
                                                    DY-ADDRESS-ID       
                 PERFORM 2565-JOURNAL-ADDRESS       THRU 2565-EXIT      
                 MOVE 'N'                       TO WS-PHY-ADDR-UPDT     
                 PERFORM 7070-SELECT-ADDR-FORMATTED THRU 7070-EXIT      
                 PERFORM 2090-COMPARE-ADDR-FIELDS   THRU 2090-EXIT      
                 PERFORM 2545-JOURNAL-PHY-CONTACT   THRU 2545-EXIT      
                 IF  PHY-ADDR-UPDT                                      
                     MOVE I-ADDRESS-ID        TO  DY-ADDRESS-ID         
                     PERFORM 2025-POPULATE-ADDR-FIELDS THRU 2025-EXIT   
                     PERFORM 8075-UPDATE-PHY-ADDRESS THRU 8075-EXIT     
                 END-IF                                                 
                 IF  PHYS-ATTR-UPDATE                                   
                     MOVE I-PHONE-NO                TO PA-PHONE-NO      
                     MOVE I-EXTENSION-NO            TO PA-EXTENSION-NO  
                     MOVE I-ADDRESS-ID              TO PA-ADDRESS-ID    
                     MOVE I-PHYSICIAN-ID            TO PA-PHYSICIAN-ID  
                     PERFORM 8080-UPDATE-PHY-ATTR                       
                      THRU 8080-EXIT                                    
                 END-IF                                                 
                 SET WH-CR-PL-UPDT             TO TRUE                  
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2280-PTNT-SSN-UPDATE.                                            
      *                                                                         
           MOVE WJ-SSN                              TO WS-SSN           
           MOVE WJ-NAME-ID                          TO WS-NAME-ID       
           MOVE I-PTNT-SSN                          TO WJ-SSN           
           IF  I-PTNT-NAME-ID = WO-NAME-ID                              
           AND I-PTNT-NAME-ID > 0                                       
               MOVE WS-SSN                          TO WJ-SSN           
               MOVE WS-NAME-ID                      TO WJ-NAME-ID       
               IF  WJ-NAME-ID > 0                                       
                   PERFORM 8890-DELETE-WCP-SSN      THRU 8890-EXIT      
               ELSE                                                     
                  IF  WJ-NAME-ID = 0                                    
                      PERFORM 2260-ADD-NEW-NAME-ID                      
                         THRU 2260-EXIT                                 
                      GO TO 2250-EXIT                                   
                  END-IF                                                
               END-IF                                                   
               MOVE I-PTNT-SSN                      TO WJ-SSN           
               PERFORM 8060-INSERT-WCP-SSN          THRU  8060-EXIT     
           ELSE                                                         
               IF  I-PTNT-NAME-ID > 0                                   
                   SET WH-CR-PL-UPDT                TO TRUE             
                   MOVE I-PTNT-NAME-ID              TO WO-NAME-ID       
                                                       DQ-NAME-ID       
                   PERFORM 7060-SELECT-NAME THRU 7060-EXIT              
                   PERFORM 2070-COMPARE-PTNT-NAME-FIELDS                
                      THRU 2070-EXIT                                    
                   IF  PATIENT-NAME-UPDT                                
                       PERFORM 2035-POPULATE-PTNT-FIELDS                
                          THRU 2035-EXIT                                
                       PERFORM 8070-UPDATE-NAME                         
                          THRU 8070-EXIT                                
                       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                           MOVE 'PA'          TO  DQ-NAME-TYPE          
                           MOVE 'I'           TO  DQ-NAME-FORMAT        
                           MOVE SPACES        TO  DQ-NICKNAME           
                           MOVE SPACES        TO  DQ-TITLE-SUFFIX-2     
                           PERFORM 8000-INSERT-NAME THRU 8000-EXIT      
                       END-IF                                           
                       INITIALIZE DCLCSS-NAME                           
                       MOVE 'N'               TO WS-PATIENT-NAME-UPDT   
                   END-IF                                               
                   MOVE I-PTNT-NAME-ID       TO WJ-NAME-ID              
                   PERFORM 7110-SELECT-PTNT-SSN                         
                      THRU 7110-EXIT                                    
                   IF  WJ-SSN = I-PTNT-SSN                              
                       CONTINUE                                         
                   ELSE                                                 
                       PERFORM 8890-DELETE-WCP-SSN      THRU 8890-EXIT  
                       MOVE I-PTNT-SSN                  TO WJ-SSN       
                       PERFORM 8060-INSERT-WCP-SSN      THRU  8060-EXIT 
                   END-IF                                               
               ELSE                                                     
                   PERFORM 2080-PROCESS-PTNT-NAME                       
                      THRU 2080-EXIT                                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2290-CHECK-DUMMY-ADDR-REQ.                                       
      *                                                                         
           IF I-ADDRESS-ID > ZEROS                                      
              CONTINUE                                                  
           ELSE                                                         
      *    CHECK IF THERE IS A DUMMY ROW ELSE INSERT ONE                        
               MOVE I-PHYSICIAN-ID              TO  PA-PHYSICIAN-ID     
               MOVE I-ADDRESS-ID                TO  PA-ADDRESS-ID       
               PERFORM 7090-SELECT-PHY-CONTACT                          
                  THRU 7090-EXIT                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE 0                        TO  PA-ADDRESS-ID       
                  MOVE I-EXTENSION-NO           TO  PA-EXTENSION-NO     
                  MOVE I-PHONE-NO               TO  PA-PHONE-NO         
                  PERFORM 8030-INSERT-PHY-ATTR THRU 8030-EXIT           
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-MISCELLANEOUS-UPDATE.                                     *        
      *                                                                *        
      *   MISCELLANEOUS UPDATE                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2300-MISCELLANEOUS-UPDATE.                                       
                                                                        
           MOVE '2200'                       TO ACTIVE-PARAGRAPH.       
           MOVE WO-ACCOUNT-NO                   TO AT-ACCOUNT-NO        
           PERFORM 7085-SELECT-CRIT-OUTAGE       THRU 7085-EXIT         
           PERFORM 7120-SELECT-WHITE-CROSS-PLUS  THRU 7120-EXIT         
           IF  WS-WCP-EXISTS                                            
               CONTINUE                                                 
           ELSE                                                         
               IF WO-STATUS-CD = 'I'                                    
                  MOVE 'DAYS-WCP-DNP-GRACE'  TO C8-DELINQ-CD            
                  MOVE AT-COMPANY-NO         TO C8-COMPANY-NO           
                  PERFORM 7020-GET-DELINQUENCY-VAL  THRU 7020-EXIT      
                  MOVE C8-DELINQ-VALUE              TO WS-NO-OF-DAYS    
                  PERFORM 7023-GET-DELINQUENCY-DT   THRU 7023-EXIT      
                  MOVE WS-ACCOUNT-NO-COMP3          TO CL-ACCOUNT-NO    
                  PERFORM 7130-OPEN-DNP-CURSOR      THRU 7130-EXIT      
                  PERFORM 7140-FETCH-DNP-CURSOR     THRU 7140-EXIT      
                  PERFORM 2310-PROCESS-DNP-DEL      THRU 2310-EXIT      
                     UNTIL END-OF-ROWS                                  
                  PERFORM 7150-CLOSE-DNP-CURSOR     THRU 7150-EXIT      
                  MOVE 'N'                          TO WS-END-OF-ROWS   
               END-IF                                                   
           END-IF                                                       
           PERFORM 2320-PROCESS-CRIT-UPDT      THRU 2320-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   2310-PROCESS-MISC-DEL.                                                
      *                                                                         
      *   DELETE FUTURE DNP FORECAST ROW                                        
      ******************************************************************        
       2310-PROCESS-DNP-DEL.                                            
      *                                                                         
            PERFORM  2580-JOURNAL-DNP-DT         THRU 2580-EXIT         
            PERFORM  8087-DELETE-DNP-ROW         THRU 8087-EXIT         
            PERFORM  7140-FETCH-DNP-CURSOR       THRU 7140-EXIT.        
      *                                                                         
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2320-PROCESS-CRIT-UPDT.                                    *         
      *                                                                *        
      *    PROCESS FOR THE MISCELLANEOUS UPDATE                       *         
      *                                                                *        
      ******************************************************************        
       2320-PROCESS-CRIT-UPDT.                                          
      *                                                                         
           PERFORM 7160-SELECT-WHITE-CROSS            THRU 7160-EXIT    
           EVALUATE I-STATUS-CD                                         
               WHEN 'A'                                                 
                  IF WS-WCP-EXISTS                                      
                  AND (AT-CODE-CRIT-OUTAGE = 'WP' OR 'WX')              
                     GO TO 2320-EXIT                                    
                  END-IF                                                
                  IF WS-WC-EXISTS                                       
                      MOVE 'WX'                TO WS-NEW-CRIT-OUTAGE    
                  ELSE                                                  
                      MOVE 'WP'                TO WS-NEW-CRIT-OUTAGE    
                  END-IF                                                
               WHEN 'I'                                                 
               WHEN 'D'                                                 
                  IF  WS-WCP-EXISTS                                     
                  OR  (WS-STATUS-CD = 'I' OR 'D')                       
                      GO TO 2320-EXIT                                   
                  END-IF                                                
                  IF  WS-WC-EXISTS                                      
                      MOVE 'WC'    TO WS-NEW-CRIT-OUTAGE                
                  ELSE                                                  
                      MOVE SPACES  TO WS-NEW-CRIT-OUTAGE                
                  END-IF                                                
           END-EVALUATE.                                                
           PERFORM 2585-JOURNAL-CODE-CRIT  THRU 2585-EXIT               
           MOVE WS-NEW-CRIT-OUTAGE         TO AT-CODE-CRIT-OUTAGE       
           PERFORM 8090-UPDT-CODE-CRIT     THRU 8090-EXIT.              
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2540-JOURNAL-PTNT-CONTACT.                                  *        
      *                                                                *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      *                                                                *        
      ******************************************************************        
       2540-JOURNAL-PTNT-CONTACT.                                       
                                                                        
           MOVE SPACES                      TO WS-TABLE-ID              
           IF  WP-PATIENT-DOB = I-PTNT-DOB                              
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                        TO WS-TRAN-APPL-NO         
               MOVE 'PATIENT DOB'            TO WS-COLUMN-DESC          
               IF  WP-PATIENT-DOB > SPACES                              
                   MOVE  WP-PATIENT-DOB      TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE  10                  TO WS-PRV-COLUMN-VALUE-LEN 
               ELSE                                                     
                   MOVE  '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE 5                    TO WS-PRV-COLUMN-VALUE-LEN 
               END-IF                                                   
               IF  I-PTNT-DOB = SPACES                                  
                   MOVE '*DELETED*'          TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE 9                    TO WS-CHG-COLUMN-VALUE-LEN 
               ELSE                                                     
                   MOVE I-PTNT-DOB           TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE 10                   TO WS-CHG-COLUMN-VALUE-LEN 
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET PTNT-UPDT                 TO TRUE                    
           END-IF.                                                      
      *                                                                         
       2540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2545-JOURNAL-PHY-CONTACT.                                   *        
      *                                                                *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      *                                                                *        
      ******************************************************************        
       2545-JOURNAL-PHY-CONTACT.                                        
                                                                        
           IF JOURNAL-PHY-CONTACT                                       
              GO TO 2545-EXIT                                           
           END-IF                                                       
           MOVE SPACES                       TO WS-TABLE-ID             
           IF  PA-PHONE-NO = I-PHONE-NO                                 
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                        TO WS-TRAN-APPL-NO         
               MOVE 'HCP PHONE'              TO WS-COLUMN-DESC          
               IF  PA-PHONE-NO  > SPACES                                
                   MOVE  PA-PHONE-NO         TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE  10                  TO WS-PRV-COLUMN-VALUE-LEN 
               ELSE                                                     
                   MOVE  '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE 5                    TO WS-PRV-COLUMN-VALUE-LEN 
               END-IF                                                   
               IF  I-PHONE-NO = SPACES                                  
                   MOVE '*DELETED*'          TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE 9                    TO WS-CHG-COLUMN-VALUE-LEN 
               ELSE                                                     
                   MOVE I-PHONE-NO           TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE 10                   TO WS-CHG-COLUMN-VALUE-LEN 
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET PHYS-ATTR-UPDATE          TO TRUE                    
           END-IF                                                       
           IF  PA-EXTENSION-NO = I-EXTENSION-NO                         
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                        TO WS-TRAN-APPL-NO         
               MOVE 'HCP EXTENSION'          TO WS-COLUMN-DESC          
               IF  PA-EXTENSION-NO  > SPACES                            
                   MOVE  PA-EXTENSION-NO     TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE  6                   TO WS-PRV-COLUMN-VALUE-LEN 
               ELSE                                                     
                   MOVE  '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE 5                    TO WS-PRV-COLUMN-VALUE-LEN 
               END-IF                                                   
               IF  I-EXTENSION-NO = SPACES                              
                   MOVE '*DELETED*'          TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE 9                    TO WS-CHG-COLUMN-VALUE-LEN 
               ELSE                                                     
                   MOVE I-EXTENSION-NO       TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE 6                    TO WS-CHG-COLUMN-VALUE-LEN 
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET PHYS-ATTR-UPDATE          TO TRUE                    
           END-IF.                                                      
           SET JOURNAL-PHY-CONTACT           TO TRUE.                   
      *                                                                         
       2545-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2547-JOURNAL-WCP-SSN.                                       *        
      *                                                                *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      *                                                                *        
      ******************************************************************        
       2547-JOURNAL-WCP-SSN.                                            
                                                                        
           MOVE SPACES                      TO WS-TABLE-ID              
           IF  WJ-SSN = I-PTNT-SSN                                      
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'SSN'                   TO WS-COLUMN-DESC           
               IF  WJ-SSN  > ZEROES                                     
                   MOVE  WJ-SSN             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE  9                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE  '*NEW*'            TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PTNT-SSN = SPACES                                  
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-SSN          TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET PTNT-SSN-UPDT            TO TRUE                     
           END-IF.                                                      
      *                                                                         
       2547-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2555-JOURNAL-LIC-STATE.                                     *        
      *                                                                *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      *                                                                *        
      ******************************************************************        
       2555-JOURNAL-LIC-STATE.                                          
                                                                        
           IF JOURNAL-LIC-STATE                                         
              GO TO 2555-EXIT                                           
           END-IF                                                       
           MOVE SPACES                      TO WS-TABLE-ID              
           ADD +1                           TO WS-TRAN-APPL-NO          
           MOVE 'MED LIC STATE'             TO WS-COLUMN-DESC           
           IF  PY-MED-LIC-STATE-CD > SPACES                             
               MOVE  PY-MED-LIC-STATE-CD    TO WS-PRV-COLUMN-VALUE-TEXT 
               MOVE 2                       TO WS-PRV-COLUMN-VALUE-LEN  
           ELSE                                                         
               MOVE  '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT 
               MOVE 5                       TO WS-PRV-COLUMN-VALUE-LEN  
           END-IF                                                       
           IF  I-MED-LIC-STATE-CD = SPACES                              
               MOVE '*DELETED*'             TO WS-CHG-COLUMN-VALUE-TEXT 
               MOVE 9                       TO WS-CHG-COLUMN-VALUE-LEN  
           ELSE                                                         
               MOVE I-MED-LIC-STATE-CD      TO WS-CHG-COLUMN-VALUE-TEXT 
               MOVE 2                       TO WS-CHG-COLUMN-VALUE-LEN  
           END-IF                                                       
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           SET JOURNAL-LIC-STATE            TO TRUE.                    
      *                                                                         
       2555-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2557-JOURNAL-LICENSE-NO.                                         
                                                                        
           IF JOURNAL-LICENSE-NO                                        
              GO TO 2557-EXIT                                           
           END-IF                                                       
           ADD +1                           TO WS-TRAN-APPL-NO          
           MOVE 'MED LICENSE NO'            TO WS-COLUMN-DESC           
           IF  PY-MED-LICENSE-NO > SPACES                               
               MOVE  PY-MED-LICENSE-NO      TO WS-PRV-COLUMN-VALUE-TEXT 
               MOVE +9                      TO WS-PRV-COLUMN-VALUE-LEN  
           ELSE                                                         
               MOVE  '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT 
               MOVE +5                      TO WS-PRV-COLUMN-VALUE-LEN  
           END-IF                                                       
           IF  I-MED-LICENCE-NO = SPACES                                
               MOVE '*DELETED*'             TO WS-CHG-COLUMN-VALUE-TEXT 
               MOVE 9                       TO WS-CHG-COLUMN-VALUE-LEN  
           ELSE                                                         
               MOVE I-MED-LICENCE-NO        TO WS-CHG-COLUMN-VALUE-TEXT 
               MOVE 9                       TO WS-CHG-COLUMN-VALUE-LEN  
           END-IF                                                       
           PERFORM 5950-SET-MNT-TRANS-VARS          THRU 5950-EXIT      
           PERFORM 6530-LOAD-MNT-TRANS-HIST         THRU 6530-EXIT.     
           SET JOURNAL-LICENSE-NO           TO TRUE.                    
                                                                        
       2557-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2550-JOURNAL-PHY-NAME.                                      *        
      *                                                                *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
      *                                                                         
       2550-JOURNAL-PHY-NAME.                                           
      *                                                                         
           MOVE SPACES                      TO WS-TABLE-ID              
           IF  DQ-FIRST-NAME  = I-PHY-FIRST-NAME                        
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                      TO WS-TRAN-APPL-NO           
               MOVE 'HCP FIRST NAME'       TO WS-COLUMN-DESC            
               IF  DQ-FIRST-NAME > SPACES                               
                   MOVE DQ-FIRST-NAME       TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PHY-FIRST-NAME = SPACES                            
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PHY-FIRST-NAME    TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-NAME-UPDT            TO TRUE                     
           END-IF                                                       
           IF  DQ-MIDDLE-NAME = I-PHY-MIDDLE-NAME                       
               CONTINUE                                                 
           ELSE                                                         
             IF  DQ-MIDDLE-NAME > SPACES                                
             OR  I-PHY-MIDDLE-NAME > SPACES                             
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'HCP MIDDLE NAME'       TO WS-COLUMN-DESC           
               IF  DQ-MIDDLE-NAME > SPACES                              
                   MOVE DQ-MIDDLE-NAME      TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PHY-MIDDLE-NAME = SPACES                           
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PHY-MIDDLE-NAME   TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-NAME-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DQ-LAST-NAME   = I-PHY-LAST-NAME                         
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'HCP LAST NAME'         TO WS-COLUMN-DESC           
               IF  DQ-LAST-NAME > SPACES                                
                   MOVE DQ-LAST-NAME        TO WS-PRV-COLUMN-VALUE-TEXT 
A01849             MOVE 40                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PHY-LAST-NAME = SPACES                             
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PHY-LAST-NAME     TO WS-CHG-COLUMN-VALUE-TEXT 
A01849             MOVE 40                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-NAME-UPDT            TO TRUE                     
           END-IF                                                       
           IF  DQ-TITLE-PREFIX = I-PHY-PREFIX                           
               CONTINUE                                                 
           ELSE                                                         
             IF  DQ-TITLE-PREFIX > SPACES                               
             OR  I-PHY-PREFIX > SPACES                                  
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'HCP TITLE'             TO WS-COLUMN-DESC           
               IF  DQ-TITLE-PREFIX > SPACES                             
                   MOVE DQ-TITLE-PREFIX     TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PHY-PREFIX = SPACES                                
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PHY-PREFIX        TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-NAME-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DQ-TITLE-SUFFIX-1 = I-PHY-SUFFIX                         
               CONTINUE                                                 
           ELSE                                                         
             IF  DQ-TITLE-SUFFIX-1 > SPACES                             
             OR  I-PHY-SUFFIX > SPACES                                  
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'HCP SUFFIX'            TO WS-COLUMN-DESC           
               IF  DQ-TITLE-SUFFIX-1 > SPACES                           
                   MOVE DQ-TITLE-SUFFIX-1   TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PHY-SUFFIX = SPACES                                
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PHY-SUFFIX        TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-NAME-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF.                                                      
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2565-JOURNAL-ADDRESS.                                       *        
      *                                                                *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
       2565-JOURNAL-ADDRESS.                                            
      *                                                                         
           IF  JOURNAL-ADDRESS                                          
               GO TO 2565-EXIT                                          
           END-IF                                                       
           MOVE SPACES                      TO WS-TABLE-ID              
           IF  DY-HOUSE-NO   = I-HOUSE-NO                               
               CONTINUE                                                 
           ELSE                                                         
             IF DY-HOUSE-NO > SPACES                                    
             OR I-HOUSE-NO > SPACES                                     
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'HOUSE NO'              TO WS-COLUMN-DESC           
               IF  DY-HOUSE-NO > SPACES                                 
                   MOVE DY-HOUSE-NO         TO WS-PRV-COLUMN-VALUE-TEXT 
A01849             MOVE 15                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-HOUSE-NO = SPACES                                  
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-HOUSE-NO          TO WS-CHG-COLUMN-VALUE-TEXT 
A01849             MOVE 15                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DY-ADDR-PREFIX-1 = I-ADDR-PREFIX-1                       
               CONTINUE                                                 
           ELSE                                                         
             IF DY-ADDR-PREFIX-1 > SPACES                               
             OR I-ADDR-PREFIX-1 > SPACES                                
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'ADDR PREFIX 1'         TO WS-COLUMN-DESC           
               IF  DY-ADDR-PREFIX-1 > SPACES                            
                   MOVE DY-ADDR-PREFIX-1    TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 3                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-ADDR-PREFIX-1 = SPACES                             
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-ADDR-PREFIX-1     TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 3                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DY-ADDR-PREFIX-2 = I-ADDR-PREFIX-2                       
               CONTINUE                                                 
           ELSE                                                         
             IF  DY-ADDR-PREFIX-2 > SPACES                              
             OR  I-ADDR-PREFIX-2  > SPACES                              
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'ADDR PREFIX 2'         TO WS-COLUMN-DESC           
               IF  DY-ADDR-PREFIX-2 > SPACES                            
                   MOVE DY-ADDR-PREFIX-2    TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 3                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-ADDR-PREFIX-2 = SPACES                             
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-ADDR-PREFIX-2     TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 3                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DY-STREET-NAME = I-STREET-NAME                           
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'STREET NAME'           TO WS-COLUMN-DESC           
               IF  DY-STREET-NAME > SPACES                              
                   MOVE DY-STREET-NAME      TO WS-PRV-COLUMN-VALUE-TEXT 
A01849             MOVE 30                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-STREET-NAME = SPACES                               
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-STREET-NAME       TO WS-CHG-COLUMN-VALUE-TEXT 
A01849             MOVE 30                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT             TO TRUE                    
           END-IF                                                       
           IF  DY-STREET-LOCATION-1 = I-STREET-LOCATION-1               
               CONTINUE                                                 
           ELSE                                                         
             IF DY-STREET-LOCATION-1 > SPACES                           
             OR I-STREET-LOCATION-1 > SPACES                            
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'STREET LOC 1'          TO WS-COLUMN-DESC           
               IF  DY-STREET-LOCATION-1 > SPACES                        
                 MOVE DY-STREET-LOCATION-1 TO WS-PRV-COLUMN-VALUE-TEXT  
                   MOVE 4                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-STREET-LOCATION-1 = SPACES                         
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-STREET-LOCATION-1 TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 4                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DY-STREET-LOCATION-2 = I-STREET-LOCATION-2               
               CONTINUE                                                 
           ELSE                                                         
             IF DY-STREET-LOCATION-2 > SPACES                           
             OR I-STREET-LOCATION-2 > SPACES                            
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'STREET LOC 2'          TO WS-COLUMN-DESC           
               IF  DY-STREET-LOCATION-2 > SPACES                        
                 MOVE DY-STREET-LOCATION-2 TO WS-PRV-COLUMN-VALUE-TEXT  
A01849             MOVE 11                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-STREET-LOCATION-2 = SPACES                         
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-STREET-LOCATION-2 TO WS-CHG-COLUMN-VALUE-TEXT 
A01849             MOVE 11                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DY-STREET-SUFFIX = I-STREET-SUFFIX                       
               CONTINUE                                                 
           ELSE                                                         
             IF DY-STREET-SUFFIX > SPACES                               
             OR I-STREET-SUFFIX > SPACES                                
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'STREET SUFFIX'         TO WS-COLUMN-DESC           
               MOVE '22'                    TO WS-TABLE-ID              
               IF  DY-STREET-SUFFIX > SPACES                            
                 MOVE DY-STREET-SUFFIX TO WS-PRV-COLUMN-VALUE-TEXT      
                   MOVE 3                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-STREET-SUFFIX = SPACES                             
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-STREET-SUFFIX     TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 3                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           MOVE SPACES                      TO WS-TABLE-ID              
           IF  DY-ADDRESS-OVERFLOW = I-ADDRESS-OVERFLOW                 
               CONTINUE                                                 
           ELSE                                                         
             IF DY-ADDRESS-OVERFLOW > SPACES                            
             OR I-ADDRESS-OVERFLOW > SPACES                             
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'ADDRESS OVER '         TO WS-COLUMN-DESC           
               IF  DY-ADDRESS-OVERFLOW > SPACES                         
                 MOVE DY-ADDRESS-OVERFLOW TO WS-PRV-COLUMN-VALUE-TEXT   
                   MOVE 26                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-ADDRESS-OVERFLOW = SPACES                          
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-ADDRESS-OVERFLOW  TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 26                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DY-ZIP-CODE = I-ZIP-CODE                                 
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'ZIP CODE'              TO WS-COLUMN-DESC           
               IF DY-ZIP-CODE > SPACES                                  
                  MOVE DY-ZIP-CODE          TO WS-PRV-COLUMN-VALUE-TEXT 
                  MOVE 5                    TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-ZIP-CODE = SPACES                                  
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-ZIP-CODE          TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT             TO TRUE                    
           END-IF                                                       
           IF  DY-ZIP-CODE-PLUS-FOUR = I-ZIP-CODE-PL-FOUR               
               CONTINUE                                                 
           ELSE                                                         
             IF DY-ZIP-CODE-PLUS-FOUR > SPACES                          
             OR I-ZIP-CODE-PL-FOUR > SPACES                             
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'ZIP PLUS FOUR'         TO WS-COLUMN-DESC           
               IF  DY-ZIP-CODE-PLUS-FOUR > SPACES                       
                 MOVE DY-ZIP-CODE-PLUS-FOUR TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 4                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-ZIP-CODE-PL-FOUR = SPACES                          
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                  MOVE I-ZIP-CODE-PL-FOUR   TO  WS-CHG-COLUMN-VALUE-TEXT
                  MOVE 4                    TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DY-ZIP-CODE-TOKEN = I-ZIP-CODE-TOKEN                     
               CONTINUE                                                 
           ELSE                                                         
             IF DY-ZIP-CODE-TOKEN > SPACES                              
             OR I-ZIP-CODE-TOKEN > SPACES                               
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'ZIP TOKEN'             TO WS-COLUMN-DESC           
               IF  DY-ZIP-CODE-TOKEN > SPACES                           
                 MOVE DY-ZIP-CODE-TOKEN TO     WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 1                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-ZIP-CODE-TOKEN = SPACES                            
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                  MOVE I-ZIP-CODE-TOKEN     TO WS-CHG-COLUMN-VALUE-TEXT 
                  MOVE 1                    TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PHY-ADDR-UPDT            TO TRUE                     
             END-IF                                                     
           END-IF.                                                      
           SET JOURNAL-ADDRESS TO TRUE.                                 
                                                                        
       2565-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2570-JOURNAL-PTNT-NAME.                                     *        
      *                                                                *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
       2570-JOURNAL-PTNT-NAME.                                          
                                                                        
           MOVE SPACES                      TO WS-TABLE-ID              
           IF  DQ-FIRST-NAME  = I-PTNT-FIRST-NAME                       
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                      TO WS-TRAN-APPL-NO           
               MOVE 'PATIENT 1ST NM'       TO WS-COLUMN-DESC            
               IF  DQ-FIRST-NAME > SPACES                               
                   MOVE DQ-FIRST-NAME       TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PTNT-FIRST-NAME = SPACES                           
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-FIRST-NAME   TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET PATIENT-NAME-UPDT        TO TRUE                     
           END-IF                                                       
           IF  DQ-MIDDLE-NAME = I-PTNT-MIDDLE-NAME                      
               CONTINUE                                                 
           ELSE                                                         
             IF  DQ-MIDDLE-NAME > SPACES                                
             OR  I-PTNT-MIDDLE-NAME > SPACES                            
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'PATIENT MID NM'        TO WS-COLUMN-DESC           
               IF  DQ-MIDDLE-NAME > SPACES                              
                   MOVE DQ-MIDDLE-NAME      TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PTNT-MIDDLE-NAME = SPACES                          
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-MIDDLE-NAME  TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 15                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PATIENT-NAME-UPDT        TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DQ-LAST-NAME   = I-PTNT-LAST-NAME                        
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'PATIENT LAST NM'       TO WS-COLUMN-DESC           
               IF  DQ-LAST-NAME > SPACES                                
                   MOVE DQ-LAST-NAME        TO WS-PRV-COLUMN-VALUE-TEXT 
A01849             MOVE 40                  TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PTNT-LAST-NAME = SPACES                            
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-LAST-NAME    TO WS-CHG-COLUMN-VALUE-TEXT 
A01849             MOVE 40                  TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET PATIENT-NAME-UPDT        TO TRUE                     
           END-IF                                                       
           IF  DQ-TITLE-PREFIX = I-PTNT-PREFIX                          
               CONTINUE                                                 
           ELSE                                                         
             IF  DQ-TITLE-PREFIX > SPACES                               
             OR  I-PTNT-PREFIX > SPACES                                 
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'PATIENT  PREFIX'       TO WS-COLUMN-DESC           
               IF  DQ-TITLE-PREFIX > SPACES                             
                   MOVE DQ-TITLE-PREFIX     TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PTNT-PREFIX = SPACES                               
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-PREFIX       TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PATIENT-NAME-UPDT        TO TRUE                     
             END-IF                                                     
           END-IF                                                       
           IF  DQ-TITLE-SUFFIX-1 = I-PTNT-SUFFIX                        
               CONTINUE                                                 
           ELSE                                                         
             IF  DQ-TITLE-SUFFIX-1 > SPACES                             
             OR  I-PTNT-SUFFIX > SPACES                                 
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'PATIENT SUFFIX'        TO WS-COLUMN-DESC           
               IF  DQ-TITLE-SUFFIX-1 > SPACES                           
                   MOVE DQ-TITLE-SUFFIX-1   TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-PRV-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT 
                   MOVE 5                   TO WS-PRV-COLUMN-VALUE-LEN  
               END-IF                                                   
               IF  I-PTNT-SUFFIX = SPACES                               
                   MOVE '*DELETED*'         TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               ELSE                                                     
                   MOVE I-PTNT-SUFFIX       TO WS-CHG-COLUMN-VALUE-TEXT 
                   MOVE 9                   TO WS-CHG-COLUMN-VALUE-LEN  
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               SET PATIENT-NAME-UPDT        TO TRUE                     
             END-IF                                                     
           END-IF.                                                      
                                                                        
       2570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2575-JOURNAL-WCP.                                           *        
      *                                                                *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
       2575-JOURNAL-WCP.                                                
      *                                                                         
           MOVE SPACES                        TO WS-TABLE-ID            
           IF  WO-APPLICATION-ID   = I-APPLICATION-ID                   
               CONTINUE                                                 
           ELSE                                                         
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'APPLICATION ID'       TO WS-COLUMN-DESC          
             IF  I-APPLICATION-ID  > ZEROES                             
                 MOVE I-APPLICATION-ID       TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
             MOVE WO-APPLICATION-ID          TO WS-CHG-COLUMN-VALUE-TEXT
             MOVE 9                          TO WS-CHG-COLUMN-VALUE-LEN 
             PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT        
             PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT        
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
           IF  WO-PHYSICIAN-ID = I-PHYSICIAN-ID                         
               CONTINUE                                                 
           ELSE                                                         
                ADD +1                       TO WS-TRAN-APPL-NO         
                MOVE 'PHYSICIAN ID'          TO WS-COLUMN-DESC          
             IF  WO-PHYSICIAN-ID > ZEROES                               
                 MOVE WO-PHYSICIAN-ID        TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
             IF  I-PHYSICIAN-ID = ZEROES                                
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-PHYSICIAN-ID         TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
             PERFORM 5950-SET-MNT-TRANS-VARS        THRU 5950-EXIT      
             PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT      
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
           IF  WO-STATUS-CD  = I-STATUS-CD                              
               CONTINUE                                                 
           ELSE                                                         
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'STATUS'               TO WS-COLUMN-DESC          
                 MOVE '77'                   TO WS-TABLE-ID             
             IF  WO-STATUS-CD  > SPACES                                 
                 MOVE WO-STATUS-CD           TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
             IF  I-STATUS-CD = SPACES                                   
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-STATUS-CD            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
             PERFORM 5950-SET-MNT-TRANS-VARS        THRU 5950-EXIT      
             PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT      
             SET WH-CR-PL-UPDT               TO TRUE                    
             SET STATUS-UPDT                 TO TRUE                    
           END-IF                                                       
           IF  WO-EFFECTIVE-DT  = I-EFFECTIVE-DT                        
               CONTINUE                                                 
           ELSE                                                         
                ADD +1                       TO WS-TRAN-APPL-NO         
                MOVE 'SIGNED DT'             TO WS-COLUMN-DESC          
             IF WO-EFFECTIVE-DT > SPACES                                
                MOVE WO-EFFECTIVE-DT         TO WS-PRV-COLUMN-VALUE-TEXT
                MOVE 10                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                MOVE '*NEW*'                 TO WS-PRV-COLUMN-VALUE-TEXT
                MOVE 5                       TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
             IF  I-EFFECTIVE-DT = SPACES                                
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-EFFECTIVE-DT         TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 10                     TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
             PERFORM 5950-SET-MNT-TRANS-VARS        THRU 5950-EXIT      
             PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT      
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
           IF  WO-EXPIRATION-DT = WS-EXPIRATION-DT                      
               CONTINUE                                                 
           ELSE                                                         
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'EXPIRATION DT'        TO WS-COLUMN-DESC          
             IF  WO-EXPIRATION-DT > SPACES                              
                 MOVE WO-EXPIRATION-DT       TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 10                     TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
             IF  WS-EXPIRATION-DT = SPACES                              
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE WS-EXPIRATION-DT       TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 10                     TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
             PERFORM 5950-SET-MNT-TRANS-VARS        THRU 5950-EXIT      
             PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT      
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
           IF  WO-COMMENT-TEXT = I-COMMENT                              
               CONTINUE                                                 
           ELSE                                                         
             IF WO-COMMENT-TEXT > SPACES                                
             OR I-COMMENT  > SPACES                                     
               ADD +1                        TO WS-TRAN-APPL-NO         
               MOVE 'COMMENT'                TO WS-COLUMN-DESC          
               IF  WO-COMMENT-TEXT > SPACES                             
                   MOVE WO-COMMENT-TEXT      TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE WO-COMMENT-LEN       TO WS-PRV-COLUMN-VALUE-LEN 
                   IF WO-COMMENT-LEN > 75                               
                      MOVE 75                TO WS-PRV-COLUMN-VALUE-LEN 
                   END-IF                                               
               ELSE                                                     
                   MOVE '*NEW*'              TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE 5                    TO WS-PRV-COLUMN-VALUE-LEN 
               END-IF                                                   
               IF  I-COMMENT = SPACES                                   
                   MOVE '*DELETED*'          TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE 9                    TO WS-CHG-COLUMN-VALUE-LEN 
               ELSE                                                     
                   MOVE I-COMMENT            TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE I-COMMENT-LEN        TO WS-CHG-COLUMN-VALUE-LEN 
                   IF I-COMMENT-LEN > 75                                
                      MOVE 75                TO WS-CHG-COLUMN-VALUE-LEN 
                   END-IF                                               
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET WH-CR-PL-UPDT             TO TRUE                    
             END-IF                                                     
           END-IF                                                       
           IF  WO-MED-COND-CODE = I-MED-COND-CODE                       
               CONTINUE                                                 
           ELSE                                                         
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'MED COND TYPE'        TO WS-COLUMN-DESC          
                 MOVE '76'                   TO WS-TABLE-ID             
             IF  WO-MED-COND-CODE > SPACES                              
                 MOVE WO-MED-COND-CODE       TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 2                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
             IF  I-MED-COND-CODE = SPACES                               
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-MED-COND-CODE        TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 2                      TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
             PERFORM 5950-SET-MNT-TRANS-VARS        THRU 5950-EXIT      
             PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT      
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
           IF  WO-MEDICAL-COND-DESC-TEXT  = I-MED-COND-DESC             
               CONTINUE                                                 
           ELSE                                                         
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'MED COND DESC'        TO WS-COLUMN-DESC          
             IF  WO-MEDICAL-COND-DESC-TEXT > SPACES                     
                 MOVE WO-MEDICAL-COND-DESC-TEXT                         
                                             TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE WO-MEDICAL-COND-DESC-LEN                          
                                             TO WS-PRV-COLUMN-VALUE-LEN 
                 IF  WS-PRV-COLUMN-VALUE-LEN > +75                      
                     MOVE +75                TO WS-PRV-COLUMN-VALUE-LEN 
                 END-IF                                                 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
             IF  I-MED-COND-DESC = SPACES                               
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-MED-COND-DESC        TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE I-MED-COND-DESC-LEN    TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
             IF  WS-CHG-COLUMN-VALUE-LEN > +75                          
                 MOVE +75                    TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
             PERFORM 5950-SET-MNT-TRANS-VARS        THRU 5950-EXIT      
             PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT      
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
           IF  WO-AMBULANCE-FL  = I-AMBULANCE-FL                        
               CONTINUE                                                 
           ELSE                                                         
                 MOVE '78'                   TO WS-TABLE-ID             
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'AMBULATORY'           TO WS-COLUMN-DESC          
             IF  WO-AMBULANCE-FL > SPACES                               
                 MOVE WO-AMBULANCE-FL        TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
             IF  I-AMBULANCE-FL = SPACES                                
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-AMBULANCE-FL         TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
             PERFORM 5950-SET-MNT-TRANS-VARS        THRU 5950-EXIT      
             PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT      
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF                                                       
           IF  WO-PATIENT-ASSIST-FL = I-PTNT-ASSIST-FL                  
               CONTINUE                                                 
           ELSE                                                         
                 MOVE '78'                   TO WS-TABLE-ID             
                 ADD +1                      TO WS-TRAN-APPL-NO         
                 MOVE 'LEAVE UNASSIST'       TO WS-COLUMN-DESC          
             IF  WO-PATIENT-ASSIST-FL  > SPACES                         
                 MOVE WO-PATIENT-ASSIST-FL   TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-PRV-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                      TO WS-PRV-COLUMN-VALUE-LEN 
             END-IF                                                     
             IF  I-PTNT-ASSIST-FL = SPACES                              
                 MOVE '*DELETED*'            TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                      TO WS-CHG-COLUMN-VALUE-LEN 
             ELSE                                                       
                 MOVE I-PTNT-ASSIST-FL       TO WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 1                      TO WS-CHG-COLUMN-VALUE-LEN 
             END-IF                                                     
             PERFORM 5950-SET-MNT-TRANS-VARS        THRU 5950-EXIT      
             PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT      
             SET WH-CR-PL-UPDT               TO TRUE                    
           END-IF.                                                      
           IF  WO-PATIENT-PH-NO   = I-PTNT-PHONE                        
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                        TO WS-TRAN-APPL-NO         
               MOVE 'PATIENT PHONE'          TO WS-COLUMN-DESC          
               IF  WO-PATIENT-PH-NO  > SPACES                           
                   MOVE  WO-PATIENT-PH-NO    TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE  10                  TO WS-PRV-COLUMN-VALUE-LEN 
               ELSE                                                     
                   MOVE  '*NEW*'             TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE 5                    TO WS-PRV-COLUMN-VALUE-LEN 
               END-IF                                                   
               IF  I-PTNT-PHONE = SPACES                                
                   MOVE '*DELETED*'          TO WS-CHG-COLUMN-VALUE-TEXT
                  MOVE 9                     TO WS-CHG-COLUMN-VALUE-LEN 
               ELSE                                                     
                  MOVE I-PTNT-PHONE          TO WS-CHG-COLUMN-VALUE-TEXT
                  MOVE 10                    TO WS-CHG-COLUMN-VALUE-LEN 
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET WH-CR-PL-UPDT               TO TRUE                  
           END-IF                                                       
           IF  WO-PATIENT-RELATION = I-RELATIONSHIP                     
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                         TO WS-TRAN-APPL-NO        
               MOVE 'RELATIONSHIP'            TO WS-COLUMN-DESC         
               IF  WO-PATIENT-RELATION   > SPACES                       
                   MOVE  WO-PATIENT-RELATION TO WS-PRV-COLUMN-VALUE-TEXT
                   MOVE  15                  TO WS-PRV-COLUMN-VALUE-LEN 
               ELSE                                                     
                  MOVE  '*NEW*'              TO WS-PRV-COLUMN-VALUE-TEXT
                  MOVE 5                     TO WS-PRV-COLUMN-VALUE-LEN 
               END-IF                                                   
               IF  I-RELATIONSHIP = SPACES                              
                   MOVE '*DELETED*'          TO WS-CHG-COLUMN-VALUE-TEXT
                   MOVE 9                    TO WS-CHG-COLUMN-VALUE-LEN 
               ELSE                                                     
                  MOVE I-RELATIONSHIP        TO WS-CHG-COLUMN-VALUE-TEXT
                  MOVE 15                    TO WS-CHG-COLUMN-VALUE-LEN 
               END-IF                                                   
               PERFORM 5950-SET-MNT-TRANS-VARS      THRU 5950-EXIT      
               PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT      
               SET WH-CR-PL-UPDT               TO TRUE                  
           END-IF.                                                      
                                                                        
       2575-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2580-JOURNAL-ACCOUNT.                                       *        
      *                                                                *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
       2580-JOURNAL-DNP-DT.                                             
                                                                        
           MOVE SPACES                       TO WS-TABLE-ID             
           ADD +1                            TO WS-TRAN-APPL-NO         
           EVALUATE CL-CODE-NOTICE-TYPE                                 
               WHEN 'D'                                                 
                  MOVE 'NORMAL DNP'          TO WS-COLUMN-DESC          
               WHEN 'G'                                                 
                  MOVE 'EXCEPTIONAL DNP'     TO WS-COLUMN-DESC          
               WHEN 'H'                                                 
                  MOVE 'RETURNED CK DNP'     TO WS-COLUMN-DESC          
               WHEN 'I'                                                 
                  MOVE 'DEPOSIT DNP'         TO WS-COLUMN-DESC          
           END-EVALUATE                                                 
           MOVE CL-DATE-CREDIT-ACTION        TO WS-PRV-COLUMN-VALUE-TEXT
           MOVE 10                           TO WS-PRV-COLUMN-VALUE-LEN 
           MOVE '*DELETED*'                  TO WS-CHG-COLUMN-VALUE-TEXT
           MOVE 9                            TO WS-CHG-COLUMN-VALUE-LEN 
           PERFORM 5950-SET-MNT-TRANS-VARS          THRU 5950-EXIT      
           PERFORM 6530-LOAD-MNT-TRANS-HIST         THRU 6530-EXIT.     
                                                                        
       2580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2585-JOURNAL-CODE-CRIT.                                     *        
      *                                                                *        
      *    PROCESS THE PARAMETERS TO LOAD INTO TRANSACTION TABLE.      *        
      ******************************************************************        
       2585-JOURNAL-CODE-CRIT.                                          
      *                                                                         
           MOVE 'Q2'                         TO WS-TABLE-ID             
           ADD +1                            TO WS-TRAN-APPL-NO         
           MOVE 'CRITICAL ACCT'              TO WS-COLUMN-DESC          
           IF  AT-CODE-CRIT-OUTAGE > SPACES                             
               MOVE AT-CODE-CRIT-OUTAGE      TO WS-PRV-COLUMN-VALUE-TEXT
               MOVE 2                        TO WS-PRV-COLUMN-VALUE-LEN 
           ELSE                                                         
               MOVE '*NEW*'                  TO WS-PRV-COLUMN-VALUE-TEXT
               MOVE 2                        TO WS-PRV-COLUMN-VALUE-LEN 
           END-IF                                                       
           IF  WS-NEW-CRIT-OUTAGE > SPACES                              
               MOVE WS-NEW-CRIT-OUTAGE       TO WS-CHG-COLUMN-VALUE-TEXT
               MOVE 2                        TO WS-CHG-COLUMN-VALUE-LEN 
           ELSE                                                         
               MOVE '*DELETED*'              TO WS-CHG-COLUMN-VALUE-TEXT
               MOVE 9                        TO WS-CHG-COLUMN-VALUE-LEN 
           END-IF                                                       
           PERFORM 5950-SET-MNT-TRANS-VARS   THRU 5950-EXIT             
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
                                                                        
       2585-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5950-SET-MNT-TRANS-VARS                                        *        
      *      -- THIS MODULE SETS UP THE REMAINING HOST VARIABLES WITH  *        
      *         SYSTEM WORKING STORAGE OR HARD-CODED VALUES FOR        *        
      *         INSERTING INTO THE CSS_MNT_TRANS_HIST AND              *        
      *         CSS_MT_TRN_HST_DET TABLES IN ORDER TO COMPLETE THE     *        
      *         REQUIRED MAINTENANCE TRANSACTION RECORD.               *        
      ******************************************************************        
       5950-SET-MNT-TRANS-VARS.                                         
                                                                        
           MOVE '5950'                      TO ACTIVE-PARAGRAPH.        
           IF  WS-TRAN-APPL-NO = 1                                      
      *                                                                         
               MOVE 'PANEL212'                  TO MH-APPL-PROGRAM-ID   
               MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO 
               MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS        
               MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE    
               MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID      
               MOVE WS-ACCOUNT-NO-COMP3         TO MH-ACCOUNT-NO        
               MOVE 0                           TO MH-CUSTOMER-NO       
               MOVE 0                           TO MH-PREMISE-NO        
               MOVE WS-USERID                   TO MH-USER-ID           
      *                                                                         
              IF I-TRANS-COMMENTS-LEN > ZEROES                          
                 IF  I-UPDATE-FL = 'I'                                  
                     IF  I-TRANS-COMMENTS-LEN > 186                     
                         MOVE 186              TO I-TRANS-COMMENTS-LEN  
                     END-IF                                             
                 ELSE                                                   
A01849               IF  I-TRANS-COMMENTS-LEN > 126                     
A01849                   MOVE 126              TO I-TRANS-COMMENTS-LEN  
                     END-IF                                             
                 END-IF                                                 
                 MOVE I-TRANS-COMMENTS(1:I-TRANS-COMMENTS-LEN)          
                      TO I-TRANS-COMMENTS                               
                 STRING WS-APPEND-COMMENT DELIMITED BY '!'              
                        I-TRANS-COMMENTS DELIMITED BY SIZE              
                   INTO MH-TRAN-COMMENT-TEXT                            
                  MOVE I-TRANS-COMMENTS-LEN    TO MH-TRAN-COMMENT-LEN   
                  ADD WS-APPEND-COMMENT-LEN    TO MH-TRAN-COMMENT-LEN   
              ELSE                                                      
                 STRING WS-APPEND-COMMENT DELIMITED BY '!'              
                                             INTO MH-TRAN-COMMENT-TEXT  
                 MOVE WS-APPEND-COMMENT-LEN    TO MH-TRAN-COMMENT-LEN   
              END-IF                                                    
           END-IF                                                       
           MOVE WS-TABLE-ID                 TO MI-TABLE-ID.             
           MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
           MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       COPY CPD00004.                                                           
      **     *     *     *     *     *     *     *     *     *       ***00110000
      **  6530-LOAD-MNT-TRANS-HIST.                                  ***00120000
      **                                                             ***00130000
      **     *     *     *     *     *     *     *     *     *       ***00140000
       6530-LOAD-MNT-TRANS-HIST.                                        
           MOVE '6530' TO ACTIVE-PARAGRAPH.                             
           IF MI-TRAN-APPL-NO EQUAL 1                                   
              PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT         
           ELSE                                                         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT
           END-IF.        
       6530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6540-INSERT-MNT-TRANS-HIST.                                      
           MOVE '6540' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       
                   CODE_TRAN_TYPE,    RESP_AREA_ID,                     
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,       PREMISE_NO,                       
                   USER_ID,           APPL_PROGRAM_ID,                  
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO), 
              IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),               
                   :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               
                   :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00202600
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                           00202700
MFA-TR*          ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       00202800
MFA-TR*            CODE_TRAN_TYPE,    RESP_AREA_ID,                     00202900
MFA-TR*            ACCOUNT_NO,                                          00203000
MFA-TR*            CUSTOMER_NO,       PREMISE_NO,                       00203300
MFA-TR*            USER_ID,           APPL_PROGRAM_ID,                  00203400
MFA-TR*            TRAN_COMMENT)                                        00204000
MFA-TR*        VALUES                                                   00290000
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO, :MH-DATE-TRANS,               00291000
MFA-TR*            :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             00293000
MFA-TR*            :MH-ACCOUNT-NO,                                      00295000
MFA-TR*            :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               00297000
MFA-TR*            :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          00299000
MFA-TR*            :MH-TRAN-COMMENT)                                    00299300
MFA-TR*    END-EXEC.                                                    00409000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE MH-APPL-PROGRAM-ID TO ABEND-PROGRAM                  
              MOVE '6540'         TO ACTIVE-PARAGRAPH                   
              MOVE 'INSERT'       TO ABEND-FUNCTION                     
              MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                      
              MOVE MH-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1                  
              MOVE MH-CUSTOMER-NO TO HOSTVAR-ELEMENT-2                  
              MOVE MH-PREMISE-NO  TO HOSTVAR-ELEMENT-3                  
              MOVE MH-DATE-TRANS  TO HOSTVAR-ELEMENT-4                  
              MOVE 'ACCOUNT-NO'   TO TABLE-ELEMENT-1                    
              MOVE 'CUSTOMER-NO'  TO TABLE-ELEMENT-2                    
              MOVE 'PREMISE-NO'   TO TABLE-ELEMENT-3                    
              MOVE 'DATE-TRANS'   TO TABLE-ELEMENT-4                    
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       6540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6550-INSERT-MT-TRN-HST-DET.                                      
           MOVE '6550' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
               ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       
                 COLUMN_DESC,       PRV_COLUMN_VALUE,                   
                 CHG_COLUMN_VALUE,                                      
                 TABLE_ID)                                              
               VALUES                                                   
               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO), 
                                                      :MI-TRAN-APPL-NO,        
                 :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           
                 :MI-CHG-COLUMN-VALUE,                                  
                 :MI-TABLE-ID)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00601200
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                           00601300
MFA-TR*        ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       00601600
MFA-TR*          COLUMN_DESC,       PRV_COLUMN_VALUE,                   00601900
MFA-TR*          CHG_COLUMN_VALUE,                                      00602200
MFA-TR*          TABLE_ID)                                              00602300
MFA-TR*        VALUES                                                   00602700
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO, :MI-TRAN-APPL-NO,               00602800
MFA-TR*          :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           00603200
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                  00603500
MFA-TR*          :MI-TABLE-ID)                                          00603600
MFA-TR*    END-EXEC.                                                    00604300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE MH-APPL-PROGRAM-ID TO ABEND-PROGRAM                  
              MOVE '6550'         TO ACTIVE-PARAGRAPH                   
              MOVE 'INSERT'       TO ABEND-FUNCTION                     
              MOVE 'CSS_MT_TRN_HST_DET' TO TABLE-1                      
              MOVE MI-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-1            
              MOVE MI-TRAN-APPL-NO      TO HOSTVAR-ELEMENT-2            
              MOVE MI-COLUMN-DESC       TO HOSTVAR-ELEMENT-3            
              MOVE MH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              MOVE 'TRANS-HIST-SEQ-NO'  TO TABLE-ELEMENT-1              
              MOVE 'TRAN-APPL-NO'       TO TABLE-ELEMENT-2              
              MOVE 'COLUMN-DESC'        TO TABLE-ELEMENT-3              
              MOVE 'ACCOUNT-NO'         TO TABLE-ELEMENT-4              
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       6550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*EJECT                                                            22991909
      ******************************************************************22989309
      *  CHECK DIGITS COPYBOOK.                                        *22989409
      ******************************************************************22989509
                                                                        
           EXEC SQL                                                     22989709
              INCLUDE CPD00071                                          22989809
           END-EXEC.                                                    22989909
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00013                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     22990109
              INCLUDE CPD00090                                          22990209
           END-EXEC.                                                    22990309
                                                                        
           EXEC SQL                                                     22990509
              INCLUDE CPD00091                                          22990609
           END-EXEC.                                                    22990709
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00092                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                            22990909
      *                                                                         
      ******************************************************************        
      * 7000-GET-CURRENT-DATE                                          *        
      *      --THIS MODULE DETERMINES THE CURRENT DATE  FOR THE        *        
      *        MAINTENANCE TRANSACTION RECORD.                         *        
      ******************************************************************        
      *                                                                         
       7000-GET-CURRENT-DATE.                                           
                                                                        
           MOVE '7000'                        TO ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE                            
MFA-TR*             ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE I-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT
           END-IF.     
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-GET-RESP-AREA-ID                                          *        
      *      -- THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION  *        
      *         ACCORDING TO A USERS ID.                               *        
      ******************************************************************        
       7010-GET-RESP-AREA-ID.                                           
                                                                        
      *                                                                         
           MOVE WS-USERID                     TO PF-USER-ID             
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE                                  
                WHERE USER_ID = :PF-USER-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_USER_PROFILE  '       TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE PF-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE I-ACCOUNT-NO               TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
                                                                        
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      7020-GET-DELINQUENCY-VAL                                  *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
       7020-GET-DELINQUENCY-VAL.                                        
      *                                                                 15055600
           MOVE '7020'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                  DELINQ_VALUE                                          
              INTO                                                      
                  :C8-DELINQ-VALUE                                      
              FROM CSS_DELINQUENCY                                      
              WHERE DELINQ_CD  = :C8-DELINQ-CD                          
              AND   COMPANY_NO = :C8-COMPANY-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7020'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-3        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                 15055600
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15055600
      *****************************************************************         
      *                                                                         
      * 7023-GET-DELINQUENCY-DT                                                 
      *                                                                         
      *****************************************************************         
      *                                                                         
       7023-GET-DELINQUENCY-DT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, :WS-NO-OF-DAYS, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DELINQUENCY-DT          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DELINQUENCY-DT =                                          
MFA-TR*           DATE(:WS-CURRENT-DATE) + :WS-NO-OF-DAYS DAYS                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7023'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE 'CURRENT DATE'             TO TABLE-ELEMENT-1        
              MOVE  WS-CURRENT-DATE           TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE  AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT       
              PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT       
      *                                                                         
           END-IF.                                                      
      *                                                                         
       7023-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                                         
      * 7025-GET-EXPIRATION-DT                                                  
      *                                                                         
      *****************************************************************         
      *                                                                         
       7025-GET-EXPIRATION-DT.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CIS.CHAR2$DATE(DATEADD( MONTH, :I-DURATION-MONTH, 
              IIF(TRY_CONVERT(DATE, :I-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :I-EFFECTIVE-DT
              ) <> 0) OR (LEN(:I-EFFECTIVE-DT) <> 10), CIS.CHAR2DATE(
                                                        :I-EFFECTIVE-DT
              ), CONVERT(DATE, :I-EFFECTIVE-DT) ) ), 'USA')
            INTO
              :WS-EXPIRATION-DT 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-EXPIRATION-DT =                                           
MFA-TR*     CHAR(DATE(:I-EFFECTIVE-DT) + :I-DURATION-MONTH MONTHS, USA)         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7025'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE 'EFFECTIVE_DT'             TO TABLE-ELEMENT-1        
              MOVE  I-EFFECTIVE-DT            TO HOSTVAR-ELEMENT-1      
              MOVE 'DURATION '                TO TABLE-ELEMENT-2        
              MOVE  I-DURATION-MONTH          TO HOSTVAR-ELEMENT-2      
              MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-3        
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT       
              PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT       
      *                                                                         
           END-IF.                                                      
      *                                                                         
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  GET THE NEW PHYSICIAN ID                                      *        
      ******************************************************************        
       7030-GET-NEXT-PHYSICIAN-ID.                                      
      *                                                                         
           MOVE '7030'                        TO ACTIVE-PARAGRAPH.      
           EXEC SQL                                                     
               SELECT
              NEXT VALUE FOR SEQ_PY_PHYSICIAN_ID
            INTO
              :PY-PHYSICIAN-ID   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :PY-PHYSICIAN-ID = NEXTVAL FOR SEQ_PY_PHYSICIAN_ID           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE 'CSR03828'                TO ABEND-PROGRAM          
               MOVE '7030'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'SET'                     TO TABLE-1                
               MOVE 'SEQ_PY_PHYSICIAN_ID'     TO TABLE-ELEMENT-1        
               MOVE 'ACCOUNT_NO '             TO TABLE-ELEMENT-2        
               MOVE WO-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7040-SELECT-PTNT-NAME-ID.                                        
                                                                        
           MOVE '7040'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
      *                                                                         
             SELECT NAME_ID                                             
               INTO :WJ-NAME-ID                                         
               FROM CSS_WH_CROSS_SSN                                    
              WHERE SSN = :WJ-SSN                                       
      *                                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_WH_CROSS_SSN'        TO TABLE-1                
               MOVE 'SSN'                     TO TABLE-ELEMENT-1        
               MOVE WJ-SSN                    TO HOSTVAR-ELEMENT-1      
               MOVE 'NAME_ID'                 TO TABLE-ELEMENT-2        
               MOVE WJ-NAME-ID                TO HOSTVAR-ELEMENT-2      
               MOVE 'ACCOUNT_NO '             TO TABLE-ELEMENT-3        
               MOVE WO-ACCOUNT-NO             TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
             END-IF.                                                    
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  GET THE NEW APPLICATION ID                                    *        
      ******************************************************************        
       7050-GET-NEXT-APPLICATION-ID.                                    
      *                                                                         
           MOVE '7050'                        TO ACTIVE-PARAGRAPH.      
           EXEC SQL                                                     
                SELECT
              NEXT VALUE FOR SEQ_WO_APPLICATION_ID
            INTO
              :WO-APPLICATION-ID                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WO-APPLICATION-ID                                          
MFA-TR*             = NEXTVAL FOR SEQ_WO_APPLICATION_ID                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE 'CSR03828'                TO ABEND-PROGRAM          
               MOVE '7050'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'SET'                     TO ABEND-FUNCTION         
               MOVE 'SEQ_PY_APPLICATION_ID'   TO TABLE-ELEMENT-1        
               MOVE 'ACCOUNT_NO '             TO TABLE-ELEMENT-2        
               MOVE WO-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7055-SELECT-PHYSICIAN.                                         *        
      *      -- THIS MODULE SELECTS PHYSICIAN DETAILS                  *        
      *         FROM CSS_PHYSIAN TABLE.                                *        
      ******************************************************************        
       7055-SELECT-PHYSICIAN.                                           
      *                                                                         
           MOVE '7055'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT MED_LIC_STATE_CD                                  
                      ,MED_LICENSE_NO                                   
                      ,NAME_ID                                          
                 INTO :PY-MED-LIC-STATE-CD                              
                     ,:PY-MED-LICENSE-NO                                
                     ,:PY-NAME-ID                                       
                 FROM CSS_PHYSICIAN                                     
                WHERE PHYSICIAN_ID = :PY-PHYSICIAN-ID                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7055'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PHYSICIAN'            TO TABLE-1                
              MOVE 'PHYSICIAN_ID'             TO TABLE-ELEMENT-1        
              MOVE PY-PHYSICIAN-ID            TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
                                                                        
           END-IF.                                                      
      *                                                                         
       7055-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7060-SELECT-NAME.                                                       
      *      -- THIS MODULE SELECTS NAME                               *        
      *         FROM CSS_NAME TABLE.                                   *        
      ******************************************************************        
       7060-SELECT-NAME.                                                
      *                                                                         
           MOVE '7060'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT  FIRST_NAME                                       
                      ,MIDDLE_NAME                                      
                      ,LAST_NAME                                        
                      ,TITLE_PREFIX                                     
                      ,TITLE_SUFFIX_1                                   
                 INTO :DQ-FIRST-NAME                                    
                     ,:DQ-MIDDLE-NAME                                   
                     ,:DQ-LAST-NAME                                     
                     ,:DQ-TITLE-PREFIX                                  
                     ,:DQ-TITLE-SUFFIX-1                                
                 FROM CSS_NAME                                          
                WHERE NAME_ID = :DQ-NAME-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO  DQ-FIRST-NAME                        
                                   DQ-MIDDLE-NAME                       
                                   DQ-LAST-NAME                         
                                   DQ-TITLE-PREFIX                      
                                   DQ-TITLE-SUFFIX-1                    
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7060'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_NAME'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO '         TO TABLE-ELEMENT-1        
                   MOVE WS-ACCOUNT-NO-COMP3   TO HOSTVAR-ELEMENT-1      
                   MOVE 'NAME_ID'             TO TABLE-ELEMENT-2        
                   MOVE DQ-NAME-ID            TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT      
                   PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7065-SELECT-WCP.                                              *         
      *      -- THIS MODULE SELECTS                                    *        
      *         FROM CSS_WH_CROSS_PLUS  TABLE                          *        
      ******************************************************************        
       7065-SELECT-WCP.                                                 
      *                                                                         
           MOVE '7065'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT  APPLICATION_ID                                   
                      ,ACCOUNT_NO                                       
                      ,NAME_ID                                          
                      ,PHYSICIAN_ID                                     
                      ,STATUS_CD                                        
                      ,DATE_TRANS                                       
                      ,COALESCE(CIS.CHAR2$DATE(EFFECTIVE_DT,'USA'),' ')         
                      ,COALESCE(CIS.CHAR2$DATE(EXPIRATION_DT,'USA'),' ')        
                      ,COMMENT                                          
                      ,ADDRESS_ID                                       
                      ,MED_COND_CODE                                    
                      ,MEDICAL_COND_DESC                                
                      ,AMBULANCE_FL                                     
                      ,PATIENT_ASSIST_FL                                
                      ,PATIENT_RELATION                                 
                      ,PATIENT_PH_NO                                    
                 INTO :WO-APPLICATION-ID                                
                     ,:WO-ACCOUNT-NO                                    
                     ,:WO-NAME-ID                                       
                     ,:WO-PHYSICIAN-ID                                  
                     ,:WO-STATUS-CD                                     
                     ,:WO-DATE-TRANS                                    
                     ,:WO-EFFECTIVE-DT                                  
                     ,:WO-EXPIRATION-DT                                 
                     ,:WO-COMMENT                                       
                     ,:WO-ADDRESS-ID                                    
                     ,:WO-MED-COND-CODE                                 
                     ,:WO-MEDICAL-COND-DESC                             
                     ,:WO-AMBULANCE-FL                                  
                     ,:WO-PATIENT-ASSIST-FL                             
                     ,:WO-PATIENT-RELATION                              
                     ,:WO-PATIENT-PH-NO                                 
                 FROM CSS_WH_CROSS_PLUS                                 
                WHERE ACCOUNT_NO     = :WO-ACCOUNT-NO                   
                  AND APPLICATION_ID = :WO-APPLICATION-ID               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  APPLICATION_ID                                           
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,NAME_ID                                                  
MFA-TR*               ,PHYSICIAN_ID                                             
MFA-TR*               ,STATUS_CD                                                
MFA-TR*               ,DATE_TRANS                                               
MFA-TR*               ,IFNULL(CHAR(EFFECTIVE_DT,USA),' ')                       
MFA-TR*               ,IFNULL(CHAR(EXPIRATION_DT,USA),' ')                      
MFA-TR*               ,COMMENT                                                  
MFA-TR*               ,ADDRESS_ID                                               
MFA-TR*               ,MED_COND_CODE                                            
MFA-TR*               ,MEDICAL_COND_DESC                                        
MFA-TR*               ,AMBULANCE_FL                                             
MFA-TR*               ,PATIENT_ASSIST_FL                                        
MFA-TR*               ,PATIENT_RELATION                                         
MFA-TR*               ,PATIENT_PH_NO                                            
MFA-TR*          INTO :WO-APPLICATION-ID                                        
MFA-TR*              ,:WO-ACCOUNT-NO                                            
MFA-TR*              ,:WO-NAME-ID                                               
MFA-TR*              ,:WO-PHYSICIAN-ID                                          
MFA-TR*              ,:WO-STATUS-CD                                             
MFA-TR*              ,:WO-DATE-TRANS                                            
MFA-TR*              ,:WO-EFFECTIVE-DT                                          
MFA-TR*              ,:WO-EXPIRATION-DT                                         
MFA-TR*              ,:WO-COMMENT                                               
MFA-TR*              ,:WO-ADDRESS-ID                                            
MFA-TR*              ,:WO-MED-COND-CODE                                         
MFA-TR*              ,:WO-MEDICAL-COND-DESC                                     
MFA-TR*              ,:WO-AMBULANCE-FL                                          
MFA-TR*              ,:WO-PATIENT-ASSIST-FL                                     
MFA-TR*              ,:WO-PATIENT-RELATION                                      
MFA-TR*              ,:WO-PATIENT-PH-NO                                         
MFA-TR*          FROM CSS_WH_CROSS_PLUS                                         
MFA-TR*         WHERE ACCOUNT_NO     = :WO-ACCOUNT-NO                           
MFA-TR*           AND APPLICATION_ID = :WO-APPLICATION-ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7065'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_WH_CROSS_PLUS'        TO TABLE-1                
              MOVE 'APPLICATION_ID'           TO TABLE-ELEMENT-1        
              MOVE WO-APPLICATION-ID          TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
                                                                        
           END-IF.                                                      
      *                                                                         
       7065-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7070-SELECT-ADDR-FORMATTED.                                    *        
      *      -- THIS MODULE SELECTS                                    *        
      *         FROM CSS_ADDR_FORMATTED TABLE                          *        
      ******************************************************************        
       7070-SELECT-ADDR-FORMATTED.                                      
      *                                                                         
           MOVE '7070'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT  ADDRESS_ID                                       
                      ,HOUSE_NO                                         
                      ,ADDR_PREFIX_1                                    
                      ,ADDR_PREFIX_2                                    
                      ,STREET_NAME                                      
                      ,STREET_LOCATION_1                                
                      ,STREET_LOCATION_2                                
                      ,STREET_SUFFIX                                    
                      ,ADDRESS_OVERFLOW                                 
                      ,CARRIER_ROUTE                                    
                      ,ZIP_CODE                                         
                      ,ZIP_CODE_PLUS_FOUR                               
                      ,ZIP_CODE_TOKEN                                   
                      ,ADDR_USAGE_CD                                    
                      ,ADDR_SUFFIX                                      
                      ,USPS_DELIV_PT_CD                                 
                 INTO :DY-ADDRESS-ID                                    
                     ,:DY-HOUSE-NO                                      
                     ,:DY-ADDR-PREFIX-1                                 
                     ,:DY-ADDR-PREFIX-2                                 
                     ,:DY-STREET-NAME                                   
                     ,:DY-STREET-LOCATION-1                             
                     ,:DY-STREET-LOCATION-2                             
                     ,:DY-STREET-SUFFIX                                 
                     ,:DY-ADDRESS-OVERFLOW                              
                     ,:DY-CARRIER-ROUTE                                 
                     ,:DY-ZIP-CODE                                      
                     ,:DY-ZIP-CODE-PLUS-FOUR                            
                     ,:DY-ZIP-CODE-TOKEN                                
                     ,:DY-ADDR-USAGE-CD                                 
                     ,:DY-ADDR-SUFFIX                                   
                     ,:DY-USPS-DELIV-PT-CD                              
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES                TO DY-HOUSE-NO            
                                                 DY-ADDR-PREFIX-1       
                                                 DY-ADDR-PREFIX-2       
                                                 DY-STREET-NAME         
                                                 DY-STREET-LOCATION-1   
                                                 DY-STREET-LOCATION-2   
                                                 DY-STREET-SUFFIX       
                                                 DY-ADDRESS-OVERFLOW    
                                                 DY-ZIP-CODE            
                                                 DY-ZIP-CODE-PLUS-FOUR  
                                                 DY-ZIP-CODE-TOKEN      
                                                 DY-ADDR-SUFFIX         
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7070'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                
                   MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1        
                   MOVE DY-ADDRESS-ID         TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
                   MOVE WO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT      
                   PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7080-SEL-PHY-MED-LIC-STATE.                                    *        
      *      -- THIS MODULE SELECTS PHYSICIAN DETAILS                  *        
      *         FROM CSS_PHYSIAN TABLE BASED ON LICENCE NO AND STATE CD*        
      ******************************************************************        
       7080-SEL-PHY-MED-LIC-STATE.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT PHYSICIAN_ID                                      
                     ,NAME_ID                                           
                 INTO :PY-PHYSICIAN-ID                                  
                     ,:PY-NAME-ID                                       
                 FROM CSS_PHYSICIAN                                     
                WHERE MED_LIC_STATE_CD = :I-MED-LIC-STATE-CD            
                  AND   MED_LICENSE_NO = :I-MED-LICENCE-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR NOT-FOUND                                                 
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7080'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PHYSICIAN'            TO TABLE-1                
              MOVE 'MED_LIC_STATE_CD'         TO TABLE-ELEMENT-1        
              MOVE I-MED-LIC-STATE-CD         TO HOSTVAR-ELEMENT-1      
              MOVE 'MED_LICENSE_NO'           TO TABLE-ELEMENT-2        
              MOVE I-MED-LICENCE-NO           TO HOSTVAR-ELEMENT-2      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
                                                                        
           END-IF.                                                      
      *                                                                         
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7085-SELECT-CRIT-OUTAGE                                        *        
      *      -- THIS MODULE SELECTS CODE_CRIT_OUTAGE                   *        
      *         FROM CSS_ACCOUNT TABLE.                                *        
      ******************************************************************        
       7085-SELECT-CRIT-OUTAGE.                                         
      *                                                                         
           MOVE '7085'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT  CODE_CRIT_OUTAGE                                 
                       ,COMPANY_NO                                      
                 INTO :AT-CODE-CRIT-OUTAGE                              
                     ,:AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7085'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
                                                                        
           END-IF.                                                      
      *                                                                         
       7085-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7089-SELECT-PTNT-CONTACT.                                               
      *                                                                         
      *    SELECT FROM WH_CROSS_PATNT                                           
      *                                                                         
      *****************************************************************         
       7089-SELECT-PTNT-CONTACT.                                        
                                                                        
               EXEC SQL                                                 
                  SELECT COALESCE(CIS.CHAR2$DATE(PATIENT_DOB,'USA'),' ')        
                    INTO :WP-PATIENT-DOB                                
                    FROM CSS_WH_CROSS_PATNT                             
                   WHERE NAME_ID = :WP-NAME-ID                          
                END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT IFNULL(CHAR(PATIENT_DOB,USA),' ')                      
MFA-TR*             INTO :WP-PATIENT-DOB                                        
MFA-TR*             FROM CSS_WH_CROSS_PATNT                                     
MFA-TR*            WHERE NAME_ID = :WP-NAME-ID                                  
MFA-TR*         END-EXEC.                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7089'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_WH_CROSS_PATNT'      TO TABLE-1                
               MOVE 'NAME_ID'                 TO TABLE-ELEMENT-1        
               MOVE WP-NAME-ID                TO HOSTVAR-ELEMENT-1      
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2        
               MOVE WO-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       7089-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7090-SELECT-PHY-CONTACT.                                                
      *                                                                         
      *    SELECT FROM  CSS_PHYSICIAN_ATTR                                      
      *                                                                         
      *****************************************************************         
       7090-SELECT-PHY-CONTACT.                                         
      *                                                                         
               EXEC SQL                                                 
                  SELECT ADDRESS_ID                                     
                        ,EXTENSION_NO                                   
                        ,PHONE_NO                                       
                   INTO                                                 
                         :PA-ADDRESS-ID                                 
                        ,:PA-EXTENSION-NO                               
                        ,:PA-PHONE-NO                                   
                   FROM  CSS_PHYSICIAN_ATTR                             
                 WHERE PHYSICIAN_ID  = :PA-PHYSICIAN-ID                 
                   AND ADDRESS_ID    = :PA-ADDRESS-ID                   
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
           OR  NOT-FOUND                                                
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7090'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_PHYSICIAN_ATTR'      TO TABLE-1                
               MOVE 'PHYSICIAN_ID'            TO TABLE-ELEMENT-1        
               MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-2        
               MOVE PA-PHYSICIAN-ID           TO HOSTVAR-ELEMENT-1      
               MOVE PA-ADDRESS-ID             TO HOSTVAR-ELEMENT-2      
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3        
               MOVE WO-ACCOUNT-NO             TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7100-SELECT-ADDRESS-ID.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y',
              ADDRESS_ID                                       
                INTO  :WS-EXACT-MATCH                                   
                     ,:DY-ADDRESS-ID                                    
                FROM   CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                 
               WHERE   HOUSE_NO            = :DY-HOUSE-NO               
                 AND   ADDR_PREFIX_1       = :DY-ADDR-PREFIX-1          
                 AND   ADDR_PREFIX_2       = :DY-ADDR-PREFIX-2          
                 AND   STREET_NAME         = :DY-STREET-NAME            
                 AND   STREET_SUFFIX       = :DY-STREET-SUFFIX          
                 AND   STREET_LOCATION_1   = :DY-STREET-LOCATION-1      
                 AND   STREET_LOCATION_2   = :DY-STREET-LOCATION-2      
                 AND   ADDRESS_OVERFLOW    = :DY-ADDRESS-OVERFLOW       
                 AND   ZIP_CODE            = :DY-ZIP-CODE               
                 AND   ZIP_CODE_PLUS_FOUR  = :DY-ZIP-CODE-PLUS-FOUR     
                 AND   ZIP_CODE_TOKEN      = :DY-ZIP-CODE-TOKEN         
                 AND   ADDR_USAGE_CD       = 'F'                        
                 AND   ADDR_SUFFIX         = :DY-ADDR-SUFFIX            
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   'Y'                                                      
MFA-TR*               ,ADDRESS_ID                                               
MFA-TR*         INTO  :WS-EXACT-MATCH                                           
MFA-TR*              ,:DY-ADDRESS-ID                                            
MFA-TR*         FROM   CSS_ADDR_FORMATTED                                       
MFA-TR*        WHERE   HOUSE_NO            = :DY-HOUSE-NO                       
MFA-TR*          AND   ADDR_PREFIX_1       = :DY-ADDR-PREFIX-1                  
MFA-TR*          AND   ADDR_PREFIX_2       = :DY-ADDR-PREFIX-2                  
MFA-TR*          AND   STREET_NAME         = :DY-STREET-NAME                    
MFA-TR*          AND   STREET_SUFFIX       = :DY-STREET-SUFFIX                  
MFA-TR*          AND   STREET_LOCATION_1   = :DY-STREET-LOCATION-1              
MFA-TR*          AND   STREET_LOCATION_2   = :DY-STREET-LOCATION-2              
MFA-TR*          AND   ADDRESS_OVERFLOW    = :DY-ADDRESS-OVERFLOW               
MFA-TR*          AND   ZIP_CODE            = :DY-ZIP-CODE                       
MFA-TR*          AND   ZIP_CODE_PLUS_FOUR  = :DY-ZIP-CODE-PLUS-FOUR             
MFA-TR*          AND   ZIP_CODE_TOKEN      = :DY-ZIP-CODE-TOKEN                 
MFA-TR*          AND   ADDR_USAGE_CD       = 'F'                                
MFA-TR*          AND   ADDR_SUFFIX         = :DY-ADDR-SUFFIX                    
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF  WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL             
           OR  NOT-FOUND                                                
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7100'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-1                
               MOVE 'ACCOUNT_NO '             TO TABLE-ELEMENT-1        
               MOVE 'STREET_NAME'             TO TABLE-ELEMENT-2        
               MOVE 'ZIP_CODE'                TO TABLE-ELEMENT-3        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-1      
               MOVE DY-STREET-NAME            TO HOSTVAR-ELEMENT-2      
               MOVE DY-ZIP-CODE               TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       7110-SELECT-PTNT-SSN.                                            
                                                                        
           MOVE '7110'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
      *                                                                         
             SELECT SSN                                                 
               INTO :WJ-SSN                                             
               FROM CSS_WH_CROSS_SSN                                    
              WHERE NAME_ID = :WJ-NAME-ID                               
      *                                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_WH_CROSS_SSN'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-1      
               MOVE 'NAME_ID'                 TO TABLE-ELEMENT-2        
               MOVE WJ-NAME-ID                TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
             END-IF.                                                    
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7120-SELECT-WHITE-CROSS-PLUS.                                    
                                                                        
           MOVE '7120'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
      *                                                                         
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-WCP-FLAG                                        
               FROM CSS_WH_CROSS_PLUS                                   
              WHERE ACCOUNT_NO = :WO-ACCOUNT-NO                         
                AND STATUS_CD  = 'A'                                    
                                                    
      *                                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-WCP-FLAG                                                
MFA-TR*        FROM CSS_WH_CROSS_PLUS                                           
MFA-TR*       WHERE ACCOUNT_NO = :WO-ACCOUNT-NO                                 
MFA-TR*         AND STATUS_CD  = 'A'                                            
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_WH_CROSS_PLUS'       TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
             END-IF.                                                    
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04270000
      * 7130-OPEN-DNP-CURSOR.                                          *04240000
      *  OPENS THE CURSOR FOR PROCESSING                               *04250000
      *                                                                *04260000
      ******************************************************************04270000
       7130-OPEN-DNP-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              OPEN DNP_CSR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7130'                   TO ACTIVE-PARAGRAPH        
               MOVE 'OPEN'                   TO ABEND-FUNCTION          
               MOVE 'CSS_CRED_COLL'          TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                 04440000
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04480000
      *                                                                *04490000
      *   7140-FETCH-DNP-CURSOR.                                       *04500000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR               *04510000
      *                                                                *04520000
      ******************************************************************04530000
       7140-FETCH-DNP-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               FETCH DNP_CSR                                            
                INTO :CL-CODE-NOTICE-TYPE                               
                    ,:CL-DATE-CREDIT-ACTION                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE 'Y'                   TO WS-END-OF-ROWS          
              END-IF                                                    
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7140'                   TO ACTIVE-PARAGRAPH        
               MOVE 'FETCH'                  TO ABEND-FUNCTION          
               MOVE 'CSS_CRED_COLL'          TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7150-CLOSE-DNP-CURSOR.                                     **         
      **                                                             **         
      **  THIS PARAGRAPH CLOSES THE MAIN PROCESSING CURSOR.          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7150-CLOSE-DNP-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              CLOSE DNP_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7150'                   TO ACTIVE-PARAGRAPH        
               MOVE 'CLOSE'                  TO ABEND-FUNCTION          
               MOVE 'CSS_CRED_COLL'          TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7160-SELECT-WHITE-CROSS.                                       *        
      *      -- THIS MODULE CHECKS IF WHITE CROSS EXISTS ON THIS ACCT  *        
      ******************************************************************        
       7160-SELECT-WHITE-CROSS.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
               INTO   :WS-WHITE-CROSS-FLAG                              
              FROM    CSS_ACCT_WHT_CROSS                                
              WHERE   ACCOUNT_NO = :WO-ACCOUNT-NO                       
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     21800000
MFA-TR*       SELECT 'Y'                                                21810000
MFA-TR*        INTO   :WS-WHITE-CROSS-FLAG                                      
MFA-TR*       FROM    CSS_ACCT_WHT_CROSS                                22170000
MFA-TR*       WHERE   ACCOUNT_NO = :WO-ACCOUNT-NO                       22180000
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*    END-EXEC.                                                    22190000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7160'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCT_WHT_CROSS'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8000-INSERT-PHY-NAME.                                                   
      *                                                                         
      *    INSERTS A ROW INTO TABLE CSS_NAME.                                   
      *****************************************************************         
       8000-INSERT-NAME.                                                
      *                                                                         
               EXEC SQL                                                 
                   INSERT INTO CSS_NAME                                 
                       (NAME_ID                                         
                       ,NAME_TYPE                                       
                       ,NAME_FORMAT                                     
                       ,CREATED_DATE                                    
                       ,TITLE_PREFIX                                    
                       ,FIRST_NAME                                      
                       ,MIDDLE_NAME                                     
                       ,LAST_NAME                                       
                       ,NICKNAME                                        
                       ,TITLE_SUFFIX_1                                  
                       ,TITLE_SUFFIX_2                                  
                       ,FULL_NAME)                                      
                   VALUES                                               
                        (:DQ-NAME-ID                                    
                        ,:DQ-NAME-TYPE                                  
                        ,:DQ-NAME-FORMAT                                
                        ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP)              
                        ,:DQ-TITLE-PREFIX                               
                        ,:DQ-FIRST-NAME                                 
                        ,:DQ-MIDDLE-NAME                                
                        ,:DQ-LAST-NAME                                  
                        ,:DQ-NICKNAME                                   
                        ,:DQ-TITLE-SUFFIX-1                             
                        ,:DQ-TITLE-SUFFIX-2                             
                        ,:DQ-FULL-NAME)                                 
                END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                         
MFA-TR*            INSERT INTO CSS_NAME                                         
MFA-TR*                (NAME_ID                                                 
MFA-TR*                ,NAME_TYPE                                               
MFA-TR*                ,NAME_FORMAT                                             
MFA-TR*                ,CREATED_DATE                                            
MFA-TR*                ,TITLE_PREFIX                                            
MFA-TR*                ,FIRST_NAME                                              
MFA-TR*                ,MIDDLE_NAME                                             
MFA-TR*                ,LAST_NAME                                               
MFA-TR*                ,NICKNAME                                                
MFA-TR*                ,TITLE_SUFFIX_1                                          
MFA-TR*                ,TITLE_SUFFIX_2                                          
MFA-TR*                ,FULL_NAME)                                              
MFA-TR*            VALUES                                                       
MFA-TR*                 (:DQ-NAME-ID                                            
MFA-TR*                 ,:DQ-NAME-TYPE                                          
MFA-TR*                 ,:DQ-NAME-FORMAT                                        
MFA-TR*                 ,:WS-CURRENT-TIMESTAMP                                  
MFA-TR*                 ,:DQ-TITLE-PREFIX                                       
MFA-TR*                 ,:DQ-FIRST-NAME                                         
MFA-TR*                 ,:DQ-MIDDLE-NAME                                        
MFA-TR*                 ,:DQ-LAST-NAME                                          
MFA-TR*                 ,:DQ-NICKNAME                                           
MFA-TR*                 ,:DQ-TITLE-SUFFIX-1                                     
MFA-TR*                 ,:DQ-TITLE-SUFFIX-2                                     
MFA-TR*                 ,:DQ-FULL-NAME)                                         
MFA-TR*         END-EXEC.                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'INSERT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_NAME'                TO TABLE-1                
               MOVE 'NAME_ID'                 TO TABLE-ELEMENT-1        
               MOVE 'NAME_TYPE'               TO TABLE-ELEMENT-2        
               MOVE 'FIRST_NAME'              TO TABLE-ELEMENT-4        
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-3      
               MOVE DQ-NAME-ID                TO HOSTVAR-ELEMENT-1      
               MOVE DQ-NAME-TYPE              TO HOSTVAR-ELEMENT-2      
               MOVE DQ-FIRST-NAME             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8010-INSERT-PHY-DETAIL.                                                 
      *                                                                         
      *    INSERT PHYSICIAN DETAIL                                              
      *    INSERTS A ROW INTO TABLE CSS_PHYSICIAN.                              
      *****************************************************************         
       8010-INSERT-PHY-DETAIL.                                          
      *                                                                         
               EXEC SQL                                                 
                   INSERT INTO CSS_PHYSICIAN                            
                       (PHYSICIAN_ID                                    
                       ,MED_LIC_STATE_CD                                
                       ,MED_LICENSE_NO                                  
                       ,NAME_ID)                                        
                   VALUES                                               
                        (:PY-PHYSICIAN-ID                               
                        ,:PY-MED-LIC-STATE-CD                           
                        ,:PY-MED-LICENSE-NO                             
                        ,:PY-NAME-ID)                                   
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8010'                    TO ACTIVE-PARAGRAPH       
               MOVE 'INSERT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_PHYSICIAN'           TO TABLE-1                
               MOVE 'PHYSICIAN_ID'            TO TABLE-ELEMENT-1        
               MOVE 'MED_LIC_STATE_CD'        TO TABLE-ELEMENT-2        
               MOVE 'MED_LICENSE_NO'          TO TABLE-ELEMENT-3        
               MOVE PY-PHYSICIAN-ID           TO HOSTVAR-ELEMENT-1      
               MOVE PY-MED-LIC-STATE-CD       TO HOSTVAR-ELEMENT-2      
               MOVE PY-MED-LICENSE-NO         TO HOSTVAR-ELEMENT-3      
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-4      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8020-INSERT-PHY-ADDRESS.                                                
      *                                                                         
      *    INSERT PHYSICIAN ADDRESS                                             
      *                                                                         
      *****************************************************************         
       8020-INSERT-PHY-ADDRESS.                                         
      *                                                                         
               EXEC SQL                                                 
                   INSERT INTO CSS_ADDR_FORMATTED                       
                       (ADDRESS_ID                                      
                       ,HOUSE_NO                                        
                       ,ADDR_PREFIX_1                                   
                       ,ADDR_PREFIX_2                                   
                       ,STREET_NAME                                     
                       ,STREET_LOCATION_1                               
                       ,STREET_LOCATION_2                               
                       ,STREET_SUFFIX                                   
                       ,ADDRESS_OVERFLOW                                
                       ,CARRIER_ROUTE                                   
                       ,ZIP_CODE                                        
                       ,ZIP_CODE_PLUS_FOUR                              
                       ,ZIP_CODE_TOKEN                                  
                       ,ADDR_USAGE_CD                                   
                       ,ADDR_SUFFIX                                     
                       ,USPS_DELIV_PT_CD)                               
                   VALUES                                               
                        (:DY-ADDRESS-ID                                 
                        ,:DY-HOUSE-NO                                   
                        ,:DY-ADDR-PREFIX-1                              
                        ,:DY-ADDR-PREFIX-2                              
                        ,:DY-STREET-NAME                                
                        ,:DY-STREET-LOCATION-1                          
                        ,:DY-STREET-LOCATION-2                          
                        ,:DY-STREET-SUFFIX                              
                        ,:DY-ADDRESS-OVERFLOW                           
                        ,:DY-CARRIER-ROUTE                              
                        ,:DY-ZIP-CODE                                   
                        ,:DY-ZIP-CODE-PLUS-FOUR                         
                        ,:DY-ZIP-CODE-TOKEN                             
                        ,:DY-ADDR-USAGE-CD                              
                        ,:DY-ADDR-SUFFIX                                
                        ,:DY-USPS-DELIV-PT-CD)                          
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8020'                    TO ACTIVE-PARAGRAPH       
               MOVE 'INSERT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-4      
               MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-1        
               MOVE 'STREET_NAME'             TO TABLE-ELEMENT-2        
               MOVE 'ZIP_CODE'                TO TABLE-ELEMENT-3        
               MOVE DY-ADDRESS-ID             TO HOSTVAR-ELEMENT-1      
               MOVE DY-STREET-NAME            TO HOSTVAR-ELEMENT-2      
               MOVE DY-ZIP-CODE               TO HOSTVAR-ELEMENT-3      
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4        
               MOVE WO-ACCOUNT-NO             TO HOSTVAR-ELEMENT-4      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8030-INSERT-PHY-ATTR.                                                   
      *                                                                         
      *    INSERT PHYSICIAN ATTRIBUTES                                          
      *                                                                         
      *****************************************************************         
       8030-INSERT-PHY-ATTR.                                            
      *                                                                         
               EXEC SQL                                                 
                   INSERT INTO CSS_PHYSICIAN_ATTR                       
                       (PHYSICIAN_ID                                    
                       ,ADDRESS_ID                                      
                       ,EXTENSION_NO                                    
                       ,PHONE_NO)                                       
                   VALUES                                               
                        (:PA-PHYSICIAN-ID                               
                        ,:PA-ADDRESS-ID                                 
                        ,:PA-EXTENSION-NO                               
                        ,:PA-PHONE-NO)                                  
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8030'                    TO ACTIVE-PARAGRAPH       
               MOVE 'INSERT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_PHYSICIAN_ATTR'      TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-4      
               MOVE 'PHYSICIAN_ID'            TO TABLE-ELEMENT-1        
               MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-2        
               MOVE 'PHONE_NO'                TO TABLE-ELEMENT-3        
               MOVE PA-PHYSICIAN-ID           TO HOSTVAR-ELEMENT-1      
               MOVE PA-ADDRESS-ID             TO HOSTVAR-ELEMENT-2      
               MOVE PA-PHONE-NO               TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8040-INSERT-CROSS-PLUS                                                  
      *                                                                         
      *    INSERT INTO WH_CROSS_PLUS                                            
      *                                                                         
      *****************************************************************         
       8040-INSERT-CROSS-PLUS.                                          
      *                                                                         
           IF  WO-EFFECTIVE-DT = SPACES OR LOW-VALUES                   
               MOVE -1         TO WS-NULL-IND-EFF                       
           ELSE                                                         
               MOVE 0          TO WS-NULL-IND-EFF                       
           END-IF                                                       
      *                                                                         
           IF  WO-EXPIRATION-DT = SPACES OR LOW-VALUES                  
               MOVE -1         TO WS-NULL-IND-EXP                       
           ELSE                                                         
               MOVE 0          TO WS-NULL-IND-EXP                       
           END-IF                                                       
      *                                                                         
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_WH_CROSS_PLUS                            
                   (APPLICATION_ID                                      
                   ,ACCOUNT_NO                                          
                   ,NAME_ID                                             
                   ,PHYSICIAN_ID                                        
                   ,STATUS_CD                                           
                   ,DATE_TRANS                                          
                   ,EFFECTIVE_DT                                        
                   ,EXPIRATION_DT                                       
                   ,COMMENT                                             
                   ,ADDRESS_ID                                          
                   ,MED_COND_CODE                                       
                   ,MEDICAL_COND_DESC                                   
                   ,AMBULANCE_FL                                        
                   ,PATIENT_ASSIST_FL                                   
                   ,PATIENT_RELATION                                    
                   ,PATIENT_PH_NO)                                      
               VALUES                                                   
                    (:WO-APPLICATION-ID                                 
                    ,:WO-ACCOUNT-NO                                     
                    ,:WO-NAME-ID                                        
                    ,:WO-PHYSICIAN-ID                                   
                    ,:WO-STATUS-CD                                      
                    ,IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                             
                    ,CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, 
                                                      :WO-EFFECTIVE-DT 
                                                       :WS-NULL-IND-EFF
              ) IS NULL OR (PATINDEX('%.%', :WO-EFFECTIVE-DT 
                                                       :WS-NULL-IND-EFF
              ) <> 0) OR (LEN(:WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ) <> 10), CIS.CHAR2DATE(:WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ), CONVERT(DATE, :WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ) ),'ISO')   
                    ,CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, 
                                                     :WO-EXPIRATION-DT 
                                                       :WS-NULL-IND-EXP
              ) IS NULL OR (PATINDEX('%.%', :WO-EXPIRATION-DT 
                                                       :WS-NULL-IND-EXP
              ) <> 0) OR (LEN(:WO-EXPIRATION-DT :WS-NULL-IND-EXP
              ) <> 10), CIS.CHAR2DATE(:WO-EXPIRATION-DT 
                                                       :WS-NULL-IND-EXP
              ), CONVERT(DATE, :WO-EXPIRATION-DT :WS-NULL-IND-EXP
              ) ),'ISO')  
                    ,:WO-COMMENT                                        
                    ,:WO-ADDRESS-ID                                     
                    ,:WO-MED-COND-CODE                                  
                    ,:WO-MEDICAL-COND-DESC                              
                    ,:WO-AMBULANCE-FL                                   
                    ,:WO-PATIENT-ASSIST-FL                              
                    ,:WO-PATIENT-RELATION                               
                    ,:WO-PATIENT-PH-NO)                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_WH_CROSS_PLUS                                    
MFA-TR*            (APPLICATION_ID                                              
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,NAME_ID                                                     
MFA-TR*            ,PHYSICIAN_ID                                                
MFA-TR*            ,STATUS_CD                                                   
MFA-TR*            ,DATE_TRANS                                                  
MFA-TR*            ,EFFECTIVE_DT                                                
MFA-TR*            ,EXPIRATION_DT                                               
MFA-TR*            ,COMMENT                                                     
MFA-TR*            ,ADDRESS_ID                                                  
MFA-TR*            ,MED_COND_CODE                                               
MFA-TR*            ,MEDICAL_COND_DESC                                           
MFA-TR*            ,AMBULANCE_FL                                                
MFA-TR*            ,PATIENT_ASSIST_FL                                           
MFA-TR*            ,PATIENT_RELATION                                            
MFA-TR*            ,PATIENT_PH_NO)                                              
MFA-TR*        VALUES                                                           
MFA-TR*             (:WO-APPLICATION-ID                                         
MFA-TR*             ,:WO-ACCOUNT-NO                                             
MFA-TR*             ,:WO-NAME-ID                                                
MFA-TR*             ,:WO-PHYSICIAN-ID                                           
MFA-TR*             ,:WO-STATUS-CD                                              
MFA-TR*             ,:WS-CURRENT-DATE                                           
MFA-TR*             ,CHAR(DATE(:WO-EFFECTIVE-DT:WS-NULL-IND-EFF),ISO)           
MFA-TR*             ,CHAR(DATE(:WO-EXPIRATION-DT:WS-NULL-IND-EXP),ISO)          
MFA-TR*             ,:WO-COMMENT                                                
MFA-TR*             ,:WO-ADDRESS-ID                                             
MFA-TR*             ,:WO-MED-COND-CODE                                          
MFA-TR*             ,:WO-MEDICAL-COND-DESC                                      
MFA-TR*             ,:WO-AMBULANCE-FL                                           
MFA-TR*             ,:WO-PATIENT-ASSIST-FL                                      
MFA-TR*             ,:WO-PATIENT-RELATION                                       
MFA-TR*             ,:WO-PATIENT-PH-NO)                                         
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8040'                    TO ACTIVE-PARAGRAPH       
               MOVE 'INSERT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_WH_CROSS_PLUS'       TO TABLE-1                
               MOVE 'APPLICATION_ID'          TO TABLE-ELEMENT-1        
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2        
               MOVE 'NAME_ID'                 TO TABLE-ELEMENT-3        
               MOVE 'PHYSICIAN_ID'            TO TABLE-ELEMENT-4        
               MOVE WO-APPLICATION-ID         TO HOSTVAR-ELEMENT-1      
               MOVE WO-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2      
               MOVE WO-NAME-ID                TO HOSTVAR-ELEMENT-3      
               MOVE WO-PHYSICIAN-ID           TO HOSTVAR-ELEMENT-4      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8050-INSERT-WCP-PTNT                                                    
      *                                                                         
      *    INSERT INTO WH_CROSS_PATNT                                           
      *                                                                         
      *****************************************************************         
       8050-INSERT-WCP-PTNT.                                            
      *                                                                         
           IF  WP-PATIENT-DOB = SPACES OR LOW-VALUES                    
               MOVE -1          TO WS-NULL-IND-DOB                      
           ELSE                                                         
               MOVE 0           TO WS-NULL-IND-DOB                      
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_WH_CROSS_PATNT                           
                   (NAME_ID                                             
                   ,PATIENT_DOB)                                        
               VALUES                                                   
                    (:WP-NAME-ID                                        
                    ,CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, 
                                                       :WP-PATIENT-DOB 
                                                       :WS-NULL-IND-DOB
              ) IS NULL OR (PATINDEX('%.%', :WP-PATIENT-DOB 
                                                       :WS-NULL-IND-DOB
              ) <> 0) OR (LEN(:WP-PATIENT-DOB :WS-NULL-IND-DOB
              ) <> 10), CIS.CHAR2DATE(:WP-PATIENT-DOB :WS-NULL-IND-DOB
              ), CONVERT(DATE, :WP-PATIENT-DOB :WS-NULL-IND-DOB
              ) ),'ISO'))   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_WH_CROSS_PATNT                                   
MFA-TR*            (NAME_ID                                                     
MFA-TR*            ,PATIENT_DOB)                                                
MFA-TR*        VALUES                                                           
MFA-TR*             (:WP-NAME-ID                                                
MFA-TR*             ,CHAR(DATE(:WP-PATIENT-DOB:WS-NULL-IND-DOB),ISO))           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8050'                    TO ACTIVE-PARAGRAPH       
               MOVE 'INSERT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_WH_CROSS_PATNT'      TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-4      
               MOVE 'NAME_ID'                 TO TABLE-ELEMENT-1        
               MOVE 'PATIENT_DOB'             TO TABLE-ELEMENT-2        
               MOVE WP-NAME-ID                TO HOSTVAR-ELEMENT-1      
               MOVE WP-PATIENT-DOB            TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8055-UPDATE-WCP-PTNT                                                    
      *                                                                         
      *    UPDATE WH_CROSS_PATNT                                                
      *                                                                         
      *****************************************************************         
       8055-UPDATE-WCP-PTNT.                                            
      *                                                                         
           IF  WP-PATIENT-DOB = SPACES OR LOW-VALUES                    
               MOVE -1          TO WS-NULL-IND-DOB                      
           ELSE                                                         
               MOVE 0           TO WS-NULL-IND-DOB                      
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_WH_CROSS_PATNT                                
                  SET PATIENT_DOB = CIS.CHAR2$DATE(
              IIF(TRY_CONVERT(DATE, :WP-PATIENT-DOB :WS-NULL-IND-DOB
              ) IS NULL OR (PATINDEX('%.%', :WP-PATIENT-DOB 
                                                       :WS-NULL-IND-DOB
              ) <> 0) OR (LEN(:WP-PATIENT-DOB :WS-NULL-IND-DOB
              ) <> 10), CIS.CHAR2DATE(:WP-PATIENT-DOB :WS-NULL-IND-DOB
              ), CONVERT(DATE, :WP-PATIENT-DOB :WS-NULL-IND-DOB
              ) ),'ISO')         
                WHERE NAME_ID = :WP-NAME-ID                             
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_WH_CROSS_PATNT                                        
MFA-TR*           SET PATIENT_DOB = CHAR(DATE(:WP-PATIENT-DOB                   
MFA-TR*                                  :WS-NULL-IND-DOB),ISO)                 
MFA-TR*         WHERE NAME_ID = :WP-NAME-ID                                     
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8055'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_WH_CROSS_PATNT'      TO TABLE-1                
               MOVE 'NAME_ID'                 TO TABLE-ELEMENT-1        
               MOVE 'PATIENT_DOB'             TO TABLE-ELEMENT-2        
               MOVE WP-NAME-ID                TO HOSTVAR-ELEMENT-1      
               MOVE WP-PATIENT-DOB            TO HOSTVAR-ELEMENT-2      
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8055-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8060-INSERT-WCP-SSN                                                     
      *                                                                         
      *    INSERT INTO WH_CROSS_SSN                                             
      *                                                                         
      *****************************************************************         
       8060-INSERT-WCP-SSN.                                             
      *                                                                         
               EXEC SQL                                                 
                   INSERT INTO CSS_WH_CROSS_SSN                         
                       (SSN                                             
                       ,NAME_ID)                                        
                   VALUES                                               
                        (:WJ-SSN                                        
                        ,:WJ-NAME-ID)                                   
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE  
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8060'                    TO ACTIVE-PARAGRAPH       
               MOVE 'INSERT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_WH_CROSS_SSN '       TO TABLE-1                
               MOVE 'NAME_ID'                 TO TABLE-ELEMENT-1        
               MOVE 'SSN'                     TO TABLE-ELEMENT-2        
               MOVE WJ-NAME-ID                TO HOSTVAR-ELEMENT-1      
               MOVE WJ-SSN                    TO HOSTVAR-ELEMENT-2      
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8065-UPDATE-PHYSICIAN.                                                  
      *                                                                         
      *    UPDATE CSS_PHYSICIAN                                                 
      *                                                                         
      *****************************************************************         
       8065-UPDATE-PHYSICIAN.                                           
                                                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PHYSICIAN                                     
                  SET MED_LIC_STATE_CD = :PY-MED-LIC-STATE-CD           
                     ,MED_LICENSE_NO   = :PY-MED-LICENSE-NO             
                WHERE PHYSICIAN_ID     = :I-PHYSICIAN-ID                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8065'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PHYSICIAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
              MOVE WS-ACCOUNT-NO-COMP3        TO HOSTVAR-ELEMENT-4      
              MOVE 'PHYSICIAN_ID'             TO TABLE-ELEMENT-1        
              MOVE 'MED_LIC_STATE_CD'         TO TABLE-ELEMENT-2        
              MOVE 'MED_LICENCE_NO'           TO TABLE-ELEMENT-3        
              MOVE I-PHYSICIAN-ID             TO HOSTVAR-ELEMENT-1      
              MOVE PY-MED-LIC-STATE-CD        TO HOSTVAR-ELEMENT-2      
              MOVE PY-MED-LICENSE-NO          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8065-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8070-UPDATE-NAME.                                                       
      *                                                                         
      *    UPDATE CSS_NAME                                                      
      *                                                                         
      *****************************************************************         
       8070-UPDATE-NAME.                                                
                                                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_NAME                                          
                  SET FIRST_NAME     = :DQ-FIRST-NAME                   
                     ,MIDDLE_NAME    = :DQ-MIDDLE-NAME                  
                     ,LAST_NAME      = :DQ-LAST-NAME                    
                     ,TITLE_PREFIX   = :DQ-TITLE-PREFIX                 
                     ,TITLE_SUFFIX_1 = :DQ-TITLE-SUFFIX-1               
                     ,FULL_NAME      = :DQ-FULL-NAME                    
                WHERE NAME_ID        = :DQ-NAME-ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8070'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_NAME'                 TO TABLE-1                
              MOVE 'FIRST_NAME'               TO TABLE-ELEMENT-1        
              MOVE 'MIDDLE_NAME'              TO TABLE-ELEMENT-2        
              MOVE 'LAST_NAME'                TO TABLE-ELEMENT-3        
              MOVE DQ-FIRST-NAME              TO HOSTVAR-ELEMENT-1      
              MOVE DQ-MIDDLE-NAME             TO HOSTVAR-ELEMENT-2      
              MOVE DQ-LAST-NAME               TO HOSTVAR-ELEMENT-3      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
              MOVE WS-ACCOUNT-NO-COMP3        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8075-UPDATE-PHY-ADDRESS.                                                
      *                                                                         
      *    INSERT PHYSICIAN ADDRESS                                             
      *                                                                         
      *****************************************************************         
       8075-UPDATE-PHY-ADDRESS.                                         
      *                                                                         
            EXEC SQL                                                    
               UPDATE CSS_ADDR_FORMATTED                                
                   SET  ADDRESS_ID        = :DY-ADDRESS-ID              
                       ,HOUSE_NO          = :DY-HOUSE-NO                
                       ,ADDR_PREFIX_1     = :DY-ADDR-PREFIX-1           
                       ,ADDR_PREFIX_2     = :DY-ADDR-PREFIX-2           
                       ,STREET_NAME       = :DY-STREET-NAME             
                       ,STREET_LOCATION_1 = :DY-STREET-LOCATION-1       
                       ,STREET_LOCATION_2 = :DY-STREET-LOCATION-2       
                       ,STREET_SUFFIX     = :DY-STREET-SUFFIX           
                       ,ADDRESS_OVERFLOW  = :DY-ADDRESS-OVERFLOW        
                       ,CARRIER_ROUTE     = :DY-CARRIER-ROUTE           
                       ,ZIP_CODE          = :DY-ZIP-CODE                
                       ,ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR     
                       ,ZIP_CODE_TOKEN    = :DY-ZIP-CODE-TOKEN          
                       ,ADDR_USAGE_CD     = :DY-ADDR-USAGE-CD           
                       ,ADDR_SUFFIX       = :DY-ADDR-SUFFIX             
                       ,USPS_DELIV_PT_CD  = :DY-USPS-DELIV-PT-CD        
               WHERE   ADDRESS_ID         = :WO-ADDRESS-ID              
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8075'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-1                
               MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-1        
               MOVE 'STREET_NAME'             TO TABLE-ELEMENT-2        
               MOVE 'ZIP_CODE'                TO TABLE-ELEMENT-3        
               MOVE DY-ADDRESS-ID             TO HOSTVAR-ELEMENT-1      
               MOVE DY-STREET-NAME            TO HOSTVAR-ELEMENT-2      
               MOVE DY-ZIP-CODE               TO HOSTVAR-ELEMENT-3      
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-4      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8075-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8080-UPDATE-PHY-ATTR.                                                   
      *                                                                         
      *    UPDATE PHYSICIAN ATTRIBUTES                                          
      *                                                                         
      *****************************************************************         
       8080-UPDATE-PHY-ATTR.                                            
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_PHYSICIAN_ATTR                                
                  SET EXTENSION_NO = :PA-EXTENSION-NO                   
                         ,PHONE_NO = :PA-PHONE-NO                       
                WHERE PHYSICIAN_ID = :PA-PHYSICIAN-ID                   
                  AND ADDRESS_ID   = :PA-ADDRESS-ID                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8080'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_PHYSICIAN_ATTR'      TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4        
               MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-4      
               MOVE 'PHYSICIAN_ID'            TO TABLE-ELEMENT-1        
               MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-2        
               MOVE 'PHONE_NO'                TO TABLE-ELEMENT-3        
               MOVE PA-PHYSICIAN-ID           TO HOSTVAR-ELEMENT-1      
               MOVE PA-ADDRESS-ID             TO HOSTVAR-ELEMENT-2      
               MOVE PA-PHONE-NO               TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8080-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8085-UPDATE-WCP.                                                        
      *                                                                         
      *    UPDATE CSS_WH_CROSS_PLUS                                             
      *                                                                         
      *****************************************************************         
       8085-UPDATE-WCP.                                                 
      *                                                                         
           IF  WO-EFFECTIVE-DT = SPACES OR LOW-VALUES                   
               MOVE -1         TO WS-NULL-IND-EFF                       
           ELSE                                                         
               MOVE 0          TO WS-NULL-IND-EFF                       
           END-IF                                                       
      *                                                                         
           IF  WO-EXPIRATION-DT = SPACES OR LOW-VALUES                  
               MOVE -1         TO WS-NULL-IND-EXP                       
           ELSE                                                         
               MOVE 0          TO WS-NULL-IND-EXP                       
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_WH_CROSS_PLUS                                  
                 SET NAME_ID           = :WO-NAME-ID                    
                    ,PHYSICIAN_ID      = :WO-PHYSICIAN-ID               
                    ,STATUS_CD         = :WO-STATUS-CD                  
                    ,DATE_TRANS        = IIF(TRY_CONVERT(DATE, 
                                                         :WO-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :WO-DATE-TRANS
              ) <> 0) OR (LEN(:WO-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :WO-DATE-TRANS
              ), CONVERT(DATE, :WO-DATE-TRANS) )                 
                    ,EFFECTIVE_DT     = CIS.CHAR2$DATE(
              IIF(TRY_CONVERT(DATE, :WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ) IS NULL OR (PATINDEX('%.%', :WO-EFFECTIVE-DT 
                                                       :WS-NULL-IND-EFF
              ) <> 0) OR (LEN(:WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ) <> 10), CIS.CHAR2DATE(:WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ), CONVERT(DATE, :WO-EFFECTIVE-DT :WS-NULL-IND-EFF
              ) ),'ISO')          
                    ,EXPIRATION_DT   = CIS.CHAR2$DATE(
              IIF(TRY_CONVERT(DATE, :WO-EXPIRATION-DT :WS-NULL-IND-EXP
              ) IS NULL OR (PATINDEX('%.%', :WO-EXPIRATION-DT 
                                                       :WS-NULL-IND-EXP
              ) <> 0) OR (LEN(:WO-EXPIRATION-DT :WS-NULL-IND-EXP
              ) <> 10), CIS.CHAR2DATE(:WO-EXPIRATION-DT 
                                                       :WS-NULL-IND-EXP
              ), CONVERT(DATE, :WO-EXPIRATION-DT :WS-NULL-IND-EXP
              ) ),'ISO')           
                    ,COMMENT           = :WO-COMMENT                    
                    ,ADDRESS_ID        = :WO-ADDRESS-ID                 
                    ,MED_COND_CODE     = :WO-MED-COND-CODE              
                    ,MEDICAL_COND_DESC = :WO-MEDICAL-COND-DESC          
                    ,AMBULANCE_FL      = :WO-AMBULANCE-FL               
                    ,PATIENT_ASSIST_FL = :WO-PATIENT-ASSIST-FL          
                    ,PATIENT_RELATION  = :WO-PATIENT-RELATION           
                    ,PATIENT_PH_NO     = :WO-PATIENT-PH-NO              
                  WHERE APPLICATION_ID = :WO-APPLICATION-ID             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_WH_CROSS_PLUS                                          
MFA-TR*          SET NAME_ID           = :WO-NAME-ID                            
MFA-TR*             ,PHYSICIAN_ID      = :WO-PHYSICIAN-ID                       
MFA-TR*             ,STATUS_CD         = :WO-STATUS-CD                          
MFA-TR*             ,DATE_TRANS        = :WO-DATE-TRANS                         
MFA-TR*             ,EFFECTIVE_DT     = CHAR(DATE(:WO-EFFECTIVE-DT              
MFA-TR*                                 :WS-NULL-IND-EFF),ISO)                  
MFA-TR*             ,EXPIRATION_DT   = CHAR(DATE(:WO-EXPIRATION-DT              
MFA-TR*                                :WS-NULL-IND-EXP),ISO)                   
MFA-TR*             ,COMMENT           = :WO-COMMENT                            
MFA-TR*             ,ADDRESS_ID        = :WO-ADDRESS-ID                         
MFA-TR*             ,MED_COND_CODE     = :WO-MED-COND-CODE                      
MFA-TR*             ,MEDICAL_COND_DESC = :WO-MEDICAL-COND-DESC                  
MFA-TR*             ,AMBULANCE_FL      = :WO-AMBULANCE-FL                       
MFA-TR*             ,PATIENT_ASSIST_FL = :WO-PATIENT-ASSIST-FL                  
MFA-TR*             ,PATIENT_RELATION  = :WO-PATIENT-RELATION                   
MFA-TR*             ,PATIENT_PH_NO     = :WO-PATIENT-PH-NO                      
MFA-TR*           WHERE APPLICATION_ID = :WO-APPLICATION-ID                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8085'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_WH_CROSS_PLUS'        TO TABLE-1                
              MOVE 'APPLICATION_ID'           TO TABLE-ELEMENT-1        
              MOVE WO-APPLICATION-ID          TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE 'NAME_ID'                  TO TABLE-ELEMENT-3        
              MOVE WO-NAME-ID                 TO HOSTVAR-ELEMENT-3      
              MOVE 'PHYSICIAN_ID'             TO TABLE-ELEMENT-4        
              MOVE WO-PHYSICIAN-ID            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
                                                                        
           END-IF.                                                      
                                                                        
       8085-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04480000
      *                                                                *04490000
      *   8087-DELETE-DNP-ROW.                                         *04500000
      *        DELETES THE RECORD FROM THE  CURSOR                    * 04510000
      *                                                                *04520000
      ******************************************************************04530000
       8087-DELETE-DNP-ROW.                                             
                                                                        
           MOVE '8087' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           EXEC SQL                                                     
               DELETE                                                   
                 FROM CSS_CRED_COLL                                     
                 WHERE  CURRENT OF DNP_CSR                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 'Y'                       TO WS-DELETE-DNP-FL        
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8087'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE 'CSS_CRED_COLL'          TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8087-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8090-UPDT-CODE-CRIT.                                                    
      *                                                                         
      *    UPDATE CSS_ACCOUNT                                                   
      *                                                                         
      *****************************************************************         
       8090-UPDT-CODE-CRIT.                                             
                                                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODE_CRIT_OUTAGE = :AT-CODE-CRIT-OUTAGE           
                     ,LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )          
                WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     23260000
MFA-TR*        UPDATE CSS_ACCOUNT                                       23270000
MFA-TR*           SET CODE_CRIT_OUTAGE = :AT-CODE-CRIT-OUTAGE           23280000
MFA-TR*              ,LAST_UPDATE_TS   = :WS-CURRENT-TIMESTAMP                  
MFA-TR*         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 23340000
MFA-TR*    END-EXEC.                                                    23350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8090'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'CODE_CRIT_OUTAGE'         TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-CODE-CRIT-OUTAGE        TO HOSTVAR-ELEMENT-1      
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
      *    EXEC SQL                                                             
      *       INCLUDE CPD00300                                                  
      *    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
      *****************************************************************         
      * DELETES ALL THE PHYSICIAN ATTR ROWS FOR THE PHYSICIAN THAT IS *         
      * IS BEING DELETED.                                             *         
      *****************************************************************         
      *                                                                         
       8850-DEL-PHYSICIAN-ATTR.                                         
      *                                                                         
           EXEC SQL                                                     
               DELETE                                                   
                 FROM CSS_PHYSICIAN_ATTR                                
                WHERE PHYSICIAN_ID = :WS-DEL-PHYSICIAN-ID               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
           OR  NOT-FOUND                                                
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8850'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE 'CSS_PHYSICIAN_ATTR'     TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               MOVE 'PHYSICIAN_ID'           TO TABLE-ELEMENT-2         
               MOVE WS-DEL-PHYSICIAN-ID      TO HOSTVAR-ELEMENT-2       
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8860-UPDATE-WCP-PHY.                                                    
      *                                                                         
      *    UPDATES PHYSICIAN-ID AND ADDRESS-ID ON ALL THE FORMS                 
      *    THE PHYSICIAN THAT IS DELETED IS ASSOCIATED.                         
      *****************************************************************         
       8860-UPDT-WCP-PHY.                                               
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_WH_CROSS_PLUS                                  
                 SET PHYSICIAN_ID    = 0                                
                    ,ADDRESS_ID      = 0                                
                WHERE PHYSICIAN_ID   = :WS-DEL-PHYSICIAN-ID             
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR NOT-FOUND                                                 
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8860'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_WH_CROSS_PLUS'        TO TABLE-1                
              MOVE 'PHYSICIAN_ID'             TO TABLE-ELEMENT-1        
              MOVE WS-DEL-PHYSICIAN-ID        TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT      
              PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8870-DELETE-PHYSICIAN.                                           
      *                                                                         
           MOVE '8870' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           EXEC SQL                                                     
               DELETE                                                   
                 FROM CSS_PHYSICIAN                                     
                WHERE PHYSICIAN_ID = :WS-DEL-PHYSICIAN-ID               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
           OR  NOT-FOUND                                                
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8870'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE 'CSS_PHYSICIAN'          TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               MOVE 'PHYSICIAN_ID'           TO TABLE-ELEMENT-2         
               MOVE WS-DEL-PHYSICIAN-ID      TO HOSTVAR-ELEMENT-2       
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8870-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8880-DELETE-PHY-ATTR.                                            
      *                                                                         
           EXEC SQL                                                     
               DELETE                                                   
                 FROM CSS_PHYSICIAN_ATTR                                
                WHERE PHYSICIAN_ID = :PA-PHYSICIAN-ID                   
                  AND ADDRESS_ID   = :WS-ADDRESS-ID                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
           OR  NOT-FOUND                                                
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8880'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE 'CSS_PHYSICIAN_ATTR'     TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               MOVE 'PHYSICIAN_ID'           TO TABLE-ELEMENT-2         
               MOVE PA-PHYSICIAN-ID          TO HOSTVAR-ELEMENT-2       
               MOVE 'ADDRESS_ID'             TO TABLE-ELEMENT-3         
               MOVE WS-ADDRESS-ID            TO HOSTVAR-ELEMENT-3       
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8880-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8890-DELETE-WCP-SSN.                                             
      *                                                                         
           EXEC SQL                                                     
               DELETE                                                   
                 FROM CSS_WH_CROSS_SSN                                  
                WHERE SSN     = :WJ-SSN                                 
                  AND NAME_ID = :WJ-NAME-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
           OR  NOT-FOUND                                                
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8890'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE 'CSS_WH_CROSS_SSN'       TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE WO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               MOVE 'NAME_ID'                TO TABLE-ELEMENT-2         
               MOVE WJ-NAME-ID               TO HOSTVAR-ELEMENT-2       
               MOVE 'SSN '                   TO TABLE-ELEMENT-3         
               MOVE WJ-SSN                   TO HOSTVAR-ELEMENT-3       
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
