       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03825.                                         
       DATE-WRITTEN.  MAR 2007.                                         
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES PATIENT'S WHITE CROSS PLUS DETAILS   *        
      *  TO BE USED BY PANEL203.                                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/14/07  COVANSYS   PROCEDURE ORIGINALLY CODED FOR CML32547  *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03825'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03825 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * WO - CSS_WH_CROSS_PLUS   *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBWCPLUS                                                 
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * WP - CSS_WH_CROSS_PATNT  *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBWCPPAT                                                 
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * WJ - CSS_WH_CROSS_SSN    *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBWCPSSN                                                 
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * PY - CSS_PHYSICIAN       *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBPHYSN                                                  
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * PA - CSS_PHYSICIAN_ATTR  *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBPHYADD                                                 
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * DQ - CSS_NAME            *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      ****************************                                              
      * DY - CSS_ADDR_FORMATTED  *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      ****************************                                              
      * AT - CSS_ACCOUNT         *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      ****************************                                              
      * TA - CSS_ACCT_MISC_INFO  *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      ****************************                                              
      * A4 - CSS_ZIP_CODE        *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      ****************************                                              
      * DZ - CSS_ADDR_FREEFORM   *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      ****************************                                              
      * DM - CSS_CUST_ADDR_XREF  *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      ****************************                                              
      * HT -  CSS_NAME_ACCT_XREF *                                              
      ****************************                                              
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      * NAME AND ADDRESS                                                        
           EXEC SQL                                                             
               INCLUDE CWS00074                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS0011A                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00132                                                 
           END-EXEC.                                                            
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
                                                                        
       01  WS-MISC.                                                     
           05 WS-SSN                   PIC X(9).                        
           05 WS-SELECT-RETURN-CODE    PIC S9(9) COMP.                  
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR03825'.      
           05  WS-SQLSTATE             PIC X(5).                        
           05  WS-ADD-SUB-CNT          PIC 99 VALUE 1.                  
           05  WS-LENGTH               PIC S9(4).                       
           05  WS-MAX-SZ               PIC S9(4).                       
           05  WS-PTNT-TITLE           PIC X(09) VALUE SPACES.          
           05  WS-PTNT-SUFFIX          PIC X(03) VALUE SPACES.          
           05  WS-PTNT-FIRST-NAME      PIC X(15) VALUE SPACES.          
           05  WS-PTNT-MIDDLE-NAME     PIC X(15) VALUE SPACES.          
T36932     05  WS-PTNT-LAST-NAME       PIC X(40) VALUE SPACES.          
                                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR03825_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-FROM.                                                 
               10  WS-FROM-X           OCCURS 51 TIMES PIC X.           
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  WS-HOLD-DATE.                                                
           05  WS-HOLD-DATE-YY     PIC X(04).                           
           05  FILLER              PIC X(01).                           
           05  WS-HOLD-DATE-MM     PIC X(02).                           
           05  FILLER              PIC X(01).                           
           05  WS-HOLD-DATE-DD     PIC X(02).                           
                                                                        
       01  WS-WORK-DATE.                                                
           05  WS-WORK-DATE-MM     PIC X(02).                           
           05  FILLER              PIC X(01) VALUE '/'.                 
           05  WS-WORK-DATE-DD     PIC X(02).                           
           05  FILLER              PIC X(01) VALUE '/'.                 
           05  WS-WORK-DATE-YY     PIC X(04).                           
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE      PIC S9(9) COMP VALUE +0.             
           05  RS-RETURN-CODE-DISP PIC +Z(04).                          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE       PIC S9(9) COMP VALUE 0.              
           05  S-STATUS-CD         PIC X(01) VALUE SPACES.              
           05  S-EXPIRATION-DT     PIC X(10) VALUE SPACES.              
COB305     05 S-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.            
           05  S-PTNT-FIRST-NAME   PIC X(15) VALUE SPACES.              
           05  S-PTNT-MIDDLE-NAME  PIC X(15) VALUE SPACES.              
T36932     05  S-PTNT-LAST-NAME    PIC X(40) VALUE SPACES.              
           05  S-PTNT-TITLE        PIC X(09) VALUE SPACES.              
           05  S-PTNT-SUFFIX       PIC X(03) VALUE SPACES.              
           05  S-PATIENT-DOB       PIC X(10) VALUE SPACES.              
T36932     05  S-STREET-NAME       PIC X(55)  VALUE SPACES.             
           05  S-CITY-STATE        PIC X(32)  VALUE SPACES.             
T36932     05  S-CUST-NAME         PIC X(96)  VALUE SPACES.             
COB305     05 S-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.            
      *                                                                         
       01  CN-CONSTANTS.                                                
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  CN-ASTERISK                  PIC X VALUE '*'.            
       01  CSRERLOG-P.                                                  
           05  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           05  S-SQLCODE               PIC S9(9)      COMP VALUE 0.     
           05  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           05  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           05  S-HOST-VARIABLES.                                        
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
           05  S-SQL-STATEMENT.                                         
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
           05  S-SQL-DESCRIPTION.                                       
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *                                                                *        
      *  CURSOR DECLARATION FOR THE CSS_WH_CROSS_SSN TABLE.            *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE  SSN_CSR CURSOR FOR                                
              SELECT  WO.NAME_ID                                        
                     ,COALESCE(CIS.CHAR2$DATE(WP.PATIENT_DOB,'USA'),' ')        
                     ,WO.STATUS_CD                                      
                     ,COALESCE(CIS.CHAR2$DATE(
           WO.EXPIRATION_DT, 'USA'),' ')           
                     ,WO.ACCOUNT_NO                                     
                FROM  CSS_WH_CROSS_PLUS WO WITH(READUNCOMMITTED)                
                     ,CSS_WH_CROSS_SSN WJ WITH(READUNCOMMITTED)                 
                     ,CSS_WH_CROSS_PATNT WP WITH(READUNCOMMITTED)               
               WHERE  WJ.SSN     = :WJ-SSN                              
                 AND  WJ.NAME_ID = WO.NAME_ID                           
                 AND  WJ.NAME_ID = WP.NAME_ID                           
                 FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  SSN_CSR CURSOR FOR                                        
MFA-TR*       SELECT  WO.NAME_ID                                                
MFA-TR*              ,IFNULL(CHAR(WP.PATIENT_DOB,USA),' ')                      
MFA-TR*              ,WO.STATUS_CD                                              
MFA-TR*              ,IFNULL(CHAR(WO.EXPIRATION_DT, USA),' ')                   
MFA-TR*              ,WO.ACCOUNT_NO                                             
MFA-TR*         FROM  CSS_WH_CROSS_PLUS WO                                      
MFA-TR*              ,CSS_WH_CROSS_SSN WJ                                       
MFA-TR*              ,CSS_WH_CROSS_PATNT WP                                     
MFA-TR*        WHERE  WJ.SSN     = :WJ-SSN                                      
MFA-TR*          AND  WJ.NAME_ID = WO.NAME_ID                                   
MFA-TR*          AND  WJ.NAME_ID = WP.NAME_ID                                   
MFA-TR*          FOR  FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
                                                                        
       LINKAGE SECTION.                                                 
       01  I-SSN                    PIC X(09).                          
       PROCEDURE DIVISION USING I-SSN.                                  
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   RETURN_CODE                                          
                  ,STATUS_CD                                            
                  ,EXPIRATION_DT                                        
                  ,NAME_ID                                              
                  ,LTRIM(RTRIM(PTNT_TITLE))         AS PTNT_TITLE              
                  ,LTRIM(RTRIM(PTNT_SUFFIX))        AS PTNT_SUFFIX             
                  ,LTRIM(RTRIM(PTNT_FIRST_NAME))    AS PTNT_FIRST_NAME         
                  ,LTRIM(RTRIM(PTNT_MIDDLE_NAME))   AS PTNT_MIDDLE_NAME        
                  ,LTRIM(RTRIM(PTNT_LAST_NAME))     AS PTNT_LAST_NAME          
                  ,PATIENT_DOB                                          
                  ,STREET_NAME                                          
                  ,CITY_STATE                                           
                  ,CUST_NAME                                            
                  ,ACCOUNT_NO                                           
               FROM                                                     
                   #CSR03825_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,STATUS_CD                                                    
MFA-TR*           ,EXPIRATION_DT                                                
MFA-TR*           ,NAME_ID                                                      
MFA-TR*           ,STRIP(PTNT_TITLE)         AS PTNT_TITLE                      
MFA-TR*           ,STRIP(PTNT_SUFFIX)        AS PTNT_SUFFIX                     
MFA-TR*           ,STRIP(PTNT_FIRST_NAME)    AS PTNT_FIRST_NAME                 
MFA-TR*           ,STRIP(PTNT_MIDDLE_NAME)   AS PTNT_MIDDLE_NAME                
MFA-TR*           ,STRIP(PTNT_LAST_NAME)     AS PTNT_LAST_NAME                  
MFA-TR*           ,PATIENT_DOB                                                  
MFA-TR*           ,STREET_NAME                                                  
MFA-TR*           ,CITY_STATE                                                   
MFA-TR*           ,CUST_NAME                                                    
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR03825_R1                                          
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR03825_R1'           
                                          TO S-SQL-STATEMENT-V.         
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR03825_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR03825_R1
               (                                                       
                   RETURN_CODE                    INT               
                  ,STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,EXPIRATION_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2              
                  ,NAME_ID                        DECIMAL(13,0)         
                  ,PTNT_TITLE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,PTNT_SUFFIX CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,PTNT_FIRST_NAME CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2              
                  ,PTNT_MIDDLE_NAME CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2              
                  ,PTNT_LAST_NAME CHAR(40)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2              
                  ,PATIENT_DOB CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,STREET_NAME CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,CITY_STATE CHAR(32)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CUST_NAME CHAR(96)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,ACCOUNT_NO                     DECIMAL(13,0)         
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
      *                                                                         
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000A-DELETE-GTT-ROWS                            
                                          THRU 8000A-EXIT               
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR03825_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE I-SSN                 TO WJ-SSN.                        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                          TO ACTIVE-PARAGRAPH     
           PERFORM 7000-OPEN-SSN-CRSR           THRU 7000-EXIT          
           PERFORM 7010-FETCH-SSN-CRSR          THRU 7010-EXIT          
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
               MOVE ZEROES                   TO WO-NAME-ID              
               MOVE ZEROES                   TO WO-ACCOUNT-NO           
               MOVE SPACES                   TO WS-PTNT-FIRST-NAME      
                                                WS-PTNT-MIDDLE-NAME     
                                                WS-PTNT-LAST-NAME       
                                                WS-PTNT-TITLE           
                                                WS-PTNT-SUFFIX          
               PERFORM 2100-MOVE-RESULT         THRU 2100-EXIT          
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
           ELSE                                                         
               PERFORM 2010-PROCESS-SSN-CRSR    THRU 2010-EXIT          
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
           END-IF                                                       
           PERFORM 7020-CLOSE-SSN-CRSR          THRU 7020-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2010-PROCESS-SSN-CRSR.                                         *        
      ******************************************************************        
      *                                                                         
       2010-PROCESS-SSN-CRSR.                                           
      *                                                                         
           MOVE '2010'                          TO ACTIVE-PARAGRAPH     
           PERFORM 7100-SELECT-NAME             THRU 7100-EXIT          
           PERFORM 2500-GET-NAME-ADDRESS        THRU 2500-EXIT          
           PERFORM 2100-MOVE-RESULT             THRU 2100-EXIT          
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT          
           PERFORM 7010-FETCH-SSN-CRSR          THRU 7010-EXIT.         
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2100-MOVE-RESULT.                                                        
      ******************************************************************        
      *                                                                         
       2100-MOVE-RESULT.                                                
      *                                                                         
           MOVE RS-RETURN-CODE        TO S-RETURN-CODE                  
           MOVE WO-STATUS-CD          TO S-STATUS-CD                    
           MOVE WO-EXPIRATION-DT      TO S-EXPIRATION-DT                
           MOVE WO-NAME-ID            TO S-NAME-ID                      
           MOVE WS-PTNT-FIRST-NAME    TO S-PTNT-FIRST-NAME              
           MOVE WS-PTNT-MIDDLE-NAME   TO S-PTNT-MIDDLE-NAME             
           MOVE WS-PTNT-LAST-NAME     TO S-PTNT-LAST-NAME               
           MOVE WS-PTNT-TITLE         TO S-PTNT-TITLE                   
           MOVE WS-PTNT-SUFFIX        TO S-PTNT-SUFFIX                  
           MOVE WP-PATIENT-DOB        TO S-PATIENT-DOB                  
           MOVE WS-PR-STREET          TO S-STREET-NAME                  
           MOVE WS-PR-ADDR-CITY-STATE TO S-CITY-STATE                   
           MOVE WS-CUSTOMER-NAME      TO S-CUST-NAME                    
           MOVE WO-ACCOUNT-NO         TO S-ACCOUNT-NO.                  
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2500-GET-NAME-ADDRESS.                                                   
      ******************************************************************        
       2500-GET-NAME-ADDRESS.                                           
      *                                                                         
           MOVE  WO-ACCOUNT-NO               TO AT-ACCOUNT-NO           
           PERFORM 7150-SELECT-ADDR-ID          THRU 7150-EXIT          
           PERFORM 4000-MAIL-NAME-ADDRESS       THRU 4000-EXIT.         
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *4000-MAIL-NAME-ADDRESS.                                                  
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  6010- REDUCE EMBEDDED SPACES                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00004                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  OPEN THE CURSOR DECLARED FOR SSN                              *        
      ******************************************************************        
       7000-OPEN-SSN-CRSR.                                              
      *                                                                         
           MOVE '7000'                          TO ACTIVE-PARAGRAPH.    
           EXEC SQL                                                     
               OPEN SSN_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE 'CSR03825'              TO ABEND-PROGRAM            
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_PLUS'     TO TABLE-1                  
               MOVE 'CSS_WH_CROSS_SSN'      TO TABLE-2                  
               MOVE 'CSS_WH_CROSS_PATNT'    TO TABLE-3                  
               MOVE 'SSN'                   TO TABLE-ELEMENT-1          
               MOVE WJ-SSN                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  FETCH THE CURSOR DECLARED FOR SSN                             *        
      ******************************************************************        
       7010-FETCH-SSN-CRSR.                                             
      *                                                                         
           EXEC SQL                                                     
               FETCH SSN_CSR                                            
               INTO :WO-NAME-ID                                         
                   ,:WP-PATIENT-DOB                                     
                   ,:WO-STATUS-CD                                       
                   ,:WO-EXPIRATION-DT                                   
                   ,:WO-ACCOUNT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE 'CSR03825'              TO ABEND-PROGRAM            
               MOVE '7010'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CSS_WH_CROSS_PLUS'     TO TABLE-1                  
               MOVE 'CSS_WH_CROSS_SSN'      TO TABLE-2                  
               MOVE 'CSS_WH_CROSS_PATNT'    TO TABLE-3                  
               MOVE 'SSN'                   TO TABLE-ELEMENT-1          
               MOVE WJ-SSN                  TO HOSTVAR-ELEMENT-1        
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  CLOSE THE CURSOR DECLARED FOR WHITE CROSS PLUS  *                      
      ******************************************************************        
       7020-CLOSE-SSN-CRSR.                                             
      *                                                                         
           EXEC SQL                                                     
               CLOSE SSN_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE 'CSR03825'              TO ABEND-PROGRAM            
               MOVE '7020'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE 'CSS_WH_CROSS_PLUS'     TO TABLE-1                  
               MOVE 'CSS_WH_CROSS_SSN'      TO TABLE-2                  
               MOVE 'CSS_WH_CROSS_PATNT'    TO TABLE-3                  
               MOVE 'SSN'                   TO TABLE-ELEMENT-1          
               MOVE WJ-SSN                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7100-SELECT-NAME.                                                        
      ******************************************************************        
       7100-SELECT-NAME.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT  DQ.FIRST_NAME                                   
                       ,DQ.MIDDLE_NAME                                  
                       ,DQ.LAST_NAME                                    
                       ,DQ.TITLE_PREFIX                                 
                       ,DQ.TITLE_SUFFIX_1                               
                  INTO  :WS-PTNT-FIRST-NAME                             
                       ,:WS-PTNT-MIDDLE-NAME                            
                       ,:WS-PTNT-LAST-NAME                              
                       ,:WS-PTNT-TITLE                                  
                       ,:WS-PTNT-SUFFIX                                 
                  FROM  CSS_NAME DQ                                     
                 WHERE  NAME_ID = :WO-NAME-ID                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE SPACES                TO WS-PTNT-FIRST-NAME      
                                                WS-PTNT-MIDDLE-NAME     
                                                WS-PTNT-LAST-NAME       
                                                WS-PTNT-TITLE           
                                                WS-PTNT-SUFFIX          
               ELSE                                                     
                  MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE          
                  MOVE 'CSR03825'            TO ABEND-PROGRAM           
                  MOVE '7100'                TO ACTIVE-PARAGRAPH        
                  MOVE 'CSS_NAME'            TO TABLE-1                 
                  MOVE 'NAME_ID '            TO TABLE-ELEMENT-1         
                  MOVE WO-NAME-ID            TO HOSTVAR-ELEMENT-1       
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2         
                  MOVE WO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2       
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7150-SELECT-ADDR-ID.                                                     
      ******************************************************************        
       7150-SELECT-ADDR-ID.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT  ADDRESS_ID                                      
                  INTO  :AT-ADDRESS-ID                                  
                  FROM  CSS_ACCOUNT                                     
                 WHERE  ACCOUNT_NO = :WO-ACCOUNT-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE 'CSR03825'                TO ABEND-PROGRAM          
               MOVE '7150'                    TO ACTIVE-PARAGRAPH       
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE WO-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS.                                                   
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR03825_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03825_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR03825_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
            END-IF.                                                     
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *8100-SEND-RESULT.                                                        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR03825_R1                          
               (                                                        
                   RETURN_CODE                                          
                  ,STATUS_CD                                            
                  ,EXPIRATION_DT                                        
                  ,NAME_ID                                              
                  ,PTNT_TITLE                                           
                  ,PTNT_SUFFIX                                          
                  ,PTNT_FIRST_NAME                                      
                  ,PTNT_MIDDLE_NAME                                     
                  ,PTNT_LAST_NAME                                       
                  ,PATIENT_DOB                                          
                  ,STREET_NAME                                          
                  ,CITY_STATE                                           
                  ,CUST_NAME                                            
                  ,ACCOUNT_NO                                           
               )                                                        
               VALUES                                                   
               (                                                        
               :S-RETURN-CODE                                           
              ,:S-STATUS-CD                                             
              ,:S-EXPIRATION-DT                                         
              ,:S-NAME-ID                                               
              ,:S-PTNT-TITLE                                            
              ,:S-PTNT-SUFFIX                                           
              ,:S-PTNT-FIRST-NAME                                       
              ,:S-PTNT-MIDDLE-NAME                                      
              ,:S-PTNT-LAST-NAME                                        
              ,:S-PATIENT-DOB                                           
              ,:S-STREET-NAME                                           
              ,:S-CITY-STATE                                            
              ,:S-CUST-NAME                                             
              ,:S-ACCOUNT-NO                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR03825_R1                                  
MFA-TR*        (                                                                
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,STATUS_CD                                                    
MFA-TR*           ,EXPIRATION_DT                                                
MFA-TR*           ,NAME_ID                                                      
MFA-TR*           ,PTNT_TITLE                                                   
MFA-TR*           ,PTNT_SUFFIX                                                  
MFA-TR*           ,PTNT_FIRST_NAME                                              
MFA-TR*           ,PTNT_MIDDLE_NAME                                             
MFA-TR*           ,PTNT_LAST_NAME                                               
MFA-TR*           ,PATIENT_DOB                                                  
MFA-TR*           ,STREET_NAME                                                  
MFA-TR*           ,CITY_STATE                                                   
MFA-TR*           ,CUST_NAME                                                    
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*        :S-RETURN-CODE                                                   
MFA-TR*       ,:S-STATUS-CD                                                     
MFA-TR*       ,:S-EXPIRATION-DT                                                 
MFA-TR*       ,:S-NAME-ID                                                       
MFA-TR*       ,:S-PTNT-TITLE                                                    
MFA-TR*       ,:S-PTNT-SUFFIX                                                   
MFA-TR*       ,:S-PTNT-FIRST-NAME                                               
MFA-TR*       ,:S-PTNT-MIDDLE-NAME                                              
MFA-TR*       ,:S-PTNT-LAST-NAME                                                
MFA-TR*       ,:S-PATIENT-DOB                                                   
MFA-TR*       ,:S-STREET-NAME                                                   
MFA-TR*       ,:S-CITY-STATE                                                    
MFA-TR*       ,:S-CUST-NAME                                                     
MFA-TR*       ,:S-ACCOUNT-NO                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                    TO  CTR-ROWS                  
             ELSE                                                       
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE '8100'               TO  ACTIVE-PARAGRAPH          
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR03825_R1'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF.                                                    
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                                     
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                                 
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
