       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR03821.                                          
       AUTHOR.       Covansys.                                          
       DATE-WRITTEN. November 2006.                                     
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      * Enables web to display the link to the notice images those     *        
      * were issued on an account.                                     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     Program Modification Log                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
C34716*  11/22/2006 VP94820   Initial Implementation for Web-CAA.      *        
      *                                                                *        
      ******************************************************************        
      *                ---- Basic Sequence Structure ----              *        
      *                                                                *        
      *         0000 - 0999     Main Control Path and Initialization   *        
      *         1000 - 1999     Input Processing Control Path          *        
      *         2000 - 2999     Output Processing Control Path         *        
      *         7000 - 7999     Database Access / Input Modules        *        
      *         8000 - 8999     Output Modules                         *        
      *         9000 - 9799     Termination Modules                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03821'.
MSQ017     COPY MFASQLM.
                                                                        
      *01 WS-START                        PIC X(40) VALUE                       
      *    'WORKING STORAGE FOR CSR03821 STARTS HERE'.                          
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE            PIC S9(9) COMP VALUE ZERO.       
           05 S-NOTICE-ID              PIC X(05) VALUE SPACES.          
           05 S-NOTICE-TYPE            PIC X(02) VALUE SPACES.          
           05 S-NOTICE-SUB-TYPE        PIC X(02) VALUE SPACES.          
           05 S-NOTICE-DATE            PIC X(10) VALUE SPACES.          
           05 S-NOTICE-DESC            PIC X(30) VALUE SPACES.          
                                                                        
       01  WS-VARIABLES.                                                
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR03821'.      
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
           05 WS-SQLSTATE              PIC X(05) VALUE SPACES.          
           05 WS-NO-MORE-RECS          PIC X(01) VALUE 'N'.             
               88 NO-MORE-RECS                   VALUE 'Y'.             
           05 SEND-DONE-SW             PIC X(01) VALUE 'Y'.             
              88 SEND-DONE-ERROR                 VALUE 'N'.             
              88 SEND-DONE-OK                    VALUE 'Y'.             
      *                                                                         
       01 WS-TABLE-DATA.                                                
          05 WS-TABLE-ENTRY-1          PIC X(42) VALUE                  
                           '80106 16 23 2ND NOTICE                    '.
          05 WS-TABLE-ENTRY-2          PIC X(42) VALUE                  
                           '80107 16 24 2ND RTN CHECK                 '.
          05 WS-TABLE-ENTRY-3          PIC X(42) VALUE                  
                           '80202 16 26 EXCEPTIONAL 2                 '.
          05 WS-TABLE-ENTRY-4          PIC X(42) VALUE                  
                           '80206 16 27 RET CHECK 2                   '.
          05 WS-TABLE-ENTRY-5          PIC X(42) VALUE                  
                           '90106 16 01 EXCEPTIONAL                   '.
          05 WS-TABLE-ENTRY-6          PIC X(42) VALUE                  
                           '90107 16 02 2N RTN CHECK                  '.
          05 WS-TABLE-ENTRY-7          PIC X(42) VALUE                  
                           '90202 16 06 EXCEPTIONAL 2                 '.
          05 WS-TABLE-ENTRY-8          PIC X(42) VALUE                  
                           '90203 16 07 DPP EARNEST                   '.
          05 WS-TABLE-ENTRY-9          PIC X(42) VALUE                  
                           '90204 16 08 DEPOSIT NOTICE                '.
          05 WS-TABLE-ENTRY-10         PIC X(42) VALUE                  
                           '90206 16 10 RET CHECK 2                   '.
      *                                                                         
       01 WS-TABLE-1 REDEFINES WS-TABLE-DATA.                           
          05 WS-NOTICE-INFO-TABLE OCCURS 10 TIMES INDEXED BY WS-IDX-1.  
             10 WS-NOTICE-ID           PIC X(05).                       
             10 FILLER1                PIC X(01).                       
             10 WS-NOTICE-TYPE         PIC X(02).                       
             10 FILLER2                PIC X(01).                       
             10 WS-NOTICE-SUB-TYPE     PIC X(02).                       
             10 FILLER3                PIC X(01).                       
             10 WS-NOTICE-DESC         PIC X(30).                       
      *                                                                         
       01 WS-TIMESTAMP.                                                 
          05 WS-DATE                   PIC X(10).                       
          05 FILLER                    PIC X(16)                        
                                       VALUE '-00.00.00.000000'.        
       01 WS-TIMESTAMP-01 REDEFINES WS-TIMESTAMP PIC X(26).             
      *                                                                         
      *01 WS-END                       PIC X(40)  VALUE                         
      *    'WORKING STORAGE FOR CSR03821 ENDS HERE'.                            
      *                                                                         
      ******************************************************************00630000
      * SQL Error Checking Copy Books.                                 *00640000
      ******************************************************************00650000
      *                                                                         
      *01 CWSSP001-FIELDS.                                                      
          COPY CWSSP001.                                                        
      *                                                                         
      *01 CWS00303-FIELDS.                                                      
          COPY CWS00303.                                                        
      *                                                                         
      ******************************************************************00630000
      * DB2 Includes.                                                  *00640000
      ******************************************************************00650000
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    MH - CSS_MNT_TRANS_HIST                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBMNHIST                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Error Handling Copy Book.                                      *        
      ******************************************************************        
      *                                                                         
      *01 ABEND-FILE.                                                           
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Cursor for getting notices those were issues for an account    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE NOTICES_INFO CURSOR FOR                         
                SELECT                                                  
                       MH.DATE_TRANS                                    
                      ,CIS.SUBSTR3 (MH.TRAN_COMMENT,34,5)                    
                FROM                                                    
                       CSS_MNT_TRANS_HIST  MH WITH(READUNCOMMITTED)             
                WHERE                                                   
                      TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
                  AND ACCOUNT_NO         = :MH-ACCOUNT-NO               
                  AND CIS.SUBSTR3 (TRAN_COMMENT,34,5) IN                     
                      (                                                 
                       '80106','80107','80202','80206',                 
                       '90106','90107','90202','90203',                 
                       '90204','90206'                                  
                      )                                                 
                ORDER BY TRANS_HIST_SEQ_NO DESC                         
                                                                 
                  FOR READ ONLY                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE NOTICES_INFO CURSOR FOR                                 
MFA-TR*         SELECT                                                          
MFA-TR*                MH.DATE_TRANS                                            
MFA-TR*               ,SUBSTR (MH.TRAN_COMMENT,34,5)                            
MFA-TR*         FROM                                                            
MFA-TR*                CSS_MNT_TRANS_HIST  MH                                   
MFA-TR*         WHERE                                                           
MFA-TR*               TRANS_HIST_SEQ_NO >= :MH-TRANS-HIST-SEQ-NO                
MFA-TR*           AND ACCOUNT_NO         = :MH-ACCOUNT-NO                       
MFA-TR*           AND SUBSTR (TRAN_COMMENT,34,5) IN                             
MFA-TR*               (                                                         
MFA-TR*                '80106','80107','80202','80206',                         
MFA-TR*                '90106','90107','90202','90203',                         
MFA-TR*                '90204','90206'                                          
MFA-TR*               )                                                         
MFA-TR*         ORDER BY TRANS_HIST_SEQ_NO DESC                                 
MFA-TR*          WITH UR                                                        
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01 I-APPLICATION-ID           PIC X(07).                         
       01 I-ACCOUNT-NO               PIC X(13).                         
      *                                                                         
       PROCEDURE DIVISION USING  I-APPLICATION-ID                       
                               , I-ACCOUNT-NO.                          
      *                                                                         
      ******************************************************************        
      * Controls the Main Processing of the Program.                   *        
      ******************************************************************        
      *                                                                         
       0000-MAIN-LINE.                                                  
      *                                                                         
           PERFORM 0100-INITIALIZATION    THRU 0100-EXIT.               
           PERFORM 1000-PROCESS-INPUT     THRU 1000-EXIT.               
           PERFORM 2000-PROCESS-OUTPUT    THRU 2000-EXIT.               
           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT.               
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Initialize Return Fields, Declare GTT and Result Set Cursor.   *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
           PERFORM 0100A-DECLARE-GTT   THRU  0100A-EXIT.                
      *                                                                         
           EXEC SQL                                                     
                DECLARE C1  CURSOR  FOR                      
                SELECT                                                  
                       RETURN_CODE                                      
                      ,LTRIM(RTRIM(NOTICE_ID))         AS NOTICE_ID            
                      ,LTRIM(RTRIM(NOTICE_TYPE))       AS NOTICE_TYPE          
                      ,LTRIM(RTRIM(NOTICE_SUB_TYPE))   AS 
           NOTICE_SUB_TYPE      
                      ,LTRIM(RTRIM(NOTICE_DATE))       AS NOTICE_DATE          
                      ,LTRIM(RTRIM(NOTICE_DESC))       AS NOTICE_DESC          
                FROM #CSR03821_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1  CURSOR WITH RETURN FOR                              
MFA-TR*         SELECT                                                          
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,STRIP(NOTICE_ID)         AS NOTICE_ID                    
MFA-TR*               ,STRIP(NOTICE_TYPE)       AS NOTICE_TYPE                  
MFA-TR*               ,STRIP(NOTICE_SUB_TYPE)   AS NOTICE_SUB_TYPE              
MFA-TR*               ,STRIP(NOTICE_DATE)       AS NOTICE_DATE                  
MFA-TR*               ,STRIP(NOTICE_DESC)       AS NOTICE_DESC                  
MFA-TR*         FROM SESSION.CSR03821_R1                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, -1, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-DATE                    
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DATE = CURRENT DATE - 1 MONTH                            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Declares GTT For Holding Result Set.                           *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR03821_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR03821_R1
               (                                                      
                   RETURN_CODE           INT                        
                  ,NOTICE_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,NOTICE_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,NOTICE_SUB_TYPE CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                  ,NOTICE_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,NOTICE_DESC CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2        
                 )
            END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE              TO WS-SQLSTATE.                   
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR03821_R1'         TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************02790000
      * Receive and Validate Input Parameters.                         *02800000
      ******************************************************************02840000
      *                                                                 02850000
       1000-PROCESS-INPUT.                                              
      * Numeric Check on Input Account Number                                   
           IF I-ACCOUNT-NO IS NUMERIC THEN                              
              MOVE I-ACCOUNT-NO              TO WS-ACCOUNT-NO           
              MOVE WS-ACCOUNT-NO-NUM         TO MH-ACCOUNT-NO           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'PROCESS INPUT'           TO ABEND-FUNCTION          
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE I-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1       
              MOVE +1000                     TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE           
              PERFORM 8100-SEND-RESULT       THRU 8100-EXIT             
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
      *                                                                         
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Processes the output                                           *        
      ******************************************************************03560000
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
            MOVE WS-TIMESTAMP-01                TO  MH-TRANS-HIST-SEQ-NO
            PERFORM 7100-OPEN-NOTICES-INFO      THRU 7100-EXIT.         
            PERFORM 2100-PROCESS-NOTICES        THRU 2100-EXIT          
                                                UNTIL NO-MORE-RECS.     
      *                                                                         
            IF CTR-ROWS = ZERO                                          
               MOVE +100                   TO S-RETURN-CODE             
               PERFORM 8100-SEND-RESULT    THRU 8100-EXIT               
            END-IF.                                                     
      *                                                                         
            PERFORM 7120-CLOSE-NOTICES-INFO     THRU 7120-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      ******************************************************************03490000
      * Gets all the notices information                               *03500000
      ******************************************************************03560000
      *                                                                         
       2100-PROCESS-NOTICES.                                            
      *                                                                         
            PERFORM 7110-FETCH-NOTICES-INFO THRU 7110-EXIT.             
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               SET WS-IDX-1 TO 1                                        
               SEARCH WS-NOTICE-INFO-TABLE                              
                   AT END                                               
                      GO TO 2100-EXIT                                   
                 WHEN WS-NOTICE-ID(WS-IDX-1) = S-NOTICE-ID              
                      MOVE WS-NOTICE-TYPE(WS-IDX-1)     TO S-NOTICE-TYPE
                      MOVE WS-NOTICE-SUB-TYPE(WS-IDX-1) TO              
                                                       S-NOTICE-SUB-TYPE
                      MOVE WS-NOTICE-DESC(WS-IDX-1)     TO S-NOTICE-DESC
               END-SEARCH                                               
               PERFORM 8100-SEND-RESULT    THRU 8100-EXIT               
               INITIALIZE GTT-RETURN-FIELDS                             
            END-IF.                                                     
      *                                                                         
       2100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Opens the NOTICES_INFO Cursor.                                 *        
      ******************************************************************03560000
      *                                                                         
       7100-OPEN-NOTICES-INFO.                                          
      *                                                                         
           EXEC SQL                                                     
                OPEN NOTICES_INFO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7100'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE 'CSS_MNT_TRANS_HIST'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE MH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Fetches the NOTICES-INFO Cursor.                               *        
      ******************************************************************03560000
      *                                                                         
       7110-FETCH-NOTICES-INFO.                                         
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                       NOTICES_INFO                                     
                 INTO                                                   
                      :MH-DATE-TRANS                                    
                     ,:S-NOTICE-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   MOVE MH-DATE-TRANS          TO S-NOTICE-DATE         
              WHEN NOT-FOUND                                            
                   MOVE 'Y'                    TO WS-NO-MORE-RECS       
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7110'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'FETCH'                TO ABEND-FUNCTION        
                   MOVE 'CSS_MNT_TRANS_HIST'   TO TABLE-1               
                   MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
                   MOVE MH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Closes the NOTICES-INFO Cursor.                                *        
      ******************************************************************03560000
      *                                                                         
       7120-CLOSE-NOTICES-INFO.                                         
      *                                                                         
           EXEC SQL                                                     
                CLOSE NOTICES_INFO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7120'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'CSS_MNT_TRANS_HIST'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE MH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Deletes all the rows from GTT.                                 *        
      ******************************************************************03560000
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM #CSR03821_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR03821_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '8100A'               TO ACTIVE-PARAGRAPH           
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSR03821_R1'         TO TABLE-1                    
               MOVE SPACES                TO TABLE-ELEMENT-1            
               MOVE SPACES                TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Inserts the result-set row into GTT.                           *03500000
      ******************************************************************03560000
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR03821_R1                         
                (                                                       
                  RETURN_CODE                                           
                 ,NOTICE_ID                                             
                 ,NOTICE_TYPE                                           
                 ,NOTICE_SUB_TYPE                                       
                 ,NOTICE_DATE                                           
                 ,NOTICE_DESC                                           
                )                                                       
                VALUES                                                  
                (                                                       
                 :S-RETURN-CODE                                         
                ,:S-NOTICE-ID                                           
                ,:S-NOTICE-TYPE                                         
                ,:S-NOTICE-SUB-TYPE                                     
                ,:S-NOTICE-DATE                                         
                ,:S-NOTICE-DESC                                         
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR03821_R1                                 
MFA-TR*         (                                                               
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,NOTICE_ID                                                     
MFA-TR*          ,NOTICE_TYPE                                                   
MFA-TR*          ,NOTICE_SUB_TYPE                                               
MFA-TR*          ,NOTICE_DATE                                                   
MFA-TR*          ,NOTICE_DESC                                                   
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*          :S-RETURN-CODE                                                 
MFA-TR*         ,:S-NOTICE-ID                                                   
MFA-TR*         ,:S-NOTICE-TYPE                                                 
MFA-TR*         ,:S-NOTICE-SUB-TYPE                                             
MFA-TR*         ,:S-NOTICE-DATE                                                 
MFA-TR*         ,:S-NOTICE-DESC                                                 
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR03821_R1'         TO TABLE-1                     
              MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1             
              MOVE MH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                       Program Copy Books                       *        
      ******************************************************************        
      *                                                                *        
      ******************************************************************        
      *9700-PROCESS-ABEND                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023C                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                  SQL Error Processing Copy Book                *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
      ************************ End of Program **************************        
