       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03818.                                         
COB303 DATE-WRITTEN.      NOVEMBER 6, 2006.                             
       DATE-COMPILED.                                                   
      ***************************************************************** 00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                  * 00080000
      ***************************************************************** 00160000
      *                P R O G R A M  S U M M A R Y                   * 00170000
      *                                                               * 00180000
      *  THIS PROGRAM RETRIEVES CUSTOMER RECORD AND CREDIT SCORING    * 00190000
      *  DATA ALONG WITH SEVERAL USER TABLE VALUES TO DETERMINE IF    * 00200000
      *  THE SSN NEEDS TO BE MASKED.                                  * 00210000
      ******************************************************************00230000
      *                                                               * 00240000
      *                     PROGRAM MODIFICATION LOG                  * 00250000
      *    DATE    USER ID    COMMENTS                                * 00270000
      *  --------  --------   --------------------------------------- * 00280000
P34788*  11/06/06  RB19957    STORED PROCEDURE ORIGINALLY CODED.      * 00290000
A01492*  07/27/09  MJ13662    IF CR_RQST_REASON_CD = 'B' DO NOT SELECT*         
A01492*                       ROW FROM CSS_CREDIT_HIST.               *         
      ***************************************************************** 00310000
      ***************************************************************** 00320000
      *                                                               * 00330000
      *                ---- BASIC SEQUENCE STRUCTURE ----             * 00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            * 00360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   * 00370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  * 00380000
      *  3000 - 4999  NOT USED                                        * 00390000
      *  5000 - 5999  COMMON PROGRAM MODULES                          * 00400000
      *  6000 - 6999  COMMON SYSTEM MODULES                           * 00410000
      *  7000 - 7999  INPUT MODULES                                   * 00420000
      *  8000 - 8999  OUTPUT MODULES                                  * 00430000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES           * 00440000
      *                                                               * 00450000
      ***************************************************************** 00460000
      *                                                                 00470000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03818'.
MSQ017     COPY MFASQLM.
      *                                                                 00510000
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03818 STARTS HERE'.                  
      *                                                                 00540000
      ******************************************************************00550000
      *    DB2 INCLUDES                                                *00560000
      ******************************************************************00570000
      *                                                                 00580000
           EXEC SQL                                                     00590000
              INCLUDE SQLCA                                             00600000
           END-EXEC.                                                    00610000
      *                                                                 00651000
      ******************************************************************00550000
      *    C8 - CSS_DELINQUENCY                                        *00560000
      ******************************************************************00570000
      *                                                                 00620000
           EXEC SQL                                                     00630000
              INCLUDE TBDELQ                                            00640000
           END-EXEC.                                                    00650000
      *                                                                 00651000
      ******************************************************************00550000
      *    CK - CSS_CREDIT_HIST                                        *00560000
      ******************************************************************00570000
      *                                                                 00620000
           EXEC SQL                                                     00630000
              INCLUDE TBCRHIST                                          00640000
           END-EXEC.                                                    00650000
      *                                                                 00620000
      ******************************************************************00550000
      *    CU - CSS_CUSTOMER                                           *00560000
      ******************************************************************00570000
      *                                                                 00620000
           EXEC SQL                                                     00630000
              INCLUDE TBCUST                                            00640000
           END-EXEC.                                                    00650000
      *                                                                 00651000
      ******************************************************************00830000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00840000
      ******************************************************************00850000
      *                                                                 00860000
      ******************************************************************00830000
      *  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.     **00840000
      ******************************************************************00850000
      *                                                                 00860000
           COPY CWS00303.                                               00920000
      *                                                                 00930000
      ******************************************************************00940000
      *    WORK AREAS                                                  *00950000
      ******************************************************************00960000
      *                                                                 00970000
       01  PARM-FIELDS.                                                 
           05  PARM-CUSTOMER-NO        PIC X(10)      VALUE SPACES.     
           05  PARM-CUSTOMER-NO-RED    REDEFINES PARM-CUSTOMER-NO       
                                       PIC 9(10).                       
      *                                                                 01151000
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 01691000
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-SSN-MASK-FLAG         PIC X(1)  VALUE SPACES.          
      *                                                                 02430000
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                 02510000
       01  WS-MISCELLANEOUS.                                            
           05  PROGRAM-NAME            PIC X(08)   VALUE 'CSR03818'.    
           05  WS-NULL-CUST-EST-DT     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-CR-HIST-TRAN-DT PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-CR-HIST-TRAN-TM PIC S9(04)  COMP VALUE ZERO.     
           05  WS-MASK-SSN-CUST-DAYS   PIC 9(09)   VALUE ZERO.          
           05  WS-MASK-SSN-SCORE-HOURS PIC 9(09)   VALUE ZERO.          
           05  WS-CURRENT-HOUR         PIC 9(08)   VALUE ZERO.          
           05  WS-CURRENT-DATE         PIC 9(08)   VALUE ZERO.          
           05  WS-DATE.                                                 
               10  WS-DATE-YYYY        PIC X(04).                       
               10  WS-DATE-MM          PIC X(02).                       
               10  WS-DATE-DD          PIC X(02).                       
           05  WS-DATE-REDEFINE        REDEFINES WS-DATE                
                                       PIC 9(08).                       
           05  WS-DAYS                 PIC 9(09)   VALUE ZEROES.        
           05  WS-HOURS                PIC S9(09)   VALUE ZEROES.       
      *                                                                 02700000
      ******************************************************************00830000
      *  THIS COPYBOOK IS USED FOR ERROR HANDLING - ABENDS.           **00840000
      ******************************************************************00850000
      *                                                                 00860000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
      *                                                                 00000040
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO         PIC X(10).                          
      *                                                                         
       PROCEDURE DIVISION USING                                         
                LINK-CUSTOMER-NO.                                       
      *                                                                         
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
      *                                                                 00000500
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
      *                                                                 02720000
      ******************************************************************02730000
      * 0000-MAINLINE                                                  *02740000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02750000
      ******************************************************************02760000
       0000-MAINLINE.                                                   
      *                                                                 02790000
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 02840000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02870000
      ******************************************************************02880000
      * 0100-INITIALIZE                                                *02890000
      *                                                                *02900000
      *     1. INITIALIZE FLAG AND OTHER WS FIELD                      *02910000
      *     2. DECLARE TEMP TABLE USED TO SEND DATA                    *02920000
      *     3. GET DELIQUENCY VALUES                                   *02930000
      *                                                                *02950000
      ******************************************************************02960000
       0100-INITIALIZE.                                                 
      *                                                                 03200000
           MOVE 'N' TO S-SSN-MASK-FLAG.                                 
           MOVE LINK-CUSTOMER-NO TO PARM-CUSTOMER-NO.                   
      *                                                                 03200000
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE              AS    RETURN_CODE             
             ,:S-SSN-MASK-FLAG            AS    SSN_MASK_FLAG           
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,:S-SSN-MASK-FLAG            AS    SSN_MASK_FLAG                   
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
      *****                                                             03200000
           MOVE 'MASK-SSN-CUST-DAYS' TO C8-DELINQ-CD.                   
           PERFORM 7000-GET-DELIQUENCY-VALUES THRU 7000-EXIT.           
           MOVE C8-DELINQ-VALUE TO WS-MASK-SSN-CUST-DAYS.               
      *                                                                 03200000
           MOVE 'MASK-SSN-SCORE-HOURS' TO C8-DELINQ-CD.                 
           PERFORM 7000-GET-DELIQUENCY-VALUES THRU 7000-EXIT.           
           MOVE C8-DELINQ-VALUE TO WS-MASK-SSN-SCORE-HOURS.             
      *                                                                 03200000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03230000
      ******************************************************************03240000
      * 1000-PROCESS-INPUT                                             *03250000
      *                                                                *03260000
      *     MOVE PARM VALUE/S TO TABLE FIELDS.                         *03270000
      *                                                                *03280000
      ******************************************************************03290000
       1000-PROCESS-INPUT.                                              
      *                                                                 03680000
           MOVE '1000' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03320000
           MOVE PARM-CUSTOMER-NO-RED TO CU-CUSTOMER-NO                  
                                        CK-CUSTOMER-NO.                 
      *                                                                 03343000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03370000
      ************************************************************      03580000
      *   2000-PROCESS-OUTPUT                                    *      03590000
      *                                                          *      03600000
      *   1. RETRIEVE DB2 DATA AND BUILD RESULT SET              *      03620000
      *   2. SEND RESULT SET                                     *      03630000
      *                                                          *      03640000
      ************************************************************      03650000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 03680000
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03680000
           PERFORM 2100-BUILD-RESULT THRU 2100-EXIT.                    
           PERFORM 8100-SEND-RESULT  THRU 8100-EXIT.                    
      *                                                                 03730000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03760000
      ******************************************************************11460000
      *   2100-BUILD-RESULT                                            *11470000
      *                                                                *11480000
      *   1.  SELECT AND FORMAT ALL CUSTOMER DETAIL INFORMATION        *11500000
      *       TO BE RETURNED.                                          *11512000
      *                                                                *11520000
      ******************************************************************11530000
       2100-BUILD-RESULT.                                               
      *                                                                 03680000
           MOVE '2100' TO ACTIVE-PARAGRAPH.                             
      *                                                                 11560000
           PERFORM 7100-SELECT-CUSTOMER-DATE   THRU 7100-EXIT.          
      *                                                                 11560000
           MOVE FUNCTION CURRENT-DATE(1:8) TO WS-CURRENT-DATE.          
           MOVE CU-CUSTOMER-EST-DATE(1:4) TO WS-DATE-YYYY.              
           MOVE CU-CUSTOMER-EST-DATE(6:2) TO WS-DATE-MM.                
           MOVE CU-CUSTOMER-EST-DATE(9:2) TO WS-DATE-DD.                
           COMPUTE WS-DAYS =                                            
               FUNCTION INTEGER-OF-DATE (WS-CURRENT-DATE) -             
               FUNCTION INTEGER-OF-DATE (WS-DATE-REDEFINE).             
      *                                                                 11560000
           IF WS-DAYS > WS-MASK-SSN-CUST-DAYS                           
               MOVE 'Y' TO S-SSN-MASK-FLAG                              
               PERFORM 7200-SELECT-CRED-HIST-DATE  THRU 7200-EXIT       
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   MOVE FUNCTION CURRENT-DATE(9:2) TO WS-CURRENT-HOUR   
                   MOVE CK-CR-HIST-TRAN-DT(1:4) TO WS-DATE-YYYY         
                   MOVE CK-CR-HIST-TRAN-DT(6:2) TO WS-DATE-MM           
                   MOVE CK-CR-HIST-TRAN-DT(9:2) TO WS-DATE-DD           
                   MOVE CK-CR-HIST-TRAN-TM(1:2) TO WS-HOURS             
                   COMPUTE WS-DAYS =                                    
                       FUNCTION INTEGER-OF-DATE (WS-CURRENT-DATE) -     
                       FUNCTION INTEGER-OF-DATE (WS-DATE-REDEFINE)      
                   COMPUTE WS-HOURS = WS-CURRENT-HOUR - WS-HOURS        
                   IF WS-DAYS > 0                                       
                       COMPUTE WS-HOURS = (WS-DAYS * 24) + WS-HOURS     
                   END-IF                                               
                   IF WS-HOURS < WS-MASK-SSN-SCORE-HOURS                
                       MOVE 'N' TO S-SSN-MASK-FLAG                      
                   END-IF                                               
               ELSE                                                     
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                       MOVE SUCCESSFUL-CALL TO S-RETURN-CODE            
                                               WS-ACTIVE-RETURN-CODE    
                                               SQLCODE                  
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                 11801000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11801000
      ******************************************************************13260000
      *   7000-GET-DELIQUENCY-VALUES                                   *13270000
      *                                                                *13271000
      *   1.  GETS THE DELIQUENCY VALUES FOR ESTABLISHED NUMBER OF     *13272000
      *       DAYS AND CREDIT SCORING NUMBER OF DAYS.                  *13272100
      *                                                                *13271000
      ******************************************************************13280000
       7000-GET-DELIQUENCY-VALUES.                                      
      *                                                                 13310000
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03760000
           EXEC SQL                                                     
              SELECT TOP(1) C8.COMPANY_NO,
              C8.DELINQ_VALUE                                    
              INTO  :C8-COMPANY-NO                                      
                   ,:C8-DELINQ-VALUE                                    
              FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                    
              WHERE C8.DELINQ_CD = :C8-DELINQ-CD                        
              ORDER BY COMPANY_NO, DELINQ_VALUE                         
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13320000
MFA-TR*       SELECT C8.COMPANY_NO                                      13330000
MFA-TR*             ,C8.DELINQ_VALUE                                    13330000
MFA-TR*       INTO  :C8-COMPANY-NO                                      13440101
MFA-TR*            ,:C8-DELINQ-VALUE                                    13440101
MFA-TR*       FROM  CSS_DELINQUENCY C8                                  13550000
MFA-TR*       WHERE C8.DELINQ_CD = :C8-DELINQ-CD                        13560000
MFA-TR*       ORDER BY COMPANY_NO, DELINQ_VALUE                         13560000
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                 13560000
MFA-TR*       WITH UR                                                   13560000
MFA-TR*    END-EXEC.                                                    13570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13581000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 13600000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME      TO ABEND-PROGRAM                   
              MOVE 'SELECT'          TO ABEND-FUNCTION                  
              MOVE 'CSS_DELINQUENCY' TO TABLE-1                         
              MOVE 'C8.DELINQ_CD'    TO TABLE-ELEMENT-1                 
              MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1               
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 13600000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14130000
      ******************************************************************13260000
      *   7100-SELECT-CUSTOMER-DATE.                                   *13270000
      *                                                                *13271000
      *   1.  GETS CUSTOMER ESTABLISHED DATE                           *13272000
      *                                                                *13271000
      ******************************************************************13280000
       7100-SELECT-CUSTOMER-DATE.                                       
      *                                                                 13310000
           MOVE '7100' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03760000
           EXEC SQL                                                     
              SELECT CU.CUSTOMER_EST_DATE                               
              INTO  :CU-CUSTOMER-EST-DATE :WS-NULL-CUST-EST-DT           
              FROM   CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
              WHERE  CU.CUSTOMER_NO = :CU-CUSTOMER-NO                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13320000
MFA-TR*       SELECT CU.CUSTOMER_EST_DATE                               13330000
MFA-TR*       INTO  :CU-CUSTOMER-EST-DATE:WS-NULL-CUST-EST-DT           13440101
MFA-TR*       FROM   CSS_CUSTOMER CU                                    13550000
MFA-TR*       WHERE  CU.CUSTOMER_NO = :CU-CUSTOMER-NO                   13560000
MFA-TR*       WITH UR                                                   13560000
MFA-TR*    END-EXEC.                                                    13570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13581000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 13600000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-CUST-EST-DT = -1                               
                 MOVE 'N' TO S-SSN-MASK-FLAG                            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE 'SELECT'        TO ABEND-FUNCTION                    
              MOVE 'CSS_CUSTOMER'  TO TABLE-1                           
              MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1                   
              MOVE CU-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1                 
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 13600000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14130000
      ******************************************************************14140000
      *   7200-SELECT-CRED-HIST-DATE                                   *14150000
      *                                                                *14151000
      *   1.  GETS CREDIT SCORING DATE                                 *13272000
      *                                                                *14152000
      ******************************************************************14160000
       7200-SELECT-CRED-HIST-DATE.                                      
      *                                                                 14190000
           MOVE '7200' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03760000
           EXEC SQL                                                     
              SELECT TOP(1) MAX(CK.CR_HIST_TRAN_DT),
              REPLACE(CONVERT(CHAR(8), MAX(CK.CR_HIST_TRAN_TM), 108), 
           ':', '.')                            
              INTO  :CK-CR-HIST-TRAN-DT :WS-NULL-CR-HIST-TRAN-DT         
                   ,:CK-CR-HIST-TRAN-TM :WS-NULL-CR-HIST-TRAN-TM         
              FROM   CSS_CREDIT_HIST CK WITH(READUNCOMMITTED)                   
              WHERE  CK.CUSTOMER_NO   = :CK-CUSTOMER-NO                 
A01492          AND  CK.CR_RQST_REASON_CD <> 'B'                        
              GROUP BY CK.CR_HIST_TRAN_DT                               
                      ,CK.CR_HIST_TRAN_TM                               
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT MAX(CK.CR_HIST_TRAN_DT)                            14210000
MFA-TR*             ,MAX(CK.CR_HIST_TRAN_TM)                            14210000
MFA-TR*       INTO  :CK-CR-HIST-TRAN-DT:WS-NULL-CR-HIST-TRAN-DT         14380000
MFA-TR*            ,:CK-CR-HIST-TRAN-TM:WS-NULL-CR-HIST-TRAN-TM         14380000
MFA-TR*       FROM   CSS_CREDIT_HIST CK                                 14550000
MFA-TR*       WHERE  CK.CUSTOMER_NO   = :CK-CUSTOMER-NO                 14560000
MFA-TR*         AND  CK.CR_RQST_REASON_CD <> 'B'                                
MFA-TR*       GROUP BY CK.CR_HIST_TRAN_DT                               13560000
MFA-TR*               ,CK.CR_HIST_TRAN_TM                               13560000
MFA-TR*       FETCH FIRST ROW ONLY                                      13560000
MFA-TR*       WITH UR                                                   13560000
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14580000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 14600000
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              IF WS-NULL-CR-HIST-TRAN-DT = -1                           
                 MOVE '1950-01-01' TO CK-CR-HIST-TRAN-DT                
              END-IF                                                    
              IF WS-NULL-CR-HIST-TRAN-TM = -1                           
                 MOVE '00.00.00' TO CK-CR-HIST-TRAN-TM                  
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CREDIT_HIST'    TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CK-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 14730100
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14760000
      ************************************************************      03580000
      *   8100-SEND-RESULT                                       *      03590000
      *      SEND RESULT SET                                     *      03630000
      ************************************************************      03650000
      *                                                                 14760000
       8100-SEND-RESULT.                                                
           ADD 1 TO CTR-ROWS.                                           
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14760000
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
