       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03817.                                     
COB303 DATE-WRITTEN. AUGUST 28, 2006.                                   
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03514              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03817 :                                                --         
      *--                                                            --         
      *--  #  CALCULATES SEASONAL BLOCKAGE CHARGES FOR THE GIVEN     --         
      *--     ACCOUNT.                                               --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            SER_TURN_OFF_DATE     CHAR(10)                  --         
      *--            SER_ON_BILL_DATE      CHAR(10)                  --         
      *--            SEASONAL_IND          CHAR(01)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            SEABLK_AMOUNT         CHAR(10)                  --         
      *--            SER_TURN_OFF_DATE     CHAR(10)                  --         
      *--            SER_ON_BILL_DATE      CHAR(10)                  --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--     1                                                      --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  08/28/2006    JC91900     PROGRAM INTIALLY WRITTEN.       --         
A36545*--  11/16/2007    JC91900     FIX ISSUE WITH UNBLOCKING.      --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03817'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT, AT                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_UTL_ENVRMNT , UT                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BILLING_HDR , BI                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BILLING_DET , BG                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CNSMPTN_HIST, CX                                          *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCNSMP                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_FIXED_FCTR, FF                                            *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFXDFCT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BUDGET_HIST, BH                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBGTHST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_CUST_PREM_HIST, CH                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCSTPRM                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BTU_WNA_RANGE, BR                                         *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBTUWNA                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_SPCL_FCTR, SF                                             *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBSPLFTR                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_SPCL_FCTR_APPL, SA                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBSPLAPL                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_RATE_USE_SEASN, RS                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRTUSES                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_RATE_VRSN_DEF, J4                                         *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRTVRSN                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY, C8                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBDELQ                                                 
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_MTRD_ENVRNMT, MN                                          *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMTRENV                                               
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK                                 *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    DB2 ERRROR PROCESSING COPYBOOK                              *        
      ******************************************************************        
       COPY CWSSP001.                                                           
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(08) VALUE 'CSRERLOG'.    
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR03817'.    
           05  WS-YES                    PIC X(01) VALUE 'Y'.           
           05  WS-NO                     PIC X(01) VALUE 'N'.           
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-ACCOUNT-NO               PIC X(13) VALUE SPACES.        
           10 S-SER-ON-BILL-DATE         PIC X(10) VALUE SPACES.        
           10 S-SER-TURN-OFF-DATE        PIC X(10) VALUE SPACES.        
           10 S-RETURN-CODE              PIC S9(9) VALUE 0 COMP.        
           10 S-SEABLK-AMOUNT            PIC S9(9)V9(2) COMP-3 VALUE 0. 
           10 S-MONTH-CT                 PIC S9(4) COMP VALUE 0.        
           10 S-MONTH-AVG                PIC S9(9)V9(2) COMP-3 VALUE 0. 
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9) COMP.                
           05  WRKLEN1                   PIC S9(9) COMP.                
           05  WRKLEN2                   PIC S9(9) COMP.                
           05  WRK-DONE-STATUS           PIC S9(9) COMP.                
                                                                        
       01  WS-MISC.                                                     
           05  WS-ANNIVERSARY-DATE.                                     
               10  WS-AD-MONTH           PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  WS-AD-DAY             PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  WS-AD-YEAR            PIC X(04) VALUE SPACES.        
           05  WS-START-DATE.                                           
               10  WS-SD-MONTH           PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '/'.           
               10  WS-SD-DAY             PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '/'.           
               10  WS-SD-YEAR            PIC X(04) VALUE SPACES.        
                                                                        
           05  WS-RETURN-CODE            PIC S9(4)  COMP VALUE 0.       
           05  WS-IC-NO                  PIC S9(4)  VALUE 0.            
           05  WS-PARM-ACCOUNT-NO        PIC 9(13) VALUE ZERO.          
           05  WS-ACCOUNT-NO             PIC 9(13) VALUE ZERO.          
           05  WS-DATE-HOLD              PIC X(10).                     
           05  WS-WORK-DATE              PIC X(10) VALUE SPACES.        
           05  WS-SEAS-END-REV-DT        PIC X(10) VALUE SPACES.        
           05  WS-SEAS-BEG-REV-DT        PIC X(10) VALUE SPACES.        
           05  WS-SER-TURN-OFF-DATE      PIC X(10) VALUE SPACES.        
           05  WS-SER-ON-BILL-DATE       PIC X(10) VALUE SPACES.        
           05  WS-SEAS-END-REV-MTH       PIC 9(06).                     
           05  WS-SEAS-BEG-REV-MTH       PIC 9(06).                     
           05  WRK-SEAS-REV-MTH          PIC 9(06).                     
           05  WRK-DATE-FROM             PIC 9(04).                     
           05  WRK-DATE-TO               PIC 9(04).                     
COB305     05 WS-SSN-BEG-REV-MTH        PIC S9(6)V USAGE COMP-3 VALUE 0.       
           05  WS-TOTAL-BFC-AMT          PIC S9(9)V9(4) USAGE COMP-3    
                                                        VALUE ZEROES.   
           05  WS-BFC-AMT                PIC S9(5)V9(2) USAGE COMP-3    
                                                        VALUE ZEROES.   
           05  WS-NON-SUMMER-START-MTH   PIC S9(6).                     
           05  WS-NON-SUMMER-WRK-MTH     PIC S9(6).                     
           05  WS-SEAS-MTH-R             PIC S9(6).                     
COB305     05 WS-NON-SUMMER-CMP-MTH        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.   
           05  WS-SECURED-RATE-IND       PIC X(01) VALUE 'N'.           
           05  WS-START-READ-DATE        PIC X(10) VALUE SPACES.        
COB305     05 WS-CPD99-PREMISE-NO        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.      
           05  WS-CPD99-ACCOUNT-NO       PIC S9(13) COMP-3 VALUE ZERO.  
           05  WS-CODE-SEASON            PIC X(01) VALUE SPACE.         
           05  WS-MONTH-CT               PIC S9(4) COMP VALUE 0.        
           05  WS-MONTH-AVG              PIC S9(9)V9(2) COMP-3 VALUE 0. 
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-01            PIC S9(4) USAGE COMP VALUE +0. 
                                                                        
       01  SWITCHES.                                                    
           05  WS-SEASONAL-IND           PIC X(01) VALUE SPACES.        
               88 OFF-ORDER-PROCESS                VALUE 'F'.           
               88 ON-ORDER-PROCESS                 VALUE 'O'.           
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-NO-MORE-SEABLK         PIC X(01) VALUE 'N'.           
               88 NO-MORE-SEABLK                   VALUE 'Y'.           
           05 WS-FACTOR-BILLED-SW        PIC X(01) VALUE 'N'.           
               88 FACTOR-ALREADY-BILLED            VALUE 'Y'.           
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  IN-ACCOUNT-NO                 PIC X(13).                     
       01  IN-SER-TURN-OFF-DATE          PIC X(10).                     
       01  IN-SER-ON-BILL-DATE           PIC X(10).                     
                                                                        
                                                                        
       PROCEDURE DIVISION USING IN-ACCOUNT-NO                           
                               ,IN-SER-TURN-OFF-DATE                    
                               ,IN-SER-ON-BILL-DATE.                    
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
                                                                        
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
                                                                        
           GOBACK.                                                      
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-INITIALIZE                                               *         
      *    SET UP SQL ERROR PROCESSING,                               *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
                                                                        
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
                                                                        
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
      *                                                                         
           EXEC SQL                                                     
                                                                        
              DECLARE C1 CURSOR  FOR                         
               SELECT  :S-ACCOUNT-NO           AS ACCOUNT_NO            
                      ,:S-SER-ON-BILL-DATE     AS SER_ON_BILL_DATE      
                      ,:S-SER-TURN-OFF-DATE    AS SER_TURN_OFF_DATE     
                      ,:S-RETURN-CODE          AS RETURN_CODE           
                      ,:S-SEABLK-AMOUNT        AS SEABLK_AMOUNT         
                      ,:S-MONTH-CT             AS MONTH_CT              
                      ,:S-MONTH-AVG            AS MONTH_AVG             
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT  :S-ACCOUNT-NO           AS ACCOUNT_NO                    
MFA-TR*               ,:S-SER-ON-BILL-DATE     AS SER_ON_BILL_DATE              
MFA-TR*               ,:S-SER-TURN-OFF-DATE    AS SER_TURN_OFF_DATE             
MFA-TR*               ,:S-RETURN-CODE          AS RETURN_CODE                   
MFA-TR*               ,:S-SEABLK-AMOUNT        AS SEABLK_AMOUNT                 
MFA-TR*               ,:S-MONTH-CT             AS MONTH_CT                      
MFA-TR*               ,:S-MONTH-AVG            AS MONTH_AVG                     
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                                                                        
           MOVE +0001                        TO FF-IC-NO                
           MOVE IN-SER-TURN-OFF-DATE         TO WS-SER-TURN-OFF-DATE.   
           MOVE IN-SER-ON-BILL-DATE          TO WS-SER-ON-BILL-DATE.    
           MOVE IN-ACCOUNT-NO                TO WS-PARM-ACCOUNT-NO      
           MOVE WS-PARM-ACCOUNT-NO           TO AT-ACCOUNT-NO           
                                                FF-ACCOUNT-NO           
                                                BG-ACCOUNT-NO           
                                                MN-ACCOUNT-NO           
                                                WS-ACCOUNT-NO.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT           THRU 2200-EXIT.          
                                                                        
           ADD +1                            TO CTR-ROWS.               
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-SELECT-ACCOUNT-DET     THRU 7000-EXIT.          
                                                                        
           MOVE WS-SER-TURN-OFF-DATE       TO WS-SEAS-BEG-REV-DT.       
           MOVE WS-SER-ON-BILL-DATE        TO WS-SEAS-END-REV-DT.       
                                                                        
           PERFORM 6400-CALCULATE-SEABLK-CHRGS THRU 6400-EXIT.          
           IF WS-MONTH-CT > 0                                           
               COMPUTE WS-MONTH-AVG =                                   
                       WS-TOTAL-BFC-AMT /                               
                       WS-MONTH-CT
           END-IF.                                     
                                                                        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2000A-MOVE-RESULT.                                            *         
      *****************************************************************         
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO S-RETURN-CODE.          
           MOVE WS-SEAS-BEG-REV-DT           TO S-SER-TURN-OFF-DATE.    
           MOVE WS-SEAS-END-REV-DT           TO S-SER-ON-BILL-DATE.     
           MOVE WS-TOTAL-BFC-AMT             TO S-SEABLK-AMOUNT.        
           MOVE AT-ACCOUNT-NO                TO S-ACCOUNT-NO.           
           MOVE WS-MONTH-CT                  TO S-MONTH-CT.             
           MOVE WS-MONTH-AVG                 TO S-MONTH-AVG.            
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6400-CALCULATE-SEABLK-CHRGS.                                  *         
      *****************************************************************         
       6400-CALCULATE-SEABLK-CHRGS.                                     
                                                                        
           MOVE 'G'                          TO FF-CODE-UTIL-TYPE.      
           PERFORM 7171-GET-UT-DETAILS          THRU 7171-EXIT          
A36545     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A36545        MOVE AT-PREMISE-NO             TO WS-CPD99-PREMISE-NO     
A36545        PERFORM 7167-FETCH-OLD-ACCOUNT    THRU 7167-EXIT          
A36545        MOVE WS-CPD99-ACCOUNT-NO       TO AT-ACCOUNT-NO           
A36545                                          BG-ACCOUNT-NO           
A36545                                          FF-ACCOUNT-NO           
A36545        PERFORM 7171-GET-UT-DETAILS       THRU 7171-EXIT          
A36545     END-IF                                                       
                                                                        
           MOVE WS-SEAS-END-REV-DT(1:4)      TO WS-SEAS-END-REV-MTH(1:4)
           MOVE WS-SEAS-END-REV-DT(6:2)      TO WS-SEAS-END-REV-MTH(5:2)
           MOVE WS-SEAS-BEG-REV-DT(1:4)      TO WS-SEAS-BEG-REV-MTH(1:4)
           MOVE WS-SEAS-BEG-REV-DT           TO WS-WORK-DATE            
                                                WS-DATE-HOLD            
           MOVE WS-SEAS-BEG-REV-DT(6:2)      TO WS-SEAS-BEG-REV-MTH(5:2)
           MOVE WS-SEAS-BEG-REV-MTH          TO WS-SSN-BEG-REV-MTH      
           MOVE FF-IC-NO                     TO BG-IC-NO.               
           PERFORM 7154-GET-RATE-PLAN-NO       THRU 7154-EXIT           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               MOVE AT-PREMISE-NO            TO WS-CPD99-PREMISE-NO     
               PERFORM 7167-FETCH-OLD-ACCOUNT  THRU 7167-EXIT           
               MOVE WS-CPD99-ACCOUNT-NO      TO AT-ACCOUNT-NO           
A36545                                          BG-ACCOUNT-NO           
A36545                                          FF-ACCOUNT-NO           
               PERFORM 7154-GET-RATE-PLAN-NO   THRU 7154-EXIT           
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE ZERO                  TO WS-ACTIVE-RETURN-CODE   
                  MOVE WS-ACCOUNT-NO         TO AT-ACCOUNT-NO           
                  MOVE UT-RATE-PLAN-NO       TO BG-RATE-PLAN-NO         
               END-IF                                                   
            END-IF                                                      
                                                                        
            PERFORM 7155-WINTER-START-MONTH    THRU 7155-EXIT           
                                                                        
            MOVE WS-SEAS-BEG-REV-MTH         TO WRK-SEAS-REV-MTH        
            MOVE WS-NON-SUMMER-CMP-MTH       TO WS-NON-SUMMER-START-MTH 
            MOVE ZEROES                      TO WS-TOTAL-BFC-AMT        
                                                                        
            PERFORM 7169-GET-RANGES            THRU 7169-EXIT           
            PERFORM UNTIL WRK-SEAS-REV-MTH > WS-SEAS-END-REV-MTH        
                 PERFORM 6600-SEAS-BLK-CHRG    THRU 6600-EXIT           
            END-PERFORM                                                 
                                                                        
            MOVE WS-TOTAL-BFC-AMT            TO FF-FACTOR.              
                                                                        
       6400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6600-SEAS-BLK-CHRG.                                           *         
      * COMPUTE THE SEASONAL BLOCK CHARGE. CURRENTLY, WE ARE NOT      *         
      * HANDLING FIXED FACTOR BFC ADJUSTMENTS. WE ARE ONLY HANDLING   *         
      * BFC ADJUSTMENTS APPLIED VIA RATE FACTORS.                     *         
      *****************************************************************         
       6600-SEAS-BLK-CHRG.                                              
                                                                        
           MOVE WRK-SEAS-REV-MTH(5:2)          TO WS-SEAS-MTH-R.        
           IF WS-SEAS-MTH-R EQUAL WS-NON-SUMMER-START-MTH               
              IF UT-GAS-BASE-USE >= BR-GAS-BASE-USE-MIN                 
                 IF BR-GAS-BASE-HIGH-RATE EQUAL BG-RATE-PLAN-NO         
                    NEXT SENTENCE                                       
                 END-IF                                                 
                 MOVE BR-GAS-BASE-HIGH-RATE  TO BG-RATE-PLAN-NO         
              ELSE                                                      
                 IF BR-GAS-BASE-LOW-RATE EQUAL BG-RATE-PLAN-NO          
                    NEXT SENTENCE                                       
                 END-IF                                                 
                 MOVE BR-GAS-BASE-LOW-RATE   TO BG-RATE-PLAN-NO         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE ZERO                         TO J4-AMT-CUST-CHRG        
                                                WS-BFC-AMT.             
           PERFORM 7157-GET-BFC                THRU 7157-EXIT.          
           MOVE J4-AMT-CUST-CHRG             TO WS-BFC-AMT.             
           PERFORM 7158-GET-SEASONS            THRU 7158-EXIT.          
           MOVE RS-DATE-FROM                 TO WRK-DATE-FROM.          
           MOVE RS-DATE-TO                   TO WRK-DATE-TO.            
                                                                        
           IF WRK-DATE-FROM EQUAL ZERO                                  
              MOVE 'S'                       TO WS-CODE-SEASON          
           ELSE                                                         
              IF (WRK-DATE-FROM(1:2) <= WRK-SEAS-REV-MTH(5:2))          
                 AND (WRK-DATE-TO(1:2) >= WRK-SEAS-REV-MTH(5:2))        
                    MOVE 'S'                 TO WS-CODE-SEASON          
              ELSE                                                      
                 MOVE 'N'                    TO WS-CODE-SEASON          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7159-BFC-ADJUST             THRU 7159-EXIT.          
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
              IF SF-ADJUST-ELEMENT EQUAL 'L'                            
                 COMPUTE WS-BFC-AMT = WS-BFC-AMT + SA-FACTOR            
              ELSE                                                      
                 COMPUTE WS-BFC-AMT = WS-BFC-AMT - SA-FACTOR            
              END-IF                                                    
           END-IF.                                                      
                                                                        
           COMPUTE WS-TOTAL-BFC-AMT = WS-TOTAL-BFC-AMT + WS-BFC-AMT.    
           MOVE WRK-SEAS-REV-MTH(1:4)        TO WS-DATE-HOLD(1:4).      
           MOVE '-'                          TO WS-DATE-HOLD(5:1).      
           MOVE WRK-SEAS-REV-MTH(5:2)        TO WS-DATE-HOLD(6:2).      
           MOVE '-'                          TO WS-DATE-HOLD(8:1).      
           MOVE '01'                         TO WS-DATE-HOLD(9:2).      
                                                                        
           PERFORM 7565-ADD-ONE-REVENUE-MTH    THRU 7565-EXIT.          
                                                                        
           MOVE WS-DATE-HOLD                 TO WS-WORK-DATE.           
           MOVE WS-DATE-HOLD(1:4)            TO WRK-SEAS-REV-MTH(1:4).  
           MOVE WS-DATE-HOLD(6:2)            TO WRK-SEAS-REV-MTH(5:2).  
           ADD +1 TO WS-MONTH-CT.                                       
                                                                        
       6600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-SELECT-ACCOUNT-DET.                                      *         
      *****************************************************************         
       7000-SELECT-ACCOUNT-DET.                                         
                                                                        
           EXEC SQL                                                     
              SELECT AT.ACCOUNT_NO                                      
                    ,AT.PREMISE_NO                                      
                INTO :AT-ACCOUNT-NO                                     
                    ,:AT-PREMISE-NO                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7153-GET-SEASN-BEG-REV-DATE.                                  *         
      *****************************************************************         
       7153-GET-SEASN-BEG-REV-DATE.                                     
                                                                        
           EXEC SQL                                                     
                SELECT DATEADD( MONTH, 1, DATEADD( MONTH, -
                                                   :FF-FAC-CHRG-BASE-AM
              , IIF(TRY_CONVERT(DATE, :WS-SEAS-END-REV-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-SEAS-END-REV-DT
              ) <> 0) OR (LEN(:WS-SEAS-END-REV-DT
              ) <> 10), CIS.CHAR2DATE(:WS-SEAS-END-REV-DT
              ), CONVERT(DATE, :WS-SEAS-END-REV-DT) ) ) ) 
                  INTO :WS-SEAS-BEG-REV-DT                              
                  FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DATE(:WS-SEAS-END-REV-DT)                                
MFA-TR*                         - :FF-FAC-CHRG-BASE-AM MONTHS + 1 MONTH         
MFA-TR*           INTO :WS-SEAS-BEG-REV-DT                                      
MFA-TR*           FROM CSS_MODEL_SQL                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7153'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_MODEL_SQL'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'SEAS END REV DT'         TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-SEAS-END-REV-DT        TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7153-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7154-GET-RATE-PLAN-NO.                                        *         
      *****************************************************************         
       7154-GET-RATE-PLAN-NO.                                           
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) BG.RATE_PLAN_NO                                  
                  INTO :BG-RATE-PLAN-NO                                 
                  FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
                 WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO            
                   AND BG.CODE_UTIL_TYPE    = 'G'                       
                   AND BG.IC_NO             = :BG-IC-NO                 
                   AND BG.REVENUE_MONTH     =                           
                        (SELECT MAX(REVENUE_MONTH)                      
                           FROM CSS_BILLING_DET BG1
                           WITH(READUNCOMMITTED)                     
                          WHERE BG1.ACCOUNT_NO     = :BG-ACCOUNT-NO     
                            AND BG1.CODE_UTIL_TYPE = 'G'                
                            AND BG1.IC_NO          = :BG-IC-NO          
                            AND BG1.REVENUE_MONTH <= :WS-SSN-BEG-REV-MTH
                            AND BG1.REVENUE_MONTH > 0)                  
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT BG.RATE_PLAN_NO                                          
MFA-TR*           INTO :BG-RATE-PLAN-NO                                         
MFA-TR*           FROM CSS_BILLING_DET BG                                       
MFA-TR*          WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO                    
MFA-TR*            AND BG.CODE_UTIL_TYPE    = 'G'                               
MFA-TR*            AND BG.IC_NO             = :BG-IC-NO                         
MFA-TR*            AND BG.REVENUE_MONTH     =                                   
MFA-TR*                 (SELECT MAX(REVENUE_MONTH)                              
MFA-TR*                    FROM CSS_BILLING_DET BG1                             
MFA-TR*                   WHERE BG1.ACCOUNT_NO     = :BG-ACCOUNT-NO             
MFA-TR*                     AND BG1.CODE_UTIL_TYPE = 'G'                        
MFA-TR*                     AND BG1.IC_NO          = :BG-IC-NO                  
MFA-TR*                     AND BG1.REVENUE_MONTH <= :WS-SSN-BEG-REV-MTH        
MFA-TR*                     AND BG1.REVENUE_MONTH > 0)                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7154'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'SSN BEG REV MTH'         TO TABLE-ELEMENT-2         
              MOVE 'IC NO'                   TO TABLE-ELEMENT-3         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-SSN-BEG-REV-MTH        TO HOSTVAR-ELEMENT-2       
              MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7154-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7155-WINTER-START-MONTH.                                      *         
      *****************************************************************         
       7155-WINTER-START-MONTH.                                         
                                                                        
           EXEC SQL                                                     
               SELECT C7.DELINQ_VALUE                                   
                 INTO :WS-NON-SUMMER-CMP-MTH                            
                 FROM CSS_DELINQUENCY C7 WITH(READUNCOMMITTED)                  
                WHERE C7.DELINQ_CD = 'NON-SUMMER-START-MTH'             
                  AND C7.COMPANY_NO = '01'                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT C7.DELINQ_VALUE                                           
MFA-TR*          INTO :WS-NON-SUMMER-CMP-MTH                                    
MFA-TR*          FROM CSS_DELINQUENCY C7                                        
MFA-TR*         WHERE C7.DELINQ_CD = 'NON-SUMMER-START-MTH'                     
MFA-TR*           AND C7.COMPANY_NO = '01'                                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7155'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7155-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7157-GET-BFC.                                                 *         
      *****************************************************************         
       7157-GET-BFC.                                                    
                                                                        
           EXEC SQL                                                     
               SELECT RV.AMT_CUST_CHRG                                  
                     ,RV.VERSION_NO_CNTRL                               
                 INTO :J4-AMT-CUST-CHRG                                 
                     ,:J4-VERSION-NO-CNTRL                              
                 FROM CSS_RATE_CREATOR RT                               
                     ,CSS_RATE_VRSN_DEF RV                              
                WHERE RT.CODE_UTIL_TYPE = 'G'                           
                  AND RT.CODE_UTIL_TYPE = RV.CODE_UTIL_TYPE             
                  AND RT.RATE_PLAN_NO   = :BG-RATE-PLAN-NO              
                  AND RT.RATE_PLAN_NO   = RV.RATE_PLAN_NO               
                  AND RT.CODE_STATUS IN ('A','I','F')                   
                  AND RT.VERSION_NO_CNTRL =                             
                     (SELECT MAX(R2.VERSION_NO_CNTRL)                   
                        FROM CSS_RATE_CREATOR R2                        
                       WHERE R2.CODE_UTIL_TYPE    = RT.CODE_UTIL_TYPE   
                         AND R2.RATE_PLAN_NO      = RT.RATE_PLAN_NO     
                         AND R2.FROM_EFFECTIVE_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) )      
                         AND RT.VERSION_NO_CNTRL  = RV.VERSION_NO_CNTRL)
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RV.AMT_CUST_CHRG                                          
MFA-TR*              ,RV.VERSION_NO_CNTRL                                       
MFA-TR*          INTO :J4-AMT-CUST-CHRG                                         
MFA-TR*              ,:J4-VERSION-NO-CNTRL                                      
MFA-TR*          FROM CSS_RATE_CREATOR RT                                       
MFA-TR*              ,CSS_RATE_VRSN_DEF RV                                      
MFA-TR*         WHERE RT.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND RT.CODE_UTIL_TYPE = RV.CODE_UTIL_TYPE                     
MFA-TR*           AND RT.RATE_PLAN_NO   = :BG-RATE-PLAN-NO                      
MFA-TR*           AND RT.RATE_PLAN_NO   = RV.RATE_PLAN_NO                       
MFA-TR*           AND RT.CODE_STATUS IN ('A','I','F')                           
MFA-TR*           AND RT.VERSION_NO_CNTRL =                                     
MFA-TR*              (SELECT MAX(R2.VERSION_NO_CNTRL)                           
MFA-TR*                 FROM CSS_RATE_CREATOR R2                                
MFA-TR*                WHERE R2.CODE_UTIL_TYPE    = RT.CODE_UTIL_TYPE           
MFA-TR*                  AND R2.RATE_PLAN_NO      = RT.RATE_PLAN_NO             
MFA-TR*                  AND R2.FROM_EFFECTIVE_DT <= :WS-DATE-HOLD              
MFA-TR*                  AND RT.VERSION_NO_CNTRL  = RV.VERSION_NO_CNTRL)        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7157'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'RATE PLAN NO'            TO TABLE-ELEMENT-2         
              MOVE 'DATE HOLD'               TO TABLE-ELEMENT-3         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-DATE-HOLD              TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7157-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7158-GET-SEASONS.                                             *         
      *****************************************************************         
       7158-GET-SEASONS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT RS.DATE_FROM                                      
                     ,RS.DATE_TO                                        
                 INTO :RS-DATE-FROM                                     
                     ,:RS-DATE-TO                                       
                 FROM CSS_RATE_USE_SEASN RS WITH(READUNCOMMITTED)               
                WHERE RATE_PLAN_NO     = :BG-RATE-PLAN-NO               
                  AND CODE_UTIL_TYPE   = 'G'                            
                  AND VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RS.DATE_FROM                                              
MFA-TR*              ,RS.DATE_TO                                                
MFA-TR*          INTO :RS-DATE-FROM                                             
MFA-TR*              ,:RS-DATE-TO                                               
MFA-TR*          FROM CSS_RATE_USE_SEASN RS                                     
MFA-TR*         WHERE RATE_PLAN_NO     = :BG-RATE-PLAN-NO                       
MFA-TR*           AND CODE_UTIL_TYPE   = 'G'                                    
MFA-TR*           AND VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7158'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_USE_SEASN'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'RATE PLAN NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION NO CNTL'         TO TABLE-ELEMENT-3         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J4-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7158-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7159-BFC-ADJUST.                                              *         
      *****************************************************************         
       7159-BFC-ADJUST.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT SA.FACTOR                                         
                     ,SF.ADJUST_ELEMENT                                 
                 INTO :SA-FACTOR                                        
                     ,:SF-ADJUST-ELEMENT                                
                 FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                    
                     ,CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
                WHERE SF.ADJUST_ELEMENT IN ('L','O')                    
                  AND SF.FACTOR_ID         = SA.FACTOR_ID               
                  AND SA.CODE_UTIL_TYPE    = 'G'                        
                  AND SA.RATE_PLAN_NO      = :BG-RATE-PLAN-NO           
                  AND SA.DATE_FROM         <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) )             
                  AND SA.DATE_TO           >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) )             
                  AND SA.CMPNT_ID_CD       = '10'                       
                  AND SA.CODE_SEASON       = :WS-CODE-SEASON            
                  AND SA.INSTR_USE_TYPE_CD = 'R'                        
                  AND SA.CODE_STATUS       = 'A'                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SA.FACTOR                                                 
MFA-TR*              ,SF.ADJUST_ELEMENT                                         
MFA-TR*          INTO :SA-FACTOR                                                
MFA-TR*              ,:SF-ADJUST-ELEMENT                                        
MFA-TR*          FROM CSS_SPCL_FCTR SF                                          
MFA-TR*              ,CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*         WHERE SF.ADJUST_ELEMENT IN ('L','O')                            
MFA-TR*           AND SF.FACTOR_ID         = SA.FACTOR_ID                       
MFA-TR*           AND SA.CODE_UTIL_TYPE    = 'G'                                
MFA-TR*           AND SA.RATE_PLAN_NO      = :BG-RATE-PLAN-NO                   
MFA-TR*           AND SA.DATE_FROM         <= :WS-WORK-DATE                     
MFA-TR*           AND SA.DATE_TO           >= :WS-WORK-DATE                     
MFA-TR*           AND SA.CMPNT_ID_CD       = '10'                               
MFA-TR*           AND SA.CODE_SEASON       = :WS-CODE-SEASON                    
MFA-TR*           AND SA.INSTR_USE_TYPE_CD = 'R'                                
MFA-TR*           AND SA.CODE_STATUS       = 'A'                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7159'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'RATE PLAN NO'            TO TABLE-ELEMENT-2         
              MOVE 'WORK DATE'               TO TABLE-ELEMENT-3         
              MOVE 'CODE REASON'             TO TABLE-ELEMENT-4         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-WORK-DATE              TO HOSTVAR-ELEMENT-3       
              MOVE WS-CODE-SEASON            TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7159-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7167-FETCH-OLD-ACCOUNT.                                       *         
      *****************************************************************         
       7167-FETCH-OLD-ACCOUNT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT CH.ACCOUNT_NO                                      
                INTO :WS-CPD99-ACCOUNT-NO                               
                FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                
               WHERE CH.PREMISE_NO = :WS-CPD99-PREMISE-NO               
                 AND DATE_UTIL_SVC_END =                                
                    (SELECT MAX(DATE_UTIL_SVC_END)                      
                       FROM CSS_CUST_PREM_HIST CH1 WITH(READUNCOMMITTED)        
                      WHERE CH1.PREMISE_NO = :WS-CPD99-PREMISE-NO       
                        AND CH1.DATE_UTIL_SVC_END IS NOT NULL)          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CH.ACCOUNT_NO                                              
MFA-TR*         INTO :WS-CPD99-ACCOUNT-NO                                       
MFA-TR*         FROM CSS_CUST_PREM_HIST CH                                      
MFA-TR*        WHERE CH.PREMISE_NO = :WS-CPD99-PREMISE-NO                       
MFA-TR*          AND DATE_UTIL_SVC_END =                                        
MFA-TR*             (SELECT MAX(DATE_UTIL_SVC_END)                              
MFA-TR*                FROM CSS_CUST_PREM_HIST CH1                              
MFA-TR*               WHERE CH1.PREMISE_NO = :WS-CPD99-PREMISE-NO               
MFA-TR*                 AND CH1.DATE_UTIL_SVC_END IS NOT NULL)                  
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
A36545     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7166'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PREMISE NO'              TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-CPD99-PREMISE-NO       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7167-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7169-GET-RANGES.                                              *         
      *****************************************************************         
       7169-GET-RANGES.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT BR.GAS_BASE_HIGH_RATE                              
                    ,BR.GAS_BASE_LOW_RATE                               
                    ,BR.GAS_BASE_USE_MIN                                
                INTO :BR-GAS-BASE-HIGH-RATE                             
                    ,:BR-GAS-BASE-LOW-RATE                              
                    ,:BR-GAS-BASE-USE-MIN                               
                FROM CSS_BTU_WNA_RANGE BR                               
               WHERE BR.CODE_UTIL_TYPE = 'G'                            
                AND  BR.RATE_PLAN_NO   = :BG-RATE-PLAN-NO               
                AND  BR.EFFECTIVE_DT   =                                
                         (SELECT MAX(B1.EFFECTIVE_DT)                   
                            FROM CSS_BTU_WNA_RANGE B1                   
                           WHERE B1.RATE_PLAN_NO   = :BG-RATE-PLAN-NO   
                             AND B1.CODE_UTIL_TYPE = 'G')               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7169'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BTU_WNA_RANGE'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'RATE PLAN NO'            TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7169-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7171-GET-UT-DETAILS                                           *         
      *****************************************************************         
       7171-GET-UT-DETAILS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT UT.GAS_BASE_USE                                    
                    ,UT.RATE_PLAN_NO                                    
                INTO :UT-GAS-BASE-USE                                   
                    ,:UT-RATE-PLAN-NO                                   
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE UT.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE             
                 AND UT.ACCOUNT_NO     = :FF-ACCOUNT-NO                 
                 AND UT.IC_NO          = :FF-IC-NO                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.GAS_BASE_USE                                            
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*         INTO :UT-GAS-BASE-USE                                           
MFA-TR*             ,:UT-RATE-PLAN-NO                                           
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                     
MFA-TR*          AND UT.ACCOUNT_NO     = :FF-ACCOUNT-NO                         
MFA-TR*          AND UT.IC_NO          = :FF-IC-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
A36545     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7171'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE UTIL TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC NO'                   TO TABLE-ELEMENT-3         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7171-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7565-ADD-ONE-REVENUE-MTH.                                     *         
      *****************************************************************         
       7565-ADD-ONE-REVENUE-MTH.                                        
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ) )
            INTO
              :WS-DATE-HOLD         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-HOLD = DATE(:WS-DATE-HOLD) + 1 MONTH                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7565'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DATE HOLD'               TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-DATE-HOLD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7565-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SQL ERROR PROCESSING COPYLIB                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
