                                                                        
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03784.                                         
       AUTHOR.        Covansys.                                         
       DATE-WRITTEN.  August 2006.                                      
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  This program returns additional account details like DPP,     *        
      *  Recent Pledges placed on this Account, Spouse, Roommate,      *        
      *  Co-Applicant and Group Code(SEB Only).                        *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     Program Modification Log                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  08/15/2006 VP94820   Initial Implementation for Web-CAA.      *        
      *                                                                *        
      ******************************************************************        
      *                ---- Basic Sequence Structure ----              *        
      *                                                                *        
      *         0000 - 0999     Main Control Path and Initialization   *        
      *         1000 - 1999     Input Processing Control Path          *        
      *         2000 - 2999     Output Processing Control Path         *        
      *         7000 - 7999     Database Access / Input Modules        *        
      *         8000 - 8999     Output Modules                         *        
      *         9000 - 9799     Termination Modules                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03784'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                         PIC X(40)  VALUE            
           'WORKING STORAGE FOR CSR03784 STARTS HERE'.                  
      *                                                                         
       01 WORK-AREAS.                                                   
          05 PROGRAM-NAME                  PIC X(08)  VALUE 'CSR03784'. 
          05 WS-ACCOUNT-NO                 PIC X(13).                   
          05 WS-ACCOUNT-NO-NUM             REDEFINES WS-ACCOUNT-NO      
                                           PIC 9(13).                   
          05 WS-ACCOUNT-NO-COMP3           PIC S9(13) COMP-3 VALUE +0.  
          05 WS-CUSTOMER-NO                PIC X(10).                   
          05 WS-CUSTOMER-NO-NUM            REDEFINES WS-CUSTOMER-NO     
                                           PIC 9(10).                   
          05 WS-CUSTOMER-NO-COMP3          PIC S9(10) COMP-3 VALUE +0.  
          05 WS-SQLSTATE                   PIC X(05) VALUE SPACES.      
          05 WS-TS.                                                     
             10 WS-DATE                    PIC X(10) VALUE SPACES.      
             10 FILLER                     PIC X(16) VALUE              
                                               '-00.00.00.000000'.      
          05 WS-TIMESTAMP                  REDEFINES WS-TS              
                                           PIC X(26).                   
          05 WS-DAYS                       PIC S9(04)V9(05) COMP-3      
                                                     VALUE +0.          
          05 WS-DATABASE                   PIC S9(04)V9(05) COMP-3      
                                                     VALUE +0.          
          05 WS-PREV-CHAR                  PIC X(01) VALUE SPACES.      
          05 WS-NO-MORE-DATA               PIC X(01) VALUE 'N'.         
             88 NO-MORE-DATA                         VALUE 'Y'.         
          05 WS-FORMAT                     PIC X(01) VALUE 'N'.         
             88 FORMAT-DONE                          VALUE 'Y'.         
          05 SEND-DONE-SW                  PIC X(01) VALUE 'Y'.         
             88 SEND-DONE-ERROR                      VALUE 'N'.         
             88 SEND-DONE-OK                         VALUE 'Y'.         
      *                                                                         
       01 WS-NAME-TABLES.                                               
          05 WS-FIRST-NAME.                                             
             10 WS-FIRST-CHAR          PIC X(01)                        
                            OCCURS 15 TIMES INDEXED BY WS-IDX-F.        
          05 WS-MIDDLE-NAME.                                            
             10 WS-MIDDLE-CHAR         PIC X(01)                        
                            OCCURS 15 TIMES INDEXED BY WS-IDX-M.        
          05 WS-LAST-NAME.                                              
             10 WS-LAST-CHAR           PIC X(01)                        
                            OCCURS 20 TIMES INDEXED BY WS-IDX-L.        
          05 WS-FULL-NAME.                                              
             10 WS-FULL-CHAR           PIC X(01)                        
                            OCCURS 52 TIMES INDEXED BY WS-IDX-N.        
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9)     COMP   VALUE ZERO. 
           05  RS-ROW-TYPE             PIC X(01)     VALUE SPACES.      
           05  RS-DPP-TOTAL-AMT        PIC S9(09)V99 COMP-3 VALUE ZERO. 
           05  RS-DPP-BALANCE          PIC S9(09)V99 COMP-3 VALUE ZERO. 
           05  RS-DPP-AGREE-DATE       PIC X(10)     VALUE SPACES.      
           05  RS-AGENCY-NAME          PIC X(30)     VALUE SPACES.      
           05  RS-PLDG-DATE            PIC X(10)     VALUE SPACES.      
           05  RS-PLDG-AMT             PIC S9(07)V99 COMP-3 VALUE ZERO. 
           05  RS-NAME                 PIC X(50)     VALUE SPACES.      
           05  RS-SSN                  PIC X(09)     VALUE SPACES.      
           05  RS-GROUP-CODE           PIC X(06)     VALUE SPACES.      
           05  RS-NO-SCHED-PYMTS       PIC S9(4)     COMP   VALUE ZERO. 
           05  RS-RCNTLY-BLLD-MTH      PIC X(02)     VALUE SPACES.      
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9)     COMP   VALUE ZERO. 
           05  S-ROW-TYPE              PIC X(01)     VALUE SPACES.      
           05  S-DPP-TOTAL-AMT         PIC S9(09)V99 COMP-3 VALUE ZERO. 
           05  S-DPP-BALANCE           PIC S9(09)V99 COMP-3 VALUE ZERO. 
           05  S-DPP-AGREE-DATE        PIC X(10)     VALUE SPACES.      
           05  S-AGENCY-NAME           PIC X(30)     VALUE SPACES.      
           05  S-PLDG-DATE             PIC X(10)     VALUE SPACES.      
           05  S-PLDG-AMT              PIC S9(07)V99 COMP-3 VALUE ZERO. 
           05  S-NAME                  PIC X(50)     VALUE SPACES.      
           05  S-SSN                   PIC X(09)     VALUE SPACES.      
           05  S-GROUP-CODE            PIC X(06)     VALUE SPACES.      
           05  S-NO-SCHED-PYMTS        PIC S9(4)     COMP   VALUE ZERO. 
           05  S-RCNTLY-BLLD-MTH       PIC X(02)     VALUE SPACES.      
      *                                                                         
      ******************************************************************        
      * Indicator Variables                                            *        
      ******************************************************************        
      *                                                                         
       01  WS-NULL-INDICATORES.                                         
           05  WS-DA-DATE-NULL         PIC S9(4) COMP.                  
      *                                                                         
      ******************************************************************00630000
      * DB2 Includes.                                                  *00640000
      ******************************************************************00650000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    LI - CSS_LIEAP                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBLIEAP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    I5 - CSS_LIEAP_AGENCY                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBLIAGCY                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DQ - CSS_NAME                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DA - CSS_DFA_ACCT                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    AC - CSS_AR_CNTL                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CE - CSS_CUST_STATS                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTSTS                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    LR - CSS_REG_PROFILE                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SQL Error Checking Copy books.                                 *        
      ******************************************************************        
      *                                                                         
      *01  WS-WARNING-DATA-ELEMENTS.                                            
       COPY CWS00303.                                                           
      *                                                                         
      *01  CSRERLOG-P.                                                          
       COPY CWSSP001.                                                           
      *                                                                         
      ******************************************************************        
      * Error Handling Copy Book.                                      *        
      ******************************************************************        
      *                                                                         
      *01  ABEND-FILE.                                                          
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Cursor for getting all the Pledges placed and Reimbursed for   *        
      * the account in past. (Duration based on Delinquency values)    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE PREVIOUS_PLEDGES  CURSOR FOR                     
               SELECT                                                   
                      I5.AGENCY_NA                                      
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           LI.VOUCHER_PAY_DT, 121), ' ', '-'), ':', '.') VOUCHER_PAY_DT        
                     ,LI.VOUCHER_AMT                                    
               FROM                                                     
                      CSS_LIEAP LI WITH(READUNCOMMITTED)                        
                     ,CSS_LIEAP_AGENCY I5 WITH(READUNCOMMITTED)                 
               WHERE                                                    
                      LI.ACCOUNT_NO           = :LI-ACCOUNT-NO          
                 AND  LI.VOUCHER_PAY_DT > CIS.CHAR2TIMESTAMP(
                                                          :WS-TIMESTAMP
              )                 
                 AND  LI.CODE_AGENCY_ID    = I5.CODE_AGENCY_ID          
                 FOR READ ONLY                                        
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PREVIOUS_PLEDGES  CURSOR FOR                             
MFA-TR*        SELECT                                                           
MFA-TR*               I5.AGENCY_NA                                              
MFA-TR*              ,LI.VOUCHER_PAY_DT                                         
MFA-TR*              ,LI.VOUCHER_AMT                                            
MFA-TR*        FROM                                                             
MFA-TR*               CSS_LIEAP LI                                              
MFA-TR*              ,CSS_LIEAP_AGENCY I5                                       
MFA-TR*        WHERE                                                            
MFA-TR*               LI.ACCOUNT_NO           = :LI-ACCOUNT-NO                  
MFA-TR*          AND  LI.VOUCHER_PAY_DT > :WS-TIMESTAMP                         
MFA-TR*          AND  LI.CODE_AGENCY_ID    = I5.CODE_AGENCY_ID                  
MFA-TR*          FOR  FETCH ONLY                                                
MFA-TR*         WITH  UR                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Cursor for getting Roommate or Co-Applicant's name             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE ROOMATE_COAPP CURSOR FOR                         
               SELECT                                                   
                       HT.CUSTOMER_ROLE_CD                              
                      ,DQ.FIRST_NAME                                    
                      ,DQ.MIDDLE_NAME                                   
                      ,DQ.LAST_NAME                                     
                 FROM                                                   
                       CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)             
                      ,CSS_NAME            DQ WITH(READUNCOMMITTED)             
                WHERE                                                   
                       HT.CUSTOMER_NO          = :HT-CUSTOMER-NO        
                  AND  HT.ACCOUNT_NO           = :HT-ACCOUNT-NO         
                  AND  HT.CUSTOMER_ROLE_CD     IN ('A','B')             
                  AND  HT.NAME_ID              = DQ.NAME_ID             
                  FOR READ ONLY                                       
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ROOMATE_COAPP CURSOR FOR                                 
MFA-TR*        SELECT                                                           
MFA-TR*                HT.CUSTOMER_ROLE_CD                                      
MFA-TR*               ,DQ.FIRST_NAME                                            
MFA-TR*               ,DQ.MIDDLE_NAME                                           
MFA-TR*               ,DQ.LAST_NAME                                             
MFA-TR*          FROM                                                           
MFA-TR*                CSS_NAME_ACCT_XREF  HT                                   
MFA-TR*               ,CSS_NAME            DQ                                   
MFA-TR*         WHERE                                                           
MFA-TR*                HT.CUSTOMER_NO          = :HT-CUSTOMER-NO                
MFA-TR*           AND  HT.ACCOUNT_NO           = :HT-ACCOUNT-NO                 
MFA-TR*           AND  HT.CUSTOMER_ROLE_CD     IN ('A','B')                     
MFA-TR*           AND  HT.NAME_ID              = DQ.NAME_ID                     
MFA-TR*           FOR  FETCH ONLY                                               
MFA-TR*          WITH  UR                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  I-APPLICATION-ID           PIC X(07).                        
       01  I-ACCOUNT-NO               PIC X(13).                        
       01  I-CUSTOMER-NO              PIC X(10).                        
      *                                                                         
       PROCEDURE DIVISION USING  I-APPLICATION-ID                       
                                 I-ACCOUNT-NO                           
                                 I-CUSTOMER-NO.                         
      *                                                                         
      ******************************************************************        
      * Controls the Main Processing of the Program.                   *        
      ******************************************************************        
      *                                                                         
       0000-MAIN-LINE.                                                  
      *                                                                         
           PERFORM  0100-INITIALIZATION           THRU  0100-EXIT.      
           PERFORM  1000-PROCESS-INPUT            THRU  1000-EXIT.      
           PERFORM  2000-PROCESS-OUTPUT           THRU  2000-EXIT.      
           PERFORM  9999-END-PROGRAM              THRU  9999-EXIT.      
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Initialize Return Fields, Declare GTT and Result Set Cursor.   *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           INITIALIZE  GTT-RETURN-FIELDS.                               
           MOVE 'N'                    TO WS-NO-MORE-DATA.              
                                                                        
           PERFORM 0100A-DECLARE-GTT   THRU 0100A-EXIT.                 
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     RETURN_CODE                                        
                    ,LTRIM(RTRIM(ROW_TYPE))              AS ROW_TYPE           
                    ,DPP_TOTAL_AMT                                      
                    ,DPP_BALANCE                                        
                    ,DPP_AGREE_DATE                                     
                    ,LTRIM(RTRIM(AGENCY_NAME))           AS AGENCY_NAME        
                    ,LTRIM(RTRIM(PLDG_DATE))             AS PLDG_DATE          
                    ,PLDG_AMT                                           
                    ,LTRIM(RTRIM(NAME))                  AS NAME               
                    ,LTRIM(RTRIM(SSN))                   AS SSN                
                    ,LTRIM(RTRIM(GROUP_CODE))            AS GROUP_CODE         
                    ,NO_SCHED_PYMTS                                     
                    ,LTRIM(RTRIM(RCNTLY_BLLD_MTH))       AS 
           RCNTLY_BLLD_MTH    
                FROM                                                    
                    #CSR03784_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,STRIP(ROW_TYPE)              AS ROW_TYPE                   
MFA-TR*             ,DPP_TOTAL_AMT                                              
MFA-TR*             ,DPP_BALANCE                                                
MFA-TR*             ,DPP_AGREE_DATE                                             
MFA-TR*             ,STRIP(AGENCY_NAME)           AS AGENCY_NAME                
MFA-TR*             ,STRIP(PLDG_DATE)             AS PLDG_DATE                  
MFA-TR*             ,PLDG_AMT                                                   
MFA-TR*             ,STRIP(NAME)                  AS NAME                       
MFA-TR*             ,STRIP(SSN)                   AS SSN                        
MFA-TR*             ,STRIP(GROUP_CODE)            AS GROUP_CODE                 
MFA-TR*             ,NO_SCHED_PYMTS                                             
MFA-TR*             ,STRIP(RCNTLY_BLLD_MTH)       AS RCNTLY_BLLD_MTH            
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR03784_R1                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           MOVE 'NBR-DAYS-CSR03784'             TO   C8-DELINQ-CD.      
           PERFORM 7100-GET-DELIQUENCY-VALUES   THRU 7100-EXIT.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE              TO WS-DAYS              
           ELSE                                                         
              MOVE 30                           TO WS-DAYS              
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, -IIF(TRY_CAST(:WS-DAYS AS INT) IS NULL, 
              CIS.INTEGER(:WS-DAYS), CAST(:WS-DAYS AS INT)), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-DATE     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET  :WS-DATE = (CURRENT DATE - INT(:WS-DAYS) DAYS)             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE 'DATABASE'                      TO   C8-DELINQ-CD.      
           PERFORM 7100-GET-DELIQUENCY-VALUES   THRU 7100-EXIT.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE       TO WS-DATABASE                 
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Declares GTT For Holding Result Set.                           *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03784_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03784_R1
              (                                                       
                     RETURN_CODE          INT                       
                    ,ROW_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                    ,DPP_TOTAL_AMT        DECIMAL(11,2)                 
                    ,DPP_BALANCE          DECIMAL(11,2)                 
                    ,DPP_AGREE_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,AGENCY_NAME CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,PLDG_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                    ,PLDG_AMT             DECIMAL(09,2)                 
                    ,NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2             
                    ,SSN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2              
                    ,GROUP_CODE CHAR(06)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,NO_SCHED_PYMTS       SMALLINT                      
                    ,RCNTLY_BLLD_MTH CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE              TO WS-SQLSTATE.                   
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE SQLCODE            TO ABEND-SQLCODE                 
               MOVE SQLSTATE           TO ABEND-SQLSTATE                
               MOVE '0100A'            TO ACTIVE-PARAGRAPH              
               MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSR03784_R1'      TO TABLE-1                       
               MOVE SPACES             TO TABLE-ELEMENT-1               
               MOVE SPACES             TO HOSTVAR-ELEMENT-1             
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                       THRU  9900-EXIT                  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************02790000
      * Receive and Validate Input Parameters.                         *02800000
      ******************************************************************02840000
      *                                                                 02850000
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF I-ACCOUNT-NO > SPACES AND I-CUSTOMER-NO > SPACES          
              MOVE I-ACCOUNT-NO              TO WS-ACCOUNT-NO           
              MOVE WS-ACCOUNT-NO-NUM         TO WS-ACCOUNT-NO-COMP3     
              MOVE WS-ACCOUNT-NO-COMP3       TO DA-ACCOUNT-NO           
                                                AC-ACCOUNT-NO           
                                                HT-ACCOUNT-NO           
                                                LI-ACCOUNT-NO           
                                                LR-ACCOUNT-NO           
              MOVE I-CUSTOMER-NO             TO WS-CUSTOMER-NO          
              MOVE WS-CUSTOMER-NO-NUM        TO WS-CUSTOMER-NO-COMP3    
              MOVE WS-CUSTOMER-NO-COMP3      TO CE-CUSTOMER-NO          
                                                HT-CUSTOMER-NO          
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'PROCESS INPUT'           TO ABEND-FUNCTION          
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE I-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1       
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-2         
              MOVE I-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2       
              MOVE +100                      TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Gets the Previous Pledges, DPP, Spouse, Roommate, Co-Applicant,*03500000
      * Group Code details and formats the Result Set.                 *03500000
      ******************************************************************03560000
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7110-OPEN-PREV-PLEDGES       THRU 7110-EXIT.         
           MOVE 'A'                             TO RS-ROW-TYPE.         
           PERFORM 2100-PROCESS-PREV-PLEDGES    THRU 2100-EXIT          
                                                UNTIL NO-MORE-DATA.     
           PERFORM 7130-CLOSE-PREV-PLEDGES      THRU 7130-EXIT.         
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE 'D'                             TO RS-ROW-TYPE.         
           PERFORM 2200-GET-DPP-DETAILS         THRU 2200-EXIT.         
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE 'S'                             TO RS-ROW-TYPE.         
           PERFORM 2300-GET-SPOUSE-NAME         THRU 2300-EXIT          
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE 'N'                             TO WS-NO-MORE-DATA.     
           PERFORM 7410-OPEN-ROOMATE-COAPP      THRU 7410-EXIT.         
           PERFORM 2400-GET-ROOMMATE-COAPP      THRU 2400-EXIT          
                                                UNTIL NO-MORE-DATA.     
           PERFORM 7430-CLOSE-ROOMATE-COAPP     THRU 7430-EXIT.         
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE 'I'                             TO RS-ROW-TYPE.         
           PERFORM 2500-GET-SSN                 THRU 2600-EXIT.         
      * For SEB only                                                            
           IF WS-DATABASE = 2                                           
              INITIALIZE TDS-RETURN-FIELDS                              
              MOVE 'G'                          TO RS-ROW-TYPE          
              PERFORM 2600-GET-GROUP-CODE       THRU 2600-EXIT          
           END-IF.                                                      
           IF CTR-ROWS < 1 THEN                                         
              MOVE SPACES                       TO RS-ROW-TYPE          
              PERFORM 2000A-MOVE-RS-TO-S        THRU 2000A-EXIT         
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      ******************************************************************03490000
      * Prepares Result Set Row.                                       *03500000
      ******************************************************************03560000
      *                                                                         
       2000A-MOVE-RS-TO-S.                                              
      *                                                                         
           MOVE  RS-RETURN-CODE            TO    S-RETURN-CODE.         
           MOVE  RS-ROW-TYPE               TO    S-ROW-TYPE.            
           MOVE  RS-DPP-TOTAL-AMT          TO    S-DPP-TOTAL-AMT.       
           MOVE  RS-DPP-BALANCE            TO    S-DPP-BALANCE.         
           MOVE  RS-DPP-AGREE-DATE         TO    S-DPP-AGREE-DATE.      
           MOVE  RS-AGENCY-NAME            TO    S-AGENCY-NAME.         
           MOVE  RS-PLDG-DATE              TO    S-PLDG-DATE.           
           MOVE  RS-PLDG-AMT               TO    S-PLDG-AMT.            
           MOVE  RS-NAME                   TO    S-NAME.                
           MOVE  RS-SSN                    TO    S-SSN.                 
           MOVE  RS-GROUP-CODE             TO    S-GROUP-CODE.          
           MOVE  RS-NO-SCHED-PYMTS         TO    S-NO-SCHED-PYMTS.      
           MOVE  RS-RCNTLY-BLLD-MTH        TO    S-RCNTLY-BLLD-MTH.     
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Gets all the Previous Pledges and formats the Result Set.      *03500000
      ******************************************************************03560000
      *                                                                         
       2100-PROCESS-PREV-PLEDGES.                                       
      *                                                                         
           PERFORM 7120-FETCH-PREV-PLEDGES THRU 7120-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE I5-AGENCY-NA            TO RS-AGENCY-NAME            
              MOVE LI-VOUCHER-PAY-DT       TO RS-PLDG-DATE              
              MOVE LI-VOUCHER-AMT          TO RS-PLDG-AMT               
              PERFORM 2000A-MOVE-RS-TO-S   THRU 2000A-EXIT              
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
           ELSE                                                         
              MOVE 'Y'                     TO WS-NO-MORE-DATA           
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Gets the DPP details and Formats the Result Set.               *03500000
      ******************************************************************03560000
      *                                                                         
       2200-GET-DPP-DETAILS.                                            
      *                                                                         
           PERFORM 7200-GET-DPP-DETAILS    THRU 7200-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE DA-DATE-OF-AGREE        TO RS-DPP-AGREE-DATE         
              MOVE DA-AMT-ORIG-ENTERED     TO RS-DPP-TOTAL-AMT          
              MOVE DA-NO-SCHED-PYMTS       TO RS-NO-SCHED-PYMTS         
              MOVE DA-RCNTLY-BLLD-MTH      TO RS-RCNTLY-BLLD-MTH        
              MOVE AC-AMT-TRAN-BALANCE     TO RS-DPP-BALANCE            
              PERFORM 2000A-MOVE-RS-TO-S   THRU 2000A-EXIT              
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
           ELSE                                                         
              MOVE SPACES                  TO RS-DPP-AGREE-DATE         
              MOVE ZEROS                   TO RS-DPP-TOTAL-AMT          
                                              RS-DPP-BALANCE            
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Gets the Spouse name and formats the Result Set.               *03500000
      ******************************************************************03560000
      *                                                                         
       2300-GET-SPOUSE-NAME.                                            
      *                                                                         
           PERFORM 7300-GET-SPOUSE-NAME    THRU 7300-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE DQ-FIRST-NAME           TO WS-FIRST-NAME             
              MOVE DQ-MIDDLE-NAME          TO WS-MIDDLE-NAME            
              MOVE DQ-LAST-NAME            TO WS-LAST-NAME              
              MOVE 'N'                     TO WS-FORMAT                 
              PERFORM 5000-REFORMAT-NAME   THRU 5000-EXIT               
              MOVE WS-FULL-NAME            TO RS-NAME                   
              PERFORM 2000A-MOVE-RS-TO-S   THRU 2000A-EXIT              
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
           ELSE                                                         
              MOVE SPACES                  TO RS-NAME                   
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Gets the Roommate/Co-App Details and formats the Result Set.   *03500000
      ******************************************************************03560000
      *                                                                         
       2400-GET-ROOMMATE-COAPP.                                         
      *                                                                         
           INITIALIZE TDS-RETURN-FIELDS                                 
                      WS-FULL-NAME.                                     
           PERFORM 7420-FETCH-ROOMATE-COAPP THRU 7420-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                  TO RS-NAME                   
              MOVE 'Y'                     TO WS-NO-MORE-DATA           
              GO TO 2400-EXIT                                           
           END-IF.                                                      
           MOVE DQ-FIRST-NAME              TO WS-FIRST-NAME.            
           MOVE DQ-MIDDLE-NAME             TO WS-MIDDLE-NAME.           
           MOVE DQ-LAST-NAME               TO WS-LAST-NAME.             
           MOVE 'N'                        TO WS-FORMAT.                
           PERFORM 5000-REFORMAT-NAME      THRU 5000-EXIT.              
           MOVE WS-FULL-NAME               TO RS-NAME.                  
           IF HT-CUSTOMER-ROLE-CD = 'A'                                 
              MOVE 'R'                     TO RS-ROW-TYPE               
           ELSE                                                         
              MOVE 'C'                     TO RS-ROW-TYPE               
           END-IF.                                                      
           PERFORM 2000A-MOVE-RS-TO-S      THRU 2000A-EXIT.             
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
      *                                                                         
       2400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Gets the Customers SSN.                                        *03500000
      ******************************************************************03560000
      *                                                                         
       2500-GET-SSN.                                                    
      *                                                                         
           PERFORM 7500-GET-SSN             THRU 7500-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CE-SSN                  TO   RS-SSN                  
              PERFORM 2000A-MOVE-RS-TO-S   THRU 2000A-EXIT              
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Gets the regulatory gropu code for all SEB Accounts.           *03500000
      ******************************************************************03560000
      *                                                                         
       2600-GET-GROUP-CODE.                                             
      *                                                                         
           PERFORM 7600-GET-GROUP-CODE      THRU 7600-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF LR-REG-GROUP-CD = '100'                                
                 MOVE 'GROUP1'             TO RS-GROUP-CODE             
              ELSE                                                      
                 MOVE 'GROUP2'             TO RS-GROUP-CODE             
              END-IF                                                    
              PERFORM 2000A-MOVE-RS-TO-S   THRU 2000A-EXIT              
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Formats the Name as follows (Last, First Middle)               *03500000
      ******************************************************************        
      *                                                                         
       5000-REFORMAT-NAME.                                              
      *                                                                         
           MOVE SPACES                                TO WS-PREV-CHAR.  
           SET WS-IDX-N, WS-IDX-F, WS-IDX-M, WS-IDX-L TO 1.             
      *                                                                         
           PERFORM UNTIL (WS-IDX-L > 20 OR FORMAT-DONE)                 
              IF (WS-LAST-CHAR(WS-IDX-L) = SPACE OR LOW-VALUES          
                                              OR HIGH-VALUES)           
                AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES) 
                IF WS-IDX-N > 1                                         
                   SET WS-IDX-N DOWN BY 1                               
                   MOVE ','                   TO WS-FULL-CHAR(WS-IDX-N) 
                   SET WS-IDX-N UP BY 1                                 
                END-IF                                                  
                MOVE 'Y'                      TO WS-FORMAT              
              ELSE                                                      
                MOVE WS-LAST-CHAR(WS-IDX-L)   TO WS-FULL-CHAR(WS-IDX-N) 
                                                 WS-PREV-CHAR           
                SET WS-IDX-L, WS-IDX-N UP BY 1                          
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           MOVE SPACES                        TO WS-PREV-CHAR.          
      *                                                                         
           PERFORM UNTIL WS-IDX-F > 15                                  
              IF (WS-FIRST-CHAR(WS-IDX-F) = SPACE OR LOW-VALUES OR      
                                                     HIGH-VALUES)       
                 AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES)
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-FIRST-CHAR(WS-IDX-F) TO WS-FULL-CHAR(WS-IDX-N) 
                                                 WS-PREV-CHAR           
                 SET WS-IDX-F, WS-IDX-N UP BY 1                         
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           MOVE SPACES                        TO WS-PREV-CHAR.          
      *                                                                         
           PERFORM UNTIL WS-IDX-M > 15                                  
              IF (WS-MIDDLE-CHAR(WS-IDX-M) = SPACE OR LOW-VALUES OR     
                                                   HIGH-VALUES)         
                AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES) 
                NEXT SENTENCE                                           
              ELSE                                                      
                MOVE WS-MIDDLE-CHAR(WS-IDX-M) TO WS-FULL-CHAR(WS-IDX-N) 
                                                 WS-PREV-CHAR           
                SET WS-IDX-M, WS-IDX-N UP BY 1                          
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * Reads the CSS_DELINQUENCY Table                                *03500000
      ******************************************************************        
      *                                                                         
       7100-GET-DELIQUENCY-VALUES.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) DELINQ_VALUE                                     
                 INTO                                                   
                       :C8-DELINQ-VALUE                                 
                 FROM                                                   
                       CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                 
                WHERE                                                   
                       C8.DELINQ_CD    = :C8-DELINQ-CD                  
                                                                 
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*                DELINQ_VALUE                                             
MFA-TR*          INTO                                                           
MFA-TR*                :C8-DELINQ-VALUE                                         
MFA-TR*          FROM                                                           
MFA-TR*                CSS_DELINQUENCY C8                                       
MFA-TR*         WHERE                                                           
MFA-TR*                C8.DELINQ_CD    = :C8-DELINQ-CD                          
MFA-TR*         WITH UR                                                         
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
      *                                                                         
           EVALUATE TRUE                                                
               WHEN WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
               WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    CONTINUE                                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7100'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                   MOVE 'CSS_DELINQUENCY'     TO TABLE-1                
                   MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1        
                   MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************03490000
      * Opens the PREVIOUS_PLEDGES Cursor.                             *        
      ******************************************************************03560000
      *                                                                         
       7110-OPEN-PREV-PLEDGES.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN PREVIOUS_PLEDGES                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_LIEAP'               TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE  WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Fetches the PREVIOUS_PLEDGES Cursor.                           *        
      ******************************************************************03560000
      *                                                                         
       7120-FETCH-PREV-PLEDGES.                                         
      *                                                                         
           EXEC SQL                                                     
               FETCH                                                    
                     PREVIOUS_PLEDGES                                   
               INTO                                                     
                     :I5-AGENCY-NA                                      
                    ,:LI-VOUCHER-PAY-DT                                 
                    ,:LI-VOUCHER-AMT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         RS-RETURN-CODE.                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_LIEAP'               TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE  WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Closes the PREVIOUS_PLEDGES Cursor.                            *        
      ******************************************************************03560000
      *                                                                         
       7130-CLOSE-PREV-PLEDGES.                                         
      *                                                                         
           EXEC SQL                                                     
                CLOSE PREVIOUS_PLEDGES                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         RS-RETURN-CODE.                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_LIEAP'               TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE  WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Selects DPP Details.                                       *    03500000
      ******************************************************************03560000
      *                                                                         
       7200-GET-DPP-DETAILS.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                       DA.DATE_OF_AGREE                                 
                      ,DA.AMT_ORIG_ENTERED                              
                      ,DA.NO_SCHED_PYMTS                                
                      ,DA.RCNTLY_BLLD_MTH                               
                      ,AC.AMT_TRAN_BALANCE                              
                 INTO                                                   
                       :DA-DATE-OF-AGREE :WS-DA-DATE-NULL               
                      ,:DA-AMT-ORIG-ENTERED                             
                      ,:DA-NO-SCHED-PYMTS                               
                      ,:DA-RCNTLY-BLLD-MTH                              
                      ,:AC-AMT-TRAN-BALANCE                             
                 FROM                                                   
                       CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                    
                      ,CSS_AR_CNTL  AC WITH(READUNCOMMITTED)                    
                WHERE                                                   
                       DA.ACCOUNT_NO           = :DA-ACCOUNT-NO         
                  AND  DA.PYMT_PRIORITY_LVL    = 90                     
                  AND  DA.CODE_DFA_STATUS      = 'A'                    
                  AND  DA.CODE_DFA_TYPE        = 'B'                    
                  AND  AC.ACCOUNT_NO           = :AC-ACCOUNT-NO         
                  AND  AC.PYMT_PRIORITY_LVL    = 90                     
                  AND  DA.DFA_ITEM_ID          = AC.ITEM_ID             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*                DA.DATE_OF_AGREE                                         
MFA-TR*               ,DA.AMT_ORIG_ENTERED                                      
MFA-TR*               ,DA.NO_SCHED_PYMTS                                        
MFA-TR*               ,DA.RCNTLY_BLLD_MTH                                       
MFA-TR*               ,AC.AMT_TRAN_BALANCE                                      
MFA-TR*          INTO                                                           
MFA-TR*                :DA-DATE-OF-AGREE :WS-DA-DATE-NULL                       
MFA-TR*               ,:DA-AMT-ORIG-ENTERED                                     
MFA-TR*               ,:DA-NO-SCHED-PYMTS                                       
MFA-TR*               ,:DA-RCNTLY-BLLD-MTH                                      
MFA-TR*               ,:AC-AMT-TRAN-BALANCE                                     
MFA-TR*          FROM                                                           
MFA-TR*                CSS_DFA_ACCT DA                                          
MFA-TR*               ,CSS_AR_CNTL  AC                                          
MFA-TR*         WHERE                                                           
MFA-TR*                DA.ACCOUNT_NO           = :DA-ACCOUNT-NO                 
MFA-TR*           AND  DA.PYMT_PRIORITY_LVL    = 90                             
MFA-TR*           AND  DA.CODE_DFA_STATUS      = 'A'                            
MFA-TR*           AND  DA.CODE_DFA_TYPE        = 'B'                            
MFA-TR*           AND  AC.ACCOUNT_NO           = :AC-ACCOUNT-NO                 
MFA-TR*           AND  AC.PYMT_PRIORITY_LVL    = 90                             
MFA-TR*           AND  DA.DFA_ITEM_ID          = AC.ITEM_ID                     
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DFA_ACCT'            TO TABLE-1                 
              MOVE 'CSS_AR_CNTL'             TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE  WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE  DA-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-2       
              MOVE 'CODE_DFA_STATUS'         TO TABLE-ELEMENT-3         
              MOVE  DA-CODE-DFA-STATUS       TO HOSTVAR-ELEMENT-3       
              MOVE 'CODE_DFA_TYPE'           TO TABLE-ELEMENT-4         
              MOVE  DA-CODE-DFA-TYPE         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Selects Spouse name.                                           *03500000
      ******************************************************************03560000
      *                                                                         
       7300-GET-SPOUSE-NAME.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                       DQ.FIRST_NAME                                    
                      ,DQ.MIDDLE_NAME                                   
                      ,DQ.LAST_NAME                                     
                 INTO                                                   
                       :DQ-FIRST-NAME                                   
                      ,:DQ-MIDDLE-NAME                                  
                      ,:DQ-LAST-NAME                                    
                 FROM                                                   
                       CSS_CUST_STATS  CE WITH(READUNCOMMITTED)                 
                      ,CSS_NAME        DQ WITH(READUNCOMMITTED)                 
                WHERE                                                   
                       CE.CUSTOMER_NO          = :CE-CUSTOMER-NO        
                  AND  CE.CUSTOMER_TYPE        = 'S'                    
                  AND  CE.NAME_ID              = DQ.NAME_ID             
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*                DQ.FIRST_NAME                                            
MFA-TR*               ,DQ.MIDDLE_NAME                                           
MFA-TR*               ,DQ.LAST_NAME                                             
MFA-TR*          INTO                                                           
MFA-TR*                :DQ-FIRST-NAME                                           
MFA-TR*               ,:DQ-MIDDLE-NAME                                          
MFA-TR*               ,:DQ-LAST-NAME                                            
MFA-TR*          FROM                                                           
MFA-TR*                CSS_CUST_STATS  CE                                       
MFA-TR*               ,CSS_NAME        DQ                                       
MFA-TR*         WHERE                                                           
MFA-TR*                CE.CUSTOMER_NO          = :CE-CUSTOMER-NO                
MFA-TR*           AND  CE.CUSTOMER_TYPE        = 'S'                            
MFA-TR*           AND  CE.NAME_ID              = DQ.NAME_ID                     
MFA-TR*          WITH  UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
              MOVE 'CSS_NAME'                TO TABLE-2                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE  CE-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Opens ROOMATE_COAPP Cursor.                                    *03500000
      ******************************************************************03560000
      *                                                                         
       7410-OPEN-ROOMATE-COAPP.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN ROOMATE_COAPP                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7140'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_NAME'                TO TABLE-1                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-2         
              MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HT-CUSTOMER-NO            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Fetches ROOMATE_COAPP Cursor.                                  *03500000
      ******************************************************************03560000
      *                                                                         
       7420-FETCH-ROOMATE-COAPP.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH ROOMATE_COAPP                                      
               INTO   :HT-CUSTOMER-ROLE-CD                              
                     ,:DQ-FIRST-NAME                                    
                     ,:DQ-MIDDLE-NAME                                   
                     ,:DQ-LAST-NAME                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         RS-RETURN-CODE.                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_NAME'                TO TABLE-1                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-2         
              MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HT-CUSTOMER-NO            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Closes ROOMATE_COAPP Cursor.                                   *03500000
      ******************************************************************03560000
      *                                                                         
       7430-CLOSE-ROOMATE-COAPP.                                        
      *                                                                         
           EXEC SQL                                                     
                CLOSE ROOMATE_COAPP                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         RS-RETURN-CODE.                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7160'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_NAME'                TO TABLE-1                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-2         
              MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HT-CUSTOMER-NO            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Selects Customer's SSN.                                        *03500000
      ******************************************************************03560000
      *                                                                         
       7500-GET-SSN.                                                    
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                       CE.SSN                                           
                 INTO                                                   
                       :CE-SSN                                          
                 FROM                                                   
                       CSS_CUST_STATS  CE WITH(READUNCOMMITTED)                 
                WHERE                                                   
                       CE.CUSTOMER_NO          = :CE-CUSTOMER-NO        
                  AND  CE.CUSTOMER_TYPE        = 'C'                    
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*                CE.SSN                                                   
MFA-TR*          INTO                                                           
MFA-TR*                :CE-SSN                                                  
MFA-TR*          FROM                                                           
MFA-TR*                CSS_CUST_STATS  CE                                       
MFA-TR*         WHERE                                                           
MFA-TR*                CE.CUSTOMER_NO          = :CE-CUSTOMER-NO                
MFA-TR*           AND  CE.CUSTOMER_TYPE        = 'C'                            
MFA-TR*          WITH  UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE  CE-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Selects Group Code.                                            *03500000
      ******************************************************************03560000
      *                                                                         
       7600-GET-GROUP-CODE.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                      LR.REG_GROUP_CD                                   
                 INTO                                                   
                      :LR-REG-GROUP-CD                                  
                 FROM                                                   
                      CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                  
                WHERE                                                   
                      LR.ACCOUNT_NO          = :LR-ACCOUNT-NO           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*               LR.REG_GROUP_CD                                           
MFA-TR*          INTO                                                           
MFA-TR*               :LR-REG-GROUP-CD                                          
MFA-TR*          FROM                                                           
MFA-TR*               CSS_REG_PROFILE LR                                        
MFA-TR*         WHERE                                                           
MFA-TR*               LR.ACCOUNT_NO          = :LR-ACCOUNT-NO                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_REG_PROFILE'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE  LR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2       
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************07730000
      * Deletes all the Rows in GTT.                                   *07740000
      ******************************************************************07800000
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR03784_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR03784_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR03784_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************07730000
      * Inserts the Result Set Row Into GTT.                           *07740000
      ******************************************************************07800000
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR03784_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,ROW_TYPE                                           
                    ,DPP_TOTAL_AMT                                      
                    ,DPP_BALANCE                                        
                    ,DPP_AGREE_DATE                                     
                    ,AGENCY_NAME                                        
                    ,PLDG_DATE                                          
                    ,PLDG_AMT                                           
                    ,NAME                                               
                    ,SSN                                                
                    ,GROUP_CODE                                         
                    ,NO_SCHED_PYMTS                                     
                    ,RCNTLY_BLLD_MTH                                    
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE                                     
                    ,:S-ROW-TYPE                                        
                    ,:S-DPP-TOTAL-AMT                                   
                    ,:S-DPP-BALANCE                                     
                    ,:S-DPP-AGREE-DATE                                  
                    ,:S-AGENCY-NAME                                     
                    ,:S-PLDG-DATE                                       
                    ,:S-PLDG-AMT                                        
                    ,:S-NAME                                            
                    ,:S-SSN                                             
                    ,:S-GROUP-CODE                                      
                    ,:S-NO-SCHED-PYMTS                                  
                    ,:S-RCNTLY-BLLD-MTH                                 
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     42750000
MFA-TR*         INSERT INTO SESSION.CSR03784_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,ROW_TYPE                                                   
MFA-TR*             ,DPP_TOTAL_AMT                                              
MFA-TR*             ,DPP_BALANCE                                                
MFA-TR*             ,DPP_AGREE_DATE                                             
MFA-TR*             ,AGENCY_NAME                                                
MFA-TR*             ,PLDG_DATE                                                  
MFA-TR*             ,PLDG_AMT                                                   
MFA-TR*             ,NAME                                                       
MFA-TR*             ,SSN                                                        
MFA-TR*             ,GROUP_CODE                                                 
MFA-TR*             ,NO_SCHED_PYMTS                                             
MFA-TR*             ,RCNTLY_BLLD_MTH                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-ROW-TYPE                                                
MFA-TR*             ,:S-DPP-TOTAL-AMT                                           
MFA-TR*             ,:S-DPP-BALANCE                                             
MFA-TR*             ,:S-DPP-AGREE-DATE                                          
MFA-TR*             ,:S-AGENCY-NAME                                             
MFA-TR*             ,:S-PLDG-DATE                                               
MFA-TR*             ,:S-PLDG-AMT                                                
MFA-TR*             ,:S-NAME                                                    
MFA-TR*             ,:S-SSN                                                     
MFA-TR*             ,:S-GROUP-CODE                                              
MFA-TR*             ,:S-NO-SCHED-PYMTS                                          
MFA-TR*             ,:S-RCNTLY-BLLD-MTH                                         
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1                    TO CTR-ROWS                    
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR03784_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                  SQL Error Processing Copy Book                *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                       Program Copy Books                       *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9700-PROCESS-ABEND                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
