       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR03783.                                          
       AUTHOR.       Covansys.                                          
       DATE-WRITTEN. July 2006.                                         
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  This program returns the pledge history by agency. Based on   *        
      *  entries in CSS_DELINQUENCY table it decides duration of the   *        
      *  pledges needs to be return. Pledges are categorized into past *        
      *  and current based on the entries in CSS_DELINQUENCY table.    *        
      *  Also returns category wise totals.                            *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     Program Modification Log                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  07/27/2006 VP94820   INITIAL IMPLEMENTATION FOR WEB-CAA.      *        
A0501E*  04/01/2009 CVNS      PERFORMANCE TUNNING.                     *        
A0501E*             CHENNAI                                            *        
ACT015*  07/27/2006 BD09555   CHECK FOR NULLS BEFORE USING REIMBURSE-DT*        
ACT015*  A05477-ACT015                                                 *        
      ******************************************************************        
      *                ---- Basic Sequence Structure ----              *        
      *                                                                *        
      *         0000 - 0999     Main Control Path and Initialization   *        
      *         1000 - 1999     Input Processing Control Path          *        
      *         2000 - 2999     Output Processing Control Path         *        
      *         7000 - 7999     Database Access / Input Modules        *        
      *         8000 - 8999     Output Modules                         *        
      *         9000 - 9799     Termination Modules                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03783'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                        PIC X(40)  VALUE              
           'WORKING STORAGE FOR CSR03783 STARTS HERE'.                  
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9)     COMP VALUE ZERO.   
           05  S-REIMBURSE-DT          PIC X(10)     VALUE  SPACES.     
           05  S-CHECK-NO              PIC X(09)     VALUE  SPACES.     
COB305     05 S-ACCOUNT-NO        PIC S9(13) USAGE COMP-3 VALUE 0.      
           05  S-NAME                  PIC X(50)     VALUE SPACES.      
           05  S-VOUCHER-AMT           PIC S9(07)V99 COMP-3 VALUE ZERO. 
           05  S-VOUCHER-PAY-DT        PIC X(26)     VALUE  SPACES.     
           05  S-COMMENT               PIC X(25)     VALUE  SPACES.     
           05  S-PLEDGE-STATUS         PIC X(01)     VALUE  SPACES.     
           05  S-PAST-PLDG-TOTAL       PIC S9(07)V99 COMP-3 VALUE ZERO. 
           05  S-CURRENT-PLDG-TOTAL    PIC S9(07)V99 COMP-3 VALUE ZERO. 
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9)     COMP VALUE ZERO.   
           05  RS-REIMBURSE-DT         PIC X(10)     VALUE  SPACES.     
           05  RS-CHECK-NO             PIC X(09)     VALUE  SPACES.     
           05  RS-ACCOUNT-NO           PIC S9(13)                       
                                       USAGE COMP-3  VALUE +0.          
           05  RS-NAME                 PIC X(50)     VALUE SPACES.      
           05  RS-VOUCHER-AMT          PIC S9(07)V99 COMP-3 VALUE ZERO. 
           05  RS-VOUCHER-PAY-DT       PIC X(26)     VALUE  SPACES.     
           05  RS-COMMENT              PIC X(25)     VALUE  SPACES.     
           05  RS-PLEDGE-STATUS        PIC X(01)     VALUE  SPACES.     
           05  RS-PAST-PLDG-TOTAL      PIC S9(07)V99 COMP-3 VALUE ZERO. 
           05  RS-CURRENT-PLDG-TOTAL   PIC S9(07)V99 COMP-3 VALUE ZERO. 
      *                                                                         
       01  WS-VARIABLES.                                                
           05  PROGRAM-NAME                PIC X(08) VALUE 'CSR03783'.  
           05  WS-I-CODE-AGENCY-ID         PIC X(05) VALUE SPACES.      
           05  WS-I-BOTH-OR-NONRECONCILE   PIC X(01) VALUE SPACES.      
           05  WS-CUR-MONTHS               PIC S9(4)V9(5)               
                                           USAGE COMP-3 VALUE +0.       
           05  WS-TIMESTAMP-CUR            PIC X(26) VALUE SPACES.      
           05  WS-MONTHS                   PIC S9(4)V9(5)               
                                           USAGE COMP-3 VALUE +0.       
           05  WS-TIMESTAMP-ALL            PIC X(26) VALUE SPACES.      
           05  WS-MONTHS-NUM               PIC S9(9) VALUE ZERO.        
           05  WS-MONTHS-RED               REDEFINES WS-MONTHS-NUM      
                                           PIC X(09).                   
           05  WS-SQLSTATE                 PIC X(05) VALUE SPACES.      
           05  WS-YES                      PIC X(01) VALUE 'Y'.         
           05  WS-PREV-PLEDGE-STATUS       PIC X(01) VALUE SPACES.      
           05  WS-PAST-PLDG-TOTAL          PIC S9(07)V99                
                                           COMP-3 VALUE ZERO.           
           05  WS-CURRENT-PLDG-TOTAL       PIC S9(07)V99                
                                           COMP-3 VALUE ZERO.           
           05  WS-PLEDGE-STATUS            PIC X(01) VALUE SPACES.      
           05  WS-NO-MORE-DATA             PIC X(01) VALUE 'N'.         
               88 NO-MORE-DATA             VALUE 'Y'.                   
           05  SEND-DONE-SW                PIC X(01) VALUE 'Y'.         
               88 SEND-DONE-ERROR          VALUE 'N'.                   
               88 SEND-DONE-OK             VALUE 'Y'.                   
           05  WS-TEMP                     PIC X(02) VALUE ' X'.        
                                                                        
           05 WS-PREV-CHAR                 PIC X(01) VALUE SPACES.      
           05 WS-FORMAT                    PIC X(01) VALUE 'N'.         
              88 FORMAT-DONE                         VALUE 'Y'.         
      *                                                                         
       01 WS-NAME-TABLES.                                               
          05 WS-F-NAME.                                                 
             10 WS-FIRST-CHAR          PIC X(01)                        
                            OCCURS 15 TIMES INDEXED BY WS-IDX-F.        
          05 WS-M-NAME.                                                 
             10 WS-MIDDLE-CHAR         PIC X(01)                        
                            OCCURS 15 TIMES INDEXED BY WS-IDX-M.        
          05 WS-L-NAME.                                                 
             10 WS-LAST-CHAR           PIC X(01)                        
                            OCCURS 20 TIMES INDEXED BY WS-IDX-L.        
          05 WS-FULL-NAME-1.                                            
             10 WS-FULL-CHAR           PIC X(01)                        
                            OCCURS 52 TIMES INDEXED BY WS-IDX-N.        
                                                                        
      *                                                                         
       01 WS-END                           PIC X(38)  VALUE             
           'WORKING STORAGE FOR CSR03783 ENDS HERE'.                    
      *                                                                         
      ******************************************************************        
      * Indicator Variables                                            *        
      ******************************************************************        
      *                                                                         
       01 IND-VARIABLES.                                                
           05 IND-REIMBURSE-DT            PIC S9(4) COMP.               
           05 IND-PLEDGE-STATUS           PIC S9(4) COMP.               
      *                                                                         
      ******************************************************************00630000
      * Copy Books.                                                    *00640000
      ******************************************************************00650000
      *                                                                         
      *01 CWS00074-FIELDS.                                                      
           COPY CWS00074.                                                       
      *                                                                         
      *01  WS-11-TABLES. (Working Storage for CPD00004)                         
           COPY CWS00011.                                                       
      *                                                                         
      ******************************************************************00630000
      * DB2 Includes.                                                  *00640000
      ******************************************************************00650000
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    LI - CSS_LIEAP                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBLIEAP                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DQ - CSS_NAME                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBNAME                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBNMACTX                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DM - CSS_CUST_ADDR_XREF                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCSADRX                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DZ - CSS_ADDR_FREEFORM                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBADRFRE                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DY - CSS_ADDR_FORMATTED                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBADRFMT                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    A4 - CSS_ZIP_CODE                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBZIPCD                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    TA - CSS_ACCT_MISC_INFO                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBATMISC                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SQL Error Checking Copy books.                                 *        
      ******************************************************************        
      *                                                                         
      *01  WS-WARNING-DATA-ELEMENTS.                                            
       COPY CWS00303.                                                           
      *                                                                         
      *01  CSRERLOG-P.                                                          
       COPY CWSSP001.                                                           
      *                                                                         
      ******************************************************************        
      * Error Handling Copy Book.                                      *        
      ******************************************************************        
      *                                                                         
      *01  ABEND-FILE.                                                          
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Cusrcor For Getting Non-Reconciled Pledges                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE NON_REC_PLEDGES CURSOR FOR                      
                SELECT                                                  
                       LI.REIMBURSE_DT                                  
                      ,LI.CHECK_NO                                      
                      ,LI.ACCOUNT_NO                                    
                      ,LI.VOUCHER_AMT                                   
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           LI.VOUCHER_PAY_DT, 121), ' ', '-'), ':', '.') VOUCHER_PAY_DT        
                      ,LI.COMMENT                                       
                FROM                                                    
                       CSS_LIEAP LI WITH(READUNCOMMITTED)                       
                WHERE                                                   
                       LI.CODE_AGENCY_ID    = :LI-CODE-AGENCY-ID        
                  AND  LI.CHECK_NO          = ' '                       
                  AND  LI.REIMBURSE_DT IS NULL                          
                  AND  LI.VOUCHER_PAY_DT > CIS.CHAR2TIMESTAMP(
                                                      :WS-TIMESTAMP-ALL
              )            
                FOR READ ONLY                                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE NON_REC_PLEDGES CURSOR FOR                              
MFA-TR*         SELECT                                                          
MFA-TR*                LI.REIMBURSE_DT                                          
MFA-TR*               ,LI.CHECK_NO                                              
MFA-TR*               ,LI.ACCOUNT_NO                                            
MFA-TR*               ,LI.VOUCHER_AMT                                           
MFA-TR*               ,LI.VOUCHER_PAY_DT                                        
MFA-TR*               ,LI.COMMENT                                               
MFA-TR*         FROM                                                            
MFA-TR*                CSS_LIEAP LI                                             
MFA-TR*         WHERE                                                           
MFA-TR*                LI.CODE_AGENCY_ID    = :LI-CODE-AGENCY-ID                
MFA-TR*           AND  LI.CHECK_NO          = ' '                               
MFA-TR*           AND  LI.REIMBURSE_DT IS NULL                                  
MFA-TR*           AND  LI.VOUCHER_PAY_DT > :WS-TIMESTAMP-ALL                    
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Cursor For Getting Both (Reconciled/Non-Reconciled) PledgeS    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE ALL_PLEDGES CURSOR FOR                          
                SELECT                                                  
                       LI.REIMBURSE_DT                                  
                      ,LI.CHECK_NO                                      
                      ,LI.ACCOUNT_NO                                    
                      ,LI.VOUCHER_AMT                                   
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           LI.VOUCHER_PAY_DT, 121), ' ', '-'), ':', '.') VOUCHER_PAY_DT        
                      ,LI.COMMENT                                       
                FROM                                                    
                       CSS_LIEAP LI WITH(READUNCOMMITTED)                       
                WHERE                                                   
                       LI.CODE_AGENCY_ID    = :LI-CODE-AGENCY-ID        
                  AND  LI.VOUCHER_PAY_DT > CIS.CHAR2TIMESTAMP(
                                                      :WS-TIMESTAMP-ALL
              )            
                FOR READ ONLY                                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE ALL_PLEDGES CURSOR FOR                                  
MFA-TR*         SELECT                                                          
MFA-TR*                LI.REIMBURSE_DT                                          
MFA-TR*               ,LI.CHECK_NO                                              
MFA-TR*               ,LI.ACCOUNT_NO                                            
MFA-TR*               ,LI.VOUCHER_AMT                                           
MFA-TR*               ,LI.VOUCHER_PAY_DT                                        
MFA-TR*               ,LI.COMMENT                                               
MFA-TR*         FROM                                                            
MFA-TR*                CSS_LIEAP LI                                             
MFA-TR*         WHERE                                                           
MFA-TR*                LI.CODE_AGENCY_ID    = :LI-CODE-AGENCY-ID                
MFA-TR*           AND  LI.VOUCHER_PAY_DT > :WS-TIMESTAMP-ALL                    
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01 I-APPLICATION-ID           PIC X(07).                         
       01 I-CODE-AGENCY-ID           PIC X(05).                         
       01 I-BOTH-OR-NONRECONCILE     PIC X(01).                         
      *                                                                         
       PROCEDURE DIVISION USING I-APPLICATION-ID                        
                               ,I-CODE-AGENCY-ID                        
                               ,I-BOTH-OR-NONRECONCILE.                 
                                                                        
      *                                                                         
      ******************************************************************        
      * Controls the Main Processing of the Program.                   *        
      ******************************************************************        
      *                                                                         
       0000-MAIN-LINE.                                                  
      *                                                                         
           PERFORM  0100-INITIALIZATION           THRU  0100-EXIT.      
           PERFORM  1000-PROCESS-INPUT            THRU  1000-EXIT.      
           PERFORM  2000-PROCESS-OUTPUT           THRU  2000-EXIT.      
           PERFORM  9999-END-PROGRAM              THRU  9999-EXIT.      
           
MSQ016        GOBACK.                                                    
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Initialize Return Fields, Declare GTT and Result Set Cursor.   *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           MOVE 'N'             TO WS-NO-MORE-DATA.                     
           MOVE  ZERO           TO AT-ADDRESS-ID.                       
           MOVE  ZERO           TO HT-ADDRESS-ID.                       
      *                                                                         
           INITIALIZE  GTT-RETURN-FIELDS.                               
      *                                                                         
           PERFORM 0100A-DECLARE-GTT   THRU  0100A-EXIT.                
      *                                                                         
           EXEC SQL                                                     
A0501E         DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR
                SELECT                                                  
                       RETURN_CODE                                      
                      ,REIMBURSE_DT                                     
                      ,LTRIM(RTRIM(CHECK_NO))          AS CHECK_NO             
                      ,ACCOUNT_NO                                       
                      ,LTRIM(RTRIM(NAME))              AS NAME                 
                      ,VOUCHER_AMT                                      
                      ,VOUCHER_PAY_DT                                   
                      ,LTRIM(RTRIM(COMMENT))           AS COMMENT              
                      ,LTRIM(RTRIM(PLEDGE_STATUS))     AS PLEDGE_STATUS        
                      ,TOT_PST_DUE_NR_CMT                               
                      ,TOT_CURRENT_NR_CMT                               
                FROM #CSR03783_R1                                
                ORDER BY VOUCHER_PAY_DT DESC                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR        
MFA-TR*         SELECT                                                          
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,REIMBURSE_DT                                             
MFA-TR*               ,STRIP(CHECK_NO)          AS CHECK_NO                     
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,STRIP(NAME)              AS NAME                         
MFA-TR*               ,VOUCHER_AMT                                              
MFA-TR*               ,VOUCHER_PAY_DT                                           
MFA-TR*               ,STRIP(COMMENT)           AS COMMENT                      
MFA-TR*               ,STRIP(PLEDGE_STATUS)     AS PLEDGE_STATUS                
MFA-TR*               ,TOT_PST_DUE_NR_CMT                                       
MFA-TR*               ,TOT_CURRENT_NR_CMT                                       
MFA-TR*         FROM SESSION.CSR03783_R1                                        
MFA-TR*         ORDER BY VOUCHER_PAY_DT DESC                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           MOVE 'NBR-MONTHS-CSR03783'               TO   C8-DELINQ-CD.  
           PERFORM 7100-GET-DELIQUENCY-VALUES       THRU 7100-EXIT.     
           MOVE 'NBR-CUR-MTS-CSR03783'              TO   C8-DELINQ-CD.  
           PERFORM 7100-GET-DELIQUENCY-VALUES       THRU 7100-EXIT.     
      *                                                                         
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -
                                                         :WS-CUR-MONTHS
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP-CUR          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET  :WS-TIMESTAMP-CUR = (CURRENT TIMESTAMP -                    
MFA-TR*                                 :WS-CUR-MONTHS MONTHS)                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -
                                                             :WS-MONTHS
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP-ALL              
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET  :WS-TIMESTAMP-ALL = (CURRENT TIMESTAMP -                    
MFA-TR*                                 :WS-MONTHS MONTHS)                      
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Declares GTT For Holding Result Set.                           *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR03783_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR03783_R1
               (                                                      
                   RETURN_CODE           INT                        
                  ,REIMBURSE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                  ,CHECK_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,ACCOUNT_NO            DECIMAL(13,0)                      
                  ,NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2               
                  ,VOUCHER_AMT           DECIMAL(9,2)                       
                  ,VOUCHER_PAY_DT CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                  ,COMMENT CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,PLEDGE_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                  ,TOT_PST_DUE_NR_CMT    DECIMAL(9,2)                       
                  ,TOT_CURRENT_NR_CMT    DECIMAL(9,2)                       
                 )
            END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE              TO WS-SQLSTATE.                   
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR03783_R1'         TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************02790000
      * Receive and Validate Input Parameters.                         *02800000
      ******************************************************************02840000
      *                                                                 02850000
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF I-CODE-AGENCY-ID        > SPACES AND                      
              I-BOTH-OR-NONRECONCILE  = 'B' OR 'N'                      
              MOVE    I-CODE-AGENCY-ID       TO WS-I-CODE-AGENCY-ID     
                                                LI-CODE-AGENCY-ID       
              MOVE    I-BOTH-OR-NONRECONCILE TO                         
                                     WS-I-BOTH-OR-NONRECONCILE          
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'PROCESS INPUT'           TO ABEND-FUNCTION          
              MOVE 'CODE-AGENCY-ID'          TO TABLE-ELEMENT-1         
              MOVE LI-CODE-AGENCY-ID         TO HOSTVAR-ELEMENT-1       
              MOVE +100                      TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Gets the Delinquency Values and Evaluates Time Lines. Also     *        
      * Fetches the Pledges Based On Input Parameters.                 *        
      ******************************************************************03560000
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           EVALUATE WS-I-BOTH-OR-NONRECONCILE                           
           WHEN 'B'                                                     
               PERFORM 2400-INSERT-DELIQ-VALUE      THRU 2400-EXIT      
               PERFORM 7140-OPEN-ALL-PLEDGES        THRU 7140-EXIT      
               PERFORM 2100-PROCESS-ALL-PLEDGES     THRU 2100-EXIT      
               UNTIL   NO-MORE-DATA                                     
               PERFORM 7160-CLOSE-ALL-PLEDGES       THRU 7160-EXIT      
           WHEN 'N'                                                     
               PERFORM 7110-OPEN-NON-REC-PLEDGES    THRU 7110-EXIT      
               PERFORM 2200-PROCESS-NON-REC-PLEDGES THRU 2200-EXIT      
               UNTIL NO-MORE-DATA                                       
               IF CTR-ROWS > 0  AND S-RETURN-CODE NOT = 100             
                  PERFORM 2300-INSERT-TOTALS        THRU 2300-EXIT      
               END-IF                                                   
               PERFORM 7130-CLOSE-NON-REC-PLEDGES   THRU 7130-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      ******************************************************************03490000
      * Fetch the Both Reconciled/Non-Reconciled Pledges and Formats   *03500000
      * the Result Set.                                                *03500000
      ******************************************************************03560000
      *                                                                         
       2100-PROCESS-ALL-PLEDGES.                                        
      *                                                                         
           PERFORM 7150-FETCH-ALL-PLEDGES      THRU 7150-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE LI-ACCOUNT-NO               TO AT-ACCOUNT-NO         
              MOVE WS-YES                      TO WS-NAME-ONLY-SW       
              IF LI-VOUCHER-PAY-DT >= WS-TIMESTAMP-CUR                  
                 MOVE 'C' TO RS-PLEDGE-STATUS                           
              ELSE                                                      
                 MOVE 'P' TO RS-PLEDGE-STATUS                           
              END-IF                                                    
              PERFORM 2500-NAME-FORMATING      THRU 2500-EXIT           
              MOVE WS-FULL-NAME-1              TO RS-NAME               
              INITIALIZE WS-FULL-NAME-1 WS-F-NAME WS-M-NAME WS-L-NAME   
              PERFORM 2900-MOVE-RS-TO-S        THRU 2900-EXIT           
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           ELSE                                                         
              IF CTR-ROWS = 1                                           
                 PERFORM 2900-MOVE-RS-TO-S     THRU 2900-EXIT           
                 PERFORM 8100-SEND-RESULT      THRU 8100-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Fetch the Only Reconciled Pledges and Formats the Result Set.  *03500000
      ******************************************************************03560000
      *                                                                         
       2200-PROCESS-NON-REC-PLEDGES.                                    
      *                                                                         
           PERFORM 7120-FETCH-NON-REC-PLEDGES THRU 7120-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE LI-ACCOUNT-NO              TO AT-ACCOUNT-NO          
              MOVE WS-YES                     TO WS-NAME-ONLY-SW        
              PERFORM 2500-NAME-FORMATING     THRU 2500-EXIT            
              MOVE WS-FULL-NAME-1             TO RS-NAME                
              INITIALIZE WS-FULL-NAME-1 WS-F-NAME WS-M-NAME WS-L-NAME   
              IF LI-VOUCHER-PAY-DT >= WS-TIMESTAMP-CUR                  
                 MOVE 'C' TO RS-PLEDGE-STATUS                           
              ELSE                                                      
                 MOVE 'P' TO RS-PLEDGE-STATUS                           
              END-IF                                                    
              IF RS-PLEDGE-STATUS = 'C'                                 
                 ADD  RS-VOUCHER-AMT          TO WS-CURRENT-PLDG-TOTAL  
              ELSE                                                      
                 ADD  RS-VOUCHER-AMT          TO WS-PAST-PLDG-TOTAL     
              END-IF                                                    
                 MOVE RS-PLEDGE-STATUS        TO WS-PREV-PLEDGE-STATUS  
                 PERFORM 2900-MOVE-RS-TO-S    THRU 2900-EXIT            
                 PERFORM 8100-SEND-RESULT     THRU 8100-EXIT            
           ELSE                                                         
              IF CTR-ROWS = ZERO                                        
                 PERFORM 2900-MOVE-RS-TO-S     THRU 2900-EXIT           
                 PERFORM 8100-SEND-RESULT      THRU 8100-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Creates and Inserts the Totals Record into Result Set.         *03500000
      ******************************************************************03560000
      *                                                                         
       2300-INSERT-TOTALS.                                              
      *                                                                         
           MOVE 0                       TO S-RETURN-CODE                
                                           S-ACCOUNT-NO                 
                                           S-VOUCHER-AMT.               
           MOVE SPACES                  TO S-REIMBURSE-DT               
                                           S-CHECK-NO                   
                                           S-NAME                       
                                           S-VOUCHER-PAY-DT             
                                           S-COMMENT.                   
           MOVE 'T'                     TO S-PLEDGE-STATUS.             
           MOVE WS-CURRENT-PLDG-TOTAL   TO S-CURRENT-PLDG-TOTAL.        
           MOVE WS-PAST-PLDG-TOTAL      TO S-PAST-PLDG-TOTAL.           
           PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                 
      *                                                                         
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Creates and Inserts the Months Record into Result Set.         *03500000
      ******************************************************************03560000
      *                                                                         
       2400-INSERT-DELIQ-VALUE.                                         
      *                                                                         
           MOVE 0                       TO S-RETURN-CODE                
                                           S-ACCOUNT-NO                 
                                           S-VOUCHER-AMT.               
           MOVE SPACES                  TO S-REIMBURSE-DT               
                                           S-CHECK-NO                   
                                           S-NAME                       
                                           S-VOUCHER-PAY-DT             
                                           S-COMMENT.                   
           MOVE 'A'                     TO S-PLEDGE-STATUS.             
           MOVE 0                       TO S-CURRENT-PLDG-TOTAL.        
           MOVE WS-MONTHS               TO S-PAST-PLDG-TOTAL.           
           PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                 
      *                                                                         
       2400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Formats the Name as follows (Last, First Middle)               *03500000
      ******************************************************************03560000
      *                                                                         
       2500-NAME-FORMATING.                                             
      *                                                                         
           PERFORM  7200-GET-CUST-NAME             THRU 7200-EXIT       
              IF DQ-FIRST-NAME  = SPACES AND                            
                 DQ-MIDDLE-NAME = SPACES AND                            
                 DQ-LAST-NAME   = SPACES                                
                 MOVE DQ-FULL-NAME                    TO WS-FULL-NAME-1 
                 GO TO 2500-EXIT                                        
              ELSE                                                      
                 MOVE DQ-FIRST-NAME                   TO WS-F-NAME      
                 MOVE DQ-MIDDLE-NAME                  TO WS-M-NAME      
                 MOVE DQ-LAST-NAME                    TO WS-L-NAME      
              END-IF.                                                   
           MOVE SPACES                                TO WS-PREV-CHAR   
                                                        WS-FORMAT.      
           SET WS-IDX-N, WS-IDX-F, WS-IDX-M, WS-IDX-L TO 1.             
      *                                                                         
           PERFORM UNTIL (WS-IDX-L > 20 OR FORMAT-DONE)                 
              IF (WS-LAST-CHAR(WS-IDX-L) = SPACE OR LOW-VALUES          
                                              OR HIGH-VALUES)           
                AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES) 
                IF WS-IDX-N > 1                                         
                   SET WS-IDX-N DOWN BY 1                               
                   MOVE ','                   TO WS-FULL-CHAR(WS-IDX-N) 
                   SET WS-IDX-N UP BY 1                                 
                END-IF                                                  
                MOVE 'Y'                      TO WS-FORMAT              
              ELSE                                                      
                MOVE WS-LAST-CHAR(WS-IDX-L)   TO WS-FULL-CHAR(WS-IDX-N) 
                                                 WS-PREV-CHAR           
                SET WS-IDX-L, WS-IDX-N UP BY 1                          
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           MOVE SPACES                        TO WS-PREV-CHAR.          
      *                                                                         
           PERFORM UNTIL WS-IDX-F > 15                                  
              IF (WS-FIRST-CHAR(WS-IDX-F) = SPACE OR LOW-VALUES OR      
                                                     HIGH-VALUES)       
                 AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES)
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-FIRST-CHAR(WS-IDX-F) TO WS-FULL-CHAR(WS-IDX-N) 
                                                 WS-PREV-CHAR           
                 SET WS-IDX-F, WS-IDX-N UP BY 1                         
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           MOVE SPACES                        TO WS-PREV-CHAR.          
      *                                                                         
           PERFORM UNTIL WS-IDX-M > 15                                  
              IF (WS-MIDDLE-CHAR(WS-IDX-M) = SPACE OR LOW-VALUES OR     
                                                   HIGH-VALUES)         
                AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES) 
                NEXT SENTENCE                                           
              ELSE                                                      
                MOVE WS-MIDDLE-CHAR(WS-IDX-M) TO WS-FULL-CHAR(WS-IDX-N) 
                                                 WS-PREV-CHAR           
                SET WS-IDX-M, WS-IDX-N UP BY 1                          
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Prepares the Result Set Row.                                   *03500000
      ******************************************************************03560000
      *                                                                         
       2900-MOVE-RS-TO-S.                                               
      *                                                                         
           MOVE  RS-RETURN-CODE            TO    S-RETURN-CODE.         
           MOVE  RS-REIMBURSE-DT           TO    S-REIMBURSE-DT.        
           MOVE  RS-CHECK-NO               TO    S-CHECK-NO.            
           MOVE  RS-ACCOUNT-NO             TO    S-ACCOUNT-NO.          
           MOVE  RS-NAME                   TO    S-NAME.                
           MOVE  RS-VOUCHER-AMT            TO    S-VOUCHER-AMT.         
           MOVE  RS-VOUCHER-PAY-DT         TO    S-VOUCHER-PAY-DT.      
           MOVE  RS-COMMENT                TO    S-COMMENT.             
           MOVE  RS-PLEDGE-STATUS          TO    S-PLEDGE-STATUS.       
           MOVE  0                         TO    S-CURRENT-PLDG-TOTAL.  
           MOVE  0                         TO    S-PAST-PLDG-TOTAL.     
      *                                                                         
       2900-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Reads the CSS_DELINQUENCY Table                                *03500000
      ******************************************************************03560000
      *                                                                         
       7100-GET-DELIQUENCY-VALUES.                                      
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                        C8.DELINQ_VALUE                                 
                  INTO                                                  
                       :C8-DELINQ-VALUE                                 
                  FROM                                                  
                        CSS_DELINQUENCY  C8 WITH(READUNCOMMITTED)               
                WHERE                                                   
                        C8.DELINQ_CD    = :C8-DELINQ-CD                 
                  AND   C8.COMPANY_NO   = '01'                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 C8.DELINQ_VALUE                                         
MFA-TR*           INTO                                                          
MFA-TR*                :C8-DELINQ-VALUE                                         
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_DELINQUENCY  C8                                     
MFA-TR*         WHERE                                                           
MFA-TR*                 C8.DELINQ_CD    = :C8-DELINQ-CD                         
MFA-TR*           AND   C8.COMPANY_NO   = '01'                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO  WS-ACTIVE-RETURN-CODE       
                                            RS-RETURN-CODE.             
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    EVALUATE C8-DELINQ-CD                               
                        WHEN 'NBR-CUR-MTS-CSR03783'                     
                             MOVE C8-DELINQ-VALUE  TO WS-CUR-MONTHS     
                        WHEN 'NBR-MONTHS-CSR03783'                      
                             MOVE C8-DELINQ-VALUE  TO WS-MONTHS         
                    END-EVALUATE                                        
               WHEN NOT-FOUND                                           
                    EVALUATE C8-DELINQ-CD                               
                        WHEN 'NBR-CUR-MTS-CSR03783'                     
                             MOVE 1                TO WS-CUR-MONTHS     
                        WHEN 'NBR-MONTHS-CSR03783'                      
                             MOVE 12               TO WS-MONTHS         
                    END-EVALUATE                                        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7100'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SELECT'              TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_DELINQUENCY'     TO TABLE-1               
                    MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1       
                    MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Opens the NON_REC_PLEDGES Cursor.                              *        
      ******************************************************************03560000
      *                                                                         
       7110-OPEN-NON-REC-PLEDGES.                                       
      *                                                                         
           EXEC SQL                                                     
                OPEN NON_REC_PLEDGES                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN CURSOR'             TO ABEND-FUNCTION          
              MOVE 'CSS_LIEAP'               TO TABLE-1                 
              MOVE 'CODE_AGENCY_ID'          TO TABLE-ELEMENT-1         
              MOVE 'VOUCHER_PAY_DT'          TO TABLE-ELEMENT-2         
              MOVE  LI-CODE-AGENCY-ID        TO HOSTVAR-ELEMENT-1       
              MOVE  WS-TIMESTAMP-ALL         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Fetches the NON_REC_PLEDGES Cursor.                            *        
      ******************************************************************03560000
      *                                                                         
       7120-FETCH-NON-REC-PLEDGES.                                      
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                       NON_REC_PLEDGES                                  
                 INTO                                                   
                      :LI-REIMBURSE-DT :IND-REIMBURSE-DT                 
                     ,:LI-CHECK-NO                                      
                     ,:LI-ACCOUNT-NO                                    
                     ,:LI-VOUCHER-AMT                                   
                     ,:LI-VOUCHER-PAY-DT                                
                     ,:LI-COMMENT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         RS-RETURN-CODE.                
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
ACT015             IF IND-REIMBURSE-DT = -1                             
ACT015                 MOVE SPACES TO LI-REIMBURSE-DT                   
ACT015             END-IF                                               
                   MOVE LI-REIMBURSE-DT        TO RS-REIMBURSE-DT       
                   MOVE LI-CHECK-NO            TO RS-CHECK-NO           
                   MOVE LI-ACCOUNT-NO          TO RS-ACCOUNT-NO         
                   MOVE LI-VOUCHER-AMT         TO RS-VOUCHER-AMT        
                   MOVE LI-VOUCHER-PAY-DT      TO RS-VOUCHER-PAY-DT     
                   MOVE LI-COMMENT-TEXT        TO RS-COMMENT            
                   MOVE WS-PLEDGE-STATUS       TO RS-PLEDGE-STATUS      
                   INITIALIZE LI-COMMENT                                
              WHEN NOT-FOUND                                            
                   MOVE 'Y'                    TO WS-NO-MORE-DATA       
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7120'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'FETCH'                TO ABEND-FUNCTION        
                   MOVE 'CSS_LIEAP'            TO TABLE-1               
                   MOVE 'CODE_AGENCY_ID'       TO TABLE-ELEMENT-1       
                   MOVE 'VOUCHER_PAY_DT'       TO TABLE-ELEMENT-2       
                   MOVE  LI-CODE-AGENCY-ID     TO HOSTVAR-ELEMENT-1     
                   MOVE  WS-TIMESTAMP-ALL      TO HOSTVAR-ELEMENT-2     
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Closes the NON_REC_PLEDGES Cursor.                             *        
      ******************************************************************03560000
      *                                                                         
       7130-CLOSE-NON-REC-PLEDGES.                                      
      *                                                                         
           EXEC SQL                                                     
                CLOSE NON_REC_PLEDGES                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_LIEAP'               TO TABLE-1                 
              MOVE 'CODE_AGENCY_ID'          TO TABLE-ELEMENT-1         
              MOVE 'VOUCHER_PAY_DT'          TO TABLE-ELEMENT-2         
              MOVE  LI-CODE-AGENCY-ID        TO HOSTVAR-ELEMENT-1       
              MOVE  WS-TIMESTAMP-ALL         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Opens the ALL-PLEDGES Cursor.                                  *03500000
      ******************************************************************03560000
      *                                                                         
       7140-OPEN-ALL-PLEDGES.                                           
      *                                                                         
           EXEC SQL                                                     
                OPEN ALL_PLEDGES                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7140'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_LIEAP'               TO TABLE-1                 
              MOVE 'CODE_AGENCY_ID'          TO TABLE-ELEMENT-1         
              MOVE 'VOUCHER_PAY_DT'          TO TABLE-ELEMENT-2         
              MOVE  LI-CODE-AGENCY-ID        TO HOSTVAR-ELEMENT-1       
              MOVE  WS-TIMESTAMP-ALL         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Fetches the ALL-PLEDGES Cursor.                               * 03500000
      ******************************************************************03560000
      *                                                                         
       7150-FETCH-ALL-PLEDGES.                                          
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                      ALL_PLEDGES                                       
                INTO                                                    
                      :LI-REIMBURSE-DT :IND-REIMBURSE-DT                 
                     ,:LI-CHECK-NO                                      
                     ,:LI-ACCOUNT-NO                                    
                     ,:LI-VOUCHER-AMT                                   
                     ,:LI-VOUCHER-PAY-DT                                
                     ,:LI-COMMENT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
ACT015             IF IND-REIMBURSE-DT = -1                             
ACT015                 MOVE SPACES TO LI-REIMBURSE-dt                   
ACT015             END-IF                                               
                   MOVE LI-REIMBURSE-DT        TO RS-REIMBURSE-DT       
                   MOVE LI-CHECK-NO            TO RS-CHECK-NO           
                   MOVE LI-ACCOUNT-NO          TO RS-ACCOUNT-NO         
                   MOVE LI-VOUCHER-AMT         TO RS-VOUCHER-AMT        
                   MOVE LI-VOUCHER-PAY-DT      TO RS-VOUCHER-PAY-DT     
                   MOVE LI-COMMENT-TEXT        TO RS-COMMENT            
                   MOVE WS-PLEDGE-STATUS       TO RS-PLEDGE-STATUS      
                   INITIALIZE LI-COMMENT                                
              WHEN NOT-FOUND                                            
                   MOVE 'Y'                    TO WS-NO-MORE-DATA       
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7150'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'FETCH'                TO ABEND-FUNCTION        
                   MOVE 'CSS_LIEAP'            TO TABLE-1               
                   MOVE 'CODE_AGENCY_ID'       TO TABLE-ELEMENT-1       
                   MOVE 'REIMBURSE_DT'         TO TABLE-ELEMENT-2       
                   MOVE LI-CODE-AGENCY-ID      TO HOSTVAR-ELEMENT-1     
                   MOVE WS-TIMESTAMP-ALL       TO HOSTVAR-ELEMENT-2     
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Closes the ALL-PLEDGES Cursor.                                 *03500000
      ******************************************************************03560000
      *                                                                         
       7160-CLOSE-ALL-PLEDGES.                                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE ALL_PLEDGES                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7160'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_LIEAP'               TO TABLE-1                 
              MOVE 'CODE_AGENCY_ID'          TO TABLE-ELEMENT-1         
              MOVE 'REIMBURSE_DT'            TO TABLE-ELEMENT-2         
              MOVE LI-CODE-AGENCY-ID         TO HOSTVAR-ELEMENT-1       
              MOVE WS-TIMESTAMP-ALL          TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************03490000
      * Selects Customer's Name.                                       *        
      ******************************************************************03560000
      *                                                                         
A0501E 7200-GET-CUST-NAME.                                              
A0501E*                                                                         
A0501E     EXEC SQL                                                     
A0501E          SELECT                                                  
A0501E                  DQ.FIRST_NAME                                   
A0501E                 ,DQ.MIDDLE_NAME                                  
A0501E                 ,DQ.LAST_NAME                                    
A0501E            INTO                                                  
A0501E                  :DQ-FIRST-NAME                                  
A0501E                 ,:DQ-MIDDLE-NAME                                 
A0501E                 ,:DQ-LAST-NAME                                   
A0501E            FROM                                                  
A0501E                  CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                   
A0501E                 ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                   
A0501E                 ,CSS_NAME     DQ WITH(READUNCOMMITTED)                   
A0501E           WHERE                                                  
A0501E                  AT.ACCOUNT_NO           = :AT-ACCOUNT-NO        
A0501E             AND  AT.CUSTOMER_NO          = CU.CUSTOMER_NO        
A0501E             AND  CU.NAME_ID              = DQ.NAME_ID            
A0501E                                                          
A0501E     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 DQ.FIRST_NAME                                           
MFA-TR*                ,DQ.MIDDLE_NAME                                          
MFA-TR*                ,DQ.LAST_NAME                                            
MFA-TR*           INTO                                                          
MFA-TR*                 :DQ-FIRST-NAME                                          
MFA-TR*                ,:DQ-MIDDLE-NAME                                         
MFA-TR*                ,:DQ-LAST-NAME                                           
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_ACCOUNT  AT                                         
MFA-TR*                ,CSS_CUSTOMER CU                                         
MFA-TR*                ,CSS_NAME     DQ                                         
MFA-TR*          WHERE                                                          
MFA-TR*                 AT.ACCOUNT_NO           = :AT-ACCOUNT-NO                
MFA-TR*            AND  AT.CUSTOMER_NO          = CU.CUSTOMER_NO                
MFA-TR*            AND  CU.NAME_ID              = DQ.NAME_ID                    
MFA-TR*           WITH  UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              OR -811                                                   
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 7300-GET-CUST-FULL-NAME   THRU 7300-EXIT       
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = -811                           
                 PERFORM 7400-GET-CUST-UNIQ-NAME   THRU 7400-EXIT       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_NAME'                TO TABLE-1                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************03490000
      * Selects Customer's Name.                                       *        
      ******************************************************************03560000
      *                                                                         
       7300-GET-CUST-FULL-NAME.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) DQ.FULL_NAME                                    
                  INTO                                                  
                        :DQ-FULL-NAME                                   
                  FROM                                                  
                        CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)            
                       ,CSS_NAME            DQ WITH(READUNCOMMITTED)            
                 WHERE                                                  
                        HT.ACCOUNT_NO           = :HT-ACCOUNT-NO        
                   AND  DQ.NAME_TYPE            = 'CN'                  
                   AND  HT.NAME_ID              = DQ.NAME_ID            
                                                    
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 DQ.FULL_NAME                                            
MFA-TR*           INTO                                                          
MFA-TR*                 :DQ-FULL-NAME                                           
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_NAME_ACCT_XREF  HT                                  
MFA-TR*                ,CSS_NAME            DQ                                  
MFA-TR*          WHERE                                                          
MFA-TR*                 HT.ACCOUNT_NO           = :HT-ACCOUNT-NO                
MFA-TR*            AND  DQ.NAME_TYPE            = 'CN'                          
MFA-TR*            AND  HT.NAME_ID              = DQ.NAME_ID                    
MFA-TR*            FETCH FIRST ROW ONLY                                         
MFA-TR*           WITH  UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'NAME UNAVAILABLE'     TO DQ-FULL-NAME            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_NAME'                TO TABLE-1                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************03490000
      * Selects Customer's Unique Name.                                *        
      ******************************************************************03560000
      *                                                                         
       7400-GET-CUST-UNIQ-NAME.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME                                    
                  INTO                                                  
                        :DQ-FIRST-NAME                                  
                       ,:DQ-MIDDLE-NAME                                 
                       ,:DQ-LAST-NAME                                   
                  FROM                                                  
                        CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)            
                       ,CSS_NAME            DQ WITH(READUNCOMMITTED)            
                 WHERE                                                  
                        HT.ACCOUNT_NO           = :HT-ACCOUNT-NO        
                   AND  DQ.NAME_TYPE            = 'CN'                  
                   AND  DQ.NAME_FORMAT          = 'I'                   
                   AND  HT.CUSTOMER_ROLE_CD     = ' '                   
                   AND  HT.NAME_ID              = DQ.NAME_ID            
                                                    
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 DQ.FIRST_NAME                                           
MFA-TR*                ,DQ.MIDDLE_NAME                                          
MFA-TR*                ,DQ.LAST_NAME                                            
MFA-TR*           INTO                                                          
MFA-TR*                 :DQ-FIRST-NAME                                          
MFA-TR*                ,:DQ-MIDDLE-NAME                                         
MFA-TR*                ,:DQ-LAST-NAME                                           
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_NAME_ACCT_XREF  HT                                  
MFA-TR*                ,CSS_NAME            DQ                                  
MFA-TR*          WHERE                                                          
MFA-TR*                 HT.ACCOUNT_NO           = :HT-ACCOUNT-NO                
MFA-TR*            AND  DQ.NAME_TYPE            = 'CN'                          
MFA-TR*            AND  DQ.NAME_FORMAT          = 'I'                           
MFA-TR*            AND  HT.CUSTOMER_ROLE_CD     = ' '                           
MFA-TR*            AND  HT.NAME_ID              = DQ.NAME_ID                    
MFA-TR*            FETCH FIRST ROW ONLY                                         
MFA-TR*           WITH  UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_NAME'                TO TABLE-1                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************03490000
      * Deletes all the Rows from GTT.                                 *        
      ******************************************************************03560000
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM #CSR03783_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR03783_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '8000A'               TO ACTIVE-PARAGRAPH           
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSR03783_R1'         TO TABLE-1                    
               MOVE SPACES                TO TABLE-ELEMENT-1            
               MOVE SPACES                TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * Inserts the Result Set Row Into GTT.                           *03500000
      ******************************************************************03560000
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR03783_R1                         
                (                                                       
                  RETURN_CODE                                           
                 ,REIMBURSE_DT                                          
                 ,CHECK_NO                                              
                 ,ACCOUNT_NO                                            
                 ,NAME                                                  
                 ,VOUCHER_AMT                                           
                 ,VOUCHER_PAY_DT                                        
                 ,COMMENT                                               
                 ,PLEDGE_STATUS                                         
                 ,TOT_PST_DUE_NR_CMT                                    
                 ,TOT_CURRENT_NR_CMT                                    
                )                                                       
                VALUES                                                  
                (                                                       
                 :S-RETURN-CODE                                         
                ,:S-REIMBURSE-DT                                        
                ,:S-CHECK-NO                                            
                ,:S-ACCOUNT-NO                                          
                ,:S-NAME                                                
                ,:S-VOUCHER-AMT                                         
                ,:S-VOUCHER-PAY-DT                                      
                ,:S-COMMENT                                             
                ,:S-PLEDGE-STATUS                                       
                ,:S-PAST-PLDG-TOTAL                                     
                ,:S-CURRENT-PLDG-TOTAL                                  
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR03783_R1                                 
MFA-TR*         (                                                               
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,REIMBURSE_DT                                                  
MFA-TR*          ,CHECK_NO                                                      
MFA-TR*          ,ACCOUNT_NO                                                    
MFA-TR*          ,NAME                                                          
MFA-TR*          ,VOUCHER_AMT                                                   
MFA-TR*          ,VOUCHER_PAY_DT                                                
MFA-TR*          ,COMMENT                                                       
MFA-TR*          ,PLEDGE_STATUS                                                 
MFA-TR*          ,TOT_PST_DUE_NR_CMT                                            
MFA-TR*          ,TOT_CURRENT_NR_CMT                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*          :S-RETURN-CODE                                                 
MFA-TR*         ,:S-REIMBURSE-DT                                                
MFA-TR*         ,:S-CHECK-NO                                                    
MFA-TR*         ,:S-ACCOUNT-NO                                                  
MFA-TR*         ,:S-NAME                                                        
MFA-TR*         ,:S-VOUCHER-AMT                                                 
MFA-TR*         ,:S-VOUCHER-PAY-DT                                              
MFA-TR*         ,:S-COMMENT                                                     
MFA-TR*         ,:S-PLEDGE-STATUS                                               
MFA-TR*         ,:S-PAST-PLDG-TOTAL                                             
MFA-TR*         ,:S-CURRENT-PLDG-TOTAL                                          
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR03783_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                  SQL Error Processing Copy Book                *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                       Program Copy Books                       *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *6010-REDUCE-EMBEDDED-SPACES / 6011-COMPRESSION-ROUTINE          *        
      ******************************************************************        
      *                                                                 08730500
           EXEC SQL                                                             
                INCLUDE CPD00004                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *9700-PROCESS-ABEND                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023C                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00320                                                
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
