                                                                        
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR03781.                                          
       AUTHOR.       Covansys.                                          
       DATE-WRITTEN. July 2006.                                         
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  This Module Returns the Utility Credit Details of an Account  *        
      *    - Coded for Customer Assistance Agency(Web)  Project.       *        
      *    - Execustes via AccountGetVoucherCreditInfo CIS Web Service *        
      *    - Can be reused/cutomized for other projects if needed.     *        
      *    - For SEB, If Reconnect/Generated DNP exists retuns 500     *        
      *      means this process will handles only Forecasted DNP.      *        
      ******************************************************************        
      *                                                                *        
      *                     Program Modification Log                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  07/26/2006  VP94820   Initial Implementation for Web-CAA.     *        
      *                                                                *        
P00180*  07/13/2009  RC41079   ADD CODE TO ALLOW PLEDGES TO BE MADE ON *        
P00180*                        FINAL BILL AND WRITE OFF ACCOUNTS.      *        
      *                                                                *        
P00726** 08/01/2014  WR19680   ADD CHANGES TO LOOK FOR STAS IN THE     *        
P00726**                       NEW TABLE STRUCTURE                     *        
      *                                                                *        
ACT355** 11/23/2015  AD7F921   REMOVAL OF TABLES STA_SUMMARY           *        
ACT355*                        AND STA_DETAIL.                         *        
      *----------------------------------------------------------------*00470000
      ******************************************************************        
      *                                                                *        
      *                ---- Basic Sequence Structure ----              *        
      *                                                                *        
      *         0000 - 0999     Main Control Path and Initialization   *        
      *         1000 - 1999     Input Processing Control Path          *        
      *         2000 - 2999     Output Processing Control Path         *        
      *         5000 - 5999     Common Modules                         *        
      *         7000 - 7999     Database Access / Input Modules        *        
      *         8000 - 8999     Output Modules                         *        
      *         9000 - 9799     Termination Modules                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03781'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                        PIC X(40)  VALUE              
           'WORKING STORAGE FOR CSR03781 STARTS HERE'.                  
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE            PIC S9(9) COMP VALUE ZERO.       
           05 S-BAL-IND                PIC X(01) VALUE  SPACES.         
           05 S-REC-IND                PIC X(01) VALUE  SPACES.         
           05 S-NORM-IND               PIC X(01) VALUE  SPACES.         
           05 S-EXCEPT-IND             PIC X(01) VALUE  SPACES.         
           05 S-STA-IND                PIC X(01) VALUE  SPACES.         
           05 S-DPP-IND                PIC X(01) VALUE  SPACES.         
           05 S-DFA-IND                PIC X(01) VALUE  SPACES.         
           05 S-EPP-IND                PIC X(01) VALUE  SPACES.         
           05 S-MED-IND                PIC X(01) VALUE  SPACES.         
           05 S-RETCHK-IND             PIC X(01) VALUE  SPACES.         
           05 S-DEP-IND                PIC X(01) VALUE  SPACES.         
           05 S-PLEDGE-IND             PIC X(01) VALUE  SPACES.         
           05 S-BILLED-DIM-IND         PIC X(01) VALUE  SPACES.         
           05 S-REC-DIM-IND            PIC X(01) VALUE  SPACES.         
           05 S-NORM-DIM-IND           PIC X(01) VALUE  SPACES.         
           05 S-EXCEPT-DIM-IND         PIC X(01) VALUE  SPACES.         
           05 S-STA-DIM-IND            PIC X(01) VALUE  SPACES.         
           05 S-DPP-DIM-IND            PIC X(01) VALUE  SPACES.         
           05 S-DFA-DIM-IND            PIC X(01) VALUE  SPACES.         
           05 S-EPP-DIM-IND            PIC X(01) VALUE  SPACES.         
           05 S-MED-DIM-IND            PIC X(01) VALUE  SPACES.         
           05 S-RETCHK-DIM-IND         PIC X(01) VALUE  SPACES.         
           05 S-DEPOSIT-DIM-IND        PIC X(01) VALUE  SPACES.         
           05 S-PLEDGE-DIM-IND         PIC X(01) VALUE  SPACES.         
           05 S-BILLED-AMT             PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-UTIL-BILLED-AMT        PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-NONUTIL-BILLED-AMT     PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-REC-SERV-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-REC-CHRG               PIC S9(07)V99 COMP-3 VALUE +0.   
           05 S-REC-DNP-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-REC-DEP-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-NORM-MAIL-DT           PIC X(10) VALUE  SPACES.         
           05 S-NORM-DUE-DT            PIC X(10) VALUE  SPACES.         
           05 S-NORM-DUE-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-NORM-DNP-DT            PIC X(10) VALUE  SPACES.         
           05 S-NORM-DNP-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-EXCEPT-DUE-DT          PIC X(10) VALUE  SPACES.         
           05 S-EXCEPT-DUE-AMT         PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-EXCEPT-DNP-DT          PIC X(10) VALUE  SPACES.         
           05 S-EXCEPT-DNP-AMT         PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-STA-SETUP-DT           PIC X(10) VALUE  SPACES.         
           05 S-STA-DUE-DT             PIC X(10) VALUE  SPACES.         
           05 S-STA-DUE-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-STA-DNP-DT             PIC X(10) VALUE  SPACES.         
           05 S-STA-DNP-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-DPP-SETUP-DT           PIC X(26) VALUE  SPACES.         
           05 S-DPP-DUE-DT             PIC X(10) VALUE  SPACES.         
           05 S-DPP-DUE-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-DPP-DNP-DT             PIC X(10) VALUE  SPACES.         
           05 S-DPP-DNP-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-MED-EXPIRE-DT          PIC X(26) VALUE  SPACES.         
           05 S-MED-DUE-DT             PIC X(10) VALUE  SPACES.         
           05 S-MED-DUE-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-MED-DNP-DT             PIC X(10) VALUE  SPACES.         
           05 S-MED-DNP-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-RETCHK-AMT             PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-RETCHK-DUE-DT          PIC X(10) VALUE  SPACES.         
           05 S-RETCHK-DNP-AMT         PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-RETCHK-DNP-DT          PIC X(10) VALUE  SPACES.         
           05 S-DEPOSIT-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-DEPOSIT-DUE-DT         PIC X(10) VALUE  SPACES.         
           05 S-DEPOSIT-DNP-AMT        PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-DEPOSIT-DNP-DT         PIC X(10) VALUE  SPACES.         
           05 S-PLEDGE-AMT-1           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-PLEDGE-AMT-2           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-PLEDGE-AMT-3           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-PLEDGE-AMT-4           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-PLEDGE-AMT-5           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-PLEDGE-AMT-6           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 S-PLEDGE-DNP-STATE       PIC X(01) VALUE  SPACES.         
P00180     05 S-FB-IND                 PIC X(01) VALUE  SPACES.         
P00180     05 S-FINAL-BILL-AMT         PIC S9(09)V99 COMP-3 VALUE +0.   
P00180     05 S-FINAL-BILL-DT          PIC X(10) VALUE  SPACES.         
P00180     05 S-WO-IND                 PIC X(01) VALUE  SPACES.         
P00180     05 S-WRITE-OFF-AMT          PIC S9(09)V99 COMP-3 VALUE +0.   
P00180     05 S-WRITE-OFF-DT           PIC X(10) VALUE  SPACES.         
      *                                                                         
       01 TDS-RETURN-FIELDS.                                            
           05 RS-RETURN-CODE           PIC S9(9) COMP VALUE ZERO.       
           05 RS-BAL-IND               PIC X(01) VALUE  SPACES.         
           05 RS-REC-IND               PIC X(01) VALUE  SPACES.         
           05 RS-NORM-IND              PIC X(01) VALUE  SPACES.         
           05 RS-EXCEPT-IND            PIC X(01) VALUE  SPACES.         
           05 RS-STA-IND               PIC X(01) VALUE  SPACES.         
           05 RS-DPP-IND               PIC X(01) VALUE  SPACES.         
           05 RS-DFA-IND               PIC X(01) VALUE  SPACES.         
           05 RS-EPP-IND               PIC X(01) VALUE  SPACES.         
           05 RS-MED-IND               PIC X(01) VALUE  SPACES.         
           05 RS-RETCHK-IND            PIC X(01) VALUE  SPACES.         
           05 RS-DEP-IND               PIC X(01) VALUE  SPACES.         
           05 RS-PLEDGE-IND            PIC X(01) VALUE  SPACES.         
           05 RS-BILLED-DIM-IND        PIC X(01) VALUE  SPACES.         
           05 RS-REC-DIM-IND           PIC X(01) VALUE  SPACES.         
           05 RS-NORM-DIM-IND          PIC X(01) VALUE  SPACES.         
           05 RS-EXCEPT-DIM-IND        PIC X(01) VALUE  SPACES.         
           05 RS-STA-DIM-IND           PIC X(01) VALUE  SPACES.         
           05 RS-DPP-DIM-IND           PIC X(01) VALUE  SPACES.         
           05 RS-DFA-DIM-IND           PIC X(01) VALUE  SPACES.         
           05 RS-EPP-DIM-IND           PIC X(01) VALUE  SPACES.         
           05 RS-MED-DIM-IND           PIC X(01) VALUE  SPACES.         
           05 RS-RETCHK-DIM-IND        PIC X(01) VALUE  SPACES.         
           05 RS-DEPOSIT-DIM-IND       PIC X(01) VALUE  SPACES.         
           05 RS-PLEDGE-DIM-IND        PIC X(01) VALUE  SPACES.         
           05 RS-BILLED-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-UTIL-BILLED-AMT       PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-NONUTIL-BILLED-AMT    PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-REC-SERV-AMT          PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-REC-CHRG              PIC S9(07)V99 COMP-3 VALUE +0.   
           05 RS-REC-DNP-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-REC-DEP-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-NORM-MAIL-DT          PIC X(10) VALUE  SPACES.         
           05 RS-NORM-DUE-DT           PIC X(10) VALUE  SPACES.         
           05 RS-NORM-DUE-AMT          PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-NORM-DNP-DT           PIC X(10) VALUE  SPACES.         
           05 RS-NORM-DNP-AMT          PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-EXCEPT-DUE-DT         PIC X(10) VALUE  SPACES.         
           05 RS-EXCEPT-DUE-AMT        PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-EXCEPT-DNP-DT         PIC X(10) VALUE  SPACES.         
           05 RS-EXCEPT-DNP-AMT        PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-STA-SETUP-DT          PIC X(10) VALUE  SPACES.         
           05 RS-STA-DUE-DT            PIC X(10) VALUE  SPACES.         
           05 RS-STA-DUE-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-STA-DNP-DT            PIC X(10) VALUE  SPACES.         
           05 RS-STA-DNP-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-DPP-SETUP-DT          PIC X(26) VALUE  SPACES.         
           05 RS-DPP-DUE-DT            PIC X(10) VALUE  SPACES.         
           05 RS-DPP-DUE-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-DPP-DNP-DT            PIC X(10) VALUE  SPACES.         
           05 RS-DPP-DNP-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-MED-EXPIRE-DT         PIC X(26) VALUE  SPACES.         
           05 RS-MED-DUE-DT            PIC X(10) VALUE  SPACES.         
           05 RS-MED-DUE-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-MED-DNP-DT            PIC X(10) VALUE  SPACES.         
           05 RS-MED-DNP-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-RETCHK-AMT            PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-RETCHK-DUE-DT         PIC X(10) VALUE  SPACES.         
           05 RS-RETCHK-DNP-AMT        PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-RETCHK-DNP-DT         PIC X(10) VALUE  SPACES.         
           05 RS-DEPOSIT-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-DEPOSIT-DUE-DT        PIC X(10) VALUE  SPACES.         
           05 RS-DEPOSIT-DNP-AMT       PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-DEPOSIT-DNP-DT        PIC X(10) VALUE  SPACES.         
           05 RS-PLEDGE-AMT-1          PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-PLEDGE-AMT-2          PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-PLEDGE-AMT-3          PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-PLEDGE-AMT-4          PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-PLEDGE-AMT-5          PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-PLEDGE-AMT-6          PIC S9(09)V99 COMP-3 VALUE +0.   
           05 RS-PLEDGE-DNP-STATE      PIC X(01) VALUE  SPACES.         
P00180     05 RS-FB-IND                PIC X(01) VALUE  SPACES.         
P00180     05 RS-FINAL-BILL-AMT        PIC S9(09)V99 COMP-3 VALUE +0.   
P00180     05 RS-FINAL-BILL-DT         PIC X(10) VALUE  SPACES.         
P00180     05 RS-WO-IND                PIC X(01) VALUE  SPACES.         
P00180     05 RS-WRITE-OFF-AMT         PIC S9(09)V99 COMP-3 VALUE +0.   
P00180     05 RS-WRITE-OFF-DT          PIC X(10) VALUE  SPACES.         
      *                                                                         
       01 WS-MISC.                                                      
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR03781'.      
           05 WS-MCSCB068              PIC X(8)  VALUE 'MCSCB068'.      
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.            
                                                                        
           05 WS-CUSTOMER-NO           PIC X(10).                       
           05 WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO         
                                       PIC 9(10).                       
           05 WS-CUSTOMER-NO-COMP3     PIC S9(10) COMP-3 VALUE +0.      
           05 WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
           05 WS-BILL-IMMED-EXISTS-FL  PIC X(01) VALUE SPACES.          
           05 WS-ADEP-BALANCE          PIC S9(09)V99 COMP-3 VALUE +0.   
           05 WS-HOLD-DEL-VALUE        PIC S9(4)V9(5) COMP-3 VALUE +0.  
           05 WS-NEXT-DNP-DATE         PIC X(10) VALUE SPACES.          
           05 WS-RECONNECT-EXISTS      PIC X(01) VALUE 'N'.             
              88  RECONNECT-EXISTS     VALUE 'Y'.                       
           05 SEND-DONE-SW             PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-NO-MORE-DATA-DELINQ  PIC X(01) VALUE 'N'.             
               88 NO-MORE-DATA-DELINQ  VALUE 'Y'.                       
           05  WS-NO-MORE-DATA-ARCUR   PIC X(01) VALUE 'N'.             
               88 NO-MORE-DATA-ARCUR   VALUE 'Y'.                       
           05 WS-DATE                  OCCURS 4 TIMES.                  
               10 WS-DATE-COMP         PIC X(10).                       
           05 WS-AMT                   OCCURS 4 TIMES.                  
COB305         10 WS-AMT-COMP        PIC S9(09)V99 COMP-3 VALUE 0.            
           05 WS-J                     PIC S9(4) COMP VALUE ZERO.       
           05 WS-K                     PIC S9(4) COMP VALUE ZERO.       
           05 WS-COUNT                 PIC S9(4) COMP VALUE ZERO.       
           05 WS-DATE-TEMP             PIC X(10) VALUE SPACES.          
           05 WS-AMT-TEMP              PIC S9(09)V99 COMP-3 VALUE ZERO. 
           05 WS-DATE-FORMAT.                                           
              10 WS-MM                 PIC X(02) VALUE SPACES.          
              10 FILLER                PIC X(01) VALUE '/'.             
              10 WS-DD                 PIC X(02) VALUE SPACES.          
              10 FILLER                PIC X(01) VALUE '/'.             
              10 WS-YYYY               PIC X(04) VALUE SPACES.          
P00180     05 WS-CUTOFF-DELINQ-VALUE   PIC S9(4)V9(5) COMP-3 VALUE +0.  
P00180     05 WS-CUT-OFF-DATE          PIC X(10) VALUE SPACES.          
P00180     05 WS-COMPANY-NO            PIC X(02) VALUE SPACES.          
      *                                                                         
      ******************************************************************        
      * Indicator Variables.                                           *        
      ******************************************************************        
      *                                                                         
       01 IND-VARIABLES.                                                
           05 WS-NULL-1                PIC S9(4) COMP.                  
           05 WS-NULL-2                PIC S9(4) COMP.                  
           05 WS-NULL-3                PIC S9(4) COMP.                  
           05 WS-NULL-4                PIC S9(4) COMP.                  
           05 WS-NULL-5                PIC S9(4) COMP.                  
           05 WS-NULL-6                PIC S9(4) COMP.                  
           05 WS-NULL-7                PIC S9(4) COMP.                  
           05 WS-NULL-8                PIC S9(4) COMP.                  
           05 WS-NULL-9                PIC S9(4) COMP.                  
           05 WS-NULL-10               PIC S9(4) COMP.                  
P00180     05 WS-NULL-11               PIC S9(4) COMP.                  
P00180     05 WS-NULL-12               PIC S9(4) COMP.                  
P00180     05 WS-NULL-13               PIC S9(4) COMP.                  
                                                                        
      ******************************************************************        
      * SQL Error Checking Copy Books.                                 *        
      ******************************************************************        
                                                                        
      *01  WS-WARNING-DATA-ELEMENTS.                                            
           COPY CWS00303.                                                       
                                                                        
      *01  CSRERLOG-P.                                                          
           COPY CWSSP001.                                                       
                                                                        
      ******************************************************************        
      * Working Storage for Procedure Division Copy Books              *        
      ******************************************************************        
                                                                        
      *01  WS-CPD68-LINK-RECORD.                                                
      *Used wile calling MCSCB0068 Module.                                      
           COPY CWS0068L.                                                       
                                                                        
      *01  WS-11-TABLES.                                                        
      *Used in reducing embdded blanks.                                         
           COPY CWS00011.                                                       
                                                                        
      ******************************************************************        
      * DB2 Includes                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    AC - CSS_AR_CNTL                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *     AT - CSS_ACCOUNT                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CA - CSS_CUST_ALERT                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTALT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DA - CSS_DFA_ACCT                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDFAACT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DL - CSS_RECONNECT                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DO - CSS_DEP_ON_HAND                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DR - CSS_DEP_REQ                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDEPREQ                                                  
           END-EXEC.                                                            
      *                                                                         
P00180******************************************************************        
P00180*    CO - CSS_CHRG_OFF                                           *        
P00180******************************************************************        
P00180*                                                                         
P00180     EXEC SQL                                                             
P00180        INCLUDE TBCHGOFF                                                  
P00180     END-EXEC.                                                            
P00180*                                                                         
P00726*****************************************************************         
P00726*    CSS_CRED_ARNGMENT  X1                                      *         
P00726*****************************************************************         
P00726*                                                                         
P00726     EXEC SQL                                                             
P00726         INCLUDE TBCRARNG                                                 
P00726     END-EXEC.                                                            
P00726*                                                                         
      ******************************************************************        
      * Error Handling Copy Book.                                      *        
      ******************************************************************        
      *                                                                         
      *01  ABEND-FILE.                                                          
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Working Storage to Support CPD00068.                           *        
      ******************************************************************        
      *                                                                         
      *01  CWS00068-FIELDS.                                                     
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
      *                                                                         
      *01  WS-CODES-DATA-PRESENT.                                               
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Cursor for getting DFA Tran balance.                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE AR_CURSOR CURSOR FOR                            
                SELECT                                                  
                       AC.AMT_TRAN_BALANCE                              
                      ,AC.ITEM_ID                                       
                FROM                                                    
                       CSS_AR_CNTL  AC WITH(READUNCOMMITTED)                    
                      ,CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                    
                WHERE                                                   
                       AC.ACCOUNT_NO        = :AC-ACCOUNT-NO            
                  AND  DA.ACCOUNT_NO        = :DA-ACCOUNT-NO            
                  AND  DA.DFA_ITEM_ID       = AC.ITEM_ID                
                  AND  DA.CODE_DFA_TYPE     IN ('A', 'B')               
                  AND  DA.CODE_DFA_STATUS   = 'A'                       
                  AND  DA.PYMT_PRIORITY_LVL = 90                        
                  AND  AC.PYMT_PRIORITY_LVL = 90                        
                  FOR READ ONLY                                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE AR_CURSOR CURSOR FOR                                    
MFA-TR*         SELECT                                                          
MFA-TR*                AC.AMT_TRAN_BALANCE                                      
MFA-TR*               ,AC.ITEM_ID                                               
MFA-TR*         FROM                                                            
MFA-TR*                CSS_AR_CNTL  AC                                          
MFA-TR*               ,CSS_DFA_ACCT DA                                          
MFA-TR*         WHERE                                                           
MFA-TR*                AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                    
MFA-TR*           AND  DA.ACCOUNT_NO        = :DA-ACCOUNT-NO                    
MFA-TR*           AND  DA.DFA_ITEM_ID       = AC.ITEM_ID                        
MFA-TR*           AND  DA.CODE_DFA_TYPE     IN ('A', 'B')                       
MFA-TR*           AND  DA.CODE_DFA_STATUS   = 'A'                               
MFA-TR*           AND  DA.PYMT_PRIORITY_LVL = 90                                
MFA-TR*           AND  AC.PYMT_PRIORITY_LVL = 90                                
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Cursor for getting amounts to display on SEB Pledge Form.      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE DELINQ_CURSOR CURSOR FOR                        
                SELECT                                                  
                       C8.DELINQ_CD                                     
                      ,C8.DELINQ_VALUE                                  
                FROM                                                    
                       CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                 
                WHERE                                                   
                       C8.DELINQ_CD   IN ('PLEDGE-AMT-1'                
                                         ,'PLEDGE-AMT-2'                
                                         ,'PLEDGE-AMT-3'                
                                         ,'PLEDGE-AMT-4'                
                                         ,'PLEDGE-AMT-5'                
                                         ,'PLEDGE-AMT-6')               
                  AND  C8.COMPANY_NO = :C8-COMPANY-NO                   
                  FOR READ ONLY                                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE DELINQ_CURSOR CURSOR FOR                                
MFA-TR*         SELECT                                                          
MFA-TR*                C8.DELINQ_CD                                             
MFA-TR*               ,C8.DELINQ_VALUE                                          
MFA-TR*         FROM                                                            
MFA-TR*                CSS_DELINQUENCY C8                                       
MFA-TR*         WHERE                                                           
MFA-TR*                C8.DELINQ_CD   IN ('PLEDGE-AMT-1'                        
MFA-TR*                                  ,'PLEDGE-AMT-2'                        
MFA-TR*                                  ,'PLEDGE-AMT-3'                        
MFA-TR*                                  ,'PLEDGE-AMT-4'                        
MFA-TR*                                  ,'PLEDGE-AMT-5'                        
MFA-TR*                                  ,'PLEDGE-AMT-6')                       
MFA-TR*           AND  C8.COMPANY_NO = :C8-COMPANY-NO                           
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  I-APPLICATION-ID         PIC X(07).                          
       01  I-ACCOUNT-NO             PIC X(13).                          
       01  I-CUSTOMER-NO            PIC X(10).                          
      *                                                                         
       PROCEDURE DIVISION USING  I-APPLICATION-ID                       
                               , I-ACCOUNT-NO                           
                               , I-CUSTOMER-NO.                         
      *                                                                         
      ******************************************************************        
      * Controls the Main Processing of the Program.                   *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Initialize Return Fields, Declare GTT and Result Set Cursor.   *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           MOVE 'N'                       TO WS-RECONNECT-EXISTS.       
           MOVE ZERO                      TO C8-DELINQ-VALUE.           
           MOVE 'N'                       TO WS-NO-MORE-DATA-DELINQ     
                                             WS-NO-MORE-DATA-ARCUR.     
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 :S-RETURN-CODE               AS RETURN_CODE            
                ,LTRIM(RTRIM(:S-BAL-IND))            AS BAL_IND                
                ,LTRIM(RTRIM(:S-REC-IND))            AS REC_IND                
                ,LTRIM(RTRIM(:S-NORM-IND))           AS NORM_IND               
                ,LTRIM(RTRIM(:S-EXCEPT-IND))         AS EXCEPT_IND             
                ,LTRIM(RTRIM(:S-STA-IND))            AS STA_IND                
                ,LTRIM(RTRIM(:S-DPP-IND))            AS DPP_IND                
                ,LTRIM(RTRIM(:S-DFA-IND))            AS DFA_IND                
                ,LTRIM(RTRIM(:S-EPP-IND))            AS EPP_IND                
                ,LTRIM(RTRIM(:S-MED-IND))            AS MED_IND                
                ,LTRIM(RTRIM(:S-RETCHK-IND))         AS RETCHK_IND             
                ,LTRIM(RTRIM(:S-DEP-IND))            AS DEP_IND                
                ,LTRIM(RTRIM(:S-PLEDGE-IND))         AS PLEDGE_IND             
                ,LTRIM(RTRIM(:S-BILLED-DIM-IND))     AS BILLED_DIM_IND         
                ,LTRIM(RTRIM(:S-REC-DIM-IND))        AS REC_DIM_IND            
                ,LTRIM(RTRIM(:S-NORM-DIM-IND))       AS NORM_DIM_IND           
                ,LTRIM(RTRIM(:S-EXCEPT-DIM-IND))     AS EXCEPT_DIM_IND         
                ,LTRIM(RTRIM(:S-STA-DIM-IND))        AS STA_DIM_IND            
                ,LTRIM(RTRIM(:S-DPP-DIM-IND))        AS DPP_DIM_IND            
                ,LTRIM(RTRIM(:S-DFA-DIM-IND))        AS DFA_DIM_IND            
                ,LTRIM(RTRIM(:S-EPP-DIM-IND))        AS EPP_DIM_IND            
                ,LTRIM(RTRIM(:S-MED-DIM-IND))        AS MED_DIM_IND            
                ,LTRIM(RTRIM(:S-RETCHK-DIM-IND))     AS RETCHK_DIM_IND         
                ,LTRIM(RTRIM(:S-DEPOSIT-DIM-IND))    AS DEPOSIT_DIM_IND        
                ,LTRIM(RTRIM(:S-PLEDGE-DIM-IND))     AS PLEDGE_DIM_IND         
                ,:S-BILLED-AMT                AS BILLED_AMT             
                ,:S-UTIL-BILLED-AMT           AS UTIL_BILLED_AMT        
                ,:S-NONUTIL-BILLED-AMT        AS NONUTIL_BILLED_AMT     
                ,:S-REC-SERV-AMT              AS REC_SERV_AMT           
                ,:S-REC-CHRG                  AS REC_CHRG               
                ,:S-REC-DNP-AMT               AS REC_DNP_AMT            
                ,:S-REC-DEP-AMT               AS REC_DEP_AMT            
                ,LTRIM(RTRIM(:S-NORM-MAIL-DT))       AS NORM_MAIL_DT           
                ,LTRIM(RTRIM(:S-NORM-DUE-DT))        AS NORM_DUE_DT            
                ,:S-NORM-DUE-AMT              AS NORM_DUE_AMT           
                ,LTRIM(RTRIM(:S-NORM-DNP-DT))        AS NORM_DNP_DT            
                ,:S-NORM-DNP-AMT              AS NORM_DNP_AMT           
                ,LTRIM(RTRIM(:S-EXCEPT-DUE-DT))      AS EXCEPT_DUE_DT          
                ,:S-EXCEPT-DUE-AMT            AS EXCEPT_DUE_AMT         
                ,LTRIM(RTRIM(:S-EXCEPT-DNP-DT))      AS EXCEPT_DNP_DT          
                ,:S-EXCEPT-DNP-AMT            AS EXCEPT_DNP_AMT         
                ,LTRIM(RTRIM(:S-STA-SETUP-DT))       AS STA_SETUP_DT           
                ,LTRIM(RTRIM(:S-STA-DUE-DT))         AS STA_DUE_DT             
                ,:S-STA-DUE-AMT               AS STA_DUE_AMT            
                ,LTRIM(RTRIM(:S-STA-DNP-DT))         AS STA_DNP_DT             
                ,:S-STA-DNP-AMT               AS STA_DNP_AMT            
                ,LTRIM(RTRIM(:S-DPP-SETUP-DT))       AS DPP_SETUP_DT           
                ,LTRIM(RTRIM(:S-DPP-DUE-DT))         AS DPP_DUE_DT             
                ,:S-DPP-DUE-AMT               AS DPP_DUE_AMT            
                ,LTRIM(RTRIM(:S-DPP-DNP-DT))         AS DPP_DNP_DT             
                ,:S-DPP-DNP-AMT               AS DPP_DNP_AMT            
                ,LTRIM(RTRIM(:S-MED-EXPIRE-DT))      AS MED_EXPIRE_DT          
                ,LTRIM(RTRIM(:S-MED-DUE-DT))         AS MED_DUE_DT             
                ,:S-MED-DUE-AMT               AS MED_DUE_AMT            
                ,LTRIM(RTRIM(:S-MED-DNP-DT))         AS MED_DNP_DT             
                ,:S-MED-DNP-AMT               AS MED_DNP_AMT            
                ,:S-RETCHK-AMT                AS RETCHK_AMT             
                ,LTRIM(RTRIM(:S-RETCHK-DUE-DT))      AS RETCHK_DUE_DT          
                ,:S-RETCHK-DNP-AMT            AS RETCHK_DNP_AMT         
                ,LTRIM(RTRIM(:S-RETCHK-DNP-DT))      AS RETCHK_DNP_DT          
                ,:S-DEPOSIT-AMT               AS DEPOSIT_AMT            
                ,LTRIM(RTRIM(:S-DEPOSIT-DUE-DT))     AS DEPOSIT_DUE_DT         
                ,:S-DEPOSIT-DNP-AMT           AS DEPOSIT_DNP_AMT        
                ,LTRIM(RTRIM(:S-DEPOSIT-DNP-DT))     AS DEPOSIT_DNP_DT         
                ,:S-PLEDGE-AMT-1              AS PLEDGE_AMT_1           
                ,:S-PLEDGE-AMT-2              AS PLEDGE_AMT_2           
                ,:S-PLEDGE-AMT-3              AS PLEDGE_AMT_3           
                ,:S-PLEDGE-AMT-4              AS PLEDGE_AMT_4           
                ,:S-PLEDGE-AMT-5              AS PLEDGE_AMT_5           
                ,:S-PLEDGE-AMT-6              AS PLEDGE_AMT_6           
                ,LTRIM(RTRIM(:S-PLEDGE-DNP-STATE))   AS PLEDGE_DNP_STATE       
P00180          ,:S-FB-IND                    AS FB_IND                 
P00180          ,:S-FINAL-BILL-AMT            AS FINAL_BILL_AMT         
P00180          ,LTRIM(RTRIM(:S-FINAL-BILL-DT))      AS FINAL_BILL_DT          
P00180          ,:S-WO-IND                    AS WO_IND                 
P00180          ,:S-WRITE-OFF-AMT             AS WRITE_OFF_AMT          
P00180          ,LTRIM(RTRIM(:S-WRITE-OFF-DT))       AS WRITE_OFF_DT           
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          :S-RETURN-CODE               AS RETURN_CODE                    
MFA-TR*         ,STRIP(:S-BAL-IND)            AS BAL_IND                        
MFA-TR*         ,STRIP(:S-REC-IND)            AS REC_IND                        
MFA-TR*         ,STRIP(:S-NORM-IND)           AS NORM_IND                       
MFA-TR*         ,STRIP(:S-EXCEPT-IND)         AS EXCEPT_IND                     
MFA-TR*         ,STRIP(:S-STA-IND)            AS STA_IND                        
MFA-TR*         ,STRIP(:S-DPP-IND)            AS DPP_IND                        
MFA-TR*         ,STRIP(:S-DFA-IND)            AS DFA_IND                        
MFA-TR*         ,STRIP(:S-EPP-IND)            AS EPP_IND                        
MFA-TR*         ,STRIP(:S-MED-IND)            AS MED_IND                        
MFA-TR*         ,STRIP(:S-RETCHK-IND)         AS RETCHK_IND                     
MFA-TR*         ,STRIP(:S-DEP-IND)            AS DEP_IND                        
MFA-TR*         ,STRIP(:S-PLEDGE-IND)         AS PLEDGE_IND                     
MFA-TR*         ,STRIP(:S-BILLED-DIM-IND)     AS BILLED_DIM_IND                 
MFA-TR*         ,STRIP(:S-REC-DIM-IND)        AS REC_DIM_IND                    
MFA-TR*         ,STRIP(:S-NORM-DIM-IND)       AS NORM_DIM_IND                   
MFA-TR*         ,STRIP(:S-EXCEPT-DIM-IND)     AS EXCEPT_DIM_IND                 
MFA-TR*         ,STRIP(:S-STA-DIM-IND)        AS STA_DIM_IND                    
MFA-TR*         ,STRIP(:S-DPP-DIM-IND)        AS DPP_DIM_IND                    
MFA-TR*         ,STRIP(:S-DFA-DIM-IND)        AS DFA_DIM_IND                    
MFA-TR*         ,STRIP(:S-EPP-DIM-IND)        AS EPP_DIM_IND                    
MFA-TR*         ,STRIP(:S-MED-DIM-IND)        AS MED_DIM_IND                    
MFA-TR*         ,STRIP(:S-RETCHK-DIM-IND)     AS RETCHK_DIM_IND                 
MFA-TR*         ,STRIP(:S-DEPOSIT-DIM-IND)    AS DEPOSIT_DIM_IND                
MFA-TR*         ,STRIP(:S-PLEDGE-DIM-IND)     AS PLEDGE_DIM_IND                 
MFA-TR*         ,:S-BILLED-AMT                AS BILLED_AMT                     
MFA-TR*         ,:S-UTIL-BILLED-AMT           AS UTIL_BILLED_AMT                
MFA-TR*         ,:S-NONUTIL-BILLED-AMT        AS NONUTIL_BILLED_AMT             
MFA-TR*         ,:S-REC-SERV-AMT              AS REC_SERV_AMT                   
MFA-TR*         ,:S-REC-CHRG                  AS REC_CHRG                       
MFA-TR*         ,:S-REC-DNP-AMT               AS REC_DNP_AMT                    
MFA-TR*         ,:S-REC-DEP-AMT               AS REC_DEP_AMT                    
MFA-TR*         ,STRIP(:S-NORM-MAIL-DT)       AS NORM_MAIL_DT                   
MFA-TR*         ,STRIP(:S-NORM-DUE-DT)        AS NORM_DUE_DT                    
MFA-TR*         ,:S-NORM-DUE-AMT              AS NORM_DUE_AMT                   
MFA-TR*         ,STRIP(:S-NORM-DNP-DT)        AS NORM_DNP_DT                    
MFA-TR*         ,:S-NORM-DNP-AMT              AS NORM_DNP_AMT                   
MFA-TR*         ,STRIP(:S-EXCEPT-DUE-DT)      AS EXCEPT_DUE_DT                  
MFA-TR*         ,:S-EXCEPT-DUE-AMT            AS EXCEPT_DUE_AMT                 
MFA-TR*         ,STRIP(:S-EXCEPT-DNP-DT)      AS EXCEPT_DNP_DT                  
MFA-TR*         ,:S-EXCEPT-DNP-AMT            AS EXCEPT_DNP_AMT                 
MFA-TR*         ,STRIP(:S-STA-SETUP-DT)       AS STA_SETUP_DT                   
MFA-TR*         ,STRIP(:S-STA-DUE-DT)         AS STA_DUE_DT                     
MFA-TR*         ,:S-STA-DUE-AMT               AS STA_DUE_AMT                    
MFA-TR*         ,STRIP(:S-STA-DNP-DT)         AS STA_DNP_DT                     
MFA-TR*         ,:S-STA-DNP-AMT               AS STA_DNP_AMT                    
MFA-TR*         ,STRIP(:S-DPP-SETUP-DT)       AS DPP_SETUP_DT                   
MFA-TR*         ,STRIP(:S-DPP-DUE-DT)         AS DPP_DUE_DT                     
MFA-TR*         ,:S-DPP-DUE-AMT               AS DPP_DUE_AMT                    
MFA-TR*         ,STRIP(:S-DPP-DNP-DT)         AS DPP_DNP_DT                     
MFA-TR*         ,:S-DPP-DNP-AMT               AS DPP_DNP_AMT                    
MFA-TR*         ,STRIP(:S-MED-EXPIRE-DT)      AS MED_EXPIRE_DT                  
MFA-TR*         ,STRIP(:S-MED-DUE-DT)         AS MED_DUE_DT                     
MFA-TR*         ,:S-MED-DUE-AMT               AS MED_DUE_AMT                    
MFA-TR*         ,STRIP(:S-MED-DNP-DT)         AS MED_DNP_DT                     
MFA-TR*         ,:S-MED-DNP-AMT               AS MED_DNP_AMT                    
MFA-TR*         ,:S-RETCHK-AMT                AS RETCHK_AMT                     
MFA-TR*         ,STRIP(:S-RETCHK-DUE-DT)      AS RETCHK_DUE_DT                  
MFA-TR*         ,:S-RETCHK-DNP-AMT            AS RETCHK_DNP_AMT                 
MFA-TR*         ,STRIP(:S-RETCHK-DNP-DT)      AS RETCHK_DNP_DT                  
MFA-TR*         ,:S-DEPOSIT-AMT               AS DEPOSIT_AMT                    
MFA-TR*         ,STRIP(:S-DEPOSIT-DUE-DT)     AS DEPOSIT_DUE_DT                 
MFA-TR*         ,:S-DEPOSIT-DNP-AMT           AS DEPOSIT_DNP_AMT                
MFA-TR*         ,STRIP(:S-DEPOSIT-DNP-DT)     AS DEPOSIT_DNP_DT                 
MFA-TR*         ,:S-PLEDGE-AMT-1              AS PLEDGE_AMT_1                   
MFA-TR*         ,:S-PLEDGE-AMT-2              AS PLEDGE_AMT_2                   
MFA-TR*         ,:S-PLEDGE-AMT-3              AS PLEDGE_AMT_3                   
MFA-TR*         ,:S-PLEDGE-AMT-4              AS PLEDGE_AMT_4                   
MFA-TR*         ,:S-PLEDGE-AMT-5              AS PLEDGE_AMT_5                   
MFA-TR*         ,:S-PLEDGE-AMT-6              AS PLEDGE_AMT_6                   
MFA-TR*         ,STRIP(:S-PLEDGE-DNP-STATE)   AS PLEDGE_DNP_STATE               
MFA-TR*         ,:S-FB-IND                    AS FB_IND                         
MFA-TR*         ,:S-FINAL-BILL-AMT            AS FINAL_BILL_AMT                 
MFA-TR*         ,STRIP(:S-FINAL-BILL-DT)      AS FINAL_BILL_DT                  
MFA-TR*         ,:S-WO-IND                    AS WO_IND                         
MFA-TR*         ,:S-WRITE-OFF-AMT             AS WRITE_OFF_AMT                  
MFA-TR*         ,STRIP(:S-WRITE-OFF-DT)       AS WRITE_OFF_DT                   
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Validates all the input parameters.                            *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF I-ACCOUNT-NO IS NUMERIC                                   
              MOVE I-ACCOUNT-NO              TO WS-ACCOUNT-NO           
              MOVE WS-ACCOUNT-NO-NUM         TO WS-ACCOUNT-NO-COMP3     
              MOVE WS-ACCOUNT-NO-COMP3       TO AT-ACCOUNT-NO           
                                                DL-ACCOUNT-NO           
           ELSE                                                         
              MOVE 9999 TO  S-RETURN-CODE                               
              EXEC SQL                                                  
                   OPEN C1                                              
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           END-IF.                                                      
      *                                                                         
           IF I-CUSTOMER-NO IS NUMERIC                                  
              MOVE I-CUSTOMER-NO             TO WS-CUSTOMER-NO          
              MOVE WS-CUSTOMER-NO-NUM        TO WS-CUSTOMER-NO-COMP3    
           ELSE                                                         
              MOVE 9999 TO  S-RETURN-CODE                               
              EXEC SQL                                                  
                   OPEN C1                                              
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF.                                                      
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Gets all the required info and formats result set.             *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7000-SELECT-ACCOUNT   THRU 7000-EXIT.                
           PERFORM 2100-PREPARE-CPD00068 THRU 2100-EXIT.                
           PERFORM 2200-BILLED-BALANCES  THRU 2200-EXIT.                
           PERFORM 7100-SELECT-RECONNECT THRU 7100-EXIT.                
           IF RECONNECT-EXISTS                                          
              IF CSR-DATABASE-CPD68                                     
                 PERFORM 2300-RECONNECT-EXISTS     THRU 2300-EXIT       
              ELSE                                                      
                 MOVE 500 TO RS-RETURN-CODE                             
              END-IF                                                    
           ELSE                                                         
              PERFORM 2400-NORMAL-ACTION THRU 2400-EXIT                 
              PERFORM 2500-EXCEPT-ACTION THRU 2500-EXIT                 
              IF CSR-DATABASE-CPD68 AND AT-COMPANY-NO = WS-PSNC-CPD68   
                 PERFORM 2600-PROCESS-PSNC THRU 2600-EXIT               
              ELSE                                                      
                 IF CSR-DATABASE-CPD68 AND                              
                    AT-COMPANY-NO = WS-SCEG-CPD68                       
                    PERFORM 2700-PROCESS-SCEG THRU 2700-EXIT            
                 ELSE                                                   
                    IF SEB-DATABASE-CPD68                               
                       PERFORM 2800-PROCESS-SEB THRU 2800-EXIT          
                    ELSE                                                
                       MOVE 600 TO RS-RETURN-CODE                       
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
P00180* for FB and WO accounts show always service was disconnected             
P00180     IF RS-FB-IND = 'Y' OR RS-WO-IND = 'Y'                        
P00180        MOVE 'W'               TO RS-PLEDGE-DNP-STATE             
P00180     END-IF                                                       
P00180*                                                                         
           PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Prepares Result Set Row.                                       *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
           MOVE RS-BAL-IND                TO S-BAL-IND.                 
           MOVE RS-REC-IND                TO S-REC-IND.                 
           MOVE RS-NORM-IND               TO S-NORM-IND.                
           MOVE RS-EXCEPT-IND             TO S-EXCEPT-IND.              
           MOVE RS-STA-IND                TO S-STA-IND.                 
           MOVE RS-DPP-IND                TO S-DPP-IND.                 
           MOVE RS-DFA-IND                TO S-DFA-IND.                 
           MOVE RS-EPP-IND                TO S-EPP-IND.                 
           MOVE RS-MED-IND                TO S-MED-IND.                 
           MOVE RS-RETCHK-IND             TO S-RETCHK-IND.              
           MOVE RS-DEP-IND                TO S-DEP-IND.                 
           MOVE RS-PLEDGE-IND             TO S-PLEDGE-IND.              
           MOVE RS-BILLED-DIM-IND         TO S-BILLED-DIM-IND.          
           MOVE RS-REC-DIM-IND            TO S-REC-DIM-IND.             
           MOVE RS-NORM-DIM-IND           TO S-NORM-DIM-IND.            
           MOVE RS-EXCEPT-DIM-IND         TO S-EXCEPT-DIM-IND.          
           MOVE RS-STA-DIM-IND            TO S-STA-DIM-IND.             
           MOVE RS-DPP-DIM-IND            TO S-DPP-DIM-IND.             
           MOVE RS-DFA-DIM-IND            TO S-DFA-DIM-IND.             
           MOVE RS-EPP-DIM-IND            TO S-EPP-DIM-IND.             
           MOVE RS-MED-DIM-IND            TO S-MED-DIM-IND.             
           MOVE RS-RETCHK-DIM-IND         TO S-RETCHK-DIM-IND.          
           MOVE RS-DEPOSIT-DIM-IND        TO S-DEPOSIT-DIM-IND.         
           MOVE RS-PLEDGE-DIM-IND         TO S-PLEDGE-DIM-IND.          
           MOVE RS-BILLED-AMT             TO S-BILLED-AMT.              
           MOVE RS-UTIL-BILLED-AMT        TO S-UTIL-BILLED-AMT.         
           MOVE RS-NONUTIL-BILLED-AMT     TO S-NONUTIL-BILLED-AMT.      
           MOVE RS-REC-SERV-AMT           TO S-REC-SERV-AMT.            
           MOVE RS-REC-CHRG               TO S-REC-CHRG.                
           MOVE RS-REC-DNP-AMT            TO S-REC-DNP-AMT.             
           MOVE RS-REC-DEP-AMT            TO S-REC-DEP-AMT.             
           MOVE RS-NORM-MAIL-DT           TO S-NORM-MAIL-DT.            
           MOVE RS-NORM-DUE-DT            TO S-NORM-DUE-DT.             
           MOVE RS-NORM-DUE-AMT           TO S-NORM-DUE-AMT.            
           MOVE RS-NORM-DNP-DT            TO S-NORM-DNP-DT.             
           MOVE RS-NORM-DNP-AMT           TO S-NORM-DNP-AMT.            
           MOVE RS-EXCEPT-DUE-DT          TO S-EXCEPT-DUE-DT.           
           MOVE RS-EXCEPT-DUE-AMT         TO S-EXCEPT-DUE-AMT.          
           MOVE RS-EXCEPT-DNP-DT          TO S-EXCEPT-DNP-DT.           
           MOVE RS-EXCEPT-DNP-AMT         TO S-EXCEPT-DNP-AMT.          
           MOVE RS-STA-SETUP-DT           TO S-STA-SETUP-DT.            
           MOVE RS-STA-DUE-DT             TO S-STA-DUE-DT.              
           MOVE RS-STA-DUE-AMT            TO S-STA-DUE-AMT.             
           MOVE RS-STA-DNP-DT             TO S-STA-DNP-DT.              
           MOVE RS-STA-DNP-AMT            TO S-STA-DNP-AMT.             
           MOVE RS-DPP-SETUP-DT           TO S-DPP-SETUP-DT.            
           MOVE RS-DPP-DUE-DT             TO S-DPP-DUE-DT.              
           MOVE RS-DPP-DUE-AMT            TO S-DPP-DUE-AMT.             
           MOVE RS-DPP-DNP-DT             TO S-DPP-DNP-DT.              
           MOVE RS-DPP-DNP-AMT            TO S-DPP-DNP-AMT.             
           MOVE RS-MED-EXPIRE-DT          TO S-MED-EXPIRE-DT.           
           MOVE RS-MED-DUE-DT             TO S-MED-DUE-DT.              
           MOVE RS-MED-DUE-AMT            TO S-MED-DUE-AMT.             
           MOVE RS-MED-DNP-DT             TO S-MED-DNP-DT.              
           MOVE RS-MED-DNP-AMT            TO S-MED-DNP-AMT.             
           MOVE RS-RETCHK-AMT             TO S-RETCHK-AMT.              
           MOVE RS-RETCHK-DUE-DT          TO S-RETCHK-DUE-DT.           
           MOVE RS-RETCHK-DNP-AMT         TO S-RETCHK-DNP-AMT.          
           MOVE RS-RETCHK-DNP-DT          TO S-RETCHK-DNP-DT.           
           MOVE RS-DEPOSIT-AMT            TO S-DEPOSIT-AMT.             
           MOVE RS-DEPOSIT-DUE-DT         TO S-DEPOSIT-DUE-DT.          
           MOVE RS-DEPOSIT-DNP-AMT        TO S-DEPOSIT-DNP-AMT.         
           MOVE RS-DEPOSIT-DNP-DT         TO S-DEPOSIT-DNP-DT.          
           MOVE RS-PLEDGE-AMT-1           TO S-PLEDGE-AMT-1.            
           MOVE RS-PLEDGE-AMT-2           TO S-PLEDGE-AMT-2.            
           MOVE RS-PLEDGE-AMT-3           TO S-PLEDGE-AMT-3.            
           MOVE RS-PLEDGE-AMT-4           TO S-PLEDGE-AMT-4.            
           MOVE RS-PLEDGE-AMT-5           TO S-PLEDGE-AMT-5.            
           MOVE RS-PLEDGE-AMT-6           TO S-PLEDGE-AMT-6.            
           MOVE RS-PLEDGE-DNP-STATE       TO S-PLEDGE-DNP-STATE.        
P00180     MOVE RS-FB-IND                 TO S-FB-IND.                  
P00180     MOVE RS-FINAL-BILL-AMT         TO S-FINAL-BILL-AMT.          
P00180     MOVE RS-FINAL-BILL-DT          TO S-FINAL-BILL-DT.           
P00180     MOVE RS-WO-IND                 TO S-WO-IND.                  
P00180     MOVE RS-WRITE-OFF-AMT          TO S-WRITE-OFF-AMT.           
P00180     MOVE RS-WRITE-OFF-DT           TO S-WRITE-OFF-DT.            
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Calls CPD00068.                                                *        
      ******************************************************************        
      *                                                                         
       2100-PREPARE-CPD00068.                                           
      *                                                                         
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           MOVE 'Y'                   TO CALC-BALANCE-SW                
                                         LOAD-WS-AMOUNTS-SW             
                                         CALC-PAST-DUE-SW               
                                         CALC-ARREARS-SW                
                                         CALC-DNP-BAL-SW.               
           MOVE PROGRAM-NAME          TO WS-CPD00068-CALLING-PGM.       
           MOVE SPACES                TO ABEND-FUNCTION.                
           PERFORM 9500-CALL-CPD00068 THRU 9500-EXIT.                   
      *                                                                         
       2100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Evaluates Billed Balance.                                      *        
      ******************************************************************        
      *                                                                         
       2200-BILLED-BALANCES.                                            
      *                                                                         
           MOVE 'Y'                     TO RS-BAL-IND.                  
           MOVE WS-TOTAL-BALANCE        TO RS-BILLED-AMT.               
           MOVE WS-TOTAL-BALANCE-UTL    TO RS-UTIL-BILLED-AMT.          
           MOVE WS-TOTAL-BALANCE-NONUTL TO RS-NONUTIL-BILLED-AMT.       
           MOVE 'N'                     TO RS-BILLED-DIM-IND.           
P00180     IF AT-CODE-ACCT-STAT = 'B'                                   
P00180        MOVE WS-TOTAL-BALANCE     TO RS-FINAL-BILL-AMT            
P00180        MOVE AT-ACCT-FINALED-DT(1:10) TO RS-FINAL-BILL-DT         
P00180        IF RS-FINAL-BILL-DT > SPACES                              
P00180           MOVE 'Y'               TO RS-FB-IND                    
P00180           MOVE 'N'               TO RS-BAL-IND                   
P00180        ELSE                                                      
P00180           MOVE 'N'               TO RS-FB-IND                    
P00180        END-IF                                                    
P00180     END-IF.                                                      
P00180     IF AT-CODE-ACCT-STAT = 'S'                                   
P00180        PERFORM 5850-WRITE-OFF-BALANCE    THRU 5850-EXIT          
P00180     END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Processes Reconnects if present.                               *        
      ******************************************************************        
      *                                                                         
       2300-RECONNECT-EXISTS.                                           
      *                                                                         
           MOVE 'Y'                           TO RS-REC-IND.            
           MOVE 'N'                           TO RS-REC-DIM-IND.        
           MOVE DL-RECNCT-COLLECT-AMT         TO RS-REC-CHRG.           
           IF DL-AUTO-DEP-CERT-NO             > ZEROES                  
              MOVE DL-AUTO-DEP-CERT-NO        TO DO-DEPOSIT-CERT-NO     
                                                 DR-DEP-ITEM-ID         
              MOVE AT-ACCOUNT-NO              TO DO-ACCOUNT-NO          
                                                 DR-ACCOUNT-NO          
              PERFORM 7310-GET-AUTO-DEP       THRU 7310-EXIT            
              IF WS-BILL-IMMED-EXISTS-FL      = 'Y'                     
                 COMPUTE RS-REC-DEP-AMT       = WS-AMT-00-DAY-DEP +     
                                                WS-AMT-30-DAY-DEP +     
                                                WS-AMT-60-DAY-DEP +     
                                                WS-AMT-90-DAY-DEP       
                 IF RS-REC-DEP-AMT             = 0                      
                    MOVE AT-ACCOUNT-NO        TO AC-ACCOUNT-NO          
                    MOVE DL-AUTO-DEP-CERT-NO  TO AC-ITEM-ID             
                    MOVE 80                   TO                        
                                                  AC-PYMT-PRIORITY-LVL  
                    PERFORM 7320-GET-AMT-ADEP-BAL THRU 7320-EXIT        
                    MOVE WS-ADEP-BALANCE          TO RS-REC-DEP-AMT     
                 END-IF                                                 
              ELSE                                                      
                 MOVE ZEROES                   TO RS-REC-DEP-AMT        
              END-IF                                                    
           ELSE                                                         
              IF DL-AUTO-DEP-AM                 > ZEROES                
                 IF AT-COMPANY-NO               = '26'                  
                    MOVE DL-AUTO-DEP-AM        TO RS-REC-DEP-AMT        
                 ELSE                                                   
                    MOVE ZEROES                TO RS-REC-DEP-AMT        
                 END-IF                                                 
              ELSE                                                      
                 MOVE ZEROES                   TO RS-REC-DEP-AMT        
              END-IF                                                    
           END-IF.                                                      
      ******************************************************************        
      * This piece of code is commented to make sure that the reconnect*        
      * logic works as per Panel#125.                                  *        
      ******************************************************************        
      *    IF WS-AMT-DNP-BAL = 0                                                
      *       IF CSR-DATABASE-CPD68 AND AT-COMPANY-NO = WS-SCEG-CPD68           
      *          IF RS-REC-DEP-AMT > 0                                          
      *             COMPUTE RS-REC-SERV-AMT    =  RS-REC-DEP-AMT +              
      *                                           DL-AMT-TOT-RECONNECT          
      *          ELSE                                                           
      *             MOVE DL-AMT-TOT-RECONNECT  TO RS-REC-SERV-AMT               
      *          END-IF                                                         
      *       ELSE                                                              
      *          MOVE DL-AMT-TOT-RECONNECT     TO RS-REC-SERV-AMT               
      *       END-IF                                                            
      *    ELSE                                                                 
      *       COMPUTE RS-REC-SERV-AMT          =  RS-REC-CHRG +                 
      *                                           RS-REC-DEP-AMT +              
      *                                           WS-AMT-DNP-BAL                
      *    END-IF.                                                              
           MOVE DL-AMT-TOT-RECONNECT           TO RS-REC-SERV-AMT.      
           PERFORM 5900-PLEDGE-CSR             THRU 5900-EXIT.          
      *                                                                         
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Processes Normal Credit Action.                                *        
      ******************************************************************        
      *                                                                         
       2400-NORMAL-ACTION.                                              
      *                                                                         
            IF WS-DATE-CREDIT-ACTION-D  > SPACES                        
                MOVE 'Y'                     TO RS-NORM-IND             
                MOVE WS-DATE-NOTICE-MAIL-C   TO RS-NORM-MAIL-DT         
                MOVE WS-DATE-NOTICE-DUE-C    TO RS-NORM-DUE-DT          
                MOVE WS-AMT-NOTICE-C         TO RS-NORM-DUE-AMT         
                MOVE WS-DATE-CREDIT-ACTION-D TO RS-NORM-DNP-DT          
                MOVE WS-AMT-NOTICE-D         TO RS-NORM-DNP-AMT         
                IF WS-DATE-CREDIT-ACTION-D > WS-CURRENT-DATE            
                    MOVE 'N'        TO RS-NORM-DIM-IND                  
                ELSE                                                    
                    MOVE 'Y'        TO RS-NORM-DIM-IND                  
                END-IF                                                  
            END-IF.                                                     
      *                                                                         
       2400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Processes Exceptional Credit Action.                           *        
      ******************************************************************        
      *                                                                         
       2500-EXCEPT-ACTION.                                              
      *                                                                         
           IF WS-DATE-CREDIT-ACTION-G        > SPACES                   
              MOVE 'Y'                      TO RS-EXCEPT-IND            
              MOVE WS-DATE-NOTICE-DUE-F     TO RS-EXCEPT-DUE-DT         
              MOVE WS-AMT-NOTICE-F          TO RS-EXCEPT-DUE-AMT        
              MOVE WS-DATE-CREDIT-ACTION-G  TO RS-EXCEPT-DNP-DT         
              MOVE WS-AMT-NOTICE-G          TO RS-EXCEPT-DNP-AMT        
              IF WS-DATE-CREDIT-ACTION-G     > WS-CURRENT-DATE          
                 MOVE 'N'                   TO RS-EXCEPT-DIM-IND        
              ELSE                                                      
                 MOVE 'Y'                   TO RS-EXCEPT-DIM-IND        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Main business logic for PSNC accounts.                         *        
      ******************************************************************        
      *                                                                         
       2600-PROCESS-PSNC.                                               
      *                                                                         
           PERFORM 5100-RET-CHECK     THRU 5100-EXIT.                   
           PERFORM 5200-DEPOSIT       THRU 5200-EXIT.                   
P00726     PERFORM 5350-CRED-ARNG     THRU 5350-EXIT.                   
           PERFORM 5400-DPP           THRU 5400-EXIT.                   
           PERFORM 5600-MED-CERT      THRU 5600-EXIT.                   
           PERFORM 5700-DFA           THRU 5700-EXIT.                   
           PERFORM 5800-EPP           THRU 5800-EXIT.                   
           PERFORM 5900-PLEDGE-CSR    THRU 5900-EXIT.                   
      *                                                                         
       2600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Main business logic for SCEG accounts.                         *        
      ******************************************************************        
      *                                                                         
       2700-PROCESS-SCEG.                                               
      *                                                                         
           PERFORM 5100-RET-CHECK  THRU 5100-EXIT.                      
           PERFORM 5200-DEPOSIT    THRU 5200-EXIT.                      
P00726     PERFORM 5350-CRED-ARNG  THRU 5350-EXIT.                      
           PERFORM 5400-DPP        THRU 5400-EXIT.                      
           PERFORM 5600-MED-CERT   THRU 5600-EXIT.                      
           PERFORM 5700-DFA        THRU 5700-EXIT.                      
           PERFORM 5800-EPP        THRU 5800-EXIT.                      
           PERFORM 5900-PLEDGE-CSR    THRU 5900-EXIT.                   
      *                                                                         
       2700-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Main business logic for SEB accounts.                          *        
      ******************************************************************        
      *                                                                         
       2800-PROCESS-SEB.                                                
      *                                                                         
           IF WS-CODE-PENDING-DNP = SPACE                               
              PERFORM 5100-RET-CHECK  THRU 5100-EXIT                    
              PERFORM 5200-DEPOSIT    THRU 5200-EXIT                    
P00726        PERFORM 5350-CRED-ARNG  THRU 5350-EXIT                    
              PERFORM 5400-DPP        THRU 5400-EXIT                    
              PERFORM 5600-MED-CERT   THRU 5600-EXIT                    
              PERFORM 5700-DFA        THRU 5700-EXIT                    
              PERFORM 5800-EPP        THRU 5800-EXIT                    
              MOVE    'F'             TO   RS-PLEDGE-DNP-STATE          
           ELSE                                                         
              MOVE 500                TO RS-RETURN-CODE                 
           END-IF.                                                      
           PERFORM 5950-PLEDGE-SEB    THRU 5950-EXIT.                   
      *                                                                         
       2800-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Processes Return Check.                                        *        
      ******************************************************************        
                                                                        
       5100-RET-CHECK.                                                  
      *                                                                         
           IF WS-DATE-CREDIT-ACTION-H        > SPACES                   
              MOVE WS-AMT-NOTICE-N          TO RS-RETCHK-AMT            
              MOVE WS-DATE-NOTICE-DUE-N     TO RS-RETCHK-DUE-DT         
              MOVE WS-AMT-NOTICE-H          TO RS-RETCHK-DNP-AMT        
              MOVE WS-DATE-CREDIT-ACTION-H  TO RS-RETCHK-DNP-DT         
              MOVE 'Y'                      TO RS-RETCHK-IND            
              IF WS-DATE-CREDIT-ACTION-H     > WS-CURRENT-DATE          
                 MOVE 'N'                   TO RS-RETCHK-DIM-IND        
              ELSE                                                      
                 MOVE 'Y'                   TO RS-RETCHK-DIM-IND        
              END-IF                                                    
           ELSE                                                         
              IF WS-AMT-DNP-RET-CHECK        > 0                        
                 MOVE 'Y'                   TO RS-RETCHK-IND            
                 MOVE 'N'                   TO RS-RETCHK-DIM-IND        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       5100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Processes Deposit.                                             *        
      ******************************************************************        
      *                                                                         
       5200-DEPOSIT.                                                    
      *                                                                         
           IF WS-DATE-CREDIT-ACTION-I       > SPACES                    
              MOVE WS-AMT-NOTICE-O         TO RS-DEPOSIT-AMT            
              MOVE WS-DATE-NOTICE-DUE-O    TO RS-DEPOSIT-DUE-DT         
              MOVE WS-AMT-NOTICE-I         TO RS-DEPOSIT-DNP-AMT        
              MOVE WS-DATE-CREDIT-ACTION-I TO RS-DEPOSIT-DNP-DT         
              MOVE 'Y'                     TO RS-DEP-IND                
              IF WS-DATE-CREDIT-ACTION-I    > WS-CURRENT-DATE           
                 MOVE 'N'                  TO RS-DEPOSIT-DIM-IND        
              ELSE                                                      
                 MOVE 'Y'                  TO RS-DEPOSIT-DIM-IND        
              END-IF                                                    
           ELSE                                                         
              IF WS-AMT-00-DAY-DEP          > 0 OR                      
                 WS-AMT-30-DAY-DEP          > 0 OR                      
                 WS-AMT-60-DAY-DEP          > 0 OR                      
                 WS-AMT-90-DAY-DEP          > 0                         
                 MOVE 'Y'                  TO RS-DEP-IND                
                 MOVE 'N'                  TO RS-DEPOSIT-DIM-IND        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       5200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00726******************************************************************        
P00726* PROCESSES CREDIT ARANGEMENT                                    *        
P00726******************************************************************        
P00726*                                                                         
P00726 5350-CRED-ARNG.                                                  
P00726*                                                                         
P00726     IF WS-CODE-STA-ACCT         = 'A'                            
P00726        MOVE 'Y'                TO RS-STA-IND                     
P00726        MOVE AT-ACCOUNT-NO      TO X1-ACCOUNT-NO                  
P00726        PERFORM 7305-SELECT-CRED-ARNG THRU 7305-EXIT              
P00726        MOVE X1-ARNG-SETUP-DT   TO RS-STA-SETUP-DT                
P00726        MOVE WS-NEXT-DNP-DATE   TO RS-STA-DNP-DT                  
P00726        IF X1-ARNG-DNP-DT        >     WS-CURRENT-DATE            
P00726           MOVE 'N'             TO RS-STA-DIM-IND                 
P00726        ELSE                                                      
P00726           MOVE 'Y'             TO RS-STA-DIM-IND                 
P00726        END-IF                                                    
P00726     END-IF.                                                      
P00726*                                                                         
P00726 5350-EXIT.                                                       
P00726      EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Processes DPP.                                                 *        
      ******************************************************************        
      *                                                                         
       5400-DPP.                                                        
      *                                                                         
           IF WS-CODE-DPP-ACCT        = 'A'                             
              MOVE 'Y'               TO RS-DPP-IND                      
              MOVE 'N'               TO RS-DPP-DIM-IND                  
           END-IF.                                                      
      *                                                                         
       5400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Gets Medical Certificate/Moratorium Details                    *        
      ******************************************************************        
      *                                                                         
       5600-MED-CERT.                                                   
      *                                                                         
           IF WS-CODE-MEDICAL              = 'A'                        
              MOVE 'Y'                    TO RS-MED-IND                 
              MOVE AT-ACCOUNT-NO          TO CA-ACCOUNT-NO              
              PERFORM 7600-SELECT-MEDCERT THRU 7600-EXIT                
              MOVE CA-DATE-EXPIRE         TO RS-MED-EXPIRE-DT           
              MOVE 'N'                    TO RS-MED-DIM-IND             
           END-IF.                                                      
      *                                                                         
       5600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Processes DFA.                                                 *        
      ******************************************************************        
      *                                                                         
       5700-DFA.                                                        
      *                                                                         
           IF WS-CODE-DFA-ACCT        = 'A'                             
              MOVE 'Y'               TO RS-DFA-IND                      
              MOVE 'N'               TO RS-DFA-DIM-IND                  
           END-IF.                                                      
      *                                                                         
       5700-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Processes Easy Payment Paln.                                   *        
      ******************************************************************        
      *                                                                         
       5800-EPP.                                                        
      *                                                                         
           IF WS-CODE-BUDGET          = 'A'                             
              MOVE 'Y'               TO RS-EPP-IND                      
              MOVE 'N'               TO RS-EPP-DIM-IND                  
           END-IF.                                                      
      *                                                                         
       5800-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00180******************************************************************        
P00180* PROCESSES WRITE OFF.                                           *        
P00180******************************************************************        
P00180*                                                                         
P00180 5850-WRITE-OFF-BALANCE.                                          
P00180*                                                                         
P00180     MOVE 'WO-CUTOFF-DT'       TO C8-DELINQ-CD.                   
P00180     MOVE AT-COMPANY-NO        TO C8-COMPANY-NO.                  
P00180     PERFORM 7900-SEL-WO-CUTOFF-DT   THRU 7900-EXIT.              
P00180     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00180        PERFORM 7950-CALC-CUTOFF-DATE   THRU 7950-EXIT            
P00180     ELSE                                                         
P00180        MOVE '1900-01-01'   TO WS-CUT-OFF-DATE                    
P00180     END-IF.                                                      
P00180*                                                                         
P00180     MOVE AT-ACCOUNT-NO           TO CO-ACCOUNT-NO.               
P00180     PERFORM 7850-SELECT-WO-BAL   THRU   7850-EXIT.               
P00180     MOVE 'Y'                      TO RS-WO-IND.                  
P00180     MOVE 'N'                      TO RS-BAL-IND.                 
P00180     MOVE CO-DATE-OF-CHG-OFF       TO RS-WRITE-OFF-DT.            
P00180     MOVE CO-AMT-TRANS             TO RS-WRITE-OFF-AMT            
P00180                                      RS-PLEDGE-AMT-6.            
P00180*                                                                         
P00180 5850-EXIT.                                                       
P00180      EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Evaluates amounts for Pledge Form.                             *        
      ******************************************************************        
      *                                                                         
       5900-PLEDGE-CSR.                                                 
      *                                                                         
           MOVE 'Y'                       TO RS-PLEDGE-IND.             
           MOVE 'N'                       TO RS-PLEDGE-DIM-IND.         
           MOVE WS-TOTAL-BALANCE-UTL      TO RS-PLEDGE-AMT-1.           
           IF WS-CODE-DFA-ACCT             = 'A' OR                     
              WS-CODE-DPP-ACCT             = 'A'                        
              PERFORM 5910-DEFERRED-ACCT  THRU 5910-EXIT                
           ELSE                                                         
              MOVE ZEROES                 TO RS-PLEDGE-AMT-2            
                                             RS-PLEDGE-AMT-3            
           END-IF.                                                      
      *                                                                         
           IF RECONNECT-EXISTS                                          
              MOVE 'W'                TO RS-PLEDGE-DNP-STATE            
              MOVE 0                  TO RS-PLEDGE-AMT-4                
              IF RS-REC-SERV-AMT < 0                                    
                 MOVE 0               TO RS-PLEDGE-AMT-5                
              ELSE                                                      
                 MOVE RS-REC-SERV-AMT TO RS-PLEDGE-AMT-5                
              END-IF                                                    
           ELSE                                                         
              MOVE 0                  TO RS-PLEDGE-AMT-5                
              IF WS-CODE-PENDING-DNP = 'A'                              
                 MOVE 'G'             TO RS-PLEDGE-DNP-STATE            
                 PERFORM 5920-PENDING-DNP  THRU 5920-EXIT               
              ELSE                                                      
                 PERFORM 5930-EARLIEST-DNP THRU 5930-EXIT               
                 IF RS-PLEDGE-AMT-4 = 0                                 
                    IF WS-CODE-STA-ACCT = 'A'                           
                       MOVE WS-TOTAL-BALANCE-UTL TO RS-PLEDGE-AMT-4     
                       MOVE 'S'       TO RS-PLEDGE-DNP-STATE            
                    ELSE                                                
                       MOVE SPACE     TO RS-PLEDGE-DNP-STATE            
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           IF RS-PLEDGE-AMT-1    > 0                                    
              IF RS-PLEDGE-AMT-1 = RS-PLEDGE-AMT-4                      
P00180* for psnc, Pending accounts don't show disconnection option.             
P00180           IF AT-CODE-ACCT-STAT = 'P' AND AT-COMPANY-NO = '26'    
P00180              AND RS-DEP-IND = 'Y'                                
P00180              MOVE 0             TO RS-PLEDGE-AMT-4               
P00180           ELSE                                                   
P00180              MOVE 0             TO RS-PLEDGE-AMT-1               
P00180           END-IF                                                 
P00180        ELSE                                                      
P00180           IF AT-CODE-ACCT-STAT = 'P' AND AT-COMPANY-NO = '26'    
P00180              AND RS-DEP-IND = 'Y'                                
P00180               MOVE 0             TO RS-PLEDGE-AMT-4              
P00180           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       5900-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Gets AR Tran Balance for Defferred Accounts.                   *        
      ******************************************************************        
      *                                                                         
       5910-DEFERRED-ACCT.                                              
      *                                                                         
           MOVE AT-ACCOUNT-NO            TO AC-ACCOUNT-NO               
                                            DA-ACCOUNT-NO.              
           PERFORM 7010-OPEN-AR-CURSOR   THRU 7010-EXIT.                
           PERFORM 7020-FETCH-AR-CURSOR  THRU 7020-EXIT                 
              UNTIL NO-MORE-DATA-ARCUR.                                 
           PERFORM 7030-CLOSE-AR-CURSOR THRU 7030-EXIT.                 
      *                                                                         
       5910-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Processes Pending DNP                                          *        
      ******************************************************************        
      *                                                                         
       5920-PENDING-DNP.                                                
      *                                                                         
           EVALUATE WS-HOLD-DNP-TYPE                                    
               WHEN 'N'                                                 
               WHEN 'O'                                                 
                   MOVE WS-AMT-DNP-BAL        TO RS-NORM-DNP-AMT        
                                                 RS-PLEDGE-AMT-4        
                   MOVE 'N'                   TO RS-NORM-DIM-IND        
               WHEN 'H'                                                 
                   MOVE WS-AMT-DNP-BAL        TO RS-RETCHK-DNP-AMT      
                                                 RS-PLEDGE-AMT-4        
                   MOVE 'N'                   TO RS-RETCHK-DIM-IND      
                WHEN 'I'                                                
                   MOVE WS-AMT-DNP-BAL        TO RS-DEPOSIT-DNP-AMT     
                                                 RS-PLEDGE-AMT-4        
                   MOVE 'N'                   TO RS-DEPOSIT-DIM-IND     
                WHEN 'Q'                                                
                    MOVE WS-AMT-DNP-BAL       TO RS-EXCEPT-DNP-AMT      
                                                 RS-PLEDGE-AMT-4        
                    MOVE 'N'                  TO RS-EXCEPT-DIM-IND      
                                                 RS-STA-DIM-IND         
                WHEN OTHER                                              
                    MOVE WS-AMT-DNP-BAL       TO RS-EXCEPT-DNP-AMT      
                                                 RS-PLEDGE-AMT-4        
                    MOVE 'N'                  TO RS-EXCEPT-DIM-IND      
           END-EVALUATE.                                                
      *                                                                         
       5920-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Decides the earliest DNP going to happend.                     *        
      ******************************************************************        
      *                                                                         
       5930-EARLIEST-DNP.                                               
      *                                                                         
           MOVE 0 TO WS-COUNT.                                          
           IF WS-DATE-CREDIT-ACTION-D       > WS-CURRENT-DATE           
              ADD 1                        TO WS-COUNT                  
              MOVE WS-DATE-CREDIT-ACTION-D TO WS-DATE-COMP(WS-COUNT)    
              MOVE WS-AMT-NOTICE-D         TO WS-AMT-COMP(WS-COUNT)     
           END-IF.                                                      
           IF WS-DATE-CREDIT-ACTION-G       > WS-CURRENT-DATE           
              ADD 1                        TO WS-COUNT                  
              MOVE WS-DATE-CREDIT-ACTION-G TO WS-DATE-COMP(WS-COUNT)    
              MOVE WS-AMT-NOTICE-G         TO WS-AMT-COMP(WS-COUNT)     
           END-IF.                                                      
           IF WS-DATE-CREDIT-ACTION-H       > WS-CURRENT-DATE           
              ADD 1                        TO WS-COUNT                  
              MOVE WS-DATE-CREDIT-ACTION-H TO WS-DATE-COMP(WS-COUNT)    
              MOVE WS-AMT-NOTICE-H         TO WS-AMT-COMP(WS-COUNT)     
           END-IF.                                                      
           IF WS-DATE-CREDIT-ACTION-I       > WS-CURRENT-DATE           
              ADD 1                        TO WS-COUNT                  
              MOVE WS-DATE-CREDIT-ACTION-I TO WS-DATE-COMP(WS-COUNT)    
              MOVE WS-AMT-NOTICE-I         TO WS-AMT-COMP(WS-COUNT)     
           END-IF.                                                      
      *                                                                         
           PERFORM VARYING WS-J FROM 1 BY 1 UNTIL WS-J > WS-COUNT - 1   
           COMPUTE WS-K = WS-J + 1                                      
              PERFORM UNTIL WS-K > WS-COUNT                             
                 IF WS-DATE-COMP(WS-J)       > WS-DATE-COMP(WS-K)       
                    MOVE WS-DATE-COMP(WS-J) TO WS-DATE-TEMP             
                    MOVE WS-AMT-COMP(WS-J)  TO WS-AMT-TEMP              
                    MOVE WS-DATE-COMP(WS-K) TO WS-DATE-COMP(WS-J)       
                    MOVE WS-AMT-COMP(WS-K)  TO WS-AMT-COMP(WS-J)        
                    MOVE WS-DATE-TEMP       TO WS-DATE-COMP(WS-K)       
                    MOVE WS-AMT-TEMP        TO WS-AMT-COMP(WS-K)        
                 END-IF                                                 
                 COMPUTE WS-K = WS-K + 1                                
              END-PERFORM                                               
           END-PERFORM.                                                 
      *                                                                         
           IF WS-DATE-COMP(1)                >  WS-CURRENT-DATE         
              MOVE WS-AMT-COMP(1)           TO RS-PLEDGE-AMT-4          
           END-IF.                                                      
      *                                                                         
           MOVE 'F'                TO RS-PLEDGE-DNP-STATE.              
      *                                                                         
       5930-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Evaluates Pleadge Amounts for SEB.                             *        
      ******************************************************************        
      *                                                                         
       5950-PLEDGE-SEB.                                                 
      *                                                                         
           MOVE 'Y'                       TO RS-PLEDGE-IND.             
           MOVE AT-COMPANY-NO             TO C8-COMPANY-NO.             
           MOVE 'N'                       TO RS-PLEDGE-DIM-IND.         
           PERFORM 5951-LOAD-DELINQUENCY  THRU 5951-EXIT.               
      *                                                                         
           IF (WS-DATE-CREDIT-ACTION-D     > WS-CURRENT-DATE   AND      
               WS-AMT-NOTICE-D             > 0)                OR       
              (WS-DATE-CREDIT-ACTION-G     > WS-CURRENT-DATE   AND      
               WS-AMT-NOTICE-G             > 0)                OR       
              (WS-DATE-CREDIT-ACTION-H     > WS-CURRENT-DATE   AND      
               WS-AMT-NOTICE-H             > 0)                OR       
              (WS-DATE-CREDIT-ACTION-I     > WS-CURRENT-DATE   AND      
               WS-AMT-NOTICE-I             > 0)                         
              MOVE 'F'                     TO RS-PLEDGE-DNP-STATE       
           ELSE                                                         
              IF WS-CODE-STA-ACCT = 'A'                                 
                 MOVE 'S'                     TO RS-PLEDGE-DNP-STATE    
              ELSE                                                      
                 MOVE SPACE                   TO RS-PLEDGE-DNP-STATE    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       5950-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Gets Delinquency values.                                       *        
      ******************************************************************        
      *                                                                         
       5951-LOAD-DELINQUENCY.                                           
      *                                                                         
           PERFORM 7810-OPEN-DELINQ-CURSOR  THRU 7810-EXIT.             
           PERFORM 7820-FETCH-DELINQ-CURSOR THRU 7820-EXIT              
              UNTIL NO-MORE-DATA-DELINQ.                                
           PERFORM 7830-CLOSE-DELINQ-CURSOR THRU 7830-EXIT.             
      *                                                                         
        5951-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * Selects Account Details.                                       *        
      ******************************************************************        
      *                                                                         
       7000-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                      AT.NOTICE_EXEMPT_CD                               
                     ,AT.CODE_DISC_OK                                   
                     ,AT.DATE_BILL_DAY_00                               
                     ,AT.DATE_BILL_DAY_30                               
                     ,AT.DATE_BILL_DAY_60                               
                     ,AT.DATE_BILL_DAY_90                               
                     ,AT.CODES_DATA_PRESENT                             
                     ,AT.COMPANY_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.BANKRUPTCY_IND                                 
                     ,AT.CREDIT_GROUP                                   
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.IVR_EXEMPT_CD                                  
                     ,AT.PREMISE_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.CODE_MAJOR_ACCT                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                
              INTO                                                      
                      :AT-NOTICE-EXEMPT-CD                              
                     ,:AT-CODE-DISC-OK                                  
                     ,:AT-DATE-BILL-DAY-00 :WS-NULL-1                    
                     ,:AT-DATE-BILL-DAY-30 :WS-NULL-2                    
                     ,:AT-DATE-BILL-DAY-60 :WS-NULL-3                    
                     ,:AT-DATE-BILL-DAY-90 :WS-NULL-4                    
                     ,:AT-CODES-DATA-PRESENT                            
                     ,:AT-COMPANY-NO                                    
                     ,:AT-LOCAL-OFFICE                                  
                     ,:AT-BANKRUPTCY-IND                                
                     ,:AT-CREDIT-GROUP                                  
                     ,:AT-CODE-ACCT-STAT                                
                     ,:AT-IVR-EXEMPT-CD                                 
                     ,:AT-PREMISE-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-CODE-MAJOR-ACCT                               
                     ,:AT-ACCT-FINALED-DT :WS-NULL-11                    
              FROM                                                      
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
              WHERE                                                     
                     AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*               AT.NOTICE_EXEMPT_CD                                       
MFA-TR*              ,AT.CODE_DISC_OK                                           
MFA-TR*              ,AT.DATE_BILL_DAY_00                                       
MFA-TR*              ,AT.DATE_BILL_DAY_30                                       
MFA-TR*              ,AT.DATE_BILL_DAY_60                                       
MFA-TR*              ,AT.DATE_BILL_DAY_90                                       
MFA-TR*              ,AT.CODES_DATA_PRESENT                                     
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.BANKRUPTCY_IND                                         
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.IVR_EXEMPT_CD                                          
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.CODE_MAJOR_ACCT                                        
MFA-TR*              ,AT.ACCT_FINALED_DT                                        
MFA-TR*       INTO                                                              
MFA-TR*               :AT-NOTICE-EXEMPT-CD                                      
MFA-TR*              ,:AT-CODE-DISC-OK                                          
MFA-TR*              ,:AT-DATE-BILL-DAY-00:WS-NULL-1                            
MFA-TR*              ,:AT-DATE-BILL-DAY-30:WS-NULL-2                            
MFA-TR*              ,:AT-DATE-BILL-DAY-60:WS-NULL-3                            
MFA-TR*              ,:AT-DATE-BILL-DAY-90:WS-NULL-4                            
MFA-TR*              ,:AT-CODES-DATA-PRESENT                                    
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:AT-BANKRUPTCY-IND                                        
MFA-TR*              ,:AT-CREDIT-GROUP                                          
MFA-TR*              ,:AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-IVR-EXEMPT-CD                                         
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-CODE-MAJOR-ACCT                                       
MFA-TR*              ,:AT-ACCT-FINALED-DT:WS-NULL-11                            
MFA-TR*       FROM                                                              
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*       WHERE                                                             
MFA-TR*              AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE             
                                      RS-RETURN-CODE.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-1          = -1                                
                  MOVE SPACES      TO AT-DATE-BILL-DAY-00               
              END-IF                                                    
              IF WS-NULL-2          = -1                                
                  MOVE SPACES      TO AT-DATE-BILL-DAY-30               
              END-IF                                                    
              IF WS-NULL-3          = -1                                
                  MOVE SPACES      TO AT-DATE-BILL-DAY-60               
              END-IF                                                    
              IF WS-NULL-4          = -1                                
                  MOVE SPACES      TO AT-DATE-BILL-DAY-90               
              END-IF                                                    
              IF AT-CODE-DISC-OK    = LOW-VALUES                        
                  MOVE SPACES      TO AT-CODE-DISC-OK                   
              END-IF                                                    
              IF WS-NULL-11         = -1                                
                  MOVE SPACES      TO AT-ACCT-FINALED-DT                
              END-IF                                                    
              MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT       
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Opens AR_CURSOR Cursor.                                        *        
      ******************************************************************        
      *                                                                         
       7010-OPEN-AR-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
                OPEN AR_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
                                              RS-RETURN-CODE            
              MOVE SQLSTATE                TO ABEND-SQLSTATE            
              MOVE '7010'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE 'CSS_AR_CNTL'           TO TABLE-1                   
              MOVE 'CSS_DFA_ACCT'          TO TABLE-2                   
              MOVE 'AC_ACCOUNT_NO'         TO TABLE-ELEMENT-1           
              MOVE 'DFA_ITEM_ID'           TO TABLE-ELEMENT-2           
              MOVE 'PYMT_PRIORITY_LVL'     TO TABLE-ELEMENT-3           
              MOVE AC-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE AC-ITEM-ID              TO HOSTVAR-ELEMENT-2         
              MOVE '90'                    TO HOSTVAR-ELEMENT-3         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Fetches AR_CURSOR Cursor.                                      *        
      ******************************************************************        
      *                                                                         
       7020-FETCH-AR-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                      AR_CURSOR                                         
                INTO                                                    
                      :AC-AMT-TRAN-BALANCE                              
                     ,:AC-ITEM-ID                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               EVALUATE TRUE                                            
                   WHEN AC-ITEM-ID >= 40000000                          
                        ADD AC-AMT-TRAN-BALANCE  TO RS-PLEDGE-AMT-3     
                   WHEN AC-ITEM-ID >= 30000000 AND AC-ITEM-ID < 40000000
                        MOVE AC-AMT-TRAN-BALANCE  TO RS-PLEDGE-AMT-2    
               END-EVALUATE                                             
             WHEN NOT-FOUND                                             
               MOVE 'Y'                    TO WS-NO-MORE-DATA-ARCUR     
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE SQLCODE                TO ABEND-SQLCODE             
                                              RS-RETURN-CODE            
               MOVE SQLSTATE               TO ABEND-SQLSTATE            
               MOVE '7020'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_AR_CNTL'          TO TABLE-1                   
               MOVE 'CSS_DFA_ACCT'         TO TABLE-2                   
               MOVE 'AC_ACCOUNT_NO'        TO TABLE-ELEMENT-1           
               MOVE 'DFA_ITEM_ID'          TO TABLE-ELEMENT-2           
               MOVE 'PYMT_PRIORITY_LVL'    TO TABLE-ELEMENT-3           
               MOVE AC-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               MOVE AC-ITEM-ID             TO HOSTVAR-ELEMENT-2         
               MOVE '90'                   TO HOSTVAR-ELEMENT-3         
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
           END-EVALUATE.                                                
      *                                                                         
       7020-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Closes AR_CURSOR Cursor.                                       *        
      ******************************************************************        
      *                                                                         
       7030-CLOSE-AR-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
                CLOSE AR_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE        = SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE SQLCODE                TO ABEND-SQLCODE              
                                             RS-RETURN-CODE             
              MOVE SQLSTATE               TO ABEND-SQLSTATE             
              MOVE '7030'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'CSS_AR_CNTL'          TO TABLE-1                    
              MOVE 'CSS_DFA_ACCT'         TO TABLE-2                    
              MOVE 'AC_ACCOUNT_NO'        TO TABLE-ELEMENT-1            
              MOVE 'DFA_ITEM_ID'          TO TABLE-ELEMENT-2            
              MOVE 'PYMT_PRIORITY_LVL'    TO TABLE-ELEMENT-3            
              MOVE AC-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE AC-ITEM-ID             TO HOSTVAR-ELEMENT-2          
              MOVE '90'                   TO HOSTVAR-ELEMENT-3          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Selects Reconnect Details.                                     *        
      ******************************************************************        
      *                                                                         
       7100-SELECT-RECONNECT.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                        DL.RECNCT_COLLECT_AMT                           
                       ,DL.AMT_TOT_RECONNECT                            
                       ,DL.AUTO_DEP_AM                                  
                       ,DL.AUTO_DEP_CERT_NO                             
                  INTO                                                  
                        :DL-RECNCT-COLLECT-AMT                          
                       ,:DL-AMT-TOT-RECONNECT                           
                       ,:DL-AUTO-DEP-AM                                 
                       ,:DL-AUTO-DEP-CERT-NO                            
                  FROM                                                  
                        CSS_RECONNECT  DL WITH(READUNCOMMITTED)                 
                  WHERE                                                 
                       DL.ACCOUNT_NO  = :DL-ACCOUNT-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 DL.RECNCT_COLLECT_AMT                                   
MFA-TR*                ,DL.AMT_TOT_RECONNECT                                    
MFA-TR*                ,DL.AUTO_DEP_AM                                          
MFA-TR*                ,DL.AUTO_DEP_CERT_NO                                     
MFA-TR*           INTO                                                          
MFA-TR*                 :DL-RECNCT-COLLECT-AMT                                  
MFA-TR*                ,:DL-AMT-TOT-RECONNECT                                   
MFA-TR*                ,:DL-AUTO-DEP-AM                                         
MFA-TR*                ,:DL-AUTO-DEP-CERT-NO                                    
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_RECONNECT  DL                                       
MFA-TR*           WHERE                                                         
MFA-TR*                DL.ACCOUNT_NO  = :DL-ACCOUNT-NO                          
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y'                 TO WS-RECONNECT-EXISTS      
               WHEN NOT-FOUND                                           
                   MOVE 'N'                 TO WS-RECONNECT-EXISTS      
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7100'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_RECONNECT'       TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00726*                                                                         
P00726******************************************************************        
P00726* Selects the credit arangement details.                         *        
P00726******************************************************************        
P00726*                                                                         
P00726 7305-SELECT-CRED-ARNG.                                           
P00726*                                                                         
P00726     EXEC SQL                                                     
P00726          SELECT TOP(1) X1.ARNG_SETUP_DT,
              X1.ARNG_DNP_DT                                   
P00726          INTO                                                    
P00726                 :X1-ARNG-SETUP-DT :WS-NULL-5                      
P00726                ,:X1-ARNG-DNP-DT :WS-NULL-6                        
P00726          FROM                                                    
P00726                 CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)               
P00726          WHERE                                                   
P00726                 X1.ACCOUNT_NO      = :X1-ACCOUNT-NO              
P00726            AND  X1.ARNG_STATUS_CD  = 'A'                         
P00726                                              
P00726                                                           
P00726                                                      
P00726     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                X1.ARNG_SETUP_DT                                         
MFA-TR*               ,X1.ARNG_DNP_DT                                           
MFA-TR*         INTO                                                            
MFA-TR*                :X1-ARNG-SETUP-DT:WS-NULL-5                              
MFA-TR*               ,:X1-ARNG-DNP-DT:WS-NULL-6                                
MFA-TR*         FROM                                                            
MFA-TR*                CSS_CRED_ARNGMENT X1                                     
MFA-TR*         WHERE                                                           
MFA-TR*                X1.ACCOUNT_NO      = :X1-ACCOUNT-NO                      
MFA-TR*           AND  X1.ARNG_STATUS_CD  = 'A'                                 
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7305                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726*                                                                         
P00726     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00726*                                                                         
P00726     IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL OR        
P00726                                        NOT-FOUND                 
P00726        IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL        
P00726           IF WS-NULL-5 = -1                                      
P00726              MOVE SPACES               TO X1-ARNG-SETUP-DT       
P00726           ELSE                                                   
P00726              MOVE X1-ARNG-SETUP-DT(1:4)       TO WS-YYYY         
P00726              MOVE X1-ARNG-SETUP-DT(6:2)       TO WS-MM           
P00726              MOVE X1-ARNG-SETUP-DT(9:2)       TO WS-DD           
P00726              MOVE WS-DATE-FORMAT              TO X1-ARNG-SETUP-DT
P00726           END-IF                                                 
P00726           IF WS-NULL-6 = -1                                      
P00726              MOVE SPACES               TO WS-NEXT-DNP-DATE       
P00726           ELSE                                                   
P00726              MOVE X1-ARNG-DNP-DT(1:4)         TO WS-YYYY         
P00726              MOVE X1-ARNG-DNP-DT(6:2)         TO WS-MM           
P00726              MOVE X1-ARNG-DNP-DT(9:2)         TO WS-DD           
P00726              MOVE WS-DATE-FORMAT              TO WS-NEXT-DNP-DATE
P00726           END-IF                                                 
P00726        END-IF                                                    
P00726     ELSE                                                         
P00726        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
P00726        MOVE SQLCODE                 TO ABEND-SQLCODE             
P00726        MOVE SQLSTATE                TO ABEND-SQLSTATE            
P00726        MOVE '7305'                  TO ACTIVE-PARAGRAPH          
P00726        MOVE 'SELECT'                TO ABEND-FUNCTION            
P00726        MOVE 'CSS_CRED_ARNGMENT'     TO TABLE-1                   
P00726        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
P00726        MOVE 'ARNG_STATUS_CD'        TO TABLE-ELEMENT-2           
P00726        MOVE  X1-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
P00726        MOVE  'A'                    TO HOSTVAR-ELEMENT-2         
P00726        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
P00726     END-IF.                                                      
P00726*                                                                         
P00726 7305-EXIT.                                                       
P00726      EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Selects Auto Deposit Details.                                  *        
      ******************************************************************        
      *                                                                         
       7310-GET-AUTO-DEP.                                               
      *                                                                         
           MOVE 'N'                  TO WS-BILL-IMMED-EXISTS-FL.        
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       'Y'                                              
                INTO                                                    
                       :WS-BILL-IMMED-EXISTS-FL                         
                FROM                                                    
                       CSS_DEP_ON_HAND AS DO WITH(READUNCOMMITTED)              
                      ,CSS_DEP_REQ        DR WITH(READUNCOMMITTED)              
                WHERE                                                   
                       DO.ACCOUNT_NO          = :DO-ACCOUNT-NO          
                  AND  DR.ACCOUNT_NO          = :DR-ACCOUNT-NO          
                  AND  DO.DEPOSIT_CERT_NO     = :DO-DEPOSIT-CERT-NO     
                  AND  DR.DEP_ITEM_ID         = :DR-DEP-ITEM-ID         
                  AND  DO.CODE_DEP_TYPE       = 'B'                     
                  AND  DR.PYMT_PRIORITY_LVL   = 80                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*         INTO                                                            
MFA-TR*                :WS-BILL-IMMED-EXISTS-FL                                 
MFA-TR*         FROM                                                            
MFA-TR*                CSS_DEP_ON_HAND AS DO                                    
MFA-TR*               ,CSS_DEP_REQ        DR                                    
MFA-TR*         WHERE                                                           
MFA-TR*                DO.ACCOUNT_NO          = :DO-ACCOUNT-NO                  
MFA-TR*           AND  DR.ACCOUNT_NO          = :DR-ACCOUNT-NO                  
MFA-TR*           AND  DO.DEPOSIT_CERT_NO     = :DO-DEPOSIT-CERT-NO             
MFA-TR*           AND  DR.DEP_ITEM_ID         = :DR-DEP-ITEM-ID                 
MFA-TR*           AND  DO.CODE_DEP_TYPE       = 'B'                             
MFA-TR*           AND  DR.PYMT_PRIORITY_LVL   = 80                              
MFA-TR*          WITH UR                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.          
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND    
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE SQLCODE                   TO ABEND-SQLCODE          
                                                 RS-RETURN-CODE         
               MOVE SQLSTATE                  TO ABEND-SQLSTATE         
               MOVE '7310'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_DEP_ON_HAND'         TO TABLE-1                
               MOVE 'CSS_DEP_REQ'             TO TABLE-2                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'DEPOSIT_CERT_NO'         TO TABLE-ELEMENT-2        
               MOVE 'DEP_ITEM_ID'             TO TABLE-ELEMENT-3        
               MOVE DO-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE DO-DEPOSIT-CERT-NO        TO HOSTVAR-ELEMENT-2      
               MOVE DR-DEP-ITEM-ID            TO HOSTVAR-ELEMENT-3      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
            END-IF.                                                     
      *                                                                         
       7310-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Selects Deposit Amount from AR Control.                        *        
      ******************************************************************        
      *                                                                         
       7320-GET-AMT-ADEP-BAL.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       SUM(AC.AMT_AR_DAY_00 +                           
                           AC.AMT_AR_DAY_30 +                           
                           AC.AMT_AR_DAY_60 +                           
                           AC.AMT_AR_DAY_90)                            
                  INTO                                                  
                        :WS-ADEP-BALANCE :WS-NULL-10                     
                  FROM                                                  
                        CSS_AR_CNTL AC WITH(READUNCOMMITTED)                    
                 WHERE                                                  
                        AC.ACCOUNT_NO        = :AC-ACCOUNT-NO           
                   AND  AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL    
                   AND  AC.ITEM_ID           = :AC-ITEM-ID              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                SUM(AC.AMT_AR_DAY_00 +                                   
MFA-TR*                    AC.AMT_AR_DAY_30 +                                   
MFA-TR*                    AC.AMT_AR_DAY_60 +                                   
MFA-TR*                    AC.AMT_AR_DAY_90)                                    
MFA-TR*           INTO                                                          
MFA-TR*                 :WS-ADEP-BALANCE:WS-NULL-10                             
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_AR_CNTL AC                                          
MFA-TR*          WHERE                                                          
MFA-TR*                 AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                   
MFA-TR*            AND  AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL            
MFA-TR*            AND  AC.ITEM_ID           = :AC-ITEM-ID                      
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF  WS-NULL-10               < ZERO                      
                   MOVE ZEROES             TO WS-ADEP-BALANCE           
                                              WS-NULL-10                
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE SQLCODE                TO ABEND-SQLCODE             
                                              RS-RETURN-CODE            
               MOVE SQLSTATE               TO ABEND-SQLSTATE            
               MOVE '7320'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_AR_CNTL'          TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE 'PYMT_PRIORITY_LVL'    TO TABLE-ELEMENT-2           
               MOVE 'ITEM_ID'              TO TABLE-ELEMENT-3           
               MOVE AC-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               MOVE AC-PYMT-PRIORITY-LVL   TO HOSTVAR-ELEMENT-2         
               MOVE AC-ITEM-ID             TO HOSTVAR-ELEMENT-3         
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
            END-IF.                                                     
      *                                                                         
        7320-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Selects Medical Certificate Details.                           *        
      ******************************************************************        
      *                                                                         
       7600-SELECT-MEDCERT.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                         CA.DATE_ALERT                                  
                        ,CA.DATE_EXPIRE                                 
                  INTO                                                  
                         :CA-DATE-ALERT :WS-NULL-7                       
                        ,:CA-DATE-EXPIRE :WS-NULL-8                      
                  FROM                                                  
                         CSS_CUST_ALERT CA WITH(READUNCOMMITTED)                
                  WHERE                                                 
                         CA.ACCOUNT_NO       = :CA-ACCOUNT-NO           
                    AND  CA.CODE_ALERT_TYPE  = 'M'                      
                    AND  CA.DATE_EXPIRE     >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                  CA.DATE_ALERT                                          
MFA-TR*                 ,CA.DATE_EXPIRE                                         
MFA-TR*           INTO                                                          
MFA-TR*                  :CA-DATE-ALERT:WS-NULL-7                               
MFA-TR*                 ,:CA-DATE-EXPIRE:WS-NULL-8                              
MFA-TR*           FROM                                                          
MFA-TR*                  CSS_CUST_ALERT CA                                      
MFA-TR*           WHERE                                                         
MFA-TR*                  CA.ACCOUNT_NO       = :CA-ACCOUNT-NO                   
MFA-TR*             AND  CA.CODE_ALERT_TYPE  = 'M'                              
MFA-TR*             AND  CA.DATE_EXPIRE     >= :WS-CURRENT-DATE                 
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL OR        
                                              NOT-FOUND                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE SQLSTATE                TO ABEND-SQLSTATE            
              MOVE '7600'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_CUST_ALERT'        TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_ALERT_TYPE'       TO TABLE-ELEMENT-2           
              MOVE 'DATE_EXPIRE'           TO TABLE-ELEMENT-3           
              MOVE  CA-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
              MOVE  CA-CODE-ALERT-TYPE     TO HOSTVAR-ELEMENT-2         
              MOVE  WS-CURRENT-DATE        TO HOSTVAR-ELEMENT-3         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Opens DELINQ_CURSOR Cursor.                                    *        
      ******************************************************************        
      *                                                                         
       7810-OPEN-DELINQ-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
                OPEN DELINQ_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7810'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Fetches DELINQ_CURSOR Cursor.                                  *        
      ******************************************************************        
      *                                                                         
       7820-FETCH-DELINQ-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                      DELINQ_CURSOR                                     
                 INTO                                                   
                      :C8-DELINQ-CD                                     
                     ,:C8-DELINQ-VALUE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  MOVE C8-DELINQ-VALUE          TO WS-HOLD-DEL-VALUE    
                  EVALUATE C8-DELINQ-CD                                 
                     WHEN 'PLEDGE-AMT-1'                                
                        MOVE WS-HOLD-DEL-VALUE  TO RS-PLEDGE-AMT-1      
                     WHEN 'PLEDGE-AMT-2'                                
                        MOVE WS-HOLD-DEL-VALUE  TO RS-PLEDGE-AMT-2      
                     WHEN 'PLEDGE-AMT-3'                                
                        MOVE WS-HOLD-DEL-VALUE  TO RS-PLEDGE-AMT-3      
                     WHEN 'PLEDGE-AMT-4'                                
                        MOVE WS-HOLD-DEL-VALUE  TO RS-PLEDGE-AMT-4      
                     WHEN 'PLEDGE-AMT-5'                                
                        MOVE WS-HOLD-DEL-VALUE  TO RS-PLEDGE-AMT-5      
                     WHEN 'PLEDGE-AMT-6'                                
                        MOVE WS-HOLD-DEL-VALUE  TO RS-PLEDGE-AMT-6      
                  END-EVALUATE                                          
               WHEN NOT-FOUND                                           
                  MOVE 'Y'                      TO                      
                                                 WS-NO-MORE-DATA-DELINQ 
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME             TO ABEND-PROGRAM        
                  MOVE SQLCODE                  TO ABEND-SQLCODE        
                  MOVE SQLSTATE                 TO ABEND-SQLSTATE       
                  MOVE '7820'                   TO ACTIVE-PARAGRAPH     
                  MOVE 'FETCH'                  TO ABEND-FUNCTION       
                  MOVE 'CSS_DELINQUENCY'        TO TABLE-1              
                  MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1      
                  MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-1    
                  PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT          
               END-EVALUATE.                                            
      *                                                                         
       7820-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Closes DELINQ_CURSOR Cursor.                                   *        
      ******************************************************************        
      *                                                                         
       7830-CLOSE-DELINQ-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
                CLOSE DELINQ_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7830'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7830-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00180******************************************************************        
P00180* SELECTS WRITE OFF AMT DETAILS.                                 *        
P00180******************************************************************        
P00180*                                                                         
P00180 7850-SELECT-WO-BAL.                                              
P00180*                                                                         
P00180     EXEC SQL                                                     
P00180          SELECT                                                  
P00180                   SUM(CO.AMT_TRANS)                              
P00180                  ,CO.DATE_OF_CHG_OFF                             
P00180            INTO                                                  
P00180                   :CO-AMT-TRANS :WS-NULL-12                       
P00180                  ,:CO-DATE-OF-CHG-OFF :WS-NULL-13                 
P00180            FROM                                                  
P00180                   CSS_CHRG_OFF CO WITH(READUNCOMMITTED)                  
P00180                  ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                   
P00180            WHERE                                                 
P00180                   CO.ACCOUNT_NO       = :CO-ACCOUNT-NO           
P00180              AND  AT.ACCOUNT_NO       = CO.ACCOUNT_NO            
P00180              AND  CAST(AT.ACCT_FINALED_DT AS DATE) > 
              IIF(TRY_CONVERT(DATE, :WS-CUT-OFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CUT-OFF-DATE
              ) <> 0) OR (LEN(:WS-CUT-OFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CUT-OFF-DATE
              ), CONVERT(DATE, :WS-CUT-OFF-DATE) )    
P00180            GROUP BY CO.DATE_OF_CHG_OFF                           
P00180                                                           
P00180     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                  SUM(CO.AMT_TRANS)                                      
MFA-TR*                 ,CO.DATE_OF_CHG_OFF                                     
MFA-TR*           INTO                                                          
MFA-TR*                  :CO-AMT-TRANS:WS-NULL-12                               
MFA-TR*                 ,:CO-DATE-OF-CHG-OFF:WS-NULL-13                         
MFA-TR*           FROM                                                          
MFA-TR*                  CSS_CHRG_OFF CO                                        
MFA-TR*                 ,CSS_ACCOUNT AT                                         
MFA-TR*           WHERE                                                         
MFA-TR*                  CO.ACCOUNT_NO       = :CO-ACCOUNT-NO                   
MFA-TR*             AND  AT.ACCOUNT_NO       = CO.ACCOUNT_NO                    
MFA-TR*             AND  DATE(AT.ACCT_FINALED_DT) > :WS-CUT-OFF-DATE            
MFA-TR*           GROUP BY CO.DATE_OF_CHG_OFF                                   
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00180*                                                                         
P00180     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00180*                                                                         
P00180     IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL OR        
P00180                                        NOT-FOUND                 
P00180        IF WS-NULL-12     = -1                                    
P00180           MOVE ZEROS     TO  CO-AMT-TRANS                        
P00180        END-IF                                                    
P00180        IF WS-NULL-13     = -1                                    
P00180           MOVE SPACES    TO  CO-DATE-OF-CHG-OFF                  
P00180        END-IF                                                    
P00180     ELSE                                                         
P00180        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
P00180        MOVE SQLCODE                 TO ABEND-SQLCODE             
P00180        MOVE SQLSTATE                TO ABEND-SQLSTATE            
P00180        MOVE '7850'                  TO ACTIVE-PARAGRAPH          
P00180        MOVE 'SELECT'                TO ABEND-FUNCTION            
P00180        MOVE 'CSS_CHRG_OFF'          TO TABLE-1                   
P00180        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
P00180        MOVE  CO-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
P00180        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
P00180     END-IF.                                                      
P00180*                                                                         
P00180 7850-EXIT.                                                       
P00180      EXIT.                                                       
      *                                                                         
P00180******************************************************************        
P00180* SELECT WO-CUTOFF-DT FROM DELINQUENCY TABLE.                    *        
P00180******************************************************************        
P00180*                                                                         
P00180 7900-SEL-WO-CUTOFF-DT.                                           
P00180*                                                                         
P00180     EXEC SQL                                                     
P00180          SELECT                                                  
P00180                  C8.DELINQ_VALUE                                 
P00180            INTO                                                  
P00180                  :WS-CUTOFF-DELINQ-VALUE                         
P00180            FROM                                                  
P00180                  CSS_DELINQUENCY C8                              
P00180           WHERE                                                  
P00180                  C8.DELINQ_CD   = :C8-DELINQ-CD                  
P00180             AND  C8.COMPANY_NO  = :C8-COMPANY-NO                 
P00180     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00180*                                                                         
P00180     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00180*                                                                         
P00180     IF WS-ACTIVE-RETURN-CODE         = SUCCESSFUL-CALL OR        
P00180                                      NOT-FOUND                   
P00180        NEXT SENTENCE                                             
P00180     ELSE                                                         
P00180             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
P00180             MOVE SQLCODE               TO ABEND-SQLCODE          
P00180             MOVE SQLSTATE              TO ABEND-SQLSTATE         
P00180             MOVE '7900'                TO ACTIVE-PARAGRAPH       
P00180             MOVE 'SELECT'              TO ABEND-FUNCTION         
P00180             MOVE SPACES                TO ABEND-SQL-PREDICATES   
P00180                                           ABEND-TABLES           
P00180             MOVE 'CSS_DELINQUENCY'     TO TABLE-1                
P00180             MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1        
P00180             MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2        
P00180             MOVE 'WO-CUTOFF-DT'        TO HOSTVAR-ELEMENT-1      
P00180             MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2      
P00180             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00180     END-IF.                                                      
P00180*                                                                         
P00180 7900-EXIT.                                                       
P00180       EXIT.                                                      
      *                                                                         
P00180******************************************************************        
P00180* CALCULATE CUTOFF DATE.                                         *        
P00180******************************************************************        
P00180*                                                                         
P00180 7950-CALC-CUTOFF-DATE.                                           
P00180*                                                                         
P00180     EXEC SQL                                                     
P00180          SELECT
              DATEADD( YEAR, -:WS-CUTOFF-DELINQ-VALUE, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CUT-OFF-DATE    
P00180     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CUT-OFF-DATE =                                          
MFA-TR*                 CURRENT DATE - :WS-CUTOFF-DELINQ-VALUE YEARS            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
P00180*                                                                         
P00180 7950-EXIT.                                                       
P00180      EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Increments Row Counter.                                        *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
              ADD +1                     TO  CTR-ROWS.                  
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Calls WS-MCSCB068 as part of CPD00068 process.                 *        
      ******************************************************************        
      *                                                                         
       9500-CALL-CPD00068.                                              
      *                                                                         
           CALL WS-MCSCB068  USING CWS00068-FIELDS                      
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
      *                                                                         
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE              
                                             SQLCODE.                   
      *                                                                         
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                  TO RS-RETURN-CODE             
                                             WS-ACTIVE-RETURN-CODE      
              END-IF                                                    
              PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       9500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                       Program Copy Books                       *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9700-PROCESS-ABEND                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023C                                                
           END-EXEC.                                                            
      *                                                                         
      *    EXEC SQL                                                             
      *         INCLUDE CPD00068                                                
      *    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                  SQL Error Processing Copy Book                *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
