       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03728.                                     
COB303 DATE-WRITTEN. JANUARY 3, 2006.                                   
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03728              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03728 :                                                --         
      *--                                                            --         
      *--  THIS PROGRAM INSERTS, DELETES, OR UPDATES A ROW IN                   
      *--  CSS_ACCT_ATTRIBUTE BASED UPON THE VALUE IN THE                       
P00245*--  WS-ACTION-CODE (ONLY 'I', 'D' AND 'W'      AT PRESENT)               
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--            ACTION_CODE           CHAR(01)                  --         
      *--            SEB_ACCOUNT_NO        CHAR(13)                  --         
      *--            EFF_SWITCH_DATE       CHAR(10)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
C33603*--  01/03/2006    SS19371     NEW CODE                        --         
      *--  08/29/2006    SS19371     CORRECT SELECT TO AVOID -811    --         
P00245*--  01/04/2010    SS19371     ADD NEW ATTRIBUTE FOR ORIS 12TO --         
P00245*--                            TO INDICATE EST. TURN-ON DATE   --         
P00245*--                            FOR WELCOME KITS.               --         
A02373*--  04/30/2010    DB18339     CHANGE TO PARA 8000 TO FIX -803 --         
      *----------------------------------------------------------------         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03728'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03728 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_ACCT_ATTRIBUTE, YP                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MKT_XREF_ACCT, XM                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMRKXR                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MODEL_SQL, MS                                                    
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DB2 AND SQL ERROR CHECKING                                           
      *****************************************************************         
           COPY CWS00303.                                                       
                                                                        
      *****************************************************************         
      *    DB2SP COMMON VARIABLES                                               
      *****************************************************************         
           COPY CWSSP001.                                                       
                                                                        
      *****************************************************************         
      *    ERROR HANDLING COPY BOOK                                             
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
       01  WS-INPUT-VARIABLES.                                          
           05  WS-ACTION-CODE        PIC X(01).                         
           05  WS-SEB-ACCOUNT-NO     PIC X(13) VALUE SPACES.            
           05  WS-EFF-SWITCH-DATE.                                      
               10  WS-ESD-YEAR       PIC X(04).                         
               10  WS-ESD-D1         PIC X(01) VALUE '-'.               
               10  WS-ESD-MONTH      PIC X(02).                         
               10  WS-ESD-D2         PIC X(01) VALUE '-'.               
               10  WS-ESD-DAY        PIC X(02).                         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE          PIC S9(9) VALUE 0 COMP.            
                                                                        
       01  WS-MISC.                                                     
           05  WS-DATABASE           PIC 9(01) VALUE ZEROS.             
               88  CSR-DATABASE                VALUE 1.                 
               88  SEB-DATABASE                VALUE 2.                 
           05  WS-ACCOUNT-NO         PIC 9(13).                         
                                                                        
       01  WS-SWITCHES.                                                 
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                PIC X(08) VALUE 'CSR03728'.  
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  IN-ACTION-CODE                PIC X(01).                     
       01  IN-SEB-ACCOUNT-NO             PIC X(13).                     
       01  IN-EFF-SWITCH-DATE            PIC X(10).                     
                                                                        
       PROCEDURE DIVISION USING IN-ACTION-CODE,                         
                                IN-SEB-ACCOUNT-NO,                      
                                IN-EFF-SWITCH-DATE.                     
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                           
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                               
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                                         
      *     1. RESET DB2 ERROR HANDLERS                                         
      *     2. ESTABLISH RETURN CURSOR AND VARIABLES                            
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT :S-RETURN-CODE      AS RETURN_CODE                  
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                                   
MFA-TR*      SELECT :S-RETURN-CODE      AS RETURN_CODE                          
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-PROCESS-INPUT                                                      
      *     1. RECEIVE PARMS.                                                   
      *     2. CALCULATE NEEDED VARIABLES.                                      
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF IN-ACTION-CODE > SPACES                                   
              MOVE IN-ACTION-CODE TO WS-ACTION-CODE                     
           ELSE                                                         
              MOVE 'ACTION_CODE'  TO TABLE-ELEMENT-1                    
              MOVE IN-ACTION-CODE TO HOSTVAR-ELEMENT-1                  
              PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           END-IF.                                                      
                                                                        
           IF IN-SEB-ACCOUNT-NO > SPACES                                
           AND IN-SEB-ACCOUNT-NO NUMERIC                                
              MOVE IN-SEB-ACCOUNT-NO TO WS-ACCOUNT-NO                   
              MOVE WS-ACCOUNT-NO     TO XM-ACCOUNT-NO                   
           ELSE                                                         
              MOVE 'SEB_ACCOUNT_NO'  TO TABLE-ELEMENT-1                 
              MOVE IN-SEB-ACCOUNT-NO TO HOSTVAR-ELEMENT-1               
              PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           END-IF.                                                      
                                                                        
           IF IN-EFF-SWITCH-DATE > SPACES                               
              MOVE IN-EFF-SWITCH-DATE TO WS-EFF-SWITCH-DATE             
           ELSE                                                         
              MOVE IN-EFF-SWITCH-DATE TO HOSTVAR-ELEMENT-1              
              PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           END-IF.                                                      
                                                                        
           ADD +1 TO CTR-ROWS.                                          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                                    
      *     1. CHECK ACTION CD                                                  
      *     2. PERFORM INSERT OR DELETE                                         
      *     3. UPDATE DB2 DATA                                                  
      *     4. BUILD RESULT SET                                                 
      *     5. SEND RESULT SET                                                  
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF WS-ACTION-CODE = 'D'                                      
              PERFORM 2200-DELETE-ATTRIBUTE THRU 2200-EXIT              
           ELSE                                                         
              PERFORM 2100-INSERT-ATTRIBUTE THRU 2100-EXIT              
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2100-INSERT-ATTRIBUTE.                                        *         
      *    1. GET THE ORIGINATION_CD AND COMPANY_NO FROM              *         
      *       CSS_MKT_XREF_ACCT                                       *         
      *    2. INSERT ROW IN CSS_ACCT_ATTRIBUTE WITH EFFECTIVE SWITCH  *         
      *       DATE AND ORIGINAL ORIGINATION-CD                        *         
      *    3. UPDATE ORIGNATION-CD IN CSS_MKT_XREF_ACCT TO 'F'        *         
      *****************************************************************         
       2100-INSERT-ATTRIBUTE.                                           
                                                                        
           MOVE '2100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 7000-ORIG-FOR-INSERT  THRU 7000-EXIT.                
                                                                        
           MOVE XM-ACCOUNT-NO     TO YP-ACCOUNT-NO                      
P00245     IF WS-ACTION-CODE = 'W'                                      
P00245        MOVE 'ORDER_EFF_DT' TO YP-ATTRIBUTE-DESC                  
P00245     ELSE                                                         
              MOVE 'EFF_SWITCH_DT'   TO YP-ATTRIBUTE-DESC               
P00245     END-IF.                                                      
           MOVE 'YES'             TO YP-ATTRIBUTE-VALUE-CD              
           MOVE 1                 TO YP-ATTRIBUTE-VALUE-TX-LEN          
           MOVE XM-ORIGINATION-CD TO YP-ATTRIBUTE-VALUE-TX-TEXT         
           MOVE WS-EFF-SWITCH-DATE TO YP-ATTRIBUTE-VALUE-DT             
           PERFORM 8000-INSERT-ACCT-ATTRIBUTE THRU 8000-EXIT.           
                                                                        
P00245*ONLY UPDATE THE ORIGINATION CD FOR THE ORIS 12 FR                        
P00245     IF WS-ACTION-CODE = 'I'                                      
              MOVE 'F' TO XM-ORIGINATION-CD                             
              PERFORM 8200-UPDATE-ORIG-CD THRU 8200-EXIT                
P00245     END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2200-DELETE-ATTRIBUTE.                                                  
      *      1. GET THE ORIGINAL ORIGINATION-CD FROM CSS_ACCT_ATTRIBUTE         
      *      2. DELETE ROW IN CSS_ACCT_ATTRIBUTE                                
      *      3. UPDATE ORIGNATION-CD IN CSS_MKT_XREF_ACCT TO ORIG VALUE         
      *****************************************************************         
       2200-DELETE-ATTRIBUTE.                                           
                                                                        
           MOVE '2100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 7100-ORIG-FOR-DELETE  THRU 7100-EXIT.                
                                                                        
           MOVE XM-ACCOUNT-NO     TO YP-ACCOUNT-NO                      
           MOVE 'EFF_SWITCH_DT'   TO YP-ATTRIBUTE-DESC                  
           PERFORM 8100-DELETE-ACCT-ATTRIBUTE                           
                                                                        
           MOVE YP-ATTRIBUTE-VALUE-TX-TEXT TO XM-ORIGINATION-CD         
           PERFORM 8200-UPDATE-ORIG-CD THRU 8200-EXIT.                  
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7000-ORIG-FOR-INSERT.                                       *           
      *     FETCH DETAILS FROM THE MKT_XREF_ACCT TABLE              *           
      ***************************************************************           
       7000-ORIG-FOR-INSERT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT XM.COMPANY_NO,                                     
                     XM.ORIGINATION_CD                                  
                INTO :XM-COMPANY-NO                                     
                    ,:XM-ORIGINATION-CD                                 
                FROM CSS_MKT_XREF_ACCT XM                               
               WHERE XM.ACCOUNT_NO = :XM-ACCOUNT-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_MKT_XREF_ACCT' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE XM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7100-ORIG-FOR-DELETE.                                       *           
      *     FETCH DETAILS FROM THE MKT_XREF_ACCT TABLE              *           
      ***************************************************************           
       7100-ORIG-FOR-DELETE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT YP.ATTRIBUTE_VALUE_TX,                             
                     XM.ACCOUNT_NO,                                     
                     XM.COMPANY_NO                                      
                INTO :YP-ATTRIBUTE-VALUE-TX,                            
                     :XM-ACCOUNT-NO,                                    
                     :XM-COMPANY-NO                                     
                FROM CSS_ACCT_ATTRIBUTE YP,                             
                     CSS_MKT_XREF_ACCT XM                               
               WHERE XM.ACCOUNT_NO = :XM-ACCOUNT-NO                     
                 AND YP.ACCOUNT_NO = XM.ACCOUNT_NO                      
                 AND YP.ATTRIBUTE_DESC = 'EFF_SWITCH_DT'                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_MKT_XREF_ACCT' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE XM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7200-GET-CURRENT-DATE                                       *           
      ***************************************************************           
       7200-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :YP-ATTRIBUTE-VALUE-DT                             
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT DATE                                               
MFA-TR*         INTO :YP-ATTRIBUTE-VALUE-DT                                     
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_MODEL_SQL'     TO TABLE-1                       
              MOVE 'CURRENT DATE'      TO TABLE-ELEMENT-1               
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  35210000
      * 8000-INSERT-ACCT-ATTRIBUTE                                   *  35220000
      *     INSERT ROW INTO CSS_ACCT_ATTRIBUTE                       *  35290000
      ****************************************************************  35300000
       8000-INSERT-ACCT-ATTRIBUTE.                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_ATTRIBUTE                            
                     ( ACCOUNT_NO                                       
                      ,ATTRIBUTE_DESC                                   
                      ,ATTRIBUTE_VALUE_CD                               
                      ,ATTRIBUTE_VALUE_DT                               
                      ,ATTRIBUTE_VALUE_TX   )                           
              VALUES (:YP-ACCOUNT-NO                                    
                     ,:YP-ATTRIBUTE-DESC                                
                     ,:YP-ATTRIBUTE-VALUE-CD                            
                     ,IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )                       
                     ,:YP-ATTRIBUTE-VALUE-TX )                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     35360000
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                                    
MFA-TR*              ( ACCOUNT_NO                                               
MFA-TR*               ,ATTRIBUTE_DESC                                           
MFA-TR*               ,ATTRIBUTE_VALUE_CD                                       
MFA-TR*               ,ATTRIBUTE_VALUE_DT                                       
MFA-TR*               ,ATTRIBUTE_VALUE_TX   )                                   
MFA-TR*       VALUES (:YP-ACCOUNT-NO                                            
MFA-TR*              ,:YP-ATTRIBUTE-DESC                                        
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-DT                                    
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-TX )                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
A02373     IF WS-ACTIVE-RETURN-CODE = ALREADY-EXISTS                    
A02373       PERFORM 8300-UPDATE-ACCT-ATTRIBUTE THRU 8300-EXIT          
A02373       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
A02373                       S-RETURN-CODE                              
A02373     ELSE IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL          
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-2              
              MOVE YP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE YP-ATTRIBUTE-DESC    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8100-DELETE-ACCT-ATTRIBUTE                                  *           
      *   DELETE RECORD FROM CSS_ACCT_ATTRIBUTE.                    *           
      ***************************************************************           
       8100-DELETE-ACCT-ATTRIBUTE.                                      
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ACCT_ATTRIBUTE                            
               WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                        
                 AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-2              
              MOVE YP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE YP-ATTRIBUTE-DESC    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8200-UPDATE-ORIG-CD.                                        *           
      *   UPDATE ORIGINATION-CD IN CSS_MKT_XREF_ACCT.               *           
      ***************************************************************           
       8200-UPDATE-ORIG-CD.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_MKT_XREF_ACCT                                  
                 SET ORIGINATION_CD     = :XM-ORIGINATION-CD            
               WHERE ACCOUNT_NO         = :XM-ACCOUNT-NO                
                 AND COMPANY_NO         = :XM-COMPANY-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '8200'              TO ACTIVE-PARAGRAPH              
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE 'CSS_MKT_XREF_ACCT' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-2               
              MOVE XM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE XM-COMPANY-NO       TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02373***************************************************************           
A02373* 8300-UPDATE-ACCT-ATTRIBUTE.                                 *           
A02373*   UPDATE ATTRIB VALUE DT IN CSS_ACCT_ATTRIBUTE              *           
A02373***************************************************************           
A02373 8300-UPDATE-ACCT-ATTRIBUTE.                                      
A02373                                                                  
A02373     EXEC SQL                                                     
A02373        UPDATE CSS_ACCT_ATTRIBUTE                                 
A02373          SET ATTRIBUTE_VALUE_DT = IIF(TRY_CONVERT(DATE, 
                                                 :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )         
A02373        WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                 
A02373          AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC             
A02373     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_ATTRIBUTE                                         
MFA-TR*         SET ATTRIBUTE_VALUE_DT = :YP-ATTRIBUTE-VALUE-DT                 
MFA-TR*       WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                         
MFA-TR*         AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02373                                                                  
A02373     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
A02373                     S-RETURN-CODE.                               
A02373                                                                  
A02373     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02373        MOVE '8300'              TO ACTIVE-PARAGRAPH              
A02373        MOVE SPACES              TO ABEND-TABLES                  
A02373        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A02373        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A02373        MOVE 'UPDATE'            TO ABEND-FUNCTION                
A02373        MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
A02373        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
A02373        MOVE YP-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
A02373        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A02373        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A02373     END-IF.                                                      
A02373                                                                  
A02373 8300-EXIT.                                                       
A02373     EXIT.                                                        
                                                                        
      *************************************************************             
      * 9500-INPUT-ABEND.                                                       
      *  PERFORMS ABEND WHEN INVALID INPUT                                      
      *************************************************************             
       9500-INPUT-ABEND.                                                
                                                                        
           MOVE PROGRAM-NAME    TO ABEND-PROGRAM                        
           MOVE 'RECEIVE INPUT' TO ABEND-FUNCTION                       
           MOVE +1000           TO WS-ACTIVE-RETURN-CODE                
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT               
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      * 8900-SEND-DONE.                                                         
      * 9000-SEND-ERROR-RESULT.                                                 
      * 9999-END-PROGRAM.                                                       
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      * 9900-SQL-ERROR-ROUTINE.                                                 
      * 9975-ABEND-CONTROL-TRANSFER.                                            
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
