       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03710.                                         
COB303 DATE-WRITTEN.     JULY 17, 2006.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      *  RETRIEVES CREDIT ARRACNGEMENT DETAILS BASED ON ACCOUNT NO     *00090000
      *  INVOKED FROM SCANA WEB SITE                                   *00100000
      *                                                                *00140000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  17/07/06    CVNS     SYBASE SP TO COBOL SP CONVERSION         *        
      *              CHENNAI                                           *        
A04228*  09/28/12    SV955326 MOVE STA COMMENTS FIELD PROPERLY WHEN IT *        
A04228*              ACT007   IS HAVING FLEX DNP ARRANGEMENT.          *        
ACT115*  06/13/14    A04880   ADD 'WITH UR' TO SELECT                  *        
P00726** 08/07/2014 WR19680   ADD CHANGES TO LOOK FOR STAS IN THE      *        
P00726**                      NEW TABLE STRUCTURE                      *        
P0726A** 01/14/2015 WR19680   FIX IVR COMMMENTS NOT POPULATING         *        
      **                                                               *        
ACT354**                                                               *        
ACT354** 11/23/2016 AD7F921   REMOVE STA_SUMMARY AND STA_DETAIL.       *        
ACT354**                      APPL00005460.                            *        
      *---------------------------------------------------------------- 00470000
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03710'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(45) VALUE   
           'WORKING STORAGE FOR RPC CSR03710 STARTS HERE'.              
                                                                        
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00780000
      ******************************************************************00790000
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           COPY CWS00303.                                               00930000
                                                                        
      ******************************************************************00950000
      *    WORK AREAS                                                  *00960000
      ******************************************************************00970000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03710'.      
           05  WS-SQLSTATE             PIC X(05) VALUE '     '.         
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NO-NUM       REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
           05  WS-ACCOUNT-NO-COMP3     PIC S9(13)   COMP-3 VALUE +0.    
           05  WS-STA-AMOUNT           PIC X(14) VALUE  SPACES.         
           05  WS-END-OF-DATA          PIC X(01) VALUE 'N'.             
               88 NO-MORE-DATA                   VALUE 'Y'.             
           05  WS-DATE-PYMNT-DUE.                                       
               10 WS-YY                PIC X(04) VALUE  SPACES.         
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-MM                PIC X(02) VALUE  SPACES.         
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-DD                PIC X(02) VALUE  SPACES.         
           05  WS-FRMT-PYMNT-DTE.                                       
               10 WS-FRMT-MM           PIC X(02) VALUE  SPACES.         
               10 FILLER               PIC X(01) VALUE '/'.             
               10 WS-FRMT-DD           PIC X(02) VALUE  SPACES.         
               10 FILLER               PIC X(01) VALUE '/'.             
               10 WS-FRMT-YY           PIC X(04) VALUE  SPACES.         
           05  WS-DATE-PYMNT-CUST      PIC X(10) VALUE  SPACES.         
           05  WS-CONFIRM-NO           PIC X(10) VALUE  SPACES.         
           05  WS-PYMNT-METHOD         PIC X(25) VALUE  SPACES.         
           05  WS-USER-ID              PIC X(03) VALUE  SPACES.         
           05  WS-RECORD-EXISTS        PIC X(01) VALUE  SPACES.         
           05  WS-PROCESS-ARNG         PIC X(01) VALUE  SPACES.         
P00726     05  WS-ACTIVE-STA           PIC X(01) VALUE  SPACES.         
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STA-FLAG             PIC X(1)  VALUE  SPACES.         
           05  RS-DATE-PYMNT-DUE       PIC X(10) VALUE  SPACES.         
           05  RS-STA-AMOUNT           PIC X(14) VALUE  SPACES.         
           05  RS-DATE-PYMNT-CUST      PIC X(10) VALUE  SPACES.         
           05  RS-CONFIRM-NO           PIC X(10) VALUE  SPACES.         
           05  RS-PYMNT-METHOD         PIC X(25) VALUE  SPACES.         
           05  RS-USER-ID              PIC X(3)  VALUE  SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STA-FLAG             PIC X(1)  VALUE  SPACES.          
           05  S-DATE-PYMNT-DUE       PIC X(10) VALUE  SPACES.          
           05  S-STA-AMOUNT           PIC X(14) VALUE  SPACES.          
           05  S-DATE-PYMNT-CUST      PIC X(10) VALUE  SPACES.          
           05  S-CONFIRM-NO           PIC X(10) VALUE  SPACES.          
           05  S-PYMNT-METHOD         PIC X(25) VALUE  SPACES.          
           05  S-USER-ID              PIC X(3)  VALUE  SPACES.          
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-BILL-DUE-DATE       PIC X(10) VALUE SPACES.           
           05  WS-BILL-DUE-SUB        PIC X(10) VALUE SPACES.           
           05  WS-CURRENT-DATE        PIC X(10) VALUE SPACES.           
           05  WS-AMT-PYMNT-EDITED    PIC $$$,$$$,$$$.99 VALUE ZEROS.   
      *                                                                         
       01  WS-NULL-INDICATORES.                                         
           05  WS-NOTICE-DUE-NULL     PIC S9(4) COMP.                   
      *                                                                         
      ******************************************************************00540000
      *    DB2 INCLUDES                                                *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE SQLCA                                             00590000
           END-EXEC.                                                    00600000
                                                                        
      *-------< INCLUDE CSS_DELIQUENCY >                                00620000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBDELQ                                            00640000
           END-EXEC.                                                    00650000
                                                                        
      *--------< CREDIT COLLECTION >                                    00920000
           EXEC SQL                                                     00630000
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                    00650000
                                                                        
      *--------< ACCOUNT >                                              00920000
           EXEC SQL                                                     00630000
              INCLUDE TBACCT                                                    
           END-EXEC.                                                    00650000
                                                                        
P00726*--------< CSS_CRED_ARNGMENT X1>                                          
P00726     EXEC SQL                                                             
P00726         INCLUDE TBCRARNG                                                 
P00726     END-EXEC.                                                            
P00726                                                                  
P00726*--------< CSS_CRED_ARNG_SCHD WX>                                         
P00726     EXEC SQL                                                             
P00726         INCLUDE TBCRARSC                                                 
P00726     END-EXEC.                                                            
P00726*                                                                         
P00726*--------< CSS_CRED_ARNG_HIST WY>                                         
P00726     EXEC SQL                                                             
P00726         INCLUDE TBCRARHS                                                 
P00726     END-EXEC.                                                            
P00726*                                                                         
P00726******************************************************************        
P00726*****************************************************************         
P00726* CURSOR FOR GETTING THE ARNG DETAILS                           *         
P00726*****************************************************************         
P00726     EXEC SQL                                                     
P00726        DECLARE ARNG_CRED_CUR CURSOR FOR                          
P00726          SELECT                                                  
P0726A            X1.ARNG_CONFIRM_NO,                                   
P00726            WX.ARNG_SCHD_DUE_DT,                                  
P00726            WX.ARNG_SCHD_PYMT_AMT,                                
P00726            WY.CHANGE_COMMENTS,                                   
P00726            WY.LAST_UPDATE_USERID                                 
P00726       FROM                                                       
P00726            CSS_CRED_ARNGMENT  X1 WITH(READUNCOMMITTED),                  
P00726            CSS_CRED_ARNG_SCHD WX WITH(READUNCOMMITTED),                  
P00726            CSS_CRED_ARNG_HIST WY WITH(READUNCOMMITTED)                   
P00726       WHERE  X1.ACCOUNT_NO      = :X1-ACCOUNT-NO                 
P00726         AND  X1.ACCOUNT_NO      = WX.ACCOUNT_NO                  
P00726         AND  X1.ACCOUNT_NO      = WY.ACCOUNT_NO                  
P00726         AND  X1.ARNG_ID         = WX.ARNG_ID                     
P00726         AND  X1.ARNG_ID         = WY.ARNG_ID                     
P00726         AND  X1.CRED_ARNG_SEQ   = WX.CRED_ARNG_SEQ               
P00726         AND  X1.CRED_ARNG_SEQ   = WY.CRED_ARNG_SEQ               
P00726         AND  X1.ARNG_STATUS_CD  = 'A'                            
P00726         AND  WY.ARNG_CHANGE_CD  = 'S'                            
P00726         AND  WX.ARNG_SCHD_SEQ = 1                                
P00726       ORDER BY                                                   
P00726           X1.CRED_ARNG_SEQ DESC                                  
P00726                                                           
P00726     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ARNG_CRED_CUR CURSOR FOR                                  
MFA-TR*         SELECT                                                          
MFA-TR*           X1.ARNG_CONFIRM_NO,                                           
MFA-TR*           WX.ARNG_SCHD_DUE_DT,                                          
MFA-TR*           WX.ARNG_SCHD_PYMT_AMT,                                        
MFA-TR*           WY.CHANGE_COMMENTS,                                           
MFA-TR*           WY.LAST_UPDATE_USERID                                         
MFA-TR*      FROM                                                               
MFA-TR*           CSS_CRED_ARNGMENT  X1,                                        
MFA-TR*           CSS_CRED_ARNG_SCHD WX,                                        
MFA-TR*           CSS_CRED_ARNG_HIST WY                                         
MFA-TR*      WHERE  X1.ACCOUNT_NO      = :X1-ACCOUNT-NO                         
MFA-TR*        AND  X1.ACCOUNT_NO      = WX.ACCOUNT_NO                          
MFA-TR*        AND  X1.ACCOUNT_NO      = WY.ACCOUNT_NO                          
MFA-TR*        AND  X1.ARNG_ID         = WX.ARNG_ID                             
MFA-TR*        AND  X1.ARNG_ID         = WY.ARNG_ID                             
MFA-TR*        AND  X1.CRED_ARNG_SEQ   = WX.CRED_ARNG_SEQ                       
MFA-TR*        AND  X1.CRED_ARNG_SEQ   = WY.CRED_ARNG_SEQ                       
MFA-TR*        AND  X1.ARNG_STATUS_CD  = 'A'                                    
MFA-TR*        AND  WY.ARNG_CHANGE_CD  = 'S'                                    
MFA-TR*        AND  WX.ARNG_SCHD_SEQ = 1                                        
MFA-TR*      ORDER BY                                                           
MFA-TR*          X1.CRED_ARNG_SEQ DESC                                          
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                            02000000
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO             PIC X(13).                       
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************02030000
      * 0000-MAINLINE                                                  *02040000
      *     CALLS 0100-INITIALIZE                                      *02050000
      *           1000-PROCESS-INPUT                                   *02060000
      *           2000-PROCESS-OUTPUT                                  *02070000
      *           9999-END-PROGRAM                                     *02080000
      *                                                                *02090000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02100000
      ******************************************************************02110000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02230000
      * 0100-INITIALIZE                                                *02240000
      *                                                                *02270000
      *     CALLED FROM 0000-MAINLINE                                  *02280000
      *     DECLARE C1 CURSOR FOR SENDING RESULT SET                   *02300000
      ******************************************************************02350000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     RETURN_CODE                                        
                    ,STA_FLAG                                           
                    ,DATE_PYMNT_DUE                                     
                    ,STA_AMOUNT                                         
                    ,DATE_PYMNT_CUST                                    
                    ,CONFIRM_NO                                         
                    ,PYMNT_METHOD                                       
                    ,USER_ID                                            
                FROM                                                    
                    #CSR03710_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,STA_FLAG                                                   
MFA-TR*             ,DATE_PYMNT_DUE                                             
MFA-TR*             ,STA_AMOUNT                                                 
MFA-TR*             ,DATE_PYMNT_CUST                                            
MFA-TR*             ,CONFIRM_NO                                                 
MFA-TR*             ,PYMNT_METHOD                                               
MFA-TR*             ,USER_ID                                                    
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR03710_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07730000
      * 0100A-DECLARE-GTT                                              *07740000
      * DECLARE TABLE TO HOLD RESULT SET                               *        
      ******************************************************************07800000
       0100A-DECLARE-GTT.                                               
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03710_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03710_R1
              (                                                       
                     RETURN_CODE            INT                     
                    ,STA_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                    ,DATE_PYMNT_DUE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,STA_AMOUNT CHAR(14)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,DATE_PYMNT_CUST CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CONFIRM_NO CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,PYMNT_METHOD CHAR(25)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,USER_ID CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2          
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE              TO WS-SQLSTATE.                   
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE SQLCODE            TO ABEND-SQLCODE                 
               MOVE SQLSTATE           TO ABEND-SQLSTATE                
               MOVE '0100A'            TO ACTIVE-PARAGRAPH              
               MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSR03710_R1'      TO TABLE-1                       
               MOVE SPACES             TO TABLE-ELEMENT-1               
               MOVE SPACES             TO HOSTVAR-ELEMENT-1             
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                       THRU  9900-EXIT                  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************02640000
      * 1000-PROCESS-INPUT                                             *02650000
      *                                                                *02670000
      *     CALLED FROM 0000-MAINLINE                                  *02680000
      *     RECEIVE PARMS.                                             *02700000
      ******************************************************************02710000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO              TO WS-ACCOUNT-NO.          
           MOVE WS-ACCOUNT-NO-NUM            TO WS-ACCOUNT-NO-COMP3.    
ACT354     MOVE WS-ACCOUNT-NO-COMP3          TO CL-ACCOUNT-NO           
                                                AT-ACCOUNT-NO           
P00726                                          X1-ACCOUNT-NO.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03210000
      * 2000-PROCESS-OUTPUT.                                           *03220000
      *                                                                *03250000
      *      CALLED FROM 0000-MAINLINE                                 *03260000
      *                                                                *03270000
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE VALUES   *03280000
      *      AND SENDS THEN BACK                                       *03290000
      ******************************************************************03300000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                     TO   ACTIVE-PARAGRAPH.       
      *                                                                         
ACT354     MOVE SPACES                     TO   WS-ACTIVE-STA.          
P00726                                                                  
                                                                        
      *                                                                         
P00726     MOVE 'N'                          TO    WS-END-OF-DATA.      
P00726     PERFORM 7130-OPEN-ARNG-CRED-CUR   THRU  7130-EXIT.           
P00726     PERFORM 2100-PROCESS-DETAIL       THRU  2100-EXIT            
P00726                                       UNTIL NO-MORE-DATA.        
P00726     PERFORM 7150-CLOSE-ARNG-CRED-CUR  THRU  7150-EXIT.           
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *  2000A-MOVE-RESULT.                                         *           
      ***************************************************************           
      *                                                                         
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
           MOVE RS-STA-FLAG           TO S-STA-FLAG.                    
           MOVE RS-DATE-PYMNT-DUE     TO S-DATE-PYMNT-DUE.              
           MOVE RS-STA-AMOUNT         TO S-STA-AMOUNT.                  
           MOVE RS-DATE-PYMNT-CUST    TO S-DATE-PYMNT-CUST.             
           MOVE RS-CONFIRM-NO         TO S-CONFIRM-NO.                  
           MOVE RS-PYMNT-METHOD       TO S-PYMNT-METHOD.                
           MOVE RS-USER-ID            TO S-USER-ID.                     
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 2100-PROCESS-DETAIL.                                        *           
      *                                                             *           
      * POPULATES VALUE AND INSERTS INTO TEMPRORARY TABLE TILL THE  *           
      * THE LAST RECORD.                                            *           
      ***************************************************************           
      *                                                                         
       2100-PROCESS-DETAIL.                                             
      *                                                                         
P00726     PERFORM 7140-FETCH-ARNG-CRED-CUR  THRU 7140-EXIT             
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00726        MOVE 'Y' TO WS-ACTIVE-STA                                 
P00726        PERFORM 2250-FRMT-ARNG-DTL THRU 2250-EXIT                 
              MOVE 'A'                   TO RS-STA-FLAG                 
              MOVE WS-FRMT-PYMNT-DTE     TO RS-DATE-PYMNT-DUE           
              MOVE WS-STA-AMOUNT         TO RS-STA-AMOUNT               
              MOVE WS-DATE-PYMNT-CUST    TO RS-DATE-PYMNT-CUST          
              MOVE WS-CONFIRM-NO         TO RS-CONFIRM-NO               
              MOVE WS-PYMNT-METHOD       TO RS-PYMNT-METHOD             
              MOVE WS-USER-ID            TO RS-USER-ID                  
              PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           ELSE                                                         
               MOVE 'Y'                   TO WS-END-OF-DATA             
               MOVE '0'                   TO RS-STA-AMOUNT              
      * IF NO ACTIVE STA FOUND, CHECK A/C IS ELIGIBLE OR NOT FOR STA            
P00726         IF CTR-ROWS < 1 AND WS-ACTIVE-STA = 'N' THEN             
                  PERFORM 2300-CHECK-STA-ELIGIBILITY                    
                                             THRU 2300-EXIT             
                  PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT            
                  PERFORM 8100-SEND-RESULT   THRU 8100-EXIT             
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00726***************************************************************           
P00726* 2250-FRMT-ARNG-DTL.                                         *           
P00726*                                                             *           
P00726* FORMATS THE RESULT SET                                      *           
P00726***************************************************************           
P00726*                                                                         
P00726 2250-FRMT-ARNG-DTL.                                              
P00726*                                                                         
P00726     MOVE WX-ARNG-SCHD-DUE-DT          TO WS-DATE-PYMNT-DUE.      
P00726     MOVE WS-YY                        TO WS-FRMT-YY.             
P00726     MOVE WS-MM                        TO WS-FRMT-MM.             
P00726     MOVE WS-DD                        TO WS-FRMT-DD.             
P00726     EVALUATE WY-LAST-UPDATE-USERID(1:3)                          
P00726        WHEN 'WEB'                                                
P00726           MOVE 'WEB'                  TO WS-USER-ID              
P00726        WHEN 'IVR'                                                
P00726           MOVE 'IVR'                  TO WS-USER-ID              
P00726        WHEN OTHER                                                
P00726           MOVE 'CSR'                  TO WS-USER-ID              
P00726     END-EVALUATE.                                                
P00726     IF WS-USER-ID = 'CSR'                                        
P0726A        MOVE SPACES                    TO WS-PYMNT-METHOD         
P0726A     END-IF.                                                      
                                                                        
P0726A     MOVE X1-ARNG-CONFIRM-NO        TO WS-CONFIRM-NO.             
P00726     MOVE WX-ARNG-SCHD-DUE-DT       TO WS-DATE-PYMNT-CUST.        
P00726     MOVE WX-ARNG-SCHD-PYMT-AMT     TO WS-AMT-PYMNT-EDITED.       
P00726     MOVE WS-AMT-PYMNT-EDITED       TO WS-STA-AMOUNT.             
P00726*                                                                         
P00726 2250-EXIT.                                                       
P00726     EXIT.                                                        
P00726*                                                                         
      ***************************************************************           
      * 2300-CHECK-STA-ELIGIBILITY.                                 *           
      *                                                             *           
      * GET BILL DUE DATE AS DELINQUENT DATE PRIOR TO NOTICE DUE    *           
      * DATE. SET STA FLAG BASED ON BILL DUE DATE IS IN FUTURE OR   *           
      * NOT.                                                        *           
      ***************************************************************           
      *                                                                         
       2300-CHECK-STA-ELIGIBILITY.                                      
      *                                                                         
           PERFORM 2310-SEL-NOTICE-DTE  THRU 2310-EXIT.                 
           IF WS-BILL-DUE-DATE > SPACES                                 
               PERFORM 7300-SEL-BILL-DUE  THRU 7300-EXIT                
               IF WS-CURRENT-DATE > WS-BILL-DUE-SUB THEN                
                  MOVE 'E'             TO RS-STA-FLAG                   
                  MOVE 0               TO RS-RETURN-CODE                
               ELSE                                                     
                  MOVE 'N'             TO RS-STA-FLAG                   
               END-IF                                                   
           ELSE                                                         
                MOVE NOT-FOUND         TO RS-RETURN-CODE                
                MOVE 'N'               TO RS-STA-FLAG                   
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 2310-SEL-NOTICE-DTE.                                        *           
      *                                                             *           
      * GET NOTICE DATE FROM CREDIT COLLECTION TABLE FOR NOTICE TYPE*           
      * 'A', 'B', 'C', 'E', 'F', 'O'. IF THE  DATE IN NOT VALID     *           
      * THEN MOVE SPACES.                                           *           
      ***************************************************************           
      *                                                                         
       2310-SEL-NOTICE-DTE.                                             
      *                                                                         
           PERFORM 7200-SEL-CRD-COLL  THRU 7200-EXIT.                   
           IF WS-RECORD-EXISTS  = 'Y'                                   
              MOVE CL-DATE-NOTICE-DUE TO WS-BILL-DUE-DATE               
           ELSE                                                         
              MOVE SPACES             TO WS-BILL-DUE-DATE               
           END-IF.                                                      
      *                                                                         
       2310-EXIT.                                                       
           EXIT.                                                        
P00726*                                                                         
P00726***************************************************************           
P00726* 7130-OPEN-ARNG-CRED-CUR.                                    *           
P00726*                                                             *           
P00726* OPEN ARNG CRED CURSOR                                       *           
P00726***************************************************************           
P00726*                                                                         
P00726 7130-OPEN-ARNG-CRED-CUR.                                         
P00726     EXEC SQL                                                     
P00726          OPEN ARNG_CRED_CUR                                      
P00726     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00726        NEXT SENTENCE                                             
P00726     ELSE                                                         
P00726        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P00726        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00726        MOVE '7130'                TO ACTIVE-PARAGRAPH            
P00726        MOVE 'OPEN'                TO ABEND-FUNCTION              
P00726        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00726                                      ABEND-TABLES                
P00726        MOVE 'CSS_CRED_ARNGMENT'   TO TABLE-1                     
P00726        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00726        MOVE X1-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00726     END-IF.                                                      
P00726 7130-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
P00726***************************************************************           
P00726* 7140-FETCH-ARNG-CRED-CUR.                                   *           
P00726*                                                             *           
P00726* FETCH DATA USING ARNG-CRED CURSOR                           *           
P00726***************************************************************           
P00726*                                                                         
P00726 7140-FETCH-ARNG-CRED-CUR.                                        
P00726     EXEC SQL                                                     
P00726         FETCH ARNG_CRED_CUR                                      
P0726A          INTO :X1-ARNG-CONFIRM-NO                                
P00726              ,:WX-ARNG-SCHD-DUE-DT                               
P00726              ,:WX-ARNG-SCHD-PYMT-AMT                             
P00726              ,:WY-CHANGE-COMMENTS                                
P00726              ,:WY-LAST-UPDATE-USERID                             
P00726     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00726        NEXT SENTENCE                                             
P00726     ELSE                                                         
P00726        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00726           IF WS-ACTIVE-STA = SPACES                              
P00726              MOVE 'N' TO WS-ACTIVE-STA                           
P00726           END-IF                                                 
P00726        ELSE                                                      
P00726           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
P00726           MOVE '7140'                TO ACTIVE-PARAGRAPH         
P00726           MOVE 'FETCH'               TO ABEND-FUNCTION           
P00726           MOVE SPACES                TO ABEND-SQL-PREDICATES     
P00726                                      ABEND-TABLES                
P00726           MOVE 'CSS_CRED_ARNGMENT'   TO TABLE-1                  
P00726           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
P00726           MOVE X1-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
P00726           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00726        END-IF                                                    
P00726     END-IF.                                                      
P00726 7140-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
P00726***************************************************************           
P00726* 7150-CLOSE-ARNG-CRED-CUR.                                   *           
P00726*                                                             *           
P00726* CLOSE ARNG CRED CURSOR                                      *           
P00726***************************************************************           
P00726*                                                                         
P00726 7150-CLOSE-ARNG-CRED-CUR.                                        
P00726     EXEC SQL                                                     
P00726        CLOSE ARNG_CRED_CUR                                       
P00726     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00726        NEXT SENTENCE                                             
P00726     ELSE                                                         
P00726        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P00726        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00726        MOVE '7150'                TO ACTIVE-PARAGRAPH            
P00726        MOVE 'CLOSE'               TO ABEND-FUNCTION              
P00726        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00726                                      ABEND-TABLES                
P00726        MOVE 'CSS_CRED_ARNGMENT'   TO TABLE-1                     
P00726        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00726        MOVE X1-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00726        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00726     END-IF.                                                      
P00726 7150-EXIT.                                                       
P00726     EXIT.                                                        
P00726*                                                                         
      ***************************************************************           
      * 7200-SEL-CRD-COLL.                                          *           
      *                                                             *           
      * GET NOTICE DATE FROM CREDIT COLLECTION TABLE AS THE CLOSEST *           
      * FUTURE DATE TO CURRENT DATE.                                *           
      ***************************************************************           
      *                                                                         
       7200-SEL-CRD-COLL.                                               
           EXEC SQL                                                     
             SELECT  'Y'                                                
                    ,MIN(DATE_NOTICE_DUE)                               
               INTO  :WS-RECORD-EXISTS                                  
                    ,:CL-DATE-NOTICE-DUE :WS-NOTICE-DUE-NULL            
               FROM  CSS_CRED_COLL WITH(READUNCOMMITTED)                        
              WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                   
                AND CODE_NOTICE_TYPE IN ('A', 'B', 'C', 'E', 'F', 'O')  
                AND ITEM_ID          = 0                                
                AND DATE_NOTICE_DUE  >= (CAST(SYSDATETIMEOFFSET() 
           AS DATE))                  
ACT115                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  'Y'                                                03390000
MFA-TR*             ,MIN(DATE_NOTICE_DUE)                                       
MFA-TR*        INTO  :WS-RECORD-EXISTS                                          
MFA-TR*             ,:CL-DATE-NOTICE-DUE :WS-NOTICE-DUE-NULL                    
MFA-TR*        FROM  CSS_CRED_COLL                                              
MFA-TR*       WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                           
MFA-TR*         AND CODE_NOTICE_TYPE IN ('A', 'B', 'C', 'E', 'F', 'O')          
MFA-TR*         AND ITEM_ID          = 0                                        
MFA-TR*         AND DATE_NOTICE_DUE  >= (CURRENT DATE)                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 7300-SEL-BILL-DUE.                                          *           
      *                                                             *           
      * GET NOTICE DATE FROM CREDIT COLLECTION TABLE. GET DELINQNT  *           
      * DAYS FROM DELINQUENCY TABLE FOR THE INPUT ACCOUNT NUMBER    *           
      * AND ITS CORRESPONDING COMPANY NUMBER IN ACCT TABLE.         *           
      ***************************************************************           
      *                                                                         
       7300-SEL-BILL-DUE.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT  DELINQ_VALUE                                     
                 INTO  :C8-DELINQ-VALUE                                 
                 FROM  CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                 
                      ,CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                 
                WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO              
                  AND C8.COMPANY_NO       = AT.COMPANY_NO               
                  AND C8.DELINQ_CD        = 'STA-DUE-SUB-DAYS'          
ACT115                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DELINQ_VALUE                                     03390000
MFA-TR*          INTO  :C8-DELINQ-VALUE                                         
MFA-TR*          FROM  CSS_ACCOUNT     AT                                       
MFA-TR*               ,CSS_DELINQUENCY C8                                       
MFA-TR*         WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO                      
MFA-TR*           AND C8.COMPANY_NO       = AT.COMPANY_NO                       
MFA-TR*           AND C8.DELINQ_CD        = 'STA-DUE-SUB-DAYS'                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              EXEC SQL                                                  
                  SELECT
              DATEADD( DAY, -:C8-DELINQ-VALUE, IIF(TRY_CONVERT(DATE, 
                                                      :WS-BILL-DUE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BILL-DUE-DATE
              ) <> 0) OR (LEN(:WS-BILL-DUE-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-BILL-DUE-DATE
              ), CONVERT(DATE, :WS-BILL-DUE-DATE) ) )
            INTO
              :WS-BILL-DUE-SUB   
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SET :WS-BILL-DUE-SUB =                                        
MFA-TR*               DATE(:WS-BILL-DUE-DATE) - :C8-DELINQ-VALUE DAYS           
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              EXEC SQL                                                  
                  SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                   
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SET :WS-CURRENT-DATE = CURRENT DATE                           
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'CSS_DELINQUENCY'     TO TABLE-2                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07730000
      * 8000A-DELETE-GTT-ROWS                                          *07740000
      *                                                                *        
      * DELETE TEMPORARY TABLE WHEN REQUIRED.                          *        
      ******************************************************************07800000
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR03710_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR03710_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                                    ABEND-TABLES        
              MOVE 'CSR03710_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************07730000
      * 8100-SEND-RESULT.                                              *07740000
      *                                                                *        
      * INSERT RESULT SET INTO TEMPORARY TABLE.                        *        
      ******************************************************************07800000
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR03710_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,STA_FLAG                                           
                    ,DATE_PYMNT_DUE                                     
                    ,STA_AMOUNT                                         
                    ,DATE_PYMNT_CUST                                    
                    ,CONFIRM_NO                                         
                    ,PYMNT_METHOD                                       
                    ,USER_ID                                            
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE                                     
                    ,:S-STA-FLAG                                        
                    ,:S-DATE-PYMNT-DUE                                  
                    ,:S-STA-AMOUNT                                      
                    ,:S-DATE-PYMNT-CUST                                 
                    ,:S-CONFIRM-NO                                      
                    ,:S-PYMNT-METHOD                                    
                    ,:S-USER-ID                                         
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     42750000
MFA-TR*         INSERT INTO SESSION.CSR03710_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,STA_FLAG                                                   
MFA-TR*             ,DATE_PYMNT_DUE                                             
MFA-TR*             ,STA_AMOUNT                                                 
MFA-TR*             ,DATE_PYMNT_CUST                                            
MFA-TR*             ,CONFIRM_NO                                                 
MFA-TR*             ,PYMNT_METHOD                                               
MFA-TR*             ,USER_ID                                                    
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-STA-FLAG                                                
MFA-TR*             ,:S-DATE-PYMNT-DUE                                          
MFA-TR*             ,:S-STA-AMOUNT                                              
MFA-TR*             ,:S-DATE-PYMNT-CUST                                         
MFA-TR*             ,:S-CONFIRM-NO                                              
MFA-TR*             ,:S-PYMNT-METHOD                                            
MFA-TR*             ,:S-USER-ID                                                 
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1                    TO CTR-ROWS                    
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR03710_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************42800000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      ******************************************************************42820000
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************42870000
      *       END PROGRAM COPYLIB                                      *42880000
      ******************************************************************42890000
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
