       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03707.                                         
COB303 DATE-WRITTEN.  09 JUNE 2006.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS USED TO POST VOUCHER PAYMENTS ACCEPTED USING  *        
      *  THE WEB CUSTOMER ASSISTANCE AGENCY APPLICATION                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
C32913*  09/11/06  BASKAR &    NEW VOUCHER PAYMENT POSTING PROGRAM     *        
      *            KHUZEM                                              *        
      *                                                                *        
C32913*  11/20/06  BASKAR     MOVE '1' TO CODE-DISK-OK FOR SEB ACCOUNTS*        
A00575*  03/27/09  BASKAR     STORE CREDIT ACTION INDICATOR IN ERROR_CD*        
A00575*                       FIELD OF CSS_PAYMENT_TRANS TABLE         *        
A01179*  04/14/09  BASKAR V   ADDED CALL TO MCS03413 TO HANDLE DNP AND *        
A01179*                       RECONNECT REAL TIME                      *        
A36248*  05/20/09  LG41184    CALL NEW SUBPROGRAM MCSCB371 TO UPDATE   *        
A36248*                       DNP BALANCE FOR CSR ACCOUNTS.            *        
A37302*  07/06/09  LG41184    DCLGEN TBRVCACT REMOVED.                 *        
PRJ420*  10/21/10  AP40911    TO FIX PROD ISSUE SOC4 WHICH IS CAUSING  *        
PRJ420*                       CREDIT ACTION NOT TO UPDATE.             *        
A03578*  08/16/11  BASKAR V   MOVE CORRECT TRANID DURING JOURNALING    *        
      *                                                                *        
A05154* 8 FEB 2015 RF10596    REMOVE UNUSED CODE                       *        
A04860*  04/05/16  MS7M727   REPLACE CSS_WQ_ITEMS_MF TABLE WITH        *01790100
A04860*            ACT105    CSS_WQ_ITEMS TABLE                        *01790200
ACT285*  09/22/16  AA97148   REPLACE CPD03413 WITH NEW COPYBOOK        *        
ACT285*                      CPD03414. Ref:APPL00005460                *        
P00948*  01/01/17  VENKAT.P  SEND DNP CANCEL NOTIFICATION E-MAIL FOR   *        
P00948*                      CUSTOMERS WITH E-MAIL ADDRESS.            *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03707'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03707 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
      *-- BU CSS_BUDGET_PLAN                                                    
           EXEC SQL                                                             
              INCLUDE TBBGTPLN                                                  
           END-EXEC.                                                            
                                                                        
      *-- EA CSS_CNT_DETAIL                                                     
           EXEC SQL                                                             
              INCLUDE TBCNTDET                                                  
           END-EXEC.                                                            
                                                                        
      *-- BH CSS_BUDGET_HIST                                                    
           EXEC SQL                                                             
              INCLUDE TBBGTHST                                                  
           END-EXEC.                                                            
                                                                        
      *-- DO CSS_DEP_ON_HAND                                                    
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
      *-- CU CSS_CUSTOMER                                                       
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      *-- PR CSS_PREMISE                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      *-- CT CSS_CONTRACT                                                       
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      *-- AR CSS_AR_TRANS_HIST                                                  
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
      *-- I5 CSS_LIEAP_AGENCY                                                   
           EXEC SQL                                                             
             INCLUDE TBLIAGCY                                                   
           END-EXEC.                                                            
                                                                        
      *-- AU CSS_AR_TRN_HST_DET                                                 
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
                                                                        
      *-- CS CSS_CSH_DRWR_CNTL                                                  
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *-- CJ CSS_CSH_DRWR_JRNL                                                  
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *-- BC CSS_BCH_JRNL_CNTL                                                  
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *-- BJ CSS_BATCH_JRNL                                                     
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *-- MJ CSS_MISC_JRNL                                                      
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *-- PJ CSS_PROJ_SHARE                                                     
           EXEC SQL                                                             
              INCLUDE TBPRJSHR                                                  
           END-EXEC.                                                            
                                                                        
      *-- DV CSS_DFA_RECVBLE                                                    
           EXEC SQL                                                             
              INCLUDE TBDFARCV                                                  
           END-EXEC.                                                            
                                                                        
      *-- C9 CSS_AR_PMT_PRTY                                                    
           EXEC SQL                                                             
              INCLUDE TBARPMT                                                   
           END-EXEC.                                                            
                                                                        
      *-- GO CSS_GL_ACCT_NO                                                     
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      *-- DP CSS_DEP_PAY_HST                                                    
           EXEC SQL                                                             
              INCLUDE TBDEPHST                                                  
           END-EXEC.                                                            
                                                                        
      *-- DL CSS_RECONNECT                                                      
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
      *-- CO CSS_CHRG_OFF                                                       
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
      *-- AL CSS_AR_LOCKOUT                                                     
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
      *-- WG CSS_WO_ARRANGEMENT                                                 
           EXEC SQL                                                             
               INCLUDE TBWOARGM                                                 
           END-EXEC.                                                            
                                                                        
      *-- JT CSS_PAYMENT_TRANS                                                  
           EXEC SQL                                                             
              INCLUDE TBPMTRAN                                                  
           END-EXEC.                                                            
                                                                        
      *-- CZ CSS_CREDIT_PROFILE                                                 
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      *-- SQL COMMINUCATION AREA                                                
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *-- LI CSS_LIEAP                                                          
           EXEC SQL                                                             
              INCLUDE TBLIEAP                                                   
           END-EXEC.                                                            
                                                                        
      *-- AT CSS_ACCOUNT                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *-- AC CSS_AR_CNTL                                                        
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
                                                                        
      *-- DA CSS_DFA_ACCT                                                       
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
                                                                        
      *-- PF CSS_USER_PROFILE                                                   
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *-- J8 CSS_HOLIDAY                                                        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      *-- CC CSS_CONNECT_CHRG                                                   
           EXEC SQL                                                             
              INCLUDE TBCCCHRG                                                  
           END-EXEC.                                                            
                                                                        
      *-- U7 CSS_RECONNECT_CHRG                                                 
           EXEC SQL                                                             
              INCLUDE TBRCNCHR                                                  
           END-EXEC.                                                            
                                                                        
      *-- C8 CSS_DELINQUENCY                                                    
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *-- LR CSS_REG_PROFILE                                                    
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      *-- B1 CSS_LOCAL_OFFICE                                                   
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *-- MH CSS_MNT_TRANS_HIST                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *-- MI CSS_MT_TRN_HST_DET                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *-- G6 CSS_JOB_PARM                                                       
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE JOURNAL VARIABLES AND CWS-13 VARIABLES            
           EXEC SQL                                                             
              INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR PAYMENT ROUTINE                  
           EXEC SQL                                                             
              INCLUDE CWS00017                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR GENERAL LEDGERS                  
           EXEC SQL                                                             
              INCLUDE CWS00061                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE LINKAGE SECTION VARIABLES FOR SCSCO061            
           EXEC SQL                                                             
              INCLUDE CWS0061L                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE CHARGE OFF RECEIVABLES                            
           EXEC SQL                                                             
              INCLUDE CWS00073                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE DISPLAY DATE VARIABLES                            
           COPY CWS00004.                                                       
                                                                        
      *-- COPYBOOK TO DECLARE DATE CALCULATION VARIABLES                        
           COPY CWS00007.                                                       
                                                                        
      *-- LINKAGE SECTION VARIABLES FOR SCSCO068                                
           COPY CWS0068L.                                                       
                                                                        
      *-- DECLARE REBATE AMOUNT VARIABLES                                       
           EXEC SQL                                                             
              INCLUDE CWS00008                                                  
           END-EXEC.                                                            
                                                                        
      *-- ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                        
           COPY CWS00027.                                                       
                                                                        
      *-- SUPPORTS DB2 AND SQL ERROR CHECKING                                   
           COPY CWS00303.                                                       
                                                                        
      *-- COPYBOOK TO DECLARE JOURNAL VARIABLES                                 
           COPY CWS00100.                                                       
                                                                        
      *-- COPYBOOK TO DECLARE 101 JOURNAL VARIABLES                             
           COPY CJF00101.                                                       
                                                                        
      *-- COPYBOOK TO DECLARE 102 JOURNAL VARIABLES                             
           COPY CJF00102.                                                       
                                                                        
      *-- COPYBOOK TO DECLARE 105 JOURNAL VARIABLES                             
           COPY CJF00105.                                                       
                                                                        
      *-- COPYBOOK TO DECLARE CODES_DATA_PRESENT                                
           COPY CWS00056.                                                       
                                                                        
      *-- COPYBOOK TO DECLARE SCSCA225 VARIABLES                                
           COPY CWSCA225.                                                       
                                                                        
                                                                        
ACT105     COPY CWS00077.                                                       
                                                                        
      *--- HOLIDAY CHECK                                                        
           EXEC SQL                                                             
               INCLUDE CWS10016                                                 
           END-EXEC.                                                            
                                                                        
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285*    WS VARIABLE FOR COPY BOOK CPD03414                         *         
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285                                                                  
ACT285     EXEC SQL                                                             
ACT285      INCLUDE CWS03414                                                    
ACT285     END-EXEC.                                                            
ACT285                                                                  
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR03707'.     
           05  WS-PROGRAM-NAME          PIC X(08) VALUE 'CSR03707'.     
           05  WS-SEB-REGULATED-FL      PIC X(01) VALUE SPACE.          
ACT105     05  WS-WQ-CALL-PGM           PIC X(08)  VALUE 'MCSCB077'.    
ACT105     05  MCSCB077                 PIC X(08)  VALUE 'MCSCB077'.    
ACT105     05  SCSCB077                 PIC X(08)  VALUE 'SCSCB077'.    
ACT105     05  WS-CPD0010S-CALL-TYPE    PIC X(01)  VALUE 'O'.           
ACT105         88 WS-CPD0010S-ONLINE-CALL          VALUE 'O'.           
ACT105         88 WS-CPD0010S-BATCH-CALL           VALUE 'B'.           
           05  WS-GROUP-2-SENIOR        PIC X(01) VALUE 'N'.            
           05  WS-DATABASE              PIC X(08) VALUE 'DATABASE'.     
           05  WS-T                     PIC X(01) VALUE 'T'.            
           05  WS-DATABASE-SW           PIC 9(01) VALUE 0.              
               88 CSR-DATABASE                    VALUE 1.              
               88 SEB-DATABASE                    VALUE 2.              
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-SWITCHES              PIC X(01) VALUE SPACES.         
               88 DUPLICATE-PAYMENT               VALUE 'P'.            
           05  WS-INPUT-ERROR-SW        PIC X(01) VALUE 'N'.            
               88 INPUT-ERROR                     VALUE 'Y'.            
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(04) COMP VALUE +0.       
           05  WS-CHRG-OFF-ACCT         PIC  X(01) VALUE 'N'.           
           05  WS-GO-GL-ACCT-NO-ED      PIC -(3)9.9999.                 
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
           05  WS-AMOUNT-LIHEAP         PIC  X(11).                     
           05  WS-AMOUNT-LIHEAP-NUM REDEFINES WS-AMOUNT-LIHEAP          
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-LIHEAP-COMP3   PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-DISP-AMOUNT           PIC 9(09).99.                   
           05  WS-CODE-DISC-OK          PIC X(1)    VALUE SPACES.       
           05  WS-TRANS-HIST-SEQ-NO     PIC X(26)   VALUE SPACES.       
           05  WS-TRAN-APPL-NO          PIC S9(4)   COMP VALUE 0.       
           05  WS-DATE-TRANS            PIC X(10)   VALUE SPACES.       
ACT285     05  WS-UPDATE-ACTION-FL      PIC  X(01) VALUE SPACES.        
           05  WS-CURRENT-DATE          PIC  X(10) VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP     PIC  X(26) VALUE SPACES.        
           05  WS-COMMENT-LEN           PIC 9(04)  VALUE 0.             
           05  WS-COMMENT-LEN-NUM       PIC S9(04) COMP VALUE 0.        
           05  WS-TRAN-COMMENT-LEN-NUM  PIC S9(04) COMP VALUE 0.        
           05  WS-COMMENT-TEXT          PIC X(25) VALUE SPACES.         
           05  WS-GL-ACCT-NO            PIC X(07) VALUE SPACES.         
           05  WS-GL-ACCT-NO-NUM        REDEFINES WS-GL-ACCT-NO         
                                        PIC 9(07).                      
           05  WS-GL-ACCT-DEBIT         PIC S9(03)V9(04) COMP-3 VALUE 0.
           05  WS-PYMT-AMOUNT           PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-D                     PIC X(01) VALUE 'D'.            
           05  WS-S                     PIC X(01) VALUE 'S'.            
           05  WS-U                     PIC X(01) VALUE 'U'.            
           05  WS-RCV-TYPE              PIC S9(04) COMP.                
           05  WS-NO                    PIC X(01) VALUE 'N'.            
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-NO-ERROR              PIC X(05) VALUE 'NOERR'.        
           05  WS-UPDATE-TYPE           PIC X(01) VALUE SPACES.         
           05  WS-COG-TRAN-TYPE-CD-73   PIC X(1)  VALUE 'P'.            
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  WS-MCSCO061              PIC X(08) VALUE 'MCSCO061'.     
           05  WS-MCSCB068              PIC X(08) VALUE 'MCSCB068'.     
           05  MCSCB225                 PIC X(8)  VALUE 'MCSCB225'.     
ACT285     05  MCS03414                 PIC X(8)  VALUE 'MCS03414'.     
           05  MCSCB371                 PIC X(8)  VALUE 'MCSCB371'.     
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-UPDATE-TYPE         PIC  X(01).                     
           05  PARM-ACCOUNT-NO          PIC  X(13).                     
           05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO            
                                        PIC 9(13).                      
           05  PARM-FACILITY-CODE       PIC  X(01).                     
           05  PARM-PAYMENT-TYPE        PIC  X(01).                     
           05  PARM-AMT-LIHEAP          PIC  X(11).                     
           05  PARM-USER-ID             PIC  X(07).                     
           05  PARM-CODE-AGENCY-ID      PIC  X(05) VALUE SPACES .       
           05  PARM-COMMENT-LEN         PIC  X(04).                     
           05  PARM-COMMENT-TEXT        PIC  X(25).                     
           05  PARM-APPLICATION-ID      PIC  X(08).                     
           05  PARM-COMPANY-NO          PIC  X(02).                     
           05  PARM-TIMESTAMP           PIC  X(26).                     
           05  PARM-SEB-EXEMPT-FL       PIC  X(01).                     
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
           05  RS-ERROR-MESSAGE       PIC X(05) VALUE SPACES.           
           05  RS-LIMIT-EXCEED-IND    PIC X(01) VALUE SPACES.           
           05  RS-CONF-NO             PIC X(15) VALUE SPACES.           
           05  RS-CANCELDNP-FLAG      PIC X(01) VALUE SPACES.           
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-ERROR-MESSAGE        PIC X(05) VALUE SPACES.           
           05  S-LIMIT-EXCEED-IND     PIC X(01) VALUE SPACES.           
           05  S-CONF-NO              PIC X(15) VALUE SPACES.           
           05  S-CANCELDNP-FLAG       PIC X(01) VALUE SPACES.           
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC               PIC S9(9) COMP.                   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS               PIC S9(9) COMP VALUE 0.           
                                                                        
       01  WORK-FIELDS.                                                 
A01179     05  WS-DNP-RET-CODE        PIC S9(4)      VALUE 0 COMP.      
A01179     05  WS-PYMT-FACILITY       PIC X(1)  VALUE SPACES.           
           05  WRK-DONE-STATUS        PIC S9(9) COMP.                   
           05  WS-PREMISE-NO-NUM      PIC 9(10) VALUE ZEROES.           
           05  WS-CUSTOMER-NO-NUM     PIC 9(10) VALUE ZEROES.           
           05  WS-NULL-IND1           PIC S9(04) COMP VALUE +0.         
           05  WS-NULL-IND2           PIC S9(04) COMP VALUE +0.         
           05  WS-NULL-IND3           PIC S9(04) COMP VALUE +0.         
           05  WS-NULL-IND4           PIC S9(04) COMP VALUE +0.         
           05  WS-CSR03421-AMOUNT     PIC X(10)  VALUE SPACES.          
           05  WS-CSR03421-AMT.                                         
               10 WS-CSR03421-INT     PIC X(7) VALUE SPACES.            
               10 FILLER              PIC X(1) VALUE '.'.               
               10 WS-CSR03421-DEC     PIC X(2) VALUE SPACES.            
A36248     05  WS-DNP-UPDATE-FL       PIC X(1) VALUE 'N'.               
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *01  LOC1                        USAGE IS SQL TYPE IS             
      *                               RESULT-SET-LOCATOR VARYING.       
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR03421                                       
                ( :WS-CSR03421-AMOUNT
                  )
MSQ001        END-EXEC.
       
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO             PIC  X(13)               .       
       01  LINK-AMT-LIHEAP             PIC  X(11)               .       
       01  LINK-USER-ID                PIC  X(07)               .       
       01  LINK-CODE-AGENCY-ID         PIC  X(05)               .       
       01  LINK-COMMENT-LEN            PIC  X(04)               .       
       01  LINK-COMMENT-TEXT           PIC  X(25)               .       
       01  LINK-APPLICATION-ID         PIC  X(08)               .       
       01  LINK-COMPANY-NO             PIC  X(02)               .       
       01  LINK-TIMESTAMP              PIC  X(26)               .       
       01  LINK-SEB-EXEMPT-FL          PIC  X(01)               .       
                                                                        
       PROCEDURE DIVISION USING                                         
                 LINK-ACCOUNT-NO                                        
               , LINK-AMT-LIHEAP                                        
               , LINK-USER-ID                                           
               , LINK-CODE-AGENCY-ID                                    
               , LINK-COMMENT-LEN                                       
               , LINK-COMMENT-TEXT                                      
               , LINK-APPLICATION-ID                                    
               , LINK-COMPANY-NO                                        
               , LINK-TIMESTAMP                                         
               , LINK-SEB-EXEMPT-FL                                     
               .                                                        

SCA006        SET WS-GL-SUB TO 1.
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      *----------------------------------------------------------------*        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT                   
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT                   
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT                   
                                                                        
A01179     IF CTR-ROWS < 1                                              
A01179        CONTINUE                                                  
A01179     ELSE                                                         
ACT285        PERFORM 8999-ISSUE-COMMIT          THRU 8999-EXIT         
ACT285        PERFORM 2950-PROCESS-DNP-RECONNECT THRU 2950-EXIT         
ACT285        MOVE WS-CNCL-DNP-ACTN-FL TO RS-CANCELDNP-FLAG             
A01179        IF RS-CANCELDNP-FLAG = 'Y'                                
A01179           EVALUATE WS-DNP-RET-CODE                               
A01179* DNP/DNPFB/RECONNECT handled correctly                                   
A01179               WHEN 0                                             
A01179* pending DNP cancelled                                                   
A01179               WHEN 790                                           
A01179* Reconnect order released                                                
A01179               WHEN 5137                                          
A01179                    MOVE 'N'        TO S-CANCELDNP-FLAG           
A01179                                       RS-CANCELDNP-FLAG          
A01179           END-EVALUATE                                           
ACT285           PERFORM 8110-UPDATE-DNP-CODE THRU 8110-EXIT            
A01179        ELSE                                                      
A01179           IF WS-DNP-RET-CODE > 0                                 
A01179              MOVE WS-DNP-RET-CODE     TO S-RETURN-CODE           
A01179           END-IF                                                 
A01179        END-IF                                                    
A01179     END-IF                                                       
                                                                        
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT                   
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DECLARES THE OUTPUT CURSOR AND POPULATES INPUT PARM VARIABLES  *        
      *----------------------------------------------------------------*        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH                     
                                                                        
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT :S-RETURN-CODE              AS RETURN_CODE          
                    ,LTRIM(RTRIM(:S-ERROR-MESSAGE))    AS ERROR_MESSAGE        
                    ,LTRIM(RTRIM(:S-LIMIT-EXCEED-IND)) AS 
           LIMIT_EXCEED_IND     
                    ,LTRIM(RTRIM(:S-CONF-NO))          AS 
           CONFIRMATION_NUM     
                    ,LTRIM(RTRIM(:S-CANCELDNP-FLAG))   AS CANCELDNP_FLAG       
               FROM CIS.SYSDUMMY1                                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                                   
MFA-TR*      SELECT :S-RETURN-CODE              AS RETURN_CODE                  
MFA-TR*             ,STRIP(:S-ERROR-MESSAGE)    AS ERROR_MESSAGE                
MFA-TR*             ,STRIP(:S-LIMIT-EXCEED-IND) AS LIMIT_EXCEED_IND             
MFA-TR*             ,STRIP(:S-CONF-NO)          AS CONFIRMATION_NUM             
MFA-TR*             ,STRIP(:S-CANCELDNP-FLAG)   AS CANCELDNP_FLAG               
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC                                                             
                                                                        
           MOVE 'U'                       TO PARM-UPDATE-TYPE           
           MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO            
           MOVE 'R'                       TO PARM-FACILITY-CODE         
           MOVE 'V'                       TO PARM-PAYMENT-TYPE          
           MOVE LINK-AMT-LIHEAP           TO PARM-AMT-LIHEAP            
           MOVE LINK-USER-ID              TO PARM-USER-ID               
           MOVE LINK-CODE-AGENCY-ID       TO PARM-CODE-AGENCY-ID        
           MOVE LINK-COMMENT-LEN          TO PARM-COMMENT-LEN           
           MOVE LINK-COMMENT-TEXT         TO PARM-COMMENT-TEXT          
           MOVE LINK-APPLICATION-ID       TO PARM-APPLICATION-ID        
           MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO            
           MOVE LINK-TIMESTAMP            TO PARM-TIMESTAMP             
                                                                        
           PERFORM 0110-VALIDATE-INPUT THRU 0110-EXIT                   
           PERFORM 0105-GET-CONFIRMATION-NO THRU 0105-EXIT              
                                                                        
           MOVE '01'                         TO C8-COMPANY-NO           
           MOVE WS-DATABASE                  TO C8-DELINQ-CD            
           PERFORM 7070-GET-DELINQ-VALUE     THRU 7070-EXIT             
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE-SW          
                                                                        
           PERFORM 0150-POPULATE-PYMT-TABLE  THRU 0150-EXIT             
           PERFORM 8020-INSERT-PAYMENT       THRU 8020-EXIT             
           IF DUPLICATE-PAYMENT                                         
              CONTINUE                                                  
           ELSE                                                         
      * COMMIT BEFORE STARTING ANY PROCESS TO STORE THE PAYMENT                 
      * IN CSS_PAYMENT_TRANS TABLE                                              
              PERFORM 8999-ISSUE-COMMIT      THRU 8999-EXIT             
           END-IF                                                       
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CALLS CSR03421 TO GET CONFIRMATION NO                          *        
      *----------------------------------------------------------------*        
       0105-GET-CONFIRMATION-NO.                                        
           MOVE '0105'          TO ACTIVE-PARAGRAPH                     
                                                                        
           MOVE LINK-AMT-LIHEAP(3:7)  TO WS-CSR03421-INT                
           MOVE LINK-AMT-LIHEAP(10:2) TO WS-CSR03421-DEC                
           MOVE WS-CSR03421-AMT       TO WS-CSR03421-AMOUNT             
                                                                        
      *    EXEC SQL CALL CSR03421                                       
      *         ( :WS-CSR03421-AMOUNT                                   
      *         )                                                       
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
      * CHECK WHETHER STORED PROCEDURE RETURNED A RESULT SET                    
           IF SQLCODE = +466 THEN                                       
                                                                        
      *       EXEC SQL                                                  
      *         ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE                
      *         CSR03421                                                
      *       END-EXEC                                                  
                                                                        
      *       EXEC SQL                                                  
      *         ALLOCATE C2 CURSOR FOR RESULT SET :LOC1                 
      *       END-EXEC                                                  
                                                                        
              EXEC SQL FETCH C2 INTO                                    
                   :S-RETURN-CODE                                       
                  ,:S-CONF-NO                                           
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              IF RETURN-CODE = SUCCESSFUL-CALL AND SQLCODE = 0          
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 8100-SEND-RESULT  THRU 8100-EXIT               
                 PERFORM 9999-END-PROGRAM  THRU 9999-EXIT               
              END-IF                                                    
                                                                        
              MOVE S-RETURN-CODE        TO RS-RETURN-CODE               
              MOVE S-CONF-NO            TO RS-CONF-NO                   
              MOVE SPACES               TO S-CONF-NO                    
                                                                        
              EXEC SQL                                                  
                CLOSE C2                                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           ELSE                                                         
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
              PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
           END-IF                                                       
           .                                                            
       0105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * VALIDATE INPUT VARIABLES                                       *        
      *----------------------------------------------------------------*        
       0110-VALIDATE-INPUT.                                             
           MOVE '0110'          TO ACTIVE-PARAGRAPH                     
                                                                        
           IF PARM-ACCOUNT-NO NUMERIC                                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 1001 TO RS-RETURN-CODE                               
              SET INPUT-ERROR TO TRUE                                   
           END-IF                                                       
                                                                        
           IF PARM-AMT-LIHEAP NUMERIC                                   
              MOVE PARM-AMT-LIHEAP         TO WS-AMOUNT-LIHEAP          
              MOVE WS-AMOUNT-LIHEAP-NUM    TO WS-AMOUNT-LIHEAP-COMP3    
              MOVE WS-AMOUNT-LIHEAP-COMP3  TO JT-PAYMENT-AMT            
           ELSE                                                         
              MOVE 1002 TO RS-RETURN-CODE                               
              SET INPUT-ERROR TO TRUE                                   
           END-IF                                                       
                                                                        
           IF WS-AMOUNT-LIHEAP-COMP3 <= 0                               
              MOVE 1003 TO RS-RETURN-CODE                               
              SET INPUT-ERROR TO TRUE                                   
           END-IF                                                       
                                                                        
           IF INPUT-ERROR                                               
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
              PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
              MOVE SPACES TO WS-INPUT-ERROR-SW                          
           END-IF                                                       
           .                                                            
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * POPULATES CSS_PAYMENT_TRANS TABLE VALUES                       *        
      *----------------------------------------------------------------*        
       0150-POPULATE-PYMT-TABLE.                                        
                                                                        
           INITIALIZE DCLCSS-PAYMENT-TRANS                              
                                                                        
           MOVE PARM-TIMESTAMP(1:10)    TO JT-DATE-CASH-REPORT          
           MOVE '998'                   TO JT-CASH-LOCAL-OFFICE         
           MOVE PARM-TIMESTAMP          TO JT-PYMT-RCVD-TS              
           MOVE WS-PROGRAM-NAME         TO JT-APPL-PROGRAM-ID           
           MOVE WS-YES                  TO JT-APPLIED-FL                
           MOVE PARM-PAYMENT-TYPE       TO JT-CURRENCY-TYPE             
           MOVE SPACES                  TO JT-CUST-PHONE-NO             
           MOVE 'UND'                   TO JT-DIRECTED-PYMT-CD          
           MOVE SPACES                  TO JT-ERROR-CD                  
           MOVE RS-CONF-NO              TO JT-PYMT-CONFIRM-NO           
           MOVE PARM-FACILITY-CODE      TO JT-PYMT-FACILITY-CD          
           MOVE LINK-USER-ID            TO JT-LAST-UPDATE-USERID        
           MOVE PARM-COMPANY-NO         TO JT-COMPANY-NO                
           MOVE PARM-PAYMENT-TYPE       TO JT-CURRENCY-TYPE             
           MOVE WS-AMOUNT-LIHEAP-COMP3  TO JT-PAYMENT-AMT               
                                                                        
           IF PARM-ACCOUNT-NO NUMERIC                                   
              MOVE PARM-ACCOUNT-NO      TO WS-ACCOUNT-NO                
              MOVE WS-ACCOUNT-NO-NUM    TO WS-ACCOUNT-NO-COMP3          
              MOVE WS-ACCOUNT-NO-COMP3  TO JT-ACCOUNT-NO                
           ELSE                                                         
              MOVE ZERO                 TO JT-ACCOUNT-NO                
           END-IF                                                       
           .                                                            
       0150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT GL ACCT NO                                              *        
      *----------------------------------------------------------------*        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-USER-ID            TO LI-INITIATED-BY              
           MOVE PARM-CODE-AGENCY-ID     TO LI-CODE-AGENCY-ID            
           MOVE PARM-FACILITY-CODE      TO LI-PYMT-FACILITY-CD          
           MOVE PARM-COMMENT-LEN        TO WS-COMMENT-LEN               
           MOVE PARM-COMMENT-TEXT       TO WS-COMMENT-TEXT              
           MOVE WS-COMMENT-LEN          TO WS-COMMENT-LEN-NUM           
                                                                        
           PERFORM 7100-CAA-GL-NO       THRU 7100-EXIT                  
                                                                        
           MOVE +106                    TO WS-PAR-AR-TRAN-COMMENT-LEN   
                                                                        
           STRING 'AGENCY: '          DELIMITED BY SIZE                 
                  I5-AGENCY-NA        DELIMITED BY SIZE                 
                  '; CONTACT: '       DELIMITED BY SIZE                 
                  LINK-COMMENT-TEXT   DELIMITED BY SIZE                 
                  '; CONFIRMATION # ' DELIMITED BY SIZE                 
                  RS-CONF-NO          DELIMITED BY SIZE                 
                  INTO WS-PAR-AR-TRAN-COMMENT-TEXT                      
                                                                        
           MOVE PARM-PAYMENT-TYPE       TO WS-HOLD-CURRENCY-TYPE        
                                                                        
           MOVE LINK-COMMENT-LEN        TO LI-COMMENT-LEN               
           MOVE LINK-COMMENT-TEXT       TO LI-COMMENT-TEXT              
           MOVE PARM-UPDATE-TYPE        TO WS-UPDATE-TYPE               
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      *----------------------------------------------------------------*        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH                              
                                                                        
           IF DUPLICATE-PAYMENT                                         
              PERFORM 7120-SELECT-PAYMENT    THRU 7120-EXIT             
           END-IF                                                       
                                                                        
      ***********                                                               
      * DO NOT PROCEED IF SYSTEM IS LOCKED                                      
      ***********                                                               
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
           IF AL-AR-LOCKOUT-IND = WS-YES                                
              MOVE 5000 TO RS-RETURN-CODE                               
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
              PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
           END-IF                                                       
                                                                        
           IF SEB-DATABASE                                              
              MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO                 
              MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3           
              MOVE WS-ACCOUNT-NO-COMP3 TO AT-ACCOUNT-NO                 
                                          LI-ACCOUNT-NO                 
              PERFORM 7000-SELECT-AT-PR-CU THRU 7000-EXIT               
              IF LINK-SEB-EXEMPT-FL NOT EQUAL WS-YES                    
                 MOVE '1' TO WS-CODE-DISC-OK                            
                 PERFORM 8000-UPDATE-TBACCT THRU 8000-EXIT              
              END-IF                                                    
                                                                        
              PERFORM 5100-JRNL-TRAN-HEAD THRU 5100-EXIT                
              PERFORM 5300-JRNL-ACCT-DTLS THRU 5300-EXIT                
                                                                        
              MOVE WS-YES                    TO JT-APPLIED-FL           
              MOVE LINK-USER-ID              TO JT-LAST-UPDATE-USERID   
              PERFORM 7120-SELECT-PAYMENT    THRU 7120-EXIT             
              PERFORM 8050-UPDATE-PYMT-TRANS THRU 8050-EXIT             
                                                                        
              PERFORM 2600-MOVE-LIEAP-VALUES THRU 2600-EXIT             
              PERFORM 8150-INSERT-LIEAP      THRU 8150-EXIT             
                                                                        
              MOVE 000                       TO S-RETURN-CODE           
              MOVE WS-NO-ERROR               TO S-ERROR-MESSAGE         
              MOVE SPACES                    TO S-CANCELDNP-FLAG        
              MOVE RS-CONF-NO                TO S-CONF-NO               
              PERFORM 8100-SEND-RESULT       THRU 8100-EXIT             
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF                                                       
                                                                        
           PERFORM 2200-PROCESS THRU 2200-EXIT                          
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * MOVES RESULTS                                                 *         
      *---------------------------------------------------------------*         
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE  RS-RETURN-CODE         TO S-RETURN-CODE                
           MOVE  RS-ERROR-MESSAGE       TO S-ERROR-MESSAGE              
           MOVE  RS-CANCELDNP-FLAG      TO S-CANCELDNP-FLAG             
           MOVE  RS-LIMIT-EXCEED-IND    TO S-LIMIT-EXCEED-IND           
            .                                                           
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      *     BUILD THE RESULT SET DESCRIBED ABOVE                      *         
      *---------------------------------------------------------------*         
       2200-PROCESS.                                                    
           MOVE '2200'              TO ACTIVE-PARAGRAPH                 
                                                                        
           MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO                    
           MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3              
           MOVE WS-ACCOUNT-NO-COMP3 TO AT-ACCOUNT-NO                    
                                       LI-ACCOUNT-NO                    
                                                                        
           PERFORM 7000-SELECT-AT-PR-CU  THRU 7000-EXIT                 
           MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT       
           IF CU-CODE-CUST-STATUS EQUAL WS-S                            
              MOVE WS-YES TO WS-CHRG-OFF-ACCT                           
           END-IF                                                       
                                                                        
           MOVE PARM-AMT-LIHEAP        TO WS-AMOUNT-LIHEAP              
           MOVE WS-AMOUNT-LIHEAP-NUM   TO WS-AMOUNT-LIHEAP-COMP3        
           MOVE WS-AMOUNT-LIHEAP-COMP3 TO WS-AMT-LIHEAP                 
           MOVE WS-AMOUNT-LIHEAP-COMP3 TO WS-PAYMENT-AMOUNT             
                                          WS-PAYMENT-AMOUNT-TOTAL       
                                                                        
           MOVE AT-ACCOUNT-NO TO DL-ACCOUNT-NO                          
           PERFORM 7170-SELECT-RECONNECT THRU 7170-EXIT                 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-YES    TO WS-PAR-RECONNECT-EXIST                  
           END-IF                                                       
                                                                        
           PERFORM 2205-LOAD-GL-NUMBERS THRU 2205-EXIT                  
                                                                        
           MOVE I5-GL-ACCT-NO           TO WS-GL-ACCT-DEBIT             
           MOVE WS-GL-ACCT-DEBIT        TO GO-GL-ACCT-NO                
           PERFORM 7460-SELECT-GL-NAME  THRU 7460-EXIT                  
           MOVE GO-GL-ACCT-NO           TO WS-PAR-GEN-LEDG-DB           
                                                                        
           MOVE PARM-UPDATE-TYPE        TO WS-PAR-UPDATE-TYPE           
           MOVE WS-NO                   TO WS-IS-THIS-DIRECTED-PYMT     
           PERFORM 2210-LOAD-PYMT-PRIORITY THRU 2210-EXIT               
                                                                        
           MOVE WS-NO-ERROR             TO RS-ERROR-MESSAGE             
                                           WS-PAR-MESSAGE-NO            
           PERFORM 5000-UPDATE          THRU 5000-EXIT                  
                                                                        
           MOVE WS-YES                    TO JT-APPLIED-FL              
           MOVE LINK-USER-ID              TO JT-LAST-UPDATE-USERID      
           PERFORM 7120-SELECT-PAYMENT    THRU 7120-EXIT                
           PERFORM 8050-UPDATE-PYMT-TRANS THRU 8050-EXIT                
                                                                        
           MOVE WS-PAR-MESSAGE-NO  TO RS-ERROR-MESSAGE                  
                                                                        
           PERFORM 2255-CREATE-VOUCHER-ENTRY THRU 2255-EXIT             
                                                                        
           MOVE AT-ACCOUNT-NO TO DL-ACCOUNT-NO                          
                                                                        
           MOVE  RS-CONF-NO          TO S-CONF-NO                       
           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                    
           PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                     
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * LOAD ALL G/L NUMBER, INCLUDEING CHARGED OFF                   *         
      *---------------------------------------------------------------*         
       2205-LOAD-GL-NUMBERS.                                            
                                                                        
           PERFORM 9350-LINK-SCSCO061     THRU 9350-EXIT                
                                                                        
           PERFORM VARYING WS-VALID-CO-SUB FROM 1 BY 1                  
              UNTIL WS-VALID-CO-SUB > 5 OR                              
              WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01' OR                
              WS-VALID-CO-NO (WS-VALID-CO-SUB) = WS-GL-99               
              IF WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'                
                 MOVE WS-YES TO WS-COMPANY-IN-TABLE                     
              END-IF                                                    
           END-PERFORM                                                  
           .                                                            
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * LOAD THE PAYMENT PRIORITY TABLE USE PARM-UPDATE-TYPE TO DECIDE*         
      * WHICH SET TO LOAD: B FOR BILLED, A FOR ARREARS, AND U FOR     *         
      * UNDIRECTED SCHEDULE 1 IS FOR BILLED AND UNDIRECTED DUE TO THE *         
      * ORDER PAYMENT IS POSTED.  SCHEDULE 2 IS FOR ARREARS WHICH PAYS*         
      * OFF ALL 90 DAY FIRST, THEN 60 DAYS, ETC.                      *         
      *---------------------------------------------------------------*         
       2210-LOAD-PYMT-PRIORITY.                                         
           IF PARM-UPDATE-TYPE EQUAL WS-A                               
              MOVE 2 TO C9-PMT-PRTY-SCHEDULE                            
           ELSE                                                         
              MOVE 1 TO C9-PMT-PRTY-SCHEDULE                            
           END-IF                                                       
                                                                        
           PERFORM 6722B-OPEN-AR-PMT-PRTY  THRU 6722B-EXIT              
           PERFORM 6722C-FETCH-AR-PMT-PRTY THRU 6722C-EXIT              
           PERFORM 6722D-LOAD-AR-PMT-PRTY  THRU 6722D-EXIT              
              VARYING WS-PAR-SUB FROM 1 BY 1                            
              UNTIL WS-PAR-SUB GREATER THAN 52 OR                       
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                                                                        
           PERFORM 6722E-CLOSE-AR-PMT-PRTY THRU 6722E-EXIT              
           .                                                            
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * CREATES ENTRY IN VOUCHER TABLE                                *         
      *---------------------------------------------------------------*         
       2255-CREATE-VOUCHER-ENTRY.                                       
           MOVE '2255'                  TO ACTIVE-PARAGRAPH             
                                                                        
           MOVE AR-TRANS-HIST-SEQ-NO    TO LI-VOUCHER-PAY-DT            
           MOVE WS-AMOUNT-LIHEAP-COMP3  TO LI-VOUCHER-AMT               
           PERFORM 8130-INSERT-LI-ROW   THRU 8130-EXIT                  
           .                                                            
       2255-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * POPULATES LIEAP TABLE VALUES                                   *        
      *----------------------------------------------------------------*        
       2600-MOVE-LIEAP-VALUES.                                          
                                                                        
            MOVE LINK-ACCOUNT-NO        TO  LI-ACCOUNT-NO               
            MOVE LINK-CODE-AGENCY-ID    TO  LI-CODE-AGENCY-ID           
            MOVE WS-AMOUNT-LIHEAP-COMP3 TO  LI-VOUCHER-AMT              
            MOVE '999999999'            TO  LI-CHECK-NO                 
            MOVE LINK-USER-ID           TO  LI-COMPLETED-BY             
            MOVE LINK-USER-ID           TO  LI-INITIATED-BY             
            MOVE PARM-FACILITY-CODE     TO  LI-PYMT-FACILITY-CD         
            MOVE LINK-COMMENT-LEN       TO  LI-COMMENT-LEN              
            MOVE LINK-COMMENT-TEXT      TO  LI-COMMENT-TEXT             
           .                                                            
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01179*--------------------------------------------------------------*          
A01179* CALLS SUB PROGRAMS MCS03413 TO HANDLE DNP/RECONNECT REAL TIME*          
A01179*--------------------------------------------------------------*          
A01179 2950-PROCESS-DNP-RECONNECT.                                      
A01179                                                                  
ACT285* Populate WS variable to call CPD03414                                   
A01179     MOVE 0                           TO WS-DNP-RET-CODE          
A01179     MOVE AT-ACCOUNT-NO               TO WS-ACCOUNT-NO-NUM        
ACT285     MOVE 'P'                         TO WS-UPDATE-ACTION-FL      
ACT285     MOVE 'O'                         TO WS-CALL-TYPE             
ACT285     MOVE 'Y'                         TO WS-CPD68-REQUIRED        
ACT285     MOVE PROGRAM-NAME                TO WS-PROGRAM-NAME          
ACT285     MOVE SPACES                      TO ws-APPL-PROGRAM-ID       
P00948     MOVE 'N'                         TO WS-CNCL-DNP-EMAIL-REQ-FL 
A01179                                                                  
ACT285     PERFORM 9800-CALL-MCS03414                                   
A01179        THRU 9800-EXIT                                            
A01179                                                                  
A01179     MOVE WS-DNP-RET-CODE             TO S-RETURN-CODE            
A01179     .                                                            
A01179 2950-EXIT.                                                       
A01179     EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * POSTS PAYMENT AND JOURNALING                                   *        
      *----------------------------------------------------------------*        
       5000-UPDATE.                                                     
           MOVE '5000'        TO ACTIVE-PARAGRAPH                       
                                                                        
           MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO                      
           MOVE 9             TO WS-TRAN-OPER-LEVEL                     
           MOVE 1             TO WS-TRAN-OCAP-FIELD                     
           MOVE 1             TO WS-TRAN-OCAP-VALUE                     
           MOVE WS-C          TO WS-TRAN-JRNL-TYPE                      
           MOVE WS-N          TO WS-TRAN-HOLD-EXEMPT-FLAG               
                                                                        
           MOVE PARM-USER-ID       TO WS-JRNL-OL-TEMP-ID                
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST            
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
           MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC                       
                                                                        
           MOVE '01'                   TO   WS-JRNL-OL-COMPANY          
                                            WS-PAR-COMPANY-NO           
           MOVE '998'                  TO   WS-JRNL-OL-LOC-OFF          
                                            WS-PAR-LOCAL-OFFICE         
           MOVE '998'                  TO   WS-JRNL-OL-REPORT-NO        
                                            WS-PAR-REPORT-NO            
           MOVE WS-CURRENT-DATE        TO   WS-JRNL-OL-REPORT-DT        
                                            WS-PAR-REPORT-DATE          
           MOVE 9999                   TO   WS-JRNL-OL-CASH-DRWR        
                                            WS-PAR-CASH-DRAWER          
                                                                        
           MOVE WS-TERM-LOC            TO   WS-JRNL-OL-TERM-LOC         
                                            WS-JRNL-OL-CASH-LOC         
                                            WS-JRNL-OL-OPR-LOC          
           MOVE WS-JRNL-VALIDATE-OPER TO    WS-JRNL-OPERATION-RQST      
           MOVE WS-C                  TO    WS-JRNL-SOURCE-CODE         
                                                                        
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE      
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE      
           END-IF                                                       
           PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT             
                                                                        
           MOVE WS-A            TO WS-100-JRNL-SORT-ID                  
           MOVE AT-ACCOUNT-NO   TO WS-100-ACCT-NO                       
           MOVE AT-CUSTOMER-NO  TO WS-100-CUSTOMER-NO                   
           MOVE AT-PREMISE-NO   TO WS-100-PREMISE-NO                    
A03578     MOVE '3707'          TO WS-PAR-EIBTRNID                      
           ADD 1                TO WS-100-JRNL-TRAN-APPL-NO             
           MOVE WS-CURRENT-DATE TO WS-100-DATE-LAST-ACTION              
                                   AT-DATE-LAST-ACTION                  
           MOVE WS-C            TO WS-100-CODE-ENTRY-SOURCE             
           MOVE AT-LOCAL-OFFICE TO WS-100-LOCAL-OFFICE-CD               
                                                                        
           MOVE WS-TERM-LOC             TO WS-PAR-ACCESS-LOC            
           MOVE PARM-USER-ID            TO WS-PAR-OPERATOR-ID           
           MOVE PF-RESP-AREA-ID         TO WS-PAR-RESP-AREA             
           MOVE PARM-APPLICATION-ID     TO WS-PAR-APPL-PROG-ID          
           MOVE PARM-FACILITY-CODE      TO WS-PAR-PYMT-FACILITY-CD      
                                                                        
           MOVE WS-PAR-P                TO WS-PAR-CODE-TRAN-TYPE        
                                                                        
           PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT                    
           PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT             
           MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST            
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5000'                TO ACTIVE-PARAGRAPH           
               MOVE 'USERABEN'            TO ABEND-FUNCTION             
               MOVE WS-YES                TO WS-USER-FORCE-ABEND        
               MOVE SPACES                TO DSNTIAR-MESSAGE-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
            END-IF                                                      
           .                                                            
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CHECKS WHETHER PAYMENT WAS SUCESSFUL                           *        
      *----------------------------------------------------------------*        
       5001-CHECK-PAYMENT-RETURN.                                       
           IF PYMT-WAS-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '5001'                  TO ACTIVE-PARAGRAPH          
              MOVE 'USERABEN'              TO ABEND-FUNCTION            
              MOVE WS-YES                  TO WS-USER-FORCE-ABEND       
              MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF                                                       
           .                                                            
       5001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *     JOURNALS THE MAINTENANCE TRANSACTION HEADER                *        
      *----------------------------------------------------------------*        
       5100-JRNL-TRAN-HEAD.                                             
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH                              
                                                                        
           PERFORM 7300-SELECT-CUR-TIMESTAMP    THRU 7300-EXIT          
           PERFORM 7400-SELECT-CUR-DATE         THRU 7400-EXIT          
           MOVE 1                               TO WS-TRAN-APPL-NO      
                                                   MI-TRAN-APPL-NO      
           MOVE WS-TRANS-HIST-SEQ-NO            TO MH-TRANS-HIST-SEQ-NO 
           MOVE WS-DATE-TRANS                   TO MH-DATE-TRANS        
           MOVE 'F'                             TO MH-CODE-TRAN-TYPE    
           MOVE SPACES                          TO MH-RESP-AREA-ID      
           MOVE WS-ACCOUNT-NO-COMP3             TO MH-ACCOUNT-NO        
           MOVE ZEROS                           TO MH-CUSTOMER-NO       
           MOVE ZEROS                           TO MH-PREMISE-NO        
           MOVE LINK-USER-ID                    TO MH-USER-ID           
           MOVE PARM-APPLICATION-ID             TO MH-APPL-PROGRAM-ID   
                                                                        
           MOVE WS-AMOUNT-LIHEAP-NUM    TO WS-DISP-AMOUNT               
                                                                        
           MOVE +135                    TO MH-TRAN-COMMENT-LEN          
                                                                        
           STRING 'AGENCY: '           DELIMITED BY SIZE                
                  I5-AGENCY-NA         DELIMITED BY SIZE                
                  '; CONTACT: '        DELIMITED BY SIZE                
                  LINK-COMMENT-TEXT    DELIMITED BY SIZE                
                  '; PLEDGE AMOUNT: $' DELIMITED BY SIZE                
                  WS-DISP-AMOUNT       DELIMITED BY SIZE                
                  '; CONFIRMATION # '  DELIMITED BY SIZE                
                  RS-CONF-NO           DELIMITED BY SIZE                
                                  INTO MH-TRAN-COMMENT-TEXT             
           .                                                            
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *     JOURNALS THE MAINTENANCE TRANSACTION DETAILS FOR ACCOUNT   *        
      *----------------------------------------------------------------*        
       5300-JRNL-ACCT-DTLS.                                             
                                                                        
           MOVE '5300' TO ACTIVE-PARAGRAPH                              
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO      
           IF WS-CODE-DISC-OK   NOT = AT-CODE-DISC-OK                   
              AND LINK-SEB-EXEMPT-FL NOT EQUAL 'Y'                      
                                                                        
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'DISCONNECT EXMPTN'     TO MI-COLUMN-DESC            
              MOVE '12'                    TO MI-TABLE-ID               
              MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN   
              IF WS-CODE-DISC-OK   <= SPACES                            
                 MOVE 1                    TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE SPACES               TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-CODE-DISC-OK      TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF AT-CODE-DISC-OK > SPACES                               
                 MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE AT-CODE-DISC-OK      TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE 1                    TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE SPACES               TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
           ELSE                                                         
              PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT         
           END-IF                                                       
           .                                                            
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 6100-COMPUTE-REBATE-AMOUNT                                     *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE CPD00003                                                   
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * 6400-ONLINE--JRNL-ROUTINE                                      *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE CPD0006A                                                   
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * 6500-ONLINE-LOAD-AR-TRAN-HIST                                  *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPD00008                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * 6700-APPLY-PAYMENT                                             *        
      *----------------------------------------------------------------*        
       COPY CPD00010.                                                           
                                                                        
      *----------------------------------------------------------------*        
      * THIS COPYBOOK CONTAINS THE SQLS FOR CPD00010                   *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPD0010S                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * 6800-APPLY-PYMT-CO                                             *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPD00073                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * 7999-SELECT-AL SELECTS AR LOCKOUT                              *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPD00075                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * SELECT ACCOUNT, PREMISE AND CUSTOMER DETAILS                   *        
      *----------------------------------------------------------------*        
       7000-SELECT-AT-PR-CU.                                            
           EXEC SQL                                                     
              SELECT AT.CUSTOMER_NO,                                    
                     AT.CODE_ACCT_STAT,                                 
                     AT.TOTAL_AR_BALANCE,                               
                     AT.DATE_LAST_ACTION,                               
                     AT.LOCAL_OFFICE,                                   
                     AT.PREMISE_NO,                                     
                     AT.CODES_DATA_PRESENT,                             
                     AT.COMPANY_NO,                                     
                     AT.AR_XFER_IND,                                    
                     AT.ACCT_XFER_TO,                                   
                     AT.BANKRUPTCY_IND,                                 
                     AT.CREDIT_GROUP,                                   
                     AT.DATE_BILL_DAY_00,                               
                     AT.DATE_BILL_DAY_30,                               
                     AT.DATE_BILL_DAY_60,                               
                     AT.DATE_BILL_DAY_90,                               
                     AT.NOTICE_EXEMPT_CD,                               
                     AT.CODE_DISC_OK,                                   
                     AT.IVR_EXEMPT_CD,                                  
                     PR.CODE_PREMISE_STAT,                              
                     PR.REV_DISTRICT_CD,                                
                     CU.CODE_EMPL_ACCT,                                 
                     CU.CODE_CUST_STATUS,                               
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
             INTO    :AT-CUSTOMER-NO,                                   
                     :AT-CODE-ACCT-STAT,                                
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-DATE-LAST-ACTION,                              
                     :AT-LOCAL-OFFICE,                                  
                     :AT-PREMISE-NO,                                    
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-COMPANY-NO,                                    
                     :AT-AR-XFER-IND,                                   
                     :AT-ACCT-XFER-TO,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-CREDIT-GROUP,                                  
                     :AT-DATE-BILL-DAY-00 :WS-NULL-IND1,                 
                     :AT-DATE-BILL-DAY-30 :WS-NULL-IND2,                 
                     :AT-DATE-BILL-DAY-60 :WS-NULL-IND3,                 
                     :AT-DATE-BILL-DAY-90 :WS-NULL-IND4,                 
                     :AT-NOTICE-EXEMPT-CD,                              
                     :AT-CODE-DISC-OK,                                  
                     :AT-IVR-EXEMPT-CD,                                 
                     :PR-CODE-PREMISE-STAT,                             
                     :PR-REV-DISTRICT-CD,                               
                     :CU-CODE-EMPL-ACCT,                                
                     :CU-CODE-CUST-STATUS,                              
                     :WS-CURRENT-DATE                                   
            FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED), CSS_PREMISE PR
                           WITH(READUNCOMMITTED), CSS_CUSTOMER CU
                           WITH(READUNCOMMITTED)        
            WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO AND                   
                  AT.PREMISE_NO  = PR.PREMISE_NO  AND                   
                  AT.CUSTOMER_NO = CU.CUSTOMER_NO                       
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CUSTOMER_NO,                                            
MFA-TR*              AT.CODE_ACCT_STAT,                                         
MFA-TR*              AT.TOTAL_AR_BALANCE,                                       
MFA-TR*              AT.DATE_LAST_ACTION,                                       
MFA-TR*              AT.LOCAL_OFFICE,                                           
MFA-TR*              AT.PREMISE_NO,                                             
MFA-TR*              AT.CODES_DATA_PRESENT,                                     
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              AT.AR_XFER_IND,                                            
MFA-TR*              AT.ACCT_XFER_TO,                                           
MFA-TR*              AT.BANKRUPTCY_IND,                                         
MFA-TR*              AT.CREDIT_GROUP,                                           
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              AT.DATE_BILL_DAY_30,                                       
MFA-TR*              AT.DATE_BILL_DAY_60,                                       
MFA-TR*              AT.DATE_BILL_DAY_90,                                       
MFA-TR*              AT.NOTICE_EXEMPT_CD,                                       
MFA-TR*              AT.CODE_DISC_OK,                                           
MFA-TR*              AT.IVR_EXEMPT_CD,                                          
MFA-TR*              PR.CODE_PREMISE_STAT,                                      
MFA-TR*              PR.REV_DISTRICT_CD,                                        
MFA-TR*              CU.CODE_EMPL_ACCT,                                         
MFA-TR*              CU.CODE_CUST_STATUS,                                       
MFA-TR*              CURRENT DATE                                               
MFA-TR*      INTO    :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-TOTAL-AR-BALANCE,                                      
MFA-TR*              :AT-DATE-LAST-ACTION,                                      
MFA-TR*              :AT-LOCAL-OFFICE,                                          
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-CODES-DATA-PRESENT,                                    
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-AR-XFER-IND,                                           
MFA-TR*              :AT-ACCT-XFER-TO,                                          
MFA-TR*              :AT-BANKRUPTCY-IND,                                        
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-DATE-BILL-DAY-00:WS-NULL-IND1,                         
MFA-TR*              :AT-DATE-BILL-DAY-30:WS-NULL-IND2,                         
MFA-TR*              :AT-DATE-BILL-DAY-60:WS-NULL-IND3,                         
MFA-TR*              :AT-DATE-BILL-DAY-90:WS-NULL-IND4,                         
MFA-TR*              :AT-NOTICE-EXEMPT-CD,                                      
MFA-TR*              :AT-CODE-DISC-OK,                                          
MFA-TR*              :AT-IVR-EXEMPT-CD,                                         
MFA-TR*              :PR-CODE-PREMISE-STAT,                                     
MFA-TR*              :PR-REV-DISTRICT-CD,                                       
MFA-TR*              :CU-CODE-EMPL-ACCT,                                        
MFA-TR*              :CU-CODE-CUST-STATUS,                                      
MFA-TR*              :WS-CURRENT-DATE                                           
MFA-TR*     FROM CSS_ACCOUNT AT, CSS_PREMISE PR, CSS_CUSTOMER CU                
MFA-TR*     WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO AND                           
MFA-TR*           AT.PREMISE_NO  = PR.PREMISE_NO  AND                           
MFA-TR*           AT.CUSTOMER_NO = CU.CUSTOMER_NO                               
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND1 EQUAL -1                                  
                 MOVE SPACES            TO AT-DATE-BILL-DAY-00          
              END-IF                                                    
              IF WS-NULL-IND2 EQUAL -1                                  
                 MOVE SPACES            TO AT-DATE-BILL-DAY-30          
              END-IF                                                    
              IF WS-NULL-IND3 EQUAL -1                                  
                 MOVE SPACES            TO AT-DATE-BILL-DAY-60          
              END-IF                                                    
              IF WS-NULL-IND4 EQUAL -1                                  
                 MOVE SPACES            TO AT-DATE-BILL-DAY-90          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'CSS_PREMISE'         TO TABLE-2                     
              MOVE 'CSS_CUSTOMER'        TO TABLE-3                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS THE DELINQ VALUE FOR A GIVEN DELINQ CODE               *        
      *----------------------------------------------------------------*        
       7070-GET-DELINQ-VALUE.                                           
                                                                        
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
               INTO :C8-DELINQ-VALUE                                    
               FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
              WHERE DELINQ_CD  = :C8-DELINQ-CD                          
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DELINQ_VALUE                                                
MFA-TR*        INTO :C8-DELINQ-VALUE                                            
MFA-TR*        FROM CSS_DELINQUENCY                                             
MFA-TR*       WHERE DELINQ_CD  = :C8-DELINQ-CD                                  
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1           
              MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*          
      * GET AGENCY GL NO TO BE USED AS THE DEBIT GL                  *          
      *--------------------------------------------------------------*          
       7100-CAA-GL-NO.                                                  
           MOVE LI-CODE-AGENCY-ID  TO  I5-CODE-AGENCY-ID                
           MOVE LINK-COMPANY-NO    TO  I5-COMPANY-NO                    
                                                                        
           EXEC SQL                                                     
             SELECT GL_ACCT_NO                                          
                   ,AGENCY_NA                                           
               INTO :I5-GL-ACCT-NO                                      
                   ,:I5-AGENCY-NA                                       
               FROM CSS_LIEAP_AGENCY WITH(READUNCOMMITTED)                      
              WHERE CODE_AGENCY_ID     = :I5-CODE-AGENCY-ID             
                AND COMPANY_NO         = :I5-COMPANY-NO                 
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT GL_ACCT_NO                                                  
MFA-TR*            ,AGENCY_NA                                                   
MFA-TR*        INTO :I5-GL-ACCT-NO                                              
MFA-TR*            ,:I5-AGENCY-NA                                               
MFA-TR*        FROM CSS_LIEAP_AGENCY                                            
MFA-TR*       WHERE CODE_AGENCY_ID     = :I5-CODE-AGENCY-ID                     
MFA-TR*         AND COMPANY_NO         = :I5-COMPANY-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_LIEAP_AGENCY'        TO TABLE-1                 
              MOVE 'CODE_AGENCY_ID'          TO TABLE-ELEMENT-1         
              MOVE I5-CODE-AGENCY-ID         TO HOSTVAR-ELEMENT-1       
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE I5-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * CHECKS WHETHER THE PAYMENT IS ALREADY POSTED TO AVOID DOUBLE  *         
      * POSTING, IF PAYMENT ALREADY POSTED THEN ABEND THE FUNCTION.   *         
      *---------------------------------------------------------------*         
       7120-SELECT-PAYMENT.                                             
                                                                        
           EXEC SQL                                                     
             SELECT ACCOUNT_NO                                          
               INTO :JT-ACCOUNT-NO                                      
               FROM CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                     
              WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )            
                AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           
                AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )                
                AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  
                AND APPL_PROGRAM_ID   = :JT-APPL-PROGRAM-ID             
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT ACCOUNT_NO                                                  
MFA-TR*        INTO :JT-ACCOUNT-NO                                              
MFA-TR*        FROM CSS_PAYMENT_TRANS                                           
MFA-TR*       WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE                   
MFA-TR*         AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                        
MFA-TR*         AND ACCOUNT_NO        = :JT-ACCOUNT-NO                          
MFA-TR*         AND APPL_PROGRAM_ID   = :JT-APPL-PROGRAM-ID                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR ( WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
              AND DUPLICATE-PAYMENT)                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_PAYMENT_TRANS'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE JT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'PYMT_RCVD_TS'             TO TABLE-ELEMENT-2        
              MOVE JT-PYMT-RCVD-TS            TO HOSTVAR-ELEMENT-2      
              MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-3        
              MOVE JT-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3      
              MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4        
              MOVE JT-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DETERMINE IF ACCOUNT IS SEB REGULATED PROVIDER                 *        
      *----------------------------------------------------------------*        
       7150-CHECK-SEB-REG.                                              
                                                                        
           MOVE '7150'                 TO ACTIVE-PARAGRAPH              
           MOVE AT-ACCOUNT-NO          TO LR-ACCOUNT-NO                 
                                                                        
           EXEC SQL                                                     
             SELECT REG_GROUP_CD                                        
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), GROUP_EFF_TS
           , 121), ' ', '-'), ':', '.') GROUP_EFF_TS                           
                    ,SENIOR_FL                                          
               INTO :LR-REG-GROUP-CD                                    
                    ,:LR-GROUP-EFF-TS                                   
                    ,:LR-SENIOR-FL                                      
               FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                         
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT REG_GROUP_CD                                                
MFA-TR*             ,GROUP_EFF_TS                                               
MFA-TR*             ,SENIOR_FL                                                  
MFA-TR*        INTO :LR-REG-GROUP-CD                                            
MFA-TR*             ,:LR-GROUP-EFF-TS                                           
MFA-TR*             ,:LR-SENIOR-FL                                              
MFA-TR*        FROM CSS_REG_PROFILE                                             
MFA-TR*       WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 'Y' TO WS-SEB-REGULATED-FL                           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'N' TO WS-SEB-REGULATED-FL                        
              ELSE                                                      
                 MOVE PROGRAM-NAME        TO ABEND-PROGRAM              
                 MOVE 'SELECT'            TO ABEND-FUNCTION             
                 MOVE 'CSS_REG_PROFILE'   TO TABLE-1                    
                 MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
                 MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF                                                       
           .                                                            
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CHECKS FOR A RECONNECT EXISTENCE                               *        
      *----------------------------------------------------------------*        
       7170-SELECT-RECONNECT.                                           
           EXEC SQL                                                     
             SELECT AMT_TOT_RECONNECT,                                  
                    RECNCT_COLLECT_AMT                                  
               INTO :DL-AMT-TOT-RECONNECT,                              
                    :DL-RECNCT-COLLECT-AMT                              
               FROM CSS_RECONNECT WITH(READUNCOMMITTED)                         
              WHERE ACCOUNT_NO = :DL-ACCOUNT-NO                         
                AND AMT_TOT_RECONNECT  > 0                              
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AMT_TOT_RECONNECT,                                          
MFA-TR*             RECNCT_COLLECT_AMT                                          
MFA-TR*        INTO :DL-AMT-TOT-RECONNECT,                                      
MFA-TR*             :DL-RECNCT-COLLECT-AMT                                      
MFA-TR*        FROM CSS_RECONNECT                                               
MFA-TR*       WHERE ACCOUNT_NO = :DL-ACCOUNT-NO                                 
MFA-TR*         AND AMT_TOT_RECONNECT  > 0                                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7170'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_RECONNECT'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS CURRENT TIMESTAMP                                      *        
      *----------------------------------------------------------------*        
       7300-SELECT-CUR-TIMESTAMP.                                       
                                                                        
           MOVE '7300' TO ACTIVE-PARAGRAPH                              
                                                                        
           EXEC SQL                                                     
             SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRANS-HIST-SEQ-NO                               
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      VALUES CURRENT TIMESTAMP                                           
MFA-TR*        INTO :WS-TRANS-HIST-SEQ-NO                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE SPACES                       TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS CURRENT DATE                                           *        
      *----------------------------------------------------------------*        
       7400-SELECT-CUR-DATE.                                            
                                                                        
           MOVE '7400' TO ACTIVE-PARAGRAPH                              
                                                                        
           EXEC SQL                                                     
             SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-TRANS                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      VALUES CURRENT DATE                                                
MFA-TR*        INTO :WS-DATE-TRANS                                              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE SPACES                       TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT THE GL NAME FOR GIVEN GL NO                             *        
      *----------------------------------------------------------------*        
       7460-SELECT-GL-NAME.                                             
           MOVE '7460'               TO ACTIVE-PARAGRAPH                
                                                                        
           EXEC SQL                                                     
             SELECT GL_ACCT_NAME                                        
               INTO :GO-GL-ACCT-NAME                                    
               FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                        
              WHERE GL_ACCT_NO  = :GO-GL-ACCT-NO                        
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT GL_ACCT_NAME                                                
MFA-TR*        INTO :GO-GL-ACCT-NAME                                            
MFA-TR*        FROM CSS_GL_ACCT_NO                                              
MFA-TR*       WHERE GL_ACCT_NO  = :GO-GL-ACCT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1                
              MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE GO-GL-ACCT-NO              TO WS-GO-GL-ACCT-NO-ED    
              MOVE WS-GO-GL-ACCT-NO-ED        TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF                                                       
           .                                                            
       7460-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * UPDATE EXEMPT FIELD OF ACCOUNT TABLE                           *        
      *----------------------------------------------------------------*        
       8000-UPDATE-TBACCT.                                              
                                                                        
           MOVE '8000' TO ACTIVE-PARAGRAPH                              
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ACCOUNT                                         
                SET CODE_DISC_OK = :WS-CODE-DISC-OK                     
              WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * INSERT A ROW IN TO PAYMENT TRANS TABLE                         *        
      *----------------------------------------------------------------*        
       8020-INSERT-PAYMENT.                                             
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_PAYMENT_TRANS                              
                  (                                                     
                   DATE_CASH_REPORT                                     
                  ,CASH_LOCAL_OFFICE                                    
                  ,PYMT_RCVD_TS                                         
                  ,ACCOUNT_NO                                           
                  ,APPL_PROGRAM_ID                                      
                  ,APPLIED_FL                                           
                  ,COMPANY_NO                                           
                  ,CREDIT_CARD_TYPE                                     
                  ,CURRENCY_TYPE                                        
                  ,CUST_PHONE_NO                                        
                  ,DIRECTED_PYMT_CD                                     
                  ,ERROR_CD                                             
                  ,PAYMENT_AMT                                          
                  ,PYMT_CONFIRM_NO                                      
                  ,PYMT_FACILITY_CD                                     
                  ,LAST_UPDATE_USERID                                   
                  ,ORIG_PYMT_TS                                         
                  ,RECONCILED_FL                                        
                  ,TRANS_HIST_SEQ_NO                                    
                  ,TRANS_TYPE_CD                                        
                  )                                                     
             VALUES                                                     
                  (                                                     
                   IIF(TRY_CONVERT(DATE, :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )                         
                  ,:JT-CASH-LOCAL-OFFICE                                
                  ,CIS.CHAR2TIMESTAMP(:JT-PYMT-RCVD-TS)                         
                  ,:JT-ACCOUNT-NO                                       
                  ,:JT-APPL-PROGRAM-ID                                  
                  ,:JT-APPLIED-FL                                       
                  ,:JT-COMPANY-NO                                       
                  ,:JT-CREDIT-CARD-TYPE                                 
                  ,:JT-CURRENCY-TYPE                                    
                  ,:JT-CUST-PHONE-NO                                    
                  ,:JT-DIRECTED-PYMT-CD                                 
                  ,:JT-ERROR-CD                                         
                  ,:JT-PAYMENT-AMT                                      
                  ,:JT-PYMT-CONFIRM-NO                                  
                  ,:JT-PYMT-FACILITY-CD                                 
                  ,:JT-LAST-UPDATE-USERID                               
                  ,NULL                                                 
                  ,'N'                                                  
                  ,NULL                                                 
                  ,'P'                                                  
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_PAYMENT_TRANS                                      
MFA-TR*           (                                                             
MFA-TR*            DATE_CASH_REPORT                                             
MFA-TR*           ,CASH_LOCAL_OFFICE                                            
MFA-TR*           ,PYMT_RCVD_TS                                                 
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,APPL_PROGRAM_ID                                              
MFA-TR*           ,APPLIED_FL                                                   
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CREDIT_CARD_TYPE                                             
MFA-TR*           ,CURRENCY_TYPE                                                
MFA-TR*           ,CUST_PHONE_NO                                                
MFA-TR*           ,DIRECTED_PYMT_CD                                             
MFA-TR*           ,ERROR_CD                                                     
MFA-TR*           ,PAYMENT_AMT                                                  
MFA-TR*           ,PYMT_CONFIRM_NO                                              
MFA-TR*           ,PYMT_FACILITY_CD                                             
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,ORIG_PYMT_TS                                                 
MFA-TR*           ,RECONCILED_FL                                                
MFA-TR*           ,TRANS_HIST_SEQ_NO                                            
MFA-TR*           ,TRANS_TYPE_CD                                                
MFA-TR*           )                                                             
MFA-TR*      VALUES                                                             
MFA-TR*           (                                                             
MFA-TR*            :JT-DATE-CASH-REPORT                                         
MFA-TR*           ,:JT-CASH-LOCAL-OFFICE                                        
MFA-TR*           ,:JT-PYMT-RCVD-TS                                             
MFA-TR*           ,:JT-ACCOUNT-NO                                               
MFA-TR*           ,:JT-APPL-PROGRAM-ID                                          
MFA-TR*           ,:JT-APPLIED-FL                                               
MFA-TR*           ,:JT-COMPANY-NO                                               
MFA-TR*           ,:JT-CREDIT-CARD-TYPE                                         
MFA-TR*           ,:JT-CURRENCY-TYPE                                            
MFA-TR*           ,:JT-CUST-PHONE-NO                                            
MFA-TR*           ,:JT-DIRECTED-PYMT-CD                                         
MFA-TR*           ,:JT-ERROR-CD                                                 
MFA-TR*           ,:JT-PAYMENT-AMT                                              
MFA-TR*           ,:JT-PYMT-CONFIRM-NO                                          
MFA-TR*           ,:JT-PYMT-FACILITY-CD                                         
MFA-TR*           ,:JT-LAST-UPDATE-USERID                                       
MFA-TR*           ,NULL                                                         
MFA-TR*           ,'N'                                                          
MFA-TR*           ,NULL                                                         
MFA-TR*           ,'P'                                                          
MFA-TR*           )                                                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
              IF WS-ACTIVE-RETURN-CODE =  -803                          
                 SET DUPLICATE-PAYMENT       TO TRUE                    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PAYMENT_TRANS'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE JT-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE JT-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE 'PYMT_RCVD_TS'            TO TABLE-ELEMENT-3         
              MOVE JT-PYMT-RCVD-TS           TO HOSTVAR-ELEMENT-3       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE JT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * UPDATE APPLIED FL,TS AND USER ID OF PAYMENT TRANS TABLE        *        
      *----------------------------------------------------------------*        
       8050-UPDATE-PYMT-TRANS.                                          
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_PAYMENT_TRANS                                   
                SET APPLIED_FL         = :JT-APPLIED-FL                 
                   ,APPLIED_TS         = CIS.CURRENT$TIMESTAMP()              
                   ,LAST_UPDATE_USERID = :JT-LAST-UPDATE-USERID         
              WHERE DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )           
                AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE          
                AND PYMT_RCVD_TS       = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
                AND APPL_PROGRAM_ID    = :JT-APPL-PROGRAM-ID            
                AND ACCOUNT_NO         = :JT-ACCOUNT-NO                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_PAYMENT_TRANS                                           
MFA-TR*         SET APPLIED_FL         = :JT-APPLIED-FL                         
MFA-TR*            ,APPLIED_TS         = CURRENT TIMESTAMP                      
MFA-TR*            ,LAST_UPDATE_USERID = :JT-LAST-UPDATE-USERID                 
MFA-TR*       WHERE DATE_CASH_REPORT   = :JT-DATE-CASH-REPORT                   
MFA-TR*         AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE                  
MFA-TR*         AND PYMT_RCVD_TS       = :JT-PYMT-RCVD-TS                       
MFA-TR*         AND APPL_PROGRAM_ID    = :JT-APPL-PROGRAM-ID                    
MFA-TR*         AND ACCOUNT_NO         = :JT-ACCOUNT-NO                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PAYMENT_TRANS'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE JT-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE JT-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE 'PYMT_RCVD_TS'            TO TABLE-ELEMENT-3         
              MOVE JT-PYMT-RCVD-TS           TO HOSTVAR-ELEMENT-3       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE JT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00575*---------------------------------------------------------------*         
A00575* UPDATES ERROR CODE WITH CANCEL DNP FLAG INDICATOR VALUE       *         
      *---------------------------------------------------------------*         
                                                                        
       8110-UPDATE-DNP-CODE.                                            
                                                                        
           MOVE 'Y' TO JT-ERROR-CD(2:1)                                 
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_PAYMENT_TRANS                                   
                SET ERROR_CD = :JT-ERROR-CD                             
              WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )            
                AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           
                AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )                
                AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_PAYMENT_TRANS                                           
MFA-TR*         SET ERROR_CD = :JT-ERROR-CD                                     
MFA-TR*       WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE                   
MFA-TR*         AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                        
MFA-TR*         AND ACCOUNT_NO        = :JT-ACCOUNT-NO                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_PAYMENT_TRANS'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE JT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'PYMT_RCVD_TS'             TO TABLE-ELEMENT-2        
              MOVE JT-PYMT-RCVD-TS            TO HOSTVAR-ELEMENT-2      
              MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-3        
              MOVE JT-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3      
              MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4        
              MOVE JT-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
A00575 8110-EXIT.                                                       
A00575     EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * INSERTS A ROW IN VOUCHER TABLE                                 *        
      *----------------------------------------------------------------*        
       8130-INSERT-LI-ROW.                                              
           MOVE '8130'               TO ACTIVE-PARAGRAPH                
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_LIEAP                                      
             (                                                          
              ACCOUNT_NO                                                
             ,VOUCHER_PAY_DT                                            
             ,VOUCHER_AMT                                               
             ,INITIATED_BY                                              
             ,CODE_AGENCY_ID                                            
             ,PYMT_FACILITY_CD                                          
             ,COMMENT                                                   
             )                                                          
             VALUES                                                     
                  (:LI-ACCOUNT-NO                                       
                  ,CIS.CHAR2TIMESTAMP(:LI-VOUCHER-PAY-DT)                       
                  ,:LI-VOUCHER-AMT                                      
                  ,:LI-INITIATED-BY                                     
                  ,:LI-CODE-AGENCY-ID                                   
                  ,:LI-PYMT-FACILITY-CD                                 
                  ,:LI-COMMENT  )                                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_LIEAP                                              
MFA-TR*      (                                                                  
MFA-TR*       ACCOUNT_NO                                                        
MFA-TR*      ,VOUCHER_PAY_DT                                                    
MFA-TR*      ,VOUCHER_AMT                                                       
MFA-TR*      ,INITIATED_BY                                                      
MFA-TR*      ,CODE_AGENCY_ID                                                    
MFA-TR*      ,PYMT_FACILITY_CD                                                  
MFA-TR*      ,COMMENT                                                           
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*           (:LI-ACCOUNT-NO                                               
MFA-TR*           ,:LI-VOUCHER-PAY-DT                                           
MFA-TR*           ,:LI-VOUCHER-AMT                                              
MFA-TR*           ,:LI-INITIATED-BY                                             
MFA-TR*           ,:LI-CODE-AGENCY-ID                                           
MFA-TR*           ,:LI-PYMT-FACILITY-CD                                         
MFA-TR*           ,:LI-COMMENT  )                                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE                
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_LIEAP'                TO TABLE-1                
              MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
              MOVE 'VOUCHER_PAY_DT'           TO TABLE-ELEMENT-2        
              MOVE 'INITIATED_BY'             TO TABLE-ELEMENT-3        
              MOVE 'CODE_AGENCY_ID'           TO TABLE-ELEMENT-4        
              MOVE LI-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE LI-VOUCHER-PAY-DT          TO HOSTVAR-ELEMENT-2      
              MOVE LI-INITIATED-BY            TO HOSTVAR-ELEMENT-3      
              MOVE LI-CODE-AGENCY-ID          TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF                                                       
           .                                                            
       8130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * INSERTS A ROW IN VOUCHER TABLE                                 *        
      *----------------------------------------------------------------*        
       8150-INSERT-LIEAP.                                               
           MOVE '8150'               TO ACTIVE-PARAGRAPH                
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_LIEAP                                      
             (                                                          
             ACCOUNT_NO                                                 
             ,VOUCHER_PAY_DT                                            
             ,CODE_AGENCY_ID                                            
             ,VOUCHER_AMT                                               
             ,REIMBURSE_DT                                              
             ,CHECK_NO                                                  
             ,COMPLETED_BY                                              
             ,INITIATED_BY                                              
             ,PYMT_FACILITY_CD                                          
             ,LAST_UPDATE_TS                                            
             ,COMMENT                                                   
             )                                                          
             VALUES                                                     
             (                                                          
             :LI-ACCOUNT-NO                                             
             ,CIS.CURRENT$TIMESTAMP()                                         
             ,:LI-CODE-AGENCY-ID                                        
             ,:LI-VOUCHER-AMT                                           
             ,CAST(SYSDATETIMEOFFSET() AS DATE)                                 
             ,:LI-CHECK-NO                                              
             ,:LI-COMPLETED-BY                                          
             ,:LI-INITIATED-BY                                          
             ,:LI-PYMT-FACILITY-CD                                      
             ,CIS.CURRENT$TIMESTAMP()                                         
             ,:LI-COMMENT                                               
             )                                                          
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_LIEAP                                              
MFA-TR*      (                                                                  
MFA-TR*      ACCOUNT_NO                                                         
MFA-TR*      ,VOUCHER_PAY_DT                                                    
MFA-TR*      ,CODE_AGENCY_ID                                                    
MFA-TR*      ,VOUCHER_AMT                                                       
MFA-TR*      ,REIMBURSE_DT                                                      
MFA-TR*      ,CHECK_NO                                                          
MFA-TR*      ,COMPLETED_BY                                                      
MFA-TR*      ,INITIATED_BY                                                      
MFA-TR*      ,PYMT_FACILITY_CD                                                  
MFA-TR*      ,LAST_UPDATE_TS                                                    
MFA-TR*      ,COMMENT                                                           
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*      :LI-ACCOUNT-NO                                                     
MFA-TR*      ,CURRENT TIMESTAMP                                                 
MFA-TR*      ,:LI-CODE-AGENCY-ID                                                
MFA-TR*      ,:LI-VOUCHER-AMT                                                   
MFA-TR*      ,CURRENT DATE                                                      
MFA-TR*      ,:LI-CHECK-NO                                                      
MFA-TR*      ,:LI-COMPLETED-BY                                                  
MFA-TR*      ,:LI-INITIATED-BY                                                  
MFA-TR*      ,:LI-PYMT-FACILITY-CD                                              
MFA-TR*      ,CURRENT TIMESTAMP                                                 
MFA-TR*      ,:LI-COMMENT                                                       
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE                
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_LIEAP'                TO TABLE-1                
              MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1        
              MOVE 'VOUCHER_AMT'              TO TABLE-ELEMENT-2        
              MOVE 'INITIATED_BY'             TO TABLE-ELEMENT-3        
              MOVE 'CODE_AGENCY_ID'           TO TABLE-ELEMENT-4        
              MOVE LI-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-AMOUNT-LIHEAP           TO HOSTVAR-ELEMENT-2      
              MOVE LI-INITIATED-BY            TO HOSTVAR-ELEMENT-3      
              MOVE LI-CODE-AGENCY-ID          TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF                                                       
           .                                                            
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * COMMITS THE TRANSACTION                                        *        
      *----------------------------------------------------------------*        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
           .                                                                    
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  MNT TRANS  COPYBOOK.                                          *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * LOADING GL NUMBERS                                                      
      *----------------------------------------------------------------*        
       9350-LINK-SCSCO061.                                              
           MOVE '9350'          TO ACTIVE-PARAGRAPH                     
           MOVE SPACES                    TO ABEND-FUNCTION             
           PERFORM 9400-CALL-CPD00061     THRU 9400-EXIT                
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE      
                                             SQLCODE                    
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF                                                       
           .                                                            
       9350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CALLS CPD00061 TO LOAD GL NOS                                  *        
      *----------------------------------------------------------------*        
       9400-CALL-CPD00061.                                              
           MOVE '9400'          TO ACTIVE-PARAGRAPH                     
                                                                        
           CALL WS-MCSCO061  USING  WS-GL-ACCT-NAME                     
                                 WS-GL-ACCT-MAJOR-FIELDS                
                                 WS-VALID-COMPANY-NOS                   
                                 WS-GL-NAME-INFO                        
                                 WS-GL-ACCT-NO-TABLE                    
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
                                                                        
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE              
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1   TO RS-RETURN-CODE                            
                              WS-ACTIVE-RETURN-CODE                     
              END-IF                                                    
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
           END-IF                                                       
           .                                                            
       9400-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01179*---------------------------------------------------------------*         
A01179* CALLS MCS03413                                                *         
A01179*---------------------------------------------------------------*         
ACT285 9800-CALL-MCS03414.                                              
A01179                                                                  
ACT285     CALL MCS03414 USING   WS-ACCOUNT-NO-NUM                      
ACT285                          ,WS-UPDATE-ACTION-FL                    
A01179                          ,WS-PYMT-FACILITY                       
A01179                          ,WS-DNP-RET-CODE                        
ACT285                          ,WS-PYMT-AMOUNT                         
ACT285                          ,WS-PAYMENT-AMOUNT-TOTAL                
ACT285                          ,WS-CALL-TYPE                           
ACT285                          ,WS-CPD68-REQUIRED                      
ACT285                          ,WS-PROGRAM-NAME                        
ACT285                          ,WS-CPD68-ACTN-FL                       
ACT285                          ,WS-CNCL-DNP-ACTN-FL                    
P00948                          ,WS-CNCL-DNP-EMAIL-REQ-FL               
ACT285                          ,WS-SO-UPDT-ACTN-FL                     
ACT285                          ,WS-CRED-ARNG-ACTN-FL                   
ACT285                          ,ws-APPL-PROGRAM-ID                     
PRJ420                          ,ABEND-FILE                             
A01179     .                                                            
A01179 9800-EXIT.                                                       
A01179     EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 9700-PROCESS-ABEND - COMMON ERROR HANDLER FOR BATCH/ON-LINE    *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      *       END PROGRAM COPYLIB                                      *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPD00312                                                  
           END-EXEC.                                                            
                                                                        
