       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03610.                                     
COB303 DATE-WRITTEN. JULY 15, 2005.                                     
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03610              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03610 :                                                --         
      *--                                                            --         
      *--  #  SELECTS DATA FOR METER INVENTORY FROM MTRD_ENVRNMT     --         
      *--     TABLE BASED ON PREMISE, CODE UTIL TYPE AND METER NO.   --         
      *--     USING CPD00099 FETCH THE MOST CURRENT ACCOUNT AT THE   --         
      *--     PREMISE.                                               --         
      *--  #  CALLING CSR03526 DB2 SP EDIT STYLE FOR METER PRESSURE  --         
      *--     DESCRIPTION.                                           --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--            COMPANY_NO            CHAR(02)                  --         
      *--            CODE_UTIL_TYPE        CHAR(01)                  --         
      *--            PREMISE_NO            CHAR(01)                  --         
      *--            METER_NO              CHAR(09)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            RETURN_CODE           S9(04)                    --         
      *--            METER_PRESS_CODE      CHAR(03)                  --         
      *--            METER_PRESS_DESC      CHAR(10)                  --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--     1                                                      --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  07/15/2005    VD88125     PROGRAM INITIALLY WRITTEN       --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03610'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_METRD_ENVRNMT, MN                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY, C8                                           *         
      *****************************************************************         
           EXEC SQL                                                             
            INCLUDE TBDELQ                                                      
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_MODEL_SQL, MS                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK                                 *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWS00303                                                 
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *    DB2 ERRROR PROCESSING COPYBOOK                            *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *    CPD00099 WORKING STORAGE COPYBOOK                         *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(08) VALUE 'CSRERLOG'.    
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR03610'.    
           05  WS-YES                    PIC X(01) VALUE 'Y'.           
           05  WS-NO                     PIC X(01) VALUE 'N'.           
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE              PIC S9(9) VALUE 0 COMP.        
           10 S-METER-PRESS-CODE         PIC X(03) VALUE '0'.           
           10 S-METER-PRESS-DESC         PIC X(10) VALUE 'STANDARD'.    
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9) COMP.                
           05  WRKLEN1                   PIC S9(9) COMP.                
           05  WRKLEN2                   PIC S9(9) COMP.                
           05  WRK-DONE-STATUS           PIC S9(9) COMP.                
           05  WS-METER-PRESS-CODE       PIC X(03) VALUE '000'.         
           05  WS-METER-PRESS-DESC       PIC X(10) VALUE 'STANDARD'.    
           05  WS-MN-METER-PRESSURE      PIC 9(03).                     
           05  WS-PREMISE-NO-A           PIC X(10) VALUE SPACES.        
           05  WS-PREMISE-NO-N  REDEFINES WS-PREMISE-NO-A               
                                         PIC 9(10).                     
           05  WS-DATABASE               PIC 9(01) VALUE 0.             
               88 CSR-DATABASE                     VALUE 1.             
               88 SEB-DATABASE                     VALUE 2.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-EXISTS                 PIC X(01) VALUE 'N'.           
               88 WS-EXISTS-YES                    VALUE 'Y'.           
               88 WS-EXISTS-NO                     VALUE 'N'.           
                                                                        
       01  WS-CSR03526-INPUT-FIELDS.                                    
           05  WS-COMPANY-NO             PIC X(02).                     
           05  WS-REGION                 PIC X(03).                     
                                                                        
       01  WS-CSR03526-OUTPUT-FIELDS.                                   
           05  WS-CSR03526-ERROR-CODE     PIC X(50) VALUE SPACES.       
           05  WS-CSR03526-SQLCODE        PIC S9(09) USAGE COMP         
                                                    VALUE ZEROES.       
           05  WS-CSR03526-SUCCESS-FL     PIC X(01) VALUE SPACES.       
      ***************************************************************           
      *    DB2 COMMUNICATION REQUIREMENT *                                      
      ***************************************************************           
      *01  LOC1                  USAGE IS SQL TYPE IS                   
      *                          RESULT-SET-LOCATOR VARYING.            
       01  ERROR-MESSAGE.                                               
           02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
           02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
                                 INDEXED BY ERROR-INDEX.                
       77   ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.            
       77  TRACE-MESSAGE-AREA    PIC X(256).                            
       77  OPENFN                PIC X(12).                             
       77  SSID                  PIC X(4).                              
       77  PLANNAME              PIC X(8).                              
       77  RETCODE               PIC S9(5).                             
       77  REASCODE              PIC S9(5).                             
       77  CLOSFN                PIC X(12).                             
       77  TERMOP                PIC X(4).
MSQ001        EXEC SQL
MSQ001          DECLARE METER_PRESS CURSOR
MSQ001          FOR CALL CSR03526                                       
           ( :WS-COMPANY-NO
                  , :WS-REGION
                  )
MSQ001        END-EXEC.
                              
      *                                                                         
       LINKAGE SECTION.                                                 
                                                                        
       01 I-COMPANY-NO             PIC X(02).                           
       01 I-CODE-UTIL-TYPE         PIC X(01).                           
       01 I-PREMISE-NO             PIC X(10).                           
       01 I-METER-NO               PIC X(09).                           
                                                                        
       PROCEDURE DIVISION USING I-COMPANY-NO                            
                               ,I-CODE-UTIL-TYPE                        
                               ,I-PREMISE-NO                            
                               ,I-METER-NO.                             
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
                                                                        
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
                                                                        
           GOBACK.                                                      
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-INITIALIZE                                               *         
      *    SET UP SQL ERROR PROCESSING,                               *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
                                                                        
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
                                                                        
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
      *                                                                         
           EXEC SQL                                                     
                                                                        
              DECLARE C1 CURSOR  FOR                         
               SELECT  :S-RETURN-CODE          AS RETURN_CODE           
                      ,:S-METER-PRESS-CODE     AS METER_PRESS_CODE      
                      ,:S-METER-PRESS-DESC     AS METER_PRESS_DESC      
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT  :S-RETURN-CODE          AS RETURN_CODE                   
MFA-TR*               ,:S-METER-PRESS-CODE     AS METER_PRESS_CODE              
MFA-TR*               ,:S-METER-PRESS-DESC     AS METER_PRESS_DESC              
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                                                                        
           IF I-PREMISE-NO > SPACES                                     
              MOVE I-PREMISE-NO        TO WS-PREMISE-NO-A               
              MOVE WS-PREMISE-NO-N     TO WS-CPD99-PREMISE-NO           
              MOVE I-METER-NO          TO MN-METER-NO                   
              MOVE I-CODE-UTIL-TYPE    TO MN-CODE-UTIL-TYPE             
              MOVE I-COMPANY-NO        TO C8-COMPANY-NO                 
                                          WS-COMPANY-NO                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE I-PREMISE-NO              TO HOSTVAR-ELEMENT-1       
              MOVE +100                      TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                       TO ACTIVE-PARAGRAPH.       
           PERFORM 2200-BUILD-RESULT           THRU 2200-EXIT.          
           ADD +1                            TO CTR-ROWS.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 6990-FETCH-CUR-ACCOUNT      THRU 6990-EXIT.          
           IF WS-CPD99-ACCOUNT-NO > 0                                   
              MOVE WS-CPD99-ACCOUNT-NO  TO MN-ACCOUNT-NO                
              PERFORM 7000-SELECT-MTRD-ENVRNMT THRU 7000-EXIT           
              PERFORM 7100-SELECT-DELINQUENCY  THRU 7100-EXIT           
              PERFORM 8200-CALL-CSR03526       THRU 8200-EXIT           
           ELSE                                                         
              MOVE WS-METER-PRESS-CODE  TO S-METER-PRESS-CODE           
              MOVE WS-METER-PRESS-DESC  TO S-METER-PRESS-DESC           
              MOVE  3                   TO S-RETURN-CODE                
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CPD ERROR PROCESSING COPYLIB                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00099                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6995-CPD99-ERROR-ROUTINE                                       *        
      ******************************************************************        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME              TO ABEND-PROGRAM              
           MOVE '6995'                    TO ACTIVE-PARAGRAPH           
           MOVE 'FETCH'                   TO ABEND-FUNCTION             
           MOVE 'CPD00099'                TO TABLE-1                    
           MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1            
           MOVE WS-CPD99-PREMISE-NO       TO HOSTVAR-ELEMENT-1          
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT               
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7000-SELECT-MTRD-ENVRNMT.                                      *        
      ******************************************************************        
       7000-SELECT-MTRD-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT METER_PRESSURE                                     
                INTO :MN-METER-PRESSURE                                 
                FROM CSS_MTRD_ENVRNMT                                   
               WHERE CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
                 AND ACCOUNT_NO     = :MN-ACCOUNT-NO                    
                 AND METER_NO       = :MN-METER-NO                      
                 AND CODE_METER_STATUS <> 'K'                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE MN-METER-PRESSURE      TO WS-MN-METER-PRESSURE    
                 MOVE WS-MN-METER-PRESSURE   TO S-METER-PRESS-CODE      
              ELSE                                                      
                 MOVE WS-METER-PRESS-CODE    TO S-METER-PRESS-CODE      
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE MN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-DELINQUENCY.                                       *        
      ******************************************************************        
       7100-SELECT-DELINQUENCY.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD      = 'DATABASE'                        
                 AND COMPANY_NO     = :C8-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE C8-DELINQ-VALUE TO WS-DATABASE                    
                 IF CSR-DATABASE                                        
                    MOVE 'CSR'        TO WS-REGION                      
                 ELSE                                                   
                    MOVE 'SEB'        TO WS-REGION                      
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'CSR'           TO WS-REGION                      
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-2         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CALL DB2 SP CSR03526                                           *        
      ******************************************************************        
       8200-CALL-CSR03526.                                              
      *                                                                         
      *    EXEC SQL CALL CSR03526                                       
      *    (:WS-COMPANY-NO,                                             
      *     :WS-REGION)                                                 
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE METER_PRESS
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN METER_PRESS
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR METER_PRESS INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = +466                             
      *        EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE        
      *           CSR03526                                              
      *        END-EXEC                                                 
                                                                        
      *        EXEC SQL                                                 
      *          ALLOCATE METER_PRESS CURSOR FOR RESULT SET :LOC1       
      *        END-EXEC                                                 
                                                                        
               PERFORM UNTIL ((WS-CSR03526-SUCCESS-FL EQUAL 'Y')        
                             OR (WS-CSR03526-SQLCODE EQUAL 100))        
                   EXEC SQL                                             
                     FETCH METER_PRESS                                  
                     INTO :WS-METER-PRESS-CODE                          
                         ,:WS-METER-PRESS-DESC                          
                     END-EXEC                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CSR03526-SQLCODE    
                                                                        
                   IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                      IF WS-METER-PRESS-CODE EQUAL  S-METER-PRESS-CODE  
                         MOVE 'Y'             TO WS-CSR03526-SUCCESS-FL 
                         MOVE WS-METER-PRESS-DESC TO S-METER-PRESS-DESC 
                         MOVE WS-CSR03526-SQLCODE TO S-RETURN-CODE      
                      END-IF                                            
                   END-IF                                               
               END-PERFORM                                              
                                                                        
               IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND 
                   EXEC SQL                                             
                      CLOSE METER_PRESS                                 
                   END-EXEC                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE    
                   IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                       CONTINUE                                         
                   ELSE                                                 
                      MOVE PROGRAM-NAME         TO ABEND-PROGRAM        
                      MOVE '8200'               TO ACTIVE-PARAGRAPH     
                      MOVE 'CLOSE'              TO ABEND-FUNCTION       
                      MOVE 'CSR03526'           TO TABLE-1              
                      MOVE 'WS-ACTIVE-RETURN-CODE' TO TABLE-ELEMENT-1   
                      MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1   
                      MOVE 'METER_NO'           TO TABLE-ELEMENT-2      
                      MOVE MN-METER-NO          TO HOSTVAR-ELEMENT-2    
                      PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT     
                      PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT     
                   END-IF                                               
               ELSE                                                     
                   MOVE 'N' TO WS-CSR03526-SUCCESS-FL                   
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '8200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                                     ABEND-TABLES       
                   MOVE 'CSR03526'          TO TABLE-1                  
                   MOVE 'SQLCODE'           TO TABLE-ELEMENT-1          
                   MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1      
                   MOVE 'METER_NO'          TO TABLE-ELEMENT-2          
                   MOVE MN-METER-NO         TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
               END-IF                                                   
           ELSE                                                         
               MOVE -1                       TO WS-ACTIVE-RETURN-CODE   
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8200'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DB2SP'                  TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                 ABEND-TABLES           
               MOVE 'CSR03526'               TO TABLE-1                 
               MOVE 'SQLCODE'                TO TABLE-ELEMENT-1         
               MOVE SQLCODE                  TO HOSTVAR-ELEMENT-1       
               MOVE 'METER_NO'               TO TABLE-ELEMENT-2         
               MOVE MN-METER-NO              TO HOSTVAR-ELEMENT-2       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * SQL ERROR PROCESSING COPYLIB                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
