       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03575.                                     
COB303 DATE-WRITTEN. AUGUST 16, 2005.                                   
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03575              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03575 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVES SUBDIVISION ID & DESCRIPTION, REVENUE        --         
      *--     DISTRICT, RATE_ITEM_CODE, AND PRICE_PER_SERV           --         
      *--  #  INVOKED FROM POWERBUILDER DATAWINDOW D_ES_SUB_REVDIST  --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--     1                                                      --         
      *--       SUBDIVISION_ID           CHAR(03)                     --        
      *--       SUBDIVISION_DESC         CHAR(26)                     --        
      *--       STATE                    CHAR(02)                     --        
      *--       COUNTY                   CHAR(03)                     --        
      *--       RATE_ITEM_CD             SMALLINT                     --        
      *--       REV_DISTRICT_CD          CHAR(03)                     --        
      *--       REV_DISTRICT_DESC        CHAR(35)                               
      *--       PRICE_PER_SERV           DECIMAL(9, 6)                --        
      *--       ZIP_CODE                 CHAR(05)                     --        
      *--       LOCAL_OFFICE             CHAR(03)                     --        
      *--                                                             --        
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
C32221*--  08/16/2005    DD19702     NEW CODE                        --         
C30135*--  01/19/2006    MSR         INCLUDE ZIPCODE IN THE DDW      --         
C35979*--  10/20/2008    SC41135     ADD COMPANY_NO TO CSS_SUBDIVISION-         
PERF  *--  12/12/2008    SC41135     ADDING COMPANY_NO IN INPUT AND  --         
PERF  *--                            IMPROVING PERFORMANCE - ACT00002185        
A04527*--  06/07/2013    AS7C117     REMOVE UNUSED COPYBOOK CWS00056.--         
A04776*--  08/29/2013    AS7C117     REMOVED UNUSED COPYBOOKS CWS00068-         
A04776*                              AND CWS0068L                     -         
A04776*                              REMOVE UNUSED DCLGENS            -         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03575'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SUBDIVISION                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ZIPCODE_SUBDIV                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPSUB                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_REV_DISTRICT                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRVDST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_UNMTR_PLAN                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_MODEL_SQL, MS                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK                                 *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ****************************************************************          
      *    DB2 ERRROR PROCESSING COPYBOOK                            *          
      ****************************************************************          
       COPY CWSSP001.                                                           
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(08) VALUE 'CSRERLOG'.    
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR03575'.    
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-SUBDIVISION-ID           PIC X(03) VALUE SPACES.        
           10 S-SUBDIVISION-DESC         PIC X(26) VALUE SPACES.        
           10 S-STATE                    PIC X(02) VALUE SPACES.        
           10 S-COUNTY                   PIC X(03) VALUE SPACES.        
           10 S-RATE-ITEM-CD             PIC S9(04) VALUE 0 COMP.       
           10 S-REV-DISTRICT-CD          PIC X(03) VALUE SPACES.        
           10 S-REV-DISTRICT-DESC        PIC X(35) VALUE SPACES.        
           10 S-PRICE-PER-SERV           PIC S9(3)V9(6) COMP-3 VALUE +0.
           10 S-ZIP-CODE                 PIC X(05) VALUE SPACES.        
           10 S-LOCAL-OFFICE             PIC X(03) VALUE SPACES.        
                                                                        
PERF   01  GENERAL-WORKING-STORAGE.                                     
PERF       05  WS-COMPANY-NO             PIC X(02)   VALUE SPACES.      
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9) COMP.                
           05  WRKLEN1                   PIC S9(9) COMP.                
           05  WRKLEN2                   PIC S9(9) COMP.                
           05  WRK-DONE-STATUS           PIC S9(9) COMP.                
                                                                        
       01  WS-MISC.                                                     
           05  WS-RETURN-CODE            PIC S9(4)  COMP VALUE 0.       
           05   S-RETURN-CODE            PIC S9(4)  COMP VALUE 0.       
           05  WS-END-OF-TABLE           PIC X(01)  VALUE 'N'.          
               88 END-OF-TABLE                      VALUE 'Y'.          
           05  WS-SQLSTATE               PIC X(05) VALUE '     '.       
                                                                        
       01  CSRERLOG-P.                                                  
          10  S-SP-NAME                 PIC X(18) VALUE SPACES.         
          10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.         
          10  S-SQLSTATE                PIC X(5)  VALUE ' '.            
          10  S-TABLE-NAME              PIC X(18) VALUE SPACES.         
          10  S-HOST-VARIABLES.                                         
              49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.           
              49  S-HOST-VARIABLES-V    PIC X(255).                     
          10  S-SQL-STATEMENT.                                          
              49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.           
              49  S-SQL-STATEMENT-V     PIC X(255).                     
          10  S-SQL-DESCRIPTION.                                        
              49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.           
              49  S-SQL-DESCRIPTION-V   PIC X(255).                     
                                                                        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-EXISTS                 PIC X(01) VALUE 'N'.           
               88 WS-EXISTS-YES                    VALUE 'Y'.           
               88 WS-EXISTS-NO                     VALUE 'N'.           
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS                                           *        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE CSS_SUBDIVISN_CUR CURSOR                
PERF             WITH ROWSET POSITIONING FOR                            
             SELECT ZS.SUBDIVISION_ID,                                  
                    B0.SUBDIVISION_DESC,                                
                    ZS.RATE_ITEM_CD,                                    
                    ZS.REV_DISTRICT_CD,                                 
                    A9.REV_DISTRICT_DESC,                               
C30135              ZS.ZIP_CODE,                                        
C30135              ZS.LOCAL_OFFICE                                     
               FROM CSS_SUBDIVISION B0,                                 
C30135              CSS_ZIPCODE_SUBDIV ZS,                              
                    CSS_REV_DISTRICT A9                                 
              WHERE ZS.SUBDIVISION_ID  = B0.SUBDIVISION_ID              
PERF            AND B0.COMPANY_NO      = :WS-COMPANY-NO                 
C35979          AND ZS.COMPANY_NO      = B0.COMPANY_NO                  
                AND ZS.REV_DISTRICT_CD = A9.REV_DISTRICT_CD             
            END-EXEC.                                                   
                                                                        
PERF   LINKAGE SECTION .                                                
PERF   01  PARM-COMPANY-NO      PIC X(02).                              
                                                                        
PERF   PROCEDURE DIVISION USING PARM-COMPANY-NO.                        
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
                                                                        
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
                                                                        
           GOBACK.                                                      
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                               *         
      *    SET UP SQL ERROR PROCESSING,                               *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
                                                                        
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
                                                                        
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03575_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03575_R1
              (                                                        
                   SUBDIVISION_ID CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,SUBDIVISION_DESC CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
C30135*           ,STATE                 CHAR(02)                               
C30135*           ,COUNTY                CHAR(03)                               
                  ,RATE_ITEM_CODE        SMALLINT                       
                  ,REV_DISTRICT_CD CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,REV_DISTRICT_DESC CHAR(35)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,PRICE_PER_SERV        DECIMAL(9,6)                  
                  ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,LOCAL_OFFICE CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
                  MOVE SQLCODE            TO ABEND-SQLCODE              
                  MOVE SQLSTATE           TO ABEND-SQLSTATE             
                  MOVE '0100'            TO ACTIVE-PARAGRAPH            
                  MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
                  MOVE SPACES             TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                  MOVE 'CSR03575_R1'      TO TABLE-1                    
                  MOVE SPACES             TO TABLE-ELEMENT-1            
                  MOVE SPACES             TO HOSTVAR-ELEMENT-1          
                  PERFORM 9900-SQL-ERROR-ROUTINE                        
                                          THRU  9900-EXIT               
               END-IF                                                   
            END-IF.                                                     
            EXEC SQL                                                    
                                                                        
              DECLARE C1 CURSOR                              
PERF              WITH ROWSET POSITIONING FOR                           
C30135         SELECT *                                                 
                 FROM #CSR03575_R1                               
                 ORDER BY SUBDIVISION_DESC                              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*                                                                         
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                                     
MFA-TR*           WITH ROWSET POSITIONING FOR                                   
MFA-TR*        SELECT *                                                         
MFA-TR*          FROM SESSION.CSR03575_R1                                       
MFA-TR*          ORDER BY SUBDIVISION_DESC                                      
MFA-TR*     END-EXEC.                                                           
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
PERF       MOVE PARM-COMPANY-NO    TO WS-COMPANY-NO.                    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                       TO ACTIVE-PARAGRAPH.       
           PERFORM 2200-BUILD-RESULT           THRU 2200-EXIT.          
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLS 5000-GET-SUBDIVISION                                 *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 5000-GET-SUBDIVISION        THRU 5000-EXIT.          
                                                                        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2000A-MOVE-RESULT.                                            *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE ZS-SUBDIVISION-ID            TO S-SUBDIVISION-ID.       
           MOVE B0-SUBDIVISION-DESC          TO S-SUBDIVISION-DESC.     
                                                                        
           MOVE ZS-RATE-ITEM-CD              TO S-RATE-ITEM-CD.         
                                                                        
           MOVE ZS-REV-DISTRICT-CD           TO S-REV-DISTRICT-CD.      
           MOVE A9-REV-DISTRICT-DESC         TO S-REV-DISTRICT-DESC.    
           MOVE UP-PRICE-PER-SERV            TO S-PRICE-PER-SERV.       
           MOVE ZS-ZIP-CODE                  TO S-ZIP-CODE.             
           MOVE ZS-LOCAL-OFFICE              TO S-LOCAL-OFFICE.         
                                                                        
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5000-GET-SUBDIVISION                                           *        
      *                                                                *        
      * LOADING SUBDIVISION AND RATE INFORMATION.                      *        
      ******************************************************************        
       5000-GET-SUBDIVISION.                                            
                                                                        
           PERFORM 7300-OPEN-CSS-SUBDIVISION   THRU  7300-EXIT.         
           PERFORM 7305-FETCH-CSS-SUBDIVISION  THRU  7305-EXIT.         
           PERFORM 5100-FETCH-SUBDIVISION      THRU 5100-EXIT           
                   UNTIL END-OF-TABLE.                                  
           PERFORM 7310-CLOSE-CSS-SUBDIVISION  THRU  7310-EXIT.         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-FETCH-SUBDIVISION                                         *        
      *                                                                *        
      * LOADING SUBDIVISION AND RATE INFORMATION.                      *        
      ******************************************************************        
       5100-FETCH-SUBDIVISION.                                          
                                                                        
           PERFORM 7315-SELECT-UNMTR-PLAN      THRU  7315-EXIT.         
           PERFORM 7305-FETCH-CSS-SUBDIVISION  THRU  7305-EXIT.         
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-OPEN-CSS-SUBDIVISION                                      *        
      ******************************************************************        
       7300-OPEN-CSS-SUBDIVISION.                                       
           EXEC SQL                                                     
                OPEN CSS_SUBDIVISN_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_SUBDIVISION'         TO TABLE-1                 
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7305-FETCH-CSS-SUBDIVISION                                     *        
      ******************************************************************        
       7305-FETCH-CSS-SUBDIVISION.                                      
           EXEC SQL                                                     
                FETCH CSS_SUBDIVISN_CUR INTO                            
                       :ZS-SUBDIVISION-ID                               
                      ,:B0-SUBDIVISION-DESC                             
                      ,:ZS-RATE-ITEM-CD                                 
                      ,:ZS-REV-DISTRICT-CD                              
                      ,:A9-REV-DISTRICT-DESC                            
                      ,:ZS-ZIP-CODE                                     
                      ,:ZS-LOCAL-OFFICE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   SET END-OF-TABLE          TO TRUE                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7305'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE 'CSS_SUBDIVISION'    TO TABLE-1                 
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7305-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-CLOSE-CSS-SUBDIVISION                                     *        
      ******************************************************************        
       7310-CLOSE-CSS-SUBDIVISION.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE CSS_SUBDIVISN_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SUBDIVISION'         TO TABLE-1                 
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7315-SELECT-UNMTR-PLAN                                         *        
      ******************************************************************        
       7315-SELECT-UNMTR-PLAN.                                          
                                                                        
           PERFORM 7400-GET-UNMTR-PLAN       THRU 7400-EXIT.            
           PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT.           
           PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.            
                                                                        
                                                                        
       7315-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-GET-UNMTR-PLAN                                            *        
      ******************************************************************        
       7400-GET-UNMTR-PLAN.                                             
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                    UP.PRICE_PER_SERV                                   
                INTO :UP-PRICE-PER-SERV                                 
                FROM                                                    
                    CSS_UNMTR_PLAN UP                                   
                WHERE UP.RATE_ITEM_CODE = :ZS-RATE-ITEM-CD              
                AND UP.RATE_PLAN_NO = '064'                             
                AND UP.CODE_UTIL_TYPE = 'U'                             
                AND UP.VERSION_NO_CNTRL = (SELECT MAX(VERSION_NO_CNTRL) 
                                           FROM CSS_UNMTR_PLAN          
                                           WHERE RATE_PLAN_NO = '064'   
                                           AND CODE_UTIL_TYPE = 'U')    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-RETURN-CODE          
           IF WS-RETURN-CODE = SUCCESSFUL-CALL                          
              NEXT SENTENCE                                             
           ELSE IF WS-RETURN-CODE = NOT-FOUND                           
              MOVE 0 TO UP-PRICE-PER-SERV                               
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UNMTR_PLAN'          TO TABLE-1                 
              MOVE 'RATE-ITEM-CODE'          TO TABLE-ELEMENT-1         
              MOVE ZS-RATE-ITEM-CD           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT
                END-IF
           END-IF.          
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR03575_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03575_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR03575_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR03575_R1                          
                 ( SUBDIVISION_ID                                       
                  ,SUBDIVISION_DESC                                     
                  ,RATE_ITEM_CODE                                       
                  ,REV_DISTRICT_CD                                      
                  ,REV_DISTRICT_DESC                                    
                  ,PRICE_PER_SERV                                       
                  ,ZIP_CODE                                             
                  ,LOCAL_OFFICE                                         
                 )                                                      
               VALUES                                                   
               (   :S-SUBDIVISION-ID                                    
                  ,:S-SUBDIVISION-DESC                                  
                  ,:S-RATE-ITEM-CD                                      
                  ,:S-REV-DISTRICT-CD                                   
                  ,:S-REV-DISTRICT-DESC                                 
                  ,:S-PRICE-PER-SERV                                    
                  ,:S-ZIP-CODE                                          
                  ,:S-LOCAL-OFFICE)                                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR03575_R1                                  
MFA-TR*          ( SUBDIVISION_ID                                               
MFA-TR*           ,SUBDIVISION_DESC                                             
MFA-TR*           ,RATE_ITEM_CODE                                               
MFA-TR*           ,REV_DISTRICT_CD                                              
MFA-TR*           ,REV_DISTRICT_DESC                                            
MFA-TR*           ,PRICE_PER_SERV                                               
MFA-TR*           ,ZIP_CODE                                                     
MFA-TR*           ,LOCAL_OFFICE                                                 
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*        (   :S-SUBDIVISION-ID                                            
MFA-TR*           ,:S-SUBDIVISION-DESC                                          
MFA-TR*           ,:S-RATE-ITEM-CD                                              
MFA-TR*           ,:S-REV-DISTRICT-CD                                           
MFA-TR*           ,:S-REV-DISTRICT-DESC                                         
MFA-TR*           ,:S-PRICE-PER-SERV                                            
MFA-TR*           ,:S-ZIP-CODE                                                  
MFA-TR*           ,:S-LOCAL-OFFICE)                                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1 TO CTR-ROWS                                       
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SQLCODE                TO ABEND-SQLCODE             
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR03575_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SQL ERROR PROCESSING COPYLIB                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
