       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03525.                                     
COB303 DATE-WRITTEN. APRIL 26, 2005.                                    
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03525              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03525 :                                                --         
      *--                                                            --         
      *--  THIS PROGRAM ADDS A ROW TO CSS_BUDGET_HIST AND UPDATES               
      *--  AMT_MO_PYMT IN CSS_BUDGET_PLAN.  ALSO ADDS ROW TO MAINT.             
      *--  TRANSACTION ROW) WHEN CUSTOMER WISHES TO ADD TO EPP                  
      *--  MONTHLY AMOUNT                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            AMT_MO_PYMT           CHAR(13)                  --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
C29534*--  04/26/2005    SS19371     NEW CODE                        --         
      *----------------------------------------------------------------         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03525'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03525 STARTS HERE'.                  
                                                                        
      ************************************************************              
      *    DB2 INCLUDES                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *    CSS_ACCOUNT, AT                                       *              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *    CSS_AR_CNTL, AC                                       *              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *    CSS_BUDGET_HIST, BH                                   *              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE TBBGTHST                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *    CSS_BUDGET_PLAN, BU                                   *              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE TBBGTPLN                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *    CSS_MNT_TRANS_HIST, MH                                *              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *    CSS_MT_TRN_HST_DET, MI                                *              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *    DB2 AND SQL ERROR CHECKING                            *              
      ************************************************************              
           COPY CWS00303.                                                       
                                                                        
      ************************************************************              
      *    DB2SP COMMON VARIABLES                                *              
      ************************************************************              
           COPY CWSSP001.                                                       
                                                                        
      ************************************************************              
      *    ERROR HANDLING COPY BOOK                              *              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *    WORK AREAS                                            *              
      ************************************************************              
       01  WS-INPUT-VARIABLES.                                          
           05  WS-ACCOUNT-NO-C          PIC X(13).                      
           05  WS-ACCOUNT-NO-N          REDEFINES WS-ACCOUNT-NO-C       
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-PACKED        PIC S9(13) COMP-3 VALUE 0.            
                                                                        
           05  WS-AMT-MO-PYMT-C         PIC X(13).                      
           05  WS-AMT-MO-PYMT-EDIT      REDEFINES WS-AMT-MO-PYMT-C      
                                        PIC -(9)9.99.                   
           05  WS-AMT-MO-PYMT-N         PIC S9(09)V99.                  
COB305     05 WS-AMT-MO-PYMT        PIC S9(09)V99 COMP-3 VALUE 0.           
           05  WS-AMT-MO-PYMT-OLD       PIC -(9)9.99.                   
                                                                        
           05  WS-AMT-MO-PYMT-CHECK.                                    
               10  WS-AMT-DOLLARS       PIC X(10).                      
               10  WS-DECIMAL-POINT     PIC X(01) VALUE '.'.            
               10  WS-AMT-CENTS         PIC X(02).                      
                                                                        
       01  WS-MISC.                                                     
           05  WS-DATABASE              PIC 9(01) VALUE ZEROS.          
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
                                                                        
           05  WS-COMMENT-TEXT          PIC X(210) VALUE                
                          'AMOUNT MONTHLY PAYMENT CHANGED VIA WEB'.     
           05  WS-COMMENT-LEN           PIC S9(04) VALUE 38 USAGE COMP. 
                                                                        
           05  WS-USER-ID               PIC X(07) VALUE 'WEBTRN1'.      
           05  WS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
           05  WS-LAST-UPDATE-TS        PIC X(26).                      
                                                                        
           05  WS-LAST-BILL-DATE        PIC X(06).                      
                                                                        
           05  WS-REVENUE-DATE.                                         
               10 WS-REVENUE-YEAR       PIC X(04).                      
               10 WS-REVENUE-YEAR-N     REDEFINES WS-REVENUE-YEAR       
                                        PIC 9(04).                      
               10 WS-REVENUE-MONTH      PIC X(02).                      
               10 WS-REVENUE-MONTH-N    REDEFINES WS-REVENUE-MONTH      
                                        PIC 9(02).                      
           05  WS-ANNIVERSARY-DATE.                                     
               10 WS-ANNIV-YEAR         PIC X(04).                      
               10 WS-ANNIV-YEAR-N       REDEFINES WS-ANNIV-YEAR         
                                        PIC 9(04).                      
               10 WS-DASH-1             PIC X(01) VALUE '-'.            
               10 WS-ANNIV-MONTH        PIC X(02).                      
               10 WS-ANNIV-MONTH-N      REDEFINES WS-ANNIV-MONTH        
                                        PIC 9(02).                      
               10 WS-DASH-2             PIC X(01) VALUE '-'.            
               10 WS-ANNIV-DAY          PIC X(02).                      
           05  WS-EPP-MTHS-RMNG-QT      PIC 9(02).                      
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-AMT-POSTED-NULL       PIC S9(4) COMP.                 
           05  WS-DATE-LAST-ACTION-NULL PIC S9(4) COMP.                 
           05  WS-BILL-NO-NULL          PIC S9(4) COMP.                 
           05  WS-EPP-OFFER-DT-NULL-IND PIC S9(4) COMP.                 
                                                                        
       01  WS-SWITCHES.                                                 
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  GOOD-AMOUNT-SW           PIC X(01) VALUE 'N'.            
               88 INVALID-AMT                     VALUE 'N'.            
               88 VALID-AMT                       VALUE 'Y'.            
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR03525'.     
           05  WS-F                     PIC X(01) VALUE 'F'.            
                                                                        
       01  WS-TRANSACTION-STORAGE.                                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26).                      
           05  WS-CURRENT-DATE          PIC X(10).                      
                                                                        
       01  WS-COUNTER-FIELDS.                                           
           05  WS-CTR-MONTHS            PIC 99.                         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  IN-ACCOUNT-NO                PIC X(13).                      
       01  IN-AMT-MO-PYMT               PIC X(13).                      
                                                                        
       PROCEDURE DIVISION USING IN-ACCOUNT-NO,                          
                                IN-AMT-MO-PYMT.                         
                                                                        
      ************************************************************              
      * 0000-MAINLINE                                            *              
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                *              
      ************************************************************              
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 0100-INITIALIZE                                          *              
      *     1. RESET DB2 ERROR HANDLERS                          *              
      *     2. ESTABLISH RETURN CURSOR AND VARIABLES             *              
      ************************************************************              
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT :S-RETURN-CODE      AS RETURN_CODE                  
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                                   
MFA-TR*      SELECT :S-RETURN-CODE      AS RETURN_CODE                          
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 1000-PROCESS-INPUT                                       *              
      *     1. RECEIVE PARMS.                                    *              
      *     2. CALCULATE NEEDED VARIABLES.                       *              
      ************************************************************              
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF IN-ACCOUNT-NO > SPACES AND IN-ACCOUNT-NO NUMERIC          
              MOVE IN-ACCOUNT-NO     TO WS-ACCOUNT-NO-C                 
              MOVE WS-ACCOUNT-NO-N   TO AT-ACCOUNT-NO                   
                                        AC-ACCOUNT-NO                   
                                        BU-ACCOUNT-NO                   
                                        BH-ACCOUNT-NO                   
                                        MH-ACCOUNT-NO                   
           ELSE                                                         
              MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                     
              MOVE IN-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                   
              PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           END-IF.                                                      
                                                                        
           IF IN-AMT-MO-PYMT > SPACES                                   
              MOVE IN-AMT-MO-PYMT TO WS-AMT-MO-PYMT-CHECK               
              INSPECT WS-AMT-DOLLARS REPLACING ALL ' ' BY '0'           
              IF WS-AMT-DOLLARS NUMERIC                                 
                 IF WS-AMT-CENTS NUMERIC                                
                    SET VALID-AMT TO TRUE                               
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF VALID-AMT                                                 
              MOVE IN-AMT-MO-PYMT      TO WS-AMT-MO-PYMT-C              
              MOVE WS-AMT-MO-PYMT-EDIT TO WS-AMT-MO-PYMT-N              
              MOVE WS-AMT-MO-PYMT-N    TO WS-AMT-MO-PYMT                
           ELSE                                                         
              MOVE 'AMT_MO_PYMT'  TO TABLE-ELEMENT-1                    
              MOVE IN-AMT-MO-PYMT TO HOSTVAR-ELEMENT-1                  
              PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           END-IF.                                                      
                                                                        
           ADD 1                      TO CTR-ROWS.                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 2000-PROCESS-OUTPUT.                                     *              
      *     1. UPDATE DB2 DATA                                   *              
      *     2. BUILD RESULT SET                                  *              
      *     3. SEND RESULT SET                                   *              
      ************************************************************              
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
      *    COMPUTE EPP-MTHS-RMNG-QT                                             
           MOVE +50 TO BU-PYMT-PRIORITY-LVL                             
                       AC-PYMT-PRIORITY-LVL                             
           MOVE +1  TO BU-BP-ITEM-ID                                    
                       AC-ITEM-ID                                       
                                                                        
           PERFORM 7000-SELECT-ACCOUNT     THRU 7000-EXIT.              
           MOVE AT-REV-MTH-LST-NRML      TO WS-LAST-BILL-DATE.          
           MOVE WS-LAST-BILL-DATE        TO WS-REVENUE-DATE.            
                                                                        
           PERFORM 7100-SELECT-BUDGET-PLAN THRU 7100-EXIT.              
           MOVE BU-ANNIVERSARY-DATE      TO WS-ANNIVERSARY-DATE.        
                                                                        
           IF WS-ANNIV-YEAR-N > WS-REVENUE-YEAR-N                       
              ADD +12 TO WS-ANNIV-MONTH-N                               
           END-IF                                                       
           SUBTRACT WS-REVENUE-MONTH-N FROM WS-ANNIV-MONTH-N            
               GIVING WS-EPP-MTHS-RMNG-QT                               
           MOVE WS-EPP-MTHS-RMNG-QT   TO BH-EPP-MTHS-RMNG-QT            
                                                                        
           MOVE BU-PYMT-PRIORITY-LVL TO BH-PYMT-PRIORITY-LVL            
           MOVE BU-BP-ITEM-ID        TO BH-ITEM-ID                      
           MOVE BU-DATE-PYMT-STRT    TO BH-DATE-PYMT-STRT               
                                                                        
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 5000-UPDATE.                                             *              
      *     MAIN UPDATE PARAGRAPH.                               *              
      ************************************************************              
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 7200-SELECT-AMT-TRAN-BALANCE THRU 7200-EXIT.         
           MOVE AC-AMT-TRAN-BALANCE       TO BH-UTILITY-BALANCE.        
                                                                        
           MOVE 0                         TO BH-BALANCE-FORWARD         
                                             BH-EPP-ESTIMATE.           
                                                                        
           MOVE BU-AMT-MO-PYMT            TO WS-AMT-MO-PYMT-OLD         
                                             BH-EPP-ESTIMATE.           
           MOVE WS-AMT-MO-PYMT            TO BU-AMT-MO-PYMT             
                                             BH-AMT-MO-PYMT.            
                                                                        
           MOVE 'C'                       TO BH-CHANGE-REASON.          
                                                                        
           MOVE WS-COMMENT-TEXT           TO BH-REMARKS-TEXT.           
           MOVE WS-COMMENT-LEN            TO BH-REMARKS-LEN.            
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO BH-BUD-HIST-SEQ-NO         
                                             BH-LAST-UPDATE-TS          
                                             BU-LAST-UPDATE-TS          
                                             MH-TRANS-HIST-SEQ-NO       
                                             MI-TRANS-HIST-SEQ-NO.      
                                                                        
           PERFORM 8000-UPDATE-BUDGET-PLAN   THRU 8000-EXIT.            
           PERFORM 8100-INSERT-BUDGET-HIST   THRU 8100-EXIT.            
                                                                        
           PERFORM 5100-UPDATE-MNT-TRANS-HISTORY THRU 5100-EXIT.        
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * 5100-UPDATE-MNT-TRANS-HISTORY.                          *               
      *    UPDATE MAINTENANCE TRANSACTION HISTORY TABLE         *               
      ***********************************************************               
       5100-UPDATE-MNT-TRANS-HISTORY.                                   
                                                                        
           MOVE '5100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           MOVE WS-CURRENT-DATE         TO MH-DATE-TRANS.               
           MOVE WS-F                    TO MH-CODE-TRAN-TYPE.           
           MOVE WS-RESP-AREA-ID         TO MH-RESP-AREA-ID.             
           MOVE ZEROS                   TO MH-CUSTOMER-NO.              
           MOVE ZEROS                   TO MH-PREMISE-NO.               
           MOVE WS-USER-ID              TO MH-USER-ID.                  
           MOVE 'CSR03525'              TO MH-APPL-PROGRAM-ID.          
           MOVE WS-COMMENT-TEXT         TO MH-TRAN-COMMENT-TEXT.        
           MOVE WS-COMMENT-LEN          TO MH-TRAN-COMMENT-LEN.         
                                                                        
           MOVE 1                       TO MI-TRAN-APPL-NO.             
           MOVE 'AMT MO PYMT'           TO MI-COLUMN-DESC.              
           MOVE +13                     TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE WS-AMT-MO-PYMT-OLD      TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE +13                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE WS-AMT-MO-PYMT-EDIT     TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE '71'                    TO MI-TABLE-ID.                 
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 7000-SELECT-ACCOUNT.                                     *              
      *     FETCH DETAILS FROM THE ACCOUNT TABLE                 *              
      ************************************************************              
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT AT.REV_MTH_LST_NRML                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                    ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :AT-REV-MTH-LST-NRML                               
                    ,:WS-CURRENT-TIMESTAMP                              
                    ,:WS-CURRENT-DATE                                   
                FROM CSS_ACCOUNT AT                                     
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*         INTO :AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:WS-CURRENT-TIMESTAMP                                      
MFA-TR*             ,:WS-CURRENT-DATE                                           
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '7000'         TO ACTIVE-PARAGRAPH                   
              MOVE SPACES         TO ABEND-TABLES                       
              MOVE SPACES         TO ABEND-SQL-PREDICATES               
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE 'SELECT'       TO ABEND-FUNCTION                     
              MOVE 'CSS_ACCOUNT'  TO TABLE-1                            
              MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1                    
              MOVE AT-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 7100-SELECT-BUDGET-PLAN.                                 *              
      *     FETCH DETAILS FROM CSS_BUDGET_PLAN                   *              
      ************************************************************              
       7100-SELECT-BUDGET-PLAN.                                         
                                                                        
           EXEC SQL                                                     
              SELECT BU.AMT_MO_PYMT                                     
                    ,BU.DATE_PYMT_STRT                                  
                    ,BU.ANNIVERSARY_DATE                                
                INTO :BU-AMT-MO-PYMT                                    
                    ,:BU-DATE-PYMT-STRT                                 
                    ,:BU-ANNIVERSARY-DATE                               
                FROM CSS_BUDGET_PLAN BU                                 
               WHERE BU.ACCOUNT_NO        = :BU-ACCOUNT-NO              
                 AND BU.PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL       
                 AND BU.BP_ITEM_ID        = :BU-BP-ITEM-ID              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUDGET_PLAN'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE BU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE BU-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3              
              MOVE BU-BP-ITEM-ID        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 7200-SELECT-AMT-TRAN-BALANCE.                            *              
      *     FETCH AMT-TRN-BALANCE FOR UTILITY-BALANCE            *              
      ************************************************************              
       7200-SELECT-AMT-TRAN-BALANCE.                                    
                                                                        
           EXEC SQL                                                     
              SELECT AC.AMT_TRAN_BALANCE                                
                INTO :AC-AMT-TRAN-BALANCE                               
                FROM CSS_AR_CNTL AC                                     
               WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO              
                 AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL       
                 AND AC.ITEM_ID           = :AC-ITEM-ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3              
              MOVE AC-ITEM-ID           TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 8000-UPDATE-BUDGET-PLAN.                                 *              
      *   UPDATE RECORD IN THE BUDGET PLAN TABLE.                *              
      ************************************************************              
       8000-UPDATE-BUDGET-PLAN.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_BUDGET_PLAN                                    
                 SET AMT_MO_PYMT    = :BU-AMT-MO-PYMT                   
                    ,LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :BU-LAST-UPDATE-TS
              )                
               WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL          
                 AND BP_ITEM_ID        = :BU-BP-ITEM-ID                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BUDGET_PLAN                                            
MFA-TR*          SET AMT_MO_PYMT    = :BU-AMT-MO-PYMT                           
MFA-TR*             ,LAST_UPDATE_TS = :BU-LAST-UPDATE-TS                        
MFA-TR*        WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL                  
MFA-TR*          AND BP_ITEM_ID        = :BU-BP-ITEM-ID                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUDGET_PLAN'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE 'BP_ITEM_ID'         TO TABLE-ELEMENT-3              
              MOVE BU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE BU-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE BU-BP-ITEM-ID        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 8100-INSERT-BUDGET-HIST.                                 *              
      *   INSERT RECORD IN THE BUDGET HISTORY TABLE.             *              
      ************************************************************              
       8100-INSERT-BUDGET-HIST.                                         
                                                                        
           EXEC SQL                                                     
           INSERT INTO CSS_BUDGET_HIST                                  
                  (ACCOUNT_NO                                           
                  ,PYMT_PRIORITY_LVL                                    
                  ,ITEM_ID                                              
                  ,BUD_HIST_SEQ_NO                                      
                  ,AMT_MO_PYMT                                          
                  ,DATE_PYMT_STRT                                       
                  ,UTILITY_BALANCE                                      
                  ,BALANCE_FORWARD                                      
                  ,EPP_ESTIMATE                                         
                  ,METHOD_OF_ESTIMATE                                   
                  ,CHANGE_REASON                                        
                  ,EPP_MTHS_RMNG_QT                                     
                  ,REMARKS            )                                 
           VALUES (:BH-ACCOUNT-NO                                       
                  ,:BH-PYMT-PRIORITY-LVL                                
                  ,:BH-ITEM-ID                                          
                  ,CIS.CHAR2TIMESTAMP(:BH-BUD-HIST-SEQ-NO)                      
                  ,:BH-AMT-MO-PYMT                                      
                  ,IIF(TRY_CONVERT(DATE, :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) )                           
                  ,:BH-UTILITY-BALANCE                                  
                  ,:BH-BALANCE-FORWARD                                  
                  ,:BH-EPP-ESTIMATE                                     
                  ,:BH-METHOD-OF-ESTIMATE                               
                  ,:BH-CHANGE-REASON                                    
                  ,:BH-EPP-MTHS-RMNG-QT                                 
                  ,:BH-REMARKS            )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_BUDGET_HIST                                          
MFA-TR*           (ACCOUNT_NO                                                   
MFA-TR*           ,PYMT_PRIORITY_LVL                                            
MFA-TR*           ,ITEM_ID                                                      
MFA-TR*           ,BUD_HIST_SEQ_NO                                              
MFA-TR*           ,AMT_MO_PYMT                                                  
MFA-TR*           ,DATE_PYMT_STRT                                               
MFA-TR*           ,UTILITY_BALANCE                                              
MFA-TR*           ,BALANCE_FORWARD                                              
MFA-TR*           ,EPP_ESTIMATE                                                 
MFA-TR*           ,METHOD_OF_ESTIMATE                                           
MFA-TR*           ,CHANGE_REASON                                                
MFA-TR*           ,EPP_MTHS_RMNG_QT                                             
MFA-TR*           ,REMARKS            )                                         
MFA-TR*    VALUES (:BH-ACCOUNT-NO                                               
MFA-TR*           ,:BH-PYMT-PRIORITY-LVL                                        
MFA-TR*           ,:BH-ITEM-ID                                                  
MFA-TR*           ,:BH-BUD-HIST-SEQ-NO                                          
MFA-TR*           ,:BH-AMT-MO-PYMT                                              
MFA-TR*           ,:BH-DATE-PYMT-STRT                                           
MFA-TR*           ,:BH-UTILITY-BALANCE                                          
MFA-TR*           ,:BH-BALANCE-FORWARD                                          
MFA-TR*           ,:BH-EPP-ESTIMATE                                             
MFA-TR*           ,:BH-METHOD-OF-ESTIMATE                                       
MFA-TR*           ,:BH-CHANGE-REASON                                            
MFA-TR*           ,:BH-EPP-MTHS-RMNG-QT                                         
MFA-TR*           ,:BH-REMARKS            )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUDGET_HIST'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3              
              MOVE 'DATE_PYMT_STRT'     TO TABLE-ELEMENT-4              
              MOVE BH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE BH-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE BH-ITEM-ID           TO HOSTVAR-ELEMENT-3            
              MOVE BH-DATE-PYMT-STRT    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 9500-INPUT-ABEND.                                        *              
      *  PERFORMS ABEND WHEN INVALID INPUT                       *              
      ************************************************************              
       9500-INPUT-ABEND.                                                
                                                                        
           ADD 1                      TO CTR-ROWS.                      
                                                                        
           MOVE PROGRAM-NAME    TO ABEND-PROGRAM.                       
           MOVE 'RECEIVE INPUT' TO ABEND-FUNCTION.                      
           MOVE +1000           TO WS-ACTIVE-RETURN-CODE.               
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * MNT TRANSACTION HISTORY CODE                             *              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      * 8900-SEND-DONE.                                          *              
      * 9000-SEND-ERROR-RESULT.                                  *              
      * 9999-END-PROGRAM.                                        *              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      * 9700-PROCESS-ABEND.                                      *              
      * CPD0023C CICS ABEND PROCESSING FOR DB2 ABENDS IN CPD00023*              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      * 9900-SQL-ERROR-ROUTINE.                                  *              
      * 9975-ABEND-CONTROL-TRANSFER.                             *              
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
