       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03524.                                     
COB303 DATE-WRITTEN. MARCH 25, 2005.                                    
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03524              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03524 :                                                --         
      *--                                                            --         
      *--  THIS PROGRAM INSERTS, DELETES, OR UPDATES THE EPP                    
      *--  INFORMATION FOR A CUSTOMER BASED ON THE VALUE IN                     
      *--  WS-ACTION-CODE (ONLY 'INSERT' AT PRESENT)                            
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
A04987*--            BILL_FLAG             CHAR(03)                  --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            AMT_MO_PYMT           CHAR(13)                  --         
      *--            UTILITY_BALANCE       CHAR(13)                  --         
      *--            UTILITY_ARREARS       CHAR(13)                  --         
      *--            EPP_ESTIMATE          CHAR(13)                  --         
      *--            LAST_UPDATE_TS        CHAR(26)                  --         
P00220*--            TRAN_IND              CHAR(03)                  --         
P00220*--            USER_ID               CHAR(07)                  --         
P00220*--            REMARKS_TEXT          CHAR(210)                 --         
P00220*--            REMARKS_LENGTH        SMALLINT                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
C29534*--  03/25/2005    SS19371     NEW CODE BASED ON RPC S276      --         
T34097*    02/07/2007    MC95456     REPLACED CSS_MODEL_SQL WITH --             
      *                                      SET STATEMENTS          --         
A00956*    03/26/2009    CVNS        REPLACE CPD00006 WITH CPD0006A.  *         
A00956*                  CHENNAI                                      *         
P00220*    07/06/2010    VP94820     MODIFIED TO REUSE SPCB IN BPA'S  *         
A02878*    12/21/2010    GD97441     1.IF AT-REV-MTH-LST-NRML = 0 THEN*         
A02878*                                POPULATE USING CSS_BILL_WINDOW.*         
A02878*                              2.6500-PARA:CHANGED INPUT VALUES *         
A02878*                              3.ADDED WITH UR/QUERYNO.         *         
ACT068*    04/07/11      SP95538     INITIALIZED REMARKS FIELD  TO    *         
ACT068*     A03082                   REMOVE LOW VALUES.               *         
A03710*    10/26/11      VV94890   1)FOR ALL COMPANIES ACCOUNTS SHOULD*         
A03710*  ***ACT0001***               NOT CHANGE TO CREDIT GRP ARREARS,*         
A03710*                              WHEN BBP IS SETUP.               *         
A03710*  ***ACT0002***             2)ALLOW BBP SETUP ON PENDING ACCTS.*         
P00694*    12/31/2012    SV95326     INCORPORATE CORRECT DELINQUENCY  *         
P00694*                              VALUES TO THE BUFFER.            *         
P0694A*  01/11/13    VV94890 1)UPDATED USER-ID TO BUDGET HISTORY TABLE.*        
P0694B*   ****P00694*******  2)ADDED TRAN-IND "BPM" FOR MANUAL PLAN.   *        
      *                                                                         
ACT132*  08/15/13    VIJAY   SET THE FRO INDICATOR IF THE EPP ELIGIBLE          
ACT132*  A04527              BALANCE (BILLED BALANCE) IS NOT EQUAL TO           
ACT132*                      THE EPP AMT TO COLLECT (IN OTHER WORDS,            
ACT132*                      IF THE BILLED BALANCE CHANGES).                    
ACT147*  09/12/13    VIJAY   USE IN-EPP-ESTIMATE MONEY AS COLLECT AMOUNT        
ACT147*  A04527              PASSED FROM MOD.                                   
ACT181*  10/29/13    VIJAY   BACK OUT ACT132 CHANGES.                           
ACT181*  A04527                                                                 
D02541*  11/21/13    VENKATV APENDING TRANS HIST COMMENTS FOR MANUAL PN.        
D03313*  03/10/14    VENKATV ADDED DIFFERENTIATE BTW A MANUAL OPTION & *        
D03313*                      A WORKSHEET CALCULATIONS FOR METHOD OF EST*        
ACT084*  04/17/14    VIJAY   SET THE FRO INDICATOR IF THE EPP ELIGIBLE          
ACT084*  A04880              BALANCE (BILLED BALANCE) IS NOT EQUAL TO           
ACT084*                      THE EPP AMT TO COLLECT (IN OTHER WORDS,            
ACT084*                      IF THE BILLED BALANCE CHANGES) AND NOT WEB         
ACT084*                      TRANSACTION.                                       
ACT117*  06/05/14   SS7F226  CHANGES TO GET THE CORRECT RESP AREA ID            
ACT117*  A04880              FROM CSS_USER_PROFILE USING USER_ID.               
ACT084*  07/14/14    VIJAY   USE IN-UTILITY-BALANCE TO SET FRO IND.             
A04987*  09/25/14   MC95456  CHANGES TO GET NO.OF MONTHS FROM CAT 268           
A04987*                      USERS AND CALCULATE START AND ANNIV DATES          
ACT307*  12/15/14   MS93554  FIX FOR PROD ISSUE IN AUTOMATED BBP SETUP          
ACT181*  19/09/15   MC95456  DELETE ROW FROM CRED COLL FOR NOTICE TYPE          
ACT181*   APPL3156-ACT181    'D' IN SEB.                                        
P00836*  12/08/15   JC91900  WEB billing Mod. Remove utility arrears            
P00836*                      check.                                             
A05136*  12/16/15   MR7E794  APPEND THE REMARKS OF CSS_BUDGET_HIST ON *         
A05136*             ACT242   THE TRAN-COMMENT-TEXT OF CSS_AR_TRANS_HIST*        
ACT001*  01/06/17   VIJAY    CHANGE IN-BILL-FLAG CHECKING PROCESS.     *        
ACT001*  A05744                                                        *        
      *----------------------------------------------------------------         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03524'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR03524 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BATCH_JRNL, BJ                                                   
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BCH_JRNL_CNTL, BC                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_CSH_DRWR_JRNL, CJ                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
ACT181*****************************************************************         
ACT181*    CSS_CRED_COLL,     CL                                                
ACT181*****************************************************************         
ACT181     EXEC SQL                                                             
ACT181        INCLUDE TBCRCOLL                                                  
ACT181     END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_CSH_DRWR_CNTL, CS                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_CSH_MISC_JRNL, MJ                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_ACCOUNT, AT                                                      
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_AR_LOCKOUT, AL                                                   
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_AR_TRANS_HIST, AR                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_AR_TRN_HST_DET, AU                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MNT_TRANS_HIST, MH                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MT_TRN_HST_DET, MI                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_AR_CNTL, AC                                                      
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_CUSTOMER, CU                                                     
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MODEL_SQL, MS                                                    
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_RESP_AREA, C1                                                    
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_PREMISE, PR                                                      
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_GL_ACCT_NO, GO                                                   
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_CONTRACT, CT                                                     
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_USER_PROFILE, PF                                                 
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BUDGET_HIST, BH                                                  
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBGTHST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BUDGET_PLAN, BU                                                  
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBGTPLN                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BILLING_DET, BG                                                  
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BILLING_HDR, BI                                                  
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BILL_CALC_DET, BZ                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBLCLDT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_LOCAL_OFFICE, B1                                                 
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_UM_CNSMPT_HIST, UC                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUMCNSM                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_CUST_PLAN, CP                                                    
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_DELINQUENCY, C8                                                  
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
A02878**  CSS_BILL_WINDOW, BN                                                   
A02878*                                                                         
A02878     EXEC SQL                                                             
A02878        INCLUDE TBBILWDW                                                  
A02878     END-EXEC.                                                            
A02878*                                                                         
      *****************************************************************         
      *    COPYBOOKS NEEDED TO SUPPORT JOURNALLING                              
      *****************************************************************         
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CJF00113.                                                       
           COPY CJF00101.                                                       
                                                                        
      *****************************************************************         
      *    CODES-DATA-PRESENT LAYOUT                                            
      *****************************************************************         
           COPY CWS00056.                                                       
                                                                        
      *****************************************************************         
      *    DB2 AND SQL ERROR CHECKING                                           
      *****************************************************************         
           COPY CWS00303.                                                       
                                                                        
      *****************************************************************         
      *    DB2SP COMMON VARIABLES                                               
      *****************************************************************         
           COPY CWSSP001.                                                       
                                                                        
      *****************************************************************         
      *    ERROR HANDLING COPY BOOK                                             
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    COMMON JOURNALLING VARIABLES                                         
      *****************************************************************         
           EXEC SQL                                                             
A00956        INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
       01  WS-INPUT-VARIABLES.                                          
           05  WS-ACTION-CODE          PIC X(01) VALUE 'I'.             
           05  WS-BILL-FLAG            PIC X(01).                       
                                                                        
           05  WS-ACCOUNT-NO-C.                                         
               10  WS-CUSTOMER-NO       PIC X(10) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE SPACES.         
           05  WS-ACCOUNT-NO REDEFINES WS-ACCOUNT-NO-C.                 
               10  WS-ACCOUNT-NO-NUM    PIC 9(13).                      
           05  WS-CUST-NO-NUM           REDEFINES WS-ACCOUNT-NO.        
               10  WS-CUSTOMER-NO-NUM   PIC 9(10).                      
               10  WS-ACCOUNT-SEQ-NUM   PIC 9(03).                      
COB305     05 WS-ACCOUNT-NO-PACKED        PIC S9(13) COMP-3 VALUE 0.            
                                                                        
           05  WS-AMT-TO-COLLECT-N      PIC S9(09)V99.                  
COB305     05 WS-AMT-TO-COLLECT        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-AMT-AR-DAY-00-RATIO        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.           
COB305     05 WS-AMT-AR-DAY-00-WAS        PIC S9(09)V99 COMP-3 VALUE 0.         
                                                                        
           05  WS-AMT-MO-PYMT-C         PIC X(13).                      
           05  WS-AMT-MO-PYMT-EDIT REDEFINES WS-AMT-MO-PYMT-C           
                                        PIC -(9)9.99.                   
           05  WS-AMT-MO-PYMT-N         PIC S9(09)V99.                  
COB305     05 WS-AMT-MO-PYMT        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-AMT-MO-PYMT-WAS        PIC S9(09)V99 COMP-3 VALUE 0.           
           05  WS-AMT-MO-PYMT-X         PIC ZZZZZZZZ9.99.               
                                                                        
           05  WS-ANNIVERSARY-DATE.                                     
               10  WS-ANNIV-YEAR       PIC X(04).                       
               10  WS-ANNIV-D1         PIC X(01) VALUE '-'.             
               10  WS-ANNIV-MONTH      PIC X(02).                       
               10  WS-ANNIV-D2         PIC X(01) VALUE '-'.             
               10  WS-ANNIV-DAY        PIC X(02).                       
           05  WS-DATE-PYMT-STRT.                                       
               10  WS-START-YEAR       PIC X(04).                       
               10  WS-START-D1         PIC X(01) VALUE '-'.             
               10  WS-START-MONTH      PIC X(02).                       
               10  WS-START-D2         PIC X(01) VALUE '-'.             
               10  WS-START-DAY        PIC X(02).                       
A04987     05  WS-INPUT-MONTHS         PIC X(02).                       
A04987     05  WS-INPUT-MONTHS-N       REDEFINES                        
A04987         WS-INPUT-MONTHS         PIC 9(02).                       
A04987     05  WS-LST-REV-YEAR-MONTH   PIC 9(06).                       
A04987     05  WS-LST-REV-YEAR-M       REDEFINES WS-LST-REV-YEAR-MONTH. 
A04987         10  WS-LST-REV-YEAR     PIC 9(4).                        
A04987         10  WS-LST-REV-MONTH    PIC 9(2).                        
A04987     05  WS-MONTH-CTR            PIC S9(3) COMP-3 VALUE 0.        
A04987     05  WS-CALC-MONTH           PIC 9(02).                       
A04987     05  WS-CALC-YEAR            PIC 9(04).                       
A04987     05  WS-AD-MONTH-X           PIC X(02) VALUE SPACES.          
A04987     05  WS-AD-MONTH-REDEF                                        
A04987         REDEFINES WS-AD-MONTH-X PIC 9(02).                       
A04987     05  WS-AD-YEAR-X            PIC X(04) VALUE SPACES.          
A04987     05  WS-AD-YEAR-REDEF                                         
A04987         REDEFINES WS-AD-YEAR-X  PIC 9(04).                       
                                                                        
           05  WS-UTILITY-BALANCE-C    PIC X(13).                       
           05  WS-UTILITY-BALANCE-EDIT REDEFINES WS-UTILITY-BALANCE-C   
                                       PIC -(9)9.99.                    
           05  WS-UTILITY-BALANCE-N    PIC S9(09)V99.                   
COB305     05 WS-UTILITY-BALANCE        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-UTILITY-BALANCE-TRN        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.            
           05  WS-UTILITY-BALANCE-UTE  PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-UTILITY-BALANCE-UTG  PIC S9(09)V99 COMP-3 VALUE +0.   
                                                                        
           05  WS-BALANCE-FORWARD-N     PIC S9(09)V99.                  
COB305     05 WS-BALANCE-FORWARD        PIC S9(09)V99 COMP-3 VALUE 0.           
                                                                        
           05  WS-EPP-ESTIMATE-C        PIC X(13).                      
           05  WS-EPP-ESTIMATE-EDIT REDEFINES WS-EPP-ESTIMATE-C         
                                        PIC -(9)9.99.                   
           05  WS-EPP-ESTIMATE-N        PIC S9(09)V99.                  
COB305     05 WS-EPP-ESTIMATE        PIC S9(09)V99 COMP-3 VALUE 0.           
                                                                        
           05  WS-UTILITY-ARREARS-C    PIC X(13).                       
           05  WS-UTILITY-ARREARS-EDIT REDEFINES WS-UTILITY-ARREARS-C   
                                       PIC -(9)9.99.                    
           05  WS-UTILITY-ARREARS-N    PIC S9(09)V99.                   
COB305     05 WS-UTILITY-ARREARS        PIC S9(09)V99 COMP-3 VALUE 0.           
                                                                        
P00220     05  WS-METHOD-OF-ESTIMATE.                                   
P00220         10  WS-CUST-RATE         PIC X(01) VALUE 'C'.            
P00220         10  WS-USAGE-ROLOVR      PIC X(01) VALUE 'R'.            
P0694B         10  WS-MANUAL            PIC X(01) VALUE 'M'.            
D03313         10  WS-WORKSHEET         PIC X(01) VALUE 'W'.            
D03313         10  WS-WORKSHEET-RO      PIC X(01) VALUE 'O'.            
           05  WS-CHANGE-REASON         PIC X(01) VALUE 'S'.            
           05  WS-XFER-BALANCE-NUM      PIC 9(09)V99 VALUE 0.           
           05  WS-SUGGESTED-ADDL-NUM    PIC 9(09)V99 VALUE 0.           
                                                                        
           05  WS-EPP-MTHS-RMNG-QT-C    PIC X(2).                       
           05  WS-EPP-MTHS-RMNG-QT-N REDEFINES WS-EPP-MTHS-RMNG-QT-C    
                                        PIC 9(2)V.                      
           05  WS-EPP-MTHS-RMNG-QT      PIC S9(2)V COMP.                
                                                                        
           05  WS-COMMENT-TEXT.                                         
               10 WS-REMARKS-TEXT       PIC X(210) VALUE SPACES.        
P00220         10 WS-TRAN-COMMENT-TEXT  PIC X(210) VALUE SPACES.        
P00220         10 WS-TRAN-CMNT-WEB-TX   PIC X(210) VALUE                
P00220                                             'SETUP FROM WEB'.    
P00220         10 WS-TRAN-CMNT-BPA-TX   PIC X(210) VALUE                
P00220                                             'SETUP FROM BPA'.    
           05  WS-COMMENT-LENGTH.                                       
               10 WS-REMARKS-LEN-N      PIC 9(04) VALUE 0.              
               10 WS-REMARKS-LEN-C      PIC S9(04) VALUE 0 USAGE COMP.  
                                                                        
               10 WS-TRAN-COMMENT-LEN-N PIC 9(04) VALUE 14.             
               10 WS-TRAN-COMMENT-LEN-C PIC S9(04) VALUE 14 USAGE COMP. 
                                                                        
           05  WS-USER-ID               PIC X(07) VALUE 'WEBTRN1'.      
           05  WS-MONTHS-CHANGED        PIC X(01) VALUE 'N'.            
           05  WS-LAST-UPDATE-TS        PIC X(26).                      
                                                                        
       01  WS-MISC.                                                     
           05  WS-AMOUNT-CHECK.                                         
               10  WS-AMT-DOLLARS       PIC X(10).                      
               10  WS-DECIMAL-POINT     PIC X(01) VALUE '.'.            
               10  WS-AMT-CENTS         PIC X(02).                      
                                                                        
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(04) COMP VALUE +0.       
           05  WS-ZERO-DATE-MASK        PIC X(10) VALUE '1900-01-01'.   
           05  WS-UTE-DAY-00            PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-UTE-DAY-30            PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-UTG-DAY-00            PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-UTG-DAY-30            PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-TOT-BAL-UTE-UTG       PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-BILLED-BALANCE        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-UTILITY-RELT-BALANCE PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-UTILITY-RELT-ARREARS PIC S9(09)V99 COMP-3 VALUE +0.   
                                                                        
COB305     05 WS-END-AR-BALANCE        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-AMT-POSTED        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-AMT-BILLED-UNPAID        PIC S9(09)V99 COMP-3 VALUE 0.         
COB305     05 WS-ELECTRIC-RATIO        PIC S9(09)V99 COMP-3 VALUE 0.           
                                                                        
           05  WS-SUMM-UNBILLED-FLAG    PIC X(01).                      
           05  WS-PRV-CODE-TEMP-BILL    PIC X(01).                      
                                                                        
           05  WS-REVENUE-MONTH         PIC 9(6).                       
           05  WS-REV-YEAR-MONTH REDEFINES WS-REVENUE-MONTH.            
               10  WS-REV-YEAR      PIC 9(4).                           
               10  WS-REV-MONTH     PIC 9(2).                           
                                                                        
           05  WS-RCC-REPLACED          PIC X(01).                      
                                                                        
           05  WS-LPN-COUNT             PIC S9(13) COMP-3 VALUE ZEROS.  
           05  WS-LPN-FOUND             PIC X(01) VALUE SPACE.          
                                                                        
           05  WS-AR-AGE             PIC X(01).                         
           05  WS-PREV-REV-MONTH     PIC S9(6) COMP-3 VALUE 0.          
COB305     05 WS-UTE-DOLLARS        PIC S9(9)V99 COMP-3 VALUE 0.               
COB305     05 WS-UTG-DOLLARS        PIC S9(9)V99 COMP-3 VALUE 0.               
COB305     05 WS-BOTH-DOLLARS        PIC S9(9)V99 COMP-3 VALUE 0.               
P00220     05  WS-STATUS-CODE        PIC S9(9)    COMP VALUE 0.         
                                                                        
           05  WS-DATABASE           PIC 9(01) VALUE ZEROS.             
               88  CSR-DATABASE                VALUE 1.                 
               88  SEB-DATABASE                VALUE 2.                 
                                                                        
           05  WS-ELEC-BUFFER        PIC -9.9999.                       
           05  WS-GAS-BUFFER         PIC -9.9999.                       
           05  WS-BUFFER-REMARKS     PIC X(210) VALUE SPACES.           
P00694     05  WS-PCT-RESRATEINCR-ELEC   PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
P00694     05  WS-PCT-RESRATEINCR-GAS    PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
P00694     05  WS-PCT-COMRATEINCR-ELEC   PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
P00694     05  WS-PCT-COMRATEINCR-GAS    PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
P00694     05  WS-ESTRATE-GAS            PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-AMT-POSTED-NULL       PIC S9(4) COMP.                 
           05  WS-DATE-LAST-ACTION-NULL PIC S9(4) COMP.                 
           05  WS-BILL-NO-NULL          PIC S9(4) COMP.                 
           05  WS-EPP-OFFER-DT-NULL-IND PIC S9(4) COMP.                 
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-UTE-SW                PIC X(01) VALUE 'N'.            
               88 UTE-EXISTS                      VALUE 'Y'.            
           05  WS-UTG-SW                PIC X(01) VALUE 'N'.            
               88 UTG-EXISTS                      VALUE 'Y'.            
           05  WS-UNMETERED-SW          PIC X(01) VALUE 'N'.            
               88 UNMETERED-EXISTS                VALUE 'Y'.            
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  GOOD-AMOUNT-SW           PIC X(01) VALUE 'N'.            
               88 INVALID-AMT                     VALUE 'N'.            
               88 VALID-AMT                       VALUE 'Y'.            
                                                                        
       01  WS-GL-PPL-TABLE.                                             
           05  WS-PPL-AR-TYPE-NSC    PIC S9(4) COMP VALUE +019.         
           05  WS-PPL-AR-TYPE-LPC    PIC S9(4) COMP VALUE +030.         
           05  WS-PPL-AR-TYPE-LPN    PIC S9(4) COMP VALUE +039.         
           05  WS-PPL-AR-TYPE-UTE    PIC S9(4) COMP VALUE +040.         
           05  WS-PPL-AR-TYPE-UTG    PIC S9(4) COMP VALUE +045.         
           05  WS-PPL-AR-TYPE-EPP    PIC S9(4) COMP VALUE +050.         
           05  WS-PPL-AR-TYPE-RCC    PIC S9(4) COMP VALUE +060.         
           05  WS-PPL-AR-TYPE-CIA    PIC S9(4) COMP VALUE +070.         
           05  WS-GEN-LED-NSC        PIC X(10) VALUE 'AR-NSC'.          
           05  WS-GEN-LED-LPC        PIC X(10) VALUE 'AR-LPC'.          
           05  WS-GEN-LED-LPN        PIC X(10) VALUE 'AR-LPN'.          
           05  WS-GEN-LED-UTE        PIC X(10) VALUE 'AR-UTE'.          
           05  WS-GEN-LED-UTG        PIC X(10) VALUE 'AR-UTG'.          
           05  WS-GEN-LED-EPP        PIC X(10) VALUE 'AR-BUD'.          
           05  WS-GEN-LED-RCC        PIC X(10) VALUE 'AR-CCC'.          
           05  WS-GEN-LED-CIA        PIC X(10) VALUE 'AR-CIA'.          
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                PIC X(08) VALUE 'CSR03524'.  
           05  WS-0                        PIC X(01) VALUE '0'.         
           05  WS-3                        PIC X(01) VALUE '3'.         
           05  WS-6                        PIC X(01) VALUE '6'.         
           05  WS-9                        PIC X(01) VALUE '9'.         
           05  WS-A                        PIC X(01) VALUE 'A'.         
           05  WS-B                        PIC X(01) VALUE 'B'.         
           05  WS-C                        PIC X(01) VALUE 'C'.         
           05  WS-F                        PIC X(01) VALUE 'F'.         
           05  WS-J                        PIC X(01) VALUE 'J'.         
           05  WS-K                        PIC X(01) VALUE 'K'.         
           05  WS-R                        PIC X(01) VALUE 'R'.         
           05  WS-T                        PIC X(01) VALUE 'T'.         
           05  WS-W                        PIC X(01) VALUE 'W'.         
           05  WS-Z                        PIC X(01) VALUE 'Z'.         
           05  WS-UNMETERED                PIC X(01) VALUE 'U'.         
           05  WS-LAST-UPDATE-TS-MISMATCH  PIC S9(9) COMP VALUE -999.   
           05  WS-E                        PIC X(01) VALUE 'E'.         
           05  WS-G                        PIC X(01) VALUE 'G'.         
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR JOURNALING                                 *        
      ******************************************************************        
       01  WS-TRANSACTION-STORAGE.                                      
           05  WS-CURRENT-TIMESTAMP       PIC X(26).                    
           05  WS-CURRENT-DATE            PIC X(10).                    
                                                                        
       01  WS-CASH-DRAWER-JOURNALING.                                   
           05  WS-CASH-DRAWER.                                          
               10  WS-CD-COMPANY-NO    PIC X(02).                       
               10  WS-CD-LOCAL-OFFICE  PIC X(03).                       
               10  WS-CD-REPORT-NO     PIC X(03).                       
               10  WS-CD-REPORT-DATE   PIC X(10).                       
               10  WS-CASH-DRAWER-ID   PIC S9(04) COMP.                 
                                                                        
       01  WS-MISCELLANEOUS-JOURNALING.                                 
           05  WS-GL-ACCT-NO              PIC 999.9999.                 
           05  WS-GL-ACCT-NO-C            PIC X(8).                     
           05  WS-RM01-RECORD-FIELD-DESC  PIC X(29) VALUE               
                                'EPP RECEIVABLES AGING CHANGED'.        
           05  WS-ACCT-NAME-DR            PIC X(10).                    
           05  WS-ACCT-NAME-CR            PIC X(10).                    
           05  WS-GO-GL-ACCT-NO-ED        PIC 9(3).9999.                
           05  WS-AR-AMT-ORIG-ENTERED-ED  PIC -(9)9.99.                 
           05  WS-AR-AMT-BILLED-UNPAID-ED PIC -(9)9.99.                 
                                                                        
       01  WS-COUNTER-FIELDS.                                           
           05  WS-CTR-MONTHS           PIC 9.                           
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
                                                                        
      *****************************************************************         
      *    CURSOR FOR AR CONTROL TABLE INFORMATION                              
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE  AR_CNTL_CURSOR CURSOR FOR                        
                SELECT AC.AMT_AR_DAY_00                                 
                      ,AC.AMT_AR_DAY_30                                 
                      ,AC.AMT_AR_DAY_60                                 
                      ,AC.AMT_AR_DAY_90                                 
                      ,AC.AMT_UNUSED_CR                                 
                      ,AC.AMT_TRAN_BALANCE                              
                      ,AC.TOT_SUMM_UNBILLED                             
                      ,AC.PYMT_PRIORITY_LVL                             
                      ,AC.ITEM_ID                                       
                  FROM CSS_AR_CNTL AC                                   
                 WHERE ACCOUNT_NO  = :AC-ACCOUNT-NO                     
              FOR UPDATE OF TOT_SUMM_UNBILLED                           
           END-EXEC.                                                    
                                                                        
            EXEC SQL                                                    
              DECLARE  AR_CNTL_CURSOR2 CURSOR FOR                       
                SELECT AC.AMT_AR_DAY_00                                 
                      ,AC.AMT_AR_DAY_30                                 
                      ,AC.AMT_AR_DAY_60                                 
                      ,AC.AMT_AR_DAY_90                                 
                      ,AC.AMT_UNUSED_CR                                 
                      ,AC.AMT_TRAN_BALANCE                              
                      ,AC.TOT_SUMM_UNBILLED                             
                      ,AC.PYMT_PRIORITY_LVL                             
                      ,ITEM_ID                                          
                  FROM CSS_AR_CNTL AC                                   
                 WHERE AC.ACCOUNT_NO  = :AC-ACCOUNT-NO                  
                 ORDER BY  AC.PYMT_PRIORITY_LVL ASC,                    
                           AC.ITEM_ID DESC                              
            END-EXEC.                                                   
                                                                        
      *****************************************************************         
      *    CURSOR FOR UTE/UTG DOLLARS                                           
      *****************************************************************         
                                                                        
           EXEC SQL DECLARE PCT-CURSOR CURSOR FOR                       
               SELECT BG.REVENUE_MONTH                                  
                     ,BZ.CODE_UTIL_TYPE                                 
                     ,BZ.BILLED_COMP_AM                                 
                     ,BG.BILL_NO                                        
                     ,BG.CODE_UTIL_TYPE                                 
                     ,BG.IC_NO                                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                 FROM CSS_BILLING_HDR   BI WITH(READUNCOMMITTED),               
                      CSS_BILLING_DET   BG WITH(READUNCOMMITTED),               
                      CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED)                
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.CODE_BILL_ITM_TYPE = 'C'                       
                  AND BG.CODE_BILL_ITM_IND  = 'A'                       
                  AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO             
                  AND BI.BILL_NO            = BG.BILL_NO                
                  AND BZ.ACCOUNT_NO         = BG.ACCOUNT_NO             
                  AND BZ.BILL_NO            = BG.BILL_NO                
                  AND BZ.CODE_UTIL_TYPE     = BG.CODE_UTIL_TYPE         
                  AND BZ.IC_NO              = BG.IC_NO                  
                  AND BZ.BILL_ITEM_TIMESTMP = BG.BILL_ITEM_TIMESTMP     
                  AND BG.DATE_ORIG_BILL     IS NULL                     
             ORDER BY BG.REVENUE_MONTH DESC                             
A02878                                                           
A02878                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE PCT-CURSOR CURSOR FOR                               
MFA-TR*        SELECT BG.REVENUE_MONTH                                          
MFA-TR*              ,BZ.CODE_UTIL_TYPE                                         
MFA-TR*              ,BZ.BILLED_COMP_AM                                         
MFA-TR*              ,BG.BILL_NO                                                
MFA-TR*              ,BG.CODE_UTIL_TYPE                                         
MFA-TR*              ,BG.IC_NO                                                  
MFA-TR*              ,BG.BILL_ITEM_TIMESTMP                                     
MFA-TR*          FROM CSS_BILLING_HDR   BI,                                     
MFA-TR*               CSS_BILLING_DET   BG,                                     
MFA-TR*               CSS_BILL_CALC_DET BZ                                      
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*           AND BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*           AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                     
MFA-TR*           AND BI.BILL_NO            = BG.BILL_NO                        
MFA-TR*           AND BZ.ACCOUNT_NO         = BG.ACCOUNT_NO                     
MFA-TR*           AND BZ.BILL_NO            = BG.BILL_NO                        
MFA-TR*           AND BZ.CODE_UTIL_TYPE     = BG.CODE_UTIL_TYPE                 
MFA-TR*           AND BZ.IC_NO              = BG.IC_NO                          
MFA-TR*           AND BZ.BILL_ITEM_TIMESTMP = BG.BILL_ITEM_TIMESTMP             
MFA-TR*           AND BG.DATE_ORIG_BILL     IS NULL                             
MFA-TR*      ORDER BY BG.REVENUE_MONTH DESC                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7950                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
A04987 01  IN-BILL-FLAG                  PIC X(03).                     
       01  IN-ACCOUNT-NO                 PIC X(13).                     
       01  IN-AMT-MO-PYMT                PIC X(13).                     
       01  IN-UTILITY-BALANCE            PIC X(13).                     
       01  IN-UTILITY-ARREARS            PIC X(13).                     
       01  IN-EPP-ESTIMATE               PIC X(13).                     
       01  IN-LAST-UPDATE-TS             PIC X(26).                     
P00220 01  IN-TRAN-IND                   PIC X(03).                     
P00220 01  IN-USER-ID                    PIC X(07).                     
P00220 01  IN-REMARKS-TEXT               PIC X(210).                    
P00220 01  IN-REMARKS-LENGTH             PIC S9(4) COMP.                
                                                                        
       PROCEDURE DIVISION USING IN-BILL-FLAG,                           
                                IN-ACCOUNT-NO,                          
                                IN-AMT-MO-PYMT,                         
                                IN-UTILITY-BALANCE,                     
                                IN-UTILITY-ARREARS,                     
                                IN-EPP-ESTIMATE,                        
                                IN-LAST-UPDATE-TS,                      
P00220                          IN-TRAN-IND,                            
P00220                          IN-USER-ID,                             
P00220                          IN-REMARKS-TEXT,                        
P00220                          IN-REMARKS-LENGTH.                      
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                           
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                               
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                                         
      *     1. RESET DB2 ERROR HANDLERS                                         
      *     2. ESTABLISH RETURN CURSOR AND VARIABLES                            
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT :S-RETURN-CODE      AS RETURN_CODE                  
P00220             ,:WS-STATUS-CODE     AS STATUS_CODE                  
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                                   
MFA-TR*      SELECT :S-RETURN-CODE      AS RETURN_CODE                          
MFA-TR*            ,:WS-STATUS-CODE     AS STATUS_CODE                          
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-PROCESS-INPUT                                                      
      *     1. RECEIVE PARMS.                                                   
      *     2. CALCULATE NEEDED VARIABLES.                                      
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000' TO ACTIVE-PARAGRAPH.                             
                                                                        
A04987*IN-BILL-FLAG LENGTH HAS BEEN INCREASED FROM 1 TO 3 TO                    
A04987*THE FIRST CHARACTER OF IN-BILL-FLAG CONTAINS BILL FLAG.                  
A04987                                                                  
ACT001     IF IN-BILL-FLAG(1:1) = SPACES                                
ACT001        MOVE 'BILL_FLAG'  TO TABLE-ELEMENT-1                      
ACT001        MOVE IN-BILL-FLAG TO HOSTVAR-ELEMENT-1                    
ACT001        PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           ELSE                                                         
ACT001        MOVE IN-BILL-FLAG(1:1) TO WS-BILL-FLAG                    
           END-IF.                                                      
                                                                        
A04987*NEXT TWO CHARACTERS OF IN-BILL-FLAG CONTAINS MONTHS FIELD                
A04987*MONTHS FIELD ENTERED BY CAT 268 USERS                                    
A04987*                                                                         
A04987     IF IN-BILL-FLAG(2:2) = SPACES                                
A04987        CONTINUE                                                  
A04987     ELSE                                                         
A04987        MOVE IN-BILL-FLAG(2:2) TO WS-INPUT-MONTHS                 
A04987        IF WS-INPUT-MONTHS-N > 12                                 
A04987           MOVE 12             TO WS-INPUT-MONTHS-N               
A04987        END-IF                                                    
A04987     END-IF.                                                      
                                                                        
           IF IN-ACCOUNT-NO > SPACES                                    
           AND IN-ACCOUNT-NO NUMERIC                                    
              MOVE IN-ACCOUNT-NO     TO WS-ACCOUNT-NO-C                 
              MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO                   
           ELSE                                                         
              MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                     
              MOVE IN-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                   
              PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           END-IF.                                                      
                                                                        
           IF IN-AMT-MO-PYMT > SPACES                                   
              MOVE IN-AMT-MO-PYMT TO WS-AMOUNT-CHECK                    
              PERFORM 1100-NUMERIC-CHECK THRU 1100-EXIT                 
              IF GOOD-AMOUNT-SW = 'Y'                                   
                 MOVE IN-AMT-MO-PYMT      TO WS-AMT-MO-PYMT-C           
                 MOVE WS-AMT-MO-PYMT-EDIT TO WS-AMT-MO-PYMT-N           
                 MOVE WS-AMT-MO-PYMT-N    TO WS-AMT-MO-PYMT             
              ELSE                                                      
                 MOVE 'AMT_MO_PYMT'  TO TABLE-ELEMENT-1                 
                 MOVE IN-AMT-MO-PYMT TO HOSTVAR-ELEMENT-1               
                 PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT             
              END-IF                                                    
           ELSE                                                         
              MOVE 'AMT_MO_PYMT'  TO TABLE-ELEMENT-1                    
              MOVE IN-AMT-MO-PYMT TO HOSTVAR-ELEMENT-1                  
              PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           END-IF.                                                      
                                                                        
           IF IN-UTILITY-BALANCE > SPACES                               
              MOVE IN-UTILITY-BALANCE TO WS-AMOUNT-CHECK                
              PERFORM 1100-NUMERIC-CHECK THRU 1100-EXIT                 
              IF GOOD-AMOUNT-SW = 'Y'                                   
                 MOVE IN-UTILITY-BALANCE      TO WS-UTILITY-BALANCE-C   
                 MOVE WS-UTILITY-BALANCE-EDIT TO WS-UTILITY-BALANCE-N   
                 MOVE WS-UTILITY-BALANCE-N    TO WS-UTILITY-BALANCE     
                                                 WS-UTILITY-BALANCE-TRN 
                 PERFORM 5740-GET-UTILITY-BALANCE THRU 5740-EXIT        
                 MOVE WS-UTILITY-RELT-BALANCE TO  WS-UTILITY-BALANCE-TRN
              ELSE                                                      
                 MOVE 'UTILITY_BALANCE'  TO TABLE-ELEMENT-1             
                 MOVE IN-UTILITY-BALANCE TO HOSTVAR-ELEMENT-1           
                 PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT             
              END-IF                                                    
           ELSE                                                         
              MOVE 'UTILITY_BALANCE'  TO TABLE-ELEMENT-1                
              MOVE IN-UTILITY-BALANCE TO HOSTVAR-ELEMENT-1              
              PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           END-IF.                                                      
                                                                        
           IF IN-EPP-ESTIMATE > SPACES                                  
              MOVE IN-EPP-ESTIMATE TO WS-AMOUNT-CHECK                   
              PERFORM 1100-NUMERIC-CHECK THRU 1100-EXIT                 
              IF GOOD-AMOUNT-SW = 'Y'                                   
                 MOVE IN-EPP-ESTIMATE      TO WS-EPP-ESTIMATE-C         
                 MOVE WS-EPP-ESTIMATE-EDIT TO WS-EPP-ESTIMATE-N         
                 MOVE WS-EPP-ESTIMATE-N    TO WS-EPP-ESTIMATE           
              ELSE                                                      
                 MOVE 'EPP_ESTIMATE'  TO TABLE-ELEMENT-1                
                 MOVE IN-EPP-ESTIMATE TO HOSTVAR-ELEMENT-1              
                 PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT             
              END-IF                                                    
           ELSE                                                         
              MOVE 'EPP_ESTIMATE'  TO TABLE-ELEMENT-1                   
              MOVE IN-EPP-ESTIMATE TO HOSTVAR-ELEMENT-1                 
              PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           END-IF.                                                      
                                                                        
           IF IN-LAST-UPDATE-TS > SPACES                                
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'LAST_UPDATE_TS'  TO TABLE-ELEMENT-1                 
              MOVE IN-LAST-UPDATE-TS TO HOSTVAR-ELEMENT-1               
              PERFORM 9500-INPUT-ABEND    THRU 9500-EXIT                
           END-IF.                                                      
                                                                        
           IF IN-UTILITY-ARREARS > SPACES                               
              MOVE IN-UTILITY-ARREARS TO WS-AMOUNT-CHECK                
              PERFORM 1100-NUMERIC-CHECK THRU 1100-EXIT                 
              IF GOOD-AMOUNT-SW = 'Y'                                   
                 MOVE IN-UTILITY-ARREARS      TO WS-UTILITY-ARREARS-C   
                 MOVE WS-UTILITY-ARREARS-EDIT TO WS-UTILITY-ARREARS-N   
                 MOVE WS-UTILITY-ARREARS-N    TO WS-UTILITY-ARREARS     
              ELSE                                                      
                 MOVE 'UTILITY_ARREARS'   TO TABLE-ELEMENT-1            
                 MOVE IN-UTILITY-ARREARS  TO HOSTVAR-ELEMENT-1          
                 PERFORM 9500-INPUT-ABEND THRU 9500-EXIT                
              END-IF                                                    
           ELSE                                                         
              MOVE 'UTILITY_ARREARS'   TO TABLE-ELEMENT-1               
              MOVE IN-UTILITY-ARREARS  TO HOSTVAR-ELEMENT-1             
              PERFORM 9500-INPUT-ABEND THRU 9500-EXIT                   
           END-IF.                                                      
                                                                        
           PERFORM 7000-SELECT-ACCOUNT    THRU 7000-EXIT.               
P00694     MOVE AT-COMPANY-NO              TO C8-COMPANY-NO             
P00694     MOVE 'DATABASE'                 TO C8-DELINQ-CD              
P00694     PERFORM 7540-SELECT-DELINQ-VALUE THRU 7540-EXIT              
P00694     MOVE C8-DELINQ-VALUE            TO   WS-DATABASE             
P00694     IF CSR-DATABASE AND AT-COMPANY-NO = '01'                     
P00694*                                                                         
P00694        EVALUATE AT-ACCOUNT-TYPE-CODE                             
P00694           WHEN 'R'                                               
P00694              MOVE 'PCT-RESRATEINCR-ELEC'      TO C8-DELINQ-CD    
P00694              PERFORM 7540-SELECT-DELINQ-VALUE THRU 7540-EXIT     
P00694              MOVE C8-DELINQ-VALUE  TO WS-PCT-RESRATEINCR-ELEC    
P00694              COMPUTE WS-PCT-RESRATEINCR-ELEC =                   
P00694                           (WS-PCT-RESRATEINCR-ELEC * .01)        
P00694                                                                  
P00694              MOVE 'PCT-RESRATEINCR-GAS'       TO C8-DELINQ-CD    
P00694              PERFORM 7540-SELECT-DELINQ-VALUE THRU 7540-EXIT     
P00694              MOVE C8-DELINQ-VALUE  TO WS-PCT-RESRATEINCR-GAS     
P00694              COMPUTE WS-PCT-RESRATEINCR-GAS  =                   
P00694                           (WS-PCT-RESRATEINCR-GAS * .01)         
P00694                                                                  
P00694           WHEN 'C'                                               
P00694              MOVE 'PCT-COMRATEINCR-ELEC'      TO C8-DELINQ-CD    
P00694              PERFORM 7540-SELECT-DELINQ-VALUE THRU 7540-EXIT     
P00694              MOVE C8-DELINQ-VALUE  TO WS-PCT-COMRATEINCR-ELEC    
P00694              COMPUTE WS-PCT-COMRATEINCR-ELEC =                   
P00694                           (WS-PCT-COMRATEINCR-ELEC * .01)        
P00694                                                                  
P00694              MOVE 'PCT-COMRATEINCR-GAS'       TO C8-DELINQ-CD    
P00694              PERFORM 7540-SELECT-DELINQ-VALUE THRU 7540-EXIT     
P00694              MOVE C8-DELINQ-VALUE  TO WS-PCT-COMRATEINCR-GAS     
P00694              COMPUTE WS-PCT-COMRATEINCR-GAS  =                   
P00694                           (WS-PCT-COMRATEINCR-GAS * .01)         
P00694        END-EVALUATE                                              
P00694     ELSE                                                         
P00694        MOVE 'PCT-ESTRATEINCR-GAS'     TO C8-DELINQ-CD            
P00694        PERFORM 7540-SELECT-DELINQ-VALUE THRU 7540-EXIT           
P00694        MOVE C8-DELINQ-VALUE           TO WS-ESTRATE-GAS          
P00694        COMPUTE WS-ESTRATE-GAS     =                              
P00694                     (WS-ESTRATE-GAS * .01)                       
P00694     END-IF                                                       
A02878*                                                                         
A02878     IF AT-REV-MTH-LST-NRML > 0                                   
A02878        MOVE AT-REV-MTH-LST-NRML    TO WS-REVENUE-MONTH           
A04987                                       WS-LST-REV-YEAR-MONTH      
A02878     ELSE                                                         
A03710        IF AT-CODE-ACCT-STAT = 'P' AND ( AT-BILL-CYCLE = SPACES   
A03710                                       OR '99' OR '00' )          
A03710           PERFORM 7720-SELECT-REV-MTH         THRU 7720-EXIT     
A03710        ELSE                                                      
A02878           MOVE AT-BILL-CYCLE       TO BN-BILL-CYCLE              
A02878           PERFORM 7730-GET-BILL-WINDOW-REVMTH THRU 7730-EXIT     
A03710        END-IF                                                    
A02878        MOVE BN-REVENUE-MONTH       TO WS-REVENUE-MONTH           
A04987                                       WS-LST-REV-YEAR-MONTH      
A02878     END-IF.                                                      
P00220*                                                                         
P00220     IF IN-TRAN-IND = 'WEB'                                       
P00220        MOVE  WS-TRAN-CMNT-WEB-TX     TO WS-TRAN-COMMENT-TEXT     
P00220     ELSE                                                         
P00220        MOVE IN-USER-ID               TO WS-USER-ID               
ACT242             STRING  WS-TRAN-CMNT-BPA-TX DELIMITED BY '   ',      
ACT242                     '; ' DELIMITED BY SIZE,                      
ACT242                     IN-REMARKS-TEXT DELIMITED BY '   '           
ACT242               INTO  WS-TRAN-COMMENT-TEXT                         
ACT242        MOVE LENGTH OF WS-TRAN-COMMENT-TEXT  TO                   
ACT242                                       WS-TRAN-COMMENT-LEN-C      
P00220     END-IF.                                                      
P00220*                                                                         
A04987     EVALUATE WS-BILL-FLAG                                        
              WHEN 'C'                                                  
                 COMPUTE WS-AMT-TO-COLLECT-N = WS-AMT-MO-PYMT +         
                                               WS-UTILITY-ARREARS-N     
A04987           IF WS-INPUT-MONTHS > SPACES AND                        
A04987              WS-INPUT-MONTHS NOT EQUAL ZEROES AND                
ACT307              (IN-TRAN-IND = 'BPM' OR IN-TRAN-IND = 'BPW')        
A04987              MOVE WS-INPUT-MONTHS-N  TO WS-EPP-MTHS-RMNG-QT-C    
A04987           ELSE                                                   
                    MOVE '11'               TO WS-EPP-MTHS-RMNG-QT-C    
A04987           END-IF                                                 
                 MOVE WS-EPP-MTHS-RMNG-QT-N TO WS-EPP-MTHS-RMNG-QT      
              WHEN 'N'                                                  
                 COMPUTE WS-AMT-TO-COLLECT-N = WS-UTILITY-BALANCE-N     
A04987           IF WS-INPUT-MONTHS > SPACES AND                        
A04987              WS-INPUT-MONTHS NOT EQUAL ZEROES AND                
ACT307              (IN-TRAN-IND = 'BPM' OR IN-TRAN-IND = 'BPW')        
A04987              MOVE WS-INPUT-MONTHS-N  TO WS-EPP-MTHS-RMNG-QT-C    
A04987           ELSE                                                   
                    MOVE '12'               TO WS-EPP-MTHS-RMNG-QT-C    
A04987           END-IF                                                 
                 MOVE WS-EPP-MTHS-RMNG-QT-N TO WS-EPP-MTHS-RMNG-QT      
P00220        WHEN 'R'                                                  
P00220           COMPUTE WS-AMT-TO-COLLECT-N = WS-AMT-MO-PYMT           
ACT307           IF WS-INPUT-MONTHS > SPACES AND                        
ACT307              WS-INPUT-MONTHS NOT EQUAL ZEROES AND                
ACT307              (IN-TRAN-IND = 'BPM' OR IN-TRAN-IND = 'BPW')        
ACT307              MOVE WS-INPUT-MONTHS-N  TO WS-EPP-MTHS-RMNG-QT-C    
ACT307           ELSE                                                   
ACT307              MOVE '11'               TO WS-EPP-MTHS-RMNG-QT-C    
ACT307           END-IF                                                 
P00220           MOVE WS-EPP-MTHS-RMNG-QT-N TO WS-EPP-MTHS-RMNG-QT      
P00220        WHEN 'S'                                                  
P00220           MOVE WS-UTILITY-ARREARS-N  TO WS-AMT-TO-COLLECT-N      
ACT307           IF WS-INPUT-MONTHS > SPACES AND                        
ACT307              WS-INPUT-MONTHS NOT EQUAL ZEROES AND                
ACT307              (IN-TRAN-IND = 'BPM' OR IN-TRAN-IND = 'BPW')        
ACT307              MOVE WS-INPUT-MONTHS-N  TO WS-EPP-MTHS-RMNG-QT-C    
ACT307           ELSE                                                   
P00220              MOVE '12'               TO WS-EPP-MTHS-RMNG-QT-C    
ACT307           END-IF                                                 
P00220           MOVE WS-EPP-MTHS-RMNG-QT-N TO WS-EPP-MTHS-RMNG-QT      
           END-EVALUATE                                                 
           MOVE WS-AMT-TO-COLLECT-N       TO WS-AMT-TO-COLLECT.         
A04987     PERFORM  1200-CALC-START-ANNIV-DATES THRU 1200-EXIT.         
                                                                        
ACT147     IF IN-TRAN-IND = 'BPM' AND                                   
ACT147        WS-EPP-ESTIMATE NOT = WS-AMT-TO-COLLECT                   
ACT147        MOVE WS-EPP-ESTIMATE   TO WS-AMT-TO-COLLECT               
ACT147        MOVE WS-AMT-TO-COLLECT TO WS-AMT-TO-COLLECT-N             
ACT147     END-IF.                                                      
                                                                        
      *    COMPUTE BALANCE-FORWARD                                              
           COMPUTE WS-BALANCE-FORWARD-N = WS-UTILITY-BALANCE-N -        
                                          WS-AMT-TO-COLLECT-N           
           MOVE WS-BALANCE-FORWARD-N      TO WS-BALANCE-FORWARD.        
                                                                        
           ADD 1                      TO CTR-ROWS.                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 1100-NUMERIC-CHECK.                                      *              
      ************************************************************              
       1100-NUMERIC-CHECK.                                              
                                                                        
           INSPECT WS-AMT-DOLLARS REPLACING ALL ' ' BY '0'.             
           IF WS-AMT-DOLLARS NUMERIC AND WS-AMT-CENTS NUMERIC           
              SET VALID-AMT TO TRUE                                     
           ELSE                                                         
              SET INVALID-AMT TO TRUE                                   
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04987************************************************************              
A04987* 1200-CALC-START-ANNIV-DATES.                             *              
A04987* THIS CALCULATES ANNIVERSARY DATE USING THE LAST REVENUE  *              
A04987* DATE AS BASELINE AND GOING FORWARD THE NUMBER OF MONTHS  *              
A04987* CAME IN AS INPUT. THEN THE START DATE IS RECALCULATED    *              
A04987* USING THE ANNIVERSARY DATE AS THE BASELINE AND GOING     *              
A0498 * BACKWARDS 12 MONTHS.                                     *              
A04987************************************************************              
A04987 1200-CALC-START-ANNIV-DATES.                                     
                                                                        
A04987     MOVE WS-LST-REV-MONTH TO WS-CALC-MONTH                       
A04987     MOVE WS-LST-REV-YEAR  TO WS-CALC-YEAR                        
A04987     PERFORM VARYING WS-MONTH-CTR FROM +1 BY +1                   
A04987        UNTIL WS-MONTH-CTR > WS-EPP-MTHS-RMNG-QT                  
A04987           ADD +1 TO WS-CALC-MONTH                                
A04987           IF WS-CALC-MONTH = +13                                 
A04987              MOVE +1 TO WS-CALC-MONTH                            
A04987              ADD +1  TO WS-CALC-YEAR                             
A04987           END-IF                                                 
A04987     END-PERFORM.                                                 
A04987     MOVE WS-CALC-MONTH  TO WS-ANNIV-MONTH.                       
A04987     MOVE WS-CALC-YEAR   TO WS-ANNIV-YEAR.                        
A04987     MOVE '01'           TO WS-ANNIV-DAY.                         
A04987                                                                  
A04987*    CALC START DATE USING ANNIVERSARY DATE AS BASELINE                   
A04987     MOVE WS-ANNIV-MONTH TO WS-AD-MONTH-X.                        
A04987     MOVE WS-ANNIV-YEAR  TO WS-AD-YEAR-X.                         
A04987     MOVE WS-AD-MONTH-REDEF    TO WS-CALC-MONTH.                  
A04987     MOVE WS-AD-YEAR-REDEF     TO WS-CALC-YEAR.                   
A04987     PERFORM VARYING WS-MONTH-CTR FROM +12 BY -1                  
A04987        UNTIL WS-MONTH-CTR = +1                                   
A04987           SUBTRACT +1 FROM WS-CALC-MONTH                         
A04987           IF WS-CALC-MONTH = ZERO                                
A04987              MOVE +12 TO WS-CALC-MONTH                           
A04987              SUBTRACT +1 FROM WS-CALC-YEAR                       
A04987           END-IF                                                 
A04987     END-PERFORM.                                                 
A04987     MOVE WS-CALC-MONTH  TO WS-START-MONTH.                       
A04987     MOVE WS-CALC-YEAR   TO WS-START-YEAR.                        
A04987     MOVE '01'           TO WS-START-DAY.                         
                                                                        
A04987  1200-EXIT.                                                      
A04987       EXIT.                                                      
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                                    
      *     1. CHECK AR LOCKOUT                                                 
      *     2. CHECK LAST-UPDATE-TS HAS NOT CHANGED                             
      *     3. UPDATE DB2 DATA                                                  
      *     4. BUILD RESULT SET                                                 
      *     5. SEND RESULT SET                                                  
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
                                                                        
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
P00220        IF IN-TRAN-IND = 'WEB'                                    
P00220           MOVE 0                   TO WS-STATUS-CODE             
P00220           MOVE 5000                TO WS-ACTIVE-RETURN-CODE      
P00220                                       S-RETURN-CODE              
P00220        ELSE                                                      
P00220           MOVE 5000                TO WS-STATUS-CODE             
P00220           MOVE 100                 TO WS-ACTIVE-RETURN-CODE      
P00220                                       S-RETURN-CODE              
P00220        END-IF                                                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF IN-LAST-UPDATE-TS NOT = AT-LAST-UPDATE-TS                 
P00220        IF IN-TRAN-IND = 'WEB'                                    
P00220           MOVE 0                   TO WS-STATUS-CODE             
P00220           MOVE 5272                TO WS-ACTIVE-RETURN-CODE      
P00220                                       S-RETURN-CODE              
P00220        ELSE                                                      
P00220           MOVE 5272                TO WS-STATUS-CODE             
P00220           MOVE 100                 TO WS-ACTIVE-RETURN-CODE      
P00220                                       S-RETURN-CODE              
P00220        END-IF                                                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5000-UPDATE.                                                *           
      * MAIN UPDATE PARAGRAPH.                                      *           
      ***************************************************************           
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.     
           MOVE AT-CODE-TEMP-BILL         TO WS-PRV-CODE-TEMP-BILL.     
                                                                        
           PERFORM 7100-SELECT-PREMISE    THRU 7100-EXIT.               
           PERFORM 7200-SELECT-CUSTOMER   THRU 7200-EXIT.               
                                                                        
           PERFORM 7600-GET-TIMESTAMP-AND-DATE THRU 7600-EXIT.          
           MOVE WS-CURRENT-TIMESTAMP      TO AR-TRANS-HIST-SEQ-NO       
           MOVE +0                        TO WS-101-DETAIL-END-BAL.     
           MOVE +0                        TO WS-101-DETAIL-END-AR-BAL.  
           MOVE +0                        TO WS-101-ACCT-END-AR-BAL.    
                                                                        
           PERFORM 5002-INSERT-EPP THRU 5002-EXIT.                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5002-INSERT-EPP.                                            *           
      ***************************************************************           
       5002-INSERT-EPP.                                                 
                                                                        
           MOVE +0                      TO WS-UTILITY-BALANCE           
           MOVE +0                      TO WS-BILLED-BALANCE            
           MOVE AT-TOTAL-AR-BALANCE     TO WS-AMT-BILLED-UNPAID         
           MOVE 0                       TO AU-TRAN-APPL-NO              
           MOVE WS-GEN-LED-EPP          TO WS-ACCT-NAME-DR              
                                                                        
           PERFORM 8810-OPEN-AR-CNTRL-CURSOR  THRU 8810-EXIT            
           PERFORM 8820-FETCH-AR-CNTRL-CURSOR THRU 8820-EXIT            
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE '0'            TO WS-AR-AGE                          
              MOVE ZEROES         TO WS-AMT-POSTED                      
                                     WS-END-AR-BALANCE                  
              MOVE WS-GEN-LED-UTE TO WS-ACCT-NAME-CR                    
              PERFORM 5500-UPDATE-TRANS-HISTORY THRU 5500-EXIT          
           ELSE                                                         
              PERFORM 5010-SETUP-EPP       THRU 5010-EXIT               
                  UNTIL ( WS-ACTIVE-RETURN-CODE = NOT-FOUND )           
ACT181        IF AT-CREDIT-GROUP = 'B' AND SEB-DATABASE                 
ACT181           MOVE    AT-ACCOUNT-NO         TO   CL-ACCOUNT-NO       
ACT181           PERFORM 8000-DELETE-CRED-COLL THRU 8000-EXIT           
ACT181        END-IF                                                    
           END-IF                                                       
           PERFORM 8830-CLOSE-AR-CNTRL-CURSOR THRU 8830-EXIT            
                                                                        
           MOVE WS-AMT-TO-COLLECT       TO AC-AMT-AR-DAY-00             
                                           WS-END-AR-BALANCE            
           MOVE ZEROES                  TO AC-AMT-AR-DAY-30             
                                           AC-AMT-AR-DAY-60             
                                           AC-AMT-AR-DAY-90             
                                           AC-AMT-UNUSED-CR             
                                           AC-AMT-TRAN-BALANCE          
                                           AC-TOT-SUMM-UNBILLED         
           MOVE +50                     TO AC-PYMT-PRIORITY-LVL         
           MOVE +0                      TO AC-ITEM-ID                   
           PERFORM 8710-INSERT-AR-CNTL  THRU 8710-EXIT                  
                                                                        
           MOVE WS-UTILITY-BALANCE      TO AC-AMT-TRAN-BALANCE          
           MOVE +1                      TO AC-ITEM-ID                   
           PERFORM 8710-INSERT-AR-CNTL  THRU 8710-EXIT                  
                                                                        
           PERFORM 5100-SETUP-AR-JRNL   THRU 5100-EXIT                  
                                                                        
           MOVE WS-AMT-MO-PYMT          TO BU-AMT-MO-PYMT               
           MOVE AC-PYMT-PRIORITY-LVL    TO BU-PYMT-PRIORITY-LVL         
                                           BH-PYMT-PRIORITY-LVL         
           MOVE AC-ITEM-ID              TO BU-BP-ITEM-ID                
                                           BH-ITEM-ID                   
           MOVE WS-ANNIVERSARY-DATE     TO BU-ANNIVERSARY-DATE          
           MOVE WS-DATE-PYMT-STRT       TO BU-DATE-PYMT-STRT            
           MOVE WS-XFER-BALANCE-NUM     TO BU-AMT-MO-PYT-BAL-FWD        
           MOVE WS-SUGGESTED-ADDL-NUM   TO BU-AMT-MO-PYMT-NEW           
           PERFORM 8720-INSERT-BUDGET-PLAN THRU 8720-EXIT               
                                                                        
           MOVE WS-AMT-MO-PYMT          TO BH-AMT-MO-PYMT               
           MOVE WS-DATE-PYMT-STRT       TO BH-DATE-PYMT-STRT            
           MOVE WS-UTILITY-BALANCE      TO BH-UTILITY-BALANCE           
           MOVE WS-BALANCE-FORWARD      TO BH-BALANCE-FORWARD           
           MOVE WS-EPP-ESTIMATE         TO BH-EPP-ESTIMATE              
           MOVE WS-EPP-MTHS-RMNG-QT     TO BH-EPP-MTHS-RMNG-QT          
A04987     IF WS-BILL-FLAG = 'R' OR 'S'                                 
              MOVE WS-USAGE-ROLOVR      TO BH-METHOD-OF-ESTIMATE        
           ELSE                                                         
              MOVE WS-CUST-RATE         TO BH-METHOD-OF-ESTIMATE        
           END-IF                                                       
           EVALUATE IN-TRAN-IND                                         
P0694B         WHEN 'BPM'                                               
P0694B              MOVE WS-MANUAL      TO BH-METHOD-OF-ESTIMATE        
D03313         WHEN 'BPW'                                               
A04987              IF WS-BILL-FLAG = 'R' OR 'S'                        
D03313                 MOVE WS-WORKSHEET-RO  TO BH-METHOD-OF-ESTIMATE   
D03313              ELSE                                                
D03313                 MOVE WS-WORKSHEET     TO BH-METHOD-OF-ESTIMATE   
D03313              END-IF                                              
           END-EVALUATE                                                 
           MOVE WS-CHANGE-REASON        TO BH-CHANGE-REASON             
           MOVE WS-REMARKS-LEN-C        TO BH-REMARKS-LEN               
                                                                        
           PERFORM 5050-FORMAT-REMARKS THRU 5050-EXIT                   
                                                                        
           PERFORM 8730-INSERT-BUDGET-HIST THRU 8730-EXIT               
                                                                        
           ADD WS-AMT-TO-COLLECT        TO AT-TOTAL-AR-BALANCE          
           SUBTRACT WS-BILLED-BALANCE   FROM AT-TOTAL-AR-BALANCE        
           MOVE AT-TOTAL-AR-BALANCE     TO AR-AMT-BILLED-UNPAID         
           MOVE WS-ACCOUNT-NO-NUM       TO AR-ACCOUNT-NO                
           IF AC-PYMT-PRIORITY-LVL = 50                                 
              MOVE WS-AMT-TO-COLLECT       TO AR-AMT-ORIG-ENTERED       
           ELSE                                                         
              MOVE WS-UTILITY-RELT-BALANCE TO AR-AMT-ORIG-ENTERED       
           END-IF                                                       
           IF AR-AMT-ORIG-ENTERED < 0                                   
              MULTIPLY -1 BY AR-AMT-ORIG-ENTERED                        
              GIVING AR-AMT-ORIG-ENTERED                                
           END-IF                                                       
           IF WS-AMT-TO-COLLECT > 0                                     
              PERFORM 8855-UPDATE-AR-TRANS-HIST THRU 8855-EXIT          
           END-IF                                                       
                                                                        
           MOVE WS-CURRENT-DATE         TO AT-DATE-LAST-ACTION          
           MOVE SPACE                   TO WS-CODE-UTL                  
           PERFORM 5910-CHECK-FOR-LPN THRU 5910-EXIT                    
           IF WS-LPN-FOUND = 'N'                                        
              MOVE SPACE                TO WS-CODE-LPC                  
           END-IF                                                       
                                                                        
           IF WS-RCC-REPLACED = 'Y'                                     
              MOVE SPACE                TO WS-CODE-CONNECT-CHRG         
           END-IF                                                       
                                                                        
           MOVE 'A'                   TO WS-CODE-BUDGET                 
           MOVE SPACES                TO WS-CODE-EPP-OFFER              
                                         AT-EPP-OFFER-DATE              
           MOVE -1                    TO WS-EPP-OFFER-DT-NULL-IND       
           MOVE ZERO                  TO AT-EPP-OFFER-AMOUNT            
           MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT          
                                                                        
           PERFORM 5950-CALC-ELEC-PCT   THRU 5950-EXIT                  
                                                                        
           PERFORM 8805-UPDATE-ACCOUNT-EPP-OFFER    THRU 8805-EXIT.     
                                                                        
       5002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5010-SETUP-EPP.                                             *           
      *     PROCESS SETTING UP EPP.                                 *           
      ***************************************************************           
       5010-SETUP-EPP.                                                  
                                                                        
           IF ( AC-ITEM-ID = 0  AND                                     
               (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-NSC OR            
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-LPC OR            
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-UTE OR            
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-UTG ))            
           OR ( AC-ITEM-ID >= 0  AND                                    
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-RCC AND           
                ( AC-AMT-AR-DAY-00                                      
                  + AC-AMT-AR-DAY-30                                    
                  + AC-AMT-AR-DAY-60                                    
                  + AC-AMT-AR-DAY-90                                    
                  + AC-AMT-UNUSED-CR                                    
                  + AC-TOT-SUMM-UNBILLED) > 0)                          
                                                                        
              IF (AC-ITEM-ID = 0 AND                                    
                        AC-PYMT-PRIORITY-LVL NOT = WS-PPL-AR-TYPE-RCC)  
                 COMPUTE WS-UTILITY-BALANCE = WS-UTILITY-BALANCE        
                                            + AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
                                            + AC-TOT-SUMM-UNBILLED      
                                                                        
                 COMPUTE WS-BILLED-BALANCE = WS-BILLED-BALANCE          
                                            + AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
                 EVALUATE AC-PYMT-PRIORITY-LVL                          
                    WHEN WS-PPL-AR-TYPE-NSC                             
                       MOVE WS-GEN-LED-NSC   TO WS-ACCT-NAME-CR         
                    WHEN WS-PPL-AR-TYPE-LPC                             
                       MOVE WS-GEN-LED-LPC   TO WS-ACCT-NAME-CR         
                    WHEN WS-PPL-AR-TYPE-UTE                             
                       MOVE 'Y'              TO WS-UTE-SW               
                       MOVE WS-GEN-LED-UTE   TO WS-ACCT-NAME-CR         
                    WHEN WS-PPL-AR-TYPE-UTG                             
                       MOVE 'Y'              TO WS-UTG-SW               
                       MOVE WS-GEN-LED-UTG   TO WS-ACCT-NAME-CR         
                 END-EVALUATE                                           
                 MOVE 'N' TO WS-SUMM-UNBILLED-FLAG                      
                 PERFORM 5100-SETUP-AR-JRNL  THRU 5100-EXIT             
              ELSE                                                      
                 IF (AC-ITEM-ID > 0)                                    
                    COMPUTE WS-UTILITY-BALANCE = WS-UTILITY-BALANCE     
                                               + AC-AMT-TRAN-BALANCE    
                                                                        
                    COMPUTE WS-BILLED-BALANCE = WS-BILLED-BALANCE       
                                              + AC-AMT-AR-DAY-00        
                                              + AC-AMT-AR-DAY-30        
                                              + AC-AMT-AR-DAY-60        
                                              + AC-AMT-AR-DAY-90        
                                              + AC-AMT-UNUSED-CR        
                    MOVE WS-GEN-LED-RCC      TO WS-ACCT-NAME-CR         
                    MOVE 'Y'                 TO WS-RCC-REPLACED         
                    PERFORM 5100-SETUP-AR-JRNL     THRU 5100-EXIT       
                 END-IF                                                 
              END-IF                                                    
              PERFORM 8840-DELETE-AR-CURSOR-ROW    THRU 8840-EXIT       
           END-IF.                                                      
           PERFORM 8820-FETCH-AR-CNTRL-CURSOR   THRU 8820-EXIT.         
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5020-SETUP-EPP-FIELDS.                                         *        
      *    FIRST TIME , SETTING UP AN EPP                              *        
      ******************************************************************        
       5020-SETUP-EPP-FIELDS.                                           
                                                                        
           IF ( AC-ITEM-ID = 0  AND                                     
               (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-NSC OR            
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-LPC OR            
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-UTE OR            
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-UTG ))            
           OR ( AC-ITEM-ID > 0  AND                                     
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-RCC AND           
                ( AC-AMT-AR-DAY-00                                      
                  + AC-AMT-AR-DAY-30                                    
                  + AC-AMT-AR-DAY-60                                    
                  + AC-AMT-AR-DAY-90                                    
                  + AC-AMT-UNUSED-CR                                    
                  + AC-TOT-SUMM-UNBILLED ) > 0 )                        
                                                                        
              IF AC-ITEM-ID = 0                                         
                 COMPUTE WS-UTILITY-RELT-BALANCE =                      
                                                WS-UTILITY-RELT-BALANCE 
                                              + AC-AMT-AR-DAY-00        
                                              + AC-AMT-AR-DAY-30        
                                              + AC-AMT-AR-DAY-60        
                                              + AC-AMT-AR-DAY-90        
                                              + AC-AMT-UNUSED-CR        
                                                                        
                 IF AC-TOT-SUMM-UNBILLED GREATER THAN ZEROES            
                    ADD AC-TOT-SUMM-UNBILLED TO WS-UTILITY-RELT-BALANCE 
                 END-IF                                                 
              ELSE                                                      
                 COMPUTE WS-UTILITY-RELT-BALANCE =                      
                                                WS-UTILITY-RELT-BALANCE 
                                              + AC-AMT-TRAN-BALANCE     
              END-IF                                                    
                                                                        
              COMPUTE WS-UTILITY-RELT-ARREARS = WS-UTILITY-RELT-ARREARS 
                                              + AC-AMT-AR-DAY-30        
                                              + AC-AMT-AR-DAY-60        
                                              + AC-AMT-AR-DAY-90        
           END-IF.                                                      
           PERFORM 7760-FETCH-AR-CNTRL-CURSOR   THRU 7760-EXIT.         
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5050-FORMAT-REMARKS.                                        *           
      ***************************************************************           
       5050-FORMAT-REMARKS.                                             
                                                                        
P00220*                                                                         
ACT068     INITIALIZE  BH-REMARKS-TEXT                                  
P00220     IF WS-BILL-FLAG = 'R' OR 'S'                                 
P00220        MOVE IN-REMARKS-TEXT         TO BH-REMARKS-TEXT           
P00220        MOVE IN-REMARKS-LENGTH       TO BH-REMARKS-LEN            
P00220        GO TO 5050-EXIT                                           
P00220     ELSE                                                         
P00220        CONTINUE                                                  
P00220     END-IF.                                                      
P00220*                                                                         
P00694     MOVE ZEROS                      TO WS-ELEC-BUFFER            
P00694                                        WS-GAS-BUFFER             
           IF CSR-DATABASE AND C8-COMPANY-NO = '01'                     
              IF PR-ELEC-AVAILABLE-IND = 'A'                            
P00694           EVALUATE AT-ACCOUNT-TYPE-CODE                          
P00694              WHEN 'R'                                            
P00694                 MOVE WS-PCT-RESRATEINCR-ELEC TO WS-ELEC-BUFFER   
P00694              WHEN 'C'                                            
P00694                 MOVE WS-PCT-COMRATEINCR-ELEC TO WS-ELEC-BUFFER   
P00694           END-EVALUATE                                           
              ELSE                                                      
                 MOVE ZEROS                TO WS-ELEC-BUFFER            
              END-IF                                                    
              IF PR-GAS-AVAILABLE-IND = 'A'                             
P00694           EVALUATE AT-ACCOUNT-TYPE-CODE                          
P00694              WHEN 'R'                                            
P00694                 MOVE WS-PCT-RESRATEINCR-GAS  TO WS-GAS-BUFFER    
P00694              WHEN 'C'                                            
P00694                 MOVE WS-PCT-COMRATEINCR-GAS  TO WS-GAS-BUFFER    
P00694           END-EVALUATE                                           
              ELSE                                                      
                 MOVE ZEROS                TO WS-GAS-BUFFER             
              END-IF                                                    
              IF PR-ELEC-AVAILABLE-IND = 'A'                            
              AND PR-GAS-AVAILABLE-IND = 'A'                            
                 STRING 'BUFFER FACTOR ELEC: ' DELIMITED BY SIZE        
                              WS-ELEC-BUFFER   DELIMITED BY SIZE        
                              ' GAS: '         DELIMITED BY SIZE        
                              WS-GAS-BUFFER    DELIMITED BY SIZE        
                             ';'               DELIMITED BY SIZE        
                         INTO WS-BUFFER-REMARKS                         
                 ADD +41                   TO BH-REMARKS-LEN            
                                              WS-REMARKS-LEN-C          
              ELSE                                                      
                 IF PR-ELEC-AVAILABLE-IND = 'A'                         
                    STRING 'BUFFER FACTOR ELEC: ' DELIMITED BY SIZE     
                                   WS-ELEC-BUFFER DELIMITED BY SIZE     
                                       ';'        DELIMITED BY SIZE     
                           INTO WS-BUFFER-REMARKS                       
                    ADD +28            TO BH-REMARKS-LEN                
                                          WS-REMARKS-LEN-C              
                 ELSE                                                   
                    IF PR-GAS-AVAILABLE-IND = 'A'                       
                       STRING 'BUFFER FACTOR GAS: ' DELIMITED BY SIZE   
                                      WS-GAS-BUFFER DELIMITED BY SIZE   
                                          ';'       DELIMITED BY SIZE   
                              INTO WS-BUFFER-REMARKS                    
                       ADD +27           TO BH-REMARKS-LEN              
                                            WS-REMARKS-LEN-C            
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
P00694        MOVE WS-ESTRATE-GAS          TO WS-GAS-BUFFER             
              STRING 'BUFFER FACTOR GAS: ' DELIMITED BY SIZE            
                      WS-GAS-BUFFER        DELIMITED BY SIZE            
                      ';'                  DELIMITED BY SIZE            
                     INTO WS-BUFFER-REMARKS                             
              ADD   +27                     TO BH-REMARKS-LEN           
                                               WS-REMARKS-LEN-C         
           END-IF                                                       
           IF WS-REMARKS-LEN-N > 0                                      
              STRING WS-BUFFER-REMARKS DELIMITED BY ';'                 
                                   ' ' DELIMITED BY SIZE                
              WS-REMARKS-TEXT(1:WS-REMARKS-LEN-N) DELIMITED BY SIZE     
              INTO  BH-REMARKS-TEXT                                     
           ELSE                                                         
P00220        STRING IN-TRAN-IND       DELIMITED BY SIZE                
P00220                             ';' DELIMITED BY SIZE                
P00220               WS-BUFFER-REMARKS DELIMITED BY ';'                 
D02541                             ';' DELIMITED BY SIZE                
D02541               IN-REMARKS-TEXT(1:IN-REMARKS-LENGTH)               
D02541                                 DELIMITED BY SIZE                
P00220        INTO  BH-REMARKS-TEXT                                     
D02541        ADD   IN-REMARKS-LENGTH, +5   TO BH-REMARKS-LEN           
P00220                                         WS-REMARKS-LEN-C         
           END-IF                                                       
           IF BH-REMARKS-LEN > 210                                      
              MOVE +210                     TO BH-REMARKS-LEN           
           END-IF.                                                      
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5100-SETUP-AR-JRNL.                                         *           
      * AR JOURNALLING FOR SETTING UP EPP.                          *           
      ***************************************************************           
       5100-SETUP-AR-JRNL.                                              
                                                                        
           IF ((AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-NSC) OR           
               (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-LPC) OR           
               (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-UTE) OR           
               (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-UTG) OR           
               (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-CIA))             
                                                                        
              IF AC-AMT-AR-DAY-00 NOT = 0                               
                 MOVE '0'                         TO WS-AR-AGE          
                 MOVE AC-AMT-AR-DAY-00            TO WS-AMT-POSTED      
                                                     WS-END-AR-BALANCE  
                 PERFORM 5500-UPDATE-TRANS-HISTORY  THRU 5500-EXIT      
                 PERFORM 5700-CASH-DRAWER-101       THRU 5700-EXIT      
              END-IF                                                    
                                                                        
              IF AC-AMT-AR-DAY-30 NOT = 0                               
                 MOVE '3'                         TO WS-AR-AGE          
                 MOVE AC-AMT-AR-DAY-30            TO WS-AMT-POSTED      
                                                     WS-END-AR-BALANCE  
                 PERFORM 5500-UPDATE-TRANS-HISTORY  THRU 5500-EXIT      
                 PERFORM 5700-CASH-DRAWER-101       THRU 5700-EXIT      
              END-IF                                                    
                                                                        
              IF AC-AMT-AR-DAY-60 NOT = 0                               
                 MOVE '6'                         TO WS-AR-AGE          
                 MOVE AC-AMT-AR-DAY-60            TO WS-AMT-POSTED      
                                                     WS-END-AR-BALANCE  
                 PERFORM 5500-UPDATE-TRANS-HISTORY  THRU 5500-EXIT      
                 PERFORM 5700-CASH-DRAWER-101       THRU 5700-EXIT      
              END-IF                                                    
                                                                        
              IF AC-AMT-AR-DAY-90 NOT = 0                               
                 MOVE '9'                         TO WS-AR-AGE          
                 MOVE AC-AMT-AR-DAY-90            TO WS-AMT-POSTED      
                                                     WS-END-AR-BALANCE  
                 PERFORM 5500-UPDATE-TRANS-HISTORY  THRU 5500-EXIT      
                 PERFORM 5700-CASH-DRAWER-101       THRU 5700-EXIT      
              END-IF                                                    
                                                                        
              IF AC-AMT-UNUSED-CR NOT = 0                               
                 MOVE 'P'                         TO WS-AR-AGE          
                 MOVE AC-AMT-UNUSED-CR            TO WS-AMT-POSTED      
                                                     WS-END-AR-BALANCE  
                 PERFORM 5500-UPDATE-TRANS-HISTORY  THRU 5500-EXIT      
                 PERFORM 5700-CASH-DRAWER-101       THRU 5700-EXIT      
              END-IF                                                    
                                                                        
              IF AC-TOT-SUMM-UNBILLED NOT = 0                           
                 MOVE 'P'                         TO WS-AR-AGE          
                 MOVE AC-TOT-SUMM-UNBILLED        TO WS-AMT-POSTED      
                                                     WS-END-AR-BALANCE  
                 MOVE 'Y' TO WS-SUMM-UNBILLED-FLAG                      
                 PERFORM 5500-UPDATE-TRANS-HISTORY  THRU 5500-EXIT      
                 MOVE 'N' TO WS-SUMM-UNBILLED-FLAG                      
                 PERFORM 5700-CASH-DRAWER-101       THRU 5700-EXIT      
              END-IF                                                    
                                                                        
              IF (AC-AMT-AR-DAY-00 = 0 AND                              
                  AC-AMT-AR-DAY-30 = 0 AND                              
                  AC-AMT-AR-DAY-60 = 0 AND                              
                  AC-AMT-AR-DAY-90 = 0 AND                              
                  AC-AMT-UNUSED-CR = 0 AND                              
                  AC-TOT-SUMM-UNBILLED = 0 )                            
                 MOVE '0'                        TO WS-AR-AGE           
                 MOVE ZEROES                     TO WS-AMT-POSTED       
                                                    WS-END-AR-BALANCE   
                 PERFORM 5500-UPDATE-TRANS-HISTORY THRU 5500-EXIT       
                 PERFORM 5700-CASH-DRAWER-101      THRU 5700-EXIT       
              END-IF                                                    
           ELSE                                                         
              IF (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-RCC)            
                 IF AC-AMT-TRAN-BALANCE NOT = 0                         
                    MOVE 'F'                        TO WS-AR-AGE        
                    MOVE AC-AMT-TRAN-BALANCE        TO WS-AMT-POSTED    
                                                       WS-END-AR-BALANCE
                    PERFORM 5500-UPDATE-TRANS-HISTORY THRU 5500-EXIT    
                    PERFORM 5700-CASH-DRAWER-101      THRU 5700-EXIT    
                 END-IF                                                 
              ELSE                                                      
                 IF ((AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-EPP)        
                      AND (WS-AMT-TO-COLLECT > 0) AND (AC-ITEM-ID > 0)) 
                 OR ((AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-EPP)        
                     AND (AT-REV-MTH-LST-NRML = 0) AND (AC-ITEM-ID > 0))
                    MOVE WS-GEN-LED-EPP     TO WS-ACCT-NAME-CR          
                    MOVE '0'                TO WS-AR-AGE                
                    MOVE WS-AMT-TO-COLLECT  TO WS-AMT-POSTED            
                                               WS-END-AR-BALANCE        
                    PERFORM 5500-UPDATE-TRANS-HISTORY  THRU 5500-EXIT   
                    PERFORM 5700-CASH-DRAWER-101       THRU 5700-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5500-UPDATE-TRANS-HISTORY.                                 *            
      * UPDATE TRANSACTION HISTORY TABLE                           *            
      **************************************************************            
       5500-UPDATE-TRANS-HISTORY.                                       
                                                                        
           MOVE '5500'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           MOVE WS-ACCOUNT-NO-NUM        TO AR-ACCOUNT-NO               
                                            AU-ACCOUNT-NO.              
ACT117     MOVE WS-USER-ID                   TO PF-USER-ID.             
ACT117     PERFORM 7550-GET-RESP-AREA-ID      THRU 7550-EXIT.           
ACT117                                                                  
           IF WS-ACTION-CODE = 'I'                                      
              IF AC-PYMT-PRIORITY-LVL = 50                              
                 MOVE  1                    TO AU-TRAN-APPL-NO          
                 PERFORM 7600-GET-TIMESTAMP-AND-DATE THRU 7600-EXIT     
              ELSE                                                      
                 ADD   1                    TO AU-TRAN-APPL-NO          
              END-IF                                                    
           ELSE                                                         
              ADD  1                    TO AU-TRAN-APPL-NO              
              IF AU-TRAN-APPL-NO = 1                                    
                 PERFORM 7600-GET-TIMESTAMP-AND-DATE THRU 7600-EXIT     
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-CURRENT-TIMESTAMP     TO AR-TRANS-HIST-SEQ-NO        
                                            AU-TRANS-HIST-SEQ-NO.       
           MOVE WS-CURRENT-DATE          TO AR-DATE-TRANS.              
           MOVE AC-ITEM-ID               TO AU-ITEM-ID.                 
                                                                        
           MOVE WS-AR-AGE                TO AU-CODE-AR-AGE.             
           IF WS-ACTION-CODE = 'I'                                      
              IF AC-PYMT-PRIORITY-LVL = 50                              
                 MOVE WS-AMT-TO-COLLECT       TO AR-AMT-ORIG-ENTERED    
              ELSE                                                      
                 MOVE WS-UTILITY-RELT-BALANCE TO AR-AMT-ORIG-ENTERED    
                 IF WS-SUMM-UNBILLED-FLAG = 'N'                         
                    COMPUTE WS-AMT-BILLED-UNPAID = WS-AMT-BILLED-UNPAID 
                                                 - WS-AMT-POSTED        
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF AC-PYMT-PRIORITY-LVL = 50                              
                 MOVE WS-BILLED-BALANCE       TO AR-AMT-ORIG-ENTERED    
              ELSE                                                      
                 MOVE WS-UTILITY-BALANCE      TO AR-AMT-ORIG-ENTERED    
              END-IF                                                    
           END-IF.                                                      
           IF AR-AMT-ORIG-ENTERED < 0                                   
              MULTIPLY -1 BY AR-AMT-ORIG-ENTERED                        
                      GIVING AR-AMT-ORIG-ENTERED                        
           END-IF.                                                      
           MOVE WS-AMT-BILLED-UNPAID     TO AR-AMT-BILLED-UNPAID.       
                                                                        
           IF WS-AMT-POSTED < 0                                         
              MOVE WS-ACCT-NAME-DR       TO GO-GL-ACCT-NAME             
           ELSE                                                         
              MOVE WS-ACCT-NAME-CR       TO GO-GL-ACCT-NAME             
           END-IF.                                                      
           PERFORM 7500-SELECT-GL-NAME  THRU 7500-EXIT.                 
                                                                        
           MOVE GO-GL-ACCT-NO            TO WS-101-ACCT-GEN-LED-CR      
                                            AU-GL-ACCT-CREDIT.          
           IF WS-AMT-POSTED < 0                                         
              MOVE WS-ACCT-NAME-CR       TO GO-GL-ACCT-NAME             
           ELSE                                                         
              MOVE WS-ACCT-NAME-DR       TO GO-GL-ACCT-NAME             
           END-IF.                                                      
           PERFORM 7500-SELECT-GL-NAME  THRU 7500-EXIT.                 
           MOVE GO-GL-ACCT-NO            TO WS-101-ACCT-GEN-LED-DR      
                                            AU-GL-ACCT-DEBIT.           
           IF WS-AMT-POSTED < 0                                         
              MULTIPLY -1 BY WS-AMT-POSTED GIVING WS-AMT-POSTED         
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-POSTED            TO AU-AMT-POSTED               
                                            AU-CURRENCY-AMT.            
ACT117     MOVE PF-RESP-AREA-ID          TO AR-RESP-AREA-ID.            
           MOVE WS-USER-ID               TO AR-USER-ID.                 
           IF AC-PYMT-PRIORITY-LVL = 50                                 
              MOVE 'A'                   TO AR-CODE-TRAN-TYPE           
              IF WS-ACTION-CODE = 'I'                                   
                 MOVE WS-TRAN-COMMENT-LEN-C TO AR-TRAN-COMMENT-LEN      
                 MOVE WS-TRAN-COMMENT-TEXT  TO AR-TRAN-COMMENT-TEXT     
              ELSE                                                      
                 MOVE +0                    TO AR-TRAN-COMMENT-LEN      
                 MOVE SPACES                TO AR-TRAN-COMMENT-TEXT     
                 IF AT-CODE-ACCT-STAT = 'P' OR AT-REV-MTH-LST-NRML = 0  
                    MOVE 'D'                TO AR-CODE-TRAN-TYPE        
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE 'D'                      TO AR-CODE-TRAN-TYPE        
              IF WS-ACTION-CODE = 'I'                                   
                 MOVE WS-UTILITY-RELT-BALANCE TO AR-AMT-ORIG-ENTERED    
              ELSE                                                      
                 MOVE WS-UTILITY-BALANCE      TO AR-AMT-ORIG-ENTERED    
              END-IF                                                    
              IF AR-AMT-ORIG-ENTERED < 0                                
                 MULTIPLY -1 BY AR-AMT-ORIG-ENTERED                     
                    GIVING AR-AMT-ORIG-ENTERED                          
              END-IF                                                    
              MOVE WS-TRAN-COMMENT-LEN-C TO AR-TRAN-COMMENT-LEN         
              MOVE WS-TRAN-COMMENT-TEXT  TO AR-TRAN-COMMENT-TEXT        
           END-IF.                                                      
                                                                        
           MOVE SPACES                   TO AR-PYMT-FACILITY-CD         
                                            AR-RECORD-ONLY-FL           
                                            AU-CODE-CONTRACT-TYPE.      
           IF WS-ACTION-CODE = 'I'                                      
P00220        IF WS-BILL-FLAG = 'C' OR 'R'                              
                 MOVE 'PANEL147C'        TO AR-APPL-PROGRAM-ID          
              ELSE                                                      
                 MOVE 'PANEL147D'        TO AR-APPL-PROGRAM-ID          
ACT084           IF WS-AMT-TO-COLLECT NOT EQUAL WS-UTILITY-BALANCE-TRN  
ACT084               AND IN-TRAN-IND NOT = 'WEB'                        
ACT084              MOVE WS-N            TO AR-RECORD-ONLY-FL           
ACT084           ELSE                                                   
ACT084              MOVE WS-Y            TO AR-RECORD-ONLY-FL           
ACT132           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE SPACES                   TO AU-CURRENCY-TYPE.           
           MOVE WS-CURRENT-DATE          TO AT-DATE-LAST-ACTION.        
           MOVE AT-COMPANY-NO            TO AR-COMPANY-NO.              
A02878     MOVE -1                       TO WS-DATE-ORIG-PYMT-IND.      
A02878     MOVE SPACES                   TO AR-PYMT-REFUNDED-IND        
A02878                                      AR-PYMT-RCPT-PRNTD-CD.      
           MOVE '01'                     TO WS-CD-COMPANY-NO.           
           MOVE '998'                    TO WS-CD-LOCAL-OFFICE.         
           MOVE '998'                    TO WS-CD-REPORT-NO.            
           MOVE WS-CURRENT-DATE          TO WS-CD-REPORT-DATE.          
           MOVE 9999                     TO WS-CASH-DRAWER-ID.          
           MOVE WS-CD-COMPANY-NO         TO AR-CASH-COMPANY-NO.         
           MOVE WS-CD-LOCAL-OFFICE       TO AR-CASH-LOCAL-OFFICE.       
           MOVE WS-CD-REPORT-NO          TO AR-CASH-REPORT-NO.          
           MOVE WS-CD-REPORT-DATE        TO AR-DATE-CASH-REPORT.        
           MOVE WS-CASH-DRAWER-ID        TO AR-CASH-DRAWER-ID.          
                                                                        
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT.        
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5700-CASH-DRAWER-101.                                          *        
      *    -- THIS MODULE WRITES A FORMAT 101 CASH DRAWER JOURNAL      *        
      ******************************************************************        
       5700-CASH-DRAWER-101.                                            
                                                                        
           PERFORM 5800-SET-100-JRNL-VARS             THRU 5800-EXIT.   
                                                                        
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
                                                                        
           MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
                                                                        
           MOVE WS-AMT-POSTED           TO WS-101-AMT-POSTED            
                                           WS-JRNL-RCV-DEBIT-AMT        
                                           WS-JRNL-RCV-CREDIT-AMT.      
           IF AC-PYMT-PRIORITY-LVL = 50                                 
              IF WS-ACTION-CODE = 'I'                                   
                 MOVE WS-AMT-TO-COLLECT TO WS-101-AMOUNT-ENTERED        
              ELSE                                                      
                 MOVE WS-BILLED-BALANCE TO WS-101-AMOUNT-ENTERED        
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTION-CODE = 'I'                                   
                 MOVE AT-TOTAL-AR-BALANCE TO WS-101-AMOUNT-ENTERED      
              ELSE                                                      
                 MOVE WS-UTILITY-BALANCE-TRN TO WS-101-AMOUNT-ENTERED   
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-AR-AGE               TO WS-101-AR-AGE.               
           MOVE WS-CURRENT-DATE         TO WS-101-DATE-AR-BILLED.       
           MOVE 0                       TO WS-101-ITEM-ID-NO.           
           IF AC-PYMT-PRIORITY-LVL = 50                                 
              MOVE WS-UTILITY-BALANCE TO WS-101-DETAIL-END-BAL          
           ELSE                                                         
              IF WS-ACTION-CODE = 'I'                                   
                 ADD WS-END-AR-BALANCE     TO WS-101-DETAIL-END-BAL     
              ELSE                                                      
                 SUBTRACT WS-AMT-POSTED  FROM WS-101-DETAIL-END-BAL     
              END-IF                                                    
           END-IF.                                                      
           IF AC-PYMT-PRIORITY-LVL = 50                                 
              IF WS-ACTION-CODE = 'I'                                   
                 MOVE WS-END-AR-BALANCE TO WS-101-DETAIL-END-AR-BAL     
              ELSE                                                      
                 IF AU-TRAN-APPL-NO = 1                                 
                    MOVE WS-BILLED-BALANCE TO WS-101-DETAIL-END-AR-BAL  
                    SUBTRACT WS-AMT-POSTED FROM WS-101-DETAIL-END-AR-BAL
                 ELSE                                                   
                    SUBTRACT WS-AMT-POSTED FROM WS-101-DETAIL-END-AR-BAL
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE ZEROES            TO WS-101-DETAIL-END-AR-BAL        
           END-IF.                                                      
           IF WS-101-ACCT-END-AR-BAL = 0                                
              IF WS-ACTION-CODE = 'I'                                   
                 MOVE AT-TOTAL-AR-BALANCE  TO WS-101-ACCT-END-AR-BAL    
              ELSE                                                      
                 IF AC-PYMT-PRIORITY-LVL = 50                           
                    MOVE WS-BILLED-BALANCE TO WS-101-ACCT-END-AR-BAL    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           IF WS-ACTION-CODE = 'I'                                      
              IF AC-PYMT-PRIORITY-LVL = 50                              
                 MOVE WS-AMT-POSTED     TO WS-101-ACCT-END-AR-BAL       
              ELSE                                                      
                 SUBTRACT WS-END-AR-BALANCE FROM WS-101-ACCT-END-AR-BAL 
              END-IF                                                    
           ELSE                                                         
              IF AC-PYMT-PRIORITY-LVL = 50                              
                 SUBTRACT WS-AMT-POSTED FROM WS-101-ACCT-END-AR-BAL     
              ELSE                                                      
                 ADD  WS-AMT-POSTED     TO WS-101-ACCT-END-AR-BAL       
              END-IF                                                    
           END-IF.                                                      
           MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
           MOVE PR-REV-DISTRICT-CD      TO WS-101-CODE-REVENUE-DISTRICT.
           MOVE CU-CODE-EMPL-ACCT       TO WS-101-CODE-EMPL-ACCT.       
           MOVE AT-CODE-COMPANY-ACCT    TO WS-101-CODE-COMPANY-ACCT.    
           MOVE AT-CODE-ACCT-STAT       TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE PR-CODE-PREMISE-STAT    TO WS-101-CODE-PREMISE-STATUS.  
                                                                        
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
                                                                        
           PERFORM 5775-ONLINE-JRNL-CALL THRU 5775-EXIT.                
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5740-GET-UTILITY-BALANCE.                                      *        
      ******************************************************************        
       5740-GET-UTILITY-BALANCE.                                        
                                                                        
              PERFORM 7750-OPEN-AR-CNTRL-CURSOR    THRU 7750-EXIT       
              PERFORM 7760-FETCH-AR-CNTRL-CURSOR   THRU 7760-EXIT       
              PERFORM 5020-SETUP-EPP-FIELDS        THRU 5020-EXIT       
                      UNTIL ( WS-ACTIVE-RETURN-CODE = NOT-FOUND )       
                                                                        
              PERFORM 7770-CLOSE-AR-CNTRL-CURSOR   THRU 7770-EXIT.      
                                                                        
       5740-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 5750-MISCELLANEOUS-113.                                      *          
      *     -- THIS MODULE WRITES A FORMAT 113 MISCELLANEOUS JOURNAL *          
      ****************************************************************          
       5750-MISCELLANEOUS-113.                                          
                                                                        
           PERFORM 5800-SET-100-JRNL-VARS     THRU 5800-EXIT.           
                                                                        
           MOVE 113                       TO WS-113-JRNL-FORMAT-NO.     
           MOVE SPACES                    TO WS-113-CASH-DRAWER-USED.   
           MOVE WS-RM01-RECORD-FIELD-DESC TO WS-113-RECORD-FIELD-DESC.  
           MOVE AT-TOTAL-AR-BALANCE       TO WS-113-ACCT-AR-BAL-IS      
                                             WS-113-ACCT-AR-BAL-WAS.    
           MOVE WS-AMT-AR-DAY-00-WAS      TO WS-113-AR-DAY-00-WAS.      
           MOVE AC-AMT-AR-DAY-00          TO WS-113-AR-DAY-00-IS.       
           MOVE AC-AMT-AR-DAY-30          TO WS-113-AR-DAY-30-IS        
                                             WS-113-AR-DAY-30-WAS.      
           MOVE AC-AMT-AR-DAY-60          TO WS-113-AR-DAY-60-IS        
                                             WS-113-AR-DAY-60-WAS.      
           MOVE AC-AMT-AR-DAY-90          TO WS-113-AR-DAY-90-IS        
                                             WS-113-AR-DAY-90-WAS.      
           ADD WS-113-AR-DAY-00-WAS                                     
               WS-113-AR-DAY-30-WAS                                     
               WS-113-AR-DAY-60-WAS                                     
               WS-113-AR-DAY-90-WAS                                     
                                     GIVING WS-113-TOTAL-AGED-WAS.      
           ADD WS-113-AR-DAY-00-IS                                      
               WS-113-AR-DAY-30-IS                                      
               WS-113-AR-DAY-60-IS                                      
               WS-113-AR-DAY-90-IS                                      
                                     GIVING WS-113-TOTAL-AGED-IS.       
           MOVE PR-REV-DISTRICT-CD     TO WS-113-CODE-REVENUE-DISTRICT. 
           MOVE CU-CODE-EMPL-ACCT      TO WS-113-CODE-EMPL-ACCT.        
           MOVE AT-CODE-COMPANY-ACCT   TO WS-113-CODE-COMPANY-ACCT.     
           MOVE AT-CODE-ACCT-STAT      TO WS-113-CODE-ACCOUNT-STATUS.   
           MOVE PR-CODE-PREMISE-STAT   TO WS-113-CODE-PREMISE-STATUS.   
                                                                        
           MOVE CJF00113               TO WS-100-USER-DEFINED-AREA.     
                                                                        
           PERFORM 5775-ONLINE-JRNL-CALL THRU 5775-EXIT.                
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 5775-ONLINE-JRNL-CALL                                        *          
      *    MOVE FIELDS AND CALL 6400- PARAGRAPH CHECKING FOR ERROR   *          
      ****************************************************************          
       5775-ONLINE-JRNL-CALL.                                           
                                                                        
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE             THRU 6400-EXIT. 
                                                                        
           IF WS-JRNL-RTRN-CODE NOT = SPACES                            
              PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT   
              PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT   
           END-IF.                                                      
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY      TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE             THRU 6400-EXIT. 
                                                                        
           IF WS-JRNL-RTRN-CODE NOT = SPACES                            
              PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT   
              PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT   
           END-IF.                                                      
                                                                        
       5775-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 5800-SET-100-JRNL-VARS                                       *          
      *    INITIALIZE FIELDS THAT ARE REQUIRED FOR THE MISCELLANEOUS *          
      *    JOURNAL HEADER.                                           *          
      ****************************************************************          
       5800-SET-100-JRNL-VARS.                                          
                                                                        
           MOVE '5800'               TO ACTIVE-PARAGRAPH.               
                                                                        
           MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO.                     
      *******************************************************                   
      * THESE FILEDS WERE POPULATED BY CALLING CPD00020     *                   
      * (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.    *                   
      *******************************************************                   
           MOVE 9             TO WS-TRAN-OPER-LEVEL.                    
           MOVE 1             TO WS-TRAN-OCAP-FIELD.                    
           MOVE 1             TO WS-TRAN-OCAP-VALUE.                    
           MOVE 'C'           TO WS-TRAN-JRNL-TYPE.                     
           MOVE 'N'           TO WS-TRAN-HOLD-EXEMPT-FLAG.              
                                                                        
      *******************************************************                   
      * THESE FILEDS WERE POPULATED BY CALLING CPD00021     *                   
      * (PARAGRAPH 5980) TO VERIFY USER-ID.                 *                   
      *******************************************************                   
           MOVE WS-USER-ID         TO WS-JRNL-OL-TEMP-ID.               
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC.                      
           MOVE WS-CD-COMPANY-NO     TO WS-JRNL-OL-COMPANY.             
           MOVE WS-CD-LOCAL-OFFICE   TO WS-JRNL-OL-LOC-OFF.             
           MOVE WS-CD-REPORT-NO      TO WS-JRNL-OL-REPORT-NO.           
           MOVE WS-CD-REPORT-DATE    TO WS-JRNL-OL-REPORT-DT.           
           MOVE WS-CASH-DRAWER-ID    TO WS-JRNL-OL-CASH-DRWR.           
           MOVE SPACES               TO WS-JRNL-CURRENCY-TYPE           
                                        WS-JRNL-CODE-PYMT-FACILITY.     
           MOVE WS-TERM-LOC          TO WS-JRNL-OL-TERM-LOC             
                                        WS-JRNL-OL-CASH-LOC             
                                        WS-JRNL-OL-OPR-LOC.             
                                                                        
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
           MOVE 'C'                  TO WS-JRNL-SOURCE-CODE.            
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE  TO WS-JRNL-OL-AUTH-TYPE         
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE
           END-IF.     
           PERFORM 6400-ONLINE-JRNL-ROUTINE      THRU 6400-EXIT.        
                                                                        
           MOVE 'A'                  TO WS-100-JRNL-SORT-ID.            
           MOVE AT-COMPANY-NO        TO WS-100-COMPANY-NO.              
           MOVE AT-ACCOUNT-NO        TO WS-100-ACCT-NO.                 
           MOVE AT-CUSTOMER-NO       TO WS-100-CUSTOMER-NO.             
           MOVE 0                    TO WS-100-PREMISE-NO.              
           MOVE '276B'               TO WS-100-CODE-TERMINAL-TRAN.      
           MOVE AU-TRAN-APPL-NO      TO WS-100-JRNL-TRAN-APPL-NO.       
           MOVE AT-DATE-LAST-ACTION  TO WS-100-DATE-LAST-ACTION.        
           MOVE 'C'                  TO WS-100-CODE-ENTRY-SOURCE.       
           MOVE WS-CD-COMPANY-NO     TO WS-JRNL-OL-COMPANY.             
           MOVE WS-CD-LOCAL-OFFICE   TO WS-JRNL-OL-LOC-OFF.             
           MOVE WS-CD-REPORT-NO      TO WS-JRNL-OL-REPORT-NO.           
           MOVE WS-CD-REPORT-DATE    TO WS-JRNL-OL-REPORT-DT.           
           MOVE WS-CASH-DRAWER-ID    TO WS-JRNL-OL-CASH-DRWR.           
           MOVE AT-LOCAL-OFFICE      TO WS-100-LOCAL-OFFICE-CD.         
           MOVE SPACES               TO WS-100-TRANS-ERRORS.            
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5910-CHECK-FOR-LPN.                                        *            
      * CHECK FOR LPN (LATE PAY NON-UTILITY) ON THE AR_CNTL TABLE. *            
      * IF THERE IS LPN, THEN SET SWITCH SO THAT CODE-LPC IN       *            
      * CODES-DATA-PRESENT WILL NOT BE BLANKED OUT.                *            
      **************************************************************            
       5910-CHECK-FOR-LPN.                                              
                                                                        
           MOVE SPACE TO WS-LPN-FOUND.                                  
           MOVE ZEROS TO WS-LPN-COUNT.                                  
           MOVE WS-ACCOUNT-NO-NUM TO AC-ACCOUNT-NO.                     
           MOVE WS-PPL-AR-TYPE-LPN TO AC-PYMT-PRIORITY-LVL.             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 1                                                  
                INTO :WS-LPN-COUNT                                      
                FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                       
               WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO              
                 AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL       
                                                  
A02878                                                           
A02878                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1                                                          
MFA-TR*         INTO :WS-LPN-COUNT                                              
MFA-TR*         FROM CSS_AR_CNTL AC                                             
MFA-TR*        WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                      
MFA-TR*          AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL               
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 5910                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5910'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
           IF WS-LPN-COUNT = ZEROS                                      
              MOVE 'N' TO WS-LPN-FOUND                                  
           ELSE                                                         
              MOVE 'Y' TO WS-LPN-FOUND                                  
           END-IF.                                                      
                                                                        
       5910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5950-CALC-ELEC-PCT.                                        *            
      **************************************************************            
       5950-CALC-ELEC-PCT.                                              
                                                                        
           MOVE 0                        TO WS-CTR-MONTHS               
                                            WS-UTE-DOLLARS              
                                            WS-UTG-DOLLARS.             
           MOVE WS-ACCOUNT-NO-NUM        TO BG-ACCOUNT-NO.              
           PERFORM 7950-OPEN-PCT-CURSOR  THRU 7950-EXIT.                
           PERFORM 7960-FETCH-PCT-CURSOR THRU 7960-EXIT.                
           PERFORM UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                   OR WS-CTR-MONTHS > 3)                                
              IF BG-REVENUE-MONTH NOT = WS-PREV-REV-MONTH               
                 ADD 1 TO WS-CTR-MONTHS                                 
              END-IF                                                    
              IF WS-CTR-MONTHS > 3                                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 IF BZ-CODE-UTIL-TYPE = 'E'                             
                    ADD BZ-BILLED-COMP-AM TO WS-UTE-DOLLARS             
                 END-IF                                                 
                 IF BZ-CODE-UTIL-TYPE = 'G'                             
                    ADD BZ-BILLED-COMP-AM TO WS-UTG-DOLLARS             
                 END-IF                                                 
                 IF BZ-CODE-UTIL-TYPE = 'U'                             
                    MOVE BG-ACCOUNT-NO         TO UC-ACCOUNT-NO         
                    MOVE BG-BILL-NO            TO UC-BILL-NO            
                    MOVE BG-CODE-UTIL-TYPE     TO UC-CODE-UTIL-TYPE     
                    MOVE BG-IC-NO              TO UC-IC-NO              
                    MOVE BG-BILL-ITEM-TIMESTMP TO UC-BILL-ITEM-TIMESTMP 
                    PERFORM 7990-FETCH-SERVICE-TYPE THRU 7990-EXIT      
                    IF UC-CODE-SERVICE-TYPE = 'E'                       
                       ADD BZ-BILLED-COMP-AM   TO WS-UTE-DOLLARS        
                    END-IF                                              
                    IF UC-CODE-SERVICE-TYPE = 'G'                       
                       ADD BZ-BILLED-COMP-AM   TO WS-UTG-DOLLARS        
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              MOVE BG-REVENUE-MONTH TO WS-PREV-REV-MONTH                
              PERFORM 7960-FETCH-PCT-CURSOR THRU 7960-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7970-CLOSE-PCT-CURSOR THRU 7970-EXIT.                
                                                                        
           IF WS-CTR-MONTHS > 3                                         
              COMPUTE WS-BOTH-DOLLARS = WS-UTE-DOLLARS + WS-UTG-DOLLARS 
              IF WS-BOTH-DOLLARS > 0                                    
                 COMPUTE AT-ELEC-REV-ALLOC-PCT ROUNDED =                
                        (WS-UTE-DOLLARS / WS-BOTH-DOLLARS) * 100        
              ELSE                                                      
                 MOVE 0 TO AT-ELEC-REV-ALLOC-PCT                        
              END-IF                                                    
           ELSE                                                         
              MOVE 0 TO AT-ELEC-REV-ALLOC-PCT                           
           END-IF.                                                      
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * ONLINE JOURNALLING.                                        *            
      **************************************************************            
           EXEC SQL                                                             
A00956        INCLUDE CPD0006A                                                  
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      * AR TRANSACTION HISTORY CODE                                *            
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE CPD00008                                                  
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      * MNT TRANSACTION HISTORY CODE                               *            
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ***************************************************************           
      * 7000-SELECT-ACCOUNT.                                        *           
      *     FETCH DETAILS FROM THE ACCOUNT TABLE                    *           
      ***************************************************************           
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT AT.CODE_COMPANY_ACCT                               
                    ,AT.DATE_LAST_ACTION                                
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.COMPANY_NO                                      
                    ,AT.PREMISE_NO                                      
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.CUSTOMER_NO                                     
                    ,AT.CODES_DATA_PRESENT                              
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.CREDIT_GROUP                                    
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                    ,AT.ELEC_REV_ALLOC_PCT                              
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.BILL_CYCLE                                      
                    ,AT.CODE_TEMP_BILL                                  
P00694              ,AT.ACCOUNT_TYPE_CODE                               
                INTO :AT-CODE-COMPANY-ACCT                              
                    ,:AT-DATE-LAST-ACTION :WS-DATE-LAST-ACTION-NULL      
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-COMPANY-NO                                     
                    ,:AT-PREMISE-NO                                     
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-LAST-UPDATE-TS                                 
                    ,:AT-ELEC-REV-ALLOC-PCT                             
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-CODE-TEMP-BILL                                 
P00694              ,:AT-ACCOUNT-TYPE-CODE                              
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
A02878                                                           
A02878                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CODE_COMPANY_ACCT                                       
MFA-TR*             ,AT.DATE_LAST_ACTION                                        
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.LAST_UPDATE_TS                                          
MFA-TR*             ,AT.ELEC_REV_ALLOC_PCT                                      
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,AT.CODE_TEMP_BILL                                          
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*         INTO :AT-CODE-COMPANY-ACCT                                      
MFA-TR*             ,:AT-DATE-LAST-ACTION:WS-DATE-LAST-ACTION-NULL              
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*             ,:AT-ELEC-REV-ALLOC-PCT                                     
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-CODE-TEMP-BILL                                         
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-DATE-LAST-ACTION-NULL < 0                           
                 MOVE +0              TO AT-DATE-LAST-ACTION            
              END-IF                                                    
           ELSE                                                         
              MOVE '7000'         TO ACTIVE-PARAGRAPH                   
              MOVE SPACES         TO ABEND-TABLES                       
              MOVE SPACES         TO ABEND-SQL-PREDICATES               
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE 'SELECT'       TO ABEND-FUNCTION                     
              MOVE 'CSS_ACCOUNT'  TO TABLE-1                            
              MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1                    
              MOVE AT-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7100-SELECT-PREMISE.                                        *           
      *    FETCH DETAILS FROM THE PREMISE TABLE                     *           
      ***************************************************************           
       7100-SELECT-PREMISE.                                             
                                                                        
           MOVE AT-PREMISE-NO           TO PR-PREMISE-NO.               
                                                                        
           EXEC SQL                                                     
              SELECT PR.CODE_PREMISE_STAT                               
                    ,PR.REV_DISTRICT_CD                                 
                    ,PR.LOCAL_OFFICE                                    
                    ,PR.GAS_AVAILABLE_IND                               
                    ,PR.ELEC_AVAILABLE_IND                              
                INTO :PR-CODE-PREMISE-STAT                              
                    ,:PR-REV-DISTRICT-CD                                
                    ,:PR-LOCAL-OFFICE                                   
                    ,:PR-GAS-AVAILABLE-IND                              
                    ,:PR-ELEC-AVAILABLE-IND                             
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                       
               WHERE PR.PREMISE_NO = :PR-PREMISE-NO                     
A02878                                                           
A02878                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.CODE_PREMISE_STAT                                       
MFA-TR*             ,PR.REV_DISTRICT_CD                                         
MFA-TR*             ,PR.LOCAL_OFFICE                                            
MFA-TR*             ,PR.GAS_AVAILABLE_IND                                       
MFA-TR*             ,PR.ELEC_AVAILABLE_IND                                      
MFA-TR*         INTO :PR-CODE-PREMISE-STAT                                      
MFA-TR*             ,:PR-REV-DISTRICT-CD                                        
MFA-TR*             ,:PR-LOCAL-OFFICE                                           
MFA-TR*             ,:PR-GAS-AVAILABLE-IND                                      
MFA-TR*             ,:PR-ELEC-AVAILABLE-IND                                     
MFA-TR*         FROM CSS_PREMISE PR                                             
MFA-TR*        WHERE PR.PREMISE_NO = :PR-PREMISE-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7100'             TO ACTIVE-PARAGRAPH               
              MOVE SPACES             TO ABEND-TABLES                   
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE 'SELECT'           TO ABEND-FUNCTION                 
              MOVE 'CSS_PREMISE'      TO TABLE-1                        
              MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1                
              MOVE PR-PREMISE-NO      TO HOSTVAR-ELEMENT-1              
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-2                
              MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2              
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7200-SELECT-CUSTOMER.                                       *           
      * FETCH DETAILS FROM THE CUSTOMER TABLE                       *           
      ***************************************************************           
       7200-SELECT-CUSTOMER.                                            
                                                                        
           MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO.                       
                                                                        
           EXEC SQL                                                     
              SELECT CU.CODE_EMPL_ACCT                                  
                    ,CU.CODE_CUST_STATUS                                
                INTO :CU-CODE-EMPL-ACCT                                 
                    ,:CU-CODE-CUST-STATUS                               
                FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
               WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                   
A02878                                                           
A02878                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CU.CODE_EMPL_ACCT                                          
MFA-TR*             ,CU.CODE_CUST_STATUS                                        
MFA-TR*         INTO :CU-CODE-EMPL-ACCT                                         
MFA-TR*             ,:CU-CODE-CUST-STATUS                                       
MFA-TR*         FROM CSS_CUSTOMER CU                                            
MFA-TR*        WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_CUSTOMER'      TO TABLE-1                       
              MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1               
              MOVE CU-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1             
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7500-SELECT-GL-NAME.                                        *           
      *    GET THE GL NAME.                                         *           
      ***************************************************************           
       7500-SELECT-GL-NAME.                                             
                                                                        
           EXEC SQL                                                     
              SELECT GO1.GL_ACCT_NO                                     
                INTO :GO-GL-ACCT-NO                                     
                FROM CSS_GL_ACCT_NO GO1 WITH(READUNCOMMITTED)                   
               WHERE GO1.COMPANY_NO   = '01'                            
                 AND GO1.GL_ACCT_NAME = :GO-GL-ACCT-NAME                
A02878                                                           
A02878                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GO1.GL_ACCT_NO                                             
MFA-TR*         INTO :GO-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_GL_ACCT_NO GO1                                         
MFA-TR*        WHERE GO1.COMPANY_NO   = '01'                                    
MFA-TR*          AND GO1.GL_ACCT_NAME = :GO-GL-ACCT-NAME                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROES TO GO-GL-ACCT-NO                           
              END-IF                                                    
           ELSE                                                         
              MOVE '7500'           TO ACTIVE-PARAGRAPH                 
              MOVE SPACES           TO ABEND-TABLES                     
              MOVE SPACES           TO ABEND-SQL-PREDICATES             
              MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
              MOVE 'SELECT'         TO ABEND-FUNCTION                   
              MOVE 'CSS_GL_ACCT_NO' TO TABLE-1                          
              MOVE 'COMPANY_NO'     TO TABLE-ELEMENT-1                  
              MOVE 'GL_ACCT_NAME'   TO TABLE-ELEMENT-2                  
              MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-3                  
              MOVE '01'             TO HOSTVAR-ELEMENT-1                
              MOVE GO-GL-ACCT-NAME  TO HOSTVAR-ELEMENT-2                
              MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-3                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT117***************************************************************           
ACT117* 7550-GET-RESP-AREA-ID                                       *           
ACT117*    GET THE RESP AREA ID.                                    *           
ACT117***************************************************************           
ACT117 7550-GET-RESP-AREA-ID.                                           
ACT117                                                                  
ACT117     EXEC SQL                                                     
ACT117        SELECT  PF.RESP_AREA_ID                                   
ACT117          INTO :PF-RESP-AREA-ID                                   
ACT117          FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
ACT117         WHERE PF.USER_ID = :PF-USER-ID                           
ACT117                                                           
ACT117                                                      
ACT117     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  PF.RESP_AREA_ID                                           
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE PF.USER_ID = :PF-USER-ID                                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7550                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT117                                                                  
ACT117     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT117                                          S-RETURN-CODE.          
ACT117                                                                  
ACT117     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT117        CONTINUE                                                  
ACT117     ELSE                                                         
ACT117        MOVE '7550'                    TO ACTIVE-PARAGRAPH        
ACT117        MOVE SPACES                    TO ABEND-TABLES            
ACT117        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT117        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT117        MOVE 'SELECT'                  TO ABEND-FUNCTION          
ACT117        MOVE 'CSS_USER_PROFILE'        TO TABLE-1                 
ACT117        MOVE 'PF_USER_ID'              TO TABLE-ELEMENT-1         
ACT117        MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-1       
ACT117        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
ACT117        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
ACT117     END-IF.                                                      
ACT117                                                                  
ACT117 7550-EXIT.                                                       
ACT117     EXIT.                                                        
ACT117                                                                  
      ****************************************************************          
      * 7540-SELECT-DELINQ-VALUE.                                    *          
      *   THIS PROCEDURE WILL SUPPLY THE DELINQUENCY VALUE           *          
      ****************************************************************          
       7540-SELECT-DELINQ-VALUE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT C8.DELINQ_VALUE                                   
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                  
                WHERE C8.DELINQ_CD       = :C8-DELINQ-CD                
                  AND C8.COMPANY_NO      = :C8-COMPANY-NO               
A02878                                                           
A02878                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT C8.DELINQ_VALUE                                           
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY C8                                        
MFA-TR*         WHERE C8.DELINQ_CD       = :C8-DELINQ-CD                        
MFA-TR*           AND C8.COMPANY_NO      = :C8-COMPANY-NO                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7540                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '7540'             TO ACTIVE-PARAGRAPH               
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE 'SELECT'           TO ABEND-FUNCTION                 
              MOVE 'CSS_DELINQUENCY'  TO TABLE-1                        
              MOVE 'DELINQ_CD'        TO TABLE-ELEMENT-1                
              MOVE C8-DELINQ-CD       TO HOSTVAR-ELEMENT-1              
              MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1                
              MOVE C8-COMPANY-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7600-GET-TIMESTAMP-AND-DATE.                                 *          
      *   THIS MODULE GETS CURRENT TIMESTAMP AND DATE FOR CREATING   *          
      * JOURNAL ENTRIES                                              *          
      ****************************************************************          
       7600-GET-TIMESTAMP-AND-DATE.                                     
                                                                        
           EXEC SQL                                                     
T34097        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP  =  CURRENT TIMESTAMP                   
MFA-TR*          ,:WS-CURRENT-DATE      =  CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5600'                TO ACTIVE-PARAGRAPH            
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A03710 7720-SELECT-REV-MTH.                                             
      *                                                                         
           EXEC SQL                                                     
            SELECT TOP(1) REVENUE_MONTH                                        
             INTO  :BN-REVENUE-MONTH                                    
             FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
             WHERE DATE_EXTRACT  >= CAST(SYSDATETIMEOFFSET() AS DATE)           
               AND CODE_BILL_COND   = 'R'                               
             ORDER BY DATE_EXTRACT, REVENUE_MONTH DESC                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     30631301
MFA-TR*     SELECT REVENUE_MONTH                                        30631401
MFA-TR*      INTO  :BN-REVENUE-MONTH                                    30631501
MFA-TR*      FROM CSS_BILL_WINDOW                                       30631601
MFA-TR*      WHERE DATE_EXTRACT  >= CURRENT DATE                        30631701
MFA-TR*        AND CODE_BILL_COND   = 'R'                               30631801
MFA-TR*      ORDER BY DATE_EXTRACT, REVENUE_MONTH DESC                          
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7720                                                       
MFA-TR*    END-EXEC.                                                    30631901

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7720'             TO ACTIVE-PARAGRAPH               
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE 'SELECT'           TO ABEND-FUNCTION                 
              MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
              MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
A03710 7720-EXIT.                                                       
A03710     EXIT.                                                        
      *                                                                         
A02878****************************************************************          
A02878** GET MAX REV MONTH USING "BILL CYCLE" & "CURRENT DATE"      **          
A02878****************************************************************          
A02878*                                                                         
A02878 7730-GET-BILL-WINDOW-REVMTH.                                     
A02878*                                                                         
A02878     EXEC SQL                                                     
A02878        SELECT COALESCE(MAX(BN.REVENUE_MONTH),0)                  
A02878          INTO :BN-REVENUE-MONTH                                  
A02878          FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
A02878         WHERE BN.BILL_CYCLE   = :BN-BILL-CYCLE                   
A02878           AND BN.DATE_EXTRACT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
A02878                                                           
A02878                                                      
A02878     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COALESCE(MAX(BN.REVENUE_MONTH),0)                          
MFA-TR*         INTO :BN-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*        WHERE BN.BILL_CYCLE   = :BN-BILL-CYCLE                           
MFA-TR*          AND BN.DATE_EXTRACT <= CURRENT DATE                            
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7730                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02878*                                                                         
A02878     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
A02878*                                                                         
A02878     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  AND              
A02878        BN-REVENUE-MONTH      > 0                                 
A02878        CONTINUE                                                  
A02878     ELSE                                                         
A02878        MOVE '7730'             TO ACTIVE-PARAGRAPH               
A02878        MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
A02878        MOVE 'SELECT'           TO ABEND-FUNCTION                 
A02878        MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                        
A02878        MOVE 'BILL CYCLE'       TO TABLE-ELEMENT-1                
A02878        MOVE BN-BILL-CYCLE      TO HOSTVAR-ELEMENT-1              
A02878        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A02878        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A02878     END-IF.                                                      
A02878*                                                                         
A02878 7730-EXIT.                                                       
A02878     EXIT.                                                        
A02878*                                                                         
      ******************************************************************        
      * 7750-OPEN-AR-CNTRL-CURSOR                                      *        
      ******************************************************************        
       7750-OPEN-AR-CNTRL-CURSOR.                                       
                                                                        
           MOVE WS-ACCOUNT-NO-NUM        TO AC-ACCOUNT-NO.              
                                                                        
           EXEC SQL                                                     
              OPEN AR_CNTL_CURSOR2                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7750'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7760-FETCH-AR-CNTRL-CURSOR                                     *        
      ******************************************************************        
       7760-FETCH-AR-CNTRL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH AR_CNTL_CURSOR2                                     
               INTO :AC-AMT-AR-DAY-00                                   
                   ,:AC-AMT-AR-DAY-30                                   
                   ,:AC-AMT-AR-DAY-60                                   
                   ,:AC-AMT-AR-DAY-90                                   
                   ,:AC-AMT-UNUSED-CR                                   
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AC-TOT-SUMM-UNBILLED                               
                   ,:AC-PYMT-PRIORITY-LVL                               
                   ,:AC-ITEM-ID                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7760'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7760-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7770-CLOSE-AR-CNTRL-CURSOR.                                    *        
      ******************************************************************        
       7770-CLOSE-AR-CNTRL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE AR_CNTL_CURSOR2                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7770'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       7770-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 7950-OPEN-PCT-CURSOR.                                    *              
      ************************************************************              
       7950-OPEN-PCT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN PCT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '7950'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'CSS_BILLING_DET'         TO TABLE-2                 
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-3                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 7960-FETCH-PCT-CURSOR                                    *              
      ************************************************************              
       7960-FETCH-PCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              FETCH PCT-CURSOR                                          
               INTO :BG-REVENUE-MONTH                                   
                   ,:BZ-CODE-UTIL-TYPE                                  
                   ,:BZ-BILLED-COMP-AM                                  
                   ,:BG-BILL-NO                                         
                   ,:BG-CODE-UTIL-TYPE                                  
                   ,:BG-IC-NO                                           
                   ,:BG-BILL-ITEM-TIMESTMP                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7960'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'CSS_BILLING_DET'         TO TABLE-2                 
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-3                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 7970-CLOSE-PCT-CURSOR.                                   *              
      ************************************************************              
       7970-CLOSE-PCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE PCT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7970'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'PCT-CURSOR'              TO TABLE-1                 
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'CSS_BILLING_DET'         TO TABLE-2                 
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-3                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7970-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 7990-FETCH-SERVICE-TYPE.                                 *              
      *    DETERMINE SERVICE IF UNMETERED                                       
      ************************************************************              
       7990-FETCH-SERVICE-TYPE.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) UC.CODE_SERVICE_TYPE                              
                 INTO :UC-CODE-SERVICE-TYPE                             
                 FROM CSS_UM_CNSMPT_HIST UC WITH(READUNCOMMITTED)               
                WHERE UC.ACCOUNT_NO           = :UC-ACCOUNT-NO          
                  AND UC.CODE_UTIL_TYPE       = :UC-CODE-UTIL-TYPE      
                  AND UC.BILL_NO              = :UC-BILL-NO             
                  AND UC.IC_NO                = :UC-IC-NO               
                  AND UC.BILL_ITEM_TIMESTMP   = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )  
                                                  
A02878                                                           
A02878                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT UC.CODE_SERVICE_TYPE                                      
MFA-TR*          INTO :UC-CODE-SERVICE-TYPE                                     
MFA-TR*          FROM CSS_UM_CNSMPT_HIST UC                                     
MFA-TR*         WHERE UC.ACCOUNT_NO           = :UC-ACCOUNT-NO                  
MFA-TR*           AND UC.CODE_UTIL_TYPE       = :UC-CODE-UTIL-TYPE              
MFA-TR*           AND UC.BILL_NO              = :UC-BILL-NO                     
MFA-TR*           AND UC.IC_NO                = :UC-IC-NO                       
MFA-TR*           AND UC.BILL_ITEM_TIMESTMP   = :UC-BILL-ITEM-TIMESTMP          
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7990                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7990'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_UM_CNSMPT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-3         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-4         
              MOVE UC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UC-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE UC-BILL-NO                TO HOSTVAR-ELEMENT-3       
              MOVE UC-IC-NO                  TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT181***************************************************************           
ACT181* 8000-DELETE-CRED-COLL                                       *           
ACT181*   FOR SEB DELETE ROW FROM CRED COLL WHERE NOTICE TYPE = 'D' *           
ACT181**************************************************************            
ACT181 8000-DELETE-CRED-COLL.                                           
                                                                        
ACT181     EXEC SQL                                                     
ACT181         DELETE FROM CSS_CRED_COLL                                
ACT181         WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO                
ACT181           AND CODE_NOTICE_TYPE   = 'D'                           
ACT181     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
ACT181     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
ACT181                     S-RETURN-CODE.                               
                                                                        
ACT181     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT181        CONTINUE                                                  
ACT181     ELSE                                                         
ACT181        MOVE '8000'                      TO ACTIVE-PARAGRAPH      
ACT181        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
ACT181        MOVE 'DELETE'                    TO ABEND-FUNCTION        
ACT181        MOVE 'CSS_CRED_COLL'             TO TABLE-1               
ACT181        MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
ACT181        MOVE CL-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
ACT181        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
ACT181        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
ACT181     END-IF.                                                      
                                                                        
ACT181 8000-EXIT.                                                       
ACT181     EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8710-INSERT-AR-CNTL.                                        *           
      *   INSERT RECORD IN THE AR CONTROL TABLE.                    *           
      ***************************************************************           
       8710-INSERT-AR-CNTL.                                             
                                                                        
           MOVE WS-CURRENT-TIMESTAMP    TO AC-LAST-UPDATE-TS.           
           MOVE AT-ACCOUNT-NO           TO AC-ACCOUNT-NO.               
                                                                        
           EXEC SQL                                                     
           INSERT INTO CSS_AR_CNTL                                      
                  ( ACCOUNT_NO                                          
                   ,PYMT_PRIORITY_LVL                                   
                   ,ITEM_ID                                             
                   ,AMT_AR_DAY_00                                       
                   ,AMT_AR_DAY_30                                       
                   ,AMT_AR_DAY_60                                       
                   ,AMT_AR_DAY_90                                       
                   ,AMT_UNUSED_CR                                       
                   ,AMT_TRAN_BALANCE                                    
                   ,TOT_SUMM_UNBILLED                                   
                   ,LAST_UPDATE_TS     )                                
           VALUES (:AC-ACCOUNT-NO                                       
                  ,:AC-PYMT-PRIORITY-LVL                                
                  ,:AC-ITEM-ID                                          
                  ,:AC-AMT-AR-DAY-00                                    
                  ,:AC-AMT-AR-DAY-30                                    
                  ,:AC-AMT-AR-DAY-60                                    
                  ,:AC-AMT-AR-DAY-90                                    
                  ,:AC-AMT-UNUSED-CR                                    
                  ,:AC-AMT-TRAN-BALANCE                                 
                  ,:AC-TOT-SUMM-UNBILLED                                
                  ,CIS.CHAR2TIMESTAMP(:AC-LAST-UPDATE-TS)    )                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_AR_CNTL                                              
MFA-TR*           ( ACCOUNT_NO                                                  
MFA-TR*            ,PYMT_PRIORITY_LVL                                           
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*            ,AMT_AR_DAY_00                                               
MFA-TR*            ,AMT_AR_DAY_30                                               
MFA-TR*            ,AMT_AR_DAY_60                                               
MFA-TR*            ,AMT_AR_DAY_90                                               
MFA-TR*            ,AMT_UNUSED_CR                                               
MFA-TR*            ,AMT_TRAN_BALANCE                                            
MFA-TR*            ,TOT_SUMM_UNBILLED                                           
MFA-TR*            ,LAST_UPDATE_TS     )                                        
MFA-TR*    VALUES (:AC-ACCOUNT-NO                                               
MFA-TR*           ,:AC-PYMT-PRIORITY-LVL                                        
MFA-TR*           ,:AC-ITEM-ID                                                  
MFA-TR*           ,:AC-AMT-AR-DAY-00                                            
MFA-TR*           ,:AC-AMT-AR-DAY-30                                            
MFA-TR*           ,:AC-AMT-AR-DAY-60                                            
MFA-TR*           ,:AC-AMT-AR-DAY-90                                            
MFA-TR*           ,:AC-AMT-UNUSED-CR                                            
MFA-TR*           ,:AC-AMT-TRAN-BALANCE                                         
MFA-TR*           ,:AC-TOT-SUMM-UNBILLED                                        
MFA-TR*           ,:AC-LAST-UPDATE-TS    )                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '8710'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3              
              MOVE 'LAST_UPDATE_TS'     TO TABLE-ELEMENT-4              
              MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE AC-ITEM-ID           TO HOSTVAR-ELEMENT-3            
              MOVE AC-LAST-UPDATE-TS    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8720-INSERT-BUDGET-PLAN.                                    *           
      *   INSERT RECORD IN THE BUDGET PLAN TABLE.                   *           
      ***************************************************************           
       8720-INSERT-BUDGET-PLAN.                                         
                                                                        
           MOVE AT-ACCOUNT-NO           TO BU-ACCOUNT-NO.               
                                                                        
           EXEC SQL                                                     
           INSERT INTO CSS_BUDGET_PLAN                                  
                  ( ACCOUNT_NO                                          
                   ,PYMT_PRIORITY_LVL                                   
                   ,BP_ITEM_ID                                          
                   ,AMT_MO_PYMT                                         
                   ,ANNIVERSARY_DATE                                    
                   ,DATE_PYMT_STRT                                      
                   ,AMT_MO_PYT_BAL_FWD                                  
                   ,AMT_MO_PYMT_NEW    )                                
           VALUES (:BU-ACCOUNT-NO                                       
                  ,:BU-PYMT-PRIORITY-LVL                                
                  ,:BU-BP-ITEM-ID                                       
                  ,:BU-AMT-MO-PYMT                                      
                  ,IIF(TRY_CONVERT(DATE, :BU-ANNIVERSARY-DATE
              ) IS NULL OR (PATINDEX('%.%', :BU-ANNIVERSARY-DATE
              ) <> 0) OR (LEN(:BU-ANNIVERSARY-DATE
              ) <> 10), CIS.CHAR2DATE(:BU-ANNIVERSARY-DATE
              ), CONVERT(DATE, :BU-ANNIVERSARY-DATE) )                         
                  ,IIF(TRY_CONVERT(DATE, :BU-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BU-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BU-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BU-DATE-PYMT-STRT
              ), CONVERT(DATE, :BU-DATE-PYMT-STRT) )                           
                  ,:BU-AMT-MO-PYT-BAL-FWD                               
                  ,:BU-AMT-MO-PYMT-NEW   )                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_BUDGET_PLAN                                          
MFA-TR*           ( ACCOUNT_NO                                                  
MFA-TR*            ,PYMT_PRIORITY_LVL                                           
MFA-TR*            ,BP_ITEM_ID                                                  
MFA-TR*            ,AMT_MO_PYMT                                                 
MFA-TR*            ,ANNIVERSARY_DATE                                            
MFA-TR*            ,DATE_PYMT_STRT                                              
MFA-TR*            ,AMT_MO_PYT_BAL_FWD                                          
MFA-TR*            ,AMT_MO_PYMT_NEW    )                                        
MFA-TR*    VALUES (:BU-ACCOUNT-NO                                               
MFA-TR*           ,:BU-PYMT-PRIORITY-LVL                                        
MFA-TR*           ,:BU-BP-ITEM-ID                                               
MFA-TR*           ,:BU-AMT-MO-PYMT                                              
MFA-TR*           ,:BU-ANNIVERSARY-DATE                                         
MFA-TR*           ,:BU-DATE-PYMT-STRT                                           
MFA-TR*           ,:BU-AMT-MO-PYT-BAL-FWD                                       
MFA-TR*           ,:BU-AMT-MO-PYMT-NEW   )                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '8720'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUDGET_PLAN'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE 'BP_ITEM_ID'         TO TABLE-ELEMENT-3              
              MOVE 'DATE_PYMT_STRT'     TO TABLE-ELEMENT-4              
              MOVE BU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE BU-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE BU-BP-ITEM-ID        TO HOSTVAR-ELEMENT-3            
              MOVE BU-DATE-PYMT-STRT    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8730-INSERT-BUDGET-HIST.                                    *           
      *   INSERT RECORD IN THE BUDGET HISTORY TABLE.                *           
      ***************************************************************           
       8730-INSERT-BUDGET-HIST.                                         
                                                                        
           MOVE WS-CURRENT-TIMESTAMP    TO BH-BUD-HIST-SEQ-NO.          
           MOVE AT-ACCOUNT-NO           TO BH-ACCOUNT-NO.               
P0694A     MOVE WS-USER-ID              TO BH-LAST-UPDATE-USERID.       
                                                                        
           EXEC SQL                                                     
           INSERT INTO CSS_BUDGET_HIST                                  
                  ( ACCOUNT_NO                                          
                   ,PYMT_PRIORITY_LVL                                   
                   ,ITEM_ID                                             
                   ,BUD_HIST_SEQ_NO                                     
                   ,AMT_MO_PYMT                                         
                   ,DATE_PYMT_STRT                                      
                   ,UTILITY_BALANCE                                     
                   ,BALANCE_FORWARD                                     
                   ,EPP_ESTIMATE                                        
                   ,METHOD_OF_ESTIMATE                                  
                   ,CHANGE_REASON                                       
                   ,EPP_MTHS_RMNG_QT                                    
                   ,REMARKS                                             
P0694A             ,LAST_UPDATE_USERID )                                
           VALUES (:BH-ACCOUNT-NO                                       
                  ,:BH-PYMT-PRIORITY-LVL                                
                  ,:BH-ITEM-ID                                          
                  ,CIS.CHAR2TIMESTAMP(:BH-BUD-HIST-SEQ-NO)                      
                  ,:BH-AMT-MO-PYMT                                      
                  ,IIF(TRY_CONVERT(DATE, :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) )                           
                  ,:BH-UTILITY-BALANCE                                  
                  ,:BH-BALANCE-FORWARD                                  
                  ,:BH-EPP-ESTIMATE                                     
                  ,:BH-METHOD-OF-ESTIMATE                               
                  ,:BH-CHANGE-REASON                                    
                  ,:BH-EPP-MTHS-RMNG-QT                                 
                  ,:BH-REMARKS                                          
P0694A            ,:BH-LAST-UPDATE-USERID )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_BUDGET_HIST                                          
MFA-TR*           ( ACCOUNT_NO                                                  
MFA-TR*            ,PYMT_PRIORITY_LVL                                           
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*            ,BUD_HIST_SEQ_NO                                             
MFA-TR*            ,AMT_MO_PYMT                                                 
MFA-TR*            ,DATE_PYMT_STRT                                              
MFA-TR*            ,UTILITY_BALANCE                                             
MFA-TR*            ,BALANCE_FORWARD                                             
MFA-TR*            ,EPP_ESTIMATE                                                
MFA-TR*            ,METHOD_OF_ESTIMATE                                          
MFA-TR*            ,CHANGE_REASON                                               
MFA-TR*            ,EPP_MTHS_RMNG_QT                                            
MFA-TR*            ,REMARKS                                                     
MFA-TR*            ,LAST_UPDATE_USERID )                                        
MFA-TR*    VALUES (:BH-ACCOUNT-NO                                               
MFA-TR*           ,:BH-PYMT-PRIORITY-LVL                                        
MFA-TR*           ,:BH-ITEM-ID                                                  
MFA-TR*           ,:BH-BUD-HIST-SEQ-NO                                          
MFA-TR*           ,:BH-AMT-MO-PYMT                                              
MFA-TR*           ,:BH-DATE-PYMT-STRT                                           
MFA-TR*           ,:BH-UTILITY-BALANCE                                          
MFA-TR*           ,:BH-BALANCE-FORWARD                                          
MFA-TR*           ,:BH-EPP-ESTIMATE                                             
MFA-TR*           ,:BH-METHOD-OF-ESTIMATE                                       
MFA-TR*           ,:BH-CHANGE-REASON                                            
MFA-TR*           ,:BH-EPP-MTHS-RMNG-QT                                         
MFA-TR*           ,:BH-REMARKS                                                  
MFA-TR*           ,:BH-LAST-UPDATE-USERID )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '8730'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUDGET_HIST'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3              
              MOVE 'DATE_PYMT_STRT'     TO TABLE-ELEMENT-4              
              MOVE BH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE BH-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE BH-ITEM-ID           TO HOSTVAR-ELEMENT-3            
              MOVE BH-DATE-PYMT-STRT    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8805-UPDATE-ACCOUNT-EPP-OFFER                               *           
      *   UPDATE LAST ACTION DATE ON ACCOUNT TABLE.                 *           
      ***************************************************************           
       8805-UPDATE-ACCOUNT-EPP-OFFER.                                   
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET DATE_LAST_ACTION   = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) ),         
                     CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       
                     CREDIT_GROUP       = :AT-CREDIT-GROUP,             
                     TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,         
                     EPP_OFFER_AMOUNT   = :AT-EPP-OFFER-AMOUNT,         
                     EPP_OFFER_DATE     = IIF(TRY_CONVERT(DATE, 
                                                    :AT-EPP-OFFER-DATE 
                                              :WS-EPP-OFFER-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :AT-EPP-OFFER-DATE 
                                              :WS-EPP-OFFER-DT-NULL-IND
              ) <> 0) OR (LEN(:AT-EPP-OFFER-DATE 
                                              :WS-EPP-OFFER-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:AT-EPP-OFFER-DATE 
                                              :WS-EPP-OFFER-DT-NULL-IND
              ), CONVERT(DATE, :AT-EPP-OFFER-DATE 
                                              :WS-EPP-OFFER-DT-NULL-IND
              ) ),    
                     ELEC_REV_ALLOC_PCT = :AT-ELEC-REV-ALLOC-PCT,       
                     CODE_TEMP_BILL     = :AT-CODE-TEMP-BILL,           
                     LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
                 AND LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET DATE_LAST_ACTION   = :AT-DATE-LAST-ACTION,                 
MFA-TR*              CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,               
MFA-TR*              CREDIT_GROUP       = :AT-CREDIT-GROUP,                     
MFA-TR*              TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,                 
MFA-TR*              EPP_OFFER_AMOUNT   = :AT-EPP-OFFER-AMOUNT,                 
MFA-TR*              EPP_OFFER_DATE     = :AT-EPP-OFFER-DATE                    
MFA-TR*                                   :WS-EPP-OFFER-DT-NULL-IND,            
MFA-TR*              ELEC_REV_ALLOC_PCT = :AT-ELEC-REV-ALLOC-PCT,               
MFA-TR*              CODE_TEMP_BILL     = :AT-CODE-TEMP-BILL,                   
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*          AND LAST_UPDATE_TS     = :AT-LAST-UPDATE-TS                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE WS-LAST-UPDATE-TS-MISMATCH TO S-RETURN-CODE          
                                                 WS-ACTIVE-RETURN-CODE  
           ELSE                                                         
              MOVE SQLCODE                    TO S-RETURN-CODE          
                                                 WS-ACTIVE-RETURN-CODE  
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '8805'              TO ACTIVE-PARAGRAPH              
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'LAST_UPDATE_TS'    TO TABLE-ELEMENT-2               
              MOVE 'DATE_LAST_ACTION'  TO TABLE-ELEMENT-3               
              MOVE 'CREDIT_GROUP'      TO TABLE-ELEMENT-4               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE AT-LAST-UPDATE-TS   TO HOSTVAR-ELEMENT-2             
              MOVE AT-DATE-LAST-ACTION TO HOSTVAR-ELEMENT-3             
              MOVE AT-CREDIT-GROUP     TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8805-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8810-OPEN-AR-CNTRL-CURSOR.                                  *           
      *   OPEN  AR-CNTL CURSOR                                      *           
      ***************************************************************           
       8810-OPEN-AR-CNTRL-CURSOR.                                       
                                                                        
           MOVE WS-ACCOUNT-NO-NUM TO AC-ACCOUNT-NO.                     
                                                                        
           EXEC SQL                                                     
              OPEN AR_CNTL_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8810'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8820-FETCH-AR-CNTRL-CURSOR.                                 *           
      *   FETCH AR-CNTL CURSOR                                      *           
      ***************************************************************           
       8820-FETCH-AR-CNTRL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                FETCH AR_CNTL_CURSOR                                    
                 INTO :AC-AMT-AR-DAY-00                                 
                     ,:AC-AMT-AR-DAY-30                                 
                     ,:AC-AMT-AR-DAY-60                                 
                     ,:AC-AMT-AR-DAY-90                                 
                     ,:AC-AMT-UNUSED-CR                                 
                     ,:AC-AMT-TRAN-BALANCE                              
                     ,:AC-TOT-SUMM-UNBILLED                             
                     ,:AC-PYMT-PRIORITY-LVL                             
                     ,:AC-ITEM-ID                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8820'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       8820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8830-CLOSE-AR-CNTRL-CURSOR.                                 *           
      *   CLOSE AR-CNTL CURSOR .                                    *           
      ***************************************************************           
       8830-CLOSE-AR-CNTRL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE AR_CNTL_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8830'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8830-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8840-DELETE-AR-CURSOR-ROW.                                  *           
      *   DELETE AR-CNTL CURSOR CURRENT ROW                         *           
      ***************************************************************           
       8840-DELETE-AR-CURSOR-ROW.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_AR_CNTL                                   
               WHERE CURRENT OF AR_CNTL_CURSOR                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8840'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8840-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      * 8855-UPDATE-AR-TRANS-HIST.                                *             
      *************************************************************             
       8855-UPDATE-AR-TRANS-HIST.                                       
                                                                        
           MOVE AR-AMT-ORIG-ENTERED  TO  WS-AR-AMT-ORIG-ENTERED-ED      
           MOVE AR-AMT-BILLED-UNPAID TO  WS-AR-AMT-BILLED-UNPAID-ED     
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_AR_TRANS_HIST                                 
                  SET AMT_ORIG_ENTERED  = :AR-AMT-ORIG-ENTERED          
                     ,AMT_BILLED_UNPAID = :AR-AMT-BILLED-UNPAID         
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_AR_TRANS_HIST                                         
MFA-TR*           SET AMT_ORIG_ENTERED  = :AR-AMT-ORIG-ENTERED                  
MFA-TR*              ,AMT_BILLED_UNPAID = :AR-AMT-BILLED-UNPAID                 
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                        
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8855'                      TO ACTIVE-PARAGRAPH      
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE 'UPDATE'                    TO ABEND-FUNCTION        
              MOVE 'CSS_AR_TRANS_HIST'         TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE 'TRANS_HIST_SEQ_NO'         TO TABLE-ELEMENT-2       
              MOVE 'AMT_ORIG_ENTERED'          TO TABLE-ELEMENT-3       
              MOVE 'AMT_BILLED_UNPAID'         TO TABLE-ELEMENT-4       
              MOVE AR-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              MOVE AR-TRANS-HIST-SEQ-NO        TO HOSTVAR-ELEMENT-2     
              MOVE WS-AR-AMT-ORIG-ENTERED-ED   TO HOSTVAR-ELEMENT-3     
              MOVE WS-AR-AMT-BILLED-UNPAID-ED  TO HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       8855-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      * 9500-INPUT-ABEND.                                                       
      *  PERFORMS ABEND WHEN INVALID INPUT                                      
      *************************************************************             
       9500-INPUT-ABEND.                                                
                                                                        
           MOVE PROGRAM-NAME    TO ABEND-PROGRAM                        
           MOVE 'RECEIVE INPUT' TO ABEND-FUNCTION                       
           MOVE +1000           TO WS-ACTIVE-RETURN-CODE                
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT               
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      * 7999-SELECT-AL.                                                         
      *     COPYBOOK TO CHECK AR-LOCKOUT STATUS                                 
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CPD00075                                                  
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      * 8900-SEND-DONE.                                                         
      * 9000-SEND-ERROR-RESULT.                                                 
      * 9999-END-PROGRAM.                                                       
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      * 9700-PROCESS-ABEND.                                       *             
      * CPD0023C CICS ABEND PROCESSING FOR DB2 ABENDS IN CPD00023 *             
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      * 9900-SQL-ERROR-ROUTINE.                                                 
      * 9975-ABEND-CONTROL-TRANSFER.                                            
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
