       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03515.                                         
COB303 DATE-WRITTEN.  DEC 21, 2004.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE CHECKS THE AUTO DEPOSIT RULES AND RETURNS      *        
      *  AUTO DEPOSIT AMT IF THE ACCOUNT IS ELIGIBLE FOR ONE.          *        
      *  THIS PROCEDURE USES CPD00308 TO COMPUTE THE MAX DEPOSIT AMT   *        
      *  THIS PROCEDURE CALLS DB2 SP CSR02072 TO CHARGE A AUTO DEPOSIT *        
      *  WHEN IT IS CALLED FROM PANEL090, CAD OR  PANEL181.            *        
      *  THIS PROCEDURE WILL CALL CSR02072 TO CHARGE A AUTO DEPOSIT    *        
      *  WHEN CALLED FROM                                              *        
      *  1. CSR02189 - (PANEL181) - RETURNED CHECKS POSTING            *        
      *  2. PCSSO067 - (CAD/PANEL090)-WHEN RECONNECT ORDERS ARE POSTED *        
P00773*  3. PCSCA044 - NEW BATCH PROGRAM - ACCOUNT REVIEW                       
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/21/04  SS82048    PROCEDURE ORIGINALLY CODED.              *        
C26296*  05/03/05  SS82048    RETRIEVE MIN DEP AMT FROM DELINQUENCY    *        
      *                       SEPARATELY WHEN MAX DEP AMT IS ZEROES.   *        
C26296*  05/26/05  MJ13662    WHEN DEPOSIT IS CHARGED THRU PCSSO067    *        
      *                       (PANEL 90), PSNC WILL BE CHARGED NEXT BILL        
      *                       DEPOSIT AND WILL BE SENT A LETTER.       *        
C33201*  09/14/05  SS82048    INCLUDE DCLGEN FOR CSS_REG_PROFILE       *        
      *                       FOR MAX DEPOSIT CALCULATION CHANGES.     *        
C33128*  10/24/05  SS82048    ALLOW AUTO DEPOSITS FOR CT-METER ACCOUNTS*        
C33201*  02/16/06  SS82048    INCLUDE DCLGEN FOR CSS_LOCAL_OFFICE      *        
      *                       FOR MAX DEPOSIT CALCULATION CHANGES.     *        
T34083*  03/27/06  SS82048    FIX AUTO DNP DEPOSITS CREATED DURING     *        
      *                       RECONNECT ORDER POSTING PROCESS THAT     *        
      *                       ARE CHARGED FOR AN AMT GREATER THAN      *        
      *                       NOTICE AMOUNT.                           *        
T34110*  04/06/06  CVNS       FIXED TO ADD SUM FOR THE COLUMN          *        
T34110*            CHENNAI    AMT_BOND IN 7280-SELECT-SURETY-BOND-AMT  *        
A37061*  04/06/09  SJ97149    1.REPLACE CODE_REV_CLASS MID DIGIT CHECK *        
A37061*                         WITH CSS_ACCOUNT.ACCOUNT_TYPE_CODE FOR *        
A37061*                         GETTING TYPE OF THE ACCOUNT.           *        
A37061*                       2.ADDED "ROWSET POSITIONING" FOR GLOBAL  *        
A37061*                         TEMPERARY TABLES.                      *        
P00677*  06/05/2012 NS75440   AUTO DEP DELINQUENCY VALUE CHANGES.      *        
ACT116*  10/12/2012 DB41297   AUTO DEP DELINQUENCY ONLY FOR CSR.       *        
P00773*  09/16/2013 MJ13662   ADDED LOGIC FOR ACCOUNT REVIEW.          *        
ACT239*  08/08/2014 RB19957   IF CALLING PROGRAM IS PCSCA132 THEN MOVE *        
ACT239*       APPL00004880    'Y' TO WS-CALLING-BATCH-SW AND MOVE NEW  *        
ACT239*                       INPUT PARM DATE TO WS-TEMP-BATCH-DATE.   *        
A05091*  01/23/16   RB19957   ADDED TBATMISC WHICH IS NOW NEEDED       *        
A05091*                       IN CPD00308 FOR SEB SEASONAL FLAG.       *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03515'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      **   CSS_DELINQUENCY (C8)                                                 
      ************************************************************              
           EXEC SQL                                                             
            INCLUDE TBDELQ                                                      
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      **   CSS_BILL_WINDOW (BN)                                                 
      ************************************************************              
           EXEC SQL                                                             
            INCLUDE TBBILWDW                                                    
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      **   CSS_RATE_CREATOR (RT)                                                
      ************************************************************              
           EXEC SQL                                                             
            INCLUDE TBRTCRTR                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_UTIL_ENVRNMT (UT)                                                
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBUTLENV                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_DEP_ON_HAND  (DO)                                                
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBDEPHND                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_GUARANTOR  (GU)                                                  
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBGTNTR                                                     
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_SURETY_BOND  (SB)                                                
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBSTYBND                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_RATE_PLAN_DESC (RD)                                              
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBRTDESC                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_ACCOUNT (AT)                                                     
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_ACCT_ATTRIBUTE  (YP)                                             
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      **   CSS_NSF_HIST (NH)                                      **            
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      **   CSS_CUST_PREM_HIST (CH)                                **            
      **************************************************************            
           EXEC SQL                                                     00912000
              INCLUDE TBCSTPRM                                          00913000
           END-EXEC.                                                    00914000
                                                                        
      **************************************************************            
      **   CSS_BILLING_HDR (BI)                                   **            
      **************************************************************            
           EXEC SQL                                                     00912000
              INCLUDE TBBLLHDR                                          00913000
           END-EXEC.                                                    00914000
                                                                        
      **************************************************************            
      **   CSS_AR_TRANS_HIST (AR)                                 **            
      **************************************************************            
           EXEC SQL                                                     00930000
              INCLUDE TBARHIST                                          00940000
           END-EXEC.                                                    00950000
                                                                        
      **************************************************************            
      **   CSS_BILLING_DET  (BG)                                  **            
      **************************************************************            
           EXEC SQL                                                     00930000
              INCLUDE TBBLLDET                                          00940000
           END-EXEC.                                                    00950000
                                                                        
      **************************************************************            
      **   CSS_CREDIT_PROFILE (CZ)                                **            
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBCRPROF                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      **   CSS_RECONNECT (DL)                                     **            
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBRECNCT                                                    
           END-EXEC.                                                            
                                                                        
C33201************************************************************              
C33201**   CSS_REG_PROFILE (LR)                                                 
C33201************************************************************              
C33201     EXEC SQL                                                             
C33201        INCLUDE TBREGPRF                                                  
C33201     END-EXEC.                                                            
C33201*                                                                         
C33201************************************************************              
C33201**   CSS_LOCAL_OFFICE (B1)                                                
C33201************************************************************              
C33201     EXEC SQL                                                             
C33201        INCLUDE TBLOCOFC                                                  
C33201     END-EXEC.                                                            
C33201*                                                                         
A05091************************************************************              
A05091**   CSS_ACCT_MISC_INFO TA                                                
A05091************************************************************              
A05091     EXEC SQL                                                             
A05091        INCLUDE TBATMISC                                                  
A05091     END-EXEC.                                                            
      *                                                                 01218000
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME              PIC X(8) VALUE 'CSR03515'.     
           05  WS-SQLSTATE               PIC X(5) VALUE SPACES.         
           05  ALL-DONE-SW               PIC X(1) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW              PIC X(1) VALUE 'Y'.            
               88  SEND-DONE-ERROR       VALUE 'N'.                     
               88  SEND-DONE-OK          VALUE 'Y'.                     
           05  WS-DATABASE               PIC 9(01) VALUE 0.             
               88 CSR-DATABASE                     VALUE 1.             
               88 SEB-DATABASE                     VALUE 2.             
           05  WS-ROW-COUNT              PIC S9(09) COMP.               
           05  WS-POSITION               PIC S9(04) COMP.               
           05  WS-NSF-COUNT              PIC S9(09) COMP.               
           05  WS-NSF-COUNT-1YEAR        PIC S9(09) COMP.               
           05  WS-NSF-COUNT-1-2YEAR      PIC S9(09) COMP.               
           05  WS-NO-OF-DNP              PIC S9(09) COMP.               
           05  WS-FOUR                   PIC X(1)  VALUE '4'.           
           05  WS-DNP-DEP-EXEMP          PIC X(18)  VALUE               
                                      'AUTODNPDEPEXEMPIND'.             
           05  WS-RET-CHK-DEP-EXEMP      PIC X(18)  VALUE               
                                      'AUTORETDEPEXEMPIND'.             
           05  WS-PREV-MNTH              PIC S9(4) COMP VALUE 0.        
           05  WS-DISC-HIST              PIC X(24).                     
           05  WS-DISC-HIST-BRKDWN REDEFINES WS-DISC-HIST               
                                         PIC X(1) OCCURS 24.            
           05  WS-EXCEPTIONAL-HIST       PIC X(24).                     
           05  WS-EXCEPTIONAL-HIST-BRKDWN  REDEFINES                    
               WS-EXCEPTIONAL-HIST       PIC X(1) OCCURS 24.            
           05  WS-BILL-TS.                                              
               10  WS-BILL-DATE          PIC X(10) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  WS-BILL-TIME          PIC X(08) VALUE SPACES.        
               10  FILLER                PIC X(07) VALUE SPACES.        
COB305     05 WS-AUTO-DEP        PIC S9(04)V9(5) COMP-3 VALUE 0.        
COB305     05 WS-CUSTOMER-NO        PIC S9(10) USAGE COMP-3 VALUE 0.       
           05  WS-APPL-PROG              PIC X(09)  VALUE SPACE.        
           05  WS-CR-HIST-TRAN-DT.                                      
               10  WS-CR-HIST-TRAN-CCYY  PIC X(04) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '-'.           
               10  WS-CR-HIST-TRAN-MM    PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '-'.           
               10  WS-CR-HIST-TRAN-DD    PIC X(02) VALUE SPACES.        
           05  WS-NULL-IND1              PIC S9(4) COMP VALUE 0.        
           05  WS-NULL-IND2              PIC S9(4) COMP VALUE 0.        
           05  WS-NULL-IND3              PIC S9(4) COMP VALUE 0.        
           05  WS-NULL-IND4              PIC S9(4) COMP VALUE 0.        
           05  WS-NULL-IND5              PIC S9(4) COMP VALUE 0.        
           05  WS-NULL-IND6              PIC S9(4) COMP VALUE 0.        
           05  WS-MAX-DEP-CERT-NO        PIC S9(9) COMP VALUE 0.        
           05  WS-DEP-NOTIFY-LETTER      PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-LETTER-NOTIFY-CD       PIC X(01) VALUE SPACES.        
           05  WS-LETTER-MAILED-DT       PIC X(10) VALUE SPACES.        
           05  WS-LETTR-NOTIFY-UPDT      PIC X(01) VALUE 'N'.           
               88  LETTR-NOTIFY-UPDT     VALUE 'Y'.                     
           05  WS-AMT-DEP-ON-HAND         PIC S9(09)V99 USAGE COMP-3    
                                                 VALUE 0.               
           05  WS-AMT-SECURED             PIC S9(09)V99 USAGE COMP-3    
                                                 VALUE 0.               
           05  WS-REM-MAX-DEPOSIT-AMT     PIC S9(09)V99 USAGE COMP-3    
                                                 VALUE 0.               
           05  WS-REM-MIN-DEPOSIT-AMT     PIC S9(09)V99 USAGE COMP-3    
                                                 VALUE 0.               
           05  WS-AUTO-DEP-AMT            PIC S9(09)V99 USAGE COMP-3    
                                                 VALUE 0.               
           05  WS-TOTAL-NO-DEP            PIC S9(09) USAGE COMP         
                                                 VALUE 0.               
           05  WS-BILL-DT-DEP            PIC S9(09) USAGE COMP          
                                                 VALUE 0.               
           05  WS-TOTAL-DEP               PIC S9(09) USAGE COMP         
                                                 VALUE 0.               
           05  WS-AUTO-DEP-DELINQ-ERR     PIC X(01) VALUE SPACES.       
           05  WS-CAP-AMT                 PIC S9(09)V99 USAGE COMP-3    
                                                 VALUE 0.               
           05  WS-REMMAX-PERCENT          PIC S9(03)V99 USAGE COMP-3    
                                                 VALUE 0.               
           05  WS-MAX-PERCENT             PIC S9(03)V99 USAGE COMP-3    
                                                 VALUE 0.               
           05  WS-MAXCALC-AMT             PIC S9(09)V99 USAGE COMP-3    
                                                 VALUE 0.               
           05  WS-AUTO-DEP-AMT-NUM        PIC S9(9)V99 VALUE ZEROES.    
           05  WS-AUTO-DEP-AMT-X   REDEFINES WS-AUTO-DEP-AMT-NUM        
                                          PIC X(11).                    
           05  WS-NO-SCHED-PYMTS-NUM      PIC S9(03) VALUE ZEROES.      
           05  WS-NO-SCHED-PYMTS-X REDEFINES WS-NO-SCHED-PYMTS-NUM      
                                          PIC X(03).                    
           05  WS-COMMENTS-LEN-NUM        PIC S9(04) VALUE ZEROES.      
           05  WS-COMMENTS-LEN-X   REDEFINES WS-COMMENTS-LEN-NUM        
                                          PIC X(04).                    
           05  WS-DEP-TYPE-TEXT           PIC X(15) VALUE SPACES.       
           05  WS-DEP-TYPE-LEN            PIC S9(02) COMP VALUE ZEROES. 
           05  WS-PANL-COMMNTS-LEN-NUM  PIC S9(04) VALUE ZEROES.        
           05  WS-PANL-COMMNTS-LEN-X REDEFINES WS-PANL-COMMNTS-LEN-NUM  
                                          PIC X(04).                    
           05  WS-AMT-DEP-MIN             PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-FDNP-SEC-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-FDNP-SEC-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-FDNP-UNS-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-FDNP-SEC-MAXCAL-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-FDNP-UNS-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SDNP-SEC-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SDNP-SEC-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SDNP-UNS-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SDNP-UNS-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-TDNP-SEC-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-TDNP-UNS-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-TDNP-SEC-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-TDNP-UNS-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SRET-SEC-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SRET-SEC-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SRET-SEC-MAXCAL-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SRET-UNS-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SRET-UNS-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-TRET-SEC-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-TRET-SEC-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-TRET-UNS-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-TRET-UNS-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-MRET-SEC-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-MRET-SEC-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-MRET-UNS-REMMAX-R   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-MRET-UNS-CAP-R      PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-FDNP-SEC-REMMAX-C   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-FDNP-UNS-REMMAX-C   PIC S9(4)V9(5) COMP-3 VALUE 0.
P00677     05  WS-AMT-FDNP-SEC-CAP-C      PIC S9(6)V9(5) COMP-3 VALUE 0.
P00677     05  WS-AMT-FDNP-UNS-CAP-C      PIC S9(6)V9(5) COMP-3 VALUE 0.
P00677     05  WS-AMT-SDNP-SEC-CAP-C      PIC S9(6)V9(5) COMP-3 VALUE 0.
P00677     05  WS-AMT-SDNP-UNS-CAP-C      PIC S9(6)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SDNP-SEC-REMMAX-C   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SDNP-UNS-REMMAX-C   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SRET-SEC-REMMAX-C   PIC S9(4)V9(5) COMP-3 VALUE 0.
P00677     05  WS-AMT-SRET-SEC-CAP-C      PIC S9(6)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SRET-SEC-MAXCAL-C   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SRET-UNS-REMMAX-C   PIC S9(4)V9(5) COMP-3 VALUE 0.
P00677     05  WS-AMT-SRET-UNS-CAP-C      PIC S9(6)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-SRET-UNS-MAXCAL-C   PIC S9(4)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-TRET-SEC-REMMAX-C   PIC S9(4)V9(5) COMP-3 VALUE 0.
P00677     05  WS-AMT-TRET-SEC-CAP-C      PIC S9(6)V9(5) COMP-3 VALUE 0.
           05  WS-AMT-TRET-UNS-REMMAX-C   PIC S9(4)V9(5) COMP-3 VALUE 0.
P00677     05  WS-AMT-TRET-UNS-CAP-C      PIC S9(6)V9(5) COMP-3 VALUE 0.
P00773     05  WS-ACCOUNT-REV-RES-MAX     PIC S9(6)V9(5) COMP-3 VALUE 0.
P00773     05  WS-ACCOUNT-REV-RES-MIN     PIC S9(6)V9(5) COMP-3 VALUE 0.
P00773     05  WS-ACCOUNT-REV-RES-CAP     PIC S9(6)V9(5) COMP-3 VALUE 0.
           05  WS-SECURED-ACCOUNT         PIC X(01) VALUE SPACES.       
           05  WS-SECURED-RATE-FLAG       PIC X(01) VALUE SPACES.       
           05  WS-MONTHLY-DNP             PIC X(01) VALUE SPACES.       
           05  WS-VARIABLE-ID             PIC X(20).                    
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
           05  WS-ACCOUNT-NO-PARM         PIC X(13).                    
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO-PARM           
                                          PIC S9(13).                   
           05  WS-CALLING-PGM             PIC X(09) VALUE SPACES.       
           05  WS-AUTO-DEP-TYPE           PIC X(01) VALUE SPACES.       
               88  AUTO-DNP-DEP                     VALUE 'B'.          
               88  AUTO-RET-DEP                     VALUE 'C'.          
P00773         88  ACCOUNT-REV-DEP                  VALUE 'Y'.          
           05  RS-MIN-DEPOSIT-AMT         PIC S9(09)V99  USAGE COMP-3   
                                                    VALUE 0.            
           05  RS-RETURN-CODE             PIC S9(9)      COMP VALUE 0.  
                                                                        
           05  P-RETURN-PARM              PIC S9(09) COMP VALUE +0.     
           05  WS-CURRENT-TIMESTAMP       PIC X(26).                    
           05  WS-AUTO-DEPOSIT-TRUNC      PIC S9(09)V COMP-3 VALUE 0.   
           05  WS-REMNDR                  PIC S9(01)V COMP-3 VALUE 0.   
           05  WS-TOTL                    PIC S9(01)V COMP-3 VALUE 0.   
      *                                                                         
      *01 LOC-RESLTSET         USAGE SQL TYPE IS                        
      *                  RESULT-SET-LOCATOR VARYING.                    
                                                                        
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
      *                                                                         
       01  WS-CSR02072-INPUT-FIELDS.                                    
           05  WS-ACTION-CODE            PIC X(01).                     
           05  WS-ACCT-NO                PIC X(13).                     
           05  WS-AMT-ORIG-ENTERED       PIC X(11).                     
           05  WS-DEPOSIT-STATUS-CD      PIC X(01).                     
           05  WS-SERVICE-TYPE-CD        PIC X(01).                     
           05  WS-DEPOSIT-CERT-NO        PIC X(09).                     
           05  WS-DEP-ACTION-CODE        PIC X(01).                     
           05  WS-USER-ID-UPDT-BY        PIC X(07).                     
           05  WS-COMMENTS               PIC X(210).                    
           05  WS-COMMENTS-LEN           PIC X(04).                     
           05  WS-PANEL-COMMENTS         PIC X(72).                     
           05  WS-PANEL-COMM-LEN         PIC X(04).                     
           05  WS-BILL-OPTION-CD         PIC X(01).                     
           05  WS-ORIG-BILL-OPTN         PIC X(01).                     
           05  WS-NO-SCHED-PYMTS         PIC X(03).                     
           05  WS-AMT-MO-PYMT            PIC X(11).                     
           05  WS-CODE-DEP-TYPE          PIC X(01).                     
           05  WS-CUT-DATE               PIC X(10).                     
           05  WS-PROJECT-CR-DT          PIC X(10).                     
           05  WS-DUE-DATE               PIC X(10).                     
           05  WS-PROGRAM-NAME           PIC X(09).                     
           05  WS-LAST-UPDATE-TS         PIC X(26).                     
           05  WS-CODE-REFUND-ELIG       PIC X(01).                     
           05  WS-ERROR-SWITCH           PIC X(01).                     
           05  WS-AUTO-DEP-LETTER-IND    PIC X(01).                     
           05  WS-AUTO-DEP-LTR-DT        PIC X(10).                     
COB305     05 WS-AUTO-DEP-NOT-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305     05 WS-AUTO-DEP-RECALC-AMT        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.          
      *                                                                         
       01  WS-CSR02072-OUTPUT-FIELDS.                                   
           05  WS-CSR02072-ERROR-CODE     PIC X(50) VALUE SPACES.       
           05  WS-CSR02072-RETURN-CODE    PIC S9(09) USAGE COMP         
                                                    VALUE ZEROES.       
           05  WS-CSR02072-AR-LOCKOUT-IND PIC X(01) VALUE SPACES.       
           05  WS-CSR02072-ACCT-XFER-TO   PIC X(13) VALUE SPACES.       
           05  WS-CSR02072-SUCCESS-FL     PIC X(01) VALUE SPACES.       
           05  WS-CSR02072-ABEND-PROGRAM     PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-ACTIVE-PARAGRAPH  PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-ABEND-FUNCTION    PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-TABLE-1           PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-TABLE-ELEMENT-1   PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-HOSTVAR-ELEMENT-1 PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-TABLE-ELEMENT-2   PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-HOSTVAR-ELEMENT-2 PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-TABLE-ELEMENT-3   PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-HOSTVAR-ELEMENT-3 PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-TABLE-ELEMENT-4   PIC X(20) VALUE SPACES.    
           05  WS-CSR02072-HOSTVAR-ELEMENT-4 PIC X(20) VALUE SPACES.    
      *                                                                         
      ***************************************************************   ****    
      *    DB2 COMMUNICATION REQUIREMENT *                                      
      ***************************************************************   ****    
      *01  LOC1                  USAGE IS SQL TYPE IS                   
      *                          RESULT-SET-LOCATOR VARYING.            
       01  ERROR-MESSAGE.                                               
           02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
           02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
                                 INDEXED BY ERROR-INDEX.                
       77   ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.            
       77  TRACE-MESSAGE-AREA    PIC X(256).                            
       77  OPENFN                PIC X(12).                             
       77  SSID                  PIC X(4).                              
       77  PLANNAME              PIC X(8).                              
       77  RETCODE               PIC S9(5).                             
       77  REASCODE              PIC S9(5).                             
       77  CLOSFN                PIC X(12).                             
       77  TERMOP                PIC X(4).                              
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-AUTO-DEP-AMT          PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-DEP-SUCCESS           PIC X(01)  VALUE SPACES.         
           05  S-DEP-CERT-NO           PIC S9(9)  COMP VALUE 0.         
           05  S-MAX-DEP-ZERO-WQ       PIC X(01)  VALUE SPACES.         
           05  S-AMT-SECURED           PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-ABEND-PROGRAM         PIC X(08)  VALUE SPACES.         
           05  S-ACTIVE-PARAGRAPH      PIC X(04)  VALUE SPACES.         
           05  S-ABEND-FUNCTION        PIC X(08)  VALUE SPACES.         
           05  S-TABLE-1               PIC X(20)  VALUE SPACES.         
           05  S-TABLE-ELEMENT-1       PIC X(20)  VALUE SPACES.         
           05  S-HOSTVAR-ELEMENT-1     PIC X(20)  VALUE SPACES.         
           05  S-TABLE-ELEMENT-2       PIC X(20)  VALUE SPACES.         
           05  S-HOSTVAR-ELEMENT-2     PIC X(20)  VALUE SPACES.         
           05  S-TABLE-ELEMENT-3       PIC X(20)  VALUE SPACES.         
           05  S-HOSTVAR-ELEMENT-3     PIC X(20)  VALUE SPACES.         
           05  S-TABLE-ELEMENT-4       PIC X(20)  VALUE SPACES.         
           05  S-HOSTVAR-ELEMENT-4     PIC X(20)  VALUE SPACES.         
      * DELINQUENCY CURSOR                                                      
           EXEC SQL                                                     
              DECLARE DELINQUENCY_CSR CURSOR FOR                        
              SELECT                                                    
                 DELINQ_VALUE,                                          
                 DELINQ_CD,                                             
                 COMPANY_NO                                             
              FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                        
              WHERE DELINQ_CD    IN ('AM-DEP-MIN          ' ,           
                                     'AM-FDNP-SEC-REMMAX-R' ,           
                                     'AM-FDNP-SEC-CAP-R  ' ,            
                                     'AM-FDNP-UNS-CAP-R  ' ,            
                                     'AM-FDNP-SEC-MAXCAL-R' ,           
                                     'AM-FDNP-UNS-REMMAX-R',            
                                     'AM-SDNP-SEC-REMMAX-R' ,           
                                     'AM-SDNP-SEC-CAP-R  ' ,            
                                     'AM-SDNP-UNS-CAP-R  ' ,            
                                     'AM-SDNP-UNS-REMMAX-R',            
                                     'AM-TDNP-SEC-CAP-R  ' ,            
                                     'AM-TDNP-UNS-CAP-R  ' ,            
                                     'AM-TDNP-SEC-REMMAX-R',            
                                     'AM-TDNP-UNS-REMMAX-R',            
                                     'AM-SRET-SEC-REMMAX-R',            
                                     'AM-SRET-SEC-CAP-R  ' ,            
                                     'AM-SRET-SEC-MAXCAL-R',            
                                     'AM-SRET-UNS-REMMAX-R',            
                                     'AM-SRET-UNS-CAP-R  ' ,            
                                     'AM-TRET-SEC-REMMAX-R',            
                                     'AM-TRET-SEC-CAP-R  ' ,            
                                     'AM-TRET-UNS-REMMAX-R',            
                                     'AM-TRET-UNS-CAP-R  ' ,            
                                     'AM-MRET-SEC-REMMAX-R',            
                                     'AM-MRET-SEC-CAP-R  ' ,            
                                     'AM-MRET-UNS-REMMAX-R',            
                                     'AM-MRET-UNS-CAP-R  ' ,            
                                     'AM-FDNP-SEC-REMMAX-C' ,           
                                     'AM-FDNP-SEC-CAP-C',               
                                     'AM-FDNP-UNS-REMMAX-C' ,           
                                     'AM-FDNP-UNS-CAP-C',               
                                     'AM-SDNP-UNS-CAP-C',               
                                     'AM-SDNP-SEC-CAP-C',               
                                     'AM-SDNP-SEC-REMMAX-C' ,           
                                     'AM-SDNP-UNS-REMMAX-C' ,           
                                     'AM-SRET-SEC-REMMAX-C',            
                                     'AM-SRET-SEC-CAP-C  ' ,            
                                     'AM-SRET-SEC-MAXCAL-C',            
                                     'AM-SRET-UNS-REMMAX-C',            
                                     'AM-SRET-UNS-CAP-C  ' ,            
                                     'AM-SRET-UNS-MAXCAL-C',            
                                     'AM-TRET-SEC-REMMAX-C',            
                                     'AM-TRET-SEC-CAP-C  ' ,            
                                     'AM-TRET-UNS-REMMAX-C',            
                                     'AM-TRET-UNS-CAP-C  ',             
P00773                               'ACCOUNT-REV-RES-CAP',             
P00773                               'ACCOUNT-REV-RES-MIN',             
P00773                               'ACCOUNT-REV-RES-MAX')             
              AND COMPANY_NO = :C8-COMPANY-NO                           
              ORDER BY COMPANY_NO,                                      
                       DELINQ_CD                                        
              FOR READ ONLY                                     
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DELINQUENCY_CSR CURSOR FOR                                
MFA-TR*       SELECT                                                            
MFA-TR*          DELINQ_VALUE,                                                  
MFA-TR*          DELINQ_CD,                                                     
MFA-TR*          COMPANY_NO                                                     
MFA-TR*       FROM CSS_DELINQUENCY                                              
MFA-TR*       WHERE DELINQ_CD    IN ('AM-DEP-MIN          ' ,                   
MFA-TR*                              'AM-FDNP-SEC-REMMAX-R' ,                   
MFA-TR*                              'AM-FDNP-SEC-CAP-R  ' ,                    
MFA-TR*                              'AM-FDNP-UNS-CAP-R  ' ,                    
MFA-TR*                              'AM-FDNP-SEC-MAXCAL-R' ,                   
MFA-TR*                              'AM-FDNP-UNS-REMMAX-R',                    
MFA-TR*                              'AM-SDNP-SEC-REMMAX-R' ,                   
MFA-TR*                              'AM-SDNP-SEC-CAP-R  ' ,                    
MFA-TR*                              'AM-SDNP-UNS-CAP-R  ' ,                    
MFA-TR*                              'AM-SDNP-UNS-REMMAX-R',                    
MFA-TR*                              'AM-TDNP-SEC-CAP-R  ' ,                    
MFA-TR*                              'AM-TDNP-UNS-CAP-R  ' ,                    
MFA-TR*                              'AM-TDNP-SEC-REMMAX-R',                    
MFA-TR*                              'AM-TDNP-UNS-REMMAX-R',                    
MFA-TR*                              'AM-SRET-SEC-REMMAX-R',                    
MFA-TR*                              'AM-SRET-SEC-CAP-R  ' ,                    
MFA-TR*                              'AM-SRET-SEC-MAXCAL-R',                    
MFA-TR*                              'AM-SRET-UNS-REMMAX-R',                    
MFA-TR*                              'AM-SRET-UNS-CAP-R  ' ,                    
MFA-TR*                              'AM-TRET-SEC-REMMAX-R',                    
MFA-TR*                              'AM-TRET-SEC-CAP-R  ' ,                    
MFA-TR*                              'AM-TRET-UNS-REMMAX-R',                    
MFA-TR*                              'AM-TRET-UNS-CAP-R  ' ,                    
MFA-TR*                              'AM-MRET-SEC-REMMAX-R',                    
MFA-TR*                              'AM-MRET-SEC-CAP-R  ' ,                    
MFA-TR*                              'AM-MRET-UNS-REMMAX-R',                    
MFA-TR*                              'AM-MRET-UNS-CAP-R  ' ,                    
MFA-TR*                              'AM-FDNP-SEC-REMMAX-C' ,                   
MFA-TR*                              'AM-FDNP-SEC-CAP-C',                       
MFA-TR*                              'AM-FDNP-UNS-REMMAX-C' ,                   
MFA-TR*                              'AM-FDNP-UNS-CAP-C',                       
MFA-TR*                              'AM-SDNP-UNS-CAP-C',                       
MFA-TR*                              'AM-SDNP-SEC-CAP-C',                       
MFA-TR*                              'AM-SDNP-SEC-REMMAX-C' ,                   
MFA-TR*                              'AM-SDNP-UNS-REMMAX-C' ,                   
MFA-TR*                              'AM-SRET-SEC-REMMAX-C',                    
MFA-TR*                              'AM-SRET-SEC-CAP-C  ' ,                    
MFA-TR*                              'AM-SRET-SEC-MAXCAL-C',                    
MFA-TR*                              'AM-SRET-UNS-REMMAX-C',                    
MFA-TR*                              'AM-SRET-UNS-CAP-C  ' ,                    
MFA-TR*                              'AM-SRET-UNS-MAXCAL-C',                    
MFA-TR*                              'AM-TRET-SEC-REMMAX-C',                    
MFA-TR*                              'AM-TRET-SEC-CAP-C  ' ,                    
MFA-TR*                              'AM-TRET-UNS-REMMAX-C',                    
MFA-TR*                              'AM-TRET-UNS-CAP-C  ',                     
MFA-TR*                              'ACCOUNT-REV-RES-CAP',                     
MFA-TR*                              'ACCOUNT-REV-RES-MIN',                     
MFA-TR*                              'ACCOUNT-REV-RES-MAX')                     
MFA-TR*       AND COMPANY_NO = :C8-COMPANY-NO                                   
MFA-TR*       ORDER BY COMPANY_NO,                                              
MFA-TR*                DELINQ_CD                                                
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CWS00308                                                 
           END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
MSQ001        EXEC SQL
MSQ001          DECLARE CHRG_AUTO_DEP CURSOR
MSQ001          FOR CALL CSR02072                                       
           ( :WS-ACTION-CODE
                  , :WS-ACCT-NO
                  , :WS-AMT-ORIG-ENTERED
                  , :WS-DEPOSIT-STATUS-CD
                  , :WS-SERVICE-TYPE-CD
                  , :WS-DEPOSIT-CERT-NO
                  , :WS-DEP-ACTION-CODE
                  , :WS-USER-ID-UPDT-BY
                  , :WS-COMMENTS
                  , :WS-COMMENTS-LEN
                  , :WS-PANEL-COMMENTS
                  , :WS-PANEL-COMM-LEN
                  , :WS-BILL-OPTION-CD
                  , :WS-ORIG-BILL-OPTN
                  , :WS-NO-SCHED-PYMTS
                  , :WS-AMT-MO-PYMT
                  , :WS-CODE-DEP-TYPE
                  , :WS-CUT-DATE
                  , :WS-PROJECT-CR-DT
                  , :WS-DUE-DATE
                  , :WS-PROGRAM-NAME
                  , :WS-LAST-UPDATE-TS
                  , :WS-CODE-REFUND-ELIG
                  , :WS-ERROR-SWITCH
                  , :WS-AUTO-DEP-LTR-DT
                  , :WS-AUTO-DEP-LETTER-IND
                  , :WS-AUTO-DEP-NOT-AMT
                  , :WS-AUTO-DEP-RECALC-AMT
                  )
MSQ001        END-EXEC.
       
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01  I-ACCOUNT-NO                 PIC X(13).                      
       01  I-CALLING-PGM                PIC X(09).                      
       01  I-AUTO-DEP-TYPE              PIC X(01).                      
COB305 01 I-DL-AUTO-DEP-AMT        PIC S9(09)V99 COMP-3 VALUE 0.           
       01  I-USER-ID                    PIC X(07).                      
       01  I-ERROR-SW                   PIC X(01).                      
ACT239 01  I-BATCH-DATE                 PIC X(10).                      
      *                                                                         
HPCCDM*EJECT                                                                    
       PROCEDURE DIVISION USING  I-ACCOUNT-NO,                          
                                 I-CALLING-PGM,                         
                                 I-AUTO-DEP-TYPE,                       
                                 I-DL-AUTO-DEP-AMT,                     
                                 I-USER-ID,                             
                                 I-ERROR-SW,                            
ACT239                           I-BATCH-DATE.                          
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                      THRU 0100-EXIT. 
           PERFORM 1000-PROCESS-INPUT                   THRU 1000-EXIT. 
           PERFORM 2000-PROCESS-OUTPUT                  THRU 2000-EXIT. 
           PERFORM 9999-END-PROGRAM                     THRU 9999-EXIT. 
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           EXEC SQL                                                     
A37061         DECLARE C1 CURSOR                             
A37061                           WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  :S-RETURN-CODE    AS RETURN_CODE                      
                 ,:S-AUTO-DEP-AMT   AS AUTO_DEP_AMT                     
                 ,:S-DEP-SUCCESS    AS DEP_SUCC_FL                      
                 ,:S-DEP-CERT-NO    AS DEP_CERT_NO                      
                 ,:S-MAX-DEP-ZERO-WQ   AS MAX_DEP_ZERO_WQ               
                 ,:S-AMT-SECURED       AS AMT_SECURED                   
                 ,:S-ABEND-PROGRAM     AS ABEND_PROGRAM                 
                 ,:S-ACTIVE-PARAGRAPH  AS ACTIVE_PARAGRAPH              
                 ,:S-ABEND-FUNCTION    AS ABEND_FUNCTION                
                 ,:S-TABLE-1           AS TABLE_1                       
                 ,:S-TABLE-ELEMENT-1   AS TABLE_ELEMENT_1               
                 ,:S-HOSTVAR-ELEMENT-1 AS HOSTVAR_ELEMENT_1             
                 ,:S-TABLE-ELEMENT-2   AS TABLE_ELEMENT_2               
                 ,:S-HOSTVAR-ELEMENT-2 AS HOSTVAR_ELEMENT_2             
                 ,:S-TABLE-ELEMENT-3   AS TABLE_ELEMENT_3               
                 ,:S-HOSTVAR-ELEMENT-3 AS HOSTVAR_ELEMENT_3             
                 ,:S-TABLE-ELEMENT-4   AS TABLE_ELEMENT_4               
                 ,:S-HOSTVAR-ELEMENT-4 AS HOSTVAR_ELEMENT_4             
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE    AS RETURN_CODE                              
MFA-TR*          ,:S-AUTO-DEP-AMT   AS AUTO_DEP_AMT                             
MFA-TR*          ,:S-DEP-SUCCESS    AS DEP_SUCC_FL                              
MFA-TR*          ,:S-DEP-CERT-NO    AS DEP_CERT_NO                              
MFA-TR*          ,:S-MAX-DEP-ZERO-WQ   AS MAX_DEP_ZERO_WQ                       
MFA-TR*          ,:S-AMT-SECURED       AS AMT_SECURED                           
MFA-TR*          ,:S-ABEND-PROGRAM     AS ABEND_PROGRAM                         
MFA-TR*          ,:S-ACTIVE-PARAGRAPH  AS ACTIVE_PARAGRAPH                      
MFA-TR*          ,:S-ABEND-FUNCTION    AS ABEND_FUNCTION                        
MFA-TR*          ,:S-TABLE-1           AS TABLE_1                               
MFA-TR*          ,:S-TABLE-ELEMENT-1   AS TABLE_ELEMENT_1                       
MFA-TR*          ,:S-HOSTVAR-ELEMENT-1 AS HOSTVAR_ELEMENT_1                     
MFA-TR*          ,:S-TABLE-ELEMENT-2   AS TABLE_ELEMENT_2                       
MFA-TR*          ,:S-HOSTVAR-ELEMENT-2 AS HOSTVAR_ELEMENT_2                     
MFA-TR*          ,:S-TABLE-ELEMENT-3   AS TABLE_ELEMENT_3                       
MFA-TR*          ,:S-HOSTVAR-ELEMENT-3 AS HOSTVAR_ELEMENT_3                     
MFA-TR*          ,:S-TABLE-ELEMENT-4   AS TABLE_ELEMENT_4                       
MFA-TR*          ,:S-HOSTVAR-ELEMENT-4 AS HOSTVAR_ELEMENT_4                     
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF  I-ACCOUNT-NO NOT NUMERIC                                 
               MOVE 200                   TO WS-ACTIVE-RETURN-CODE      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF                                                       
           MOVE I-ACCOUNT-NO              TO WS-ACCOUNT-NO-PARM.        
           MOVE I-CALLING-PGM             TO WS-CALLING-PGM.            
           MOVE I-AUTO-DEP-TYPE           TO WS-AUTO-DEP-TYPE.          
           MOVE WS-ACCOUNT-NO-NUM         TO AT-ACCOUNT-NO              
                                             WS-ACCOUNT-NO.             
           MOVE '01'                      TO C8-COMPANY-NO              
           MOVE 'DATABASE'                TO C8-DELINQ-CD               
           PERFORM 7000-GET-INIT-DELINQ   THRU 7000-EXIT.               
           MOVE C8-DELINQ-VALUE           TO WS-DATABASE                
           IF  CSR-DATABASE                                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE ZEROES                TO WS-AUTO-DEP-AMT            
               MOVE SPACES                TO                            
                                             S-DEP-SUCCESS              
               MOVE ZEROES                TO S-RETURN-CODE              
               ADD +1                     TO CTR-ROWS                   
               PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                
           END-IF                                                       
           PERFORM 7100-SELECT-ACCOUNT    THRU 7100-EXIT.               
           MOVE AT-COMPANY-NO             TO C8-COMPANY-NO.             
P00773** FOR ACCOUNT REVIEW DEPOSIT THE FOLLOWING LOGIC                         
P00773** CAN BE BYPASSED.                                                       
P00773     IF ACCOUNT-REV-DEP                                           
P00773        GO TO 1000-EXIT                                           
P00773     ELSE                                                         
                 MOVE 'AUTO-DEP'                TO C8-DELINQ-CD         
                 PERFORM 7000-GET-INIT-DELINQ   THRU 7000-EXIT          
                 MOVE C8-DELINQ-VALUE           TO WS-AUTO-DEP          
                 IF  WS-AUTO-DEP = 0                                    
                     MOVE ZEROES                TO S-AUTO-DEP-AMT       
                     MOVE SPACES                TO                      
                                                   S-DEP-SUCCESS        
                     MOVE ZEROES                TO S-RETURN-CODE        
                     ADD +1                     TO CTR-ROWS             
                     PERFORM 9999-END-PROGRAM   THRU 9999-EXIT          
                END-IF                                                  
                MOVE AT-ACCOUNT-NO        TO DO-ACCOUNT-NO              
                                             BI-ACCOUNT-NO              
                                             AR-ACCOUNT-NO              
                                             CZ-ACCOUNT-NO              
                                             GU-ACCOUNT-NO              
                                             SB-ACCOUNT-NO              
                PERFORM 7140-SELECT-DATE-BILLED THRU 7140-EXIT          
                IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    AND BI-LAST-UPDATE-TS > SPACES                      
                    MOVE BI-LAST-UPDATE-TS     TO WS-BILL-TS            
                    MOVE WS-BILL-DATE          TO DO-DATE-TRAN          
                ELSE                                                    
      * IF THE ACCOUNT IS NOT BILLED EVEN ONCE CHECK IF THERE IS ANY            
      * DEPOSIT WITH A DATE-TRAN > DEFAULT DATE '1900-01-01'                    
      * AND DEFAULT TIME OF '00.00.00'                                          
                    MOVE '1900-01-01'          TO DO-DATE-TRAN          
                                                  WS-BILL-DATE          
                    MOVE '00.00.00'            TO WS-BILL-TIME          
                END-IF                                                  
                PERFORM 7150-DEPOSITS-THIS-MONTH THRU 7150-EXIT         
                MOVE 'NO-TOTAL-DEP'            TO C8-DELINQ-CD          
                PERFORM 7000-GET-INIT-DELINQ       THRU 7000-EXIT       
                MOVE C8-DELINQ-VALUE           TO WS-TOTAL-DEP          
                IF  WS-TOTAL-NO-DEP >= WS-TOTAL-DEP                     
                    MOVE ZEROES                TO S-AUTO-DEP-AMT        
                    MOVE SPACES                TO                       
                                               S-DEP-SUCCESS            
                    MOVE ZEROES                TO S-RETURN-CODE         
                    ADD +1                     TO CTR-ROWS              
                    PERFORM 9999-END-PROGRAM THRU 9999-EXIT             
                ELSE                                                    
                    PERFORM 7160-DEPOSITS-ON-BILL-DATE THRU 7160-EXIT   
                    ADD WS-BILL-DT-DEP         TO WS-TOTAL-NO-DEP       
                    IF  WS-TOTAL-NO-DEP >= WS-TOTAL-DEP                 
                        MOVE ZEROES            TO S-AUTO-DEP-AMT        
                        MOVE SPACES            TO                       
                                               S-DEP-SUCCESS            
                        MOVE ZEROES            TO S-RETURN-CODE         
                        ADD +1                 TO CTR-ROWS              
                        PERFORM 9999-END-PROGRAM THRU 9999-EXIT         
                    END-IF                                              
                END-IF                                                  
           END-IF.                                                      
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           5000-UPDATE                                          *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
P00773     IF AUTO-DNP-DEP OR AUTO-RET-DEP                              
              PERFORM 2100-GET-AUTO-DEPOSIT      THRU 2100-EXIT         
              IF  WS-AUTO-DEP-AMT < WS-AMT-DEP-MIN                      
                  MOVE ZEROES     TO WS-AUTO-DEP-AMT                    
              ELSE                                                      
                  PERFORM 2160-ROUND-AUTO-DEP    THRU 2160-EXIT         
              END-IF                                                    
           END-IF.                                                      
P00773     IF ACCOUNT-REV-DEP                                           
P00773        PERFORM 2120-GET-ACCTREV-DEPOSIT   THRU 2120-EXIT         
P00773        IF WS-AUTO-DEP-AMT  < WS-ACCOUNT-REV-RES-MIN              
P00773            MOVE WS-ACCOUNT-REV-RES-MIN   TO WS-AUTO-DEP-AMT      
P00773        ELSE                                                      
P00773            PERFORM 2160-ROUND-AUTO-DEP    THRU 2160-EXIT         
P00773        END-IF                                                    
P00773     END-IF.                                                      
           MOVE WS-AUTO-DEP-AMT               TO S-AUTO-DEP-AMT         
           MOVE ZEROES                        TO S-RETURN-CODE          
           ADD  1                             TO CTR-ROWS.              
      *                                                                         
      ******************************************************************        
      * AUTO DEPOSITS (CALLS CSR02072) ARE CHARGED WHEN CALLED FROM    *        
      * 1. PANEL181 BY CSR02189 WHEN POSTING RETURNED CHECKS(PANEL181D)*        
      * 2. PCSSO067 (CAD/PANEL090) - RECONNECT SERVICE ORDER POSTING   *        
      *    (PCSSO67D)                                                  *        
P00773* 3. PCSCA044 - ACCOUNT REVIEW BATCH PROCESS.                    *        
      ******************************************************************        
      *                                                                         
           IF  I-CALLING-PGM = 'PANEL181D' OR = 'PCSSO67D'              
P00773                    OR = 'PCSCA044'                               
               IF  WS-AUTO-DEP-AMT > ZEROES                             
                   PERFORM 2900-SET-UP-AUTO-DEP         THRU 2900-EXIT  
                   MOVE WS-CSR02072-SUCCESS-FL          TO S-DEP-SUCCESS
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECKS AUTO DEPOSITS RULES AND RETURNS AUTO DEP AMT BASED ON   *        
      * AUTO DEPOSIT RULES                                             *        
      ******************************************************************        
      *                                                                         
       2100-GET-AUTO-DEPOSIT.                                           
ACT239     IF  I-CALLING-PGM = 'PCSCA132' AND                           
ACT239        I-BATCH-DATE > SPACES                                     
ACT239        MOVE I-BATCH-DATE TO WS-TEMP-BATCH-DATE                   
ACT239        MOVE 'Y'          TO WS-CALLING-BATCH-SW                  
ACT239        MOVE 0            TO WS-PREMISE-NO                        
ACT239     END-IF.                                                      
           IF  CSR-DATABASE AND (AT-COMPANY-NO = '01' OR '26')          
               IF  AT-CODE-ACCT-STAT NOT = 'A'                          
               OR  AT-CODE-MAJOR-ACCT = 'Y'                             
               OR (AT-CREDIT-GROUP = 'C' OR 'D' OR 'S' OR 'M')          
                   MOVE ZEROES  TO  WS-AUTO-DEP-AMT                     
                   GO TO 2100-EXIT                                      
               END-IF                                                   
               MOVE AT-ACCOUNT-NO               TO YP-ACCOUNT-NO        
               IF  AUTO-DNP-DEP                                         
      * THIS MODULE IS CALLED TO COMPUTE AUTO DEPOSIT AMT FOR DNP               
                   MOVE WS-DNP-DEP-EXEMP        TO YP-ATTRIBUTE-DESC    
                   PERFORM 7310-GET-AUTO-EXEMPTIONS THRU 7310-EXIT      
                   IF  SQLCODE = SUCCESSFUL-CALL                        
                       MOVE ZEROES  TO  WS-AUTO-DEP-AMT                 
                       GO TO 2100-EXIT                                  
                   END-IF                                               
                   PERFORM 7240-SELECT-DISCONN-HIST                     
                      THRU 7240-EXIT                                    
                   PERFORM 2210-CALC-NO-OF-DNPS                         
                      THRU 2210-EXIT                                    
      * THIS IS TO ADD THE FORECASTED DNP WHEN 2ND NOTICE IS GENERATED          
                   IF  I-CALLING-PGM = 'PCSCA132'                       
                       ADD +1                      TO WS-NO-OF-DNP      
                   END-IF                                               
               ELSE                                                     
                   IF  AUTO-RET-DEP                                     
      * THIS MODULE IS CALLED TO COMPUTE AUTO DEPOSIT AMT FOR RETURN CHK        
                       MOVE WS-RET-CHK-DEP-EXEMP    TO YP-ATTRIBUTE-DESC
                       PERFORM 7310-GET-AUTO-EXEMPTIONS THRU 7310-EXIT  
                       IF  SQLCODE = SUCCESSFUL-CALL                    
                           MOVE ZEROES TO WS-AUTO-DEP-AMT               
                           GO TO 2100-EXIT                              
                       END-IF                                           
      * THIS GETS THE NO OF RETURN CHECKS BETWEEN THE LAST 12 AND 24            
      * MONTHS                                                                  
                       PERFORM 7290-SELECT-NSF-1-2YEAR-HIST             
                          THRU 7290-EXIT                                
      * THIS GETS THE NO OF RETURN CHECKS IN THE LAST 1 YEAR                    
                       PERFORM 7300-SELECT-NSF-1YEAR-HIST               
                          THRU 7300-EXIT                                
                       ADD WS-NSF-COUNT-1-2YEAR WS-NSF-COUNT-1YEAR      
                       GIVING WS-NSF-COUNT                              
      * THIS IS TO ADD THE CURRENT RETURN CHECK THAT IS ENTERED FROM            
      * PANEL181                                                                
      *                ADD +1                      TO WS-NSF-COUNT-1YEAR        
                   END-IF                                               
               END-IF                                                   
      * THIS GETS THE ACCOUNT TYPE 1 - RESIDENTIAL 2 - COMMERCIAL               
      * WILL PROCEED FURTHER                                                    
A37061         IF  AT-ACCOUNT-TYPE-CODE NOT = 'D' AND 'R' AND 'C'       
                   MOVE ZEROES TO WS-AUTO-DEP-AMT                       
                   GO TO 2100-EXIT                                      
               END-IF                                                   
      * THIS CHECKS IF THE RATES ATTACHED TO THE ACCTS ARE SECURED              
      * RATES                                                                   
               PERFORM 7200-CHECK-SECURED-RATES                         
                  THRU 7200-EXIT                                        
               IF  RD-SECURED-RATE-FL = 'Y'                             
                   MOVE ZEROES TO WS-AUTO-DEP-AMT                       
                   GO TO 2100-EXIT                                      
               END-IF                                                   
      * THIS CALLS CPD00308 TO COMPUTE THE MAX DEPOSIT AMT                      
               PERFORM 5650-GET-MAX-DEPOSIT                             
                  THRU 5650-GET-MAX-DEPOSIT-EXIT                        
      * THIS CHECKS FOR ANY EXISTING SECURITIES ON THE ACCOUNT                  
               MOVE 'N' TO WS-SECURED-ACCOUNT                           
               PERFORM 7210-SELECT-DEP-ON-HAND                          
                  THRU 7210-EXIT                                        
               IF  WS-SECURED-ACCOUNT = 'N'                             
                   PERFORM 7220-SELECT-GUARANTOR                        
                      THRU 7220-EXIT                                    
               END-IF                                                   
               IF  WS-SECURED-ACCOUNT = 'N'                             
                   PERFORM 7230-SELECT-SURETY-BOND                      
                      THRU 7230-EXIT                                    
               END-IF                                                   
      * THIS GETS THE TOTAL DEPOSIT AMT THAT IS PAID AND NOT REFUNDED           
               PERFORM 7260-GET-AMT-DEP-ON-HAND THRU 7260-EXIT          
      * GETS THE GUARANTEED AMT                                                 
               MOVE ZEROES                      TO GU-AMOUNT-GUARANTEED 
               PERFORM 7270-SELECT-GUARANTEED-AMT                       
                  THRU 7270-EXIT                                        
      * GETS THE SURETY BOND/IRREVOCABLE LETTER OF CREDIT AMOUNT                
               MOVE ZEROES                      TO SB-AMT-BOND          
               PERFORM 7280-SELECT-SURETY-BOND-AMT                      
                  THRU 7280-EXIT                                        
               COMPUTE WS-AMT-SECURED = WS-AMT-DEP-ON-HAND +            
                                        GU-AMOUNT-GUARANTEED +          
                                        SB-AMT-BOND                     
      * SUBTRACTS DEPOSITS ON HAND FROM MAX-DEPOSIT-AMT AND                     
      * MIN-DEPOSIT-AMT                                                         
               SUBTRACT WS-AMT-SECURED     FROM WS-MAX-DEPOSIT-AMT      
               GIVING WS-REM-MAX-DEPOSIT-AMT                            
      *                                                                         
               SUBTRACT WS-AMT-SECURED     FROM WS-MIN-DEPOSIT-AMT      
               GIVING WS-REM-MIN-DEPOSIT-AMT                            
      *                                                                         
               IF  WS-MAX-DEPOSIT-AMT = ZEROES                          
                   PERFORM 2250-DETRMNE-MAX-ZERO-DEP THRU 2250-EXIT     
                   MOVE WS-AMT-SECURED     TO S-AMT-SECURED             
                   GO TO 2100-EXIT                                      
               END-IF                                                   
      * THIS GETS ALL REQUIRED DELIQUENCY VALUES - CAPS, PERCENTAGE ETC.        
               PERFORM 2110-GET-DELINQUENCY                             
                  THRU 2110-EXIT                                        
               IF  AT-COMPANY-NO = '01'                                 
      * THIS DETERMINES THE AUTO DEPOSIT AMT FOR SCEG ACCTS                     
                   PERFORM 2300-DETERMINE-SCEG-DEP-AMT                  
                      THRU 2300-EXIT                                    
               ELSE                                                     
                  IF  AT-COMPANY-NO = '26'                              
      * THIS DETERMINES THE AUTO DEPOSIT AMT FOR PSNC ACCTS                     
                      PERFORM 2400-DETERMINE-PSNC-DEP-AMT               
                         THRU 2400-EXIT                                 
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2110-GET-DELINQUENCY.                                            
      *                                                                         
           INITIALIZE WS-VARIABLE-ID                                    
           MOVE AT-COMPANY-NO             TO C8-COMPANY-NO              
           PERFORM 7110-OPEN-DELINQUENCY                                
              THRU 7110-EXIT                                            
           PERFORM 7120-FETCH-DELINQUENCY                               
              THRU 7120-EXIT                                            
           PERFORM 2115-LOAD-DELINQ-VALUE THRU 2115-EXIT                
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
           PERFORM 7130-CLOSE-DELINQUENCY                               
              THRU 7130-EXIT.                                           
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2115-LOAD-DELINQ-VALUE.                                          
      *                                                                         
           MOVE C8-DELINQ-CD    TO WS-VARIABLE-ID.                      
           PERFORM 2135-LOAD-DW-VARIABLE  THRU 2135-EXIT                
                                                                        
           PERFORM 7120-FETCH-DELINQUENCY                               
              THRU 7120-EXIT.                                           
                                                                        
       2115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
P00773* ACCOUNT REVIEW RULES HAVE ALREADY BEEN CHECKED IN PCSCA044.    *        
P00773* RETURN ACCOUNT REVIEW DEPOSIT AMOUNT.                          *        
P00773******************************************************************        
P00773 2120-GET-ACCTREV-DEPOSIT.                                        
P00773* THIS CALLS CPD00308 TO COMPUTE THE MAX DEPOSIT AMT                      
P00773     PERFORM 5650-GET-MAX-DEPOSIT  THRU 5650-GET-MAX-DEPOSIT-EXIT.
P00773                                                                  
P00773     PERFORM 2110-GET-DELINQUENCY  THRU 2110-EXIT.                
P00773                                                                  
P00773     MOVE WS-MAX-DEPOSIT-AMT               TO   WS-AUTO-DEP-AMT.  
P00773     IF  WS-MAX-DEPOSIT-AMT = ZEROES                              
P00773         CONTINUE                                                 
P00773     ELSE                                                         
P00773         PERFORM 2312-RES-ACCOUNT-REV-DEP   THRU 2312-EXIT        
P00773     END-IF.                                                      
P00773*                                                                         
P00773 2120-EXIT.                                                       
P00773     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  THIS PARA LOADS THE DELINQUENCY VALUE INTO                   *         
      *  WORKING STORAGE DELIQUENCY FIELDS                            *         
      *****************************************************************         
       2135-LOAD-DW-VARIABLE.                                           
      *                                                                         
P00773     IF AUTO-DNP-DEP OR AUTO-RET-DEP                              
             EVALUATE WS-VARIABLE-ID                                    
                WHEN 'AM-DEP-MIN          '                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-DEP-MIN             
P00677          WHEN 'AM-FDNP-SEC-CAP-C  '                              
P00677               MOVE 999999          TO WS-AMT-FDNP-SEC-CAP-C      
                WHEN 'AM-FDNP-SEC-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-FDNP-SEC-CAP-R      
                WHEN 'AM-FDNP-SEC-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-FDNP-SEC-REMMAX-R   
                WHEN 'AM-FDNP-UNS-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-FDNP-UNS-CAP-R      
                WHEN 'AM-FDNP-SEC-MAXCAL-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-FDNP-SEC-MAXCAL-R   
                WHEN 'AM-FDNP-UNS-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-FDNP-UNS-REMMAX-R   
                WHEN 'AM-SDNP-SEC-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SDNP-SEC-REMMAX-R   
                WHEN 'AM-SDNP-SEC-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SDNP-SEC-CAP-R      
                WHEN 'AM-SDNP-UNS-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SDNP-UNS-CAP-R      
                WHEN 'AM-SDNP-UNS-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SDNP-UNS-REMMAX-R   
                WHEN 'AM-TDNP-SEC-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-TDNP-SEC-CAP-R      
                WHEN 'AM-TDNP-UNS-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-TDNP-UNS-CAP-R      
                WHEN 'AM-TDNP-SEC-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-TDNP-SEC-REMMAX-R   
                WHEN 'AM-TDNP-UNS-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-TDNP-UNS-REMMAX-R   
                WHEN 'AM-SRET-SEC-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SRET-SEC-REMMAX-R   
                WHEN 'AM-SRET-SEC-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SRET-SEC-CAP-R      
                WHEN 'AM-SRET-SEC-MAXCAL-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SRET-SEC-MAXCAL-R   
                WHEN 'AM-SRET-UNS-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SRET-UNS-REMMAX-R   
                WHEN 'AM-SRET-UNS-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SRET-UNS-CAP-R      
                WHEN 'AM-TRET-SEC-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-TRET-SEC-REMMAX-R   
                WHEN 'AM-TRET-SEC-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-TRET-SEC-CAP-R      
                WHEN 'AM-TRET-UNS-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-TRET-UNS-REMMAX-R   
                WHEN 'AM-TRET-UNS-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-TRET-UNS-CAP-R      
                WHEN 'AM-MRET-SEC-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-MRET-SEC-REMMAX-R   
                WHEN 'AM-MRET-SEC-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-MRET-SEC-CAP-R      
                WHEN 'AM-MRET-UNS-REMMAX-R'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-MRET-UNS-REMMAX-R   
                WHEN 'AM-MRET-UNS-CAP-R  '                              
                     MOVE C8-DELINQ-VALUE TO WS-AMT-MRET-UNS-CAP-R      
P00677          WHEN 'AM-FDNP-UNS-CAP-C  '                              
P00677               MOVE 999999          TO WS-AMT-FDNP-UNS-CAP-C      
P00677          WHEN 'AM-SDNP-SEC-CAP-C  '                              
P00677               MOVE 999999          TO WS-AMT-SDNP-SEC-CAP-C      
P00677          WHEN 'AM-SDNP-UNS-CAP-C  '                              
P00677               MOVE 999999          TO WS-AMT-SDNP-UNS-CAP-C      
                WHEN 'AM-FDNP-SEC-REMMAX-C'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-FDNP-SEC-REMMAX-C   
                WHEN 'AM-FDNP-UNS-REMMAX-C'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-FDNP-UNS-REMMAX-C   
                WHEN 'AM-SDNP-SEC-REMMAX-C'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SDNP-SEC-REMMAX-C   
                WHEN 'AM-SDNP-UNS-REMMAX-C'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SDNP-UNS-REMMAX-C   
                WHEN 'AM-SRET-SEC-REMMAX-C'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SRET-SEC-REMMAX-C   
P00677          WHEN 'AM-SRET-SEC-CAP-C  '                              
ACT116             IF CSR-DATABASE AND AT-COMPANY-NO = '01'             
P00677               MOVE 999999          TO WS-AMT-SRET-SEC-CAP-C      
ACT116             ELSE                                                 
ACT116               MOVE C8-DELINQ-VALUE TO WS-AMT-SRET-SEC-CAP-C      
ACT116             END-IF                                               
                WHEN 'AM-SRET-SEC-MAXCAL-C'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SRET-SEC-MAXCAL-C   
                WHEN 'AM-SRET-UNS-REMMAX-C'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SRET-UNS-REMMAX-C   
P00677          WHEN 'AM-SRET-UNS-CAP-C  '                              
ACT116             IF CSR-DATABASE AND AT-COMPANY-NO = '01'             
P00677                MOVE 999999          TO WS-AMT-SRET-UNS-CAP-C     
ACT116             ELSE                                                 
ACT116               MOVE C8-DELINQ-VALUE TO  WS-AMT-SRET-UNS-CAP-C     
ACT116             END-IF                                               
                WHEN 'AM-SRET-UNS-MAXCAL-C'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-SRET-UNS-MAXCAL-C   
                WHEN 'AM-TRET-SEC-REMMAX-C'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-TRET-SEC-REMMAX-C   
P00677          WHEN 'AM-TRET-SEC-CAP-C  '                              
ACT116             IF CSR-DATABASE AND AT-COMPANY-NO = '01'             
P00677               MOVE 999999          TO WS-AMT-TRET-SEC-CAP-C      
ACT116             ELSE                                                 
ACT116               MOVE C8-DELINQ-VALUE TO WS-AMT-TRET-SEC-CAP-C      
ACT116             END-IF                                               
                WHEN 'AM-TRET-UNS-REMMAX-C'                             
                     MOVE C8-DELINQ-VALUE TO WS-AMT-TRET-UNS-REMMAX-C   
P00677          WHEN 'AM-TRET-UNS-CAP-C  '                              
ACT116             IF CSR-DATABASE AND AT-COMPANY-NO = '01'             
P00677               MOVE 999999          TO WS-AMT-TRET-UNS-CAP-C      
ACT116             ELSE                                                 
ACT116               MOVE C8-DELINQ-VALUE TO WS-AMT-TRET-UNS-CAP-C      
ACT116             END-IF                                               
                END-EVALUATE                                            
P00773       ELSE                                                       
P00773          EVALUATE WS-VARIABLE-ID                                 
P00773            WHEN 'ACCOUNT-REV-RES-MAX'                            
P00773                 MOVE C8-DELINQ-VALUE TO WS-ACCOUNT-REV-RES-MAX   
P00773            WHEN 'ACCOUNT-REV-RES-MIN'                            
P00773                 MOVE C8-DELINQ-VALUE TO WS-ACCOUNT-REV-RES-MIN   
P00773            WHEN 'ACCOUNT-REV-RES-CAP'                            
P00773                 MOVE C8-DELINQ-VALUE TO WS-ACCOUNT-REV-RES-CAP   
P00773          END-EVALUATE                                            
P00773     END-IF.                                                      
      *                                                                         
       2135-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2160 ROUND WS-AUTO-DEP-AMT    DOWN TO THE NEAREST $5.          *        
      ******************************************************************        
       2160-ROUND-AUTO-DEP.                                             
      *                                                                         
           MOVE WS-AUTO-DEP-AMT         TO WS-AUTO-DEPOSIT-TRUNC.       
      *                                                                         
           DIVIDE WS-AUTO-DEPOSIT-TRUNC BY 5                            
                GIVING WS-TOTL REMAINDER WS-REMNDR.                     
      *                                                                         
           SUBTRACT WS-REMNDR FROM WS-AUTO-DEPOSIT-TRUNC                
                GIVING WS-AUTO-DEP-AMT.                                 
      *                                                                         
       2160-EXIT.                                                       
           EXIT.                                                        
      * CODE ADDED FOR GETTING NO-OF-DNP LIKE S316                              
      ******************************************************************        
      * 2210-CALC-NO-OF-DNPS                                           *        
      *                                                                *        
      *     CALLS NOTHING                                              *        
      *                                                                *        
      *     CALLED FROM 2100-GET-AUTO-DEPOSIT                          *        
      *                                                                *        
      *     BREAKDOWN THE DISCONNECT HISTORY AND THE DISCONNECT        *        
      *     EXCEPTIONAL HISTORY. EACH IS A SERIES OF 24 CODES          *        
      *     REPRESENTING THE LAST 24 MONTHS. A 4 INDICATES A DNP.      *        
      *     WE ARE ONLY CHECKING THE PREVIOUS YEAR.                    *        
      ******************************************************************        
                                                                        
       2210-CALC-NO-OF-DNPS.                                            
                                                                        
      *-----< START OFF BY READING THE CREDIT PROFILE TABLE AND GETTING>        
      *-----< DISCONNECT EXEMPTION >                                            
                                                                        
           MOVE CZ-DISCONNECT-HIST   TO WS-DISC-HIST.                   
           MOVE CZ-DISC-EXCEPTN-HIST TO WS-EXCEPTIONAL-HIST.            
           MOVE 0                    TO WS-NO-OF-DNP.                   
           MOVE 1                    TO WS-PREV-MNTH                    
                                                                        
           PERFORM UNTIL WS-PREV-MNTH > 12                              
                                                                        
               IF  WS-DISC-HIST-BRKDWN(WS-PREV-MNTH) = WS-FOUR          
                   ADD 1 TO WS-NO-OF-DNP                                
               END-IF                                                   
                                                                        
               IF  WS-EXCEPTIONAL-HIST-BRKDWN(WS-PREV-MNTH) = WS-FOUR   
                   ADD 1 TO WS-NO-OF-DNP                                
               END-IF                                                   
                                                                        
              ADD 1 TO WS-PREV-MNTH                                     
                                                                        
           END-PERFORM.                                                 
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
       2250-DETRMNE-MAX-ZERO-DEP.                                       
      *                                                                         
           IF  AT-COMPANY-NO = '01'                                     
A37061         EVALUATE AT-ACCOUNT-TYPE-CODE                            
A37061            WHEN 'R'                                              
      * RESIDENTIAL ACCOUNTS WITH MAX DEPOSIT AMT ZEROES                        
                   IF  AUTO-DNP-DEP AND WS-NO-OF-DNP >= 1               
                       IF  WS-AMT-SECURED     < WS-MIN-DEPOSIT-AMT      
                           MOVE WS-REM-MIN-DEPOSIT-AMT                  
                                                   TO WS-AUTO-DEP-AMT   
                       ELSE                                             
                           MOVE ZEROES             TO WS-AUTO-DEP-AMT   
                       END-IF                                           
                   ELSE                                                 
                       IF  AUTO-RET-DEP                                 
                           IF  (WS-NSF-COUNT-1YEAR = 1                  
                               AND (WS-NSF-COUNT-1-2YEAR >= 2))         
                           OR (WS-NSF-COUNT-1YEAR > 1)                  
                              IF  WS-AMT-SECURED                        
                                      < WS-MIN-DEPOSIT-AMT              
                                  MOVE WS-REM-MIN-DEPOSIT-AMT           
                                    TO WS-AUTO-DEP-AMT                  
                              ELSE                                      
                                  MOVE ZEROES     TO WS-AUTO-DEP-AMT    
                              END-IF                                    
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
A37061            WHEN 'C'                                              
                      MOVE ZEROES                 TO WS-AUTO-DEP-AMT    
               END-EVALUATE                                             
           END-IF.                                                      
           MOVE 'Y'                            TO S-MAX-DEP-ZERO-WQ.    
C26296     IF  WS-AUTO-DEP-AMT > ZEROES                                 
C26296* AMT-DEP-MIN WILL BE RETRIEVED SEPARATELY                                
C26296         MOVE AT-COMPANY-NO         TO C8-COMPANY-NO              
C26296         MOVE 'AM-DEP-MIN'          TO C8-DELINQ-CD               
C26296         PERFORM 7000-GET-INIT-DELINQ THRU 7000-EXIT              
C26296         MOVE C8-DELINQ-VALUE       TO WS-AMT-DEP-MIN             
C26296     END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2300-DETERMINE-SCEG-DEP-AMT.                                     
      *                                                                         
A37061     EVALUATE  AT-ACCOUNT-TYPE-CODE                               
      * RESIDENTIAL ACCOUNTS                                                    
A37061         WHEN 'R'                                                 
                   IF  AUTO-DNP-DEP                                     
                       EVALUATE TRUE                                    
                           WHEN WS-NO-OF-DNP = 1                        
                               PERFORM 2310-SCEG-RES-FIRST-DNP-DEP      
                                  THRU 2310-EXIT                        
                           WHEN WS-NO-OF-DNP = 2                        
                               PERFORM 2320-SCEG-RES-SECND-DNP-DEP      
                                  THRU 2320-EXIT                        
                           WHEN WS-NO-OF-DNP >= 3                       
                               PERFORM 2330-SCEG-RES-THIRD-DNP-DEP      
                                  THRU 2330-EXIT                        
                       END-EVALUATE                                     
                   ELSE                                                 
                       IF  AUTO-RET-DEP                                 
                           EVALUATE TRUE                                
                               WHEN WS-NSF-COUNT-1YEAR = 1              
                                   EVALUATE TRUE                        
                                       WHEN WS-NSF-COUNT-1-2YEAR = 0    
                                       WHEN WS-NSF-COUNT-1-2YEAR = 1    
                                           MOVE ZEROES                  
                                             TO WS-AUTO-DEP-AMT         
                                       WHEN WS-NSF-COUNT-1-2YEAR = 2    
                                           PERFORM                      
                                             2350-SCEG-RES-THIRD-RTC-DEP
                                             THRU 2350-EXIT             
                                       WHEN WS-NSF-COUNT-1-2YEAR >= 3   
                                           PERFORM                      
                                              2360-SCEG-RES-MULT-RTC-DEP
                                              THRU 2360-EXIT            
                                   END-EVALUATE                         
                               WHEN WS-NSF-COUNT-1YEAR = 2              
                                   EVALUATE TRUE                        
                                       WHEN WS-NSF-COUNT-1-2YEAR = 0    
                                           PERFORM                      
                                             2340-SCEG-RES-SECND-RTC-DEP
                                             THRU 2340-EXIT             
                                       WHEN WS-NSF-COUNT-1-2YEAR = 1    
                                           PERFORM                      
                                             2350-SCEG-RES-THIRD-RTC-DEP
                                             THRU 2350-EXIT             
                                       WHEN WS-NSF-COUNT-1-2YEAR >= 2   
                                           PERFORM                      
                                              2360-SCEG-RES-MULT-RTC-DEP
                                              THRU 2360-EXIT            
                                   END-EVALUATE                         
                               WHEN WS-NSF-COUNT-1YEAR = 3              
                                   EVALUATE TRUE                        
                                       WHEN WS-NSF-COUNT-1-2YEAR = 0    
                                           PERFORM                      
                                             2350-SCEG-RES-THIRD-RTC-DEP
                                             THRU 2350-EXIT             
                                       WHEN WS-NSF-COUNT-1-2YEAR >= 1   
                                           PERFORM                      
                                              2360-SCEG-RES-MULT-RTC-DEP
                                              THRU 2360-EXIT            
                                   END-EVALUATE                         
                               WHEN WS-NSF-COUNT-1YEAR >= 4             
                                   PERFORM 2360-SCEG-RES-MULT-RTC-DEP   
                                      THRU 2360-EXIT                    
                           END-EVALUATE                                 
                       END-IF                                           
                   END-IF                                               
      * COMMERCIAL ACCOUNTS                                                     
A37061         WHEN 'C'                                                 
                   IF  AUTO-DNP-DEP                                     
                       EVALUATE TRUE                                    
                           WHEN WS-NO-OF-DNP = 1                        
                               PERFORM 2370-SCEG-COM-FIRST-DNP-DEP      
                                  THRU 2370-EXIT                        
                           WHEN WS-NO-OF-DNP >= 2                       
                               PERFORM 2380-SCEG-COM-SECND-DNP-DEP      
                                  THRU 2380-EXIT                        
                       END-EVALUATE                                     
                   ELSE                                                 
                       IF  AUTO-RET-DEP                                 
                           EVALUATE TRUE                                
                               WHEN WS-NSF-COUNT = 2                    
                                   PERFORM 2390-SCEG-COM-SECND-RTC-DEP  
                                      THRU 2390-EXIT                    
                               WHEN WS-NSF-COUNT >= 3                   
                                   PERFORM 2395-SCEG-COM-MULT-RTC-DEP   
                                      THRU 2395-EXIT                    
                           END-EVALUATE                                 
                       END-IF                                           
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE ZEROES TO WS-AUTO-DEP-AMT                       
           END-EVALUATE.                                                
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2310-SCEG-RES-FIRST-DNP-DEP.                                     
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-FDNP-SEC-MAXCAL-R    TO WS-MAXCALC-AMT       
               MOVE WS-AMT-FDNP-SEC-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-FDNP-SEC-REMMAX-R    TO WS-REMMAX-PERCENT    
               PERFORM 2500-CALC-AUTO-DEP-MAX   THRU 2500-EXIT          
           ELSE                                                         
               MOVE WS-AMT-FDNP-UNS-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-FDNP-UNS-REMMAX-R    TO WS-MAX-PERCENT       
               PERFORM 2550-CALC-AUTO-DEP-NOMAX THRU 2550-EXIT          
           END-IF.                                                      
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00773 2312-RES-ACCOUNT-REV-DEP.                                        
P00773*                                                                         
P00773     MOVE WS-ACCOUNT-REV-RES-MAX       TO WS-MAX-PERCENT.         
P00773     PERFORM 2525-CALC-ACCOUNT-REV-DEP THRU 2525-EXIT.            
P00773                                                                  
P00773 2312-EXIT.                                                       
P00773     EXIT.                                                        
      *                                                                         
       2320-SCEG-RES-SECND-DNP-DEP.                                     
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-SDNP-SEC-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-SDNP-SEC-REMMAX-R    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-SDNP-UNS-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-SDNP-UNS-REMMAX-R    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2330-SCEG-RES-THIRD-DNP-DEP.                                     
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-TDNP-SEC-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-TDNP-SEC-REMMAX-R    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-TDNP-UNS-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-TDNP-UNS-REMMAX-R    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
      *                                                                         
       2330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2340-SCEG-RES-SECND-RTC-DEP.                                     
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-SRET-SEC-MAXCAL-R    TO WS-MAXCALC-AMT       
               MOVE WS-AMT-SRET-SEC-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-SRET-SEC-REMMAX-R    TO WS-REMMAX-PERCENT    
               PERFORM 2500-CALC-AUTO-DEP-MAX                           
                  THRU 2500-EXIT                                        
           ELSE                                                         
               MOVE WS-AMT-SRET-UNS-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-SRET-UNS-REMMAX-R    TO WS-MAX-PERCENT       
               PERFORM 2550-CALC-AUTO-DEP-NOMAX THRU 2550-EXIT          
           END-IF.                                                      
      *                                                                         
       2340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2350-SCEG-RES-THIRD-RTC-DEP.                                     
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-TRET-SEC-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-TRET-SEC-REMMAX-R    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-TRET-UNS-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-TRET-UNS-REMMAX-R    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2360-SCEG-RES-MULT-RTC-DEP.                                      
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-MRET-SEC-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-MRET-SEC-REMMAX-R    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-MRET-UNS-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-MRET-UNS-REMMAX-R    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
      *                                                                         
       2360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2370-SCEG-COM-FIRST-DNP-DEP.                                     
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-FDNP-SEC-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-FDNP-SEC-REMMAX-C    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-FDNP-UNS-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-FDNP-UNS-REMMAX-C    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
      *                                                                         
       2370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2380-SCEG-COM-SECND-DNP-DEP.                                     
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-SDNP-SEC-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-SDNP-SEC-REMMAX-C    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-SDNP-UNS-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-SDNP-UNS-REMMAX-C    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
      *                                                                         
       2380-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2390-SCEG-COM-SECND-RTC-DEP.                                     
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-SRET-SEC-MAXCAL-C    TO WS-MAXCALC-AMT       
               MOVE WS-AMT-SRET-SEC-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-SRET-SEC-REMMAX-C    TO WS-REMMAX-PERCENT    
           ELSE                                                         
               MOVE WS-AMT-SRET-UNS-MAXCAL-C    TO WS-MAXCALC-AMT       
               MOVE WS-AMT-SRET-UNS-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-SRET-UNS-REMMAX-C    TO WS-REMMAX-PERCENT    
           END-IF                                                       
           PERFORM 2500-CALC-AUTO-DEP-MAX       THRU 2500-EXIT.         
                                                                        
      *                                                                         
       2390-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2395-SCEG-COM-MULT-RTC-DEP.                                      
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-TRET-SEC-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-TRET-SEC-REMMAX-C    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-TRET-UNS-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-TRET-UNS-REMMAX-C    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
      *                                                                         
       2395-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2400-DETERMINE-PSNC-DEP-AMT.                                     
      *                                                                         
A37061     EVALUATE  AT-ACCOUNT-TYPE-CODE                               
      * RESIDENTIAL ACCOUNTS                                                    
A37061         WHEN 'R'                                                 
      * AUTO DNP DEPOSIT                                                        
                   IF  AUTO-DNP-DEP                                     
      * 1ST DNP OR GREATER                                                      
                       IF  WS-NO-OF-DNP >= 1                            
                           PERFORM 2410-PSNC-RES-DNP-DEP                
                               THRU 2410-EXIT                           
                       END-IF                                           
                   ELSE                                                 
      * AUTO RETURN CHECK DEPOSIT                                               
                       IF  AUTO-RET-DEP                                 
                           IF  WS-NSF-COUNT-1YEAR = 1                   
                               EVALUATE TRUE                            
                                   WHEN WS-NSF-COUNT-1-2YEAR = 0        
                                   WHEN WS-NSF-COUNT-1-2YEAR = 1        
                                       MOVE ZEROES                      
                                         TO WS-AUTO-DEP-AMT             
                                   WHEN WS-NSF-COUNT-1-2YEAR = 2        
                                       PERFORM                          
                                         2450-PSNC-RES-RTC-DEP          
                                         THRU 2450-EXIT                 
                                   WHEN WS-NSF-COUNT-1-2YEAR >= 3       
                                       PERFORM                          
                                          2450-PSNC-RES-RTC-DEP         
                                          THRU 2450-EXIT                
                               END-EVALUATE                             
                           ELSE                                         
                               IF  WS-NSF-COUNT-1YEAR >= 2              
                                   PERFORM 2450-PSNC-RES-RTC-DEP        
                                      THRU 2450-EXIT                    
                               END-IF                                   
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
      * COMMERCIAL ACCOUNTS                                                     
A37061         WHEN 'C'                                                 
      * AUTO DNP DEPOSIT                                                        
                   IF  AUTO-DNP-DEP                                     
      * 1ST DNP OR GREATER                                                      
                       IF  WS-NO-OF-DNP >= 1                            
                           PERFORM 2420-PSNC-COM-DNP-DEP                
                               THRU 2420-EXIT                           
                       END-IF                                           
                   ELSE                                                 
      * AUTO RETURN CHECK DEPOSIT                                               
                       IF  AUTO-RET-DEP                                 
                           IF  WS-NSF-COUNT-1YEAR = 1                   
                               EVALUATE TRUE                            
                                   WHEN WS-NSF-COUNT-1-2YEAR = 0        
                                   WHEN WS-NSF-COUNT-1-2YEAR = 1        
                                       MOVE ZEROES                      
                                         TO WS-AUTO-DEP-AMT             
                                   WHEN WS-NSF-COUNT-1-2YEAR >= 2       
                                       PERFORM                          
                                         2460-PSNC-COM-RTC-DEP          
                                         THRU 2460-EXIT                 
                               END-EVALUATE                             
                           ELSE                                         
                               IF  WS-NSF-COUNT-1YEAR >= 2              
                                   PERFORM 2460-PSNC-COM-RTC-DEP        
                               END-IF                                   
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE ZEROES TO WS-AUTO-DEP-AMT                       
           END-EVALUATE.                                                
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2410-PSNC-RES-DNP-DEP.                                           
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-FDNP-SEC-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-FDNP-SEC-REMMAX-R    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-FDNP-UNS-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-FDNP-UNS-REMMAX-R    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
      *                                                                         
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2420-PSNC-COM-DNP-DEP.                                           
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-FDNP-SEC-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-FDNP-SEC-REMMAX-C    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-FDNP-UNS-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-FDNP-UNS-REMMAX-C    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
      *                                                                         
       2420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2450-PSNC-RES-RTC-DEP.                                           
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-SRET-SEC-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-SRET-SEC-REMMAX-R    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-SRET-UNS-CAP-R       TO WS-CAP-AMT           
               MOVE WS-AMT-SRET-UNS-REMMAX-R    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
      *                                                                         
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2460-PSNC-COM-RTC-DEP.                                           
      *                                                                         
           IF  WS-SECURED-ACCOUNT = 'Y'                                 
               MOVE WS-AMT-SRET-SEC-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-SRET-SEC-REMMAX-C    TO WS-MAX-PERCENT       
           ELSE                                                         
               MOVE WS-AMT-SRET-UNS-CAP-C       TO WS-CAP-AMT           
               MOVE WS-AMT-SRET-UNS-REMMAX-C    TO WS-MAX-PERCENT       
           END-IF.                                                      
           PERFORM 2550-CALC-AUTO-DEP-NOMAX     THRU 2550-EXIT.         
      *                                                                         
       2460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2500-CALC-AUTO-DEP-MAX.                                          
      *                                                                         
               IF  WS-REM-MAX-DEPOSIT-AMT < WS-MAXCALC-AMT              
                   MOVE WS-REM-MAX-DEPOSIT-AMT TO WS-AUTO-DEP-AMT       
               ELSE                                                     
                   COMPUTE WS-AUTO-DEP-AMT =                            
                    WS-REM-MAX-DEPOSIT-AMT * WS-REMMAX-PERCENT          
                            / 100                                       
                   IF  WS-AUTO-DEP-AMT > WS-CAP-AMT                     
                       MOVE WS-CAP-AMT TO WS-AUTO-DEP-AMT               
                   END-IF                                               
               END-IF.                                                  
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00773 2525-CALC-ACCOUNT-REV-DEP.                                       
P00773     COMPUTE WS-AUTO-DEP-AMT =                                    
P00773        WS-AUTO-DEP-AMT * WS-MAX-PERCENT                          
P00773                      / 100.                                      
P00773     IF WS-AUTO-DEP-AMT  > WS-ACCOUNT-REV-RES-CAP                 
P00773        MOVE WS-ACCOUNT-REV-RES-CAP TO WS-AUTO-DEP-AMT            
P00773     END-IF.                                                      
P00773*                                                                         
P00773 2525-EXIT.                                                       
P00773     EXIT.                                                        
      *                                                                         
       2550-CALC-AUTO-DEP-NOMAX.                                        
      *                                                                         
               IF  WS-REM-MAX-DEPOSIT-AMT < WS-CAP-AMT                  
                   MOVE WS-REM-MAX-DEPOSIT-AMT TO WS-AUTO-DEP-AMT       
               ELSE                                                     
                   COMPUTE WS-AUTO-DEP-AMT =                            
                    WS-REM-MAX-DEPOSIT-AMT * WS-MAX-PERCENT             
                            / 100                                       
                   IF  WS-AUTO-DEP-AMT > WS-CAP-AMT                     
                       MOVE WS-CAP-AMT     TO WS-AUTO-DEP-AMT           
                   END-IF                                               
               END-IF.                                                  
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2900-SET-UP-AUTO-DEP.                                            
      *                                                                         
           INITIALIZE WS-CSR02072-INPUT-FIELDS.                         
T34083     IF  I-CALLING-PGM = 'PCSSO67D'                               
T34083     AND I-AUTO-DEP-TYPE = 'B'                                    
T34083         IF  I-DL-AUTO-DEP-AMT < WS-AUTO-DEP-AMT                  
T34083             MOVE I-DL-AUTO-DEP-AMT                               
T34083                                  TO  WS-AUTO-DEP-AMT             
T34083         END-IF                                                   
T34083     END-IF                                                       
           MOVE WS-AUTO-DEP-AMT         TO  WS-AUTO-DEP-AMT-NUM         
           MOVE +12                     TO  WS-COMMENTS-LEN-NUM         
           MOVE +1                      TO  WS-NO-SCHED-PYMTS-NUM       
           MOVE ZEROES                  TO  WS-PANL-COMMNTS-LEN-NUM     
           PERFORM 7250-SELECT-MAX-DEP-CERT THRU 7250-EXIT              
           ADD +1                       TO  WS-MAX-DEP-CERT-NO          
           MOVE   'I'                   TO  WS-ACTION-CODE              
           MOVE  AT-ACCOUNT-NO          TO  WS-ACCT-NO                  
           MOVE  WS-AUTO-DEP-AMT-X      TO  WS-AMT-ORIG-ENTERED         
           MOVE  'A'                    TO  WS-DEPOSIT-STATUS-CD        
           MOVE  'U'                    TO  WS-SERVICE-TYPE-CD          
           MOVE  WS-MAX-DEP-CERT-NO     TO  WS-DEPOSIT-CERT-NO          
           MOVE  SPACES                 TO  WS-DEP-ACTION-CODE          
           IF  I-CALLING-PGM = 'PANEL125D'                              
               MOVE  I-USER-ID          TO  WS-USER-ID-UPDT-BY          
           ELSE                                                         
               MOVE  'SYSTEM'           TO  WS-USER-ID-UPDT-BY          
           END-IF                                                       
           IF  I-AUTO-DEP-TYPE = 'B'                                    
               MOVE ' DNP'               TO  WS-DEP-TYPE-TEXT           
               MOVE +4                   TO  WS-DEP-TYPE-LEN            
           ELSE                                                         
              IF  I-AUTO-DEP-TYPE = 'C'                                 
                  MOVE ' RETURNED CHECK' TO  WS-DEP-TYPE-TEXT           
                  MOVE +15               TO  WS-DEP-TYPE-LEN            
              END-IF                                                    
           END-IF                                                       
      *** ADD DEP TYPE TO COMMENTS                                              
P00773     IF I-AUTO-DEP-TYPE = 'B' OR = 'C'                            
              ADD   WS-DEP-TYPE-LEN         TO  WS-COMMENTS-LEN-NUM     
              STRING 'AUTO DEPOSIT'    DELIMITED BY SIZE                
                      WS-DEP-TYPE-TEXT DELIMITED BY SIZE                
              INTO WS-COMMENTS                                          
P00773     ELSE                                                         
P00773        IF I-AUTO-DEP-TYPE = 'Y'                                  
P00773           MOVE ' ACCOUNT REVIEW' TO WS-COMMENTS                  
P00773           MOVE +15               TO WS-COMMENTS-LEN-X            
P00773        END-IF                                                    
P00773     END-IF                                                       
           MOVE  WS-COMMENTS-LEN-X      TO  WS-COMMENTS-LEN             
           MOVE  SPACES                 TO  WS-PANEL-COMMENTS           
           MOVE  ZEROES                 TO  WS-PANEL-COMM-LEN           
           IF  I-CALLING-PGM = 'PANEL181D'                              
               MOVE 'N'                 TO  WS-BILL-OPTION-CD           
           ELSE                                                         
               MOVE 'N'             TO  WS-BILL-OPTION-CD               
                                        WS-ORIG-BILL-OPTN               
           END-IF                                                       
           MOVE WS-NO-SCHED-PYMTS-X     TO  WS-NO-SCHED-PYMTS           
           MOVE WS-AUTO-DEP-AMT-X       TO  WS-AMT-MO-PYMT              
           MOVE I-AUTO-DEP-TYPE         TO  WS-CODE-DEP-TYPE            
           MOVE SPACES                  TO  WS-CUT-DATE                 
                                            WS-PROJECT-CR-DT            
                                            WS-DUE-DATE                 
           MOVE I-CALLING-PGM           TO  WS-PROGRAM-NAME             
           MOVE SPACES                  TO  WS-LAST-UPDATE-TS           
                                            WS-CODE-REFUND-ELIG.        
      * NO LETTER WILL BE SENT FOR RETURN CHECK DEPOSITS.                       
P00773* NO LETTER WILL BE SENT FOR ACCOUNT REVIEW.                              
P00773     IF  I-CALLING-PGM = 'PANEL181D' OR = 'PCSCA044'              
               MOVE SPACES              TO  WS-AUTO-DEP-LETTER-IND      
           ELSE                                                         
               MOVE 'DEP-NOTIFY-LETTER' TO  C8-DELINQ-CD                
               MOVE AT-COMPANY-NO       TO  C8-COMPANY-NO               
               PERFORM 7000-GET-INIT-DELINQ THRU 7000-EXIT              
               MOVE C8-DELINQ-VALUE     TO  WS-DEP-NOTIFY-LETTER        
               EVALUATE WS-DEP-NOTIFY-LETTER                            
      * LETTER WILL BE SENT IRRESPECTIVE OF WHAT WAS SELECTED                   
                   WHEN 1                                               
                       MOVE 'L'         TO  WS-AUTO-DEP-LETTER-IND      
                   WHEN 2                                               
      * NO LETTER WILL BE SENT IRRESPECTIVE OF WHAT WAS SELECTED                
                       MOVE 'C'         TO  WS-AUTO-DEP-LETTER-IND      
                   WHEN 0                                               
      * LETTER WILL BE SENT FOR ALL EXCEPT WHEN THE ACCOUNT IS A PSNC   W       
      * ACCOUNT AND THE AUTO DNP DEPOSIT IS CHARGED FROM PANEL090 OR CAD        
                       IF  I-CALLING-PGM = 'PCSSO67D'                   
                           MOVE 'L' TO  WS-AUTO-DEP-LETTER-IND          
                       END-IF                                           
               END-EVALUATE                                             
           END-IF                                                       
           MOVE 'N'                     TO  WS-ERROR-SWITCH             
           MOVE I-DL-AUTO-DEP-AMT       TO  WS-AUTO-DEP-NOT-AMT         
           MOVE WS-AUTO-DEP-AMT         TO  WS-AUTO-DEP-RECALC-AMT      
           MOVE SPACES                  TO  WS-AUTO-DEP-LTR-DT          
           PERFORM 8200-CALL-CSR02072   THRU 8200-EXIT.                 
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **     7000-GET-INIT-DELINQ.                                    **        
      **                                                              **        
      ******************************************************************        
       7000-GET-INIT-DELINQ.                                            
      *---------------------*                                                   
             MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE COMPANY_NO           = :C8-COMPANY-NO              
                 AND DELINQ_CD            = :C8-DELINQ-CD               
                                                                 
P00773                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE COMPANY_NO           = :C8-COMPANY-NO                      
MFA-TR*          AND DELINQ_CD            = :C8-DELINQ-CD                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7000'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                 ABEND-TABLES           
               MOVE 'CSS_DELINQUENCY'        TO TABLE-1                 
               MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1         
               MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1       
               MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2         
               MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7100-SELECT-ACCOUNT                                         *           
      *                                                             *           
      * FETCH DETAILS FROM THE ACCOUNT TABLE                        *           
      ***************************************************************           
      *                                                                         
       7100-SELECT-ACCOUNT.                                             
      *                                                                         
           MOVE '7100'                          TO ACTIVE-PARAGRAPH.    
      *                                                                         
           EXEC SQL                                                     
             SELECT                                                     
                 AT.CODE_ACCT_STAT,                                     
                 AT.CODE_MAJOR_ACCT,                                    
                 AT.CT_METER_RATED_IND,                                 
                 AT.CREDIT_GROUP,                                       
                 AT.COMPANY_NO,                                         
                 AT.BILL_CYCLE,                                         
                 AT.PREMISE_NO,                                         
A37061           AT.LOCAL_OFFICE,                                       
A37061           AT.ACCOUNT_TYPE_CODE                                   
             INTO                                                       
                 :AT-CODE-ACCT-STAT,                                    
                 :AT-CODE-MAJOR-ACCT,                                   
                 :AT-CT-METER-RATED-IND,                                
                 :AT-CREDIT-GROUP,                                      
                 :AT-COMPANY-NO,                                        
                 :AT-BILL-CYCLE,                                        
                 :WS-PREMISE-NO,                                        
A37061           :AT-LOCAL-OFFICE,                                      
A37061           :AT-ACCOUNT-TYPE-CODE                                  
             FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                          
             WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT                                                             
MFA-TR*          AT.CODE_ACCT_STAT,                                             
MFA-TR*          AT.CODE_MAJOR_ACCT,                                            
MFA-TR*          AT.CT_METER_RATED_IND,                                         
MFA-TR*          AT.CREDIT_GROUP,                                               
MFA-TR*          AT.COMPANY_NO,                                                 
MFA-TR*          AT.BILL_CYCLE,                                                 
MFA-TR*          AT.PREMISE_NO,                                                 
MFA-TR*          AT.LOCAL_OFFICE,                                               
MFA-TR*          AT.ACCOUNT_TYPE_CODE                                           
MFA-TR*      INTO                                                               
MFA-TR*          :AT-CODE-ACCT-STAT,                                            
MFA-TR*          :AT-CODE-MAJOR-ACCT,                                           
MFA-TR*          :AT-CT-METER-RATED-IND,                                        
MFA-TR*          :AT-CREDIT-GROUP,                                              
MFA-TR*          :AT-COMPANY-NO,                                                
MFA-TR*          :AT-BILL-CYCLE,                                                
MFA-TR*          :WS-PREMISE-NO,                                                
MFA-TR*          :AT-LOCAL-OFFICE,                                              
MFA-TR*          :AT-ACCOUNT-TYPE-CODE                                          
MFA-TR*      FROM CSS_ACCOUNT AT                                                
MFA-TR*      WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE SPACES                     TO ABEND-TABLES          
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
               MOVE 'CSR03515'                 TO ABEND-PROGRAM         
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_ACCOUNT'              TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **     7110-OPEN-DELINQUENCY.                                   **        
      **                                                              **        
      ******************************************************************        
       7110-OPEN-DELINQUENCY.                                           
      *---------------------*                                                   
             MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
               OPEN  DELINQUENCY_CSR                                    
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7110'                   TO ACTIVE-PARAGRAPH        
P00773         MOVE 'OPEN'                   TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                 ABEND-TABLES           
               MOVE 'CSS_DELINQUENCY'        TO TABLE-1                 
               MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1         
               MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1       
               MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2         
               MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **     7120-FETCH-DELINQUENCY.                                  **        
      **                                                              **        
      ******************************************************************        
       7120-FETCH-DELINQUENCY.                                          
      *---------------------*                                                   
             MOVE '7120'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
               FETCH DELINQUENCY_CSR                                    
                INTO :C8-DELINQ-VALUE                                   
                    ,:C8-DELINQ-CD                                      
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
           OR  NOT-FOUND                                                
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7120'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                 ABEND-TABLES           
               MOVE 'CSS_DELINQUENCY'        TO TABLE-1                 
               MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1         
               MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1       
               MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2         
               MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **     7130-CLOSE-DELINQUENCY.                                  **        
      **                                                              **        
      ******************************************************************        
       7130-CLOSE-DELINQUENCY.                                          
      *---------------------*                                                   
             MOVE '7130'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
               CLOSE DELINQUENCY_CSR                                    
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7130'                   TO ACTIVE-PARAGRAPH        
P00773         MOVE 'CLOSE'                  TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                 ABEND-TABLES           
               MOVE 'CSS_DELINQUENCY'        TO TABLE-1                 
               MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1         
               MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1       
               MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2         
               MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GETS THE LAST BILLED DATE TO CHECK IF A DEPOSIT WAS CHARGED    *        
      * SINCE THE LAST BILL.                                           *        
      ******************************************************************        
      *                                                                         
       7140-SELECT-DATE-BILLED.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), BI.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO :BI-LAST-UPDATE-TS                                 
              FROM  CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                    
              WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                      
              AND   BI.BILL_NO = (SELECT MAX (A.BILL_NO)                
                               FROM CSS_BILLING_HDR A
                           WITH(READUNCOMMITTED)                   
                               WHERE A.ACCOUNT_NO = BI.ACCOUNT_NO)      
              AND  BI.DATE_BILLED IS NULL                               
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BI.LAST_UPDATE_TS                                          
MFA-TR*         INTO :BI-LAST-UPDATE-TS                                         
MFA-TR*       FROM  CSS_BILLING_HDR BI                                          
MFA-TR*       WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                              
MFA-TR*       AND   BI.BILL_NO = (SELECT MAX (A.BILL_NO)                        
MFA-TR*                        FROM CSS_BILLING_HDR A                           
MFA-TR*                        WHERE A.ACCOUNT_NO = BI.ACCOUNT_NO)              
MFA-TR*       AND  BI.DATE_BILLED IS NULL                                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7140                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME   TO ABEND-PROGRAM                     
               MOVE '7140'         TO ACTIVE-PARAGRAPH                  
               MOVE 'SELECT'       TO ABEND-FUNCTION                    
               MOVE 'CSS_BILLING_HDR '  TO TABLE-1                      
               MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1              
               MOVE BI-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
               PERFORM 9000-SEND-ERROR-RESULT                           
                  THRU 9000-EXIT                                        
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                   THRU 9900-EXIT                                       
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-DEPOSITS-THIS-MONTH.                                      *        
      ******************************************************************        
       7150-DEPOSITS-THIS-MONTH.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
              INTO  :WS-TOTAL-NO-DEP :WS-NULL-IND1                       
              FROM   CSS_DEP_ON_HAND AS DO WITH(READUNCOMMITTED)                
              WHERE  DO.ACCOUNT_NO = :DO-ACCOUNT-NO                     
              AND    DO.DATE_TRAN > IIF(TRY_CONVERT(DATE, :DO-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-TRAN
              ) <> 0) OR (LEN(:DO-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :DO-DATE-TRAN
              ), CONVERT(DATE, :DO-DATE-TRAN) )                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*       INTO  :WS-TOTAL-NO-DEP:WS-NULL-IND1                               
MFA-TR*       FROM   CSS_DEP_ON_HAND AS DO                                      
MFA-TR*       WHERE  DO.ACCOUNT_NO = :DO-ACCOUNT-NO                             
MFA-TR*       AND    DO.DATE_TRAN > :DO-DATE-TRAN                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
               IF  WS-NULL-IND1 < ZEROS                                 
                   MOVE ZEROS     TO WS-NULL-IND1                       
                                     WS-TOTAL-NO-DEP                    
               END-IF                                                   
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7150'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE  DO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'DATE_TRAN'          TO TABLE-ELEMENT-2              
              MOVE DO-DATE-TRAN         TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 7160-DEPOSITS-ON-BILL-DATE.                                    *        
      ******************************************************************        
       7160-DEPOSITS-ON-BILL-DATE.                                      
      *                                                                         
           EXEC SQL                                                     
      *                                                                         
               SELECT COUNT(*)                                          
               INTO :WS-BILL-DT-DEP :WS-NULL-IND2                        
               FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                  
               WHERE AR.ACCOUNT_NO = :AR-ACCOUNT-NO                     
               AND CAST(AR.TRANS_HIST_SEQ_NO AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BILL-DATE
              ) <> 0) OR (LEN(:WS-BILL-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-BILL-DATE
              ), CONVERT(DATE, :WS-BILL-DATE) )           
               AND DATEADD(NANOSECOND, -DATEPART(NANOSECOND, CAST(
           AR.TRANS_HIST_SEQ_NO AS TIME)), CAST(AR.TRANS_HIST_SEQ_NO
            AS TIME)) > CIS.CHAR2TIME(:WS-BILL-TIME)           
               AND AR.APPL_PROGRAM_ID IN ('PANEL141','PANEL141C',       
                                          'PANEL164','PCSSO67D',        
                                          'PANEL125D','PANEL181D')      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*        INTO :WS-BILL-DT-DEP:WS-NULL-IND2                                
MFA-TR*        FROM CSS_AR_TRANS_HIST AR                                        
MFA-TR*        WHERE AR.ACCOUNT_NO = :AR-ACCOUNT-NO                             
MFA-TR*        AND DATE(AR.TRANS_HIST_SEQ_NO) = :WS-BILL-DATE                   
MFA-TR*        AND TIME(AR.TRANS_HIST_SEQ_NO) > :WS-BILL-TIME                   
MFA-TR*        AND AR.APPL_PROGRAM_ID IN ('PANEL141','PANEL141C',               
MFA-TR*                                   'PANEL164','PCSSO67D',                
MFA-TR*                                   'PANEL125D','PANEL181D')              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
               IF  WS-NULL-IND2 < ZEROS                                 
                   MOVE ZEROS     TO WS-NULL-IND2                       
                                     WS-BILL-DT-DEP                     
               END-IF                                                   
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7160'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE  AR-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'TRANS_HIST_DATE'    TO TABLE-ELEMENT-2              
              MOVE WS-BILL-DATE         TO HOSTVAR-ELEMENT-2            
              MOVE 'TRANS_HIST_TIME'    TO TABLE-ELEMENT-3              
              MOVE WS-BILL-TIME         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * GETS THE SECURED_RATE_FL TO CHECK IF THE ACCOUNT IS ON A     *          
      * SECURED RATE                                                 *          
      ****************************************************************          
       7200-CHECK-SECURED-RATES.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT SECURED_RATE_FL                                    
              INTO :RD-SECURED-RATE-FL                                  
              FROM  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                  
                    CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                 
              WHERE UT.ACCOUNT_NO      = :AT-ACCOUNT-NO                 
                AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE              
                AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO                
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SECURED_RATE_FL                                            
MFA-TR*       INTO :RD-SECURED-RATE-FL                                          
MFA-TR*       FROM  CSS_UTIL_ENVRNMT UT,                                        
MFA-TR*             CSS_RATE_PLAN_DESC RD                                       
MFA-TR*       WHERE UT.ACCOUNT_NO      = :AT-ACCOUNT-NO                         
MFA-TR*         AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE                      
MFA-TR*         AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN -811                                                
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                 
                   MOVE 'CSS_RATE_PLAN_DESC' TO TABLE-2                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-SELECT-DEP-ON-HAND                                        *        
      ******************************************************************        
      *                                                                         
       7210-SELECT-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
              INTO  :DO-ACCOUNT-NO                                      
              FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
              AND  DEPOSIT_STATUS_CD IN ('A','P')                       
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*       INTO  :DO-ACCOUNT-NO                                              
MFA-TR*       FROM   CSS_DEP_ON_HAND                                            
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       AND  DEPOSIT_STATUS_CD IN ('A','P')                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
           WHEN -811                                                    
               MOVE 'Y' TO WS-SECURED-ACCOUNT                           
           WHEN NOT-FOUND                                               
               MOVE 'N' TO WS-SECURED-ACCOUNT                           
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7210'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-SELECT-GUARANTOR                                          *        
      ******************************************************************        
                                                                        
       7220-SELECT-GUARANTOR.                                           
                                                                        
           EXEC SQL                                                     
              SELECT GU.ACCOUNT_NO                                      
              INTO  :GU-ACCOUNT-NO                                      
              FROM   CSS_GUARANTOR GU WITH(READUNCOMMITTED),                    
                     CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                     
              WHERE  GU.ACCOUNT_NO      = :AT-ACCOUNT-NO                
                AND  GU.GUARNTR_ACCT_NO = AT.ACCOUNT_NO                 
                AND  AT.CODE_ACCT_STAT  = 'A'                           
                AND  GU.GUAR_STATUS_CD  IN ('A','P')                    
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GU.ACCOUNT_NO                                              
MFA-TR*       INTO  :GU-ACCOUNT-NO                                              
MFA-TR*       FROM   CSS_GUARANTOR GU,                                          
MFA-TR*              CSS_ACCOUNT   AT                                           
MFA-TR*       WHERE  GU.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*         AND  GU.GUARNTR_ACCT_NO = AT.ACCOUNT_NO                         
MFA-TR*         AND  AT.CODE_ACCT_STAT  = 'A'                                   
MFA-TR*         AND  GU.GUAR_STATUS_CD  IN ('A','P')                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7220                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
           WHEN -811                                                    
               MOVE 'Y' TO WS-SECURED-ACCOUNT                           
           WHEN NOT-FOUND                                               
               MOVE 'N' TO WS-SECURED-ACCOUNT                           
           WHEN OTHER                                                   
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '7220'              TO ACTIVE-PARAGRAPH             
               MOVE 'SELECT'            TO ABEND-FUNCTION               
               MOVE 'CSS_GUARANTOR'     TO TABLE-1                      
               MOVE 'CSS_ACCOUNT'       TO TABLE-2                      
               MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1              
               MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1            
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7230-SELECT-SURETY-BOND                                        *        
      ******************************************************************        
                                                                        
       7230-SELECT-SURETY-BOND.                                         
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
              INTO  :SB-ACCOUNT-NO                                      
              FROM   CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
              AND CODE_BOND_TYPE IN('A','B')                            
              AND CODE_STATUS IN('A','P')                               
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*       INTO  :SB-ACCOUNT-NO                                              
MFA-TR*       FROM   CSS_SURETY_BOND                                            
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       AND CODE_BOND_TYPE IN('A','B')                                    
MFA-TR*       AND CODE_STATUS IN('A','P')                                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7230                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
           WHEN -811                                                    
               MOVE 'Y' TO WS-SECURED-ACCOUNT                           
           WHEN NOT-FOUND                                               
               MOVE 'N' TO WS-SECURED-ACCOUNT                           
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7230'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * SELECT ARREARS_HIST  FROM CSS_CREDIT_PROFILE **                         
      ************************************************************              
       7240-SELECT-DISCONN-HIST.                                        
                                                                        
             MOVE '7240' TO WS-ACTIVE-PARAGRAPH.                        
                                                                        
             EXEC SQL                                                   
                 SELECT DISCONNECT_HIST                                 
                       ,DISC_EXCEPTN_HIST                               
                   INTO :CZ-DISCONNECT-HIST                             
                       ,:CZ-DISC-EXCEPTN-HIST                           
                   FROM  CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)               
                   WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                    
                                                                 
P00773                                                      
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*          SELECT DISCONNECT_HIST                                         
MFA-TR*                ,DISC_EXCEPTN_HIST                                       
MFA-TR*            INTO :CZ-DISCONNECT-HIST                                     
MFA-TR*                ,:CZ-DISC-EXCEPTN-HIST                                   
MFA-TR*            FROM  CSS_CREDIT_PROFILE                                     
MFA-TR*            WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7240                                                   
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
             IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
             ELSE                                                       
                 MOVE PROGRAM-NAME TO ABEND-PROGRAM                     
                 MOVE '7240'       TO ACTIVE-PARAGRAPH                  
                 MOVE 'SELECT'     TO ABEND-FUNCTION                    
                 MOVE 'CSS_CREDIT_PROFILE' TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1              
                 MOVE WS-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1            
                 PERFORM 9000-SEND-ERROR-RESULT                         
                    THRU 9000-EXIT                                      
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                    THRU 9900-EXIT                                      
             END-IF.                                                    
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7250-SELECT-MAX-DEP-CERT.                                      *        
      ******************************************************************        
      *                                                                         
       7250-SELECT-MAX-DEP-CERT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT MAX(DEPOSIT_CERT_NO)                               
              INTO  :WS-MAX-DEP-CERT-NO :WS-NULL-IND4                    
              FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(DEPOSIT_CERT_NO)                                       
MFA-TR*       INTO  :WS-MAX-DEP-CERT-NO:WS-NULL-IND4                            
MFA-TR*       FROM   CSS_DEP_ON_HAND                                            
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF  WS-NULL-IND4 < ZEROS                                 
                   MOVE ZEROS     TO WS-NULL-IND4                       
                                     WS-MAX-DEP-CERT-NO                 
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7250'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7260-GET-AMT-DEP-ON-HAND                                       *        
      ******************************************************************        
                                                                        
       7260-GET-AMT-DEP-ON-HAND.                                        
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMT_DEPOSIT)                                   
              INTO  :WS-AMT-DEP-ON-HAND :WS-NULL-IND3                    
              FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
              AND  DEPOSIT_STATUS_CD IN ('A','P')                       
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_DEPOSIT)                                           
MFA-TR*       INTO  :WS-AMT-DEP-ON-HAND:WS-NULL-IND3                            
MFA-TR*       FROM   CSS_DEP_ON_HAND                                            
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       AND  DEPOSIT_STATUS_CD IN ('A','P')                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7260                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF  WS-NULL-IND3 < ZEROS                                 
                   MOVE ZEROS     TO WS-NULL-IND3                       
                                     WS-AMT-DEP-ON-HAND                 
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7260'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 7270-SELECT-GUARANTEED-AMT.                                    *        
      ******************************************************************        
                                                                        
       7270-SELECT-GUARANTEED-AMT.                                      
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMOUNT_GUARANTEED)                             
              INTO  :GU-AMOUNT-GUARANTEED :WS-NULL-IND5                  
              FROM   CSS_GUARANTOR GU WITH(READUNCOMMITTED),                    
                     CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                     
              WHERE  GU.ACCOUNT_NO      = :GU-ACCOUNT-NO                
                AND  GU.GUARNTR_ACCT_NO = AT.ACCOUNT_NO                 
                AND  AT.CODE_ACCT_STAT  = 'A'                           
                AND  GU.GUAR_STATUS_CD  = 'A'                           
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMOUNT_GUARANTEED)                                     
MFA-TR*       INTO  :GU-AMOUNT-GUARANTEED:WS-NULL-IND5                          
MFA-TR*       FROM   CSS_GUARANTOR GU,                                          
MFA-TR*              CSS_ACCOUNT   AT                                           
MFA-TR*       WHERE  GU.ACCOUNT_NO      = :GU-ACCOUNT-NO                        
MFA-TR*         AND  GU.GUARNTR_ACCT_NO = AT.ACCOUNT_NO                         
MFA-TR*         AND  AT.CODE_ACCT_STAT  = 'A'                                   
MFA-TR*         AND  GU.GUAR_STATUS_CD  = 'A'                                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7270                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   IF  WS-NULL-IND5 < ZEROES                            
                       MOVE ZEROS       TO GU-AMOUNT-GUARANTEED         
                                           WS-NULL-IND5                 
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7270'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_GUARANTOR' TO TABLE-1                      
                   MOVE 'CSS_ACCOUNT'   TO TABLE-2                      
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1              
                   MOVE WS-ACCOUNT-NO-NUM TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7280-SELECT-SURETY-BOND-AMT.                                   *        
      ******************************************************************        
                                                                        
       7280-SELECT-SURETY-BOND-AMT.                                     
                                                                        
           EXEC SQL                                                     
T34110        SELECT SUM(SB.AMT_BOND)                                   
              INTO  :SB-AMT-BOND :WS-NULL-IND6                           
              FROM   CSS_SURETY_BOND SB WITH(READUNCOMMITTED)                   
              WHERE  ACCOUNT_NO = :SB-ACCOUNT-NO                        
              AND SB.CODE_BOND_TYPE IN('A','B')                         
              AND SB.CODE_STATUS IN('A','P')                            
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(SB.AMT_BOND)                                           
MFA-TR*       INTO  :SB-AMT-BOND:WS-NULL-IND6                                   
MFA-TR*       FROM   CSS_SURETY_BOND SB                                         
MFA-TR*       WHERE  ACCOUNT_NO = :SB-ACCOUNT-NO                                
MFA-TR*       AND SB.CODE_BOND_TYPE IN('A','B')                                 
MFA-TR*       AND SB.CODE_STATUS IN('A','P')                                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7280                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
               IF  WS-NULL-IND6 < ZEROES                                
                   MOVE ZEROES     TO SB-AMT-BOND                       
                                      WS-NULL-IND6                      
               END-IF                                                   
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7280'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * THIS GETS THE NO OF RETURN CHECKS BETWEEN THE LAST 12 AND 24*           
      * MONTHS                                                      *           
      ***************************************************************           
      *                                                                         
       7290-SELECT-NSF-1-2YEAR-HIST.                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-NSF-COUNT-1-2YEAR                              
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO    = :AT-ACCOUNT-NO                     
                 AND NSF_STATUS_CD  = 'C'                               
                 AND NSF_TYPE_CD    = 'C'                               
                 AND DATE_TRAN      > DATEADD( YEAR, -2, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )             
                 AND DATE_TRAN      < DATEADD( YEAR, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )             
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-NSF-COUNT-1-2YEAR                                      
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO    = :AT-ACCOUNT-NO                             
MFA-TR*          AND NSF_STATUS_CD  = 'C'                                       
MFA-TR*          AND NSF_TYPE_CD    = 'C'                                       
MFA-TR*          AND DATE_TRAN      > CURRENT DATE - 2 YEAR                     
MFA-TR*          AND DATE_TRAN      < CURRENT DATE - 1 YEAR                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7290                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN OTHER                                                
                  MOVE SPACES                  TO ABEND-TABLES          
                  MOVE SPACES                  TO ABEND-SQL-PREDICATES  
                  MOVE 'CSR03515'              TO ABEND-PROGRAM         
                  MOVE '7290'                  TO ACTIVE-PARAGRAPH      
                  MOVE 'SELECT'                TO ABEND-FUNCTION        
                  MOVE 'CSS_NSF_HIST'          TO TABLE-1               
                  MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1       
                  MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1     
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       7290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * THIS GETS THE NO OF RETURN CHECKS IN THE LAST 1 YEAR        *           
      ***************************************************************           
      *                                                                         
       7300-SELECT-NSF-1YEAR-HIST.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-NSF-COUNT-1YEAR                                
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO    = :AT-ACCOUNT-NO                     
                 AND NSF_STATUS_CD  = 'C'                               
                 AND NSF_TYPE_CD    = 'C'                               
                 AND DATE_TRAN      > DATEADD( YEAR, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )             
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-NSF-COUNT-1YEAR                                        
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO    = :AT-ACCOUNT-NO                             
MFA-TR*          AND NSF_STATUS_CD  = 'C'                                       
MFA-TR*          AND NSF_TYPE_CD    = 'C'                                       
MFA-TR*          AND DATE_TRAN      > CURRENT DATE - 1 YEAR                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN OTHER                                                
                  MOVE SPACES                  TO ABEND-TABLES          
                  MOVE SPACES                  TO ABEND-SQL-PREDICATES  
                  MOVE 'CSR03515'              TO ABEND-PROGRAM         
                  MOVE '7300'                  TO ACTIVE-PARAGRAPH      
                  MOVE 'SELECT'                TO ABEND-FUNCTION        
                  MOVE 'CSS_NSF_HIST'          TO TABLE-1               
                  MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1       
                  MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1     
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7310-GET-AUTO-EXEMPTIONS.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT ATTRIBUTE_VALUE_CD                                 
                INTO :YP-ATTRIBUTE-VALUE-CD                             
                FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                    
                 AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                
                                                                 
P00773                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ATTRIBUTE_VALUE_CD                                         
MFA-TR*         INTO :YP-ATTRIBUTE-VALUE-CD                                     
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE                                         
MFA-TR*        WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                            
MFA-TR*          AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                  MOVE SPACES                  TO ABEND-TABLES          
                  MOVE SPACES                  TO ABEND-SQL-PREDICATES  
                  MOVE 'CSR03515'              TO ABEND-PROGRAM         
                  MOVE '7310'                  TO ACTIVE-PARAGRAPH      
                  MOVE 'SELECT'                TO ABEND-FUNCTION        
                  MOVE 'CSS_ACCT_ATTRIBUTE'    TO TABLE-1               
                  MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1       
                  MOVE YP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1     
                  MOVE 'ATTRIBUTE_DESC'        TO TABLE-ELEMENT-2       
                  MOVE YP-ATTRIBUTE-DESC       TO HOSTVAR-ELEMENT-2     
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7500-SELECT-CURRENT-TS                                         *        
      ******************************************************************        
       7500-SELECT-CURRENT-TS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7500'               TO ACTIVE-PARAGRAPH            
               MOVE 'SET'                TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                             ABEND-TABLES               
               MOVE 'CSS_ACCOUNT'        TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8200-CALL-CSR02072.                                              
      *                                                                         
           INITIALIZE WS-CSR02072-OUTPUT-FIELDS.                        
      *    EXEC SQL CALL CSR02072                                       
      *    (:WS-ACTION-CODE,                                            
      *     :WS-ACCT-NO,                                                
      *     :WS-AMT-ORIG-ENTERED ,                                      
      *     :WS-DEPOSIT-STATUS-CD,                                      
      *     :WS-SERVICE-TYPE-CD  ,                                      
      *     :WS-DEPOSIT-CERT-NO  ,                                      
      *     :WS-DEP-ACTION-CODE  ,                                      
      *     :WS-USER-ID-UPDT-BY  ,                                      
      *     :WS-COMMENTS         ,                                      
      *     :WS-COMMENTS-LEN,                                           
      *     :WS-PANEL-COMMENTS   ,                                      
      *     :WS-PANEL-COMM-LEN,                                         
      *     :WS-BILL-OPTION-CD   ,                                      
      *     :WS-ORIG-BILL-OPTN,                                         
      *     :WS-NO-SCHED-PYMTS   ,                                      
      *     :WS-AMT-MO-PYMT      ,                                      
      *     :WS-CODE-DEP-TYPE    ,                                      
      *     :WS-CUT-DATE ,                                              
      *     :WS-PROJECT-CR-DT,                                          
      *     :WS-DUE-DATE,                                               
      *     :WS-PROGRAM-NAME,                                           
      *     :WS-LAST-UPDATE-TS,                                         
      *     :WS-CODE-REFUND-ELIG,                                       
      *     :WS-ERROR-SWITCH,                                           
      *     :WS-AUTO-DEP-LTR-DT,                                        
      *     :WS-AUTO-DEP-LETTER-IND,                                    
      *     :WS-AUTO-DEP-NOT-AMT,                                       
      *     :WS-AUTO-DEP-RECALC-AMT)                                    
      *     END-EXEC                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CHRG_AUTO_DEP
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CHRG_AUTO_DEP
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CHRG_AUTO_DEP INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE      
            IF  WS-ACTIVE-RETURN-CODE = +466                            
      *         EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE       
      *            CSR02072                                             
      *         END-EXEC                                                
                                                                        
      *         EXEC SQL                                                
      *           ALLOCATE CHRG_AUTO_DEP CURSOR FOR RESULT SET :LOC1    
      *         END-EXEC                                                
                                                                        
                EXEC SQL                                                
                  FETCH CHRG_AUTO_DEP                                   
                  INTO :WS-CSR02072-ERROR-CODE                          
                      ,:WS-CSR02072-RETURN-CODE                         
                      ,:WS-CSR02072-AR-LOCKOUT-IND                      
                      ,:WS-CSR02072-ACCT-XFER-TO                        
                      ,:WS-CSR02072-ABEND-PROGRAM                       
                      ,:WS-CSR02072-ACTIVE-PARAGRAPH                    
                      ,:WS-CSR02072-ABEND-FUNCTION                      
                      ,:WS-CSR02072-TABLE-1                             
                      ,:WS-CSR02072-TABLE-ELEMENT-1                     
                      ,:WS-CSR02072-TABLE-ELEMENT-2                     
                      ,:WS-CSR02072-TABLE-ELEMENT-3                     
                      ,:WS-CSR02072-TABLE-ELEMENT-4                     
                      ,:WS-CSR02072-HOSTVAR-ELEMENT-1                   
                      ,:WS-CSR02072-HOSTVAR-ELEMENT-2                   
                      ,:WS-CSR02072-HOSTVAR-ELEMENT-3                   
                      ,:WS-CSR02072-HOSTVAR-ELEMENT-4                   
                END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE  
                IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    EVALUATE WS-CSR02072-RETURN-CODE                    
                        WHEN 0                                          
                            MOVE 'Y' TO WS-CSR02072-SUCCESS-FL          
                            MOVE WS-MAX-DEP-CERT-NO TO S-DEP-CERT-NO    
      * ADD NEW AUTO DEP AMT CHARGED TO S-AMT-SECURED FOR CREATING              
      * MAX DEPOSIT ZERO WQ FROM PANEL 181                                      
                            IF  I-CALLING-PGM = 'PANEL181D'             
                            AND WS-MAX-DEPOSIT-AMT = ZEROES             
                                ADD WS-AUTO-DEP-AMT TO S-AMT-SECURED    
                            END-IF                                      
                        WHEN OTHER                                      
                            MOVE 'N' TO WS-CSR02072-SUCCESS-FL          
                            MOVE WS-CSR02072-RETURN-CODE                
                            TO WS-ACTIVE-RETURN-CODE                    
                            MOVE WS-CSR02072-ABEND-FUNCTION             
                            TO ABEND-FUNCTION                           
                            MOVE WS-CSR02072-ACTIVE-PARAGRAPH           
                            TO ACTIVE-PARAGRAPH                         
                            MOVE WS-CSR02072-ABEND-PROGRAM              
                            TO ABEND-PROGRAM                            
                            MOVE WS-CSR02072-TABLE-1                    
                            TO TABLE-1                                  
                            MOVE WS-CSR02072-TABLE-ELEMENT-1            
                            TO TABLE-ELEMENT-1                          
                            MOVE WS-CSR02072-HOSTVAR-ELEMENT-1          
                            TO HOSTVAR-ELEMENT-1                        
                            MOVE WS-CSR02072-TABLE-ELEMENT-2            
                            TO TABLE-ELEMENT-2                          
                            MOVE WS-CSR02072-HOSTVAR-ELEMENT-2          
                            TO HOSTVAR-ELEMENT-2                        
                            MOVE WS-CSR02072-TABLE-ELEMENT-3            
                            TO TABLE-ELEMENT-3                          
                            MOVE WS-CSR02072-HOSTVAR-ELEMENT-3          
                            TO HOSTVAR-ELEMENT-3                        
                            MOVE WS-CSR02072-TABLE-ELEMENT-4            
                            TO TABLE-ELEMENT-4                          
                            MOVE WS-CSR02072-HOSTVAR-ELEMENT-4          
                            TO HOSTVAR-ELEMENT-4                        
                           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT
                           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
                    END-EVALUATE                                        
                ELSE                                                    
                    MOVE 'N' TO WS-CSR02072-SUCCESS-FL                  
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '8200'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                      ABEND-TABLES      
                    MOVE 'CSR02072'          TO TABLE-1                 
                    MOVE 'SQLCODE'           TO TABLE-ELEMENT-1         
                    MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
                    MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2         
                    MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2       
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
                END-IF                                                  
                                                                        
                EXEC SQL                                                
                   CLOSE CHRG_AUTO_DEP                                  
                END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                MOVE SQLCODE          TO WS-ACTIVE-RETURN-CODE          
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                    CONTINUE                                            
                ELSE                                                    
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '8200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'CLOSE'              TO ABEND-FUNCTION          
                   MOVE 'CSR02072'           TO TABLE-1                 
                   MOVE 'WS-ACTIVE-RETURN-CODE' TO TABLE-ELEMENT-1      
                   MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
                END-IF                                                  
           ELSE                                                         
               MOVE -1                       TO WS-ACTIVE-RETURN-CODE   
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8200'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DB2SP'                  TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                 ABEND-TABLES           
               MOVE 'CSR02072'               TO TABLE-1                 
               MOVE 'SQLCODE'                TO TABLE-ELEMENT-1         
               MOVE SQLCODE                  TO HOSTVAR-ELEMENT-1       
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2         
               MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * INCLUDE COPYBOOK FOR DETERMINING MAX-DEPOSIT ESTIMATES         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00308                                                  
           END-EXEC.                                                            
      *                                                                         
HPCCDM*    EJECT                                                        15303900
      *                                                                 15304000
      ************************************************************              
      * INCLUDE CPD0023C FOR ERROR HANDLING                                     
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      ************************************************************              
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *    EXEC SQL                                                             
      *       INCLUDE CPDSP300                                                  
      *    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE AND 9975-ABEND-CONTROL-TRANSFER WHICH   *        
      * ARE PART OF CPDSP300 IS ADDED TO THIS PROGRAM TO HANDLE NEW    *        
      * ERROR-SWITCH WHICH WILL BE USED BY CALLING PROGRAMS            *        
      ******************************************************************        
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           PERFORM 9975-ABEND-CONTROL-TRANSFER THRU 9975-EXIT.          
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9975-ABEND-CONTROL-TRANSFER.                                     
      *                                                                         
           IF  I-ERROR-SW = 'Y'                                         
               
MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
               EXEC SQL                                                 
      *                                                                         
                   CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
               END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*        EXEC SQL                                                         
MFA-TR*                                                                         
MFA-TR*            CALL CSRERLOG (                                              
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*        END-EXEC                                                         
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
           END-IF.                                                      
      *                                                                         
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9975-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    EXEC SQL                                                             
      *       INCLUDE CPD00321                                                  
      *    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  8900-SEND-DONE, 9000-SEND-ERROR-RESULT AND 9999-END-PROGRAM   *        
      *  WHICH ARE PART OF CPD000321 IS ADDED TO THIS PROGRAM          *        
      *  TO HANDLE NEW ERROR-SWITCH TO BE USED BY CALLING PROGRAMS     *        
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                         
           IF  I-ERROR-SW = 'Y'                                         
               EXEC SQL                                                 
                   ROLLBACK                                             
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
               IF SQLCODE = 0                                           
                  CONTINUE                                              
               ELSE                                                     
                  MOVE 'ROLLBACK'     TO ABEND-FUNCTION                 
               END-IF                                                   
           ELSE                                                         
      * MOVES ERROR-INFO TO RESULT SET VARIABLES                                
               MOVE ABEND-PROGRAM            TO S-ABEND-PROGRAM         
               MOVE ACTIVE-PARAGRAPH         TO S-ACTIVE-PARAGRAPH      
               MOVE ABEND-FUNCTION           TO S-ABEND-FUNCTION        
               MOVE TABLE-1                  TO S-TABLE-1               
               MOVE TABLE-ELEMENT-1          TO S-TABLE-ELEMENT-1       
               MOVE HOSTVAR-ELEMENT-1        TO S-HOSTVAR-ELEMENT-1     
               MOVE TABLE-ELEMENT-2          TO S-TABLE-ELEMENT-2       
               MOVE HOSTVAR-ELEMENT-2        TO S-HOSTVAR-ELEMENT-2     
               MOVE TABLE-ELEMENT-3          TO S-TABLE-ELEMENT-3       
               MOVE HOSTVAR-ELEMENT-3        TO S-HOSTVAR-ELEMENT-3     
               MOVE TABLE-ELEMENT-4          TO S-TABLE-ELEMENT-4       
               MOVE HOSTVAR-ELEMENT-4        TO S-HOSTVAR-ELEMENT-4     
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9010-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9010-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
       9010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
