       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03514.                                     
COB303 DATE-WRITTEN. FEBRUARY 28, 2005.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03514              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03514 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVES INFORMATION OF ACCOUNT TO CHECK IF ELIGIBLE  --         
      *--     TO BE SET UP ON EPP.                                   --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--     1                                                      --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
C29534*--  02/28/2005    KB40308     NEW CODE                        --         
C29534*--  03/31/2005    JC91900     EPP VALIDATION RULES            --         
T35434*--  07/28/2007    MR97640     REPLACED MODEL_SQL WITH SET     --         
T35434*--                            STATEMENT AND ADDED WITH UR TO  --         
T35434*--                            AVOID -911                      --         
PRODFX*--  03/31/2009    VV94890     FIXED LOGIC IN 7600-CHECK PARA  --         
PRODFX*--                            FOR WEB EPP ISSUE THAT WAS RETUR--         
PRODFX*--                            NING A -811.                    --         
A01120*--  04/29/2009    DM94438     FIXED LOGIC IN 5350-CHECK-FOR-ANNIV        
A01120*--                            TO STOP GETTING -180 ERROR IN PARA         
A01120*--                            7970-CHECK-ACCT-FOR-ANNIV.                 
A01120*--                                                                       
A37061*--  07/21/2009    SJ97149     1.REPLACE CODE_REV_CLASS MID DIGIT*        
A37061*--                              CHECK WITH CSS_ACCOUNT.         *        
A37061*--                              ACCOUNT_TYPE_CODE FOR GETTING   *        
A37061*--                              TYPE OF THE ACCOUNT.            *        
A37061*--                            2.ADDED"ROWSET POSITIONING" FOR   *        
A37061*--                              GLOBAL TEMPERARY TABLES         *        
P00251** 03/08/10 WR19680 BLOCK CO-GENERATION ACCOUNTS FROM BEING    **         
P00251**                  SETUP ON BBP.                                         
A02824*--  09/30/10      GD97441     1.BLOCK SECURED RATE ACCOUNTS FROM*        
A02824*--                              BEING SETUP ON BBP.             *        
A02824*--                            2. CHANGED QUERY IN 7700- PARA.   *        
ACT219*--  12/01/2013    BD09555     ADD CREDIT GROUP 'N' TO CONDITION *        
ACT219*--  A04527                                                      *        
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03514'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT, AT                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BUDGET_PLAN , BU                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBGTPLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_RATE_TOU_DEF, RJ                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTTOUD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_RATE_CREATOR, RT                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
P00251******************************************************************        
P00251* CSS_RATE_COMP_DEF, J1                                          *        
P00251******************************************************************        
P00251     EXEC SQL                                                             
P00251        INCLUDE TBRTCDEF                                                  
P00251     END-EXEC.                                                            
P00251*                                                                         
A02824******************************************************************        
A02824* CSS_RATE_PLAN_DESC - RD                                        *        
A02824******************************************************************        
A02824*                                                                         
A02824     EXEC SQL                                                             
A02824         INCLUDE TBRTDESC                                                 
A02824     END-EXEC.                                                            
A02824*                                                                         
      ******************************************************************        
      * CSS_UTL_ENVRMNT , UT                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BILLING_HDR , BI                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BILLING_DET , BG                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_AR_CNTL, AR                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_CREDIT_PROFILE, CZ                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCRPROF                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_AR_TRANS_HIST, AR                                         *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBARHIST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BUDGET_HIST, BH                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBGTHST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BILL_WINDOW, BN                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBILWDW                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_FINAL_WO, FW                                              *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFINLWO                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_PROJ_SHARE, PJ                                            *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBPRJSHR                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_CONTRACT, CT                                              *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCNTRCT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      *    COPYBOOKS NEEDED TO SUPPORT JOURNALLING                              
      *****************************************************************         
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK                                 *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE FOR CODES DATA PRESENT                      *        
      ******************************************************************        
           COPY CWS00056.                                                       
                                                                        
      ******************************************************************        
      *    COPY BOOK TO REDUCE EMBEDDED BLANKS                         *        
      ******************************************************************        
           COPY CWS00011.                                                       
                                                                        
      ******************************************************************        
      *    LINKAGE SECTION VARIABLES FOR SCSCO068                      *        
      ******************************************************************        
           COPY CWS0068L.                                                       
                                                                        
      ****************************************************************          
      *    DB2 ERRROR PROCESSING COPYBOOK                            *          
      ****************************************************************          
       COPY CWSSP001.                                                           
                                                                        
      ****************************************************************          
      *    WORKING STORAGE TO SUPPORT CPD00068                       *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(08) VALUE 'CSRERLOG'.    
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR03514'.    
           05  WS-PPL-AR-TYPE-NSC        PIC S9(4) COMP VALUE +019.     
           05  WS-PPL-AR-TYPE-LPC        PIC S9(4) COMP VALUE +030.     
           05  WS-PPL-AR-TYPE-UTE        PIC S9(4) COMP VALUE +040.     
           05  WS-PPL-AR-TYPE-UTG        PIC S9(4) COMP VALUE +045.     
           05  WS-PPL-AR-TYPE-RCC        PIC S9(4) COMP VALUE +060.     
           05  WS-ACTIVE-CODE            PIC X(01) VALUE 'A'.           
           05  WS-PENDING-CODE           PIC X(01) VALUE 'P'.           
           05  WS-YES                    PIC X(01) VALUE 'Y'.           
           05  WS-NO                     PIC X(01) VALUE 'N'.           
                                                                        
      ******************************************************************        
      * S-EPP-STATUS WILL HAVE THE FOLLOWING VALUES                    *        
      *  E - ELIGIBLE                                                  *        
      *  I - IN-ELIGIBLE                                               *        
      *  C - CURRENT EPP                                               *        
      *  N - NEXT BILL EPP                                             *        
      ******************************************************************        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE              PIC S9(9) VALUE 0 COMP.        
           10 S-EPP-STATUS               PIC X(01) VALUE SPACES.        
           10 S-OTHR-BILLED-CHRG         PIC X(13) VALUE SPACES.        
           10 S-OTHR-NEXT-CHRG           PIC X(13) VALUE SPACES.        
           10 S-UTILITY-BALANCE          PIC X(13) VALUE SPACES.        
           10 S-UTILITY-ARREARS          PIC X(13) VALUE SPACES.        
           10 S-CURRENT-EPP-AMT          PIC X(13) VALUE SPACES.        
           10 S-INCREASE-EPP-AMT         PIC X(13) VALUE SPACES.        
           10 S-START-DATE               PIC X(10) VALUE SPACES.        
           10 S-ANNIV-DATE               PIC X(10) VALUE SPACES.        
           10 S-MONTHS-LEFT              PIC X(02) VALUE SPACES.        
           10 S-REVENUE-MONTH            PIC X(06) VALUE SPACES.        
           10 S-EPP-BILL-OPT             PIC X(01) VALUE SPACES.        
           10 S-ANNIV-FLAG               PIC X(01) VALUE SPACES.        
           10 S-OTHR-CHRG-FLAG           PIC X(01) VALUE SPACES.        
           10 S-LAST-UPDATE-TS           PIC X(26) VALUE SPACES.        
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9) COMP.                
           05  WRKLEN1                   PIC S9(9) COMP.                
           05  WRKLEN2                   PIC S9(9) COMP.                
           05  WRK-DONE-STATUS           PIC S9(9) COMP.                
                                                                        
       01  WS-UTIL-FIELDS.                                              
           05  WS-UTL-RELT-ARS           PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-UTL-RELT-ARS-NUM       PIC S9(11)V99.                 
           05  WS-UTIL-BILL-COUNT        PIC S9(3) COMP-3 VALUE 0.      
           05  WS-UTIL-RELT-BAL-NUM      PIC S9(11)V99.                 
           05  WS-UTIL-RELT-BAL          PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-UTIL-RELT-BAL-CHAR     PIC X(13).                     
           05  WS-UTIL-RELT-BAL-EDIT      REDEFINES                     
                WS-UTIL-RELT-BAL-CHAR    PIC -(9)9.99.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-ANNIVERSARY-DATE.                                     
               10  WS-AD-MONTH           PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  WS-AD-DAY             PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE SPACES.        
               10  WS-AD-YEAR            PIC X(04) VALUE SPACES.        
           05  WS-START-DATE.                                           
               10  WS-SD-MONTH           PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '/'.           
               10  WS-SD-DAY             PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '/'.           
               10  WS-SD-YEAR            PIC X(04) VALUE SPACES.        
           05  WS-YEAR-MONTH1.                                          
               10 WS-YEAR1               PIC 9(04) VALUE ZERO.          
               10 WS-MONTH1              PIC 9(02) VALUE ZERO.          
           05  WS-YEAR-MONTH2.                                          
               10 WS-YEAR2               PIC 9(04) VALUE ZERO.          
               10 WS-MONTH2              PIC 9(02) VALUE ZERO.          
                                                                        
           05  MCSCB068                  PIC X(8)  VALUE 'MCSCB068'.    
           05  WS-RETURN-CODE            PIC S9(4)  COMP VALUE 0.       
           05  WS-CALC-START-MONTH       PIC 9(02).                     
           05  WS-CALC-START-YEAR        PIC 9(04).                     
           05  WS-PARM-ACCOUNT-NO        PIC 9(13) VALUE ZERO.          
           05  WS-ACCOUNT-NO             PIC 9(13) VALUE ZERO.          
           05  WS-MONTH-CTR              PIC S9(3) COMP-3 VALUE 0.      
COB305     05 WS-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.              
           05  WS-REVENUE-MONTH-X        PIC X(06) VALUE SPACES.        
           05  WS-REVENUE-MONTH-NULL     PIC S9(4) COMP.                
           05  WS-NULL-IND-3             PIC S9(4) USAGE COMP VALUE +0. 
           05  WS-NULL-IND-4             PIC S9(4) USAGE COMP VALUE +0. 
           05  WS-NULL-IND-5             PIC S9(4) USAGE COMP VALUE +0. 
           05  WS-NULL-IND-6             PIC S9(4) USAGE COMP VALUE +0. 
           05  WS-NULL-IND-7             PIC S9(4) USAGE COMP VALUE +0. 
           05  WS-NULL-IND-8             PIC S9(4) USAGE COMP VALUE +0. 
           05  WS-MONTHS-LEFT            PIC 9(02) VALUE ZEROES.        
           05  WS-HTGCLG-ROWS            PIC S9(3) COMP-3 VALUE 0.      
           05  WS-PYMT-PRIORITY-LVL      PIC S9(4) COMP VALUE ZERO.     
COB305     05 WS-TO-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.       
           05  WS-TO-REV-MONTH-NI        PIC S9(4) COMP  VALUE +0.      
           05  WS-TO-REV-MONTH-C         PIC 9(06).                     
           05  WS-MAX-REV-DATE           PIC X(10).                     
           05  WS-MAX-REV-DATE-TMP       PIC X(10).                     
           05  WS-DATE-BILLED-00         PIC X(10).                     
COB305     05 WS-MAX-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.       
COB305     05 WS-FROM-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.       
           05  WS-FROM-REV-MONTH-C       PIC 9(06).                     
           05  WS-CURRENT-DATE           PIC X(10).                     
           05  WS-CONTRACT-EXISTS        PIC X(01) VALUE 'N'.           
           05  WS-PROJ-SHARE-EXISTS      PIC X(01) VALUE 'N'.           
           05  WS-NOT-ELIG-FOR-EPP       PIC X(01) VALUE SPACES.        
           05  WS-ACCT-ANNIV-FLAG        PIC X(01) VALUE SPACES.        
           05  WS-CODE-BILL-TYPE         PIC X(01) VALUE SPACES.        
           05  WS-OTHR-CHRG-FLAG         PIC X(01) VALUE 'N'.           
           05  WS-PYMT-FOUND             PIC X(01) VALUE SPACES.        
           05  WS-EPP-ACCT-WITH-ANNIV    PIC X(01) VALUE SPACES.        
           05  WS-EPP-BILL-OPT           PIC X(01) VALUE SPACES.        
           05  WS-NSF-COUNT              PIC S9(4) COMP.                
           05  WS-TOTAL-ARREARS          PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-TOT-PROJ-SHR-AMT       PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-00-30-60-90-DAY-AMT    PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-FINAL-INSTLMNT-DTMNT   PIC S9(09)V99 COMP-3 VALUE +0. 
                                                                        
           05  WS-AD-MONTH-X             PIC X(02) VALUE SPACES.        
           05  WS-AD-MONTH-RED            REDEFINES                     
                WS-AD-MONTH-X            PIC 9(02).                     
           05  WS-AD-YEAR-X              PIC X(04) VALUE SPACES.        
           05  WS-AD-YEAR-RED             REDEFINES                     
                WS-AD-YEAR-X             PIC 9(04).                     
           05  WS-UTL-RELT-ARS-CHAR      PIC X(13).                     
           05  WS-UTL-RELT-ARS-EDIT       REDEFINES                     
                WS-UTL-RELT-ARS-CHAR     PIC -(9)9.99.                  
                                                                        
           05  WS-NONEPP-ELIG-AMT        PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-NONEPP-ELIG-AMT-NUM    PIC S9(11)V99.                 
           05  WS-NONEPP-ELIG-AMT-CHAR   PIC X(13).                     
           05  WS-NONEPP-ELIG-AMT-EDIT    REDEFINES                     
                WS-NONEPP-ELIG-AMT-CHAR  PIC -(9)9.99.                  
                                                                        
           05  WS-OTHR-NEXT-CHRG         PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-OTHR-NEXT-CHRG-NUM     PIC S9(11)V99.                 
           05  WS-OTHR-NEXT-CHRG-CHAR    PIC X(13).                     
           05  WS-OTHR-NEXT-CHRG-EDIT     REDEFINES                     
                WS-OTHR-NEXT-CHRG-CHAR PIC -(9)9.99.                    
                                                                        
           05  WS-CURRENT-EPP-AMT        PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-CURRENT-EPP-AMT-NUM    PIC S9(11)V99.                 
           05  WS-CURRENT-EPP-AMT-CHAR   PIC X(13).                     
           05  WS-CURRENT-EPP-AMT-EDIT    REDEFINES                     
                WS-CURRENT-EPP-AMT-CHAR  PIC -(9)9.99.                  
                                                                        
           05  WS-INCREASE-EPP-AMT-RND   PIC S9(11) COMP-3 VALUE +0.    
                                                                        
           05  WS-INCREASE-EPP-AMT       PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-INCREASE-EPP-AMT-NUM   PIC S9(11)V99.                 
           05  WS-INCREASE-EPP-AMT-CHAR  PIC X(13).                     
           05  WS-INCREASE-EPP-AMT-EDIT   REDEFINES                     
                WS-INCREASE-EPP-AMT-CHAR PIC -(9)9.99.                  
A02824     05  WS-SECURED-RATE-FLAG      PIC X(01) VALUE SPACES.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-EXISTS                 PIC X(01) VALUE 'N'.           
               88 WS-EXISTS-YES                    VALUE 'Y'.           
               88 WS-EXISTS-NO                     VALUE 'N'.           
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS                                           *        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE UTIL_ENVRNMT CURSOR FOR                            
                SELECT  UT.PREMISE_NO                                   
                       ,UT.CODE_UTIL_TYPE                               
                       ,UT.IC_NO                                        
                       ,UT.ACCOUNT_NO                                   
                 FROM   CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                 WHERE UT.ACCOUNT_NO  = :UT-ACCOUNT-NO                  
                   AND (EXISTS                                          
                      (SELECT 1 FROM CSS_MTRD_ENVRNMT MN
                           WITH(READUNCOMMITTED)                
                        WHERE MN.ACCOUNT_NO = UT.ACCOUNT_NO             
                          AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE     
                          AND MN.IC_NO = UT.IC_NO                       
                          AND MN.METER_NO <> '         '                
                          AND MN.CODE_METER_STATUS = 'A' ))             
T35434             FOR READ ONLY                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE UTIL_ENVRNMT CURSOR FOR                                    
MFA-TR*         SELECT  UT.PREMISE_NO                                           
MFA-TR*                ,UT.CODE_UTIL_TYPE                                       
MFA-TR*                ,UT.IC_NO                                                
MFA-TR*                ,UT.ACCOUNT_NO                                           
MFA-TR*          FROM   CSS_UTIL_ENVRNMT UT                                     
MFA-TR*          WHERE UT.ACCOUNT_NO  = :UT-ACCOUNT-NO                          
MFA-TR*            AND (EXISTS                                                  
MFA-TR*               (SELECT 1 FROM CSS_MTRD_ENVRNMT MN                        
MFA-TR*                 WHERE MN.ACCOUNT_NO = UT.ACCOUNT_NO                     
MFA-TR*                   AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE             
MFA-TR*                   AND MN.IC_NO = UT.IC_NO                               
MFA-TR*                   AND MN.METER_NO <> '         '                        
MFA-TR*                   AND MN.CODE_METER_STATUS = 'A' ))                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
              DECLARE  AR_CNTL_CURSOR CURSOR FOR                        
                SELECT AC.AMT_AR_DAY_00                                 
                      ,AC.AMT_AR_DAY_30                                 
                      ,AC.AMT_AR_DAY_60                                 
                      ,AC.AMT_AR_DAY_90                                 
                      ,AC.AMT_UNUSED_CR                                 
                      ,AC.AMT_TRAN_BALANCE                              
                      ,AC.TOT_SUMM_UNBILLED                             
                      ,AC.PYMT_PRIORITY_LVL                             
                      ,AC.ITEM_ID                                       
                FROM   CSS_AR_CNTL AC WITH(READUNCOMMITTED)                     
                WHERE  AC.ACCOUNT_NO  = :AC-ACCOUNT-NO                  
                ORDER BY  AC.PYMT_PRIORITY_LVL ASC,                     
                          AC.ITEM_ID DESC                               
T35434            FOR READ ONLY                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*       DECLARE  AR_CNTL_CURSOR CURSOR FOR                                
MFA-TR*         SELECT AC.AMT_AR_DAY_00                                         
MFA-TR*               ,AC.AMT_AR_DAY_30                                         
MFA-TR*               ,AC.AMT_AR_DAY_60                                         
MFA-TR*               ,AC.AMT_AR_DAY_90                                         
MFA-TR*               ,AC.AMT_UNUSED_CR                                         
MFA-TR*               ,AC.AMT_TRAN_BALANCE                                      
MFA-TR*               ,AC.TOT_SUMM_UNBILLED                                     
MFA-TR*               ,AC.PYMT_PRIORITY_LVL                                     
MFA-TR*               ,AC.ITEM_ID                                               
MFA-TR*         FROM   CSS_AR_CNTL AC                                           
MFA-TR*         WHERE  AC.ACCOUNT_NO  = :AC-ACCOUNT-NO                          
MFA-TR*         ORDER BY  AC.PYMT_PRIORITY_LVL ASC,                             
MFA-TR*                   AC.ITEM_ID DESC                                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
              DECLARE  CONTRACT_CURSOR CURSOR FOR                       
                SELECT CT.AMT_MO_PYMT                                   
                      ,CT.CODE_BILL_TYPE                                
                      ,CT.CNT_ITEM_ID                                   
                  FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                    
                 WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO            
                  AND  CT.CNT_STATUS_CD     = 'B'                       
                  AND  CT.CODE_BILL_TYPE IN ('A', 'B', 'C', 'E')        
T35434            FOR READ ONLY                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*       DECLARE  CONTRACT_CURSOR CURSOR FOR                               
MFA-TR*         SELECT CT.AMT_MO_PYMT                                           
MFA-TR*               ,CT.CODE_BILL_TYPE                                        
MFA-TR*               ,CT.CNT_ITEM_ID                                           
MFA-TR*           FROM CSS_CONTRACT CT                                          
MFA-TR*          WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO                    
MFA-TR*           AND  CT.CNT_STATUS_CD     = 'B'                               
MFA-TR*           AND  CT.CODE_BILL_TYPE IN ('A', 'B', 'C', 'E')                
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*     END-EXEC.                                                           
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  IN-ACCOUNT-NO                 PIC X(13).                     
                                                                        
                                                                        
       PROCEDURE DIVISION USING IN-ACCOUNT-NO.                          
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
                                                                        
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
                                                                        
           GOBACK.                                                      
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-INITIALIZE                                               *         
      *    SET UP SQL ERROR PROCESSING,                               *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
                                                                        
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
                                                                        
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
      *                                                                         
           EXEC SQL                                                     
                                                                        
A37061        DECLARE C1 CURSOR                              
A37061                          WITH ROWSET POSITIONING FOR             
               SELECT  :S-RETURN-CODE          AS RETURN_CODE           
                      ,:S-EPP-STATUS           AS EPP_STATUS            
                      ,:S-OTHR-BILLED-CHRG     AS OTHR_BILLED_CHRG      
                      ,:S-OTHR-NEXT-CHRG       AS OTHR_NEXT_CHARG       
                      ,:S-UTILITY-BALANCE      AS UTILITY_BALANCE       
                      ,:S-UTILITY-ARREARS      AS UTILITY_ARREARS       
                      ,:S-CURRENT-EPP-AMT      AS CURRENT_EPP_AMT       
                      ,:S-INCREASE-EPP-AMT     AS INCREASE_EPP_AMT      
                      ,:S-START-DATE           AS EPP_START_DATE        
                      ,:S-ANNIV-DATE           AS ANNIV_DATE            
                      ,:S-MONTHS-LEFT          AS MONTHS_LEFT           
                      ,:S-REVENUE-MONTH        AS REVENUE_MONTH         
                      ,:S-EPP-BILL-OPT         AS EPP_BILL_OPTION       
                      ,:S-ANNIV-FLAG           AS EPP_ANNIV_FLAG        
                      ,:S-OTHR-CHRG-FLAG       AS EPP_OTHR_CHRG_FLAG    
                      ,:S-LAST-UPDATE-TS       AS LAST_UPDATE_TS        
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                                     
MFA-TR*                         WITH ROWSET POSITIONING FOR                     
MFA-TR*        SELECT  :S-RETURN-CODE          AS RETURN_CODE                   
MFA-TR*               ,:S-EPP-STATUS           AS EPP_STATUS                    
MFA-TR*               ,:S-OTHR-BILLED-CHRG     AS OTHR_BILLED_CHRG              
MFA-TR*               ,:S-OTHR-NEXT-CHRG       AS OTHR_NEXT_CHARG               
MFA-TR*               ,:S-UTILITY-BALANCE      AS UTILITY_BALANCE               
MFA-TR*               ,:S-UTILITY-ARREARS      AS UTILITY_ARREARS               
MFA-TR*               ,:S-CURRENT-EPP-AMT      AS CURRENT_EPP_AMT               
MFA-TR*               ,:S-INCREASE-EPP-AMT     AS INCREASE_EPP_AMT              
MFA-TR*               ,:S-START-DATE           AS EPP_START_DATE                
MFA-TR*               ,:S-ANNIV-DATE           AS ANNIV_DATE                    
MFA-TR*               ,:S-MONTHS-LEFT          AS MONTHS_LEFT                   
MFA-TR*               ,:S-REVENUE-MONTH        AS REVENUE_MONTH                 
MFA-TR*               ,:S-EPP-BILL-OPT         AS EPP_BILL_OPTION               
MFA-TR*               ,:S-ANNIV-FLAG           AS EPP_ANNIV_FLAG                
MFA-TR*               ,:S-OTHR-CHRG-FLAG       AS EPP_OTHR_CHRG_FLAG            
MFA-TR*               ,:S-LAST-UPDATE-TS       AS LAST_UPDATE_TS                
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                                                                        
           IF IN-ACCOUNT-NO > SPACES                                    
              MOVE IN-ACCOUNT-NO             TO WS-PARM-ACCOUNT-NO      
              MOVE WS-PARM-ACCOUNT-NO        TO AC-ACCOUNT-NO           
                                                AT-ACCOUNT-NO           
                                                AR-ACCOUNT-NO           
                                                BG-ACCOUNT-NO           
                                                BH-ACCOUNT-NO           
                                                BU-ACCOUNT-NO           
                                                CT-ACCOUNT-NO           
                                                CZ-ACCOUNT-NO           
                                                PJ-ACCOUNT-NO           
                                                UT-ACCOUNT-NO           
                                                WS-ACCOUNT-NO           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE IN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE +100                      TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                       TO ACTIVE-PARAGRAPH.       
           PERFORM 2200-BUILD-RESULT           THRU 2200-EXIT.          
                                                                        
           ADD +1                            TO CTR-ROWS.               
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLS 7000-GET-ACCOUNT-INFO                                *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-GET-ACCOUNT-INFO       THRU 7000-EXIT.          
                                                                        
           MOVE AT-LAST-UPDATE-TS            TO S-LAST-UPDATE-TS        
                                                                        
           IF AT-REV-MTH-LST-NRML  > 0                                  
             MOVE AT-REV-MTH-LST-NRML        TO WS-REVENUE-MONTH        
           ELSE                                                         
             PERFORM 7800-SELECT-BILLING-DET   THRU 7800-EXIT           
           END-IF                                                       
                                                                        
           MOVE WS-REVENUE-MONTH             TO S-REVENUE-MONTH         
                                                                        
           IF WS-CODE-BUDGET = 'A'                                      
             PERFORM 5300-CHECK-MONTHS-LEFT    THRU 5300-EXIT           
             IF WS-MONTHS-LEFT = 12                                     
               PERFORM 5350-CHECK-FOR-ANNIV    THRU 5350-EXIT           
             ELSE                                                       
               MOVE 'N'                      TO S-ANNIV-FLAG            
             END-IF                                                     
           ELSE                                                         
             PERFORM 5400-CHECK-EPP-ELIGIBLE   THRU 5400-EXIT           
             IF WS-NOT-ELIG-FOR-EPP EQUAL WS-YES                        
                MOVE 'I'                     TO S-EPP-STATUS            
             ELSE                                                       
                MOVE 'E'                     TO S-EPP-STATUS            
                PERFORM 7400-OPEN-AR-CNTRL-CURSOR    THRU 7400-EXIT     
                PERFORM 7405-FETCH-AR-CNTRL-CURSOR   THRU 7405-EXIT     
                PERFORM 5200-SETUP-EPP-FIELDS        THRU 5200-EXIT     
                        UNTIL ( WS-ACTIVE-RETURN-CODE = NOT-FOUND )     
                                                                        
                PERFORM 7410-CLOSE-AR-CNTRL-CURSOR   THRU 7410-EXIT     
                                                                        
                PERFORM 5550-CALC-CNT-CHRGS          THRU 5550-EXIT     
                                                                        
                PERFORM 5600-CALC-PRJ-SHARE-AMT      THRU 5600-EXIT     
                                                                        
             END-IF                                                     
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2000A-MOVE-RESULT.                                            *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-EPP-BILL-OPT              TO S-EPP-BILL-OPT          
           MOVE WS-OTHR-CHRG-FLAG            TO S-OTHR-CHRG-FLAG        
                                                                        
           MOVE WS-NONEPP-ELIG-AMT           TO WS-NONEPP-ELIG-AMT-NUM. 
           MOVE WS-NONEPP-ELIG-AMT-NUM       TO WS-NONEPP-ELIG-AMT-EDIT.
           MOVE WS-NONEPP-ELIG-AMT-CHAR      TO S-OTHR-BILLED-CHRG.     
                                                                        
           MOVE WS-UTIL-RELT-BAL             TO WS-UTIL-RELT-BAL-NUM    
           MOVE WS-UTIL-RELT-BAL-NUM         TO WS-UTIL-RELT-BAL-EDIT   
           MOVE WS-UTIL-RELT-BAL-CHAR        TO S-UTILITY-BALANCE.      
                                                                        
           MOVE WS-UTL-RELT-ARS              TO WS-UTL-RELT-ARS-NUM     
           MOVE WS-UTL-RELT-ARS-NUM          TO WS-UTL-RELT-ARS-EDIT    
           MOVE WS-UTL-RELT-ARS-CHAR         TO S-UTILITY-ARREARS.      
                                                                        
           MOVE WS-OTHR-NEXT-CHRG            TO WS-OTHR-NEXT-CHRG-NUM   
           MOVE WS-OTHR-NEXT-CHRG-NUM        TO WS-OTHR-NEXT-CHRG-EDIT  
           MOVE WS-OTHR-NEXT-CHRG-CHAR       TO S-OTHR-NEXT-CHRG.       
                                                                        
           IF WS-CODE-BUDGET = 'A'                                      
              MOVE BU-AMT-MO-PYMT            TO WS-CURRENT-EPP-AMT      
              COMPUTE WS-INCREASE-EPP-AMT = WS-CURRENT-EPP-AMT * 1.2    
              COMPUTE WS-INCREASE-EPP-AMT-RND ROUNDED =                 
                                            WS-INCREASE-EPP-AMT         
                                                                        
              IF WS-INCREASE-EPP-AMT > WS-INCREASE-EPP-AMT-RND          
                COMPUTE WS-INCREASE-EPP-AMT-RND =                       
                                          WS-INCREASE-EPP-AMT-RND + 1   
              END-IF                                                    
           ELSE                                                         
              MOVE ZEROES                    TO WS-CURRENT-EPP-AMT      
              MOVE ZEROES                    TO WS-INCREASE-EPP-AMT-RND 
           END-IF                                                       
                                                                        
           MOVE WS-CURRENT-EPP-AMT           TO WS-CURRENT-EPP-AMT-NUM  
           MOVE WS-CURRENT-EPP-AMT-NUM       TO WS-CURRENT-EPP-AMT-EDIT 
           MOVE WS-CURRENT-EPP-AMT-CHAR      TO S-CURRENT-EPP-AMT.      
                                                                        
           MOVE WS-INCREASE-EPP-AMT-RND      TO WS-INCREASE-EPP-AMT-NUM 
           MOVE WS-INCREASE-EPP-AMT-NUM      TO WS-INCREASE-EPP-AMT-EDIT
           MOVE WS-INCREASE-EPP-AMT-CHAR     TO S-INCREASE-EPP-AMT.     
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5000-CHECK-BILLING                                             *        
      *                                                                *        
      * LOADING UTILITY TABLE.                                         *        
      ******************************************************************        
       5000-CHECK-BILLING.                                              
                                                                        
           MOVE AT-PREMISE-NO                TO BI-PREMISE-NO.          
           MOVE AT-ACCOUNT-NO                TO BG-ACCOUNT-NO.          
                                                                        
           PERFORM 7300-OPEN-UTIL-ENVRNMT      THRU  7300-EXIT.         
           PERFORM 7305-FETCH-UTIL-ENVRNMT     THRU  7305-EXIT.         
                                                                        
           PERFORM 7100-CALCULATE-DATE         THRU 7100-EXIT.          
                                                                        
           PERFORM 5100-LOAD-ALL-UTIL-ENVRNMT  THRU 5100-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
                       OR WS-NOT-ELIG-FOR-EPP  EQUAL WS-YES             
                                                                        
           PERFORM 7310-CLOSE-UTIL-ENVRNMT     THRU  7310-EXIT.         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-LOAD-ALL-UTIL-ENVRNMT                                     *        
      *                                                                *        
      ******************************************************************        
       5100-LOAD-ALL-UTIL-ENVRNMT.                                      
                                                                        
           PERFORM 7200-GET-SUFFICIENT-ROWS    THRU  7200-EXIT.         
                                                                        
           PERFORM 7305-FETCH-UTIL-ENVRNMT     THRU  7305-EXIT.         
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-SETUP-EPP-FIELDS.                                         *        
      *                                                                *        
      *    FIRST TIME , SETTING UP AN EPP                              *        
      ******************************************************************        
       5200-SETUP-EPP-FIELDS.                                           
                                                                        
           IF ( AC-ITEM-ID = 0  AND                                     
               (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-NSC OR            
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-LPC OR            
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-UTE OR            
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-UTG ))            
           OR ( AC-ITEM-ID > 0  AND                                     
                AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-RCC AND           
                ( AC-AMT-AR-DAY-00                                      
                  + AC-AMT-AR-DAY-30                                    
                  + AC-AMT-AR-DAY-60                                    
                  + AC-AMT-AR-DAY-90                                    
                  + AC-AMT-UNUSED-CR ) > 0 )                            
                                                                        
              IF AC-ITEM-ID = 0                                         
                 COMPUTE WS-UTIL-RELT-BAL  =                            
                                             WS-UTIL-RELT-BAL           
                                           + AC-AMT-AR-DAY-00           
                                           + AC-AMT-AR-DAY-30           
                                           + AC-AMT-AR-DAY-60           
                                           + AC-AMT-AR-DAY-90           
                                           + AC-AMT-UNUSED-CR           
                                                                        
                 IF AC-TOT-SUMM-UNBILLED GREATER THAN ZEROES            
                    ADD AC-TOT-SUMM-UNBILLED TO WS-UTIL-RELT-BAL        
                 END-IF                                                 
                                                                        
              ELSE                                                      
                 COMPUTE WS-UTIL-RELT-BAL     =                         
                                                WS-UTIL-RELT-BAL        
                                              + AC-AMT-TRAN-BALANCE     
              END-IF                                                    
                                                                        
              COMPUTE WS-UTL-RELT-ARS = WS-UTL-RELT-ARS                 
                                              + AC-AMT-AR-DAY-30        
                                              + AC-AMT-AR-DAY-60        
                                              + AC-AMT-AR-DAY-90        
                                                                        
              PERFORM 7405-FETCH-AR-CNTRL-CURSOR   THRU 7405-EXIT       
           ELSE                                                         
              PERFORM 5250-CALC-NONEPP-ELIG-CHRGS  THRU 5250-EXIT       
              PERFORM 7405-FETCH-AR-CNTRL-CURSOR   THRU 7405-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-UTIL-RELT-BAL <= 0 OR WS-CODE-BANK-EFT = 'A'           
                                    OR AT-TOTAL-AR-BALANCE < 0          
              MOVE 'N'                       TO WS-EPP-BILL-OPT         
           ELSE                                                         
              MOVE 'B'                       TO WS-EPP-BILL-OPT         
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5250-CALC-NONEPP-ELIG-CHRGS.                                   *        
      *                                                                *        
      *   CALCULATE OTHER CHARGES                                      *        
      ******************************************************************        
       5250-CALC-NONEPP-ELIG-CHRGS.                                     
           IF AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-RCC                 
              NEXT SENTENCE                                             
           ELSE                                                         
              IF AC-PYMT-PRIORITY-LVL < 50  OR                          
                 (AC-PYMT-PRIORITY-LVL > 50 AND                         
                 AC-ITEM-ID > 0)                                        
                 COMPUTE WS-NONEPP-ELIG-AMT = WS-NONEPP-ELIG-AMT        
                                    + AC-AMT-AR-DAY-00                  
                                    + AC-AMT-AR-DAY-30                  
                                    + AC-AMT-AR-DAY-60                  
                                    + AC-AMT-AR-DAY-90                  
                                    + AC-AMT-UNUSED-CR                  
                                                                        
                 IF AC-TOT-SUMM-UNBILLED GREATER THAN ZEROES            
                    ADD AC-TOT-SUMM-UNBILLED TO WS-NONEPP-ELIG-AMT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
                                                                        
              IF WS-NONEPP-ELIG-AMT NOT EQUAL ZERO                      
                MOVE 'Y'                    TO WS-OTHR-CHRG-FLAG        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5300-CHECK-MONTHS-LEFT.                                        *        
      *     DETERMINES THE MONTHS LEFT IN THE PLAN                     *        
      ******************************************************************        
       5300-CHECK-MONTHS-LEFT.                                          
                                                                        
           PERFORM 7900-COMPUTE-FIELDS       THRU 7900-EXIT.            
                                                                        
           MOVE WS-MONTHS-LEFT               TO S-MONTHS-LEFT.          
                                                                        
           IF WS-MONTHS-LEFT < 12                                       
              MOVE 'C'                       TO S-EPP-STATUS            
           ELSE                                                         
              PERFORM 7990-CHECK-CURRENT-EPP   THRU 7990-EXIT           
              IF WS-EPP-ACCT-WITH-ANNIV = 'Y'                           
                MOVE 'C'                     TO S-EPP-STATUS            
              ELSE                                                      
                MOVE 'N'                     TO S-EPP-STATUS            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5350-CHECK-FOR-ANNIV                                           *        
      ******************************************************************        
       5350-CHECK-FOR-ANNIV.                                            
                                                                        
           PERFORM 7960-GET-LAST-BILLED-DATE   THRU 7960-EXIT.          
A01120     IF WS-DATE-BILLED-00 NOT = SPACES                            
               PERFORM 7970-CHECK-ACCT-FOR-ANNIV   THRU 7970-EXIT       
                                                                        
               IF WS-DATE-BILLED-00 = AT-DATE-BILL-DAY-00               
                                AND WS-ACCT-ANNIV-FLAG = 'Y'            
                  PERFORM 7980-CHECK-FOR-PYMTS     THRU 7980-EXIT       
                  IF WS-PYMT-FOUND = 'Y'                                
                    MOVE 'N'                     TO S-ANNIV-FLAG        
                  ELSE                                                  
                    MOVE +000                    TO S-RETURN-CODE       
                    MOVE 'Y'                     TO S-ANNIV-FLAG        
                  END-IF                                                
               END-IF                                                   
A01120     END-IF.                                                      
                                                                        
       5350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5400-CHECK-EPP-ELIGIBLE.                                       *        
      *     ACCOUNT IS NOT ELIGIBLE TO SETUP EPP WHEN                  *        
      *       1. NOT AN ACTIVE ACCOUNT.                                *        
      *       2. DPP ACCOUNT.                                          *        
      *       3. DFA ACCOUNT.                                          *        
      *       4. MEDICAL CERTIFICATE.                                  *        
      *       5. MAJOR ACCOUNTS.                                       *        
      *       6. ACCOUNTS WITH NO UTIL RECEIVABLES.                    *        
      *       7. STA ACCOUNTS.                                         *        
      *       8. ACCOUNTS THAT ARE MASTER/SUB.                         *        
      *       9. BANKRUPT ACCOUNTS.                                    *        
      *       10.CREDIT GROUP OTHER THAN ARREARS AND EXEMPT.           *        
      *       11.FIXED INCOME ACCOUNTS.                                *        
      *       12.ACCTS WHOSE XFER FROM IS NOT FINALLED.                *        
      *       13.XFER TO ACCOUNTS.                                     *        
      *       14.TOU ACCOUNTS.                                         *        
      *       13.INDUSTRIAL(SCEG & PSNC) & COMMERCIAL (SCEG) ACCOUNT.  *        
      *       16.CASH ONLY CUSTOMERS.                                  *        
      *       17.EPP OFFER IS ACTIVE(BILLING)                          *        
      *       18.ARREARS ACCOUNT.                                      *        
      *       19.ACCOUNTS THAT DO NOT HAVE 12 MONTHS BILLING DATA.     *        
P00251*       20.COGENERATION ACCOUNTS                                          
      ******************************************************************        
       5400-CHECK-EPP-ELIGIBLE.                                         
                                                                        
           MOVE 'N'                          TO WS-NOT-ELIG-FOR-EPP.    
                                                                        
           EVALUATE TRUE                                                
           WHEN AT-CODE-ACCT-STAT  NOT EQUAL 'A'                        
              MOVE 'Y'                       TO WS-NOT-ELIG-FOR-EPP     
                                                                        
           WHEN WS-CODE-DPP-ACCT   EQUAL 'A'                            
              MOVE 'Y'                       TO WS-NOT-ELIG-FOR-EPP     
                                                                        
           WHEN WS-CODE-DFA-ACCT   EQUAL 'A'                            
              MOVE 'Y'                       TO WS-NOT-ELIG-FOR-EPP     
                                                                        
           WHEN WS-CODE-MEDICAL    EQUAL 'A'                            
              MOVE 'Y'                       TO WS-NOT-ELIG-FOR-EPP     
                                                                        
           WHEN AT-CODE-MAJOR-ACCT EQUAL 'Y'                            
              MOVE 'Y'                       TO WS-NOT-ELIG-FOR-EPP     
                                                                        
           WHEN WS-CODE-UTL = SPACE AND WS-CODE-BUDGET = SPACE          
              MOVE 'Y'                       TO WS-NOT-ELIG-FOR-EPP     
                                                                        
           WHEN WS-CODE-STA-ACCT EQUAL 'A'                              
              MOVE 'Y'                       TO WS-NOT-ELIG-FOR-EPP     
                                                                        
           WHEN (AT-MST-SUB-ACCT-IND = 'M' OR AT-MST-SUB-ACCT-IND = 'S')
                 MOVE 'Y'                    TO WS-NOT-ELIG-FOR-EPP     
                                                                        
           WHEN (AT-BANKRUPTCY-IND = 'B' OR AT-BANKRUPTCY-IND = 'J')    
              MOVE 'Y'                       TO WS-NOT-ELIG-FOR-EPP     
                                                                        
           WHEN AT-BILL-CYCLE-CHG-CD =  'F'                             
              MOVE 'Y'                       TO WS-NOT-ELIG-FOR-EPP     
A02824     WHEN OTHER                                                   
A02824        MOVE 'N'                       TO WS-SECURED-RATE-FLAG    
A02824        PERFORM 7075-CHK-SECURE-RATE-IC-EXISTS  THRU  7075-EXIT   
A02824        IF WS-SECURED-RATE-FLAG  =  'Y'                           
A02824           MOVE 'Y'                    TO WS-NOT-ELIG-FOR-EPP     
A02824        END-IF                                                    
           END-EVALUATE.                                                
                                                                        
           IF AT-ACCT-XFER-FROM-LST NOT EQUAL ZERO                      
                      AND WS-NOT-ELIG-FOR-EPP EQUAL 'N'                 
              PERFORM 7700-CHECK-FINAL-BILL   THRU 7700-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-NOT-ELIG-FOR-EPP EQUAL 'N'                             
             IF AT-COMPANY-NO = '26' AND AT-CREDIT-GROUP NOT = 'C'      
                MOVE 'Y'                     TO WS-NOT-ELIG-FOR-EPP     
ACT219       ELSE IF AT-CREDIT-GROUP NOT = 'A' AND 'C' AND 'N'          
                MOVE 'Y'                     TO WS-NOT-ELIG-FOR-EPP     
             END-IF                                                     
           END-IF
           END-IF.                                                      
                                                                        
           IF WS-NOT-ELIG-FOR-EPP EQUAL 'N'                             
              PERFORM 7999-SELECT-TRANSFER-IND                          
                           THRU 7999-SELECT-TRANSFER-IND-EXIT           
              IF AT-ACCT-XFER-TO > ZERO                                 
                MOVE 'Y'                     TO WS-NOT-ELIG-FOR-EPP     
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-NOT-ELIG-FOR-EPP EQUAL 'N'                             
              PERFORM 7600-CHECK-FOR-TOU-ACCT  THRU 7600-EXIT           
           END-IF.                                                      
                                                                        
P00251     IF WS-NOT-ELIG-FOR-EPP EQUAL 'N'                             
P00251        PERFORM 7650-CHECK-FOR-COGEN-ACCT  THRU 7650-EXIT         
P00251     END-IF.                                                      
                                                                        
           IF WS-NOT-ELIG-FOR-EPP EQUAL 'N'                             
A37061      IF ((AT-ACCOUNT-TYPE-CODE = 'I' AND AT-COMPANY-NO = '26') OR
A37061        (AT-ACCOUNT-TYPE-CODE NOT = 'R' AND AT-COMPANY-NO = '01'))
A37061        MOVE 'Y'                     TO  WS-NOT-ELIG-FOR-EPP      
A37061      END-IF                                                      
           END-IF.                                                      
           IF WS-NOT-ELIG-FOR-EPP EQUAL 'N'                             
              PERFORM 7750-SELECT-CREDIT-PROFILE THRU 7750-EXIT         
           END-IF.                                                      
                                                                        
           IF WS-NOT-ELIG-FOR-EPP EQUAL 'N'                             
              PERFORM 7760-CHK-ACTIVE-EPP-OFFER   THRU 7760-EXIT        
           END-IF.                                                      
                                                                        
           IF WS-NOT-ELIG-FOR-EPP EQUAL 'N'                             
              PERFORM 5500-CHECK-FOR-UTIL-ARREARS THRU 5500-EXIT        
              COMPUTE WS-TOTAL-ARREARS = WS-AMT-ARREARS-UTL             
                                    + WS-AMT-ARREARS-NONUTL             
              IF WS-TOTAL-ARREARS > 0                                   
                MOVE 'Y'                     TO WS-NOT-ELIG-FOR-EPP     
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-NOT-ELIG-FOR-EPP EQUAL 'N'                             
              PERFORM 5000-CHECK-BILLING       THRU 5000-EXIT           
           END-IF.                                                      
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04220000
      *  5500-CHECK-FOR-UTIL-ARREARS                                   *04230000
      ******************************************************************04240000
       5500-CHECK-FOR-UTIL-ARREARS.                                     
                                                                        
           MOVE 'Y'                          TO CALC-ARREARS-SW.        
                                                                        
           MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
           MOVE CWS00068-FIELDS            TO WS-CWS68-FIELDS-LK.       
           MOVE WS-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT-LK. 
           MOVE DCLCSS-ACCOUNT             TO WS-DCLCSS-ACCOUNT-LK.     
           MOVE ABEND-FILE                 TO WS-ABEND-FILE-LK.         
           MOVE WS-RETURN-CODE             TO WS-RETURN-CODE-LK.        
           MOVE SPACES                     TO ABEND-FUNCTION .          
           PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT.              
           MOVE WS-RETURN-CODE             TO WS-ACTIVE-RETURN-CODE,    
                                              SQLCODE.                  
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04220000
      *                                                                *04220000
      *  5550-CALC-CNT-CHRGS                                           *04230000
      ******************************************************************04240000
       5550-CALC-CNT-CHRGS.                                             
                                                                        
           PERFORM 7500-OPEN-CNT-CSR           THRU 7500-EXIT           
                                                                        
           PERFORM 7505-FETCH-CNT-CSR           THRU 7505-EXIT          
                                                                        
           PERFORM 5560-PROCESS-CNT-CSR        THRU 5560-EXIT           
                          UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND)     
                                                                        
           PERFORM 7510-CLOSE-CNT-CSR          THRU 7510-EXIT.          
                                                                        
       5550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04220000
      *                                                                *04220000
      *  5560-PROCESS-CNT-CSR                                          *04230000
      ******************************************************************04240000
       5560-PROCESS-CNT-CSR.                                            
                                                                        
           MOVE CT-CODE-BILL-TYPE             TO WS-CODE-BILL-TYPE.     
                                                                        
            IF WS-CODE-BILL-TYPE EQUAL 'A' OR 'C'                       
                                                                        
                PERFORM 7530-GET-AR-CNTL-AMT   THRU 7530-EXIT           
                                                                        
                COMPUTE WS-00-30-60-90-DAY-AMT = AC-AMT-TRAN-BALANCE -  
                             ( AC-AMT-AR-DAY-00 + AC-AMT-AR-DAY-30 +    
                               AC-AMT-AR-DAY-60 + AC-AMT-AR-DAY-90 +    
                               AC-TOT-SUMM-UNBILLED )                   
                                                                        
                COMPUTE WS-FINAL-INSTLMNT-DTMNT ROUNDED =               
                               WS-00-30-60-90-DAY-AMT / CT-AMT-MO-PYMT  
                                                                        
                EVALUATE TRUE                                           
                  WHEN WS-FINAL-INSTLMNT-DTMNT <= 0                     
                     CONTINUE                                           
                  WHEN WS-FINAL-INSTLMNT-DTMNT = 1                      
                     COMPUTE WS-OTHR-NEXT-CHRG =                        
                          WS-OTHR-NEXT-CHRG + WS-00-30-60-90-DAY-AMT    
                  WHEN WS-FINAL-INSTLMNT-DTMNT >= 2                     
                     COMPUTE WS-OTHR-NEXT-CHRG =                        
                          WS-OTHR-NEXT-CHRG + CT-AMT-MO-PYMT            
                END-EVALUATE                                            
                                                                        
            END-IF.                                                     
                                                                        
            IF WS-CODE-BILL-TYPE EQUAL 'E'                              
                COMPUTE WS-OTHR-NEXT-CHRG =                             
                          WS-OTHR-NEXT-CHRG - CT-AMT-MO-PYMT            
            ELSE IF WS-CODE-BILL-TYPE EQUAL 'B'                         
                COMPUTE WS-OTHR-NEXT-CHRG =                             
                          WS-OTHR-NEXT-CHRG + CT-AMT-MO-PYMT            
            END-IF
            END-IF.                                                     
                                                                        
           PERFORM 7505-FETCH-CNT-CSR           THRU 7505-EXIT.         
                                                                        
       5560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04220000
      *                                                                *04220000
      * 5600-CALC-PRJ-SHARE-AMT                                        *04230000
      ******************************************************************04240000
       5600-CALC-PRJ-SHARE-AMT.                                         
                                                                        
           PERFORM 7520-GET-PRJ-SHARE-AMT      THRU 7520-EXIT           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             COMPUTE WS-OTHR-NEXT-CHRG =                                
                       WS-OTHR-NEXT-CHRG + WS-TOT-PROJ-SHR-AMT          
           END-IF.                                                      
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-GET-ACCOUNT-INFO.                                         *        
      ******************************************************************        
       7000-GET-ACCOUNT-INFO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT                              
                    ,AT.CODE_MAJOR_ACCT                                 
                    ,AT.PREMISE_NO                                      
                    ,AT.ACCT_XFER_FROM_LST                              
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.BILL_CYCLE                                      
                    ,AT.BILL_CYCLE_CHG_CD                               
                    ,AT.MST_SUB_ACCT_IND                                
                    ,AT.BANKRUPTCY_IND                                  
                    ,AT.CREDIT_GROUP                                    
                    ,AT.CODE_ACCT_USAGE                                 
                    ,AT.COMPANY_NO                                      
                    ,AT.NOTICE_EXEMPT_CD                                
                    ,AT.CODE_DISC_OK                                    
                    ,AT.DATE_BILL_DAY_00                                
                    ,AT.DATE_BILL_DAY_30                                
                    ,AT.DATE_BILL_DAY_60                                
                    ,AT.DATE_BILL_DAY_90                                
                    ,AT.IVR_EXEMPT_CD                                   
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                    ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
A37061              ,AT.ACCOUNT_TYPE_CODE                               
                INTO :AT-CODES-DATA-PRESENT                             
                    ,:AT-CODE-MAJOR-ACCT                                
                    ,:AT-PREMISE-NO                                     
                    ,:AT-ACCT-XFER-FROM-LST                             
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-REV-MTH-LST-NRML :WS-REVENUE-MONTH-NULL         
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-BILL-CYCLE-CHG-CD                              
                    ,:AT-MST-SUB-ACCT-IND                               
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-CODE-ACCT-USAGE                                
                    ,:AT-COMPANY-NO                                     
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-DATE-BILL-DAY-00 :WS-NULL-IND-3                 
                    ,:AT-DATE-BILL-DAY-30 :WS-NULL-IND-4                 
                    ,:AT-DATE-BILL-DAY-60 :WS-NULL-IND-5                 
                    ,:AT-DATE-BILL-DAY-90 :WS-NULL-IND-6                 
                    ,:AT-IVR-EXEMPT-CD                                  
                    ,:AT-LAST-UPDATE-TS                                 
                    ,:WS-CURRENT-DATE                                   
A37061              ,:AT-ACCOUNT-TYPE-CODE                              
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.CODE_MAJOR_ACCT                                         
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.ACCT_XFER_FROM_LST                                      
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,AT.BILL_CYCLE_CHG_CD                                       
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                        
MFA-TR*             ,AT.BANKRUPTCY_IND                                          
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.CODE_ACCT_USAGE                                         
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.DATE_BILL_DAY_30                                        
MFA-TR*             ,AT.DATE_BILL_DAY_60                                        
MFA-TR*             ,AT.DATE_BILL_DAY_90                                        
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,AT.LAST_UPDATE_TS                                          
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-CODE-MAJOR-ACCT                                        
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-ACCT-XFER-FROM-LST                                     
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-REV-MTH-LST-NRML:WS-REVENUE-MONTH-NULL                 
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-BILL-CYCLE-CHG-CD                                      
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-CODE-ACCT-USAGE                                        
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00:WS-NULL-IND-3                         
MFA-TR*             ,:AT-DATE-BILL-DAY-30:WS-NULL-IND-4                         
MFA-TR*             ,:AT-DATE-BILL-DAY-60:WS-NULL-IND-5                         
MFA-TR*             ,:AT-DATE-BILL-DAY-90:WS-NULL-IND-6                         
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*             ,:WS-CURRENT-DATE                                           
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-IND-3 EQUAL -1                                 
                 MOVE SPACES TO AT-DATE-BILL-DAY-00                     
              END-IF                                                    
                                                                        
              IF WS-NULL-IND-4 EQUAL -1                                 
                 MOVE SPACES TO AT-DATE-BILL-DAY-30                     
              END-IF                                                    
                                                                        
              IF WS-NULL-IND-5 EQUAL -1                                 
                 MOVE SPACES TO AT-DATE-BILL-DAY-60                     
              END-IF                                                    
                                                                        
              IF WS-NULL-IND-6 EQUAL -1                                 
                 MOVE SPACES TO AT-DATE-BILL-DAY-90                     
              END-IF                                                    
                                                                        
              MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT   
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02824******************************************************************        
A02824* CHECK IF ANY IC IS ON SECURED RATE FOR A GIVEN ACCOUNT         *        
A02824******************************************************************        
A02824*                                                                         
A02824 7075-CHK-SECURE-RATE-IC-EXISTS.                                  
A02824*                                                                         
A02824     EXEC SQL                                                     
A02824       SELECT TOP(1) 'Y'                                               
A02824         INTO   :WS-SECURED-RATE-FLAG                             
A02824         FROM   CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)               
A02824               ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
A02824        WHERE  UT.ACCOUNT_NO       =  :UT-ACCOUNT-NO              
A02824          AND  UT.CODE_UTIL_TYPE  IN  ('E', 'G')                  
A02824          AND  RD.CODE_UTIL_TYPE   =  UT.CODE_UTIL_TYPE           
A02824          AND  RD.RATE_PLAN_NO     =  UT.RATE_PLAN_NO             
A02824          AND  RD.SECURED_RATE_FL  =  'Y'                         
A02824                                       
A02824                                                      
A02824     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT   'Y'                                                       
MFA-TR*        INTO   :WS-SECURED-RATE-FLAG                                     
MFA-TR*        FROM   CSS_UTIL_ENVRNMT   UT                                     
MFA-TR*              ,CSS_RATE_PLAN_DESC RD                                     
MFA-TR*       WHERE  UT.ACCOUNT_NO       =  :UT-ACCOUNT-NO                      
MFA-TR*         AND  UT.CODE_UTIL_TYPE  IN  ('E', 'G')                          
MFA-TR*         AND  RD.CODE_UTIL_TYPE   =  UT.CODE_UTIL_TYPE                   
MFA-TR*         AND  RD.RATE_PLAN_NO     =  UT.RATE_PLAN_NO                     
MFA-TR*         AND  RD.SECURED_RATE_FL  =  'Y'                                 
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7075                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02824*                                                                         
A02824     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A02824*                                                                         
A02824     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02824        MOVE +000                      TO S-RETURN-CODE           
A02824     ELSE                                                         
A02824        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A02824        MOVE '7075'                    TO ACTIVE-PARAGRAPH        
A02824        MOVE 'SELECT'                  TO ABEND-FUNCTION          
A02824        MOVE 'CSS_UTIL_ENVRMNT'        TO TABLE-1                 
A02824        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
A02824        MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
A02824        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A02824        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A02824     END-IF.                                                      
A02824*                                                                         
A02824 7075-EXIT.                                                       
A02824     EXIT.                                                        
A02824*                                                                 41260000
      *****************************************************************         
      * 7100-CALCULATE-DATE.                                          *         
      * CALCULATE WS-FROM-DATE AND WS-TO-DATE TO BE USED IN THE       *         
      * SELECT TO DETERMINE SUFFICIENT DATA OR NOT                    *         
      *****************************************************************         
       7100-CALCULATE-DATE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT MAX(BG.REVENUE_MONTH)                             
                 INTO :WS-TO-REV-MONTH :WS-TO-REV-MONTH-NI              
               FROM CSS_BILLING_HDR   BI WITH(READUNCOMMITTED)                  
                   ,CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                  
              WHERE BI.PREMISE_NO         = :BI-PREMISE-NO              
                AND BI.PREMISE_NO         = BG.PREMISE_NO               
                AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO               
                AND BG.CODE_BILL_ITM_TYPE = 'C'                         
                AND BG.CODE_BILL_ITM_IND  = 'A'                         
                AND BG.CODE_BILL_CALC     = 'A'                         
                AND BG.CODE_UTIL_TYPE     IN ('E','G','U')              
                AND BI.BILL_NO            = BG.BILL_NO                  
                AND BI.DATE_BILLED  BETWEEN                             
                    (DATEADD( MONTH, -2, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )) AND             
                    IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                             
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(BG.REVENUE_MONTH)                                     
MFA-TR*          INTO :WS-TO-REV-MONTH :WS-TO-REV-MONTH-NI                      
MFA-TR*        FROM CSS_BILLING_HDR   BI                                        
MFA-TR*            ,CSS_BILLING_DET   BG                                        
MFA-TR*       WHERE BI.PREMISE_NO         = :BI-PREMISE-NO                      
MFA-TR*         AND BI.PREMISE_NO         = BG.PREMISE_NO                       
MFA-TR*         AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                       
MFA-TR*         AND BG.CODE_BILL_ITM_TYPE = 'C'                                 
MFA-TR*         AND BG.CODE_BILL_ITM_IND  = 'A'                                 
MFA-TR*         AND BG.CODE_BILL_CALC     = 'A'                                 
MFA-TR*         AND BG.CODE_UTIL_TYPE     IN ('E','G','U')                      
MFA-TR*         AND BI.BILL_NO            = BG.BILL_NO                          
MFA-TR*         AND BI.DATE_BILLED  BETWEEN                                     
MFA-TR*             (DATE(:WS-CURRENT-DATE) - 2 MONTHS) AND                     
MFA-TR*             :WS-CURRENT-DATE                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE BI-PREMISE-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           IF WS-TO-REV-MONTH-NI < 0                                    
              STRING WS-CURRENT-DATE(1:4) WS-CURRENT-DATE(6:2)          
                     DELIMITED BY SIZE INTO WS-TO-REV-MONTH-C           
              MOVE WS-TO-REV-MONTH-C         TO WS-TO-REV-MONTH         
           ELSE                                                         
              MOVE  WS-TO-REV-MONTH          TO WS-TO-REV-MONTH-C       
           END-IF                                                       
                                                                        
           MOVE WS-TO-REV-MONTH-C            TO  WS-MAX-REV-MONTH.      
                                                                        
           STRING WS-TO-REV-MONTH-C(1:4) '-'                            
                  WS-TO-REV-MONTH-C(5:2) '-01'                          
                  DELIMITED BY SIZE INTO WS-MAX-REV-DATE.               
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              CAST(DATEADD( MONTH, -11, IIF(TRY_CONVERT(DATE, 
                                                       :WS-MAX-REV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-REV-DATE
              ) <> 0) OR (LEN(:WS-MAX-REV-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-MAX-REV-DATE
              ), CONVERT(DATE, :WS-MAX-REV-DATE) ) ) AS CHAR(10))
            INTO
              :WS-MAX-REV-DATE-TMP    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-MAX-REV-DATE-TMP =                                        
MFA-TR*                    CHAR(DATE(:WS-MAX-REV-DATE) -  11 MONTHS)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-MAX-REV-DATE-TMP       TO WS-MAX-REV-DATE         
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
T35434        MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'MAX REVENUE DATE'        TO TABLE-ELEMENT-1         
              MOVE WS-MAX-REV-DATE           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           STRING WS-MAX-REV-DATE(1:4)                                  
                  WS-MAX-REV-DATE(6:2)                                  
                  DELIMITED BY SIZE INTO WS-FROM-REV-MONTH-C.           
           MOVE WS-FROM-REV-MONTH-C          TO WS-FROM-REV-MONTH.      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-GET-SUFFICIENT-ROWS                                       *        
      ******************************************************************        
       7200-GET-SUFFICIENT-ROWS.                                        
                                                                        
           MOVE UT-CODE-UTIL-TYPE            TO BG-CODE-UTIL-TYPE       
           MOVE UT-IC-NO                     TO BG-IC-NO                
                                                                        
           EXEC SQL                                                     
                SELECT COUNT(*)                                         
                INTO :WS-UTIL-BILL-COUNT                                
                FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
                    ,CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO             
                  AND BI.BILL_NO            = BG.BILL_NO                
                  AND BG.CODE_BILL_ITM_TYPE = 'C'                       
                  AND BG.CODE_BILL_ITM_IND  = 'A'                       
                  AND BG.CODE_BILL_CALC     = 'A'                       
                  AND BI.BILL_NO            = BG.BILL_NO                
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND BG.IC_NO              = :BG-IC-NO                 
               AND (BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MONTH         
                                         AND :WS-TO-REV-MONTH)          
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*         INTO :WS-UTIL-BILL-COUNT                                        
MFA-TR*         FROM CSS_BILLING_HDR BI                                         
MFA-TR*             ,CSS_BILLING_DET BG                                         
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                     
MFA-TR*           AND BI.BILL_NO            = BG.BILL_NO                        
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*           AND BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*           AND BG.CODE_BILL_CALC     = 'A'                               
MFA-TR*           AND BI.BILL_NO            = BG.BILL_NO                        
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND BG.IC_NO              = :BG-IC-NO                         
MFA-TR*        AND (BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MONTH                 
MFA-TR*                                  AND :WS-TO-REV-MONTH)                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-UTIL-BILL-COUNT  < 12                               
                 MOVE 'Y'                      TO WS-NOT-ELIG-FOR-EPP   
      *          IF WS-UTIL-BILL-COUNT  >= 09                                   
      *             PERFORM 7825-CHECK-FOR-HTGCLG-ROWS  THRU                    
      *                                                 7825-EXIT               
      *          ELSE                                                           
      *             MOVE 'Y'            TO WS-NOT-ELIG-FOR-EPP                  
      *          END-IF                                                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-OPEN-UTIL-ENVRNMT                                         *        
      ******************************************************************        
       7300-OPEN-UTIL-ENVRNMT.                                          
           EXEC SQL                                                     
                OPEN UTIL_ENVRNMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRMNT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7305-FETCH-UTIL-ENVRNMT                                        *        
      ******************************************************************        
       7305-FETCH-UTIL-ENVRNMT.                                         
           EXEC SQL                                                     
                FETCH UTIL_ENVRNMT INTO                                 
                       :UT-PREMISE-NO                                   
                      ,:UT-CODE-UTIL-TYPE                               
                      ,:UT-IC-NO                                        
                      ,:UT-ACCOUNT-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7305'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRMNT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7305-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-CLOSE-UTIL-ENVRNMT                                        *        
      ******************************************************************        
       7310-CLOSE-UTIL-ENVRNMT.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE UTIL_ENVRNMT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRMNT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-OPEN-AR-CNTRL-CURSOR                                      *        
      ******************************************************************        
       7400-OPEN-AR-CNTRL-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN AR_CNTL_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT
           END-IF.          
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7405-FETCH-AR-CNTRL-CURSOR                                     *        
      ******************************************************************        
       7405-FETCH-AR-CNTRL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                FETCH  AR_CNTL_CURSOR                                   
                INTO  :AC-AMT-AR-DAY-00                                 
                     ,:AC-AMT-AR-DAY-30                                 
                     ,:AC-AMT-AR-DAY-60                                 
                     ,:AC-AMT-AR-DAY-90                                 
                     ,:AC-AMT-UNUSED-CR                                 
                     ,:AC-AMT-TRAN-BALANCE                              
                     ,:AC-TOT-SUMM-UNBILLED                             
                     ,:AC-PYMT-PRIORITY-LVL                             
                     ,:AC-ITEM-ID                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7405'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7405-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-CLOSE-AR-CNTRL-CURSOR.                                    *        
      ******************************************************************        
       7410-CLOSE-AR-CNTRL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE AR_CNTL_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7410'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-OPEN-CNT-CSR                                              *        
      ******************************************************************        
       7500-OPEN-CNT-CSR.                                               
                                                                        
           EXEC SQL                                                     
              OPEN CONTRACT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7505-FETCH-CNT-CSR                                             *        
      ******************************************************************        
       7505-FETCH-CNT-CSR.                                              
                                                                        
           EXEC SQL                                                     
              FETCH CONTRACT_CURSOR                                     
               INTO :CT-AMT-MO-PYMT                                     
                   ,:CT-CODE-BILL-TYPE                                  
                   ,:CT-CNT-ITEM-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                MOVE +000                   TO S-RETURN-CODE            
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                MOVE 'Y'                   TO WS-OTHR-CHRG-FLAG         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7505'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7505-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7510-CLOSE-CNT-CSR                                             *        
      ******************************************************************        
       7510-CLOSE-CNT-CSR.                                              
                                                                        
           EXEC SQL                                                     
              CLOSE CONTRACT_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7510'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7520-GET-PRJ-SHARE-AMT                                         *        
      ******************************************************************        
       7520-GET-PRJ-SHARE-AMT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT SUM(MONTHLY_BILL_AM)                               
                INTO :WS-TOT-PROJ-SHR-AMT :WS-NULL-IND-8                 
              FROM CSS_PROJ_SHARE PJ WITH(READUNCOMMITTED)                      
              WHERE PJ.ACCOUNT_NO        = :PJ-ACCOUNT-NO               
                AND PJ.SHARE_STATUS_CD   = 'A'                          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(MONTHLY_BILL_AM)                                       
MFA-TR*         INTO :WS-TOT-PROJ-SHR-AMT:WS-NULL-IND-8                         
MFA-TR*       FROM CSS_PROJ_SHARE PJ                                            
MFA-TR*       WHERE PJ.ACCOUNT_NO        = :PJ-ACCOUNT-NO                       
MFA-TR*         AND PJ.SHARE_STATUS_CD   = 'A'                                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-NULL-IND-8 EQUAL -1                                    
             MOVE ZEROES                     TO WS-TOT-PROJ-SHR-AMT     
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                MOVE +000                    TO S-RETURN-CODE           
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                MOVE 'Y'                     TO WS-OTHR-CHRG-FLAG       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7520'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PROJ_SHARE'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE PJ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7530-GET-AR-CNTL-AMT                                           *        
      ******************************************************************        
       7530-GET-AR-CNTL-AMT.                                            
                                                                        
           MOVE CT-CNT-ITEM-ID               TO AC-ITEM-ID.             
                                                                        
           EXEC SQL                                                     
             SELECT  AC.AMT_AR_DAY_00                                   
                    ,AC.AMT_AR_DAY_30                                   
                    ,AC.AMT_AR_DAY_60                                   
                    ,AC.AMT_AR_DAY_90                                   
                    ,AC.AMT_TRAN_BALANCE                                
               INTO :AC-AMT-AR-DAY-00                                   
                   ,:AC-AMT-AR-DAY-30                                   
                   ,:AC-AMT-AR-DAY-60                                   
                   ,:AC-AMT-AR-DAY-90                                   
                   ,:AC-AMT-TRAN-BALANCE                                
             FROM  CSS_AR_CNTL AC WITH(READUNCOMMITTED)                         
             WHERE AC.ACCOUNT_NO         = :AC-ACCOUNT-NO               
               AND AC.ITEM_ID            = :AC-ITEM-ID                  
               AND AC.PYMT_PRIORITY_LVL  = 100                          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  AC.AMT_AR_DAY_00                                           
MFA-TR*             ,AC.AMT_AR_DAY_30                                           
MFA-TR*             ,AC.AMT_AR_DAY_60                                           
MFA-TR*             ,AC.AMT_AR_DAY_90                                           
MFA-TR*             ,AC.AMT_TRAN_BALANCE                                        
MFA-TR*        INTO :AC-AMT-AR-DAY-00                                           
MFA-TR*            ,:AC-AMT-AR-DAY-30                                           
MFA-TR*            ,:AC-AMT-AR-DAY-60                                           
MFA-TR*            ,:AC-AMT-AR-DAY-90                                           
MFA-TR*            ,:AC-AMT-TRAN-BALANCE                                        
MFA-TR*      FROM  CSS_AR_CNTL AC                                               
MFA-TR*      WHERE AC.ACCOUNT_NO         = :AC-ACCOUNT-NO                       
MFA-TR*        AND AC.ITEM_ID            = :AC-ITEM-ID                          
MFA-TR*        AND AC.PYMT_PRIORITY_LVL  = 100                                  
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7530'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ITEM_ID'                 TO TABLE-ELEMENT-1         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7600-CHECK-FOR-TOU-ACCT                                        *        
      ******************************************************************        
       7600-CHECK-FOR-TOU-ACCT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-NOT-ELIG-FOR-EPP                               
              FROM CSS_RATE_TOU_DEF RJ WITH(READUNCOMMITTED)                    
                  ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                    
              WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                  
              AND   RJ.CODE_UTIL_TYPE =  UT.CODE_UTIL_TYPE              
              AND   RJ.RATE_PLAN_NO   =  UT.RATE_PLAN_NO                
              AND   RJ.VERSION_NO_CNTRL =                               
PRODFX          (SELECT MAX(RT.VERSION_NO_CNTRL)                        
                 FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                 
                 WHERE RT.CODE_UTIL_TYPE = RJ.CODE_UTIL_TYPE            
                 AND   RT.RATE_PLAN_NO   = RJ.RATE_PLAN_NO              
                 AND   RT.CODE_STATUS NOT IN ('T')                      
PRODFX           AND   RT.FROM_EFFECTIVE_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE) )           
A37061                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-NOT-ELIG-FOR-EPP                                       
MFA-TR*       FROM CSS_RATE_TOU_DEF RJ                                          
MFA-TR*           ,CSS_UTIL_ENVRNMT UT                                          
MFA-TR*       WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                          
MFA-TR*       AND   RJ.CODE_UTIL_TYPE =  UT.CODE_UTIL_TYPE                      
MFA-TR*       AND   RJ.RATE_PLAN_NO   =  UT.RATE_PLAN_NO                        
MFA-TR*       AND   RJ.VERSION_NO_CNTRL =                                       
MFA-TR*         (SELECT MAX(RT.VERSION_NO_CNTRL)                                
MFA-TR*          FROM CSS_RATE_CREATOR RT                                       
MFA-TR*          WHERE RT.CODE_UTIL_TYPE = RJ.CODE_UTIL_TYPE                    
MFA-TR*          AND   RT.RATE_PLAN_NO   = RJ.RATE_PLAN_NO                      
MFA-TR*          AND   RT.CODE_STATUS NOT IN ('T')                              
MFA-TR*          AND   RT.FROM_EFFECTIVE_DT <= CURRENT DATE )                   
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00251******************************************************************        
P00251* 7650-CHECK-FOR-COGEN-ACCT                                      *        
P00251******************************************************************        
P00251 7650-CHECK-FOR-COGEN-ACCT.                                       
                                                                        
P00251     EXEC SQL                                                     
P00251        SELECT TOP(1) 'Y'                                                
P00251          INTO :WS-NOT-ELIG-FOR-EPP                               
P00251        FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                   
P00251            ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                   
P00251        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                  
P00251        AND   J1.CODE_UTIL_TYPE =  UT.CODE_UTIL_TYPE              
P00251        AND   J1.RATE_PLAN_NO   =  UT.RATE_PLAN_NO                
P00251        AND  (J1.BAL_FWD_CD        > ' '                          
P00251         OR   J1.CMPNT_ID_CD       = '60')                        
P00251        AND   J1.VERSION_NO_CNTRL =                               
P00251          (SELECT MAX(RT.VERSION_NO_CNTRL)                        
P00251           FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                 
P00251           WHERE RT.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE            
P00251           AND   RT.RATE_PLAN_NO   = J1.RATE_PLAN_NO              
P00251           AND   RT.CODE_STATUS    = 'A')                         
P00251                                       
P00251                                                      
P00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-NOT-ELIG-FOR-EPP                                       
MFA-TR*       FROM CSS_RATE_COMP_DEF J1                                         
MFA-TR*           ,CSS_UTIL_ENVRNMT  UT                                         
MFA-TR*       WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                          
MFA-TR*       AND   J1.CODE_UTIL_TYPE =  UT.CODE_UTIL_TYPE                      
MFA-TR*       AND   J1.RATE_PLAN_NO   =  UT.RATE_PLAN_NO                        
MFA-TR*       AND  (J1.BAL_FWD_CD        > ' '                                  
MFA-TR*        OR   J1.CMPNT_ID_CD       = '60')                                
MFA-TR*       AND   J1.VERSION_NO_CNTRL =                                       
MFA-TR*         (SELECT MAX(RT.VERSION_NO_CNTRL)                                
MFA-TR*          FROM CSS_RATE_CREATOR RT                                       
MFA-TR*          WHERE RT.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE                    
MFA-TR*          AND   RT.RATE_PLAN_NO   = J1.RATE_PLAN_NO                      
MFA-TR*          AND   RT.CODE_STATUS    = 'A')                                 
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7650                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00251        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00251           MOVE +000                   TO S-RETURN-CODE           
P00251        END-IF                                                    
P00251     ELSE                                                         
P00251        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00251        MOVE '7650'                    TO ACTIVE-PARAGRAPH        
P00251        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00251        MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
P00251        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00251        MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00251        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00251        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00251     END-IF.                                                      
P00251                                                                  
P00251 7650-EXIT.                                                       
P00251     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-CHECK-FINAL-BILL                                          *        
      ******************************************************************        
       7700-CHECK-FINAL-BILL.                                           
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-NOT-ELIG-FOR-EPP                               
A02824          FROM CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                      
A02824         WHERE AT.ACCOUNT_NO       = :AT-ACCT-XFER-FROM-LST       
A02824           AND AT.ACCT_FINALED_DT  IS NULL                        
A02824                                                           
A02824                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-NOT-ELIG-FOR-EPP                                       
MFA-TR*         FROM CSS_ACCOUNT  AT                                            
MFA-TR*        WHERE AT.ACCOUNT_NO       = :AT-ACCT-XFER-FROM-LST               
MFA-TR*          AND AT.ACCT_FINALED_DT  IS NULL                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02824        MOVE +000                      TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7700'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
A02824        MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
A02824        MOVE AT-ACCT-XFER-FROM-LST     TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7750-SELECT-CREDIT-PROFILE                                     *        
      ******************************************************************        
                                                                        
       7750-SELECT-CREDIT-PROFILE.                                      
           EXEC SQL                                                     
              SELECT CZ.CASH_ONLY_FL                                    
                INTO :CZ-CASH-ONLY-FL                                   
                FROM CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)                
              WHERE CZ.ACCOUNT_NO = :CZ-ACCOUNT-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CZ.CASH_ONLY_FL                                            
MFA-TR*         INTO :CZ-CASH-ONLY-FL                                           
MFA-TR*         FROM CSS_CREDIT_PROFILE CZ                                      
MFA-TR*       WHERE CZ.ACCOUNT_NO = :CZ-ACCOUNT-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              ELSE IF CZ-CASH-ONLY-FL = 'Y'                             
                 MOVE CZ-CASH-ONLY-FL        TO WS-NOT-ELIG-FOR-EPP     
              END-IF
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7750'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CREDIT_PROFILE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE CZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7760-CHK-ACTIVE-EPP-OFFER                                      *        
      ******************************************************************        
       7760-CHK-ACTIVE-EPP-OFFER.                                       
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-NOT-ELIG-FOR-EPP                             
                  FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                
                 WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO             
                   AND AT.ACCOUNT_NO       = BH.ACCOUNT_NO              
                   AND AT.EPP_OFFER_AMOUNT > 0                          
                    AND BH.CHANGE_REASON   = 'O'                        
                   AND AT.REV_MTH_LST_NRML = CIS.CHAR2DECIMAL(                  
                             (SUBSTRING(CAST(BH.DATE_PYMT_STRT
            AS CHAR(10)), 1, 4)) + (SUBSTRING(CAST(BH.DATE_PYMT_STRT
            AS CHAR(10)), 6, 2)))     
                   AND AT.REV_MTH_LST_NRML = CIS.CHAR2DECIMAL(                  
                             (SUBSTRING(CAST(AT.EPP_OFFER_DATE
            AS CHAR(10)), 1, 4)) + (SUBSTRING(CAST(AT.EPP_OFFER_DATE
            AS CHAR(10)), 6, 2)))     
A37061                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-NOT-ELIG-FOR-EPP                                     
MFA-TR*           FROM  CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_BUDGET_HIST BH                                      
MFA-TR*          WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO                     
MFA-TR*            AND AT.ACCOUNT_NO       = BH.ACCOUNT_NO                      
MFA-TR*            AND AT.EPP_OFFER_AMOUNT > 0                                  
MFA-TR*             AND BH.CHANGE_REASON   = 'O'                                
MFA-TR*            AND AT.REV_MTH_LST_NRML = DECIMAL(                           
MFA-TR*                      (SUBSTR(CHAR(BH.DATE_PYMT_STRT),1,4)) ||           
MFA-TR*                      (SUBSTR(CHAR(BH.DATE_PYMT_STRT),6,2)))             
MFA-TR*            AND AT.REV_MTH_LST_NRML = DECIMAL(                           
MFA-TR*                      (SUBSTR(CHAR(AT.EPP_OFFER_DATE),1,4)) ||           
MFA-TR*                      (SUBSTR(CHAR(AT.EPP_OFFER_DATE),6,2)))             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7760'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7760-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7800-SELECT-BILLING-DET.                                      *         
      *****************************************************************         
       7800-SELECT-BILLING-DET.                                         
                                                                        
           EXEC SQL                                                     
              SELECT MAX(BG.REVENUE_MONTH)                              
                INTO :WS-REVENUE-MONTH :WS-REVENUE-MONTH-NULL            
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
               WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(BG.REVENUE_MONTH)                                      
MFA-TR*         INTO :WS-REVENUE-MONTH:WS-REVENUE-MONTH-NULL                    
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*        WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-REVENUE-MONTH-NULL < 0 OR WS-REVENUE-MONTH = 0      
                 PERFORM 7850-READ-BILL-WINDOW THRU 7850-EXIT           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7800'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7825-CHECK-FOR-HTGCLG-ROWS                                     *        
      ******************************************************************        
      *7825-CHECK-FOR-HTGCLG-ROWS.                                              
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT COUNT(*)                                                 
      *         INTO :WS-HTGCLG-ROWS                                            
      *         FROM CSS_BILLING_HDR BI,                                        
      *              CSS_BILLING_DET BG                                         
      *         WHERE BG.ACCOUNT_NO      = :BG-ACCOUNT-NO                       
      *           AND BI.ACCOUNT_NO      = BG.ACCOUNT_NO                        
      *           AND BI.BILL_NO         = BG.BILL_NO                           
      *           AND CODE_BILL_ITM_TYPE = 'C'                                  
      *           AND CODE_BILL_ITM_IND  = 'A'                                  
      *           AND CODE_BILL_CALC     = 'A'                                  
      *           AND BI.BILL_NO         = BG.BILL_NO                           
      *           AND BG.CODE_UTIL_TYPE  = :BG-CODE-UTIL-TYPE                   
      *           AND BG.IC_NO           = :BG-IC-NO                            
      *        AND (BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MONTH                 
      *                                  AND :WS-TO-REV-MONTH)                  
      *        AND (SUBSTR(STRIP(CHAR(BG.REVENUE_MONTH)),5,2) IN                
      *                       ('12','01','02','06','07','08'))                  
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE                
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       IF WS-HTGCLG-ROWS < 06                                            
      *         MOVE 'Y'                TO WS-NOT-ELIG-FOR-EPP                  
      *       END-IF                                                            
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                        
      *       MOVE '7825'               TO ACTIVE-PARAGRAPH                     
      *       MOVE 'SELECT'             TO ABEND-FUNCTION                       
      *       MOVE 'CSS_BILLING_DET'    TO TABLE-1                              
      *       MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1                      
      *       MOVE BG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1                    
      *       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT                     
      *       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                     
      *    END-IF.                                                              
                                                                        
      *7825-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      *****************************************************************         
      * 7850-READ-BILL-WINDOW.                                        *         
      *****************************************************************         
       7850-READ-BILL-WINDOW.                                           
                                                                        
           MOVE AT-BILL-CYCLE                TO BN-BILL-CYCLE.          
                                                                        
           EXEC SQL                                                     
            SELECT MAX(BN.REVENUE_MONTH)                                
             INTO  :WS-REVENUE-MONTH :WS-REVENUE-MONTH-NULL              
             FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                      
             WHERE BN.DATE_EXTRACT < CAST(SYSDATETIMEOFFSET() AS DATE)          
             AND   BN.BILL_CYCLE   = :BN-BILL-CYCLE                     
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT MAX(BN.REVENUE_MONTH)                                        
MFA-TR*      INTO  :WS-REVENUE-MONTH:WS-REVENUE-MONTH-NULL                      
MFA-TR*      FROM CSS_BILL_WINDOW BN                                            
MFA-TR*      WHERE BN.DATE_EXTRACT < CURRENT DATE                               
MFA-TR*      AND   BN.BILL_CYCLE   = :BN-BILL-CYCLE                             
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             IF WS-REVENUE-MONTH-NULL EQUAL -1                          
                MOVE ZEROES                  TO WS-REVENUE-MONTH        
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7850'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_WINDOW'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'BILL_CYCLE'              TO TABLE-ELEMENT-2         
              MOVE BN-BILL-CYCLE             TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7900-COMPUTE-FIELDS.                                          *         
      *****************************************************************         
       7900-COMPUTE-FIELDS.                                             
                                                                        
           PERFORM 7950-SELECT-BUDGET-PLAN     THRU 7950-EXIT           
           MOVE BU-ANNIVERSARY-DATE          TO WS-ANNIVERSARY-DATE     
                                                S-ANNIV-DATE.           
           MOVE WS-AD-MONTH                  TO WS-AD-MONTH-X.          
           MOVE WS-AD-YEAR                   TO WS-AD-YEAR-X.           
           MOVE WS-AD-MONTH-RED              TO WS-MONTH1.              
           MOVE WS-AD-YEAR-RED               TO WS-YEAR1.               
                                                                        
           MOVE WS-AD-MONTH-RED              TO WS-CALC-START-MONTH.    
           MOVE WS-AD-YEAR-RED               TO WS-CALC-START-YEAR.     
                                                                        
           PERFORM VARYING WS-MONTH-CTR FROM +12 BY -1                  
                               UNTIL WS-MONTH-CTR = +1                  
                 SUBTRACT +1               FROM WS-CALC-START-MONTH     
                 IF WS-CALC-START-MONTH = ZERO                          
                    MOVE +12                 TO WS-CALC-START-MONTH     
                    SUBTRACT +1            FROM WS-CALC-START-YEAR      
                 END-IF                                                 
           END-PERFORM.                                                 
                                                                        
           MOVE WS-CALC-START-MONTH     TO WS-SD-MONTH.                 
           MOVE WS-CALC-START-YEAR           TO WS-SD-YEAR.             
           MOVE '01'                         TO WS-SD-DAY.              
           MOVE WS-START-DATE                TO S-START-DATE.           
                                                                        
           MOVE WS-REVENUE-MONTH             TO WS-REVENUE-MONTH-X.     
           MOVE WS-REVENUE-MONTH-X           TO WS-YEAR-MONTH2.         
                                                                        
           IF WS-MONTH2 = 12 AND WS-YEAR1 = WS-YEAR2 + 2                
              ADD  1                         TO WS-MONTH2               
           END-IF.                                                      
                                                                        
           IF WS-MONTH2 > 12                                            
              COMPUTE WS-MONTH2 = WS-MONTH2 - 12                        
              COMPUTE WS-YEAR2  = WS-YEAR2 + 1                          
           END-IF.                                                      
                                                                        
           IF WS-YEAR1 > WS-YEAR2                                       
              ADD +12                        TO WS-MONTH1               
           END-IF.                                                      
                                                                        
           COMPUTE WS-MONTHS-LEFT = WS-MONTH1 - WS-MONTH2.              
                                                                        
           IF WS-MONTHS-LEFT <= 0                                       
              MOVE +12                       TO WS-MONTHS-LEFT          
           END-IF.                                                      
                                                                        
           IF WS-MONTHS-LEFT > 12                                       
              MOVE 12                        TO WS-MONTHS-LEFT          
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7950-SELECT-BUDGET-PLAN                                        *        
      ******************************************************************        
       7950-SELECT-BUDGET-PLAN.                                         
                                                                        
           EXEC SQL                                                     
              SELECT BU.AMT_MO_PYMT                                     
                    ,CIS.CHAR2$DATE(BU.ANNIVERSARY_DATE, 'USA')                 
                    ,CIS.CHAR2$DATE(BU.DATE_PYMT_STRT, 'USA')                   
                INTO :BU-AMT-MO-PYMT                                    
                    ,:BU-ANNIVERSARY-DATE                               
                    ,:BU-DATE-PYMT-STRT                                 
                FROM CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                   
               WHERE BU.ACCOUNT_NO        = :BU-ACCOUNT-NO              
                 AND BU.PYMT_PRIORITY_LVL = 50                          
                 AND BU.BP_ITEM_ID        = 1                           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BU.AMT_MO_PYMT                                             
MFA-TR*             ,CHAR(BU.ANNIVERSARY_DATE, USA)                             
MFA-TR*             ,CHAR(BU.DATE_PYMT_STRT, USA)                               
MFA-TR*         INTO :BU-AMT-MO-PYMT                                            
MFA-TR*             ,:BU-ANNIVERSARY-DATE                                       
MFA-TR*             ,:BU-DATE-PYMT-STRT                                         
MFA-TR*         FROM CSS_BUDGET_PLAN BU                                         
MFA-TR*        WHERE BU.ACCOUNT_NO        = :BU-ACCOUNT-NO                      
MFA-TR*          AND BU.PYMT_PRIORITY_LVL = 50                                  
MFA-TR*          AND BU.BP_ITEM_ID        = 1                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7950'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BUDGET_PLAN'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE BU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7960-GET-LAST-BILLED-DATE                                      *        
      ******************************************************************        
       7960-GET-LAST-BILLED-DATE.                                       
                                                                        
           EXEC SQL                                                     
               SELECT  MAX(BI.DATE_BILLED)                              
                 INTO  :WS-DATE-BILLED-00 :WS-NULL-IND-7                 
               FROM    CSS_BILLING_HDR   BI WITH(READUNCOMMITTED)               
                      ,CSS_BILLING_DET   BG WITH(READUNCOMMITTED)               
                      ,CSS_ACCOUNT       AT WITH(READUNCOMMITTED)               
               WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO             
                AND  AT.ACCOUNT_NO         = BI.ACCOUNT_NO              
                AND  AT.ACCOUNT_NO         = BG.ACCOUNT_NO              
                AND  BI.BILL_NO            = BG.BILL_NO                 
                AND  BG.CODE_BILL_CALC     <> 'S'                       
                AND  BG.CODE_UTIL_TYPE     IN ('E','G','U')             
                AND  BG.DATE_ORIG_BILL IS NULL                          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MAX(BI.DATE_BILLED)                                      
MFA-TR*          INTO  :WS-DATE-BILLED-00:WS-NULL-IND-7                         
MFA-TR*        FROM    CSS_BILLING_HDR   BI                                     
MFA-TR*               ,CSS_BILLING_DET   BG                                     
MFA-TR*               ,CSS_ACCOUNT       AT                                     
MFA-TR*        WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                     
MFA-TR*         AND  AT.ACCOUNT_NO         = BI.ACCOUNT_NO                      
MFA-TR*         AND  AT.ACCOUNT_NO         = BG.ACCOUNT_NO                      
MFA-TR*         AND  BI.BILL_NO            = BG.BILL_NO                         
MFA-TR*         AND  BG.CODE_BILL_CALC     <> 'S'                               
MFA-TR*         AND  BG.CODE_UTIL_TYPE     IN ('E','G','U')                     
MFA-TR*         AND  BG.DATE_ORIG_BILL IS NULL                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              END-IF                                                    
              IF WS-NULL-IND-7 EQUAL -1                                 
                 MOVE SPACES                 TO WS-DATE-BILLED-00       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7960'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7970-CHECK-ACCT-FOR-ANNIV                                      *        
      ******************************************************************        
       7970-CHECK-ACCT-FOR-ANNIV.                                       
                                                                        
           MOVE 'N'                          TO WS-ACCT-ANNIV-FLAG      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                             
                 INTO   :WS-ACCT-ANNIV-FLAG                             
               FROM     CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                
               WHERE BH.ACCOUNT_NO            = :BH-ACCOUNT-NO          
                AND  CAST(BH.BUD_HIST_SEQ_NO AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-DATE-BILLED-00
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED-00
              ) <> 0) OR (LEN(:WS-DATE-BILLED-00
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILLED-00
              ), CONVERT(DATE, :WS-DATE-BILLED-00) )      
                AND  CHANGE_REASON            = 'A'                     
A37061                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT   'Y'                                                     
MFA-TR*          INTO   :WS-ACCT-ANNIV-FLAG                                     
MFA-TR*        FROM     CSS_BUDGET_HIST BH                                      
MFA-TR*        WHERE BH.ACCOUNT_NO            = :BH-ACCOUNT-NO                  
MFA-TR*         AND  DATE(BH.BUD_HIST_SEQ_NO) = :WS-DATE-BILLED-00              
MFA-TR*         AND  CHANGE_REASON            = 'A'                             
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7970'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BUDGET_HIST'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE BH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7970-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7980-CHECK-FOR-PYMTS                                           *        
      ******************************************************************        
       7980-CHECK-FOR-PYMTS.                                            
                                                                        
           MOVE 'N'                          TO WS-PYMT-FOUND           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                INTO  :WS-PYMT-FOUND                                    
                FROM   CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)               
                WHERE AR.ACCOUNT_NO        = :AR-ACCOUNT-NO             
                  AND AR.CODE_TRAN_TYPE    = 'P'                        
                  AND CAST(AR.TRANS_HIST_SEQ_NO AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-DATE-BILLED-00
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED-00
              ) <> 0) OR (LEN(:WS-DATE-BILLED-00
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILLED-00
              ), CONVERT(DATE, :WS-DATE-BILLED-00) )  
A37061                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*         INTO  :WS-PYMT-FOUND                                            
MFA-TR*         FROM   CSS_AR_TRANS_HIST AR                                     
MFA-TR*         WHERE AR.ACCOUNT_NO        = :AR-ACCOUNT-NO                     
MFA-TR*           AND AR.CODE_TRAN_TYPE    = 'P'                                
MFA-TR*           AND DATE(AR.TRANS_HIST_SEQ_NO) >= :WS-DATE-BILLED-00          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7980'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7980-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7990-CHECK-CURRENT-EPP                                         *        
      ******************************************************************        
       7990-CHECK-CURRENT-EPP.                                          
                                                                        
           MOVE 'N'                          TO WS-EPP-ACCT-WITH-ANNIV  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                INTO  :WS-EPP-ACCT-WITH-ANNIV                           
                FROM   CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                 
                WHERE BH.ACCOUNT_NO        = :BH-ACCOUNT-NO             
                  AND BH.CHANGE_REASON     = 'A'                        
                  AND BH.BUD_HIST_SEQ_NO >=                             
                      (SELECT MAX(BH1.BUD_HIST_SEQ_NO)                  
                         FROM CSS_BUDGET_HIST BH1 WITH(READUNCOMMITTED)         
                        WHERE BH1.ACCOUNT_NO    = BH.ACCOUNT_NO         
                        AND   BH1.CHANGE_REASON = 'S')                  
A37061                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*         INTO  :WS-EPP-ACCT-WITH-ANNIV                                   
MFA-TR*         FROM   CSS_BUDGET_HIST BH                                       
MFA-TR*         WHERE BH.ACCOUNT_NO        = :BH-ACCOUNT-NO                     
MFA-TR*           AND BH.CHANGE_REASON     = 'A'                                
MFA-TR*           AND BH.BUD_HIST_SEQ_NO >=                                     
MFA-TR*               (SELECT MAX(BH1.BUD_HIST_SEQ_NO)                          
MFA-TR*                  FROM CSS_BUDGET_HIST BH1                               
MFA-TR*                 WHERE BH1.ACCOUNT_NO    = BH.ACCOUNT_NO                 
MFA-TR*                 AND   BH1.CHANGE_REASON = 'S')                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7990'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BUDGET_HIST'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE BH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9500-CALL-CPD00068                                             *        
      ******************************************************************        
       9500-CALL-CPD00068.                                              
                                                                        
           MOVE '9500' TO ACTIVE-PARAGRAPH.                             
                                                                        
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                  TO WS-RETURN-CODE,            
                                             WS-ACTIVE-RETURN-CODE      
              END-IF                                                    
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SQL ERROR PROCESSING COPYLIB                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6010-REDUCE-EMBEDDED-SPACES.                                   *        
      *      COPYBOOK TO ELIMINATE EXTRA SPACES IN ADDRESS INFO        *        
      ******************************************************************        
         COPY CPD00004.                                                         
                                                                        
      ****************************************************************          
      * 7999-SELECT-TRANSFER-IND.                                               
      *     COPYBOOK TO CHECK AT-ACCT-XFER STATUS                               
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD00307                                                 
           END-EXEC.                                                            
                                                                        
