       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03513.                                     
COB303 DATE-WRITTEN. FEBRUARY 10, 2005.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03513              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03513 :                                                --         
      *--                                                            --         
      *--  #  UPDATES CSS_ATTRIBUTE BASED ON ATTRIBUTE VALUE:        --         
      *--     IF EUAL 'YES' THEN INSERT ROW, IF EQUAL OTHER THEN     --         
      *--     DELETE ROW...                                          --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            IN   I_USERID                 CHAR(07),         --         
      *--            IN   I_COMMENT_TEXT           CHAR(210),        --         
      *--            IN   I_COMMENT_LEN_NUM        CHAR(04),         --         
      *--            IN   I_ACCOUNT_NO             CHAR(13),         --         
      *--            IN   I_ATTRIB_DESC            CHAR(18),         --         
      *--            IN   I_ATTRIB_VALUE           CHAR(05)          --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            RETURN_CODE                                     --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          USER ID     COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
C29533*--  02/10/2005    SM19366     NEW CODE                        --         
T35434*--  07/28/2007    MR97640     REPLACED MODEL_SQL WITH SET     --         
T35434*--                            STATEMENT AND ADDED WITH UR TO  --         
T35434*--                            AVOID -911 ABENDS.              --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03513'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_USER_PROFILE (PREFIX = PF)                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_ACCOUNT      (PREFIX = AT)                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_ATTRIBUTE (PREFIX = WZ)                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATTRIB                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_ACCT_ATTRIBUTE (PREFIX = YP)                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * CSS_MNT_TRANS_HIST   (PREFIX = MH)                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * CSS_MT_TRN_HST_DET   (PREFIX = MI)                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG            PIC X(08) VALUE 'CSRERLOG'.      
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03513'.      
      *                                                                         
       01  LS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
      *                                                                         
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE            PIC S9(9)  VALUE 0 COMP.         
           10 S-ACCOUNT-NO             PIC X(13)  VALUE SPACES.         
           10 S-ACTIVE-PARAGRAPH       PIC X(04)  VALUE SPACES.         
                                                                        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                         
           05  WS-COMMENT-LEN-NUM       PIC S9(04).                     
      *                                                                         
       01  WS-MISC-ITEMS.                                               
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-TIMESTMP     PIC X(26) VALUE SPACES.          
           05  WS-RESP-AREA            PIC X(03) VALUE SPACES.          
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE 0.         
           05  WS-OLD-NO-OF-COPIES     PIC S9(1)  VALUE 0 COMP.         
           05  WS-NEW-NO-OF-COPIES     PIC S9(1)  VALUE 0 COMP.         
           05  WS-PARM-ACCOUNT-NO      PIC 9(13) VALUE ZERO.            
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.              
           05  WS-ADDRESS-ID           PIC 9(13) VALUE ZERO.            
      *                                                                         
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-MT-TRN-HST-DET       PIC X(01) VALUE 'N'.             
               88 NO-OF-COPIES                   VALUE 'C'.             
               88 DELETE-EMAIL-ONLY              VALUE 'E'.             
                                                                        
           COPY CWS00011.                                                       
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  IN-USERID                   PIC X(07).                       
       01  IN-COMMENT-TEXT             PIC X(210).                      
       01  IN-COMMENT-LEN-NUM          PIC X(04).                       
       01  IN-ACCOUNT-NO               PIC X(13).                       
       01  IN-ATTRIBUTE-DESC           PIC X(18).                       
       01  IN-ATTRIBUTE-VALUE          PIC X(05).                       
      *                                                                         
       PROCEDURE DIVISION USING IN-USERID                               
                                IN-COMMENT-TEXT                         
                                IN-COMMENT-LEN-NUM                      
                                IN-ACCOUNT-NO                           
                                IN-ATTRIBUTE-DESC                       
                                IN-ATTRIBUTE-VALUE.                     
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
                                                                        
           PERFORM 1100-PROCESS-INPUT        THRU 1100-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-INITIALIZE-PROCEDURE.                                     *        
      *--  SET UP SQL ERROR PROCESSING                              -- *        
      *--  DECLARE ASSOCIATED CURSOR                                -- *        
      ******************************************************************        
      *                                                                         
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
      *                                                                         
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT  :S-RETURN-CODE     AS RETURN_CODE,                 
                     :S-ACCOUNT-NO      AS ACCOUNT_NO,                  
                     :S-ACTIVE-PARAGRAPH AS ACTIVE_PARAGRAPH            
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                                   
MFA-TR*      SELECT  :S-RETURN-CODE     AS RETURN_CODE,                         
MFA-TR*              :S-ACCOUNT-NO      AS ACCOUNT_NO,                          
MFA-TR*              :S-ACTIVE-PARAGRAPH AS ACTIVE_PARAGRAPH                    
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-PROCESS-INPUT                                             *        
      ******************************************************************        
                                                                        
       1100-PROCESS-INPUT.                                              
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
      * POPULATE RETURN VARIABLES                                               
           MOVE ZERO                         TO S-RETURN-CODE.          
           MOVE IN-ACCOUNT-NO                 TO S-ACCOUNT-NO.          
           MOVE SPACES                   TO S-ACTIVE-PARAGRAPH.         
      *                                                                         
           IF IN-ACCOUNT-NO > SPACES                                    
              MOVE IN-ACCOUNT-NO         TO WS-PARM-ACCOUNT-NO          
              MOVE WS-PARM-ACCOUNT-NO    TO AT-ACCOUNT-NO               
                                            WS-ACCOUNT-NO               
                                            YP-ACCOUNT-NO               
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '1100'          TO ACTIVE-PARAGRAPH                  
              MOVE 'RECEIVE INPUT' TO ABEND-FUNCTION                    
              MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                   
              MOVE IN-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1                 
              MOVE +100 TO WS-ACTIVE-RETURN-CODE                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
           EVALUATE IN-ATTRIBUTE-DESC                                   
              WHEN 'EMAIL PMT REMINDER'                                 
                IF IN-ATTRIBUTE-VALUE EQUAL 'YES'                       
                   PERFORM 2000-MOVE-ACCT-ATTRIBUTE THRU 2000-EXIT      
                   PERFORM 2100-INS-ACCT-ATTRIBUTE  THRU 2100-EXIT      
                   PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT       
                   PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT         
                ELSE                                                    
                   PERFORM 3100-DEL-ACCT-ATTRIBUTE THRU 3100-EXIT       
                   PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT       
                   PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT         
                END-IF                                                  
              WHEN OTHER                                                
                CONTINUE                                                
           END-EVALUATE.                                                
                                                                        
           ADD +1 TO CTR-ROWS.                                          
                                                                        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1700-UPD-MNT-TRANS-HIST                                        *        
      * UPDATE MNT TRANS HIST HEADER                                   *        
      ******************************************************************        
       1700-UPD-MNT-TRANS-HIST.                                         
                                                                        
            PERFORM 7100-GET-CURRENT-DATETIME THRU 7100-EXIT.           
                                                                        
            MOVE WS-CURRENT-TIMESTMP TO MH-TRANS-HIST-SEQ-NO.           
            MOVE WS-CURRENT-DATE TO MH-DATE-TRANS.                      
                                                                        
            MOVE 'F' TO MH-CODE-TRAN-TYPE.                              
                                                                        
            PERFORM 7150-GET-RESP-AREA THRU 7150-EXIT.                  
                                                                        
            MOVE WS-RESP-AREA TO MH-RESP-AREA-ID.                       
            MOVE ZEROES        TO MH-CUSTOMER-NO.                       
            MOVE IN-ACCOUNT-NO TO  MH-ACCOUNT-NO.                       
            MOVE ZEROS TO MH-PREMISE-NO.                                
            MOVE IN-USERID TO MH-USER-ID.                               
                                                                        
            MOVE 'CSR03513A' TO MH-APPL-PROGRAM-ID.                     
                                                                        
            MOVE IN-COMMENT-LEN-NUM TO WS-COMMENT-LEN-NUM.              
            MOVE WS-COMMENT-LEN-NUM TO MH-TRAN-COMMENT-LEN.             
            MOVE IN-COMMENT-TEXT   TO MH-TRAN-COMMENT-TEXT.             
                                                                        
            MOVE +1 TO WS-TRAN-APPL-NO.                                 
                                                                        
            MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.          
                                                                        
      * UPDATE MNT TRANS HIST DETAIL                                            
                                                                        
       1700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1800-LOAD-MNT-DTL-UPD.                                         *        
      * UPDATE MNT DETAIL                                              *        
      ******************************************************************        
       1800-LOAD-MNT-DTL-UPD.                                           
                                                                        
           IF IN-ATTRIBUTE-VALUE EQUAL 'YES'                            
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 'EMAIL PMT REMINDER'     TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +18                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE 'ATTRIBUTE DESC '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
                                                                        
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'OPT OUT'                TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +7                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 'OPT IN'                 TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +6                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE ' PYMT REMINDER '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'EMAIL PMT REMINDER'     TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +18                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '* DELETED *'            TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +11                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE 'ATTRIBUTE DESC '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
                                                                        
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'OPT IN'                 TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +6                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 'OPT OUT'                TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +7                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE ' PYMT REMINDER '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       1800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-MOVE-ACCT-ATTRIBUTE                                                
      ******************************************************************        
                                                                        
       2000-MOVE-ACCT-ATTRIBUTE.                                        
      *                                                                         
           MOVE WS-ACCOUNT-NO TO YP-ACCOUNT-NO.                         
           MOVE IN-ATTRIBUTE-DESC TO YP-ATTRIBUTE-DESC.                 
      *                                                                         
           PERFORM 2160-SEL-CSS-ATTRIBUTE THRU 2160-EXIT.               
           IF WZ-ATTRIB-DFLT-VAL-CD = 'NO'                              
              MOVE 'YES'          TO YP-ATTRIBUTE-VALUE-CD              
           ELSE IF WZ-ATTRIB-DFLT-VAL-CD = 'YES'                        
              MOVE 'NO'          TO YP-ATTRIBUTE-VALUE-CD               
           END-IF
           END-IF.                                                      
           MOVE WZ-ATTRIB-DFLT-VAL-TX TO YP-ATTRIBUTE-VALUE-TX.         
                                                                        
      *                                                                         
           PERFORM 7100-GET-CURRENT-DATETIME THRU 7100-EXIT.            
           MOVE WS-CURRENT-DATE TO YP-ATTRIBUTE-VALUE-DT.               
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-INS-ACCT-ATTRIBUTE                                                 
      ******************************************************************        
                                                                        
       2100-INS-ACCT-ATTRIBUTE.                                         
           EXEC SQL                                                     
                INSERT INTO CSS_ACCT_ATTRIBUTE                          
                     ( ACCOUNT_NO                                       
                      ,ATTRIBUTE_DESC                                   
                      ,ATTRIBUTE_VALUE_CD                               
                      ,ATTRIBUTE_VALUE_DT                               
                      ,ATTRIBUTE_VALUE_TX)                              
                VALUES                                                  
                     ( :YP-ACCOUNT-NO                                   
                      ,:YP-ATTRIBUTE-DESC                               
                      ,:YP-ATTRIBUTE-VALUE-CD                           
                      ,IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )                       
                      ,:YP-ATTRIBUTE-VALUE-TX)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ACCT_ATTRIBUTE                                  
MFA-TR*              ( ACCOUNT_NO                                               
MFA-TR*               ,ATTRIBUTE_DESC                                           
MFA-TR*               ,ATTRIBUTE_VALUE_CD                                       
MFA-TR*               ,ATTRIBUTE_VALUE_DT                                       
MFA-TR*               ,ATTRIBUTE_VALUE_TX)                                      
MFA-TR*         VALUES                                                          
MFA-TR*              ( :YP-ACCOUNT-NO                                           
MFA-TR*               ,:YP-ATTRIBUTE-DESC                                       
MFA-TR*               ,:YP-ATTRIBUTE-VALUE-CD                                   
MFA-TR*               ,:YP-ATTRIBUTE-VALUE-DT                                   
MFA-TR*               ,:YP-ATTRIBUTE-VALUE-TX)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE.                               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO S-RETURN-CODE                             
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2100'          TO ACTIVE-PARAGRAPH                  
                                      S-ACTIVE-PARAGRAPH                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE '  ACCOUNT_NO  '     TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2160-SEL-CSS-ATTRIBUTE                                         *        
      ******************************************************************        
       2160-SEL-CSS-ATTRIBUTE.                                          
                                                                        
           MOVE IN-ATTRIBUTE-DESC TO WZ-ATTRIBUTE-DESC                  
           MOVE YP-ACCOUNT-NO    TO AT-ACCOUNT-NO                       
                                                                        
           EXEC SQL                                                     
                SELECT ATTRIB_DFLT_VAL_CD                               
                      ,ATTRIB_DFLT_VAL_TX                               
                      ,AT.COMPANY_NO                                    
                INTO   :WZ-ATTRIB-DFLT-VAL-CD                           
                      ,:WZ-ATTRIB-DFLT-VAL-TX                           
                      ,:AT-COMPANY-NO                                   
                  FROM CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                   
                      ,CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                   
                 WHERE ATTRIBUTE_DESC = :WZ-ATTRIBUTE-DESC              
                   AND ACCOUNT_NO     = :AT-ACCOUNT-NO                  
                   AND AT.COMPANY_NO  = WZ.COMPANY_NO                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ATTRIB_DFLT_VAL_CD                                       
MFA-TR*               ,ATTRIB_DFLT_VAL_TX                                       
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*         INTO   :WZ-ATTRIB-DFLT-VAL-CD                                   
MFA-TR*               ,:WZ-ATTRIB-DFLT-VAL-TX                                   
MFA-TR*               ,:AT-COMPANY-NO                                           
MFA-TR*           FROM CSS_ATTRIBUTE WZ                                 00450010
MFA-TR*               ,CSS_ACCOUNT   AT                                 00450010
MFA-TR*          WHERE ATTRIBUTE_DESC = :WZ-ATTRIBUTE-DESC                      
MFA-TR*            AND ACCOUNT_NO     = :AT-ACCOUNT-NO                          
MFA-TR*            AND AT.COMPANY_NO  = WZ.COMPANY_NO                           
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2160'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ATTRIBUTE     ' TO TABLE-1                      
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       2160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3100-DEL-ACCT-ATTRIBUTE.                                       *        
      ******************************************************************        
       3100-DEL-ACCT-ATTRIBUTE.                                         
                                                                        
           EXEC SQL                                                     
               DELETE FROM YP                         
               FROM CSS_ACCT_ATTRIBUTE YP
               WHERE YP.ACCOUNT_NO  = :YP-ACCOUNT-NO                    
                 AND YP.ATTRIBUTE_DESC = 'EMAIL PMT REMINDER'           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ACCT_ATTRIBUTE YP                                
MFA-TR*        WHERE YP.ACCOUNT_NO  = :YP-ACCOUNT-NO                            
MFA-TR*          AND YP.ATTRIBUTE_DESC = 'EMAIL PMT REMINDER'                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '3100'          TO ACTIVE-PARAGRAPH                  
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7100-GET-CURRENT-DATETIME.                                     *        
      ******************************************************************        
       7100-GET-CURRENT-DATETIME.                                       
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTMP,
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP,                     
MFA-TR*           :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE.                               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE '7100'                TO S-ACTIVE-PARAGRAPH          
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7150-GET-RESP-AREA                                             *        
      ******************************************************************        
       7150-GET-RESP-AREA.                                              
                                                                        
           MOVE IN-USERID TO PF-USER-ID.                                
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA                                      
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE USER_ID = :PF-USER-ID                              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :WS-RESP-AREA                                              
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE USER_ID = :PF-USER-ID                                      
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE.                               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE '7150'                TO S-ACTIVE-PARAGRAPH          
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE PF-USER-ID               TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      * 9000-SEND-ERROR-RESULT                                         *        
      * 9999-END-PROGRAM                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
      *                                                                         
      *6530-LOAD-MNT-TRANS-HIST.                                                
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
