       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03512.                                     
COB303 DATE-WRITTEN. JANUARY 05, 2005.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03512              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03512 :                                                --         
      *--                                                            --         
      *--  #  UPDATES BILL-PREFERENCE AND PAYMENT REMINDER BASED     --         
      *--     PARAMETERS PROVIDED IN INPUT.                          --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            I_ACCOUNT_NO          CHAR(13)                  --         
      *--            I_COMPANY_NO          CHAR(13)                  --         
      *--            I_BILL_PREFERENCE     CHAR(01)                  --         
      *--            I_PYMT_REMINDER       CHAR(01)                  --         
      *--            I_USERID              CHAR(07)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          USER ID     COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
C29533*--  02/09/2005    SM19366     NEW CODE                        --         
C29533*--  03/10/2005    SM19366     CHANGES PER CODE REVIEW         --         
T35434*--  07/30/2007    MR97640     REPLACED MODEL_SQL WITH SET     --         
T35434*--                            STATEMENT AND ADDED WITH UR TO  --         
T35434*--                            AVOID -911 ABENDS.              --         
P00150*--  08/11/2009    JG41113   - CHANGE TO KEEP NOTIFICATION     --         
      *--                            PAPERLESS/EMAIL ONCE EDI PROFILE--         
      *--                            IS DELETED                      --         
      *--                          - MODIFY PROGRAM ORGANIZATION     --         
P00596*--  08/20/2012    HA7A338   - MODIFIED 1800- TO MOVE 'NO PAPER--         
      *--                            /NO EMAIL' TO MODIFIED COLUMN   --         
      *--                            IN TRANS HIST FOR NO BILL NOTFY --         
      *--                          - ADDED NEW LOGIC PARA 5500- TO   --         
      *--                            DETERMINE PREV BILL NOTIFICATION--         
      *--                          - ADDED LOGIC TO INSER TRANS_HIST --         
      *--                            WHEN BILL NOTIFY OPT CHANGE FROM--         
      *--                            EMAIL ONLY TO EMAIL N PAPER &   --         
      *--                            VICE VERSA                      --         
      *--                          - REMOVED TRANS_HIST_DTL INSERT   --         
      *--                            WHILE DELETE EMAIL_PAPERONLY &  --         
      *--                            EMAIL_BILLNOTIFY FROM CSS_ACCT_ --         
      *--                            ATTRIBUTE TABLE TO AVOID DUPL   --         
      *--                            TRANS_HIST DETAIL INSERT        --         
      *--                          - REMOVED EMAIL_CURSOR & MODIFIED --         
      *--                            5000- PARA TO USE SINGLETON QRY --         
      *--                          - REMOVED DELETE-PAPERONLY &      --         
      *--                            DELETE-BILLNOTIFY UNDER         --         
      *--                            WS-MT-TRN-HST-DET & CHANGED VALS--         
      *--                            FROM E/F/Q/C TO 1/2/3/4 CORRES  --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03512'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_USER_PROFILE (PREFIX = PF)                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_ACCOUNT      (PREFIX = AT)                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
P00596******************************************************************        
P00596*    CSS_CUST_STATS    (PREFIX = CE)                             *        
P00596******************************************************************        
P00596     EXEC SQL                                                             
P00596        INCLUDE TBCSTSTS                                                  
P00596     END-EXEC.                                                            
P00150******************************************************************        
P00150*    CSS_EDI_ACCT_DEST (PREFIX = NF)                             *        
P00150******************************************************************        
P00150     EXEC SQL                                                             
P00150        INCLUDE TBACDEST                                                  
P00150     END-EXEC.                                                            
      ******************************************************************        
      *    CSS_ATTRIBUTE (PREFIX = WZ)                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATTRIB                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_ACCT_ATTRIBUTE (PREFIX = YP)                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_MNT_TRANS_HIST   (PREFIX = MH)                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * CSS_MT_TRN_HST_DET   (PREFIX = MI)                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
      *                                                                         
       01  WS-ACTIVE-RETURN-CODE1     PIC S9(9)  COMP VALUE 0.          
      *                                                                         
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG            PIC X(08) VALUE 'CSRERLOG'.      
P00596     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03512'.      
      *                                                                         
       01  LS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
      *                                                                         
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE            PIC S9(9)  VALUE 0 COMP.         
           10 S-ACCOUNT-NO             PIC X(13)  VALUE SPACES.         
           10 S-ACTIVE-PARAGRAPH       PIC X(04)  VALUE SPACES.         
                                                                        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                         
       01  WS-MISC-ITEMS.                                               
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-TIMESTMP     PIC X(26) VALUE SPACES.          
           05  WS-RESP-AREA            PIC X(03) VALUE SPACES.          
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE 0.         
           05  WS-OLD-NO-OF-COPIES     PIC S9(1)  VALUE 0 COMP.         
           05  WS-NEW-NO-OF-COPIES     PIC S9(1)  VALUE 0 COMP.         
           05  WS-ATTRIBUTE-DESC       PIC X(18)  VALUE SPACES.         
           05  WS-EXISTS-FLAG          PIC X(01)  VALUE 'N'.            
           05  WS-ACTIVE-CODE          PIC X(01)  VALUE 'A'.            
           05  WS-PENDING-CODE         PIC X(01)  VALUE 'P'.            
P00596     05  WS-1-EMAIL-ONLY         PIC X(01)  VALUE '1'.            
P00596     05  WS-2-EMAIL-PAPER        PIC X(01)  VALUE '2'.            
P00596     05  WS-3-PAPER-ONLY         PIC X(01)  VALUE '3'.            
P00596     05  WS-4-NOEMAIL-NOPAPER    PIC X(01)  VALUE '4'.            
           05  WS-PARM-ACCOUNT-NO      PIC 9(13)  VALUE ZERO.           
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.              
           05  WS-ADDRESS-ID           PIC 9(13)  VALUE ZERO.           
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-INDICATOR-2     PIC S9(04) COMP VALUE +0.        
      *                                                                         
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-MT-TRN-HST-DET       PIC X(01) VALUE 'N'.             
               88 NO-OF-COPIES                   VALUE 'O'.             
P00596         88 INSERT-EMAIL-ONLY              VALUE '1'.             
P00596         88 INSERT-EMAIL-PAPER             VALUE '2'.             
P00596         88 INSERT-PAPER-ONLY              VALUE '3'.             
P00596         88 INSERT-BILLNOTIFY              VALUE '4'.             
               88 DELETE-PMTREMINDER             VALUE 'R'.             
               88 INSERT-PMTREMINDER             VALUE 'S'.             
P00150     05  WS-EDI-ACCT-SW          PIC X(01) VALUE 'N'.             
P00150         88 EDI-ACCT-YES                   VALUE 'Y'.             
                                                                        
           COPY CWS00011.                                                       
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  IN-ACCOUNT-NO               PIC X(13).                       
       01  IN-COMPANY-NO               PIC X(02).                       
       01  IN-BILL-PREFERENCE          PIC X(01).                       
       01  IN-PMT-REMINDER             PIC X(01).                       
       01  IN-USERID                   PIC X(07).                       
      *                                                                         
       PROCEDURE DIVISION USING IN-ACCOUNT-NO                           
                                IN-COMPANY-NO                           
                                IN-BILL-PREFERENCE                      
                                IN-PMT-REMINDER                         
                                IN-USERID.                              
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
P00150     PERFORM 0100-INITIALIZE-PROCEDURE THRU 0100-EXIT.            
P00150     PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------          
      *--  SET UP SQL ERROR PROCESSING                              --          
      *--  DECLARE ASSOCIATED CURSOR                                --          
      *---------------------------------------------------------------          
      *                                                                         
P00150 0100-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
      *                                                                         
           EXEC SQL                                                     
            DECLARE C3512 CURSOR  FOR                        
             SELECT  :S-RETURN-CODE     AS RETURN_CODE,                 
                     :S-ACCOUNT-NO      AS ACCOUNT_NO,                  
                     :S-ACTIVE-PARAGRAPH AS ACTIVE_PARAGRAPH            
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE C3512 CURSOR WITH RETURN FOR                                
MFA-TR*      SELECT  :S-RETURN-CODE     AS RETURN_CODE,                         
MFA-TR*              :S-ACCOUNT-NO      AS ACCOUNT_NO,                          
MFA-TR*              :S-ACTIVE-PARAGRAPH AS ACTIVE_PARAGRAPH                    
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
                                                                        
P00150 0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
P00150* 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
                                                                        
P00150 1000-PROCESS-INPUT.                                              
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
      * POPULATE RETURN VARIABLES                                               
           MOVE ZERO                         TO S-RETURN-CODE.          
           MOVE IN-ACCOUNT-NO                TO S-ACCOUNT-NO.           
      *                                                                         
           IF IN-ACCOUNT-NO > SPACES                                    
              MOVE IN-ACCOUNT-NO         TO WS-PARM-ACCOUNT-NO          
              MOVE WS-PARM-ACCOUNT-NO    TO AT-ACCOUNT-NO               
                                            WS-ACCOUNT-NO               
P00150                                      NF-ACCOUNT-NO               
LISH                                        YP-ACCOUNT-NO               
LISH       ELSE                                                         
LISH          MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
LISH          MOVE '1100'          TO ACTIVE-PARAGRAPH                  
LISH          MOVE 'RECEIVE INPUT' TO ABEND-FUNCTION                    
LISH          MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                   
LISH          MOVE IN-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1                 
LISH          MOVE +100 TO WS-ACTIVE-RETURN-CODE                        
LISH          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
LISH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
P00150     PERFORM 7000-GET-EDI-INDICATOR     THRU 7000-EXIT.           
                                                                        
P00150     IF EDI-ACCT-YES                                              
P00150        MOVE +200 TO S-RETURN-CODE                                
P00150     ELSE                                                         
P00150        PERFORM 1500-PROCESS-BILL-PREF  THRU 1500-EXIT            
P00150        PERFORM 1600-PROCESS-PMT-REMIND THRU 1600-EXIT            
P00150     END-IF.                                                      
                                                                        
           ADD +1 TO CTR-ROWS.                                          
                                                                        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00150**************************************************************            
P00150* 1500-PROCESS-BILL-PREF                                                  
P00150**************************************************************            
      *                                                                         
       1500-PROCESS-BILL-PREF.                                          
      *                                                                         
           EVALUATE IN-BILL-PREFERENCE                                  
P00596        WHEN WS-1-EMAIL-ONLY                                      
                 PERFORM 2300-EMAIL-ONLY THRU 2300-EXIT                 
P00596        WHEN WS-2-EMAIL-PAPER                                     
                 PERFORM 3300-EMAIL-AND-PAPER THRU 3300-EXIT            
P00596        WHEN WS-3-PAPER-ONLY                                      
                 PERFORM 4300-PAPER-ONLY THRU 4300-EXIT                 
P00596        WHEN WS-4-NOEMAIL-NOPAPER                                 
                 PERFORM 5300-NO-BILLNOTIFY THRU 5300-EXIT              
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
      *                                                                         
P00150 1500-EXIT.                                                       
P00150     EXIT.                                                        
      *                                                                         
P00150**************************************************************            
P00150* 1600-PROCESS-PMT-REMIND                                                 
P00150**************************************************************            
      *                                                                         
       1600-PROCESS-PMT-REMIND.                                         
      *                                                                         
           PERFORM 8000-CHECK-PMTREMINDER THRU 8000-EXIT                
      *                                                                         
           EVALUATE IN-PMT-REMINDER                                     
              WHEN '1'                                                  
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE 'R' TO WS-MT-TRN-HST-DET                       
                    MOVE 'EMAIL PMT REMINDER' TO YP-ATTRIBUTE-DESC      
P00596              MOVE 'YES'                TO YP-ATTRIBUTE-VALUE-CD  
                    PERFORM 3100-DEL-ACCT-ATTRIBUTE THRU 3100-EXIT      
                    IF WS-TRAN-APPL-NO EQUAL 0                          
                       PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT   
                       PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT     
                    ELSE                                                
                       PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT     
                    END-IF                                              
                 END-IF                                                 
                 MOVE 'N' TO WS-MT-TRN-HST-DET                          
              WHEN '2'                                                  
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE 'S' TO WS-MT-TRN-HST-DET                       
                    PERFORM 2010-MOVE-ACCT-ATTRIBUTE THRU  2010-EXIT    
                    PERFORM 2100-INS-ACCT-ATTRIBUTE  THRU 2100-EXIT     
                    IF WS-TRAN-APPL-NO EQUAL 0                          
                       PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT   
                       PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT     
                    ELSE                                                
                       PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT     
                    END-IF                                              
                 END-IF                                                 
                 MOVE 'N' TO WS-MT-TRN-HST-DET                          
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
P00150 1600-EXIT.                                                       
P00150     EXIT.                                                        
      *                                                                         
      **************************************************************            
      * 1700-UPD-MNT-TRANS-HIST                                                 
      **************************************************************            
       1700-UPD-MNT-TRANS-HIST.                                         
                                                                        
      * UPDATE MNT TRANS HIST HEADER                                            
                                                                        
            PERFORM 7100-GET-CURRENT-DATETIME THRU 7100-EXIT.           
                                                                        
            MOVE WS-CURRENT-TIMESTMP TO MH-TRANS-HIST-SEQ-NO.           
            MOVE WS-CURRENT-DATE TO MH-DATE-TRANS.                      
                                                                        
            MOVE 'F' TO MH-CODE-TRAN-TYPE.                              
                                                                        
            PERFORM 7150-GET-RESP-AREA THRU 7150-EXIT.                  
                                                                        
            MOVE WS-RESP-AREA TO MH-RESP-AREA-ID.                       
            MOVE ZEROES        TO MH-CUSTOMER-NO.                       
            MOVE IN-ACCOUNT-NO TO  MH-ACCOUNT-NO.                       
            MOVE ZEROS TO MH-PREMISE-NO.                                
            MOVE IN-USERID TO MH-USER-ID.                               
                                                                        
            MOVE 'CSR03512A' TO MH-APPL-PROGRAM-ID.                     
                                                                        
            MOVE ZEROES             TO MH-TRAN-COMMENT-LEN.             
            MOVE SPACES            TO MH-TRAN-COMMENT-TEXT.             
                                                                        
            MOVE +1 TO WS-TRAN-APPL-NO.                                 
                                                                        
            MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.          
                                                                        
            MOVE +24                      TO MH-TRAN-COMMENT-LEN        
            MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT.      
                                                                        
      * UPDATE MNT TRANS HIST DETAIL                                            
                                                                        
       1700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1800-LOAD-MNT-DTL-UPD.                                         *        
      ******************************************************************        
       1800-LOAD-MNT-DTL-UPD.                                           
                                                                        
           IF NO-OF-COPIES                                              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE WS-OLD-NO-OF-COPIES                                  
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-NEW-NO-OF-COPIES      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE 'NO. BILL COPIES'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
P00596     IF (INSERT-EMAIL-ONLY   OR  INSERT-EMAIL-PAPER               
P00596     OR  INSERT-PAPER-ONLY   OR  INSERT-BILLNOTIFY)               
P00596        MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
P00596        MOVE SPACES                    TO MI-TABLE-ID             
P00596        MOVE 'BILL NOTIFY OPT'         TO MI-COLUMN-DESC          
P00596                                                                  
P00596        PERFORM 5500-SET-PREV-N-CRNT-BILNTFY                      
P00596                                       THRU 5500-EXIT             
P00596        IF MI-CHG-COLUMN-VALUE-TEXT NOT EQUAL                     
P00596                                       MI-PRV-COLUMN-VALUE-TEXT   
P00596           PERFORM 6530-LOAD-MNT-TRANS-HIST                       
P00596                                       THRU 6530-EXIT             
P00596           ADD 1                       TO WS-TRAN-APPL-NO         
P00596        END-IF                                                    
P00596     END-IF.                                                      
                                                                        
           IF DELETE-PMTREMINDER                                        
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE ' REMINDER '                                         
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 'NO REMINDER'            TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +11                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE 'PMT REMINDER'           TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF INSERT-PMTREMINDER                                        
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'NO REMINDER'                                        
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +11                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE ' REMINDER '             TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE 'PMT REMINDER'           TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       1800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-SELECT-NO-OF-COPIES.                                        
                                                                        
           EXEC SQL                                                     
              SELECT NO_BILL_COPIES                                     
P00596              ,CUSTOMER_NO                                        
              INTO   :AT-NO-BILL-COPIES                                 
P00596              ,:AT-CUSTOMER-NO                                    
              FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                            
LISH          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NO_BILL_COPIES                                             
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*       INTO   :AT-NO-BILL-COPIES                                         
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*       FROM CSS_ACCOUNT                                                  
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AT-NO-BILL-COPIES TO WS-OLD-NO-OF-COPIES             
           ELSE                                                         
              MOVE SQLCODE TO S-RETURN-CODE                             
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2000'          TO ACTIVE-PARAGRAPH                  
                                      S-ACTIVE-PARAGRAPH                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2010-MOVE-ACCT-ATTRIBUTE                                                
      ******************************************************************        
                                                                        
       2010-MOVE-ACCT-ATTRIBUTE.                                        
      *                                                                         
           MOVE WS-ACCOUNT-NO TO YP-ACCOUNT-NO.                         
      *                                                                         
           IF INSERT-PAPER-ONLY  OR INSERT-BILLNOTIFY                   
P00596        IF IN-BILL-PREFERENCE      = WS-3-PAPER-ONLY              
                 MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-DESC            
P00596        ELSE IF IN-BILL-PREFERENCE = WS-4-NOEMAIL-NOPAPER         
                 MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-DESC           
              END-IF                                                    
           END-IF
           END-IF.                                                      
      *                                                                         
           IF INSERT-PMTREMINDER                                        
              MOVE 'EMAIL PMT REMINDER' TO YP-ATTRIBUTE-DESC            
           END-IF.                                                      
      *                                                                         
           PERFORM 2160-CSS-ATTRIBUTE THRU 2160-EXIT.                   
           IF WZ-ATTRIB-DFLT-VAL-CD = 'NO'                              
              MOVE 'YES'          TO YP-ATTRIBUTE-VALUE-CD              
           ELSE IF WZ-ATTRIB-DFLT-VAL-CD = 'YES'                        
              MOVE 'NO'          TO YP-ATTRIBUTE-VALUE-CD               
           END-IF
           END-IF.                                                      
           MOVE WZ-ATTRIB-DFLT-VAL-TX TO YP-ATTRIBUTE-VALUE-TX.         
                                                                        
      *                                                                         
           PERFORM 7100-GET-CURRENT-DATETIME THRU 7100-EXIT.            
           MOVE WS-CURRENT-DATE TO YP-ATTRIBUTE-VALUE-DT.               
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-INS-ACCT-ATTRIBUTE                                                 
      ******************************************************************        
                                                                        
       2100-INS-ACCT-ATTRIBUTE.                                         
           EXEC SQL                                                     
                INSERT INTO CSS_ACCT_ATTRIBUTE                          
                     ( ACCOUNT_NO,                                      
                       ATTRIBUTE_DESC,                                  
                       ATTRIBUTE_VALUE_CD,                              
                       ATTRIBUTE_VALUE_DT,                              
                       ATTRIBUTE_VALUE_TX)                              
                VALUES                                                  
                     ( :YP-ACCOUNT-NO,                                  
                       :YP-ATTRIBUTE-DESC,                              
                       :YP-ATTRIBUTE-VALUE-CD,                          
                       IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) ),                      
                       :YP-ATTRIBUTE-VALUE-TX)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ACCT_ATTRIBUTE                                  
MFA-TR*              ( ACCOUNT_NO,                                              
MFA-TR*                ATTRIBUTE_DESC,                                          
MFA-TR*                ATTRIBUTE_VALUE_CD,                                      
MFA-TR*                ATTRIBUTE_VALUE_DT,                                      
MFA-TR*                ATTRIBUTE_VALUE_TX)                                      
MFA-TR*         VALUES                                                          
MFA-TR*              ( :YP-ACCOUNT-NO,                                          
MFA-TR*                :YP-ATTRIBUTE-DESC,                                      
MFA-TR*                :YP-ATTRIBUTE-VALUE-CD,                                  
MFA-TR*                :YP-ATTRIBUTE-VALUE-DT,                                  
MFA-TR*                :YP-ATTRIBUTE-VALUE-TX)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO S-RETURN-CODE                             
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2100'          TO ACTIVE-PARAGRAPH                  
                                      S-ACTIVE-PARAGRAPH                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2160-CSS-ATTRIBUTE.                                            *        
      ******************************************************************        
       2160-CSS-ATTRIBUTE.                                              
                                                                        
           MOVE YP-ATTRIBUTE-DESC TO WZ-ATTRIBUTE-DESC                  
           MOVE IN-COMPANY-NO     TO WZ-COMPANY-NO                      
                                                                        
           EXEC SQL                                                     
                SELECT ATTRIB_DFLT_VAL_CD                               
                      ,ATTRIB_DFLT_VAL_TX                               
LISH  *               ,AT.COMPANY_NO                                            
                INTO   :WZ-ATTRIB-DFLT-VAL-CD                           
                      ,:WZ-ATTRIB-DFLT-VAL-TX                           
LISH  *               ,:AT-COMPANY-NO                                           
                  FROM CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                   
LISH  *               ,CSS_ACCOUNT   AT                                 00450010
LISH             WHERE WZ.ATTRIBUTE_DESC = :WZ-ATTRIBUTE-DESC           
LISH  *            AND ACCOUNT_NO     = :WS-ACCOUNT-NO                          
LISH               AND WZ.COMPANY_NO  = :WZ-COMPANY-NO                  
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ATTRIB_DFLT_VAL_CD                                       
MFA-TR*               ,ATTRIB_DFLT_VAL_TX                                       
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*         INTO   :WZ-ATTRIB-DFLT-VAL-CD                                   
MFA-TR*               ,:WZ-ATTRIB-DFLT-VAL-TX                                   
MFA-TR*               ,:AT-COMPANY-NO                                           
MFA-TR*           FROM CSS_ATTRIBUTE WZ                                 00450010
MFA-TR*               ,CSS_ACCOUNT   AT                                 00450010
MFA-TR*          WHERE WZ.ATTRIBUTE_DESC = :WZ-ATTRIBUTE-DESC                   
MFA-TR*            AND ACCOUNT_NO     = :WS-ACCOUNT-NO                          
MFA-TR*            AND WZ.COMPANY_NO  = :WZ-COMPANY-NO                          
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO S-RETURN-CODE                             
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2160'          TO ACTIVE-PARAGRAPH                  
                                      S-ACTIVE-PARAGRAPH                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ATTRIBUTE     ' TO TABLE-1                      
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       2160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-EMAIL-ONLY                                                *        
      ******************************************************************        
                                                                        
       2300-EMAIL-ONLY.                                                 
                                                                        
           PERFORM 2000-SELECT-NO-OF-COPIES    THRU 2000-EXIT.          
           IF WS-OLD-NO-OF-COPIES NOT = 0                               
              MOVE 0 TO WS-NEW-NO-OF-COPIES                             
              PERFORM 3000-UPDATE-NO-OF-COPIES THRU 3000-EXIT           
           END-IF.                                                      
           PERFORM 5000-INS-EMAIL-OR-EMAILNPAPER THRU 5000-EXIT.        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2310-DELETE-EMAIL-ONLY.                                        *        
      ******************************************************************        
       2310-DELETE-EMAIL-ONLY.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ACCT_ATTRIBUTE                           
LISH           WHERE ACCOUNT_NO             = :YP-ACCOUNT-NO            
P00596           AND ((ATTRIBUTE_DESC       = 'EMAIL_PAPERONLY'         
P00596             AND ATTRIBUTE_VALUE_CD   = 'YES')                    
P00596            OR  (ATTRIBUTE_DESC       = 'EMAIL_BILLNOTIFY'        
P00596             AND ATTRIBUTE_VALUE_CD   = 'NO'))                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00596        IF IN-BILL-PREFERENCE = WS-1-EMAIL-ONLY                   
P00596           SET INSERT-EMAIL-ONLY       TO TRUE                    
              ELSE                                                      
P00596           IF IN-BILL-PREFERENCE = WS-2-EMAIL-PAPER               
P00596              SET INSERT-EMAIL-PAPER   TO TRUE                    
                 END-IF                                                 
              END-IF                                                    
              IF WS-TRAN-APPL-NO EQUAL 0                                
                 PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT         
                 PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT           
              ELSE                                                      
                 PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT           
              END-IF                                                    
              MOVE 'N' TO WS-MT-TRN-HST-DET                             
           ELSE                                                         
              MOVE SQLCODE TO S-RETURN-CODE                             
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2310'          TO ACTIVE-PARAGRAPH                  
                                      S-ACTIVE-PARAGRAPH                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 3000-UPDATE-NO-OF-COPIES.                                      *        
      ******************************************************************        
       3000-UPDATE-NO-OF-COPIES.                                        
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ACCOUNT                                         
                SET NO_BILL_COPIES     = :WS-NEW-NO-OF-COPIES           
              WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'O' TO WS-MT-TRN-HST-DET                             
              IF WS-TRAN-APPL-NO EQUAL 0                                
                 PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT         
                 PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT           
              ELSE                                                      
                 PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT           
              END-IF                                                    
              MOVE 'N' TO WS-MT-TRN-HST-DET                             
           ELSE                                                         
              MOVE SQLCODE TO S-RETURN-CODE                             
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '3000'          TO ACTIVE-PARAGRAPH                  
                                      S-ACTIVE-PARAGRAPH                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 3100-DEL-ACCT-ATTRIBUTE.                                       *        
      ******************************************************************        
       3100-DEL-ACCT-ATTRIBUTE.                                         
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ACCT_ATTRIBUTE                           
               WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                
                 AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC            
P00596           AND ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO S-RETURN-CODE                             
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '3100'          TO ACTIVE-PARAGRAPH                  
                                      S-ACTIVE-PARAGRAPH                
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 3300-EMAIL-AND-PAPER.                                          *        
      ******************************************************************        
       3300-EMAIL-AND-PAPER.                                            
                                                                        
           PERFORM 2000-SELECT-NO-OF-COPIES    THRU 2000-EXIT.          
           IF WS-OLD-NO-OF-COPIES < 1                                   
              MOVE 1 TO WS-NEW-NO-OF-COPIES                             
              PERFORM 3000-UPDATE-NO-OF-COPIES THRU 3000-EXIT           
           END-IF.                                                      
           PERFORM 5000-INS-EMAIL-OR-EMAILNPAPER THRU 5000-EXIT.        
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 4300-PAPER-ONLY.                                               *        
      ******************************************************************        
       4300-PAPER-ONLY.                                                 
                                                                        
           PERFORM 2000-SELECT-NO-OF-COPIES THRU 2000-EXIT.             
                                                                        
           IF WS-OLD-NO-OF-COPIES < 1                                   
              MOVE 1 TO WS-NEW-NO-OF-COPIES                             
              PERFORM 3000-UPDATE-NO-OF-COPIES THRU 3000-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 4350-CHECK-BILLNOTIFY  THRU 4350-EXIT.               
           PERFORM 4310-CHECK-PAPER-ONLY  THRU 4310-EXIT.               
                                                                        
       4300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 4310-CHECK-PAPER-ONLY.                                         *        
      ******************************************************************        
       4310-CHECK-PAPER-ONLY.                                           
                                                                        
           EXEC SQL                                                     
                SELECT ATTRIBUTE_DESC                                   
P00596          INTO   :WS-ATTRIBUTE-DESC                               
                FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO               
                 AND ATTRIBUTE_DESC      = 'EMAIL_PAPERONLY'            
P00596           AND ATTRIBUTE_VALUE_CD  = 'YES'                        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ATTRIBUTE_DESC                                           
MFA-TR*         INTO   :WS-ATTRIBUTE-DESC                                       
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE                                 00450010
MFA-TR*         WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                       
MFA-TR*          AND ATTRIBUTE_DESC      = 'EMAIL_PAPERONLY'                    
MFA-TR*          AND ATTRIBUTE_VALUE_CD  = 'YES'                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
LISH       EVALUATE WS-ACTIVE-RETURN-CODE                               
LISH          WHEN SUCCESSFUL-CALL                                      
LISH             EVALUATE IN-BILL-PREFERENCE                            
P00596              WHEN WS-4-NOEMAIL-NOPAPER                           
LISH                   MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-DESC      
P00596                 MOVE 'YES'             TO YP-ATTRIBUTE-VALUE-CD  
LISH                   PERFORM 3100-DEL-ACCT-ATTRIBUTE THRU 3100-EXIT   
LISH                WHEN OTHER                                          
LISH                   CONTINUE                                         
LISH             END-EVALUATE                                           
LISH          WHEN NOT-FOUND                                            
LISH             EVALUATE IN-BILL-PREFERENCE                            
P00596              WHEN WS-3-PAPER-ONLY                                
P00596                 SET INSERT-PAPER-ONLY TO TRUE                    
LISH                   PERFORM 2010-MOVE-ACCT-ATTRIBUTE THRU  2010-EXIT 
LISH                   PERFORM 2100-INS-ACCT-ATTRIBUTE  THRU 2100-EXIT  
LISH                   IF WS-TRAN-APPL-NO EQUAL 0                       
LISH                     PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT 
LISH                     PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT   
LISH                   ELSE                                             
LISH                     PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT   
LISH                   END-IF                                           
LISH                   MOVE 'N' TO WS-MT-TRN-HST-DET                    
LISH                WHEN OTHER                                          
LISH                   CONTINUE                                         
LISH             END-EVALUATE                                           
LISH          WHEN OTHER                                                
LISH             MOVE SQLCODE TO S-RETURN-CODE                          
LISH             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
LISH             MOVE '4310'          TO ACTIVE-PARAGRAPH               
LISH                                     S-ACTIVE-PARAGRAPH             
LISH             MOVE 'FETCH'              TO ABEND-FUNCTION            
LISH             MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                   
LISH             MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-1           
LISH             MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
LISH             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
LISH             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
LISH          END-EVALUATE.                                             
       4310-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 4350-CHECK-BILLNOTIFY.                                         *        
      ******************************************************************        
       4350-CHECK-BILLNOTIFY.                                           
                                                                        
           EXEC SQL                                                     
                SELECT ATTRIBUTE_DESC                                   
P00596          INTO   :WS-ATTRIBUTE-DESC                               
                FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO               
                 AND ATTRIBUTE_DESC      = 'EMAIL_BILLNOTIFY'           
P00596           AND ATTRIBUTE_VALUE_CD  = 'NO'                         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ATTRIBUTE_DESC                                           
MFA-TR*         INTO   :WS-ATTRIBUTE-DESC                                       
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE                                 00450010
MFA-TR*         WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                       
MFA-TR*          AND ATTRIBUTE_DESC      = 'EMAIL_BILLNOTIFY'                   
MFA-TR*          AND ATTRIBUTE_VALUE_CD  = 'NO'                                 
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
LISH       EVALUATE WS-ACTIVE-RETURN-CODE                               
LISH          WHEN SUCCESSFUL-CALL                                      
LISH             EVALUATE IN-BILL-PREFERENCE                            
P00596              WHEN WS-3-PAPER-ONLY                                
LISH                   MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-DESC     
P00596                 MOVE 'NO'               TO YP-ATTRIBUTE-VALUE-CD 
LISH                   PERFORM 3100-DEL-ACCT-ATTRIBUTE THRU 3100-EXIT   
LISH                WHEN OTHER                                          
LISH                   CONTINUE                                         
LISH             END-EVALUATE                                           
LISH          WHEN NOT-FOUND                                            
LISH             EVALUATE IN-BILL-PREFERENCE                            
P00596              WHEN WS-4-NOEMAIL-NOPAPER                           
P00596                 SET INSERT-BILLNOTIFY TO TRUE                    
LISH                   PERFORM 2010-MOVE-ACCT-ATTRIBUTE THRU  2010-EXIT 
LISH                   PERFORM 2100-INS-ACCT-ATTRIBUTE  THRU 2100-EXIT  
LISH                   IF WS-TRAN-APPL-NO EQUAL 0                       
LISH                     PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT 
LISH                     PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT   
LISH                   ELSE                                             
LISH                     PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT   
LISH                   END-IF                                           
LISH                   MOVE 'N' TO WS-MT-TRN-HST-DET                    
LISH                WHEN OTHER                                          
LISH                   CONTINUE                                         
LISH             END-EVALUATE                                           
LISH          WHEN OTHER                                                
LISH             MOVE SQLCODE TO S-RETURN-CODE                          
LISH             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
LISH             MOVE '4350'          TO ACTIVE-PARAGRAPH               
LISH                                     S-ACTIVE-PARAGRAPH             
LISH             MOVE 'FETCH'              TO ABEND-FUNCTION            
LISH             MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                   
LISH             MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-1           
LISH             MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
LISH             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
LISH             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
LISH          END-EVALUATE.                                             
       4350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00596******************************************************************        
P00596* 5000-INS-EMAIL-OR-EMAILNPAPER                                  *        
P00596******************************************************************        
P00596 5000-INS-EMAIL-OR-EMAILNPAPER.                                   
P00596                                                                  
P00596     PERFORM 5100-SELECT-EMAIL-ATTR        THRU 5100-EXIT.        
P00596                                                                  
P00596     IF WS-ACTIVE-RETURN-CODE      = SUCCESSFUL-CALL              
P00596        PERFORM 2310-DELETE-EMAIL-ONLY     THRU 2310-EXIT         
P00596     ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
P00596        IF IN-BILL-PREFERENCE      = WS-1-EMAIL-ONLY              
P00596           SET INSERT-EMAIL-ONLY       TO TRUE                    
P00596        ELSE                                                      
P00596           IF IN-BILL-PREFERENCE   = WS-2-EMAIL-PAPER             
P00596              SET INSERT-EMAIL-PAPER   TO TRUE                    
P00596           END-IF                                                 
P00596        END-IF                                                    
P00596        IF WS-TRAN-APPL-NO EQUAL 0                                
P00596           PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT         
P00596           PERFORM 1800-LOAD-MNT-DTL-UPD   THRU 1800-EXIT         
P00596        ELSE                                                      
P00596           PERFORM 1800-LOAD-MNT-DTL-UPD   THRU 1800-EXIT         
P00596        END-IF                                                    
P00596        MOVE 'N'                       TO WS-MT-TRN-HST-DET       
P00596     END-IF
           END-IF.                                                      
P00596                                                                  
P00596 5000-EXIT.                                                       
P00596     EXIT.                                                        
P00596******************************************************************        
P00596* 5100-SELECT-EMAIL-ATTR.                                        *        
P00596******************************************************************        
P00596 5100-SELECT-EMAIL-ATTR.                                          
P00596                                                                  
P00596     EXEC SQL                                                     
P00596        SELECT ATTRIBUTE_DESC                                     
P00596          INTO :WS-ATTRIBUTE-DESC                                 
P00596          FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
P00596         WHERE ACCOUNT_NO           = :YP-ACCOUNT-NO              
P00596         AND ((ATTRIBUTE_DESC       = 'EMAIL_PAPERONLY'           
P00596           AND ATTRIBUTE_VALUE_CD   = 'YES')                      
P00596          OR  (ATTRIBUTE_DESC       = 'EMAIL_BILLNOTIFY'          
P00596           AND ATTRIBUTE_VALUE_CD   = 'NO'))                      
P00596                                                           
P00596     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ATTRIBUTE_DESC                                             
MFA-TR*         INTO :WS-ATTRIBUTE-DESC                                         
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE                                         
MFA-TR*        WHERE ACCOUNT_NO           = :YP-ACCOUNT-NO                      
MFA-TR*        AND ((ATTRIBUTE_DESC       = 'EMAIL_PAPERONLY'                   
MFA-TR*          AND ATTRIBUTE_VALUE_CD   = 'YES')                              
MFA-TR*         OR  (ATTRIBUTE_DESC       = 'EMAIL_BILLNOTIFY'                  
MFA-TR*          AND ATTRIBUTE_VALUE_CD   = 'NO'))                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
P00596     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5100'                    TO ACTIVE-PARAGRAPH        
                                                S-ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
              MOVE 'ATTRIBUTE_DESC'          TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 5300-NO-BILLNOTIFY.                                            *        
      ******************************************************************        
       5300-NO-BILLNOTIFY.                                              
                                                                        
           PERFORM 2000-SELECT-NO-OF-COPIES THRU 2000-EXIT.             
           IF WS-OLD-NO-OF-COPIES NOT = 0                               
              MOVE 0 TO WS-NEW-NO-OF-COPIES                             
              PERFORM 3000-UPDATE-NO-OF-COPIES THRU 3000-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 4310-CHECK-PAPER-ONLY  THRU 4310-EXIT.               
           PERFORM 4350-CHECK-BILLNOTIFY  THRU 4350-EXIT.               
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
P00596******************************************************************        
P00596* 5500-SET-PREV-N-CRNT-BILNTFY.                                  *        
P00596******************************************************************        
P00596 5500-SET-PREV-N-CRNT-BILNTFY.                                    
P00596                                                                  
P00596     EVALUATE WS-ATTRIBUTE-DESC                                   
P00596        WHEN 'EMAIL_PAPERONLY'                                    
P00596             MOVE 'PAPER ONLY'         TO MI-PRV-COLUMN-VALUE-TEXT
P00596             MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN 
P00596        WHEN 'EMAIL_BILLNOTIFY'                                   
P00596             MOVE 'NO PAPER/NO EMAIL'  TO MI-PRV-COLUMN-VALUE-TEXT
P00596             MOVE +17                  TO MI-PRV-COLUMN-VALUE-LEN 
P00596        WHEN OTHER                                                
P00596             IF WS-OLD-NO-OF-COPIES  > 0                          
P00596                PERFORM 5600-SELECT-CUST-STAT THRU 5600-EXIT      
P00596                IF CE-EBILL-REGISTER-IND = 'Y'                    
P00596                   MOVE 'EMAIL AND PAPER'                         
P00596                                       TO MI-PRV-COLUMN-VALUE-TEXT
P00596                   MOVE +15            TO MI-PRV-COLUMN-VALUE-LEN 
P00596                ELSE                                              
P00596                   MOVE 'SYSTEM DEFAULT PAPER ONLY'               
P00596                                       TO MI-PRV-COLUMN-VALUE-TEXT
P00596                   MOVE +25            TO MI-PRV-COLUMN-VALUE-LEN 
P00596                END-IF                                            
P00596             ELSE                                                 
P00596                MOVE 'EMAIL ONLY'      TO MI-PRV-COLUMN-VALUE-TEXT
P00596                MOVE +10               TO MI-PRV-COLUMN-VALUE-LEN 
P00596             END-IF                                               
P00596     END-EVALUATE.                                                
P00596                                                                  
P00596     EVALUATE TRUE                                                
P00596        WHEN INSERT-EMAIL-ONLY                                    
P00596             MOVE 'EMAIL ONLY'         TO MI-CHG-COLUMN-VALUE-TEXT
P00596             MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN 
P00596        WHEN INSERT-EMAIL-PAPER                                   
P00596             MOVE 'EMAIL AND PAPER'    TO MI-CHG-COLUMN-VALUE-TEXT
P00596             MOVE +15                  TO MI-CHG-COLUMN-VALUE-LEN 
P00596        WHEN INSERT-PAPER-ONLY                                    
P00596             MOVE 'PAPER ONLY'         TO MI-CHG-COLUMN-VALUE-TEXT
P00596             MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN 
P00596        WHEN INSERT-BILLNOTIFY                                    
P00596             MOVE 'NO PAPER/NO EMAIL'  TO MI-CHG-COLUMN-VALUE-TEXT
P00596             MOVE +17                  TO MI-CHG-COLUMN-VALUE-LEN 
P00596     END-EVALUATE.                                                
P00596                                                                  
P00596 5500-EXIT.                                                       
P00596     EXIT.                                                        
P00596******************************************************************        
P00596* 5600-SELECT-CUST-STAT.                                         *        
P00596******************************************************************        
P00596 5600-SELECT-CUST-STAT.                                           
P00596                                                                  
P00596     MOVE AT-CUSTOMER-NO               TO CE-CUSTOMER-NO.         
P00596                                                                  
P00596     EXEC SQL                                                     
P00596          SELECT EBILL_REGISTER_IND                               
P00596            INTO :CE-EBILL-REGISTER-IND                           
P00596            FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                     
P00596           WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                  
P00596             AND CUSTOMER_TYPE = 'C'                              
P00596                                                           
P00596                                                      
P00596     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT EBILL_REGISTER_IND                                       
MFA-TR*           INTO :CE-EBILL-REGISTER-IND                                   
MFA-TR*           FROM CSS_CUST_STATS                                           
MFA-TR*          WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                          
MFA-TR*            AND CUSTOMER_TYPE = 'C'                                      
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 5600                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00596                                                                  
P00596     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00596                                                                  
P00596     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00596        CONTINUE                                                  
P00596     ELSE                                                         
P00596        MOVE SQLCODE               TO S-RETURN-CODE               
P00596        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00596        MOVE SQLCODE               TO ABEND-SQLCODE               
P00596        MOVE SQLSTATE              TO ABEND-SQLSTATE              
P00596        MOVE '5600'                TO ACTIVE-PARAGRAPH            
P00596                                      S-ACTIVE-PARAGRAPH          
P00596        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00596        MOVE 'CSS_CUST_STAT'       TO TABLE-1                     
P00596        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
P00596        MOVE CE-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
P00596        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P00596        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P00596     END-IF.                                                      
P00596*                                                                         
P00596 5600-EXIT.                                                       
P00596     EXIT.                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST.                                               
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
P00150******************************************************************        
P00150* 7000-GET-EDI-INDICATOR.                                        *        
P00150******************************************************************        
P00150 7000-GET-EDI-INDICATOR.                                          
                                                                        
           EXEC SQL                                                     
                SELECT 'Y'                                              
                  INTO :WS-EDI-ACCT-SW                                  
                  FROM CSS_EDI_ACCT_DEST NF WITH(READUNCOMMITTED)               
                 WHERE NF.ACCOUNT_NO   = :NF-ACCOUNT-NO                 
                   AND NF.STATUS_CD    = 'A'                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EDI-ACCT-SW                                          
MFA-TR*           FROM CSS_EDI_ACCT_DEST NF                                     
MFA-TR*          WHERE NF.ACCOUNT_NO   = :NF-ACCOUNT-NO                         
MFA-TR*            AND NF.STATUS_CD    = 'A'                                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
                                            S-ACTIVE-PARAGRAPH          
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_EDI_ACCT_DEST'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO '         TO TABLE-ELEMENT-1             
              MOVE NF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
P00150 7000-EXIT.                                                       
P00150     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-CURRENT-DATETIME.                                     *        
      ******************************************************************        
       7100-GET-CURRENT-DATETIME.                                       
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTMP,
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP,                     
MFA-TR*           :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO S-RETURN-CODE                             
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
                                      S-ACTIVE-PARAGRAPH                
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7150-GET-RESP-AREA.                                            *        
      ******************************************************************        
       7150-GET-RESP-AREA.                                              
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA                                      
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :IN-USERID                               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :WS-RESP-AREA                                              
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :IN-USERID                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO S-RETURN-CODE                             
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
                                      S-ACTIVE-PARAGRAPH                
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE IN-USERID              TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8000-CHECK-PMTREMINDER.                                        *        
      ******************************************************************        
       8000-CHECK-PMTREMINDER.                                          
                                                                        
           EXEC SQL                                                     
                SELECT ACCOUNT_NO                                       
                      ,ATTRIBUTE_DESC                                   
                INTO   :YP-ACCOUNT-NO                                   
                      ,:YP-ATTRIBUTE-DESC                               
                  FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                 
                 WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                      
                 AND ATTRIBUTE_DESC = 'EMAIL PMT REMINDER'              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ACCOUNT_NO                                               
MFA-TR*               ,ATTRIBUTE_DESC                                           
MFA-TR*         INTO   :YP-ACCOUNT-NO                                           
MFA-TR*               ,:YP-ATTRIBUTE-DESC                                       
MFA-TR*           FROM CSS_ACCT_ATTRIBUTE                               00450010
MFA-TR*          WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                              
MFA-TR*          AND ATTRIBUTE_DESC = 'EMAIL PMT REMINDER'                      
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
LISH       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO S-RETURN-CODE                             
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8000'          TO ACTIVE-PARAGRAPH                  
                                      S-ACTIVE-PARAGRAPH                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN C3512                                               
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3512 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
      **   INITIALIZE GTT-RETURN-FIELDS.                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9100-CHECK-ERROR                                               *        
      ******************************************************************        
       9100-CHECK-ERROR.                                                
           EXIT.                                                        
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
