       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03511.                                     
COB303 DATE-WRITTEN.     JANUARY 13, 2005.                              
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03511              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03511 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVES EMAIL ATTRIBUTES FOR ACCOUNT OR CUSTOMER     --         
      *--     BASED UPON THE INPUT PARAMETERS.                       --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            CUSTOMER_NO           CHAR(10)                  --         
      *--            COMPANY_NO            CHAR(02)                  --         
      *--            ATTRIBUTE_TYPE        CHAR(01)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
C29533*--  13 JAN 2005   SS19371     NEW CODE                        --         
C37303*--  05/2102008    FMB         DELETE ALL REFERENCES TO        --         
C37303*--                            CSS_CUST_ATTRIBUTE              --         
      *--                                                            --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03511'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT, AT                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MODEL_SQL, MS                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ATTRIBUTE, WZ                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATTRIB                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_ATTRIBUTE, YP                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPYBOOKS                             *        
      ******************************************************************        
                                                                        
      *    COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
      *                                                                         
       01  WS-ACTIVE-RETURN-CODE1     PIC S9(9)  COMP VALUE 0.          
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03511'.      
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-NAME                PIC X(26) VALUE                  
                                           'SESSION.CSR03511_R1'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
                                                                        
       01  LS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
                                                                        
      ****************************************************************          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
                                                                        
       COPY CWSSP001.                                                           
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE          PIC S9(9) VALUE 0 COMP.            
           10 S-EMAIL-OPTION         PIC X(18) VALUE SPACES.            
           10 S-ATTRIB-VALUE         PIC X(01) VALUE SPACES.            
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
       01  WS-MISC-ITEMS.                                               
           05  WS-EXISTS-FLAG          PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-PARM-ACCOUNT-NO      PIC 9(13) VALUE ZERO.            
           05  WS-PARM-CUSTOMER-NO     PIC 9(10) VALUE ZERO.            
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *     CURSOR DECLARATIONS                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE ATTRIBUTE_CSR CURSOR FOR                          
                SELECT WZ.ATTRIBUTE_DESC                                
                      ,WZ.ATTRIB_DFLT_VAL_CD                            
                      ,WZ.GROUP_SEQ_NO                                  
                      ,WZ.SORT_SEQ_NO                                   
                  FROM CSS_ATTRIBUTE WZ                                 
                 WHERE WZ.COMPANY_NO = :WZ-COMPANY-NO                   
                   AND WZ.ATTRIBUTE_TYPE_TX = 'EMAIL'                   
                   AND WZ.ATTRIBUTE_EFF_DT < CAST(SYSDATETIMEOFFSET() 
           AS DATE)               
                   AND (WZ.ATTRIBUTE_EXP_DT > CAST(SYSDATETIMEOFFSET() 
           AS DATE) OR           
                        WZ.ATTRIBUTE_EXP_DT IS NULL)                    
                   AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
                   AND WZ.ATTRIB_LEVEL_CD = :WZ-ATTRIB-LEVEL-CD         
                   AND WZ.ATTRIBUTE_DESC <> 'EMAIL_PAPERONLY'           
                   AND WZ.ATTRIBUTE_DESC <> 'EMAIL_BILLNOTIFY'          
                 ORDER BY GROUP_SEQ_NO, SORT_SEQ_NO                     
                 FOR READ ONLY                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ATTRIBUTE_CSR CURSOR FOR                                  
MFA-TR*         SELECT WZ.ATTRIBUTE_DESC                                        
MFA-TR*               ,WZ.ATTRIB_DFLT_VAL_CD                                    
MFA-TR*               ,WZ.GROUP_SEQ_NO                                          
MFA-TR*               ,WZ.SORT_SEQ_NO                                           
MFA-TR*           FROM CSS_ATTRIBUTE WZ                                 00450010
MFA-TR*          WHERE WZ.COMPANY_NO = :WZ-COMPANY-NO                           
MFA-TR*            AND WZ.ATTRIBUTE_TYPE_TX = 'EMAIL'                           
MFA-TR*            AND WZ.ATTRIBUTE_EFF_DT < CURRENT DATE                       
MFA-TR*            AND (WZ.ATTRIBUTE_EXP_DT > CURRENT DATE OR                   
MFA-TR*                 WZ.ATTRIBUTE_EXP_DT IS NULL)                            
MFA-TR*            AND WZ.ATTRIBUTE_STAT_CD = 'A'                               
MFA-TR*            AND WZ.ATTRIB_LEVEL_CD = :WZ-ATTRIB-LEVEL-CD                 
MFA-TR*            AND WZ.ATTRIBUTE_DESC <> 'EMAIL_PAPERONLY'                   
MFA-TR*            AND WZ.ATTRIBUTE_DESC <> 'EMAIL_BILLNOTIFY'                  
MFA-TR*          ORDER BY GROUP_SEQ_NO, SORT_SEQ_NO                             
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  IN-ACCOUNT-NO               PIC X(13).                       
       01  IN-CUSTOMER-NO              PIC X(10).                       
       01  IN-COMPANY-NO               PIC X(02).                       
       01  IN-ATTRIBUTE-TYPE           PIC X(01).                       
                                                                        
       PROCEDURE DIVISION USING IN-ACCOUNT-NO,                          
                                IN-CUSTOMER-NO,                         
                                IN-COMPANY-NO,                          
                                IN-ATTRIBUTE-TYPE.                      
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *--  0100A-DECLARE-GTT                                        -*          
      *--  DECLARE TEMPORARY TABLE                                  -*          
      ****************************************************************          
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR03511_R1'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03511_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03511_R1
              (                                                    
             RETURN_CODE           INT                              
            ,EMAIL_OPTION CHAR(18)  COLLATE LATIN1_GENERAL_100_BIN2             
            ,ATTRIB_VALUE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03511_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 1000-INITIALIZE-PROCEDURE.                                   *          
      *--  SET UP SQL ERROR PROCESSING                              -*          
      *--  DECLARE ASSOCIATED CURSOR                                -*          
      ****************************************************************          
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR  FOR                        
               SELECT *                                                 
               FROM #CSR03511_R1                                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*        FROM SESSION.CSR03511_R1                                         
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           PERFORM 1500-PROCESS-INPUT         THRU 1500-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1500-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1500-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                                                                        
           MOVE IN-COMPANY-NO            TO WZ-COMPANY-NO.              
                                                                        
           EVALUATE IN-ATTRIBUTE-TYPE                                   
                                                                        
           WHEN 'A'                                                     
              IF IN-ACCOUNT-NO > SPACES                                 
                 MOVE IN-ACCOUNT-NO         TO WS-PARM-ACCOUNT-NO       
                 MOVE WS-PARM-ACCOUNT-NO    TO YP-ACCOUNT-NO            
                 MOVE IN-ATTRIBUTE-TYPE     TO WZ-ATTRIB-LEVEL-CD       
              ELSE                                                      
                 SET SEND-DONE-ERROR TO TRUE                            
              END-IF                                                    
           WHEN 'C'                                                     
              IF IN-CUSTOMER-NO > SPACES                                
                 MOVE IN-CUSTOMER-NO        TO WS-PARM-CUSTOMER-NO      
                 MOVE IN-ATTRIBUTE-TYPE     TO WZ-ATTRIB-LEVEL-CD       
              ELSE                                                      
                 SET SEND-DONE-ERROR TO TRUE                            
              END-IF                                                    
           WHEN OTHER                                                   
              SET SEND-DONE-ERROR TO TRUE                               
           END-EVALUATE                                                 
                                                                        
           IF SEND-DONE-ERROR                                           
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '1500'          TO ACTIVE-PARAGRAPH                  
              MOVE 'RECEIVE INPUT' TO ABEND-FUNCTION                    
              MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                   
              MOVE IN-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1                 
              MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-2                   
              MOVE IN-CUSTOMER-NO  TO HOSTVAR-ELEMENT-2                 
              MOVE 'ATTRIBUTE_TYPE'  TO TABLE-ELEMENT-3                 
              MOVE IN-ATTRIBUTE-TYPE TO HOSTVAR-ELEMENT-3               
              MOVE +100 TO WS-ACTIVE-RETURN-CODE                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-OPEN-ATTRIBUTE-CURSOR THRU 7000-EXIT            
           PERFORM 7100-FETCH-ATTRIBUTE-CURSOR THRU 7100-EXIT           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 IF IN-ATTRIBUTE-TYPE = 'A'                             
                    PERFORM 7300-GET-ACCT-CODES THRU 7300-EXIT          
                 END-IF                                                 
                 PERFORM 7100-FETCH-ATTRIBUTE-CURSOR THRU 7100-EXIT     
              END-PERFORM                                               
           END-IF.                                                      
           PERFORM 7200-CLOSE-ATTRIBUTE-CURSOR THRU 7200-EXIT.          
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE NOT-FOUND TO S-RETURN-CODE                           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-ATTRIBUTE-CURSOR.                                    *        
      ******************************************************************        
       7000-OPEN-ATTRIBUTE-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              OPEN ATTRIBUTE_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
              MOVE 'OPEN '              TO ABEND-FUNCTION               
              MOVE 'CSS_ATTRIBUTE'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE IN-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'ATTRIB_LEVEL_CD'    TO TABLE-ELEMENT-2              
              MOVE IN-ATTRIBUTE-TYPE    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-ATTRIBUTE-CURSOR.                                   *        
      *    FETCH ATTRIBUTE CURSOR TO GET ALL REQUIRED EMAIL ATTRIBUTES *        
      ******************************************************************        
       7100-FETCH-ATTRIBUTE-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
              FETCH ATTRIBUTE_CSR                                       
              INTO                                                      
                      :WZ-ATTRIBUTE-DESC                                
                     ,:WZ-ATTRIB-DFLT-VAL-CD                            
                     ,:WZ-GROUP-SEQ-NO                                  
                     ,:WZ-SORT-SEQ-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7100'          TO ACTIVE-PARAGRAPH                  
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_ATTRIBUTE'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE IN-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'ATTRIB_LEVEL_CD'    TO TABLE-ELEMENT-2              
              MOVE IN-ATTRIBUTE-TYPE    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-CLOSE-ATTRIBUTE-CURSOR.                                   *        
      ******************************************************************        
       7200-CLOSE-ATTRIBUTE-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
              CLOSE ATTRIBUTE_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7200'          TO ACTIVE-PARAGRAPH                  
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_ATTRIBUTE'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE IN-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'ATTRIB_LEVEL_CD'    TO TABLE-ELEMENT-2              
              MOVE IN-ATTRIBUTE-TYPE    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-GET-ACCT-CODES.                                           *        
      *      GET THE ATTRIBUTE VALUE (IF PRESENT) FROM THE TABLE       *        
      *         CSS_ACCT_ATTRIBUTE                                     *        
      ******************************************************************        
       7300-GET-ACCT-CODES.                                             
                                                                        
           EXEC SQL                                                     
               SELECT YP.ATTRIBUTE_VALUE_CD                             
                 INTO :YP-ATTRIBUTE-VALUE-CD                            
                 FROM CSS_ACCT_ATTRIBUTE YP                             
                WHERE YP.ACCOUNT_NO = :YP-ACCOUNT-NO                    
                  AND YP.ATTRIBUTE_DESC = :WZ-ATTRIBUTE-DESC            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE YP-ATTRIBUTE-VALUE-CD TO S-ATTRIB-VALUE           
              ELSE                                                      
                 MOVE WZ-ATTRIB-DFLT-VAL-CD TO S-ATTRIB-VALUE           
              END-IF                                                    
              MOVE WZ-ATTRIBUTE-DESC TO S-EMAIL-OPTION                  
              MOVE ZERO TO S-RETURN-CODE                                
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7300'          TO ACTIVE-PARAGRAPH                  
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE YP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-2              
              MOVE WZ-ATTRIBUTE-DESC    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR03511_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03511_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR03511_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR03511_R1'                               
                                         TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
                                                                        
               INSERT INTO #CSR03511_R1                          
                   (                                                    
                     RETURN_CODE                                        
                    ,EMAIL_OPTION                                       
                    ,ATTRIB_VALUE                                       
                   )                                                    
               VALUES                                                   
                   (                                                    
                    :S-RETURN-CODE                                      
                   ,:S-EMAIL-OPTION                                     
                   ,:S-ATTRIB-VALUE                                     
                   )                                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR03511_R1                                  
MFA-TR*            (                                                            
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,EMAIL_OPTION                                               
MFA-TR*             ,ATTRIB_VALUE                                               
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-EMAIL-OPTION                                             
MFA-TR*            ,:S-ATTRIB-VALUE                                             
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8900'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR03511_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 9700-PROCESS-ABEND.                                        *            
      **************************************************************            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
