       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03510.                                     
COB303 DATE-WRITTEN. DECEMBER 20, 2004.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03510              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03510 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVES FREEFORM OR FORMATTED ADDRESS FOR ACCOUNT    --         
      *--     PROVIDED IN THE INPUT PARAMETERS.                      --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
C29533*--  20 DEC 2004   SS19371     NEW CODE                        --         
C29533*--  22 MAR 2004   SS19371     ONLY LOOK FOR ADDRESS IF ADDRESS--         
C29533*--                            ID IS > 0 TO REDUCE # OF ENTRIES --        
C29533*--                            IN CSS_ERROR_LOG.               --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03510'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT, AT                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_FORMATTED, DY                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_FREEFORM, DZ                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_MODEL_SQL, MS                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ZIP_CODE, A4                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
                                                                        
       01  WS-ACTIVE-RETURN-CODE1    PIC S9(9)  COMP VALUE 0.           
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG          PIC X(08) VALUE 'CSRERLOG'.        
           05  PROGRAM-NAME          PIC X(08) VALUE 'CSR03510'.        
                                                                        
       01  LS-DATABASE               PIC 9(01)  VALUE 0.                
           88 CSR-DATABASE                      VALUE 1.                
           88 SEB-DATABASE                      VALUE 2.                
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE          PIC S9(9) VALUE 0 COMP.            
           10 S-ADDRESS-FORMAT       PIC X(01) VALUE SPACES.            
           10 S-ADDRESS-ID           PIC X(13) VALUE SPACES.            
           10 S-OUTPUT-ADDRESS-1     PIC X(77) VALUE SPACES.            
           10 S-OUTPUT-ADDRESS-2     PIC X(35) VALUE SPACES.            
           10 S-OUTPUT-CITY          PIC X(26) VALUE SPACES.            
           10 S-OUTPUT-STATE         PIC X(02) VALUE SPACES.            
           10 S-OUTPUT-CITY-STATE    PIC X(20) VALUE SPACES.            
           10 S-OUTPUT-ZIP           PIC X(09) VALUE SPACES.            
           10 S-OUTPUT-ZIP-PL-FOUR   PIC X(04) VALUE SPACES.            
           10 S-OUTPUT-COUNTRY       PIC X(35) VALUE SPACES.            
                                                                        
      ****************************************************************          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
       01  WS-MISC-ITEMS.                                               
           05  WS-EXISTS-FLAG          PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-PENDING-CODE         PIC X(01) VALUE 'P'.             
           05  WS-PARM-ACCOUNT-NO      PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ADDRESS-ID           PIC 9(13) VALUE ZERO.            
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-INDICATOR-2     PIC S9(04) COMP VALUE +0.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
           COPY CWS00011.                                                       
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  IN-ACCOUNT-NO               PIC X(13).                       
                                                                        
                                                                        
       PROCEDURE DIVISION USING IN-ACCOUNT-NO.                          
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-INITIALIZE-PROCEDURE.                                    *         
      *    SET UP SQL ERROR PROCESSING,                               *         
      *    DECLARE ASSOCIATED CURSOR, THEN PROCESS THE INPUT          *         
      *****************************************************************         
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
                                                                        
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
                                                                        
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
      *                                                                         
           EXEC SQL                                                     
                                                                        
              DECLARE C1 CURSOR  FOR                         
               SELECT  :S-RETURN-CODE          AS RETURN_CODE           
                      ,:S-ADDRESS-FORMAT       AS ADDRESS_FORMAT        
                      ,:S-ADDRESS-ID           AS ADDRESS_ID            
                      ,:S-OUTPUT-ADDRESS-1     AS OUTPUT_ADDRESS_1      
                      ,:S-OUTPUT-ADDRESS-2     AS OUTPUT_ADDRESS_2      
                      ,:S-OUTPUT-CITY          AS OUTPUT_CITY           
                      ,:S-OUTPUT-STATE         AS OUTPUT_STATE          
                      ,:S-OUTPUT-CITY-STATE    AS OUTPUT_CITY_STATE     
                      ,:S-OUTPUT-ZIP           AS OUTPUT_ZIP            
                      ,:S-OUTPUT-ZIP-PL-FOUR   AS OUTPUT_ZIP_PL_FOUR    
                      ,:S-OUTPUT-COUNTRY       AS OUTPUT_COUNTRY        
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT  :S-RETURN-CODE          AS RETURN_CODE                   
MFA-TR*               ,:S-ADDRESS-FORMAT       AS ADDRESS_FORMAT                
MFA-TR*               ,:S-ADDRESS-ID           AS ADDRESS_ID                    
MFA-TR*               ,:S-OUTPUT-ADDRESS-1     AS OUTPUT_ADDRESS_1              
MFA-TR*               ,:S-OUTPUT-ADDRESS-2     AS OUTPUT_ADDRESS_2              
MFA-TR*               ,:S-OUTPUT-CITY          AS OUTPUT_CITY                   
MFA-TR*               ,:S-OUTPUT-STATE         AS OUTPUT_STATE                  
MFA-TR*               ,:S-OUTPUT-CITY-STATE    AS OUTPUT_CITY_STATE             
MFA-TR*               ,:S-OUTPUT-ZIP           AS OUTPUT_ZIP                    
MFA-TR*               ,:S-OUTPUT-ZIP-PL-FOUR   AS OUTPUT_ZIP_PL_FOUR            
MFA-TR*               ,:S-OUTPUT-COUNTRY       AS OUTPUT_COUNTRY                
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           PERFORM 1500-PROCESS-INPUT         THRU 1500-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1500-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1500-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                                                                        
           IF IN-ACCOUNT-NO > SPACES                                    
              MOVE IN-ACCOUNT-NO         TO WS-PARM-ACCOUNT-NO          
              MOVE WS-PARM-ACCOUNT-NO    TO AT-ACCOUNT-NO               
                                            WS-ACCOUNT-NO               
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '1500'          TO ACTIVE-PARAGRAPH                  
              MOVE 'RECEIVE INPUT' TO ABEND-FUNCTION                    
              MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                   
              MOVE IN-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1                 
              MOVE +100 TO WS-ACTIVE-RETURN-CODE                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD +1 TO CTR-ROWS.                                          
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-GET-ADDRESS-INFO     THRU 7000-EXIT.            
                                                                        
C32484     IF AT-ADDRESS-ID > 0                                         
              MOVE AT-ADDRESS-ID TO S-ADDRESS-ID                        
                                    DY-ADDRESS-ID                       
                                    DZ-ADDRESS-ID                       
                                    WS-ADDRESS-ID                       
                                                                        
              IF AT-ADDRESS-FORMAT = 'A'                                
                 PERFORM 7010-GET-FORMAT-ADDRESS   THRU 7010-EXIT       
                 MOVE 'A' TO S-ADDRESS-FORMAT                           
                 PERFORM 2500-FORMAT-TO-FREEFORM   THRU 2500-EXIT       
              ELSE                                                      
                 PERFORM 7020-GET-FREEFORM-ADDRESS THRU 7020-EXIT       
                 MOVE 'B' TO S-ADDRESS-FORMAT                           
                 MOVE DZ-ADDR-STREET      TO S-OUTPUT-ADDRESS-1         
                 MOVE DZ-ADDRESS-OVERFLOW TO S-OUTPUT-ADDRESS-2         
                 MOVE DZ-ADDR-CITY-STATE  TO S-OUTPUT-CITY-STATE        
                 MOVE DZ-ADDR-ZIP-CODE    TO S-OUTPUT-ZIP               
                 MOVE DZ-ADDR-COUNTRY     TO S-OUTPUT-COUNTRY           
              END-IF                                                    
C32484     ELSE                                                         
C32484        MOVE +101 TO S-RETURN-CODE                                
C32484                     WS-ACTIVE-RETURN-CODE                        
C32484     END-IF                                                       
           .                                                            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-FORMAT-TO-FREEFORM.                                       *        
      *    STRING TOGETHER ADDRESS PARTS AND REMOVE EXTRA SPACES       *        
      ******************************************************************        
       2500-FORMAT-TO-FREEFORM.                                         
                                                                        
           STRING DY-HOUSE-NO ' ' DY-ADDR-PREFIX-1 ' ' DY-ADDR-PREFIX-2 
                  ' ' DY-STREET-NAME ' ' DY-STREET-SUFFIX ' '           
                  DY-ADDR-SUFFIX ' ' DY-STREET-LOCATION-1 ' '           
                  DY-STREET-LOCATION-2                                  
                  DELIMITED BY SIZE INTO WS-EMB-INPUT                   
           MOVE +77 TO WS-EMB-LENG                                      
           INITIALIZE WS-CMP-TABLE                                      
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
           MOVE WS-CMP-TABLE TO S-OUTPUT-ADDRESS-1.                     
                                                                        
           MOVE DY-ADDRESS-OVERFLOW TO S-OUTPUT-ADDRESS-2.              
           MOVE A4-TOWN  TO S-OUTPUT-CITY.                              
           MOVE A4-STATE TO S-OUTPUT-STATE.                             
           MOVE DY-ZIP-CODE  TO S-OUTPUT-ZIP.                           
           MOVE DY-ZIP-CODE-PLUS-FOUR TO S-OUTPUT-ZIP-PL-FOUR.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6010-REDUCE-EMBEDDED-SPACES.                                   *        
      *      COPYBOOK TO ELIMINATE EXTRA SPACES IN ADDRESS INFO        *        
      ******************************************************************        
                                                                        
         COPY CPD00004.                                                         
                                                                        
      ******************************************************************        
      * 7000-GET-ADDRESS-INFO.                                         *        
      ******************************************************************        
       7000-GET-ADDRESS-INFO.                                           
                                                                        
           MOVE SPACES TO AT-ADDRESS-FORMAT.                            
           MOVE ZEROES TO AT-ADDRESS-ID.                                
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) ADDRESS_FORMAT,
              ADDRESS_ID                                       
                  INTO :AT-ADDRESS-FORMAT                               
                      ,:AT-ADDRESS-ID                                   
                  FROM CSS_ACCOUNT                                      
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ADDRESS_FORMAT                                           
MFA-TR*               ,ADDRESS_ID                                               
MFA-TR*           INTO :AT-ADDRESS-FORMAT                                       
MFA-TR*               ,:AT-ADDRESS-ID                                           
MFA-TR*           FROM CSS_ACCOUNT                                      00450010
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-GET-FORMAT-ADDRESS.                                       *        
      *     FETCH INFO FROM CSS_ADDR_FORMATTED.                        *        
      ******************************************************************        
       7010-GET-FORMAT-ADDRESS.                                         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) DY.HOUSE_NO,
              DY.ADDR_PREFIX_1,
              DY.ADDR_PREFIX_2,
              DY.STREET_NAME,
              DY.STREET_SUFFIX,
              DY.STREET_LOCATION_1,
              DY.STREET_LOCATION_2,
              DY.ADDRESS_OVERFLOW,
              DY.ZIP_CODE,
              DY.ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN,
              DY.ADDR_SUFFIX,
              DY.CARRIER_ROUTE,
              A4.TOWN,
              A4.STATE                                         
                  INTO :DY-HOUSE-NO                                     
                      ,:DY-ADDR-PREFIX-1                                
                      ,:DY-ADDR-PREFIX-2                                
                      ,:DY-STREET-NAME                                  
                      ,:DY-STREET-SUFFIX                                
                      ,:DY-STREET-LOCATION-1                            
                      ,:DY-STREET-LOCATION-2                            
                      ,:DY-ADDRESS-OVERFLOW                             
                      ,:DY-ZIP-CODE                                     
                      ,:DY-ZIP-CODE-PLUS-FOUR                           
                      ,:DY-ZIP-CODE-TOKEN                               
                      ,:DY-ADDR-SUFFIX                                  
                      ,:DY-CARRIER-ROUTE                                
                      ,:A4-TOWN                                         
                      ,:A4-STATE                                        
                  FROM CSS_ADDR_FORMATTED DY                            
                      ,CSS_ZIP_CODE A4                                  
                 WHERE ADDRESS_ID = :DY-ADDRESS-ID                      
                   AND ADDR_USAGE_CD = 'F'                              
                   AND A4.ZIP_CODE = DY.ZIP_CODE                        
                   AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN            
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DY.HOUSE_NO                                              
MFA-TR*               ,DY.ADDR_PREFIX_1                                         
MFA-TR*               ,DY.ADDR_PREFIX_2                                         
MFA-TR*               ,DY.STREET_NAME                                           
MFA-TR*               ,DY.STREET_SUFFIX                                         
MFA-TR*               ,DY.STREET_LOCATION_1                                     
MFA-TR*               ,DY.STREET_LOCATION_2                                     
MFA-TR*               ,DY.ADDRESS_OVERFLOW                                      
MFA-TR*               ,DY.ZIP_CODE                                              
MFA-TR*               ,DY.ZIP_CODE_PLUS_FOUR                                    
MFA-TR*               ,DY.ZIP_CODE_TOKEN                                        
MFA-TR*               ,DY.ADDR_SUFFIX                                           
MFA-TR*               ,DY.CARRIER_ROUTE                                         
MFA-TR*               ,A4.TOWN                                                  
MFA-TR*               ,A4.STATE                                                 
MFA-TR*           INTO :DY-HOUSE-NO                                             
MFA-TR*               ,:DY-ADDR-PREFIX-1                                        
MFA-TR*               ,:DY-ADDR-PREFIX-2                                        
MFA-TR*               ,:DY-STREET-NAME                                          
MFA-TR*               ,:DY-STREET-SUFFIX                                        
MFA-TR*               ,:DY-STREET-LOCATION-1                                    
MFA-TR*               ,:DY-STREET-LOCATION-2                                    
MFA-TR*               ,:DY-ADDRESS-OVERFLOW                                     
MFA-TR*               ,:DY-ZIP-CODE                                             
MFA-TR*               ,:DY-ZIP-CODE-PLUS-FOUR                                   
MFA-TR*               ,:DY-ZIP-CODE-TOKEN                                       
MFA-TR*               ,:DY-ADDR-SUFFIX                                          
MFA-TR*               ,:DY-CARRIER-ROUTE                                        
MFA-TR*               ,:A4-TOWN                                                 
MFA-TR*               ,:A4-STATE                                                
MFA-TR*           FROM CSS_ADDR_FORMATTED DY                                    
MFA-TR*               ,CSS_ZIP_CODE A4                                          
MFA-TR*          WHERE ADDRESS_ID = :DY-ADDRESS-ID                              
MFA-TR*            AND ADDR_USAGE_CD = 'F'                                      
MFA-TR*            AND A4.ZIP_CODE = DY.ZIP_CODE                                
MFA-TR*            AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN                    
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7010'          TO ACTIVE-PARAGRAPH                  
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE WS-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7020-GET-FREEFORM-ADDRESS.                                    *         
      *****************************************************************         
       7020-GET-FREEFORM-ADDRESS.                                       
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) ADDR_STREET,
              ADDRESS_OVERFLOW,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY                                     
                  INTO :DZ-ADDR-STREET                                  
                      ,:DZ-ADDRESS-OVERFLOW                             
                      ,:DZ-ADDR-CITY-STATE                              
                      ,:DZ-ADDR-ZIP-CODE                                
                      ,:DZ-ADDR-COUNTRY                                 
                  FROM CSS_ADDR_FREEFORM                                
                 WHERE ADDRESS_ID = :DZ-ADDRESS-ID                      
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ADDR_STREET                                              
MFA-TR*               ,ADDRESS_OVERFLOW                                         
MFA-TR*               ,ADDR_CITY_STATE                                          
MFA-TR*               ,ADDR_ZIP_CODE                                            
MFA-TR*               ,ADDR_COUNTRY                                             
MFA-TR*           INTO :DZ-ADDR-STREET                                          
MFA-TR*               ,:DZ-ADDRESS-OVERFLOW                                     
MFA-TR*               ,:DZ-ADDR-CITY-STATE                                      
MFA-TR*               ,:DZ-ADDR-ZIP-CODE                                        
MFA-TR*               ,:DZ-ADDR-COUNTRY                                         
MFA-TR*           FROM CSS_ADDR_FREEFORM                                        
MFA-TR*          WHERE ADDRESS_ID = :DZ-ADDRESS-ID                              
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7020'          TO ACTIVE-PARAGRAPH                  
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'     TO TABLE-1                   
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE WS-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9100-CHECK-ERROR                                               *        
      ******************************************************************        
       9100-CHECK-ERROR.                                                
           EXIT.                                                        
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
