       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03502.                                     
COB303 DATE-WRITTEN.      DEC 20, 2004.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM INSERTS, UPDATES, DELETES INTO CSS_INTERRUPT_HIST*00100000
      *                                                                *00110000
      *  TRANID:        CSR03502                                       *00120000
      *  PROGRAM:       CSR03502                                       *00130000
      *  CALLING SP:    CSR03502                                       *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM IS A STORED PROCEDURE TO INSERT, UPDATE AND      *00190000
      *  DELETE FROM INTERRUPT EXCEPTION.                              *00200000
      *                                                                *00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  12/20/04    PD       PROCEDURE ORIGINALLY CODED.              *00280000
T33415*  02/07/06    VV90387  AVOID INVALID DATE/TIME FORMAT ERROR.    *00280000
C34624*  11/14/06    AD94658  ADDED ACCOUNT_NO TO 2280- PARA TO AVOID  *00280000
C34624*                       DUPLICATE ROWS.                          *00280000
T35434*  07/30/07    MR97640  REPLACED MODEL_SQL WITH SET STATEMENT AND*00280000
T35434*                       ADDED WITH UR TO AVOID -911.             *00280000
A02395*  05/07/10    SV95326  FIX THE TRANSACTION HISTORY DETAILS      *        
A02395*              ACT-004  PROBLEM, PERFORMANCE IMPROVEMENT PROCESS *        
A02395*                       AND REOMOVE THE UNWANTED CODES ALSO.     *        
A04527*  06/07/13    AS7C117  REMOVE UNUSED COPYBOOK CWS00056.         *        
ACT106*  05/15/15    RS7M249  DELETE UNUSED COPYBOOK(S)                *        
A05136*  14/2015     RS7M249  GET USERID FROM INPUT INSTEAD FROM CURRE *        
A05136*              ACT232   NT SQLID                                 *        
      ******************************************************************00460000
      ******************************************************************00470000
      *                                                                *00480000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00490000
      *                                                                *00500000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00510000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00520000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00530000
      *  3000 - 4999  NOT USED                                         *00540000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00550000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00560000
      *  7000 - 7999  INPUT MODULES                                    *00570000
      *  8000 - 8999  OUTPUT MODULES                                   *00580000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00590000
      *                                                                *00600000
      ******************************************************************00610000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03502'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(50) VALUE   
           'WORKING STORAGE FOR RPC CSR03502 STARTS HERE'.              
                                                                        
      ******************************************************************00700000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00710000
      ******************************************************************00720000
                                                                        
           COPY CWS00004.                                               00770000
           COPY CWS00007.                                               00780000
           COPY CWS00008.                                               00790000
           COPY CWS00303.                                               00820000
           COPY CWS00100.                                               00830000
           COPY CJF00101.                                               00840000
           COPY CJF00102.                                               00850000
      ******************************************************************00870000
      *    WORK AREAS                                                  *00880000
      ******************************************************************00890000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR03502'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-ACCOUNT-NO            PIC 9(13).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-CURRENT-DATE          PIC X(10).                      
           05  WS-3MONTHS-BACK          PIC X(10).                      
           05  WS-INTERRUPT-END-DT      PIC X(10).                      
           05  WS-CURRENT-TIME          PIC X(08).                      
           05  WS-MODE-FL               PIC X(01)  VALUE 'U'.           
           05  WS-EXISTS                PIC X(01)  VALUE 'Y'.           
           05  WS-EXISTS-HIST           PIC X(01)  VALUE 'Y'.           
COB305     05 WS-PREV-EGAS-UNIT-AM        PIC S9(5)V9(6) USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-CURRENT-TIMESTAMP     PIC X(26).                      
COB305     05 WS-PREV-ACCOUNT-NO        PIC  S9(13)V USAGE COMP-3 
COB305       VALUE 0.       
           05  WS-PREV-CODE-UTIL-TYPE  PIC  X(1).                       
           05  WS-PREV-IC-NO           PIC  S9(4) USAGE COMP.           
           05  WS-PREV-INT-START-DT    PIC  X(10).                      
           05  WS-PREV-INT-START-TM    PIC  X(8).                       
           05  WS-PREV-EXCEPTION-CD    PIC  X(2).                       
           05  WS-PREV-INT-END-DT      PIC  X(10).                      
           05  WS-PREV-INT-END-TM      PIC  X(8).                       
           05  WS-PREV-UPD-USERID      PIC  X(7).                       
           05  WS-PREV-COMMENT         PIC  X(250).                     
ACT232     05  PARM-USER-ID            PIC  X(07) VALUE SPACES.         
                                                                        
A02395 01  WS-EGAS-UNIT-AMT-TRAN.                                       
A02395     05  WS-PRV-EGAS-UNIT-AMT        PIC 9(11).                   
A02395     05  WS-PRV-EGAS-UNIT-AMT-RED    REDEFINES                    
A02395               WS-PRV-EGAS-UNIT-AMT  PIC 9(5)V9(6).               
A02395     05  WS-PRV-EGAS-UNIT-AMT-TEXT   PIC 9(5).9(6).               
A02395     05  WS-PRV-EGAS-UNIT-AMT-Z      PIC -Z(05).9(6).             
A02395     05  WS-CHG-EGAS-UNIT-AMT        PIC 9(11).                   
A02395     05  WS-CHG-EGAS-UNIT-AMT-RED    REDEFINES                    
A02395               WS-CHG-EGAS-UNIT-AMT  PIC 9(5)V9(6).               
A02395     05  WS-CHG-EGAS-UNIT-AMT-TEXT   PIC 9(5).9(6).               
A02395     05  WS-CHG-EGAS-UNIT-AMT-Z      PIC -Z(05).9(6).             
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) COMP VALUE +0.        
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE +0.        
                                                                        
           EXEC SQL                                                     01990000
              INCLUDE SQLCA                                             02000000
           END-EXEC.                                                    02010000
                                                                        
           EXEC SQL                                                             
              INCLUDE TBINTCAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_INTERRUPT_EXCP >                                        01531000
           EXEC SQL                                                     01532000
              INCLUDE TBINTEXP                                          01533000
           END-EXEC.                                                    01534000
                                                                        
      *---< CSS_INTERRUPT_HIST >                                        01531000
           EXEC SQL                                                     01532000
              INCLUDE TBINHIST                                          01533000
           END-EXEC.                                                    01534000
                                                                        
           EXEC SQL                                                     01532000
              INCLUDE CWSX0010                                          01533000
           END-EXEC.                                                    01534000
                                                                        
           EXEC SQL                                                     01532000
              INCLUDE CWS00061                                          01533000
           END-EXEC.                                                    01534000
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01 I-ACCOUNT-NO         PIC  X(13).                              
       01 I-CODE-UTIL-TYPE     PIC  X(1).                               
       01 I-IC-NO              PIC  S9(4) USAGE COMP.                   
       01 I-INTERRUPT-START-DT PIC  X(10).                              
       01 I-INTERRUPT-START-TM PIC  X(8).                               
       01 I-EXCEPTION-CD       PIC  X(2).                               
       01 I-INTERRUPT-END-DT   PIC  X(10).                              
       01 I-INTERRUPT-END-TM   PIC  X(8).                               
       01 I-LAST-UPDATE-USERID PIC  X(7).                               
       01 I-COMMENT            PIC  X(250).                             
COB305 01 I-EGAS-UNIT-AM        PIC  S9(5)V9(6) USAGE COMP-3 VALUE 0.           
       01 I-MODE-FL            PIC  X(01).                              
ACT232 01 I-USER-ID            PIC  X(07).                              
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                               ,I-CODE-UTIL-TYPE                        
                               ,I-IC-NO                                 
                               ,I-INTERRUPT-START-DT                    
                               ,I-INTERRUPT-START-TM                    
                               ,I-EXCEPTION-CD                          
                               ,I-INTERRUPT-END-DT                      
                               ,I-INTERRUPT-END-TM                      
                               ,I-LAST-UPDATE-USERID                    
                               ,I-COMMENT                               
                               ,I-EGAS-UNIT-AM                          
                               ,I-MODE-FL                               
ACT232                         ,I-USER-ID                               
                               .                                        
      ******************************************************************03540000
      * 0000-MAINLINE                                                  *03550000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03560000
      ******************************************************************03570000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03680000
      * 0100-INITIALIZE                                                *03690000
      *                                                                *03700000
      *                                                                *03710000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03720000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03730000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03740000
      *                                                                *03750000
      ******************************************************************03760000
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE     AS RETURN_CODE                 
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE     AS RETURN_CODE                         
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
           MOVE I-ACCOUNT-NO         TO WS-ACCOUNT-NO.                  
           MOVE WS-ACCOUNT-NO        TO NX-ACCOUNT-NO                   
C34624                                  NY-ACCOUNT-NO.                  
           MOVE I-IC-NO              TO NX-IC-NO.                       
           MOVE I-CODE-UTIL-TYPE     TO NX-CODE-UTIL-TYPE.              
           PERFORM 2260-VALIDATE-STDT THRU 2260-EXIT.                   
           MOVE I-INTERRUPT-START-DT TO NX-INTERRUPT-START-DT.          
           MOVE I-INTERRUPT-START-TM TO NX-INTERRUPT-START-TM.          
           MOVE I-EXCEPTION-CD       TO NX-EXCEPTION-CD.                
           MOVE I-INTERRUPT-END-DT   TO NX-INTERRUPT-END-DT.            
           MOVE I-INTERRUPT-END-TM   TO NX-INTERRUPT-END-TM             
           MOVE I-LAST-UPDATE-USERID TO NX-LAST-UPDATE-USERID           
           MOVE 100                  TO NX-COMMENT-LEN                  
           MOVE I-COMMENT            TO NX-COMMENT-TEXT                 
ACT232     MOVE I-USER-ID            TO PARM-USER-ID                    
           MOVE I-EGAS-UNIT-AM       TO NX-EGAS-UNIT-AM                 
           PERFORM 7150-GET-CURRENT-INFO  THRU 7150-EXIT.               
           IF WS-3MONTHS-BACK        > WS-INTERRUPT-END-DT              
              MOVE 1500 TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05510000
      * 2000-PROCESS-OUTPUT.                                           *05520000
      *                                                                *05530000
      *     2. UPDATE DB2 DATA                                         *05550000
      *     3. BUILD RESULT SET                                        *05560000
      *     4. SEND RESULT SET                                         *05570000
      *                                                                *05580000
      ******************************************************************05590000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
A02395      PERFORM 2100-PROCESS-INT       THRU 2100-EXIT.              
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05510000
A02395* 2100-PROCESS-INT.                                              *        
      * INSERT/UPDATE INTERRUPT EXCEPTION                              *        
      *                                                                *05530000
      ******************************************************************05590000
                                                                        
A02395 2100-PROCESS-INT.                                                
                                                                        
           PERFORM 7200-SELECT-INT           THRU 7200-EXIT.            
           MOVE I-MODE-FL TO WS-MODE-FL.                                
           IF WS-MODE-FL = 'U'                                          
              IF WS-EXISTS = 'X'                                        
                 PERFORM 7500-GET-PREVIOUS-HEADER THRU 7500-EXIT        
                 PERFORM 8080-UPDATE-INT         THRU 8080-EXIT         
                 MOVE 'CSR03502'         TO PROGRAM-NAME                
                 PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT        
A02395           PERFORM 2200-FIND-CHANGED-HEADER THRU 2200-EXIT        
              ELSE                                                      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF                                                       
           IF WS-MODE-FL = 'D'                                          
              IF WS-EXISTS = 'X'                                        
                 PERFORM 7500-GET-PREVIOUS-HEADER THRU 7500-EXIT        
                 PERFORM 8090-DELETE-INT         THRU 8090-EXIT         
      **** COPY VARIABLES FOR HISTORY RECORD DELETION                           
                 MOVE NX-ACCOUNT-NO     TO NZ-ACCOUNT-NO                
                 MOVE NX-CODE-UTIL-TYPE TO NZ-CODE-UTIL-TYPE            
                 MOVE NX-IC-NO          TO NZ-IC-NO                     
                 MOVE NX-INTERRUPT-START-DT                             
                                        TO NZ-INTERRUPT-START-DT        
                 MOVE NX-INTERRUPT-START-TM                             
                                        TO NZ-INTERRUPT-START-TM        
                 MOVE NX-EXCEPTION-CD   TO NZ-EXCEPTION-CD              
                 PERFORM 7205-SELECT-HIST     THRU 7205-EXIT            
                 IF WS-EXISTS-HIST = 'X'                                
                    PERFORM 8091-DELETE-HIST  THRU 8091-EXIT            
                 END-IF                                                 
                 MOVE 'CSR03502'         TO PROGRAM-NAME                
                 PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT        
                 MOVE 'INT START DT'       TO MI-COLUMN-DESC            
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-INT-START-DT TO MI-PRV-COLUMN-VALUE-TEXT  
                 MOVE +7                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE 'DELETED'            TO MI-CHG-COLUMN-VALUE-TEXT  
                 PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT             
                                                                        
                 MOVE 'EXCEPTION'           TO MI-COLUMN-DESC           
                 MOVE +2                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-PREV-EXCEPTION-CD  TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +7                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE 'DELETED'             TO MI-CHG-COLUMN-VALUE-TEXT 
                 PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT             
              ELSE                                                      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF                                                       
           IF WS-MODE-FL = 'I'                                          
              IF WS-EXISTS NOT = 'N'                                    
                 PERFORM 8070-INSERT-INT         THRU 8070-EXIT         
                 MOVE 'CSR03502'         TO PROGRAM-NAME                
                 PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT        
                 MOVE 'INT START DT'        TO MI-COLUMN-DESC           
                 MOVE +3                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE 'NEW'                 TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE NX-INTERRUPT-START-DT TO MI-CHG-COLUMN-VALUE-TEXT 
                 PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT             
                                                                        
                 MOVE 'EXCEPTION'        TO MI-COLUMN-DESC              
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 'NEW'              TO MI-PRV-COLUMN-VALUE-TEXT    
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE NX-EXCEPTION-CD    TO MI-CHG-COLUMN-VALUE-TEXT    
                 PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT             
                                                                        
              ELSE                                                      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
A02395 2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
A02395* 2200-FIND-CHANGED-HEADER.                                      *        
      ******************************************************************        
A02395 2200-FIND-CHANGED-HEADER.                                        
                                                                        
            IF WS-PREV-ACCOUNT-NO NOT = NX-ACCOUNT-NO                   
               MOVE 'ACCOUNT NO'         TO MI-COLUMN-DESC              
               MOVE +13                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-ACCOUNT-NO   TO WS-ACCOUNT-NO-CHAR          
               MOVE WS-ACCOUNT-NO-CHAR   TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +13                  TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE NX-ACCOUNT-NO        TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
            IF WS-PREV-CODE-UTIL-TYPE NOT = NX-CODE-UTIL-TYPE           
               MOVE 'CODE UTIL TYPE'       TO MI-COLUMN-DESC            
               MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN   
               MOVE WS-PREV-CODE-UTIL-TYPE TO MI-PRV-COLUMN-VALUE-TEXT  
               MOVE +2                     TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE NX-CODE-UTIL-TYPE      TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
            IF WS-PREV-IC-NO NOT = NX-IC-NO                             
               MOVE 'IC NO'             TO MI-COLUMN-DESC               
               MOVE +2                  TO MI-PRV-COLUMN-VALUE-LEN      
               MOVE WS-PREV-IC-NO       TO MI-PRV-COLUMN-VALUE-TEXT     
               MOVE +2                  TO MI-CHG-COLUMN-VALUE-LEN      
               MOVE NX-IC-NO            TO MI-CHG-COLUMN-VALUE-TEXT     
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
            IF WS-PREV-INT-START-DT  NOT = NX-INTERRUPT-START-DT        
               MOVE 'INT START DT'        TO MI-COLUMN-DESC             
               MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-INT-START-DT  TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE NX-INTERRUPT-START-DT TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
            IF WS-PREV-INT-START-TM NOT = NX-INTERRUPT-START-TM         
               MOVE 'INT START TIME'       TO MI-COLUMN-DESC            
               MOVE +8                     TO MI-PRV-COLUMN-VALUE-LEN   
               MOVE WS-PREV-INT-START-TM                                
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
               MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE NX-INTERRUPT-START-TM  TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
            IF WS-PREV-EXCEPTION-CD NOT = NX-EXCEPTION-CD               
               MOVE 'EXCEPTION CD'       TO MI-COLUMN-DESC              
               MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-EXCEPTION-CD TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +2                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE NX-EXCEPTION-CD TO MI-CHG-COLUMN-VALUE-TEXT         
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
            IF WS-PREV-INT-END-DT NOT = NX-INTERRUPT-END-DT             
               MOVE 'INT END DATE'        TO MI-COLUMN-DESC             
               MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-INT-END-TM TO MI-PRV-COLUMN-VALUE-TEXT      
               MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE NX-INTERRUPT-END-DT   TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
            IF WS-PREV-INT-END-TM NOT = NX-INTERRUPT-END-TM             
               MOVE 'INT END TIME'       TO MI-COLUMN-DESC              
               MOVE +8                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-INT-END-TM   TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +8                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE NX-INTERRUPT-END-TM  TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
            IF WS-PREV-UPD-USERID NOT = NX-LAST-UPDATE-USERID           
               MOVE 'UPDATE USER ID'      TO MI-COLUMN-DESC             
               MOVE +8                                                  
                                          TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-UPD-USERID                                  
                                          TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE NX-LAST-UPDATE-USERID  TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
            IF WS-PREV-COMMENT NOT = NX-COMMENT-TEXT                    
A02395         MOVE 'COMMENTS'           TO MI-COLUMN-DESC              
A02395         MOVE WS-PREV-COMMENT      TO MI-PRV-COLUMN-VALUE-TEXT    
A02395         MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                  
A02395                                   TO MI-PRV-COLUMN-VALUE-LEN     
A02395         MOVE NX-COMMENT-TEXT      TO MI-CHG-COLUMN-VALUE-TEXT    
A02395         MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                  
A02395                                   TO MI-CHG-COLUMN-VALUE-LEN     
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
A02395      IF WS-PREV-EGAS-UNIT-AM  NOT = NX-EGAS-UNIT-AM              
               MOVE 'EGAS UNIT AM'         TO MI-COLUMN-DESC            
               MOVE +11                    TO MI-PRV-COLUMN-VALUE-LEN   
A02395         MOVE WS-PREV-EGAS-UNIT-AM   TO WS-PRV-EGAS-UNIT-AMT-RED  
A02395         MOVE WS-PRV-EGAS-UNIT-AMT-RED TO                         
A02395                                 WS-PRV-EGAS-UNIT-AMT-TEXT        
A02395         MOVE WS-PRV-EGAS-UNIT-AMT-TEXT  TO                       
A02395                                 WS-PRV-EGAS-UNIT-AMT-Z           
A02395         MOVE WS-PRV-EGAS-UNIT-AMT-Z  TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE +11                    TO MI-CHG-COLUMN-VALUE-LEN   
A02395         MOVE NX-EGAS-UNIT-AM        TO WS-CHG-EGAS-UNIT-AMT-RED  
A02395         MOVE WS-CHG-EGAS-UNIT-AMT-RED TO                         
A02395                                 WS-CHG-EGAS-UNIT-AMT-TEXT        
A02395         MOVE WS-CHG-EGAS-UNIT-AMT-TEXT  TO                       
A02395                                 WS-CHG-EGAS-UNIT-AMT-Z           
A02395         MOVE WS-CHG-EGAS-UNIT-AMT-Z  TO MI-CHG-COLUMN-VALUE-TEXT 
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
A02395      END-IF.                                                     
                                                                        
A02395 2200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
A02395*****************************************************************         
      * 2260-VALIDATE-STDT                                            *         
      *                                                               *         
      * VALIDATE INTERRUPT START DATE                                 *         
      *****************************************************************         
       2260-VALIDATE-STDT.                                              
                                                                        
           PERFORM 7210-SELECT-PRTY-SVC-CAT   THRU 7210-EXIT.           
           MOVE Z4-PRTY-SVC-CAT-CD       TO NY-PRTY-SVC-CAT-CD          
A02395     PERFORM 7300-GET-CAT-INT           THRU 7300-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 1000 TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
       2260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2500-MAINTENANCE-HISTORY.                                     *         
      *                                                               *         
      *                                                               *         
      *     PREPARE MAINTENANCE JOURNAL                               *         
      *****************************************************************         
                                                                        
       2500-MAINTENANCE-HISTORY.                                        
                                                                        
           MOVE '2500'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 7150-GET-CURRENT-INFO THRU 7150-EXIT.                
           MOVE WS-CURRENT-TIMESTAMP   TO MH-TRANS-HIST-SEQ-NO,         
           MOVE WS-CURRENT-DATE        TO MH-DATE-TRANS                 
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE NX-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
           MOVE ZEROS                  TO MH-CUSTOMER-NO.               
           MOVE ZEROS                  TO MH-PREMISE-NO.                
ACT232     MOVE PARM-USER-ID           TO MH-USER-ID.                   
           MOVE PROGRAM-NAME           TO MH-APPL-PROGRAM-ID.           
           MOVE 210                    TO MH-TRAN-COMMENT-LEN.          
           MOVE NX-COMMENT-TEXT        TO MH-TRAN-COMMENT-TEXT.         
           MOVE +0                     TO MI-TRAN-APPL-NO.              
       2500-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2550-WRITE-MNT-HIST.                                          *         
      *                                                               *         
      *                                                               *         
      *     WRITE TRAN HISTORY                                        *         
      *****************************************************************         
                                                                        
       2550-WRITE-MNT-HIST.                                             
           ADD  +1                     TO MI-TRAN-APPL-NO               
           MOVE SPACES                 TO MI-TABLE-ID                   
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO    
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      *                                                                *        
      *                                                                *        
      *     JOURNALING ROUTINE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
                                                                        
      *****************************************************************         
      * GET CURRENT TIMESTAMP, DATE AND TIME                          *         
      *****************************************************************         
                                                                        
       7150-GET-CURRENT-INFO.                                           
                                                                        
           EXEC SQL                                                     
T35434       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE),
              DATEADD( MONTH, -3, CAST(SYSDATETIMEOFFSET() AS DATE) ),
              IIF(TRY_CONVERT(DATE, :NX-INTERRUPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :NX-INTERRUPT-END-DT
              ) <> 0) OR (LEN(:NX-INTERRUPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:NX-INTERRUPT-END-DT
              ), CONVERT(DATE, :NX-INTERRUPT-END-DT) )
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-TIME,
              :WS-CURRENT-DATE,
              :WS-3MONTHS-BACK,
              :WS-INTERRUPT-END-DT     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                      
MFA-TR*          ,:WS-CURRENT-TIME     = CURRENT TIME                           
MFA-TR*          ,:WS-CURRENT-DATE     = CURRENT DATE                           
MFA-TR*          ,:WS-3MONTHS-BACK     = CURRENT DATE - 3 MONTHS                
MFA-TR*          ,:WS-INTERRUPT-END-DT = DATE(:NX-INTERRUPT-END-DT)             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                                        
C29529     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7150'                     TO ACTIVE-PARAGRAPH      
T35434         MOVE 'SET'                      TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF                                                       
           .                                                            
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02395*****************************************************************         
      * SELECT IF INTERRUPT EXCEPTION EXISTS                          *         
      *****************************************************************         
       7200-SELECT-INT.                                                 
                                                                        
           EXEC SQL                                                     
             SELECT 'X'                                                 
               INTO :WS-EXISTS                                          
               FROM CSS_INTERRUPT_EXCP WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO     = :NX-ACCOUNT-NO                     
                AND IC_NO          = :NX-IC-NO                          
                AND CODE_UTIL_TYPE = :NX-CODE-UTIL-TYPE                 
                AND INTERRUPT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                 :NX-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :NX-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:NX-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:NX-INTERRUPT-START-DT
              ), CONVERT(DATE, :NX-INTERRUPT-START-DT) )      
                AND INTERRUPT_START_TM    = CIS.CHAR2TIME(
                                                 :NX-INTERRUPT-START-TM
              )      
T35434                                                           
A02395                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'X'                                                         
MFA-TR*        INTO :WS-EXISTS                                                  
MFA-TR*        FROM CSS_INTERRUPT_EXCP                                          
MFA-TR*       WHERE ACCOUNT_NO     = :NX-ACCOUNT-NO                             
MFA-TR*         AND IC_NO          = :NX-IC-NO                                  
MFA-TR*         AND CODE_UTIL_TYPE = :NX-CODE-UTIL-TYPE                         
MFA-TR*         AND INTERRUPT_START_DT    = :NX-INTERRUPT-START-DT              
MFA-TR*         AND INTERRUPT_START_TM    = :NX-INTERRUPT-START-TM              
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_INTERRUPT_EXCP'       TO TABLE-1                
A02395        MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
A02395        MOVE 'IC_NO  '                  TO TABLE-ELEMENT-2        
A02395        MOVE 'CODE_UTIL_TYPE  '         TO TABLE-ELEMENT-3        
A02395        MOVE 'INTERRUPT_START_DT '      TO TABLE-ELEMENT-4        
A02395        MOVE NX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A02395        MOVE NX-IC-NO                   TO HOSTVAR-ELEMENT-2      
A02395        MOVE NX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
A02395        MOVE NX-INTERRUPT-START-DT      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * SELECT IF INTERRUPT EXCEPTION HISTORY EXISTS                  *         
      *****************************************************************         
       7205-SELECT-HIST.                                                
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'X'                                                 
               INTO :WS-EXISTS-HIST                                     
               FROM CSS_INTERRUPT_HIST WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO     = :NZ-ACCOUNT-NO                     
                AND IC_NO          = :NZ-IC-NO                          
                AND CODE_UTIL_TYPE = :NZ-CODE-UTIL-TYPE                 
                AND INTERRUPT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                 :NZ-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :NZ-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:NZ-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:NZ-INTERRUPT-START-DT
              ), CONVERT(DATE, :NZ-INTERRUPT-START-DT) )      
                AND INTERRUPT_START_TM    = CIS.CHAR2TIME(
                                                 :NZ-INTERRUPT-START-TM
              )      
A02395                                       
A02395                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'X'                                                         
MFA-TR*        INTO :WS-EXISTS-HIST                                             
MFA-TR*        FROM CSS_INTERRUPT_HIST                                          
MFA-TR*       WHERE ACCOUNT_NO     = :NZ-ACCOUNT-NO                             
MFA-TR*         AND IC_NO          = :NZ-IC-NO                                  
MFA-TR*         AND CODE_UTIL_TYPE = :NZ-CODE-UTIL-TYPE                         
MFA-TR*         AND INTERRUPT_START_DT    = :NZ-INTERRUPT-START-DT              
MFA-TR*         AND INTERRUPT_START_TM    = :NZ-INTERRUPT-START-TM              
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*      QUERYNO 7205                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02395        MOVE '7205'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_INTERRUPT_HIST'       TO TABLE-1                
A02395        MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
A02395        MOVE 'IC_NO  '                  TO TABLE-ELEMENT-2        
A02395        MOVE 'CODE_UTIL_TYPE  '         TO TABLE-ELEMENT-3        
A02395        MOVE 'INTERRUPT_START_DT '      TO TABLE-ELEMENT-4        
A02395        MOVE NZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A02395        MOVE NZ-IC-NO                   TO HOSTVAR-ELEMENT-2      
A02395        MOVE NZ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
A02395        MOVE NZ-INTERRUPT-START-DT      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
        7205-EXIT.                                                      
             EXIT.                                                      
                                                                        
      *****************************************************************         
      * SELECT PRTY SVC CAT CD                                        *         
      *****************************************************************         
       7210-SELECT-PRTY-SVC-CAT.                                        
                                                                        
           EXEC SQL                                                     
             SELECT Z4.PRTY_SVC_CAT_CD                                  
               INTO :Z4-PRTY-SVC-CAT-CD                                 
               FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                   
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
              WHERE UT.ACCOUNT_NO        = :NX-ACCOUNT-NO               
                AND UT.CODE_UTIL_TYPE    = :NX-CODE-UTIL-TYPE           
                AND UT.IC_NO             = :NX-IC-NO                    
                AND Z4.CODE_CURTAIL_PRTY = UT.CODE_CURTAIL_PRTY         
T35434                                                           
A02395                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT Z4.PRTY_SVC_CAT_CD                                          
MFA-TR*        INTO :Z4-PRTY-SVC-CAT-CD                                         
MFA-TR*        FROM CSS_PRTY_SVC_CAT Z4                                         
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*       WHERE UT.ACCOUNT_NO        = :NX-ACCOUNT-NO                       
MFA-TR*         AND UT.CODE_UTIL_TYPE    = :NX-CODE-UTIL-TYPE                   
MFA-TR*         AND UT.IC_NO             = :NX-IC-NO                            
MFA-TR*         AND Z4.CODE_CURTAIL_PRTY = UT.CODE_CURTAIL_PRTY                 
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_PRTY_SVC_CAT'         TO TABLE-1                
A02395        MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
A02395        MOVE 'IC_NO  '                  TO TABLE-ELEMENT-2        
A02395        MOVE 'CODE_UTIL_TYPE  '         TO TABLE-ELEMENT-3        
A02395        MOVE NX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A02395        MOVE NX-IC-NO                   TO HOSTVAR-ELEMENT-2      
A02395        MOVE NX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * GET CAT INTERRUPT INTERVAL                                    *         
      *****************************************************************         
A02395 7300-GET-CAT-INT.                                                
                                                                        
           EXEC SQL                                                     
                                                                        
             SELECT CIS.CHAR2$DATE(NY.INTERRUPT_START_DT, 'USA')                
                   ,REPLACE(CONVERT(CHAR(8), NY.INTERRUPT_START_TM
           , 108), ':', '.') INTERRUPT_START_TM                               
                   ,CIS.CHAR2$DATE(NY.INTERRUPT_END_DT, 'USA')                  
                   ,REPLACE(CONVERT(CHAR(8), NY.INTERRUPT_END_TM, 108), 
           ':', '.') INTERRUPT_END_TM                                 
               INTO   :NY-INTERRUPT-START-DT                            
                     ,:NY-INTERRUPT-START-TM                            
                     ,:NY-INTERRUPT-END-DT                              
                     ,:NY-INTERRUPT-END-TM                              
               FROM  CSS_INTERRUPT_CAT NY WITH(READUNCOMMITTED)                 
C34624        WHERE (NY.ACCOUNT_NO      = 0                             
C34624              OR NY.ACCOUNT_NO   = :NY-ACCOUNT-NO)                
C34624          AND NY.PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD            
                AND NY.COMPANY_NO      = '01'                           
                AND NY.CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE             
                AND CAST(IIF(TRY_CONVERT(DATE, :I-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :I-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:I-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:I-INTERRUPT-START-DT
              ), CONVERT(DATE, :I-INTERRUPT-START-DT) ) AS CHAR(10)) + 
                                               :I-INTERRUPT-START-TM >=        
                  CAST(NY.INTERRUPT_START_DT AS CHAR(10)) + REPLACE(
           CONVERT(CHAR(8), NY.INTERRUPT_START_TM, 108), ':', '.')             
                AND CAST(IIF(TRY_CONVERT(DATE, :I-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :I-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:I-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:I-INTERRUPT-START-DT
              ), CONVERT(DATE, :I-INTERRUPT-START-DT) ) AS CHAR(10)) + 
                                               :I-INTERRUPT-START-TM <=        
                  CAST(NY.INTERRUPT_END_DT AS CHAR(10)) + REPLACE(
           CONVERT(CHAR(8), NY.INTERRUPT_END_TM, 108), ':', '.')               
T35434                                                           
A02395                                                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*      SELECT CHAR(NY.INTERRUPT_START_DT, USA)                            
MFA-TR*            ,NY.INTERRUPT_START_TM                                       
MFA-TR*            ,CHAR(NY.INTERRUPT_END_DT, USA)                              
MFA-TR*            ,NY.INTERRUPT_END_TM                                         
MFA-TR*        INTO   :NY-INTERRUPT-START-DT                                    
MFA-TR*              ,:NY-INTERRUPT-START-TM                                    
MFA-TR*              ,:NY-INTERRUPT-END-DT                                      
MFA-TR*              ,:NY-INTERRUPT-END-TM                                      
MFA-TR*        FROM  CSS_INTERRUPT_CAT NY                                       
MFA-TR*       WHERE (NY.ACCOUNT_NO      = 0                                     
MFA-TR*             OR NY.ACCOUNT_NO   = :NY-ACCOUNT-NO)                        
MFA-TR*         AND NY.PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD                    
MFA-TR*         AND NY.COMPANY_NO      = '01'                                   
MFA-TR*         AND NY.CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE                     
MFA-TR*         AND CHAR(DATE(:I-INTERRUPT-START-DT))                           
MFA-TR*           ||CHAR(:I-INTERRUPT-START-TM) >=                              
MFA-TR*           CHAR(NY.INTERRUPT_START_DT)                                   
MFA-TR*           ||CHAR(NY.INTERRUPT_START_TM)                                 
MFA-TR*         AND CHAR(DATE(:I-INTERRUPT-START-DT))                           
MFA-TR*           ||CHAR(:I-INTERRUPT-START-TM) <=                              
MFA-TR*           CHAR(NY.INTERRUPT_END_DT)                                     
MFA-TR*           ||CHAR(NY.INTERRUPT_END_TM)                                   
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE                
                                   S-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
A02395           MOVE '7300'          TO ACTIVE-PARAGRAPH               
                 MOVE 'GET CAT INT'   TO ABEND-FUNCTION                 
                 MOVE 'CSS_INTERRUPT_CAT'  TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
A02395           MOVE 'PRTY_SVC_CAT_CD'    TO TABLE-ELEMENT-2           
A02395           MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3           
A02395           MOVE NX-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
A02395           MOVE NY-PRTY-SVC-CAT-CD   TO HOSTVAR-ELEMENT-2         
A02395           MOVE NX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
A02395 7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *      GET THE PREVIOUS VALUES FROM CSS_INTERRUPT_EXCP SO THAT   *        
      *      THE CHANGED VALUES WILL BE KNOWN FOR MAINTENANCE HISTORY  *        
      ******************************************************************        
       7500-GET-PREVIOUS-HEADER.                                        
                                                                        
           EXEC SQL                                                     
                                                                        
                SELECT ACCOUNT_NO                                       
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,INTERRUPT_START_DT                               
                      ,REPLACE(CONVERT(CHAR(8), INTERRUPT_START_TM
           , 108), ':', '.') INTERRUPT_START_TM                               
                      ,EXCEPTION_CD                                     
                      ,INTERRUPT_END_DT                                 
                      ,REPLACE(CONVERT(CHAR(8), INTERRUPT_END_TM, 108), 
           ':', '.') INTERRUPT_END_TM                                 
                      ,LAST_UPDATE_USERID                               
                      ,COMMENT                                          
                      ,EGAS_UNIT_AM                                     
                  INTO                                                  
                       :WS-PREV-ACCOUNT-NO                              
                      ,:WS-PREV-CODE-UTIL-TYPE                          
                      ,:WS-PREV-IC-NO                                   
                      ,:WS-PREV-INT-START-DT                            
                      ,:WS-PREV-INT-START-TM                            
                      ,:WS-PREV-EXCEPTION-CD                            
                      ,:WS-PREV-INT-END-DT                              
                      ,:WS-PREV-INT-END-TM                              
                      ,:WS-PREV-UPD-USERID                              
                      ,:WS-PREV-COMMENT                                 
                      ,:WS-PREV-EGAS-UNIT-AM                            
                  FROM CSS_INTERRUPT_EXCP WITH(READUNCOMMITTED)                 
                 WHERE ACCOUNT_NO      = :NX-ACCOUNT-NO                 
                   AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE             
                   AND IC_NO           = :NX-IC-NO                      
A02395             AND INTERRUPT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                 :NX-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :NX-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:NX-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:NX-INTERRUPT-START-DT
              ), CONVERT(DATE, :NX-INTERRUPT-START-DT) )   
A02395             AND INTERRUPT_START_TM    = CIS.CHAR2TIME(
                                                 :NX-INTERRUPT-START-TM
              )   
T35434                                                           
A02395                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*         SELECT ACCOUNT_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,INTERRUPT_START_DT                                       
MFA-TR*               ,INTERRUPT_START_TM                                       
MFA-TR*               ,EXCEPTION_CD                                             
MFA-TR*               ,INTERRUPT_END_DT                                         
MFA-TR*               ,INTERRUPT_END_TM                                         
MFA-TR*               ,LAST_UPDATE_USERID                                       
MFA-TR*               ,COMMENT                                                  
MFA-TR*               ,EGAS_UNIT_AM                                             
MFA-TR*           INTO                                                          
MFA-TR*                :WS-PREV-ACCOUNT-NO                                      
MFA-TR*               ,:WS-PREV-CODE-UTIL-TYPE                                  
MFA-TR*               ,:WS-PREV-IC-NO                                           
MFA-TR*               ,:WS-PREV-INT-START-DT                                    
MFA-TR*               ,:WS-PREV-INT-START-TM                                    
MFA-TR*               ,:WS-PREV-EXCEPTION-CD                                    
MFA-TR*               ,:WS-PREV-INT-END-DT                                      
MFA-TR*               ,:WS-PREV-INT-END-TM                                      
MFA-TR*               ,:WS-PREV-UPD-USERID                                      
MFA-TR*               ,:WS-PREV-COMMENT                                         
MFA-TR*               ,:WS-PREV-EGAS-UNIT-AM                                    
MFA-TR*           FROM CSS_INTERRUPT_EXCP                                       
MFA-TR*          WHERE ACCOUNT_NO      = :NX-ACCOUNT-NO                         
MFA-TR*            AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE                     
MFA-TR*            AND IC_NO           = :NX-IC-NO                              
MFA-TR*            AND INTERRUPT_START_DT    = :NX-INTERRUPT-START-DT           
MFA-TR*            AND INTERRUPT_START_TM    = :NX-INTERRUPT-START-TM           
MFA-TR*           WITH UR                                                       
MFA-TR*          QUERYNO 7500                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02395     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A02395                                         S-RETURN-CODE            
                                                                        
A02395     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02395        CONTINUE                                                  
A02395     ELSE                                                         
A02395        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02395        MOVE '7500'                     TO ACTIVE-PARAGRAPH       
A02395        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A02395        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A02395                                           ABEND-TABLES           
A02395        MOVE 'CSS_INTERRUPT_EXCP'       TO TABLE-1                
A02395        MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
A02395        MOVE 'IC_NO  '                  TO TABLE-ELEMENT-2        
A02395        MOVE 'CODE_UTIL_TYPE  '         TO TABLE-ELEMENT-3        
A02395        MOVE 'INTERRUPT_START_DT '      TO TABLE-ELEMENT-4        
A02395        MOVE NX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A02395        MOVE NX-IC-NO                   TO HOSTVAR-ELEMENT-2      
A02395        MOVE NX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
A02395        MOVE NX-INTERRUPT-START-DT      TO HOSTVAR-ELEMENT-4      
A02395        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A02395        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A02395     END-IF                                                       
           .                                                            
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * INSERT INTERRUPT EXCEPTION                                    *         
      *****************************************************************         
       8070-INSERT-INT.                                                 
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_INTERRUPT_EXCP                          
                       (                                                
                        ACCOUNT_NO                                      
                       ,CODE_UTIL_TYPE                                  
                       ,IC_NO                                           
                       ,INTERRUPT_START_DT                              
                       ,INTERRUPT_START_TM                              
                       ,EXCEPTION_CD                                    
                       ,INTERRUPT_END_DT                                
                       ,INTERRUPT_END_TM                                
                       ,LAST_UPDATE_USERID                              
                       ,LAST_UPDATE_TS                                  
                       ,COMMENT                                         
                       ,EGAS_UNIT_AM                                    
                       )                                                
                VALUES                                                  
                       (                                                
                        :NX-ACCOUNT-NO                                  
                       ,:NX-CODE-UTIL-TYPE                              
                       ,:NX-IC-NO                                       
                       ,IIF(TRY_CONVERT(DATE, :NX-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :NX-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:NX-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:NX-INTERRUPT-START-DT
              ), CONVERT(DATE, :NX-INTERRUPT-START-DT) )                    
                       ,CIS.CHAR2TIME(:NX-INTERRUPT-START-TM)                   
                       ,:NX-EXCEPTION-CD                                
                       ,IIF(TRY_CONVERT(DATE, :NX-INTERRUPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :NX-INTERRUPT-END-DT
              ) <> 0) OR (LEN(:NX-INTERRUPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:NX-INTERRUPT-END-DT
              ), CONVERT(DATE, :NX-INTERRUPT-END-DT) )                      
                       ,CIS.CHAR2TIME(:NX-INTERRUPT-END-TM)                     
                       ,:NX-LAST-UPDATE-USERID                          
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:NX-COMMENT                                     
                       ,:NX-EGAS-UNIT-AM                                
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_INTERRUPT_EXCP                                  
MFA-TR*                (                                                        
MFA-TR*                 ACCOUNT_NO                                              
MFA-TR*                ,CODE_UTIL_TYPE                                          
MFA-TR*                ,IC_NO                                                   
MFA-TR*                ,INTERRUPT_START_DT                                      
MFA-TR*                ,INTERRUPT_START_TM                                      
MFA-TR*                ,EXCEPTION_CD                                            
MFA-TR*                ,INTERRUPT_END_DT                                        
MFA-TR*                ,INTERRUPT_END_TM                                        
MFA-TR*                ,LAST_UPDATE_USERID                                      
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,COMMENT                                                 
MFA-TR*                ,EGAS_UNIT_AM                                            
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :NX-ACCOUNT-NO                                          
MFA-TR*                ,:NX-CODE-UTIL-TYPE                                      
MFA-TR*                ,:NX-IC-NO                                               
MFA-TR*                ,DATE(:NX-INTERRUPT-START-DT)                            
MFA-TR*                ,TIME(:NX-INTERRUPT-START-TM)                            
MFA-TR*                ,:NX-EXCEPTION-CD                                        
MFA-TR*                ,DATE(:NX-INTERRUPT-END-DT)                              
MFA-TR*                ,TIME(:NX-INTERRUPT-END-TM)                              
MFA-TR*                ,:NX-LAST-UPDATE-USERID                                  
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:NX-COMMENT                                             
MFA-TR*                ,:NX-EGAS-UNIT-AM                                        
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_INTERRUPT_EXCP'      TO TABLE-1                 
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8070-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * UPDATE INTERRUPT EXCEPTION                                    *         
      *****************************************************************         
       8080-UPDATE-INT.                                                 
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_INTERRUPT_EXCP                                  
                SET EXCEPTION_CD          = :NX-EXCEPTION-CD            
                   ,INTERRUPT_END_DT      = IIF(TRY_CONVERT(DATE, 
                                                   :NX-INTERRUPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :NX-INTERRUPT-END-DT
              ) <> 0) OR (LEN(:NX-INTERRUPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:NX-INTERRUPT-END-DT
              ), CONVERT(DATE, :NX-INTERRUPT-END-DT) )        
                   ,INTERRUPT_END_TM      = CIS.CHAR2TIME(
                                                   :NX-INTERRUPT-END-TM
              )        
                   ,LAST_UPDATE_USERID    = :NX-LAST-UPDATE-USERID      
                   ,LAST_UPDATE_TS        = CIS.CURRENT$TIMESTAMP()           
                   ,COMMENT               = :NX-COMMENT                 
                   ,EGAS_UNIT_AM          = :NX-EGAS-UNIT-AM            
              WHERE ACCOUNT_NO            = :NX-ACCOUNT-NO              
                AND IC_NO                 = :NX-IC-NO                   
                AND CODE_UTIL_TYPE        = :NX-CODE-UTIL-TYPE          
                AND INTERRUPT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                 :NX-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :NX-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:NX-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:NX-INTERRUPT-START-DT
              ), CONVERT(DATE, :NX-INTERRUPT-START-DT) )      
                AND INTERRUPT_START_TM    = CIS.CHAR2TIME(
                                                 :NX-INTERRUPT-START-TM
              )      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_INTERRUPT_EXCP                                          
MFA-TR*         SET EXCEPTION_CD          = :NX-EXCEPTION-CD                    
MFA-TR*            ,INTERRUPT_END_DT      = :NX-INTERRUPT-END-DT                
MFA-TR*            ,INTERRUPT_END_TM      = :NX-INTERRUPT-END-TM                
MFA-TR*            ,LAST_UPDATE_USERID    = :NX-LAST-UPDATE-USERID              
MFA-TR*            ,LAST_UPDATE_TS        = CURRENT TIMESTAMP                   
MFA-TR*            ,COMMENT               = :NX-COMMENT                         
MFA-TR*            ,EGAS_UNIT_AM          = :NX-EGAS-UNIT-AM                    
MFA-TR*       WHERE ACCOUNT_NO            = :NX-ACCOUNT-NO                      
MFA-TR*         AND IC_NO                 = :NX-IC-NO                           
MFA-TR*         AND CODE_UTIL_TYPE        = :NX-CODE-UTIL-TYPE                  
MFA-TR*         AND INTERRUPT_START_DT    = :NX-INTERRUPT-START-DT              
MFA-TR*         AND INTERRUPT_START_TM    = :NX-INTERRUPT-START-TM              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8080'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_INTERRUPT_EXCP'      TO TABLE-1                 
A02395        MOVE 'ACCOUNT_NO    '          TO TABLE-ELEMENT-1         
A02395        MOVE 'IC_NO  '                 TO TABLE-ELEMENT-2         
A02395        MOVE 'CODE_UTIL_TYPE  '        TO TABLE-ELEMENT-3         
A02395        MOVE 'INTERRUPT_START_DT '     TO TABLE-ELEMENT-4         
A02395        MOVE NX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
A02395        MOVE NX-IC-NO                  TO HOSTVAR-ELEMENT-2       
A02395        MOVE NX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
A02395        MOVE NX-INTERRUPT-START-DT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8080-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * DELETE INTERRUPT EXCEPTION                                    *         
      *****************************************************************         
       8090-DELETE-INT.                                                 
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_INTERRUPT_EXCP                             
              WHERE ACCOUNT_NO            = :NX-ACCOUNT-NO              
                AND IC_NO                 = :NX-IC-NO                   
                AND CODE_UTIL_TYPE        = :NX-CODE-UTIL-TYPE          
                AND INTERRUPT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                 :NX-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :NX-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:NX-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:NX-INTERRUPT-START-DT
              ), CONVERT(DATE, :NX-INTERRUPT-START-DT) )      
                AND INTERRUPT_START_TM    = CIS.CHAR2TIME(
                                                 :NX-INTERRUPT-START-TM
              )      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_INTERRUPT_EXCP                                     
MFA-TR*       WHERE ACCOUNT_NO            = :NX-ACCOUNT-NO                      
MFA-TR*         AND IC_NO                 = :NX-IC-NO                           
MFA-TR*         AND CODE_UTIL_TYPE        = :NX-CODE-UTIL-TYPE                  
MFA-TR*         AND INTERRUPT_START_DT    = :NX-INTERRUPT-START-DT              
MFA-TR*         AND INTERRUPT_START_TM    = :NX-INTERRUPT-START-TM              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8090'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_INTERRUPT_EXCP'      TO TABLE-1                 
A02395        MOVE 'ACCOUNT_NO    '          TO TABLE-ELEMENT-1         
A02395        MOVE 'IC_NO  '                 TO TABLE-ELEMENT-2         
A02395        MOVE 'CODE_UTIL_TYPE  '        TO TABLE-ELEMENT-3         
A02395        MOVE 'INTERRUPT_START_DT '     TO TABLE-ELEMENT-4         
A02395        MOVE NX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
A02395        MOVE NX-IC-NO                  TO HOSTVAR-ELEMENT-2       
A02395        MOVE NX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
A02395        MOVE NX-INTERRUPT-START-DT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8090-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * DELETE INTERRUPT EXCEPTION HISTORY                            *         
      *****************************************************************         
       8091-DELETE-HIST.                                                
           EXEC SQL                                                     
             DELETE FROM CSS_INTERRUPT_HIST                             
              WHERE ACCOUNT_NO            = :NZ-ACCOUNT-NO              
                AND IC_NO                 = :NZ-IC-NO                   
T33415*         AND BILL_NO               = :NZ-BILL-NO                         
                AND CODE_UTIL_TYPE        = :NZ-CODE-UTIL-TYPE          
T33415*         AND BILL_ITEM_TIMESTMP    = :NZ-BILL-ITEM-TIMESTMP              
                AND INTERRUPT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                 :NZ-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :NZ-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:NZ-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:NZ-INTERRUPT-START-DT
              ), CONVERT(DATE, :NZ-INTERRUPT-START-DT) )      
                AND INTERRUPT_START_TM    = CIS.CHAR2TIME(
                                                 :NZ-INTERRUPT-START-TM
              )      
                AND EXCEPTION_CD          = :NZ-EXCEPTION-CD            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_INTERRUPT_HIST                                     
MFA-TR*       WHERE ACCOUNT_NO            = :NZ-ACCOUNT-NO                      
MFA-TR*         AND IC_NO                 = :NZ-IC-NO                           
MFA-TR*         AND BILL_NO               = :NZ-BILL-NO                         
MFA-TR*         AND CODE_UTIL_TYPE        = :NZ-CODE-UTIL-TYPE                  
MFA-TR*         AND BILL_ITEM_TIMESTMP    = :NZ-BILL-ITEM-TIMESTMP              
MFA-TR*         AND INTERRUPT_START_DT    = :NZ-INTERRUPT-START-DT              
MFA-TR*         AND INTERRUPT_START_TM    = :NZ-INTERRUPT-START-TM              
MFA-TR*         AND EXCEPTION_CD          = :NZ-EXCEPTION-CD                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8091'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_INTERRUPT_HIST'      TO TABLE-1                 
A02395        MOVE 'ACCOUNT_NO    '          TO TABLE-ELEMENT-1         
A02395        MOVE 'IC_NO  '                 TO TABLE-ELEMENT-2         
A02395        MOVE 'CODE_UTIL_TYPE  '        TO TABLE-ELEMENT-3         
A02395        MOVE 'INTERRUPT_START_DT '     TO TABLE-ELEMENT-4         
A02395        MOVE NZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
A02395        MOVE NZ-IC-NO                  TO HOSTVAR-ELEMENT-2       
A02395        MOVE NZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
A02395        MOVE NZ-INTERRUPT-START-DT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8091-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *---------------------------------------------------------------*         
      *   OPEN THE RESULT SET CURSOR                                  *         
      *---------------------------------------------------------------*         
                                                                        
       8900-SEND-DONE.                                                  
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
           .                                                            
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SENDS ERROR RESULT                                            *         
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
                                           S-RETURN-CODE                
                                           ABEND-SQLCODE.               
A02395*      DISPLAY ACTIVE-PARAGRAPH                                           
             EXEC SQL                                                   
               ROLLBACK                                                 
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             IF SQLCODE = 0                                             
                CONTINUE                                                
             ELSE                                                       
                MOVE 'ROLLBACK' TO ABEND-FUNCTION                       
             END-IF.                                                    
                                                                        
       9000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       9100-CHECK-ERROR.                                                
                                                                        
           EXIT                                                         
           .                                                            
       9100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      *---------------------------------------------------------------*         
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!    *         
      *---------------------------------------------------------------*         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF                                                       
                                                                        
           
MSQ016        GOBACK                                                     
           .                                                            
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
