       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03501.                                     
COB303 DATE-WRITTEN.     DEC 27,  2004.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03501              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03501 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVES INTERRUPT EXCEPTION INFORMATION.             --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            CODE_UTIL_TYPE        CHAR(01)                  --         
      *--            IC_NO                 CHAR(03)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  27 DEC 2004   PD80186     NEW CODE                        --         
      *--                                                            --         
C34624*--  14 NOV 2006   AD94658     ADDED ACCOUNT_NO TO 2240- PARA  --         
C34624*--                            INORDER TO AVOID DUPLICATE ROWS.--         
T35434*--  30 JUL 2007   MR97640     REPLACED MODEL_SQL WITH SET     --         
T35434*--                            STATEMENT AND ADDED WITH UR TO  --         
T35434*--                            AVOID -911.                     --         
A02034*--  04 MAR 2010   VIJAY       FIX MIN DATE QUERY TO AVOID     --         
A02034*--                            -305 ISSUES.                    --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03501'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBINTEXP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBINTCAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBVOLBLK                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
                                                                        
      *                                                                         
                                                                        
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
      *                                                                         
       01  WS-ACTIVE-RETURN-CODE1     PIC S9(9)  COMP VALUE 0.          
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03501'.      
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-NAME                PIC X(26) VALUE                  
                                           'SESSION.CSR03501_R1'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
      *                                                                         
       01  LS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
      *                                                                         
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  WS-FUTURE-DATE.                                              
           10 S-FUT-INT-ST-DT      PIC X(10) VALUE SPACES.              
           10 S-FUT-INT-ST-TM      PIC X(08) VALUE SPACES.              
           10 S-FUT-INT-END-DT     PIC X(10) VALUE SPACES.              
           10 S-FUT-INT-END-TM     PIC X(08) VALUE SPACES.              
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE        PIC S9(9) VALUE 0 COMP.              
           10 S-INTERRUPT-START-DT PIC X(10) VALUE SPACES.              
           10 S-INTERRUPT-START-TM PIC X(08) VALUE SPACES.              
           10 S-INTERRUPT-END-DT   PIC X(10) VALUE SPACES.              
           10 S-INTERRUPT-END-TM   PIC X(08) VALUE SPACES.              
           10 S-EXCEPTION-CD       PIC X(02) VALUE SPACES.              
           10 S-COMMENT            PIC X(250) VALUE SPACES.             
           10 S-LAST-UPDATE-USERID PIC X(07) VALUE SPACES.              
           10 S-VOL-BLOCK          PIC X(01) VALUE SPACES.              
           10 S-CAT-INT-ST-DT      PIC X(10) VALUE SPACES.              
           10 S-CAT-INT-ST-TM      PIC X(08) VALUE SPACES.              
           10 S-CAT-INT-END-DT     PIC X(10) VALUE SPACES.              
           10 S-CAT-INT-END-TM     PIC X(08) VALUE SPACES.              
           10 S-EGAS-UNIT-AM       PIC S9(5)V9(6) USAGE COMP-3 VALUE 0. 
           10 S-CANCEL-REBILL-FL   PIC X(01) VALUE SPACES.              
           10 S-INTERRUPT-BILLED   PIC X(01) VALUE SPACES.              
      *                                                                         
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY       PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-MM         PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-DD         PIC X(02) VALUE SPACES.           
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-DD        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-CCYY      PIC X(04) VALUE SPACES.           
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
      *                                                                         
       01  WS-MISC-ITEMS.                                               
           05  WS-EXISTS-FLAG          PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-PENDING-CODE         PIC X(01) VALUE 'P'.             
           05  WS-PARM-ACCOUNT-NO      PIC 9(13) VALUE ZERO.            
           05  WS-AMT-DUE              PIC 9(11)V9(2) VALUE 0.          
           05  WS-AMT-DUE-T            PIC 9(13) VALUE 0.               
           05  WS-MST-ACCT-NO          PIC 9(13) VALUE ZERO.            
           05  WS-IC-NO                PIC 9(04) VALUE ZERO.            
           05  WS-VOL-BLOCK            PIC X(01) VALUE 'N'.             
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-ACCOUNT-NO-L         PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-ACCOUNT-NO-H         PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-STATUS-CD-L          PIC X(01) VALUE SPACES.          
           05  WS-STATUS-CD-H          PIC X(01) VALUE SPACES.          
           05  WS-SCHED-SEND-DT-L      PIC X(10) VALUE SPACES.          
           05  WS-SCHED-SEND-DT-H      PIC X(10) VALUE SPACES.          
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-INDICATOR-2     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND1            PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND2            PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND3            PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND4            PIC S9(04) COMP VALUE +0.        
           05  WS-DEST-ID              PIC X(10).                       
           05  WS-CURRENT-DATE          PIC X(10).                      
           05  WS-CURRENT-TIME          PIC X(08).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26).                      
           05  WS-CANCEL-REBILL         PIC X(01).                      
           05  WS-INTERRUPT-END-DT      PIC X(10).                      
           05  WS-INTERRUPT-START-DT    PIC X(10).                      
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
      ******************************************************************        
      *     CURSOR DECLARATIONS                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE HDR1_CURSOR CURSOR FOR                            
                SELECT CIS.CHAR2$DATE(INTERRUPT_START_DT, 'USA')                
                       ,REPLACE(CONVERT(CHAR(8), INTERRUPT_START_TM
           , 108), ':', '.') INTERRUPT_START_TM                              
                       ,CIS.CHAR2$DATE(INTERRUPT_END_DT, 'USA')                 
                       ,REPLACE(CONVERT(CHAR(8), INTERRUPT_END_TM
           , 108), ':', '.') INTERRUPT_END_TM                                
                       ,EXCEPTION_CD                                    
                       ,COMMENT                                         
                       ,LAST_UPDATE_USERID                              
                       ,EGAS_UNIT_AM                                    
                       ,INTERRUPT_END_DT                                
                       ,INTERRUPT_START_DT                              
                FROM    CSS_INTERRUPT_EXCP WITH(READUNCOMMITTED)                
                WHERE ACCOUNT_NO      = :NX-ACCOUNT-NO                  
                  AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE              
                  AND IC_NO           = :NX-IC-NO                       
                ORDER BY INTERRUPT_START_DT                             
                        ,INTERRUPT_START_TM                             
T35434            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE HDR1_CURSOR CURSOR FOR                                    
MFA-TR*         SELECT CHAR(INTERRUPT_START_DT, USA)                            
MFA-TR*                ,INTERRUPT_START_TM                                      
MFA-TR*                ,CHAR(INTERRUPT_END_DT, USA)                             
MFA-TR*                ,INTERRUPT_END_TM                                        
MFA-TR*                ,EXCEPTION_CD                                    00450010
MFA-TR*                ,COMMENT                                         00450010
MFA-TR*                ,LAST_UPDATE_USERID                                      
MFA-TR*                ,EGAS_UNIT_AM                                            
MFA-TR*                ,INTERRUPT_END_DT                                        
MFA-TR*                ,INTERRUPT_START_DT                                      
MFA-TR*         FROM    CSS_INTERRUPT_EXCP                              00450010
MFA-TR*         WHERE ACCOUNT_NO      = :NX-ACCOUNT-NO                          
MFA-TR*           AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE                      
MFA-TR*           AND IC_NO           = :NX-IC-NO                               
MFA-TR*         ORDER BY INTERRUPT_START_DT                                     
MFA-TR*                 ,INTERRUPT_START_TM                                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01 I-ACCOUNT-NO          PIC  X(13).                             
       01 I-CODE-UTIL-TYPE      PIC  X(01).                             
       01 I-IC-NO               PIC  S9(4) USAGE COMP.                  
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                               ,I-CODE-UTIL-TYPE                        
                               ,I-IC-NO                                 
                               .                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------          
      *--  0100A-DECLARE-GTT                                        --          
      *--  DECLARE TEMPORARY TABLE                                  --          
      *---------------------------------------------------------------          
      *                                                                         
       0100A-DECLARE-GTT.                                               
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR03501_R1'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03501_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03501_R1
              (                                                    
             RETURN_CODE            INT                             
            ,INTERRUPT_START_DT CHAR(10)  COLLATE 
                          LATIN1_GENERAL_100_BIN2                            
            ,INTERRUPT_START_TM CHAR(08)  COLLATE 
                          LATIN1_GENERAL_100_BIN2                            
            ,INTERRUPT_END_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
            ,INTERRUPT_END_TM CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2         
            ,EXCEPTION_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
            ,COMMENT CHAR(250)  COLLATE LATIN1_GENERAL_100_BIN2                 
            ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                          LATIN1_GENERAL_100_BIN2                            
            ,VOL_BLOCK CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2                
            ,CAT_INT_ST_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
            ,CAT_INT_ST_TM CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2            
            ,CAT_INT_END_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
            ,CAT_INT_END_TM CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2           
            ,FUT_INT_ST_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
            ,FUT_INT_ST_TM CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2            
            ,FUT_INT_END_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
            ,FUT_INT_END_TM CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2           
            ,EGAS_UNIT_AM           DECIMAL(11,6)                       
            ,CANCEL_REBILL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
            ,INTERRUPT_BILLED CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      *---------------------------------------------------------------          
      *--  SET UP SQL ERROR PROCESSING                              --          
      *--  DECLARE ASSOCIATED CURSOR                                --          
      *---------------------------------------------------------------          
      *                                                                         
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR  FOR                        
               SELECT *                                                 
               FROM #CSR03501_R1                                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*        FROM SESSION.CSR03501_R1                                         
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT  THRU 2200-EXIT.                   
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
      *                                                                         
           MOVE I-ACCOUNT-NO            TO WS-ACCOUNT-NO                
           MOVE WS-ACCOUNT-NO           TO NX-ACCOUNT-NO                
C34624                                    ,NY-ACCOUNT-NO                
           MOVE I-IC-NO                 TO WS-IC-NO                     
           MOVE WS-IC-NO                TO NX-IC-NO                     
           MOVE I-CODE-UTIL-TYPE        TO NX-CODE-UTIL-TYPE            
           MOVE NX-ACCOUNT-NO           TO BI-ACCOUNT-NO                
           MOVE NX-ACCOUNT-NO           TO AT-ACCOUNT-NO                
           MOVE NX-CODE-UTIL-TYPE       TO BG-CODE-UTIL-TYPE            
           MOVE NX-IC-NO                TO BG-IC-NO                     
           PERFORM 7300-SELECT-CAN-REBILL THRU 7300-EXIT                
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                  TO S-CANCEL-REBILL-FL           
           ELSE                                                         
              MOVE 'N'                  TO S-CANCEL-REBILL-FL           
           END-IF                                                       
           PERFORM 7400-SELECT-LAST-BILL  THRU 7400-EXIT                
           PERFORM 7210-SELECT-PRTY-SVC-CAT   THRU 7210-EXIT.           
           MOVE Z4-PRTY-SVC-CAT-CD       TO NY-PRTY-SVC-CAT-CD          
           PERFORM 2240-GET-FUT-DATE     THRU 2240-EXIT.                
           PERFORM 2210-GET-VOL-BLOCK    THRU 2210-EXIT.                
           IF UB-PRIMARY-IC-NO > 0 AND WS-ACTIVE-RETURN-CODE = 0        
              MOVE 'Y' TO WS-VOL-BLOCK                                  
           ELSE                                                         
              MOVE 'N' TO WS-VOL-BLOCK                                  
           END-IF.                                                      
           MOVE   WS-VOL-BLOCK           TO  S-VOL-BLOCK                
           PERFORM 7000-OPEN-HDR-CURSOR THRU 7000-EXIT                  
           PERFORM 7100-FETCH-HDR-CURSOR THRU 7100-EXIT                 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2300-MOVE-VALUES      THRU 2300-EXIT              
              PERFORM 7100-FETCH-HDR-CURSOR THRU 7100-EXIT              
           END-PERFORM                                                  
           PERFORM 7200-CLOSE-HDR-CURSOR THRU 7200-EXIT.                
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE NOT-FOUND              TO S-RETURN-CODE              
              MOVE WS-VOL-BLOCK           TO  S-VOL-BLOCK               
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-MOVE-VALUES                                              *         
      *                                                                *        
      *     MOVE VALUES INTO RESULT SET.                               *        
      *                                                                *        
      ******************************************************************        
       2300-MOVE-VALUES.                                                
      *                                                                         
           MOVE 0                        TO  S-RETURN-CODE              
           IF BN-DATE-EXTRACT > SPACES                                  
              IF BN-DATE-EXTRACT >= WS-INTERRUPT-START-DT               
                 MOVE 'Y'       TO S-INTERRUPT-BILLED                   
              ELSE                                                      
                 MOVE SPACES    TO S-INTERRUPT-BILLED
              END-IF                   
           ELSE                                                         
                 MOVE SPACES    TO S-INTERRUPT-BILLED                   
           END-IF                                                       
           MOVE   NX-INTERRUPT-START-DT  TO  S-INTERRUPT-START-DT       
           MOVE   NX-INTERRUPT-START-TM  TO  S-INTERRUPT-START-TM       
           MOVE   NX-INTERRUPT-END-DT    TO  S-INTERRUPT-END-DT         
           MOVE   NX-INTERRUPT-END-TM    TO  S-INTERRUPT-END-TM         
           MOVE   NX-EXCEPTION-CD        TO  S-EXCEPTION-CD             
           MOVE   NX-COMMENT-TEXT        TO  S-COMMENT                  
           MOVE   NX-LAST-UPDATE-USERID  TO  S-LAST-UPDATE-USERID       
           MOVE   NX-EGAS-UNIT-AM        TO  S-EGAS-UNIT-AM             
           PERFORM 2220-GET-CAT-INT           THRU 2220-EXIT.           
           MOVE   NY-INTERRUPT-START-DT  TO  S-CAT-INT-ST-DT            
           MOVE   NY-INTERRUPT-START-TM  TO  S-CAT-INT-ST-TM            
           MOVE   NY-INTERRUPT-END-DT    TO  S-CAT-INT-END-DT           
           MOVE   NY-INTERRUPT-END-TM    TO  S-CAT-INT-END-TM           
           PERFORM 7150-GET-CURRENT-INFO THRU 7150-EXIT.                
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
                                                                        
******************************************************************              
      **  2210-GET-VOL-BLOCK                                                    
******************************************************************              
       2210-GET-VOL-BLOCK.                                              
      *------------------------*                                                
           MOVE '2210'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                                                                        
             SELECT DISTINCT PRIMARY_IC_NO                              
               INTO :UB-PRIMARY-IC-NO                                   
               FROM CSS_VOL_BLOCK WITH(READUNCOMMITTED)                         
              WHERE ACCOUNT_NO = :NX-ACCOUNT-NO                         
T35434                                                           
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*      SELECT DISTINCT PRIMARY_IC_NO                                      
MFA-TR*        INTO :UB-PRIMARY-IC-NO                                           
MFA-TR*        FROM CSS_VOL_BLOCK                                               
MFA-TR*       WHERE ACCOUNT_NO = :NX-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO WS-VOL-BLOCK                               
              ELSE                                                      
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '2210'          TO ACTIVE-PARAGRAPH               
                 MOVE 'GET VOL BLOCK'      TO ABEND-FUNCTION            
                 MOVE 'CSS_VOL_BLOCK' TO TABLE-1                        
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2220-GET-CAT-INT                                               *        
      *                                                                *        
      *     GET THE CAT INTERRUPT VALUES.                              *        
      *                                                                *        
      ******************************************************************        
       2220-GET-CAT-INT.                                                
      *------------------------*                                                
           MOVE '2220'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                                                                        
             SELECT CIS.CHAR2$DATE(NY.INTERRUPT_START_DT, 'USA')                
                   ,REPLACE(CONVERT(CHAR(8), NY.INTERRUPT_START_TM
           , 108), ':', '.') INTERRUPT_START_TM                               
                   ,CIS.CHAR2$DATE(NY.INTERRUPT_END_DT, 'USA')                  
                   ,REPLACE(CONVERT(CHAR(8), NY.INTERRUPT_END_TM, 108), 
           ':', '.') INTERRUPT_END_TM                                 
               INTO   :NY-INTERRUPT-START-DT                            
                     ,:NY-INTERRUPT-START-TM                            
                     ,:NY-INTERRUPT-END-DT                              
                     ,:NY-INTERRUPT-END-TM                              
               FROM  CSS_INTERRUPT_CAT NY WITH(READUNCOMMITTED)                 
C34624        WHERE (ACCOUNT_NO     = :NY-ACCOUNT-NO                    
C34624               OR ACCOUNT_NO  = 0)                                
                AND NY.PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD            
                AND NY.COMPANY_NO      = '01'                           
                AND NY.CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE             
                AND CAST(IIF(TRY_CONVERT(DATE, :S-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :S-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:S-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:S-INTERRUPT-START-DT
              ), CONVERT(DATE, :S-INTERRUPT-START-DT) ) AS CHAR(10)) + 
                                               :S-INTERRUPT-START-TM >=        
                  CAST(NY.INTERRUPT_START_DT AS CHAR(10)) + REPLACE(
           CONVERT(CHAR(8), NY.INTERRUPT_START_TM, 108), ':', '.')             
                AND CAST(IIF(TRY_CONVERT(DATE, :S-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :S-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:S-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:S-INTERRUPT-START-DT
              ), CONVERT(DATE, :S-INTERRUPT-START-DT) ) AS CHAR(10)) + 
                                               :S-INTERRUPT-START-TM <=        
                  CAST(NY.INTERRUPT_END_DT AS CHAR(10)) + REPLACE(
           CONVERT(CHAR(8), NY.INTERRUPT_END_TM, 108), ':', '.')               
T35434                                                           
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*      SELECT CHAR(NY.INTERRUPT_START_DT, USA)                            
MFA-TR*            ,NY.INTERRUPT_START_TM                                       
MFA-TR*            ,CHAR(NY.INTERRUPT_END_DT, USA)                              
MFA-TR*            ,NY.INTERRUPT_END_TM                                         
MFA-TR*        INTO   :NY-INTERRUPT-START-DT                                    
MFA-TR*              ,:NY-INTERRUPT-START-TM                                    
MFA-TR*              ,:NY-INTERRUPT-END-DT                                      
MFA-TR*              ,:NY-INTERRUPT-END-TM                                      
MFA-TR*        FROM  CSS_INTERRUPT_CAT NY                                       
MFA-TR*       WHERE (ACCOUNT_NO     = :NY-ACCOUNT-NO                            
MFA-TR*              OR ACCOUNT_NO  = 0)                                        
MFA-TR*         AND NY.PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD                    
MFA-TR*         AND NY.COMPANY_NO      = '01'                                   
MFA-TR*         AND NY.CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE                     
MFA-TR*         AND CHAR(DATE(:S-INTERRUPT-START-DT))                           
MFA-TR*           ||CHAR(:S-INTERRUPT-START-TM) >=                              
MFA-TR*           CHAR(NY.INTERRUPT_START_DT)                                   
MFA-TR*           ||CHAR(NY.INTERRUPT_START_TM)                                 
MFA-TR*         AND CHAR(DATE(:S-INTERRUPT-START-DT))                           
MFA-TR*           ||CHAR(:S-INTERRUPT-START-TM) <=                              
MFA-TR*           CHAR(NY.INTERRUPT_END_DT)                                     
MFA-TR*           ||CHAR(NY.INTERRUPT_END_TM)                                   
MFA-TR*        WITH UR                                                          
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES TO NY-INTERRUPT-START-DT                   
                 MOVE SPACES TO NY-INTERRUPT-START-TM                   
                 MOVE SPACES TO NY-INTERRUPT-END-DT                     
                 MOVE SPACES TO NY-INTERRUPT-END-TM                     
              END-IF                                                    
           ELSE                                                         
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '2220'          TO ACTIVE-PARAGRAPH               
                 MOVE 'GET CAT INT'   TO ABEND-FUNCTION                 
                 MOVE 'CSS_INTERRUPT_CAT'  TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7150-GET-CURRENT-INFO                                          *        
      *                                                                *        
      * GET CURRENT TIMESTAMP, DATE AND TIME                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7150-GET-CURRENT-INFO.                                           
                                                                        
           EXEC SQL                                                     
T35434       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-TIME,
              :WS-CURRENT-DATE                        
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                      
MFA-TR*         ,:WS-CURRENT-TIME = CURRENT TIME                                
MFA-TR*         ,:WS-CURRENT-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                                        
C29529     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7150'                     TO ACTIVE-PARAGRAPH      
T35434         MOVE 'SET'                      TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF                                                       
           .                                                            
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2240-GET-FUT-DATE                                       *               
      *                                                                *        
      * GET FUTURE DATE FROM CAT INTERRUPT TABLE                       *        
      *                                                                *        
      ******************************************************************        
       2240-GET-FUT-DATE.                                               
      *------------------------*                                                
           MOVE '2240'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                                                                        
             SELECT CIS.CHAR2$DATE(INTERRUPT_START_DT, 'USA')                   
                   ,REPLACE(CONVERT(CHAR(8), INTERRUPT_START_TM, 108), 
           ':', '.') INTERRUPT_START_TM                                  
                   ,CIS.CHAR2$DATE(INTERRUPT_END_DT, 'USA')                     
                   ,REPLACE(CONVERT(CHAR(8), INTERRUPT_END_TM, 108), 
           ':', '.') INTERRUPT_END_TM                                    
               INTO   :S-FUT-INT-ST-DT :WS-NULL-IND1                     
                     ,:S-FUT-INT-ST-TM :WS-NULL-IND2                     
                     ,:S-FUT-INT-END-DT :WS-NULL-IND3                    
                     ,:S-FUT-INT-END-TM :WS-NULL-IND4                    
               FROM  CSS_INTERRUPT_CAT WITH(READUNCOMMITTED)                    
C34624        WHERE (ACCOUNT_NO     = :NY-ACCOUNT-NO                    
C34624               OR ACCOUNT_NO  = 0)                                
C34624          AND PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD               
                AND COMPANY_NO      = '01'                              
                AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE                
                AND INTERRUPT_START_DT =                                
                     (                                                  
                      SELECT MAX(INTERRUPT_START_DT)                    
                        FROM CSS_INTERRUPT_CAT WITH(READUNCOMMITTED)            
C34624                 WHERE (ACCOUNT_NO     = :NY-ACCOUNT-NO           
C34624                        OR ACCOUNT_NO  = 0)                       
C34624                   AND PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD      
                         AND COMPANY_NO      = '01'                     
                         AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE       
                     )                                                  
                AND INTERRUPT_START_TM =                                
                     (                                                  
                      SELECT MAX(INTERRUPT_START_TM)                    
                        FROM CSS_INTERRUPT_CAT WITH(READUNCOMMITTED)            
C34624                 WHERE (ACCOUNT_NO     = :NY-ACCOUNT-NO           
C34624                        OR ACCOUNT_NO  = 0)                       
C34624                   AND PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD      
                         AND COMPANY_NO      = '01'                     
                         AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE       
                         AND INTERRUPT_START_DT =                       
                             (                                          
                             SELECT MAX(INTERRUPT_START_DT)             
                                FROM CSS_INTERRUPT_CAT
                           WITH(READUNCOMMITTED)                  
C34624                         WHERE (ACCOUNT_NO   = :NY-ACCOUNT-NO     
C34624                            OR ACCOUNT_NO    = 0)                 
C34624                         AND PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD
                               AND COMPANY_NO      = '01'               
                               AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE 
                             )                                          
                     )                                                  
T35434                                                           
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*      SELECT CHAR(INTERRUPT_START_DT, USA)                               
MFA-TR*            ,INTERRUPT_START_TM                                          
MFA-TR*            ,CHAR(INTERRUPT_END_DT, USA)                                 
MFA-TR*            ,INTERRUPT_END_TM                                            
MFA-TR*        INTO   :S-FUT-INT-ST-DT:WS-NULL-IND1                             
MFA-TR*              ,:S-FUT-INT-ST-TM:WS-NULL-IND2                             
MFA-TR*              ,:S-FUT-INT-END-DT:WS-NULL-IND3                            
MFA-TR*              ,:S-FUT-INT-END-TM:WS-NULL-IND4                            
MFA-TR*        FROM  CSS_INTERRUPT_CAT                                          
MFA-TR*       WHERE (ACCOUNT_NO     = :NY-ACCOUNT-NO                            
MFA-TR*              OR ACCOUNT_NO  = 0)                                        
MFA-TR*         AND PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD                       
MFA-TR*         AND COMPANY_NO      = '01'                                      
MFA-TR*         AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE                        
MFA-TR*         AND INTERRUPT_START_DT =                                        
MFA-TR*              (                                                          
MFA-TR*               SELECT MAX(INTERRUPT_START_DT)                            
MFA-TR*                 FROM CSS_INTERRUPT_CAT                                  
MFA-TR*                WHERE (ACCOUNT_NO     = :NY-ACCOUNT-NO                   
MFA-TR*                       OR ACCOUNT_NO  = 0)                               
MFA-TR*                  AND PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD              
MFA-TR*                  AND COMPANY_NO      = '01'                             
MFA-TR*                  AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE               
MFA-TR*              )                                                          
MFA-TR*         AND INTERRUPT_START_TM =                                        
MFA-TR*              (                                                          
MFA-TR*               SELECT MAX(INTERRUPT_START_TM)                            
MFA-TR*                 FROM CSS_INTERRUPT_CAT                                  
MFA-TR*                WHERE (ACCOUNT_NO     = :NY-ACCOUNT-NO                   
MFA-TR*                       OR ACCOUNT_NO  = 0)                               
MFA-TR*                  AND PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD              
MFA-TR*                  AND COMPANY_NO      = '01'                             
MFA-TR*                  AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE               
MFA-TR*                  AND INTERRUPT_START_DT =                               
MFA-TR*                      (                                                  
MFA-TR*                      SELECT MAX(INTERRUPT_START_DT)                     
MFA-TR*                         FROM CSS_INTERRUPT_CAT                          
MFA-TR*                        WHERE (ACCOUNT_NO   = :NY-ACCOUNT-NO             
MFA-TR*                           OR ACCOUNT_NO    = 0)                         
MFA-TR*                        AND PRTY_SVC_CAT_CD = :NY-PRTY-SVC-CAT-CD        
MFA-TR*                        AND COMPANY_NO      = '01'                       
MFA-TR*                        AND CODE_UTIL_TYPE  = :NX-CODE-UTIL-TYPE         
MFA-TR*                      )                                                  
MFA-TR*              )                                                          
MFA-TR*        WITH UR                                                          
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES         TO S-FUT-INT-ST-DT                 
                                        S-FUT-INT-ST-TM                 
                                        S-FUT-INT-END-DT                
                                        S-FUT-INT-END-TM                
              END-IF                                                    
           ELSE                                                         
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '2240'          TO ACTIVE-PARAGRAPH               
                 MOVE 'GET CAT INT'   TO ABEND-FUNCTION                 
                 MOVE 'CSS_INTERRUPT_CAT'  TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-SELECT-PRTY-SVC-CAT.                                      *        
      *                                                                *        
      * SELECT THE PRTY SVC CAT CD                                     *        
      *                                                                *        
      ******************************************************************        
       7210-SELECT-PRTY-SVC-CAT.                                        
                                                                        
           EXEC SQL                                                     
             SELECT Z4.PRTY_SVC_CAT_CD                                  
               INTO :Z4-PRTY-SVC-CAT-CD                                 
               FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                   
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
              WHERE UT.ACCOUNT_NO = :NX-ACCOUNT-NO                      
                AND UT.IC_NO      = :NX-IC-NO                           
                AND Z4.CODE_CURTAIL_PRTY = UT.CODE_CURTAIL_PRTY         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT Z4.PRTY_SVC_CAT_CD                                          
MFA-TR*        INTO :Z4-PRTY-SVC-CAT-CD                                         
MFA-TR*        FROM CSS_PRTY_SVC_CAT Z4                                         
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*       WHERE UT.ACCOUNT_NO = :NX-ACCOUNT-NO                              
MFA-TR*         AND UT.IC_NO      = :NX-IC-NO                                   
MFA-TR*         AND Z4.CODE_CURTAIL_PRTY = UT.CODE_CURTAIL_PRTY                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_PRTY_SVC_CAT'         TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7210-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7000-OPEN-HDR-CURSOR.                                          *        
      ******************************************************************        
                                                                        
       7000-OPEN-HDR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN HDR1_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
              MOVE 'OPEN '              TO ABEND-FUNCTION               
              MOVE 'CSS_INTERRUPT_EXCP' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-HDR-CURSOR.                                         *        
      *     FETCH HEADER CURSOR TO GET ALL RECORDS SELECTED.           *        
      ******************************************************************        
                                                                        
       7100-FETCH-HDR-CURSOR.                                           
                                                                        
                                                                        
           EXEC SQL                                                     
              FETCH HDR1_CURSOR                                         
              INTO                                                      
                  :NX-INTERRUPT-START-DT                                
                  ,:NX-INTERRUPT-START-TM                               
                  ,:NX-INTERRUPT-END-DT                                 
                  ,:NX-INTERRUPT-END-TM                                 
                  ,:NX-EXCEPTION-CD                                     
                  ,:NX-COMMENT                                          
                  ,:NX-LAST-UPDATE-USERID                               
                  ,:NX-EGAS-UNIT-AM                                     
                  ,:WS-INTERRUPT-END-DT                                 
                  ,:WS-INTERRUPT-START-DT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7100'          TO ACTIVE-PARAGRAPH                  
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_HDR'      TO TABLE-1                   
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-CLOSE-HDR-CURSOR.                                         *        
      ******************************************************************        
                                                                        
       7200-CLOSE-HDR-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE HDR1_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7200'          TO ACTIVE-PARAGRAPH                  
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_EDI_BILL_HDR'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-CAN-REBILL.                                        *        
      *                                                                *        
      * SELECT THE CANCEL REBILL FOR THE IC.                           *        
      *                                                                *        
      ******************************************************************        
       7300-SELECT-CAN-REBILL.                                          
                                                                        
           EXEC SQL                                                     
                SELECT  DISTINCT 'Y'                                    
                  INTO  :WS-CANCEL-REBILL                               
                FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
                    ,CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                WHERE BI.ACCOUNT_NO     = :BI-ACCOUNT-NO                
                AND   BI.ACCOUNT_NO     = BG.ACCOUNT_NO                 
                AND   BI.BILL_NO        = BG.BILL_NO                    
                AND   BI.DATE_BILLED    IS NULL                         
                AND   BG.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE            
                AND   BG.IC_NO          = :BG-IC-NO                     
                AND   BG.DATE_ORIG_BILL IS NOT NULL                     
T35434                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  DISTINCT 'Y'                                            
MFA-TR*           INTO  :WS-CANCEL-REBILL                                       
MFA-TR*         FROM CSS_BILLING_HDR BI                                         
MFA-TR*             ,CSS_BILLING_DET BG                                         
MFA-TR*         WHERE BI.ACCOUNT_NO     = :BI-ACCOUNT-NO                        
MFA-TR*         AND   BI.ACCOUNT_NO     = BG.ACCOUNT_NO                         
MFA-TR*         AND   BI.BILL_NO        = BG.BILL_NO                            
MFA-TR*         AND   BI.DATE_BILLED    IS NULL                                 
MFA-TR*         AND   BG.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                    
MFA-TR*         AND   BG.IC_NO          = :BG-IC-NO                             
MFA-TR*         AND   BG.DATE_ORIG_BILL IS NOT NULL                             
MFA-TR*         WITH  UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET '         TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-SELECT-LAST-BILL.                                         *        
      *                                                                *        
      * SELECT THE LAST BILL DATE                                      *        
      *                                                                *        
      ******************************************************************        
       7400-SELECT-LAST-BILL.                                           
                                                                        
           EXEC SQL                                                     
A02034          SELECT TOP(1) DATE_EXTRACT                                    
                  INTO  :BN-DATE-EXTRACT                                
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
                WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO            
                  AND AT.REV_MTH_LST_NRML   = BN.REVENUE_MONTH          
                  AND BN.BILL_CYCLE         = '21'                      
A02034            ORDER BY DATE_EXTRACT ASC                             
A02034                                              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  DATE_EXTRACT                                            
MFA-TR*           INTO  :BN-DATE-EXTRACT                                        
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_BILL_WINDOW BN                                         
MFA-TR*         WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                    
MFA-TR*           AND AT.REV_MTH_LST_NRML   = BN.REVENUE_MONTH                  
MFA-TR*           AND BN.BILL_CYCLE         = '21'                              
MFA-TR*           ORDER BY DATE_EXTRACT ASC                                     
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02034        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A02034           MOVE SPACES TO BN-DATE-EXTRACT                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_HDR '         TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR03501_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03501_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR03501_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
                                                                        
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *    EXEC SQL                                                             
      *       INCLUDE CPD00300                                                  
      *    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR03501_R1'                               
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL                                                     
                                                                        
               INSERT INTO #CSR03501_R1                          
                   (                                                    
                     RETURN_CODE                                        
                    ,INTERRUPT_START_DT                                 
                    ,INTERRUPT_START_TM                                 
                    ,INTERRUPT_END_DT                                   
                    ,INTERRUPT_END_TM                                   
                    ,EXCEPTION_CD                                       
                    ,COMMENT                                            
                    ,LAST_UPDATE_USERID                                 
                    ,VOL_BLOCK                                          
                    ,CAT_INT_ST_DT                                      
                    ,CAT_INT_ST_TM                                      
                    ,CAT_INT_END_DT                                     
                    ,CAT_INT_END_TM                                     
                    ,FUT_INT_ST_DT                                      
                    ,FUT_INT_ST_TM                                      
                    ,FUT_INT_END_DT                                     
                    ,FUT_INT_END_TM                                     
                    ,EGAS_UNIT_AM                                       
                    ,CANCEL_REBILL_FL                                   
                    ,INTERRUPT_BILLED                                   
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE                                     
                    ,:S-INTERRUPT-START-DT                              
                    ,:S-INTERRUPT-START-TM                              
                    ,:S-INTERRUPT-END-DT                                
                    ,:S-INTERRUPT-END-TM                                
                    ,:S-EXCEPTION-CD                                    
                    ,:S-COMMENT                                         
                    ,:S-LAST-UPDATE-USERID                              
                    ,:S-VOL-BLOCK                                       
                    ,:S-CAT-INT-ST-DT                                   
                    ,:S-CAT-INT-ST-TM                                   
                    ,:S-CAT-INT-END-DT                                  
                    ,:S-CAT-INT-END-TM                                  
                    ,:S-FUT-INT-ST-DT                                   
                    ,:S-FUT-INT-ST-TM                                   
                    ,:S-FUT-INT-END-DT                                  
                    ,:S-FUT-INT-END-TM                                  
                    ,:S-EGAS-UNIT-AM                                    
                    ,:S-CANCEL-REBILL-FL                                
                    ,:S-INTERRUPT-BILLED                                
                   )                                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR03501_R1                                  
MFA-TR*            (                                                            
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,INTERRUPT_START_DT                                         
MFA-TR*             ,INTERRUPT_START_TM                                         
MFA-TR*             ,INTERRUPT_END_DT                                           
MFA-TR*             ,INTERRUPT_END_TM                                           
MFA-TR*             ,EXCEPTION_CD                                               
MFA-TR*             ,COMMENT                                                    
MFA-TR*             ,LAST_UPDATE_USERID                                         
MFA-TR*             ,VOL_BLOCK                                                  
MFA-TR*             ,CAT_INT_ST_DT                                              
MFA-TR*             ,CAT_INT_ST_TM                                              
MFA-TR*             ,CAT_INT_END_DT                                             
MFA-TR*             ,CAT_INT_END_TM                                             
MFA-TR*             ,FUT_INT_ST_DT                                              
MFA-TR*             ,FUT_INT_ST_TM                                              
MFA-TR*             ,FUT_INT_END_DT                                             
MFA-TR*             ,FUT_INT_END_TM                                             
MFA-TR*             ,EGAS_UNIT_AM                                               
MFA-TR*             ,CANCEL_REBILL_FL                                           
MFA-TR*             ,INTERRUPT_BILLED                                           
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-INTERRUPT-START-DT                                      
MFA-TR*             ,:S-INTERRUPT-START-TM                                      
MFA-TR*             ,:S-INTERRUPT-END-DT                                        
MFA-TR*             ,:S-INTERRUPT-END-TM                                        
MFA-TR*             ,:S-EXCEPTION-CD                                            
MFA-TR*             ,:S-COMMENT                                                 
MFA-TR*             ,:S-LAST-UPDATE-USERID                                      
MFA-TR*             ,:S-VOL-BLOCK                                               
MFA-TR*             ,:S-CAT-INT-ST-DT                                           
MFA-TR*             ,:S-CAT-INT-ST-TM                                           
MFA-TR*             ,:S-CAT-INT-END-DT                                          
MFA-TR*             ,:S-CAT-INT-END-TM                                          
MFA-TR*             ,:S-FUT-INT-ST-DT                                           
MFA-TR*             ,:S-FUT-INT-ST-TM                                           
MFA-TR*             ,:S-FUT-INT-END-DT                                          
MFA-TR*             ,:S-FUT-INT-END-TM                                          
MFA-TR*             ,:S-EGAS-UNIT-AM                                            
MFA-TR*             ,:S-CANCEL-REBILL-FL                                        
MFA-TR*             ,:S-INTERRUPT-BILLED                                        
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
              MOVE '8900'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR03501_R1'        TO TABLE-1                      
              MOVE 'DEST_ID'            TO TABLE-ELEMENT-1              
************* MOVE S-DEST-ID           TO HOSTVAR-ELEMENT-1                     
************* PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
                                                                        
               ROLLBACK                                                 
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
***********PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                          
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9100-CHECK-ERROR                                               *        
      ******************************************************************        
       9100-CHECK-ERROR.                                                
           EXIT.                                                        
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
