       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03500.                                     
COB303 DATE-WRITTEN.     JUNE 01, 2003.                                 
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                    SOUTH CAROLINA ELECTRIC & GAS             **         
      *****************************************************************         
      *                     STORED PROCEDURE:  CSR03500              **         
      *****************************************************************         
      *                           S U M M A R Y                      **         
      *                                                              **         
      ***  CSR03500 :                                                **         
      ***                                                            **         
      *****************************************************************         
      ***                                                            **         
      ***  PARAMETERS                                                **         
      ***                                                            **         
      ***      IN                                                    **         
      ***                                                            **         
A02395***            I_PRTY_SVC_CAT_CD     CHAR(02)                  **         
A02395***           ,I_CODE_CURTAIL_PRTY   DECIMAL(3,1)              **         
      ***                                                            **         
      ***      OUT                                                   **         
      ***                                                            **         
A02395***            RETURN_CODE           INTEGER                   **         
A02395***           ,ACCOUNT_NO            DECIMAL(13,0)             **         
A02395***           ,IC_NO                 SMALLINT                  **         
A02395***           ,FULL_NAME             CHAR(40)                  **         
A02395***           ,PRTY_SVC_CAT_CD       CHAR(02)                  **         
A02395***           ,CONTRACT_MDQ          DECIMAL(9, 2)             **         
A02395***           ,VOL_BLOCK             CHAR(01)                  **         
A02395***           ,ZONE_CITY             CHAR(15)                  **         
      ***                                                            **         
      ***      INOUT                                                 **         
      ***                                                            **         
      ***            NONE                                            **         
      ***                                                            **         
      ***  RESULT SET                                                **         
      ***                                                            **         
      ***      1                                                     **         
      ***                                                            **         
      ***                                                            **         
      *****************************************************************         
      ***                        MODIFICATION LOG                    **         
      ***                                                            **         
      ***  DATE          INITIALS    COMMENTS                        **         
      ***  ***********   ********    **********************************         
      ***  02 JUN 2003   PD80186     NEW CODE                        **         
T33415***  24 JAN 2006   VV90387     REFINE CODE                     **         
C34624***  25 SEP 2006   AD94658     ADDED NEW RESULT SET VARIABLE.  **         
T35434***  30 JUL 2007   MR97640     REPLACED MODEL_SQL WITH SET     **         
T35434***                            STATEMENT AND ADDED WITH UR TO  **         
T35434***                            AVOID -911 ABENDS.              **         
A00077**   12 FEB 2009  NC94746      ZONE CITY POPULATED USING       **         
A00077**                             INDUST_BTU_ID OF MN IN PLACE OF **         
A00077**                             GAS_DLVRY_ZONE_CD FIELD OF      **         
A00077**                             CSS_PREM_DLVRY_PT TABLE.        **         
A01088**  04  MAY 2010  SP94986      REF TO THE TABLE DCLGEN TBGSPREM**         
A01088**                             HAS TO BE REMOVED.              **         
A02395**  20  MAY 2010  SV95326      ADDING NEW INPUT PARAMETER      **         
A02395**                             CODE_CURTAIL_PRTY AND PEFORMANCE**         
A02395**                             IMPROVEMENT PROCESS ALSO .      **         
P00801**  25  FEB 2014  MC95456      ADD SECOND RESULT SET WHEN      **         
P00801**                             I_PRTY_SVC_CAT_CD = 'XX'.       **         
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03500'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLCNTR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBVOLBLK                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSADRX                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
A00077     EXEC SQL                                                             
A00077        INCLUDE TBMTRENV                                                  
A00077     END-EXEC.                                                            
                                                                        
A00077     EXEC SQL                                                             
A00077        INCLUDE TBBTUIND                                                  
A00077     END-EXEC.                                                            
                                                                        
P00801     EXEC SQL                                                             
P00801        INCLUDE TBRTCDEF                                                  
P00801     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00074                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00011                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03500'.      
      *                                                                         
      ****************************************************************          
      ***  ERROR PROCESSING VARIABLES                               **          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-ABEND-SWITCH           PIC X(03).                     
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE       PIC S9(9) VALUE 0 COMP.               
COB305     10 S-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.             
           10 S-FULL-NAME         PIC X(40).                            
           10 S-IC-NO             PIC S9(4) USAGE COMP.                 
           10 S-PRTY-SVC-CAT-CD   PIC X(2).                             
COB305     10 S-CONTRACT-DEMAND        PIC S9(7)V9(2) USAGE COMP-3 
COB305       VALUE 0.          
           10 S-VOL-BLOCK         PIC X(01).                            
C34624     10 S-ZONE-CITY         PIC X(15).                            
COB305     10 S-CODE-CURTAIL-PRTY        PIC S9(2)V9(1) USAGE COMP-3 
COB305       VALUE 0.          
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  WS-MISC.                                                     
A02395     05  WS-SQLSTATE                 PIC X(05) VALUE SPACES.      
A02395     05  WS-VOL-BLOCK-IND            PIC X(01) VALUE SPACES.      
A02395     05  WS-CODE-CURTAIL-PRTY        PIC 9(03).                   
A02395     05  WS-CODE-CURTAIL-PRTY-RED    REDEFINES                    
A02395             WS-CODE-CURTAIL-PRTY    PIC 9(2)V9(1).               
A02395     05  WS-CODE-CURTAIL-PRTY-TEXT   PIC 9(1).9(1).               
A02395     05  WS-CODE-CURTAIL-PRTY-Z      PIC -Z(01).9(1).             
P00801     05  WS-PRTY-SVC-CAT-CD          PIC X(2).                    
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  WS-REVENUE-MONTH.                                            
           05  WS-R-YEAR               PIC X(04).                       
           05  WS-R-MONTH              PIC X(02).                       
      *                                                                         
       01  WS-CONTRCT-END-DATE     PIC X(10).                           
       01  WS-CNT-START-DATE.                                           
           05 WS-CONTRCT-YEAR      PIC X(04) VALUE SPACES.              
           05 FILLER               PIC X(01) VALUE '-'.                 
           05 WS-CONTRCT-MONTH     PIC X(02) VALUE SPACES.              
           05 FILLER               PIC X(01) VALUE '-'.                 
           05 WS-CONTRCT-DAY       PIC X(02) VALUE '01'.                
       01  WS-CONTRCT-START-DATE   PIC X(10).                           
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
      ******************************************************************        
      **             VARIABLES IN USE                                 **        
      ******************************************************************        
      ******************************************************************        
      *     CURSOR DECLARATIONS                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE ACCOUNT_CURSOR CURSOR FOR                         
                SELECT AT.ACCOUNT_NO                                    
                     , UT.IC_NO                                         
C34624               , UT.PREMISE_NO                                    
                     , UT.COMPANY_NO                                    
                  FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                     , CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                
                 WHERE UT.ACCOUNT_NO        = AT.ACCOUNT_NO             
                   AND UT.COMPANY_NO        = AT.COMPANY_NO             
                   AND AT.CODE_ACCT_STAT    = 'A'                       
                   AND UT.CODE_UTIL_TYPE    = 'G'                       
A02395             AND UT.CODE_CURTAIL_PRTY = :UT-CODE-CURTAIL-PRTY     
T35434             FOR READ ONLY                                
A02395                                                      
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNT_CURSOR CURSOR FOR                                 
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*              , UT.IC_NO                                                 
MFA-TR*              , UT.PREMISE_NO                                            
MFA-TR*              , UT.COMPANY_NO                                            
MFA-TR*           FROM CSS_UTIL_ENVRNMT UT                                      
MFA-TR*              , CSS_ACCOUNT      AT                                      
MFA-TR*          WHERE UT.ACCOUNT_NO        = AT.ACCOUNT_NO                     
MFA-TR*            AND UT.COMPANY_NO        = AT.COMPANY_NO                     
MFA-TR*            AND AT.CODE_ACCT_STAT    = 'A'                               
MFA-TR*            AND UT.CODE_UTIL_TYPE    = 'G'                               
MFA-TR*            AND UT.CODE_CURTAIL_PRTY = :UT-CODE-CURTAIL-PRTY             
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*       END-EXEC.                                                         
                                                                        
P00801******************************************************************        
P00801*     CURSOR DECLARATION FOR SECOND RESULT SET                   *        
P00801******************************************************************        
                                                                        
P00801     EXEC SQL                                                     
P00801        DECLARE ACCOUNT_CSR CURSOR FOR                            
P00801          SELECT AT.ACCOUNT_NO                                    
P00801               , UT.IC_NO                                         
P00801               , UT.PREMISE_NO                                    
P00801               , UT.COMPANY_NO                                    
P00801               , UT.CODE_CURTAIL_PRTY                             
P00801            FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
P00801               , CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                
P00801           WHERE UT.CODE_UTIL_TYPE   = 'G'                        
P00801             AND AT.CODE_ACCT_STAT   = 'A'                        
P00801             AND AT.COMPANY_NO       = '01'                       
P00801             AND AT.ACCOUNT_NO       = UT.ACCOUNT_NO              
P00801             AND EXISTS                                           
P00801                 (SELECT *                                        
P00801                    FROM CSS_RATE_COMP_DEF J1
                           WITH(READUNCOMMITTED)                     
P00801                   WHERE J1.RATE_PLAN_NO   = UT.RATE_PLAN_NO      
P00801                     AND J1.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE    
P00801                     AND J1.REG_TYPE_CD      = 'D'                
P00801                  )                                               
P00801             FOR READ ONLY                                
P00801                                                      
P00801        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNT_CSR CURSOR FOR                                    
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*              , UT.IC_NO                                                 
MFA-TR*              , UT.PREMISE_NO                                            
MFA-TR*              , UT.COMPANY_NO                                            
MFA-TR*              , UT.CODE_CURTAIL_PRTY                                     
MFA-TR*           FROM CSS_UTIL_ENVRNMT UT                                      
MFA-TR*              , CSS_ACCOUNT      AT                                      
MFA-TR*          WHERE UT.CODE_UTIL_TYPE   = 'G'                                
MFA-TR*            AND AT.CODE_ACCT_STAT   = 'A'                                
MFA-TR*            AND AT.COMPANY_NO       = '01'                               
MFA-TR*            AND AT.ACCOUNT_NO       = UT.ACCOUNT_NO                      
MFA-TR*            AND EXISTS                                                   
MFA-TR*                (SELECT *                                                
MFA-TR*                   FROM CSS_RATE_COMP_DEF J1                             
MFA-TR*                  WHERE J1.RATE_PLAN_NO   = UT.RATE_PLAN_NO              
MFA-TR*                    AND J1.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE            
MFA-TR*                    AND J1.REG_TYPE_CD      = 'D'                        
MFA-TR*                 )                                                       
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7500                                                   
MFA-TR*       END-EXEC.                                                         
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01 I-PRTY-SVC-CAT-CD      PIC X(2).                              
COB305 01 I-CODE-CURTAIL-PRTY        PIC S9(2)V9(1) USAGE COMP-3 
COB305       VALUE 0.           
       PROCEDURE DIVISION USING I-PRTY-SVC-CAT-CD                       
A02395                         ,I-CODE-CURTAIL-PRTY.                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ***  0100A-DECLARE-GTT                                        **          
      ***  DECLARE TEMPORARY TABLE                                  **          
      *****************************************************************         
      *                                                                         
       0100A-DECLARE-GTT.                                               
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR03500_R1'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03500_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03500_R1
              (                                                    
                     RETURN_CODE           INT                      
                    ,ACCOUNT_NO            DECIMAL(13,0)                
                    ,IC_NO                 SMALLINT                     
                    ,FULL_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2        
                    ,PRTY_SVC_CAT_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                    ,CONTRACT_MDQ          DECIMAL(9,2)                
                    ,VOL_BLOCK CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
C34624              ,ZONE_CITY CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03500_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT *                                                
                FROM #CSR03500_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT *                                                        
MFA-TR*         FROM SESSION.CSR03500_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      ***  0100B-DECLARE-GTT                                        **          
      ***  DECLARE TEMPORARY TABLE                                  **          
      *****************************************************************         
      *                                                                         
       0100B-DECLARE-GTT.                                               
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR03500_R2'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03500_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03500_R2
              (                                                    
                     RETURN_CODE           INT                      
                    ,ACCOUNT_NO            DECIMAL(13,0)                
                    ,IC_NO                 SMALLINT                     
                    ,FULL_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2        
                    ,PRTY_SVC_CAT_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                    ,CONTRACT_MDQ          DECIMAL(9,2)                
                    ,VOL_BLOCK CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                    ,ZONE_CITY CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
                    ,CODE_CURTAIL_PRTY     DECIMAL(3,1)                 
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100B'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03500_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                DECLARE C2 CURSOR  FOR                       
                SELECT *                                                
                FROM #CSR03500_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C2 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT *                                                        
MFA-TR*         FROM SESSION.CSR03500_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
      ****************************************************************          
      ***  SET UP SQL ERROR PROCESSING                              **          
      ***  DECLARE ASSOCIATED CURSOR                                **          
      ****************************************************************          
      *                                                                         
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
                                                                        
P00801     IF I-PRTY-SVC-CAT-CD = 'XX'                                  
P00801        PERFORM 0100B-DECLARE-GTT         THRU 0100B-EXIT         
P00801     ELSE                                                         
P00801        PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT         
P00801     END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
P00801     IF I-PRTY-SVC-CAT-CD = 'XX'                                  
P00801        PERFORM 2201-BUILD-RESULT   THRU 2201-EXIT                
P00801     ELSE                                                         
P00801        PERFORM 2200-BUILD-RESULT   THRU 2200-EXIT                
P00801     END-IF.                                                      
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
      *                                                                         
P00801     MOVE I-PRTY-SVC-CAT-CD         TO WS-PRTY-SVC-CAT-CD.        
A02395     MOVE I-CODE-CURTAIL-PRTY       TO UT-CODE-CURTAIL-PRTY.      
P00801     IF WS-PRTY-SVC-CAT-CD > SPACES                               
A02395        MOVE UT-CODE-CURTAIL-PRTY      TO WS-CODE-CURTAIL-PRTY-RED
A02395        MOVE WS-CODE-CURTAIL-PRTY-RED  TO                         
A02395                                       WS-CODE-CURTAIL-PRTY-TEXT  
A02395        MOVE WS-CODE-CURTAIL-PRTY-TEXT TO WS-CODE-CURTAIL-PRTY-Z  
A02395        PERFORM 7000-OPEN-ACCT-CUR     THRU 7000-EXIT             
A02395        PERFORM 7100-FETCH-ACCT-CUR    THRU 7100-EXIT             
A02395        PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
A02395           MOVE AT-ACCOUNT-NO            TO UB-ACCOUNT-NO         
A02395                                            MN-ACCOUNT-NO         
A02395           MOVE 'Y'                      TO WS-NAME-ONLY-SW       
A02395           PERFORM 2250-SELECT-VOL-BLOCK THRU 2250-EXIT           
A02395           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT          
A02395           MOVE UT-COMPANY-NO            TO FD-COMPANY-NO         
A02395           MOVE UT-IC-NO                 TO MN-IC-NO              
A02395           MOVE SPACES                   TO FD-INDUST-BTU-DESC    
A02395           PERFORM 7450-SELECT-ZONE-CITY THRU 7450-EXIT           
A02395           PERFORM 2300-MOVE-VALUES      THRU 2300-EXIT           
A02395           PERFORM 7100-FETCH-ACCT-CUR   THRU 7100-EXIT           
A02395        END-PERFORM                                               
A02395        PERFORM 7200-CLOSE-ACCT-CUR      THRU 7200-EXIT           
A02395     END-IF.                                                      
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE NOT-FOUND TO S-RETURN-CODE                           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
P00801******************************************************************        
P00801* 2201-BUILD-RESULT                                              *        
P00801*     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
P00801******************************************************************        
                                                                        
P00801 2201-BUILD-RESULT.                                               
      *                                                                         
P00801     MOVE I-PRTY-SVC-CAT-CD         TO WS-PRTY-SVC-CAT-CD.        
P00801*    MOVE I-CODE-CURTAIL-PRTY       TO UT-CODE-CURTAIL-PRTY.              
P00801     PERFORM 7500-OPEN-ACCT-CUR     THRU 7500-EXIT                
P00801     PERFORM 7510-FETCH-ACCT-CUR    THRU 7510-EXIT                
P00801     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00801        MOVE AT-ACCOUNT-NO          TO UB-ACCOUNT-NO              
P00801                                        MN-ACCOUNT-NO             
P00801        MOVE 'Y'                    TO WS-NAME-ONLY-SW            
P00801        MOVE UT-CODE-CURTAIL-PRTY  TO WS-CODE-CURTAIL-PRTY-RED    
P00801        MOVE WS-CODE-CURTAIL-PRTY-RED  TO                         
P00801                                       WS-CODE-CURTAIL-PRTY-TEXT  
P00801        MOVE WS-CODE-CURTAIL-PRTY-TEXT TO                         
P00801                                       WS-CODE-CURTAIL-PRTY-Z     
P00801        PERFORM 2250-SELECT-VOL-BLOCK  THRU 2250-EXIT             
P00801        PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT             
P00801        MOVE UT-COMPANY-NO          TO FD-COMPANY-NO              
P00801        MOVE UT-IC-NO               TO MN-IC-NO                   
P00801        MOVE SPACES                 TO FD-INDUST-BTU-DESC         
P00801        PERFORM 7450-SELECT-ZONE-CITY  THRU 7450-EXIT             
P00801        PERFORM 2300-MOVE-VALUES       THRU 2300-EXIT             
P00801        PERFORM 7510-FETCH-ACCT-CUR    THRU 7510-EXIT             
P00801     END-PERFORM.                                                 
P00801     PERFORM 7520-CLOSE-ACCT-CUR      THRU 7520-EXIT.             
                                                                        
P00801     IF CTR-ROWS = 0                                              
P00801        INITIALIZE GTT-RETURN-FIELDS                              
P00801        MOVE NOT-FOUND TO S-RETURN-CODE                           
P00801        PERFORM 8200-SEND-RESULT      THRU 8200-EXIT              
P00801     END-IF.                                                      
                                                                        
P00801 2201-EXIT.                                                       
P00801      EXIT.                                                       
      ****************************************************************          
      **   2250-SELECT-VOL-BLOCK                                    **          
      ****************************************************************          
       2250-SELECT-VOL-BLOCK.                                           
            MOVE AT-ACCOUNT-NO        TO BK-ACCOUNT-NO                  
                                         UB-ACCOUNT-NO                  
            MOVE UT-IC-NO             TO BK-IC-NO                       
                                         UB-IC-NO                       
A02395      PERFORM 7250-SELECT-REVENUE-MONTH THRU 7250-EXIT.           
            MOVE WS-R-YEAR            TO WS-CONTRCT-YEAR                
            MOVE WS-R-MONTH           TO WS-CONTRCT-MONTH               
            MOVE '01'                 TO WS-CONTRCT-DAY                 
            MOVE WS-CNT-START-DATE    TO WS-CONTRCT-START-DATE          
A02395      PERFORM 7300-SELECT-CONTRACT-DATE THRU 7300-EXIT.           
                                                                        
A02395      MOVE 0                    TO BK-CONTRACT-DEMAND             
A02395      MOVE 'N'                  TO WS-VOL-BLOCK-IND               
A02395*                                                                         
A02395     MOVE WS-CONTRCT-START-DATE TO BK-CNTRCT-START-DT             
A02395     MOVE WS-CONTRCT-END-DATE   TO BK-CNTRCT-END-DT               
A02395     PERFORM 7350-GET-CSS-BILL-CONTRACT    THRU 7350-EXIT         
A02395*                                                                         
A02395     IF WS-ACTIVE-RETURN-CODE EQUAL ZERO                          
A02395        MOVE BK-CNTRCT-START-DT TO UB-CNTRCT-START-DT             
A02395        PERFORM 7400-GET-CSS-VOL-BLOCK-DATA     THRU 7400-EXIT    
A02395     END-IF.                                                      
A02395*                                                                         
       2250-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      ** 2300-MOVE-VALUES                                                       
      ***************************************************************           
       2300-MOVE-VALUES.                                                
                                                                        
           MOVE AT-ACCOUNT-NO          TO S-ACCOUNT-NO.                 
           MOVE UT-IC-NO               TO S-IC-NO.                      
           MOVE WS-CUSTOMER-NAME       TO S-FULL-NAME.                  
           MOVE WS-PRTY-SVC-CAT-CD     TO S-PRTY-SVC-CAT-CD.            
           MOVE BK-CONTRACT-DEMAND     TO S-CONTRACT-DEMAND.            
A00077     MOVE FD-INDUST-BTU-DESC     TO S-ZONE-CITY.                  
A02395     MOVE WS-VOL-BLOCK-IND       TO S-VOL-BLOCK.                  
P00801     IF WS-PRTY-SVC-CAT-CD = 'XX'                                 
              MOVE UT-CODE-CURTAIL-PRTY TO S-CODE-CURTAIL-PRTY          
P00801        PERFORM 8200-SEND-RESULT  THRU 8200-EXIT                  
P00801     ELSE                                                         
P00801        PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
P00801     END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
A02395*    7000-OPEN-ACCT-CUR.                                       **         
      *****************************************************************         
A02395 7000-OPEN-ACCT-CUR.                                              
                                                                        
           EXEC SQL                                                     
                OPEN ACCOUNT_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                NEXT SENTENCE                                           
           ELSE                                                         
A02395          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
A02395          MOVE '7000'                    TO ACTIVE-PARAGRAPH      
A02395          MOVE 'OPEN  '                  TO ABEND-FUNCTION        
A02395          MOVE 'CSS_ACCOUNT '            TO TABLE-1               
A02395          MOVE 'ACCOUNT CURSOR    '      TO TABLE-ELEMENT-1       
A02395          MOVE 'ACCOUNT CURSOR    '      TO TABLE-ELEMENT-1       
A02395          MOVE 'CODE CURTAIL PRTY '      TO TABLE-ELEMENT-2       
A02395          MOVE SPACES                    TO HOSTVAR-ELEMENT-1     
A02395          MOVE WS-CODE-CURTAIL-PRTY-Z    TO HOSTVAR-ELEMENT-2     
A02395          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
A02395          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      **********************************************************************    
      **     7100-FETCH-ACCT-CUR.                                     **  **    
      **********************************************************************    
       7100-FETCH-ACCT-CUR.                                             
                                                                        
             EXEC SQL                                                   
                FETCH ACCOUNT_CURSOR                                    
                 INTO :AT-ACCOUNT-NO                                    
                    , :UT-IC-NO                                         
C34624              , :UT-PREMISE-NO                                    
                    , :UT-COMPANY-NO                                    
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                NEXT SENTENCE                                           
           ELSE                                                         
A02395          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
A02395          MOVE '7100'                    TO ACTIVE-PARAGRAPH      
A02395          MOVE 'FETCH '                  TO ABEND-FUNCTION        
A02395          MOVE 'CSS_ACCOUNT '            TO TABLE-1               
A02395          MOVE 'ACCOUNT CURSOR    '      TO TABLE-ELEMENT-1       
A02395          MOVE 'CODE CURTAIL PRTY '      TO TABLE-ELEMENT-2       
A02395          MOVE SPACES                    TO HOSTVAR-ELEMENT-1     
A02395          MOVE WS-CODE-CURTAIL-PRTY-Z    TO HOSTVAR-ELEMENT-2     
A02395          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
A02395          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
        7100-EXIT.                                                      
             EXIT.                                                      
      *****************************************************************         
A02395***7200-CLOSE-ACCT-CUR.                                        **         
      *****************************************************************         
A02395  7200-CLOSE-ACCT-CUR.                                            
                                                                        
           EXEC SQL                                                     
                CLOSE ACCOUNT_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                NEXT SENTENCE                                           
           ELSE                                                         
A02395          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
A02395          MOVE '7200'                    TO ACTIVE-PARAGRAPH      
A02395          MOVE 'CLOSE '                  TO ABEND-FUNCTION        
A02395          MOVE 'CSS_ACCOUNT '            TO TABLE-1               
A02395          MOVE 'ACCOUNT CURSOR    '      TO TABLE-ELEMENT-1       
A02395          MOVE 'CODE CURTAIL PRTY '      TO TABLE-ELEMENT-2       
A02395          MOVE SPACES                    TO HOSTVAR-ELEMENT-1     
A02395          MOVE WS-CODE-CURTAIL-PRTY-Z    TO HOSTVAR-ELEMENT-2     
A02395          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
A02395          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
        7200-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      *****************************************************************         
P00801*    7500-OPEN-ACCT-CUR.                                       **         
      *****************************************************************         
P00801 7500-OPEN-ACCT-CUR.                                              
                                                                        
P00801     EXEC SQL                                                     
P00801          OPEN ACCOUNT_CSR                                        
P00801     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00801     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
P00801     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00801          NEXT SENTENCE                                           
P00801     ELSE                                                         
P00801          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
P00801          MOVE '7500'                    TO ACTIVE-PARAGRAPH      
P00801          MOVE 'OPEN  '                  TO ABEND-FUNCTION        
P00801          MOVE 'CSS_ACCOUNT '            TO TABLE-1               
P00801          MOVE 'ACCOUNT CURSOR    '      TO TABLE-ELEMENT-1       
P00801          MOVE 'ACCOUNT CURSOR    '      TO TABLE-ELEMENT-1       
P00801          MOVE 'CODE CURTAIL PRTY '      TO TABLE-ELEMENT-2       
P00801          MOVE SPACES                    TO HOSTVAR-ELEMENT-1     
P00801          MOVE WS-CODE-CURTAIL-PRTY-Z    TO HOSTVAR-ELEMENT-2     
P00801          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
P00801          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
P00801 7500-EXIT.                                                       
P00801     EXIT.                                                        
P00801**********************************************************************    
P00801**     7510-FETCH-ACCT-CUR.                                     **  **    
P00801**********************************************************************    
P00801 7510-FETCH-ACCT-CUR.                                             
                                                                        
P00801       EXEC SQL                                                   
P00801          FETCH ACCOUNT_CSR                                       
P00801           INTO :AT-ACCOUNT-NO                                    
P00801              , :UT-IC-NO                                         
P00801              , :UT-PREMISE-NO                                    
P00801              , :UT-COMPANY-NO                                    
P00801              , :UT-CODE-CURTAIL-PRTY                             
P00801       END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00801     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
P00801     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00801          NEXT SENTENCE                                           
P00801     ELSE                                                         
P00801          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
P00801          MOVE '7510'                    TO ACTIVE-PARAGRAPH      
P00801          MOVE 'FETCH '                  TO ABEND-FUNCTION        
P00801          MOVE 'CSS_ACCOUNT '            TO TABLE-1               
P00801          MOVE 'ACCOUNT CURSOR    '      TO TABLE-ELEMENT-1       
P00801          MOVE 'CODE CURTAIL PRTY '      TO TABLE-ELEMENT-2       
P00801          MOVE SPACES                    TO HOSTVAR-ELEMENT-1     
P00801          MOVE WS-CODE-CURTAIL-PRTY-Z    TO HOSTVAR-ELEMENT-2     
P00801          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
P00801          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
P00801  7510-EXIT.                                                      
P00801       EXIT.                                                      
      *****************************************************************         
P00801***7520-CLOSE-ACCT-CUR.                                        **         
      *****************************************************************         
P00801  7520-CLOSE-ACCT-CUR.                                            
                                                                        
P00801     EXEC SQL                                                     
P00801          CLOSE ACCOUNT_CSR                                       
P00801     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00801     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
P00801     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00801          NEXT SENTENCE                                           
P00801     ELSE                                                         
P00801          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
P00801          MOVE '7520'                    TO ACTIVE-PARAGRAPH      
P00801          MOVE 'CLOSE '                  TO ABEND-FUNCTION        
P00801          MOVE 'CSS_ACCOUNT '            TO TABLE-1               
P00801          MOVE 'ACCOUNT CURSOR    '      TO TABLE-ELEMENT-1       
P00801          MOVE 'CODE CURTAIL PRTY '      TO TABLE-ELEMENT-2       
P00801          MOVE SPACES                    TO HOSTVAR-ELEMENT-1     
P00801          MOVE WS-CODE-CURTAIL-PRTY-Z    TO HOSTVAR-ELEMENT-2     
P00801          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
P00801          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
P00801     END-IF.                                                      
                                                                        
P00801  7520-EXIT.                                                      
P00801       EXIT.                                                      
      *                                                                         
      ******************************************************************        
A02395**7250-SELECT-REVENUE-MONTH                                     **        
      ******************************************************************        
A02395 7250-SELECT-REVENUE-MONTH.                                       
                                                                        
              EXEC SQL                                                  
                SELECT CIS.SUBSTR3(PARM_DATA,19,2)                           
                     , CIS.SUBSTR3(PARM_DATA,15,4)                           
                  INTO :WS-R-MONTH                                      
                     , :WS-R-YEAR                                       
                  FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                       
                 WHERE PROGRAM_NAME = 'COMMON'                          
                   AND PARM_DATA LIKE 'REVENUE-MONTH%'                  
T35434                                                           
A02395                                                      
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*       EXEC SQL                                                          
MFA-TR*         SELECT SUBSTR(PARM_DATA,19,2)                                   
MFA-TR*              , SUBSTR(PARM_DATA,15,4)                                   
MFA-TR*           INTO :WS-R-MONTH                                              
MFA-TR*              , :WS-R-YEAR                                               
MFA-TR*           FROM CSS_JOB_PARM                                             
MFA-TR*          WHERE PROGRAM_NAME = 'COMMON'                                  
MFA-TR*            AND PARM_DATA LIKE 'REVENUE-MONTH%'                          
MFA-TR*           WITH UR                                                       
MFA-TR*          QUERYNO 7250                                                   
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02395     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                 NEXT SENTENCE                                          
           ELSE                                                         
                MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
A02395          MOVE '7250'                 TO ACTIVE-PARAGRAPH         
                MOVE 'REVENUE MONTH'        TO ABEND-FUNCTION           
                MOVE 'CSS_JOB_PARM  '       TO TABLE-ELEMENT-1          
                MOVE SPACES                 TO HOSTVAR-ELEMENT-1        
A02395          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
A02395          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-IF.                                                      
A02395 7250-EXIT.                                                       
              EXIT.                                                     
     ******************************************************************         
A02395*    7300-SELECT-CONTRACT-DATE                                      **    
     ***********************************************************************    
A02395 7300-SELECT-CONTRACT-DATE.                                       
                                                                        
           EXEC SQL                                                     
T35434          SELECT
              DATEADD( DAY, -1, (DATEADD( MONTH, 1, 
              IIF(TRY_CONVERT(DATE, :WS-CONTRCT-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CONTRCT-START-DATE
              ) <> 0) OR (LEN(:WS-CONTRCT-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CONTRCT-START-DATE
              ), CONVERT(DATE, :WS-CONTRCT-START-DATE) ) )) )
            INTO
              :WS-CONTRCT-END-DATE         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CONTRCT-END-DATE = (DATE(:WS-CONTRCT-START-DATE)        
MFA-TR*                                    + 1 MONTHS) - 1 DAYS                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                 NEXT SENTENCE                                          
           ELSE                                                         
                MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
A02395          MOVE '7300'                 TO ACTIVE-PARAGRAPH         
T35434          MOVE 'SET'                  TO ABEND-FUNCTION           
A02395          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
A02395          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
A02395 7300-EXIT.                                                       
            EXIT.                                                       
A02395******************************************************************        
A02395* 7350-GET-CSS-BILL-CONTRACT                                     *        
A02395******************************************************************        
A02395  7350-GET-CSS-BILL-CONTRACT.                                     
A02395*                                                                         
A02395     EXEC SQL                                                     
A02395         SELECT TOP(1) BK.CONTRACT_DEMAND,
              BK.CNTRCT_START_DT                                
A02395           INTO :BK-CONTRACT-DEMAND                               
A02395               ,:BK-CNTRCT-START-DT                               
A02395           FROM CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                
A02395          WHERE BK.ACCOUNT_NO       = :BK-ACCOUNT-NO              
A02395            AND BK.IC_NO            = :BK-IC-NO                   
A02395            AND BK.CODE_UTIL_TYPE   = 'G'                         
A02395            AND BK.CNTRCT_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                    :BK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :BK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:BK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:BK-CNTRCT-START-DT
              ), CONVERT(DATE, :BK-CNTRCT-START-DT) )        
A02395            AND BK.CNTRCT_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                      :BK-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :BK-CNTRCT-END-DT
              ) <> 0) OR (LEN(:BK-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :BK-CNTRCT-END-DT
              ), CONVERT(DATE, :BK-CNTRCT-END-DT) )          
A02395          ORDER BY BK.CNTRCT_START_DT DESC                        
A02395                                       
A02395                                                      
A02395     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BK.CONTRACT_DEMAND                                        
MFA-TR*              ,BK.CNTRCT_START_DT                                        
MFA-TR*          INTO :BK-CONTRACT-DEMAND                                       
MFA-TR*              ,:BK-CNTRCT-START-DT                                       
MFA-TR*          FROM CSS_BILL_CONTRACT BK                                      
MFA-TR*         WHERE BK.ACCOUNT_NO       = :BK-ACCOUNT-NO                      
MFA-TR*           AND BK.IC_NO            = :BK-IC-NO                           
MFA-TR*           AND BK.CODE_UTIL_TYPE   = 'G'                                 
MFA-TR*           AND BK.CNTRCT_START_DT  <= :BK-CNTRCT-START-DT                
MFA-TR*           AND BK.CNTRCT_END_DT    >= :BK-CNTRCT-END-DT                  
MFA-TR*         ORDER BY BK.CNTRCT_START_DT DESC                                
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02395*                                                                         
A02395     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02395*                                                                         
A02395     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
A02395          NEXT SENTENCE                                           
A02395     ELSE                                                         
A02395          MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
A02395          MOVE '7350'                TO ACTIVE-PARAGRAPH          
A02395          MOVE 'SELECT'              TO ABEND-FUNCTION            
A02395          MOVE 'CSS_BILL_CONTRACT'   TO TABLE-1                   
A02395          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1           
A02395          MOVE 'IC_NO'               TO TABLE-ELEMENT-2           
A02395          MOVE 'CNTRCT_START_DT'     TO TABLE-ELEMENT-3           
A02395          MOVE 'CNTRCT_END_DT'       TO TABLE-ELEMENT-4           
A02395          MOVE BK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
A02395          MOVE BK-IC-NO              TO HOSTVAR-ELEMENT-2         
A02395          MOVE BK-CNTRCT-START-DT    TO HOSTVAR-ELEMENT-3         
A02395          MOVE BK-CNTRCT-END-DT      TO HOSTVAR-ELEMENT-4         
A02395          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
A02395          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
A02395     END-IF.                                                      
A02395*                                                                         
A02395  7350-EXIT.                                                      
A02395       EXIT.                                                      
C34624*                                                                   **    
C34624**********************************************************************    
A02395** 7400-GET-CSS-VOL-BLOCK-DATA .                                 * **     
A02395*********************************************************************     
A02395  7400-GET-CSS-VOL-BLOCK-DATA.                                    
A02395*                                                                         
A02395      EXEC SQL                                                    
A02395          SELECT 'Y'                                              
A02395            INTO :WS-VOL-BLOCK-IND                                
A02395            FROM CSS_VOL_BLOCK UB WITH(READUNCOMMITTED)                   
A02395           WHERE UB.ACCOUNT_NO      = :UB-ACCOUNT-NO              
A02395             AND UB.IC_NO           = :UB-IC-NO                   
A02395             AND UB.CODE_UTIL_TYPE  = 'G'                         
A02395             AND UB.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :UB-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UB-CNTRCT-START-DT
              ) <> 0) OR (LEN(:UB-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:UB-CNTRCT-START-DT
              ), CONVERT(DATE, :UB-CNTRCT-START-DT) )         
A02395                                                           
A02395                                                      
A02395      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-VOL-BLOCK-IND                                        
MFA-TR*           FROM CSS_VOL_BLOCK UB                                         
MFA-TR*          WHERE UB.ACCOUNT_NO      = :UB-ACCOUNT-NO                      
MFA-TR*            AND UB.IC_NO           = :UB-IC-NO                           
MFA-TR*            AND UB.CODE_UTIL_TYPE  = 'G'                                 
MFA-TR*            AND UB.CNTRCT_START_DT = :UB-CNTRCT-START-DT                 
MFA-TR*           WITH UR                                                       
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02395*                                                                         
A02395     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02395*                                                                         
A02395     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02395        NEXT SENTENCE                                             
A02395     ELSE                                                         
A02395          MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
A02395          MOVE '7400'                 TO ACTIVE-PARAGRAPH         
A02395          MOVE 'SELECT'               TO ABEND-FUNCTION           
A02395          MOVE 'CSS_VOL_BLOCK '       TO TABLE-1                  
A02395          MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1          
A02395          MOVE 'IC_NO'                TO TABLE-ELEMENT-2          
A02395          MOVE 'CNTRCT_START_DT'      TO TABLE-ELEMENT-3          
A02395          MOVE UB-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
A02395          MOVE UB-IC-NO               TO HOSTVAR-ELEMENT-2        
A02395          MOVE UB-CNTRCT-START-DT     TO HOSTVAR-ELEMENT-3        
A02395          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
A02395          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
A02395     END-IF.                                                      
A02395*                                                                         
A02395  7400-EXIT.                                                      
A02395        EXIT.                                                     
      *                                                                         
C34624*****************************************************************         
C34624*    7450-SELECT-ZONE-CITY.                                         **    
C34624**********************************************************************    
C34624 7450-SELECT-ZONE-CITY.                                           
C34624                                                                  
A00077     EXEC SQL                                                     
A00077          SELECT TOP(1) FD.INDUST_BTU_DESC                               
A00077            INTO :FD-INDUST-BTU-DESC                              
A00077            FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
A00077                ,CSS_BTU_INDUST   FD WITH(READUNCOMMITTED)                
A00077           WHERE MN.INDUST_BTU_ID     = FD.INDUST_BTU_ID          
A00077             AND MN.ACCOUNT_NO        = :MN-ACCOUNT-NO            
A00077             AND MN.CODE_UTIL_TYPE    = 'G'                       
A00077             AND FD.COMPANY_NO        = :FD-COMPANY-NO            
A00077             AND MN.CODE_METER_STATUS <> 'K'                      
A00077                                       
A02395                                                      
A00077     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT FD.INDUST_BTU_DESC                                       
MFA-TR*           INTO :FD-INDUST-BTU-DESC                                      
MFA-TR*           FROM CSS_MTRD_ENVRNMT MN                                      
MFA-TR*               ,CSS_BTU_INDUST   FD                                      
MFA-TR*          WHERE MN.INDUST_BTU_ID     = FD.INDUST_BTU_ID                  
MFA-TR*            AND MN.ACCOUNT_NO        = :MN-ACCOUNT-NO                    
MFA-TR*            AND MN.CODE_UTIL_TYPE    = 'G'                               
MFA-TR*            AND FD.COMPANY_NO        = :FD-COMPANY-NO                    
MFA-TR*            AND MN.CODE_METER_STATUS <> 'K'                              
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*          QUERYNO 7450                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00077                                                                  
C34624     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
C34624     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C34624        CONTINUE                                                  
C34624     ELSE                                                         
C34624          MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
C34624          MOVE '7450'                 TO ACTIVE-PARAGRAPH         
C34624          MOVE 'SELECT'               TO ABEND-FUNCTION           
C34624          MOVE 'CSS_MTRD_ENVRNMT '    TO TABLE-1                  
C34624          MOVE 'ACCOUNT_NO    '       TO TABLE-ELEMENT-1          
C34624          MOVE MN-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
A02395          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
A02395          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
C34624     END-IF.                                                      
C34624                                                                  
C34624 7450-EXIT.                                                       
C34624      EXIT.                                                       
      *                                                                         
      *************************************************************             
      ** 8000A-DELETE-GTT-ROWS                                    *             
      *************************************************************             
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR03500_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03500_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR03500_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
                                                                        
      *************************************************************             
      ** 8000B-DELETE-GTT-ROWS                                    *             
      *************************************************************             
       8000B-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR03500_R2                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03500_R2                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000B'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR03500_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *    EXEC SQL                                                             
      *       INCLUDE CPD00300                                                  
      *    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPD00074                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPD00004                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR03500_R1'                               
                                         TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
                                                                        
               INSERT INTO #CSR03500_R1                          
                   (                                                    
                     RETURN_CODE                                        
                    ,ACCOUNT_NO                                         
                    ,IC_NO                                              
                    ,FULL_NAME                                          
                    ,PRTY_SVC_CAT_CD                                    
                    ,CONTRACT_MDQ                                       
                    ,VOL_BLOCK                                          
C34624              ,ZONE_CITY                                          
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE                                     
                    ,:S-ACCOUNT-NO                                      
                    ,:S-IC-NO                                           
                    ,:S-FULL-NAME                                       
                    ,:S-PRTY-SVC-CAT-CD                                 
                    ,:S-CONTRACT-DEMAND                                 
                    ,:S-VOL-BLOCK                                       
C34624              ,:S-ZONE-CITY                                       
                   )                                                    
                                                                        
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR03500_R1                                  
MFA-TR*            (                                                            
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,FULL_NAME                                                  
MFA-TR*             ,PRTY_SVC_CAT_CD                                            
MFA-TR*             ,CONTRACT_MDQ                                               
MFA-TR*             ,VOL_BLOCK                                                  
MFA-TR*             ,ZONE_CITY                                                  
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-ACCOUNT-NO                                              
MFA-TR*             ,:S-IC-NO                                                   
MFA-TR*             ,:S-FULL-NAME                                               
MFA-TR*             ,:S-PRTY-SVC-CAT-CD                                         
MFA-TR*             ,:S-CONTRACT-DEMAND                                         
MFA-TR*             ,:S-VOL-BLOCK                                               
MFA-TR*             ,:S-ZONE-CITY                                               
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR03500_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-SEND-RESULT                                               *        
      ******************************************************************        
       8200-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR03500_R2'                               
                                         TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
                                                                        
               INSERT INTO #CSR03500_R2                          
                   (                                                    
                     RETURN_CODE                                        
                    ,ACCOUNT_NO                                         
                    ,IC_NO                                              
                    ,FULL_NAME                                          
                    ,PRTY_SVC_CAT_CD                                    
                    ,CONTRACT_MDQ                                       
                    ,VOL_BLOCK                                          
                    ,ZONE_CITY                                          
                    ,CODE_CURTAIL_PRTY                                  
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE                                     
                    ,:S-ACCOUNT-NO                                      
                    ,:S-IC-NO                                           
                    ,:S-FULL-NAME                                       
                    ,:S-PRTY-SVC-CAT-CD                                 
                    ,:S-CONTRACT-DEMAND                                 
                    ,:S-VOL-BLOCK                                       
                    ,:S-ZONE-CITY                                       
                    ,:S-CODE-CURTAIL-PRTY                               
                   )                                                    
                                                                        
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR03500_R2                                  
MFA-TR*            (                                                            
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,FULL_NAME                                                  
MFA-TR*             ,PRTY_SVC_CAT_CD                                            
MFA-TR*             ,CONTRACT_MDQ                                               
MFA-TR*             ,VOL_BLOCK                                                  
MFA-TR*             ,ZONE_CITY                                                  
MFA-TR*             ,CODE_CURTAIL_PRTY                                          
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-ACCOUNT-NO                                              
MFA-TR*             ,:S-IC-NO                                                   
MFA-TR*             ,:S-FULL-NAME                                               
MFA-TR*             ,:S-PRTY-SVC-CAT-CD                                         
MFA-TR*             ,:S-CONTRACT-DEMAND                                         
MFA-TR*             ,:S-VOL-BLOCK                                               
MFA-TR*             ,:S-ZONE-CITY                                               
MFA-TR*             ,:S-CODE-CURTAIL-PRTY                                       
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR03500_R2'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *                                                                         
           IF WS-PRTY-SVC-CAT-CD = 'XX'                                 
              EXEC SQL                                                  
                   OPEN C2                                              
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           ELSE                                                         
              EXEC SQL                                                  
                   OPEN C1                                              
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
P00801     IF WS-PRTY-SVC-CAT-CD = 'XX'                                 
P00801        PERFORM 8200-SEND-RESULT   THRU 8200-EXIT                 
P00801     ELSE                                                         
P00801        PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
P00801     END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *9999-END-PROGRAM                                                         
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
