       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03495.                                         
COB303 DATE-WRITTEN.  OCT 05, 2004.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE UPDATES ROWS IN CSS_CRED_ITPA_HIST AND ALSO    *        
      *  WRITES MNT TRANS HIST.                                        *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
C29586*  10/05/04  SS82048    PROCEDURE ORIGINALLY CODED.              *        
C29586*  12/13/04  DP19151  1. ADDED CODE TO UPDATE RESOLVED DATE TO   *        
C29586*                        THE CURRENT DATE WHEN THE RESULT CODE   *        
C29586*                        IS UPDATED TO RESOLVED, UNVERIFIED AND  *        
C29586*                        ID-VERIFIRED.                           *        
C29586*                     2. MAINTAINENCE HISTORY IS ALSO UPDATED.   *        
C29586*  01/24/05  DP19151     ADD CODE FOR RESULT CODE UPDATE.        *        
T35434*  07/30/07  MR97640    REPLACED MODEL_SQL WITH SET STATEMENT    *        
T35434*                       AND ADDED WITH UR TO AVOID -911 ABENDS   *        
C36013*  01/16/08  CVNS     1)CALL MATRIX PROGRAM TO RECALCULATE THE   *        
C36013*            CHENNAI    FINAL DECISION NOT USING THE ITPA SCORE  *        
C36013*                       IN THE CALCULATION (CSR04071)            *        
C36013*                     2)UPDATE THE FINAL DECISION FIELDS INTO THE*        
C36013*                       CSS_CREDIT_HIST TABLE                    *        
C36013*                     3)MAINTENANCE TRANSACTION HISTORY ROWS FOR *        
C36013*                       ALL UPDATES TO THE FIELDS                *        
C36013*                     4)GENERATE WQ ONLY FOR CSR IF APP STATUS IS*        
C36013*                       CHANGED(CAT:453-APPLICATION OVERRIDE)    *        
A01723*  11/16/09  MJ13662  WHEN ITPA STATUS IS UPDATED TO RESOLVED,   *        
A01723*                     IF CK-CR-ACION-FL IS EQUAL TO 'B' (BILL)   *        
A01723*                     SET THE ADVERSE CREDIT LETTER TO 'Y' SO THAT        
A01723*                     THE LETTER WILL BE SENT.                            
P00342*  04/06/10  MJ13662  WHEN ITPA STATUS IS UPDATED TO RESOLVED,   *        
P00342*                     IF CR-BUREAU-CD = 'E', & OTHER RULES APPLY,*        
P00342*                     UPDATE CK-ADV-CREDIT-LTR TO 'Y'.           *        
P00453*  01/11/11  MJ13662  IF SEB AND DEREGULATED AND SPECIAL-OFFER-CD*        
P00453*                     ON CSS_CREDIT_HIST = 'P' (PAY AND GO) AND  *        
P00453*                     WHEN APPLICATION STATUS CHANGES TO CONTINUE*        
P00453*                     SET CK-ADV-CREDIT-LTR TO 'Y'.              *        
P00453*                     IF SEB AND DEREGULATED AND SPECIAL-OFFER-CD*        
P00453*                     = 'P' IF APPLICATION STATUS CHANGE TO      *        
P00453*                     SOMETHING OTHER THAN CONTINUE, AND ADV-LTR *        
P00453*                     WASN'T CHANGED ON THE PANEL OR FOR ITPA    *        
P00453*                     PROCESSING SET CK-ADV-CREDIT-LTR TO 'N'.   *        
P00551*  11/16/11  RC41079  FOR SERVICE CARE CREDIT SCORING ADDED      *        
P00551*                     CHECK WHEN CR-CHK-COMPANY-NO  = '30' MOVE  *        
P00551*                     '01' TO C8-COMPANY-NO WHEN GETTING DATABASE*        
P00551*                      IN PARA 2000-PROCESS-INPUT.               *        
P00599*  09/26/12  AA97148  CHANGES MADE TO CREDIT SCORING PROCESS TO  *TO  *   
P00599*                     GENERATE ADVERSE LETTER OF CREDIT(ALOC) AND* AND*   
P00599*                     IDENTITY THEFT PREVENTION ALERT (ITPA)     *    *   
P00599*                     LETTERS USING THE NEW LETTER GENERATION    *    *   
P00599*                     PROCESS.                                   *    *   
P00599*  01/28/13  GOKUL    SKIP NOT-FOUND CHECK DURING DB2 UPDATE IN  *    *   
P00599*                     CORRESP_HDR FOR CREDIT CHECKS BEFORE 01/27.*    *   
P0599A*  02/25/13  AA97148  USE CORRESP ID WHILE UPDATE/DELETE ON      *        
P0599A*                     CORRESP TABLES.                            *        
P00704*  07/21/13  RAJ      CREDIT SCORING MODERNIZATION.              *        
I01701*  07/15/14  MJ13662  INCLUDE SPECIAL-OFFER-CD PARM FOR CSR04071 *        
A05198*  11/13/15  MJ13662  INCLUDE ADDL-CRED-SCORE AND ADDL-SCORE-IND *        
A05198*                     IN PARM TO CSR04071.                       *        
A05198*                     GET SCORE-MODEL-CD FROM CSR04071 AND       *        
A05198*                     UPDATE TABLE.                              *        
A05460*  04/13/16  MJ13662  CHANGED PROGRAM-NAME DEFINITION SO THAT    *        
A05460*                     RQST-REASON-CD COULD BE PLACED IN LAST     *        
A05460*                     POSITION AND USED WHEN PROCESSING ALOC AND *        
A05460*                     ITPA LETTERS.  ACT115                      *        
ACT233*  08/09/16  TP7R341  REPLACED CSR00028 WITH CSR04675 AND        *        
ACT233*                     REMOVE UNWANTED COPYBOOK                   *        
ACT304*  10/13/16  MJ13662  WHEN ALOC STATUS IS CHANGED TO 'NOT NEEDED'*        
ACT304*                     DELETE ROW FROM CSS_CORRESP_HDR IF STATUS =*        
ACT304*                     'I' OR 'X'. APPL5460                       *        
ACT304*                     ALSO FOR ITPA.                             *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03495'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_CRED_ITPA_HIST (LF)                                **            
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBCRITPA                                                    
           END-EXEC.                                                            
                                                                        
P00599**************************************************************    *****014
P00599*    CSS_CORRESP_HDR    - 1J                                **         014
P00599**************************************************************    *****014
P00599                                                                  
P00599     EXEC SQL                                                          017
P00599        INCLUDE TBCORHDR                                               017
P00599     END-EXEC.                                                         017
P00599                                                                  
P00599**************************************************************    *****014
P00599*    CSS_CORRESP_VAR    - 1K                                **         014
P00599**************************************************************    *****014
P00599                                                                  
P00599     EXEC SQL                                                          017
P00599        INCLUDE TBCORVAR                                               017
P00599     END-EXEC.                                                         017
P00599                                                                  
P00599**************************************************************    *****014
P00599*    CSS_CRED_HIST_ADDR - LJ                                **         014
P00599**************************************************************    *****014
P00599                                                                  
P00599     EXEC SQL                                                          017
P00599        INCLUDE TBCRADDR                                               017
P00599     END-EXEC.                                                         017
P00599                                                                  
      **************************************************************            
      *    CSS_ACCOUNT (AT)                                       **            
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      **   CSS_MNT_TRANS_HIST (MH)                                **            
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      **   CSS_MT_TRN_HST_DET (MI)                                **            
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      **   CSS_USER_PROFILE (PF)                                  **            
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      **   CSS_CREDIT_HIST (CK)                                   **            
      **************************************************************            
           EXEC SQL                                                             
               INCLUDE TBCRHIST                                                 
           END-EXEC.                                                            
                                                                        
C36013**************************************************************            
C36013**   CSS_WQ_ITEMS (WQ)                                      **            
C36013**************************************************************            
C36013     EXEC SQL                                                             
C36013      INCLUDE TBWQITS                                                     
C36013     END-EXEC.                                                            
                                                                        
C36013**************************************************************            
C36013**   CSS_DELINQUENCY (C8)                                   **            
C36013**************************************************************            
C36013     EXEC SQL                                                             
C36013      INCLUDE TBDELQ                                                      
C36013     END-EXEC.                                                            
                                                                        
      **************************************************************            
      **   CSS_CREDIT_PROFILE (CZ)                                **            
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBCRPROF                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      **   CSS_CRED_BUR_MATRX (DG)                                **            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCRBUMX                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
      *****************************************************************         
      *    WS FOR 6010-REDUCE-EMBEDDED SPACES                         *         
      *****************************************************************         
      *                                                                         
      *    COPY CWS00011.                                                       
P00704     COPY CWS0011A.                                                       
      *                                                                         
P00599********************************************************************** 015
P00599* WORKING STORAGE FOR CPDKR125                                   *   *    
P00599********************************************************************** 015
P00599                                                                  
P00599     EXEC SQL                                                             
P00599        INCLUDE CWS00341                                                  
P00599     END-EXEC.                                                            
P00599                                                                  
P00599******************************************************************        
P00599* VARIABLES NEEDED FOR NOTICE PROCESSING                         *        
P00599******************************************************************        
P00599                                                                  
P00599     EXEC SQL                                                             
P00599        INCLUDE CWS00350                                                  
P00599     END-EXEC.                                                            
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
ACT115     05  PROGRAM-NAME.                                            
ACT115         10  PROGRAM-NAME-7           PIC X(07) VALUE 'CSR0349'.  
ACT115         10  PROGRAM-NAME-RQST-REASON PIC X(01) VALUE SPACES.     
           05  WS-SQLSTATE               PIC X(5) VALUE SPACES.         
           05  ALL-DONE-SW               PIC X(1) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW              PIC X(1) VALUE 'Y'.            
               88  SEND-DONE-ERROR       VALUE 'N'.                     
               88  SEND-DONE-OK          VALUE 'Y'.                     
           05  WS-ROW-COUNT              PIC S9(09) COMP.               
           05  WS-TRAN-APPL-NO           PIC S9(04) COMP VALUE 0.       
           05  WS-MAX-LEN                PIC S9(4) COMP.                
C36013     05  WS-VARCHAR                PIC X(255).                    
C36013     05  FILLER REDEFINES WS-VARCHAR.                             
C36013         10 WS-VARCHAR-POS         PIC X(01) OCCURS 255.          
C36013     05  WS-VARCHAR-LEN            PIC S9(4) COMP.                
COB305     05 WS-CUSTOMER-NO        PIC S9(10) USAGE COMP-3 VALUE 0.       
           05  WS-APPL-PROG              PIC X(09)  VALUE SPACE.        
           05  WS-CR-HIST-TRAN-DT.                                      
               10  WS-CR-HIST-TRAN-CCYY  PIC X(04) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '-'.           
               10  WS-CR-HIST-TRAN-MM    PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '-'.           
               10  WS-CR-HIST-TRAN-DD    PIC X(02) VALUE SPACES.        
C36013*                                                                         
C36013     05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
C36013*                                                                         
C36013     05  WS-ITPA-CHG-IND           PIC X(01) VALUE 'N'.           
C36013*                                                                         
           05  WS-NULL-IND1              PIC S9(4) COMP VALUE 0.        
           05  WS-NULL-IND2              PIC S9(4) COMP VALUE 0.        
C29586     05  WS-NULL-IND3              PIC S9(4) COMP VALUE 0.        
P00599     05  MCSKR125                  PIC X(08) VALUE 'MCSKR125'.    
P00599     05  RS-RETURN-CODE            PIC S9(9) COMP VALUE 0.        
P00599     05  WS-CPD351-COMP-NO         PIC X(02) VALUE SPACES.        
P00599     05  WS-ADDR-TYPE-CD           PIC X(01) VALUE SPACES.        
P0599A     05  WS-ROW-FOUND              PIC X(01) VALUE SPACES.        
P00599     05  WS-PREV-LTR-NOTIFY-CD     PIC X(01) VALUE SPACES.        
P00599     05  WS-CR-HIST-TRAN-TM        PIC X(08) VALUE SPACES.        
P00599     05  RS-KR125-RETURN-CODE      PIC S9(04) COMP VALUE 0.       
           05  WS-LETTER-NOTIFY-CD       PIC X(01) VALUE SPACES.        
           05  WS-PREV-ADV-CRED-LTR      PIC X(01) VALUE SPACES.        
C36013     05  WS-PREV-DEPSOIT-ACTION    PIC X(01) VALUE SPACES.        
           05  WS-LETTER-MAILED-DT       PIC X(10) VALUE SPACES.        
C29586     05  WS-RESOLUTION-DT          PIC X(10) VALUE SPACES.        
C36013     05  WS-ITPA-RSLT-CURR-CD      PIC X(01) VALUE SPACES.        
C36013     05  WS-CURRENT-TIMESTAMP      PIC X(26) VALUE SPACES.        
C36013     05  WS-PREV-APPL-STATUS-CD    PIC X(01).                     
           05  WS-ITPA-RSLT-UPDT         PIC X(01) VALUE 'N'.           
               88  ITPA-RSLT-UPDT        VALUE 'Y'.                     
C36013     05  WS-APPL-STAT-UPDT         PIC X(01) VALUE 'N'.           
C36013         88  APPL-STAT-UPDT        VALUE 'Y'.                     
C36013     05  WS-CR-FL-UPDT             PIC X(01) VALUE 'N'.           
C36013         88  CR-FL-UPDT            VALUE 'Y'.                     
C36013     05  WS-ADV-LTR-UPDT           PIC X(01) VALUE 'N'.           
C36013         88  ADV-LTR-UPDT          VALUE 'Y'.                     
           05  WS-LETTR-NOTIFY-UPDT      PIC X(01) VALUE 'N'.           
               88  LETTR-NOTIFY-UPDT     VALUE 'Y'.                     
           05  WS-LETTR-MAILED-DT-UPDT   PIC X(01) VALUE 'N'.           
               88  LETTR-MAILED-DT-UPDT  VALUE 'Y'.                     
C36013     05  WS-DATABASE               PIC 9(01)  VALUE ZERO.         
C36013         88  CSR-DATABASE                     VALUE 1.            
C36013         88  SEB-DATABASE                     VALUE 2.            
A05198     05  WS-ADDL-SCORE-IND-NUM      PIC 9(01) VALUE 0.            
A05198     05  WS-ADDL-SCORE-IND-ALPHA REDEFINES WS-ADDL-SCORE-IND-NUM. 
A05198         10  WS-ADDL-SCORE-IND      PIC X(01).                    
A05198             88  PROCESS-ADDL-SCORE           VALUE '1'.          
A05198             88  DO-NOT-PROCESS-ADDL-SCORE    VALUE '2'.          
C36013     05  WS-CR-COMMENTS            PIC X(210) VALUE SPACES.       
P0599A     05  WS-CORRESP-ID-FL          PIC X(01)  VALUE 'N'.          
P0599A         88  CORR-ID-FOUND                    VALUE 'Y'.          
P0599A         88  CORR-ID-NOT-FOUND                VALUE 'N'.          
I01701     05  WS-SPECIAL-OFFER-CD       PIC X(01)  VALUE SPACE.        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9) COMP VALUE 1.        
           05  CTR-ROWS                  PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
      *                                                                         
C36013 01  WS-WQ-APPL-STAT-COMMENTS.                                    
C36013     05  FILLER                    PIC X(24)                      
C36013           VALUE 'APP STATUS UPDATED FROM '.                      
C36013     05  WS-PREV-APPL-STAT-DESC    PIC X(09).                     
C36013     05  FILLER                    PIC X(03)                      
C36013           VALUE 'TO '.                                           
C36013     05  WS-APPL-STAT-DESC         PIC X(09).                     
      *                                                                         
ACT233 01  WS-CSR04675-OUTPUT.                                          
ACT233     05  WS-CSR04675-RET-CODE        PIC S9(09) COMP VALUE 0.     
                                                                        
C36013 01 WS-WORKQ-VARS.                                                
C36013     05 WS-WQ-ITEM-ID                PIC S9(10)V COMP-3 VALUE +0. 
C36013     05 WS-WQ-ROUTE-CATEGORY         PIC X(01).                   
C36013     05 WS-WQ-LOCAL-OFFICE           PIC X(03).                   
C36013     05 WS-WQ-USER-ID-ASGN           PIC X(07).                   
C36013     05 WS-WQ-USER-ID-ORIG           PIC X(07).                   
C36013     05 WS-WQ-RESP-AREA-ID           PIC X(03).                   
C36013     05 WS-WQ-CATEGORY-ID            PIC S9(04) USAGE COMP.       
COB305     05 WS-WQ-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-WQ-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-WQ-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-WQ-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
C36013     05 WS-WQ-COMMENTS.                                           
C36013        49 WS-WQ-COMMENTS-LEN        PIC S9(04) USAGE COMP.       
C36013        49 WS-WQ-COMMENTS-TEXT       PIC X(250).                  
C36013     05 WS-WQ-DATE-REQUIRED          PIC X(26).                   
C36013     05 WS-WQ-DATE-CREATED           PIC X(26).                   
C36013     05 WS-WQ-PRIORITY               PIC X(01).                   
C36013     05 WS-WQ-FREE-FORM-AREA.                                     
C36013        49 WS-WQ-FREEFORM-LEN        PIC S9(04) USAGE COMP.       
C36013        49 WS-WQ-FREEFORM-TEXT       PIC X(255).                  
C36013     05 WS-WQ-CREATED-BY             PIC X(16).                   
C36013*                                                                         
C36013 01  WS-CSR04071-OUTPUT.                                          
C36013     05  WS-4071-RETURN-CODE      PIC S9(09) COMP VALUE 0.        
C36013     05  WS-4071-APPL-STATUS-CD   PIC X(01)  VALUE SPACES.        
C36013     05  WS-4071-CR-SCORE-TYPE-CD PIC X(02)  VALUE SPACES.        
C36013     05  WS-4071-CR-SCORE-CD      PIC X(05)  VALUE SPACES.        
C36013     05  WS-4071-CR-ACTION-FL     PIC X(01)  VALUE SPACES.        
C36013     05  WS-4071-APPL-RESULT-CD   PIC X(01)  VALUE SPACES.        
C36013     05  WS-4071-APPL-RESPONSE-CD PIC X(02)  VALUE SPACES.        
C36013     05  WS-4071-CR-COMMENTS      PIC X(210) VALUE SPACES.        
A05198     05  WS-4071-SCORE-MODEL-CD   PIC X(01)  VALUE SPACES.        
C36013*                                                                         
C36013**************************************************************            
C36013**   MATRIX PRORAM PARM VARIABLES                           **            
C36013**************************************************************            
C36013 01  WS-PARM-INPUT.                                               
C36013     05  PARM-PROGRAM-ID          PIC  X(08) VALUE 'CSR03495'.    
C36013     05  PARM-HDR-RETURN-CODE     PIC  X(04) VALUE SPACES.        
C36013     05  PARM-ITPA-EXISTS-CD      PIC  X(01) VALUE SPACES.        
C36013     05  PARM-COMPANY-NO          PIC  X(02) VALUE SPACES.        
C36013     05  PARM-HIT-CD              PIC  X(01) VALUE SPACES.        
C36013     05  PARM-SAFESCAN-CD         PIC  X(01) VALUE SPACES.        
C36013     05  PARM-MATCH-CD            PIC  X(01) VALUE SPACES.        
C36013     05  PARM-BEACON-REJ-CD       PIC  X(04) VALUE SPACES.        
C36013     05  PARM-FORMAT-ERR          PIC  X(03) VALUE SPACES.        
C36013     05  PARM-VALID-ERR           PIC  X(03) VALUE SPACES.        
C36013     05  PARM-PROCESS-ERR         PIC  X(03) VALUE SPACES.        
C36013     05  PARM-RQST-REASON-CD      PIC  X(01) VALUE SPACES.        
C36013     05  PARM-SENIOR-FL           PIC  X(01) VALUE SPACES.        
C36013     05  PARM-REG-GROUP-CD        PIC  X(03) VALUE SPACES.        
C36013     05  PARM-BEACON-SCORE        PIC  X(05) VALUE SPACES.        
C36013     05  PARM-CUSTOMER-NO         PIC  X(10) VALUE SPACES.        
C36013     05  PARM-USER-ID             PIC  X(07) VALUE SPACES.        
A05198     05  PARM-ADDL-CRED-SCORE     PIC  X(05) VALUE SPACES.        
A05198     05  PARM-ADDL-SCORE-IND      PIC  X(01) VALUE SPACES.        
C36013                                                                  
C36013***************************************************************           
C36013*    DB2 COMMUNICATION REQUIREMENT *                                      
C36013***************************************************************           
C36013*01  LOC-RESLTSET          USAGE IS SQL TYPE IS                   
C36013*                          RESULT-SET-LOCATOR VARYING.            
C36013 01  ERROR-MESSAGE.                                               
C36013     02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
C36013     02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
C36013                           INDEXED BY ERROR-INDEX.                
C36013 77   ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.            
C36013 77  TRACE-MESSAGE-AREA    PIC X(256).                            
C36013 77  OPENFN                PIC X(12).                             
C36013 77  SSID                  PIC X(4).                              
C36013 77  PLANNAME              PIC X(8).                              
C36013 77  RETCODE               PIC S9(5).                             
C36013 77  REASCODE              PIC S9(5).                             
C36013 77  CLOSFN                PIC X(12).                             
C36013 77  TERMOP                PIC X(4).
MSQ001        EXEC SQL
MSQ001          DECLARE CSR04071_RS_CSR CURSOR
MSQ001          FOR CALL CSR04071 ( :PARM-PROGRAM-ID
                  , :PARM-HDR-RETURN-CODE
                  , :PARM-ITPA-EXISTS-CD
                  , :PARM-COMPANY-NO
                  , :PARM-HIT-CD
                  , :PARM-SAFESCAN-CD
                  , :PARM-MATCH-CD
                  , :PARM-BEACON-REJ-CD
                  , :PARM-FORMAT-ERR
                  , :PARM-VALID-ERR
                  , :PARM-PROCESS-ERR
                  , :PARM-RQST-REASON-CD
                  , :PARM-SENIOR-FL
                  , :PARM-REG-GROUP-CD
                  , :PARM-BEACON-SCORE
                  , :PARM-CUSTOMER-NO
                  , :PARM-USER-ID
                  , :WS-SPECIAL-OFFER-CD
                  , :PARM-ADDL-CRED-SCORE
                  , :PARM-ADDL-SCORE-IND
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CSR04675_RS_CSR CURSOR
MSQ001          FOR CALL CSR04675 ( :WS-WQ-ITEM-ID
                  , :WS-WQ-ROUTE-CATEGORY
                  , :WS-WQ-LOCAL-OFFICE
                  , :WS-WQ-USER-ID-ORIG
                  , :WS-WQ-USER-ID-ASGN
                  , :WS-WQ-RESP-AREA-ID
                  , :WS-WQ-CATEGORY-ID
                  , :WS-WQ-ACCOUNT-NO
                  , :WS-WQ-PREMISE-NO
                  , :WS-WQ-CUSTOMER-NO
                  , :WS-WQ-SERV-ORDER-NO
                  , :WS-WQ-COMMENTS
                  , :WS-WQ-DATE-REQUIRED
                  , :WS-WQ-DATE-CREATED
                  , :WS-WQ-PRIORITY
                  , :WS-WQ-FREE-FORM-AREA
                  , :WS-WQ-CREATED-BY
                  )
MSQ001        END-EXEC.
                              
C36013                                                                  
       LINKAGE SECTION.                                                 
      *                                                                         
       01  I-CUSTOMER-NO                PIC X(10).                      
       01  I-CR-HIST-TRAN-DT            PIC X(10).                      
       01  I-CR-HIST-TRAN-TM            PIC X(08).                      
       01  I-ITPA-RSLT-CUR-CD           PIC X(01).                      
       01  I-LETTR-NOTIFY-CD            PIC X(01).                      
       01  I-USER-ID                    PIC X(07).                      
       01  I-COMMENTS-LEN               PIC S9(04) COMP SYNC.           
       01  I-COMMENTS-TEXT              PIC X(254).                     
C36013 01  I-CR-ACTION-FL               PIC X(01).                      
C36013 01  I-APPL-STATUS-CD             PIC X(01).                      
C36013 01  I-ADV-CREDIT-LTR             PIC X(01).                      
      *                                                                         
HPCCDM*EJECT                                                                    
       PROCEDURE DIVISION USING  I-CUSTOMER-NO                          
                               , I-CR-HIST-TRAN-DT                      
                               , I-CR-HIST-TRAN-TM                      
                               , I-ITPA-RSLT-CUR-CD                     
                               , I-LETTR-NOTIFY-CD                      
                               , I-USER-ID                              
                               , I-COMMENTS-LEN                         
                               , I-COMMENTS-TEXT                        
C36013                         , I-CR-ACTION-FL                         
C36013                         , I-APPL-STATUS-CD                       
C36013                         , I-ADV-CREDIT-LTR.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                      THRU 0100-EXIT. 
           PERFORM 1000-PROCESS-INPUT                   THRU 1000-EXIT. 
           PERFORM 2000-PROCESS-OUTPUT                  THRU 2000-EXIT. 
           PERFORM 9999-END-PROGRAM                     THRU 9999-EXIT. 
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                  :S-RETURN-CODE    AS RETURN_CODE                      
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE    AS RETURN_CODE                              
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE I-CUSTOMER-NO             TO WS-CUSTOMER-NO.            
           MOVE I-CR-HIST-TRAN-DT(1:2)    TO WS-CR-HIST-TRAN-MM         
           MOVE I-CR-HIST-TRAN-DT(4:2)    TO WS-CR-HIST-TRAN-DD         
           MOVE I-CR-HIST-TRAN-DT(7:4)    TO WS-CR-HIST-TRAN-CCYY.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           5000-UPDATE                                          *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
C36013     MOVE SPACES                        TO LF-ITPA-RSLT-CURR-CD   
C36013                                           LF-LETTER-NOTIFY-CD    
C36013                                           LF-LETTER-MAILED-DT    
C36013                                           LF-RESOLUTION-DT       
P00599                                           WS-PREV-LTR-NOTIFY-CD  
           MOVE WS-CUSTOMER-NO                TO LF-CUSTOMER-NO         
                                                 CK-CUSTOMER-NO         
P00599                                           LJ-CUSTOMER-NO.        
           MOVE WS-CR-HIST-TRAN-DT            TO LF-CR-HIST-TRAN-DT     
                                                 CK-CR-HIST-TRAN-DT     
P00599                                           LJ-CR-HIST-TRAN-DT     
P00599                                           WS-COMMON-DATE         
           MOVE I-CR-HIST-TRAN-TM             TO LF-CR-HIST-TRAN-TM     
                                                 CK-CR-HIST-TRAN-TM     
P00599                                           LJ-CR-HIST-TRAN-TM     
P00599                                           WS-CR-HIST-TRAN-TM.    
      *                                                                         
           PERFORM 7200-SELECT-CREDIT-HIST    THRU 7200-EXIT            
P00599     MOVE CK-SENIOR-FL                  TO PARM-SENIOR-FL         
P00599     MOVE CK-REG-GROUP-CD               TO PARM-REG-GROUP-CD      
P00599     MOVE SPACES                        TO WS-CWS350-LOCAL-OFFICE 
      *                                                                         
           MOVE CK-ADV-CREDIT-LTR             TO WS-PREV-ADV-CRED-LTR   
C36013     IF  CK-ADV-CREDIT-LTR NOT = I-ADV-CREDIT-LTR                 
C36013         SET  ADV-LTR-UPDT              TO TRUE                   
C36013         MOVE I-ADV-CREDIT-LTR          TO CK-ADV-CREDIT-LTR      
C36013     END-IF                                                       
C36013*                                                                         
C36013     MOVE CK-CR-ACTION-FL               TO WS-PREV-DEPSOIT-ACTION 
C36013     IF CK-CR-ACTION-FL    NOT  = I-CR-ACTION-FL                  
C36013         SET CR-FL-UPDT                 TO TRUE                   
C36013     END-IF                                                       
C36013*                                                                         
C36013     MOVE CK-APPL-STATUS-CD             TO WS-PREV-APPL-STATUS-CD 
C36013     IF CK-APPL-STATUS-CD  NOT  = I-APPL-STATUS-CD                
C36013         SET APPL-STAT-UPDT             TO TRUE                   
C36013     END-IF                                                       
C36013*                                                                         
C36013     IF WS-PREV-APPL-STATUS-CD = 'O'                              
C36013        MOVE  'ON HOLD'                 TO  WS-PREV-APPL-STAT-DESC
C36013     ELSE                                                         
C36013         IF  WS-PREV-APPL-STATUS-CD = 'D'                         
C36013             MOVE  'DENY'               TO  WS-PREV-APPL-STAT-DESC
C36013         ELSE                                                     
C36013            IF WS-PREV-APPL-STATUS-CD = 'C'                       
C36013               MOVE  'CONTINUE'         TO  WS-PREV-APPL-STAT-DESC
C36013            END-IF                                                
C36013         END-IF                                                   
C36013     END-IF                                                       
C36013     IF I-APPL-STATUS-CD = 'O'                                    
C36013        MOVE  'ON HOLD'                 TO  WS-APPL-STAT-DESC     
C36013     ELSE                                                         
C36013         IF  I-APPL-STATUS-CD = 'D'                               
C36013             MOVE  'DENY'               TO  WS-APPL-STAT-DESC     
C36013         ELSE                                                     
C36013            IF I-APPL-STATUS-CD = 'C'                             
C36013               MOVE  'CONTINUE'         TO  WS-APPL-STAT-DESC     
C36013            END-IF                                                
C36013         END-IF                                                   
C36013     END-IF                                                       
C36013*                                                                         
P00551     IF  (CK-CR-CHK-COMPANY-NO  = SPACES OR LOW-VALUES OR '30')   
C36013         MOVE  '01'                     TO C8-COMPANY-NO          
C36013     ELSE                                                         
C36013         MOVE CK-CR-CHK-COMPANY-NO      TO C8-COMPANY-NO          
C36013     END-IF                                                       
C36013     MOVE ZERO                          TO WS-DATABASE            
C36013     MOVE 'DATABASE'                    TO C8-DELINQ-CD           
C36013     PERFORM 7025-GET-DATABASE                 THRU 7025-EXIT     
C36013     MOVE C8-DELINQ-VALUE               TO WS-DATABASE            
P00599                                           WS-CWS350-DATABASE.    
P00599     MOVE CK-CR-CHK-COMPANY-NO          TO WS-CPD351-COMP-NO      
P00599                                           WS-PROCESS-COMPANY-NO. 
ACT115     MOVE CK-CR-RQST-REASON-CD        TO PROGRAM-NAME-RQST-REASON.
           PERFORM 7100-SELECT-CRED-ITPA-HIST        THRU 7100-EXIT     
      *                                                                         
           MOVE LF-LETTER-NOTIFY-CD           TO WS-LETTER-NOTIFY-CD    
P00599                                           WS-PREV-LTR-NOTIFY-CD. 
           MOVE LF-LETTER-MAILED-DT           TO WS-LETTER-MAILED-DT    
C29586     MOVE LF-RESOLUTION-DT              TO WS-RESOLUTION-DT       
C36013     MOVE LF-ITPA-RSLT-CURR-CD          TO WS-ITPA-RSLT-CURR-CD   
      *                                                                         
           PERFORM 5000-UPDATE                       THRU 5000-EXIT     
      *                                                                         
           ADD  1                             TO CTR-ROWS.              
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C36013*****************************************************************         
C36013* 2500-CREATE-WQ.                                               *         
C36013* CREATE WQ                                                     *         
C36013*****************************************************************         
C36013 2500-CREATE-WQ.                                                  
C36013*                                                                         
C36013     INITIALIZE DCLCSS-WQ-ITEMS                                   
ACT233                WS-CSR04675-OUTPUT.                               
C36013     MOVE  MH-TRANS-HIST-SEQ-NO       TO WS-CURRENT-TIMESTAMP     
C36013     MOVE  '453'                      TO WS-WQ-CATEGORY-ID        
C36013     MOVE  MH-RESP-AREA-ID            TO WS-WQ-RESP-AREA-ID       
C36013     MOVE  WS-WQ-APPL-STAT-COMMENTS   TO WS-WQ-COMMENTS-TEXT      
C36013     MOVE  LENGTH OF WS-WQ-APPL-STAT-COMMENTS                     
C36013                                      TO WS-WQ-COMMENTS-LEN       
C36013     MOVE SPACES                      TO WS-WQ-LOCAL-OFFICE       
C36013     MOVE I-USER-ID                   TO WS-WQ-USER-ID-ORIG       
C36013     MOVE SPACES                      TO WS-WQ-USER-ID-ASGN       
C36013     MOVE ZERO                        TO WS-WQ-ACCOUNT-NO         
C36013     MOVE ZERO                        TO WS-WQ-PREMISE-NO         
C36013     MOVE WS-CUSTOMER-NO              TO WS-WQ-CUSTOMER-NO        
C36013     MOVE ZERO                        TO WS-WQ-SERV-ORDER-NO      
C36013     MOVE WS-CURRENT-TIMESTAMP        TO WS-WQ-DATE-REQUIRED      
C36013     MOVE WS-CURRENT-TIMESTAMP        TO WS-WQ-DATE-CREATED       
C36013     MOVE 'N'                         TO WS-WQ-PRIORITY           
C36013     MOVE SPACES                      TO WS-WQ-FREEFORM-TEXT      
C36013     MOVE ZERO                        TO WS-WQ-FREEFORM-LEN       
C36013     MOVE '5'                         TO WS-WQ-ROUTE-CATEGORY     
ACT233     MOVE 'CSR03495'                  TO WS-WQ-CREATED-BY         
C36013*                                                                         
C36013     PERFORM 8200-INSERT-WQ           THRU 8200-EXIT.             
C36013*                                                                         
C36013 2500-EXIT.                                                       
C36013     EXIT.                                                        
      *                                                                         
P0599A******************************************************************        
P0599A* 2550-CORRESP-ID-PROCESS                                        *        
P0599A******************************************************************        
P0599A                                                                  
P0599A 2550-CORRESP-ID-PROCESS.                                         
P0599A                                                                  
P0599A     PERFORM 7350-GET-CORRESP-ID                  THRU 7350-EXIT. 
P0599A     IF WS-ROW-FOUND = 'Y'                                        
P0599A        PERFORM 8300-UPDATE-CORRESP-HDR           THRU 8300-EXIT  
P0599A        PERFORM 8400-DELETE-CORRESP-HDR           THRU 8400-EXIT  
P0599A     SET CORR-ID-FOUND TO TRUE                                    
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A 2550-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A                                                                  
      ******************************************************************        
      * 5000-UPDATE                                                    *        
      *     CALLS 5100-JRNL-TRAN-HEAD                                  *        
      *     CALLS 5200-PROCESS-ROW                                     *        
      *     CALLS 8000-UPDATE-BHV-ACCT-SCORE                           *        
      *     CALLS 8010-UPDATE-CREDIT-PROFILE                           *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE 'PANEL053'                TO WS-APPL-PROG               
                                                                        
           PERFORM 5100-JRNL-TRAN-HEAD                  THRU 5100-EXIT. 
           PERFORM 5200-PROCESS-ROW                     THRU 5200-EXIT. 
      *                                                                         
           IF  ITPA-RSLT-UPDT OR LETTR-NOTIFY-UPDT OR                   
               LETTR-MAILED-DT-UPDT                                     
               MOVE I-USER-ID             TO LF-LAST-UPDATE-USERID      
               MOVE MH-TRANS-HIST-SEQ-NO  TO LF-LAST-UPDATE-TS          
               PERFORM 8000-UPDATE-CRED-ITPA-HIST       THRU 8000-EXIT  
P00599         IF LF-LETTER-NOTIFY-CD NOT = WS-PREV-LTR-NOTIFY-CD       
P00599            MOVE WS-CUSTOMER-NO     TO 1J-CUSTOMER-NO             
P00599            MOVE WS-CPD351-COMP-NO  TO 1J-CORRESP-COMPANY-NO      
P00599            MOVE WS-CR-HIST-TRAN-DT TO 1J-CORRESP-STMT-DT         
P00599            MOVE 'IT'               TO 1J-CORRESP-TYPE-CD         
P00599            IF ((WS-PREV-LTR-NOTIFY-CD  = 'A' OR 'U') AND         
P00599               (LF-LETTER-NOTIFY-CD NOT = WS-PREV-LTR-NOTIFY-CD)) 
P0599A               MOVE 'Y'             TO WS-ROW-FOUND               
P0599A               SET CORR-ID-NOT-FOUND   TO TRUE                    
P0599A               PERFORM 2550-CORRESP-ID-PROCESS    THRU 2550-EXIT  
P0599A                 UNTIL WS-ROW-FOUND = 'N'                         
P0599A               IF CORR-ID-NOT-FOUND                               
P0599A                  PERFORM 7400-GET-CORR-ID        THRU 7400-EXIT  
P0599A                  IF SQLCODE = 0                                  
P0599A                    PERFORM 8300-UPDATE-CORRESP-HDR THRU 8300-EXIT
P0599A                    PERFORM 8400-DELETE-CORRESP-HDR THRU 8400-EXIT
P0599A                  END-IF                                          
P0599A               END-IF                                             
P00599            END-IF                                                
P00599            IF LF-LETTER-NOTIFY-CD  = 'A' OR 'U'                  
P00599               PERFORM 5000-CORRESP-DATA-INSERT-DTLS              
P00599                                           THRU 5000-CPD351-EXIT  
P00599            END-IF                                                
P00599         END-IF                                                   
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
P00599***********************************************************************332
P00599* 5000-CORRESP-DATA-INSERT-DTLS                                  *    *332
P00599***********************************************************************332
P00599                                                                  
P00599     EXEC SQL                                                          015
P00599        INCLUDE CPD00351                                               015
P00599     END-EXEC.                                                         015
P00599                                                                  
      ******************************************************************        
      *   5100-JRNL-TRAN-HEAD.                                         *        
      *   1.   MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *        
      *        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *        
      *        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *        
      ******************************************************************        
       5100-JRNL-TRAN-HEAD.                                             
                                                                        
           PERFORM 7000-SELECT-TIMESTAMP                THRU 7000-EXIT. 
           PERFORM 7050-SELECT-RESP-AREA                THRU 7050-EXIT. 
           MOVE 1                        TO WS-TRAN-APPL-NO             
                                            MI-TRAN-APPL-NO.            
           MOVE SPACES                   TO MI-TABLE-ID.                
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE ZERO                     TO MH-ACCOUNT-NO.              
           MOVE WS-CUSTOMER-NO           TO MH-CUSTOMER-NO.             
           MOVE ZERO                     TO MH-PREMISE-NO.              
           MOVE I-USER-ID                TO MH-USER-ID.                 
           MOVE WS-APPL-PROG             TO MH-APPL-PROGRAM-ID.         
           MOVE I-COMMENTS-TEXT          TO MH-TRAN-COMMENT-TEXT.       
           MOVE I-COMMENTS-LEN           TO MH-TRAN-COMMENT-LEN.        
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      *   5200-PROCESS-ROW.                                            *        
      *                                                                *        
      *       UPDATE BASED ON THE CHANGED VALUES                       *        
      ******************************************************************        
      *                                                                         
       5200-PROCESS-ROW.                                                
      *                                                                         
           IF  I-ITPA-RSLT-CUR-CD NOT = LF-ITPA-RSLT-CURR-CD            
               SET ITPA-RSLT-UPDT        TO TRUE                        
               PERFORM 5210-JRNL-RSLT-CD THRU 5210-EXIT                 
               MOVE I-ITPA-RSLT-CUR-CD   TO LF-ITPA-RSLT-CURR-CD        
P00704     END-IF                                                       
P00704*                                                                         
P00704     IF CK-CR-COMMENTS-TEXT NOT EQUAL TO  I-COMMENTS-TEXT         
P00704         PERFORM 5215-JRNL-COMMENT THRU 5215-EXIT                 
P00704     END-IF                                                       
      *                                                                         
           IF ITPA-RSLT-UPDT                                            
              EVALUATE I-ITPA-RSLT-CUR-CD                               
               WHEN 'S'                                                 
                   MOVE 'A'              TO WS-LETTER-NOTIFY-CD         
                                            CK-ADV-CREDIT-LTR           
                   MOVE SPACES           TO WS-LETTER-MAILED-DT         
               WHEN 'N'                                                 
                   MOVE 'A'              TO WS-LETTER-NOTIFY-CD         
                                            CK-ADV-CREDIT-LTR           
                   MOVE SPACES           TO WS-LETTER-MAILED-DT         
               WHEN 'U'                                                 
                   MOVE 'U'              TO WS-LETTER-NOTIFY-CD         
                   MOVE SPACES           TO WS-LETTER-MAILED-DT         
                   MOVE 'H'              TO CK-ADV-CREDIT-LTR           
               WHEN 'V'                                                 
                   MOVE 'U'              TO WS-LETTER-NOTIFY-CD         
                   MOVE SPACES           TO WS-LETTER-MAILED-DT         
                   MOVE 'H'              TO CK-ADV-CREDIT-LTR           
               WHEN 'R'                                                 
      *****************************************************************         
      * ITPA RESULT IS CHANGED TO RESOLVED , PERFORM MATRIX PROGRAM   *         
      *****************************************************************         
A05198             MOVE CK-CR-CHK-COMPANY-NO    TO C8-COMPANY-NO        
A05198             IF CK-REG-GROUP-CD          = '   '                  
A05198                MOVE 'ADDL-SCORE-IND'     TO C8-DELINQ-CD         
A05198             ELSE                                                 
A05198                MOVE 'ADDL-SCORE-IND-REG' TO C8-DELINQ-CD         
A05198             END-IF                                               
A05198             PERFORM 7025-GET-DATABASE    THRU 7025-EXIT          
A05198             MOVE C8-DELINQ-VALUE         TO WS-ADDL-SCORE-IND-NUM
                   PERFORM 5260-CALL-MATRIX-SP  THRU  5260-EXIT         
      *                                                                         
                   IF ( CK-CR-RQST-REASON-CD NOT EQUAL 'V' ) AND        
P00342                ( CK-CR-BUREAU-CD = 'E') AND                      
A01723                ( CK-CR-ACTION-FL EQUAL 'C' OR 'R' OR 'B')        
                      MOVE 'Y'           TO CK-ADV-CREDIT-LTR           
                   ELSE                                                 
                      MOVE 'N'           TO CK-ADV-CREDIT-LTR           
                   END-IF                                               
      *                                                                         
                   IF  WS-LETTER-NOTIFY-CD = 'A' OR 'U'                 
                       MOVE 'N'          TO WS-LETTER-NOTIFY-CD         
                       MOVE SPACES       TO WS-LETTER-MAILED-DT         
                   END-IF                                               
              END-EVALUATE                                              
      *                                                                         
      *****************************************************************         
      * FROM ITPA STATUS 'RESOLVED' TO ANY OTHER ITPA STATUS          *         
      *****************************************************************         
              IF WS-ITPA-RSLT-CURR-CD = 'R'                             
                 MOVE I-APPL-STATUS-CD   TO CK-APPL-STATUS-CD           
                 MOVE 'I'                TO CK-CR-SCORE-TYPE-CD         
                 MOVE SPACES             TO CK-CR-SCORE-CD              
                 MOVE I-CR-ACTION-FL     TO CK-CR-ACTION-FL             
                 MOVE 'Y'                TO WS-ITPA-CHG-IND             
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           IF I-APPL-STATUS-CD = 'D'                                    
              MOVE 'R'                   TO CK-CR-ACTION-FL             
                                            I-CR-ACTION-FL              
           END-IF                                                       
      *                                                                         
      *****************************************************************         
      * IF DEPOSIT ACTION OR APPLICATION STATUS IS CHANGED ON PANEL053*         
      * SELECT "DEFAULT" ROW FROM CSS_CRED_BUR_MATRX BASED ON ACTION  *         
      * FLAG AND APPLICATION STATUS CODE.                             *         
      *****************************************************************         
           IF WS-ITPA-CHG-IND = 'N'                                     
               IF APPL-STAT-UPDT OR CR-FL-UPDT                          
                  MOVE CK-CR-CHK-COMPANY-NO TO DG-COMPANY-NO            
                  MOVE CK-CR-RQST-REASON-CD TO DG-CR-RQST-REASON-CD     
                  MOVE CK-REG-GROUP-CD      TO DG-REG-GROUP-CD          
                  MOVE CK-SENIOR-FL         TO DG-SENIOR-FL             
                  MOVE I-APPL-STATUS-CD     TO DG-APPL-STATUS-CD        
                                               CK-APPL-STATUS-CD        
                  MOVE I-CR-ACTION-FL       TO DG-CREDIT-ACTION-FL      
                                               CK-CR-ACTION-FL          
      *                                                                         
                  MOVE MH-DATE-TRANS        TO WS-CURRENT-DATE          
                  PERFORM 7300-CRED-BUR-MATRX           THRU 7300-EXIT  
      *                                                                         
                  MOVE DG-CR-SCORE-TYPE-CD  TO CK-CR-SCORE-TYPE-CD      
                  MOVE DG-CR-SCORE-CD       TO CK-CR-SCORE-CD           
               END-IF                                                   
           END-IF                                                       
      *                                                                         
           IF ( CK-APPL-STATUS-CD NOT = WS-PREV-APPL-STATUS-CD )        
              PERFORM 5252-JRNL-APPL-STATUS-CD   THRU 5252-EXIT         
              IF CSR-DATABASE AND WS-ITPA-CHG-IND = 'N'                 
                 PERFORM 2500-CREATE-WQ          THRU 2500-EXIT         
              END-IF                                                    
P00453        IF (SEB-DATABASE AND CK-REG-GROUP-CD = SPACES             
P00453            AND CK-SPECIAL-OFFER-CD = 'P')                        
P00453           IF  CK-APPL-STATUS-CD = 'C'                            
P00453               MOVE 'Y'                  TO CK-ADV-CREDIT-LTR     
P00453           ELSE                                                   
P00453               IF (WS-ADV-LTR-UPDT = 'N'                          
P00453                   AND CK-ADV-CREDIT-LTR  = WS-PREV-ADV-CRED-LTR) 
P00453                   MOVE 'N'              TO CK-ADV-CREDIT-LTR     
P00453               END-IF                                             
P00453           END-IF                                                 
P00453        END-IF                                                    
           END-IF                                                       
      *                                                                         
           IF ( CK-CR-ACTION-FL  NOT = WS-PREV-DEPSOIT-ACTION )         
              PERFORM 5254-JRNL-CR-ACTION-FL     THRU 5254-EXIT         
           END-IF                                                       
      *                                                                         
           IF ( CK-ADV-CREDIT-LTR NOT = WS-PREV-ADV-CRED-LTR )          
              PERFORM 5240-JRNL-ADV-LTR-CD       THRU 5240-EXIT         
           END-IF                                                       
      *                                                                         
      *****************************************************************         
      * UPDATE CSS_CREDIT_HIST TABLE FOR CHANGES                      *         
      *****************************************************************         
           IF ITPA-RSLT-UPDT OR APPL-STAT-UPDT OR                       
P00704        CR-FL-UPDT     OR ADV-LTR-UPDT   OR                       
P00704        CK-CR-COMMENTS-TEXT NOT EQUAL TO  I-COMMENTS-TEXT         
      *                                                                         
      *                                                                         
C36013        IF WS-4071-CR-COMMENTS = SPACES OR LOW-VALUES             
C36013           MOVE SPACES                 TO WS-4071-CR-COMMENTS     
C36013        END-IF                                                    
C36013*                                                                         
P00704******CK-CR-COMMENTS WILL BE PAINTED IN ADMIN PANEL. THE USER CAN         
P00704******DECICDE TO RETAIN OR OVERWRITE THE COMMENTS THERE.                  
P00704        IF I-COMMENTS-TEXT > SPACES                               
P00704           INITIALIZE    WS-EMB-INPUT                             
P00704                         WS-CMP-TABLE                             
P00704              MOVE I-COMMENTS-TEXT        TO WS-EMB-INPUT         
P00704              MOVE +210                   TO WS-EMB-LENG          
P00704              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT  
P00704              MOVE WS-CMP-TABLE           TO CK-CR-COMMENTS-TEXT  
P00704        END-IF                                                    
P00704*                                                                         
C36013        IF WS-4071-CR-COMMENTS > SPACES                           
C36013           INITIALIZE    WS-EMB-INPUT                             
C36013                         WS-CMP-TABLE                             
C36013           MOVE WS-4071-CR-COMMENTS    TO WS-EMB-INPUT            
C36013           MOVE +210                   TO WS-EMB-LENG             
C36013           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT     
C36013           MOVE WS-CMP-TABLE           TO WS-4071-CR-COMMENTS     
C36013*                                                                         
C36013           IF CK-CR-COMMENTS-TEXT = SPACES OR LOW-VALUES          
C36013              MOVE SPACES              TO CK-CR-COMMENTS-TEXT     
C36013           END-IF                                                 
C36013*                                                                         
C36013           IF CK-CR-COMMENTS-TEXT > SPACES                        
C36013              STRING  WS-4071-CR-COMMENTS DELIMITED BY '  '       
C36013                      ' '                 DELIMITED BY SIZE       
C36013                      CK-CR-COMMENTS-TEXT DELIMITED BY '  '       
C36013              INTO    WS-CR-COMMENTS                              
C36013*                                                                         
C36013              INITIALIZE    WS-EMB-INPUT                          
C36013                            WS-CMP-TABLE                          
C36013              MOVE WS-CR-COMMENTS         TO WS-EMB-INPUT         
C36013              MOVE +210                   TO WS-EMB-LENG          
C36013              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT  
C36013              MOVE WS-CMP-TABLE           TO WS-CR-COMMENTS       
C36013           ELSE                                                   
C36013              MOVE WS-4071-CR-COMMENTS    TO WS-CR-COMMENTS       
C36013           END-IF                                                 
C36013*                                                                         
C36013           MOVE WS-CR-COMMENTS       TO CK-CR-COMMENTS-TEXT       
C36013                                        WS-VARCHAR                
C36013           MOVE +210                 TO WS-MAX-LEN                
C36013           PERFORM 5900-CALC-VARCHAR-LENGTH  THRU 5900-EXIT       
C36013           MOVE WS-VARCHAR-LEN       TO CK-CR-COMMENTS-LEN        
P00704        ELSE                                                      
P00704           IF I-COMMENTS-TEXT > SPACES                            
P00704              MOVE CK-CR-COMMENTS-TEXT   TO WS-VARCHAR            
P00704              MOVE +210                  TO WS-MAX-LEN            
P00704              PERFORM 5900-CALC-VARCHAR-LENGTH  THRU 5900-EXIT    
P00704              MOVE WS-VARCHAR-LEN       TO CK-CR-COMMENTS-LEN     
P00704           END-IF                                                 
C36013        END-IF                                                    
C36013*                                                                         
C36013*                                                                         
              MOVE 'Y'                   TO CK-CR-SCORE-UPDATE-FL       
              PERFORM 8100-UPDATE-CREDIT-HIST       THRU 8100-EXIT      
P00599        IF CK-ADV-CREDIT-LTR NOT = WS-PREV-ADV-CRED-LTR           
P00599           MOVE WS-CUSTOMER-NO     TO 1J-CUSTOMER-NO              
P00599           MOVE WS-CPD351-COMP-NO  TO 1J-CORRESP-COMPANY-NO       
P00599           MOVE WS-CR-HIST-TRAN-DT TO 1J-CORRESP-STMT-DT          
P00599           MOVE 'CL'               TO 1J-CORRESP-TYPE-CD          
P00599           IF WS-PREV-ADV-CRED-LTR  = 'Y' AND                     
P00599              CK-ADV-CREDIT-LTR NOT = 'Y'                         
P0599A               MOVE 'Y'             TO WS-ROW-FOUND               
P0599A               SET CORR-ID-NOT-FOUND   TO TRUE                    
P0599A               PERFORM 2550-CORRESP-ID-PROCESS    THRU 2550-EXIT  
P0599A                 UNTIL WS-ROW-FOUND = 'N'                         
P0599A               IF CORR-ID-NOT-FOUND                               
P0599A                  PERFORM 7400-GET-CORR-ID        THRU 7400-EXIT  
P0599A                  IF SQLCODE = 0                                  
P0599A                    PERFORM 8300-UPDATE-CORRESP-HDR THRU 8300-EXIT
P0599A                    PERFORM 8400-DELETE-CORRESP-HDR THRU 8400-EXIT
P0599A                  END-IF                                          
P0599A               END-IF                                             
P00599           END-IF                                                 
P00599           IF CK-ADV-CREDIT-LTR  = 'Y'                            
P00599              PERFORM 5040-POPULATE-CORRESP-HDR-DTLS              
P00599                                            THRU 5040-CPD351-EXIT 
P00599              PERFORM 5010-GET-MSG-ID-FST-METHOD                  
P00599                                            THRU 5010-CPD351-EXIT 
P00599              PERFORM 5030-CALL-NOTICES                           
P00599                                            THRU 5030-CPD351-EXIT 
P00599           END-IF                                                 
P00599        END-IF                                                    
           END-IF                                                       
      *                                                                         
           IF  WS-LETTER-NOTIFY-CD NOT = LF-LETTER-NOTIFY-CD            
               SET LETTR-NOTIFY-UPDT     TO TRUE                        
               PERFORM 5220-JRNL-LETTR-NOTIFY THRU 5220-EXIT            
               MOVE WS-LETTER-NOTIFY-CD  TO LF-LETTER-NOTIFY-CD         
           END-IF                                                       
      *                                                                         
           IF  WS-LETTER-MAILED-DT NOT = LF-LETTER-MAILED-DT            
               SET LETTR-MAILED-DT-UPDT    TO TRUE                      
               PERFORM 5230-JRNL-LETTR-DT           THRU 5230-EXIT      
               MOVE WS-LETTER-MAILED-DT    TO LF-LETTER-MAILED-DT       
           END-IF                                                       
      *                                                                         
C29586     IF WS-RESOLUTION-DT > SPACES                                 
C29586         NEXT SENTENCE                                            
C29586     ELSE                                                         
C29586         IF ( I-ITPA-RSLT-CUR-CD EQUAL 'U' OR 'V' OR 'R' ) AND    
C36013              ITPA-RSLT-UPDT                                      
C29586             PERFORM 5250-JRNL-RESLTN-DATE    THRU 5250-EXIT      
C29586             MOVE MH-DATE-TRANS      TO LF-RESOLUTION-DT          
C29586         ELSE                                                     
C29586             MOVE SPACES             TO LF-RESOLUTION-DT          
C29586         END-IF                                                   
C29586     END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ****************************************************************          
      * 5210-JRNL-RSLT-CD.                         *                            
      *                                                              *          
      ****************************************************************          
       5210-JRNL-RSLT-CD.                                               
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE SPACES                   TO MI-TABLE-ID.                
           MOVE 'ITPA_CURR_RSLT'         TO MI-COLUMN-DESC.             
           MOVE 1                        TO MI-CHG-COLUMN-VALUE-LEN     
           MOVE I-ITPA-RSLT-CUR-CD       TO MI-CHG-COLUMN-VALUE-TEXT    
           IF  LF-ITPA-RSLT-CURR-CD NOT = SPACES                        
               MOVE 1                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE LF-ITPA-RSLT-CURR-CD TO MI-PRV-COLUMN-VALUE-TEXT    
           ELSE                                                         
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
           END-IF.                                                      
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
           ADD  1                        TO WS-TRAN-APPL-NO.            
                                                                        
P00704 5210-EXIT.                                                       
P00704     EXIT.                                                        
                                                                        
P00704****************************************************************          
P00704* 5215-JRNL-COMMENT.                         *                            
P00704*                                                              *          
P00704****************************************************************          
P00704 5215-JRNL-COMMENT.                                               
P00704                                                                  
P00704     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
P00704     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
P00704     MOVE SPACES                   TO MI-TABLE-ID.                
P00704     MOVE 'COMMENT'                TO MI-COLUMN-DESC.             
P00704     IF I-COMMENTS-LEN < 76                                       
P00704        MOVE I-COMMENTS-LEN           TO MI-CHG-COLUMN-VALUE-LEN  
P00704        MOVE I-COMMENTS-TEXT          TO MI-CHG-COLUMN-VALUE-TEXT 
P00704     ELSE                                                         
P00704        MOVE 75                       TO MI-CHG-COLUMN-VALUE-LEN  
P00704        MOVE I-COMMENTS-TEXT(1:75)    TO MI-CHG-COLUMN-VALUE-TEXT 
P00704     END-IF                                                       
P00704     IF  CK-CR-COMMENTS-TEXT  NOT = SPACES                        
P00704         IF CK-CR-COMMENTS-LEN < 76                               
P00704            MOVE CK-CR-COMMENTS-LEN   TO MI-PRV-COLUMN-VALUE-LEN  
P00704            MOVE CK-CR-COMMENTS-TEXT  TO MI-PRV-COLUMN-VALUE-TEXT 
P00704         ELSE                                                     
P00704            MOVE 75                   TO MI-PRV-COLUMN-VALUE-LEN  
P00704            MOVE CK-CR-COMMENTS-TEXT(1:75) TO                     
P00704                                        MI-PRV-COLUMN-VALUE-TEXT  
P00704         END-IF                                                   
P00704     ELSE                                                         
P00704         MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
P00704         MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
P00704     END-IF.                                                      
P00704     PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
P00704     ADD  1                        TO WS-TRAN-APPL-NO.            
P00704                                                                  
       5215-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 5220-JRNL-LETTR-NOTIFY.                                      *          
      *                                                              *          
      ****************************************************************          
       5220-JRNL-LETTR-NOTIFY.                                          
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE SPACES                   TO MI-TABLE-ID.                
           MOVE 'LETTER NOTIFY'          TO MI-COLUMN-DESC.             
           MOVE 1                        TO MI-CHG-COLUMN-VALUE-LEN     
           MOVE WS-LETTER-NOTIFY-CD      TO MI-CHG-COLUMN-VALUE-TEXT    
           IF  LF-LETTER-NOTIFY-CD NOT = ZEROES                         
               MOVE 1                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE LF-LETTER-NOTIFY-CD  TO MI-PRV-COLUMN-VALUE-TEXT    
           ELSE                                                         
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
           END-IF.                                                      
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
           ADD  1                        TO WS-TRAN-APPL-NO.            
                                                                        
       5220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 5230-JRNL-LETTR-DT.                                          *          
      *                                                              *          
      ****************************************************************          
       5230-JRNL-LETTR-DT.                                              
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE SPACES                   TO MI-TABLE-ID.                
           MOVE 'LETTR MAILED DT'        TO MI-COLUMN-DESC.             
           MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN     
           MOVE WS-LETTER-MAILED-DT      TO MI-CHG-COLUMN-VALUE-TEXT    
           IF  LF-LETTER-MAILED-DT NOT = SPACES                         
               MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE LF-LETTER-MAILED-DT  TO MI-PRV-COLUMN-VALUE-TEXT    
           ELSE                                                         
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
           END-IF.                                                      
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
           ADD  1                        TO WS-TRAN-APPL-NO.            
                                                                        
       5230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 5240-JRNL-ADV-LTR-CD.                                        *          
      *                                                              *          
      ****************************************************************          
       5240-JRNL-ADV-LTR-CD.                                            
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE  '79'                    TO MI-TABLE-ID.                
           MOVE 'ADV LETTER STAT'        TO MI-COLUMN-DESC.             
           MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN     
           MOVE CK-ADV-CREDIT-LTR        TO MI-CHG-COLUMN-VALUE-TEXT    
           IF  WS-PREV-ADV-CRED-LTR NOT = SPACES                        
               MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-ADV-CRED-LTR TO MI-PRV-COLUMN-VALUE-TEXT    
           ELSE                                                         
               MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
           END-IF.                                                      
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
           ADD  1                        TO WS-TRAN-APPL-NO.            
                                                                        
       5240-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29586****************************************************************          
C29586* 5250-JRNL-RESLTN-DATE                                        *          
C29586*                                                              *          
C29586****************************************************************          
C29586 5250-JRNL-RESLTN-DATE.                                           
C29586                                                                  
C29586     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
C29586     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
C29586     MOVE SPACES                   TO MI-TABLE-ID.                
C29586     MOVE 'RESOLUTION DT'          TO MI-COLUMN-DESC.             
C29586     MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN     
C29586     MOVE MH-DATE-TRANS            TO MI-CHG-COLUMN-VALUE-TEXT    
C29586     IF LF-RESOLUTION-DT NOT = SPACES                             
C29586         MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN     
C29586         MOVE LF-RESOLUTION-DT     TO MI-PRV-COLUMN-VALUE-TEXT    
C29586     ELSE                                                         
C29586         MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
C29586         MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
C29586     END-IF.                                                      
C29586     PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
C29586     ADD  1                        TO WS-TRAN-APPL-NO.            
C29586                                                                  
C29586 5250-EXIT.                                                       
C29586     EXIT.                                                        
C36013****************************************************************          
C36013* 5252-JRNL-APPL-STATUS-CD.                                    *          
C36013*                                                              *          
C36013****************************************************************          
C36013 5252-JRNL-APPL-STATUS-CD.                                        
C36013                                                                  
C36013     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
C36013     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
C36013     MOVE 'C3'                     TO MI-TABLE-ID.                
C36013     MOVE 'APPL  STATUS'           TO MI-COLUMN-DESC.             
C36013     MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN     
C36013     MOVE CK-APPL-STATUS-CD        TO MI-CHG-COLUMN-VALUE-TEXT    
C36013     IF  WS-PREV-APPL-STATUS-CD  NOT = SPACES                     
C36013         MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN     
C36013         MOVE WS-PREV-APPL-STATUS-CD                              
C36013                                   TO MI-PRV-COLUMN-VALUE-TEXT    
C36013     ELSE                                                         
C36013         MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN     
C36013         MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
C36013     END-IF.                                                      
C36013     PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
C36013     ADD  1                        TO WS-TRAN-APPL-NO.            
C36013                                                                  
C36013 5252-EXIT.                                                       
C36013     EXIT.                                                        
C36013*                                                                         
C36013****************************************************************          
C36013* 5254-JRNL-CR-ACTION-FL.                                      *          
C36013*                                                              *          
C36013****************************************************************          
C36013 5254-JRNL-CR-ACTION-FL.                                          
C36013                                                                  
C36013     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
C36013     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
C36013     MOVE 'C4'                     TO MI-TABLE-ID.                
C36013     MOVE 'DEPOSIT ACTION'         TO MI-COLUMN-DESC.             
C36013     MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN     
C36013     MOVE CK-CR-ACTION-FL          TO MI-CHG-COLUMN-VALUE-TEXT    
C36013     IF  WS-PREV-DEPSOIT-ACTION  NOT = SPACES                     
C36013         MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN     
C36013         MOVE WS-PREV-DEPSOIT-ACTION                              
C36013                                   TO MI-PRV-COLUMN-VALUE-TEXT    
C36013     ELSE                                                         
C36013         MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN     
C36013         MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
C36013     END-IF.                                                      
C36013     PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
C36013     ADD  1                        TO WS-TRAN-APPL-NO.            
C36013                                                                  
C36013 5254-EXIT.                                                       
C36013     EXIT.                                                        
C36013*                                                                         
C36013****************************************************************          
C36013* 5260-CALL-MATRIX-PROGRAM CSR04071                            *          
C36013*                                                              *          
C36013****************************************************************          
C36013*                                                                         
C36013 5260-CALL-MATRIX-SP.                                             
C36013*                                                                         
C36013     MOVE '5260'                   TO WS-ACTIVE-PARAGRAPH.        
C36013*****INPUT PARAMETERS FOR MATRIX PROGRAM(CSR04071)                        
C36013     MOVE 'CSR03495'               TO PARM-PROGRAM-ID.            
C36013     MOVE SPACES                   TO PARM-HDR-RETURN-CODE.       
C36013     MOVE SPACES                   TO PARM-ITPA-EXISTS-CD.        
C36013     MOVE CK-CR-CHK-COMPANY-NO     TO PARM-COMPANY-NO.            
C36013     MOVE CK-CB-HIT-CD             TO PARM-HIT-CD.                
C36013     MOVE CK-CB-SAFESCAN-CD        TO PARM-SAFESCAN-CD.           
C36013     MOVE CK-CB-MATCH-CD           TO PARM-MATCH-CD.              
C36013     MOVE CK-CB-BEACON-REJ-CD      TO PARM-BEACON-REJ-CD.         
C36013     MOVE CK-CB-FORMAT-ERR-CD      TO PARM-FORMAT-ERR.            
C36013     MOVE CK-CB-VALIDITY-ERR-CD    TO PARM-VALID-ERR.             
C36013     MOVE CK-CB-PROCESS-ERR-CD     TO PARM-PROCESS-ERR.           
C36013     MOVE CK-CR-RQST-REASON-CD     TO PARM-RQST-REASON-CD.        
C36013     MOVE CK-SENIOR-FL             TO PARM-SENIOR-FL.             
C36013     MOVE CK-REG-GROUP-CD          TO PARM-REG-GROUP-CD.          
A05198     MOVE CK-ADDL-CRED-SCORE       TO PARM-ADDL-CRED-SCORE.       
C36013     MOVE CK-BEACON-SCORE          TO PARM-BEACON-SCORE.          
A05198     MOVE WS-ADDL-SCORE-IND        TO PARM-ADDL-SCORE-IND.        
C36013     MOVE WS-CUSTOMER-NO           TO PARM-CUSTOMER-NO.           
C36013     MOVE I-USER-ID                TO PARM-USER-ID.               
I01701     MOVE CK-SPECIAL-OFFER-CD      TO WS-SPECIAL-OFFER-CD.        
C36013*                                                                         
C36013     INITIALIZE   WS-CSR04071-OUTPUT.                             
C36013*    EXEC SQL                                                     
C36013*       CALL CSR04071 ( :PARM-PROGRAM-ID                          
C36013*                      ,:PARM-HDR-RETURN-CODE                     
C36013*                      ,:PARM-ITPA-EXISTS-CD                      
C36013*                      ,:PARM-COMPANY-NO                          
C36013*                      ,:PARM-HIT-CD                              
C36013*                      ,:PARM-SAFESCAN-CD                         
C36013*                      ,:PARM-MATCH-CD                            
C36013*                      ,:PARM-BEACON-REJ-CD                       
C36013*                      ,:PARM-FORMAT-ERR                          
C36013*                      ,:PARM-VALID-ERR                           
C36013*                      ,:PARM-PROCESS-ERR                         
C36013*                      ,:PARM-RQST-REASON-CD                      
C36013*                      ,:PARM-SENIOR-FL                           
C36013*                      ,:PARM-REG-GROUP-CD                        
C36013*                      ,:PARM-BEACON-SCORE                        
C36013*                      ,:PARM-CUSTOMER-NO                         
C36013*                      ,:PARM-USER-ID                             
I01701*                      ,:WS-SPECIAL-OFFER-CD                      
A05198*                      ,:PARM-ADDL-CRED-SCORE                     
A05198*                      ,:PARM-ADDL-SCORE-IND                      
C36013*                     )                                           
C36013*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CSR04071_RS_CSR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CSR04071_RS_CSR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CSR04071_RS_CSR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
C36013                                                                  
C36013     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
C36013     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
C36013        MOVE 500                       TO WS-ACTIVE-RETURN-CODE   
C36013        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C36013        MOVE '5260'                    TO ACTIVE-PARAGRAPH        
C36013        MOVE 'DB2 SP CALL'             TO ABEND-FUNCTION          
C36013        MOVE 'CSR04071'                TO TABLE-1                 
C36013        MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
C36013        MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
C36013        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C36013        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C36013     END-IF.                                                      
C36013                                                                  
C36013*    EXEC SQL                                                     
C36013*       ASSOCIATE LOCATORS                                        
C36013*       (:LOC-RESLTSET)                                           
C36013*       WITH PROCEDURE CSR04071                                   
C36013*    END-EXEC.                                                    
C36013                                                                  
C36013*    EXEC SQL                                                     
C36013*       ALLOCATE CSR04071_RS_CSR CURSOR FOR RESULT SET            
C36013*       :LOC-RESLTSET                                             
C36013*    END-EXEC.                                                    
C36013                                                                  
C36013     EXEC SQL                                                     
C36013         FETCH CSR04071_RS_CSR                                    
C36013          INTO :WS-4071-RETURN-CODE                               
C36013              ,:WS-4071-APPL-STATUS-CD                            
C36013              ,:WS-4071-CR-SCORE-TYPE-CD                          
C36013              ,:WS-4071-CR-SCORE-CD                               
C36013              ,:WS-4071-CR-ACTION-FL                              
C36013              ,:WS-4071-APPL-RESULT-CD                            
C36013              ,:WS-4071-APPL-RESPONSE-CD                          
C36013              ,:WS-4071-CR-COMMENTS                               
A05198              ,:WS-4071-SCORE-MODEL-CD                            
C36013     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013                                                                  
C36013     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C36013     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36013        NEXT SENTENCE                                             
C36013     ELSE                                                         
C36013        MOVE 500                       TO WS-ACTIVE-RETURN-CODE   
C36013        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C36013        MOVE '5260'                    TO ACTIVE-PARAGRAPH        
C36013        MOVE 'FETCH'                   TO ABEND-FUNCTION          
C36013        MOVE 'RESULT_SET_CSR'          TO TABLE-1                 
C36013        MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
C36013        MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
C36013        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C36013        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C36013     END-IF.                                                      
C36013                                                                  
C36013     EXEC SQL                                                     
C36013         CLOSE CSR04071_RS_CSR                                    
C36013     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013                                                                  
C36013     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C36013     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36013        NEXT SENTENCE                                             
C36013     ELSE                                                         
C36013        MOVE 500                       TO WS-ACTIVE-RETURN-CODE   
C36013        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C36013        MOVE '5260'                    TO ACTIVE-PARAGRAPH        
C36013        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
C36013        MOVE 'RESULT_SET_CSR'          TO TABLE-1                 
C36013        MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
C36013        MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
C36013        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C36013        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C36013     END-IF.                                                      
C36013                                                                  
C36013     IF WS-4071-RETURN-CODE = ZEROES                              
C36013        MOVE WS-4071-APPL-STATUS-CD    TO CK-APPL-STATUS-CD       
C36013        MOVE WS-4071-CR-SCORE-TYPE-CD  TO CK-CR-SCORE-TYPE-CD     
C36013        MOVE WS-4071-CR-SCORE-CD       TO CK-CR-SCORE-CD          
C36013        MOVE WS-4071-CR-ACTION-FL      TO CK-CR-ACTION-FL         
A05198        MOVE WS-4071-SCORE-MODEL-CD    TO CK-SCORE-MODEL-CD       
C36013        MOVE 'Y'                       TO WS-ITPA-CHG-IND         
C36013     ELSE                                                         
C36013        MOVE 500                       TO WS-ACTIVE-RETURN-CODE   
C36013        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C36013        MOVE '2310'                    TO ACTIVE-PARAGRAPH        
C36013        MOVE 'DB2 SP CALL'             TO ABEND-FUNCTION          
C36013        MOVE 'CSR04071'                TO TABLE-1                 
C36013        MOVE 'RETURN-CODE'             TO TABLE-ELEMENT-1         
C36013        MOVE WS-4071-RETURN-CODE       TO HOSTVAR-ELEMENT-1       
C36013        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C36013        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C36013     END-IF.                                                      
C36013                                                                  
C36013 5260-EXIT.                                                       
C36013     EXIT.                                                        
C36013                                                                  
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
C36013******************************************************************        
C36013*    6010-REDUCE-EMBEDDED-SPACES                                **        
C36013******************************************************************        
C36013*                                                                         
C36013     EXEC SQL                                                             
C36013         INCLUDE CPD00004                                                 
C36013     END-EXEC.                                                            
C36013*                                                                         
C36013******************************************************************        
C36013* INCLUDE THE CPD00060 COPYBOOK HERE.                            *        
C36013******************************************************************        
C36013*                                                                         
C36013 COPY CPD00060.                                                           
C36013*                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *   7000-SELECT-TIMESTAMP.                                       *        
      *                                                                *        
      *       GET CURRENT DATE AND TIMESTAMP.                          *        
      ******************************************************************        
       7000-SELECT-TIMESTAMP.                                           
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP,                    
MFA-TR*           :MH-DATE-TRANS = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE I-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT            THRU 9000-EXIT  
              PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C36013*****************************************************************         
C36013* 7025-GET-DATABASE.                                            *         
C36013* CHECK DATABASE TO DETERMINE WHICH REGION THE TRANSACTION      *         
C36013* IS BEING EXECUTED ON.                                         *         
C36013*****************************************************************         
C36013*                                                                         
C36013 7025-GET-DATABASE.                                               
C36013                                                                  
C36013     EXEC SQL                                                     
C36013         SELECT DELINQ_VALUE                                      
C36013           INTO :C8-DELINQ-VALUE                                  
C36013           FROM CSS_DELINQUENCY                                   
C36013          WHERE DELINQ_CD = :C8-DELINQ-CD                         
C36013          AND  COMPANY_NO = :C8-COMPANY-NO                        
C36013     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013                                                                  
C36013     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36013                                                                  
C36013     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36013         NEXT SENTENCE                                            
C36013     ELSE                                                         
C36013         MOVE '7025'                TO ACTIVE-PARAGRAPH           
C36013         MOVE 'SELECT'              TO ABEND-FUNCTION             
C36013         MOVE 'CSS_DELIQUENCY'      TO TABLE-1                    
C36013         MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1            
C36013         MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2            
C36013         MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1          
C36013         MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2          
C36013         PERFORM 9000-SEND-ERROR-RESULT            THRU 9000-EXIT 
C36013         PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT 
C36013     END-IF.                                                      
C36013                                                                  
C36013 7025-EXIT.                                                       
C36013     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7050-SELECT-RESP-AREA.                                       *        
      *                                                                *        
      *       GET RESPONSIBLE AREA FOR THE USER.                       *        
      ******************************************************************        
                                                                        
       7050-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :MH-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :I-USER-ID                               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :MH-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :I-USER-ID                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE I-USER-ID             TO HOSTVAR-ELEMENT-1           
              MOVE I-CUSTOMER-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT            THRU 9000-EXIT  
              PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7100-SELECT-CRED-ITPA-HIST                                    *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *                                                               *         
      *     SELECTS CSS_CRED_ITPA_HIST                                *         
      *****************************************************************         
       7100-SELECT-CRED-ITPA-HIST.                                      
                                                                        
           EXEC SQL                                                     
              SELECT ITPA_RSLT_CURR_CD                                  
                    ,LETTER_NOTIFY_CD                                   
                    ,CIS.CHAR2$DATE(LETTER_MAILED_DT,'USA')                     
C29586              ,RESOLUTION_DT                                      
                INTO :LF-ITPA-RSLT-CURR-CD                              
                    ,:LF-LETTER-NOTIFY-CD :WS-NULL-IND1                  
                    ,:LF-LETTER-MAILED-DT :WS-NULL-IND2                  
C29586              ,:LF-RESOLUTION-DT :WS-NULL-IND3                     
                FROM CSS_CRED_ITPA_HIST WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO = :LF-CUSTOMER-NO                      
                 AND CR_HIST_TRAN_DT = IIF(TRY_CONVERT(DATE, 
                                                    :LF-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :LF-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:LF-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:LF-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :LF-CR-HIST-TRAN-DT) )              
                 AND CR_HIST_TRAN_TM = CIS.CHAR2TIME(:LF-CR-HIST-TRAN-TM
              )              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ITPA_RSLT_CURR_CD                                          
MFA-TR*             ,LETTER_NOTIFY_CD                                           
MFA-TR*             ,CHAR(LETTER_MAILED_DT,USA)                                 
MFA-TR*             ,RESOLUTION_DT                                              
MFA-TR*         INTO :LF-ITPA-RSLT-CURR-CD                                      
MFA-TR*             ,:LF-LETTER-NOTIFY-CD:WS-NULL-IND1                          
MFA-TR*             ,:LF-LETTER-MAILED-DT:WS-NULL-IND2                          
MFA-TR*             ,:LF-RESOLUTION-DT:WS-NULL-IND3                             
MFA-TR*         FROM CSS_CRED_ITPA_HIST                                         
MFA-TR*        WHERE CUSTOMER_NO = :LF-CUSTOMER-NO                              
MFA-TR*          AND CR_HIST_TRAN_DT = :LF-CR-HIST-TRAN-DT                      
MFA-TR*          AND CR_HIST_TRAN_TM = :LF-CR-HIST-TRAN-TM                      
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  WS-NULL-IND1 = -1                                    
                   MOVE SPACES TO LF-LETTER-NOTIFY-CD                   
                   MOVE ZEROES TO WS-NULL-IND1                          
               END-IF                                                   
               IF  WS-NULL-IND2 = -1                                    
                   MOVE SPACES TO LF-LETTER-MAILED-DT                   
                   MOVE ZEROES TO WS-NULL-IND2                          
               END-IF                                                   
C29586         IF  WS-NULL-IND3 = -1                                    
C29586             MOVE SPACES TO LF-RESOLUTION-DT                      
C29586             MOVE ZEROES TO WS-NULL-IND3                          
C29586         END-IF                                                   
           ELSE                                                         
C36013         IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
C36013             IF I-ITPA-RSLT-CUR-CD > SPACES                       
C36013                MOVE PROGRAM-NAME          TO ABEND-PROGRAM       
C36013                MOVE '7100'                TO ACTIVE-PARAGRAPH    
C36013                MOVE 'SELECT'              TO ABEND-FUNCTION      
C36013                MOVE SPACES                TO ABEND-SQL-PREDICATES
C36013                                              ABEND-TABLES        
C36013                MOVE 'CSS_CRED_ITPA_HIST'  TO TABLE-1             
C36013                MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1     
C36013                MOVE 'CR_HIST_TRAN_DT'     TO TABLE-ELEMENT-2     
C36013                MOVE 'CR_HIST_TRAN_TM'     TO TABLE-ELEMENT-3     
C36013                MOVE LF-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1   
C36013                MOVE LF-CR-HIST-TRAN-DT    TO HOSTVAR-ELEMENT-2   
C36013                MOVE LF-CR-HIST-TRAN-TM    TO HOSTVAR-ELEMENT-3   
C36013                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT     
C36013                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT     
C36013             END-IF                                               
C36013         ELSE                                                     
                  MOVE PROGRAM-NAME              TO ABEND-PROGRAM       
                  MOVE '7100'                    TO ACTIVE-PARAGRAPH    
                  MOVE 'SELECT'                  TO ABEND-FUNCTION      
                  MOVE SPACES                    TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                  MOVE 'CSS_CRED_ITPA_HIST'      TO TABLE-1             
                  MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1     
                  MOVE 'CR_HIST_TRAN_DT'         TO TABLE-ELEMENT-2     
                  MOVE 'CR_HIST_TRAN_TM'         TO TABLE-ELEMENT-3     
                  MOVE LF-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1   
                  MOVE LF-CR-HIST-TRAN-DT        TO HOSTVAR-ELEMENT-2   
                  MOVE LF-CR-HIST-TRAN-TM        TO HOSTVAR-ELEMENT-3   
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
C36013         END-IF                                                   
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02338314
      * 7200-SELECT-CREDIT-HIST.                                       *02338314
      *     - THIS MODULE PERFORMS THE SELECT FROM   CSS_CREDIT HIST   *02338314
      *       TABLE.                                                   *02338314
      ******************************************************************02338314
       7200-SELECT-CREDIT-HIST.                                         
           EXEC SQL                                                     
                SELECT     CR_ACTION_FL,                                
                           CR_RQST_REASON_CD,                           
                           ADV_CREDIT_LTR,                              
                           CR_CHK_COMPANY_NO,                           
                           CB_HIT_CD,                                   
                           CB_SAFESCAN_CD,                              
                           CB_MATCH_CD,                                 
                           CB_BEACON_REJ_CD,                            
                           CB_FORMAT_ERR_CD,                            
                           CB_VALIDITY_ERR_CD,                          
                           CB_PROCESS_ERR_CD,                           
                           CR_RQST_REASON_CD,                           
                           APPL_STATUS_CD,                              
                           SENIOR_FL,                                   
                           REG_GROUP_CD,                                
                           BEACON_SCORE,                                
C36013                     CR_SCORE_TYPE_CD,                            
C36013                     CR_SCORE_CD,                                 
C36013                     CR_COMMENTS,                                 
P00342                     CR_BUREAU_CD,                                
A05198                     SPECIAL_OFFER_CD,                            
A05198                     ADDL_CRED_SCORE,                             
A05198                     SCORE_MODEL_CD                               
                  INTO    :CK-CR-ACTION-FL,                             
                          :CK-CR-RQST-REASON-CD,                        
                          :CK-ADV-CREDIT-LTR,                           
                          :CK-CR-CHK-COMPANY-NO,                        
                          :CK-CB-HIT-CD,                                
                          :CK-CB-SAFESCAN-CD,                           
                          :CK-CB-MATCH-CD,                              
                          :CK-CB-BEACON-REJ-CD,                         
                          :CK-CB-FORMAT-ERR-CD,                         
                          :CK-CB-VALIDITY-ERR-CD,                       
                          :CK-CB-PROCESS-ERR-CD,                        
                          :CK-CR-RQST-REASON-CD,                        
                          :CK-APPL-STATUS-CD,                           
                          :CK-SENIOR-FL,                                
                          :CK-REG-GROUP-CD,                             
                          :CK-BEACON-SCORE,                             
C36013                    :CK-CR-SCORE-TYPE-CD,                         
C36013                    :CK-CR-SCORE-CD,                              
C36013                    :CK-CR-COMMENTS,                              
P00342                    :CK-CR-BUREAU-CD,                             
A05198                    :CK-SPECIAL-OFFER-CD,                         
A05198                    :CK-ADDL-CRED-SCORE,                          
A05198                    :CK-SCORE-MODEL-CD                            
                  FROM     CSS_CREDIT_HIST WITH(READUNCOMMITTED)                
                 WHERE     CUSTOMER_NO     = :CK-CUSTOMER-NO            
                   AND     CR_HIST_TRAN_DT = IIF(TRY_CONVERT(DATE, 
                                                    :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) )        
                   AND     CR_HIST_TRAN_TM = CIS.CHAR2TIME(
                                                    :CK-CR-HIST-TRAN-TM
              )        
T35434                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02338914
MFA-TR*         SELECT     CR_ACTION_FL,                                        
MFA-TR*                    CR_RQST_REASON_CD,                                   
MFA-TR*                    ADV_CREDIT_LTR,                                      
MFA-TR*                    CR_CHK_COMPANY_NO,                                   
MFA-TR*                    CB_HIT_CD,                                           
MFA-TR*                    CB_SAFESCAN_CD,                                      
MFA-TR*                    CB_MATCH_CD,                                         
MFA-TR*                    CB_BEACON_REJ_CD,                                    
MFA-TR*                    CB_FORMAT_ERR_CD,                                    
MFA-TR*                    CB_VALIDITY_ERR_CD,                                  
MFA-TR*                    CB_PROCESS_ERR_CD,                                   
MFA-TR*                    CR_RQST_REASON_CD,                                   
MFA-TR*                    APPL_STATUS_CD,                                      
MFA-TR*                    SENIOR_FL,                                           
MFA-TR*                    REG_GROUP_CD,                                        
MFA-TR*                    BEACON_SCORE,                                        
MFA-TR*                    CR_SCORE_TYPE_CD,                                    
MFA-TR*                    CR_SCORE_CD,                                         
MFA-TR*                    CR_COMMENTS,                                         
MFA-TR*                    CR_BUREAU_CD,                                        
MFA-TR*                    SPECIAL_OFFER_CD,                                    
MFA-TR*                    ADDL_CRED_SCORE,                                     
MFA-TR*                    SCORE_MODEL_CD                                       
MFA-TR*           INTO    :CK-CR-ACTION-FL,                             02339599
MFA-TR*                   :CK-CR-RQST-REASON-CD,                        02339799
MFA-TR*                   :CK-ADV-CREDIT-LTR,                           02339799
MFA-TR*                   :CK-CR-CHK-COMPANY-NO,                        02339799
MFA-TR*                   :CK-CB-HIT-CD,                                02339799
MFA-TR*                   :CK-CB-SAFESCAN-CD,                           02339799
MFA-TR*                   :CK-CB-MATCH-CD,                              02339799
MFA-TR*                   :CK-CB-BEACON-REJ-CD,                         02339799
MFA-TR*                   :CK-CB-FORMAT-ERR-CD,                         02339799
MFA-TR*                   :CK-CB-VALIDITY-ERR-CD,                       02339799
MFA-TR*                   :CK-CB-PROCESS-ERR-CD,                        02339799
MFA-TR*                   :CK-CR-RQST-REASON-CD,                        02339799
MFA-TR*                   :CK-APPL-STATUS-CD,                                   
MFA-TR*                   :CK-SENIOR-FL,                                02339799
MFA-TR*                   :CK-REG-GROUP-CD,                             02339799
MFA-TR*                   :CK-BEACON-SCORE,                             02339799
MFA-TR*                   :CK-CR-SCORE-TYPE-CD,                         02339799
MFA-TR*                   :CK-CR-SCORE-CD,                              02339799
MFA-TR*                   :CK-CR-COMMENTS,                              02339799
MFA-TR*                   :CK-CR-BUREAU-CD,                                     
MFA-TR*                   :CK-SPECIAL-OFFER-CD,                                 
MFA-TR*                   :CK-ADDL-CRED-SCORE,                                  
MFA-TR*                   :CK-SCORE-MODEL-CD                                    
MFA-TR*           FROM     CSS_CREDIT_HIST                                      
MFA-TR*          WHERE     CUSTOMER_NO     = :CK-CUSTOMER-NO                    
MFA-TR*            AND     CR_HIST_TRAN_DT = :CK-CR-HIST-TRAN-DT                
MFA-TR*            AND     CR_HIST_TRAN_TM = :CK-CR-HIST-TRAN-TM                
MFA-TR*           WITH     UR                                                   
MFA-TR*    END-EXEC.                                                    02340014

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CREDIT_HIST'         TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE 'CR_HIST_TRAN_DT'         TO TABLE-ELEMENT-2         
              MOVE 'CR_HIST_TRAN_TM'         TO TABLE-ELEMENT-3         
              MOVE  LF-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1       
              MOVE  LF-CR-HIST-TRAN-DT       TO HOSTVAR-ELEMENT-2       
              MOVE  LF-CR-HIST-TRAN-TM       TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT
           END-IF.           
       7200-EXIT.                                                       
           EXIT.                                                        
C36013*                                                                         
C36013*****************************************************************         
C36013* 7300-CRED-BUR-MATRX                                           *         
C36013* GET THE CODE FOR "CR-SCORE-TYPE-CD" AND "CR-SCORE-CD" FIELDS  *         
C36013* FROM CSS_CRED_BUR_MATRX DG BASED ON CR-ACTION-FL & APPL-STATUS*         
C36013*****************************************************************         
C36013*                                                                         
C36013 7300-CRED-BUR-MATRX.                                             
C36013*                                                                 06240000
C36013     MOVE '7300'          TO ACTIVE-PARAGRAPH                     
C36013     INITIALIZE              DG-CR-SCORE-TYPE-CD                  
C36013                             DG-CR-SCORE-CD                       
C36013*                                                                 06260000
C36013     EXEC SQL                                                     
C36013         SELECT TOP(1) CR_SCORE_TYPE_CD,
              CR_SCORE_CD                                       
C36013           INTO :DG-CR-SCORE-TYPE-CD                              
C36013               ,:DG-CR-SCORE-CD                                   
C36013           FROM CSS_CRED_BUR_MATRX WITH(READUNCOMMITTED)                  
C36013          WHERE EFFECTIVE_DT      <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
C36013          AND   EXPIRATION_DT     >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
C36013          AND   COMPANY_NO         = :DG-COMPANY-NO               
C36013          AND   CR_RQST_REASON_CD  = :DG-CR-RQST-REASON-CD        
C36013          AND   REG_GROUP_CD       = :DG-REG-GROUP-CD             
C36013          AND   SENIOR_FL          = :DG-SENIOR-FL                
C36013          AND   APPL_STATUS_CD     = :DG-APPL-STATUS-CD           
C36013          AND   CREDIT_ACTION_FL   = :DG-CREDIT-ACTION-FL         
C36013          AND   CR_SCORE_TYPE_CD   LIKE 'D%'                      
C36013          AND   CR_SCORE_TYPE_CD   <> 'DE'                        
C36013                                     
C36013     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06270000
MFA-TR*        SELECT CR_SCORE_TYPE_CD                                          
MFA-TR*              ,CR_SCORE_CD                                               
MFA-TR*          INTO :DG-CR-SCORE-TYPE-CD                                      
MFA-TR*              ,:DG-CR-SCORE-CD                                           
MFA-TR*          FROM CSS_CRED_BUR_MATRX                                        
MFA-TR*         WHERE EFFECTIVE_DT      <= :WS-CURRENT-DATE                     
MFA-TR*         AND   EXPIRATION_DT     >= :WS-CURRENT-DATE                     
MFA-TR*         AND   COMPANY_NO         = :DG-COMPANY-NO               06296000
MFA-TR*         AND   CR_RQST_REASON_CD  = :DG-CR-RQST-REASON-CD        06296000
MFA-TR*         AND   REG_GROUP_CD       = :DG-REG-GROUP-CD             06296000
MFA-TR*         AND   SENIOR_FL          = :DG-SENIOR-FL                06296000
MFA-TR*         AND   APPL_STATUS_CD     = :DG-APPL-STATUS-CD                   
MFA-TR*         AND   CREDIT_ACTION_FL   = :DG-CREDIT-ACTION-FL                 
MFA-TR*         AND   CR_SCORE_TYPE_CD   LIKE 'D%'                              
MFA-TR*         AND   CR_SCORE_TYPE_CD   <> 'DE'                                
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC                                                     06298000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013*                                                                         
C36013     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36013*                                                                 06060000
C36013     EVALUATE WS-ACTIVE-RETURN-CODE                               
C36013         WHEN SUCCESSFUL-CALL                                     
C36013             CONTINUE                                             
C36013         WHEN NOT-FOUND                                           
C36013             MOVE 'DE'   TO DG-CR-SCORE-TYPE-CD                   
C36013             MOVE 'E'    TO DG-CR-SCORE-CD                        
C36013         WHEN OTHER                                               
C36013             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C36013             MOVE '7300'                TO ACTIVE-PARAGRAPH       
C36013             MOVE 'SELECT'              TO ABEND-FUNCTION         
C36013             MOVE SPACES                TO ABEND-SQL-PREDICATES   
C36013                                           ABEND-TABLES           
C36013             MOVE 'CSS_CRED_BUR_MATRX'  TO TABLE-1                
C36013             MOVE 'APPL_STATUS_CD'      TO TABLE-ELEMENT-1        
C36013             MOVE 'CREDIT_ACTION_FL'    TO TABLE-ELEMENT-2        
C36013             MOVE DG-APPL-STATUS-CD     TO HOSTVAR-ELEMENT-1      
C36013             MOVE DG-CREDIT-ACTION-FL   TO HOSTVAR-ELEMENT-2      
C36013             PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT     
C36013             PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT     
C36013     END-EVALUATE.                                                
C36013*                                                                 06190000
C36013 7300-EXIT.                                                       
C36013     EXIT.                                                        
      *                                                                         
P0599A******************************************************************02338314
P0599A* 7350-GET-CORRESP-ID                                            *02338314
P0599A******************************************************************02338314
P0599A                                                                  
P0599A 7350-GET-CORRESP-ID.                                             
P0599A                                                                  
P0599A     EXEC SQL                                                     
P0599A        SELECT TOP(1) A.CORRESP_ID                                       
P0599A          INTO :1J-CORRESP-ID                                     
P0599A          FROM CSS_CORRESP_HDR A WITH(READUNCOMMITTED)                    
P0599A              ,CSS_CORRESP_VAR B WITH(READUNCOMMITTED)                    
P0599A              ,CSS_CORRESP_VAR C WITH(READUNCOMMITTED)                    
P0599A         WHERE A.CORRESP_ID         = B.CORRESP_ID                
P0599A           AND C.CORRESP_ID         = A.CORRESP_ID                
P0599A           AND A.CUSTOMER_NO        = :1J-CUSTOMER-NO             
P0599A           AND A.CORRESP_TYPE_CD    = :1J-CORRESP-TYPE-CD         
P0599A           AND A.CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO      
P0599A           AND A.REG_GROUP_CD       = :CK-REG-GROUP-CD            
ACT304           AND (A.CORRESP_STATUS_CD  = 'I' OR                     
ACT304                A.CORRESP_STATUS_CD  = 'X')                       
P0599A           AND B.CORRESP_VAR_DATA   = 'CR-HIST-TRAN-TM'           
P0599A           AND B.CORRESP_VAR_CHAR   = :CK-CR-HIST-TRAN-TM         
P0599A           AND C.CORRESP_VAR_DATA   = 'CR-HIST-TRAN-DT'           
P0599A           AND C.CORRESP_VAR_CHAR   = :CK-CR-HIST-TRAN-DT         
P0599A                                              
P0599A                                                           
P0599A                                                      
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02338914
MFA-TR*       SELECT A.CORRESP_ID                                               
MFA-TR*         INTO :1J-CORRESP-ID                                             
MFA-TR*         FROM CSS_CORRESP_HDR A                                          
MFA-TR*             ,CSS_CORRESP_VAR B                                          
MFA-TR*             ,CSS_CORRESP_VAR C                                          
MFA-TR*        WHERE A.CORRESP_ID         = B.CORRESP_ID                        
MFA-TR*          AND C.CORRESP_ID         = A.CORRESP_ID                        
MFA-TR*          AND A.CUSTOMER_NO        = :1J-CUSTOMER-NO                     
MFA-TR*          AND A.CORRESP_TYPE_CD    = :1J-CORRESP-TYPE-CD                 
MFA-TR*          AND A.CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO              
MFA-TR*          AND A.REG_GROUP_CD       = :CK-REG-GROUP-CD                    
MFA-TR*          AND (A.CORRESP_STATUS_CD  = 'I' OR                             
MFA-TR*               A.CORRESP_STATUS_CD  = 'X')                               
MFA-TR*          AND B.CORRESP_VAR_DATA   = 'CR-HIST-TRAN-TM'                   
MFA-TR*          AND B.CORRESP_VAR_CHAR   = :CK-CR-HIST-TRAN-TM                 
MFA-TR*          AND C.CORRESP_VAR_DATA   = 'CR-HIST-TRAN-DT'                   
MFA-TR*          AND C.CORRESP_VAR_CHAR   = :CK-CR-HIST-TRAN-DT                 
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7350                                                       
MFA-TR*    END-EXEC.                                                    02340014

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A                                                                  
P0599A     MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                     
P0599A                                                                  
P0599A     EVALUATE SQLCODE                                             
P0599A        WHEN SUCCESSFUL-CALL                                      
P0599A           CONTINUE                                               
P0599A        WHEN NOT-FOUND                                            
P0599A           MOVE 'N'                       TO WS-ROW-FOUND         
P0599A        WHEN OTHER                                                
P0599A           MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
P0599A           MOVE '7350'                    TO ACTIVE-PARAGRAPH     
P0599A           MOVE 'SELECT'                  TO ABEND-FUNCTION       
P0599A           MOVE SPACES                    TO ABEND-SQL-PREDICATES 
P0599A                                             ABEND-TABLES         
P0599A           MOVE 'CSS_CORRESP_HDR'         TO TABLE-1              
P0599A           MOVE 'CSS_CORRESP_VAR'         TO TABLE-2              
P0599A           MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1      
P0599A           MOVE 'REG_GROUP_CD'            TO TABLE-ELEMENT-2      
P0599A           MOVE 'CORR_VAR_CHAR_TM'        TO TABLE-ELEMENT-3      
P0599A           MOVE 'CORR_VAR_CHAR_DT'        TO TABLE-ELEMENT-4      
P0599A           MOVE 1J-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1    
P0599A           MOVE CK-REG-GROUP-CD           TO HOSTVAR-ELEMENT-2    
P0599A           MOVE CK-CR-HIST-TRAN-TM        TO HOSTVAR-ELEMENT-3    
P0599A           MOVE CK-CR-HIST-TRAN-DT        TO HOSTVAR-ELEMENT-4    
P0599A           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
P0599A           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
P0599A     END-EVALUATE.                                                
P0599A                                                                  
P0599A 7350-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A                                                                  
P0599A******************************************************************02338314
P0599A* 7400-GET-CORR-ID                                               *02338314
P0599A******************************************************************02338314
P0599A                                                                  
P0599A 7400-GET-CORR-ID.                                                
P0599A                                                                  
P0599A     EXEC SQL                                                     
P0599A        SELECT TOP(1) A.CORRESP_ID                                       
P0599A          INTO :1J-CORRESP-ID                                     
P0599A          FROM CSS_CORRESP_HDR A WITH(READUNCOMMITTED)                    
P0599A              ,CSS_CORRESP_VAR B WITH(READUNCOMMITTED)                    
P0599A         WHERE A.CORRESP_ID         = B.CORRESP_ID                
P0599A           AND A.CUSTOMER_NO        = :1J-CUSTOMER-NO             
P0599A           AND A.CORRESP_TYPE_CD    = :1J-CORRESP-TYPE-CD         
P0599A           AND A.CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO      
P0599A           AND A.REG_GROUP_CD       = :CK-REG-GROUP-CD            
ACT304           AND (A.CORRESP_STATUS_CD  = 'I' OR                     
ACT304                A.CORRESP_STATUS_CD  = 'X')                       
P0599A           AND B.CORRESP_VAR_DATA   = 'CR-HIST-TRAN-TM'           
P0599A           AND B.CORRESP_VAR_CHAR   = :CK-CR-HIST-TRAN-TM         
P0599A           AND A.CORRESP_STMT_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :1J-CORRESP-STMT-DT
              ) IS NULL OR (PATINDEX('%.%', :1J-CORRESP-STMT-DT
              ) <> 0) OR (LEN(:1J-CORRESP-STMT-DT
              ) <> 10), CIS.CHAR2DATE(:1J-CORRESP-STMT-DT
              ), CONVERT(DATE, :1J-CORRESP-STMT-DT) )         
P0599A                                            
P0599A                                                           
P0599A                                                      
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02338914
MFA-TR*       SELECT A.CORRESP_ID                                               
MFA-TR*         INTO :1J-CORRESP-ID                                             
MFA-TR*         FROM CSS_CORRESP_HDR A                                          
MFA-TR*             ,CSS_CORRESP_VAR B                                          
MFA-TR*        WHERE A.CORRESP_ID         = B.CORRESP_ID                        
MFA-TR*          AND A.CUSTOMER_NO        = :1J-CUSTOMER-NO                     
MFA-TR*          AND A.CORRESP_TYPE_CD    = :1J-CORRESP-TYPE-CD                 
MFA-TR*          AND A.CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO              
MFA-TR*          AND A.REG_GROUP_CD       = :CK-REG-GROUP-CD                    
MFA-TR*          AND (A.CORRESP_STATUS_CD  = 'I' OR                             
MFA-TR*               A.CORRESP_STATUS_CD  = 'X')                               
MFA-TR*          AND B.CORRESP_VAR_DATA   = 'CR-HIST-TRAN-TM'                   
MFA-TR*          AND B.CORRESP_VAR_CHAR   = :CK-CR-HIST-TRAN-TM                 
MFA-TR*          AND A.CORRESP_STMT_DT    = :1J-CORRESP-STMT-DT                 
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                    02340014

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A                                                                  
P0599A     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P0599A                                                                  
P0599A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0599A        CONTINUE                                                  
P0599A     ELSE                                                         
P0599A        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P0599A        MOVE '7400'                    TO ACTIVE-PARAGRAPH        
P0599A        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P0599A        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P0599A                                          ABEND-TABLES            
P0599A        MOVE 'CSS_CORRESP_HDR'         TO TABLE-1                 
P0599A        MOVE 'CSS_CORRESP_VAR'         TO TABLE-2                 
P0599A        MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
P0599A        MOVE 'REG_GROUP_CD'            TO TABLE-ELEMENT-2         
P0599A        MOVE 'CORRESP_VAR_CHAR'        TO TABLE-ELEMENT-3         
P0599A        MOVE 'CORRESP_STMT_DT'         TO TABLE-ELEMENT-4         
P0599A        MOVE 1J-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
P0599A        MOVE CK-REG-GROUP-CD           TO HOSTVAR-ELEMENT-2       
P0599A        MOVE CK-CR-HIST-TRAN-TM        TO HOSTVAR-ELEMENT-3       
P0599A        MOVE 1J-CORRESP-STMT-DT        TO HOSTVAR-ELEMENT-4       
P0599A        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P0599A        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A 7400-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A                                                                  
      *****************************************************************         
      * 8000-UPDATE-CRED-ITPA-HIST                                    *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *                                                               *         
      *     UPDATES CSS_CRED_ITPA_HIST                                *         
      *****************************************************************         
       8000-UPDATE-CRED-ITPA-HIST.                                      
                                                                        
           IF  LF-LETTER-NOTIFY-CD = SPACES                             
               MOVE -1 TO WS-NULL-IND1                                  
           END-IF.                                                      
           IF  LF-LETTER-MAILED-DT = SPACES                             
               MOVE -1 TO WS-NULL-IND2                                  
           END-IF.                                                      
C29586     IF  LF-RESOLUTION-DT = SPACES                                
C29586         MOVE -1 TO WS-NULL-IND3                                  
C29586     END-IF.                                                      
           EXEC SQL                                                     
              UPDATE CSS_CRED_ITPA_HIST                                 
                 SET ITPA_RSLT_CURR_CD   =:LF-ITPA-RSLT-CURR-CD,        
                     LETTER_NOTIFY_CD                                   
                                     =:LF-LETTER-NOTIFY-CD 
                                      :WS-NULL-IND1,
                     LETTER_MAILED_DT                                   
                                     =IIF(TRY_CONVERT(DATE, 
                                                  :LF-LETTER-MAILED-DT 
                                                          :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :LF-LETTER-MAILED-DT 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:LF-LETTER-MAILED-DT :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:LF-LETTER-MAILED-DT 
                                                          :WS-NULL-IND2
              ), CONVERT(DATE, :LF-LETTER-MAILED-DT :WS-NULL-IND2) ),
                     LAST_UPDATE_USERID  =:LF-LAST-UPDATE-USERID,       
                     LAST_UPDATE_TS      =CIS.CHAR2TIMESTAMP(
                                                     :LF-LAST-UPDATE-TS
              ),           
C29586               RESOLUTION_DT   =IIF(TRY_CONVERT(DATE, 
                                                     :LF-RESOLUTION-DT 
                                                          :WS-NULL-IND3
              ) IS NULL OR (PATINDEX('%.%', :LF-RESOLUTION-DT 
                                                          :WS-NULL-IND3
              ) <> 0) OR (LEN(:LF-RESOLUTION-DT :WS-NULL-IND3
              ) <> 10), CIS.CHAR2DATE(:LF-RESOLUTION-DT :WS-NULL-IND3
              ), CONVERT(DATE, :LF-RESOLUTION-DT :WS-NULL-IND3) )    
               WHERE CUSTOMER_NO         =:LF-CUSTOMER-NO               
                 AND CR_HIST_TRAN_DT     =IIF(TRY_CONVERT(DATE, 
                                                    :LF-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :LF-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:LF-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:LF-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :LF-CR-HIST-TRAN-DT) )           
                 AND CR_HIST_TRAN_TM     =CIS.CHAR2TIME(
                                                    :LF-CR-HIST-TRAN-TM
              )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_ITPA_HIST                                         
MFA-TR*          SET ITPA_RSLT_CURR_CD   =:LF-ITPA-RSLT-CURR-CD,                
MFA-TR*              LETTER_NOTIFY_CD                                           
MFA-TR*                              =:LF-LETTER-NOTIFY-CD:WS-NULL-IND1,        
MFA-TR*              LETTER_MAILED_DT                                           
MFA-TR*                              =:LF-LETTER-MAILED-DT:WS-NULL-IND2,        
MFA-TR*              LAST_UPDATE_USERID  =:LF-LAST-UPDATE-USERID,               
MFA-TR*              LAST_UPDATE_TS      =:LF-LAST-UPDATE-TS,                   
MFA-TR*              RESOLUTION_DT   =:LF-RESOLUTION-DT:WS-NULL-IND3            
MFA-TR*        WHERE CUSTOMER_NO         =:LF-CUSTOMER-NO                       
MFA-TR*          AND CR_HIST_TRAN_DT     =:LF-CR-HIST-TRAN-DT                   
MFA-TR*          AND CR_HIST_TRAN_TM     =:LF-CR-HIST-TRAN-TM                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '8000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'UPDATE'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CRED_ITPA_HIST'       TO TABLE-1               
               MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1       
               MOVE 'CR_HIST_TRAN_DT'          TO TABLE-ELEMENT-2       
               MOVE 'CR_HIST_TRAN_TM'          TO TABLE-ELEMENT-3       
               MOVE LF-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1     
               MOVE LF-CR-HIST-TRAN-DT         TO HOSTVAR-ELEMENT-2     
               MOVE LF-CR-HIST-TRAN-TM         TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8100-UPDATE-CREDIT-HIST                                       *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *                                                               *         
      *     UPDATES CSS_CREDIT_HIST                                   *         
      *****************************************************************         
       8100-UPDATE-CREDIT-HIST.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CREDIT_HIST                                    
                 SET ADV_CREDIT_LTR      =:CK-ADV-CREDIT-LTR            
C36013              ,APPL_STATUS_CD      =:CK-APPL-STATUS-CD            
C36013              ,CR_SCORE_TYPE_CD    =:CK-CR-SCORE-TYPE-CD          
C36013              ,CR_SCORE_CD         =:CK-CR-SCORE-CD               
C36013              ,CR_ACTION_FL        =:CK-CR-ACTION-FL              
C36013              ,CR_COMMENTS         =:CK-CR-COMMENTS               
C36013              ,CR_SCORE_UPDATE_FL  =:CK-CR-SCORE-UPDATE-FL        
A05198              ,SCORE_MODEL_CD      =:CK-SCORE-MODEL-CD            
               WHERE CUSTOMER_NO         =:LF-CUSTOMER-NO               
                 AND CR_HIST_TRAN_DT     =IIF(TRY_CONVERT(DATE, 
                                                    :LF-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :LF-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:LF-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:LF-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :LF-CR-HIST-TRAN-DT) )           
                 AND CR_HIST_TRAN_TM     =CIS.CHAR2TIME(
                                                    :LF-CR-HIST-TRAN-TM
              )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CREDIT_HIST                                            
MFA-TR*          SET ADV_CREDIT_LTR      =:CK-ADV-CREDIT-LTR                    
MFA-TR*             ,APPL_STATUS_CD      =:CK-APPL-STATUS-CD                    
MFA-TR*             ,CR_SCORE_TYPE_CD    =:CK-CR-SCORE-TYPE-CD                  
MFA-TR*             ,CR_SCORE_CD         =:CK-CR-SCORE-CD                       
MFA-TR*             ,CR_ACTION_FL        =:CK-CR-ACTION-FL                      
MFA-TR*             ,CR_COMMENTS         =:CK-CR-COMMENTS                       
MFA-TR*             ,CR_SCORE_UPDATE_FL  =:CK-CR-SCORE-UPDATE-FL                
MFA-TR*             ,SCORE_MODEL_CD      =:CK-SCORE-MODEL-CD                    
MFA-TR*        WHERE CUSTOMER_NO         =:LF-CUSTOMER-NO                       
MFA-TR*          AND CR_HIST_TRAN_DT     =:LF-CR-HIST-TRAN-DT                   
MFA-TR*          AND CR_HIST_TRAN_TM     =:LF-CR-HIST-TRAN-TM                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '8100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'UPDATE'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CREDIT_HIST'          TO TABLE-1               
               MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1       
               MOVE 'CR_HIST_TRAN_DT'          TO TABLE-ELEMENT-2       
               MOVE 'CR_HIST_TRAN_TM'          TO TABLE-ELEMENT-3       
               MOVE LF-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1     
               MOVE LF-CR-HIST-TRAN-DT         TO HOSTVAR-ELEMENT-2     
               MOVE LF-CR-HIST-TRAN-TM         TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C36013******************************************************************23350000
C36013* 8200-INSERT-WQ.                                                *23360000
ACT233* ARGUMENTS WILL BE PASSED TO THE DB2 STORED PROCEDURE CSR04675. *23370000
C36013* THIS SPDB INSERTS THE ROWS INTO THE DB2 TABLE CSS_WQ_ITEMS     *23380000
C36013* AND RETURNS SQLCODE & ITEM ID.                                 *23390000
C36013******************************************************************23400000
C36013 8200-INSERT-WQ.                                                  
C36013*                                                                 23420000
ACT233      INITIALIZE   WS-CSR04675-OUTPUT.                            
C36013      MOVE ZERO                        TO WS-WQ-ITEM-ID           
C36013                                                                  
C36013*    EXEC SQL                                                     
ACT233*       CALL CSR04675 (:WS-WQ-ITEM-ID,                            
C36013*                      :WS-WQ-ROUTE-CATEGORY,                     
C36013*                      :WS-WQ-LOCAL-OFFICE,                       
C36013*                      :WS-WQ-USER-ID-ORIG,                       
C36013*                      :WS-WQ-USER-ID-ASGN,                       
C36013*                      :WS-WQ-RESP-AREA-ID,                       
C36013*                      :WS-WQ-CATEGORY-ID,                        
C36013*                      :WS-WQ-ACCOUNT-NO,                         
C36013*                      :WS-WQ-PREMISE-NO,                         
C36013*                      :WS-WQ-CUSTOMER-NO,                        
C36013*                      :WS-WQ-SERV-ORDER-NO,                      
C36013*                      :WS-WQ-COMMENTS,                           
C36013*                      :WS-WQ-DATE-REQUIRED,                      
C36013*                      :WS-WQ-DATE-CREATED,                       
C36013*                      :WS-WQ-PRIORITY,                           
C36013*                      :WS-WQ-FREE-FORM-AREA,                     
ACT233*                      :WS-WQ-CREATED-BY)                         
C36013*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CSR04675_RS_CSR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CSR04675_RS_CSR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CSR04675_RS_CSR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
C36013                                                                  
C36013     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
C36013     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
C36013        MOVE 290                    TO WS-ACTIVE-RETURN-CODE      
C36013        MOVE '8200'                 TO ACTIVE-PARAGRAPH           
C36013        MOVE 'DB2 SP CALL'          TO ABEND-FUNCTION             
ACT233        MOVE 'CSR04675'             TO TABLE-1                    
C36013        MOVE 'WS-ACTIVE-RETURN-CODE' TO TABLE-ELEMENT-1           
C36013        MOVE WS-ACTIVE-RETURN-CODE  TO HOSTVAR-ELEMENT-1          
C36013        MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-2            
C36013        MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-2          
C36013        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C36013        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C36013     END-IF.                                                      
C36013*                                                                 23780000
C36013*    EXEC SQL                                                     
C36013*       ASSOCIATE LOCATORS                                        
C36013*       (:LOC-RESLTSET)                                           
ACT233*       WITH PROCEDURE CSR04675                                   
C36013*    END-EXEC.                                                    
C36013*                                                                 23840000
C36013*    EXEC SQL                                                     
ACT233*       ALLOCATE CSR04675_RS_CSR CURSOR FOR RESULT SET            
C36013*       :LOC-RESLTSET                                             
C36013*    END-EXEC.                                                    
C36013*                                                                 23890000
C36013     EXEC SQL                                                     
ACT233         FETCH CSR04675_RS_CSR                                    
ACT233          INTO :WS-CSR04675-RET-CODE, :WS-WQ-ITEM-ID              
C36013     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013*                                                                 23990000
C36013     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C36013     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36013        NEXT SENTENCE                                             
C36013     ELSE                                                         
C36013        MOVE 290                       TO WS-ACTIVE-RETURN-CODE   
C36013        MOVE '8200'                    TO ACTIVE-PARAGRAPH        
C36013        MOVE 'FETCH'                   TO ABEND-FUNCTION          
C36013        MOVE 'RESULT_SET_CSR'          TO TABLE-1                 
C36013        MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
C36013        MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
C36013        MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-2         
C36013        MOVE WS-CUSTOMER-NO            TO HOSTVAR-ELEMENT-2       
C36013        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C36013        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C36013     END-IF.                                                      
C36013                                                                  
C36013     EXEC SQL                                                     
ACT233         CLOSE CSR04675_RS_CSR                                    
C36013     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013*                                                                 24200000
C36013     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C36013     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36013        NEXT SENTENCE                                             
C36013     ELSE                                                         
C36013        MOVE 290                    TO WS-ACTIVE-RETURN-CODE      
C36013        MOVE '8200'                 TO ACTIVE-PARAGRAPH           
C36013        MOVE 'CLOSE'                TO ABEND-FUNCTION             
C36013        MOVE 'RESULT_SET_CSR'       TO TABLE-1                    
C36013        MOVE 'WS-ACTIVE-RETURN-CODE' TO TABLE-ELEMENT-1           
C36013        MOVE WS-ACTIVE-RETURN-CODE  TO HOSTVAR-ELEMENT-1          
C36013        MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-2            
C36013        MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-2          
C36013        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C36013        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C36013     END-IF.                                                      
C36013                                                                  
ACT233     IF WS-CSR04675-RET-CODE = ZEROES                             
C36013        NEXT SENTENCE                                             
C36013     ELSE                                                         
C36013        MOVE 290                       TO WS-ACTIVE-RETURN-CODE   
C36013        MOVE '8200'                    TO ACTIVE-PARAGRAPH        
C36013        MOVE 'DB2 SP CALL'             TO ABEND-FUNCTION          
ACT233        MOVE 'CSR04675'                TO TABLE-1                 
C36013        MOVE 'RETURN-CODE'             TO TABLE-ELEMENT-1         
ACT233        MOVE WS-CSR04675-RET-CODE      TO HOSTVAR-ELEMENT-1       
C36013        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C36013        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C36013     END-IF.                                                      
C36013*                                                                 24370000
C36013 8200-EXIT.                                                       
C36013     EXIT.                                                        
      *                                                                         
P00599**********************************************************************    
P00599* 8300-UPDATE-CORRESP-HDR                                        *   *    
P00599********************************************************************      
P00599 8300-UPDATE-CORRESP-HDR.                                         
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599        UPDATE CSS_CORRESP_HDR                                    
P00599           SET CORRESP_STATUS_CD  = 'C'                           
P0599A         WHERE CORRESP_ID         = :1J-CORRESP-ID                
P00599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL  OR NOT-FOUND 
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        MOVE SPACES                TO ABEND-TABLES                
P00599                                      ABEND-SQL-PREDICATES        
P00599        MOVE '8300'                TO ACTIVE-PARAGRAPH            
P00599        MOVE SQLCODE               TO ABEND-SQLCODE               
P00599        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P00599        MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
P00599        MOVE 'CORRESP_ID'          TO TABLE-ELEMENT-1             
P0599A        MOVE 1J-CORRESP-ID         TO HOSTVAR-ELEMENT-1           
P00599        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00599        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00599     END-IF.                                                      
P00599                                                                  
P00599 8300-EXIT.                                                       
P00599     EXIT.                                                        
P00599                                                                  
P00599**********************************************************************    
P00599* 8400-DELETE-CORRESP-HDR                                        *   *    
P00599**********************************************************************    
P00599                                                                  
P00599 8400-DELETE-CORRESP-HDR.                                         
P00599                                                                  
P00599     EXEC SQL                                                     
P00599        DELETE FROM CSS_CORRESP_HDR                               
P0599A         WHERE CORRESP_ID         = :1J-CORRESP-ID                
P00599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL  OR NOT-FOUND 
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        MOVE SPACES                TO ABEND-TABLES                
P00599                                      ABEND-SQL-PREDICATES        
P00599        MOVE '8400'                TO ACTIVE-PARAGRAPH            
P00599        MOVE SQLCODE               TO ABEND-SQLCODE               
P00599        MOVE 'DELETE'              TO ABEND-FUNCTION              
P00599        MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
P00599        MOVE 'CORRESP_ID'          TO TABLE-ELEMENT-1             
P0599A        MOVE 1J-CORRESP-ID         TO HOSTVAR-ELEMENT-1           
P00599        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00599        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00599     END-IF.                                                      
P00599                                                                  
P00599 8400-EXIT.                                                       
P00599     EXIT.                                                        
P00599                                                                  
P00599***********************************************************************443
P00599* 9700-PROCESS-ABEND                                             *    *443
P00599***********************************************************************444
P00599                                                                  
P00599     EXEC SQL                                                          444
P00599        INCLUDE CPD0023C                                               444
P00599     END-EXEC.                                                         444
P00599                                                                  
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
