       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03488.                                         
COB303 DATE-WRITTEN.  SEP 9,04.                                         
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00070000
      ******************************************************************00060000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00090000
      * A) THIS PROGRAM ENTERS REVERSALS INTO CSS_PAYMENT_TRANS.       *00100000
      * B) THIS IS A DRIVER PROGRAM CALLING FOLLOWING SPS.             *00190000
      *    CSR03487 - FOR VALIDATING INFORMATION FOR REVERSAL.         *00190000
      *    CSR03486 - FOR REVERSING THE PAYMENT.                       *00190000
      * C) THIS CAN BE INVOKED ON-LINE OR THRU BATCH PROCESS(PCSCA362).*00100000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  09/15/04    PD       PROCEDURE ORIGINALLY CODED.              *00280000
      *  04/07/05  SK88120    IMPLEMENT STANDARDS.                     *00280000
APSAPS*  06/02/05 SK88120    UPDATE OV/SH TABLE WITH CORRECT CR/DR     *        
APSAPS*                      INDICATOR                                 *        
C34416*  06/21/06  BASKAR     CHANGES MADE TO REPORT APS REVERSAL      *        
C34416*                       ON PCSACA362 REPORT                      *        
T35434*  07/30/07  MR97640    REPLACED MODEL_SQL WITH SET STATEMENT    *        
T35434*                       AND ADDED WITH UR TO AVOID -911          *        
A00575*  01/20/09  BASKAR V   STORE CREDIT ACTION FLAG IN ERROR_CD     *        
A00575*                       FIELD OF CSS_PAYMENT_TRANS TABLE, HANDLE *        
A00575*                       ERROR_CD FIELD FOR THAT.                 *        
      ******************************************************************00470000
      *                                                                *00480000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00490000
      *                                                                *00500000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00510000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00520000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00530000
      *  3000 - 4999  NOT USED                                         *00540000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00550000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00560000
      *  7000 - 7999  INPUT MODULES                                    *00570000
      *  8000 - 8999  OUTPUT MODULES                                   *00580000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00590000
      *                                                                *00600000
      ******************************************************************00610000
      *                                                                 00620000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
      *                                                                 00650000
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03488'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(50) VALUE   
           'WORKING STORAGE FOR CSR03488 STARTS HERE'.                  
      *                                                                 00690000
      ******************************************************************00700000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00710000
      ******************************************************************00720000
      *                                                                 00730000
           COPY CWS00303.                                               00820000
           COPY CWS00100.                                               00830000
           COPY CJF00101.                                               00840000
           COPY CJF00102.                                               00850000
      *                                                                 00860000
      ******************************************************************00870000
      *    WORK AREAS                                                  *00880000
      ******************************************************************00890000
                                                                        
       01 WS-MISC.                                                      
           05 PROGRAM-NAME             PIC X(08)   VALUE 'CSR03488'.    
           05 WS-ACCOUNT-NO            PIC 9(13).                       
           05 WS-ACCOUNT-NO-CHAR       PIC X(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
           05 WS-PYMT-AMOUNT           PIC 9(09)V99.                    
           05 WS-PYMT-AMOUNT9          PIC 9(09)V99.                    
           05 WS-CURRENT-DATE          PIC X(10).                       
           05 WS-CURRENT-TIME          PIC X(08).                       
           05 WS-COMPANY-NO            PIC X(02).                       
           05 WS-P                     PIC X(01)   VALUE 'P'.           
           05 WS-DISP-GL-ACCT          PIC 9(3).9(4).                   
           05 WS-SYSTEM                PIC X(07)   VALUE 'SYSTEM'.      
           05 WS-JRNL-NAME             PIC X(04)   VALUE '3488'.        
           05 WS-CURRENT-TIMESTAMP     PIC X(26).                       
      *                                                                 01270000
       01 WS-LITERAL.                                                   
           05 WS-A                     PIC X(01)   VALUE 'A'.           
           05 WS-C                     PIC X(01)   VALUE 'C'.           
      *                                                                 01710000
       01  COUNTER-FIELDS.                                              
           05 CTR-ROWS                 PIC S9(9)   COMP VALUE 0.        
      *                                                                 01750000
       01  S-RETURN-FIELDS.                                             
           05 RS-RETURN-CODE           PIC S9(09)  COMP VALUE +0.       
           05 S-RETURN-CODE            PIC S9(09)  COMP VALUE +0.       
           05 S-ERROR-CD               PIC  X(01)  VALUE 'N'.           
           05 S-TIMESTAMP              PIC  X(26)  VALUE ' '.           
           05 S-PYMT-TIMESTAMP         PIC  X(26)  VALUE ' '.           
           05 S-DNP-FLAG               PIC  X(01)  VALUE 'N'.           
           05 S-AR-LOCKOUT-IND         PIC X(01)   VALUE SPACE.         
           05 S-ACCT-XFER-TO           PIC X(13)   VALUE SPACE.         
           05 S-ACCOUNT-NO             PIC X(13)   VALUE SPACES.        
           05 S-COMPANY-NO             PIC X(04)   VALUE SPACES.        
           05 S-BILLED-BALANCE         PIC X(13)   VALUE SPACES.        
           05 S-CANCEL-DNP-FLAG        PIC X(01)   VALUE SPACES.        
           05 S-XFER-TO                PIC S9(13)V COMP-3 VALUE 0.      
      *                                                                 01980000
      ************************                                          01980000
      *     S Q L C A        *                                          01980000
      ************************                                          01980000
           EXEC SQL                                                     01990000
              INCLUDE SQLCA                                             02000000
           END-EXEC.                                                    02010000
      *************************                                         01980000
      * CSS_JOB_PARM       G6 *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02030000
              INCLUDE TBJBPARM                                          02040000
           END-EXEC.                                                    02050000
      *************************                                         01980000
      * CSS_OVERSHORT_HDR  OH *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                             
             INCLUDE TBOVSHHD                                                   
           END-EXEC.                                                            
      *************************                                         01980000
      * CSS_CASHIER_OFFICE Y2 *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE TBCSHOFF                                          01533000
           END-EXEC.                                                    01534000
      *************************                                         01980000
      * CSS_OVERSHORT_TYPE OT *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                             
             INCLUDE TBOVSHTY                                                   
           END-EXEC.                                                            
      *************************                                         01980000
      * CSS_PAYMENT_TRANS  JT *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE TBPMTRAN                                          01533000
           END-EXEC.                                                    01534000
      *************************                                         01980000
      * CSS_CSH_DRWR_CNTL  CS *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02550000
              INCLUDE TBCDCNTL                                          02560000
           END-EXEC.                                                    02570000
      *************************                                         01980000
      * CSS_CSH_DRWR_JRNL  CJ *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02590000
              INCLUDE TBCDJRNL                                          02600000
           END-EXEC.                                                    02610000
      *************************                                         01980000
      * CSS_BCH_JRNL_CNTL  BC *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02630000
              INCLUDE TBBJCNTL                                          02640000
           END-EXEC.                                                    02650000
      *************************                                         01980000
      * CSS_BATCH_JRN      BJ *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02670000
              INCLUDE TBBTJRNL                                          02680000
           END-EXEC.                                                    02690000
      *************************                                         01980000
      * CSS_USER_PROFILE   PF *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02670000
              INCLUDE TBUSRPRF                                          02680000
           END-EXEC.                                                    02690000
      *************************                                         01980000
      * CSS_GL_ACCT_NO     GO *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02670000
              INCLUDE TBGLATNO                                          02680000
           END-EXEC.                                                    02690000
      *************************                                         01980000
      * CSS_MISC_JRNL      MJ *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02670000
              INCLUDE TBMSJRNL                                          02680000
           END-EXEC.                                                    02690000
      *************************                                         01980000
      *   C W S X 0 0 1 0     *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE CWSX0010                                          01533000
           END-EXEC.                                                    01534000
      *************************                                         01980000
      *   C W S 0 0 0 1 3 B   *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03310000
              INCLUDE CWS0013B                                          03320000
           END-EXEC.                                                    03330000
      *************************                                         01980000
      *   C W S 0 0 0 6 1     *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE CWS00061                                          01533000
           END-EXEC.                                                    01534000
      ****** DB2 COMMUNICATION REQUIREMENT ******                               
      *01  LOC1                        USAGE IS SQL TYPE IS             
      *                                RESULT-SET-LOCATOR VARYING.      
      *----------------------------------------------------------------*        
      *    DECLARE CURSOR TO SELECT OVERSHORT TYPE                     *        
      *----------------------------------------------------------------*        
      *                                                                         
           EXEC SQL                                                     
            DECLARE OVSHTYPE_CURSOR CURSOR FOR                          
             SELECT OVERSHORT_TYPE_CD                                   
               FROM CSS_OVERSHORT_TYPE WITH(READUNCOMMITTED)                    
              WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                         
T35434          FOR READ ONLY                                   
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE OVSHTYPE_CURSOR CURSOR FOR                                  
MFA-TR*      SELECT OVERSHORT_TYPE_CD                                           
MFA-TR*        FROM CSS_OVERSHORT_TYPE                                          
MFA-TR*       WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                                 
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR03487                                       
                       ( :I-TIMESTAMP
                  , :I-ACCOUNT-NO
                  , :WS-COMPANY-NO
                  , :I-CASH-LOCAL-OFFICE
                  , :I-CURRENCY-TYPE
                  , :I-PAYMENT-AMOUNT
                  , :I-REPORT-DATE
                  , :I-PYMT-FACILITY-CD
                  , :I-PYMT-INDICATOR
                  , :I-CONFIRMATION-NO
                  , :I-PROGRAM-ID
                  , :I-USER-ID
                  , :I-COMMENTS
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C3 CURSOR
MSQ001          FOR CALL CSR03486                                       
                       ( :WS-ACCOUNT-NO-CHAR
                  , :S-PYMT-TIMESTAMP
                  , :I-PROGRAM-ID
                  , :I-USER-ID
                  , :I-COMMENTS
                  )
MSQ001        END-EXEC.
                                                    
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 I-TIMESTAMP                  PIC  X(26).                      
       01 I-ACCOUNT-NO                 PIC  X(13).                      
       01 I-COMPANY                    PIC  X(04).                      
       01 I-CASH-LOCAL-OFFICE          PIC  X(03).                      
       01 I-CURRENCY-TYPE              PIC  X(03).                      
       01 I-PAYMENT-AMOUNT             PIC  X(11).                      
       01 I-REPORT-DATE                PIC  X(10).                      
       01 I-PYMT-FACILITY-CD           PIC  X(11).                      
       01 I-PYMT-INDICATOR             PIC  X(03).                      
       01 I-CONFIRMATION-NO            PIC  X(12).                      
       01 I-PROGRAM-ID                 PIC  X(09).                      
       01 I-USER-ID                    PIC  X(07).                      
       01 I-COMMENTS                   PIC  X(30).                      
                                                                        
       PROCEDURE DIVISION USING I-TIMESTAMP                             
                               ,I-ACCOUNT-NO                            
                               ,I-COMPANY                               
                               ,I-CASH-LOCAL-OFFICE                     
                               ,I-CURRENCY-TYPE                         
                               ,I-PAYMENT-AMOUNT                        
                               ,I-REPORT-DATE                           
                               ,I-PYMT-FACILITY-CD                      
                               ,I-PYMT-INDICATOR                        
                               ,I-CONFIRMATION-NO                       
                               ,I-PROGRAM-ID                            
                               ,I-USER-ID                               
                               ,I-COMMENTS                              
                               .                                        
      ******************************************************************03540000
      * 0000-MAINLINE                                                  *03550000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03560000
      ******************************************************************03570000
       0000-MAINLINE.                                                   
      *                                                                 03600000
           PERFORM 0100-INITIALIZE      THRU 0100-EXIT.                 
           PERFORM 2000-PROCESS-OUTPUT  THRU 2000-EXIT.                 
           PERFORM 9999-END-PROGRAM     THRU 9999-EXIT.                 
      *                                                                 03600000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03670000
      ******************************************************************03680000
      * 0100-INITIALIZE                                                *03690000
      ******************************************************************03760000
       0100-INITIALIZE.                                                 
      *                                                                 03760000
           MOVE '0100'                  TO ACTIVE-PARAGRAPH.            
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE    AS RETURN_CODE                  
                     ,:S-TIMESTAMP      AS TIMESTAMP                    
                     ,:S-ACCOUNT-NO     AS ACCOUNT_NO                   
                     ,:S-COMPANY-NO     AS COMPANY_NO                   
                     ,:S-BILLED-BALANCE AS BILLED_BALANCE               
                     ,:S-CANCEL-DNP-FLAG AS CANCEL_DNP_FLAG             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE    AS RETURN_CODE                          
MFA-TR*              ,:S-TIMESTAMP      AS TIMESTAMP                            
MFA-TR*              ,:S-ACCOUNT-NO     AS ACCOUNT_NO                           
MFA-TR*              ,:S-COMPANY-NO     AS COMPANY_NO                           
MFA-TR*              ,:S-BILLED-BALANCE AS BILLED_BALANCE                       
MFA-TR*              ,:S-CANCEL-DNP-FLAG AS CANCEL_DNP_FLAG                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
           MOVE I-TIMESTAMP             TO S-TIMESTAMP                  
           MOVE I-ACCOUNT-NO            TO S-ACCOUNT-NO                 
           EVALUATE I-COMPANY                                           
                WHEN 'SCEG'                                             
                  MOVE '01'             TO WS-COMPANY-NO                
                WHEN 'PSNC'                                             
                  MOVE '26'             TO WS-COMPANY-NO                
                WHEN 'SEB'                                              
                  MOVE '01'             TO WS-COMPANY-NO                
                WHEN OTHER                                              
                  MOVE I-COMPANY        TO WS-COMPANY-NO                
           END-EVALUATE                                                 
           MOVE I-COMPANY               TO S-COMPANY-NO                 
           MOVE SPACES                  TO S-BILLED-BALANCE             
           MOVE SPACES                  TO S-CANCEL-DNP-FLAG            
           PERFORM 7150-GET-CURRENT-INFO                                
                                        THRU 7150-EXIT.                 
      *                                                                 03760000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03760000
      ******************************************************************05510000
      * 2000-PROCESS-OUTPUT.                                           *05520000
      ******************************************************************05590000
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 2100-PROCESS-VALIDATION                              
                                        THRU 2100-EXIT                  
           IF S-RETURN-CODE = SUCCESSFUL-CALL                           
              AND S-ERROR-CD = ' '                                      
              PERFORM 2200-PROCESS-REVERSAL                             
                                        THRU 2200-EXIT                  
              IF S-RETURN-CODE = SUCCESSFUL-CALL                        
                 PERFORM 2600-THIRD-PARTY-JRNL                          
                                        THRU 2600-EXIT                  
                 PERFORM 2700-PROCESS-OVSH                              
                                        THRU 2700-EXIT                  
                 MOVE I-ACCOUNT-NO      TO WS-ACCOUNT-NO                
                 MOVE WS-ACCOUNT-NO     TO WS-ACCOUNT-NO-COMP3          
                 MOVE WS-ACCOUNT-NO-COMP3 TO JT-ACCOUNT-NO              
                 MOVE S-TIMESTAMP       TO JT-PYMT-RCVD-TS              
                 IF I-PROGRAM-ID = 'PCSC362R'                           
                    CONTINUE                                            
                 ELSE                                                   
                    PERFORM 8090-UPDATE-PYMT-TRANS                      
                                        THRU 8090-EXIT                  
                 END-IF                                                 
C34416           IF S-DNP-FLAG = 'Y'                                    
C34416              MOVE I-CASH-LOCAL-OFFICE  TO JT-CASH-LOCAL-OFFICE   
C34416              MOVE CS-DATE-CASH-REPORT  TO JT-DATE-CASH-REPORT    
C34416              MOVE I-TIMESTAMP          TO JT-ORIG-PYMT-TS        
A00575              MOVE 'Z'                  TO JT-ERROR-CD(1:1)       
C34416              PERFORM 8300-UPDATE-ERROR-FLAG                      
C34416                 THRU 8300-EXIT                                   
C34416           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                 
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10700000
      ******************************************************************05510000
      * 2100-PROCESS-VALIDATION.                                       *05520000
      ******************************************************************05590000
       2100-PROCESS-VALIDATION.                                         
      *                                                                 10700000
           MOVE 100                     TO S-RETURN-CODE                
      *                                                                 10700000
      *    EXEC SQL CALL CSR03487                                       
      *                ( :I-TIMESTAMP                                   
      *                 ,:I-ACCOUNT-NO                                  
      *                 ,:WS-COMPANY-NO                                 
      *                 ,:I-CASH-LOCAL-OFFICE                           
      *                 ,:I-CURRENCY-TYPE                               
      *                 ,:I-PAYMENT-AMOUNT                              
      *                 ,:I-REPORT-DATE                                 
      *                 ,:I-PYMT-FACILITY-CD                            
      *                 ,:I-PYMT-INDICATOR                              
      *                 ,:I-CONFIRMATION-NO                             
      *                 ,:I-PROGRAM-ID                                  
      *                 ,:I-USER-ID                                     
      *                 ,:I-COMMENTS                                    
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                 10700000
           IF SQLCODE = 466 THEN                                        
      *                                                                 10700000
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
      *         CSR03487                                                
      *       END-EXEC                                                  
      *                                                                 10700000
      *       EXEC SQL ALLOCATE C2 CURSOR FOR RESULT SET :LOC1          
      *       END-EXEC                                                  
      *                                                                 10700000
              EXEC SQL                                                  
              FETCH C2 INTO :S-RETURN-CODE                              
                           ,:S-ERROR-CD                                 
                           ,:S-TIMESTAMP                                
                           ,:S-PYMT-TIMESTAMP                           
                           ,:S-XFER-TO                                  
                           ,:S-COMPANY-NO                               
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              MOVE S-RETURN-CODE        TO RS-RETURN-CODE               
      *                                                                         
              EXEC SQL                                                  
                CLOSE C2                                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10700000
      ******************************************************************05510000
      * 2200-PROCESS-REVERSAL.                                         *05520000
      ******************************************************************05590000
       2200-PROCESS-REVERSAL.                                           
      *                                                                 05590000
           MOVE 100                     TO S-RETURN-CODE                
      *                                                                 05590000
           IF S-XFER-TO > 0                                             
              MOVE S-XFER-TO            TO WS-ACCOUNT-NO                
              MOVE WS-ACCOUNT-NO        TO WS-ACCOUNT-NO-CHAR           
           ELSE                                                         
              MOVE I-ACCOUNT-NO         TO WS-ACCOUNT-NO-CHAR           
           END-IF                                                       
      *                                                                 05590000
      *    EXEC SQL CALL CSR03486                                       
      *                ( :WS-ACCOUNT-NO-CHAR                            
      *                 ,:S-PYMT-TIMESTAMP                              
      *                 ,:I-PROGRAM-ID                                  
      *                 ,:I-USER-ID                                     
      *                 ,:I-COMMENTS                                    
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C3
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C3
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C3 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                 05590000
           IF SQLCODE = 466 THEN                                        
      *                                                                 05590000
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
      *         CSR03486                                                
      *       END-EXEC                                                  
      *                                                                 05590000
      *       EXEC SQL ALLOCATE C3 CURSOR FOR RESULT SET :LOC1          
      *       END-EXEC                                                  
      *                                                                 05590000
              EXEC SQL                                                  
              FETCH C3 INTO :S-RETURN-CODE                              
                           ,:S-DNP-FLAG                                 
                           ,:S-AR-LOCKOUT-IND                           
                           ,:S-ACCT-XFER-TO                             
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05590000
              MOVE S-RETURN-CODE TO RS-RETURN-CODE                      
      *                                                                 05590000
              EXEC SQL                                                  
                CLOSE C3                                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF.                                                      
      *                                                                 05590000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05590000
      ******************************************************************05510000
      * 2300-MOVE-TRAN-DATA-VALUES                                     *05520000
      *                                                                *05520000
      *  MOVE VALUES TO 101 JOURNAL VARIABLES                          *        
      ******************************************************************05590000
       2300-MOVE-TRAN-DATA-VALUES.                                      
      *                                                                         
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO        
           MOVE WS-PYMT-AMOUNT          TO WS-101-AMOUNT-ENTERED        
           MOVE SPACES                  TO WS-101-AR-AGE                
                                           WS-101-CASH-DRAWER-USED      
                                           WS-101-DATE-AR-BILLED        
                                           WS-101-FCS-DEP-BANK-CD       
                                           WS-101-FCS-DEP-BANK-ST-CD    
                                           WS-101-FUNCTION-CODE         
                                           WS-101-CODE-REVENUE-DISTRICT 
                                           WS-101-CODE-EMPL-ACCT        
                                           WS-101-CODE-COMPANY-ACCT     
                                           WS-101-CODE-ACCOUNT-STATUS   
                                           WS-101-CODE-PREMISE-STATUS   
           MOVE ZERO                    TO WS-101-ITEM-DETAIL-DATA      
                                           WS-101-ITEM-ID-NO            
                                           WS-101-DETAIL-END-BAL        
                                           WS-101-DETAIL-END-AR-BAL     
                                           WS-101-ACCT-END-AR-BAL       
                                           WS-101-REVENUE-MONTH         
           .                                                            
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 2600-THIRD-PARTY-JRNL.                                         *05520000
      ******************************************************************05590000
       2600-THIRD-PARTY-JRNL.                                           
      *                                                                         
           MOVE '01'                    TO WS-JRNL-OL-COMPANY           
           MOVE I-CASH-LOCAL-OFFICE     TO CS-CASH-LOCAL-OFFICE         
           PERFORM 7250-SELECT-EPAYCURRDT                               
                                        THRU 7250-EXIT                  
           MOVE G6-PARM-DATA            TO CS-DATE-CASH-REPORT          
           PERFORM 7000-SELECT-ACTIVE-DRWR                              
                                        THRU 7000-EXIT.                 
           MOVE WS-C                    TO WS-TRAN-JRNL-TYPE            
           MOVE CS-CASH-LOCAL-OFFICE    TO WS-JRNL-OL-LOC-OFF           
                                           WS-JRNL-OL-REPORT-NO         
           MOVE CS-DATE-CASH-REPORT     TO WS-JRNL-OL-REPORT-DT         
           MOVE CS-CASH-DRAWER-ID       TO WS-JRNL-OL-CASH-DRWR         
           MOVE SPACES                  TO WS-JRNL-OL-CSR-PC-ID         
           MOVE WS-TERM-LOC             TO WS-JRNL-OL-TERM-LOC          
                                           WS-JRNL-OL-CASH-LOC          
                                           WS-JRNL-OL-OPR-LOC           
           MOVE WS-JRNL-VALIDATE-OPER   TO WS-JRNL-OPERATION-RQST       
           MOVE WS-C                    TO WS-JRNL-SOURCE-CODE          
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE  TO WS-JRNL-OL-AUTH-TYPE         
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE                              
                                        TO WS-JRNL-OL-AUTH-TYPE         
           END-IF                                                       
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
                                        THRU 6400-EXIT                  
           MOVE I-CASH-LOCAL-OFFICE     TO Y2-CASH-LOCAL-OFFICE         
           MOVE I-CASH-LOCAL-OFFICE     TO CS-CASH-LOCAL-OFFICE         
           PERFORM 7100-GET-USER-ID     THRU 7100-EXIT                  
           MOVE Y2-USER-ID              TO WS-JRNL-OL-PERM-ID           
           MOVE WS-A                    TO WS-100-JRNL-SORT-ID          
           MOVE ZEROES                  TO WS-100-ACCT-NO               
           MOVE ZEROES                  TO WS-100-CUSTOMER-NO           
           MOVE ZEROES                  TO WS-100-PREMISE-NO            
           ADD 1                        TO WS-100-JRNL-TRAN-APPL-NO     
           MOVE WS-CURRENT-DATE         TO WS-100-DATE-LAST-ACTION      
           MOVE WS-C                    TO WS-100-CODE-ENTRY-SOURCE     
           MOVE Y2-LOCAL-OFFICE         TO WS-100-LOCAL-OFFICE-CD       
           MOVE 30                      TO WS-JRNL-TRAN-COMMENT-LEN     
           MOVE I-COMMENTS              TO WS-JRNL-TRAN-COMMENT-TEXT    
           INITIALIZE CJF00101                                          
           MOVE I-PAYMENT-AMOUNT        TO WS-PYMT-AMOUNT9              
           COMPUTE WS-PYMT-AMOUNT     = WS-PYMT-AMOUNT9 /100 END-COMPUTE
                                                                        
           MOVE I-CURRENCY-TYPE         TO WS-JRNL-CURRENCY-TYPE        
           MOVE WS-PYMT-AMOUNT          TO WS-101-AMT-POSTED            
           PERFORM 2300-MOVE-TRAN-DATA-VALUES                           
                                        THRU 2300-EXIT                  
           MOVE Y2-DEP-CASH-GL-OFFSET   TO WS-101-ACCT-GEN-LED-CR       
           MOVE 184.2000                TO WS-101-ACCT-GEN-LED-DR       
           MOVE WS-JRNL-NAME            TO WS-100-CODE-TERMINAL-TRAN    
                                                                        
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA     
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST       
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
                                        THRU 6400-EXIT                  
           MOVE WS-JRNL-CNTRL-ONLY      TO WS-JRNL-OPERATION-RQST       
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
                                        THRU 6400-EXIT                  
           .                                                            
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 2700-PROCESS-OVSH.                                             *05520000
      * INSERT/UPDATE OVERSHORT AMOUNT FOR THE PAYMENT                 *        
      ******************************************************************05590000
       2700-PROCESS-OVSH.                                               
      *                                                                         
           MOVE '01'                    TO OH-CASH-COMPANY-NO           
           MOVE CS-CASH-LOCAL-OFFICE    TO OH-CASH-LOCAL-OFFICE         
           MOVE CS-DATE-CASH-REPORT     TO OH-DATE-CASH-REPORT          
           MOVE CS-CASH-DRAWER-ID       TO OH-CASH-DRAWER-ID            
           MOVE 1                       TO OH-OVERSHORT-ID              
           PERFORM 7200-SELECT-OVSH     THRU 7200-EXIT                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
APS           IF OH-OVERSHORT-DR-CR = 'D'                               
APS              COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT -          
APS                                         WS-PYMT-AMOUNT              
APS              IF OH-OVERSHORT-AMT > 0                                
APS                 MOVE 'D'                 TO OH-OVERSHORT-DR-CR      
APS              ELSE                                                   
APS                 MOVE 'C'                 TO OH-OVERSHORT-DR-CR      
APS                 COMPUTE OH-OVERSHORT-AMT = (OH-OVERSHORT-AMT * -1)  
APS              END-IF                                                 
APS           ELSE                                                      
APS              COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT +          
APS                                         WS-PYMT-AMOUNT              
APS              MOVE 'C'                 TO OH-OVERSHORT-DR-CR         
APS           END-IF                                                    
              PERFORM 8080-UPDATE-OVERSHORT                             
                                        THRU 8080-EXIT                  
           ELSE                                                         
              PERFORM 2800-MOVE-DTL-TO-OVSH                             
                                        THRU 2800-EXIT                  
              PERFORM 8070-INSERT-OVERSHORT                             
                                        THRU 8070-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 2700-PROCESS-OVSH.                                             *05520000
      * MOVE DETAILS TO OVERSHORT                                    *          
      ******************************************************************05590000
       2800-MOVE-DTL-TO-OVSH.                                           
      *                                                                         
           MOVE WS-SYSTEM               TO OH-USER-ID                   
           MOVE 30                      TO OH-TRAN-COMMENT-LEN          
           MOVE I-COMMENTS              TO OH-TRAN-COMMENT-TEXT         
           MOVE WS-P                    TO OH-OVERSHORT-SOLTN-FL        
           MOVE WS-PYMT-AMOUNT          TO OH-OVERSHORT-AMT             
           MOVE WS-C                    TO OH-OVERSHORT-DR-CR           
           MOVE Y2-DEP-CASH-GL-OFFSET   TO OH-GL-ACCT-NO                
                                           OT-GL-ACCT-NO                
                                           WS-DISP-GL-ACCT              
           PERFORM 7210-OPEN-OVSH-TYPE  THRU 7210-EXIT                  
           PERFORM 7220-FETCH-OVSH-TYPE THRU 7220-EXIT                  
           PERFORM 7230-CLOSE-OVSH-TYPE THRU 7230-EXIT                  
           MOVE OT-OVERSHORT-TYPE-CD    TO OH-OVERSHORT-TYPE-CD         
           MOVE 1                       TO OH-OVERSHORT-ID              
           MOVE ZERO                    TO OH-OFST-OVERSHORT-AMT        
                                           OH-ACCOUNT-NO                
           MOVE SPACES                  TO OH-OFST-DR-CR                
           .                                                            
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 7000-SELECT-ACTIVE-DRWR                                        *05520000
      * SELECTS ACTIVE CASH DRAWER ID FOR GIVEN CASH LOCAL OFFICE AND  *        
      * DATE CASH REPORT                                               *        
      ******************************************************************05590000
       7000-SELECT-ACTIVE-DRWR.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT CASH_DRAWER_ID                                      
                   ,DATE_CASH_REPORT                                    
               INTO :CS-CASH-DRAWER-ID                                  
                   ,:CS-DATE-CASH-REPORT                                
               FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO     = '01'                          
                AND CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE         
                AND DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
                AND CODE_CSH_DRWR_STAT  = 'A'                           
                AND CASH_DRAWER_ID      < 500                           
T35434                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASH_DRAWER_ID                                              
MFA-TR*            ,DATE_CASH_REPORT                                            
MFA-TR*        INTO :CS-CASH-DRAWER-ID                                          
MFA-TR*            ,:CS-DATE-CASH-REPORT                                        
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO     = '01'                                  
MFA-TR*         AND CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE                 
MFA-TR*         AND DATE_CASH_REPORT    = :CS-DATE-CASH-REPORT                  
MFA-TR*         AND CODE_CSH_DRWR_STAT  = 'A'                                   
MFA-TR*         AND CASH_DRAWER_ID      < 500                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE     =  SUCCESSFUL-CALL              
                                        OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CSH_DRWR_CNTL'  TO TABLE-1                      
              MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-1              
              MOVE CS-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-1            
              MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-2              
              MOVE CS-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-2            
              MOVE 'CODE_CSH_DRWR_STAT' TO TABLE-ELEMENT-3              
              MOVE CS-CODE-CSH-DRWR-STAT                                
                                        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 7100-GET-USER-ID                                               *05520000
      * GET USER ID USING CASH LOCAL OFFICE                            *        
      ******************************************************************05590000
       7100-GET-USER-ID.                                                
      *                                                                         
           EXEC SQL                                                     
             SELECT USER_ID                                             
                   ,DEP_CASH_GL_OFFSET                                  
                   ,LOCAL_OFFICE                                        
                   ,PAYMENT_AGENT_FL                                    
               INTO :Y2-USER-ID                                         
                   ,:Y2-DEP-CASH-GL-OFFSET                              
                   ,:Y2-LOCAL-OFFICE                                    
                   ,:Y2-PAYMENT-AGENT-FL                                
               FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO     = '01'                          
                AND CASH_LOCAL_OFFICE   = :Y2-CASH-LOCAL-OFFICE         
T35434                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*            ,DEP_CASH_GL_OFFSET                                          
MFA-TR*            ,LOCAL_OFFICE                                                
MFA-TR*            ,PAYMENT_AGENT_FL                                            
MFA-TR*        INTO :Y2-USER-ID                                                 
MFA-TR*            ,:Y2-DEP-CASH-GL-OFFSET                                      
MFA-TR*            ,:Y2-LOCAL-OFFICE                                            
MFA-TR*            ,:Y2-PAYMENT-AGENT-FL                                        
MFA-TR*        FROM CSS_CASHIER_OFFICE                                          
MFA-TR*       WHERE CASH_COMPANY_NO     = '01'                                  
MFA-TR*         AND CASH_LOCAL_OFFICE   = :Y2-CASH-LOCAL-OFFICE                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '7100'              TO ACTIVE-PARAGRAPH             
               MOVE 'SELECT'            TO ABEND-FUNCTION               
               MOVE SPACES              TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
               MOVE 'CSS_CASHIER_OFFICE'                                
                                        TO TABLE-1                      
               MOVE 'CASH_COMPANY_NO'   TO TABLE-ELEMENT-1              
               MOVE 'CASH_LOCAL_OFFICE' TO TABLE-ELEMENT-2              
               MOVE Y2-CASH-COMPANY-NO  TO HOSTVAR-ELEMENT-1            
               MOVE Y2-CASH-LOCAL-OFFICE                                
                                        TO HOSTVAR-ELEMENT-2            
               PERFORM 9000-SEND-ERROR-RESULT                           
                                        THRU 9000-EXIT                  
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 7150-GET-CURRENT-INFO                                          *05520000
      * GET CURRENT TIMESTAMP, DATE AND TIME                           *        
      ******************************************************************05590000
       7150-GET-CURRENT-INFO.                                           
      *                                                                         
           EXEC SQL                                                     
T35434       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-TIME,
              :WS-CURRENT-DATE                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET  :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*          ,:WS-CURRENT-TIME      = CURRENT TIME                          
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '7150'              TO ACTIVE-PARAGRAPH             
T35434         MOVE 'SET'               TO ABEND-FUNCTION               
               MOVE SPACES              TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
               PERFORM 9000-SEND-ERROR-RESULT                           
                                        THRU 9000-EXIT                  
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 7200-SELECT-OVSH.                                              *05520000
      ******************************************************************05590000
       7200-SELECT-OVSH.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT OVERSHORT_AMT,                                     
                     OVERSHORT_DR_CR                                    
               INTO :OH-OVERSHORT-AMT,                                  
                    :OH-OVERSHORT-DR-CR                                 
               FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO     = :OH-CASH-COMPANY-NO           
                AND CASH_LOCAL_OFFICE   = :OH-CASH-LOCAL-OFFICE         
                AND DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )          
                AND CASH_DRAWER_ID      = :OH-CASH-DRAWER-ID            
                AND OVERSHORT_ID        = :OH-OVERSHORT-ID              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT OVERSHORT_AMT,                                             
MFA-TR*              OVERSHORT_DR_CR                                            
MFA-TR*        INTO :OH-OVERSHORT-AMT,                                          
MFA-TR*             :OH-OVERSHORT-DR-CR                                         
MFA-TR*        FROM CSS_OVERSHORT_HDR                                           
MFA-TR*       WHERE CASH_COMPANY_NO     = :OH-CASH-COMPANY-NO                   
MFA-TR*         AND CASH_LOCAL_OFFICE   = :OH-CASH-LOCAL-OFFICE                 
MFA-TR*         AND DATE_CASH_REPORT    = :OH-DATE-CASH-REPORT                  
MFA-TR*         AND CASH_DRAWER_ID      = :OH-CASH-DRAWER-ID                    
MFA-TR*         AND OVERSHORT_ID        = :OH-OVERSHORT-ID                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE     =  SUCCESSFUL-CALL              
                                        OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_OVERSHORT_HDR'  TO TABLE-1                      
              MOVE 'CASH_COMPANY_NO'    TO TABLE-ELEMENT-1              
              MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-2              
              MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-3              
              MOVE 'CASH_DRAWER_ID'     TO TABLE-ELEMENT-4              
              MOVE OH-CASH-COMPANY-NO   TO HOSTVAR-ELEMENT-1            
              MOVE OH-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-2            
              MOVE OH-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-3            
              MOVE OH-CASH-DRAWER-ID    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 7210-OPEN-OVSH-TYPE.                                           *05520000
      * OPEN  OVERSHORT TYPE CURSOR                                    *        
      ******************************************************************05590000
       7210-OPEN-OVSH-TYPE.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN OVSHTYPE_CURSOR                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE     EQUAL SUCCESSFUL-CALL           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7210'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_OVERSHORT_TYPE' TO TABLE-1                      
              MOVE 'GL_ACCT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-DISP-GL-ACCT      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 7220-FETCH-OVSH-TYPe.                                          *05520000
      * FETCH OVERSHORT TYPE CURSOR                                    *        
      ******************************************************************05590000
       7220-FETCH-OVSH-TYPE.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH OVSHTYPE_CURSOR                                     
               INTO :OT-OVERSHORT-TYPE-CD                               
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7220'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_OVERSHORT_TYPE' TO TABLE-1                      
              MOVE 'GL_ACCT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-DISP-GL-ACCT      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 7230-FETCH-OVSH-TYPe.                                          *05520000
      * CLOSE OVERSHORT TYPE CURSOR                                    *        
      ******************************************************************05590000
       7230-CLOSE-OVSH-TYPE.                                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE OVSHTYPE_CURSOR                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL SUCCESSFUL-CALL           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7230'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_OVERSHORT_TYPE' TO TABLE-1                      
              MOVE 'GL_ACCT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-DISP-GL-ACCT      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 7250-SELECT=EPAYCURRDT.                                        *05520000
      * SELECTING EPAYCURRDT FROM CSS_JOB_PARM                         *        
      ******************************************************************05590000
       7250-SELECT-EPAYCURRDT.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT PARM_DATA                                           
               INTO :G6-PARM-DATA                                       
               FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                          
              WHERE PROGRAM_NAME        = 'EPAYCURRDT'                  
                AND COMPANY_NO          = '01'                          
                AND CMND_CODE           = 'DATE'                        
                AND SEQ_NO              = 10                            
                AND STATUS              = 'A'                           
T35434                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PARM_DATA                                                   
MFA-TR*        INTO :G6-PARM-DATA                                               
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE PROGRAM_NAME        = 'EPAYCURRDT'                          
MFA-TR*         AND COMPANY_NO          = '01'                                  
MFA-TR*         AND CMND_CODE           = 'DATE'                                
MFA-TR*         AND SEQ_NO              = 10                                    
MFA-TR*         AND STATUS              = 'A'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE     EQUAL SUCCESSFUL-CALL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE                                
                                        TO RS-RETURN-CODE               
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7250'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM     '  TO TABLE-1                      
              MOVE 'PROGRAM_NAME     '  TO TABLE-ELEMENT-1              
              MOVE 'EPAYCURRDT'         TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 8070-INSERT-OVERSHORT                                          *05520000
      ******************************************************************05590000
       8070-INSERT-OVERSHORT.                                           
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_OVERSHORT_HDR                           
                       (                                                
                        CASH_COMPANY_NO                                 
                       ,CASH_LOCAL_OFFICE                               
                       ,DATE_CASH_REPORT                                
                       ,CASH_DRAWER_ID                                  
                       ,USER_ID                                         
                       ,OVERSHORT_ID                                    
                       ,TRAN_TS                                         
                       ,OVERSHORT_AMT                                   
                       ,OVERSHORT_DR_CR                                 
                       ,OFST_OVERSHORT_AMT                              
                       ,OFST_DR_CR                                      
                       ,GL_ACCT_NO                                      
                       ,LAST_UPDATE_TS                                  
                       ,OVERSHORT_TYPE_CD                               
                       ,OVERSHORT_SOLTN_FL                              
                       ,TRAN_COMMENT                                    
                       ,ACCOUNT_NO                                      
                       )                                                
                VALUES                                                  
                       (                                                
                        :OH-CASH-COMPANY-NO                             
                       ,:OH-CASH-LOCAL-OFFICE                           
                       ,IIF(TRY_CONVERT(DATE, :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )                         
                       ,:OH-CASH-DRAWER-ID                              
                       ,:OH-USER-ID                                     
                       ,:OH-OVERSHORT-ID                                
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:OH-OVERSHORT-AMT                               
                       ,:OH-OVERSHORT-DR-CR                             
                       ,:OH-OFST-OVERSHORT-AMT                          
                       ,:OH-OFST-DR-CR                                  
                       ,:OH-GL-ACCT-NO                                  
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:OH-OVERSHORT-TYPE-CD                           
                       ,:OH-OVERSHORT-SOLTN-FL                          
                       ,:OH-TRAN-COMMENT                                
                       ,:OH-ACCOUNT-NO                                  
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_OVERSHORT_HDR                                   
MFA-TR*                (                                                        
MFA-TR*                 CASH_COMPANY_NO                                         
MFA-TR*                ,CASH_LOCAL_OFFICE                                       
MFA-TR*                ,DATE_CASH_REPORT                                        
MFA-TR*                ,CASH_DRAWER_ID                                          
MFA-TR*                ,USER_ID                                                 
MFA-TR*                ,OVERSHORT_ID                                            
MFA-TR*                ,TRAN_TS                                                 
MFA-TR*                ,OVERSHORT_AMT                                           
MFA-TR*                ,OVERSHORT_DR_CR                                         
MFA-TR*                ,OFST_OVERSHORT_AMT                                      
MFA-TR*                ,OFST_DR_CR                                              
MFA-TR*                ,GL_ACCT_NO                                              
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,OVERSHORT_TYPE_CD                                       
MFA-TR*                ,OVERSHORT_SOLTN_FL                                      
MFA-TR*                ,TRAN_COMMENT                                            
MFA-TR*                ,ACCOUNT_NO                                              
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :OH-CASH-COMPANY-NO                                     
MFA-TR*                ,:OH-CASH-LOCAL-OFFICE                                   
MFA-TR*                ,:OH-DATE-CASH-REPORT                                    
MFA-TR*                ,:OH-CASH-DRAWER-ID                                      
MFA-TR*                ,:OH-USER-ID                                             
MFA-TR*                ,:OH-OVERSHORT-ID                                        
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:OH-OVERSHORT-AMT                                       
MFA-TR*                ,:OH-OVERSHORT-DR-CR                                     
MFA-TR*                ,:OH-OFST-OVERSHORT-AMT                                  
MFA-TR*                ,:OH-OFST-DR-CR                                          
MFA-TR*                ,:OH-GL-ACCT-NO                                          
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:OH-OVERSHORT-TYPE-CD                                   
MFA-TR*                ,:OH-OVERSHORT-SOLTN-FL                                  
MFA-TR*                ,:OH-TRAN-COMMENT                                        
MFA-TR*                ,:OH-ACCOUNT-NO                                          
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE     = SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8070'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_OVERSHORT_HDR'  TO TABLE-1                      
              MOVE 'CASH_COMPANY_NO'    TO TABLE-ELEMENT-1              
              MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-2              
              MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-3              
              MOVE 'CASH_DRAWER_ID'     TO TABLE-ELEMENT-4              
              MOVE OH-CASH-COMPANY-NO   TO HOSTVAR-ELEMENT-1            
              MOVE OH-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-2            
              MOVE OH-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-3            
              MOVE OH-CASH-DRAWER-ID    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       8070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05510000
      * 8080-UPDATE-OVERSHORT                                          *05520000
      ******************************************************************05590000
       8080-UPDATE-OVERSHORT.                                           
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_OVERSHORT_HDR                                   
                SET OVERSHORT_AMT       = :OH-OVERSHORT-AMT             
                   ,OVERSHORT_DR_CR     = :OH-OVERSHORT-DR-CR           
                   ,LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()             
              WHERE CASH_COMPANY_NO     = :OH-CASH-COMPANY-NO           
                AND CASH_LOCAL_OFFICE   = :OH-CASH-LOCAL-OFFICE         
                AND DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )          
                AND CASH_DRAWER_ID      = :OH-CASH-DRAWER-ID            
                AND OVERSHORT_ID        = :OH-OVERSHORT-ID              
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_OVERSHORT_HDR                                           
MFA-TR*         SET OVERSHORT_AMT       = :OH-OVERSHORT-AMT                     
MFA-TR*            ,OVERSHORT_DR_CR     = :OH-OVERSHORT-DR-CR                   
MFA-TR*            ,LAST_UPDATE_TS      = CURRENT TIMESTAMP                     
MFA-TR*       WHERE CASH_COMPANY_NO     = :OH-CASH-COMPANY-NO                   
MFA-TR*         AND CASH_LOCAL_OFFICE   = :OH-CASH-LOCAL-OFFICE                 
MFA-TR*         AND DATE_CASH_REPORT    = :OH-DATE-CASH-REPORT                  
MFA-TR*         AND CASH_DRAWER_ID      = :OH-CASH-DRAWER-ID                    
MFA-TR*         AND OVERSHORT_ID        = :OH-OVERSHORT-ID                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE     = SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8080'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_OVERSHORT_HDR'  TO TABLE-1                      
              MOVE 'CASH_COMPANY_NO'    TO TABLE-ELEMENT-1              
              MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-2              
              MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-3              
              MOVE 'CASH_DRAWER_ID'     TO TABLE-ELEMENT-4              
              MOVE OH-CASH-COMPANY-NO   TO HOSTVAR-ELEMENT-1            
              MOVE OH-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-2            
              MOVE OH-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-3            
              MOVE OH-CASH-DRAWER-ID    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       8080-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************05510000
      * 8090-UPDATE-PYMT-TRANS                                         *05520000
      ******************************************************************05590000
       8090-UPDATE-PYMT-TRANS.                                          
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_PAYMENT_TRANS                                   
                SET APPLIED_TS          = CIS.CURRENT$TIMESTAMP()             
                   ,APPLIED_FL          = 'Y'                           
              WHERE ACCOUNT_NO          = :JT-ACCOUNT-NO                
                AND PYMT_RCVD_TS        = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )              
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_PAYMENT_TRANS                                           
MFA-TR*         SET APPLIED_TS          = CURRENT TIMESTAMP                     
MFA-TR*            ,APPLIED_FL          = 'Y'                                   
MFA-TR*       WHERE ACCOUNT_NO          = :JT-ACCOUNT-NO                        
MFA-TR*         AND PYMT_RCVD_TS        = :JT-PYMT-RCVD-TS                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE     = SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8090'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_PAYMENT_TRANS'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_RCVD_TS    '   TO TABLE-ELEMENT-2              
              MOVE I-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1            
              MOVE JT-PYMT-RCVD-TS      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
      *                                                                         
       8090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-UPDATE-ERROR-FLAG                                         *        
      ******************************************************************        
       8300-UPDATE-ERROR-FLAG.                                          
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_PAYMENT_TRANS                                   
                SET ERROR_CD           = :JT-ERROR-CD                   
              WHERE ACCOUNT_NO         = :JT-ACCOUNT-NO                 
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )           
                AND ORIG_PYMT_TS       = CIS.CHAR2TIMESTAMP(
                                                       :JT-ORIG-PYMT-TS
              )               
                AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE          
                AND TRANS_TYPE_CD      = 'R'                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_PAYMENT_TRANS                                           
MFA-TR*         SET ERROR_CD           = :JT-ERROR-CD                           
MFA-TR*       WHERE ACCOUNT_NO         = :JT-ACCOUNT-NO                         
MFA-TR*         AND DATE_CASH_REPORT   = :JT-DATE-CASH-REPORT                   
MFA-TR*         AND ORIG_PYMT_TS       = :JT-ORIG-PYMT-TS                       
MFA-TR*         AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE                  
MFA-TR*         AND TRANS_TYPE_CD      = 'R'                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE     = SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_PAYMENT_TRANS'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-2              
              MOVE 'ORIG_PYMT_TS'       TO TABLE-ELEMENT-3              
              MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-4              
              MOVE I-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1            
              MOVE JT-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-2            
              MOVE JT-ORIG-PYMT-TS      TO HOSTVAR-ELEMENT-3            
              MOVE JT-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF                                                       
           .                                                            
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *---------------------------------------------------------------*         
      *   OPEN THE RESULT SET CURSOR                                  *         
      *---------------------------------------------------------------*         
       8900-SEND-DONE.                                                  
      *                                                                         
           MOVE RS-RETURN-CODE          TO S-RETURN-CODE                
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
           .                                                            
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * SENDS ERROR RESULT                                            *         
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
                                           S-RETURN-CODE                
                                           ABEND-SQLCODE.               
      *                                                                         
             EXEC SQL                                                   
               ROLLBACK                                                 
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             IF SQLCODE = 0                                             
                CONTINUE                                                
             ELSE                                                       
                MOVE 'ROLLBACK'         TO ABEND-FUNCTION               
             END-IF.                                                    
      *                                                                         
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           IF CTR-ROWS < 1                                              
      *---------------------------------------------------------------*         
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!    *         
      *---------------------------------------------------------------*         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF                                                       
      *                                                                         
           
MSQ016        GOBACK                                                     
           .                                                            
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0006A                                                  
           END-EXEC.                                                            
      *                                                                         
