       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03487.                                         
COB303 DATE-WRITTEN.  SEP 9,04.                                         
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      * A) THIS PROGRAM ENTERS REVERSALS INTO CSS_PAYMENT_TRANS & ALSO *00100000
      *    DOES VALIDATIONS FOR DOING REVERSALS.                       *00100000
      * B) THIS IS INVOKED FROM CSR03488.                              *00100000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  09/15/04    PD       PROCEDURE ORIGINALLY CODED.              *00280000
      *  04/07/05  SK88120    IMPLEMENT STANDARDS.                     *00280000
      *  05/26/05  SK88120    CHANGES WERE MADE TO UPDATE ERROR CD FOR *00280000
      *                       REVERSAL TRANSACTION ONLY                *00280000
A00575*  01/20/09  BASKAR V   STORE CREDIT ACTION FLAG IN ERROR_CD     *        
A00575*                       FIELD OF CSS_PAYMENT_TRANS TABLE, HANDLE *        
A00575*                       ERROR_CD FIELD FOR THAT.                 *        
      ******************************************************************00470000
      *                                                                *00480000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00490000
      *                                                                *00500000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00510000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00520000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00530000
      *  3000 - 4999  NOT USED                                         *00540000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00550000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00560000
      *  7000 - 7999  INPUT MODULES                                    *00570000
      *  8000 - 8999  OUTPUT MODULES                                   *00580000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00590000
      *                                                                *00600000
      ******************************************************************00610000
      *                                                                 00620000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
      *                                                                 00650000
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03487'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(50) VALUE                  
           'WORKING STORAGE FOR CSR03487 STARTS HERE'.                  
      *                                                                 00690000
      ******************************************************************00700000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00710000
      ******************************************************************00720000
      *                                                                 00730000
           COPY CWS00303.                                               00820000
           COPY CWS00100.                                               00830000
           COPY CJF00101.                                               00840000
           COPY CJF00102.                                               00850000
      *                                                                 00860000
      ******************************************************************00870000
      *    WORK AREAS                                                  *00880000
      ******************************************************************00890000
      *                                                                 00900000
       01 WS-MISC.                                                      
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR03487'.      
           05 WS-ACCOUNT-NO            PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
COB305     05 WS-ACCOUNT-NO-JT        PIC S9(13) COMP-3 VALUE 0.               
           05 WS-AMOUNT-9              PIC 9(11)V99.                    
           05 WS-AMOUNT9-2             PIC 9(11)V99.                    
           05 WS-CURRENT-DATE          PIC X(10).                       
           05 WS-CURRENT-TIMESTAMP     PIC X(26).                       
           05 WS-DATE                  PIC X(10).                       
           05 WS-TIME                  PIC X(08).                       
           05 WS-APPLIED-FL            PIC X(01) VALUE SPACES.          
           05 WS-NULL-IND1             PIC S9(4) COMP VALUE 0.          
           05 WS-NULL-IND2             PIC S9(4) COMP VALUE 0.          
           05 WS-NULL-IND3             PIC S9(4) COMP VALUE 0.          
           05 WS-CASH-LOCAL-OFFICE     PIC X(03).                       
           05 WS-PYMT-RCVD-TS          PIC x(26).                       
           05 WS-DATABASE-SW           PIC 9(01) VALUE 0.               
              88 CSR-DATABASE                    VALUE 1.               
              88 SEB-DATABASE                    VALUE 2.               
           05 WS-DATABASE              PIC X(08) VALUE 'DATABASE'.      
           05 WS-MULTIPLE-ROWS         PIC S9(04) COMP VALUE -811.      
           05 WS-ROW-EXIST             PIC S9(04) COMP VALUE -803.      
      *                                                                 01270000
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 01750000
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE +0.         
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE +0.         
           05  S-ERROR-CODE            PIC X(01) VALUE ' '.             
           05  S-TIMESTAMP             PIC X(26) VALUE ' '.             
           05  S-PYMT-TIMESTAMP        PIC X(26) VALUE ' '.             
COB305     05 S-XFER-TO        PIC S9(13)V COMP-3 VALUE 0.              
           05  S-COMPANY-NO            PIC X(04) VALUE ' '.             
      *                                                                 01980000
      ************************                                          01980000
      *     S Q L C A        *                                          01980000
      ************************                                          01980000
           EXEC SQL                                                     01990000
              INCLUDE SQLCA                                             02000000
           END-EXEC.                                                    02010000
      *************************                                         01980000
      * CSS_MODEL_SQL      MS *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02030000
              INCLUDE TBMODEL                                           02040000
           END-EXEC.                                                    02050000
      *************************                                         01980000
      * CSS_JOB_PARM       G6 *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *************************                                         01980000
      * CSS_AR_LOCKOUT     AL *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02030000
              INCLUDE TBARLOCK                                          02040000
           END-EXEC.                                                    02050000
      *************************                                         01980000
      * CSS_ACCOUNT        AT *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02030000
              INCLUDE TBACCT                                            02040000
           END-EXEC.                                                    02050000
      *************************                                         01980000
      * CSS_DELINQUENCY    C8 *                                         01980000
      *************************                                         01980000
      * CSS_DELINQUENCY                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *************************                                         01980000
      * CSS_USER_PROFILE   PF *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02790000
              INCLUDE TBUSRPRF                                          02800000
           END-EXEC.                                                    02810000
      *************************                                         01980000
      * CSS_CSH_DRWR_CNTL  CS *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE TBCDCNTL                                          01533000
           END-EXEC.                                                    01534000
      *************************                                         01980000
      * CSS_LOCAL_OFFICE   B1 *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE TBLOCOFC                                          01533000
           END-EXEC.                                                    01534000
      *************************                                         01980000
      * CSS_CASHIER_OFFICE Y2 *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE TBCSHOFF                                          01533000
           END-EXEC.                                                    01534000
      *************************                                         01980000
      * CSS_PAYMENT_TRANS  JT *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE TBPMTRAN                                          01533000
           END-EXEC.                                                    01534000
      *************************                                         01980000
      * CSS_AR_TRANS_HIST  AR *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE TBARHIST                                          01533000
           END-EXEC.                                                    01534000
      *************************                                         01980000
      * CSS_COMM_DATA      KO *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                             
               INCLUDE TBCOMDAT                                                 
           END-EXEC.                                                            
      *************************                                         01980000
      * CSS_MKT_XREF_ACCT  KO *                                         01980000
      *************************                                         01980000
      * CSS_MKT_XREF_ACCT                                                       
           EXEC SQL                                                             
               INCLUDE TBMRKXR                                                  
           END-EXEC.                                                            
      *************************                                         01980000
      *   C W S X 0 0 1 0     *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE CWSX0010                                          01533000
           END-EXEC.                                                    01534000
      *************************                                         01980000
      *   C W S 0 0 0 1 3     *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03310000
              INCLUDE CWS00013                                          03320000
           END-EXEC.                                                    03330000
      *                                                                 01980000
       LINKAGE SECTION.                                                 
      *                                                                         
       01 I-TIMESTAMP                  PIC  X(26).                      
       01 I-ACCOUNT-NO                 PIC  X(13).                      
       01 I-COMPANY                    PIC  X(04).                      
       01 I-CASH-LOCAL-OFFICE          PIC  X(03).                      
       01 I-CURRENCY-TYPE              PIC  X(03).                      
       01 I-PAYMENT-AMOUNT             PIC  X(11).                      
       01 I-REPORT-DATE                PIC  X(10).                      
       01 I-PYMT-FACILITY-CD           PIC  X(11).                      
       01 I-PYMT-INDICATOR             PIC  X(03).                      
       01 I-CONFIRMATION-NO            PIC  X(12).                      
       01 I-PROGRAM-ID                 PIC  X(09).                      
       01 I-USER-ID                    PIC  X(07).                      
       01 I-COMMENTS                   PIC  X(30).                      
       PROCEDURE DIVISION USING I-TIMESTAMP                             
                              , I-ACCOUNT-NO                            
                              , I-COMPANY                               
                              , I-CASH-LOCAL-OFFICE                     
                              , I-CURRENCY-TYPE                         
                              , I-PAYMENT-AMOUNT                        
                              , I-REPORT-DATE                           
                              , I-PYMT-FACILITY-CD                      
                              , I-PYMT-INDICATOR                        
                              , I-CONFIRMATION-NO                       
                              , I-PROGRAM-ID                            
                              , I-USER-ID                               
                              , I-COMMENTS                              
                               .                                        
      ******************************************************************03540000
      * 0000-MAINLINE                                                  *03550000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03560000
      ******************************************************************03570000
       0000-MAINLINE.                                                   
      *                                                                 03600000
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 03600000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03670000
      ******************************************************************03680000
      * 0100-INITIALIZE                                                *03690000
      ******************************************************************03760000
       0100-INITIALIZE.                                                 
      *                                                                 03760000
           MOVE '0100'                 TO ACTIVE-PARAGRAPH.             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           MOVE '01'                   TO C8-COMPANY-NO                 
           MOVE WS-DATABASE            TO C8-DELINQ-CD                  
           PERFORM 7070-GET-DELINQ-VALUE                                
                                       THRU 7070-EXIT                   
           MOVE C8-DELINQ-VALUE        TO WS-DATABASE-SW.               
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE   AS RETURN_CODE                   
                     ,:S-ERROR-CODE    AS ERROR_CODE                    
                     ,:S-TIMESTAMP     AS TIMESTAMP_TS                  
                     ,:S-PYMT-TIMESTAMP AS PYMT_TIMESTAMP_TS            
                     ,:S-XFER-TO       AS XFER_TO                       
                     ,:S-COMPANY-NO    AS COMPANY_NO                    
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE   AS RETURN_CODE                           
MFA-TR*              ,:S-ERROR-CODE    AS ERROR_CODE                            
MFA-TR*              ,:S-TIMESTAMP     AS TIMESTAMP_TS                          
MFA-TR*              ,:S-PYMT-TIMESTAMP AS PYMT_TIMESTAMP_TS                    
MFA-TR*              ,:S-XFER-TO       AS XFER_TO                               
MFA-TR*              ,:S-COMPANY-NO    AS COMPANY_NO                            
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
           MOVE SPACES                 TO S-ERROR-CODE.                 
      *                                                                 04010000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04010000
      ******************************************************************05510000
      * 2000-PROCESS-OUTPUT.                                           *05520000
      ******************************************************************05590000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 04010000
           MOVE '2000'                 TO ACTIVE-PARAGRAPH.             
           MOVE I-ACCOUNT-NO           TO WS-ACCOUNT-NO                 
           MOVE WS-ACCOUNT-NO          TO WS-ACCOUNT-NO-COMP3           
           PERFORM 7000-GET-CURRENT-TIMESTAMP                           
                                       THRU 7000-EXIT.                  
           PERFORM 2200-PROCESS        THRU 2200-EXIT.                  
           IF CTR-ROWS < 1                                              
              MOVE WS-ACTIVE-RETURN-CODE                                
                                       TO RS-RETURN-CODE                
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05700000
      ******************************************************************06650000
      * 2200-PROCESS.                                                  *06660000
      ******************************************************************06670000
       2200-PROCESS.                                                    
      *                                                                 05700000
           MOVE I-CASH-LOCAL-OFFICE    TO CS-CASH-LOCAL-OFFICE          
           IF I-PROGRAM-ID          NOT = 'PCSC362R'                    
             PERFORM 7250-SELECT-EPAYCURRDT                             
                                       THRU 7250-EXIT                   
             MOVE G6-PARM-DATA         TO CS-DATE-CASH-REPORT           
             MOVE CS-DATE-CASH-REPORT  TO JT-DATE-CASH-REPORT           
           ELSE                                                         
             MOVE I-REPORT-DATE        TO CS-DATE-CASH-REPORT           
             MOVE CS-DATE-CASH-REPORT  TO JT-DATE-CASH-REPORT           
           END-IF                                                       
           PERFORM 7200-SELECT-CSH-DRWR-CNTL                            
                                       THRU 7200-EXIT                   
           IF S-ERROR-CODE <= ' ' OR S-ERROR-CODE = '3'                 
              PERFORM 2300-POPULATE-PYMT-TRANS                          
                                       THRU 2300-EXIT                   
           END-IF                                                       
           IF I-PROGRAM-ID = 'PCSC362R'                                 
              IF S-ERROR-CODE NOT EQUAL SPACES                          
                 MOVE WS-CASH-LOCAL-OFFICE                              
                                       TO JT-CASH-LOCAL-OFFICE          
                 MOVE WS-PYMT-RCVD-TS  TO JT-ORIG-PYMT-TS               
                 MOVE I-REPORT-DATE    TO JT-DATE-CASH-REPORT           
                 PERFORM 8300-UPDATE-PYMT-TRANS                         
                                       THRU 8300-EXIT                   
              END-IF                                                    
           ELSE                                                         
              IF S-ERROR-CODE NOT = 'S'                                 
                 PERFORM 8200-INSERT-PYMT-TRANS                         
                                       THRU 8200-EXIT                   
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = WS-ROW-EXIST                   
                 MOVE 'Z'              TO S-ERROR-CODE                  
              ELSE                                                      
                 PERFORM 8999-ISSUE-COMMIT                              
                                       THRU 8999-EXIT                   
              END-IF                                                    
           END-IF.                                                      
      **** CHECKS AR LOCK OUT INDICATOR                                         
           PERFORM 7999-SELECT-AL      THRU 7999-SELECT-AL-EXIT         
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000                TO S-RETURN-CODE                 
              MOVE 5000                TO WS-ACTIVE-RETURN-CODE         
              MOVE '1'                 TO S-ERROR-CODE                  
           ELSE                                                         
              IF S-ERROR-CODE > ' '                                     
                 MOVE +1000            TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 07380000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07410000
      ******************************************************************06650000
      * 2300-POPULATE-PYMT-TRANS                                       *06660000
      ******************************************************************06670000
       2300-POPULATE-PYMT-TRANS.                                        
      *                                                                 07410000
           MOVE 0                      TO S-XFER-TO                     
           MOVE WS-ACCOUNT-NO-COMP3    TO JT-ACCOUNT-NO                 
           MOVE JT-ACCOUNT-NO          TO AT-ACCOUNT-NO                 
           PERFORM 7500-SELECT-ACCOUNT THRU 7500-EXIT                   
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'A'                 TO S-ERROR-CODE                  
           ELSE                                                         
              MOVE AT-ACCT-XFER-TO     TO S-XFER-TO                     
              IF AT-COMPANY-NO = I-COMPANY                              
                 CONTINUE                                               
              ELSE                                                      
                 IF SEB-DATABASE                                        
                    MOVE 'SEB '        TO S-COMPANY-NO                  
                 ELSE                                                   
                    IF AT-COMPANY-NO = '26'                             
                       MOVE 'PSNC'     TO S-COMPANY-NO                  
                    ELSE                                                
                       MOVE 'SCEG'     TO S-COMPANY-NO                  
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              IF AT-COMPANY-NO = '26'  AND AT-CODE-ACCT-STAT = 'J'      
                 MOVE 'U'              TO S-ERROR-CODE                  
              END-IF                                                    
              IF SEB-DATABASE                                           
                 MOVE AT-ACCOUNT-NO    TO XM-ACCOUNT-NO                 
                 MOVE AT-COMPANY-NO    TO XM-COMPANY-NO                 
                 PERFORM 7130-GET-MKT-XREF                              
                                       THRU 7130-EXIT                   
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND         
                    AT-CODE-ACCT-STAT = 'B'                 AND         
                    XM-ORIGINATION-CD = 'T'                             
                    MOVE AT-ACCOUNT-NO TO KO-ACCOUNT-NO                 
                    MOVE '44'          TO KO-COMM-TYPE-CD               
                    MOVE '22'          TO KO-COMM-SUBTYPE-CODE          
                    PERFORM 7140-GET-COMM-DATA                          
                                       THRU 7140-EXIT                   
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                                       OR WS-MULTIPLE-ROWS              
                        MOVE 'N'       TO S-ERROR-CODE                  
                     END-IF                                             
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           MOVE  CS-CASH-LOCAL-OFFICE  TO JT-CASH-LOCAL-OFFICE          
           MOVE  CS-CASH-LOCAL-OFFICE  TO WS-CASH-LOCAL-OFFICE          
           MOVE  I-TIMESTAMP           TO JT-PYMT-RCVD-TS               
           MOVE  I-TIMESTAMP           TO WS-PYMT-RCVD-TS               
           MOVE  WS-ACCOUNT-NO-COMP3   TO JT-ACCOUNT-NO                 
           PERFORM 7400-SELECT-PYMT-TRANS                               
                                       THRU 7400-EXIT                   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              S-ERROR-CODE <= ' '                                       
              IF JT-DATE-CASH-REPORT NOT = CS-DATE-CASH-REPORT          
                 MOVE 'T'              TO S-ERROR-CODE                  
A00575           MOVE 'T'              TO JT-ERROR-CD(1:1)              
              END-IF                                                    
              MOVE JT-APPLIED-FL       TO WS-APPLIED-FL                 
              MOVE  'R'                TO JT-TRANS-TYPE-CD              
              MOVE  'N'                TO JT-APPLIED-FL                 
              MOVE  I-PROGRAM-ID       TO JT-APPL-PROGRAM-ID            
              MOVE  CS-DATE-CASH-REPORT TO JT-DATE-CASH-REPORT          
              MOVE  WS-CURRENT-TIMESTAMP                                
                                       TO S-TIMESTAMP                   
                                          JT-PYMT-RCVD-TS               
              MOVE  I-TIMESTAMP        TO JT-ORIG-PYMT-TS               
              PERFORM 7450-SELECT-ORIG-TRANS                            
                                       THRU 7450-EXIT                   
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
              AND I-PROGRAM-ID NOT = 'PCSC362R'                         
                  MOVE 'S'             TO S-ERROR-CODE                  
A00575            MOVE 'S'             TO JT-ERROR-CD(1:1)              
                 MOVE 0                TO WS-ACTIVE-RETURN-CODE         
                 GO TO  2300-EXIT                                       
              END-IF                                                    
              MOVE  0                  TO WS-NULL-IND3                  
              MOVE  JT-TRANS-HIST-SEQ-NO                                
                                       TO S-PYMT-TIMESTAMP              
              IF WS-APPLIED-FL = 'N' OR JT-TRANS-HIST-SEQ-NO <= SPACES  
                  MOVE 'X'             TO S-ERROR-CODE                  
              ELSE                                                      
                 IF S-XFER-TO > 0                                       
                    MOVE S-XFER-TO     TO AR-ACCOUNT-NO                 
                 ELSE                                                   
                    MOVE JT-ACCOUNT-NO TO AR-ACCOUNT-NO                 
                 END-IF                                                 
                 MOVE JT-TRANS-HIST-SEQ-NO                              
                                       TO AR-TRANS-HIST-SEQ-NO          
                 MOVE CS-DATE-CASH-REPORT                               
                                       TO AR-DATE-CASH-REPORT           
                 MOVE CS-CASH-DRAWER-ID                                 
                                       TO AR-CASH-DRAWER-ID             
                 PERFORM 7100-SELECT-AR-TRANS-HIST                      
                                       THRU 7100-EXIT                   
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE 'T'           TO S-ERROR-CODE                  
                 END-IF                                                 
              END-IF                                                    
A00575        IF JT-ERROR-CD(1:1) = 'D'                                 
                 MOVE 'D'              TO S-ERROR-CODE                  
              END-IF                                                    
           ELSE                                                         
             IF I-TIMESTAMP =  SPACES                                   
                MOVE  SPACES           TO JT-ORIG-PYMT-TS               
                MOVE  -1               TO WS-NULL-IND3                  
             ELSE                                                       
                MOVE  I-TIMESTAMP      TO JT-ORIG-PYMT-TS               
             END-IF                                                     
             MOVE  WS-CURRENT-TIMESTAMP                                 
                                       TO JT-PYMT-RCVD-TS               
                                          S-TIMESTAMP                   
             IF S-ERROR-CODE <= ' '                                     
                MOVE  'R'              TO S-ERROR-CODE                  
A00575          MOVE  'R'              TO JT-ERROR-CD(1:1)              
             END-IF                                                     
             MOVE  I-PROGRAM-ID        TO JT-APPL-PROGRAM-ID            
             MOVE  'N'                 TO JT-APPLIED-FL                 
             MOVE  ' '                 TO JT-APPLIED-TS                 
             MOVE  I-COMPANY           TO JT-COMPANY-NO                 
             MOVE  ' '                 TO JT-CREDIT-CARD-TYPE           
             MOVE  I-CURRENCY-TYPE     TO JT-CURRENCY-TYPE              
             MOVE  ' '                 TO JT-CUST-PHONE-NO              
             MOVE  'REV'               TO JT-DIRECTED-PYMT-CD           
             MOVE  'R'                 TO JT-TRANS-TYPE-CD              
             MOVE  I-PAYMENT-AMOUNT    TO WS-AMOUNT-9                   
             COMPUTE WS-AMOUNT9-2 = WS-AMOUNT-9 / 100                   
             END-COMPUTE                                                
             MOVE  WS-AMOUNT9-2        TO JT-PAYMENT-AMT                
             MOVE  I-CONFIRMATION-NO   TO JT-PYMT-CONFIRM-NO            
             MOVE  I-PYMT-FACILITY-CD  TO JT-PYMT-FACILITY-CD           
             MOVE  I-USER-ID           TO JT-LAST-UPDATE-USERID         
             MOVE  CS-DATE-CASH-REPORT TO JT-DATE-CASH-REPORT           
             MOVE  SPACES              TO S-PYMT-TIMESTAMP              
           END-IF.                                                      
A00575     MOVE S-ERROR-CODE           TO JT-ERROR-CD(1:1).             
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07410000
      ******************************************************************07990000
      * 7000-GET-CURRENT-TIMESTAMP.                                    *08000000
      ******************************************************************08010000
       7000-GET-CURRENT-TIMESTAMP.                                      
      *                                                                 07410000
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08040000
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP           08050000
MFA-TR*    END-EXEC.                                                    08060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08070000
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                   
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08080000
MFA-TR*         SET :WS-CURRENT-DATE   = CURRENT DATE                   08090000
MFA-TR*    END-EXEC.                                                    08100000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                 08130000
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07990000
      * 7070-GET-DELINQ-VALUE                                          *08000000
      * SELECTS DELINQUENCY VALUE FOR GIVEN DELINQUENCY CODE           *        
      ******************************************************************08010000
       7070-GET-DELINQ-VALUE.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
               INTO :C8-DELINQ-VALUE                                    
               FROM CSS_DELINQUENCY                                     
              WHERE DELINQ_CD          = :C8-DELINQ-CD                  
                AND COMPANY_NO         = :C8-COMPANY-NO                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE                 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7070'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_DELINQUENCY'   TO TABLE-1                       
              MOVE C8-DELINQ-CD        TO HOSTVAR-ELEMENT-1             
              MOVE C8-COMPANY-NO       TO HOSTVAR-ELEMENT-2             
              MOVE 'DELINQ_CD'         TO TABLE-ELEMENT-1               
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-2               
              PERFORM 9000-SEND-ERROR-RESULT                            
                                       THRU 9000-EXIT                   
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08160000
      * 7100-SELECT-AR-TRANS-HIST                                     * 08170000
      ***************************************************************** 08180000
       7100-SELECT-AR-TRANS-HIST.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      AMT_ORIG_ENTERED,                                 
                      AMT_BILLED_UNPAID,                                
                      RESP_AREA_ID,                                     
                      APPL_PROGRAM_ID,                                  
                      PYMT_FACILITY_CD,                                 
                      USER_ID,                                          
                      COMPANY_NO,                                       
                      RECORD_ONLY_FL,                                   
                      DATE_ORIG_PYMT,                                   
                      CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      CASH_REPORT_NO,                                   
                      DATE_CASH_REPORT,                                 
                      CASH_DRAWER_ID,                                   
                      TRAN_COMMENT                                      
                 INTO :AR-DATE-TRANS :WS-NULL-IND1,                      
                      :AR-CODE-TRAN-TYPE,                               
                      :AR-AMT-ORIG-ENTERED,                             
                      :AR-AMT-BILLED-UNPAID,                            
                      :AR-RESP-AREA-ID,                                 
                      :AR-APPL-PROGRAM-ID,                              
                      :AR-PYMT-FACILITY-CD,                             
                      :AR-USER-ID,                                      
                      :AR-COMPANY-NO,                                   
                      :AR-RECORD-ONLY-FL,                               
                      :AR-DATE-ORIG-PYMT :WS-NULL-IND2,                  
                      :AR-CASH-COMPANY-NO,                              
                      :AR-CASH-LOCAL-OFFICE,                            
                      :AR-CASH-REPORT-NO,                               
                      :AR-DATE-CASH-REPORT,                             
                      :AR-CASH-DRAWER-ID,                               
                      :AR-TRAN-COMMENT                                  
              FROM CSS_AR_TRANS_HIST                                    
              WHERE ACCOUNT_NO         = :AR-ACCOUNT-NO                 
                AND TRANS_HIST_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :AR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT) )           
                AND CASH_DRAWER_ID     = :AR-CASH-DRAWER-ID             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08210000
MFA-TR*        SELECT DATE_TRANS,                                       08220000
MFA-TR*               CODE_TRAN_TYPE,                                   08230000
MFA-TR*               AMT_ORIG_ENTERED,                                 08240000
MFA-TR*               AMT_BILLED_UNPAID,                                08250000
MFA-TR*               RESP_AREA_ID,                                     08260000
MFA-TR*               APPL_PROGRAM_ID,                                  08270000
MFA-TR*               PYMT_FACILITY_CD,                                 08280000
MFA-TR*               USER_ID,                                          08290000
MFA-TR*               COMPANY_NO,                                       08300000
MFA-TR*               RECORD_ONLY_FL,                                   08310000
MFA-TR*               DATE_ORIG_PYMT,                                   08320000
MFA-TR*               CASH_COMPANY_NO,                                  08330000
MFA-TR*               CASH_LOCAL_OFFICE,                                08340000
MFA-TR*               CASH_REPORT_NO,                                   08350000
MFA-TR*               DATE_CASH_REPORT,                                 08360000
MFA-TR*               CASH_DRAWER_ID,                                   08370000
MFA-TR*               TRAN_COMMENT                                      08380000
MFA-TR*          INTO :AR-DATE-TRANS:WS-NULL-IND1,                      08390000
MFA-TR*               :AR-CODE-TRAN-TYPE,                               08400000
MFA-TR*               :AR-AMT-ORIG-ENTERED,                             08410000
MFA-TR*               :AR-AMT-BILLED-UNPAID,                            08420000
MFA-TR*               :AR-RESP-AREA-ID,                                 08430000
MFA-TR*               :AR-APPL-PROGRAM-ID,                              08440000
MFA-TR*               :AR-PYMT-FACILITY-CD,                             08450000
MFA-TR*               :AR-USER-ID,                                      08460000
MFA-TR*               :AR-COMPANY-NO,                                   08470000
MFA-TR*               :AR-RECORD-ONLY-FL,                               08480000
MFA-TR*               :AR-DATE-ORIG-PYMT:WS-NULL-IND2,                  08490000
MFA-TR*               :AR-CASH-COMPANY-NO,                              08500000
MFA-TR*               :AR-CASH-LOCAL-OFFICE,                            08510000
MFA-TR*               :AR-CASH-REPORT-NO,                               08520000
MFA-TR*               :AR-DATE-CASH-REPORT,                             08530000
MFA-TR*               :AR-CASH-DRAWER-ID,                               08540000
MFA-TR*               :AR-TRAN-COMMENT                                  08550000
MFA-TR*       FROM CSS_AR_TRANS_HIST                                    08560000
MFA-TR*       WHERE ACCOUNT_NO         = :AR-ACCOUNT-NO                 08570000
MFA-TR*         AND TRANS_HIST_SEQ_NO  = :AR-TRANS-HIST-SEQ-NO          08580000
MFA-TR*         AND DATE_CASH_REPORT   = :AR-DATE-CASH-REPORT           08530000
MFA-TR*         AND CASH_DRAWER_ID     = :AR-CASH-DRAWER-ID             08540000
MFA-TR*    END-EXEC.                                                    08590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08630000
           IF WS-NULL-IND1 < 0                                          
              MOVE SPACES              TO AR-DATE-TRANS                 
           END-IF.                                                      
      *                                                                 08630000
           IF WS-NULL-IND2 < 0                                          
              MOVE SPACES              TO AR-DATE-ORIG-PYMT             
           END-IF.                                                      
      *                                                                 08670000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 08670000
           IF WS-ACTIVE-RETURN-CODE    EQUAL SUCCESSFUL-CALL            
                                       OR NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE                                
                                       TO RS-RETURN-CODE                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_AR_TRANS_HIST' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AR-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT                            
                                       THRU 9000-EXIT                   
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                       THRU 9900-EXIT
           END-IF.                  
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08160000
      * 7130-GET-MKT-XREF.                                            * 08170000
      * CHECKS WHETHER ACCOUNT IS TRANSFERRED TO COBB                 *         
      ***************************************************************** 08180000
       7130-GET-MKT-XREF.                                               
      *                                                                         
            EXEC SQL                                                    
              SELECT ORIGINATION_CD                                     
                INTO :XM-ORIGINATION-CD                                 
                FROM CSS_MKT_XREF_ACCT                                  
               WHERE ACCOUNT_NO        = :XM-ACCOUNT-NO                 
                 AND COMPANY_NO        = :XM-COMPANY-NO                 
            END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE                 
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7130'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSS_MKT_XREF_ACCT'                                 
                                       TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE XM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2               
               MOVE XM-COMPANY-NO      TO HOSTVAR-ELEMENT-2             
               PERFORM 9000-SEND-ERROR-RESULT                           
                                       THRU 9000-EXIT                   
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08160000
      * 7140-GET-COMM-DATA.                                           * 08170000
      * SELECTS COMMUNICATION DATA FOR A GIVEN ACCOUNT, COMM TYPE     *         
      * AND COMM SUB TYPE                                             *         
      ***************************************************************** 08180000
       7140-GET-COMM-DATA.                                              
      *                                                                         
           EXEC SQL                                                     
             SELECT ACCOUNT_NO                                          
               INTO :KO-ACCOUNT-NO                                      
               FROM CSS_COMM_DATA                                       
              WHERE ACCOUNT_NO         = :KO-ACCOUNT-NO                 
                AND COMM_TYPE_CD       = :KO-COMM-TYPE-CD               
                AND COMM_SUBTYPE_CODE  = :KO-COMM-SUBTYPE-CODE          
                AND INITIAL_COMMENT_TX LIKE                             
                    '%Account has been transferred to Cobb%'            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE                 
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               OR -811                                                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7140'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSS_COMM_DATA'    TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE KO-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               MOVE 'COMM_TYPE_CD'     TO TABLE-ELEMENT-2               
               MOVE KO-COMM-TYPE-CD    TO HOSTVAR-ELEMENT-2             
               MOVE 'COMM_SUBTYPE_CODE'                                 
                                       TO TABLE-ELEMENT-3               
               MOVE KO-COMM-SUBTYPE-CODE                                
                                       TO HOSTVAR-ELEMENT-3             
               PERFORM 9000-SEND-ERROR-RESULT                           
                                       THRU 9000-EXIT                   
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08160000
      * 7200-SELECT-CSH-DRWR-CNTL                                     * 08170000
      ***************************************************************** 08180000
       7200-SELECT-CSH-DRWR-CNTL.                                       
      *                                                                 08190000
           EXEC SQL                                                     
              SELECT DATE_CASH_REPORT                                   
                    ,CASH_DRAWER_ID                                     
                    ,CODE_CSH_DRWR_STAT                                 
                INTO :CS-DATE-CASH-REPORT                               
                    ,:CS-CASH-DRAWER-ID                                 
                    ,:CS-CODE-CSH-DRWR-STAT                             
              FROM CSS_CSH_DRWR_CNTL                                    
              WHERE CASH_COMPANY_NO    = '01'                           
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CODE_CSH_DRWR_STAT = 'A'                            
                AND CASH_DRAWER_ID     < 500                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08210000
MFA-TR*       SELECT DATE_CASH_REPORT                                   08220000
MFA-TR*             ,CASH_DRAWER_ID                                     08260000
MFA-TR*             ,CODE_CSH_DRWR_STAT                                 08270000
MFA-TR*         INTO :CS-DATE-CASH-REPORT                               08390000
MFA-TR*             ,:CS-CASH-DRAWER-ID                                 08430000
MFA-TR*             ,:CS-CODE-CSH-DRWR-STAT                             08440000
MFA-TR*       FROM CSS_CSH_DRWR_CNTL                                    08560000
MFA-TR*       WHERE CASH_COMPANY_NO    = '01'                           08570000
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          08580000
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT           08580000
MFA-TR*         AND CODE_CSH_DRWR_STAT = 'A'                                    
MFA-TR*         AND CASH_DRAWER_ID     < 500                                    
MFA-TR*    END-EXEC.                                                    08590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08670000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 08670000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE '3'              TO S-ERROR-CODE                  
A00575           MOVE '3'              TO JT-ERROR-CD(1:1)              
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CSH_DRWR_CNTL' TO TABLE-1                       
              MOVE 'CASH_LOCAL_OFFICE' TO TABLE-ELEMENT-1               
              MOVE CS-CASH-LOCAL-OFFICE                                 
                                       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT                            
                                       THRU 9000-EXIT                   
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08160000
      * 7250-SELECT-EPAYCURRDT                                        * 08170000
      * SELECTING EPAYCURRDT FROM CSS_JOB_PARM                        *         
      *****************************************************************         
       7250-SELECT-EPAYCURRDT.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT PARM_DATA                                           
               INTO :G6-PARM-DATA                                       
               FROM CSS_JOB_PARM                                        
              WHERE PROGRAM_NAME       = 'EPAYCURRDT'                   
                AND COMPANY_NO         = '01'                           
                AND CMND_CODE          = 'DATE'                         
                AND SEQ_NO             = 10                             
                AND STATUS             = 'A'                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE    EQUAL SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE                                
                                       TO RS-RETURN-CODE                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7250'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_JOB_PARM   '   TO TABLE-1                       
              MOVE 'PROGRAM_NAME     ' TO TABLE-ELEMENT-1               
              MOVE 'EPAYCURRDT'        TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT                            
                                       THRU 9000-EXIT                   
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                       THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08160000
      * 7300-SELECT-CASHIER-OFF                                       * 08170000
      ***************************************************************** 08180000
       7300-SELECT-CASHIER-OFF.                                         
      *                                                                 08190000
           EXEC SQL                                                     
              SELECT  CASH_LOCAL_OFFICE                                 
                INTO :Y2-CASH-LOCAL-OFFICE                              
              FROM CSS_CASHIER_OFFICE                                   
              WHERE PAYMENT_SOURCE_CD  = :Y2-PAYMENT-SOURCE-CD          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08670000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 08190000
           IF WS-ACTIVE-RETURN-CODE    EQUAL SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE                                
                                       TO RS-RETURN-CODE                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CASHIER_OFFICE'                                 
                                       TO TABLE-1                       
              MOVE 'CASH_LOCAL_OFFICE' TO TABLE-ELEMENT-1               
              MOVE Y2-CASH-LOCAL-OFFICE                                 
                                       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT                            
                                       THRU 9000-EXIT                   
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-SELECT-PYMT-TRANS                                         *        
      ******************************************************************        
       7400-SELECT-PYMT-TRANS.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  DATE_CASH_REPORT                                      
                 ,CASH_LOCAL_OFFICE                                     
                 ,REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_RCVD_TS, 121), 
           ' ', '-'), ':', '.') PYMT_RCVD_TS                                   
                 ,ACCOUNT_NO                                            
                 ,APPL_PROGRAM_ID                                       
                 ,APPLIED_FL                                            
                 ,REPLACE(REPLACE(CONVERT(CHAR(26), APPLIED_TS, 121), 
           ' ', '-'), ':', '.') APPLIED_TS                                     
                 ,COMPANY_NO                                            
                 ,CREDIT_CARD_TYPE                                      
                 ,CURRENCY_TYPE                                         
                 ,CUST_PHONE_NO                                         
                 ,DIRECTED_PYMT_CD                                      
                 ,ERROR_CD                                              
                 ,PAYMENT_AMT                                           
                 ,PYMT_CONFIRM_NO                                       
                 ,PYMT_FACILITY_CD                                      
                 ,LAST_UPDATE_USERID                                    
                 ,REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
                INTO                                                    
                 :JT-DATE-CASH-REPORT                                   
                ,:JT-CASH-LOCAL-OFFICE                                  
                ,:JT-PYMT-RCVD-TS                                       
                ,:JT-ACCOUNT-NO                                         
                ,:JT-APPL-PROGRAM-ID                                    
                ,:JT-APPLIED-FL                                         
                ,:JT-APPLIED-TS :WS-NULL-IND1                            
                ,:JT-COMPANY-NO                                         
                ,:JT-CREDIT-CARD-TYPE                                   
                ,:JT-CURRENCY-TYPE                                      
                ,:JT-CUST-PHONE-NO                                      
                ,:JT-DIRECTED-PYMT-CD                                   
                ,:JT-ERROR-CD                                           
                ,:JT-PAYMENT-AMT                                        
                ,:JT-PYMT-CONFIRM-NO                                    
                ,:JT-PYMT-FACILITY-CD                                   
                ,:JT-LAST-UPDATE-USERID                                 
                ,:JT-TRANS-HIST-SEQ-NO :WS-NULL-IND2                     
            FROM CSS_PAYMENT_TRANS                                      
            WHERE ACCOUNT_NO           = :JT-ACCOUNT-NO                 
              AND PYMT_RCVD_TS         = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           DATE_CASH_REPORT                                              
MFA-TR*          ,CASH_LOCAL_OFFICE                                             
MFA-TR*          ,PYMT_RCVD_TS                                                  
MFA-TR*          ,ACCOUNT_NO                                                    
MFA-TR*          ,APPL_PROGRAM_ID                                               
MFA-TR*          ,APPLIED_FL                                                    
MFA-TR*          ,APPLIED_TS                                                    
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,CREDIT_CARD_TYPE                                              
MFA-TR*          ,CURRENCY_TYPE                                                 
MFA-TR*          ,CUST_PHONE_NO                                                 
MFA-TR*          ,DIRECTED_PYMT_CD                                              
MFA-TR*          ,ERROR_CD                                                      
MFA-TR*          ,PAYMENT_AMT                                                   
MFA-TR*          ,PYMT_CONFIRM_NO                                               
MFA-TR*          ,PYMT_FACILITY_CD                                              
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,TRANS_HIST_SEQ_NO                                             
MFA-TR*         INTO                                                            
MFA-TR*          :JT-DATE-CASH-REPORT                                           
MFA-TR*         ,:JT-CASH-LOCAL-OFFICE                                          
MFA-TR*         ,:JT-PYMT-RCVD-TS                                               
MFA-TR*         ,:JT-ACCOUNT-NO                                                 
MFA-TR*         ,:JT-APPL-PROGRAM-ID                                            
MFA-TR*         ,:JT-APPLIED-FL                                                 
MFA-TR*         ,:JT-APPLIED-TS:WS-NULL-IND1                                    
MFA-TR*         ,:JT-COMPANY-NO                                                 
MFA-TR*         ,:JT-CREDIT-CARD-TYPE                                           
MFA-TR*         ,:JT-CURRENCY-TYPE                                              
MFA-TR*         ,:JT-CUST-PHONE-NO                                              
MFA-TR*         ,:JT-DIRECTED-PYMT-CD                                           
MFA-TR*         ,:JT-ERROR-CD                                                   
MFA-TR*         ,:JT-PAYMENT-AMT                                                
MFA-TR*         ,:JT-PYMT-CONFIRM-NO                                            
MFA-TR*         ,:JT-PYMT-FACILITY-CD                                           
MFA-TR*         ,:JT-LAST-UPDATE-USERID                                         
MFA-TR*         ,:JT-TRANS-HIST-SEQ-NO:WS-NULL-IND2                             
MFA-TR*     FROM CSS_PAYMENT_TRANS                                              
MFA-TR*     WHERE ACCOUNT_NO           = :JT-ACCOUNT-NO                         
MFA-TR*       AND PYMT_RCVD_TS         = :JT-PYMT-RCVD-TS                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE                                
                                       TO RS-RETURN-CODE                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7400'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_PAYMENT_TRANS' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE JT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT                            
                                       THRU 9000-EXIT                   
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7450-SELECT-ORIG-TRANS                                         *        
      ******************************************************************        
       7450-SELECT-ORIG-TRANS.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
                INTO :WS-ACCOUNT-NO-JT                                  
            FROM CSS_PAYMENT_TRANS                                      
            WHERE ACCOUNT_NO           = :JT-ACCOUNT-NO                 
              AND ORIG_PYMT_TS         = CIS.CHAR2TIMESTAMP(
                                                       :JT-ORIG-PYMT-TS
              )               
              AND TRANS_TYPE_CD        = 'R'                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-ACCOUNT-NO-JT                                          
MFA-TR*     FROM CSS_PAYMENT_TRANS                                              
MFA-TR*     WHERE ACCOUNT_NO           = :JT-ACCOUNT-NO                         
MFA-TR*       AND ORIG_PYMT_TS         = :JT-ORIG-PYMT-TS                       
MFA-TR*       AND TRANS_TYPE_CD        = 'R'                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE                                
                                       TO RS-RETURN-CODE                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7450'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_PAYMENT_TRANS' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE JT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT                            
                                       THRU 9000-EXIT                   
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-SELECT-ACCOUNT.                                           *        
      ******************************************************************        
       7500-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  ACCOUNT_NO                                            
                 ,CODE_ACCT_STAT                                        
                 ,ACCT_XFER_TO                                          
                 ,COMPANY_NO                                            
                INTO                                                    
                 :AT-ACCOUNT-NO                                         
                ,:AT-CODE-ACCT-STAT                                     
                ,:AT-ACCT-XFER-TO                                       
                ,:AT-COMPANY-NO                                         
            FROM CSS_ACCOUNT                                            
            WHERE ACCOUNT_NO           = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE                                
                                       TO RS-RETURN-CODE                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7500'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_ACCOUNT      ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT                            
                                       THRU 9000-EXIT                   
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-INSERT-PYMT-TRANS                                         *        
      ******************************************************************        
       8200-INSERT-PYMT-TRANS.                                          
           EXEC SQL                                                     
              INSERT INTO CSS_PAYMENT_TRANS                             
                (                                                       
                  DATE_CASH_REPORT                                      
                 ,CASH_LOCAL_OFFICE                                     
                 ,PYMT_RCVD_TS                                          
                 ,ACCOUNT_NO                                            
                 ,APPL_PROGRAM_ID                                       
                 ,APPLIED_FL                                            
                 ,APPLIED_TS                                            
                 ,COMPANY_NO                                            
                 ,CREDIT_CARD_TYPE                                      
                 ,CURRENCY_TYPE                                         
                 ,CUST_PHONE_NO                                         
                 ,DIRECTED_PYMT_CD                                      
                 ,ERROR_CD                                              
                 ,PAYMENT_AMT                                           
                 ,PYMT_CONFIRM_NO                                       
                 ,PYMT_FACILITY_CD                                      
                 ,LAST_UPDATE_USERID                                    
                 ,ORIG_PYMT_TS                                          
                 ,RECONCILED_FL                                         
                 ,TRANS_HIST_SEQ_NO                                     
                 ,TRANS_TYPE_CD                                         
                )                                                       
                VALUES                                                  
                (                                                       
                 IIF(TRY_CONVERT(DATE, :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )                         
                ,:JT-CASH-LOCAL-OFFICE                                  
                ,CIS.CHAR2TIMESTAMP(:JT-PYMT-RCVD-TS)                           
                ,:JT-ACCOUNT-NO                                         
                ,:JT-APPL-PROGRAM-ID                                    
                ,:JT-APPLIED-FL                                         
                ,NULL                                                   
                ,:JT-COMPANY-NO                                         
                ,:JT-CREDIT-CARD-TYPE                                   
                ,:JT-CURRENCY-TYPE                                      
                ,:JT-CUST-PHONE-NO                                      
                ,:JT-DIRECTED-PYMT-CD                                   
                ,:JT-ERROR-CD                                           
                ,:JT-PAYMENT-AMT                                        
                ,:JT-PYMT-CONFIRM-NO                                    
                ,:JT-PYMT-FACILITY-CD                                   
                ,:JT-LAST-UPDATE-USERID                                 
                ,CIS.CHAR2TIMESTAMP(:JT-ORIG-PYMT-TS :WS-NULL-IND3)             
                ,'N'                                                    
                ,NULL                                                   
                ,:JT-TRANS-TYPE-CD                                      
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_PAYMENT_TRANS                                     
MFA-TR*         (                                                               
MFA-TR*           DATE_CASH_REPORT                                              
MFA-TR*          ,CASH_LOCAL_OFFICE                                             
MFA-TR*          ,PYMT_RCVD_TS                                                  
MFA-TR*          ,ACCOUNT_NO                                                    
MFA-TR*          ,APPL_PROGRAM_ID                                               
MFA-TR*          ,APPLIED_FL                                                    
MFA-TR*          ,APPLIED_TS                                                    
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,CREDIT_CARD_TYPE                                              
MFA-TR*          ,CURRENCY_TYPE                                                 
MFA-TR*          ,CUST_PHONE_NO                                                 
MFA-TR*          ,DIRECTED_PYMT_CD                                              
MFA-TR*          ,ERROR_CD                                                      
MFA-TR*          ,PAYMENT_AMT                                                   
MFA-TR*          ,PYMT_CONFIRM_NO                                               
MFA-TR*          ,PYMT_FACILITY_CD                                              
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,ORIG_PYMT_TS                                                  
MFA-TR*          ,RECONCILED_FL                                                 
MFA-TR*          ,TRANS_HIST_SEQ_NO                                             
MFA-TR*          ,TRANS_TYPE_CD                                                 
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*          :JT-DATE-CASH-REPORT                                           
MFA-TR*         ,:JT-CASH-LOCAL-OFFICE                                          
MFA-TR*         ,:JT-PYMT-RCVD-TS                                               
MFA-TR*         ,:JT-ACCOUNT-NO                                                 
MFA-TR*         ,:JT-APPL-PROGRAM-ID                                            
MFA-TR*         ,:JT-APPLIED-FL                                                 
MFA-TR*         ,NULL                                                           
MFA-TR*         ,:JT-COMPANY-NO                                                 
MFA-TR*         ,:JT-CREDIT-CARD-TYPE                                           
MFA-TR*         ,:JT-CURRENCY-TYPE                                              
MFA-TR*         ,:JT-CUST-PHONE-NO                                              
MFA-TR*         ,:JT-DIRECTED-PYMT-CD                                           
MFA-TR*         ,:JT-ERROR-CD                                                   
MFA-TR*         ,:JT-PAYMENT-AMT                                                
MFA-TR*         ,:JT-PYMT-CONFIRM-NO                                            
MFA-TR*         ,:JT-PYMT-FACILITY-CD                                           
MFA-TR*         ,:JT-LAST-UPDATE-USERID                                         
MFA-TR*         ,:JT-ORIG-PYMT-TS:WS-NULL-IND3                                  
MFA-TR*         ,'N'                                                            
MFA-TR*         ,NULL                                                           
MFA-TR*         ,:JT-TRANS-TYPE-CD                                              
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR WS-ROW-EXIST                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE                                
                                       TO RS-RETURN-CODE                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '8200'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_PAYMENT_TRANS' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE JT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT                            
                                       THRU 9000-EXIT                   
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-UPDATE-PYMT-TRANS                                         *        
      ******************************************************************        
       8300-UPDATE-PYMT-TRANS.                                          
      *                                                                         
           EXEC SQL                                                     
              UPDATE  CSS_PAYMENT_TRANS                                 
                SET ERROR_CD           = :JT-ERROR-CD                   
              WHERE ACCOUNT_NO         = :JT-ACCOUNT-NO                 
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )           
                AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE          
T31289          AND ORIG_PYMT_TS       = CIS.CHAR2TIMESTAMP(
                                                       :JT-ORIG-PYMT-TS
              )               
T31289          AND TRANS_TYPE_CD      = 'R'                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE  CSS_PAYMENT_TRANS                                         
MFA-TR*         SET ERROR_CD           = :JT-ERROR-CD                           
MFA-TR*       WHERE ACCOUNT_NO         = :JT-ACCOUNT-NO                         
MFA-TR*         AND DATE_CASH_REPORT   = :JT-DATE-CASH-REPORT                   
MFA-TR*         AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE                  
MFA-TR*         AND ORIG_PYMT_TS       = :JT-ORIG-PYMT-TS                       
MFA-TR*         AND TRANS_TYPE_CD      = 'R'                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR WS-ROW-EXIST                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE                                
                                       TO RS-RETURN-CODE                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '8300'              TO ACTIVE-PARAGRAPH              
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_PAYMENT_TRANS' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE JT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT                            
                                       THRU 9000-EXIT                   
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------*         
      *8900-SEND-DONE.                                                *         
      *   OPEN THE RESULT SET CURSOR                                  *         
      *---------------------------------------------------------------*         
       8900-SEND-DONE.                                                  
      *                                                                         
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE                 
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------*         
      *8999-ISSUE-COMMIT                                              *         
      *---------------------------------------------------------------*         
       8999-ISSUE-COMMIT.                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
                                                    
      *                                                                         
       8999-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *9000-SEND-ERROR-RESULT.                                         *        
      * SENDS ERROR RESULT                                             *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
             MOVE WS-ACTIVE-RETURN-CODE                                 
                                       TO RS-RETURN-CODE                
                                          S-RETURN-CODE                 
      *                                   ABEND-SQLCODE.                        
             EXEC SQL                                                   
               ROLLBACK                                                 
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             IF SQLCODE = 0                                             
                CONTINUE                                                
             ELSE                                                       
                MOVE 'ROLLBACK'        TO ABEND-FUNCTION                
             END-IF.                                                    
      *                                                                         
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM                                               *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
      *                                                                         
           IF CTR-ROWS < 1                                              
      *---------------------------------------------------------------*         
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!    *         
      *---------------------------------------------------------------*         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF                                                       
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00075                                                  
           END-EXEC.                                                            
      *                                                                         
                                                                        
