       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03486.                                         
COB303 DATE-WRITTEN.  SEP 9,04.                                         
       DATE-COMPILED.                                                   
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      * A) THIS PROGRAM IS FOR PAYMENT REVERSALS FOR THIRD PARTY PYMNT.*00100000
      * B) THIS IS INVOKED FROM CSR03488.                              *00110000
      *                                                                *00110000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  09/15/04    PD       PROCEDURE ORIGINALLY CODED.              *00280000
      *  04/07/05   SK88120   IMPLEMENT STANDARDS.                     *00280000
T33431** 03/22/06   SK88120        COG PROJECT CHANGES -                        
T33431**                           A- ADD NEW COPYBOOKS                         
T33431**                           B- CHANGE IN CPD00116                        
C33676** 10/10/06   BASKAR V  ADD DIFFERENT APPL ID FOR BATCH REVERSAL *        
T35434** 19/01/08   MK92804   ADDED FOR FETCH ONLY WITH UR FOR CURSOR  *        
      **                      SELECTS AND WITH UR FOR SINGELTON SELECTS*        
      **                      AND REPLACED WITH SET COMMANDS           *        
      **                      IN CSS_MODEL_SQL  SELECTS.               *        
C36929** 02/28/08   VP94820   SCE&G COG CHANGES.                       *        
A04880** 07/21/14   AS7C117   REMOVED UNUSED COPYBOOK CPD00008,CPD0062C*        
A04880**            #ACT225                                            *        
A04860*  08/04/16  MS7M727   REPLACE CSS_WQ_ITEMS_MF TABLE WITH        *01790100
A04860*            ACT107    CSS_WQ_ITEMS TABLE                        *01790200
      ******************************************************************00470000
      *                                                                *00480000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00490000
      *                                                                *00500000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00510000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00520000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00530000
      *  3000 - 4999  NOT USED                                         *00540000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00550000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00560000
      *  7000 - 7999  INPUT MODULES                                    *00570000
      *  8000 - 8999  OUTPUT MODULES                                   *00580000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00590000
      *                                                                *00600000
      ******************************************************************00610000
      *                                                                 00620000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
      *                                                                 00650000
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03486'.
MSQ017     COPY MFASQLM.
       01 WS-START                          PIC X(50) VALUE             
           'WORKING STORAGE CSR03486 STARTS HERE'.                      
      *                                                                 00690000
      ******************************************************************00700000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00710000
      ******************************************************************00720000
      *                                                                 00730000
           COPY CWS00056.                                               00810000
           COPY CWS00303.                                               00820000
           COPY CJF00101.                                               00840000
T33431     COPY CWSCA224.                                                       
T33431     COPY CWSCA225.                                                       
ACT107     COPY CWS00077.                                                       
      *                                                                 00860000
      ******************************************************************00870000
      *    WORK AREAS                                                  *00880000
      ******************************************************************00890000
                                                                        
       01 WS-MISC.                                                      
           05 PROGRAM-NAME                  PIC X(08) VALUE 'CSR03486'. 
           05 WS-ACCOUNT-NO                 PIC 9(13).                  
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.          
ACT107     05 MCSCB077                      PIC X(08)  VALUE 'MCSCB077'.
           05 WS-CURRENT-DATE               PIC X(10).                  
           05 WS-PAYMENT-REVERSED           PIC X(09) VALUE             
                                                            'PANEL118A'.
           05 WS-CURRENT-TIMESTAMP          PIC X(26).                  
           05 WS-USER-ID                    PIC X(07).                  
           05 WS-PREV-TRANS-HIST-SEQ-NO     PIC X(26).                  
           05 WS-TRANS-HIST-SEQ-NO          PIC X(26).                  
           05 WS-ADJ-TRANS-HIST-SEQ-NO      PIC X(26).                  
           05 WS-DATE                       PIC X(10).                  
           05 WS-TIME                       PIC X(08).                  
           05 WS-NULL-IND1                  PIC S9(04) COMP VALUE 0.    
           05 WS-NULL-IND2                  PIC S9(04) COMP VALUE 0.    
           05 WS-NULL-IND3                  PIC S9(04) COMP VALUE 0.    
           05 WS-DATE-ORIG-PYMT-IND         PIC S9(04) COMP VALUE +0.   
           05 WS-TRAN-COMMENT-LEN           PIC S9(09) COMP.            
           05 WS-TRAN-COMMENT-TEXT          PIC  X(210).                
           05 WS-TOTAL-ORIG-AMT             PIC S9(09)V99               
                                                       COMP-3 VALUE +0. 
           05 WS-RECORD-ONLY                PIC  X(01) VALUE SPACES.    
           05 WS-LAST-UPDATE-TS             PIC X(26).                  
           05 WS-VOUCHER-REVERSED           PIC  X(09)                  
                                                      VALUE 'PANEL378A'.
T33431     05  MCSCB225                 PIC X(8) VALUE  'MCSCB225'.     
T33431     05  MCSCB224                 PIC X(8) VALUE  'MCSCB224'.     
T33431     05  WS-UTIL-ACCOUNT          PIC X.                          
T33431         88  UTIL-EXISTS          VALUE 'Y'.                      
T33431         88  NO-UTIL-EXISTS       VALUE 'N'.                      
      *                                                                         
T33431     05  WS-VALID-RATE-FL         PIC X.                          
T33431         88  VALID-RATE           VALUE 'Y'.                      
T33431         88  NOT-VALID-RATE       VALUE 'N'.                      
      *                                                                 01270000
       01 WS-LITERAL.                                                   
           05 WS-R                          PIC X(01) VALUE 'R'.        
           05 WS-FOUND-MULT-BILLS           PIC S9(04) COMP VALUE -811. 
      *                                                                 01270000
       01 PARM-FIELDS.                                                  
           05 PARM-PANEL-NO                 PIC X(08).                  
           05 PARM-CASH-COMPANY-NO          PIC X(02).                  
           05 PARM-CASH-LOCAL-OFFICE        PIC X(03).                  
           05 PARM-CASH-REPORT-NO           PIC X(03).                  
           05 PARM-DATE-CASH-REPORT         PIC X(10).                  
           05 PARM-CASH-DRAWER-ID           PIC S9(04) COMP.            
           05 PARM-CSR-PC-ID                PIC X(04).                  
      *                                                                 01380000
       01 COUNTER-FIELDS.                                               
           05 CTR-ROWS                      PIC S9(9) COMP VALUE 0.     
      *                                                                 01750000
       01 TDS-RETURN-FIELDS.                                            
           05 RS-RETURN-CODE                PIC S9(09) COMP VALUE +0.   
           05 S-RETURN-CODE                 PIC S9(09) COMP VALUE +0.   
           05 S-DNP-FLAG                    PIC X(01) VALUE 'N'.        
           05 S-AR-LOCKOUT-IND              PIC X(01) VALUE SPACE.      
           05 S-ACCT-XFER-TO                PIC X(13) VALUE SPACE.      
      *                                                                 01880000
      ************************                                          01980000
      *     S Q L C A        *                                          01980000
      ************************                                          01980000
           EXEC SQL                                                     01990000
              INCLUDE SQLCA                                             02000000
           END-EXEC.                                                    02010000
      *************************                                         01980000
      * CSS_LIEAP          LI *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02051000
              INCLUDE TBLIEAP                                           02052000
           END-EXEC.                                                    02053000
      *************************                                         01980000
      * CSS_CNT_DETAIL     EA *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02061000
              INCLUDE TBCNTDET                                          02062000
           END-EXEC.                                                    02063000
      *************************                                         01980000
      * CSS_FINAL_WO       FW *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02069400
              INCLUDE TBFINLWO                                          02069500
           END-EXEC.                                                    02069600
      *************************                                         01980000
      * CSS_CRED_COLL      CL *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02069800
              INCLUDE TBCRCOLL                                          02069900
           END-EXEC.                                                    02070000
      *************************                                         01980000
      * CSS_AR_CNTL        AC *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02071000
              INCLUDE TBARCNTL                                          02080000
           END-EXEC.                                                    02090000
      *************************                                         01980000
      * CSS_DFA_ACCT       DA *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02110000
              INCLUDE TBDFAACT                                          02120000
           END-EXEC.                                                    02130000
      *************************                                         01980000
      * CSS_BUDGET_HIST    BH *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02150000
              INCLUDE TBBGTHST                                          02160000
           END-EXEC.                                                    02170000
      *************************                                         01980000
      * CSS_BUDGET_PLAN    BU *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02190000
              INCLUDE TBBGTPLN                                          02200000
           END-EXEC.                                                    02210000
      *************************                                         01980000
      * CSS_AR_TRANS_HIST  AR *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02230000
              INCLUDE TBARHIST                                          02240000
           END-EXEC.                                                    02250000
      *************************                                         01980000
      * CSS_ACCOUNT        AT *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02270000
              INCLUDE TBACCT                                            02280000
           END-EXEC.                                                    02290000
      *************************                                         01980000
      * CSS_AR_LOCKOUT     AL *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02310000
              INCLUDE TBARLOCK                                          02320000
           END-EXEC.                                                    02330000
      *************************                                         01980000
      * CSS_CUSTOMER       CU *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02350000
              INCLUDE TBCUST                                            02360000
           END-EXEC.                                                    02370000
      *************************                                         01980000
      * CSS_PREMISE        PR *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02390000
              INCLUDE TBPREM                                            02400000
           END-EXEC.                                                    02410000
      *************************                                         01980000
      * CSS_CONTRACT       CT *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02470000
              INCLUDE TBCNTRCT                                          02480000
           END-EXEC.                                                    02490000
      *************************                                         01980000
      * CSS_AR_TRN_HST_DET AU *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02510000
              INCLUDE TBARHDT                                           02520000
           END-EXEC.                                                    02530000
      *************************                                         01980000
      * CSS_CSH_DRWR_CNTL  CS *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02550000
              INCLUDE TBCDCNTL                                          02560000
           END-EXEC.                                                    02570000
      *************************                                         01980000
      * CSS_CSH_DRWR_JRNL  CJ *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02550000
              INCLUDE TBCDJRNL                                          02560000
           END-EXEC.                                                    02570000
      *************************                                         01980000
      * CSS_BCH_JRNL_CNTL  BC *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02630000
              INCLUDE TBBJCNTL                                          02640000
           END-EXEC.                                                    02650000
      *************************                                         01980000
      * CSS_CHRG_OFF       CO *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02630000
              INCLUDE TBCHGOFF                                          02640000
           END-EXEC.                                                    02650000
      *************************                                         01980000
      * CSS_BATCH_JRNL     BJ *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02670000
              INCLUDE TBBTJRNL                                          02680000
           END-EXEC.                                                    02690000
      *************************                                         01980000
      * CSS_DEP_REQ        DR *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02710000
              INCLUDE TBDEPREQ                                          02720000
           END-EXEC.                                                    02730000
      *************************                                         01980000
      * CSS_MISC_JRNL      MJ *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02750000
              INCLUDE TBMSJRNL                                          02760000
           END-EXEC.                                                    02770000
      *************************                                         01980000
      * CSS_USER_PROFILE   PF *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02790000
              INCLUDE TBUSRPRF                                          02800000
           END-EXEC.                                                    02810000
      *************************                                         01980000
      * CSS_PROJ_SHARE     PJ *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02830000
              INCLUDE TBPRJSHR                                          02840000
           END-EXEC.                                                    02850000
      *************************                                         01980000
      * CSS_DFA_RECVBLE    DV *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02870000
              INCLUDE TBDFARCV                                          02880000
           END-EXEC.                                                    02890000
      *************************                                         01980000
      * CSS_GL_ACCT_NO     GO *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     02990000
              INCLUDE TBGLATNO                                          03000000
           END-EXEC.                                                    03010000
      *************************                                         01980000
      * CSS_DEP_PAY_HST    DP *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03110000
              INCLUDE TBDEPHST                                          03120000
           END-EXEC.                                                    03130000
      *************************                                         01980000
      * CSS_DEP_ON_HAND    DO *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03150000
              INCLUDE TBDEPHND                                          03160000
           END-EXEC.                                                    03170000
      *************************                                         01980000
      * CSS_CREDIT_PROFILE CZ *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03270000
              INCLUDE TBCRPROF                                          03280000
           END-EXEC.                                                    03290000
      *************************                                         01980000
      * CSS_CONNECT_CHRG   CC *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03880001
              INCLUDE TBCCCHRG                                          03890000
           END-EXEC.                                                    03900001
      *************************                                         01980000
      * CSS_LOCAL_OFFICE   B1 *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE TBLOCOFC                                          01533000
           END-EXEC.                                                    01534000
      *************************                                         01980000
      * CSS_JOB_PARM       G6 *                                         01980000
      *************************                                         01980000
T33431     EXEC SQL                                                             
T33431       INCLUDE TBJBPARM                                                   
T33431     END-EXEC.                                                            
      *************************                                         01980000
      * CSS_UTIL_ENVRNMT   UT *                                         01980000
      *************************                                         01980000
T33431     EXEC SQL                                                             
T33431       INCLUDE TBUTLENV                                                   
T33431     END-EXEC.                                                            
      *************************                                         01980000
      * CSS_RATE_PLAN_DESC RD *                                         01980000
      *************************                                         01980000
T33431     EXEC SQL                                                             
T33431       INCLUDE TBRTDESC                                                   
T33431     END-EXEC.                                                            
      *************************                                         01980000
      * CSS_DELINQUENCY    CF *                                         01980000
      *************************                                         01980000
C36929     EXEC SQL                                                             
C36929       INCLUDE TBDELQ                                                     
C36929     END-EXEC.                                                            
      *************************                                         01980000
      *    C W S 0 0 0 1 3 B  *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03310000
              INCLUDE CWS0013B                                          03320000
           END-EXEC.                                                    03330000
      *************************                                         01980000
      *    C W S 0 0 0 1 7    *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03350000
              INCLUDE CWS00017                                          03360000
           END-EXEC.                                                    03370000
      *************************                                         01980000
      *    C W S 0 0 0 6 1    *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03390000
              INCLUDE CWS00061                                          03400000
           END-EXEC.                                                    03410000
      *************************                                         01980000
      *    C W S 0 0 0 7 3    *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03430000
              INCLUDE CWS00073                                          03440000
           END-EXEC.                                                    03450000
      *************************                                         01980000
      *    C W S 0 1 1 6 A    *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     03470000
              INCLUDE CWS0116A                                          03480000
           END-EXEC.                                                    03490000
      *************************                                         01980000
      *    C W S X 0 0 1 0    *                                         01980000
      *************************                                         01980000
           EXEC SQL                                                     01532000
              INCLUDE CWSX0010                                          01533000
           END-EXEC.                                                    01534000
      *                                                                 01536000
       LINKAGE SECTION.                                                 
       01 I-ACCOUNT-NO                      PIC X(13).                  
       01 I-USER-ID                         PIC  X(07).                 
       01 I-PROGRAM-ID                      PIC  X(08).                 
       01 I-TIMESTAMP                       PIC  X(26).                 
       01 I-COMMENTS                        PIC  X(30).                 
      ******************************************************************03540000
      * P R O C E D U R E D I V I S I O N                              *03540000
      ******************************************************************03540000
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                              , I-TIMESTAMP                             
                              , I-PROGRAM-ID                            
                              , I-USER-ID                               
                              , I-COMMENTS                              
                              .                                         

SCA006        SET WS-GL-SUB TO 1.
      ******************************************************************03540000
      * 0000-MAINLINE                                                  *03550000
      *  CONTROLS THE MAIN PATH OF THE PROGRAM                         *03560000
      ******************************************************************03570000
       0000-MAINLINE.                                                   
      *                                                                 03600000
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                 03600000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03670000
      ******************************************************************03680000
      * 0100-INITIALIZE                                                *03690000
      ******************************************************************03760000
       0100-INITIALIZE.                                                 
      *                                                                 03670000
           MOVE '0100'                      TO ACTIVE-PARAGRAPH.        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE        AS RETURN_CODE              
                    , :S-DNP-FLAG           AS DNP_FLAG                 
                    , :S-AR-LOCKOUT-IND     AS AR_LOCAKOUT_IND          
                    , :S-ACCT-XFER-TO       AS ACCT_XFER_TO             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE        AS RETURN_CODE                      
MFA-TR*             , :S-DNP-FLAG           AS DNP_FLAG                         
MFA-TR*             , :S-AR-LOCKOUT-IND     AS AR_LOCAKOUT_IND                  
MFA-TR*             , :S-ACCT-XFER-TO       AS ACCT_XFER_TO                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                 05510000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05510000
      ******************************************************************05510000
      * 2000-PROCESS-OUTPUT.                                           *05520000
      ******************************************************************05590000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 05600000
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
           PERFORM 2200-PROCESS             THRU 2200-EXIT.             
      *                                                                 05650000
           IF CTR-ROWS < 1                                              
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                 05600000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05600000
      ******************************************************************06650000
      * 2200-PROCESS.                                                  *06660000
      ******************************************************************06670000
       2200-PROCESS.                                                    
      *                                                                 06700000
           PERFORM 7999-SELECT-AL           THRU 7999-SELECT-AL-EXIT.   
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000                     TO RS-RETURN-CODE           
              MOVE AL-AR-LOCKOUT-IND        TO S-AR-LOCKOUT-IND         
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
      *                                                                 06780000
           PERFORM 7000-GET-CURRENT-TIMESTAMP                           
                                            THRU 7000-EXIT.             
           MOVE I-ACCOUNT-NO                TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO               TO WS-ACCOUNT-NO-COMP3.     
           MOVE WS-ACCOUNT-NO               TO LI-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO-COMP3         TO AT-ACCOUNT-NO.           
           PERFORM 8000-UPDATE-AT-ACCT      THRU 8000-EXIT              
      *                                                                         
           PERFORM 7999-SELECT-TRANSFER-IND THRU                        
                   7999-SELECT-TRANSFER-IND-EXIT.                       
           MOVE AT-ACCT-XFER-TO             TO S-ACCT-XFER-TO.          
      *                                                                 06920000
           PERFORM 2300-CREATE-AR-FOR-REV   THRU 2300-EXIT.             
           MOVE I-USER-ID                   TO AR-USER-ID.              
           MOVE I-PROGRAM-ID                TO AR-APPL-PROGRAM-ID.      
           MOVE ZEROS                       TO WS-NULL-IND1             
                                               WS-NULL-IND2             
                                               WS-NULL-IND3.            
           MOVE 'C'                         TO AR-CODE-TRAN-TYPE.       
           MOVE AR-DATE-TRANS               TO AR-DATE-ORIG-PYMT.       
           MOVE WS-CURRENT-DATE             TO AR-DATE-TRANS.           
           MOVE I-COMMENTS                  TO WS-TRAN-COMMENT-TEXT.    
           MOVE 30                          TO WS-TRAN-COMMENT-LEN.     
           MOVE WS-TRAN-COMMENT-TEXT        TO AR-TRAN-COMMENT-TEXT.    
           MOVE WS-TRAN-COMMENT-LEN         TO AR-TRAN-COMMENT-LEN.     
           MOVE 'Y'                         TO WS-REVERSAL-FLAG.        
           MOVE PARM-CASH-COMPANY-NO        TO AR-CASH-COMPANY-NO.      
           MOVE PARM-CASH-LOCAL-OFFICE      TO AR-CASH-LOCAL-OFFICE.    
           MOVE PARM-CASH-REPORT-NO         TO AR-CASH-REPORT-NO.       
           MOVE PARM-DATE-CASH-REPORT       TO AR-DATE-CASH-REPORT.     
           MOVE PARM-CASH-DRAWER-ID         TO AR-CASH-DRAWER-ID.       
      *                                                                 06920000
           PERFORM 7150-INSERT-AR-TRANS-HIST                            
                                            THRU 7150-EXIT.             
           MOVE AR-AMT-ORIG-ENTERED         TO WS-AMOUNT-REFUNDED.      
           MOVE 'F'                         TO WS-PART-CASH-PROCESS-FLG.
           MOVE 'RVR'                       TO WS-CHECK-CASH-IND.       
      *    MOVE '183B'                      TO WS-116-NON-CASH-TRAN-NO. 07170000
           MOVE I-USER-ID                   TO WS-USER-ID.              
           MOVE AR-ACCOUNT-NO               TO AU-ACCOUNT-NO            
                                               AT-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO-COMP3         TO CZ-ACCOUNT-NO.           
      * CHECK IF PAYMENT CANCELLED A DNP IF SO SET DNP-FLAG             07220000
           PERFORM 7300-PROCESS-DNP         THRU 7300-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'N'                      TO S-DNP-FLAG               
           ELSE                                                         
              MOVE 'Y'                      TO S-DNP-FLAG               
           END-IF.                                                      
      *                                                                 07290000
           MOVE PARM-CASH-COMPANY-NO        TO WS-CD-COMPANY-NO.        
           MOVE PARM-CASH-LOCAL-OFFICE      TO WS-CD-LOCAL-OFFICE.      
           MOVE PARM-CASH-REPORT-NO         TO WS-CD-REPORT-NO.         
           MOVE PARM-DATE-CASH-REPORT       TO WS-CD-REPORT-DATE.       
           MOVE PARM-CASH-DRAWER-ID         TO WS-CASH-DRAWER-ID.       
           MOVE PARM-CSR-PC-ID              TO WS-JRNL-OL-CSR-PC-ID.    
           MOVE '3486'                      TO WS-CSH-DRWR-TRAN-ID      
      *                                                                 07360000
           PERFORM 6904-INSERT-AR-DETAILS   THRU 6904-EXIT.             
      *                                                                 07370100
           PERFORM 8110-DELETE-LI-ROW       THRU 8110-EXIT.             
      *                                                                 07380000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07410000
      ******************************************************************07420000
      * 2300-CREATE-AR-FOR-REV                                         *07430000
      ******************************************************************07440000
       2300-CREATE-AR-FOR-REV.                                          
      *                                                                 07410000
           MOVE I-TIMESTAMP                 TO AR-TRANS-HIST-SEQ-NO     
                                              WS-INPUT-TRANS-HIST-SEQ-NO
                                               WS-PREV-TRANS-HIST-SEQ-NO
                                               LI-VOUCHER-PAY-DT.       
           MOVE WS-ACCOUNT-NO-COMP3         TO AR-ACCOUNT-NO.           
           PERFORM 7100-SELECT-AR-TRANS-HIST                            
                                            THRU 7100-EXIT.             
           MOVE AR-CASH-COMPANY-NO          TO PARM-CASH-COMPANY-NO     
           MOVE AR-CASH-LOCAL-OFFICE        TO PARM-CASH-LOCAL-OFFICE.  
           MOVE AR-CASH-REPORT-NO           TO PARM-CASH-REPORT-NO.     
           MOVE AR-DATE-CASH-REPORT         TO PARM-DATE-CASH-REPORT.   
           MOVE AR-CASH-DRAWER-ID           TO PARM-CASH-DRAWER-ID.     
      *                                                                 07410000
           IF AR-DATE-ORIG-PYMT EQUAL SPACES                            
              MOVE -1                       TO WS-NULL-IND1             
                                               WS-DATE-ORIG-PYMT-IND    
           END-IF                                                       
      *                                                                 07410000
           IF AR-DATE-TRANS EQUAL SPACES                                
              MOVE -1                       TO WS-NULL-IND2             
           END-IF                                                       
      *                                                                 07410000
           IF AR-TRANS-HIST-SEQ-NO EQUAL SPACES                         
              MOVE -1                       TO WS-NULL-IND3             
           END-IF                                                       
      *                                                                 07410000
           MOVE 'Y'                         TO AR-PYMT-REFUNDED-IND.    
      *                                                                 07410000
           IF PARM-PANEL-NO = 'PANEL378'                                
              MOVE WS-VOUCHER-REVERSED      TO AR-APPL-PROGRAM-ID       
           ELSE                                                         
C33676        IF I-PROGRAM-ID = 'PCSAC184'                              
C33676           MOVE 'PCSAC184A'          TO AR-APPL-PROGRAM-ID        
C33676        ELSE                                                      
                 MOVE WS-PAYMENT-REVERSED  TO AR-APPL-PROGRAM-ID        
C33676        END-IF                                                    
           END-IF.                                                      
      *                                                                 07410000
           MOVE AR-DATE-TRANS               TO WS-PREV-DATE-TRANS.      
      *                                                                 07680000
      * CHECK IF BILLINGS OCCURED ATER PAYMENT IF NOT MARK JOURNAL      07690000
      * ENTRIES FOR RECORD ONLY.                                        07700000
           PERFORM 7250-PROCESS-RECORD-ONLY THRU 7250-EXIT.             
      * NOT-FOUND MEANS THERE WAS NO BILLING FOUND SO RECORD ONLY       07720000
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'Y'                      TO WS-RECORD-ONLY           
           END-IF.                                                      
      *                                                                 07720000
           MOVE WS-RECORD-ONLY              TO AR-RECORD-ONLY-FL.       
           PERFORM 7200-UPDATE-AR-TRANS-HIST                            
                                            THRU 7200-EXIT.             
           MOVE AR-TRANS-HIST-SEQ-NO(1:10)  TO WS-DATE                  
           MOVE AR-TRANS-HIST-SEQ-NO(12:8)  TO WS-TIME                  
           PERFORM 7251-GET-ADJ-RECORD      THRU 7251-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                   OR WS-FOUND-MULT-BILLS                               
              MOVE WS-ADJ-TRANS-HIST-SEQ-NO TO AR-TRANS-HIST-SEQ-NO     
              MOVE 'PANEL113H'              TO AR-APPL-PROGRAM-ID       
              PERFORM 7200-UPDATE-AR-TRANS-HIST                         
                                            THRU 7200-EXIT              
           END-IF                                                       
           PERFORM 7000-GET-CURRENT-TIMESTAMP                           
                                            THRU 7000-EXIT.             
      *                                                                 07470000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07810000
      ******************************************************************07820000
      * 6400 - FINANCIAL JOURNALING ROUTINE                            *07830000
      ******************************************************************07840000
      *                                                                 07810000
           EXEC SQL                                                     07850000
             INCLUDE CPD0006A                                           07860000
           END-EXEC.                                                    07870000
      *                                                                 07920000
           EXEC SQL                                                     07930000
              INCLUDE CPD00116                                          07940000
           END-EXEC.                                                    07950000
      *                                                                 07960000
      ****************************************************************  07990000
      * 7000-GET-CURRENT-TIMESTAMP.                               *     08000000
      ****************************************************************  08010000
       7000-GET-CURRENT-TIMESTAMP.                                      
      *                                                                 08020000
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08040000
MFA-TR*         SET :WS-CURRENT-TIMESTAMP   = CURRENT TIMESTAMP         08050000
MFA-TR*    END-EXEC.                                                    08060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08070000
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08080000
MFA-TR*         SET :WS-CURRENT-DATE        = CURRENT DATE              08090000
MFA-TR*    END-EXEC.                                                    08100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08110000
           MOVE WS-CURRENT-TIMESTAMP        TO AR-TRANS-HIST-SEQ-NO.    
      *                                                                 08130000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08160000
      ****************************************************************  08160000
      * 7100-SELECT-AR-TRANS-HIST                                 *     08170000
      ****************************************************************  08180000
       7100-SELECT-AR-TRANS-HIST.                                       
      *                                                                 08160000
           EXEC SQL                                                     
               SELECT DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      AMT_ORIG_ENTERED,                                 
                      AMT_BILLED_UNPAID,                                
                      RESP_AREA_ID,                                     
                      APPL_PROGRAM_ID,                                  
                      PYMT_FACILITY_CD,                                 
                      USER_ID,                                          
                      COMPANY_NO,                                       
                      RECORD_ONLY_FL,                                   
                      DATE_ORIG_PYMT,                                   
                      CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      CASH_REPORT_NO,                                   
                      DATE_CASH_REPORT,                                 
                      CASH_DRAWER_ID,                                   
                      TRAN_COMMENT                                      
                 INTO  :AR-DATE-TRANS :WS-NULL-IND1,                     
                       :AR-CODE-TRAN-TYPE,                              
                       :AR-AMT-ORIG-ENTERED,                            
                       :AR-AMT-BILLED-UNPAID,                           
                       :AR-RESP-AREA-ID,                                
                       :AR-APPL-PROGRAM-ID,                             
                       :AR-PYMT-FACILITY-CD,                            
                       :AR-USER-ID,                                     
                       :AR-COMPANY-NO,                                  
                       :AR-RECORD-ONLY-FL,                              
                       :AR-DATE-ORIG-PYMT :WS-NULL-IND2,                 
                       :AR-CASH-COMPANY-NO,                             
                       :AR-CASH-LOCAL-OFFICE,                           
                       :AR-CASH-REPORT-NO,                              
                       :AR-DATE-CASH-REPORT,                            
                       :AR-CASH-DRAWER-ID,                              
                       :AR-TRAN-COMMENT                                 
              FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO              = :AR-ACCOUNT-NO AND        
                    TRANS_HIST_SEQ_NO       = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )     
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08210000
MFA-TR*        SELECT DATE_TRANS,                                       08220000
MFA-TR*               CODE_TRAN_TYPE,                                   08230000
MFA-TR*               AMT_ORIG_ENTERED,                                 08240000
MFA-TR*               AMT_BILLED_UNPAID,                                08250000
MFA-TR*               RESP_AREA_ID,                                     08260000
MFA-TR*               APPL_PROGRAM_ID,                                  08270000
MFA-TR*               PYMT_FACILITY_CD,                                 08280000
MFA-TR*               USER_ID,                                          08290000
MFA-TR*               COMPANY_NO,                                       08300000
MFA-TR*               RECORD_ONLY_FL,                                   08310000
MFA-TR*               DATE_ORIG_PYMT,                                   08320000
MFA-TR*               CASH_COMPANY_NO,                                  08330000
MFA-TR*               CASH_LOCAL_OFFICE,                                08340000
MFA-TR*               CASH_REPORT_NO,                                   08350000
MFA-TR*               DATE_CASH_REPORT,                                 08360000
MFA-TR*               CASH_DRAWER_ID,                                   08370000
MFA-TR*               TRAN_COMMENT                                      08380000
MFA-TR*          INTO  :AR-DATE-TRANS:WS-NULL-IND1,                     08390000
MFA-TR*                :AR-CODE-TRAN-TYPE,                              08400000
MFA-TR*                :AR-AMT-ORIG-ENTERED,                            08410000
MFA-TR*                :AR-AMT-BILLED-UNPAID,                           08420000
MFA-TR*                :AR-RESP-AREA-ID,                                08430000
MFA-TR*                :AR-APPL-PROGRAM-ID,                             08440000
MFA-TR*                :AR-PYMT-FACILITY-CD,                            08450000
MFA-TR*                :AR-USER-ID,                                     08460000
MFA-TR*                :AR-COMPANY-NO,                                  08470000
MFA-TR*                :AR-RECORD-ONLY-FL,                              08480000
MFA-TR*                :AR-DATE-ORIG-PYMT:WS-NULL-IND2,                 08490000
MFA-TR*                :AR-CASH-COMPANY-NO,                             08500000
MFA-TR*                :AR-CASH-LOCAL-OFFICE,                           08510000
MFA-TR*                :AR-CASH-REPORT-NO,                              08520000
MFA-TR*                :AR-DATE-CASH-REPORT,                            08530000
MFA-TR*                :AR-CASH-DRAWER-ID,                              08540000
MFA-TR*                :AR-TRAN-COMMENT                                 08550000
MFA-TR*       FROM CSS_AR_TRANS_HIST                                    08560000
MFA-TR*       WHERE ACCOUNT_NO              = :AR-ACCOUNT-NO AND        08570000
MFA-TR*             TRANS_HIST_SEQ_NO       = :AR-TRANS-HIST-SEQ-NO     08580000
MFA-TR*             WITH UR                                                     
MFA-TR*    END-EXEC.                                                    08590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08160000
           IF WS-NULL-IND1 < 0                                          
              MOVE SPACES                   TO AR-DATE-TRANS            
           END-IF.                                                      
      *                                                                 08160000
           IF WS-NULL-IND2 < 0                                          
              MOVE SPACES                   TO AR-DATE-ORIG-PYMT        
           END-IF.                                                      
      *                                                                 08160000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                            OR NOT-FOUND                
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                            THRU 9000-EXIT              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                            THRU 9900-EXIT
           END-IF.             
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08850000
      * 7150-INSERT-AR-TRANS-HIST                                     * 08860000
      ***************************************************************** 08870000
       7150-INSERT-AR-TRANS-HIST.                                       
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_AR_TRANS_HIST                            
                   ( ACCOUNT_NO,                                        
                     TRANS_HIST_SEQ_NO,                                 
                     DATE_TRANS,                                        
                     CODE_TRAN_TYPE,                                    
                     AMT_ORIG_ENTERED,                                  
                     AMT_BILLED_UNPAID,                                 
                     RESP_AREA_ID,                                      
                     APPL_PROGRAM_ID,                                   
                     PYMT_FACILITY_CD,                                  
                     USER_ID,                                           
                     COMPANY_NO,                                        
                     RECORD_ONLY_FL,                                    
                     DATE_ORIG_PYMT,                                    
                     PYMT_REFUNDED_IND,                                 
                     CASH_COMPANY_NO,                                   
                     CASH_LOCAL_OFFICE,                                 
                     CASH_REPORT_NO,                                    
                     DATE_CASH_REPORT,                                  
                     CASH_DRAWER_ID,                                    
                     TRAN_COMMENT )                                     
               VALUES                                                   
                  ( :AR-ACCOUNT-NO,                                     
                    CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO 
                                       :WS-NULL-IND3),                 
                    IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:AR-DATE-TRANS :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-TRANS :WS-NULL-IND2
              ), CONVERT(DATE, :AR-DATE-TRANS :WS-NULL-IND2) ),                
                    :AR-CODE-TRAN-TYPE,                                 
                    :AR-AMT-ORIG-ENTERED,                               
                    :AR-AMT-BILLED-UNPAID,                              
                    :AR-RESP-AREA-ID,                                   
                    :AR-APPL-PROGRAM-ID,                                
                    :AR-PYMT-FACILITY-CD,                               
                    :AR-USER-ID,                                        
                    :AR-COMPANY-NO,                                     
                    :AR-RECORD-ONLY-FL,                                 
                    IIF(TRY_CONVERT(DATE, :AR-DATE-ORIG-PYMT 
                                          :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT :WS-NULL-IND1
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT :WS-NULL-IND1) ),            
                    :AR-PYMT-REFUNDED-IND,                              
                    :AR-CASH-COMPANY-NO,                                
                    :AR-CASH-LOCAL-OFFICE,                              
                    :AR-CASH-REPORT-NO,                                 
                    IIF(TRY_CONVERT(DATE, :AR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT) ),                        
                    :AR-CASH-DRAWER-ID,                                 
                    :AR-TRAN-COMMENT )                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08890000
MFA-TR*        INSERT INTO CSS_AR_TRANS_HIST                            08900000
MFA-TR*            ( ACCOUNT_NO,                                        08910000
MFA-TR*              TRANS_HIST_SEQ_NO,                                 08920000
MFA-TR*              DATE_TRANS,                                        08930000
MFA-TR*              CODE_TRAN_TYPE,                                    08940000
MFA-TR*              AMT_ORIG_ENTERED,                                  08950000
MFA-TR*              AMT_BILLED_UNPAID,                                 08960000
MFA-TR*              RESP_AREA_ID,                                      08970000
MFA-TR*              APPL_PROGRAM_ID,                                   08980000
MFA-TR*              PYMT_FACILITY_CD,                                  08990000
MFA-TR*              USER_ID,                                           09000000
MFA-TR*              COMPANY_NO,                                        09010000
MFA-TR*              RECORD_ONLY_FL,                                    09020000
MFA-TR*              DATE_ORIG_PYMT,                                    09030000
MFA-TR*              PYMT_REFUNDED_IND,                                 09040000
MFA-TR*              CASH_COMPANY_NO,                                   09050000
MFA-TR*              CASH_LOCAL_OFFICE,                                 09060000
MFA-TR*              CASH_REPORT_NO,                                    09070000
MFA-TR*              DATE_CASH_REPORT,                                  09080000
MFA-TR*              CASH_DRAWER_ID,                                    09090000
MFA-TR*              TRAN_COMMENT )                                     09100000
MFA-TR*        VALUES                                                   09110000
MFA-TR*           ( :AR-ACCOUNT-NO,                                     09120000
MFA-TR*             :AR-TRANS-HIST-SEQ-NO:WS-NULL-IND3,                 09130000
MFA-TR*             :AR-DATE-TRANS:WS-NULL-IND2,                        09140000
MFA-TR*             :AR-CODE-TRAN-TYPE,                                 09150000
MFA-TR*             :AR-AMT-ORIG-ENTERED,                               09160000
MFA-TR*             :AR-AMT-BILLED-UNPAID,                              09170000
MFA-TR*             :AR-RESP-AREA-ID,                                   09180000
MFA-TR*             :AR-APPL-PROGRAM-ID,                                09190000
MFA-TR*             :AR-PYMT-FACILITY-CD,                               09200000
MFA-TR*             :AR-USER-ID,                                        09210000
MFA-TR*             :AR-COMPANY-NO,                                     09220000
MFA-TR*             :AR-RECORD-ONLY-FL,                                 09230000
MFA-TR*             :AR-DATE-ORIG-PYMT:WS-NULL-IND1,                    09240000
MFA-TR*             :AR-PYMT-REFUNDED-IND,                              09250000
MFA-TR*             :AR-CASH-COMPANY-NO,                                09260000
MFA-TR*             :AR-CASH-LOCAL-OFFICE,                              09270000
MFA-TR*             :AR-CASH-REPORT-NO,                                 09280000
MFA-TR*             :AR-DATE-CASH-REPORT,                               09290000
MFA-TR*             :AR-CASH-DRAWER-ID,                                 09300000
MFA-TR*             :AR-TRAN-COMMENT )                                  09310000
MFA-TR*    END-EXEC.                                                    09320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'AMT_ORIG_ENTERED'       TO TABLE-ELEMENT-2          
              MOVE 'DATE_TRANS'             TO TABLE-ELEMENT-3          
              MOVE 'DATE_CASH_REPORT'       TO TABLE-ELEMENT-4          
              MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE AR-AMT-ORIG-ENTERED      TO HOSTVAR-ELEMENT-2-N      
              MOVE AR-DATE-TRANS            TO HOSTVAR-ELEMENT-3        
              MOVE AR-DATE-CASH-REPORT      TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                            THRU 9000-EXIT              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                            THRU 9900-EXIT
           END-IF.             
      *                                                                 09490000
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09490000
      ****************************************************************  09490000
      * 7200-UPDATE-AR-TRANS-HIST                                 *     09500000
      ****************************************************************  09510000
       7200-UPDATE-AR-TRANS-HIST.                                       
      *                                                                 09490000
           EXEC SQL                                                     
               UPDATE CSS_AR_TRANS_HIST                                 
                  SET USER_ID               = :AR-USER-ID,              
                      APPL_PROGRAM_ID       = :AR-APPL-PROGRAM-ID,      
                      PYMT_REFUNDED_IND     = :AR-PYMT-REFUNDED-IND,    
                      RECORD_ONLY_FL        = :AR-RECORD-ONLY-FL        
                WHERE ACCOUNT_NO            = :AR-ACCOUNT-NO            
                  AND TRANS_HIST_SEQ_NO     = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09530000
MFA-TR*        UPDATE CSS_AR_TRANS_HIST                                 09540000
MFA-TR*           SET USER_ID               = :AR-USER-ID,              09550000
MFA-TR*               APPL_PROGRAM_ID       = :AR-APPL-PROGRAM-ID,      09560000
MFA-TR*               PYMT_REFUNDED_IND     = :AR-PYMT-REFUNDED-IND,    09570000
MFA-TR*               RECORD_ONLY_FL        = :AR-RECORD-ONLY-FL        09580000
MFA-TR*         WHERE ACCOUNT_NO            = :AR-ACCOUNT-NO            09590000
MFA-TR*           AND TRANS_HIST_SEQ_NO     = :AR-TRANS-HIST-SEQ-NO     09600000
MFA-TR*    END-EXEC.                                                    09610000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09490000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PYMT_REFUNDED_IND'      TO TABLE-ELEMENT-2          
              MOVE 'USER_ID'                TO TABLE-ELEMENT-3          
              MOVE 'APPL_PROGRAM_ID'        TO TABLE-ELEMENT-4          
              MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE AR-PYMT-REFUNDED-IND     TO HOSTVAR-ELEMENT-2        
              MOVE AR-USER-ID               TO HOSTVAR-ELEMENT-3        
              MOVE AR-APPL-PROGRAM-ID       TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                            THRU 9000-EXIT              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                            THRU 9900-EXIT
           END-IF.             
      *                                                                 09490000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09490000
      ****************************************************************  09780000
      * 7250-PROCESS-RECORD-ONLY.                                   *   09790000
      * THE SELECT DETERMINES IF A BILLING OCCURRED AFTER THE       *   09800000
      * PAYMENT WAS MADE. IF NOT THIS MEANS THE JOURNALING IS FOR   *   09810000
      * RECORDS ONLY. NOTE THIS SELECT MAY BRING BACK MORE THAN ONE  *  09820000
      * ROW IF SO MULTIPLE BILLINGS HAVE OCCURED.                   *   09830000
      ****************************************************************  09840000
       7250-PROCESS-RECORD-ONLY.                                        
      *                                                                 09490000
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
              INTO :WS-TRANS-HIST-SEQ-NO                                
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO              = :AR-ACCOUNT-NO            
              AND TRANS_HIST_SEQ_NO         > CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )     
              AND CODE_TRAN_TYPE            = 'B'                       
              AND CIS.SUBSTR3(APPL_PROGRAM_ID,1,5) IN ('PCSCA','SCSCA')      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09860000
MFA-TR*       SELECT TRANS_HIST_SEQ_NO                                  09870000
MFA-TR*       INTO :WS-TRANS-HIST-SEQ-NO                                09880000
MFA-TR*         FROM CSS_AR_TRANS_HIST                                  09890000
MFA-TR*       WHERE ACCOUNT_NO              = :AR-ACCOUNT-NO            09900000
MFA-TR*       AND TRANS_HIST_SEQ_NO         > :AR-TRANS-HIST-SEQ-NO     09910000
MFA-TR*       AND CODE_TRAN_TYPE            = 'B'                       09920000
MFA-TR*       AND SUBSTR(APPL_PROGRAM_ID,1,5) IN ('PCSCA','SCSCA')      09930000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    09940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09490000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND OR WS-FOUND-MULT-BILLS                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                            THRU 9000-EXIT              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                            THRU 9900-EXIT
           END-IF.             
      *                                                                 09770000
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09770000
      ****************************************************************  09780000
      * 7251-GET-ADJ-RECORD.                                         *  09790000
      * THE SELECT GETS THE ADJ RECORD FOR THE PAYMENT TO BE         *  09800000
      * REVERSED. WHEN THE PAYMENT ROW IS REVERSED THE RECORD ONLY   *  09810000
      * FLAG FOR THE ADJ ROW SHOULD ALSO BE SET                      *  09820000
      ****************************************************************  09840000
       7251-GET-ADJ-RECORD.                                             
      *                                                                 09770000
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
              INTO :WS-ADJ-TRANS-HIST-SEQ-NO                            
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO              = :AR-ACCOUNT-NO            
              AND TRANS_HIST_SEQ_NO        <= CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )     
              AND DATE_TRANS                = IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )            
              AND CODE_TRAN_TYPE            = 'A'                       
              AND APPL_PROGRAM_ID           = 'PANEL113H'               
              AND CAST(TRANS_HIST_SEQ_NO AS DATE)   = 
              IIF(TRY_CONVERT(DATE, :WS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE) <> 0) OR (LEN(
                                                               :WS-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-DATE), CONVERT(DATE, :WS-DATE
              ) )                  
              AND DATEADD(NANOSECOND, -DATEPART(NANOSECOND, CAST(
           TRANS_HIST_SEQ_NO AS TIME)), CAST(TRANS_HIST_SEQ_NO
            AS TIME))   = CIS.CHAR2TIME(:WS-TIME)                  
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09860000
MFA-TR*       SELECT TRANS_HIST_SEQ_NO                                  09870000
MFA-TR*       INTO :WS-ADJ-TRANS-HIST-SEQ-NO                            09880000
MFA-TR*         FROM CSS_AR_TRANS_HIST                                  09890000
MFA-TR*       WHERE ACCOUNT_NO              = :AR-ACCOUNT-NO            09900000
MFA-TR*       AND TRANS_HIST_SEQ_NO        <= :AR-TRANS-HIST-SEQ-NO     09910000
MFA-TR*       AND DATE_TRANS                = :AR-DATE-TRANS                    
MFA-TR*       AND CODE_TRAN_TYPE            = 'A'                       09920000
MFA-TR*       AND APPL_PROGRAM_ID           = 'PANEL113H'                       
MFA-TR*       AND DATE(TRANS_HIST_SEQ_NO)   = :WS-DATE                  09930000
MFA-TR*       AND TIME(TRANS_HIST_SEQ_NO)   = :WS-TIME                  09930000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    09940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09770000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND OR WS-FOUND-MULT-BILLS                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7251'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                            THRU 9000-EXIT              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                            THRU 9900-EXIT
           END-IF.             
      *                                                                 10110000
       7251-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10110000
      ***************************************************************** 10130000
      * 7300-PROCESS-DNP.                                             * 10140000
      * CHECK IF THE FIRST CHARACTOR IN DISCCONNECT_HIST AND          * 10150000
      * DISC_EXCEPTN_HIST = R IF SO SEND BACK FLAG TO INDICATE A      * 10160000
      * DNP MESSAGE NEEDS TO GO BACK TO THE USER.                     * 10170000
      ***************************************************************** 10180000
       7300-PROCESS-DNP.                                                
      *                                                                 10110000
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO :WS-R                                                
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
              WHERE ACCOUNT_NO              = :CZ-ACCOUNT-NO            
              AND ( CIS.SUBSTR3(DISCONNECT_HIST,1,1) IN ('R')                
               OR CIS.SUBSTR3(DISC_EXCEPTN_HIST,1,1) IN ('R'))               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     10200000
MFA-TR*       SELECT 'Y'                                                10210000
MFA-TR*       INTO :WS-R                                                10220000
MFA-TR*         FROM CSS_CREDIT_PROFILE                                 10230000
MFA-TR*       WHERE ACCOUNT_NO              = :CZ-ACCOUNT-NO            10240000
MFA-TR*       AND ( SUBSTR(DISCONNECT_HIST,1,1) IN ('R')                10250000
MFA-TR*        OR SUBSTR(DISC_EXCEPTN_HIST,1,1) IN ('R'))               10260000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    10270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10280000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CREDIT_PROFILE'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE CZ-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                            THRU 9000-EXIT              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                            THRU 9900-EXIT
           END-IF.             
      *                                                                 10420000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10420000
      ******************************************************************07420000
      * 8000-UPDATE-AT-ACCT                                            *07430000
      * TO UPDATE LAST_UPDATE_TS IN CSS_ACCOUNT                        *        
      ******************************************************************07440000
       8000-UPDATE-AT-ACCT.                                             
      *                                                                 07470000
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET LAST_UPDATE_TS        = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )     
                WHERE ACCOUNT_NO            = :AT-ACCOUNT-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET LAST_UPDATE_TS        = :WS-CURRENT-TIMESTAMP             
MFA-TR*         WHERE ACCOUNT_NO            = :AT-ACCOUNT-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT                           
                                            THRU 9000-EXIT              
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 07820000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07820000
      ******************************************************************10420200
      * 8110-DELETE-LI-ROW.                                            *10420100
      *  THIS PARAGRAPH IS USED TO INSERT A ROW IN THE                 *10420300
      *  CSS_LIEAP   TABLE                                             *10420400
      ******************************************************************10420500
       8110-DELETE-LI-ROW.                                              
      *                                                                 10420600
           MOVE '8110'                       TO ACTIVE-PARAGRAPH.       
           EXEC SQL                                                     
             DELETE FROM  CSS_LIEAP                                     
             WHERE                                                      
                  ACCOUNT_NO                 = :LI-ACCOUNT-NO           
                  AND VOUCHER_PAY_DT         = CIS.CHAR2TIMESTAMP(
                                                     :LI-VOUCHER-PAY-DT
              )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10420800
MFA-TR*      DELETE FROM  CSS_LIEAP                                     10420900
MFA-TR*      WHERE                                                      10421000
MFA-TR*           ACCOUNT_NO                 = :LI-ACCOUNT-NO           10421100
MFA-TR*           AND VOUCHER_PAY_DT         = :LI-VOUCHER-PAY-DT       10421200
MFA-TR*    END-EXEC.                                                    10421400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10421500
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE.         
      *                                                                 10421800
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
               WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
              MOVE ZERO                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE          
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_LIEAP'               TO TABLE-1                 
              MOVE 'ACCOUNT-NO    '          TO TABLE-ELEMENT-1         
              MOVE 'VOUCHER_PAY_DT'          TO TABLE-ELEMENT-2         
              MOVE LI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE LI-VOUCHER-PAY-DT         TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
      *                                                                 10470000
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10470000
      ******************************************************************10470000
      *  INCLUDE COPYBOOKS FOR AR LOCKOUT AND AT XREF.                 *10480000
      ******************************************************************10490000
      *                                                                 10500000
           EXEC SQL                                                     10510000
              INCLUDE CPD00075                                          10520000
           END-EXEC.                                                    10530000
      *                                                                 10540000
           EXEC SQL                                                     10550000
              INCLUDE CPD00307                                          10560000
           END-EXEC.                                                    10570000
      *                                                                         
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           ADD 1                             TO CTR-ROWS.               
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------*         
      *   OPEN THE RESULT SET CURSOR                                  *         
      *---------------------------------------------------------------*         
       8900-SEND-DONE.                                                  
      *                                                                         
           MOVE RS-RETURN-CODE               TO S-RETURN-CODE           
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *9000-SEND-ERROR-RESULT.                                         *        
      * SENDS ERROR RESULT                                             *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
             MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE          
                                                ABEND-SQLCODE.          
      *                                                                         
             EXEC SQL                                                   
               ROLLBACK                                                 
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             IF SQLCODE = 0                                             
                CONTINUE                                                
             ELSE                                                       
                MOVE 'ROLLBACK'              TO ABEND-FUNCTION          
             END-IF.                                                    
      *                                                                         
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           IF CTR-ROWS < 1                                              
      *---------------------------------------------------------------*         
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!    *         
      *---------------------------------------------------------------*         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '9999-END-PROGRAM'        TO ABEND-FUNCTION          
              MOVE 'PROGRAMMER LOGIC'        TO TABLE-1                 
              MOVE 'FAILED TO SEND'          TO TABLE-ELEMENT-1         
              MOVE 'RESULT SET'              TO HOSTVAR-ELEMENT-1       
              MOVE -1                        TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           ELSE                                                         
              PERFORM 8900-SEND-DONE         THRU 8900-EXIT             
           END-IF                                                       
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
