       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  CSR03451.                                           
       AUTHOR.      PALASH DAS.                                         
COB303 DATE-WRITTEN. JULY 2004.                                          
       DATE-COMPILED.                                                   
      ***************************************************************           
      **                SOUTH CAROLINA ELECTRIC & GAS              **           
      ***************************************************************           
      **                 STORED PROCEDURE:  CSR03451               **           
      ***************************************************************           
      *                         S U M M A R Y                       *           
      ***************************************************************           
      **CSR03413 :                                                 **           
      **  #  GETS MATRIX SCORE                                     **           
      **  #  HISTORY                                               **           
      ***************************************************************           
      **  PARAMETERS                                               **           
      **      IN                                                   **           
      **                                                           **           
      **            TIMESTAMP                    TIMESTAMP         **           
      **            ACCOUNT_NO                   CHAR(13)          **           
      **            BEACON_SCORE                 CHAR(05)          **           
      **            UPADATE_FLAG                 CHAR(05)          **           
      **            BILL_NO                      CHAR(05)          **           
      **      OUT                                                  **           
      **            CELL_SCORE                   CHAR(08)          **           
      **            WGT_SCORE                    CHAR(08)          **           
      **            RATING                       CHAR(01)          **           
      **            RETURN_CODE                  INTEGER           **           
      **                                                           **           
      **      INOUT                                                **           
      **                                                           **           
      **            NONE                                           **           
      **                                                           **           
      ***************************************************************           
      **                 MODIFICATION LOG                          **           
      **                                                           **           
      ** DATE      INITIALS    COMMENTS                            **           
      ***************************************************************           
C30257*-- 06/07/2004 PALASH DAS FIX BHV SCORING PROBLEM         **              
ACT054*-- 05/25/2011 BD09555    IF NEGATIVE NUMBER OF DAYS,     **              
ACT054*-- A03967                CHANGE TO ZERO TO PREVENT ERROR **              
ACT054*-- A03967                IN LOG FUNCTION.                **              
A04527*-- 06/07/13   AS7C117    REMOVE UNUSED COPYBOOK CWS00056.**              
      ***************************************************************           
      ***************************************************************           
      *                                                                         
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
      *                                                                         
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03451'.
MSQ017     COPY MFASQLM.
      **************************************************************            
      *   DB2 INCLUDES                                             *            
      **************************************************************            
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_MODEL_SQL                                                           
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
      ************************************************************              
      **   CSS_ACCOUNT **                                                       
      ************************************************************              
           EXEC SQL                                                             
            INCLUDE TBACCT                                                      
           END-EXEC.                                                            
      ************************************************************              
      **   CSS_REG_PROFILE                                                      
      ************************************************************              
           EXEC SQL                                                             
            INCLUDE TBREGPRF                                                    
           END-EXEC.                                                            
      ************************************************************              
      **   CSS_BHV_MODEL                                                        
      ************************************************************              
           EXEC SQL                                                             
            INCLUDE TBBHMODL                                                    
           END-EXEC.                                                            
      ************************************************************              
      **   CSS_CREDIT_PROFILE                                                   
      ************************************************************              
           EXEC SQL                                                             
            INCLUDE TBCRPROF                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_CATEGORY                                                     
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBHVCAT                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_CRITERIA                                                     
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBCRITRA                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_ACCT_SCORE                                                   
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBACSCRE                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_SCORE                                                        
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBHVSCR                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_SCOR_MODL                                                    
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBHSCRE                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_SCOR_RATING                                                  
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBSCRRAT                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_CATEG_MODL                                                   
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBCATMDL                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    ERROR PROCESSING WORKING STORAGE                                     
      **************************************************************            
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CWS09900.                                                       
      ************************************************************              
      *--  ERROR PROCESSING VARIABLES                           **              
      ************************************************************              
       01  WS-CSRERLOG-P.                                               
           10  WS-SP-NAME               PIC X(18)  VALUE SPACES.        
           10  WS-SQLCODE               PIC S9(9)  VALUE 0 COMP.        
           10  WS-SQLSTATE              PIC X(05)  VALUE SPACES.        
           10  WS-TABLE-NAME            PIC X(18)  VALUE SPACES.        
                                                                        
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L  PIC S9(4)  USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V  PIC X(255).                     
       01  WS-WORK-VARIABLES.                                           
           05  WS-ERR-MSG               PIC X(100) VALUE SPACES.        
           05  WS-ERR-MSG2              PIC X(100) VALUE SPACES.        
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03451'.      
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-NAME                PIC X(26) VALUE                  
                                           'SESSION.CSR03451_R1'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
      *                                                                         
       01  LS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
      *                                                                         
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
       01  WS-GTT-RETURN-FIELDS.                                        
           10 WS-RETURN-CODE            PIC S9(9)  VALUE 0 COMP.        
           10 WS-TIMESTAMP              PIC X(26)  VALUE SPACES.        
           10 WS-COMPANY-NO             PIC X(04)  VALUE SPACES.        
       01  WS-CONSTANTS.                                                
           05  WS-SYSTEM                PIC X(07)  VALUE 'SYSTEM'.      
           05  WS-PCSCA456              PIC X(08)  VALUE 'PCSCA456'.    
           05  WS-PGRMNAME              PIC X(08)  VALUE 'CSR03451'.    
           05  WS-JRNL-NAME             PIC X(04)  VALUE '3451'.        
           05  WS-1                     PIC X(01) VALUE '1'.            
           05  WS-2                     PIC X(01) VALUE '2'.            
           05  WS-3                     PIC X(01) VALUE '3'.            
           05  WS-4                     PIC X(01) VALUE '4'.            
           05  WS-5                     PIC X(01) VALUE '5'.            
           05  WS-6                     PIC X(01) VALUE '6'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-ONE                   PIC 9(01) VALUE 1.              
           05  WS-TWO                   PIC 9(01) VALUE 2.              
           05  WS-THREE                 PIC 9(01) VALUE 3.              
           05  WS-FOUR                  PIC 9(01) VALUE 4.              
           05  WS-FIVE                  PIC 9(01) VALUE 5.              
           05  WS-SIX                   PIC 9(01) VALUE 6.              
           05  WS-SEVEN                 PIC 9(01) VALUE 7.              
           05  WS-EIGHT                 PIC 9(01) VALUE 8.              
           05  WS-NINE                  PIC 9(01) VALUE 9.              
           05  WS-HUNDRED               PIC 9(03) VALUE 100.            
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-NO                    PIC X(01) VALUE 'N'.            
           05  WS-MODEL-STATUS-A        PIC X(01) VALUE 'A'.            
           05  WS-MODEL-STATUS-F        PIC X(01) VALUE 'F'.            
           05  WS-MODEL-STATUS-I        PIC X(01) VALUE 'I'.            
           05  WS-MODEL-STATUS-E        PIC X(01) VALUE 'E'.            
           05  WS-MATCH-FLAG            PIC X(01) VALUE 'N'.            
           05  WS-END-FETCH             PIC X(01) VALUE 'N'.            
           05  WS-TRAN-COMMENT-LEN      PIC S9(04) COMP VALUE +19.      
           05  WS-TRAN-COMMENT-TEXT     PIC X(34) VALUE                 
                                        'THIRD PARTY JOURNAL'.          
       01  WS-SWITCHES.                                                 
           05 WS-INPUT-ERROR-SW        PIC X(01) VALUE SPACES.          
              88 ACCOUNT-NOT-FOUND     VALUE 'A'.                       
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-ARRAY.                                                    
           05  WS-COORDINATE-ARRAY OCCURS 1000 TIMES.                   
             10  WS-COORD-DIMENSION          PIC 9(4).                  
             10  WS-COORD-CATEGORY           PIC 9(4).                  
       01  WS-MISC-ITEMS.                                               
           05  WS-USER-ABEND-CODE          PIC S9(4) COMP VALUE +100.   
           05  ILBOABN0                    PIC X(8) VALUE 'ILBOABN0'.   
           05  WS-ACCOUNT-NO               PIC X(13).                   
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO PIC 9(13).     
           05  WS-AGE-IN-DAYS              PIC S9(04) COMP.             
           05  WS-AGE-IN-MONTHS            PIC S9(04) COMP.             
           05  WS-COUNT                    PIC S9(04) COMP.             
           05  WS-COORD-MATCH-COUNT        PIC S9(04) COMP.             
           05  WS-COORD-COUNT              PIC S9(04) COMP.             
           05  WS-PRESENT                  PIC X(01).                   
           05  WS-DATABASE                 PIC X(08) VALUE              
                                           'DATABASE'.                  
COB305     05 WS-SCORE-VALUE        PIC S9(8)V9(5) USAGE COMP-3 VALUE 0. 
           05  WS-COMB                     PIC S9(8)V9(5) USAGE COMP-3  
                                           VALUE 0.                     
COB305     05 WS-SCORE        PIC S9(8)V9(5) USAGE COMP-3 VALUE 0. 
           05  WS-SCORE-NUM                PIC 9(4).                    
COB305     05 WS-SCORE-RATING        PIC S9(8)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
           05  WS-VALUE                    PIC S9(5)V9(2).              
           05  WS-GROUP-CD                 PIC 9(3).                    
                                                                        
       01  WS-ACTIVE-RETURN-CODE-NEW.                                   
           05  RS-RETURN-CODE          PIC S9(9)  VALUE 0 COMP.         
           05  WS-REV-DATE.                                             
               10 WS-REV-YY            PIC X(04)  VALUE SPACES.         
               10 FILLER               PIC X(01)  VALUE '-'.            
               10 WS-REV-MM            PIC X(02)  VALUE SPACES.         
               10 FILLER               PIC X(01)  VALUE '-'.            
               10 WS-REV-DD            PIC X(02)  VALUE '01'.           
      ************************************************************              
      *--             VARIABLES IN USE                          **              
      ************************************************************              
       01  WS-WORKING-VARIABLES.                                        
           05    WS-NO-REVENUE-CLASS        PIC 9(11).                  
           05    WS-REVENUE-CLASS           PIC X(3).                   
           05    WS-COMPANY-NO              PIC X(02).                  
           05    WS-REGULATED-FLAG          PIC X(05).                  
           05    WS-DATE-BILLED             PIC X(10).                  
           05    WS-REVENUE-MONTH           PIC 9(6).                   
           05    WS-NO-OF-RECORDS           PIC 9(11).                  
           05    WS-REVENUE-CLASS-MODEL     PIC X(01).                  
           05    WS-MODEL-ID                PIC X(09).                  
           05    WS-MODEL-NAME              PIC X(13).                  
           05    WS-MODEL-STYLE             PIC X(11).                  
           05    WS-WEIGHTAGE            PIC X(10) VALUE 'WEIGHTAGE'.   
           05    WS-MATRIX               PIC X(09) VALUE 'MATRIX'.      
           05    WS-RECORD-BHV-MODEL-ID-COUNT   PIC 9(09).              
           05    WS-DISCONNECT-HIST         PIC X(24).                  
           05    WS-LEN-DISCONNECT-HIST     PIC 9(1).                   
           05    WS-ARREARS-HIST            PIC X(24).                  
           05    WS-30D-ARREARS             PIC 9(04) VALUE ZERO.       
           05    WS-60D-ARREARS             PIC 9(04) VALUE ZERO.       
           05    WS-90D-ARREARS             PIC 9(04) VALUE ZERO.       
           05    WS-POSITION                PIC 9(04) COMP VALUE 1.     
           05    WS-ONE1                    PIC 9(04) COMP VALUE 1.     
           05    WS-MONTHLY-ARREAR          PIC X(01).                  
           05    WS-LEN-ARREARS-HIST        PIC 9(4).                   
           05    WS-NO-OF-SONP              PIC 9(04) VALUE ZERO.       
           05    WS-MONTHLY-SONP            PIC X(01).                  
           05    WS-LAST-CATEGORY-ID        PIC 9(04) VALUE ZERO.       
           05    WS-CATEGORY-ID             PIC 9(04).                  
           05    WS-CRITERIA-TYPE           PIC X(26).                  
           05    WS-CRITERIA-MIN-VALUE      PIC 9(12)V9(2).             
           05    WS-CRITERIA-MAX-VALUE      PIC 9(12)V9(2).             
           05    WS-ACCT-CREATE-MO          PIC S9(08) COMP.            
           05    WS-BEACON-SCORE            PIC 9(05).                  
           05    WS-WGT-VALUE               PIC 9(12)V9(2).             
           05    WS-MONTHS            PIC X(07) VALUE 'MONTHS'.         
           05    WS-BEACON            PIC X(07) VALUE 'BEACON'.         
           05    WS-30-D-ARREARS      PIC X(13) VALUE '30-D ARREARS'.   
           05    WS-60-D-ARREARS      PIC X(13) VALUE '60-D ARREARS'.   
           05    WS-90-D-ARREARS      PIC X(13) VALUE '90-D ARREARS'.   
           05    WS-SONP              PIC X(05) VALUE 'SONP'.           
           05    WS-INQUERY-STR       PIC X(1000).                      
           05    WS-OUTQUERY-STR      PIC X(1000).                      
           05    WS-CELL-ID           PIC X(04).                        
       01 WS-CURRENT-DATE.                                              
           05    WS-CURRENT-CC        PIC X(02).                        
           05    WS-CURRENT-YEAR      PIC X(04).                        
           05    WS-CURRENT-MONTH     PIC X(02).                        
           05    WS-CURRENT-DATE      PIC X(02).                        
       01 WS-ACCT-CREATE-DT.                                            
           05    WS-ACCT-CREATE-YEAR  PIC X(04).                        
           05    WS-ACCT-CREATE-MONTH PIC X(02).                        
           05    WS-ACCT-CREATE-DATE  PIC X(02).                        
      ************************************************************              
      *--  OUTPUT VARIABLES                               --                    
      ************************************************************              
       01 GTT-RETURN-FIELDS.                                            
           05    S-RETURN-CODE                  PIC S9(9) COMP.         
COB305     05 S-CELL-SCORE        PIC S9(8)V9(2) COMP-3 VALUE 0.  
           05    S-WGT-SCORE                    PIC X(4).               
           05    S-RATING                       PIC X(01).              
           05    S-ERROR-MSG                    PIC X(20).              
                                                                        
      ***************************************************************           
      * CURSOR TO SELECT DISTINCT DIMENSIONS FROM CSS_BHV_CATEG_MODL*           
      ***************************************************************           
           EXEC SQL                                                     
            DECLARE DIMENSION_CURSOR CURSOR FOR                         
             SELECT DISTINCT BHV_DIMENSION_ID                           
               FROM CSS_BHV_CATEG_MODL                                  
              WHERE BHV_MODEL_ID =:KK-BHV-MODEL-ID                      
           END-EXEC.                                                    
      ************************************************************              
      *    CURSOR TO SELECT CSS_BHV_CATEG_MODL                   *              
      ************************************************************              
           EXEC SQL                                                     
            DECLARE CATEGORY_CURSOR CURSOR FOR                          
              SELECT BHV_CATEGORY_ID                                    
                    ,BHV_WGT_COEFFICINT                                 
                FROM CSS_BHV_CATEG_MODL                                 
               WHERE BHV_DIMENSION_ID =:KK-BHV-DIMENSION-ID             
                 AND BHV_MODEL_ID =:KK-BHV-MODEL-ID                     
              ORDER BY BHV_CATEGORY_ID                                  
           END-EXEC.                                                    
                                                                        
      ************************************************************              
      *    CURSOR TO SELECT CSS_BHV_CRITERIA                     *              
      ************************************************************              
           EXEC SQL                                                     
            DECLARE CRITERIA_CURSOR CURSOR FOR                          
             SELECT KK.BHV_CATEGORY_ID                                  
                   ,KK.BHV_CRITERIA_TYPE                                
                   ,KK.BHV_CRIT_MIN_VALUE                               
                   ,KK.BHV_CRIT_MAX_VALUE                               
                   ,KK.BHV_WGT_VALUE                                    
                   ,KY.BHV_WGT_TYPE                                     
                   ,KY.BHV_CATEGORY_DESC                                
               FROM CSS_BHV_CRITERIA KK                                 
                   ,CSS_BHV_CATEGORY KY                                 
              WHERE KK.BHV_DIMENSION_ID = :KK-BHV-DIMENSION-ID          
                AND KK.BHV_CATEGORY_ID  = :KK-BHV-CATEGORY-ID           
                AND KK.BHV_DIMENSION_ID = KY.BHV_DIMENSION_ID           
                AND KK.BHV_CATEGORY_ID  = KY.BHV_CATEGORY_ID            
              ORDER BY BHV_CATEGORY_ID,BHV_CRITERIA_ID                  
           END-EXEC.                                                    
                                                                        
      ************************************************************              
      *    CURSOR TO SELECT CSS_BHV_SCORE_MODL                   *              
      ************************************************************              
           EXEC SQL                                                     
            DECLARE SCORE_CURSOR CURSOR FOR                             
             SELECT DISTINCT BHV_SCORE_ID                               
               FROM CSS_BHV_SCORE_MODL                                  
              WHERE BHV_MODEL_ID = :KZ-BHV-MODEL-ID                     
              ORDER BY BHV_SCORE_ID                                     
           END-EXEC.                                                    
                                                                        
      ************************************************************              
      *    CURSOR TO SELECT CSS_BHV_SCORE_MODL                   *              
      ************************************************************              
           EXEC SQL                                                     
            DECLARE COORD_CURSOR CURSOR FOR                             
             SELECT BHV_DIMENSION_ID                                    
                   ,BHV_CATEGORY_ID                                     
               FROM CSS_BHV_SCORE_MODL                                  
              WHERE BHV_MODEL_ID = :KZ-BHV-MODEL-ID                     
                AND BHV_SCORE_ID = :KZ-BHV-SCORE-ID                     
              ORDER BY BHV_SCORE_ID                                     
           END-EXEC.                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  I-ACCOUNT-NO                   PIC X(13).                    
       01  I-BILL-NO                      PIC 9(05).                    
       01  I-MODEL-ID                     PIC X(04).                    
       01  I-BEACON-SCORE                 PIC X(05).                    
       01  I-BATCH-CD                     PIC X(01).                    
       01  I-UPDATE-FLAG                  PIC X(05).                    
       PROCEDURE DIVISION USING,I-ACCOUNT-NO                            
                               ,I-BILL-NO                               
                               ,I-MODEL-ID                              
                               ,I-BEACON-SCORE                          
                               ,I-BATCH-CD                              
                               ,I-UPDATE-FLAG.                          
      ************************************************************              
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
                                                                        
           PERFORM 1000-PROCESS-INPUT                                   
              THRU 1000-EXIT.                                           
                                                                        
           PERFORM 7200-SELECT-CSS-BHV-MODEL                            
              THRU 7200-EXIT.                                           
                                                                        
           PERFORM 7220-SELECT-AGE-OF-ACCOUNT                           
              THRU 7220-EXIT.                                           
                                                                        
           PERFORM 7221-SELECT-GROUP-CODE                               
              THRU 7221-EXIT.                                           
                                                                        
           PERFORM 7230-SELECT-ARREARS-HIST                             
              THRU 7230-EXIT.                                           
                                                                        
           PERFORM 7260-CALC-NO-OF-ARREARS                              
              THRU 7260-EXIT.                                           
                                                                        
           PERFORM 7290-NO-OF-SONP                                      
              THRU 7290-EXIT.                                           
                                                                        
           PERFORM 1200-BEHAVIORAL-SCORE                                
              THRU 1200-EXIT.                                           
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0100-INITIALIZATION                                   **              
      **  COMMON INITIALIZATION ROUTINE                         **              
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                      :S-RETURN-CODE                                    
                     ,:S-CELL-SCORE                                     
                     ,:S-WGT-SCORE                                      
                     ,:S-RATING                                         
                     ,:S-ERROR-MSG                                      
               FROM CSS_MODEL_SQL                                       
                                                                        
           END-EXEC.                                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *      1000-PROCESS-INPUT                                                 
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
             MOVE I-ACCOUNT-NO             TO WS-ACCOUNT-NO             
             MOVE WS-ACCOUNT-NO-NUM        TO AT-ACCOUNT-NO             
             MOVE WS-ACCOUNT-NO-NUM        TO KF-ACCOUNT-NO             
             MOVE WS-ACCOUNT-NO-NUM        TO CZ-ACCOUNT-NO             
             MOVE WS-ACCOUNT-NO-NUM        TO LR-ACCOUNT-NO             
             MOVE I-BILL-NO                TO KF-BILL-NO                
             MOVE I-MODEL-ID               TO KK-BHV-MODEL-ID           
             MOVE I-MODEL-ID               TO KS-BHV-MODEL-ID           
             MOVE I-MODEL-ID               TO KZ-BHV-MODEL-ID           
             MOVE I-MODEL-ID               TO JZ-BHV-MODEL-ID           
             MOVE I-MODEL-ID               TO KI-BHV-MODEL-ID           
             MOVE I-BEACON-SCORE           TO KF-BEACON-SCORE.          
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
******************************************************************              
*********  1200-BEHAVIORAL-SCORE                                                
******************************************************************              
       1200-BEHAVIORAL-SCORE.                                           
      *------------------------*                                                
                                                                        
           DISPLAY 'OPEN CURSOR'                                        
           PERFORM 7300-OPEN-DIMENSION-CURSOR                           
              THRU 7300-EXIT.                                           
                                                                        
           DISPLAY 'FETCH CURSOR'                                       
           PERFORM 7310-FETCH-DIMENSION-CURSOR                          
              THRU 7310-EXIT.                                           
                                                                        
            PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
              PERFORM 7351-OPEN-CATEGORY-CURSOR  THRU 7351-EXIT         
              PERFORM 7352-FETCH-CATEGORY-CURSOR THRU 7352-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                                                                        
                DISPLAY 'OPEN CURSOR'                                   
                PERFORM 7330-OPEN-CRITERIA-CURSOR                       
                   THRU 7330-EXIT                                       
                                                                        
                DISPLAY 'FETCH CURSOR'                                  
                PERFORM 7340-FETCH-CRITERIA-CURSOR                      
                   THRU 7340-EXIT                                       
                                                                        
                MOVE WS-YES   TO WS-MATCH-FLAG                          
                                                                        
                PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND         
                           OR WS-MATCH-FLAG = WS-NO                     
                                                                        
                     PERFORM 7370-CRITERIA-TYPE                         
                        THRU 7370-EXIT                                  
                                                                        
                     IF WS-MATCH-FLAG = WS-YES                          
                        IF KY-BHV-WGT-TYPE = 'VALUE'                    
                           MOVE KX-BHV-WGT-VALUE TO WS-SCORE-VALUE      
                        END-IF                                          
                        IF KY-BHV-WGT-TYPE = 'LN'                       
                           COMPUTE WS-SCORE-VALUE =                     
                              FUNCTION LOG (WS-VALUE)                   
                        END-IF                                          
                     ELSE                                               
                        MOVE 0 TO WS-SCORE-VALUE                        
                     END-IF                                             
                                                                        
                                                                        
                                                                        
                     COMPUTE WS-SCORE-VALUE = WS-SCORE-VALUE *          
                             KK-BHV-WGT-COEFFICINT                      
                     END-COMPUTE                                        
                     COMPUTE WS-COMB = WS-COMB + WS-SCORE-VALUE         
                     END-COMPUTE                                        
                     PERFORM 7340-FETCH-CRITERIA-CURSOR                 
                        THRU 7340-EXIT                                  
                                                                        
                END-PERFORM                                             
                PERFORM 7350-CLOSE-CRITERIA-CURSOR                      
                   THRU 7350-EXIT                                       
                                                                        
                PERFORM 7352-FETCH-CATEGORY-CURSOR                      
                   THRU 7352-EXIT                                       
                                                                        
            END-PERFORM                                                 
            PERFORM 7353-CLOSE-CATEGORY-CURSOR                          
               THRU 7353-EXIT                                           
                                                                        
            PERFORM 7310-FETCH-DIMENSION-CURSOR                         
               THRU 7310-EXIT                                           
                                                                        
           END-PERFORM                                                  
                                                                        
           PERFORM 7320-CLOSE-DIMENSION-CURSOR                          
              THRU 7320-EXIT                                            
           COMPUTE WS-COMB  = -1 * WS-COMB      END-COMPUTE             
*************** ASSUMPTION THAT E=2.718                                         
           COMPUTE WS-SCORE = 2.718 ** WS-COMB  END-COMPUTE             
           COMPUTE WS-SCORE = 1 + WS-SCORE      END-COMPUTE             
           COMPUTE WS-SCORE = 1/WS-SCORE        END-COMPUTE             
           COMPUTE WS-SCORE = 1 - WS-SCORE      END-COMPUTE             
           COMPUTE WS-SCORE = 500 * WS-SCORE    END-COMPUTE.            
           COMPUTE WS-SCORE-NUM ROUNDED = WS-SCORE                      
           END-COMPUTE                                                  
***********MOVE WS-SCORE                        TO WS-SCORE-NUM                 
           MOVE WS-SCORE-NUM                    TO S-WGT-SCORE          
      *    MOVE WS-SCORE                        TO WS-SCORE-RATING.             
                                                   WS-SCORE-RATING.     
           MOVE 0                               TO S-CELL-SCORE.        
           MOVE 0                               TO S-RETURN-CODE.       
           MOVE SPACES                          TO S-ERROR-MSG.         
           PERFORM 7406-SELECT-RATING           THRU 7406-EXIT          
           MOVE KI-BHV-SCORE-RATING             TO S-RATING.            
           PERFORM 8100-SEND-RESULT                                     
              THRU 8100-EXIT.                                           
           PERFORM 8900-SEND-DONE                                       
              THRU 8900-EXIT.                                           
                                                                        
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
******************************************************************              
********SELECT MODEL TYPE FROM CSS-BHV-MODEL                                    
                                                                        
******************************************************************              
                                                                        
       7200-SELECT-CSS-BHV-MODEL.                                       
                                                                        
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
              EXEC SQL                                                  
               SELECT  BHV_MODEL_STYLE                                  
                 INTO :KS-BHV-MODEL-STYLE                               
                 FROM  CSS_BHV_MODEL                                    
                WHERE BHV_MODEL_ID = :KS-BHV-MODEL-ID                   
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7200'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'        TO ABEND-FUNCTION                    
              MOVE 'CSS_BHV_MODEL   '   TO TABLE-1                      
              MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1              
              MOVE KS-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
           END-IF.                                                      
       7200-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      * SELECT-AGE-OF-ACCOUNT *                                                 
      ****************************************************************          
       7220-SELECT-AGE-OF-ACCOUNT.                                      
                                                                        
            MOVE '7220' TO WS-ACTIVE-PARAGRAPH.                         
                                                                        
            EXEC SQL                                                    
                   SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           ACCT_CREATE_DT, 121), ' ', '-'), ':', '.') ACCT_CREATE_DT           
                        , CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE))-
           CIS.DAYS(ACCT_CREATE_DT)       
                        , MONTH(ACCT_CREATE_DT)                         
                     INTO :AT-ACCT-CREATE-DT                            
                        , :WS-AGE-IN-DAYS                               
                        , :WS-ACCT-CREATE-MO                            
                     FROM CSS_ACCOUNT                                   
                    WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                   
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*            SELECT ACCT_CREATE_DT                                        
MFA-TR*                 , DAYS(CURRENT DATE)-DAYS(ACCT_CREATE_DT)               
MFA-TR*                 , MONTH(ACCT_CREATE_DT)                                 
MFA-TR*              INTO :AT-ACCT-CREATE-DT                                    
MFA-TR*                 , :WS-AGE-IN-DAYS                                       
MFA-TR*                 , :WS-ACCT-CREATE-MO                                    
MFA-TR*              FROM CSS_ACCOUNT                                           
MFA-TR*             WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
ACT054          IF WS-AGE-IN-DAYS < 0                                   
ACT054              MOVE ZERO TO WS-AGE-IN-DAYS                         
ACT054          END-IF                                                  
            ELSE                                                        
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7220'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'        TO ABEND-FUNCTION                    
              MOVE 'CSS_ACCOUNT     '   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
            END-IF.                                                     
                                                                        
       7220-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * SELECT REGULATED GROUP CODE                                             
      ****************************************************************          
       7221-SELECT-GROUP-CODE.                                          
                                                                        
            MOVE '7221' TO WS-ACTIVE-PARAGRAPH.                         
                                                                        
            EXEC SQL                                                    
                   SELECT REG_GROUP_CD                                  
                     INTO :LR-REG-GROUP-CD                              
                     FROM CSS_REG_PROFILE                               
                    WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7221'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'        TO ABEND-FUNCTION                    
              MOVE 'CSS_REG_PROFILE '   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
            END-IF.                                                     
                                                                        
       7221-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ************************************************************              
      * SELECT ARREARS_HIST  FROM CSS_CREDIT_PROFILE **                         
      ************************************************************              
       7230-SELECT-ARREARS-HIST.                                        
                                                                        
             MOVE '7230' TO WS-ACTIVE-PARAGRAPH.                        
                                                                        
             EXEC SQL                                                   
              SELECT ARREARS_HIST                                       
                   , DISCONNECT_HIST                                    
                INTO :CZ-ARREARS-HIST                                   
                   , :CZ-DISCONNECT-HIST                                
                FROM CSS_CREDIT_PROFILE                                 
               WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7230'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'        TO ABEND-FUNCTION                    
              MOVE 'CSS_CREDIT_PROFILE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
             END-IF.                                                    
                                                                        
                                                                        
       7230-EXIT.                                                       
             EXIT.                                                      
      ****************************************************************          
      **SUBSTRING OF ARREAR HISTORY **                                          
      ****************************************************************          
       7240-SUBSTRING-OF-ARREARS.                                       
                                                                        
              MOVE '7240' TO WS-ACTIVE-PARAGRAPH.                       
              MOVE CZ-ARREARS-HIST (WS-POSITION:1)                      
                  TO WS-MONTHLY-ARREAR.                                 
                                                                        
                                                                        
       7240-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **CALCULATE NO-OF-ARREARS-A **                                            
      ************************************************************              
       7250-NO-OF-ARREARS-A.                                            
                                                                        
              MOVE '7250' TO WS-ACTIVE-PARAGRAPH.                       
                                                                        
              PERFORM 7240-SUBSTRING-OF-ARREARS                         
                 THRU 7240-EXIT.                                        
              IF WS-MONTHLY-ARREAR = '1'                                
                 ADD 1      TO WS-30D-ARREARS                           
              END-IF                                                    
              IF WS-MONTHLY-ARREAR = '2'                                
                 ADD 1      TO WS-60D-ARREARS                           
                 ADD 1      TO WS-30D-ARREARS                           
              END-IF                                                    
              IF WS-MONTHLY-ARREAR = '3'                                
                 ADD 1      TO WS-90D-ARREARS                           
                 ADD 1      TO WS-60D-ARREARS                           
                 ADD 1      TO WS-30D-ARREARS                           
              END-IF.                                                   
                                                                        
              ADD 1      TO WS-POSITION.                                
                                                                        
       7250-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **CALCULATE NO-OF-ARREARS                                 **              
      ************************************************************              
       7260-CALC-NO-OF-ARREARS.                                         
                                                                        
             MOVE '7260' TO WS-ACTIVE-PARAGRAPH.                        
             MOVE 1 TO WS-POSITION.                                     
             MOVE 0 TO WS-30D-ARREARS.                                  
             MOVE 0 TO WS-60D-ARREARS.                                  
             MOVE 0 TO WS-90D-ARREARS.                                  
                                                                        
             PERFORM 7250-NO-OF-ARREARS-A                               
                THRU 7250-EXIT                                          
               UNTIL WS-POSITION > 10.                                  
                                                                        
       7260-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **SUBSTRING OF ARREAR HISTORY                                             
      ************************************************************              
       7270-SUBSTRING-OF-DISCHIST.                                      
                                                                        
             MOVE '7270' TO WS-ACTIVE-PARAGRAPH.                        
             MOVE CZ-DISCONNECT-HIST(WS-POSITION:1)                     
                  TO WS-MONTHLY-SONP.                                   
                                                                        
       7270-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **  CALCULATE NO-OF-SONP-A **                                             
      ************************************************************              
       7280-MONTHLY-NO-OF-SONP.                                         
                                                                        
             MOVE '7280' TO WS-ACTIVE-PARAGRAPH.                        
                                                                        
             PERFORM 7270-SUBSTRING-OF-DISCHIST                         
                THRU 7270-EXIT.                                         
                                                                        
             IF WS-MONTHLY-SONP = '4'                                   
                ADD 1      TO WS-NO-OF-SONP                             
             END-IF.                                                    
                                                                        
             ADD 1      TO WS-POSITION.                                 
                                                                        
       7280-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **  CALCULATE NO-OF-SONP **                                               
      ************************************************************              
       7290-NO-OF-SONP.                                                 
                                                                        
             MOVE '7290' TO WS-ACTIVE-PARAGRAPH.                        
             MOVE 1 TO WS-POSITION.                                     
             MOVE 0 TO WS-NO-OF-SONP.                                   
                                                                        
             PERFORM 7280-MONTHLY-NO-OF-SONP                            
             THRU 7280-EXIT                                             
             UNTIL WS-POSITION > 10.                                    
                                                                        
       7290-EXIT.                                                       
             EXIT.                                                      
      ****************************************************************          
      ** 7300-OPEN-DIMENSION-CURSOR.                                **          
      ****************************************************************          
       7300-OPEN-DIMENSION-CURSOR.                                      
                                                                        
             MOVE '7300' TO WS-ACTIVE-PARAGRAPH.                        
                                                                        
             EXEC SQL                                                   
                OPEN DIMENSION_CURSOR                                   
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                CONTINUE                                                
             ELSE                                                       
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7300'          TO ACTIVE-PARAGRAPH                  
              MOVE 'OPEN  '        TO ABEND-FUNCTION                    
              MOVE 'CSS_BHV_CATEG_MODL' TO TABLE-1                      
              MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1              
              MOVE KF-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
             END-IF.                                                    
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      **  7310-FETCH-DIMENSION-CURSOR.                          **              
      ************************************************************              
       7310-FETCH-DIMENSION-CURSOR.                                     
      *--------------*                                                          
             MOVE '7310' TO WS-ACTIVE-PARAGRAPH.                        
                                                                        
             EXEC SQL                                                   
                FETCH DIMENSION_CURSOR                                  
                 INTO :KK-BHV-DIMENSION-ID                              
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
                 NEXT SENTENCE                                          
              ELSE                                                      
                MOVE PROGRAM-NAME    TO ABEND-PROGRAM                   
                MOVE '7310'          TO ACTIVE-PARAGRAPH                
                MOVE 'FETCH '        TO ABEND-FUNCTION                  
                MOVE 'CSS_BHV_CATEG_MODL' TO TABLE-1                    
                MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1            
                MOVE KF-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1          
                PERFORM 9000-SEND-ERROR-RESULT                          
                   THRU 9000-EXIT                                       
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                   THRU 9900-EXIT                                       
              END-IF.                                                   
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      **7320-CLOSE-DIMENSION-CURSOR                             **              
      ************************************************************              
       7320-CLOSE-DIMENSION-CURSOR.                                     
      *--------------*                                                          
           MOVE '7320' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           DISPLAY 'CLOSE CURSOR'                                       
           EXEC SQL                                                     
                CLOSE DIMENSION_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
                MOVE PROGRAM-NAME    TO ABEND-PROGRAM                   
                MOVE '7320'          TO ACTIVE-PARAGRAPH                
                MOVE 'CLOSE '        TO ABEND-FUNCTION                  
                MOVE 'CSS_BHV_CATEG_MODL' TO TABLE-1                    
                MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1            
                MOVE KF-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1          
                PERFORM 9000-SEND-ERROR-RESULT                          
                   THRU 9000-EXIT                                       
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                   THRU 9900-EXIT                                       
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
            EXIT.                                                       
      ************************************************************              
      **  7330-OPEN-CRITERIA-CURSOR.                            **              
      ************************************************************              
       7330-OPEN-CRITERIA-CURSOR.                                       
                                                                        
             MOVE '7330' TO WS-ACTIVE-PARAGRAPH.                        
                                                                        
             EXEC SQL                                                   
                 OPEN CRITERIA_CURSOR                                   
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                CONTINUE                                                
             ELSE                                                       
                MOVE PROGRAM-NAME    TO ABEND-PROGRAM                   
                MOVE '7330'          TO ACTIVE-PARAGRAPH                
                MOVE 'OPEN  '        TO ABEND-FUNCTION                  
                MOVE 'CRITERIA CURSOR   ' TO TABLE-1                    
                MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1            
                MOVE KF-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1          
                PERFORM 9000-SEND-ERROR-RESULT                          
                   THRU 9000-EXIT                                       
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                   THRU 9900-EXIT                                       
              END-IF.                                                   
                                                                        
       7330-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  7340-FETCH-CRITERIA-CURSOR.                                 **        
      **                                                              **        
      ******************************************************************        
       7340-FETCH-CRITERIA-CURSOR.                                      
      *--------------*                                                          
              MOVE '7340' TO WS-ACTIVE-PARAGRAPH.                       
                                                                        
              EXEC SQL                                                  
                 FETCH CRITERIA_CURSOR                                  
                  INTO :KX-BHV-CATEGORY-ID                              
                      ,:KX-BHV-CRITERIA-TYPE                            
                      ,:KX-BHV-CRIT-MIN-VALUE                           
                      ,:KX-BHV-CRIT-MAX-VALUE                           
                      ,:KX-BHV-WGT-VALUE                                
                      ,:KY-BHV-WGT-TYPE                                 
                      ,:KY-BHV-CATEGORY-DESC                            
                                                                        
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 NEXT SENTENCE                                          
              ELSE                                                      
                MOVE PROGRAM-NAME    TO ABEND-PROGRAM                   
                MOVE '7340'          TO ACTIVE-PARAGRAPH                
                MOVE 'FETCH '        TO ABEND-FUNCTION                  
                MOVE 'CRITERIA CURSOR   ' TO TABLE-1                    
                MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1            
                MOVE KF-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1          
                PERFORM 9000-SEND-ERROR-RESULT                          
                   THRU 9000-EXIT                                       
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                   THRU 9900-EXIT                                       
              END-IF.                                                   
                                                                        
       7340-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      **  7350-CLOSE-CRITERIA-CURSOR                                  **        
      **                                                              **        
      ******************************************************************        
       7350-CLOSE-CRITERIA-CURSOR.                                      
      *--------------*                                                          
              MOVE '7350' TO WS-ACTIVE-PARAGRAPH.                       
              DISPLAY 'CLOSE CURSOR'                                    
              EXEC SQL                                                  
                   CLOSE CRITERIA_CURSOR                                
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                MOVE PROGRAM-NAME    TO ABEND-PROGRAM                   
                MOVE '7350'          TO ACTIVE-PARAGRAPH                
                MOVE 'CLOSE '        TO ABEND-FUNCTION                  
                MOVE 'CRITERIA CURSOR   ' TO TABLE-1                    
                MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1            
                MOVE KF-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1          
                PERFORM 9000-SEND-ERROR-RESULT                          
                   THRU 9000-EXIT                                       
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                   THRU 9900-EXIT                                       
              END-IF.                                                   
                                                                        
       7350-EXIT.                                                       
            EXIT.                                                       
      ************************************************************              
      **  7351-OPEN-CATEGORY-CURSOR.                            **              
      ************************************************************              
       7351-OPEN-CATEGORY-CURSOR.                                       
                                                                        
             MOVE '7351' TO WS-ACTIVE-PARAGRAPH.                        
                                                                        
             EXEC SQL                                                   
                 OPEN CATEGORY_CURSOR                                   
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                CONTINUE                                                
             ELSE                                                       
                MOVE PROGRAM-NAME    TO ABEND-PROGRAM                   
                MOVE '7351'          TO ACTIVE-PARAGRAPH                
                MOVE 'OPEN  '        TO ABEND-FUNCTION                  
                MOVE 'CATEGORY CURSOR   ' TO TABLE-1                    
                MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1            
                MOVE KF-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1          
                PERFORM 9000-SEND-ERROR-RESULT                          
                   THRU 9000-EXIT                                       
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                   THRU 9900-EXIT                                       
              END-IF.                                                   
                                                                        
       7351-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  7352-FETCH-CATEGORY-CURSOR.                                 **        
      **                                                              **        
      ******************************************************************        
       7352-FETCH-CATEGORY-CURSOR.                                      
      *--------------*                                                          
              MOVE '7352' TO WS-ACTIVE-PARAGRAPH.                       
                                                                        
              EXEC SQL                                                  
                 FETCH CATEGORY_CURSOR                                  
                  INTO :KK-BHV-CATEGORY-ID                              
                      ,:KK-BHV-WGT-COEFFICINT                           
                                                                        
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                  NEXT SENTENCE                                         
              ELSE                                                      
                MOVE PROGRAM-NAME    TO ABEND-PROGRAM                   
                MOVE '7352'          TO ACTIVE-PARAGRAPH                
                MOVE 'FETCH '        TO ABEND-FUNCTION                  
                MOVE 'CATEGORY CURSOR   ' TO TABLE-1                    
                MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1            
                MOVE KF-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1          
                PERFORM 9000-SEND-ERROR-RESULT                          
                   THRU 9000-EXIT                                       
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                   THRU 9900-EXIT                                       
              END-IF.                                                   
                                                                        
       7352-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      **  7353-CLOSE-CATEGORY-CURSOR                                  **        
      **                                                              **        
      ******************************************************************        
       7353-CLOSE-CATEGORY-CURSOR.                                      
      *--------------*                                                          
              MOVE '7352' TO WS-ACTIVE-PARAGRAPH.                       
              DISPLAY 'CLOSE CURSOR'                                    
              EXEC SQL                                                  
                   CLOSE CATEGORY_CURSOR                                
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                MOVE PROGRAM-NAME    TO ABEND-PROGRAM                   
                MOVE '7353'          TO ACTIVE-PARAGRAPH                
                MOVE 'FETCH '        TO ABEND-FUNCTION                  
                MOVE 'CATEGORY CURSOR   ' TO TABLE-1                    
                MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1            
                MOVE KF-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1          
                PERFORM 9000-SEND-ERROR-RESULT                          
                   THRU 9000-EXIT                                       
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                   THRU 9900-EXIT                                       
              END-IF.                                                   
                                                                        
       7353-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      **  7360-MATCH-CRITERIA-TYPE                                    **        
      **                                                              **        
      ******************************************************************        
       7360-MATCH-CRITERIA-TYPE.                                        
                                                                        
            MOVE '7360' TO WS-ACTIVE-PARAGRAPH.                         
            MOVE 0      TO WS-VALUE                                     
                                                                        
            IF KX-BHV-CRITERIA-TYPE = 'AGE'                             
               MOVE WS-YES TO WS-MATCH-FLAG                             
               COMPUTE WS-VALUE = .01 + WS-AGE-IN-DAYS                  
               END-COMPUTE                                              
            END-IF.                                                     
                                                                        
            MOVE KF-BEACON-SCORE TO WS-BEACON-SCORE                     
            IF KX-BHV-CRITERIA-TYPE = 'BEACON'                          
               IF  WS-BEACON-SCORE >= KX-BHV-CRIT-MIN-VALUE             
               AND WS-BEACON-SCORE <= KX-BHV-CRIT-MAX-VALUE             
                   MOVE WS-YES TO WS-MATCH-FLAG                         
                   MOVE 1      TO WS-VALUE                              
               ELSE                                                     
                   MOVE WS-NO  TO WS-MATCH-FLAG                         
                   MOVE 0      TO WS-VALUE                              
               END-IF                                                   
            END-IF.                                                     
                                                                        
                                                                        
            IF KX-BHV-CRITERIA-TYPE = '30DAY'                           
                   MOVE WS-YES TO WS-MATCH-FLAG                         
                   COMPUTE  WS-VALUE = .01 + WS-30D-ARREARS             
                   END-COMPUTE                                          
            END-IF.                                                     
                                                                        
            IF KX-BHV-CRITERIA-TYPE = '60DAY'                           
                   MOVE WS-YES TO WS-MATCH-FLAG                         
                   COMPUTE  WS-VALUE = .01 + WS-60D-ARREARS             
                   END-COMPUTE                                          
            END-IF.                                                     
                                                                        
            IF KX-BHV-CRITERIA-TYPE = '90DAY'                           
                   MOVE WS-YES TO WS-MATCH-FLAG                         
                   COMPUTE  WS-VALUE = .01 + WS-90D-ARREARS             
                   END-COMPUTE                                          
            END-IF.                                                     
                                                                        
                                                                        
            IF KX-BHV-CRITERIA-TYPE = 'SONP'                            
                   MOVE WS-YES TO WS-MATCH-FLAG                         
                   COMPUTE  WS-VALUE = .01 + WS-NO-OF-SONP              
                   END-COMPUTE                                          
            END-IF.                                                     
            IF KX-BHV-CRITERIA-TYPE = 'INTERCEPT'                       
               MOVE WS-YES TO WS-MATCH-FLAG                             
            END-IF.                                                     
                                                                        
            IF KX-BHV-CRITERIA-TYPE = 'HEAT'                            
               IF  WS-ACCT-CREATE-MO >= KX-BHV-CRIT-MIN-VALUE           
               AND WS-ACCT-CREATE-MO <= KX-BHV-CRIT-MAX-VALUE           
                   MOVE WS-YES TO WS-MATCH-FLAG                         
                   MOVE KX-BHV-WGT-VALUE TO WS-VALUE                    
                                                                        
               ELSE                                                     
**************     MOVE WS-NO  TO WS-MATCH-FLAG                                 
                   MOVE 0      TO WS-VALUE                              
                   MOVE 0      TO KX-BHV-WGT-VALUE                      
               END-IF                                                   
            END-IF.                                                     
                                                                        
            MOVE LR-REG-GROUP-CD TO WS-GROUP-CD                         
            IF KX-BHV-CRITERIA-TYPE = 'GROUP'                           
               IF  WS-GROUP-CD       >= KX-BHV-CRIT-MIN-VALUE           
               AND WS-GROUP-CD       <= KX-BHV-CRIT-MAX-VALUE           
                   MOVE WS-YES TO WS-MATCH-FLAG                         
                   MOVE KX-BHV-WGT-VALUE TO WS-VALUE                    
               ELSE                                                     
***************    MOVE WS-NO  TO WS-MATCH-FLAG                                 
                   MOVE 0      TO WS-VALUE                              
                   MOVE 0      TO KX-BHV-WGT-VALUE                      
               END-IF                                                   
            END-IF.                                                     
                                                                        
                                                                        
       7360-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  7370-CRITERIA-TYPE                                          **        
      **                                                              **        
      ******************************************************************        
       7370-CRITERIA-TYPE.                                              
                                                                        
            MOVE '7370' TO WS-ACTIVE-PARAGRAPH.                         
                                                                        
                                                                        
            PERFORM 7360-MATCH-CRITERIA-TYPE                            
               THRU 7360-EXIT.                                          
       7370-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      **  7406-SELECT-RATING.                                         **        
      **                                                              **        
      ******************************************************************        
       7406-SELECT-RATING.                                              
                                                                        
            MOVE '7406' TO WS-ACTIVE-PARAGRAPH.                         
                                                                        
            EXEC SQL                                                    
             SELECT MAX(BHV_SCORE_RATING)                               
               INTO :KI-BHV-SCORE-RATING                                
               FROM CSS_BHV_SCOR_RATNG                                  
              WHERE BHV_MODEL_ID     =  :KI-BHV-MODEL-ID                
                AND BHV_SCORE_MAX    >= :WS-SCORE-RATING                
                AND BHV_SCORE_MIN    <= :WS-SCORE-RATING                
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                CONTINUE                                                
            ELSE                                                        
                MOVE PROGRAM-NAME    TO ABEND-PROGRAM                   
                MOVE '7406'          TO ACTIVE-PARAGRAPH                
                MOVE 'SELECT'        TO ABEND-FUNCTION                  
                MOVE 'SCORE   CURSOR    ' TO TABLE-1                    
                MOVE 'BHV_MODEL_ID'       TO TABLE-ELEMENT-1            
                MOVE KI-BHV-MODEL-ID      TO HOSTVAR-ELEMENT-1          
                PERFORM 9000-SEND-ERROR-RESULT                          
                   THRU 9000-EXIT                                       
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                   THRU 9900-EXIT                                       
            END-IF.                                                     
       7406-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
                                                                        
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **     8900-SEND-DONE.                                                    
      **                                                                        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *---------------------*                                                   
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * SENDS ERROR RESULT                                            *         
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
                                                                        
               ROLLBACK                                                 
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
                                                                        
                                                                        
       9000-EXIT.                                                       
            EXIT.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
