       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  CSR03426.                                           
       AUTHOR.      LISA FISHER.                                        
COB303 DATE-WRITTEN. MAY 2004.                                           
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03426              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03426 :                                                --         
      *--                                                            --         
      *--                                                            --         
      *--    #  MAINTAIN CUSTOMER BANK ACCOUNT INFORMATION AND RECORD--         
      *--    #  IN TRANS HISTORY TABLE                               --         
      *--                                                            --         
      *--    #  INVOKED FROM PANEL518 AND E-CUSTOMER WEB SITE        --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--                                                            --         
      *--    PARAMETERS                                              --         
      *--                                                            --         
      *--        IN                                                  --         
      *--                                                            --         
      *--              BANK ACCOUNT NAME            CHAR(50)         --         
      *--              BANK ACCOUNT NO              CHAR(19)         --         
      *--              BANK ACCOUNT STATUS          CHAR(01)         --         
      *--              BANK ACCOUNT TYPE            CHAR(01)         --         
      *--              BANK ID                      CHAR(06)         --         
      *--              CUST BANK SEQ NUMBER         CHAR(09)         --         
      *--              BANK ACCOUNT NICKNAME        CHAR(50)         --         
      *--              CUSTOMER NO                  CHAR(10)         --         
      *--              PRIMARY INDICATOR            CHAR(01)         --         
      *--              UPDATE TYPE                  CHAR(01)         --         
      *--              USER ID                      CHAR(07)         --         
      *--              COMMENTS                     CHAR(210)        --         
      *--              COMMENT LENGTH               CHAR(04)         --         
      *--                                                            --         
      *--        OUT                                                 --         
      *--                                                            --         
      *--              NONE                                          --         
      *--                                                            --         
      *--        INOUT                                               --         
      *--                                                            --         
      *--              NONE                                          --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--    RESULT SET                                              --         
      *--                                                            --         
      *--      1                                                     --         
      *--              RETURN-CODE                                   --         
      *----------------------------------------------------------------         
      *--                   MODIFICATION LOG                         --         
      *--                                                            --         
      *--   DATE      INITIALS    COMMENTS                           --         
      *-- ----------  --------    -------------------------------------         
      *-- 05/11/2004  LISA FISHER NEW CODE                           --         
      *-- 07/22/2004  SRIDHAR    ADDED A CHK FOR PNDNG PYMNT IN 7700 --         
T29529*-- 08/25/2004  VIDHU       CHANGES TO TRANS_HIST DESCRIPTION  --         
T29529*-- 10/04/2004  KHUZ        CHANGES TO CHECK FOR UNIQUE NICKNAME-         
C32389*-- 03/07/2006  CARLA BROWN MADE CHANGES TO UPDATE TIMESTAMP   --         
C32389*--                         WHENEVER CSS_CUSTOMER_BANK IS      --         
C32389*--                         UPDATED.                           --         
C36298*-- 03/07/2006  CARLA BROWN ADDED BANK NICKNAME TO TRANS HIST  --         
C33861*-- 10/25/2007  CARLA BROWN ACTIVITY 5 - ADDED CODE TO CORRECT --         
C33861*--                         HEADER DESCR WHEN A BANK IS        --         
C33861*--                         DELETED.                           --         
C36298*-- 01/04/2008  CARLA BROWN ACTIVITY 2 - FIXED PROBLEM OF      --         
C36298*--                         EXTRA LETTERS BEING ADDED TO SHORT --         
C36298*--                         NICKNAMES WHEN THEY ARE REPLACING  --         
C36298*--                         LONGER NICKNAMES.                  --         
A04074*-- 06/13/2012  CARLA BROWN ACTIVITY 1 - FIXED PROBLEM WITH    --         
A04074*--                         CUSTOMERS NOT BEING ABLE TO DELETE --         
A04074*--                         BANK INFO ON THE WEB.              --         
A04527*-- 06/07/13    AS7C117     REMOVE UNUSED COPYBOOK CWS00056.   --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03426'.
MSQ017     COPY MFASQLM.
                                                                        
      *----------------------------------------------------------------*        
      *    DB2 INCLUDES                                                *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_MODEL_SQL                                                           
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_MNT_TRANS_HIST                                                      
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_MT_TRN_HST_DET                                                      
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_BANK_EFT                                                            
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_CUST_BANK                                                           
           EXEC SQL                                                             
              INCLUDE TBCSTBNK                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_PNDNG_BNK_DRFT                                                      
                                                                        
           EXEC SQL                                                             
             INCLUDE TBPDBKDF                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_ACCOUNT                                                             
                                                                        
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_USER_PROFILE                                                        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBUSRPRF                                                   
           END-EXEC.                                                            
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      *    WORK AREAS                                                  *        
      *----------------------------------------------------------------*        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG            PIC X(8)   VALUE 'CSRERLOG'.     
                                                                        
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)  VALUE SPACES.         
           10  S-SQLCODE               PIC S9(9)  VALUE 0 COMP.         
           10  S-SQLSTATE              PIC X(05)  VALUE SPACES.         
           10  S-TABLE-NAME            PIC X(18)  VALUE SPACES.         
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4)  USAGE COMP.           
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4)  USAGE COMP.           
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4)  USAGE COMP.           
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4)  USAGE COMP.           
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE            PIC S9(9)  VALUE 0 COMP.         
           10 S-ACCOUNT-NO             PIC X(13)  VALUE SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9)  COMP VALUE 1.         
           05  CTR-ROWS                PIC S9(9)  COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9)  COMP.                 
           05  WRKLEN1                 PIC S9(9)  COMP.                 
           05  WRKLEN2                 PIC S9(9)  COMP.                 
           05  WRK-DONE-STATUS         PIC S9(9)  COMP.                 
                                                                        
           05  WS-SQLSTATE             PIC X(05)  VALUE SPACES.         
                                                                        
       01  WS-CONSTANTS.                                                
           05  WS-SYSTEM               PIC X(07)  VALUE 'SYSTEM'.       
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR03426'.     
           05  WS-PGRMNAME             PIC X(08)  VALUE 'CSR03426'.     
                                                                        
       01  WS-BANK-SEQ                 PIC S9(09) COMP.                 
                                                                        
       01  WS-MISC-ITEMS.                                               
           05  WS-CUSTOMER-NO          PIC X(10).                       
           05  WS-CUSTOMER-NO-NUM REDEFINES WS-CUSTOMER-NO              
                                       PIC 9(10).                       
COB305     05 WS-CUSTOMER-NO-COMP3        PIC S9(10) COMP-3 VALUE 0.            
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
           05  WS-ACCT-TRANSLATE       PIC 9(13).                       
           05  WS-ACCT-TRANSLATE-CH REDEFINES                           
                     WS-ACCT-TRANSLATE PIC X(13).                       
           05  WS-BANK-SEQ-NO          PIC X(09) JUSTIFIED RIGHT.       
           05  WS-BANK-SEQ-NO-NUM REDEFINES WS-BANK-SEQ-NO              
                                       PIC 9(09).                       
           05  WS-BANK-ID              PIC X(06) JUSTIFIED RIGHT.       
           05  WS-BANK-ID-NUM REDEFINES WS-BANK-ID                      
                                       PIC S9(06)V.                     
           05  WS-COMMENT-LEN          PIC X(04) JUSTIFIED RIGHT.       
           05  WS-COMMENT-LEN-NUM REDEFINES WS-COMMENT-LEN              
                                       PIC 9(04).                       
           05  WS-USER-ID              PIC X(07)  VALUE SPACES.         
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE 0.         
           05  WS-WEB-TRANS-FLAG       PIC X(01) VALUE 'N'.             
               88  WS-WEB-TRANS        VALUE 'Y'.                       
           05  WS-PRIMARY-FLAG         PIC X(01) VALUE 'N'.             
               88  WS-PRIMARY          VALUE 'Y'.                       
               88  WS-ADD-PRIMARY      VALUE 'A'.                       
               88  WS-UPD-PRIMARY      VALUE 'U'.                       
C29529     05  WS-NICKNAME-EXISTS-FLAG PIC X(01) VALUE 'N'.             
C29529         88 WS-NICKNAME-EXISTS             VALUE 'Y'.             
C29529         88 WS-NICKNAME-NOT-EXISTS         VALUE 'N'.             
           05  WS-D                    PIC X(01) VALUE 'D'.             
           05  WS-TRAILING-SPACES      PIC 9(02) VALUE 0.               
           05  WS-CTR                  PIC 9(02) VALUE 0.               
           05  WS-SEQ-COUNT            PIC 9(01) VALUE 9.               
           05  WS-SEQ-COUNT-4          PIC 9(01) VALUE 4.               
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-TIMESTMP     PIC X(26) VALUE SPACES.          
           05  WS-RESP-AREA            PIC X(03) VALUE SPACES.          
           05  WS-NULL-IND             PIC S9(04) COMP VALUE +0.        
           05  WS-PYMT-PNDNG           PIC X(01) VALUE 'N'.             
T29529     05  WS-PREV-BNK-NICKNAME    PIC X(50) VALUE SPACES.          
COB305     05 WS-FINALLED-ACCT-COMP3        PIC S9(13) COMP-3 VALUE 0.          
A04074     05  WS-30-DAYS-AGO          PIC X(10) VALUE SPACES.          
                                                                        
       LINKAGE SECTION.                                                 
       01  I-CUSTOMER-NO               PIC X(10).                       
       01  I-CUST-BANK-SEQ-NO          PIC X(09).                       
       01  I-UPDATE-TYPE               PIC X(01).                       
       01  I-PRIMARY-IND               PIC X(01).                       
       01  I-BANK-ACCT-NAME            PIC X(50).                       
       01  I-BANK-ACCT-NO              PIC X(19).                       
       01  I-BANK-ACCT-STATUS          PIC X(01).                       
       01  I-BANK-ACCT-TYPE            PIC X(01).                       
       01  I-BANK-ID                   PIC X(06).                       
       01  I-BANK-ACCT-NICKNA          PIC X(50).                       
       01  I-USER-ID                   PIC X(07).                       
       01  I-COMMENT-TEXT              PIC X(210).                      
       01  I-COMMENT-LEN-NUM           PIC X(04).                       
       01  I-ACCOUNT-NO                PIC X(13).                       
                                                                        
       PROCEDURE DIVISION USING I-CUSTOMER-NO                           
                               , I-CUST-BANK-SEQ-NO                     
                               , I-UPDATE-TYPE                          
                               , I-PRIMARY-IND                          
                               , I-BANK-ACCT-NAME                       
                               , I-BANK-ACCT-NO                         
                               , I-BANK-ACCT-STATUS                     
                               , I-BANK-ACCT-TYPE                       
                               , I-BANK-ID                              
                               , I-BANK-ACCT-NICKNA                     
                               , I-USER-ID                              
                               , I-COMMENT-TEXT                         
                               , I-COMMENT-LEN-NUM                      
                               , I-ACCOUNT-NO.                          
                                                                        
      *---------------------------------------------------------------          
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                    *          
      *---------------------------------------------------------------          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE THRU 0100-EXIT             
                                                                        
           PERFORM 1000-PROCESS              THRU 1000-EXIT             
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT             
           GOBACK                                                       
           .                                                            
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------          
      *    SET UP SQL ERROR PROCESSING                               *          
      *    DECLARE ASSOCIATED CURSOR                                 *          
      *---------------------------------------------------------------          
                                                                        
       0100-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT  :S-RETURN-CODE     AS RETURN_CODE,                 
                     :S-ACCOUNT-NO      AS ACCOUNT_NO                   
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                                   
MFA-TR*      SELECT  :S-RETURN-CODE     AS RETURN_CODE,                         
MFA-TR*              :S-ACCOUNT-NO      AS ACCOUNT_NO                           
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------          
      * SELECT ROW FOR CUSTOMER BANK INFORMATION AND PERFORM UPDATES *          
      *---------------------------------------------------------------          
                                                                        
       1000-PROCESS.                                                    
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                                                                        
           IF I-UPDATE-TYPE = 'D' AND                                   
              I-PRIMARY-IND = 'D'                                       
              MOVE 'Y' TO WS-WEB-TRANS-FLAG                             
           ELSE                                                         
              MOVE 'N' TO WS-WEB-TRANS-FLAG                             
           END-IF                                                       
                                                                        
           MOVE I-CUSTOMER-NO TO WS-CUSTOMER-NO.                        
           MOVE WS-CUSTOMER-NO-NUM TO WS-CUSTOMER-NO-COMP3.             
           MOVE WS-CUSTOMER-NO-COMP3 TO JF-CUSTOMER-NO                  
C36298                                  BE-CUSTOMER-NO.                 
                                                                        
           MOVE I-ACCOUNT-NO TO WS-ACCOUNT-NO.                          
           MOVE WS-ACCOUNT-NO-NUM TO WS-ACCOUNT-NO-COMP3.               
           MOVE WS-ACCOUNT-NO-COMP3 TO BE-ACCOUNT-NO                    
C36298                                 MH-ACCOUNT-NO.                   
                                                                        
           MOVE I-BANK-ID TO WS-BANK-ID                                 
                                                                        
           INSPECT I-CUST-BANK-SEQ-NO                                   
                   TALLYING WS-TRAILING-SPACES FOR ALL SPACES.          
           COMPUTE WS-CTR = WS-SEQ-COUNT - WS-TRAILING-SPACES.          
           MOVE I-CUST-BANK-SEQ-NO(1:WS-CTR) TO WS-BANK-SEQ-NO.         
           INSPECT WS-BANK-SEQ-NO REPLACING LEADING SPACES BY ZEROS.    
           MOVE WS-BANK-SEQ-NO-NUM TO JF-CUST-BANK-SEQ-NO.              
                                                                        
           MOVE ZEROS TO WS-TRAILING-SPACES                             
           INSPECT I-COMMENT-LEN-NUM                                    
                   TALLYING WS-TRAILING-SPACES FOR ALL SPACES.          
           COMPUTE WS-CTR = WS-SEQ-COUNT-4 - WS-TRAILING-SPACES.        
           MOVE I-COMMENT-LEN-NUM(1:WS-CTR) TO WS-COMMENT-LEN           
           INSPECT WS-COMMENT-LEN REPLACING LEADING SPACES BY ZEROS.    
                                                                        
           PERFORM 7200-SELECT-BANK-INFO THRU 7200-EXIT.                
                                                                        
           IF WS-WEB-TRANS OR I-UPDATE-TYPE = 'D'                       
              MOVE 'N' TO WS-PRIMARY-FLAG                               
              MOVE WS-BANK-SEQ-NO-NUM TO WS-BANK-SEQ                    
              PERFORM 7300-CHECK-EFT-BANK THRU 7300-EXIT                
              IF NOT WS-PRIMARY                                         
                 PERFORM 7700-CHK-PNDNG-BNK-DRFT THRU 7700-EXIT         
                 IF WS-PYMT-PNDNG = 'N'                                 
                    PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT      
                    PERFORM 7050-CUST-BANK-DEL THRU 7050-EXIT           
                 ELSE                                                   
                    MOVE +250 TO WS-ACTIVE-RETURN-CODE                  
                    MOVE AT-ACCOUNT-NO TO WS-ACCT-TRANSLATE             
                    MOVE WS-ACCT-TRANSLATE-CH TO S-ACCOUNT-NO           
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
                 END-IF                                                 
              ELSE                                                      
                 MOVE +200 TO WS-ACTIVE-RETURN-CODE                     
                 MOVE AT-ACCOUNT-NO TO WS-ACCT-TRANSLATE                
                 MOVE WS-ACCT-TRANSLATE-CH TO S-ACCOUNT-NO              
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           ELSE                                                         
              IF I-PRIMARY-IND = 'Y'                                    
                 PERFORM 7400-CHECK-EFT-ACCT THRU 7400-EXIT             
C36298           MOVE SPACES TO JF-BANK-ACCT-NICKNAME                   
T29529           PERFORM 7400A-GET-BNK-NICKNAME THRU 7400A-EXIT         
                    IF WS-UPD-PRIMARY                                   
                       PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT   
                       MOVE WS-BANK-SEQ-NO-NUM TO BE-CUST-BANK-SEQ-NO   
                       MOVE WS-BANK-ID-NUM TO BE-BANK-ID                
                       PERFORM 7600-BANK-EFT-UPD THRU 7600-EXIT         
                    END-IF                                              
              END-IF                                                    
              IF I-BANK-ACCT-NICKNA NOT = JF-BANK-ACCT-NICKNAME         
T29529           IF WS-PRIMARY-FLAG NOT EQUAL 'U'                       
                    PERFORM 1700-UPD-MNT-TRANS-HIST THRU 1700-EXIT      
T29529           END-IF                                                 
C29529           PERFORM 7800-CHK-FOR-UNIQUE-NM   THRU 7800-EXIT        
C29529           IF WS-NICKNAME-EXISTS                                  
C29529              MOVE +300 TO WS-ACTIVE-RETURN-CODE                  
C29529              MOVE AT-ACCOUNT-NO TO WS-ACCT-TRANSLATE             
C29529              MOVE WS-ACCT-TRANSLATE-CH TO S-ACCOUNT-NO           
C29529              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
C29529              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
C29529           ELSE                                                   
                    PERFORM 7000-CUST-BANK-UPD THRU 7000-EXIT           
C29529           END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
      * POPULATE RETURN VARIABLES                                               
           MOVE ZERO TO S-RETURN-CODE.                                  
           ADD +1 TO CTR-ROWS.                                          
                                                                        
           PERFORM 8999-ISSUE-COMMIT      THRU 8999-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------          
      * WRITE MNT TRANSACTION HISTORY ROWS FOR UPDATES TO CUSTOMER   *          
      * BANK INFORMATION                                             *          
      *---------------------------------------------------------------          
                                                                        
       1700-UPD-MNT-TRANS-HIST.                                         
                                                                        
      * UPDATE MNT TRANS HIST HEADER                                            
                                                                        
            PERFORM 7100-GET-CURRENT-DATETIME THRU 7100-EXIT.           
                                                                        
            MOVE WS-CURRENT-TIMESTMP TO MH-TRANS-HIST-SEQ-NO.           
            MOVE WS-CURRENT-DATE TO MH-DATE-TRANS.                      
                                                                        
            MOVE 'F' TO MH-CODE-TRAN-TYPE.                              
                                                                        
            PERFORM 7150-GET-RESP-AREA THRU 7150-EXIT.                  
                                                                        
            MOVE WS-RESP-AREA TO MH-RESP-AREA-ID.                       
            MOVE I-CUSTOMER-NO TO MH-CUSTOMER-NO.                       
            MOVE ZEROS TO MH-PREMISE-NO.                                
            MOVE I-USER-ID TO MH-USER-ID.                               
                                                                        
C33861      PERFORM 1900-RETRIEVE-INIT-TYPE-CD THRU 1900-EXIT.          
C33861      IF BE-INIT-TYPE-CD = '02'                                   
C33861         IF BE-STATUS-CODE = 'M'                                  
C33861         OR BE-STATUS-CODE = 'N'                                  
C33861         OR BE-STATUS-CODE = 'O'                                  
C33861            MOVE 'PANELWEB ' TO MH-APPL-PROGRAM-ID                
C33861         ELSE                                                     
C33861            MOVE 'PANEL194E' TO MH-APPL-PROGRAM-ID                
C33861         END-IF                                                   
C33861      ELSE                                                        
C33861         MOVE 'PANEL194 ' TO MH-APPL-PROGRAM-ID                   
            END-IF.                                                     
                                                                        
            MOVE WS-COMMENT-LEN-NUM TO MH-TRAN-COMMENT-LEN.             
            MOVE I-COMMENT-TEXT    TO MH-TRAN-COMMENT-TEXT.             
                                                                        
      * UPDATE MNT TRANS HIST DETAIL                                            
                                                                        
            PERFORM 1800-LOAD-MNT-DTL-UPD THRU 1800-EXIT.               
                                                                        
       1700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       1800-LOAD-MNT-DTL-UPD.                                           
                                                                        
           MOVE +1 TO WS-TRAN-APPL-NO.                                  
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
                                                                        
T29529     IF WS-WEB-TRANS OR I-UPDATE-TYPE = 'D'                       
T29529        MOVE +24                      TO MH-TRAN-COMMENT-LEN      
T29529        MOVE 'BANK INFORMATION DELETED'                           
T29529                                      TO MH-TRAN-COMMENT-TEXT     
T29529        MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
T29529        MOVE SPACES                   TO MI-TABLE-ID              
T29529        MOVE JF-BANK-ACCT-NICKNAME-TEXT                           
T29529                                      TO MI-PRV-COLUMN-VALUE-TEXT 
T29529        MOVE +50                      TO MI-PRV-COLUMN-VALUE-LEN  
T29529        MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
T29529        MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
T29529        MOVE 'BANK NICKNAME'          TO MI-COLUMN-DESC           
T29529        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T29529        ADD 1                         TO WS-TRAN-APPL-NO          
T29529                                                                  
T29529        MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
T29529        MOVE SPACES                   TO MI-TABLE-ID              
T29529        MOVE JF-CUST-BANK-SEQ-NO      TO MI-PRV-COLUMN-VALUE-TEXT 
T29529        MOVE +9                       TO MI-PRV-COLUMN-VALUE-LEN  
T29529        MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
T29529        MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
T29529        MOVE 'BANK SEQUENCE #'        TO MI-COLUMN-DESC           
T29529        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T29529        ADD 1                         TO WS-TRAN-APPL-NO          
T29529     END-IF.                                                      
T29529                                                                  
T29529     IF WS-UPD-PRIMARY                                            
T29529        MOVE +20                      TO MH-TRAN-COMMENT-LEN      
T29529        MOVE 'PRIMARY BANK UPDATED'   TO MH-TRAN-COMMENT-TEXT     
T29529        MOVE WS-ACCOUNT-NO-COMP3      TO MH-ACCOUNT-NO            
T29529        MOVE ZEROES                   TO MH-CUSTOMER-NO           
T29529        MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
T29529        MOVE SPACES                   TO MI-TABLE-ID              
T29529        MOVE JF-BANK-ACCT-NICKNAME-TEXT                           
T29529                                      TO MI-PRV-COLUMN-VALUE-TEXT 
T29529        MOVE +50                      TO MI-PRV-COLUMN-VALUE-LEN  
T29529        MOVE I-BANK-ACCT-NICKNA       TO MI-CHG-COLUMN-VALUE-TEXT 
T29529        MOVE +50                      TO MI-CHG-COLUMN-VALUE-LEN  
T29529        MOVE 'BANK NICKNAME'          TO MI-COLUMN-DESC           
T29529        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T29529        ADD 1                         TO WS-TRAN-APPL-NO          
T29529                                                                  
T29529        MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
T29529        MOVE SPACES                   TO MI-TABLE-ID              
T29529        MOVE BE-CUST-BANK-SEQ-NO      TO MI-PRV-COLUMN-VALUE-TEXT 
T29529        MOVE +9                       TO MI-PRV-COLUMN-VALUE-LEN  
T29529        MOVE WS-BANK-SEQ-NO-NUM       TO MI-CHG-COLUMN-VALUE-TEXT 
T29529        MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
T29529        MOVE 'BANK SEQUENCE #'        TO MI-COLUMN-DESC           
T29529        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T29529        ADD 1                         TO WS-TRAN-APPL-NO          
T29529     END-IF.                                                      
T29529                                                                  
           IF  I-BANK-ACCT-NICKNA NOT = JF-BANK-ACCT-NICKNAME-TEXT      
           AND I-BANK-ACCT-NICKNA NOT = SPACES                          
T29529     AND WS-PRIMARY-FLAG NOT EQUAL 'U'                            
T29529     AND I-UPDATE-TYPE NOT EQUAL 'D'                              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE JF-BANK-ACCT-NICKNAME-TEXT                           
                                TO MI-PRV-COLUMN-VALUE-TEXT             
              MOVE +50                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE I-BANK-ACCT-NICKNA       TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +50                      TO MI-CHG-COLUMN-VALUE-LEN  
C36298        MOVE 'BANK NICKNAME'          TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       1800-EXIT.                                                       
           EXIT.                                                        
C33861                                                                  
C33861******************************************************************14490000
C33861* 1900-RETRIEVE-INIT-TYPE-CD                                     *14500000
C33861******************************************************************14510000
C33861                                                                  
C33861 1900-RETRIEVE-INIT-TYPE-CD.                                      
C33861                                                                  
C33861     EXEC SQL                                                     
C33861        SELECT STATUS_CODE                                        
C33861              ,INIT_TYPE_CD                                       
C33861        INTO  :BE-STATUS-CODE                                     
C33861             ,:BE-INIT-TYPE-CD                                    
C33861        FROM  CSS_BANK_EFT                                        
C33861        WHERE ACCOUNT_NO  = :BE-ACCOUNT-NO                        
C33861          AND CUSTOMER_NO = :BE-CUSTOMER-NO                       
C33861     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33861                                                                  
C33861     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33861                                                                  
C33861     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33861        NEXT SENTENCE                                             
C33861     ELSE                                                         
A04074        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A04074           PERFORM 2000-CHECK-FOR-FINALLED THRU 2000-EXIT         
A04074           MOVE SPACES TO BE-INIT-TYPE-CD                         
A04074        ELSE                                                      
C33861           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
C33861           MOVE SQLCODE               TO ABEND-SQLCODE            
C33861           MOVE SQLSTATE              TO ABEND-SQLSTATE           
C33861           MOVE '1900'                TO ACTIVE-PARAGRAPH         
C33861           MOVE 'SELECT'              TO ABEND-FUNCTION           
C33861           MOVE 'CSS_BANK_EFT'        TO TABLE-1                  
C33861           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
C33861           MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
C33861           PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
C33861           PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
A04074        END-IF                                                    
C33861     END-IF.                                                      
C33861                                                                  
C33861 1900-EXIT.                                                       
C33861     EXIT.                                                        
A04074                                                                  
A04074******************************************************************14490000
A04074* 2000-CHECK-FOR-FINALLED                                        *14500000
A04074******************************************************************14510000
A04074                                                                  
A04074 2000-CHECK-FOR-FINALLED.                                         
A04074                                                                  
A04074     EXEC SQL                                                     
A04074        SELECT TOP(1) ACCOUNT_NO                                         
A04074        INTO   :WS-FINALLED-ACCT-COMP3 :WS-NULL-IND              
A04074        FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
A04074        WHERE  AT.CUSTOMER_NO = :BE-CUSTOMER-NO                   
A04074        AND    AT.CODE_ACCT_STAT = 'B'                            
A04074        AND    (AT.TOTAL_AR_BALANCE > 0.00                        
A04074        OR     CAST(AT.ACCT_FINALED_DT AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-30-DAYS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-30-DAYS-AGO
              ) <> 0) OR (LEN(:WS-30-DAYS-AGO) <> 10), CIS.CHAR2DATE(
                                                        :WS-30-DAYS-AGO
              ), CONVERT(DATE, :WS-30-DAYS-AGO) ))       
A04074                                     
A04074     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*       INTO   :WS-FINALLED-ACCT-COMP3  :WS-NULL-IND                      
MFA-TR*       FROM   CSS_ACCOUNT AT                                             
MFA-TR*       WHERE  AT.CUSTOMER_NO = :BE-CUSTOMER-NO                           
MFA-TR*       AND    AT.CODE_ACCT_STAT = 'B'                                    
MFA-TR*       AND    (AT.TOTAL_AR_BALANCE > 0.00                                
MFA-TR*       OR     DATE(AT.ACCT_FINALED_DT) >= :WS-30-DAYS-AGO)               
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04074                                                                  
A04074     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
A04074                     S-RETURN-CODE.                               
A04074                                                                  
A04074     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04074        MOVE +200 TO WS-ACTIVE-RETURN-CODE                        
A04074        MOVE WS-FINALLED-ACCT-COMP3 TO WS-ACCT-TRANSLATE          
A04074        MOVE WS-ACCT-TRANSLATE-CH TO S-ACCOUNT-NO                 
A04074        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A04074        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A04074     ELSE                                                         
A04074        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A04074           NEXT SENTENCE                                          
A04074        ELSE                                                      
A04074           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
A04074           MOVE SQLCODE               TO ABEND-SQLCODE            
A04074           MOVE SQLSTATE              TO ABEND-SQLSTATE           
A04074           MOVE '2000'                TO ACTIVE-PARAGRAPH         
A04074           MOVE 'SELECT'              TO ABEND-FUNCTION           
A04074           MOVE 'CSS_ACCOUNT'         TO TABLE-1                  
A04074           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
A04074           MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
A04074           PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
A04074           PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
A04074        END-IF                                                    
A04074     END-IF.                                                      
A04074                                                                  
A04074 2000-EXIT.                                                       
A04074     EXIT.                                                        
                                                                        
      *6530-LOAD-MNT-TRANS-HIST.                                                
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      * SELECTS ACTIVE CASH DRAWER ID FOR GIVEN CASH LOCAL OFFICE AND *         
      * DATE CASH REPORT                                              *         
      *---------------------------------------------------------------*         
                                                                        
       7000-CUST-BANK-UPD.                                              
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_CUSTOMER_BANK                                   
              SET BANK_ACCT_NICKNAME = :I-BANK-ACCT-NICKNA,             
C32389            LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                   :WS-CURRENT-TIMESTMP
              )             
              WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO                
                AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_CUSTOMER_BANK                                           
MFA-TR*       SET BANK_ACCT_NICKNAME = :I-BANK-ACCT-NICKNA,                     
MFA-TR*           LAST_UPDATE_TS     = :WS-CURRENT-TIMESTMP             14610000
MFA-TR*       WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO                        
MFA-TR*         AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CUSTOMER_BANK'       TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE JF-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'CUST_BANK_SEQ_NO'        TO TABLE-ELEMENT-2         
              MOVE JF-CUST-BANK-SEQ-NO       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-CUST-BANK-DEL.                                              
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUSTOMER_BANK                                 
                 SET BANK_ACCT_STAT_CD  = :WS-D,                        
C32389           LAST_UPDATE_TS     =  CIS.CHAR2TIMESTAMP(
                                                   :WS-CURRENT-TIMESTMP
              )             
               WHERE CUSTOMER_NO = :JF-CUSTOMER-NO                      
               AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUSTOMER_BANK                                         
MFA-TR*          SET BANK_ACCT_STAT_CD  = :WS-D,                                
MFA-TR*          LAST_UPDATE_TS     =  :WS-CURRENT-TIMESTMP             14610000
MFA-TR*        WHERE CUSTOMER_NO = :JF-CUSTOMER-NO                              
MFA-TR*        AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CUSTOMER_BANK'       TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE JF-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'CUST_BANK_SEQ_NO'        TO TABLE-ELEMENT-2         
              MOVE JF-CUST-BANK-SEQ-NO       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-CURRENT-DATETIME.                                       
      *                                                                         
C36298     EXEC SQL                                                     
C36298        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTMP              
C36298     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE.                               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
C36298        MOVE 'SET'                 TO ABEND-FUNCTION              
C36298        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C36298        MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
C36298     EXEC SQL                                                     
C36298        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
C36298     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C36298     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
C36298                     S-RETURN-CODE.                               
C36298*                                                                         
C36298     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36298        CONTINUE                                                  
C36298     ELSE                                                         
C36298        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C36298        MOVE SQLCODE               TO ABEND-SQLCODE               
C36298        MOVE SQLSTATE              TO ABEND-SQLSTATE              
C36298        MOVE '7100'                TO ACTIVE-PARAGRAPH            
C36298        MOVE 'SET'                 TO ABEND-FUNCTION              
C36298        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C36298        MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1           
C36298        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
C36298        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
C36298     END-IF.                                                      
A04074                                                                  
A04074     EXEC SQL                                                     
A04074        SELECT
              DATEADD( DAY, -30, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-30-DAYS-AGO              
A04074     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-30-DAYS-AGO = CURRENT DATE - 30 DAYS                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04074                                                                  
A04074     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
A04074                     S-RETURN-CODE.                               
A04074*                                                                         
A04074     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04074        CONTINUE                                                  
A04074     ELSE                                                         
A04074        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A04074        MOVE SQLCODE               TO ABEND-SQLCODE               
A04074        MOVE SQLSTATE              TO ABEND-SQLSTATE              
A04074        MOVE '7100'                TO ACTIVE-PARAGRAPH            
A04074        MOVE 'SET'                 TO ABEND-FUNCTION              
A04074        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A04074        MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1           
A04074        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
A04074        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
A04074     END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-GET-RESP-AREA.                                              
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA                                      
                FROM CSS_USER_PROFILE                                   
               WHERE USER_ID = :I-USER-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           S-RETURN-CODE.                               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE I-USER-ID             TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-BANK-INFO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT BANK_ACCOUNT_NAME                                  
                    ,BANK_ACCT_NO                                       
                    ,BANK_ACCT_STAT_CD                                  
                    ,BANK_ID                                            
                    ,BANK_ACCT_TYPE_CD                                  
                    ,BANK_ACCT_NICKNAME                                 
              INTO  :JF-BANK-ACCOUNT-NAME                               
                   ,:JF-BANK-ACCT-NO                                    
                   ,:JF-BANK-ACCT-STAT-CD                               
                   ,:JF-BANK-ID                                         
                   ,:JF-BANK-ACCT-TYPE-CD                               
                   ,:JF-BANK-ACCT-NICKNAME                              
              FROM  CSS_CUSTOMER_BANK                                   
              WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO                
                AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CUSTOMER_BANK'       TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE JF-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'CUST_BANK_SEQ_NO'        TO TABLE-ELEMENT-2         
              MOVE JF-CUST-BANK-SEQ-NO       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-CHECK-EFT-BANK.                                             
                                                                        
           EXEC SQL                                                     
              SELECT MIN(ACCOUNT_NO)                                    
              INTO  :AT-ACCOUNT-NO :WS-NULL-IND                        
              FROM  CSS_ACCOUNT AT                                      
              WHERE AT.CUSTOMER_NO  = :WS-CUSTOMER-NO-COMP3             
              AND EXISTS(SELECT 1                                       
                         FROM CSS_BANK_EFT BE                           
                         WHERE BE.ACCOUNT_NO = AT.ACCOUNT_NO            
                         AND BE.STATUS_CODE IN ('A','B','M','N')        
                         AND BE.CUST_BANK_SEQ_NO = :WS-BANK-SEQ )       
              AND AT.CODE_ACCT_STAT = 'A'                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-IND < 0                                        
                 MOVE 'N' TO WS-PRIMARY-FLAG                            
              ELSE                                                      
                 MOVE 'Y' TO WS-PRIMARY-FLAG                            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-CHECK-EFT-ACCT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT BANK_ACCT_NO                                       
                    ,CUST_BANK_SEQ_NO                                   
T29529              ,CUSTOMER_NO                                        
              INTO  :BE-BANK-ACCT-NO                                    
                   ,:BE-CUST-BANK-SEQ-NO                                
T29529             ,:BE-CUSTOMER-NO                                     
              FROM  CSS_BANK_EFT                                        
              WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-BANK-SEQ-NO-NUM NOT = BE-CUST-BANK-SEQ-NO           
                 MOVE 'U' TO WS-PRIMARY-FLAG                            
              END-IF                                                    
           ELSE                                                         
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7400'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_BANK_EFT'        TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
                 PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T29529 7400A-GET-BNK-NICKNAME.                                          
T29529                                                                  
T29529     EXEC SQL                                                     
T29529        SELECT BANK_ACCT_NICKNAME                                 
T29529        INTO  :JF-BANK-ACCT-NICKNAME                              
T29529        FROM  CSS_CUSTOMER_BANK                                   
T29529       WHERE CUSTOMER_NO        = :BE-CUSTOMER-NO                 
T29529         AND CUST_BANK_SEQ_NO   = :BE-CUST-BANK-SEQ-NO            
T29529     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29529                                                                  
T29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T29529                                                                  
T29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T29529        CONTINUE                                                  
T29529     ELSE                                                         
T29529        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T29529        MOVE SQLCODE               TO ABEND-SQLCODE               
T29529        MOVE SQLSTATE              TO ABEND-SQLSTATE              
T29529        MOVE '7400A'               TO ACTIVE-PARAGRAPH            
T29529        MOVE 'SELECT'              TO ABEND-FUNCTION              
T29529        MOVE 'CSS_CUSTOMER_BANK'   TO TABLE-1                     
T29529        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
T29529        MOVE BE-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
T29529        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
T29529        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
T29529     END-IF.                                                      
T29529                                                                  
T29529 7400A-EXIT.                                                      
T29529     EXIT.                                                        
                                                                        
       7600-BANK-EFT-UPD.                                               
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BANK_EFT                                      
                 SET BANK_ACCT_NO = :I-BANK-ACCT-NO                     
                    ,CUST_BANK_SEQ_NO = :BE-CUST-BANK-SEQ-NO            
                    ,BANK_ID = :BE-BANK-ID                              
                    ,ACCT_TYPE_CD = :I-BANK-ACCT-TYPE                   
                    ,STATUS_CHANGE_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                
                    ,BANK_ACCOUNT_NAME = :I-BANK-ACCT-NAME              
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-COMP3                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BANK_EFT                                              
MFA-TR*          SET BANK_ACCT_NO = :I-BANK-ACCT-NO                             
MFA-TR*             ,CUST_BANK_SEQ_NO = :BE-CUST-BANK-SEQ-NO                    
MFA-TR*             ,BANK_ID = :BE-BANK-ID                                      
MFA-TR*             ,ACCT_TYPE_CD = :I-BANK-ACCT-TYPE                           
MFA-TR*             ,STATUS_CHANGE_DT = :WS-CURRENT-DATE                        
MFA-TR*             ,BANK_ACCOUNT_NAME = :I-BANK-ACCT-NAME                      
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-COMP3                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BANK_EFT'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE I-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-CHK-PNDNG-BNK-DRFT.                                         
                                                                        
           EXEC SQL                                                     
             SELECT MIN(PB.ACCOUNT_NO)                                  
             INTO  :AT-ACCOUNT-NO :WS-NULL-IND                         
             FROM CSS_PNDNG_BNK_DRFT PB                                 
             WHERE PB.CUST_BANK_SEQ_NO = :WS-BANK-SEQ                   
             AND PB.ACCOUNT_NO IN (SELECT AT.ACCOUNT_NO                 
                            FROM CSS_ACCOUNT AT                         
                            WHERE AT.CUSTOMER_NO = :WS-CUSTOMER-NO-COMP3
                            )                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-IND < 0                                        
                 MOVE 'N' TO WS-PYMT-PNDNG                              
              ELSE                                                      
                 MOVE 'Y' TO WS-PYMT-PNDNG                              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7700'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PNDNG_BANK_DRFT'     TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE I-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
C29529******************************************************************14920000
C29529* 7800-CHK-FOR-UNIQUE-NM                                         *14930000
C29529******************************************************************14940000
C29529                                                                  
C29529 7800-CHK-FOR-UNIQUE-NM.                                          
C29529                                                                  
C29529     MOVE 'N'               TO WS-NICKNAME-EXISTS-FLAG            
C29529     EXEC SQL                                                     
C29529         SELECT CUST_BANK_SEQ_NO                                  
C29529               ,BANK_ACCOUNT_NAME                                 
C29529           INTO :JF-CUST-BANK-SEQ-NO :WS-NULL-IND                  
C29529               ,:JF-BANK-ACCOUNT-NAME                             
C29529           FROM CSS_CUSTOMER_BANK                                 
C29529          WHERE CUSTOMER_NO         = :JF-CUSTOMER-NO             
C29529            AND BANK_ACCT_NICKNAME  = :I-BANK-ACCT-NICKNA         
C29529            AND BANK_ACCT_NO       <> :JF-BANK-ACCT-NO            
C29529            AND BANK_ACCT_STAT_CD  <> 'D'                         
C29529     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
C29529        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C29529           MOVE 'Y'               TO WS-NICKNAME-EXISTS-FLAG      
C29529        END-IF                                                    
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C29529        MOVE '7800'               TO ACTIVE-PARAGRAPH             
C29529        MOVE 'SELECT'             TO ABEND-FUNCTION               
C29529        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C29529                                          ABEND-TABLES            
C29529        MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
C29529        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
C29529        MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 7800-EXIT.                                                       
C29529     EXIT.                                                        
C29529                                                                  
      *---------------------------------------------------------------*         
      *   OPEN THE RESULT SET CURSOR                                  *         
      *---------------------------------------------------------------*         
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
           .                                                            
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * COMMIT DB2 SO THAT IT WILL STORE THE PAYMENT IN TABLE         *         
      *---------------------------------------------------------------*         
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
                                                    
                                                                        
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * SENDS ERROR RESULT                                            *         
      *---------------------------------------------------------------*         
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE                  
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9100-CHECK-ERROR.                                                
                                                                        
           EXIT                                                         
           .                                                            
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *9900-SQL-ERROR.                                                          
                                                                        
            EXEC SQL                                                            
               INCLUDE CPDSP300                                                 
            END-EXEC.                                                           
                                                                        
      *---------------------------------------------------------------*         
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!    *         
      *---------------------------------------------------------------*         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK                                                     
           .                                                            
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
