       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  CSR03413.                                           
       AUTHOR.      BASKAR VANNI.                                       
COB303 DATE-WRITTEN. DEC 2003.                                           
       DATE-COMPILED.                                                   
                                                                        
      *---------------------------------------------------------------- 00070000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00080000
      *---------------------------------------------------------------- 00090000
      *--                   STORED PROCEDURE:  CSR03413              -- 00100000
      *---------------------------------------------------------------- 00110000
      *--                         S U M M A R Y                      -- 00120000
      *--                                                            -- 00130000
      *--  CSR03413 :                                                -- 00140000
      *--                                                            -- 00150000
      *--                                                            -- 00160000
      *--    #  POST PAYMENTS, WRITES JOURNALS AND TRANSACTION       -- 00170000
      *--    #  HISTORY                                              -- 00180000
      *--                                                            -- 00190000
      *--    #  INVOKED FROM WEBSERVICES AND PCSCA362                -- 00200000
      *--                                                            -- 00210000
      *---------------------------------------------------------------- 00220000
      *--                                                            -- 00230000
      *--                                                            -- 00240000
      *--    PARAMETERS                                              -- 00250000
      *--                                                            -- 00260000
      *--        IN                                                  -- 00270000
      *--                                                            -- 00280000
      *--              TIMESTAMP                    TIMESTAMP        -- 00290000
      *--              ACCOUNT NO                   CHAR(13)         -- 00300000
      *--              COMPANY NO                   CHAR(04)         -- 00310000
      *--              CASH LOCAL OFFICE            CHAR(03)         -- 00320000
      *--              CUST PHONE NO                CHAR(10)         -- 00330000
      *--              CURRENCY TYPE                CHAR(01)         -- 00340000
      *--              PAYMENT AMOUNT               CHAR(11)         -- 00350000
      *--              REPORT DATE                  DATE             -- 00360000
      *--              PAYMENT FACILITY CODE        CHAR(01)         -- 00370000
      *--              DIRECTED PAYMENT INDICATOR   CHAR(03)         -- 00380000
      *--              CONFIRMATION NO              CHAR(15)         -- 00390000
      *--              APPL PGM ID                  CHAR(09)         -- 00400000
      *--                                                            -- 00410000
      *--        OUT                                                 -- 00420000
      *--                                                            -- 00430000
      *--              NONE                                          -- 00440000
      *--                                                            -- 00450000
      *--        INOUT                                               -- 00460000
      *--                                                            -- 00470000
      *--              NONE                                          -- 00480000
      *--                                                            -- 00490000
      *---------------------------------------------------------------- 00500000
      *--    RESULT SET                                              -- 00510000
      *--                                                            -- 00520000
      *--      1                                                     -- 00530000
      *--              RETURN CODE               INTEGER             -- 00540000
      *--              TIMESTAMP                 TIMESTAMP           -- 00550000
      *--              ACCOUNT NO                CHAR(13)            -- 00560000
      *--              COMPANY NO                CHAR(04)            -- 00570000
      *--              BILLED BALANCE            CHAR(13)            -- 00580000
      *--              DNP CANCEL INDICATOR      CHAR(01)            -- 00590000
      *---------------------------------------------------------------- 00600000
      *--                   MODIFICATION LOG                         -- 00610000
      *--                                                            -- 00620000
      *--   DATE      INITIALS    COMMENTS                           -- 00630000
      *-- ----------  --------    ------------------------------------- 00640000
      *-- 12/08/2003  BASKAR V    NEW CODE                           -- 00650000
C30257*-- 02/10/2004 BASKAR VANNI 1. ADDED CODE TO AVOID DOUBLE      -- 00660000
C30257*--                         POSTING THE SAME PAYMENT BY        -- 00670000
C30257*--                         PCSCA362 AND CSR03413              -- 00680000
C30257*--                         2. POST PAYMENT IF BILLMATRIX IS   -- 00690000
C30257*--                         SENDING THE PAYMENT SECOND TIME AND-- 00700000
C30257*--                         IT IS NOT APPLIED TO CUSTOMER'S    -- 00710000
C30257*--                         ACCOUNT                            -- 00720000
C30257*--                         3. ADD 'F' AS A VALID CURRENCY TYPE-- 00730000
C30257*-- 03/18/2004 BASKAR VANNI FIX COBB XFER ACCT PROBLEM         -- 00740000
LEF   *-- 05/10/2004 LISA FISHER  ADDED CSS_CODE_VALUE TO PROGRAM    -- 00750000
LEF   *--                         FOR CURRENCY TYPE                  -- 00760000
C29529*-- 06/01/2004  SS19371     ADD CODE FOR E-CUSTOMER PROJECT    -- 00770000
C29529*--                         UPDATING PYMT_POSTED_FL TO 'Y' IN  -- 00780000
C29529*--                         CSS_PNDING_BNK_DRFT AND ADDING     -- 00790000
C29529*--                         ADDING CUST_BANK_SEQ_NO TO         -- 00800000
C29529*--                         ALSO CHANGING RETURN CODE TO 2000  -- 00810000
C29529*--                         IF SQL ERROR OCCURS BEFORE ROW IS  -- 00820000
C29529*--                         LOADED INTO CSS_PAYMENT_TRANS      -- 00830000
C29529*-- 08/17/2004  SS19371     ADD CODE TO GET APPL-PGM-ID OF     -- 00840000
C29529*--                         TRANS IF CALLED FROM pcsca362      -- 00850000
C31801*-- 01/11/2005  SK88120   A)ADDED CODE TO ALLOW CORRECT LOCAL- -- 00860000
C31801*--                         OFFICE PAYMENTS.                   -- 00870000
C31801*--                       B)ADDED CODE TO SEND 0 AS RETURN CODE-- 00880000
C31801*--                         FOR DIRECTED PAYMENTS.             -- 00890000
C31844*--                                                            -- 00900000
C31844*-- 01/19/2005  BASKAR V  1. DO ERROR (THIRD PARTY) JOURNAL    -- 00910000
C31844*--   These changes are      FOR REAL TIME E-PAY PAYMENT       -- 00920000
C31844*--   for e-pay issues    2. POPULATE COMPANY-NO FOR E-PAY     -- 00930000
C31844*--                          PAYMENT IN PAYMENT TRANS TABLE    -- 00940000
C31844*--                       3. USE APPL_PROGRAM_ID TO CHECK FOR  -- 00950000
C31844*--                          CORRECT CASH LOCAL OFFICE         -- 00960000
C31844*--                       4. DON'T CHECK AND ABEND IF PENDING  -- 00970000
C31844*--                          E-PAY IS NOT FOUND BEFORE         -- 00980000
C31844*--                          INSERTING A ROW IN PAYMENT TRANS  -- 00990000
C31844*--                          TABLE WHEN SP IS CALLED VIA WEB   -- 01000000
C31844*--                       5. UPDATE PYMT_POSTED_FL OF PENDING  -- 01010000
C31844*--                          DRAFT TABLE TO 'Y' AS SOON AS A   -- 01020000
C31844*--                          ROW IS INSERTED IN TO PAYMENT     -- 01030000
C31844*--                          TRANS.                            -- 01040000
C31844*--                       6. RETURN 5000 IF ANY ERROR OCCURS   -- 01050000
C31844*--                          WHILE PROCESSING E-PAY,IF SUCCESS -- 01060000
C31844*--                          RETURN 0. THESE TWO ARE THE VALID -- 01070000
C31844*--                          RETURN CODES FOR E-PAYMENT        -- 01080000
C31844*--                       7. WHEN SP IS CALLED VIA PCSCA362 TO -- 01090000
C31844*--                          PROCESS E-PAYMENT DON'T CHECK FOR -- 01100000
C31844*--                          PENDING EPAY.                     -- 01110000
C31844*--                       8. FIX PROBLEM IN PAYMENT FACILITY   -- 01120000
C31844*--                          CD VALIDATION.CSS_CODE_VALUE IS   -- 01130000
C31844*--                          IS USED TO VALIDATE PYMT FACILITY -- 01140000
C31844*--                       9. FIX PROBLEM IN CURRENCY TYPE      -- 01150000
C31844*--                          VALIDATION                        -- 01160000
APSAPS*  06/02/05 SK88120    UPDATE OV/SH TABLE WITH CORRECT CR/DR     *01170000
APSAPS*                      INDICATOR                                 *01180000
c33290*  02/17/06 Diane       Remove cobb transfer logic for seb emc    01190000
c33290*         Perdue-Shupe conversion project plus deleted commented  01200000
c33290*                       code                                      01210000
C33965*  02/28/06 Diane      Updated reconnect logic                    01220000
c33965*         Perdue-Shupe Plus added for fetch only                  01230000
T33431** 04/11/06   SK88120        COG PROJECT CHANGES -                01240000
T33431**                           A- ADD NEW COPYBOOKS                 01250000
T33431**                           B- CHANGE IN CPD00073                01260000
T33431** 05/22/06   SK88120       CHANGE SCSCB225 TO MCSCB225           01270000
T33431**                          (TO FIX PROD ABEND)                   01280000
T34097** 01/17/07   COVANSYS    REPLACE MODEL_SQL WITH SET STATEMENT   *01290000
C33486** 06/20/07   BASKAR V   FIX CUSTOMER BANK SEQ NO PROBLEM        *01300000
C33928*  06/20/07   BASKAR V   PERFORMANCE TUNING                      *01301000
C35818*  08/08/07   BASKAR V   CHECK RECONNECT/DNP LOGIC BEFORE POSTING*01302000
C35818*                        PAYMENT TO BE IN SYNC WITH OTHER POSTING*01303000
C35818*                        PROCESSES                               *01304000
C33928*  10/12/07   BASKAR V   IF VENDOR SENDS SPACES FOR TIMESTAMP    *01305000
C33928*                        THEN STORE IT AS AN ERROR INSTEAD OF    *01306000
C33928*                        REJECTING IT                            *01307000
C35842*  08/01/08 LATHA GANESH CHANGES MADE FOR CREDIT CARD PROJECT    *01308000
C35842*  08/08/08   BASKAR V   ADDED CALL TO MCS03413 TO HANDLE DNP AND*01308100
C35842*                        RECONNECT REAL TIME                     *01309000
C37302*  11/18/08   LG41184    REMOVE DCLGEN TBCIAC FOR CSS_CIAC.      *01309100
A00575*  01/16/09   BASKAR V   ADD THE CREDIT ACTION INDICATOR FROM    *01309200
A00575*                        CPD00068 TO CSS_PAYMENT_TRANS TABLE     *01309300
A00575*                        ERROR_CD FIELD. IT IS STORED IN THE     *01309400
A00575*                        SECOND POSITION OF THIS FIELD.          *01309500
A01294*  05/26/09   BASKAR V   CHANGE BANKRUPTCY WQ CATEGORY TO 398.   *01309600
C35843*  05/29/09   BASKAR V   CHANGES MADE TO ACCEPT DIRECTED PAYMENTS*01309700
C35843*                        FOR BILLMATRIX AND ERROR THEM OUT ON    *01309800
C35843*                        362 REPORT FOR REMITTANCE PROCESSING    *01309900
A36248*  06/23/09   LG41184    CALL NEW SUBPROGRAM MCSCB371 TO UPDATE  *01310000
A36248*                        DNP BALANCE REAL TIME FOR CSR.          *01310100
A37302*  07/28/09   LG41184    REMOVED DCLGEN TBRVCACT.                *01310200
A01714*  09/24/09   BASKAR V   FIX PROD PROBLEM - DNP IS NOT WORKING   *01310300
A01714*                        IF THIS PGM IS CALLED FROM PCSCA362.    *01310400
P00526*  09/28/09   LG41184    CHANGES FOR COLLECTIONS CREDIT CARD PROJ*01310500
P00526*  10/05/09   LG41184    CHANGES FOR AUTOCARD/RECURRING CREDIT/  *01310600
P00526*                        DEBIT CARD PROJECT.                     *01310700
A02036*  02/23/10   VV94890    CORRECT THE LOGIC TO FIX SQLCODE -507   *01310800
      *                        ISSUES(ACTIVITY ID : ACT0008).          *01310900
P00420*  08/09/10   BASKAR V   ADD ABEND-FILE IN THE PARAMETER LIST    *01310910
P00420*                        WHEN CALLING MCS03413                   *01310920
A37666*  10/05/10   CB18344    MADE CHANGE TO ADD ORIGINAL ACCOUNT NUM *01310910
A37666*                        WHEN A PAYMENT IS MADE ON A TRANSFERRED *01310920
A37666*                        ACCOUNT.                                *01310920
P00641*  05/01/12   DB41297  GET GL-ACCT-NAME-DESC FROM CSS_GL_ACCT_NO *        
A04174*  03/11/13   BASKAR V   DELINQUENCY VALUE IS MULTIPLIED BY 100  *01310910
A04174*                        TO GET MAX PAYMENT AMT FOR BILLMATRIX   *01310910
A04789*  08/01/13   BASKAR V   WHEN DUPLICATE TRANSACTION IS RECEIVED  *01310910
A04789*                        IT IS WIPING OUT THE CREDIT ACTION VALUE*01310910
A04789*                        THIS PROBLEM IS FIXED IN THIS ACTIVITY. *01310910
A05203*  03/27/15  GOKUL      CHANGE STA COMPLETION LOGIC TO HANDLE    *        
A05203*                       NEW TABLE STRUCTURE.                     *        
A5203A*  04/06/15  GOKUL AND RICK                                      *        
A5203A*                    1) INCLUDE LOGIC TO COMPLETE CDD/CDDA.      *        
A5203A*                    2) MAKE CALL TO CPD00068 A SEPARATE         *        
A5203A*                       PARAGRAPH - 2495-CALL-CPD00068.          *        
PRDFIX*  08/12/15  LG41184    PROD FIX TO NOT SEND CANCEL-DNP-FLAG TO  *        
PRDFIX*                       THE WEBSERVICE.                          *        
A5203B*  08/18/15  RICK       FIX ISSUE OF CHECKING FOR DNP WHEN NOT   *        
A5203B*                       NEEDED.                                  *        
A5203C*  09/29/15  RICK       CHECK FOR BBP OFFER PAYMENT AND BBP      *        
A5203C*  ALSO DEFECT 9155     SETUP - IF SO GET CURRENT TIMESTAMP.     *        
ACT095*  03/04/16  TP7R341    WORK QUEUE CHANGE TO REPLACE THE         *        
ACT095*            A04860     CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS.       *        
ACT196*  06/17/16  VIJAY      INCREASE 1 MILLISECOND TO MNT TIMESTMAP  *        
ACT196*  A05460               TO FIX DISPLAY ISSUE.                    *        
P00948*  07/15/16  AA97148    LEAST AMOUNT TO PAY CHANGES.             *        
ACT027*  02/15/17  RS7V450    DELETE CODE RELATED TO CSS_STA_SUMMARY            
ACT027*  APPL00005744         AND CSS_STA_DETAIL.                               
ACT285*  09/22/16  AA97148    REPLACE CPD03413 WITH NEW COPYBOOK       *        
ACT285*                       CPD03414. Ref:APPL00005460               *        
P00948*  01/01/17  VENKAT.P   SEND DNP CANCEL NOTIFICATION E-MAIL FOR  *        
P00948*                       CUSTOMERS WITH E-MAIL ADDRESS.           *        
      *----------------------------------------------------------------*01311000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03413'.
MSQ017     COPY MFASQLM.
                                                                        
      *----------------------------------------------------------------*01370000
      *    DB2 INCLUDES                                                *01380000
      *----------------------------------------------------------------*01390000
                                                                        
           EXEC SQL                                                     01410000
              INCLUDE SQLCA                                             01420000
           END-EXEC.                                                    01430000
                                                                        
      * CSS_CNT_DETAIL                                                  01500000
           EXEC SQL                                                     01510000
              INCLUDE TBCNTDET                                          01520000
           END-EXEC.                                                    01530000
                                                                        
      * CSS_BUDGET_PLAN                                                 01550000
           EXEC SQL                                                     01560000
              INCLUDE TBBGTPLN                                          01570000
           END-EXEC.                                                    01580000
                                                                        
      * CSS_LOCAL_OFFICE                                                01700000
           EXEC SQL                                                     01710000
              INCLUDE TBLOCOFC                                          01720000
           END-EXEC.                                                    01730000
                                                                        
      * CSS_USER_PROFILE                                                01750000
           EXEC SQL                                                     01760000
              INCLUDE TBUSRPRF                                          01770000
           END-EXEC.                                                    01780000
                                                                        
      * CSS_BUDGET_HIST                                                 01800000
           EXEC SQL                                                     01810000
              INCLUDE TBBGTHST                                          01820000
           END-EXEC.                                                    01830000
                                                                        
      * CSS_LIEAP                                                       01900000
           EXEC SQL                                                     01910000
              INCLUDE TBLIEAP                                           01920000
           END-EXEC.                                                    01930000
                                                                        
      * CSS_DEP_ON_HAND                                                 02000000
           EXEC SQL                                                     02010000
              INCLUDE TBDEPHND                                          02020000
           END-EXEC.                                                    02030000
                                                                        
      * CSS_ACCOUNT                                                     02050000
           EXEC SQL                                                     02060000
              INCLUDE TBACCT                                            02070000
           END-EXEC.                                                    02080000
                                                                        
      * CSS_CUSTOMER                                                    02100000
           EXEC SQL                                                     02110000
              INCLUDE TBCUST                                            02120000
           END-EXEC.                                                    02130000
                                                                        
      * CSS_PREMISE                                                     02150000
           EXEC SQL                                                     02160000
              INCLUDE TBPREM                                            02170000
           END-EXEC.                                                    02180000
                                                                        
      * CSS_AR_CNTL                                                     02200000
           EXEC SQL                                                     02210000
              INCLUDE TBARCNTL                                          02220000
           END-EXEC.                                                    02230000
                                                                        
      * CSS_JOB_PARM                                                    02250000
           EXEC SQL                                                     02260000
              INCLUDE TBJBPARM                                          02270000
           END-EXEC.                                                    02280000
                                                                        
      * CSS_PAYMENT_TRANS                                               02300000
           EXEC SQL                                                     02310000
              INCLUDE TBPMTRAN                                          02320000
           END-EXEC.                                                    02330000
                                                                        
      * CSS_CONTRACT                                                    02400000
           EXEC SQL                                                     02410000
              INCLUDE TBCNTRCT                                          02420000
           END-EXEC.                                                    02430000
                                                                        
      * CSS_DFA_ACCT                                                    02450000
           EXEC SQL                                                     02460000
              INCLUDE TBDFAACT                                          02470000
           END-EXEC.                                                    02480000
                                                                        
      * CSS_XREF_ACCT                                                   02500000
           EXEC SQL                                                     02510000
               INCLUDE TBXREF                                           02520000
           END-EXEC.                                                    02530000
                                                                        
      * CSS_AR_TRANS_HIST                                               02550000
           EXEC SQL                                                     02560000
              INCLUDE TBARHIST                                          02570000
           END-EXEC.                                                    02580000
                                                                        
      * CSS_AR_TRN_HST_DET                                              02600000
           EXEC SQL                                                     02610000
              INCLUDE TBARHDT                                           02620000
           END-EXEC.                                                    02630000
                                                                        
      * CSS_CSH_DRWR_CNTL                                               02650000
           EXEC SQL                                                     02660000
              INCLUDE TBCDCNTL                                          02670000
           END-EXEC.                                                    02680000
                                                                        
      * CSS_CSH_DRWR_JRNL                                               02700000
           EXEC SQL                                                     02710000
              INCLUDE TBCDJRNL                                          02720000
           END-EXEC.                                                    02730000
                                                                        
      * CSS_MISC_JRNL                                                   02750000
           EXEC SQL                                                     02760000
              INCLUDE TBMSJRNL                                          02770000
           END-EXEC.                                                    02780000
                                                                        
      * CSS_PROJ_SHARE                                                  02800000
           EXEC SQL                                                     02810000
              INCLUDE TBPRJSHR                                          02820000
           END-EXEC.                                                    02830000
                                                                        
      * CSS_CASHIER_OFFICE                                              02850000
           EXEC SQL                                                     02860000
              INCLUDE TBCSHOFF                                          02870000
           END-EXEC.                                                    02880000
                                                                        
      * CSS_DFA_RECVBLE                                                 02900000
           EXEC SQL                                                     02910000
              INCLUDE TBDFARCV                                          02920000
           END-EXEC.                                                    02930000
                                                                        
      * CSS_AR_PMT_PRTY                                                 03000000
           EXEC SQL                                                     03010000
              INCLUDE TBARPMT                                           03020000
           END-EXEC.                                                    03030000
                                                                        
      * CSS_GL_ACCT_NO                                                  03050000
           EXEC SQL                                                     03060000
              INCLUDE TBGLATNO                                          03070000
           END-EXEC.                                                    03080000
                                                                        
      * CSS_CREDIT_PROFILE                                              03200000
           EXEC SQL                                                     03210000
              INCLUDE TBCRPROF                                          03220000
           END-EXEC.                                                    03230000
                                                                        
      * CSS_DEP_PAY_HST                                                 03250000
           EXEC SQL                                                     03260000
              INCLUDE TBDEPHST                                          03270000
           END-EXEC.                                                    03280000
                                                                        
      * CSS_RECONNECT                                                   03300000
           EXEC SQL                                                     03310000
              INCLUDE TBRECNCT                                          03320000
           END-EXEC.                                                    03330000
                                                                        
      * CSS_CHRG_OFF                                                    03350000
           EXEC SQL                                                     03360000
              INCLUDE TBCHGOFF                                          03370000
           END-EXEC.                                                    03380000
                                                                        
      * CSS_AR_LOCKOUT                                                  03400000
           EXEC SQL                                                     03410000
              INCLUDE TBARLOCK                                          03420000
           END-EXEC.                                                    03430000
                                                                        
      * CSS_DELINQUENCY                                                 03450000
           EXEC SQL                                                     03460000
              INCLUDE TBDELQ                                            03470000
           END-EXEC.                                                    03480000
                                                                        
      * CSS_HOLIDAY                                                     03600000
           EXEC SQL                                                     03610000
               INCLUDE TBHLDAY                                          03620000
           END-EXEC.                                                    03630000
                                                                        
      * CSS_WO_ARRANGEMENT                                              03750000
           EXEC SQL                                                     03760000
               INCLUDE TBWOARGM                                         03770000
           END-EXEC.                                                    03780000
                                                                        
      * CSS_CONNECT_CHRG                                                03800000
           EXEC SQL                                                     03810000
               INCLUDE TBCCCHRG                                         03820000
           END-EXEC.                                                    03830000
                                                                        
      * CSS_RECONNECT_CHRG                                              03850000
           EXEC SQL                                                     03860000
               INCLUDE TBRCNCHR                                         03870000
           END-EXEC.                                                    03880000
                                                                        
      * CSS_MNT_TRANS_HIST                                              03900000
           EXEC SQL                                                     03910000
              INCLUDE TBMNHIST                                          03920000
           END-EXEC.                                                    03930000
                                                                        
      * CSS_MT_TRN_HST_DET                                              03950000
           EXEC SQL                                                     03960000
              INCLUDE TBMNHDT                                           03970000
           END-EXEC.                                                    03980000
                                                                        
      * CSS_CSH_REPORT_HDR                                              04000000
           EXEC SQL                                                     04010000
               INCLUDE TBCSRPHD                                         04020000
           END-EXEC.                                                    04030000
                                                                        
      * CSS_BCH_JRNL_CNTL                                               04050000
           EXEC SQL                                                     04060000
               INCLUDE TBBJCNTL                                         04070000
           END-EXEC.                                                    04080000
                                                                        
      * CSS_BATCH_JRNL                                                  04100000
           EXEC SQL                                                     04110000
               INCLUDE TBBTJRNL                                         04120000
           END-EXEC.                                                    04130000
                                                                        
      * OH - CSS_OVERSHORT_HDR                                          04150000
                                                                        
           EXEC SQL                                                     04170000
             INCLUDE TBOVSHHD                                           04180000
           END-EXEC.                                                    04190000
                                                                        
      * OT - CSS_OVERSHORT_TYPE                                         04210000
                                                                        
           EXEC SQL                                                     04230000
             INCLUDE TBOVSHTY                                           04240000
           END-EXEC.                                                    04250000
                                                                        
      * WQ - CSS_WQ_ITEMS                                               04270000
                                                                        
           EXEC SQL                                                     04290000
             INCLUDE TBWQITS                                            04300000
           END-EXEC.                                                    04310000
                                                                        
      * BG - CSS_BILLING_DET                                            04330000
                                                                        
           EXEC SQL                                                     04350000
             INCLUDE TBBLLDET                                           04360000
           END-EXEC.                                                    04370000
                                                                        
      * CE - CSS_CUST-STATS                                             04390000
                                                                        
           EXEC SQL                                                     04410000
             INCLUDE TBCSTSTS                                           04420000
           END-EXEC.                                                    04430000
                                                                        
      * UV - CSS_CODE_VALUE                                             04450000
                                                                        
           EXEC SQL                                                     04470000
             INCLUDE TBCDVALU                                           04480000
           END-EXEC.                                                    04490000
                                                                        
C29529* PB - CSS_PNDING_BNK_DRFT                                        04510000
C29529                                                                  
C29529     EXEC SQL                                                     04530000
C29529       INCLUDE TBPDBKDF                                           04540000
C29529     END-EXEC.                                                    04550000
                                                                        
P00526* PC - CSS_PNDNG_CARD_PMT                                         04561000
P00526     EXEC SQL                                                     04562000
P00526       INCLUDE TBPNDCRD                                           04563000
P00526     END-EXEC.                                                    04564000
P00526*                                                                 04565000
                                                                        
           EXEC SQL                                                     04570000
              INCLUDE CWS00008                                          04580000
           END-EXEC.                                                    04590000
                                                                        
           EXEC SQL                                                     04650000
              INCLUDE CWS0013B                                          04660000
           END-EXEC.                                                    04670000
                                                                        
           EXEC SQL                                                     04690000
              INCLUDE CWS00017                                          04700000
           END-EXEC.                                                    04710000
                                                                        
           EXEC SQL                                                     04730000
              INCLUDE CWS00061                                          04740000
           END-EXEC.                                                    04750000
                                                                        
                                                                        
           EXEC SQL                                                     04810000
              INCLUDE CWS00073                                          04820000
           END-EXEC.                                                    04830000
                                                                        
           EXEC SQL                                                     04850000
               INCLUDE CWS10016                                         04860000
           END-EXEC.                                                    04870000
                                                                        
           EXEC SQL                                                     04890000
              INCLUDE CWS00315                                          04900000
           END-EXEC.                                                    04910000
                                                                        
           COPY CCA00001.                                               04930000
                                                                        
           EXEC SQL                                                     04950000
               INCLUDE CWSX0010                                         04960000
           END-EXEC.                                                    04970000
                                                                        
           EXEC SQL                                                     04990000
                INCLUDE CWS00018                                        05000000
           END-EXEC.                                                    05010000
                                                                        
           COPY CWS00303.                                               05030000
           COPY CWS00004.                                               05050000
           COPY CWS00007.                                               05060000
           COPY CWS00038.                                               05070000
           COPY CWS00056.                                               05080000
           COPY CWS00100.                                               05090000
           COPY CWS0068L.                                               05100000
           COPY CWS0061L.                                               05110000
           COPY CJF00101.                                               05120000
           COPY CJF00102.                                               05130000
           COPY CJF00105.                                               05140000
           COPY FIOJC01.                                                05150000
T33431     COPY CWSCA225.                                               05160000
ACT095     COPY CWS00077.                                                       
                                                                        
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285*    WS VARIABLE FOR COPY BOOK CPD03414                         *         
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285                                                                  
ACT285     EXEC SQL                                                             
ACT285      INCLUDE CWS03414                                                    
ACT285     END-EXEC.                                                            
ACT285                                                                  
      *----------------------------------------------------------------*05180000
      *    WORK AREAS                                                  *05190000
      *----------------------------------------------------------------*05200000
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG            PIC X(8)   VALUE 'CSRERLOG'.     
                                                                        
      *---------------------------------------------------------------  05260000
      *--  ERROR PROCESSING VARIABLES                               --  05270000
      *---------------------------------------------------------------  05280000
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)  VALUE SPACES.         
           10  S-SQLCODE               PIC S9(9)  VALUE 0 COMP.         
           10  S-SQLSTATE              PIC X(05)  VALUE SPACES.         
           10  S-TABLE-NAME            PIC X(18)  VALUE SPACES.         
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4)  USAGE COMP.           
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4)  USAGE COMP.           
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4)  USAGE COMP.           
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4)  USAGE COMP.           
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE            PIC S9(9)  VALUE 0 COMP.         
           10 S-TIMESTAMP              PIC X(26)  VALUE SPACES.         
           10 S-ACCOUNT-NO             PIC X(13)  VALUE SPACES.         
           10 S-COMPANY-NO             PIC X(04)  VALUE SPACES.         
           10 S-BILLED-BALANCE         PIC X(13)  VALUE SPACES.         
           10 S-CANCEL-DNP-FLAG        PIC X(01)  VALUE SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9)  COMP VALUE 1.         
           05  CTR-ROWS                PIC S9(9)  COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9)  COMP.                 
           05  WRKLEN1                 PIC S9(9)  COMP.                 
           05  WRKLEN2                 PIC S9(9)  COMP.                 
           05  WRK-DONE-STATUS         PIC S9(9)  COMP.                 
                                                                        
           05  WS-SQLSTATE             PIC X(05)  VALUE SPACES.         
                                                                        
       01  WS-CONSTANTS.                                                
           05  WS-SYSTEM               PIC X(07)  VALUE 'SYSTEM'.       
           05  WS-PCSCA362             PIC X(08)  VALUE 'PCSCA362'.     
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR03413'.     
           05  WS-PGRMNAME             PIC X(08)  VALUE 'CSR03413'.     
           05  WS-JRNL-NAME            PIC X(04)  VALUE '3413'.         
           05  WS-EPAY-APPL-ID         PIC X(09)  VALUE 'CSR03413E'.    
           05  WS-APS-APPL-ID          PIC X(09)  VALUE 'CSR03413F'.    
           05  WS-APS-APPL-ID1         PIC X(08)  VALUE 'PCSCA461'.     
ACT285     05  MCS03414                PIC X(08)  VALUE 'MCS03414'.     
A36248     05  MCSCB371                PIC X(08)  VALUE 'MCSCB371'.     
A04174     05  WS-MULTIPLIER           PIC 9(03)  VALUE 100.            
           05  WS-H                    PIC X(01)  VALUE 'H'.            
           05  WS-D                    PIC X(01)  VALUE 'D'.            
           05  WS-J                    PIC X(01)  VALUE 'J'.            
           05  WS-F                    PIC X(01)  VALUE 'F'.            
           05  WS-P                    PIC X(01)  VALUE 'P'.            
           05  WS-M                    PIC X(01)  VALUE 'M'.            
           05  WS-S                    PIC X(01)  VALUE 'S'.            
           05  WS-N                    PIC X(01)  VALUE 'N'.            
           05  WS-Y                    PIC X(01)  VALUE 'Y'.            
           05  WS-Z                    PIC X(01)  VALUE 'Z'.            
           05  WS-U                    PIC X(01)  VALUE 'U'.            
           05  WS-YES                  PIC X(01)  VALUE 'Y'.            
           05  WS-NO                   PIC X(01)  VALUE 'N'.            
           05  WS-01                   PIC X(02)  VALUE '01'.           
           05  WS-4                    PIC X(01)  VALUE '4'.            
           05  WS-44                   PIC X(02)  VALUE '44'.           
           05  WS-22                   PIC X(02)  VALUE '22'.           
           05  WS-T                    PIC X(01)  VALUE 'T'.            
           05  WS-ONE                  PIC 9(01)  VALUE 1.              
           05  MCSCB068                PIC X(8)   VALUE 'MCSCB068'.     
           05  MCSCO061                PIC X(8)   VALUE 'MCSCO061'.     
A01294     05  WS-BANKRUPT-CAT-ID      PIC S9(04) COMP  VALUE +398.     
           05  WS-HIGH-PRIORITY        PIC X(01)  VALUE 'H'.            
           05  WS-BM-DATE-RANGE        PIC X(19)  VALUE                 
                                       'BILLMATRIX DT RANGE'.           
           05  WS-BM-PYMT-MAX          PIC X(19)  VALUE                 
                                       'BILLMATRIX PYMT MAX'.           
           05  WS-DATABASE             PIC X(08)  VALUE 'DATABASE'.     
           05  MULTIPLE-ROWS-SELECTED  PIC S9(09) VALUE -811 COMP.      
           05  WS-COMMENT-LEN          PIC S9(04) COMP VALUE +34.       
           05  WS-COMMENT-TEXT         PIC X(34) VALUE                  
                   'BATCH OVERAGE POSTED BY THE SYSTEM'.                
C35842     05  WS-CC-TRAN-COMMENT      PIC X(28) VALUE SPACES.          
C35842     05  WS-PYMT-OFFC-COMMENT    PIC X(17) VALUE SPACES.          
C35842     05  WS-CURR-TYPE-COMMENT    PIC X(11) VALUE SPACES.          
A37666     05  WS-XFER-ACCT-COMMENT    PIC X(24) VALUE SPACES.          
           05  WS-TRAN-COMMENT-LEN     PIC S9(04) COMP VALUE +19.       
           05  WS-TRAN-COMMENT-TEXT    PIC X(34) VALUE                  
                   'THIRD PARTY JOURNAL'.                               
T33431     05  MCSCB225                 PIC X(8) VALUE  'MCSCB225'.     
T33431     05  WS-COG-TRAN-TYPE-CD-73   PIC X(1) VALUE  'P'.            
                                                                        
       01  WS-BANKRUPT-WQ-MSG.                                          
           05  WS-BANKRUPT-WQ-TXT1     PIC X(40) VALUE                  
               'A THIRD PARTY PAYMENT IN THE AMOUNT OF $'.              
           05  WS-BANKRUPT-WQ-AMT-DISP PIC ZZZZZZZZ9.99.                
           05  WS-BANKRUPT-WQ-TXT2     PIC X(46) VALUE                  
               ' POSTED FOR AN ACCOUNT FLAGGED FOR BANKRUPTCY.'.        
           05  FILLER                  PIC X(04) VALUE SPACES.          
                                                                        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-3           PIC S9(4)  USAGE COMP VALUE +0.  
           05  WS-NULL-IND-4           PIC S9(4)  USAGE COMP VALUE +0.  
           05  WS-NULL-IND-5           PIC S9(4)  USAGE COMP VALUE +0.  
           05  WS-NULL-IND-6           PIC S9(4)  USAGE COMP VALUE +0.  
           05  WS-NULL-IND-7           PIC S9(4)  USAGE COMP VALUE +0.  
           05  WS-NULL-IND-8           PIC S9(4)  USAGE COMP VALUE +0.  
           05  WS-NULL-IND-9           PIC S9(4)  USAGE COMP VALUE +0.  
           05  WS-NULL-IND-10          PIC S9(4)  USAGE COMP VALUE +0.  
           05  WS-NULL-IND-11          PIC S9(4)  USAGE COMP VALUE +0.  
           05  WS-NULL-IND-12          PIC S9(4)  USAGE COMP VALUE +0.  
A5203A     05 WS-TOTAL-ARREARS         PIC S9(9)V99 COMP-3 VALUE 0.     
ACT285     05  WS-PROGRAM-NAME         PIC X(08) VALUE SPACES.          
ACT285     05  WS-UPDATE-ACTION-FL     PIC X(01) VALUE SPACES.          
                                                                        
       01  WS-PREV-BUSINESS-DAY-MISC.                                   
           05 WS-OLD-BUSINESS-DAY      PIC X(10).                       
           05 WS-PREV-SUNDAY           PIC S9(04) COMP VALUE -1.        
           05 WS-PREV-SATURDAY         PIC S9(04) COMP VALUE +5.        
           05 WS-PREV-BUSINESS-DAY     PIC  X(01)      VALUE 'N'.       
              88 PREV-BUSINESS-DAY-FOUND               VALUE 'Y'.       
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-INPUT-ERROR-SW        PIC X(01) VALUE SPACES.          
              88 ACCOUNT-NOT-FOUND               VALUE 'A'.             
              88 ACCOUNT-INACTIVE                VALUE 'B'.             
              88 APS-DIR-PYMT-IND                VALUE 'D'.             
              88 REPORT-DATE-ERROR               VALUE 'E'.             
              88 CURR-TYPE-ERROR                 VALUE 'F'.             
              88 PYMT-GT-MAX-AMT                 VALUE 'G'.             
              88 NEG-OR-ZERO-PYMT                VALUE 'H'.             
              88 PYMT-FACILITY-ERROR             VALUE 'I'.             
              88 INVALID-PYMT-OFFICE             VALUE 'J'.             
              88 INVALID-DIR-PYMT-IND            VALUE 'K'.             
              88 ACCOUNT-NOT-NUMERIC             VALUE 'L'.             
              88 AMOUNT-NOT-NUMERIC              VALUE 'M'.             
              88 COBB-XFERED-ACCT                VALUE 'N'.             
              88 MULTIPLE-OLD-ACCOUNT            VALUE 'O'.             
              88 DUPLICATE-PAYMENT               VALUE 'P'.             
S29529        88 DRAFT-NOT-FOUND                 VALUE 'Q'.             
C33928        88 INVALID-TIMESTAMP               VALUE 'Y'.             
           05 WS-DIR-PYMT-SW           PIC X(03) VALUE SPACES.          
              88 UNDIRECTED-PYMT                 VALUE 'UND'.           
              88 DEPOSIT-PYMT                    VALUE 'DEP'.           
           05 WS-DATABASE-SW           PIC 9(01) VALUE 0.               
              88 CSR-DATABASE                    VALUE 1.               
              88 SEB-DATABASE                    VALUE 2.               
           05 WS-EXISTS-SW             PIC X(01) VALUE 'N'.             
              88 WQ-EXISTS                       VALUE 'Y'.             
              88 WQ-NOT-EXISTS                   VALUE 'N'.             
           05 WS-CAN-REBILL-SW         PIC X(01) VALUE 'N'.             
              88 CAN-REBILL-EXISTS               VALUE 'Y'.             
              88 CAN-REBILL-NOT-EXISTS           VALUE 'N'.             
           05 WS-PASSWORD-SW           PIC X(01) VALUE 'N'.             
              88 PASSWORD-EXISTS                 VALUE 'Y'.             
              88 PASSWORD-NOT-EXISTS             VALUE 'N'.             
           05 WS-SUB-ACCT-SW           PIC X(01) VALUE SPACES.          
              88 SUB-ACCOUNT                     VALUE 'S'.             
A5203C     05 WS-BBP-SETUP             PIC X(01) VALUE SPACES.          
A5203C        88 BBP-SETUP-NO                    VALUE 'N'.             
A5203C        88 BBP-SETUP-YES                   VALUE 'Y'.             
                                                                        
       01  WS-MISC-ITEMS.                                               
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
           05  WS-AMOUNT-9             PIC 9(11)V99.                    
           05  WS-AMOUNT-X  REDEFINES  WS-AMOUNT-9 PIC X(13).           
           05  WS-PYMT-AMT             PIC X(11).                       
           05  WS-PYMT-AMT-NUM REDEFINES WS-PYMT-AMT PIC 9(9)V99.       
           05  WS-PYMT-AMOUNT          PIC S9(09)V99 COMP-3 VALUE +0.   
A04174     05  WS-PYMT-MAX             PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-USER-ID              PIC X(07)  VALUE SPACES.         
           05  WS-XFER-ACCT            PIC X(01)  VALUE SPACES.         
A37666     05  WS-XFER-ACCT-NUM        PIC X(13)  VALUE SPACES.         
           05  WS-HOLD-ACCT-NUM        PIC X(13)  VALUE SPACES.         
           05  WS-DELINQ-VAL           PIC 9(04)  VALUE 0.              
           05  WS-GL-ACCT-NUM          PIC 9(3).9(4).                   
           05  WS-CLR-CASH             PIC X(10)      VALUE 'CLR-CASH'. 
           05  WS-TOTAL-CHRG-OFF       PIC S9(11)V99  VALUE 0 COMP-3.   
           05  RS-RETURN-CODE          PIC S9(9)      VALUE 0 COMP.     
C35842     05  WS-DNP-RET-CODE         PIC S9(4)      VALUE 0 COMP.     
           05  WS-DATE-ORIG-PYMT-IND   PIC S9(04) COMP VALUE +0.        
           05  WS-CURRENT-DATE         PIC X(10)  VALUE SPACES.         
C29529     05  WS-YESTERDAY            PIC X(10)  VALUE SPACES.         
           05  WS-REPORT-DATE          PIC X(10)  VALUE SPACES.         
           05  WS-PREV-DATE            PIC X(10)  VALUE SPACES.         
           05  WS-CURRENT-TIMESTAMP    PIC X(26)  VALUE SPACES.         
           05  WS-CURRENT-TS           PIC X(26)  VALUE SPACES.         
C33928     05  WS-INVALID-TS           PIC X(26)  VALUE                 
C33928                                 '1900-01-01-00.00.00.000000'.    
           05  WS-BANKRUPT-WQ-AMT      PIC 9(09)V99 VALUE ZERO.         
           05  WS-DISP-GL-ACCT         PIC 9(3).9(4).                   
           05  WS-SO-UPDT-ACTION-FL    PIC X(01)  VALUE SPACES.         
           05  WS-COMPANY-NO           PIC X(02)  VALUE SPACES.         
COB305     05 WS-REV-MTH-LOWER-LIMIT        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.         
COB305     05 WS-REV-MTH-UPPER-LIMIT        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.         
           05  WS-REV-MTH-NUM          PIC S9(6)V.                      
           05  WS-PARM-DATA            PIC X(20).                       
           05  WS-PARM-DATA-N          REDEFINES WS-PARM-DATA.          
               10  WS-PARM-TEXT        PIC X(14).                       
               10  WS-PARM-REVMNTH.                                     
                   15 WS-PARM-REV-YY   PIC X(4).                        
                   15 WS-PARM-REV-MM   PIC X(2).                        
           05  WS-REV-DATE.                                             
               10 WS-REV-YY            PIC X(04)  VALUE SPACES.         
               10 FILLER               PIC X(01)  VALUE '-'.            
               10 WS-REV-MM            PIC X(02)  VALUE SPACES.         
               10 FILLER               PIC X(01)  VALUE '-'.            
               10 WS-REV-DD            PIC X(02)  VALUE '01'.           
           05  WS-REV-DATE1            PIC X(10).                       
           05  WS-BILL-BAL             PIC S9(11)V99                    
                                                  VALUE 0 COMP-3.       
           05  WS-BILL-BAL-NUM         PIC S9(11)V99.                   
           05  WS-BILL-BAL-CHAR        PIC X(13).                       
           05  WS-BILL-BAL-EDIT REDEFINES WS-BILL-BAL-CHAR              
                                       PIC -(10).99.                    
C29529     05  WS-CURRENT-TS-FROM.                                      
C29529         10 WS-CURRENT-DATE-FROM     PIC X(10).                   
C29529         10 WS-TS-FROM               PIC X(16)                    
C29529                      VALUE '-00.00.00.000001'.                   
C29529     05  WS-CURRENT-TS-TO.                                        
C29529         10 WS-CURRENT-DATE-TO       PIC X(10).                   
C29529         10 WS-TS-TO                 PIC X(16)                    
C29529                      VALUE '-23.59.59.999999'.                   
C29529     05  WS-CURRENT-TS-FROM-DB2      PIC X(26).                   
C29529     05  WS-CURRENT-TS-TO-DB2        PIC X(26).                   
C29529     05  WS-APPL-PGM-ID              PIC X(09).                   
LEF        05  WS-CV-TABLE-NAME        PIC X(18).                       
LEF        05  WS-CV-COLUMN-NAME       PIC X(18).                       
LEF        05  WS-CV-CODE-VALUE        PIC X(10).                       
C31844     05  WS-APPL-PGM.                                             
C31844         10 WS-APPL-PGM-1        PIC X(03) VALUE SPACES.          
C31844         10 WS-APPL-PGM-2        PIC X(06) VALUE SPACES.          
ACT095     05  WS-WQ-CALL-PGM           PIC X(08)  VALUE 'MCSCB077'.    
ACT095     05  MCSCB077                 PIC X(08)  VALUE 'MCSCB077'.    
ACT095     05  SCSCB077                 PIC X(08)  VALUE 'SCSCB077'.    
ACT095     05  WS-CPD0010S-CALL-TYPE    PIC X(01)  VALUE 'O'.           
ACT095         88 WS-CPD0010S-ONLINE-CALL          VALUE 'O'.           
ACT095         88 WS-CPD0010S-BATCH-CALL           VALUE 'B'.           
P00948     05  WS-LEAST-AMT-DUE-CD      PIC X(13)  VALUE                
P00948                                       'LEAST-AMT-DUE'.           
P00948     05  WS-LEAST-AMT-DUE         PIC S9(4)V9(5) USAGE COMP-3     
P00948                                             VALUE 0.             
      *---------------------------------------------------------------  07510000
      * DECLARE CURSOR FOR CSS_JOB_PARM TABLE                        -  07520000
      *---------------------------------------------------------------  07530000
                                                                        
           EXEC SQL                                                     
            DECLARE PARM_CSR CURSOR FOR                                 
             SELECT PROGRAM_NAME                                        
                   ,COMPANY_NO                                          
                   ,CMND_CODE                                           
                   ,SEQ_NO                                              
                   ,STATUS                                              
                   ,PARM_DATA                                           
               FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                          
              WHERE PROGRAM_NAME  = :G6-PROGRAM-NAME                    
                AND CMND_CODE     = :G6-CMND-CODE                       
                AND COMPANY_NO    = :G6-COMPANY-NO                      
              ORDER BY SEQ_NO                                           
C33965        FOR READ ONLY                                     
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07550000
MFA-TR*     DECLARE PARM_CSR CURSOR FOR                                 07560000
MFA-TR*      SELECT PROGRAM_NAME                                        07570000
MFA-TR*            ,COMPANY_NO                                          07580000
MFA-TR*            ,CMND_CODE                                           07590000
MFA-TR*            ,SEQ_NO                                              07600000
MFA-TR*            ,STATUS                                              07610000
MFA-TR*            ,PARM_DATA                                           07620000
MFA-TR*        FROM CSS_JOB_PARM                                        07630000
MFA-TR*       WHERE PROGRAM_NAME  = :G6-PROGRAM-NAME                    07640000
MFA-TR*         AND CMND_CODE     = :G6-CMND-CODE                       07650000
MFA-TR*         AND COMPANY_NO    = :G6-COMPANY-NO                      07660000
MFA-TR*       ORDER BY SEQ_NO                                           07670000
MFA-TR*       FOR FETCH ONLY WITH UR                                    07680000
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                    07690000
                                                                        
      *----------------------------------------------------------------*07710000
      *    DECLARE CURSOR TO SELECT OVERSHORT TYPE                     *07720000
      *----------------------------------------------------------------*07730000
           EXEC SQL                                                     
            DECLARE OVSHTYPE_CURSOR CURSOR FOR                          
             SELECT OVERSHORT_TYPE_CD                                   
               FROM CSS_OVERSHORT_TYPE WITH(READUNCOMMITTED)                    
              WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                         
C33965        FOR READ ONLY                                     
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07740000
MFA-TR*     DECLARE OVSHTYPE_CURSOR CURSOR FOR                          07750000
MFA-TR*      SELECT OVERSHORT_TYPE_CD                                   07760000
MFA-TR*        FROM CSS_OVERSHORT_TYPE                                  07770000
MFA-TR*       WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                         07780000
MFA-TR*       FOR FETCH ONLY WITH UR                                    07790000
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                    07800000
                                                                        
       LINKAGE SECTION.                                                 
       01  I-TIMESTAMP                 PIC X(26).                       
       01  I-ACCOUNT-NO                PIC X(13).                       
       01  I-COMPANY-NO                PIC X(04).                       
       01  I-CASH-LOC-OFFICE           PIC X(03).                       
       01  I-CUST-PHONE-NO             PIC X(10).                       
       01  I-CURRENCY-TYPE             PIC X(01).                       
       01  I-PAYMENT-AMOUNT            PIC X(11).                       
       01  I-REPORT-DATE               PIC X(10).                       
       01  I-PYMT-FACILITY-CD          PIC X(01).                       
       01  I-DIR-PYMT-IND              PIC X(03).                       
       01  I-CONFIRMATION-NO           PIC X(15).                       
       01  I-APPL-PGM-ID               PIC X(09).                       
                                                                        
       PROCEDURE DIVISION USING I-TIMESTAMP,                            
                                I-ACCOUNT-NO,                           
                                I-COMPANY-NO,                           
                                I-CASH-LOC-OFFICE,                      
                                I-CUST-PHONE-NO,                        
                                I-CURRENCY-TYPE,                        
                                I-PAYMENT-AMOUNT,                       
                                I-REPORT-DATE,                          
                                I-PYMT-FACILITY-CD,                     
                                I-DIR-PYMT-IND,                         
                                I-CONFIRMATION-NO,                      
                                I-APPL-PGM-ID.                          

SCA006        SET WS-GL-SUB TO 1.
                                                                        
      *---------------------------------------------------------------  08100000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                    *  08110000
      *---------------------------------------------------------------  08120000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE THRU 0100-EXIT             
                                                                        
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT             
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT             
                                                                        
ACT285     IF CTR-ROWS < 1                                              
C35842        CONTINUE                                                  
C35842     ELSE                                                         
ACT285        PERFORM 8999-ISSUE-COMMIT          THRU 8999-EXIT         
ACT285        PERFORM 2950-PROCESS-DNP-RECONNECT THRU 2950-EXIT         
ACT285        MOVE WS-CNCL-DNP-ACTN-FL TO S-CANCEL-DNP-FLAG             
C35842        IF S-CANCEL-DNP-FLAG = 'Y'                                
C35842           IF I-PYMT-FACILITY-CD = 'O' OR 'U'                     
C35842              EVALUATE WS-DNP-RET-CODE                            
C35842* DNP/DNPFB/RECONNECT handled correctly                           08223400
C35842                  WHEN 0                                          
C35842* pending DNP cancelled                                           08223600
C35842                  WHEN 790                                        
C35842* Reconnect order released                                        08223800
C35842                  WHEN 5137                                       
C35842                       MOVE 'N'        TO S-CANCEL-DNP-FLAG       
C35842              END-EVALUATE                                        
C35842           ELSE                                                   
C35842              IF WS-DNP-RET-CODE = 0                              
C35842                 MOVE 'N'              TO S-CANCEL-DNP-FLAG       
C35842              ELSE                                                
C35842                 MOVE 0                TO S-RETURN-CODE           
C35842              END-IF                                              
C35842           END-IF                                                 
ACT285           PERFORM 8100-UPDATE-DNP-CODE   THRU 8100-EXIT          
C35842        ELSE                                                      
C35842           IF WS-DNP-RET-CODE > 0                                 
C35842              MOVE WS-DNP-RET-CODE     TO S-RETURN-CODE           
C35842           END-IF                                                 
C35842        END-IF                                                    
C35842     END-IF                                                       
A36248*                                                                 08225600
PRDFIX*                                                                         
PRDFIX     IF S-CANCEL-DNP-FLAG = 'Y'                                   
PRDFIX        MOVE 'N'        TO S-CANCEL-DNP-FLAG                      
PRDFIX     END-IF                                                       
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT             
                                                                        
           GOBACK                                                       
           .                                                            
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  08280000
      *    SET UP SQL ERROR PROCESSING                               *  08290000
      *    DECLARE ASSOCIATED CURSOR                                 *  08300000
      *---------------------------------------------------------------  08310000
                                                                        
       0100-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC               
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC               
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC               
                                                                        
           MOVE WS-01                        TO C8-COMPANY-NO           
           MOVE WS-DATABASE                  TO C8-DELINQ-CD            
           PERFORM 7070-GET-DELINQ-VALUE     THRU 7070-EXIT             
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE-SW          
                                                                        
           IF I-TIMESTAMP = 'STRESS'                                    
              PERFORM 7202-GET-CURRENT-TS THRU 7202-EXIT                
              MOVE WS-CURRENT-TS TO I-TIMESTAMP                         
              MOVE 'STRESS '     TO I-CONFIRMATION-NO                   
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT  :S-RETURN-CODE     AS RETURN_CODE                  
                    ,:S-TIMESTAMP       AS TIMESTAMP                    
                    ,:S-ACCOUNT-NO      AS ACCOUNT_NO                   
                    ,:S-COMPANY-NO      AS COMPANY_NO                   
                    ,:S-BILLED-BALANCE  AS BILLED_BALANCE               
                    ,:S-CANCEL-DNP-FLAG AS CANCEL_DNP_FLAG              
               FROM CIS.SYSDUMMY1                                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     08500000
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                           08510000
MFA-TR*      SELECT  :S-RETURN-CODE     AS RETURN_CODE                  08520000
MFA-TR*             ,:S-TIMESTAMP       AS TIMESTAMP                    08530000
MFA-TR*             ,:S-ACCOUNT-NO      AS ACCOUNT_NO                   08540000
MFA-TR*             ,:S-COMPANY-NO      AS COMPANY_NO                   08550000
MFA-TR*             ,:S-BILLED-BALANCE  AS BILLED_BALANCE               08560000
MFA-TR*             ,:S-CANCEL-DNP-FLAG AS CANCEL_DNP_FLAG              08570000
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                    08580000
MFA-TR*    END-EXEC                                                     08590000
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  08640000
      * SELECTS ACTIVE CASH DRAWER FOR CASH LOCAL OFFICE AND DATE.   *  08650000
      * IF NOT FOUND IT CHECKS FOR A REPORT. IF REPORT NOT FOUND     *  08660000
      * IT CREATES A NEW REPORT AND NEW BATCH. INSERT A ROW IN       *  08670000
      * CSS_PAYMENT_TRANS AND VALIDATES INPUTS. IF ERROR IT UPDATES  *  08680000
      * THE PAYMENT ROW AS ERROR                                     *  08690000
      *---------------------------------------------------------------  08700000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                                                                        
      * POPULATE RETURN VARIABLES                                       08760000
           MOVE ZERO                         TO S-RETURN-CODE           
           MOVE I-TIMESTAMP                  TO S-TIMESTAMP             
           MOVE I-ACCOUNT-NO                 TO S-ACCOUNT-NO            
           MOVE I-COMPANY-NO                 TO S-COMPANY-NO            
           MOVE SPACES                       TO S-BILLED-BALANCE        
           MOVE SPACES                       TO S-CANCEL-DNP-FLAG       
           ADD +1 TO CTR-ROWS                                           
                                                                        
           MOVE I-PAYMENT-AMOUNT             TO WS-PYMT-AMT             
           MOVE WS-PYMT-AMT-NUM              TO WS-PYMT-AMOUNT          
                                                                        
C33928     IF I-TIMESTAMP = SPACES                                      
C33928        MOVE WS-INVALID-TS             TO I-TIMESTAMP             
C33928     END-IF                                                       
                                                                        
           IF I-APPL-PGM-ID = WS-PCSCA362                               
              MOVE I-REPORT-DATE             TO JT-DATE-CASH-REPORT     
              MOVE I-CASH-LOC-OFFICE         TO JT-CASH-LOCAL-OFFICE    
              MOVE I-TIMESTAMP               TO JT-PYMT-RCVD-TS         
              MOVE I-ACCOUNT-NO              TO JT-ACCOUNT-NO           
              PERFORM 7160-SELECT-PYMT-TRAN  THRU 7160-EXIT             
           ELSE                                                         
C29529        IF I-APPL-PGM-ID = WS-EPAY-APPL-ID                        
C29529           IF SEB-DATABASE                                        
C29529              MOVE '022' TO I-CASH-LOC-OFFICE                     
C29529           END-IF                                                 
C29529           PERFORM 8057-SELECT-I-REPORT-DATE THRU 8057-EXIT       
C29529        END-IF                                                    
APS           IF I-APPL-PGM-ID = WS-APS-APPL-ID                         
APS              PERFORM 8057-SELECT-I-REPORT-DATE THRU 8057-EXIT       
APS           END-IF                                                    
              PERFORM 2400-POPULATE-PYMT-TABLE  THRU 2400-EXIT          
              PERFORM 8020-INSERT-PAYMENT       THRU 8020-EXIT          
C31844        IF I-APPL-PGM-ID = WS-EPAY-APPL-ID                        
C31844           PERFORM 8055-UPDATE-PYMT-POSTED  THRU 8055-EXIT        
C31844        END-IF                                                    
              IF DUPLICATE-PAYMENT                                      
                 CONTINUE                                               
              ELSE                                                      
      * COMMIT BEFORE STARTING ANY PROCESS TO STORE THE PAYMENT         09170000
      * IN CSS_PAYMENT_TRANS TABLE                                      09180000
                 PERFORM 8999-ISSUE-COMMIT      THRU 8999-EXIT          
              END-IF                                                    
                                                                        
           END-IF                                                       
                                                                        
           IF DUPLICATE-PAYMENT                                         
C30257        PERFORM 7120-SELECT-PAYMENT    THRU 7120-EXIT             
C30257        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
C30257           MOVE SPACES                 TO WS-INPUT-ERROR-SW       
C30257           PERFORM 1100-VALIDATE-INPUT THRU 1100-EXIT             
C30257        END-IF                                                    
           ELSE                                                         
              PERFORM 1100-VALIDATE-INPUT    THRU 1100-EXIT             
           END-IF                                                       
                                                                        
           MOVE WS-SYSTEM     TO JT-LAST-UPDATE-USERID                  
                                                                        
           IF CSR-DATABASE                                              
              IF WS-COMPANY-NO = '01'                                   
                 MOVE 'SCEG'                 TO S-COMPANY-NO            
              ELSE                                                      
                 IF WS-COMPANY-NO = '26'                                
                    MOVE 'PSNC'              TO S-COMPANY-NO            
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF SEB-DATABASE                                           
                 MOVE 'SEB'                  TO S-COMPANY-NO            
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-INPUT-ERROR-SW > SPACES                                
A04789        IF DUPLICATE-PAYMENT                                      
A04789           PERFORM 7750-GET-ERROR-CD                              
A04789              THRU 7750-EXIT                                      
A04789        END-IF                                                    
A04789        MOVE WS-INPUT-ERROR-SW TO JT-ERROR-CD(1:1)                
              PERFORM 8060-UPDATE-ERROR-CD   THRU 8060-EXIT             
C31801        IF WS-INPUT-ERROR-SW = 'D' AND                            
C35843           (I-APPL-PGM-ID = WS-APS-APPL-ID OR                     
C35843            I-APPL-PGM-ID = PROGRAM-NAME)                         
C31801           MOVE ZERO                   TO S-RETURN-CODE           
C31801        ELSE                                                      
                 MOVE +1000                  TO S-RETURN-CODE           
C31801        END-IF                                                    
C31844        IF JT-APPL-PROGRAM-ID = WS-EPAY-APPL-ID                   
C31844           MOVE 5000                   TO S-RETURN-CODE           
C31844        END-IF                                                    
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF                                                       
                                                                        
      * CHECKS AR LOCK OUT INDICATOR                                    09650000
           PERFORM 7999-SELECT-AL            THRU 7999-SELECT-AL-EXIT   
           IF AL-AR-LOCKOUT-IND = WS-Y                                  
              MOVE 5000                      TO S-RETURN-CODE           
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF                                                       
                                                                        
           PERFORM 1050-CREATE-REPORT-DRWR                              
              THRU 1050-EXIT                                            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  09780000
      * CHECKS FOR VALID CASH DRAWER AND CASH REPORT FOR GIVEN CASH  *  09790000
      * LOCAL OFFICE AND CASH REPORT DATE. IF NOT AVAILABLE IT       *  09800000
      * CREATES NEW BATCH AND REPORT.                                *  09810000
      *---------------------------------------------------------------  09820000
                                                                        
       1050-CREATE-REPORT-DRWR.                                         
                                                                        
           MOVE WS-REPORT-DATE               TO CS-DATE-CASH-REPORT     
                                                YR-DATE-CASH-REPORT     
           MOVE I-CASH-LOC-OFFICE            TO CS-CASH-LOCAL-OFFICE    
                                                CS-CASH-REPORT-NO       
                                                YR-CASH-LOCAL-OFFICE    
           MOVE WS-01                        TO CS-CASH-COMPANY-NO      
                                                YR-CASH-COMPANY-NO      
           MOVE WS-A                         TO CS-CODE-CSH-DRWR-STAT   
           IF I-APPL-PGM-ID = WS-APS-APPL-ID                            
             PERFORM 7010-CHECK-CASH-RPT    THRU 7010-EXIT              
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                MOVE Y2-USER-ID         TO YR-USER-ID                   
                MOVE WS-A               TO YR-STATUS                    
                PERFORM 8000-CREATE-NEW-RPT THRU 8000-EXIT              
             END-IF                                                     
           END-IF                                                       
                                                                        
           PERFORM 7000-SELECT-ACTIVE-DRWR   THRU 7000-EXIT             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
                                                                        
              PERFORM 7010-CHECK-CASH-RPT    THRU 7010-EXIT             
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE Y2-USER-ID         TO YR-USER-ID                  
                 MOVE WS-A               TO YR-STATUS                   
                 PERFORM 8000-CREATE-NEW-RPT THRU 8000-EXIT             
              END-IF                                                    
                                                                        
              INITIALIZE DCLCSS-CSH-DRWR-CNTL                           
              MOVE WS-01                     TO  CS-CASH-COMPANY-NO     
              MOVE WS-REPORT-DATE            TO  CS-DATE-CASH-REPORT    
                                                 CS-DATE-LAST-ACTIVITY  
              MOVE I-CASH-LOC-OFFICE         TO  CS-CASH-LOCAL-OFFICE   
                                                 CS-CASH-REPORT-NO      
                                                                        
              PERFORM 7020-SELECT-MAX-DRWR-ID THRU 7020-EXIT            
                                                                        
              ADD  WS-ONE                    TO  CS-CASH-DRAWER-ID      
              MOVE WS-A                      TO  CS-CODE-CSH-DRWR-STAT  
              MOVE Y2-USER-ID                TO  CS-USER-ID             
              MOVE SPACES                    TO  CS-CASHIER-CODE        
              MOVE WS-NO                     TO  CS-CODE-FCS-EXTRACTED  
              MOVE SPACES                    TO  CS-BALANCED-BY         
              MOVE WS-P                      TO  CS-CODE-PYMT-FACILITY  
              MOVE -1                        TO  WS-NULL-IND-12         
                                                                        
              PERFORM 8010-CREATE-NEW-BATCH  THRU 8010-EXIT             
                                                                        
           END-IF                                                       
           .                                                            
       1050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  10380000
      * GET DATE RANGE FROM CSS_DELINQUENCY TABLE AND CHECKS WHETHER *  10390000
      * REPORT DATE IS WITHIN VALID RANGE. ALSO IT VALIDATES ACCOUNT,*  10400000
      * PAYMENT AMT, CURRENCY AND PAYMENT FACILITY.                  *  10410000
      *---------------------------------------------------------------  10420000
                                                                        
       1100-VALIDATE-INPUT.                                             
                                                                        
C33928     IF I-TIMESTAMP = WS-INVALID-TS                               
C33928        SET INVALID-TIMESTAMP TO TRUE                             
C33928        GO TO 1100-EXIT                                           
C33928     END-IF                                                       
                                                                        
C31844* CHECK WHETHER CASH LOCAL OFFICE IS VALID                        10460000
C31844                                                                  
C31844     IF JT-APPL-PROGRAM-ID = PROGRAM-NAME                         
C31844        MOVE JT-APPL-PROGRAM-ID        TO UV-PROGRAM-ID           
C31844     ELSE                                                         
C31844        MOVE JT-APPL-PROGRAM-ID        TO WS-APPL-PGM             
C31844        MOVE WS-APPL-PGM-2             TO UV-PROGRAM-ID           
C31844     END-IF                                                       
C31844     MOVE '01'                         TO UV-COMPANY-NO           
C31844     MOVE 17                           TO UV-TABLE-NA-LEN         
C31844     MOVE 'CSS_PAYMENT_TRANS'          TO UV-TABLE-NA-TEXT        
C31844     MOVE 17                           TO UV-COLUMN-NA-LEN        
C31844     MOVE 'CASH_LOCAL_OFFICE'          TO UV-COLUMN-NA-TEXT       
C31844     PERFORM 7300-SELECT-CODE-VAL      THRU 7300-EXIT             
C31844     IF UV-CODE-VALUE-TEXT(1:3) = I-CASH-LOC-OFFICE               
C31844        CONTINUE                                                  
C31844     ELSE                                                         
C31844        SET INVALID-PYMT-OFFICE        TO TRUE                    
C31844        GO TO 1100-EXIT                                           
C31844     END-IF                                                       
C31844                                                                  
C31844     MOVE WS-01                        TO Y2-CASH-COMPANY-NO      
C31844     MOVE I-CASH-LOC-OFFICE            TO Y2-CASH-LOCAL-OFFICE    
C31844     PERFORM 7110-GET-USER-ID  THRU 7110-EXIT                     
                                                                        
C31844     IF DRAFT-NOT-FOUND                                           
C31844        GO TO 1100-EXIT                                           
C31844     END-IF                                                       
                                                                        
           MOVE I-ACCOUNT-NO                 TO WS-ACCOUNT-NO           
           MOVE WS-ACCOUNT-NO-NUM            TO WS-ACCOUNT-NO-COMP3     
           MOVE WS-ACCOUNT-NO-COMP3          TO AT-ACCOUNT-NO           
                                                                        
           IF I-ACCOUNT-NO NOT NUMERIC                                  
              SET ACCOUNT-NOT-NUMERIC TO TRUE                           
              GO TO 1100-EXIT                                           
           END-IF                                                       
                                                                        
      * REJECT PAYMENT IF ACCOUNT NOT FOUND OR ACCOUNT IS INACTIVE      10840000
           PERFORM 7080-VALIDATE-ACCOUNT     THRU 7080-EXIT             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF AT-CODE-ACCT-STAT = WS-J                               
                 SET ACCOUNT-INACTIVE TO TRUE                           
                 GO TO 1100-EXIT                                        
              END-IF                                                    
                                                                        
              EVALUATE I-COMPANY-NO                                     
                WHEN 'SCEG'                                             
                  MOVE '01'        TO WS-COMPANY-NO                     
                WHEN 'PSNC'                                             
                  MOVE '26'        TO WS-COMPANY-NO                     
                WHEN 'SEB'                                              
                  MOVE '01'        TO WS-COMPANY-NO                     
              END-EVALUATE                                              
                                                                        
              IF WS-COMPANY-NO NOT = AT-COMPANY-NO                      
                 MOVE AT-COMPANY-NO TO WS-COMPANY-NO                    
              END-IF                                                    
           ELSE                                                         
              MOVE AT-ACCOUNT-NO TO XR-OLD-ACCOUNT-NO                   
              PERFORM 7090-GET-NEW-ACCOUNT   THRU 7090-EXIT             
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                 WHEN SUCCESSFUL-CALL                                   
                    MOVE XR-NEW-ACCOUNT-NO      TO AT-ACCOUNT-NO        
                    PERFORM 7080-VALIDATE-ACCOUNT  THRU 7080-EXIT       
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                                                                        
                       IF AT-CODE-ACCT-STAT = WS-J                      
                          SET ACCOUNT-INACTIVE  TO TRUE                 
                          GO TO 1100-EXIT                               
                       END-IF                                           
                                                                        
                       IF WS-COMPANY-NO NOT = AT-COMPANY-NO             
                          MOVE AT-COMPANY-NO    TO WS-COMPANY-NO        
                       END-IF                                           
                    ELSE                                                
                       SET ACCOUNT-NOT-FOUND    TO TRUE                 
                       GO TO 1100-EXIT                                  
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                    SET ACCOUNT-NOT-FOUND       TO TRUE                 
                    GO TO 1100-EXIT                                     
                                                                        
      * NOTES:- IF THIS GIVES PROBLEMS IN THE FUTURE IT NEEDS TO        11290000
      *  BE COMMENTED AS PER BARBARA REESE AND DENA ROSE   - BASKAR.    11300000
                                                                        
                 WHEN MULTIPLE-ROWS-SELECTED                            
                    SET MULTIPLE-OLD-ACCOUNT    TO TRUE                 
C29529              GO TO 1100-EXIT                                     
              END-EVALUATE                                              
           END-IF                                                       
P00526*                                                                 11361000
P00526     MOVE I-ACCOUNT-NO                    TO PC-ACCOUNT-NO        
P00526     MOVE WS-PYMT-AMOUNT                  TO PC-PAYMENT-AMT       
P00526     IF (JT-APPL-PROGRAM-ID = PROGRAM-NAME OR WS-PCSCA362) AND    
P00526                              (I-PYMT-FACILITY-CD = 'K')          
P00526        PERFORM 7350-VALIDATE-AUTOCARD-PMT   THRU 7350-EXIT       
P00526        IF DRAFT-NOT-FOUND                                        
P00526           GO TO 1100-EXIT                                        
P00526        END-IF                                                    
P00526     END-IF                                                       
                                                                        
           PERFORM 1200-GET-COMMON-DATE      THRU 1200-EXIT             
                                                                        
      * CHECK WHETHER REPORT DATE IS A BUSINESS DATE AND SELECT         11400000
      * NEXT BUSINESS DATE IF REPORT DATE IS NOT A BUSINESS DATE        11410000
           PERFORM 7180-GET-PREV-DATE        THRU 7180-EXIT             
           MOVE WS-PREV-DATE                 TO WS-NEW-BUSINESS-DAY     
           MOVE WS-NO                        TO WS-NEXT-BUSINESS-DAY    
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
              THRU 6500-NEXT-BUSINESS-DAY-EXIT                          
             UNTIL NEXT-BUSINESS-DAY-FOUND                              
           MOVE WS-NEW-BUSINESS-DAY          TO WS-REPORT-DATE          
                                                                        
      * IF CSR03413 IS CALLED FROM PCSCA362, 'PCSCA362' IS PASSED       11500000
      * AS THE I-APPL-PGM-ID.  FOR THE VALIDATION TESTS, WE ARE         11510000
      * CONCERNED ABOUT THE ORIGINAL APPL-PGM-ID (EPAY OR BILL MATRIX). 11520000
      * SO WE WILL USE THE VALUE IN JT-APPL-PROGRAM-ID (THIS VALUE IS   11530000
      * ALWAYS POPULATED WITH THE ORIGINAL CALLING PROGRAM.             11540000
C29529     MOVE JT-APPL-PROGRAM-ID TO WS-APPL-PGM-ID                    
                                                                        
C31844*    IF WS-APPL-PGM-ID NOT = WS-EPAY-APPL-ID                      11570000
C31844     IF WS-APPL-PGM-ID = PROGRAM-NAME                             
              MOVE WS-COMPANY-NO                TO C8-COMPANY-NO        
              MOVE WS-BM-DATE-RANGE             TO C8-DELINQ-CD         
              PERFORM 7070-GET-DELINQ-VALUE     THRU 7070-EXIT          
              MOVE C8-DELINQ-VALUE              TO WS-DELINQ-VAL        
                                                                        
              MOVE WS-INPUT-DATE                TO WS-NEW-BUSINESS-DAY  
              MOVE WS-NO                        TO WS-NEXT-BUSINESS-DAY 
              MOVE SPACES                       TO WS-HOLIDAY-EXISTS    
                                                                        
      * CHECK WHETHER REPORT DATE IS WITHIN THE ALLOWED LIMIT           11680000
              PERFORM WS-DELINQ-VAL TIMES                               
                 PERFORM 6500-GET-NEXT-BUSINESS-DAY                     
                    THRU 6500-NEXT-BUSINESS-DAY-EXIT                    
                   UNTIL NEXT-BUSINESS-DAY-FOUND                        
                 MOVE WS-NO                     TO WS-NEXT-BUSINESS-DAY 
              END-PERFORM                                               
                                                                        
              MOVE WS-INPUT-DATE                TO WS-OLD-BUSINESS-DAY  
              MOVE WS-NO                        TO WS-PREV-BUSINESS-DAY 
              MOVE SPACES                       TO WS-HOLIDAY-EXISTS    
                                                                        
              PERFORM WS-DELINQ-VAL TIMES                               
                 PERFORM 1300-GET-PREV-BUSINESS-DAY THRU 1300-EXIT      
                   UNTIL PREV-BUSINESS-DAY-FOUND                        
                 MOVE WS-NO                     TO WS-PREV-BUSINESS-DAY 
              END-PERFORM                                               
                                                                        
              IF WS-REPORT-DATE < WS-OLD-BUSINESS-DAY OR                
                 WS-REPORT-DATE > WS-NEW-BUSINESS-DAY                   
                 SET REPORT-DATE-ERROR          TO TRUE                 
                 GO TO 1100-EXIT                                        
              END-IF                                                    
C29529     END-IF                                                       
                                                                        
C31844     EVALUATE JT-APPL-PROGRAM-ID                                  
C31844       WHEN PROGRAM-NAME                                          
C31844         MOVE 'CURRENCY_TYPE'          TO WS-CV-COLUMN-NAME       
C31844       WHEN WS-EPAY-APPL-ID                                       
C31844         MOVE 'CURRENCY_TYPE_EPAY'     TO WS-CV-COLUMN-NAME       
C31844       WHEN WS-APS-APPL-ID                                        
C31844       WHEN WS-APS-APPL-ID1                                       
C31844         MOVE 'CURRENCY_TYPE_APS'      TO WS-CV-COLUMN-NAME       
C31844     END-EVALUATE                                                 
                                                                        
LEF        MOVE 'CSS_PAYMENT_TRANS' TO WS-CV-TABLE-NAME.                
LEF        MOVE I-CURRENCY-TYPE TO WS-CV-CODE-VALUE.                    
LEF        MOVE WS-COMPANY-NO    TO WS-COMPANY-NO.                      
LEF        PERFORM 7190-VALIDATE-CURRENCY-TYPE THRU 7190-EXIT.          
                                                                        
      * VALIDATE PAYMENT AMOUNT                                         12080000
           MOVE WS-PYMT-AMOUNT               TO WS-AMOUNT-9             
           IF I-PAYMENT-AMOUNT NOT NUMERIC                              
              SET AMOUNT-NOT-NUMERIC         TO TRUE                    
              GO TO 1100-EXIT                                           
           END-IF                                                       
                                                                        
           IF WS-PYMT-AMOUNT <= 0                                       
              SET NEG-OR-ZERO-PYMT           TO TRUE                    
              GO TO 1100-EXIT                                           
           END-IF                                                       
                                                                        
      * CHECK WHETHER PAYMENT AMOUNT IS WITH IN THE MAX ALLOWED AMT     12200000
C31844      IF WS-APPL-PGM-ID = PROGRAM-NAME                            
              MOVE WS-COMPANY-NO                TO C8-COMPANY-NO        
              MOVE WS-BM-PYMT-MAX               TO C8-DELINQ-CD         
              PERFORM 7070-GET-DELINQ-VALUE     THRU 7070-EXIT          
A04174        COMPUTE WS-PYMT-MAX = C8-DELINQ-VALUE * WS-MULTIPLIER     
A04174        IF WS-PYMT-AMOUNT > WS-PYMT-MAX                           
                 SET PYMT-GT-MAX-AMT            TO TRUE                 
                 GO TO 1100-EXIT                                        
              END-IF                                                    
C29529      END-IF                                                      
                                                                        
C31844     IF JT-APPL-PROGRAM-ID = PROGRAM-NAME                         
C31844        MOVE JT-APPL-PROGRAM-ID        TO UV-PROGRAM-ID           
C31844     ELSE                                                         
C31844        MOVE JT-APPL-PROGRAM-ID        TO WS-APPL-PGM             
C31844        MOVE WS-APPL-PGM-2             TO UV-PROGRAM-ID           
C31844     END-IF                                                       
C31844     MOVE '01'                         TO UV-COMPANY-NO           
C31844     MOVE 17                           TO UV-TABLE-NA-LEN         
C31844     MOVE 'CSS_PAYMENT_TRANS'          TO UV-TABLE-NA-TEXT        
C31844     MOVE 16                           TO UV-COLUMN-NA-LEN        
C31844     MOVE 'PYMT_FACILITY_CD'           TO UV-COLUMN-NA-TEXT       
C31844     MOVE 1                            TO UV-CODE-VALUE-LEN       
C31844     MOVE I-PYMT-FACILITY-CD           TO UV-CODE-VALUE-TEXT      
C31844     PERFORM 7310-CHECK-CODE-VALUE     THRU 7310-EXIT             
C31844     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
C31844        SET PYMT-FACILITY-ERROR        TO TRUE                    
C31844        GO TO 1100-EXIT                                           
C31844     END-IF                                                       
C31844                                                                  
                                                                        
           IF I-DIR-PYMT-IND  = 'UND'                                   
              SET UNDIRECTED-PYMT           TO TRUE                     
           ELSE                                                         
              SET INVALID-DIR-PYMT-IND       TO TRUE                    
              IF ((I-APPL-PGM-ID      = WS-APS-APPL-ID) OR              
                  (JT-APPL-PROGRAM-ID = WS-APS-APPL-ID) OR              
                  (JT-APPL-PROGRAM-ID = WS-APS-APPL-ID1))               
                  AND I-DIR-PYMT-IND = 'DIR'                            
                  SET APS-DIR-PYMT-IND           TO TRUE                
C35843        ELSE                                                      
C35843           IF ((I-APPL-PGM-ID     = PROGRAM-NAME) OR              
C35843              (JT-APPL-PROGRAM-ID = PROGRAM-NAME))                
C35843              AND I-PYMT-FACILITY-CD = 'N'                        
C35843              AND I-DIR-PYMT-IND = 'DIR'                          
C35843              SET APS-DIR-PYMT-IND         TO TRUE                
C35843           END-IF                                                 
C35843        END-IF                                                    
              GO TO 1100-EXIT                                           
           END-IF                                                       
           .                                                            
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  12670000
      * SELECTS COMMON DATE FROM CSS_JOB_PARM TABLE                  *  12680000
      *---------------------------------------------------------------  12690000
                                                                        
       1200-GET-COMMON-DATE.                                            
                                                                        
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT                                            
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '            TO WS-PGRMNAME                 
              MOVE SPACES                TO WS-INPUT-AREA               
              MOVE SPACES                TO WS-INPUT-DATA-BREAKDOWN     
              PERFORM 6251-GET-FJC01-DATE                               
                 THRU 6251-EXIT                                         
              MOVE PROGRAM-NAME          TO WS-PGRMNAME                 
           END-IF                                                       
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  12880000
      * SELECTS THE PREVIOUS BUSINESS DATE FOR REPORT DATE VALIDATION*  12890000
      *---------------------------------------------------------------  12900000
                                                                        
       1300-GET-PREV-BUSINESS-DAY.                                      
                                                                        
           PERFORM 7100-GET-PREV-BUSINESS-DAY THRU 7100-EXIT            
                                                                        
      ***  CHECK TO SEE IF IT IS A WEEKEND...                           12960000
           IF WS-DAY-OF-WEEK NOT EQUAL WS-PREV-SATURDAY AND             
              WS-DAY-OF-WEEK NOT EQUAL WS-PREV-SUNDAY                   
                                                                        
              MOVE WS-OLD-BUSINESS-DAY       TO J8-HOLIDAY-DT           
              MOVE WS-NO                     TO WS-HOLIDAY-EXISTS       
                                                                        
      ***  ...IF NOT A WEEKEND, THEN CHECK TO SEE IF IT IS A HOLIDAY    13030000
              PERFORM 7150-CHECK-HOLIDAY     THRU 7150-EXIT             
              IF HOLIDAY-EXISTS-NO                                      
                  MOVE WS-YES                TO WS-PREV-BUSINESS-DAY    
              ELSE                                                      
                  MOVE WS-NO                 TO WS-PREV-BUSINESS-DAY    
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *---------------------------------------------------------------  13160000
      * CHECKS WHETHER AR LOCK OUT IS IN EFFECT, IF SO, IT RETURNS   *  13170000
      * AN ERROR. CALLS PAYMENT POSTING ROUTINE AND AFTER SUCCESSFUL *  13180000
      * POSTING IT UPDATES THE PAYMENT ROW IN CSS_PAYMENT_TRANS      *  13190000
      * TABLE AS POSTED.                                             *  13200000
      *--------------------------------------------------------------*  13210000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH                              
                                                                        
                                                                        
           PERFORM 2200-PROCESS THRU 2200-EXIT                          
                                                                        
           MOVE WS-YES                    TO JT-APPLIED-FL              
           MOVE WS-SYSTEM                 TO JT-LAST-UPDATE-USERID      
C30257     PERFORM 7120-SELECT-PAYMENT    THRU 7120-EXIT                
           PERFORM 8050-UPDATE-PYMT-TRANS THRU 8050-EXIT                
      * E-PAY PROCESSING                                                13330000
C29529     IF WS-APPL-PGM-ID = WS-EPAY-APPL-ID                          
C33486        PERFORM 8054-SELECT-PND-BNK-DRFT THRU 8054-EXIT           
C29529        PERFORM 8056-UPDATE-AR-TRANS     THRU 8056-EXIT           
C29529     END-IF.                                                      
P00526*                                                                 13360100
P00526* UPDATE PNDNG_CARD_PMT ON SUCCESSFUL AUTOCARD PYMT POSTING       13360200
P00526     IF (JT-APPL-PROGRAM-ID = PROGRAM-NAME OR WS-PCSCA362) AND    
P00526                              I-PYMT-FACILITY-CD = 'K'            
P00526        PERFORM 8150-UPDATE-PNDNG-CARD-PMT  THRU 8150-EXIT        
P00526     END-IF.                                                      
P00526*                                                                 13361000
A5203C* IF BBP SETUP THEN GET NEW TIMESTAMP FOR TRANS HIST KEY          13361000
A5203C     IF BBP-SETUP-YES AND WS-CODE-BUDGET = 'A'                    
A5203C       AND AT-EPP-OFFER-AMOUNT = 0                                
A5203C        PERFORM 6791A-GET-TIMESTAMP THRU 6791A-EXIT               
A5203C     END-IF.                                                      
A5203C*                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  13410000
      * CHECKS ACCOUNT IS A TRANSFERRED ACCOUNT, IF SO, IT SELECTS   *  13420000
      * THE TRANSFERRED TO ACCOUNT FOR POSTING. AFTER POSTING IT     *  13430000
      * CHECKS WHETHER ACCOUNT HAS AN ACTIVE DNP OR RECONNECT, IF SO,*  13440000
      * IT SETS THE RETURN CODE FOR THE CALLING PROGRAM TO CALL THE  *  13450000
      * RPC TO CANCEL THE DNP OR CHANGE THE RECONNECT ORDER TO       *  13460000
      * TURNED DOWN CUSTOMER.                                        *  13470000
      *--------------------------------------------------------------*  13480000
                                                                        
       2200-PROCESS.                                                    
                                                                        
           PERFORM 7999-SELECT-TRANSFER-IND                             
              THRU 7999-SELECT-TRANSFER-IND-EXIT                        
           IF AT-ACCT-XFER-TO > ZERO AND AT-AR-XFER-IND = WS-Y          
              MOVE SPACES                     TO WS-XFER-ACCT           
              PERFORM UNTIL WS-XFER-ACCT = WS-Y                         
                 MOVE AT-ACCOUNT-NO           TO WS-HOLD-ACCT-NUM       
                 MOVE AT-ACCT-XFER-TO         TO AT-ACCOUNT-NO          
                 PERFORM 7030-SELECT-AT-PR-CU THRU 7030-EXIT            
                 IF AT-MST-SUB-ACCT-IND = WS-M                          
                    SET SUB-ACCOUNT           TO TRUE                   
                 END-IF                                                 
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE WS-HOLD-ACCT-NUM     TO AT-ACCOUNT-NO          
                    PERFORM 7030-SELECT-AT-PR-CU THRU 7030-EXIT         
                    IF AT-MST-SUB-ACCT-IND = WS-S                       
                       SET SUB-ACCOUNT        TO TRUE                   
                    END-IF                                              
                    MOVE WS-Y TO WS-XFER-ACCT                           
                 ELSE                                                   
                    IF AT-ACCT-XFER-TO > ZEROS                          
                       CONTINUE                                         
                    ELSE                                                
                       MOVE WS-Y TO WS-XFER-ACCT                        
                    END-IF                                              
                 END-IF                                                 
              END-PERFORM                                               
A37666        IF NOT SUB-ACCOUNT                                        
A37666           MOVE WS-HOLD-ACCT-NUM TO WS-XFER-ACCT-NUM              
A37666        END-IF                                                    
           ELSE                                                         
              PERFORM 7030-SELECT-AT-PR-CU THRU 7030-EXIT               
              IF AT-MST-SUB-ACCT-IND = WS-S                             
                 SET SUB-ACCOUNT        TO TRUE                         
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT     
A5203C*                                                                         
A5203C     IF WS-CODE-BUDGET NOT = 'A' AND AT-EPP-OFFER-AMOUNT > 0      
A5203C        MOVE 'Y' TO WS-BBP-SETUP                                  
A5203C     ELSE                                                         
A5203C        MOVE 'N' TO WS-BBP-SETUP                                  
A5203C     END-IF.                                                      
                                                                        
           EVALUATE WS-CURRENCY-TYPE                                    
              WHEN 'C'                                                  
                 MOVE WS-PYMT-AMOUNT       TO WS-AMT-CHECK              
              WHEN 'H'                                                  
                 MOVE WS-PYMT-AMOUNT       TO WS-AMT-CREDIT-CARD        
APS           WHEN 'M'                                                  
APS              MOVE WS-PYMT-AMOUNT       TO WS-AMT-MONEY-ORDER        
APS           WHEN 'A'                                                  
APS              MOVE WS-PYMT-AMOUNT       TO WS-AMT-CASH               
           END-EVALUATE                                                 
                                                                        
C35818     MOVE WS-NO                      TO S-CANCEL-DNP-FLAG         
C35818     MOVE AT-ACCOUNT-NO              TO DL-ACCOUNT-NO             
                                                                        
           MOVE WS-PYMT-AMOUNT             TO WS-PAYMENT-AMOUNT         
                                              WS-PAYMENT-AMOUNT-TOTAL   
                                                                        
           PERFORM 7060-SELECT-CASH-CNTRL  THRU 7060-EXIT               
                                                                        
      *   GET G/L ACCOUNT NUMBER                                        14040000
                                                                        
           PERFORM 2205-LOAD-GL-NUMBERS    THRU 2205-EXIT               
                                                                        
      * DEBIT CASH                                                      14080000
                                                                        
            MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB    
                                                                        
      * LOAD PAYMENT PRIORITY TABLE FOR UNDIRECTED PAYMENT              14120000
                                                                        
           IF UNDIRECTED-PYMT                                           
              MOVE WS-U                    TO WS-PAR-UPDATE-TYPE        
           END-IF                                                       
           PERFORM 2210-LOAD-PYMT-PRIORITY THRU 2210-EXIT               
                                                                        
           PERFORM 5000-UPDATE THRU 5000-EXIT                           
                                                                        
      * IF THIS STORED PROCEDURE GIVES PERFORMANCE PROBLEM THEN BELOW   14210000
      * TWO LINES CAN BE MOVED TO THE PROGRAM WHERE ALL THIRD PARTY     14220000
      * BATCHES ARE CLOSED - BASKAR.                                    14230000
                                                                        
C31844*    IF Y2-PAYMENT-AGENT-FL = 'Y'                                 14250000
              PERFORM 2600-THIRD-PARTY-JRNL       THRU 2600-EXIT        
              PERFORM 2700-PROCESS-OVSH           THRU 2700-EXIT        
C31844*    END-IF                                                       14280000
                                                                        
           PERFORM 2900-PROCESS-BILLED-BALANCE THRU 2900-EXIT           
                                                                        
           IF AT-BANKRUPTCY-IND = WS-B                                  
              PERFORM 2550-BANKRUPT-WORK-QUEUE THRU 2550-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  14630000
      * LOADS ALL G/L NUMBER, INCLUDEING CHARGED OFF                 *  14640000
      *--------------------------------------------------------------*  14650000
                                                                        
       2205-LOAD-GL-NUMBERS.                                            
                                                                        
           MOVE PROGRAM-NAME               TO WS-CPD00061-CALLING-PGM   
           MOVE SPACES                     TO ABEND-FUNCTION            
           PERFORM 9400-CALL-CPD00061      THRU 9400-EXIT               
           .                                                            
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  14760000
      * LOAD THE PAYMENT PRIORITY TABLE                              *  14770000
      * I-DIR-PYMT-IND IS 'UND' FOR UNDIRECTED PAYMENT               *  14780000
      *--------------------------------------------------------------*  14790000
                                                                        
       2210-LOAD-PYMT-PRIORITY.                                         
                                                                        
           IF UNDIRECTED-PYMT                                           
              MOVE 1 TO C9-PMT-PRTY-SCHEDULE                            
           END-IF                                                       
                                                                        
           PERFORM 6722B-OPEN-AR-PMT-PRTY  THRU 6722B-EXIT              
           PERFORM 6722C-FETCH-AR-PMT-PRTY THRU 6722C-EXIT              
           PERFORM 6722D-LOAD-AR-PMT-PRTY  THRU 6722D-EXIT              
              VARYING WS-PAR-SUB FROM 1 BY 1                            
              UNTIL WS-PAR-SUB GREATER THAN 52                          
              OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
           PERFORM 6722E-CLOSE-AR-PMT-PRTY THRU 6722E-EXIT              
           .                                                            
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  14980000
      * MOVE VALUES TO 101 JOURNAL VARIABLES                         *  14990000
      *--------------------------------------------------------------*  15000000
                                                                        
       2300-MOVE-TRAN-DATA-VALUES.                                      
                                                                        
           MOVE 101                      TO WS-101-JRNL-FORMAT-NO       
           MOVE WS-PYMT-AMOUNT           TO WS-101-AMOUNT-ENTERED       
           MOVE SPACES                   TO WS-101-AR-AGE               
                                            WS-101-CASH-DRAWER-USED     
                                            WS-101-DATE-AR-BILLED       
                                            WS-101-FCS-DEP-BANK-CD      
                                            WS-101-FCS-DEP-BANK-ST-CD   
                                            WS-101-FUNCTION-CODE        
                                            WS-101-CODE-REVENUE-DISTRICT
                                            WS-101-CODE-EMPL-ACCT       
                                            WS-101-CODE-COMPANY-ACCT    
                                            WS-101-CODE-ACCOUNT-STATUS  
                                            WS-101-CODE-PREMISE-STATUS  
           MOVE ZERO                     TO WS-101-ITEM-DETAIL-DATA     
                                            WS-101-ITEM-ID-NO           
                                            WS-101-DETAIL-END-BAL       
                                            WS-101-DETAIL-END-AR-BAL    
                                            WS-101-ACCT-END-AR-BAL      
                                            WS-101-REVENUE-MONTH        
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  15270000
      * MOVE VALUES TO PAYMENT TABLE                                 *  15280000
      *--------------------------------------------------------------*  15290000
                                                                        
       2400-POPULATE-PYMT-TABLE.                                        
                                                                        
C29529     INITIALIZE DCLCSS-PAYMENT-TRANS                              
                                                                        
           MOVE I-REPORT-DATE       TO JT-DATE-CASH-REPORT              
           MOVE I-CASH-LOC-OFFICE   TO JT-CASH-LOCAL-OFFICE             
           MOVE I-TIMESTAMP         TO JT-PYMT-RCVD-TS                  
           MOVE I-APPL-PGM-ID       TO JT-APPL-PROGRAM-ID               
           MOVE SPACES              TO JT-APPLIED-FL                    
           MOVE I-CURRENCY-TYPE     TO JT-CURRENCY-TYPE                 
           MOVE I-CUST-PHONE-NO     TO JT-CUST-PHONE-NO                 
           MOVE I-DIR-PYMT-IND      TO JT-DIRECTED-PYMT-CD              
           MOVE SPACES              TO JT-ERROR-CD                      
           MOVE I-CONFIRMATION-NO   TO JT-PYMT-CONFIRM-NO               
           MOVE I-PYMT-FACILITY-CD  TO JT-PYMT-FACILITY-CD              
           MOVE WS-SYSTEM           TO JT-LAST-UPDATE-USERID            
                                                                        
           IF I-PAYMENT-AMOUNT NUMERIC                                  
              MOVE WS-PYMT-AMOUNT   TO JT-PAYMENT-AMT                   
           ELSE                                                         
              MOVE ZERO             TO JT-PAYMENT-AMT                   
           END-IF                                                       
                                                                        
           IF I-ACCOUNT-NO NUMERIC                                      
              MOVE I-ACCOUNT-NO     TO JT-ACCOUNT-NO                    
           ELSE                                                         
              MOVE ZERO             TO JT-ACCOUNT-NO                    
           END-IF                                                       
                                                                        
           EVALUATE I-COMPANY-NO                                        
             WHEN 'SCEG'                                                
               MOVE '01'            TO JT-COMPANY-NO                    
             WHEN 'PSNC'                                                
               MOVE '26'            TO JT-COMPANY-NO                    
             WHEN 'SEB'                                                 
               MOVE '01'            TO JT-COMPANY-NO                    
C31844       WHEN OTHER                                                 
C31844         MOVE I-COMPANY-NO    TO JT-COMPANY-NO                    
           END-EVALUATE                                                 
                                                                        
APS        IF   I-CASH-LOC-OFFICE = '028' OR '029'                      
APS         NEXT SENTENCE                                               
APS        ELSE                                                         
            EVALUATE I-CURRENCY-TYPE                                    
              WHEN 'V'                                                  
              WHEN 'M'                                                  
              WHEN 'D'                                                  
              WHEN 'S'                                                  
              WHEN 'P'                                                  
C35842        WHEN 'X'                                                  
C35842        WHEN 'E'                                                  
C35842        WHEN 'N'                                                  
C35842        WHEN 'G'                                                  
                 MOVE I-CURRENCY-TYPE TO JT-CREDIT-CARD-TYPE            
                 MOVE WS-H          TO JT-CURRENCY-TYPE                 
              WHEN OTHER                                                
                 MOVE SPACES        TO JT-CREDIT-CARD-TYPE              
            END-EVALUATE                                                
APS        END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  16390000
      * SEND A WORK QUEUE TO ALERT SOMEONE THAT THE PAYMENT IS MADE  *  16400000
      * ON A BANKRUPT ACCOUNT.                                       *  16410000
      *--------------------------------------------------------------*  16420000
       2550-BANKRUPT-WORK-QUEUE.                                        
                                                                        
act095     INITIALIZE CWS00077-FIELDS.                                  
ACT095     MOVE AT-ACCOUNT-NO         TO WS-77-ACCOUNT-NO               
ACT095     MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO              
ACT095     MOVE AT-PREMISE-NO         TO WS-77-PREMISE-NO               
ACT095     MOVE ZERO                  TO WS-77-SERV-ORDER-NO            
ACT095     MOVE AT-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE             
ACT095     MOVE WS-BANKRUPT-CAT-ID    TO WS-77-CATEGORY-ID              
ACT095     MOVE SPACES                TO WS-77-RESP-AREA-ID             
ACT095     MOVE WS-HIGH-PRIORITY      TO WS-77-PRIORITY                 
ACT095     MOVE WS-4                  TO WS-77-ROUTE-CATEGORY           
ACT095     MOVE WS-SYSTEM             TO WS-77-USER-ID-ORIG             
ACT095     MOVE ZERO                  TO WS-77-FREE-FORM-LEN            
ACT095     MOVE SPACES                TO WS-77-FREE-FORM-TXT            
           MOVE WS-PYMT-AMOUNT        TO WS-BANKRUPT-WQ-AMT             
           MOVE WS-BANKRUPT-WQ-AMT    TO WS-BANKRUPT-WQ-AMT-DISP        
ACT095     MOVE +102                  TO WS-77-COMMENTS-LEN             
ACT095     MOVE WS-BANKRUPT-WQ-MSG    TO WS-77-COMMENTS-TEXT            
ACT095     MOVE PROGRAM-NAME          TO WS-77-CREATED-BY               
                                                                        
           MOVE WS-CURRENT-DATE       TO WS-CCD-START-DATE              
           MOVE WS-A                  TO WS-CCD-ADD-DAYS                
           MOVE WS-A                  TO WS-CCD-PLUS-MINUS              
           MOVE +1                    TO WS-CCD-DAYS-PLUS-MINUS         
           PERFORM 6600-COMPUTE-CALENDAR-DATE                           
              THRU 6600-COMPUTE-DATE-EXIT                               
           PERFORM 7700-SQL-CODE-CHECK THRU 7700-EXIT                   
                                                                        
ACT095     MOVE WS-CCD-NEW-DATE       TO WS-77-DATE-REQUIRED            
ACT095     MOVE WS-CURRENT-DATE       TO WS-77-DATE-CREATED             
           PERFORM 6797E-INSERT-WORK-QUEUE THRU 6797E-EXIT              
           .                                                            
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  16780000
      *  MOVE THE MONEY FROM CASH TO THIRD PARTY RECEIVABLE          *  16790000
      *--------------------------------------------------------------*  16800000
                                                                        
       2600-THIRD-PARTY-JRNL.                                           
                                                                        
           MOVE WS-JRNL-VALIDATE-OPER       TO WS-JRNL-OPERATION-RQST   
           MOVE WS-C                        TO WS-JRNL-SOURCE-CODE      
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE      TO WS-JRNL-OL-AUTH-TYPE     
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE  TO WS-JRNL-OL-AUTH-TYPE     
           END-IF                                                       
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
                                                                        
           MOVE WS-A                  TO WS-100-JRNL-SORT-ID            
           MOVE ZEROES                TO WS-100-ACCT-NO                 
           MOVE ZEROES                TO WS-100-CUSTOMER-NO             
           MOVE ZEROES                TO WS-100-PREMISE-NO              
           ADD 1                      TO WS-100-JRNL-TRAN-APPL-NO       
           MOVE WS-CURRENT-DATE       TO WS-100-DATE-LAST-ACTION        
           MOVE WS-C                  TO WS-100-CODE-ENTRY-SOURCE       
           MOVE Y2-LOCAL-OFFICE       TO WS-100-LOCAL-OFFICE-CD         
           MOVE WS-JRNL-OL-COMPANY    TO WS-PAR-COMPANY-NO              
           MOVE WS-JRNL-OL-LOC-OFF    TO WS-PAR-LOCAL-OFFICE            
           MOVE WS-JRNL-OL-REPORT-NO  TO WS-PAR-REPORT-NO               
           MOVE WS-JRNL-OL-REPORT-DT  TO WS-PAR-REPORT-DATE             
           MOVE WS-JRNL-OL-CASH-DRWR  TO WS-PAR-CASH-DRAWER             
           MOVE WS-TERM-LOC           TO WS-PAR-ACCESS-LOC              
           MOVE WS-SYSTEM             TO WS-PAR-OPERATOR-ID             
           MOVE WS-TRAN-COMMENT-LEN   TO WS-JRNL-TRAN-COMMENT-LEN       
           MOVE WS-TRAN-COMMENT-TEXT  TO WS-JRNL-TRAN-COMMENT-TEXT      
                                                                        
           INITIALIZE CJF00101                                          
                                                                        
           MOVE WS-CURRENCY-TYPE      TO WS-JRNL-CURRENCY-TYPE          
           MOVE WS-PYMT-AMOUNT        TO WS-101-AMT-POSTED              
                                         WS-PAYMENT-AMOUNT              
                                                                        
           PERFORM 2300-MOVE-TRAN-DATA-VALUES                           
              THRU 2300-EXIT                                            
                                                                        
           MOVE Y2-DEP-CASH-GL-OFFSET TO WS-101-ACCT-GEN-LED-DR         
           MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB)                           
                                      TO WS-101-ACCT-GEN-LED-CR         
                                                                        
           MOVE WS-JRNL-NAME          TO WS-100-CODE-TERMINAL-TRAN      
                                                                        
           MOVE CJF00101              TO WS-100-USER-DEFINED-AREA       
           MOVE WS-JRNL-ONLY          TO WS-JRNL-OPERATION-RQST         
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
              THRU 6400-EXIT                                            
           MOVE WS-JRNL-CNTRL-ONLY    TO WS-JRNL-OPERATION-RQST         
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
              THRU 6400-EXIT                                            
           .                                                            
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  17390000
      * INSERT/UPDATE OVERSHORT AMOUNT FOR THE PAYMENT               *  17400000
      *--------------------------------------------------------------*  17410000
                                                                        
       2700-PROCESS-OVSH.                                               
                                                                        
           MOVE CS-CASH-COMPANY-NO            TO OH-CASH-COMPANY-NO     
           MOVE CS-CASH-LOCAL-OFFICE          TO OH-CASH-LOCAL-OFFICE   
           MOVE CS-DATE-CASH-REPORT           TO OH-DATE-CASH-REPORT    
           MOVE CS-CASH-DRAWER-ID             TO OH-CASH-DRAWER-ID      
           MOVE 1                             TO OH-OVERSHORT-ID        
           PERFORM 7240-SELECT-OVSH           THRU 7240-EXIT            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
APS           IF OH-OVERSHORT-DR-CR = 'C'                               
APS              COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT -          
APS                                         WS-PYMT-AMOUNT              
APS              IF OH-OVERSHORT-AMT > 0                                
APS                 MOVE 'C'                 TO OH-OVERSHORT-DR-CR      
APS              ELSE                                                   
APS                 MOVE 'D'                 TO OH-OVERSHORT-DR-CR      
APS                 COMPUTE OH-OVERSHORT-AMT = (OH-OVERSHORT-AMT * -1)  
APS              END-IF                                                 
APS           ELSE                                                      
APS              COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT +          
APS                                         WS-PYMT-AMOUNT              
APS              MOVE 'D'                 TO OH-OVERSHORT-DR-CR         
APS           END-IF                                                    
              PERFORM 8080-UPDATE-OVERSHORT   THRU 8080-EXIT            
           ELSE                                                         
              PERFORM 2800-MOVE-DTL-TO-OVSH   THRU 2800-EXIT            
              PERFORM 8070-INSERT-OVERSHORT   THRU 8070-EXIT            
           END-IF                                                       
           .                                                            
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  17750000
      * MOVE DETAILS TO OVERSHORT                                    *  17760000
      *--------------------------------------------------------------*  17770000
                                                                        
       2800-MOVE-DTL-TO-OVSH.                                           
                                                                        
           MOVE WS-SYSTEM                     TO OH-USER-ID             
           MOVE WS-COMMENT-LEN                TO OH-TRAN-COMMENT-LEN    
           MOVE WS-COMMENT-TEXT               TO OH-TRAN-COMMENT-TEXT   
           MOVE WS-P                          TO OH-OVERSHORT-SOLTN-FL  
           MOVE WS-PYMT-AMOUNT                TO OH-OVERSHORT-AMT       
           MOVE WS-D                          TO OH-OVERSHORT-DR-CR     
                                                                        
           MOVE Y2-DEP-CASH-GL-OFFSET         TO OH-GL-ACCT-NO          
                                                 OT-GL-ACCT-NO          
                                                 WS-DISP-GL-ACCT        
                                                                        
           PERFORM 7210-OPEN-OVSH-TYPE        THRU 7210-EXIT            
           PERFORM 7220-FETCH-OVSH-TYPE       THRU 7220-EXIT            
           PERFORM 7230-CLOSE-OVSH-TYPE       THRU 7230-EXIT            
           MOVE OT-OVERSHORT-TYPE-CD          TO OH-OVERSHORT-TYPE-CD   
                                                                        
           MOVE 1                             TO OH-OVERSHORT-ID        
           MOVE ZERO                          TO OH-OFST-OVERSHORT-AMT  
                                                 OH-ACCOUNT-NO          
           MOVE SPACES                        TO OH-OFST-DR-CR          
           .                                                            
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  18050000
      * GET THE BILLED BALANCE AMOUNT                                *  18060000
      *--------------------------------------------------------------*  18070000
                                                                        
       2900-PROCESS-BILLED-BALANCE.                                     
                                                                        
           PERFORM 7290-SELECT-REV-MON      THRU 7290-EXIT              
           MOVE G6-PARM-DATA                TO WS-PARM-DATA             
           MOVE WS-PARM-REV-YY              TO WS-REV-YY                
           MOVE WS-PARM-REV-MM              TO WS-REV-MM                
           MOVE WS-PARM-REVMNTH             TO WS-REV-MTH-NUM           
           MOVE WS-REV-MTH-NUM              TO WS-REV-MTH-UPPER-LIMIT   
           MOVE WS-REV-DATE                 TO WS-REV-DATE1             
           PERFORM 7295-SUBTRACT-2-MONTH    THRU 7295-EXIT              
           MOVE WS-REV-DATE1                TO WS-REV-DATE              
           MOVE WS-REV-YY                   TO WS-PARM-REV-YY           
           MOVE WS-REV-MM                   TO WS-PARM-REV-MM           
           MOVE WS-PARM-REVMNTH             TO WS-REV-MTH-NUM           
           MOVE WS-REV-MTH-NUM              TO WS-REV-MTH-LOWER-LIMIT   
                                                                        
           PERFORM 7260-SELECT-BILLEXECP-WQ THRU 7260-EXIT              
           PERFORM 7270-SELECT-CANCEL-REBIL THRU 7270-EXIT              
           PERFORM 7280-SELECT-CUST-STAT    THRU 7280-EXIT              
                                                                        
           IF SUB-ACCOUNT                   OR                          
              AT-CODE-ACCT-STAT   = WS-P    OR                          
             (AT-CODE-ACCT-STAT   = WS-B    AND                         
              AT-ACCT-FINALED-DT  = SPACES) OR                          
              AT-BANKRUPTCY-IND   = WS-B    OR                          
              WQ-EXISTS                     OR                          
              CAN-REBILL-EXISTS             OR                          
              PASSWORD-EXISTS                                           
              MOVE SPACES                   TO S-BILLED-BALANCE         
           ELSE                                                         
              PERFORM 7050-DETERMINE-TOTAL-CO-AMT THRU 7050-EXIT        
              IF WS-NULL-IND-7 < 0                                      
                 MOVE ZERO                  TO WS-TOTAL-CHRG-OFF        
              END-IF                                                    
                                                                        
              COMPUTE WS-BILL-BAL        = AT-TOTAL-AR-BALANCE +        
                                           WS-TOTAL-CHRG-OFF            
              MOVE WS-BILL-BAL              TO WS-BILL-BAL-NUM          
              MOVE WS-BILL-BAL-NUM          TO WS-BILL-BAL-EDIT         
              MOVE WS-BILL-BAL-CHAR         TO S-BILLED-BALANCE         
           END-IF                                                       
           .                                                            
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
C35842*--------------------------------------------------------------*  18530100
ACT285* CALLS SUB PROGRAMS MCS03414 TO HANDLE DNP/RECONNECT REAL TIME*  18530200
C35842*--------------------------------------------------------------*  18530300
C35842 2950-PROCESS-DNP-RECONNECT.                                      
C35842                                                                  
C35842     MOVE 0                           TO WS-DNP-RET-CODE          
P00420     INITIALIZE ABEND-FILE                                        
C35842                                                                  
ACT285* Populate WS variable to call CPD03414                                   
ACT285     MOVE AT-ACCOUNT-NO               TO WS-ACCOUNT-NO-NUM        
ACT285     MOVE 'P'                         TO WS-UPDATE-ACTION-FL      
ACT285     MOVE 'O'                         TO WS-CALL-TYPE             
ACT285     MOVE 'Y'                         TO WS-CPD68-REQUIRED        
ACT285     MOVE PROGRAM-NAME                TO WS-PROGRAM-NAME          
ACT285     MOVE I-APPL-PGM-ID               TO WS-APPL-PROGRAM-ID       
P00948     MOVE 'Y'                         TO WS-CNCL-DNP-EMAIL-REQ-FL 
ACT285     PERFORM 9800-CALL-MCS03414       THRU 9800-EXIT              
C35842                                                                  
C35842     MOVE WS-DNP-RET-CODE             TO S-RETURN-CODE            
C35842     .                                                            
C35842 2950-EXIT.                                                       
C35842     EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  18540000
      * POSTS PAYMENT TO CIS                                         *  18550000
      *--------------------------------------------------------------*  18560000
                                                                        
       5000-UPDATE.                                                     
           MOVE '5000'                      TO ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-JRNL-NAME                TO WS-PAR-EIBTRNID          
           MOVE I-PYMT-FACILITY-CD          TO WS-PAR-PYMT-FACILITY-CD  
           MOVE AT-COMPANY-NO               TO WS-100-COMPANY-NO        
           MOVE 9                           TO WS-TRAN-OPER-LEVEL       
           MOVE 1                           TO WS-TRAN-OCAP-FIELD       
           MOVE 1                           TO WS-TRAN-OCAP-VALUE       
           MOVE WS-C                        TO WS-TRAN-JRNL-TYPE        
           MOVE WS-N                        TO WS-TRAN-HOLD-EXEMPT-FLAG 
                                                                        
           MOVE WS-SYSTEM                   TO WS-JRNL-OL-TEMP-ID       
           MOVE WS-JRNL-CK-OPER-ID          TO WS-JRNL-OPERATION-RQST   
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
           MOVE WS-JRNL-OL-OPR-LOC          TO WS-TERM-LOC              
                                                                        
           MOVE WS-01                       TO WS-JRNL-OL-COMPANY       
           MOVE I-CASH-LOC-OFFICE           TO WS-JRNL-OL-LOC-OFF       
                                               WS-JRNL-OL-REPORT-NO     
           MOVE WS-REPORT-DATE              TO WS-JRNL-OL-REPORT-DT     
           MOVE CS-CASH-DRAWER-ID           TO WS-JRNL-OL-CASH-DRWR     
           MOVE SPACES                      TO WS-JRNL-OL-CSR-PC-ID     
                                                                        
           MOVE WS-TERM-LOC                 TO WS-JRNL-OL-TERM-LOC      
                                               WS-JRNL-OL-CASH-LOC      
                                               WS-JRNL-OL-OPR-LOC       
           MOVE WS-JRNL-VALIDATE-OPER       TO WS-JRNL-OPERATION-RQST   
           MOVE WS-C                        TO WS-JRNL-SOURCE-CODE      
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE      TO WS-JRNL-OL-AUTH-TYPE     
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE  TO WS-JRNL-OL-AUTH-TYPE     
           END-IF                                                       
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
                                                                        
           MOVE WS-A                        TO WS-100-JRNL-SORT-ID      
           MOVE AT-ACCOUNT-NO               TO WS-100-ACCT-NO           
           MOVE AT-CUSTOMER-NO              TO WS-100-CUSTOMER-NO       
           MOVE AT-PREMISE-NO               TO WS-100-PREMISE-NO        
                                                                        
           MOVE WS-JRNL-NAME                TO WS-100-CODE-TERMINAL-TRAN
           ADD 1                            TO WS-100-JRNL-TRAN-APPL-NO 
           MOVE WS-CURRENT-DATE             TO WS-100-DATE-LAST-ACTION  
                                               AT-DATE-LAST-ACTION      
           MOVE WS-C                        TO WS-100-CODE-ENTRY-SOURCE 
           MOVE AT-LOCAL-OFFICE             TO WS-100-LOCAL-OFFICE-CD   
                                                                        
           MOVE WS-JRNL-OL-COMPANY          TO WS-PAR-COMPANY-NO        
           MOVE WS-JRNL-OL-LOC-OFF          TO WS-PAR-LOCAL-OFFICE      
           MOVE WS-JRNL-OL-REPORT-NO        TO WS-PAR-REPORT-NO         
           MOVE WS-JRNL-OL-REPORT-DT        TO WS-PAR-REPORT-DATE       
           MOVE WS-JRNL-OL-CASH-DRWR        TO WS-PAR-CASH-DRAWER       
                                                                        
           MOVE WS-TERM-LOC                 TO WS-PAR-ACCESS-LOC        
           MOVE WS-SYSTEM                   TO WS-PAR-OPERATOR-ID       
C35842     MOVE '998'                       TO WS-PAR-RESP-AREA,        
C35842                                         PF-RESP-AREA-ID          
           MOVE I-APPL-PGM-ID               TO WS-PAR-APPL-PROG-ID      
           MOVE I-PYMT-FACILITY-CD          TO WS-PAR-PYMT-FACILITY-CD  
           MOVE WS-NO                       TO WS-PAR-PYMT-RCPT-PRNTD-CD
C35842*                                                                 19121000
A37666     MOVE +0 TO WS-PAR-AR-TRAN-COMMENT-LEN.                       
A37666     MOVE SPACES TO WS-CC-TRAN-COMMENT                            
A37666                    WS-XFER-ACCT-COMMENT                          
A37666                    WS-PAR-AR-TRAN-COMMENT-TEXT.                  
A37666                                                                  
C35842     IF JT-APPL-PROGRAM-ID = PROGRAM-NAME                         
C35842        IF I-APPL-PGM-ID = WS-PCSCA362                            
C35842           MOVE I-CUST-PHONE-NO       TO JT-CUST-PHONE-NO         
C35842        END-IF                                                    
P00526        IF I-PYMT-FACILITY-CD = 'O' OR 'U'                        
C35842           MOVE FUNCTION UPPER-CASE(JT-CUST-PHONE-NO(1:7))        
C35842                                      TO WS-PAR-OPERATOR-ID       
P00526           IF I-PYMT-FACILITY-CD = 'O'                            
C35842              STRING "PYMT-OFFICE=",                              
C35842                     JT-CUST-PHONE-NO(8:3) DELIMITED SIZE         
C35842                     "; " DELIMITED SIZE                          
C35842                     INTO WS-PYMT-OFFC-COMMENT                    
P00526           END-IF                                                 
C35842        END-IF                                                    
C35842        IF JT-CURRENCY-TYPE = 'H'                                 
C35842           STRING "CARD-TYPE=", JT-CREDIT-CARD-TYPE               
C35842                    DELIMITED SIZE INTO WS-CURR-TYPE-COMMENT      
C35842        END-IF                                                    
A37666        IF  WS-XFER-ACCT-NUM > SPACES                             
A37666        AND WS-XFER-ACCT = 'Y'                                    
A37666            STRING "PYMT ORIG: ",                                 
A37666                   WS-XFER-ACCT-NUM DELIMITED SIZE                
A37666                   INTO WS-XFER-ACCT-COMMENT                      
A37666        END-IF                                                    
C35842        STRING WS-PYMT-OFFC-COMMENT DELIMITED BY SPACE            
C35842               WS-CURR-TYPE-COMMENT DELIMITED BY SIZE             
C35842               INTO WS-CC-TRAN-COMMENT                            
C35842        MOVE WS-CC-TRAN-COMMENT TO WS-PAR-AR-TRAN-COMMENT-TEXT    
A37666        MOVE WS-XFER-ACCT-COMMENT TO                              
A37666                               WS-PAR-AR-TRAN-COMMENT-TEXT(41:24) 
A37666*       MOVE 31                 TO WS-PAR-AR-TRAN-COMMENT-LEN     19123300
A37666        MOVE 64                 TO WS-PAR-AR-TRAN-COMMENT-LEN     
C35842                                                                  
C35842        MOVE SPACES             TO WS-PAR-PYMT-RCPT-PRNTD-CD      
A37666     ELSE                                                         
A37666        IF  WS-XFER-ACCT-NUM > SPACES                             
A37666        AND WS-XFER-ACCT = 'Y'                                    
A37666            STRING "PYMT ORIG: ",                                 
A37666                   WS-XFER-ACCT-NUM DELIMITED SIZE                
A37666                   INTO WS-XFER-ACCT-COMMENT                      
A37666            MOVE WS-XFER-ACCT-COMMENT TO                          
A37666                                WS-PAR-AR-TRAN-COMMENT-TEXT(41:24)
A37666            MOVE 64                 TO WS-PAR-AR-TRAN-COMMENT-LEN 
A37666            MOVE SPACES             TO WS-PAR-PYMT-RCPT-PRNTD-CD  
A37666        END-IF                                                    
C35842     END-IF                                                       
                                                                        
      *--------------------------------------------------------------*  19200000
      * MOVE P TO WS-PAR-CODE-TRAN-TYPE RATHER THAN DEFAULT TO 'P'   *  19210000
      * IN CWS00017. IT IS NECESSARY TO POPULATE                     *  19220000
      * WS-PAR-CODE-TRAN-TYPE OUTSIDE COPYBOOK BECAUSE OTHER PROGRAMS*  19230000
      * ARE CALLING CPD00010 EVEN THOUGH THEY ARE NOT PAYMENT POSTING*  19240000
      * PROGRAM.                                                     *  19250000
      *--------------------------------------------------------------*  19260000
                                                                        
           MOVE WS-PAR-P                    TO WS-PAR-CODE-TRAN-TYPE    
                                                                        
           PERFORM 6700-APPLY-PAYMENT       THRU 6700-EXIT              
           MOVE WS-CURRENT-TIMESTAMP        TO JT-TRANS-HIST-SEQ-NO     
           PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT             
           MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST            
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '5000'               TO ACTIVE-PARAGRAPH             
              MOVE 'USERABEN'           TO ABEND-FUNCTION               
              MOVE WS-YES               TO WS-USER-FORCE-ABEND          
              MOVE SPACES               TO DSNTIAR-MESSAGE-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  19510000
      * IF PAYMENT NOT SUCCESSFUL IT SENDS A BAD RETURN CODE         *  19520000
      *--------------------------------------------------------------*  19530000
                                                                        
       5001-CHECK-PAYMENT-RETURN.                                       
                                                                        
           IF PYMT-WAS-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5001'                    TO ACTIVE-PARAGRAPH        
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       5001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  19710000
      * GETS COMMON DATE FROM CSS_JOB_PARM                           ** 19720000
      *--------------------------------------------------------------*  19730000
                                                                        
       6251-GET-FJC01-DATE.                                             
                                                                        
           MOVE ZEROS                  TO WS-SEQUENCE                   
           MOVE SPACES                 TO WS-SYSIPT                     
           MOVE WS-KEY-AREA            TO E-FJC01-KEY                   
                                                                        
           MOVE WS-PGRMNAME            TO G6-PROGRAM-NAME               
           MOVE WS-DATE                TO G6-CMND-CODE                  
           MOVE WS-01                  TO G6-COMPANY-NO                 
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT                  
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (RUN-DATE AND INPUT-ACTIVE)                        
                  OR END-OF-SYSIPT                                      
                                                                        
           IF END-OF-SYSIPT                                             
              MOVE WS-N                TO WS-OVERRIDE-DATE-SW           
           ELSE                                                         
              MOVE WS-Y TO WS-OVERRIDE-DATE-SW                          
              IF WS-INPUT-RUN-DATE-MM  NUMERIC                          
                 AND WS-INPUT-RUN-DATE-DD  NUMERIC                      
                 AND WS-INPUT-RUN-DATE-YY  NUMERIC                      
                                                                        
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
                 MOVE  WS-INPUT-RUN-DATE    TO WS-INPUT-DATE            
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '6251'                TO ACTIVE-PARAGRAPH         
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               ABEND-FUNCTION           
                 MOVE 'CSS_JOB_PARM'        TO TABLE-1                  
                 MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1        
                 MOVE +100                  TO WS-ACTIVE-RETURN-CODE    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF                                                       
           .                                                            
       6251-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 20170000
      * SELECTS ACTIVE CASH DRAWER ID FOR GIVEN CASH LOCAL OFFICE AND * 20180000
      * DATE CASH REPORT                                              * 20190000
      *---------------------------------------------------------------* 20200000
                                                                        
       7000-SELECT-ACTIVE-DRWR.                                         
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) CASH_DRAWER_ID                                      
               INTO :CS-CASH-DRAWER-ID                                  
               FROM CSS_CSH_DRWR_CNTL                                   
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CODE_CSH_DRWR_STAT = :CS-CODE-CSH-DRWR-STAT         
                AND CASH_DRAWER_ID     < 500                            
                                                  
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     20240000
MFA-TR*      SELECT CASH_DRAWER_ID                                      20250000
MFA-TR*        INTO :CS-CASH-DRAWER-ID                                  20260000
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                   20270000
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            20280000
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          20290000
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT           20300000
MFA-TR*         AND CODE_CSH_DRWR_STAT = :CS-CODE-CSH-DRWR-STAT         20310000
MFA-TR*         AND CASH_DRAWER_ID     < 500                            20320000
MFA-TR*       FETCH FIRST 1 ROW ONLY                                    20330000
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC                                                     20340000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CSH_DRWR_CNTL'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE CS-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE CS-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE 'CODE_CSH_DRWR_STAT'      TO TABLE-ELEMENT-3         
              MOVE CS-CODE-CSH-DRWR-STAT     TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 20610000
      * SELECTS CASH REPORT FOR GIVEN CASH LOCAL OFFICE AND           * 20620000
      * DATE CASH REPORT                                              * 20630000
      *---------------------------------------------------------------* 20640000
                                                                        
       7010-CHECK-CASH-RPT.                                             
                                                                        
           EXEC SQL                                                     
             SELECT STATUS                                              
               INTO :YR-STATUS                                          
               FROM CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )           
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     20680000
MFA-TR*      SELECT STATUS                                              20690000
MFA-TR*        INTO :YR-STATUS                                          20700000
MFA-TR*        FROM CSS_CSH_REPORT_HDR                                  20710000
MFA-TR*       WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO            20720000
MFA-TR*         AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE          20730000
MFA-TR*         AND DATE_CASH_REPORT   = :YR-DATE-CASH-REPORT           20740000
MFA-TR*        WITH UR                                                  20742000
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC                                                     20750000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CSH_REPORT_HDR'      TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE YR-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE YR-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 21000000
      * SELECTS MAX CASH DRAWER ID FOR GIVEN CASH LOCAL OFFICE AND    * 21010000
      * DATE CASH REPORT                                              * 21020000
      *---------------------------------------------------------------* 21030000
                                                                        
       7020-SELECT-MAX-DRWR-ID.                                         
                                                                        
           EXEC SQL                                                     
             SELECT MAX(CASH_DRAWER_ID)                                 
               INTO :CS-CASH-DRAWER-ID :WS-NULL-IND-11                   
               FROM CSS_CSH_DRWR_CNTL                                   
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CASH_DRAWER_ID     < 500                            
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     21070000
MFA-TR*      SELECT MAX(CASH_DRAWER_ID)                                 21080000
MFA-TR*        INTO :CS-CASH-DRAWER-ID:WS-NULL-IND-11                   21090000
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                   21100000
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            21110000
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          21120000
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT           21130000
MFA-TR*         AND CASH_DRAWER_ID     < 500                            21140000
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC                                                     21150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF  WS-NULL-IND-11 < ZERO                                 
                  MOVE 0                       TO CS-CASH-DRAWER-ID     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CSH_DRWR_CNTL'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE CS-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE CS-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 21420000
      * SELECTS ACCOUNT, CUSTOMER AND PREMISE DETAILS FOR GIVEN       * 21430000
      * ACCOUNT NO                                                    * 21440000
      *---------------------------------------------------------------* 21450000
                                                                        
       7030-SELECT-AT-PR-CU.                                            
           EXEC SQL                                                     
             SELECT AT.CUSTOMER_NO                                      
                   ,AT.CODE_ACCT_STAT                                   
                   ,AT.TOTAL_AR_BALANCE                                 
                   ,AT.DATE_LAST_ACTION                                 
                   ,AT.LOCAL_OFFICE                                     
                   ,AT.PREMISE_NO                                       
                   ,AT.CODES_DATA_PRESENT                               
                   ,AT.COMPANY_NO                                       
                   ,AT.AR_XFER_IND                                      
                   ,AT.ACCT_XFER_TO                                     
                   ,AT.BANKRUPTCY_IND                                   
                   ,AT.CREDIT_GROUP                                     
                   ,AT.NOTICE_EXEMPT_CD                                 
                   ,AT.CODE_DISC_OK                                     
                   ,AT.MST_SUB_ACCT_IND                                 
                   ,AT.EPP_OFFER_AMOUNT                                 
                   ,AT.REV_MTH_LST_NRML                                 
                   ,PR.CODE_PREMISE_STAT                                
                   ,PR.REV_DISTRICT_CD                                  
                   ,CU.CODE_EMPL_ACCT                                   
                   ,CU.CODE_CUST_STATUS                                 
                   ,CAST(SYSDATETIMEOFFSET() AS DATE)                           
                   ,AT.DATE_BILL_DAY_00                                 
                   ,AT.DATE_BILL_DAY_30                                 
                   ,AT.DATE_BILL_DAY_60                                 
                   ,AT.DATE_BILL_DAY_90                                 
                   ,AT.IVR_EXEMPT_CD                                    
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
               INTO :AT-CUSTOMER-NO                                     
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:AT-DATE-LAST-ACTION                                
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-PREMISE-NO                                      
                   ,:AT-CODES-DATA-PRESENT                              
                   ,:AT-COMPANY-NO                                      
                   ,:AT-AR-XFER-IND                                     
                   ,:AT-ACCT-XFER-TO                                    
                   ,:AT-BANKRUPTCY-IND                                  
                   ,:AT-CREDIT-GROUP                                    
                   ,:AT-NOTICE-EXEMPT-CD                                
                   ,:AT-CODE-DISC-OK                                    
                   ,:AT-MST-SUB-ACCT-IND                                
                   ,:AT-EPP-OFFER-AMOUNT                                
                   ,:AT-REV-MTH-LST-NRML                                
                   ,:PR-CODE-PREMISE-STAT                               
                   ,:PR-REV-DISTRICT-CD                                 
                   ,:CU-CODE-EMPL-ACCT                                  
                   ,:CU-CODE-CUST-STATUS                                
                   ,:WS-CURRENT-DATE                                    
                   ,:AT-DATE-BILL-DAY-00 :WS-NULL-IND-3                  
                   ,:AT-DATE-BILL-DAY-30 :WS-NULL-IND-4                  
                   ,:AT-DATE-BILL-DAY-60 :WS-NULL-IND-5                  
                   ,:AT-DATE-BILL-DAY-90 :WS-NULL-IND-6                  
                   ,:AT-IVR-EXEMPT-CD                                   
                   ,:AT-ACCT-FINALED-DT :WS-NULL-IND-10                  
               FROM CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                       
                   ,CSS_PREMISE  PR WITH(READUNCOMMITTED)                       
                   ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                       
              WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO AND                 
                    AT.PREMISE_NO  = PR.PREMISE_NO  AND                 
                    AT.CUSTOMER_NO = CU.CUSTOMER_NO                     
C33928                                                           
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     21480000
MFA-TR*      SELECT AT.CUSTOMER_NO                                      21490000
MFA-TR*            ,AT.CODE_ACCT_STAT                                   21500000
MFA-TR*            ,AT.TOTAL_AR_BALANCE                                 21510000
MFA-TR*            ,AT.DATE_LAST_ACTION                                 21520000
MFA-TR*            ,AT.LOCAL_OFFICE                                     21530000
MFA-TR*            ,AT.PREMISE_NO                                       21540000
MFA-TR*            ,AT.CODES_DATA_PRESENT                               21550000
MFA-TR*            ,AT.COMPANY_NO                                       21560000
MFA-TR*            ,AT.AR_XFER_IND                                      21570000
MFA-TR*            ,AT.ACCT_XFER_TO                                     21580000
MFA-TR*            ,AT.BANKRUPTCY_IND                                   21590000
MFA-TR*            ,AT.CREDIT_GROUP                                     21600000
MFA-TR*            ,AT.NOTICE_EXEMPT_CD                                 21610000
MFA-TR*            ,AT.CODE_DISC_OK                                     21620000
MFA-TR*            ,AT.MST_SUB_ACCT_IND                                 21630000
MFA-TR*            ,AT.EPP_OFFER_AMOUNT                                 21640000
MFA-TR*            ,AT.REV_MTH_LST_NRML                                 21650000
MFA-TR*            ,PR.CODE_PREMISE_STAT                                21660000
MFA-TR*            ,PR.REV_DISTRICT_CD                                  21670000
MFA-TR*            ,CU.CODE_EMPL_ACCT                                   21680000
MFA-TR*            ,CU.CODE_CUST_STATUS                                 21690000
MFA-TR*            ,CURRENT DATE                                        21700000
MFA-TR*            ,AT.DATE_BILL_DAY_00                                 21710000
MFA-TR*            ,AT.DATE_BILL_DAY_30                                 21720000
MFA-TR*            ,AT.DATE_BILL_DAY_60                                 21730000
MFA-TR*            ,AT.DATE_BILL_DAY_90                                 21740000
MFA-TR*            ,AT.IVR_EXEMPT_CD                                    21750000
MFA-TR*            ,AT.ACCT_FINALED_DT                                  21760000
MFA-TR*        INTO :AT-CUSTOMER-NO                                     21770000
MFA-TR*            ,:AT-CODE-ACCT-STAT                                  21780000
MFA-TR*            ,:AT-TOTAL-AR-BALANCE                                21790000
MFA-TR*            ,:AT-DATE-LAST-ACTION                                21800000
MFA-TR*            ,:AT-LOCAL-OFFICE                                    21810000
MFA-TR*            ,:AT-PREMISE-NO                                      21820000
MFA-TR*            ,:AT-CODES-DATA-PRESENT                              21830000
MFA-TR*            ,:AT-COMPANY-NO                                      21840000
MFA-TR*            ,:AT-AR-XFER-IND                                     21850000
MFA-TR*            ,:AT-ACCT-XFER-TO                                    21860000
MFA-TR*            ,:AT-BANKRUPTCY-IND                                  21870000
MFA-TR*            ,:AT-CREDIT-GROUP                                    21880000
MFA-TR*            ,:AT-NOTICE-EXEMPT-CD                                21890000
MFA-TR*            ,:AT-CODE-DISC-OK                                    21900000
MFA-TR*            ,:AT-MST-SUB-ACCT-IND                                21910000
MFA-TR*            ,:AT-EPP-OFFER-AMOUNT                                21920000
MFA-TR*            ,:AT-REV-MTH-LST-NRML                                21930000
MFA-TR*            ,:PR-CODE-PREMISE-STAT                               21940000
MFA-TR*            ,:PR-REV-DISTRICT-CD                                 21950000
MFA-TR*            ,:CU-CODE-EMPL-ACCT                                  21960000
MFA-TR*            ,:CU-CODE-CUST-STATUS                                21970000
MFA-TR*            ,:WS-CURRENT-DATE                                    21980000
MFA-TR*            ,:AT-DATE-BILL-DAY-00:WS-NULL-IND-3                  21990000
MFA-TR*            ,:AT-DATE-BILL-DAY-30:WS-NULL-IND-4                  22000000
MFA-TR*            ,:AT-DATE-BILL-DAY-60:WS-NULL-IND-5                  22010000
MFA-TR*            ,:AT-DATE-BILL-DAY-90:WS-NULL-IND-6                  22020000
MFA-TR*            ,:AT-IVR-EXEMPT-CD                                   22030000
MFA-TR*            ,:AT-ACCT-FINALED-DT:WS-NULL-IND-10                  22040000
MFA-TR*        FROM CSS_ACCOUNT  AT                                     22050000
MFA-TR*            ,CSS_PREMISE  PR                                     22060000
MFA-TR*            ,CSS_CUSTOMER CU                                     22070000
MFA-TR*       WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO AND                 22080000
MFA-TR*             AT.PREMISE_NO  = PR.PREMISE_NO  AND                 22090000
MFA-TR*             AT.CUSTOMER_NO = CU.CUSTOMER_NO                     22100000
MFA-TR*        WITH UR                                                  22102000
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                    22110000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-NULL-IND-3 EQUAL -1                                    
              MOVE SPACES TO AT-DATE-BILL-DAY-00                        
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-4 EQUAL -1                                    
              MOVE SPACES TO AT-DATE-BILL-DAY-30                        
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-5 EQUAL -1                                    
              MOVE SPACES TO AT-DATE-BILL-DAY-60                        
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-6 EQUAL -1                                    
              MOVE SPACES TO AT-DATE-BILL-DAY-90                        
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-10 EQUAL -1                                   
              MOVE SPACES TO AT-ACCT-FINALED-DT                         
           END-IF                                                       
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'CSS_PREMISE'         TO TABLE-2                     
              MOVE 'CSS_CUSTOMER'        TO TABLE-3                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 22890000
      * SELECTS TOTAL CHARGE OFF AMOUNT FOR GIVEN ACCOUNT NO          * 22900000
      *---------------------------------------------------------------* 22910000
                                                                        
       7050-DETERMINE-TOTAL-CO-AMT.                                     
                                                                        
           EXEC SQL                                                     
             SELECT SUM(AMT_TRANS)                                      
               INTO :WS-TOTAL-CHRG-OFF :WS-NULL-IND-7                    
               FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 
C33928          AND PYMT_PRIORITY_LVL  > 0                              
C33928          AND ITEM_ID            >= 0                             
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22950000
MFA-TR*      SELECT SUM(AMT_TRANS)                                      22960000
MFA-TR*        INTO :WS-TOTAL-CHRG-OFF:WS-NULL-IND-7                    22970000
MFA-TR*        FROM CSS_CHRG_OFF                                        22980000
MFA-TR*       WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 22990000
MFA-TR*         AND PYMT_PRIORITY_LVL  > 0                              22992000
MFA-TR*         AND ITEM_ID            >= 0                             22993000
MFA-TR*        WITH UR                                                  22994000
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC                                                     23000000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CHRG_OFF'            TO TABLE-1                 
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 23230000
      *  SELECTS CASH DRAWER DETAILS FOR GIVEN CASH LOCAL OFFICE,     * 23240000
      *  DATE CASH REPORT AND CASH DRAWER ID                          * 23250000
      *---------------------------------------------------------------* 23260000
                                                                        
       7060-SELECT-CASH-CNTRL.                                          
                                                                        
           EXEC SQL                                                     
             SELECT AMT_CASH_DEBIT                                      
                   ,AMT_CASH_CREDIT                                     
                   ,AMT_AR_DEBIT                                        
                   ,AMT_AR_CREDIT                                       
                   ,AMT_CK_ISS_DEBIT                                    
                   ,AMT_CK_ISS_CREDIT                                   
                   ,AMT_GL_DEBIT                                        
                   ,AMT_GL_CREDIT                                       
                   ,CODE_CSH_DRWR_STAT                                  
                   ,NO_ITEMS_ENTERED                                    
               INTO :CS-AMT-CASH-DEBIT                                  
                   ,:CS-AMT-CASH-CREDIT                                 
                   ,:CS-AMT-AR-DEBIT                                    
                   ,:CS-AMT-AR-CREDIT                                   
                   ,:CS-AMT-CK-ISS-DEBIT                                
                   ,:CS-AMT-CK-ISS-CREDIT                               
                   ,:CS-AMT-GL-DEBIT                                    
                   ,:CS-AMT-GL-CREDIT                                   
                   ,:CS-CODE-CSH-DRWR-STAT                              
                   ,:CS-NO-ITEMS-ENTERED                                
               FROM CSS_CSH_DRWR_CNTL                                   
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND CASH_REPORT_NO     = :CS-CASH-REPORT-NO             
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID             
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     23300000
MFA-TR*      SELECT AMT_CASH_DEBIT                                      23310000
MFA-TR*            ,AMT_CASH_CREDIT                                     23320000
MFA-TR*            ,AMT_AR_DEBIT                                        23330000
MFA-TR*            ,AMT_AR_CREDIT                                       23340000
MFA-TR*            ,AMT_CK_ISS_DEBIT                                    23350000
MFA-TR*            ,AMT_CK_ISS_CREDIT                                   23360000
MFA-TR*            ,AMT_GL_DEBIT                                        23370000
MFA-TR*            ,AMT_GL_CREDIT                                       23380000
MFA-TR*            ,CODE_CSH_DRWR_STAT                                  23390000
MFA-TR*            ,NO_ITEMS_ENTERED                                    23400000
MFA-TR*        INTO :CS-AMT-CASH-DEBIT                                  23410000
MFA-TR*            ,:CS-AMT-CASH-CREDIT                                 23420000
MFA-TR*            ,:CS-AMT-AR-DEBIT                                    23430000
MFA-TR*            ,:CS-AMT-AR-CREDIT                                   23440000
MFA-TR*            ,:CS-AMT-CK-ISS-DEBIT                                23450000
MFA-TR*            ,:CS-AMT-CK-ISS-CREDIT                               23460000
MFA-TR*            ,:CS-AMT-GL-DEBIT                                    23470000
MFA-TR*            ,:CS-AMT-GL-CREDIT                                   23480000
MFA-TR*            ,:CS-CODE-CSH-DRWR-STAT                              23490000
MFA-TR*            ,:CS-NO-ITEMS-ENTERED                                23500000
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                   23510000
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            23520000
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          23530000
MFA-TR*         AND CASH_REPORT_NO     = :CS-CASH-REPORT-NO             23540000
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT           23550000
MFA-TR*         AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID             23560000
MFA-TR*       QUERYNO 7060                                                      
MFA-TR*    END-EXEC                                                     23570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CSH_DRWR_CNTL'   TO TABLE-1                     
              MOVE CS-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE CS-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE CS-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              MOVE CS-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-4           
              MOVE 'CASH_COMPANY_NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE_CASH_REPORT'    TO TABLE-ELEMENT-3             
              MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 24250000
      * SELECTS DELINQUENCY VALUE FOR GIVEN DELINQUENCY CODE          * 24260000
      *---------------------------------------------------------------* 24270000
                                                                        
       7070-GET-DELINQ-VALUE.                                           
                                                                        
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
               INTO :C8-DELINQ-VALUE                                    
               FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
              WHERE DELINQ_CD  = :C8-DELINQ-CD                          
                AND COMPANY_NO = :C8-COMPANY-NO                         
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24310000
MFA-TR*      SELECT DELINQ_VALUE                                        24320000
MFA-TR*        INTO :C8-DELINQ-VALUE                                    24330000
MFA-TR*        FROM CSS_DELINQUENCY                                     24340000
MFA-TR*       WHERE DELINQ_CD  = :C8-DELINQ-CD                          24350000
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                         24360000
MFA-TR*        WITH UR                                                  24362000
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC                                                     24370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
C31844*       IF PAYMENT-NOT-INSERTED                                   24450000
C31844*          MOVE +2000 TO S-RETURN-CODE                            24460000
C31844*       END-IF                                                    24470000
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1           
              MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 24650000
      * VALIDATES ACCOUNT NO AND SELECTS ACCOUNT DETAILS FOR GIVEN    * 24660000
      * ACCOUNT NO                                                    * 24670000
      *---------------------------------------------------------------* 24680000
                                                                        
       7080-VALIDATE-ACCOUNT.                                           
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NO                                          
                   ,CODE_ACCT_STAT                                      
                   ,BANKRUPTCY_IND                                      
               INTO :AT-COMPANY-NO                                      
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-BANKRUPTCY-IND                                  
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24720000
MFA-TR*      SELECT COMPANY_NO                                          24730000
MFA-TR*            ,CODE_ACCT_STAT                                      24740000
MFA-TR*            ,BANKRUPTCY_IND                                      24750000
MFA-TR*        INTO :AT-COMPANY-NO                                      24760000
MFA-TR*            ,:AT-CODE-ACCT-STAT                                  24770000
MFA-TR*            ,:AT-BANKRUPTCY-IND                                  24780000
MFA-TR*        FROM CSS_ACCOUNT                                         24790000
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         24800000
MFA-TR*        WITH UR                                                  24802000
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC                                                     24810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 25040000
      *    CHECKS WHETHER ACCOUNT IS A OLD ACCOUNT NO AND GET THE     * 25050000
      *    NEW CIS ACCOUNT NO IF IT IS OLD ACCOUNT NO.                * 25060000
      *---------------------------------------------------------------* 25070000
                                                                        
       7090-GET-NEW-ACCOUNT.                                            
                                                                        
           EXEC SQL                                                     
             SELECT NEW_ACCOUNT_NO                                      
               INTO :XR-NEW-ACCOUNT-NO                                  
               FROM CSS_XREF_ACCT WITH(READUNCOMMITTED)                         
              WHERE OLD_ACCOUNT_NO  = :XR-OLD-ACCOUNT-NO                
C33928                                                           
P00641                                                      
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     25110000
MFA-TR*      SELECT NEW_ACCOUNT_NO                                      25120000
MFA-TR*        INTO :XR-NEW-ACCOUNT-NO                                  25130000
MFA-TR*        FROM CSS_XREF_ACCT                                       25140000
MFA-TR*       WHERE OLD_ACCOUNT_NO  = :XR-OLD-ACCOUNT-NO                25150000
MFA-TR*        WITH UR                                                  25152000
MFA-TR*       QUERYNO 7090                                                      
MFA-TR*     END-EXEC                                                    25160000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                            S-RETURN-CODE                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              OR MULTIPLE-ROWS-SELECTED                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7090'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_XREF_ACCT'       TO TABLE-1                     
              MOVE XR-OLD-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1           
              MOVE 'OLD_ACCOUNT_NO'      TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 25400000
      *    FINDS THE PREV BUSINESS DAY, SKIPPING OVER WEEKENDS        * 25410000
      *    AND HOLIDAYS (FOUND IN CSS_HOLIDAY), FROM THE CURRENT      * 25420000
      *    VALUE IN WS-OLD-BUSINESS-DAY                               * 25430000
      *---------------------------------------------------------------* 25440000
                                                                        
       7100-GET-PREV-BUSINESS-DAY.                                      
T34097                                                                  
T34097     EXEC SQL                                                     
T34097        SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-OLD-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-OLD-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-BUSINESS-DAY
              ), CONVERT(DATE, :WS-OLD-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-OLD-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-OLD-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-BUSINESS-DAY
              ), CONVERT(DATE, :WS-OLD-BUSINESS-DAY) ) )) -       
T34097                CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-OLD-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-OLD-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-BUSINESS-DAY
              ), CONVERT(DATE, :WS-OLD-BUSINESS-DAY) ) ))/7*7)-1
            INTO
              :WS-OLD-BUSINESS-DAY,
              :WS-DAY-OF-WEEK  
T34097     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     25480000
MFA-TR*       SET :WS-OLD-BUSINESS-DAY =                                25490000
MFA-TR*                      DATE(:WS-OLD-BUSINESS-DAY) - 1 DAYS        25500000
MFA-TR*          ,:WS-DAY-OF-WEEK =                                     25501000
MFA-TR*              (DAYS(DATE(:WS-OLD-BUSINESS-DAY) - 1 DAYS) -       25502000
MFA-TR*               DAYS(DATE(:WS-OLD-BUSINESS-DAY) - 1 DAYS)/7*7)-1  25503000
MFA-TR*    END-EXEC                                                     25510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 25920000
      * GET USER ID USING CASH LOCAL OFFICE                           * 25930000
      *---------------------------------------------------------------* 25940000
                                                                        
       7110-GET-USER-ID.                                                
                                                                        
           EXEC SQL                                                     
             SELECT USER_ID                                             
                   ,DEP_CASH_GL_OFFSET                                  
                   ,LOCAL_OFFICE                                        
C29529             ,PAYMENT_AGENT_FL                                    
               INTO :Y2-USER-ID                                         
                   ,:Y2-DEP-CASH-GL-OFFSET                              
                   ,:Y2-LOCAL-OFFICE                                    
C29529             ,:Y2-PAYMENT-AGENT-FL                                
               FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE           
C29529*         AND PAYMENT_AGENT_FL  = 'Y'                             26100000
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     25980000
MFA-TR*      SELECT USER_ID                                             25990000
MFA-TR*            ,DEP_CASH_GL_OFFSET                                  26000000
MFA-TR*            ,LOCAL_OFFICE                                        26010000
MFA-TR*            ,PAYMENT_AGENT_FL                                    26020000
MFA-TR*        INTO :Y2-USER-ID                                         26030000
MFA-TR*            ,:Y2-DEP-CASH-GL-OFFSET                              26040000
MFA-TR*            ,:Y2-LOCAL-OFFICE                                    26050000
MFA-TR*            ,:Y2-PAYMENT-AGENT-FL                                26060000
MFA-TR*        FROM CSS_CASHIER_OFFICE                                  26070000
MFA-TR*       WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO             26080000
MFA-TR*         AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE           26090000
MFA-TR*         AND PAYMENT_AGENT_FL  = 'Y'                             26100000
MFA-TR*        WITH UR                                                  26102000
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC                                                     26110000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                                        
C29529*    IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     26160000
C29529     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7110'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASHIER_OFFICE'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE Y2-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE Y2-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF                                                       
           .                                                            
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
C30257*---------------------------------------------------------------* 26370000
C30257* CHECKS WHETHER THE PAYMENT IS ALREADY POSTED TO AVOID DOUBLE  * 26380000
C30257* POSTING, IF PAYMENT ALREADY POSTED THEN ABEND THE FUNCTION.   * 26390000
C30257*---------------------------------------------------------------* 26400000
C30257 7120-SELECT-PAYMENT.                                             
C30257                                                                  
C30257     EXEC SQL                                                     
C30257       SELECT ACCOUNT_NO                                          
C30257         INTO :JT-ACCOUNT-NO                                      
C30257         FROM CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                     
C30257        WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )            
C30257          AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           
C30257          AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )                
C30257          AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  
C30257          AND APPLIED_FL        <> 'Y'                            
C33928                                                           
P00641                                                      
C30257     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     26430000
MFA-TR*      SELECT ACCOUNT_NO                                          26440000
MFA-TR*        INTO :JT-ACCOUNT-NO                                      26450000
MFA-TR*        FROM CSS_PAYMENT_TRANS                                   26460000
MFA-TR*       WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT            26470000
MFA-TR*         AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           26480000
MFA-TR*         AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                26490000
MFA-TR*         AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  26500000
MFA-TR*         AND APPLIED_FL        <> 'Y'                            26510000
MFA-TR*        WITH UR                                                  26512000
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC                                                     26520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30257                                                                  
C30257     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C30257                                                                  
C30257     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30257     OR ( WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
C30257        AND DUPLICATE-PAYMENT)                                    
C30257        CONTINUE                                                  
C30257     ELSE                                                         
C30257        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C30257        MOVE '7120'                     TO ACTIVE-PARAGRAPH       
C30257        MOVE 'SELECT'                   TO ABEND-FUNCTION         
C30257        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C30257                                           ABEND-TABLES           
C30257        MOVE 'CSS_PAYMENT_TRANS'        TO TABLE-1                
C30257        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
C30257        MOVE JT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C30257        MOVE 'PYMT_RCVD_TS'             TO TABLE-ELEMENT-2        
C30257        MOVE JT-PYMT-RCVD-TS            TO HOSTVAR-ELEMENT-2      
C30257        MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-3        
C30257        MOVE JT-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3      
C30257        MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4        
C30257        MOVE JT-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4      
C30257        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C30257        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30257     END-IF                                                       
C30257     .                                                            
C30257 7120-EXIT.                                                       
C30257     EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 26820000
      * CHECKS WHETHER THE GIVEN DATE IS EXISTS IN HOLIDAY TABLE      * 26830000
      *---------------------------------------------------------------* 26840000
                                                                        
       7150-CHECK-HOLIDAY.                                              
                                                                        
           EXEC SQL                                                     
C33928*      SELECT DISTINCT('Y')                                       26890000
C33928       SELECT TOP(1) 'Y'                                                 
               INTO :WS-HOLIDAY-EXISTS                                  
               FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                           
              WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                         
C33928                                            
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     26880000
MFA-TR*      SELECT DISTINCT('Y')                                       26890000
MFA-TR*      SELECT 'Y'                                                 26891000
MFA-TR*        INTO :WS-HOLIDAY-EXISTS                                  26900000
MFA-TR*        FROM CSS_HOLIDAY                                         26910000
MFA-TR*       WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                         26920000
MFA-TR*       FETCH FIRST 1 ROW ONLY                                    26922000
MFA-TR*        WITH UR                                                  26923000
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC                                                     26930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 27140000
      * SELECTS PAYMENT TRANSACTION                                   * 27150000
      *---------------------------------------------------------------* 27160000
                                                                        
       7160-SELECT-PYMT-TRAN.                                           
           EXEC SQL                                                     
             SELECT CURRENCY_TYPE,                                      
                    CREDIT_CARD_TYPE,                                   
C29529              APPL_PROGRAM_ID                                     
               INTO :JT-CURRENCY-TYPE,                                  
                    :JT-CREDIT-CARD-TYPE,                               
C29529              :JT-APPL-PROGRAM-ID                                 
               FROM CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                     
              WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )            
                AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           
                AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )                
                AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  
                AND APPLIED_FL        <> 'Y'                            
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     27190000
MFA-TR*      SELECT CURRENCY_TYPE,                                      27200000
MFA-TR*             CREDIT_CARD_TYPE,                                   27210000
MFA-TR*             APPL_PROGRAM_ID                                     27220000
MFA-TR*        INTO :JT-CURRENCY-TYPE,                                  27230000
MFA-TR*             :JT-CREDIT-CARD-TYPE,                               27240000
MFA-TR*             :JT-APPL-PROGRAM-ID                                 27250000
MFA-TR*        FROM CSS_PAYMENT_TRANS                                   27260000
MFA-TR*       WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT            27270000
MFA-TR*         AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           27280000
MFA-TR*         AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                27290000
MFA-TR*         AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  27300000
MFA-TR*         AND APPLIED_FL        <> 'Y'                            27310000
MFA-TR*        WITH UR                                                  27312000
MFA-TR*       QUERYNO 7160                                                      
MFA-TR*    END-EXEC                                                     27320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF JT-CURRENCY-TYPE = WS-H                                
                 MOVE JT-CREDIT-CARD-TYPE TO I-CURRENCY-TYPE            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7160'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PAYMENT_TRANS'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE JT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'PYMT_RCVD_TS'             TO TABLE-ELEMENT-2        
              MOVE JT-PYMT-RCVD-TS            TO HOSTVAR-ELEMENT-2      
              MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-3        
              MOVE JT-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3      
              MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4        
              MOVE JT-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 27630000
      * SUBTRACTS ONE DAY FROM GIVEN DATE                             * 27640000
      *---------------------------------------------------------------* 27650000
                                                                        
       7180-GET-PREV-DATE.                                              
                                                                        
           EXEC SQL                                                     
T34097        SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :I-REPORT-DATE
              ) IS NULL OR (PATINDEX('%.%', :I-REPORT-DATE
              ) <> 0) OR (LEN(:I-REPORT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :I-REPORT-DATE
              ), CONVERT(DATE, :I-REPORT-DATE) ) )
            INTO
              :WS-PREV-DATE         
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     27690000
MFA-TR*       SET :WS-PREV-DATE = DATE(:I-REPORT-DATE) - 1 DAYS         27700000
MFA-TR*    END-EXEC                                                     27710000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7180'                TO ACTIVE-PARAGRAPH            
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'REPORT DATE'         TO TABLE-ELEMENT-1             
              MOVE I-REPORT-DATE         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7190-VALIDATE-CURRENCY-TYPE.                                     
                                                                        
           EXEC SQL                                                     
             SELECT PROGRAM_ID                                          
               INTO :UV-PROGRAM-ID                                      
               FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
              WHERE TABLE_NA   = :WS-CV-TABLE-NAME                      
                AND COMPANY_NO = :WS-COMPANY-NO                         
                AND COLUMN_NA  = :WS-CV-COLUMN-NAME                     
                AND CODE_VALUE = :WS-CV-CODE-VALUE                      
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27950000
MFA-TR*      SELECT PROGRAM_ID                                          27960000
MFA-TR*        INTO :UV-PROGRAM-ID                                      27970000
MFA-TR*        FROM CSS_CODE_VALUE                                      27980000
MFA-TR*       WHERE TABLE_NA   = :WS-CV-TABLE-NAME                      27990000
MFA-TR*         AND COMPANY_NO = :WS-COMPANY-NO                         28000000
MFA-TR*         AND COLUMN_NA  = :WS-CV-COLUMN-NAME                     28010000
MFA-TR*         AND CODE_VALUE = :WS-CV-CODE-VALUE                      28020000
MFA-TR*        WITH UR                                                  28022000
MFA-TR*       QUERYNO 7190                                                      
MFA-TR*    END-EXEC                                                     28030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE UV-PROGRAM-ID TO WS-CURRENCY-TYPE                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-F TO WS-INPUT-ERROR-SW                         
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7190'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_CODE_VALUE'      TO TABLE-1                  
                 MOVE 'TABLE_NAME'               TO TABLE-ELEMENT-1     
                 MOVE WS-CV-TABLE-NAME           TO HOSTVAR-ELEMENT-1   
                 MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2     
                 MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2   
                 MOVE 'COLUMN_NAME'              TO TABLE-ELEMENT-3     
                 MOVE WS-CV-COLUMN-NAME          TO HOSTVAR-ELEMENT-3   
                 MOVE 'CODE_VALUE'               TO TABLE-ELEMENT-4     
                 MOVE WS-CV-CODE-VALUE           TO HOSTVAR-ELEMENT-4   
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 28360000
      * SELECTS CURRENT DATE                                          * 28370000
      *---------------------------------------------------------------* 28380000
                                                                        
       7200-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
T34097        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     28420000
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                       28430000
MFA-TR*    END-EXEC                                                     28440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7202-GET-CURRENT-TS.                                             
                                                                        
           EXEC SQL                                                     
T34097        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     28660000
MFA-TR*       SET :WS-CURRENT-TS = CURRENT TIMESTAMP                    28670000
MFA-TR*    END-EXEC                                                     28680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7202'                TO ACTIVE-PARAGRAPH            
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7202-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT196 7203-GET-MNT-TRANS-TS.                                           
ACT196                                                                  
ACT196     EXEC SQL                                                     
ACT196        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, 
              1, CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP) ), 121), 
           ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO  
ACT196     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     28660000
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO =                               28670000
MFA-TR*               TIMESTAMP(:WS-CURRENT-TIMESTAMP) + 1 MICROSECOND          
MFA-TR*    END-EXEC                                                     28680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT196                                                                  
ACT196     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
ACT196                     S-RETURN-CODE                                
ACT196                                                                  
ACT196     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT196        CONTINUE                                                  
ACT196     ELSE                                                         
ACT196        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT196        MOVE '7203'                TO ACTIVE-PARAGRAPH            
ACT196        MOVE 'SET'                 TO ABEND-FUNCTION              
ACT196        MOVE SPACES                TO ABEND-SQL-PREDICATES        
ACT196                                      ABEND-TABLES                
ACT196        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
ACT196        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
ACT196     END-IF                                                       
ACT196     .                                                            
ACT196 7203-EXIT.                                                       
ACT196     EXIT.                                                        
                                                                        
C29529*---------------------------------------------------------------* 28880000
C29529* SELECTS CURRENT DATE MINUS 1 DAY                              * 28890000
C29529*---------------------------------------------------------------* 28900000
                                                                        
C29529 7201-GET-CURR-DATE-MINUS-ONE.                                    
                                                                        
C29529     EXEC SQL                                                     
T34097        SELECT
              DATEADD( DAY, -1, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-YESTERDAY                 
C29529     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     28940000
MFA-TR*       SET :WS-YESTERDAY = CURRENT DATE - 1 DAYS                 28950000
MFA-TR*    END-EXEC                                                     28960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C29529                     S-RETURN-CODE                                
                                                                        
C29529     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29529        MOVE '7201'                TO ACTIVE-PARAGRAPH            
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
C29529        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C29529                                      ABEND-TABLES                
C29529        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29529        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29529     END-IF                                                       
C29529     .                                                            
C29529 7201-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*29160000
      * OPEN OVER SHORT TYPE CURSOR                                    *29170000
      *----------------------------------------------------------------*29180000
                                                                        
       7210-OPEN-OVSH-TYPE.                                             
                                                                        
           EXEC SQL                                                     
               OPEN OVSHTYPE_CURSOR                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_OVERSHORT_TYPE'       TO TABLE-1                
              MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-DISP-GL-ACCT            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*29470000
      *      FETCH OVERSHORT TYPE CURSOR                               *29480000
      *----------------------------------------------------------------*29490000
                                                                        
       7220-FETCH-OVSH-TYPE.                                            
                                                                        
           EXEC SQL                                                     
              FETCH OVSHTYPE_CURSOR                                     
               INTO :OT-OVERSHORT-TYPE-CD                               
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_OVERSHORT_TYPE'       TO TABLE-1                
              MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-DISP-GL-ACCT            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*29790000
      *      CLOSE OVERSHORT TYPE CURSOR                               *29800000
      *----------------------------------------------------------------*29810000
                                                                        
       7230-CLOSE-OVSH-TYPE.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE OVSHTYPE_CURSOR                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7230'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_OVERSHORT_TYPE'       TO TABLE-1                
              MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-DISP-GL-ACCT            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 30100000
      * SELECT OVER/SHORT AMOUNT FOR GIVEN PYMT OFFICE, DATE, DRAWER  * 30110000
      *---------------------------------------------------------------* 30120000
                                                                        
       7240-SELECT-OVSH.                                                
                                                                        
           EXEC SQL                                                     
              SELECT OVERSHORT_AMT,                                     
                     OVERSHORT_DR_CR                                    
               INTO :OH-OVERSHORT-AMT,                                  
                    :OH-OVERSHORT-DR-CR                                 
               FROM CSS_OVERSHORT_HDR                                   
              WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE           
                AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )            
                AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID              
                AND OVERSHORT_ID      = :OH-OVERSHORT-ID                
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     30160000
MFA-TR*       SELECT OVERSHORT_AMT,                                     30170000
MFA-TR*              OVERSHORT_DR_CR                                    30180000
MFA-TR*        INTO :OH-OVERSHORT-AMT,                                  30190000
MFA-TR*             :OH-OVERSHORT-DR-CR                                 30200000
MFA-TR*        FROM CSS_OVERSHORT_HDR                                   30210000
MFA-TR*       WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO             30220000
MFA-TR*         AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE           30230000
MFA-TR*         AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT            30240000
MFA-TR*         AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID              30250000
MFA-TR*         AND OVERSHORT_ID      = :OH-OVERSHORT-ID                30260000
MFA-TR*       QUERYNO 7240                                                      
MFA-TR*    END-EXEC.                                                    30270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7240'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_OVERSHORT_HDR'        TO TABLE-1                
              MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1        
              MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2        
              MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3        
              MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4        
              MOVE OH-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1      
              MOVE OH-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2      
              MOVE OH-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3      
              MOVE OH-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 30560000
      * CHECKS WHETHER ACCOUNT IS ALREADY THERE IN DNP CANCEL TABLE   * 30570000
      *---------------------------------------------------------------* 30580000
                                                                        
      *---------------------------------------------------------------* 30910000
      *    SELECTS ACTIVE/INPROGRESS BILL EXCEPTION WQS               * 30920000
      *---------------------------------------------------------------* 30930000
                                                                        
       7260-SELECT-BILLEXECP-WQ.                                        
                                                                        
           EXEC SQL                                                     
             SELECT WQ.ACCOUNT_NO                                       
               INTO :WQ-ACCOUNT-NO                                      
               FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                       
              WHERE WQ.ACCOUNT_NO = :AT-ACCOUNT-NO                      
                AND STATUS        IN ('A','I')                          
                AND CATEGORY_ID   IN (17,137,138,139)                   
C33928          AND PREMISE_NO    >= 0                                  
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30970000
MFA-TR*      SELECT WQ.ACCOUNT_NO                                       30980000
MFA-TR*        INTO :WQ-ACCOUNT-NO                                      30990000
MFA-TR*        FROM CSS_WQ_ITEMS WQ                                     31000000
MFA-TR*       WHERE WQ.ACCOUNT_NO = :AT-ACCOUNT-NO                      31010000
MFA-TR*         AND STATUS        IN ('A','I')                          31020000
MFA-TR*         AND CATEGORY_ID   IN (17,137,138,139)                   31030000
MFA-TR*         AND PREMISE_NO    >= 0                                  31032000
MFA-TR*        WITH UR                                                  31033000
MFA-TR*       QUERYNO 7260                                                      
MFA-TR*    END-EXEC                                                     31040000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR MULTIPLE-ROWS-SELECTED                                 
              SET WQ-EXISTS                     TO TRUE                 
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 SET WQ-NOT-EXISTS              TO TRUE                 
              ELSE                                                      
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '7260'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'SELECT'                  TO ABEND-FUNCTION       
                 MOVE SPACES                    TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                 MOVE 'CSS_WQ_ITEMS'            TO TABLE-1              
                 MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1    
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF                                                       
           .                                                            
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 31320000
      *    SELECTS CANCEL REBILL ROW FOR THE LAST TWO MONTHS          * 31330000
      *---------------------------------------------------------------* 31340000
                                                                        
       7270-SELECT-CANCEL-REBIL.                                        
                                                                        
           EXEC SQL                                                     
             SELECT ACCOUNT_NO                                          
               INTO :BG-ACCOUNT-NO                                      
               FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 
                AND REV_MTH_ORIG_BILL >= :WS-REV-MTH-LOWER-LIMIT        
                AND REV_MTH_ORIG_BILL <= :WS-REV-MTH-UPPER-LIMIT        
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31380000
MFA-TR*      SELECT ACCOUNT_NO                                          31390000
MFA-TR*        INTO :BG-ACCOUNT-NO                                      31400000
MFA-TR*        FROM CSS_BILLING_DET BG                                  31410000
MFA-TR*       WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 31420000
MFA-TR*         AND REV_MTH_ORIG_BILL >= :WS-REV-MTH-LOWER-LIMIT        31430000
MFA-TR*         AND REV_MTH_ORIG_BILL <= :WS-REV-MTH-UPPER-LIMIT        31440000
MFA-TR*        WITH UR                                                  31442000
MFA-TR*       QUERYNO 7270                                                      
MFA-TR*    END-EXEC                                                     31450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR MULTIPLE-ROWS-SELECTED                                 
              SET CAN-REBILL-EXISTS             TO TRUE                 
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 SET CAN-REBILL-NOT-EXISTS      TO TRUE                 
              ELSE                                                      
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '7270'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'SELECT'                  TO ABEND-FUNCTION       
                 MOVE SPACES                    TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                 MOVE 'CSS_BILLING_DET'         TO TABLE-1              
                 MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1    
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE WS-REV-MTH-LOWER-LIMIT    TO HOSTVAR-ELEMENT-2    
                 MOVE 'REV_MTH_ORIG_BILL > '    TO TABLE-ELEMENT-2      
                 MOVE WS-REV-MTH-UPPER-LIMIT    TO HOSTVAR-ELEMENT-3    
                 MOVE 'REV_MTH_ORIG_BILL < '    TO TABLE-ELEMENT-3      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF                                                       
           .                                                            
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 31770000
      *    SELECTS PASSWORD TEXT FROM CUST STATS                      * 31780000
      *---------------------------------------------------------------* 31790000
                                                                        
       7280-SELECT-CUST-STAT.                                           
                                                                        
           EXEC SQL                                                     
             SELECT CE.PASSWORD_TX                                      
               INTO :CE-PASSWORD-TX                                     
               FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                     
              WHERE CE.CUSTOMER_NO     = :AT-CUSTOMER-NO                
                AND CE.CUSTOMER_TYPE   = 'C'                            
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31830000
MFA-TR*      SELECT CE.PASSWORD_TX                                      31840000
MFA-TR*        INTO :CE-PASSWORD-TX                                     31850000
MFA-TR*        FROM CSS_CUST_STATS CE                                   31860000
MFA-TR*       WHERE CE.CUSTOMER_NO     = :AT-CUSTOMER-NO                31870000
MFA-TR*         AND CE.CUSTOMER_TYPE   = 'C'                            31880000
MFA-TR*        WITH UR                                                  31882000
MFA-TR*       QUERYNO 7280                                                      
MFA-TR*    END-EXEC                                                     31890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF CE-PASSWORD-TX > '  '                                  
                 SET PASSWORD-EXISTS            TO TRUE                 
              ELSE                                                      
                 SET PASSWORD-NOT-EXISTS        TO TRUE                 
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 SET PASSWORD-NOT-EXISTS        TO TRUE                 
              ELSE                                                      
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '7280'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'SELECT'                  TO ABEND-FUNCTION       
                 MOVE SPACES                    TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                 MOVE 'CSS_CUST_STATS'          TO TABLE-1              
                 MOVE AT-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1    
                 MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1      
                 MOVE WS-C                      TO HOSTVAR-ELEMENT-2    
                 MOVE 'CUSTOMER_TYPE'           TO TABLE-ELEMENT-2      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF                                                       
           .                                                            
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 32220000
      *    SELECTS CURRENT REVENUE MONTH                              * 32230000
      *---------------------------------------------------------------* 32240000
                                                                        
       7290-SELECT-REV-MON.                                             
                                                                        
           EXEC SQL                                                     
             SELECT PARM_DATA                                           
               INTO :G6-PARM-DATA                                       
               FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                       
              WHERE PROGRAM_NAME = 'COMMON'                             
                AND COMPANY_NO   = '01'                                 
                AND CMND_CODE    = 'DATE'                               
                AND SEQ_NO       = 20                                   
                AND STATUS       = 'A'                                  
C33928                                                           
P00641                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32280000
MFA-TR*      SELECT PARM_DATA                                           32290000
MFA-TR*        INTO :G6-PARM-DATA                                       32300000
MFA-TR*        FROM CSS_JOB_PARM G6                                     32310000
MFA-TR*       WHERE PROGRAM_NAME = 'COMMON'                             32320000
MFA-TR*         AND COMPANY_NO   = '01'                                 32330000
MFA-TR*         AND CMND_CODE    = 'DATE'                               32340000
MFA-TR*         AND SEQ_NO       = 20                                   32350000
MFA-TR*         AND STATUS       = 'A'                                  32360000
MFA-TR*        WITH UR                                                  32362000
MFA-TR*       QUERYNO 7290                                                      
MFA-TR*    END-EXEC                                                     32370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7290'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_JOB_PARM'            TO TABLE-1                 
              MOVE 'COMMON'                  TO HOSTVAR-ELEMENT-1       
              MOVE 'PROGRAM_NAME'            TO TABLE-ELEMENT-1         
              MOVE 'DATE'                    TO HOSTVAR-ELEMENT-2       
              MOVE 'CMND_CODE'               TO TABLE-ELEMENT-2         
              MOVE 20                        TO HOSTVAR-ELEMENT-3       
              MOVE 'SEQ_NO'                  TO TABLE-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 32640000
      *    SUBTRACTS TWO MONTHS FROM GIVEN DATE                       * 32650000
      *---------------------------------------------------------------* 32660000
                                                                        
       7295-SUBTRACT-2-MONTH.                                           
                                                                        
           EXEC SQL                                                     
T34097        SELECT
              DATEADD( MONTH, -2, IIF(TRY_CONVERT(DATE, :WS-REV-DATE1
              ) IS NULL OR (PATINDEX('%.%', :WS-REV-DATE1
              ) <> 0) OR (LEN(:WS-REV-DATE1) <> 10), CIS.CHAR2DATE(
                                                          :WS-REV-DATE1
              ), CONVERT(DATE, :WS-REV-DATE1) ) )
            INTO
              :WS-REV-DATE1        
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     32700000
MFA-TR*       SET :WS-REV-DATE1 = DATE(:WS-REV-DATE1) - 2 MONTHS        32710000
MFA-TR*    END-EXEC                                                     32720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7295'                TO ACTIVE-PARAGRAPH            
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'WS REV DATE'         TO TABLE-ELEMENT-1             
              MOVE WS-REV-DATE           TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7295-EXIT.                                                       
           EXIT.                                                        
                                                                        
C31844                                                                  
C31844*---------------------------------------------------------------* 32950000
C31844*    GET VALID PAYMENT OFFICE USING APPL-PROGRAM-ID, FOR EACH   * 32960000
C31844*    APPL-PROGRAM-ID THERE SHOULD BE ONLY ONE VALID PYMT OFFICE.* 32970000
C31844*---------------------------------------------------------------* 32980000
C31844                                                                  
C31844 7300-SELECT-CODE-VAL.                                            
C31844                                                                  
C31844     EXEC SQL                                                     
C31844       SELECT CODE_VALUE                                          
C31844         INTO :UV-CODE-VALUE                                      
C31844         FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
C31844        WHERE COMPANY_NO = :UV-COMPANY-NO                         
C31844          AND TABLE_NA   = :UV-TABLE-NA                           
C31844          AND COLUMN_NA  = :UV-COLUMN-NA                          
C31844          AND PROGRAM_ID = :UV-PROGRAM-ID                         
C33928                                                           
P00641                                                      
C31844     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     33020000
MFA-TR*      SELECT CODE_VALUE                                          33030000
MFA-TR*        INTO :UV-CODE-VALUE                                      33040000
MFA-TR*        FROM CSS_CODE_VALUE                                      33050000
MFA-TR*       WHERE COMPANY_NO = :UV-COMPANY-NO                         33060000
MFA-TR*         AND TABLE_NA   = :UV-TABLE-NA                           33070000
MFA-TR*         AND COLUMN_NA  = :UV-COLUMN-NA                          33080000
MFA-TR*         AND PROGRAM_ID = :UV-PROGRAM-ID                         33090000
MFA-TR*        WITH UR                                                  33092000
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC                                                     33100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31844                                                                  
C31844     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
C31844                                           S-RETURN-CODE          
C31844                                                                  
C31844     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C31844        CONTINUE                                                  
C31844     ELSE                                                         
C31844        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C31844        MOVE '7300'                     TO ACTIVE-PARAGRAPH       
C31844        MOVE 'SELECT'                   TO ABEND-FUNCTION         
C31844        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C31844                                           ABEND-TABLES           
C31844        MOVE 'CSS_CODE_VALUE'           TO TABLE-1                
C31844        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
C31844        MOVE 'TABLE_NA'                 TO TABLE-ELEMENT-2        
C31844        MOVE 'COLUMN_NA'                TO TABLE-ELEMENT-3        
C31844        MOVE 'PROGRAM_ID'               TO TABLE-ELEMENT-4        
C31844        MOVE UV-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
C31844        MOVE UV-TABLE-NA-TEXT           TO HOSTVAR-ELEMENT-2      
C31844        MOVE UV-COLUMN-NA-TEXT          TO HOSTVAR-ELEMENT-3      
C31844        MOVE UV-PROGRAM-ID              TO HOSTVAR-ELEMENT-4      
C31844        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C31844        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C31844     END-IF                                                       
C31844     .                                                            
C31844 7300-EXIT.                                                       
C31844     EXIT.                                                        
C31844                                                                  
C31844*---------------------------------------------------------------* 33390000
C31844*    CHECK WHETHER A MATCHING ROW IS AVAILABLE FOR ALL THE KEY  * 33400000
C31844*    VALUES                                                     * 33410000
C31844*---------------------------------------------------------------* 33420000
C31844                                                                  
C31844 7310-CHECK-CODE-VALUE.                                           
C31844                                                                  
C31844     EXEC SQL                                                     
C31844       SELECT CODE_VALUE                                          
C31844         INTO :UV-CODE-VALUE                                      
C31844         FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
C31844        WHERE COMPANY_NO = :UV-COMPANY-NO                         
C31844          AND TABLE_NA   = :UV-TABLE-NA                           
C31844          AND COLUMN_NA  = :UV-COLUMN-NA                          
C31844          AND PROGRAM_ID = :UV-PROGRAM-ID                         
C31844          AND CODE_VALUE = :UV-CODE-VALUE                         
C33928                                                           
P00641                                                      
C31844     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     33460000
MFA-TR*      SELECT CODE_VALUE                                          33470000
MFA-TR*        INTO :UV-CODE-VALUE                                      33480000
MFA-TR*        FROM CSS_CODE_VALUE                                      33490000
MFA-TR*       WHERE COMPANY_NO = :UV-COMPANY-NO                         33500000
MFA-TR*         AND TABLE_NA   = :UV-TABLE-NA                           33510000
MFA-TR*         AND COLUMN_NA  = :UV-COLUMN-NA                          33520000
MFA-TR*         AND PROGRAM_ID = :UV-PROGRAM-ID                         33530000
MFA-TR*         AND CODE_VALUE = :UV-CODE-VALUE                         33540000
MFA-TR*        WITH UR                                                  33542000
MFA-TR*       QUERYNO 7310                                                      
MFA-TR*    END-EXEC                                                     33550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31844                                                                  
C31844     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
C31844                                           S-RETURN-CODE          
C31844                                                                  
C31844     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C31844        CONTINUE                                                  
C31844     ELSE                                                         
C31844        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C31844        MOVE '7310'                     TO ACTIVE-PARAGRAPH       
C31844        MOVE 'SELECT'                   TO ABEND-FUNCTION         
C31844        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C31844                                           ABEND-TABLES           
C31844        MOVE 'CSS_CODE_VALUE'           TO TABLE-1                
C31844        MOVE 'CODE_VALUE'               TO TABLE-ELEMENT-1        
C31844        MOVE 'TABLE_NA'                 TO TABLE-ELEMENT-2        
C31844        MOVE 'COLUMN_NA'                TO TABLE-ELEMENT-3        
C31844        MOVE 'PROGRAM_ID'               TO TABLE-ELEMENT-4        
C31844        MOVE UV-CODE-VALUE-TEXT         TO HOSTVAR-ELEMENT-1      
C31844        MOVE UV-TABLE-NA-TEXT           TO HOSTVAR-ELEMENT-2      
C31844        MOVE UV-COLUMN-NA-TEXT          TO HOSTVAR-ELEMENT-3      
C31844        MOVE UV-PROGRAM-ID              TO HOSTVAR-ELEMENT-4      
C31844        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C31844        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C31844     END-IF                                                       
C31844     .                                                            
C31844 7310-EXIT.                                                       
C31844     EXIT.                                                        
P00526*                                                                 33821000
P00526*---------------------------------------------------------------* 33822000
P00526*    CHECK IF A PENDING CARD PAYMENT ROW EXISTS.                * 33823000
P00526*---------------------------------------------------------------* 33824000
P00526 7350-VALIDATE-AUTOCARD-PMT.                                      
P00526*                                                                 33825100
P00526     EXEC SQL                                                     
P00526         SELECT TOP(1) PAYMENT_DATE,
              STATUS_CODE                                       
P00526           INTO :PC-PAYMENT-DATE,                                 
P00526                :PC-STATUS-CODE                                   
P00526           FROM CSS_PNDNG_CARD_PMT                                
P00526          WHERE ACCOUNT_NO  = :PC-ACCOUNT-NO                      
P00526            AND PAYMENT_AMT = :PC-PAYMENT-AMT                     
P00526            AND STATUS_CODE = 'E'                                 
P00526          ORDER BY PAYMENT_DATE                                   
P00526                                              
P00641                                                      
P00526     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     33825200
MFA-TR*        SELECT PAYMENT_DATE,                                     33825300
MFA-TR*               STATUS_CODE                                       33825400
MFA-TR*          INTO :PC-PAYMENT-DATE,                                 33825500
MFA-TR*               :PC-STATUS-CODE                                   33825600
MFA-TR*          FROM CSS_PNDNG_CARD_PMT                                33825700
MFA-TR*         WHERE ACCOUNT_NO  = :PC-ACCOUNT-NO                      33825800
MFA-TR*           AND PAYMENT_AMT = :PC-PAYMENT-AMT                     33825900
MFA-TR*           AND STATUS_CODE = 'E'                                 33826000
MFA-TR*         ORDER BY PAYMENT_DATE                                   33826100
MFA-TR*         FETCH FIRST ROW ONLY                                    33826200
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                    33826300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00526                                                                  
P00526     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
P00526                                           S-RETURN-CODE.         
P00526                                                                  
P00526     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00526        CONTINUE                                                  
P00526     ELSE                                                         
P00526        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00526           SET DRAFT-NOT-FOUND          TO TRUE                   
P00526        ELSE                                                      
P00526           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
P00526           MOVE '7350'                  TO ACTIVE-PARAGRAPH       
P00526           MOVE 'SELECT'                TO ABEND-FUNCTION         
P00526           MOVE SPACES                  TO ABEND-SQL-PREDICATES   
P00526                                           ABEND-TABLES           
P00526           MOVE 'CSS_PNDNG_CARD_PMT'    TO TABLE-1                
P00526           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
P00526           MOVE 'PAYMENT_AMT'           TO TABLE-ELEMENT-2        
P00526           MOVE PC-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
P00526           MOVE I-PAYMENT-AMOUNT        TO HOSTVAR-ELEMENT-2      
P00526           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
P00526           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
P00526        END-IF                                                    
P00526     END-IF.                                                      
P00526*                                                                 33828900
P00526 7350-EXIT.                                                       
P00526     EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 33840000
      *    OPEN JOB PARM TABLE CURSOR                                 * 33850000
      *---------------------------------------------------------------* 33860000
                                                                        
       7600-START-FCSJC01.                                              
                                                                        
           EXEC SQL                                                     
               OPEN PARM_CSR                                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1             
              MOVE 'CMND_CODE'           TO TABLE-ELEMENT-2             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE G6-PROGRAM-NAME       TO HOSTVAR-ELEMENT-1           
              MOVE G6-CMND-CODE          TO HOSTVAR-ELEMENT-2           
              MOVE G6-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 34190000
      *     SELECTS FROM JOB PARM TABLE                               * 34200000
      *---------------------------------------------------------------* 34210000
                                                                        
       7610-READ-FCSJC01.                                               
                                                                        
           EXEC SQL                                                     
              FETCH PARM_CSR                                            
               INTO :G6-PROGRAM-NAME                                    
                   ,:G6-COMPANY-NO                                      
                   ,:G6-CMND-CODE                                       
                   ,:G6-SEQ-NO                                          
                   ,:G6-STATUS                                          
                   ,:G6-PARM-DATA                                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE G6-SEQ-NO       TO E-FJC01-SEQ-NBR                  
                                       WS-SEQ-NBR                       
               MOVE G6-PROGRAM-NAME TO E-FJC01-PGRM-NAME                
               MOVE G6-CMND-CODE    TO E-FJC01-CMND-CODE                
               MOVE G6-STATUS       TO E-FJC01-STATUS                   
                                       WS-INPUT-STATUS                  
               MOVE G6-PARM-DATA    TO WS-INPUT-DATA-BREAKDOWN          
                                       E-FJC01-PARAMETER-DATA           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'END' TO WS-SYSIPT                                
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7610'                TO ACTIVE-PARAGRAPH         
                 MOVE 'FETCH'               TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_JOB_PARM'        TO TABLE-1                  
                 MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1          
                 MOVE 'CMND_CODE'           TO TABLE-ELEMENT-2          
                 MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3          
                 MOVE G6-PROGRAM-NAME       TO HOSTVAR-ELEMENT-1        
                 MOVE G6-CMND-CODE          TO HOSTVAR-ELEMENT-2        
                 MOVE G6-COMPANY-NO         TO HOSTVAR-ELEMENT-3        
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF                                                       
           .                                                            
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 34720000
      * CLOSE JOB PARM TABLE CURSOR                                   * 34730000
      *---------------------------------------------------------------* 34740000
                                                                        
       7611-CLOSE.                                                      
                                                                        
           EXEC SQL                                                     
              CLOSE PARM_CSR                                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7611'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1             
              MOVE 'CMND_CODE'           TO TABLE-ELEMENT-2             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE G6-PROGRAM-NAME       TO HOSTVAR-ELEMENT-1           
              MOVE G6-CMND-CODE          TO HOSTVAR-ELEMENT-2           
              MOVE G6-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7611-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 35070000
      *   CHECK SQL RETURN CODE FROM THE COPY CPD00012 WHICH IS USED  * 35080000
      *   COMPUTE THE CALENDAR DATE                                   * 35090000
      *---------------------------------------------------------------* 35100000
                                                                        
       7700-SQL-CODE-CHECK.                                             
                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7700'                 TO ACTIVE-PARAGRAPH           
T34097        MOVE 'SET'                  TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'INPUT DATE IS'        TO TABLE-ELEMENT-1            
              MOVE WS-CCD-START-DATE      TO HOSTVAR-ELEMENT-1          
              MOVE 'INPUT DAYS IS'        TO TABLE-ELEMENT-2            
              MOVE WS-CCD-DAYS-PLUS-MINUS TO HOSTVAR-ELEMENT-2          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04789*---------------------------------------------------------------* 26370000
A04789* ERROR CODE WILL HAVE CREDIT ACTION VALUE. THIS IS SELECTED FOR* 26380000
A04789* DUPLICATE PAYMENTS SO THAT WE DON'T WIPE OUT THIS WHILE       * 26390000
A04789* UPDATING AS DUPLICATE PAYMENT.                                * 26390000
A04789*---------------------------------------------------------------* 26400000
A04789 7750-GET-ERROR-CD.                                               
A04789                                                                  
A04789     EXEC SQL                                                     
A04789       SELECT ERROR_CD                                            
A04789         INTO :JT-ERROR-CD                                        
A04789         FROM CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                     
A04789        WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )            
A04789          AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           
A04789          AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )                
A04789          AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  
A04789                                                           
A04789                                                      
A04789     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     26430000
MFA-TR*      SELECT ERROR_CD                                            26440000
MFA-TR*        INTO :JT-ERROR-CD                                        26450000
MFA-TR*        FROM CSS_PAYMENT_TRANS                                   26460000
MFA-TR*       WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT            26470000
MFA-TR*         AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           26480000
MFA-TR*         AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                26490000
MFA-TR*         AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  26500000
MFA-TR*        WITH UR                                                  26512000
MFA-TR*       QUERYNO 7750                                                      
MFA-TR*    END-EXEC                                                     26520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04789                                                                  
A04789     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
A04789                                                                  
A04789     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04789        CONTINUE                                                  
A04789     ELSE                                                         
A04789        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A04789        MOVE '7750'                     TO ACTIVE-PARAGRAPH       
A04789        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A04789        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A04789                                           ABEND-TABLES           
A04789        MOVE 'CSS_PAYMENT_TRANS'        TO TABLE-1                
A04789        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A04789        MOVE JT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A04789        MOVE 'PYMT_RCVD_TS'             TO TABLE-ELEMENT-2        
A04789        MOVE JT-PYMT-RCVD-TS            TO HOSTVAR-ELEMENT-2      
A04789        MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-3        
A04789        MOVE JT-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3      
A04789        MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4        
A04789        MOVE JT-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4      
A04789        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A04789        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A04789     END-IF                                                       
A04789     .                                                            
A04789 7750-EXIT.                                                       
A04789     EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 35370000
      * CREATES NEW CASH REPORT                                       * 35380000
      *---------------------------------------------------------------* 35390000
                                                                        
       8000-CREATE-NEW-RPT.                                             
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_REPORT_HDR                             
                  (                                                     
                   CASH_COMPANY_NO                                      
                  ,CASH_LOCAL_OFFICE                                    
                  ,DATE_CASH_REPORT                                     
                  ,USER_ID                                              
                  ,STATUS                                               
                  ,CLOSED_TS                                            
                  )                                                     
             VALUES                                                     
                  (                                                     
                   :YR-CASH-COMPANY-NO                                  
                  ,:YR-CASH-LOCAL-OFFICE                                
                  ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
                  ,:YR-USER-ID                                          
                  ,:YR-STATUS                                           
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     35430000
MFA-TR*      INSERT INTO CSS_CSH_REPORT_HDR                             35440000
MFA-TR*           (                                                     35450000
MFA-TR*            CASH_COMPANY_NO                                      35460000
MFA-TR*           ,CASH_LOCAL_OFFICE                                    35470000
MFA-TR*           ,DATE_CASH_REPORT                                     35480000
MFA-TR*           ,USER_ID                                              35490000
MFA-TR*           ,STATUS                                               35500000
MFA-TR*           ,CLOSED_TS                                            35510000
MFA-TR*           )                                                     35520000
MFA-TR*      VALUES                                                     35530000
MFA-TR*           (                                                     35540000
MFA-TR*            :YR-CASH-COMPANY-NO                                  35550000
MFA-TR*           ,:YR-CASH-LOCAL-OFFICE                                35560000
MFA-TR*           ,:YR-DATE-CASH-REPORT                                 35570000
MFA-TR*           ,:YR-USER-ID                                          35580000
MFA-TR*           ,:YR-STATUS                                           35590000
MFA-TR*           ,CURRENT TIMESTAMP                                    35600000
MFA-TR*           )                                                     35610000
MFA-TR*    END-EXEC                                                     35620000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CSH_REPORT_HDR'      TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE YR-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE YR-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-3         
              MOVE YR-USER-ID                TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 35890000
      * CREATES NEW BATCH                                             * 35900000
      *---------------------------------------------------------------* 35910000
                                                                        
       8010-CREATE-NEW-BATCH.                                           
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_DRWR_CNTL                              
                  (                                                     
                   CASH_COMPANY_NO                                      
                  ,CASH_LOCAL_OFFICE                                    
                  ,CASH_REPORT_NO                                       
                  ,DATE_CASH_REPORT                                     
                  ,CASH_DRAWER_ID                                       
                  ,AMT_CASH_DEBIT                                       
                  ,AMT_CASH_CREDIT                                      
                  ,AMT_AR_DEBIT                                         
                  ,AMT_AR_CREDIT                                        
                  ,AMT_CK_ISS_DEBIT                                     
                  ,AMT_CK_ISS_CREDIT                                    
                  ,AMT_GL_DEBIT                                         
                  ,AMT_GL_CREDIT                                        
                  ,AMT_CASH_BEGIN_BAL                                   
                  ,AMT_BASIC_WORK                                       
                  ,USER_ID                                              
                  ,CASHIER_CODE                                         
                  ,CODE_PYMT_FACILITY                                   
                  ,CODE_FCS_EXTRACTED                                   
                  ,CODE_CSH_DRWR_STAT                                   
                  ,DATE_LAST_ACTIVITY                                   
                  ,BALANCED_BY                                          
                  ,BALANCED_TS                                          
                  ,NO_ITEMS_ENTERED                                     
                  )                                                     
           VALUES (                                                     
                   :CS-CASH-COMPANY-NO                                  
                  ,:CS-CASH-LOCAL-OFFICE                                
                  ,:CS-CASH-REPORT-NO                                   
                  ,IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )                         
                  ,:CS-CASH-DRAWER-ID                                   
                  ,:CS-AMT-CASH-DEBIT                                   
                  ,:CS-AMT-CASH-CREDIT                                  
                  ,:CS-AMT-AR-DEBIT                                     
                  ,:CS-AMT-AR-CREDIT                                    
                  ,:CS-AMT-CK-ISS-DEBIT                                 
                  ,:CS-AMT-CK-ISS-CREDIT                                
                  ,:CS-AMT-GL-DEBIT                                     
                  ,:CS-AMT-GL-CREDIT                                    
                  ,:CS-AMT-CASH-BEGIN-BAL                               
                  ,:CS-AMT-BASIC-WORK                                   
                  ,:CS-USER-ID                                          
                  ,:CS-CASHIER-CODE                                     
                  ,:CS-CODE-PYMT-FACILITY                               
                  ,:CS-CODE-FCS-EXTRACTED                               
                  ,:CS-CODE-CSH-DRWR-STAT                               
                  ,IIF(TRY_CONVERT(DATE, :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) )                       
                  ,:CS-BALANCED-BY                                      
                  ,CIS.CHAR2TIMESTAMP(:CS-BALANCED-TS :WS-NULL-IND-12)          
                  ,:CS-NO-ITEMS-ENTERED                                 
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     35950000
MFA-TR*      INSERT INTO CSS_CSH_DRWR_CNTL                              35960000
MFA-TR*           (                                                     35970000
MFA-TR*            CASH_COMPANY_NO                                      35980000
MFA-TR*           ,CASH_LOCAL_OFFICE                                    35990000
MFA-TR*           ,CASH_REPORT_NO                                       36000000
MFA-TR*           ,DATE_CASH_REPORT                                     36010000
MFA-TR*           ,CASH_DRAWER_ID                                       36020000
MFA-TR*           ,AMT_CASH_DEBIT                                       36030000
MFA-TR*           ,AMT_CASH_CREDIT                                      36040000
MFA-TR*           ,AMT_AR_DEBIT                                         36050000
MFA-TR*           ,AMT_AR_CREDIT                                        36060000
MFA-TR*           ,AMT_CK_ISS_DEBIT                                     36070000
MFA-TR*           ,AMT_CK_ISS_CREDIT                                    36080000
MFA-TR*           ,AMT_GL_DEBIT                                         36090000
MFA-TR*           ,AMT_GL_CREDIT                                        36100000
MFA-TR*           ,AMT_CASH_BEGIN_BAL                                   36110000
MFA-TR*           ,AMT_BASIC_WORK                                       36120000
MFA-TR*           ,USER_ID                                              36130000
MFA-TR*           ,CASHIER_CODE                                         36140000
MFA-TR*           ,CODE_PYMT_FACILITY                                   36150000
MFA-TR*           ,CODE_FCS_EXTRACTED                                   36160000
MFA-TR*           ,CODE_CSH_DRWR_STAT                                   36170000
MFA-TR*           ,DATE_LAST_ACTIVITY                                   36180000
MFA-TR*           ,BALANCED_BY                                          36190000
MFA-TR*           ,BALANCED_TS                                          36200000
MFA-TR*           ,NO_ITEMS_ENTERED                                     36210000
MFA-TR*           )                                                     36220000
MFA-TR*    VALUES (                                                     36230000
MFA-TR*            :CS-CASH-COMPANY-NO                                  36240000
MFA-TR*           ,:CS-CASH-LOCAL-OFFICE                                36250000
MFA-TR*           ,:CS-CASH-REPORT-NO                                   36260000
MFA-TR*           ,:CS-DATE-CASH-REPORT                                 36270000
MFA-TR*           ,:CS-CASH-DRAWER-ID                                   36280000
MFA-TR*           ,:CS-AMT-CASH-DEBIT                                   36290000
MFA-TR*           ,:CS-AMT-CASH-CREDIT                                  36300000
MFA-TR*           ,:CS-AMT-AR-DEBIT                                     36310000
MFA-TR*           ,:CS-AMT-AR-CREDIT                                    36320000
MFA-TR*           ,:CS-AMT-CK-ISS-DEBIT                                 36330000
MFA-TR*           ,:CS-AMT-CK-ISS-CREDIT                                36340000
MFA-TR*           ,:CS-AMT-GL-DEBIT                                     36350000
MFA-TR*           ,:CS-AMT-GL-CREDIT                                    36360000
MFA-TR*           ,:CS-AMT-CASH-BEGIN-BAL                               36370000
MFA-TR*           ,:CS-AMT-BASIC-WORK                                   36380000
MFA-TR*           ,:CS-USER-ID                                          36390000
MFA-TR*           ,:CS-CASHIER-CODE                                     36400000
MFA-TR*           ,:CS-CODE-PYMT-FACILITY                               36410000
MFA-TR*           ,:CS-CODE-FCS-EXTRACTED                               36420000
MFA-TR*           ,:CS-CODE-CSH-DRWR-STAT                               36430000
MFA-TR*           ,:CS-DATE-LAST-ACTIVITY                               36440000
MFA-TR*           ,:CS-BALANCED-BY                                      36450000
MFA-TR*           ,:CS-BALANCED-TS:WS-NULL-IND-12                       36460000
MFA-TR*           ,:CS-NO-ITEMS-ENTERED                                 36470000
MFA-TR*           )                                                     36480000
MFA-TR*    END-EXEC                                                     36490000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CSH_DRWR_CNTL'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE 'CASH_DRAWER_ID'          TO TABLE-ELEMENT-3         
              MOVE 'CODE_CSH_DRWR_STAT'      TO TABLE-ELEMENT-4         
              MOVE CS-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE CS-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE CS-CASH-DRAWER-ID         TO HOSTVAR-ELEMENT-3       
              MOVE CS-CODE-CSH-DRWR-STAT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 36780000
      * INSERTS PAYMENT TRANSACTION IN CSS_PAYMENT_TRANS TABLE        * 36790000
      *---------------------------------------------------------------* 36800000
                                                                        
       8020-INSERT-PAYMENT.                                             
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_PAYMENT_TRANS                              
                  (                                                     
                   DATE_CASH_REPORT                                     
                  ,CASH_LOCAL_OFFICE                                    
                  ,PYMT_RCVD_TS                                         
                  ,ACCOUNT_NO                                           
                  ,APPL_PROGRAM_ID                                      
                  ,APPLIED_FL                                           
                  ,COMPANY_NO                                           
                  ,CREDIT_CARD_TYPE                                     
                  ,CURRENCY_TYPE                                        
                  ,CUST_PHONE_NO                                        
                  ,DIRECTED_PYMT_CD                                     
                  ,ERROR_CD                                             
                  ,PAYMENT_AMT                                          
                  ,PYMT_CONFIRM_NO                                      
                  ,PYMT_FACILITY_CD                                     
                  ,LAST_UPDATE_USERID                                   
                  ,ORIG_PYMT_TS                                         
                  ,RECONCILED_FL                                        
                  ,TRANS_HIST_SEQ_NO                                    
                  ,TRANS_TYPE_CD                                        
                  )                                                     
             VALUES                                                     
                  (                                                     
                   IIF(TRY_CONVERT(DATE, :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )                         
                  ,:JT-CASH-LOCAL-OFFICE                                
                  ,CIS.CHAR2TIMESTAMP(:JT-PYMT-RCVD-TS)                         
                  ,:JT-ACCOUNT-NO                                       
                  ,:JT-APPL-PROGRAM-ID                                  
                  ,:JT-APPLIED-FL                                       
                  ,:JT-COMPANY-NO                                       
                  ,:JT-CREDIT-CARD-TYPE                                 
                  ,:JT-CURRENCY-TYPE                                    
                  ,:JT-CUST-PHONE-NO                                    
                  ,:JT-DIRECTED-PYMT-CD                                 
                  ,:JT-ERROR-CD                                         
                  ,:JT-PAYMENT-AMT                                      
                  ,:JT-PYMT-CONFIRM-NO                                  
                  ,:JT-PYMT-FACILITY-CD                                 
                  ,:JT-LAST-UPDATE-USERID                               
APS               ,NULL                                                 
APS               ,'N'                                                  
APS               ,NULL                                                 
APS               ,'P'                                                  
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     36840000
MFA-TR*      INSERT INTO CSS_PAYMENT_TRANS                              36850000
MFA-TR*           (                                                     36860000
MFA-TR*            DATE_CASH_REPORT                                     36870000
MFA-TR*           ,CASH_LOCAL_OFFICE                                    36880000
MFA-TR*           ,PYMT_RCVD_TS                                         36890000
MFA-TR*           ,ACCOUNT_NO                                           36900000
MFA-TR*           ,APPL_PROGRAM_ID                                      36910000
MFA-TR*           ,APPLIED_FL                                           36920000
MFA-TR*           ,COMPANY_NO                                           36930000
MFA-TR*           ,CREDIT_CARD_TYPE                                     36940000
MFA-TR*           ,CURRENCY_TYPE                                        36950000
MFA-TR*           ,CUST_PHONE_NO                                        36960000
MFA-TR*           ,DIRECTED_PYMT_CD                                     36970000
MFA-TR*           ,ERROR_CD                                             36980000
MFA-TR*           ,PAYMENT_AMT                                          36990000
MFA-TR*           ,PYMT_CONFIRM_NO                                      37000000
MFA-TR*           ,PYMT_FACILITY_CD                                     37010000
MFA-TR*           ,LAST_UPDATE_USERID                                   37020000
MFA-TR*           ,ORIG_PYMT_TS                                         37030000
MFA-TR*           ,RECONCILED_FL                                        37040000
MFA-TR*           ,TRANS_HIST_SEQ_NO                                    37050000
MFA-TR*           ,TRANS_TYPE_CD                                        37060000
MFA-TR*           )                                                     37070000
MFA-TR*      VALUES                                                     37080000
MFA-TR*           (                                                     37090000
MFA-TR*            :JT-DATE-CASH-REPORT                                 37100000
MFA-TR*           ,:JT-CASH-LOCAL-OFFICE                                37110000
MFA-TR*           ,:JT-PYMT-RCVD-TS                                     37120000
MFA-TR*           ,:JT-ACCOUNT-NO                                       37130000
MFA-TR*           ,:JT-APPL-PROGRAM-ID                                  37140000
MFA-TR*           ,:JT-APPLIED-FL                                       37150000
MFA-TR*           ,:JT-COMPANY-NO                                       37160000
MFA-TR*           ,:JT-CREDIT-CARD-TYPE                                 37170000
MFA-TR*           ,:JT-CURRENCY-TYPE                                    37180000
MFA-TR*           ,:JT-CUST-PHONE-NO                                    37190000
MFA-TR*           ,:JT-DIRECTED-PYMT-CD                                 37200000
MFA-TR*           ,:JT-ERROR-CD                                         37210000
MFA-TR*           ,:JT-PAYMENT-AMT                                      37220000
MFA-TR*           ,:JT-PYMT-CONFIRM-NO                                  37230000
MFA-TR*           ,:JT-PYMT-FACILITY-CD                                 37240000
MFA-TR*           ,:JT-LAST-UPDATE-USERID                               37250000
MFA-TR*           ,NULL                                                 37260000
MFA-TR*           ,'N'                                                  37270000
MFA-TR*           ,NULL                                                 37280000
MFA-TR*           ,'P'                                                  37290000
MFA-TR*           )                                                     37300000
MFA-TR*    END-EXEC                                                     37310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
              IF WS-ACTIVE-RETURN-CODE =  -803                          
                 SET DUPLICATE-PAYMENT       TO TRUE                    
              END-IF                                                    
C31844*       SET PAYMENT-INSERTED TO TRUE                              37400000
           ELSE                                                         
C31844*       MOVE +2000 TO S-RETURN-CODE                               37420000
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PAYMENT_TRANS'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE JT-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE JT-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE 'PYMT_RCVD_TS'            TO TABLE-ELEMENT-3         
              MOVE JT-PYMT-RCVD-TS           TO HOSTVAR-ELEMENT-3       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE JT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 37640000
      * INSERTS A ROW IN CSS_SO_DNP_CANCEL                            * 37650000
      *---------------------------------------------------------------* 37660000
                                                                        
      *---------------------------------------------------------------* 38080000
      * UPDATES A PAYMENT RECORD AS POSTED IN CSS_PAYMENT_TRANS       * 38090000
      *---------------------------------------------------------------* 38100000
                                                                        
       8050-UPDATE-PYMT-TRANS.                                          
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_PAYMENT_TRANS                                   
                SET APPLIED_FL         = :JT-APPLIED-FL                 
                   ,APPLIED_TS         = CIS.CURRENT$TIMESTAMP()              
                   ,LAST_UPDATE_USERID = :JT-LAST-UPDATE-USERID         
APS                ,TRANS_HIST_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                  :JT-TRANS-HIST-SEQ-NO
              )          
              WHERE DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )           
                AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE          
                AND PYMT_RCVD_TS       = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
                AND ACCOUNT_NO         = :JT-ACCOUNT-NO                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     38140000
MFA-TR*      UPDATE CSS_PAYMENT_TRANS                                   38150000
MFA-TR*         SET APPLIED_FL         = :JT-APPLIED-FL                 38160000
MFA-TR*            ,APPLIED_TS         = CURRENT TIMESTAMP              38170000
MFA-TR*            ,LAST_UPDATE_USERID = :JT-LAST-UPDATE-USERID         38180000
MFA-TR*            ,TRANS_HIST_SEQ_NO  = :JT-TRANS-HIST-SEQ-NO          38190000
MFA-TR*       WHERE DATE_CASH_REPORT   = :JT-DATE-CASH-REPORT           38200000
MFA-TR*         AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE          38210000
MFA-TR*         AND PYMT_RCVD_TS       = :JT-PYMT-RCVD-TS               38220000
MFA-TR*         AND ACCOUNT_NO         = :JT-ACCOUNT-NO                 38230000
MFA-TR*    END-EXEC                                                     38240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PAYMENT_TRANS'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE JT-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE JT-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE 'PYMT_RCVD_TS'            TO TABLE-ELEMENT-3         
              MOVE JT-PYMT-RCVD-TS           TO HOSTVAR-ELEMENT-3       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE JT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29529*---------------------------------------------------------------* 38530000
C29529* SELECTS CUST-BANK-SEQ-NO FROM PENDING BANK DRAFT FO INSERT    * 38540000
C29529*   INTO AR-TRANS-HIST                                          * 38550000
C29529*---------------------------------------------------------------* 38560000
C29529 8054-SELECT-PND-BNK-DRFT.                                        
C29529                                                                  
C29529     MOVE I-ACCOUNT-NO TO PB-ACCOUNT-NO                           
C29529     MOVE I-TIMESTAMP  TO PB-PYMT-TRANS-TS                        
                                                                        
C29529     EXEC SQL                                                     
C29529       SELECT CUST_BANK_SEQ_NO,                                   
C29529              PYMT_POSTED_FL                                      
C29529         INTO :PB-CUST-BANK-SEQ-NO,                               
C29529              :PB-PYMT-POSTED-FL                                  
C29529         FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                    
C29529        WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                        
C29529          AND PYMT_TRANS_TS = CIS.CHAR2TIMESTAMP(:PB-PYMT-TRANS-TS
              )                  
C33928                                                           
P00641                                                      
C29529     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     38620000
MFA-TR*      SELECT CUST_BANK_SEQ_NO,                                   38630000
MFA-TR*             PYMT_POSTED_FL                                      38640000
MFA-TR*        INTO :PB-CUST-BANK-SEQ-NO,                               38650000
MFA-TR*             :PB-PYMT-POSTED-FL                                  38660000
MFA-TR*        FROM CSS_PNDNG_BNK_DRFT                                  38670000
MFA-TR*       WHERE ACCOUNT_NO = : PB-ACCOUNT-NO                        38680000
MFA-TR*         AND PYMT_TRANS_TS = : PB-PYMT-TRANS-TS                  38690000
MFA-TR*        WITH UR                                                  38691000
MFA-TR*       QUERYNO 8054                                                      
MFA-TR*    END-EXEC                                                     38700000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C29529                     S-RETURN-CODE                                
                                                                        
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33486*       IF PB-PYMT-POSTED-FL = 'Y'                                38760000
C33486*          PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          38770000
C33486*       END-IF                                                    38780000
C33486        CONTINUE                                                  
C29529     ELSE                                                         
C31844*       MOVE +2000 TO S-RETURN-CODE                               38800000
C31844*                     WS-ACTIVE-RETURN-CODE                       38810000
C29529        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C29529        MOVE '8054'                    TO ACTIVE-PARAGRAPH        
C29529        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C29529        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C29529                                          ABEND-TABLES            
C29529        MOVE 'CSS_PNDNG_BNK_DRFT'      TO TABLE-1                 
C29529        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
C29529        MOVE PB-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
C29529        MOVE 'PYMT_TRANS_TS'           TO TABLE-ELEMENT-2         
C29529        MOVE PB-PYMT-TRANS-TS          TO HOSTVAR-ELEMENT-2       
C29529        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29529        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29529     END-IF                                                       
C29529     .                                                            
                                                                        
C29529 8054-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529*---------------------------------------------------------------* 39000000
C29529* UPDATES PYMT-POSTED-FL TO 'Y' IN CSS_PNDNG_BNK_DRFT SINCE     * 39010000
C29529*   PAYMENT HAS BEEN SUCCESSFULLY POSTED AT THIS POINT          * 39020000
C29529*---------------------------------------------------------------* 39030000
C29529 8055-UPDATE-PYMT-POSTED.                                         
C29529                                                                  
C31844     MOVE I-ACCOUNT-NO TO PB-ACCOUNT-NO                           
C31844     MOVE I-TIMESTAMP  TO PB-PYMT-TRANS-TS                        
                                                                        
C29529     EXEC SQL                                                     
C29529       UPDATE CSS_PNDNG_BNK_DRFT                                  
C29529          SET PYMT_POSTED_FL = 'Y'                                
C29529        WHERE ACCOUNT_NO     = :PB-ACCOUNT-NO                    
C29529          AND PYMT_TRANS_TS  = CIS.CHAR2TIMESTAMP(
                                                      :PB-PYMT-TRANS-TS
              )                 
C31844          AND PYMT_POSTED_FL = 'N'                                
C29529     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     39090000
MFA-TR*      UPDATE CSS_PNDNG_BNK_DRFT                                  39100000
MFA-TR*         SET PYMT_POSTED_FL = 'Y'                                39110000
MFA-TR*       WHERE ACCOUNT_NO     = : PB-ACCOUNT-NO                    39120000
MFA-TR*         AND PYMT_TRANS_TS  = : PB-PYMT-TRANS-TS                 39130000
MFA-TR*         AND PYMT_POSTED_FL = 'N'                                39140000
MFA-TR*    END-EXEC                                                     39150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C29529                     S-RETURN-CODE                                
                                                                        
C31844*    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   39200000
C31844     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C31844        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C31844           SET DRAFT-NOT-FOUND TO TRUE                            
C31844        END-IF                                                    
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C29529        MOVE '8055'                    TO ACTIVE-PARAGRAPH        
C29529        MOVE 'UPDATE'                  TO ABEND-FUNCTION          
C29529        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C29529                                          ABEND-TABLES            
C29529        MOVE 'CSS_PNDNG_BNK_DRFT'      TO TABLE-1                 
C29529        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
C29529        MOVE PB-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
C29529        MOVE 'PYMT_TRANS_TS'           TO TABLE-ELEMENT-2         
C29529        MOVE PB-PYMT-TRANS-TS          TO HOSTVAR-ELEMENT-2       
C29529        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29529        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29529     END-IF                                                       
C29529     .                                                            
                                                                        
C29529 8055-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529*---------------------------------------------------------------* 39440000
C29529* UPDATES CUST_BANK_SEQ_NO IN CSS_AR_TRANS_HIST                 * 39450000
C29529*---------------------------------------------------------------* 39460000
C29529 8056-UPDATE-AR-TRANS.                                            
                                                                        
C29529     PERFORM 7200-GET-CURRENT-DATE        THRU 7200-EXIT          
C29529     PERFORM 7201-GET-CURR-DATE-MINUS-ONE THRU 7201-EXIT          
C29529     MOVE WS-YESTERDAY        TO WS-CURRENT-DATE-FROM             
C29529     MOVE WS-CURRENT-DATE     TO WS-CURRENT-DATE-TO               
C29529     MOVE WS-CURRENT-TS-FROM  TO WS-CURRENT-TS-FROM-DB2           
C29529     MOVE WS-CURRENT-TS-TO    TO WS-CURRENT-TS-TO-DB2             
                                                                        
C29529     MOVE PB-CUST-BANK-SEQ-NO TO AR-CUST-BANK-SEQ-NO              
C29529     MOVE I-ACCOUNT-NO        TO AR-ACCOUNT-NO                    
                                                                        
C29529     IF AR-ACCOUNT-NO = AT-ACCOUNT-NO                             
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C29529        MOVE AT-ACCOUNT-NO TO AR-ACCOUNT-NO                       
C29529     END-IF                                                       
C33486     MOVE I-TIMESTAMP         TO AR-TRANS-HIST-SEQ-NO             
                                                                        
                                                                        
C29529     EXEC SQL                                                     
C29529          UPDATE CSS_AR_TRANS_HIST                                
C29529             SET CUST_BANK_SEQ_NO = :AR-CUST-BANK-SEQ-NO          
C29529           WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                      
C29529             AND TRANS_HIST_SEQ_NO  =                             
C29529                 (SELECT MAX(TRANS_HIST_SEQ_NO)                   
C29529                    FROM CSS_AR_TRANS_HIST                        
C29529                   WHERE ACCOUNT_NO = :AR-ACCOUNT-NO              
C33486                     AND TRANS_HIST_SEQ_NO > CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )
C29529                     AND CODE_TRAN_TYPE = 'P')                    
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     39650000
MFA-TR*         UPDATE CSS_AR_TRANS_HIST                                39660000
MFA-TR*            SET CUST_BANK_SEQ_NO = :AR-CUST-BANK-SEQ-NO          39670000
MFA-TR*          WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                      39680000
MFA-TR*            AND TRANS_HIST_SEQ_NO  =                             39690000
MFA-TR*                (SELECT MAX(TRANS_HIST_SEQ_NO)                   39700000
MFA-TR*                   FROM CSS_AR_TRANS_HIST                        39710000
MFA-TR*                  WHERE ACCOUNT_NO = :AR-ACCOUNT-NO              39720000
MFA-TR*                    AND TRANS_HIST_SEQ_NO > :AR-TRANS-HIST-SEQ-NO39721000
MFA-TR*                    AND CODE_TRAN_TYPE = 'P')                    39760000
MFA-TR*    END-EXEC.                                                    39770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C29529                     S-RETURN-CODE                                
                                                                        
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C29529        MOVE '8056'                    TO ACTIVE-PARAGRAPH        
C29529        MOVE 'UPDATE'                  TO ABEND-FUNCTION          
C29529        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C29529                                          ABEND-TABLES            
C29529        MOVE 'AR_TRANS_HIST'           TO TABLE-1                 
C29529        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
C29529        MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
C29529        MOVE 'AR_TRANS_HIST_SEQ_NO'    TO TABLE-ELEMENT-2         
C29529        MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
C29529        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29529        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29529     END-IF                                                       
C29529     .                                                            
                                                                        
C29529 8056-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 40030000
      * SELECT DATE FROM CSS_JOB_PARM FOR E-PAY PAYMENTS              * 40040000
      *---------------------------------------------------------------* 40050000
C29529 8057-SELECT-I-REPORT-DATE.                                       
C29529                                                                  
C29529     EXEC SQL                                                     
C29529        SELECT PARM_DATA                                          
C29529          INTO :I-REPORT-DATE                                     
C29529          FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
C29529         WHERE PROGRAM_NAME = 'EPAYCURRDT'                        
C33928           AND COMPANY_NO   = '01'                                
C29529           AND CMND_CODE    = 'DATE'                              
C29529           AND SEQ_NO       = 10                                  
C33928                                                           
P00641                                                      
C29529     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     40080000
MFA-TR*       SELECT PARM_DATA                                          40090000
MFA-TR*         INTO :I-REPORT-DATE                                     40100000
MFA-TR*         FROM CSS_JOB_PARM                                       40110000
MFA-TR*        WHERE PROGRAM_NAME = 'EPAYCURRDT'                        40120000
MFA-TR*          AND COMPANY_NO   = '01'                                40121000
MFA-TR*          AND CMND_CODE    = 'DATE'                              40130000
MFA-TR*          AND SEQ_NO       = 10                                  40140000
MFA-TR*         WITH UR                                                 40141000
MFA-TR*       QUERYNO 8057                                                      
MFA-TR*    END-EXEC                                                     40150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C29529                     S-RETURN-CODE                                
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C31844*       MOVE +2000 TO S-RETURN-CODE                               40230000
C31844*                     WS-ACTIVE-RETURN-CODE                       40240000
C29529        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C29529        MOVE '8057'                    TO ACTIVE-PARAGRAPH        
C29529        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C29529        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C29529                                         ABEND-TABLES             
C29529        MOVE 'CSS_JOB_PARM'            TO TABLE-1                 
C29529        MOVE 'EPAYCURRDT'              TO HOSTVAR-ELEMENT-1       
C29529        MOVE 'PROGRAM_NAME'            TO TABLE-ELEMENT-1         
C29529        MOVE 'DATE'                    TO HOSTVAR-ELEMENT-2       
C29529        MOVE 'CMND_CODE'               TO TABLE-ELEMENT-2         
C29529        MOVE 10                        TO HOSTVAR-ELEMENT-3       
C29529        MOVE 'SEQ_NO'                  TO TABLE-ELEMENT-3         
C29529        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29529        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29529     END-IF                                                       
           .                                                            
C29529 8057-EXIT.                                                       
           EXIT.                                                        
      *---------------------------------------------------------------* 40430000
      * UPDATES A PAYMENT RECORD AS ERROR IN CSS_PAYMENT_TRANS TABLE  * 40440000
      *---------------------------------------------------------------* 40450000
                                                                        
       8060-UPDATE-ERROR-CD.                                            
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_PAYMENT_TRANS                                   
                SET ERROR_CD           = :JT-ERROR-CD                   
                   ,LAST_UPDATE_USERID = :JT-LAST-UPDATE-USERID         
              WHERE DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )           
                AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE          
                AND PYMT_RCVD_TS       = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
                AND ACCOUNT_NO         = :JT-ACCOUNT-NO                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     40490000
MFA-TR*      UPDATE CSS_PAYMENT_TRANS                                   40500000
MFA-TR*         SET ERROR_CD           = :JT-ERROR-CD                   40510000
MFA-TR*            ,LAST_UPDATE_USERID = :JT-LAST-UPDATE-USERID         40520000
MFA-TR*       WHERE DATE_CASH_REPORT   = :JT-DATE-CASH-REPORT           40530000
MFA-TR*         AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE          40540000
MFA-TR*         AND PYMT_RCVD_TS       = :JT-PYMT-RCVD-TS               40550000
MFA-TR*         AND ACCOUNT_NO         = :JT-ACCOUNT-NO                 40560000
MFA-TR*    END-EXEC                                                     40570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PAYMENT_TRANS'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE JT-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE JT-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE 'PYMT_RCVD_TS'            TO TABLE-ELEMENT-3         
              MOVE JT-PYMT-RCVD-TS           TO HOSTVAR-ELEMENT-3       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE JT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*40860000
      * INSERTS OVER/SHORT IN OVERSHORT HEADER TABLE                   *40870000
      *----------------------------------------------------------------*40880000
                                                                        
       8070-INSERT-OVERSHORT.                                           
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_OVERSHORT_HDR                           
                       (                                                
                        CASH_COMPANY_NO                                 
                       ,CASH_LOCAL_OFFICE                               
                       ,DATE_CASH_REPORT                                
                       ,CASH_DRAWER_ID                                  
                       ,USER_ID                                         
                       ,OVERSHORT_ID                                    
                       ,TRAN_TS                                         
                       ,OVERSHORT_AMT                                   
                       ,OVERSHORT_DR_CR                                 
                       ,OFST_OVERSHORT_AMT                              
                       ,OFST_DR_CR                                      
                       ,GL_ACCT_NO                                      
                       ,LAST_UPDATE_TS                                  
                       ,OVERSHORT_TYPE_CD                               
                       ,OVERSHORT_SOLTN_FL                              
                       ,TRAN_COMMENT                                    
                       ,ACCOUNT_NO                                      
                       )                                                
                VALUES                                                  
                       (                                                
                        :OH-CASH-COMPANY-NO                             
                       ,:OH-CASH-LOCAL-OFFICE                           
                       ,IIF(TRY_CONVERT(DATE, :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )                         
                       ,:OH-CASH-DRAWER-ID                              
                       ,:OH-USER-ID                                     
                       ,:OH-OVERSHORT-ID                                
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:OH-OVERSHORT-AMT                               
                       ,:OH-OVERSHORT-DR-CR                             
                       ,:OH-OFST-OVERSHORT-AMT                          
                       ,:OH-OFST-DR-CR                                  
                       ,:OH-GL-ACCT-NO                                  
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:OH-OVERSHORT-TYPE-CD                           
                       ,:OH-OVERSHORT-SOLTN-FL                          
                       ,:OH-TRAN-COMMENT                                
                       ,:OH-ACCOUNT-NO                                  
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     40920000
MFA-TR*         INSERT INTO CSS_OVERSHORT_HDR                           40930000
MFA-TR*                (                                                40940000
MFA-TR*                 CASH_COMPANY_NO                                 40950000
MFA-TR*                ,CASH_LOCAL_OFFICE                               40960000
MFA-TR*                ,DATE_CASH_REPORT                                40970000
MFA-TR*                ,CASH_DRAWER_ID                                  40980000
MFA-TR*                ,USER_ID                                         40990000
MFA-TR*                ,OVERSHORT_ID                                    41000000
MFA-TR*                ,TRAN_TS                                         41010000
MFA-TR*                ,OVERSHORT_AMT                                   41020000
MFA-TR*                ,OVERSHORT_DR_CR                                 41030000
MFA-TR*                ,OFST_OVERSHORT_AMT                              41040000
MFA-TR*                ,OFST_DR_CR                                      41050000
MFA-TR*                ,GL_ACCT_NO                                      41060000
MFA-TR*                ,LAST_UPDATE_TS                                  41070000
MFA-TR*                ,OVERSHORT_TYPE_CD                               41080000
MFA-TR*                ,OVERSHORT_SOLTN_FL                              41090000
MFA-TR*                ,TRAN_COMMENT                                    41100000
MFA-TR*                ,ACCOUNT_NO                                      41110000
MFA-TR*                )                                                41120000
MFA-TR*         VALUES                                                  41130000
MFA-TR*                (                                                41140000
MFA-TR*                 :OH-CASH-COMPANY-NO                             41150000
MFA-TR*                ,:OH-CASH-LOCAL-OFFICE                           41160000
MFA-TR*                ,:OH-DATE-CASH-REPORT                            41170000
MFA-TR*                ,:OH-CASH-DRAWER-ID                              41180000
MFA-TR*                ,:OH-USER-ID                                     41190000
MFA-TR*                ,:OH-OVERSHORT-ID                                41200000
MFA-TR*                ,CURRENT TIMESTAMP                               41210000
MFA-TR*                ,:OH-OVERSHORT-AMT                               41220000
MFA-TR*                ,:OH-OVERSHORT-DR-CR                             41230000
MFA-TR*                ,:OH-OFST-OVERSHORT-AMT                          41240000
MFA-TR*                ,:OH-OFST-DR-CR                                  41250000
MFA-TR*                ,:OH-GL-ACCT-NO                                  41260000
MFA-TR*                ,CURRENT TIMESTAMP                               41270000
MFA-TR*                ,:OH-OVERSHORT-TYPE-CD                           41280000
MFA-TR*                ,:OH-OVERSHORT-SOLTN-FL                          41290000
MFA-TR*                ,:OH-TRAN-COMMENT                                41300000
MFA-TR*                ,:OH-ACCOUNT-NO                                  41310000
MFA-TR*                )                                                41320000
MFA-TR*    END-EXEC                                                     41330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_OVERSHORT_HDR'       TO TABLE-1                 
              MOVE 'CASH_COMPANY_NO'         TO TABLE-ELEMENT-1         
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-2         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-3         
              MOVE 'CASH_DRAWER_ID'          TO TABLE-ELEMENT-4         
              MOVE OH-CASH-COMPANY-NO        TO HOSTVAR-ELEMENT-1       
              MOVE OH-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-2       
              MOVE OH-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-3       
              MOVE OH-CASH-DRAWER-ID         TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*41620000
      * UPDATES OVERSHORT AMOUNT IN OVERSHORT HEADER TABLE             *41630000
      *----------------------------------------------------------------*41640000
                                                                        
       8080-UPDATE-OVERSHORT.                                           
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_OVERSHORT_HDR                                   
                SET OVERSHORT_AMT     = :OH-OVERSHORT-AMT               
                   ,OVERSHORT_DR_CR   = :OH-OVERSHORT-DR-CR             
                   ,LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()               
              WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE           
                AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )            
                AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID              
                AND OVERSHORT_ID      = :OH-OVERSHORT-ID                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     41680000
MFA-TR*      UPDATE CSS_OVERSHORT_HDR                                   41690000
MFA-TR*         SET OVERSHORT_AMT     = :OH-OVERSHORT-AMT               41700000
MFA-TR*            ,OVERSHORT_DR_CR   = :OH-OVERSHORT-DR-CR             41710000
MFA-TR*            ,LAST_UPDATE_TS    = CURRENT TIMESTAMP               41720000
MFA-TR*       WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO             41730000
MFA-TR*         AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE           41740000
MFA-TR*         AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT            41750000
MFA-TR*         AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID              41760000
MFA-TR*         AND OVERSHORT_ID      = :OH-OVERSHORT-ID                41770000
MFA-TR*    END-EXEC                                                     41780000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8080'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_OVERSHORT_HDR'       TO TABLE-1                 
              MOVE 'CASH_COMPANY_NO'         TO TABLE-ELEMENT-1         
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-2         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-3         
              MOVE 'CASH_DRAWER_ID'          TO TABLE-ELEMENT-4         
              MOVE OH-CASH-COMPANY-NO        TO HOSTVAR-ELEMENT-1       
              MOVE OH-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-2       
              MOVE OH-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-3       
              MOVE OH-CASH-DRAWER-ID         TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 42070000
      * UPDATES A ROW IN CSS_SO_DNP_CANCEL                            * 42080000
      *---------------------------------------------------------------* 42090000
                                                                        
                                                                        
A00575*---------------------------------------------------------------* 42411000
A00575* UPDATES ERROR CODE WITH CANCEL DNP FLAG INDICATOR VALUE       * 42412000
      *---------------------------------------------------------------* 42413000
                                                                        
       8100-UPDATE-DNP-CODE.                                            
                                                                        
           MOVE 'Y' TO JT-ERROR-CD(2:1)                                 
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_PAYMENT_TRANS                                   
                SET ERROR_CD = :JT-ERROR-CD                             
              WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )            
                AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           
                AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )                
                AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42416000
MFA-TR*      UPDATE CSS_PAYMENT_TRANS                                   42417000
MFA-TR*         SET ERROR_CD = :JT-ERROR-CD                             42418000
MFA-TR*       WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT            42419500
MFA-TR*         AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           42419600
MFA-TR*         AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                42419700
MFA-TR*         AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  42419800
MFA-TR*    END-EXEC                                                     42420100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PAYMENT_TRANS'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE JT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'PYMT_RCVD_TS'             TO TABLE-ELEMENT-2        
              MOVE JT-PYMT-RCVD-TS            TO HOSTVAR-ELEMENT-2      
              MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-3        
              MOVE JT-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3      
              MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4        
              MOVE JT-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
A00575 8100-EXIT.                                                       
A00575     EXIT.                                                        
P00526*                                                                 42423100
P00526*---------------------------------------------------------------* 42423200
P00526* 8150-UPDATE-PNDNG-CARD-PMT.                                   * 42423300
P00526* UPDATE PNDNG-CARD-PMT TO POSTED.                              * 42423400
P00526*---------------------------------------------------------------* 42423500
P00526 8150-UPDATE-PNDNG-CARD-PMT.                                      
P00526     EXEC SQL                                                     
P00526         UPDATE CSS_PNDNG_CARD_PMT                                
P00526            SET STATUS_CODE = 'P',                                
P00526                PYMT_POSTED_TS = CIS.CURRENT$TIMESTAMP()                
P00526          WHERE ACCOUNT_NO   = :PC-ACCOUNT-NO                     
P00526            AND PAYMENT_DATE = IIF(TRY_CONVERT(DATE, 
                                                       :PC-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PC-PAYMENT-DATE
              ) <> 0) OR (LEN(:PC-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :PC-PAYMENT-DATE
              ), CONVERT(DATE, :PC-PAYMENT-DATE) )                   
P00526            AND PAYMENT_AMT  = :PC-PAYMENT-AMT                    
P00526            AND STATUS_CODE  = 'E'                                
P00526     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42423700
MFA-TR*        UPDATE CSS_PNDNG_CARD_PMT                                42423800
MFA-TR*           SET STATUS_CODE = 'P',                                42423900
MFA-TR*               PYMT_POSTED_TS = CURRENT TIMESTAMP                42424000
MFA-TR*         WHERE ACCOUNT_NO   = :PC-ACCOUNT-NO                     42424100
MFA-TR*           AND PAYMENT_DATE = :PC-PAYMENT-DATE                   42424200
MFA-TR*           AND PAYMENT_AMT  = :PC-PAYMENT-AMT                    42424300
MFA-TR*           AND STATUS_CODE  = 'E'                                42424400
MFA-TR*    END-EXEC.                                                    42424500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00526*                                                                 42424600
P00526     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00526     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00526        CONTINUE                                                  
P00526     ELSE                                                         
P00526        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00526        MOVE '8150'                     TO ACTIVE-PARAGRAPH       
P00526        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
P00526        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00526                                           ABEND-TABLES           
P00526        MOVE 'CSS_PNDNG_CARD_PMT'       TO TABLE-1                
P00526        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00526        MOVE 'PAYMENT_AMT'              TO TABLE-ELEMENT-2        
P00526        MOVE 'PAYMENT_DATE'             TO TABLE-ELEMENT-3        
P00526        MOVE PC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00526        MOVE I-PAYMENT-AMOUNT           TO HOSTVAR-ELEMENT-2      
P00526        MOVE PC-PAYMENT-DATE            TO HOSTVAR-ELEMENT-3      
P00526        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00526        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00526     END-IF.                                                      
P00526 8150-EXIT.                                                       
P00526     EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 42429800
      *   OPEN THE RESULT SET CURSOR                                  * 42430000
      *---------------------------------------------------------------* 42440000
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
           .                                                            
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 42550000
      * COMMIT DB2 SO THAT IT WILL STORE THE PAYMENT IN TABLE         * 42560000
      *---------------------------------------------------------------* 42570000
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                     42610000
              INCLUDE CPD00047                                          42620000
           END-EXEC                                                     42630000
           .                                                            42640000
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 42680000
      * SENDS ERROR RESULT                                            * 42690000
      *---------------------------------------------------------------* 42700000
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE                  
C31844* if error occurs return 5000 always for e-payment                42760000
C31844     IF JT-APPL-PROGRAM-ID = WS-EPAY-APPL-ID                      
C31844        MOVE 5000               TO S-RETURN-CODE                  
C31844     END-IF                                                       
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF                                                       
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 43010000
      * CALLS MCSCO061                                                * 43020000
      *---------------------------------------------------------------* 43030000
                                                                        
       9400-CALL-CPD00061.                                              
                                                                        
           CALL MCSCO061  USING   wS-GL-ACCT-NAME,                      
                                  WS-GL-ACCT-MAJOR-FIELDS,              
                                  WS-VALID-COMPANY-NOS,                 
                                  WS-GL-NAME-INFO,                      
                                  WS-GL-ACCT-NO-TABLE,                  
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE                        
                                                                        
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE              
                                             SQLCODE                    
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                  TO S-RETURN-CODE,             
                                             WS-ACTIVE-RETURN-CODE      
              END-IF                                                    
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       9400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 43310000
      * CALLS MCSCB068                                                * 43320000
      *---------------------------------------------------------------* 43330000
                                                                        
                                                                        
C35842*---------------------------------------------------------------* 43580100
ACT285* CALLS MCS03414                                                * 43580200
C35842*---------------------------------------------------------------* 43580300
ACT285 9800-CALL-MCS03414.                                              
C35842                                                                  
ACT285     CALL MCS03414 USING   WS-ACCOUNT-NO-NUM                      
C35842                          ,WS-UPDATE-ACTION-FL                    
C35842                          ,I-PYMT-FACILITY-CD                     
C35842                          ,WS-DNP-RET-CODE                        
ACT285                          ,WS-PYMT-AMOUNT                         
ACT285                          ,WS-PAYMENT-AMOUNT-TOTAL                
ACT285                          ,WS-CALL-TYPE                           
ACT285                          ,WS-CPD68-REQUIRED                      
ACT285                          ,WS-PROGRAM-NAME                        
ACT285                          ,WS-CPD68-ACTN-FL                       
ACT285                          ,WS-CNCL-DNP-ACTN-FL                    
P00948                          ,WS-CNCL-DNP-EMAIL-REQ-FL               
ACT285                          ,WS-SO-UPDT-ACTN-FL                     
ACT285                          ,WS-CRED-ARNG-ACTN-FL                   
ACT285                          ,ws-APPL-PROGRAM-ID                     
P00420                          ,ABEND-FILE                             
C35842     .                                                            
C35842 9800-EXIT.                                                       
C35842     EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      *---------------------------------------------------------------* 43620000
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!    * 43630000
      *---------------------------------------------------------------* 43640000
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF                                                       
                                                                        
           
MSQ016        GOBACK                                                     
           .                                                            
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     43860000
                INCLUDE CPD00012                                        43870000
           END-EXEC.                                                    43880000
                                                                        
           EXEC SQL                                                     43900000
             INCLUDE CPD00003                                           43910000
           END-EXEC.                                                    43920000
                                                                        
           EXEC SQL                                                     43980000
             INCLUDE CPD0006A                                           43990000
           END-EXEC.                                                    44000000
                                                                        
           EXEC SQL                                                     44020000
              INCLUDE CPD00008                                          44030000
           END-EXEC.                                                    44040000
                                                                        
           COPY CPD00010.                                               44060000
                                                                        
           EXEC SQL                                                     44080000
              INCLUDE CPD0010S                                          44090000
           END-EXEC.                                                    44100000
                                                                        
           EXEC SQL                                                     44120000
              INCLUDE CPD00073                                          44130000
           END-EXEC.                                                    44140000
                                                                        
           EXEC SQL                                                     44160000
              INCLUDE CPD0023C                                          44170000
           END-EXEC.                                                    44180000
                                                                        
           EXEC SQL                                                     44200000
              INCLUDE CPDSP300                                          44210000
           END-EXEC.                                                    44220000
                                                                        
           EXEC SQL                                                     44240000
              INCLUDE CPD00075                                          44250000
           END-EXEC.                                                    44260000
                                                                        
           EXEC SQL                                                     44280000
              INCLUDE CPD00307                                          44290000
           END-EXEC.                                                    44300000
                                                                        
           EXEC SQL                                                     44320000
              INCLUDE CPD0315B                                          44330000
           END-EXEC.                                                    44340000
                                                                        
           EXEC SQL                                                     44360000
              INCLUDE CPD00312                                          44370000
           END-EXEC.                                                    44380000
                                                                        
